/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

package com.sun.ejb.base.sfsb;

import com.sun.ejb.spi.sfsb.SFSBUUIDUtil;
import com.sun.enterprise.util.Utility;

/**
 * A utility class that generates stateful session keys using two longs
 * The session id generated by this class is guarenteed to be unique as 
 * long as the system clock is never reset to a previous value
 * 
 * The hashCode of the SessionKey generated by SimpleKeyGenerator 
 * also allows uniform distribution of keys when hashed in a HashMap
 *
 * @author  Mahesh Kannan
 */
public class SimpleKeyGenerator
    implements SFSBUUIDUtil
{
   
    private int idCounter;
    private long time;
    private long prefix;

    public SimpleKeyGenerator() {
        //Inital isCounter value
        this.idCounter = 0;

        //Set the default time value
        this.time = System.currentTimeMillis();

        //Default value for prefix
        this.prefix = 0;
    }

    public void setPrefix(int val) {
        this.prefix = val;
    }

    /**
     * Create and return the sessionKey.
     * @return the sessionKey object
     */
    public Object createSessionKey() {
        int id = 0;
        synchronized (this) {
            id = ++idCounter;
            if (id < 0) {
                //idCounter wrapped around!!
                id = idCounter = 0;
                time = System.currentTimeMillis();
            }
        }

        return new SimpleSessionKey(time, prefix + id);
    }
    
    /**
     * Called from the Container before publishing an IOR. 
     * The method must convert the sessionKey into a byte[]
     * @return A byte[] representation of the key. The byte[] 
     * could be created using serialization.
     */
    public byte[] keyToByteArray(Object sessionKey) {
        SimpleSessionKey key = (SimpleSessionKey) sessionKey;
        byte[] array = new byte[16];

        Utility.longToBytes(key.time, array, 0);
        Utility.longToBytes(key.id, array, 8);

        return array;
    }
    
     /**
      * Return the sessionKey that represents the sessionKey. 
      * This has to be super efficient as the container calls this 
      * method on every invocation. Two objects obtained from identical 
      * byte[] must satisfy both o1.equals(o2) and 
      * o1.hashCode() == o2.hashCode()
      * @return the sessionKey object
      */
    public Object byteArrayToKey(byte[] array, int startIndex, int len) {
        long myTime = Utility.bytesToLong(array, startIndex);
        long myId = Utility.bytesToLong(array, startIndex+8);

        return new SimpleSessionKey(myTime, myId);
    }

}

class SimpleSessionKey
    implements java.io.Serializable
{

    long time;
    long id;

    public SimpleSessionKey(long time, long id) {
        this.time = time;
        this.id = id;
    }
    
    public int hashCode() {
        return (int) id;
    }

    public boolean equals(Object otherObj) {
        if (otherObj instanceof SimpleSessionKey) {
            SimpleSessionKey other = (SimpleSessionKey) otherObj;
            return ((id == other.id) && (time == other.time));
        }

        return false;
    }

    public String toString() {
        return "" + time + "-" + id;
    }

}
    
