/* contacts-address-map.c generated by valac 0.30.0.16-6dbb1, the Vala compiler
 * generated from contacts-address-map.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: t; c-basic-offset: 2; tab-width: 8 -*- */
/*
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author: Jonas Danielsson <jonas@threetimestwo.org>
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gee.h>
#include <folks/folks.h>
#include <geocode-glib/geocode-glib.h>
#include <champlain/champlain.h>
#include <clutter-gtk/clutter-gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gdesktopappinfo.h>
#include <clutter/clutter.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <cogl/cogl.h>
#include <float.h>
#include <math.h>


#define CONTACTS_TYPE_ADDRESS_MAP (contacts_address_map_get_type ())
#define CONTACTS_ADDRESS_MAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_ADDRESS_MAP, ContactsAddressMap))
#define CONTACTS_ADDRESS_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_ADDRESS_MAP, ContactsAddressMapClass))
#define CONTACTS_IS_ADDRESS_MAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_ADDRESS_MAP))
#define CONTACTS_IS_ADDRESS_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_ADDRESS_MAP))
#define CONTACTS_ADDRESS_MAP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_ADDRESS_MAP, ContactsAddressMapClass))

typedef struct _ContactsAddressMap ContactsAddressMap;
typedef struct _ContactsAddressMapClass ContactsAddressMapClass;
typedef struct _ContactsAddressMapPrivate ContactsAddressMapPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

#define CONTACTS_TYPE_CONTACT (contacts_contact_get_type ())
#define CONTACTS_CONTACT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_CONTACT, ContactsContact))
#define CONTACTS_CONTACT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_CONTACT, ContactsContactClass))
#define CONTACTS_IS_CONTACT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_CONTACT))
#define CONTACTS_IS_CONTACT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_CONTACT))
#define CONTACTS_CONTACT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_CONTACT, ContactsContactClass))

typedef struct _ContactsContact ContactsContact;
typedef struct _ContactsContactClass ContactsContactClass;
typedef struct _Block9Data Block9Data;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ContactsContactPrivate ContactsContactPrivate;

#define CONTACTS_TYPE_STORE (contacts_store_get_type ())
#define CONTACTS_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_STORE, ContactsStore))
#define CONTACTS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_STORE, ContactsStoreClass))
#define CONTACTS_IS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_STORE))
#define CONTACTS_IS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_STORE))
#define CONTACTS_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_STORE, ContactsStoreClass))

typedef struct _ContactsStore ContactsStore;
typedef struct _ContactsStoreClass ContactsStoreClass;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _Block10Data Block10Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block11Data Block11Data;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define __vala_ChamplainBoundingBox_free0(var) ((var == NULL) ? NULL : (var = (_vala_ChamplainBoundingBox_free (var), NULL)))

struct _ContactsAddressMap {
	GtkFrame parent_instance;
	ContactsAddressMapPrivate * priv;
};

struct _ContactsAddressMapClass {
	GtkFrameClass parent_class;
};

struct _ContactsAddressMapPrivate {
	GtkStack* map_stack;
	GtkGrid* map_grid;
	GtkImage* map_icon;
	GeeSet* addresses;
	GList* found_places;
	ChamplainView* map_view;
	ChamplainMarkerLayer* marker_layer;
	GMutex mutex;
	gulong alloc_id;
};

struct _Block9Data {
	int _ref_count_;
	ContactsAddressMap* self;
	GtkClutterEmbed* map;
	gchar* maps_id;
	ContactsContact* c;
};

struct _ContactsContact {
	GObject parent_instance;
	ContactsContactPrivate * priv;
	ContactsStore* store;
	gboolean is_main;
	FolksPresenceType presence_type;
	gchar* presence_message;
	gboolean is_phone;
	FolksIndividual* individual;
	FolksPersona* fake_persona;
};

struct _ContactsContactClass {
	GObjectClass parent_class;
};

struct _Block10Data {
	int _ref_count_;
	ContactsAddressMap* self;
	gint geocodes;
};

struct _Block11Data {
	int _ref_count_;
	ContactsAddressMap* self;
	GList* markers;
};


static gpointer contacts_address_map_parent_class = NULL;

GType contacts_address_map_get_type (void) G_GNUC_CONST;
#define CONTACTS_ADDRESS_MAP_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CONTACTS_TYPE_ADDRESS_MAP, ContactsAddressMapPrivate))
enum  {
	CONTACTS_ADDRESS_MAP_DUMMY_PROPERTY
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
GType contacts_contact_get_type (void) G_GNUC_CONST;
ContactsAddressMap* contacts_address_map_new (ContactsContact* c, GeeSet* postal_addresses);
ContactsAddressMap* contacts_address_map_construct (GType object_type, ContactsContact* c, GeeSet* postal_addresses);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
static gboolean __lambda34_ (ContactsAddressMap* self);
static gboolean ___lambda34__clutter_actor_captured_event (ClutterActor* _sender, ClutterEvent* event, gpointer self);
static void ___lambda35_ (Block9Data* _data9_);
static void ____lambda35__gtk_widget_realize (GtkWidget* _sender, gpointer self);
static gboolean ___lambda36_ (Block9Data* _data9_);
void contacts_activate_action (const gchar* app_id, const gchar* action, GVariant* parameter, guint32 timestamp);
GType contacts_store_get_type (void) G_GNUC_CONST;
static gboolean ____lambda36__gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
void contacts_address_map_load (ContactsAddressMap* self);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (void * _userdata_);
void contacts_contact_geocode_address (FolksPostalAddress* addr, GAsyncReadyCallback _callback_, gpointer _user_data_);
GeocodePlace* contacts_contact_geocode_address_finish (GAsyncResult* _res_);
static void ____lambda37_ (Block10Data* _data10_, GObject* object, GAsyncResult* res);
static void contacts_address_map_show_map (ContactsAddressMap* self);
static void _____lambda37__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void contacts_address_map_show_pin (ContactsAddressMap* self);
static void contacts_address_map_show_labels (ContactsAddressMap* self);
static void contacts_address_map_on_allocation_changed (ContactsAddressMap* self);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (void * _userdata_);
static gboolean __lambda38_ (Block11Data* _data11_);
static void _vala_ChamplainBoundingBox_free (ChamplainBoundingBox* self);
static gboolean ___lambda38__gsource_func (gpointer self);
static void _contacts_address_map_on_allocation_changed_clutter_actor_allocation_changed (ClutterActor* _sender, ClutterActorBox* box, ClutterAllocationFlags flags, gpointer self);
static void contacts_address_map_finalize (GObject* obj);
static void _vala_clear_GMutex (GMutex * mutex);
static void _vala_clear_GRecMutex (GRecMutex * mutex);
static void _vala_clear_GRWLock (GRWLock * mutex);
static void _vala_clear_GCond (GCond * mutex);


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static Block9Data* block9_data_ref (Block9Data* _data9_) {
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}


static void block9_data_unref (void * _userdata_) {
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		ContactsAddressMap* self;
		self = _data9_->self;
		_g_free0 (_data9_->maps_id);
		_g_object_unref0 (_data9_->map);
		_g_object_unref0 (_data9_->c);
		_g_object_unref0 (self);
		g_slice_free (Block9Data, _data9_);
	}
}


static gboolean __lambda34_ (ContactsAddressMap* self) {
	gboolean result = FALSE;
	result = TRUE;
	return result;
}


static gboolean ___lambda34__clutter_actor_captured_event (ClutterActor* _sender, ClutterEvent* event, gpointer self) {
	gboolean result;
	result = __lambda34_ ((ContactsAddressMap*) self);
	return result;
}


static void ___lambda35_ (Block9Data* _data9_) {
	ContactsAddressMap* self;
	GtkClutterEmbed* _tmp0_ = NULL;
	GdkWindow* _tmp1_ = NULL;
	GdkCursor* _tmp2_ = NULL;
	GdkCursor* _tmp3_ = NULL;
	self = _data9_->self;
	_tmp0_ = _data9_->map;
	_tmp1_ = gtk_widget_get_window ((GtkWidget*) _tmp0_);
	_tmp2_ = gdk_cursor_new (GDK_HAND1);
	_tmp3_ = _tmp2_;
	gdk_window_set_cursor (_tmp1_, _tmp3_);
	_g_object_unref0 (_tmp3_);
}


static void ____lambda35__gtk_widget_realize (GtkWidget* _sender, gpointer self) {
	___lambda35_ (self);
}


static gboolean ___lambda36_ (Block9Data* _data9_) {
	ContactsAddressMap* self;
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	ContactsContact* _tmp1_ = NULL;
	FolksIndividual* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GVariant* _tmp5_ = NULL;
	GVariant* _tmp6_ = NULL;
	guint32 _tmp7_ = 0U;
	self = _data9_->self;
	_tmp0_ = _data9_->maps_id;
	_tmp1_ = _data9_->c;
	_tmp2_ = _tmp1_->individual;
	_tmp3_ = folks_individual_get_id (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_variant_new ("s", _tmp4_, NULL);
	g_variant_ref_sink (_tmp5_);
	_tmp6_ = _tmp5_;
	_tmp7_ = gtk_get_current_event_time ();
	contacts_activate_action (_tmp0_, "show-contact", _tmp6_, _tmp7_);
	_g_variant_unref0 (_tmp6_);
	result = TRUE;
	return result;
}


static gboolean ____lambda36__gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = ___lambda36_ (self);
	return result;
}


ContactsAddressMap* contacts_address_map_construct (GType object_type, ContactsContact* c, GeeSet* postal_addresses) {
	ContactsAddressMap * self = NULL;
	Block9Data* _data9_;
	ContactsContact* _tmp0_ = NULL;
	ContactsContact* _tmp1_ = NULL;
	GtkClutterEmbed* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	GDesktopAppInfo* maps_info = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	GDesktopAppInfo* _tmp7_ = NULL;
	GDesktopAppInfo* _tmp8_ = NULL;
	ChamplainMapSourceFactory* map_factory = NULL;
	ChamplainMapSourceFactory* _tmp9_ = NULL;
	GtkGrid* _tmp10_ = NULL;
	GtkClutterEmbed* _tmp11_ = NULL;
	ChamplainView* _tmp12_ = NULL;
	ChamplainView* _tmp13_ = NULL;
	ChamplainMapSourceFactory* _tmp14_ = NULL;
	ChamplainMapSource* _tmp15_ = NULL;
	ChamplainView* _tmp16_ = NULL;
	ChamplainView* _tmp17_ = NULL;
	guint _tmp18_ = 0U;
	guint _tmp19_ = 0U;
	GtkClutterEmbed* _tmp20_ = NULL;
	ClutterActor* _tmp21_ = NULL;
	ChamplainView* _tmp22_ = NULL;
	ChamplainMarkerLayer* _tmp23_ = NULL;
	ChamplainView* _tmp24_ = NULL;
	ChamplainMarkerLayer* _tmp25_ = NULL;
	GtkClutterEmbed* _tmp26_ = NULL;
	ClutterActor* _tmp27_ = NULL;
	GDesktopAppInfo* _tmp28_ = NULL;
	GeeSet* _tmp33_ = NULL;
	GeeSet* _tmp34_ = NULL;
	g_return_val_if_fail (c != NULL, NULL);
	g_return_val_if_fail (postal_addresses != NULL, NULL);
	_data9_ = g_slice_new0 (Block9Data);
	_data9_->_ref_count_ = 1;
	_tmp0_ = c;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data9_->c);
	_data9_->c = _tmp1_;
	self = (ContactsAddressMap*) g_object_new (object_type, NULL);
	_data9_->self = g_object_ref (self);
	_tmp2_ = (GtkClutterEmbed*) gtk_clutter_embed_new ();
	g_object_ref_sink (_tmp2_);
	_data9_->map = _tmp2_;
	_tmp3_ = g_strdup ("org.gnome.Maps");
	_data9_->maps_id = _tmp3_;
	_tmp4_ = _data9_->maps_id;
	_tmp5_ = g_strconcat (_tmp4_, ".desktop", NULL);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_desktop_app_info_new (_tmp6_);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp6_);
	maps_info = _tmp8_;
	_tmp9_ = champlain_map_source_factory_dup_default ();
	map_factory = _tmp9_;
	_tmp10_ = self->priv->map_grid;
	_tmp11_ = _data9_->map;
	gtk_container_add ((GtkContainer*) _tmp10_, (GtkWidget*) _tmp11_);
	_tmp12_ = (ChamplainView*) champlain_view_new ();
	g_object_ref_sink (_tmp12_);
	_g_object_unref0 (self->priv->map_view);
	self->priv->map_view = _tmp12_;
	_tmp13_ = self->priv->map_view;
	_tmp14_ = map_factory;
	_tmp15_ = champlain_map_source_factory_create (_tmp14_, CHAMPLAIN_MAP_SOURCE_OSM_MAPQUEST);
	champlain_view_set_map_source (_tmp13_, _tmp15_);
	_tmp16_ = self->priv->map_view;
	_tmp17_ = self->priv->map_view;
	_tmp18_ = champlain_view_get_max_zoom_level (_tmp17_);
	_tmp19_ = _tmp18_;
	champlain_view_set_zoom_level (_tmp16_, _tmp19_ - 2);
	_tmp20_ = _data9_->map;
	_tmp21_ = gtk_clutter_embed_get_stage (_tmp20_);
	_tmp22_ = self->priv->map_view;
	clutter_actor_add_child (_tmp21_, (ClutterActor*) _tmp22_);
	_tmp23_ = champlain_marker_layer_new ();
	g_object_ref_sink (_tmp23_);
	_g_object_unref0 (self->priv->marker_layer);
	self->priv->marker_layer = _tmp23_;
	_tmp24_ = self->priv->map_view;
	_tmp25_ = self->priv->marker_layer;
	champlain_view_add_layer (_tmp24_, (ChamplainLayer*) _tmp25_);
	_tmp26_ = _data9_->map;
	_tmp27_ = gtk_clutter_embed_get_stage (_tmp26_);
	g_signal_connect_object (_tmp27_, "captured-event", (GCallback) ___lambda34__clutter_actor_captured_event, self, 0);
	_tmp28_ = maps_info;
	if (_tmp28_ != NULL) {
		GtkClutterEmbed* _tmp29_ = NULL;
		GtkClutterEmbed* _tmp30_ = NULL;
		_tmp29_ = _data9_->map;
		g_signal_connect_data ((GtkWidget*) _tmp29_, "realize", (GCallback) ____lambda35__gtk_widget_realize, block9_data_ref (_data9_), (GClosureNotify) block9_data_unref, 0);
		_tmp30_ = _data9_->map;
		g_signal_connect_data ((GtkWidget*) _tmp30_, "button-press-event", (GCallback) ____lambda36__gtk_widget_button_press_event, block9_data_ref (_data9_), (GClosureNotify) block9_data_unref, 0);
	} else {
		GtkClutterEmbed* _tmp31_ = NULL;
		const gchar* _tmp32_ = NULL;
		_tmp31_ = _data9_->map;
		_tmp32_ = _ ("Install GNOME Maps to open location.");
		gtk_widget_set_tooltip_text ((GtkWidget*) _tmp31_, _tmp32_);
	}
	_tmp33_ = postal_addresses;
	_tmp34_ = _g_object_ref0 (_tmp33_);
	_g_object_unref0 (self->priv->addresses);
	self->priv->addresses = _tmp34_;
	__g_list_free__g_object_unref0_0 (self->priv->found_places);
	self->priv->found_places = NULL;
	_vala_clear_GMutex (&self->priv->mutex);
	g_mutex_init (&self->priv->mutex);
	_g_object_unref0 (map_factory);
	_g_object_unref0 (maps_info);
	block9_data_unref (_data9_);
	_data9_ = NULL;
	return self;
}


ContactsAddressMap* contacts_address_map_new (ContactsContact* c, GeeSet* postal_addresses) {
	return contacts_address_map_construct (CONTACTS_TYPE_ADDRESS_MAP, c, postal_addresses);
}


static Block10Data* block10_data_ref (Block10Data* _data10_) {
	g_atomic_int_inc (&_data10_->_ref_count_);
	return _data10_;
}


static void block10_data_unref (void * _userdata_) {
	Block10Data* _data10_;
	_data10_ = (Block10Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
		ContactsAddressMap* self;
		self = _data10_->self;
		_g_object_unref0 (self);
		g_slice_free (Block10Data, _data10_);
	}
}


static void ____lambda37_ (Block10Data* _data10_, GObject* object, GAsyncResult* res) {
	ContactsAddressMap* self;
	GeocodePlace* place = NULL;
	GAsyncResult* _tmp0_ = NULL;
	GeocodePlace* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	GeocodePlace* _tmp3_ = NULL;
	gboolean _tmp6_ = FALSE;
	gint _tmp7_ = 0;
	GeeSet* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	self = _data10_->self;
	g_return_if_fail (res != NULL);
	g_mutex_lock (&self->priv->mutex);
	_tmp0_ = res;
	_tmp1_ = contacts_contact_geocode_address_finish (_tmp0_);
	place = _tmp1_;
	_tmp2_ = _data10_->geocodes;
	_data10_->geocodes = _tmp2_ + 1;
	_tmp3_ = place;
	if (_tmp3_ != NULL) {
		GeocodePlace* _tmp4_ = NULL;
		GeocodePlace* _tmp5_ = NULL;
		_tmp4_ = place;
		_tmp5_ = _g_object_ref0 (_tmp4_);
		self->priv->found_places = g_list_prepend (self->priv->found_places, _tmp5_);
	}
	_tmp7_ = _data10_->geocodes;
	_tmp8_ = self->priv->addresses;
	_tmp9_ = gee_collection_get_size ((GeeCollection*) _tmp8_);
	_tmp10_ = _tmp9_;
	if (_tmp7_ == _tmp10_) {
		GList* _tmp11_ = NULL;
		guint _tmp12_ = 0U;
		_tmp11_ = self->priv->found_places;
		_tmp12_ = g_list_length (_tmp11_);
		_tmp6_ = _tmp12_ > ((guint) 0);
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		contacts_address_map_show_map (self);
	}
	g_mutex_unlock (&self->priv->mutex);
	_g_object_unref0 (place);
}


static void _____lambda37__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	____lambda37_ (self, source_object, res);
	block10_data_unref (self);
}


void contacts_address_map_load (ContactsAddressMap* self) {
	Block10Data* _data10_;
	GtkStack* _tmp0_ = NULL;
	GtkImage* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_data10_ = g_slice_new0 (Block10Data);
	_data10_->_ref_count_ = 1;
	_data10_->self = g_object_ref (self);
	_tmp0_ = self->priv->map_stack;
	_tmp1_ = self->priv->map_icon;
	gtk_stack_set_visible_child (_tmp0_, (GtkWidget*) _tmp1_);
	_data10_->geocodes = 0;
	{
		GeeIterator* _addr_it = NULL;
		GeeSet* _tmp2_ = NULL;
		GeeIterator* _tmp3_ = NULL;
		_tmp2_ = self->priv->addresses;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
		_addr_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_ = NULL;
			gboolean _tmp5_ = FALSE;
			FolksPostalAddressFieldDetails* addr = NULL;
			GeeIterator* _tmp6_ = NULL;
			gpointer _tmp7_ = NULL;
			FolksPostalAddressFieldDetails* _tmp8_ = NULL;
			gconstpointer _tmp9_ = NULL;
			FolksPostalAddress* _tmp10_ = NULL;
			_tmp4_ = _addr_it;
			_tmp5_ = gee_iterator_next (_tmp4_);
			if (!_tmp5_) {
				break;
			}
			_tmp6_ = _addr_it;
			_tmp7_ = gee_iterator_get (_tmp6_);
			addr = (FolksPostalAddressFieldDetails*) _tmp7_;
			_tmp8_ = addr;
			_tmp9_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp8_);
			_tmp10_ = _tmp9_;
			contacts_contact_geocode_address ((FolksPostalAddress*) _tmp10_, _____lambda37__gasync_ready_callback, block10_data_ref (_data10_));
			_g_object_unref0 (addr);
		}
		_g_object_unref0 (_addr_it);
	}
	block10_data_unref (_data10_);
	_data10_ = NULL;
}


static void contacts_address_map_show_pin (ContactsAddressMap* self) {
	GtkIconTheme* theme = NULL;
	GtkIconTheme* _tmp0_ = NULL;
	GtkIconTheme* _tmp1_ = NULL;
	ClutterActor* actor = NULL;
	ClutterActor* _tmp2_ = NULL;
	ChamplainMarker* marker = NULL;
	ChamplainMarker* _tmp22_ = NULL;
	GeocodePlace* place = NULL;
	GList* _tmp23_ = NULL;
	gconstpointer _tmp24_ = NULL;
	GeocodePlace* _tmp25_ = NULL;
	GeocodeLocation* _tmp26_ = NULL;
	GeocodeLocation* _tmp27_ = NULL;
	gdouble _tmp28_ = 0.0;
	gdouble _tmp29_ = 0.0;
	GeocodeLocation* _tmp30_ = NULL;
	GeocodeLocation* _tmp31_ = NULL;
	gdouble _tmp32_ = 0.0;
	gdouble _tmp33_ = 0.0;
	ClutterActor* _tmp34_ = NULL;
	ChamplainMarkerLayer* _tmp35_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_icon_theme_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	theme = _tmp1_;
	_tmp2_ = clutter_actor_new ();
	g_object_ref_sink (_tmp2_);
	actor = _tmp2_;
	{
		GdkPixbuf* pixbuf = NULL;
		GtkIconTheme* _tmp3_ = NULL;
		GdkPixbuf* _tmp4_ = NULL;
		ClutterImage* image = NULL;
		ClutterImage* _tmp5_ = NULL;
		ClutterImage* _tmp6_ = NULL;
		GdkPixbuf* _tmp7_ = NULL;
		guint8* _tmp8_ = NULL;
		GdkPixbuf* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		GdkPixbuf* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		GdkPixbuf* _tmp13_ = NULL;
		gint _tmp14_ = 0;
		ClutterActor* _tmp15_ = NULL;
		ClutterImage* _tmp16_ = NULL;
		ClutterActor* _tmp17_ = NULL;
		GdkPixbuf* _tmp18_ = NULL;
		gint _tmp19_ = 0;
		GdkPixbuf* _tmp20_ = NULL;
		gint _tmp21_ = 0;
		_tmp3_ = theme;
		_tmp4_ = gtk_icon_theme_load_icon (_tmp3_, "mark-location", 32, 0, &_inner_error_);
		pixbuf = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch2_g_error;
		}
		_tmp5_ = clutter_image_new ();
		image = _tmp5_;
		_tmp6_ = image;
		_tmp7_ = pixbuf;
		_tmp8_ = gdk_pixbuf_get_pixels (_tmp7_);
		_tmp9_ = pixbuf;
		_tmp10_ = gdk_pixbuf_get_width (_tmp9_);
		_tmp11_ = pixbuf;
		_tmp12_ = gdk_pixbuf_get_height (_tmp11_);
		_tmp13_ = pixbuf;
		_tmp14_ = gdk_pixbuf_get_rowstride (_tmp13_);
		clutter_image_set_data (_tmp6_, _tmp8_, COGL_PIXEL_FORMAT_RGBA_8888, (guint) _tmp10_, (guint) _tmp12_, (guint) _tmp14_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (image);
			_g_object_unref0 (pixbuf);
			goto __catch2_g_error;
		}
		_tmp15_ = actor;
		_tmp16_ = image;
		clutter_actor_set_content (_tmp15_, (ClutterContent*) _tmp16_);
		_tmp17_ = actor;
		_tmp18_ = pixbuf;
		_tmp19_ = gdk_pixbuf_get_width (_tmp18_);
		_tmp20_ = pixbuf;
		_tmp21_ = gdk_pixbuf_get_height (_tmp20_);
		clutter_actor_set_size (_tmp17_, (gfloat) _tmp19_, (gfloat) _tmp21_);
		_g_object_unref0 (image);
		_g_object_unref0 (pixbuf);
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (actor);
		_g_object_unref0 (theme);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp22_ = (ChamplainMarker*) champlain_marker_new ();
	g_object_ref_sink (_tmp22_);
	marker = _tmp22_;
	_tmp23_ = self->priv->found_places;
	_tmp24_ = g_list_nth_data (_tmp23_, (guint) 0);
	_tmp25_ = _g_object_ref0 ((GeocodePlace*) _tmp24_);
	place = _tmp25_;
	_tmp26_ = geocode_place_get_location (place);
	_tmp27_ = _tmp26_;
	g_object_get (_tmp27_, "latitude", &_tmp28_, NULL);
	_tmp29_ = _tmp28_;
	g_object_set ((ChamplainLocation*) marker, "latitude", _tmp29_, NULL);
	_tmp30_ = geocode_place_get_location (place);
	_tmp31_ = _tmp30_;
	g_object_get (_tmp31_, "longitude", &_tmp32_, NULL);
	_tmp33_ = _tmp32_;
	g_object_set ((ChamplainLocation*) marker, "longitude", _tmp33_, NULL);
	_tmp34_ = actor;
	clutter_actor_add_child ((ClutterActor*) marker, _tmp34_);
	_tmp35_ = self->priv->marker_layer;
	champlain_marker_layer_add_marker (_tmp35_, marker);
	_g_object_unref0 (place);
	_g_object_unref0 (marker);
	_g_object_unref0 (actor);
	_g_object_unref0 (theme);
}


static void contacts_address_map_show_labels (ContactsAddressMap* self) {
	GList* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->found_places;
	{
		GList* place_collection = NULL;
		GList* place_it = NULL;
		place_collection = _tmp0_;
		for (place_it = place_collection; place_it != NULL; place_it = place_it->next) {
			GeocodePlace* _tmp1_ = NULL;
			GeocodePlace* place = NULL;
			_tmp1_ = _g_object_ref0 ((GeocodePlace*) place_it->data);
			place = _tmp1_;
			{
				ChamplainLabel* label = NULL;
				ChamplainLabel* _tmp2_ = NULL;
				GeocodePlace* _tmp3_ = NULL;
				const gchar* _tmp4_ = NULL;
				const gchar* _tmp5_ = NULL;
				ChamplainLabel* _tmp14_ = NULL;
				GeocodePlace* _tmp15_ = NULL;
				GeocodeLocation* _tmp16_ = NULL;
				GeocodeLocation* _tmp17_ = NULL;
				gdouble _tmp18_ = 0.0;
				gdouble _tmp19_ = 0.0;
				ChamplainLabel* _tmp20_ = NULL;
				GeocodePlace* _tmp21_ = NULL;
				GeocodeLocation* _tmp22_ = NULL;
				GeocodeLocation* _tmp23_ = NULL;
				gdouble _tmp24_ = 0.0;
				gdouble _tmp25_ = 0.0;
				ChamplainMarkerLayer* _tmp26_ = NULL;
				ChamplainLabel* _tmp27_ = NULL;
				_tmp2_ = (ChamplainLabel*) champlain_label_new ();
				g_object_ref_sink (_tmp2_);
				label = _tmp2_;
				_tmp3_ = place;
				_tmp4_ = geocode_place_get_street_address (_tmp3_);
				_tmp5_ = _tmp4_;
				if (_tmp5_ != NULL) {
					ChamplainLabel* _tmp6_ = NULL;
					GeocodePlace* _tmp7_ = NULL;
					const gchar* _tmp8_ = NULL;
					const gchar* _tmp9_ = NULL;
					_tmp6_ = label;
					_tmp7_ = place;
					_tmp8_ = geocode_place_get_street_address (_tmp7_);
					_tmp9_ = _tmp8_;
					champlain_label_set_text (_tmp6_, _tmp9_);
				} else {
					ChamplainLabel* _tmp10_ = NULL;
					GeocodePlace* _tmp11_ = NULL;
					const gchar* _tmp12_ = NULL;
					const gchar* _tmp13_ = NULL;
					_tmp10_ = label;
					_tmp11_ = place;
					_tmp12_ = geocode_place_get_street (_tmp11_);
					_tmp13_ = _tmp12_;
					champlain_label_set_text (_tmp10_, _tmp13_);
				}
				_tmp14_ = label;
				_tmp15_ = place;
				_tmp16_ = geocode_place_get_location (_tmp15_);
				_tmp17_ = _tmp16_;
				g_object_get (_tmp17_, "latitude", &_tmp18_, NULL);
				_tmp19_ = _tmp18_;
				g_object_set ((ChamplainLocation*) _tmp14_, "latitude", _tmp19_, NULL);
				_tmp20_ = label;
				_tmp21_ = place;
				_tmp22_ = geocode_place_get_location (_tmp21_);
				_tmp23_ = _tmp22_;
				g_object_get (_tmp23_, "longitude", &_tmp24_, NULL);
				_tmp25_ = _tmp24_;
				g_object_set ((ChamplainLocation*) _tmp20_, "longitude", _tmp25_, NULL);
				_tmp26_ = self->priv->marker_layer;
				_tmp27_ = label;
				champlain_marker_layer_add_marker (_tmp26_, (ChamplainMarker*) _tmp27_);
				_g_object_unref0 (label);
				_g_object_unref0 (place);
			}
		}
	}
}


static Block11Data* block11_data_ref (Block11Data* _data11_) {
	g_atomic_int_inc (&_data11_->_ref_count_);
	return _data11_;
}


static void block11_data_unref (void * _userdata_) {
	Block11Data* _data11_;
	_data11_ = (Block11Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
		ContactsAddressMap* self;
		self = _data11_->self;
		_g_list_free0 (_data11_->markers);
		_g_object_unref0 (self);
		g_slice_free (Block11Data, _data11_);
	}
}


static void _vala_ChamplainBoundingBox_free (ChamplainBoundingBox* self) {
	g_boxed_free (champlain_bounding_box_get_type (), self);
}


static gboolean __lambda38_ (Block11Data* _data11_) {
	ContactsAddressMap* self;
	gboolean result = FALSE;
	GList* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	self = _data11_->self;
	_tmp0_ = self->priv->found_places;
	_tmp1_ = g_list_length (_tmp0_);
	if (_tmp1_ == ((guint) 1)) {
		GeocodePlace* place = NULL;
		GList* _tmp2_ = NULL;
		gconstpointer _tmp3_ = NULL;
		GeocodePlace* _tmp4_ = NULL;
		ChamplainView* _tmp5_ = NULL;
		GeocodePlace* _tmp6_ = NULL;
		GeocodeLocation* _tmp7_ = NULL;
		GeocodeLocation* _tmp8_ = NULL;
		gdouble _tmp9_ = 0.0;
		gdouble _tmp10_ = 0.0;
		GeocodePlace* _tmp11_ = NULL;
		GeocodeLocation* _tmp12_ = NULL;
		GeocodeLocation* _tmp13_ = NULL;
		gdouble _tmp14_ = 0.0;
		gdouble _tmp15_ = 0.0;
		_tmp2_ = self->priv->found_places;
		_tmp3_ = g_list_nth_data (_tmp2_, (guint) 0);
		_tmp4_ = _g_object_ref0 ((GeocodePlace*) _tmp3_);
		place = _tmp4_;
		_tmp5_ = self->priv->map_view;
		_tmp6_ = place;
		_tmp7_ = geocode_place_get_location (_tmp6_);
		_tmp8_ = _tmp7_;
		g_object_get (_tmp8_, "latitude", &_tmp9_, NULL);
		_tmp10_ = _tmp9_;
		_tmp11_ = place;
		_tmp12_ = geocode_place_get_location (_tmp11_);
		_tmp13_ = _tmp12_;
		g_object_get (_tmp13_, "longitude", &_tmp14_, NULL);
		_tmp15_ = _tmp14_;
		champlain_view_center_on (_tmp5_, _tmp10_, _tmp15_);
		_g_object_unref0 (place);
	} else {
		ChamplainBoundingBox* bbox = NULL;
		ChamplainBoundingBox* _tmp16_ = NULL;
		GList* _tmp17_ = NULL;
		ChamplainView* _tmp50_ = NULL;
		ChamplainBoundingBox* _tmp51_ = NULL;
		_tmp16_ = champlain_bounding_box_new ();
		bbox = _tmp16_;
		_tmp17_ = _data11_->markers;
		{
			GList* marker_collection = NULL;
			GList* marker_it = NULL;
			marker_collection = _tmp17_;
			for (marker_it = marker_collection; marker_it != NULL; marker_it = marker_it->next) {
				ClutterActor* marker = NULL;
				marker = (ClutterActor*) marker_it->data;
				{
					gdouble x = 0.0;
					ChamplainView* _tmp18_ = NULL;
					ClutterActor* _tmp19_ = NULL;
					gdouble _tmp20_ = 0.0;
					gdouble _tmp21_ = 0.0;
					gdouble _tmp22_ = 0.0;
					gdouble y = 0.0;
					ChamplainView* _tmp23_ = NULL;
					ClutterActor* _tmp24_ = NULL;
					gdouble _tmp25_ = 0.0;
					gdouble _tmp26_ = 0.0;
					gdouble _tmp27_ = 0.0;
					gdouble lat = 0.0;
					ChamplainView* _tmp28_ = NULL;
					gdouble _tmp29_ = 0.0;
					ClutterActor* _tmp30_ = NULL;
					gfloat _tmp31_ = 0.0F;
					gfloat _tmp32_ = 0.0F;
					gdouble _tmp33_ = 0.0;
					gdouble lon = 0.0;
					ChamplainView* _tmp34_ = NULL;
					gdouble _tmp35_ = 0.0;
					ClutterActor* _tmp36_ = NULL;
					gfloat _tmp37_ = 0.0F;
					gfloat _tmp38_ = 0.0F;
					gdouble _tmp39_ = 0.0;
					ChamplainBoundingBox* _tmp40_ = NULL;
					gdouble _tmp41_ = 0.0;
					gdouble _tmp42_ = 0.0;
					ChamplainBoundingBox* _tmp43_ = NULL;
					ClutterActor* _tmp44_ = NULL;
					gdouble _tmp45_ = 0.0;
					gdouble _tmp46_ = 0.0;
					ClutterActor* _tmp47_ = NULL;
					gdouble _tmp48_ = 0.0;
					gdouble _tmp49_ = 0.0;
					_tmp18_ = self->priv->map_view;
					_tmp19_ = marker;
					g_object_get ((ChamplainLocation*) (G_TYPE_CHECK_INSTANCE_TYPE (_tmp19_, champlain_marker_get_type ()) ? ((ChamplainMarker*) _tmp19_) : NULL), "longitude", &_tmp20_, NULL);
					_tmp21_ = _tmp20_;
					_tmp22_ = champlain_view_longitude_to_x (_tmp18_, _tmp21_);
					x = _tmp22_;
					_tmp23_ = self->priv->map_view;
					_tmp24_ = marker;
					g_object_get ((ChamplainLocation*) (G_TYPE_CHECK_INSTANCE_TYPE (_tmp24_, champlain_marker_get_type ()) ? ((ChamplainMarker*) _tmp24_) : NULL), "latitude", &_tmp25_, NULL);
					_tmp26_ = _tmp25_;
					_tmp27_ = champlain_view_latitude_to_y (_tmp23_, _tmp26_);
					y = _tmp27_;
					_tmp28_ = self->priv->map_view;
					_tmp29_ = y;
					_tmp30_ = marker;
					_tmp31_ = clutter_actor_get_height (_tmp30_);
					_tmp32_ = _tmp31_;
					_tmp33_ = champlain_view_y_to_latitude (_tmp28_, _tmp29_ - (_tmp32_ * 256));
					lat = _tmp33_;
					_tmp34_ = self->priv->map_view;
					_tmp35_ = x;
					_tmp36_ = marker;
					_tmp37_ = clutter_actor_get_width (_tmp36_);
					_tmp38_ = _tmp37_;
					_tmp39_ = champlain_view_x_to_longitude (_tmp34_, _tmp35_ + (_tmp38_ * 256));
					lon = _tmp39_;
					_tmp40_ = bbox;
					_tmp41_ = lat;
					_tmp42_ = lon;
					champlain_bounding_box_extend (_tmp40_, _tmp41_, _tmp42_);
					_tmp43_ = bbox;
					_tmp44_ = marker;
					g_object_get ((ChamplainLocation*) (G_TYPE_CHECK_INSTANCE_TYPE (_tmp44_, champlain_marker_get_type ()) ? ((ChamplainMarker*) _tmp44_) : NULL), "latitude", &_tmp45_, NULL);
					_tmp46_ = _tmp45_;
					_tmp47_ = marker;
					g_object_get ((ChamplainLocation*) (G_TYPE_CHECK_INSTANCE_TYPE (_tmp47_, champlain_marker_get_type ()) ? ((ChamplainMarker*) _tmp47_) : NULL), "longitude", &_tmp48_, NULL);
					_tmp49_ = _tmp48_;
					champlain_bounding_box_extend (_tmp43_, _tmp46_, _tmp49_);
				}
			}
		}
		_tmp50_ = self->priv->map_view;
		_tmp51_ = bbox;
		champlain_view_ensure_visible (_tmp50_, _tmp51_, FALSE);
		__vala_ChamplainBoundingBox_free0 (bbox);
	}
	result = FALSE;
	return result;
}


static gboolean ___lambda38__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda38_ (self);
	return result;
}


static void contacts_address_map_on_allocation_changed (ContactsAddressMap* self) {
	Block11Data* _data11_;
	gulong _tmp0_ = 0UL;
	ChamplainMarkerLayer* _tmp1_ = NULL;
	GList* _tmp2_ = NULL;
	GList* _tmp3_ = NULL;
	gconstpointer _tmp4_ = NULL;
	ClutterActor* _tmp5_ = NULL;
	gfloat _tmp6_ = 0.0F;
	gfloat _tmp7_ = 0.0F;
	ChamplainMarkerLayer* _tmp8_ = NULL;
	gulong _tmp9_ = 0UL;
	g_return_if_fail (self != NULL);
	_data11_ = g_slice_new0 (Block11Data);
	_data11_->_ref_count_ = 1;
	_data11_->self = g_object_ref (self);
	_tmp0_ = self->priv->alloc_id;
	if (_tmp0_ == ((gulong) 0)) {
		block11_data_unref (_data11_);
		_data11_ = NULL;
		return;
	}
	_tmp1_ = self->priv->marker_layer;
	_tmp2_ = clutter_actor_get_children (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, clutter_actor_get_type ()) ? ((ClutterActor*) _tmp1_) : NULL);
	_data11_->markers = _tmp2_;
	_tmp3_ = _data11_->markers;
	_tmp4_ = g_list_nth_data (_tmp3_, (guint) 0);
	_tmp5_ = (ClutterActor*) _tmp4_;
	_tmp6_ = clutter_actor_get_height ((ClutterActor*) (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, champlain_marker_get_type ()) ? ((ChamplainMarker*) _tmp5_) : NULL));
	_tmp7_ = _tmp6_;
	if (_tmp7_ == ((gfloat) 0)) {
		block11_data_unref (_data11_);
		_data11_ = NULL;
		return;
	}
	_tmp8_ = self->priv->marker_layer;
	_tmp9_ = self->priv->alloc_id;
	g_signal_handler_disconnect ((GObject*) _tmp8_, _tmp9_);
	self->priv->alloc_id = (gulong) 0;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda38__gsource_func, block11_data_ref (_data11_), block11_data_unref);
	block11_data_unref (_data11_);
	_data11_ = NULL;
}


static void _contacts_address_map_on_allocation_changed_clutter_actor_allocation_changed (ClutterActor* _sender, ClutterActorBox* box, ClutterAllocationFlags flags, gpointer self) {
	contacts_address_map_on_allocation_changed ((ContactsAddressMap*) self);
}


static void contacts_address_map_show_map (ContactsAddressMap* self) {
	GList* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	GList* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
	GtkStack* _tmp6_ = NULL;
	GtkGrid* _tmp7_ = NULL;
	ChamplainMarkerLayer* _tmp8_ = NULL;
	gulong _tmp9_ = 0UL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->found_places;
	_tmp1_ = g_list_length (_tmp0_);
	if (_tmp1_ == ((guint) 0)) {
		GtkStack* _tmp2_ = NULL;
		GtkImage* _tmp3_ = NULL;
		_tmp2_ = self->priv->map_stack;
		_tmp3_ = self->priv->map_icon;
		gtk_stack_set_visible_child (_tmp2_, (GtkWidget*) _tmp3_);
		return;
	}
	_tmp4_ = self->priv->found_places;
	_tmp5_ = g_list_length (_tmp4_);
	if (_tmp5_ == ((guint) 1)) {
		contacts_address_map_show_pin (self);
	} else {
		contacts_address_map_show_labels (self);
	}
	_tmp6_ = self->priv->map_stack;
	_tmp7_ = self->priv->map_grid;
	gtk_stack_set_visible_child (_tmp6_, (GtkWidget*) _tmp7_);
	_tmp8_ = self->priv->marker_layer;
	_tmp9_ = g_signal_connect_object ((ClutterActor*) _tmp8_, "allocation-changed", (GCallback) _contacts_address_map_on_allocation_changed_clutter_actor_allocation_changed, self, 0);
	self->priv->alloc_id = _tmp9_;
}


static void contacts_address_map_class_init (ContactsAddressMapClass * klass) {
	gint ContactsAddressMap_private_offset;
	contacts_address_map_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ContactsAddressMapPrivate));
	G_OBJECT_CLASS (klass)->finalize = contacts_address_map_finalize;
	ContactsAddressMap_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/contacts/ui/contacts-address-map.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "map_stack", FALSE, ContactsAddressMap_private_offset + G_STRUCT_OFFSET (ContactsAddressMapPrivate, map_stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "map_grid", FALSE, ContactsAddressMap_private_offset + G_STRUCT_OFFSET (ContactsAddressMapPrivate, map_grid));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "map_icon", FALSE, ContactsAddressMap_private_offset + G_STRUCT_OFFSET (ContactsAddressMapPrivate, map_icon));
}


static void contacts_address_map_instance_init (ContactsAddressMap * self) {
	self->priv = CONTACTS_ADDRESS_MAP_GET_PRIVATE (self);
	self->priv->alloc_id = (gulong) 0;
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void contacts_address_map_finalize (GObject* obj) {
	ContactsAddressMap * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_ADDRESS_MAP, ContactsAddressMap);
	_g_object_unref0 (self->priv->map_stack);
	_g_object_unref0 (self->priv->map_grid);
	_g_object_unref0 (self->priv->map_icon);
	_g_object_unref0 (self->priv->addresses);
	__g_list_free__g_object_unref0_0 (self->priv->found_places);
	_g_object_unref0 (self->priv->map_view);
	_g_object_unref0 (self->priv->marker_layer);
	_vala_clear_GMutex (&self->priv->mutex);
	G_OBJECT_CLASS (contacts_address_map_parent_class)->finalize (obj);
}


GType contacts_address_map_get_type (void) {
	static volatile gsize contacts_address_map_type_id__volatile = 0;
	if (g_once_init_enter (&contacts_address_map_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ContactsAddressMapClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_address_map_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsAddressMap), 0, (GInstanceInitFunc) contacts_address_map_instance_init, NULL };
		GType contacts_address_map_type_id;
		contacts_address_map_type_id = g_type_register_static (gtk_frame_get_type (), "ContactsAddressMap", &g_define_type_info, 0);
		g_once_init_leave (&contacts_address_map_type_id__volatile, contacts_address_map_type_id);
	}
	return contacts_address_map_type_id__volatile;
}


static void _vala_clear_GMutex (GMutex * mutex) {
	GMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GMutex))) {
		g_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GMutex));
	}
}


static void _vala_clear_GRecMutex (GRecMutex * mutex) {
	GRecMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRecMutex))) {
		g_rec_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GRecMutex));
	}
}


static void _vala_clear_GRWLock (GRWLock * mutex) {
	GRWLock zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRWLock))) {
		g_rw_lock_clear (mutex);
		memset (mutex, 0, sizeof (GRWLock));
	}
}


static void _vala_clear_GCond (GCond * mutex) {
	GCond zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GCond))) {
		g_cond_clear (mutex);
		memset (mutex, 0, sizeof (GCond));
	}
}



