// Code generated by smithy-go-codegen DO NOT EDIT.

package iotfleetwise

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/iotfleetwise/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Retrieves information about a campaign.
func (c *Client) GetCampaign(ctx context.Context, params *GetCampaignInput, optFns ...func(*Options)) (*GetCampaignOutput, error) {
	if params == nil {
		params = &GetCampaignInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetCampaign", params, optFns, c.addOperationGetCampaignMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetCampaignOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetCampaignInput struct {

	// The name of the campaign to retrieve information about.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

type GetCampaignOutput struct {

	// The Amazon Resource Name (ARN) of the campaign.
	Arn *string

	// Information about the data collection scheme associated with the campaign.
	CollectionScheme types.CollectionScheme

	// Whether to compress signals before transmitting data to Amazon Web Services IoT
	// FleetWise. If OFF is specified, the signals aren't compressed. If it's not
	// specified, SNAPPY is used.
	Compression types.Compression

	// The time the campaign was created in seconds since epoch (January 1, 1970 at
	// midnight UTC time).
	CreationTime *time.Time

	// The destination where the campaign sends data. You can choose to send data to
	// be stored in Amazon S3 or Amazon Timestream. Amazon S3 optimizes the cost of
	// data storage and provides additional mechanisms to use vehicle data, such as
	// data lakes, centralized data storage, data processing pipelines, and analytics.
	// You can use Amazon Timestream to access and analyze time series data, and
	// Timestream to query vehicle data so that you can identify trends and patterns.
	DataDestinationConfigs []types.DataDestinationConfig

	// A list of vehicle attributes associated with the campaign.
	DataExtraDimensions []string

	// The description of the campaign.
	Description *string

	// Option for a vehicle to send diagnostic trouble codes to Amazon Web Services
	// IoT FleetWise.
	DiagnosticsMode types.DiagnosticsMode

	// The time the campaign expires, in seconds since epoch (January 1, 1970 at
	// midnight UTC time). Vehicle data won't be collected after the campaign expires.
	ExpiryTime *time.Time

	// The last time the campaign was modified.
	LastModificationTime *time.Time

	// The name of the campaign.
	Name *string

	// How long (in seconds) to collect raw data after a triggering event initiates
	// the collection.
	PostTriggerCollectionDuration *int64

	// A number indicating the priority of one campaign over another campaign for a
	// certain vehicle or fleet. A campaign with the lowest value is deployed to
	// vehicles before any other campaigns.
	Priority *int32

	// The ARN of a signal catalog.
	SignalCatalogArn *string

	// Information about a list of signals to collect data on.
	SignalsToCollect []types.SignalInformation

	// Whether to store collected data after a vehicle lost a connection with the
	// cloud. After a connection is re-established, the data is automatically forwarded
	// to Amazon Web Services IoT FleetWise.
	SpoolingMode types.SpoolingMode

	// The time, in milliseconds, to deliver a campaign after it was approved.
	StartTime *time.Time

	// The state of the campaign. The status can be one of: CREATING ,
	// WAITING_FOR_APPROVAL , RUNNING , and SUSPENDED .
	Status types.CampaignStatus

	// The ARN of the vehicle or the fleet targeted by the campaign.
	TargetArn *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetCampaignMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpGetCampaign{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpGetCampaign{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetCampaign"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpGetCampaignValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetCampaign(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetCampaign(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetCampaign",
	}
}
