// ************************************************************
// This file is automatically generated by genxdr. Do not edit.
// ************************************************************

package xdr_test

import (
	"github.com/calmh/xdr"
)

/*

TestStruct Structure:

 0                   1                   2                   3
 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
|                        B (V=0 or 1)                         |V|
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
/                                                               /
\                         int Structure                         \
/                                                               /
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
|                 24 zero bits                  |      I8       |
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
|                 24 zero bits                  |      UI8      |
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
|         16 zero bits          |              I16              |
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
|         16 zero bits          |             UI16              |
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
|                              I32                              |
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
|                             UI32                              |
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
|                                                               |
+                         I64 (64 bits)                         +
|                                                               |
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
|                                                               |
+                        UI64 (64 bits)                         +
|                                                               |
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
/                                                               /
\                   BS (length + padded data)                   \
/                                                               /
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
/                                                               /
\                   S (length + padded data)                    \
/                                                               /
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
/                                                               /
\                       Opaque Structure                        \
/                                                               /
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
|                         Number of SS                          |
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
/                                                               /
/                                                               /
\                   SS (length + padded data)                   \
/                                                               /
/                                                               /
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
/                                                               /
\                     EmptyStruct Structure                     \
/                                                               /
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
/                                                               /
\                     OtherStruct Structure                     \
/                                                               /
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
|                         Number of OSs                         |
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
/                                                               /
\              Zero or more OtherStruct Structures              \
/                                                               /
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+


struct TestStruct {
	bool B;
	int I;
	int I8;
	unsigned int UI8;
	int I16;
	unsigned int UI16;
	int I32;
	unsigned int UI32;
	hyper I64;
	unsigned hyper UI64;
	opaque BS<1024>;
	string S<1024>;
	Opaque C;
	string SS<1024>;
	EmptyStruct ES;
	OtherStruct OS;
	OtherStruct OSs<>;
}

*/

func (o TestStruct) XDRSize() int {
	return 4 + 8 + 4 + 4 + 4 + 4 + 4 + 4 + 8 + 8 +
		4 + len(o.BS) + xdr.Padding(len(o.BS)) +
		4 + len(o.S) + xdr.Padding(len(o.S)) +
		o.C.XDRSize() +
		4 + xdr.SizeOfSlice(o.SS) +
		o.ES.XDRSize() +
		o.OS.XDRSize() +
		4 + xdr.SizeOfSlice(o.OSs)
}

func (o TestStruct) MarshalXDR() ([]byte, error) {
	buf := make([]byte, o.XDRSize())
	m := &xdr.Marshaller{Data: buf}
	return buf, o.MarshalXDRInto(m)
}

func (o TestStruct) MustMarshalXDR() []byte {
	bs, err := o.MarshalXDR()
	if err != nil {
		panic(err)
	}
	return bs
}

func (o TestStruct) MarshalXDRInto(m *xdr.Marshaller) error {
	m.MarshalBool(o.B)
	m.MarshalUint64(uint64(o.I))
	m.MarshalUint8(uint8(o.I8))
	m.MarshalUint8(o.UI8)
	m.MarshalUint16(uint16(o.I16))
	m.MarshalUint16(o.UI16)
	m.MarshalUint32(uint32(o.I32))
	m.MarshalUint32(o.UI32)
	m.MarshalUint64(uint64(o.I64))
	m.MarshalUint64(o.UI64)
	if l := len(o.BS); l > 1024 {
		return xdr.ElementSizeExceeded("BS", l, 1024)
	}
	m.MarshalBytes(o.BS)
	if l := len(o.S); l > 1024 {
		return xdr.ElementSizeExceeded("S", l, 1024)
	}
	m.MarshalString(o.S)
	if err := o.C.MarshalXDRInto(m); err != nil {
		return err
	}
	if l := len(o.SS); l > 1024 {
		return xdr.ElementSizeExceeded("SS", l, 1024)
	}
	m.MarshalUint32(uint32(len(o.SS)))
	for i := range o.SS {
		m.MarshalString(o.SS[i])
	}
	if err := o.ES.MarshalXDRInto(m); err != nil {
		return err
	}
	if err := o.OS.MarshalXDRInto(m); err != nil {
		return err
	}
	m.MarshalUint32(uint32(len(o.OSs)))
	for i := range o.OSs {
		if err := o.OSs[i].MarshalXDRInto(m); err != nil {
			return err
		}
	}
	return m.Error
}

func (o *TestStruct) UnmarshalXDR(bs []byte) error {
	u := &xdr.Unmarshaller{Data: bs}
	return o.UnmarshalXDRFrom(u)
}
func (o *TestStruct) UnmarshalXDRFrom(u *xdr.Unmarshaller) error {
	o.B = u.UnmarshalBool()
	o.I = int(u.UnmarshalUint64())
	o.I8 = int8(u.UnmarshalUint8())
	o.UI8 = u.UnmarshalUint8()
	o.I16 = int16(u.UnmarshalUint16())
	o.UI16 = u.UnmarshalUint16()
	o.I32 = int32(u.UnmarshalUint32())
	o.UI32 = u.UnmarshalUint32()
	o.I64 = int64(u.UnmarshalUint64())
	o.UI64 = u.UnmarshalUint64()
	o.BS = u.UnmarshalBytesMax(1024)
	o.S = u.UnmarshalStringMax(1024)
	(&o.C).UnmarshalXDRFrom(u)
	_SSSize := int(u.UnmarshalUint32())
	if _SSSize < 0 {
		return xdr.ElementSizeExceeded("SS", _SSSize, 1024)
	} else if _SSSize == 0 {
		o.SS = nil
	} else {
		if _SSSize > 1024 {
			return xdr.ElementSizeExceeded("SS", _SSSize, 1024)
		}
		if _SSSize <= len(o.SS) {
			for i := _SSSize; i < len(o.SS); i++ {
				o.SS[i] = ""
			}
			o.SS = o.SS[:_SSSize]
		} else {
			o.SS = make([]string, _SSSize)
		}
		for i := range o.SS {
			o.SS[i] = u.UnmarshalString()
		}
	}
	(&o.ES).UnmarshalXDRFrom(u)
	(&o.OS).UnmarshalXDRFrom(u)
	_OSsSize := int(u.UnmarshalUint32())
	if _OSsSize < 0 {
		return xdr.ElementSizeExceeded("OSs", _OSsSize, 0)
	} else if _OSsSize == 0 {
		o.OSs = nil
	} else {
		if _OSsSize <= len(o.OSs) {
			o.OSs = o.OSs[:_OSsSize]
		} else {
			o.OSs = make([]OtherStruct, _OSsSize)
		}
		for i := range o.OSs {
			(&o.OSs[i]).UnmarshalXDRFrom(u)
		}
	}
	return u.Error
}

/*

EmptyStruct Structure:
(contains no fields)


struct EmptyStruct {
}

*/

func (o EmptyStruct) XDRSize() int {
	return 0
}
func (o EmptyStruct) MarshalXDR() ([]byte, error) {
	return nil, nil
}

func (o EmptyStruct) MustMarshalXDR() []byte {
	return nil
}

func (o EmptyStruct) MarshalXDRInto(m *xdr.Marshaller) error {
	return nil
}

func (o *EmptyStruct) UnmarshalXDR(bs []byte) error {
	return nil
}

func (o *EmptyStruct) UnmarshalXDRFrom(u *xdr.Unmarshaller) error {
	return nil
}

/*

OtherStruct Structure:

 0                   1                   2                   3
 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6 7 8 9 0 1
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
|                              F1                               |
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
/                                                               /
\                   F2 (length + padded data)                   \
/                                                               /
+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+


struct OtherStruct {
	unsigned int F1;
	string F2<>;
}

*/

func (o OtherStruct) XDRSize() int {
	return 4 +
		4 + len(o.F2) + xdr.Padding(len(o.F2))
}

func (o OtherStruct) MarshalXDR() ([]byte, error) {
	buf := make([]byte, o.XDRSize())
	m := &xdr.Marshaller{Data: buf}
	return buf, o.MarshalXDRInto(m)
}

func (o OtherStruct) MustMarshalXDR() []byte {
	bs, err := o.MarshalXDR()
	if err != nil {
		panic(err)
	}
	return bs
}

func (o OtherStruct) MarshalXDRInto(m *xdr.Marshaller) error {
	m.MarshalUint32(o.F1)
	m.MarshalString(o.F2)
	return m.Error
}

func (o *OtherStruct) UnmarshalXDR(bs []byte) error {
	u := &xdr.Unmarshaller{Data: bs}
	return o.UnmarshalXDRFrom(u)
}
func (o *OtherStruct) UnmarshalXDRFrom(u *xdr.Unmarshaller) error {
	o.F1 = u.UnmarshalUint32()
	o.F2 = u.UnmarshalString()
	return u.Error
}
