// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/genomics/v1/variants.proto

package genomics

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import google_longrunning "google.golang.org/genproto/googleapis/longrunning"
import google_protobuf1 "github.com/golang/protobuf/ptypes/empty"
import google_protobuf2 "google.golang.org/genproto/protobuf/field_mask"
import google_protobuf3 "github.com/golang/protobuf/ptypes/struct"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// Operations to be performed during import on Variant info fields.
// These operations are set for each info field in the info_merge_config
// map of ImportVariantsRequest, which is plumbed down to the
// MergeVariantRequests generated by the import job.
type InfoMergeOperation int32

const (
	InfoMergeOperation_INFO_MERGE_OPERATION_UNSPECIFIED InfoMergeOperation = 0
	// By default, Variant info fields are persisted if the Variant doesn't
	// already exist in the variantset.  If the Variant is equivalent to a
	// Variant already in the variantset, the incoming Variant's info field
	// is ignored in favor of that of the already persisted Variant.
	InfoMergeOperation_IGNORE_NEW InfoMergeOperation = 1
	// This operation removes an info field from the incoming Variant
	// and persists this info field in each of the incoming Variant's Calls.
	InfoMergeOperation_MOVE_TO_CALLS InfoMergeOperation = 2
)

var InfoMergeOperation_name = map[int32]string{
	0: "INFO_MERGE_OPERATION_UNSPECIFIED",
	1: "IGNORE_NEW",
	2: "MOVE_TO_CALLS",
}
var InfoMergeOperation_value = map[string]int32{
	"INFO_MERGE_OPERATION_UNSPECIFIED": 0,
	"IGNORE_NEW":                       1,
	"MOVE_TO_CALLS":                    2,
}

func (x InfoMergeOperation) String() string {
	return proto.EnumName(InfoMergeOperation_name, int32(x))
}
func (InfoMergeOperation) EnumDescriptor() ([]byte, []int) { return fileDescriptor11, []int{0} }

type VariantSetMetadata_Type int32

const (
	VariantSetMetadata_TYPE_UNSPECIFIED VariantSetMetadata_Type = 0
	VariantSetMetadata_INTEGER          VariantSetMetadata_Type = 1
	VariantSetMetadata_FLOAT            VariantSetMetadata_Type = 2
	VariantSetMetadata_FLAG             VariantSetMetadata_Type = 3
	VariantSetMetadata_CHARACTER        VariantSetMetadata_Type = 4
	VariantSetMetadata_STRING           VariantSetMetadata_Type = 5
)

var VariantSetMetadata_Type_name = map[int32]string{
	0: "TYPE_UNSPECIFIED",
	1: "INTEGER",
	2: "FLOAT",
	3: "FLAG",
	4: "CHARACTER",
	5: "STRING",
}
var VariantSetMetadata_Type_value = map[string]int32{
	"TYPE_UNSPECIFIED": 0,
	"INTEGER":          1,
	"FLOAT":            2,
	"FLAG":             3,
	"CHARACTER":        4,
	"STRING":           5,
}

func (x VariantSetMetadata_Type) String() string {
	return proto.EnumName(VariantSetMetadata_Type_name, int32(x))
}
func (VariantSetMetadata_Type) EnumDescriptor() ([]byte, []int) { return fileDescriptor11, []int{0, 0} }

type ImportVariantsRequest_Format int32

const (
	ImportVariantsRequest_FORMAT_UNSPECIFIED ImportVariantsRequest_Format = 0
	// VCF (Variant Call Format). The VCF files may be gzip compressed. gVCF is
	// also supported.
	ImportVariantsRequest_FORMAT_VCF ImportVariantsRequest_Format = 1
	// Complete Genomics masterVarBeta format. The masterVarBeta files may
	// be bzip2 compressed.
	ImportVariantsRequest_FORMAT_COMPLETE_GENOMICS ImportVariantsRequest_Format = 2
)

var ImportVariantsRequest_Format_name = map[int32]string{
	0: "FORMAT_UNSPECIFIED",
	1: "FORMAT_VCF",
	2: "FORMAT_COMPLETE_GENOMICS",
}
var ImportVariantsRequest_Format_value = map[string]int32{
	"FORMAT_UNSPECIFIED":       0,
	"FORMAT_VCF":               1,
	"FORMAT_COMPLETE_GENOMICS": 2,
}

func (x ImportVariantsRequest_Format) String() string {
	return proto.EnumName(ImportVariantsRequest_Format_name, int32(x))
}
func (ImportVariantsRequest_Format) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor11, []int{6, 0}
}

type ExportVariantSetRequest_Format int32

const (
	ExportVariantSetRequest_FORMAT_UNSPECIFIED ExportVariantSetRequest_Format = 0
	// Export the data to Google BigQuery.
	ExportVariantSetRequest_FORMAT_BIGQUERY ExportVariantSetRequest_Format = 1
)

var ExportVariantSetRequest_Format_name = map[int32]string{
	0: "FORMAT_UNSPECIFIED",
	1: "FORMAT_BIGQUERY",
}
var ExportVariantSetRequest_Format_value = map[string]int32{
	"FORMAT_UNSPECIFIED": 0,
	"FORMAT_BIGQUERY":    1,
}

func (x ExportVariantSetRequest_Format) String() string {
	return proto.EnumName(ExportVariantSetRequest_Format_name, int32(x))
}
func (ExportVariantSetRequest_Format) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor11, []int{9, 0}
}

// Metadata describes a single piece of variant call metadata.
// These data include a top level key and either a single value string (value)
// or a list of key-value pairs (info.)
// Value and info are mutually exclusive.
type VariantSetMetadata struct {
	// The top-level key.
	Key string `protobuf:"bytes,1,opt,name=key" json:"key,omitempty"`
	// The value field for simple metadata
	Value string `protobuf:"bytes,2,opt,name=value" json:"value,omitempty"`
	// User-provided ID field, not enforced by this API.
	// Two or more pieces of structured metadata with identical
	// id and key fields are considered equivalent.
	Id string `protobuf:"bytes,4,opt,name=id" json:"id,omitempty"`
	// The type of data. Possible types include: Integer, Float,
	// Flag, Character, and String.
	Type VariantSetMetadata_Type `protobuf:"varint,5,opt,name=type,enum=google.genomics.v1.VariantSetMetadata_Type" json:"type,omitempty"`
	// The number of values that can be included in a field described by this
	// metadata.
	Number string `protobuf:"bytes,8,opt,name=number" json:"number,omitempty"`
	// A textual description of this metadata.
	Description string `protobuf:"bytes,7,opt,name=description" json:"description,omitempty"`
	// Remaining structured metadata key-value pairs. This must be of the form
	// map<string, string[]> (string key mapping to a list of string values).
	Info map[string]*google_protobuf3.ListValue `protobuf:"bytes,3,rep,name=info" json:"info,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *VariantSetMetadata) Reset()                    { *m = VariantSetMetadata{} }
func (m *VariantSetMetadata) String() string            { return proto.CompactTextString(m) }
func (*VariantSetMetadata) ProtoMessage()               {}
func (*VariantSetMetadata) Descriptor() ([]byte, []int) { return fileDescriptor11, []int{0} }

func (m *VariantSetMetadata) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *VariantSetMetadata) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

func (m *VariantSetMetadata) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *VariantSetMetadata) GetType() VariantSetMetadata_Type {
	if m != nil {
		return m.Type
	}
	return VariantSetMetadata_TYPE_UNSPECIFIED
}

func (m *VariantSetMetadata) GetNumber() string {
	if m != nil {
		return m.Number
	}
	return ""
}

func (m *VariantSetMetadata) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *VariantSetMetadata) GetInfo() map[string]*google_protobuf3.ListValue {
	if m != nil {
		return m.Info
	}
	return nil
}

// A variant set is a collection of call sets and variants. It contains summary
// statistics of those contents. A variant set belongs to a dataset.
//
// For more genomics resource definitions, see [Fundamentals of Google
// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
type VariantSet struct {
	// The dataset to which this variant set belongs.
	DatasetId string `protobuf:"bytes,1,opt,name=dataset_id,json=datasetId" json:"dataset_id,omitempty"`
	// The server-generated variant set ID, unique across all variant sets.
	Id string `protobuf:"bytes,2,opt,name=id" json:"id,omitempty"`
	// The reference set to which the variant set is mapped. The reference set
	// describes the alignment provenance of the variant set, while the
	// `referenceBounds` describe the shape of the actual variant data. The
	// reference set's reference names are a superset of those found in the
	// `referenceBounds`.
	//
	// For example, given a variant set that is mapped to the GRCh38 reference set
	// and contains a single variant on reference 'X', `referenceBounds` would
	// contain only an entry for 'X', while the associated reference set
	// enumerates all possible references: '1', '2', 'X', 'Y', 'MT', etc.
	ReferenceSetId string `protobuf:"bytes,6,opt,name=reference_set_id,json=referenceSetId" json:"reference_set_id,omitempty"`
	// A list of all references used by the variants in a variant set
	// with associated coordinate upper bounds for each one.
	ReferenceBounds []*ReferenceBound `protobuf:"bytes,5,rep,name=reference_bounds,json=referenceBounds" json:"reference_bounds,omitempty"`
	// The metadata associated with this variant set.
	Metadata []*VariantSetMetadata `protobuf:"bytes,4,rep,name=metadata" json:"metadata,omitempty"`
	// User-specified, mutable name.
	Name string `protobuf:"bytes,7,opt,name=name" json:"name,omitempty"`
	// A textual description of this variant set.
	Description string `protobuf:"bytes,8,opt,name=description" json:"description,omitempty"`
}

func (m *VariantSet) Reset()                    { *m = VariantSet{} }
func (m *VariantSet) String() string            { return proto.CompactTextString(m) }
func (*VariantSet) ProtoMessage()               {}
func (*VariantSet) Descriptor() ([]byte, []int) { return fileDescriptor11, []int{1} }

func (m *VariantSet) GetDatasetId() string {
	if m != nil {
		return m.DatasetId
	}
	return ""
}

func (m *VariantSet) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *VariantSet) GetReferenceSetId() string {
	if m != nil {
		return m.ReferenceSetId
	}
	return ""
}

func (m *VariantSet) GetReferenceBounds() []*ReferenceBound {
	if m != nil {
		return m.ReferenceBounds
	}
	return nil
}

func (m *VariantSet) GetMetadata() []*VariantSetMetadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *VariantSet) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *VariantSet) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

// A variant represents a change in DNA sequence relative to a reference
// sequence. For example, a variant could represent a SNP or an insertion.
// Variants belong to a variant set.
//
// For more genomics resource definitions, see [Fundamentals of Google
// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
//
// Each of the calls on a variant represent a determination of genotype with
// respect to that variant. For example, a call might assign probability of 0.32
// to the occurrence of a SNP named rs1234 in a sample named NA12345. A call
// belongs to a call set, which contains related calls typically from one
// sample.
type Variant struct {
	// The ID of the variant set this variant belongs to.
	VariantSetId string `protobuf:"bytes,15,opt,name=variant_set_id,json=variantSetId" json:"variant_set_id,omitempty"`
	// The server-generated variant ID, unique across all variants.
	Id string `protobuf:"bytes,2,opt,name=id" json:"id,omitempty"`
	// Names for the variant, for example a RefSNP ID.
	Names []string `protobuf:"bytes,3,rep,name=names" json:"names,omitempty"`
	// The date this variant was created, in milliseconds from the epoch.
	Created int64 `protobuf:"varint,12,opt,name=created" json:"created,omitempty"`
	// The reference on which this variant occurs.
	// (such as `chr20` or `X`)
	ReferenceName string `protobuf:"bytes,14,opt,name=reference_name,json=referenceName" json:"reference_name,omitempty"`
	// The position at which this variant occurs (0-based).
	// This corresponds to the first base of the string of reference bases.
	Start int64 `protobuf:"varint,16,opt,name=start" json:"start,omitempty"`
	// The end position (0-based) of this variant. This corresponds to the first
	// base after the last base in the reference allele. So, the length of
	// the reference allele is (end - start). This is useful for variants
	// that don't explicitly give alternate bases, for example large deletions.
	End int64 `protobuf:"varint,13,opt,name=end" json:"end,omitempty"`
	// The reference bases for this variant. They start at the given
	// position.
	ReferenceBases string `protobuf:"bytes,6,opt,name=reference_bases,json=referenceBases" json:"reference_bases,omitempty"`
	// The bases that appear instead of the reference bases.
	AlternateBases []string `protobuf:"bytes,7,rep,name=alternate_bases,json=alternateBases" json:"alternate_bases,omitempty"`
	// A measure of how likely this variant is to be real.
	// A higher value is better.
	Quality float64 `protobuf:"fixed64,8,opt,name=quality" json:"quality,omitempty"`
	// A list of filters (normally quality filters) this variant has failed.
	// `PASS` indicates this variant has passed all filters.
	Filter []string `protobuf:"bytes,9,rep,name=filter" json:"filter,omitempty"`
	// A map of additional variant information. This must be of the form
	// map<string, string[]> (string key mapping to a list of string values).
	Info map[string]*google_protobuf3.ListValue `protobuf:"bytes,10,rep,name=info" json:"info,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// The variant calls for this particular variant. Each one represents the
	// determination of genotype with respect to this variant.
	Calls []*VariantCall `protobuf:"bytes,11,rep,name=calls" json:"calls,omitempty"`
}

func (m *Variant) Reset()                    { *m = Variant{} }
func (m *Variant) String() string            { return proto.CompactTextString(m) }
func (*Variant) ProtoMessage()               {}
func (*Variant) Descriptor() ([]byte, []int) { return fileDescriptor11, []int{2} }

func (m *Variant) GetVariantSetId() string {
	if m != nil {
		return m.VariantSetId
	}
	return ""
}

func (m *Variant) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Variant) GetNames() []string {
	if m != nil {
		return m.Names
	}
	return nil
}

func (m *Variant) GetCreated() int64 {
	if m != nil {
		return m.Created
	}
	return 0
}

func (m *Variant) GetReferenceName() string {
	if m != nil {
		return m.ReferenceName
	}
	return ""
}

func (m *Variant) GetStart() int64 {
	if m != nil {
		return m.Start
	}
	return 0
}

func (m *Variant) GetEnd() int64 {
	if m != nil {
		return m.End
	}
	return 0
}

func (m *Variant) GetReferenceBases() string {
	if m != nil {
		return m.ReferenceBases
	}
	return ""
}

func (m *Variant) GetAlternateBases() []string {
	if m != nil {
		return m.AlternateBases
	}
	return nil
}

func (m *Variant) GetQuality() float64 {
	if m != nil {
		return m.Quality
	}
	return 0
}

func (m *Variant) GetFilter() []string {
	if m != nil {
		return m.Filter
	}
	return nil
}

func (m *Variant) GetInfo() map[string]*google_protobuf3.ListValue {
	if m != nil {
		return m.Info
	}
	return nil
}

func (m *Variant) GetCalls() []*VariantCall {
	if m != nil {
		return m.Calls
	}
	return nil
}

// A call represents the determination of genotype with respect to a particular
// variant. It may include associated information such as quality and phasing.
// For example, a call might assign a probability of 0.32 to the occurrence of
// a SNP named rs1234 in a call set with the name NA12345.
type VariantCall struct {
	// The ID of the call set this variant call belongs to.
	CallSetId string `protobuf:"bytes,8,opt,name=call_set_id,json=callSetId" json:"call_set_id,omitempty"`
	// The name of the call set this variant call belongs to.
	CallSetName string `protobuf:"bytes,9,opt,name=call_set_name,json=callSetName" json:"call_set_name,omitempty"`
	// The genotype of this variant call. Each value represents either the value
	// of the `referenceBases` field or a 1-based index into
	// `alternateBases`. If a variant had a `referenceBases`
	// value of `T` and an `alternateBases`
	// value of `["A", "C"]`, and the `genotype` was
	// `[2, 1]`, that would mean the call
	// represented the heterozygous value `CA` for this variant.
	// If the `genotype` was instead `[0, 1]`, the
	// represented value would be `TA`. Ordering of the
	// genotype values is important if the `phaseset` is present.
	// If a genotype is not called (that is, a `.` is present in the
	// GT string) -1 is returned.
	Genotype []int32 `protobuf:"varint,7,rep,packed,name=genotype" json:"genotype,omitempty"`
	// If this field is present, this variant call's genotype ordering implies
	// the phase of the bases and is consistent with any other variant calls in
	// the same reference sequence which have the same phaseset value.
	// When importing data from VCF, if the genotype data was phased but no
	// phase set was specified this field will be set to `*`.
	Phaseset string `protobuf:"bytes,5,opt,name=phaseset" json:"phaseset,omitempty"`
	// The genotype likelihoods for this variant call. Each array entry
	// represents how likely a specific genotype is for this call. The value
	// ordering is defined by the GL tag in the VCF spec.
	// If Phred-scaled genotype likelihood scores (PL) are available and
	// log10(P) genotype likelihood scores (GL) are not, PL scores are converted
	// to GL scores.  If both are available, PL scores are stored in `info`.
	GenotypeLikelihood []float64 `protobuf:"fixed64,6,rep,packed,name=genotype_likelihood,json=genotypeLikelihood" json:"genotype_likelihood,omitempty"`
	// A map of additional variant call information. This must be of the form
	// map<string, string[]> (string key mapping to a list of string values).
	Info map[string]*google_protobuf3.ListValue `protobuf:"bytes,2,rep,name=info" json:"info,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *VariantCall) Reset()                    { *m = VariantCall{} }
func (m *VariantCall) String() string            { return proto.CompactTextString(m) }
func (*VariantCall) ProtoMessage()               {}
func (*VariantCall) Descriptor() ([]byte, []int) { return fileDescriptor11, []int{3} }

func (m *VariantCall) GetCallSetId() string {
	if m != nil {
		return m.CallSetId
	}
	return ""
}

func (m *VariantCall) GetCallSetName() string {
	if m != nil {
		return m.CallSetName
	}
	return ""
}

func (m *VariantCall) GetGenotype() []int32 {
	if m != nil {
		return m.Genotype
	}
	return nil
}

func (m *VariantCall) GetPhaseset() string {
	if m != nil {
		return m.Phaseset
	}
	return ""
}

func (m *VariantCall) GetGenotypeLikelihood() []float64 {
	if m != nil {
		return m.GenotypeLikelihood
	}
	return nil
}

func (m *VariantCall) GetInfo() map[string]*google_protobuf3.ListValue {
	if m != nil {
		return m.Info
	}
	return nil
}

// A call set is a collection of variant calls, typically for one sample. It
// belongs to a variant set.
//
// For more genomics resource definitions, see [Fundamentals of Google
// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
type CallSet struct {
	// The server-generated call set ID, unique across all call sets.
	Id string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	// The call set name.
	Name string `protobuf:"bytes,2,opt,name=name" json:"name,omitempty"`
	// The sample ID this call set corresponds to.
	SampleId string `protobuf:"bytes,7,opt,name=sample_id,json=sampleId" json:"sample_id,omitempty"`
	// The IDs of the variant sets this call set belongs to. This field must
	// have exactly length one, as a call set belongs to a single variant set.
	// This field is repeated for compatibility with the
	// [GA4GH 0.5.1
	// API](https://github.com/ga4gh/schemas/blob/v0.5.1/src/main/resources/avro/variants.avdl#L76).
	VariantSetIds []string `protobuf:"bytes,6,rep,name=variant_set_ids,json=variantSetIds" json:"variant_set_ids,omitempty"`
	// The date this call set was created in milliseconds from the epoch.
	Created int64 `protobuf:"varint,5,opt,name=created" json:"created,omitempty"`
	// A map of additional call set information. This must be of the form
	// map<string, string[]> (string key mapping to a list of string values).
	Info map[string]*google_protobuf3.ListValue `protobuf:"bytes,4,rep,name=info" json:"info,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *CallSet) Reset()                    { *m = CallSet{} }
func (m *CallSet) String() string            { return proto.CompactTextString(m) }
func (*CallSet) ProtoMessage()               {}
func (*CallSet) Descriptor() ([]byte, []int) { return fileDescriptor11, []int{4} }

func (m *CallSet) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *CallSet) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *CallSet) GetSampleId() string {
	if m != nil {
		return m.SampleId
	}
	return ""
}

func (m *CallSet) GetVariantSetIds() []string {
	if m != nil {
		return m.VariantSetIds
	}
	return nil
}

func (m *CallSet) GetCreated() int64 {
	if m != nil {
		return m.Created
	}
	return 0
}

func (m *CallSet) GetInfo() map[string]*google_protobuf3.ListValue {
	if m != nil {
		return m.Info
	}
	return nil
}

// ReferenceBound records an upper bound for the starting coordinate of
// variants in a particular reference.
type ReferenceBound struct {
	// The name of the reference associated with this reference bound.
	ReferenceName string `protobuf:"bytes,1,opt,name=reference_name,json=referenceName" json:"reference_name,omitempty"`
	// An upper bound (inclusive) on the starting coordinate of any
	// variant in the reference sequence.
	UpperBound int64 `protobuf:"varint,2,opt,name=upper_bound,json=upperBound" json:"upper_bound,omitempty"`
}

func (m *ReferenceBound) Reset()                    { *m = ReferenceBound{} }
func (m *ReferenceBound) String() string            { return proto.CompactTextString(m) }
func (*ReferenceBound) ProtoMessage()               {}
func (*ReferenceBound) Descriptor() ([]byte, []int) { return fileDescriptor11, []int{5} }

func (m *ReferenceBound) GetReferenceName() string {
	if m != nil {
		return m.ReferenceName
	}
	return ""
}

func (m *ReferenceBound) GetUpperBound() int64 {
	if m != nil {
		return m.UpperBound
	}
	return 0
}

// The variant data import request.
type ImportVariantsRequest struct {
	// Required. The variant set to which variant data should be imported.
	VariantSetId string `protobuf:"bytes,1,opt,name=variant_set_id,json=variantSetId" json:"variant_set_id,omitempty"`
	// A list of URIs referencing variant files in Google Cloud Storage. URIs can
	// include wildcards [as described
	// here](https://cloud.google.com/storage/docs/gsutil/addlhelp/WildcardNames).
	// Note that recursive wildcards ('**') are not supported.
	SourceUris []string `protobuf:"bytes,2,rep,name=source_uris,json=sourceUris" json:"source_uris,omitempty"`
	// The format of the variant data being imported. If unspecified, defaults to
	// to `VCF`.
	Format ImportVariantsRequest_Format `protobuf:"varint,3,opt,name=format,enum=google.genomics.v1.ImportVariantsRequest_Format" json:"format,omitempty"`
	// Convert reference names to the canonical representation.
	// hg19 haploytypes (those reference names containing "_hap")
	// are not modified in any way.
	// All other reference names are modified according to the following rules:
	// The reference name is capitalized.
	// The "chr" prefix is dropped for all autosomes and sex chromsomes.
	// For example "chr17" becomes "17" and "chrX" becomes "X".
	// All mitochondrial chromosomes ("chrM", "chrMT", etc) become "MT".
	NormalizeReferenceNames bool `protobuf:"varint,5,opt,name=normalize_reference_names,json=normalizeReferenceNames" json:"normalize_reference_names,omitempty"`
	// A mapping between info field keys and the InfoMergeOperations to
	// be performed on them. This is plumbed down to the MergeVariantRequests
	// generated by the resulting import job.
	InfoMergeConfig map[string]InfoMergeOperation `protobuf:"bytes,6,rep,name=info_merge_config,json=infoMergeConfig" json:"info_merge_config,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"varint,2,opt,name=value,enum=google.genomics.v1.InfoMergeOperation"`
}

func (m *ImportVariantsRequest) Reset()                    { *m = ImportVariantsRequest{} }
func (m *ImportVariantsRequest) String() string            { return proto.CompactTextString(m) }
func (*ImportVariantsRequest) ProtoMessage()               {}
func (*ImportVariantsRequest) Descriptor() ([]byte, []int) { return fileDescriptor11, []int{6} }

func (m *ImportVariantsRequest) GetVariantSetId() string {
	if m != nil {
		return m.VariantSetId
	}
	return ""
}

func (m *ImportVariantsRequest) GetSourceUris() []string {
	if m != nil {
		return m.SourceUris
	}
	return nil
}

func (m *ImportVariantsRequest) GetFormat() ImportVariantsRequest_Format {
	if m != nil {
		return m.Format
	}
	return ImportVariantsRequest_FORMAT_UNSPECIFIED
}

func (m *ImportVariantsRequest) GetNormalizeReferenceNames() bool {
	if m != nil {
		return m.NormalizeReferenceNames
	}
	return false
}

func (m *ImportVariantsRequest) GetInfoMergeConfig() map[string]InfoMergeOperation {
	if m != nil {
		return m.InfoMergeConfig
	}
	return nil
}

// The variant data import response.
type ImportVariantsResponse struct {
	// IDs of the call sets created during the import.
	CallSetIds []string `protobuf:"bytes,1,rep,name=call_set_ids,json=callSetIds" json:"call_set_ids,omitempty"`
}

func (m *ImportVariantsResponse) Reset()                    { *m = ImportVariantsResponse{} }
func (m *ImportVariantsResponse) String() string            { return proto.CompactTextString(m) }
func (*ImportVariantsResponse) ProtoMessage()               {}
func (*ImportVariantsResponse) Descriptor() ([]byte, []int) { return fileDescriptor11, []int{7} }

func (m *ImportVariantsResponse) GetCallSetIds() []string {
	if m != nil {
		return m.CallSetIds
	}
	return nil
}

// The CreateVariantSet request
type CreateVariantSetRequest struct {
	// Required. The variant set to be created. Must have a valid `datasetId`.
	VariantSet *VariantSet `protobuf:"bytes,1,opt,name=variant_set,json=variantSet" json:"variant_set,omitempty"`
}

func (m *CreateVariantSetRequest) Reset()                    { *m = CreateVariantSetRequest{} }
func (m *CreateVariantSetRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateVariantSetRequest) ProtoMessage()               {}
func (*CreateVariantSetRequest) Descriptor() ([]byte, []int) { return fileDescriptor11, []int{8} }

func (m *CreateVariantSetRequest) GetVariantSet() *VariantSet {
	if m != nil {
		return m.VariantSet
	}
	return nil
}

// The variant data export request.
type ExportVariantSetRequest struct {
	// Required. The ID of the variant set that contains variant data which
	// should be exported. The caller must have READ access to this variant set.
	VariantSetId string `protobuf:"bytes,1,opt,name=variant_set_id,json=variantSetId" json:"variant_set_id,omitempty"`
	// If provided, only variant call information from the specified call sets
	// will be exported. By default all variant calls are exported.
	CallSetIds []string `protobuf:"bytes,2,rep,name=call_set_ids,json=callSetIds" json:"call_set_ids,omitempty"`
	// Required. The Google Cloud project ID that owns the destination
	// BigQuery dataset. The caller must have WRITE access to this project.  This
	// project will also own the resulting export job.
	ProjectId string `protobuf:"bytes,3,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// The format for the exported data.
	Format ExportVariantSetRequest_Format `protobuf:"varint,4,opt,name=format,enum=google.genomics.v1.ExportVariantSetRequest_Format" json:"format,omitempty"`
	// Required. The BigQuery dataset to export data to. This dataset must already
	// exist. Note that this is distinct from the Genomics concept of "dataset".
	BigqueryDataset string `protobuf:"bytes,5,opt,name=bigquery_dataset,json=bigqueryDataset" json:"bigquery_dataset,omitempty"`
	// Required. The BigQuery table to export data to.
	// If the table doesn't exist, it will be created. If it already exists, it
	// will be overwritten.
	BigqueryTable string `protobuf:"bytes,6,opt,name=bigquery_table,json=bigqueryTable" json:"bigquery_table,omitempty"`
}

func (m *ExportVariantSetRequest) Reset()                    { *m = ExportVariantSetRequest{} }
func (m *ExportVariantSetRequest) String() string            { return proto.CompactTextString(m) }
func (*ExportVariantSetRequest) ProtoMessage()               {}
func (*ExportVariantSetRequest) Descriptor() ([]byte, []int) { return fileDescriptor11, []int{9} }

func (m *ExportVariantSetRequest) GetVariantSetId() string {
	if m != nil {
		return m.VariantSetId
	}
	return ""
}

func (m *ExportVariantSetRequest) GetCallSetIds() []string {
	if m != nil {
		return m.CallSetIds
	}
	return nil
}

func (m *ExportVariantSetRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *ExportVariantSetRequest) GetFormat() ExportVariantSetRequest_Format {
	if m != nil {
		return m.Format
	}
	return ExportVariantSetRequest_FORMAT_UNSPECIFIED
}

func (m *ExportVariantSetRequest) GetBigqueryDataset() string {
	if m != nil {
		return m.BigqueryDataset
	}
	return ""
}

func (m *ExportVariantSetRequest) GetBigqueryTable() string {
	if m != nil {
		return m.BigqueryTable
	}
	return ""
}

// The variant set request.
type GetVariantSetRequest struct {
	// Required. The ID of the variant set.
	VariantSetId string `protobuf:"bytes,1,opt,name=variant_set_id,json=variantSetId" json:"variant_set_id,omitempty"`
}

func (m *GetVariantSetRequest) Reset()                    { *m = GetVariantSetRequest{} }
func (m *GetVariantSetRequest) String() string            { return proto.CompactTextString(m) }
func (*GetVariantSetRequest) ProtoMessage()               {}
func (*GetVariantSetRequest) Descriptor() ([]byte, []int) { return fileDescriptor11, []int{10} }

func (m *GetVariantSetRequest) GetVariantSetId() string {
	if m != nil {
		return m.VariantSetId
	}
	return ""
}

// The search variant sets request.
type SearchVariantSetsRequest struct {
	// Exactly one dataset ID must be provided here. Only variant sets which
	// belong to this dataset will be returned.
	DatasetIds []string `protobuf:"bytes,1,rep,name=dataset_ids,json=datasetIds" json:"dataset_ids,omitempty"`
	// The continuation token, which is used to page through large result sets.
	// To get the next page of results, set this parameter to the value of
	// `nextPageToken` from the previous response.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
	// The maximum number of results to return in a single page. If unspecified,
	// defaults to 1024.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
}

func (m *SearchVariantSetsRequest) Reset()                    { *m = SearchVariantSetsRequest{} }
func (m *SearchVariantSetsRequest) String() string            { return proto.CompactTextString(m) }
func (*SearchVariantSetsRequest) ProtoMessage()               {}
func (*SearchVariantSetsRequest) Descriptor() ([]byte, []int) { return fileDescriptor11, []int{11} }

func (m *SearchVariantSetsRequest) GetDatasetIds() []string {
	if m != nil {
		return m.DatasetIds
	}
	return nil
}

func (m *SearchVariantSetsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *SearchVariantSetsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

// The search variant sets response.
type SearchVariantSetsResponse struct {
	// The variant sets belonging to the requested dataset.
	VariantSets []*VariantSet `protobuf:"bytes,1,rep,name=variant_sets,json=variantSets" json:"variant_sets,omitempty"`
	// The continuation token, which is used to page through large result sets.
	// Provide this value in a subsequent request to return the next page of
	// results. This field will be empty if there aren't any additional results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *SearchVariantSetsResponse) Reset()                    { *m = SearchVariantSetsResponse{} }
func (m *SearchVariantSetsResponse) String() string            { return proto.CompactTextString(m) }
func (*SearchVariantSetsResponse) ProtoMessage()               {}
func (*SearchVariantSetsResponse) Descriptor() ([]byte, []int) { return fileDescriptor11, []int{12} }

func (m *SearchVariantSetsResponse) GetVariantSets() []*VariantSet {
	if m != nil {
		return m.VariantSets
	}
	return nil
}

func (m *SearchVariantSetsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// The delete variant set request.
type DeleteVariantSetRequest struct {
	// The ID of the variant set to be deleted.
	VariantSetId string `protobuf:"bytes,1,opt,name=variant_set_id,json=variantSetId" json:"variant_set_id,omitempty"`
}

func (m *DeleteVariantSetRequest) Reset()                    { *m = DeleteVariantSetRequest{} }
func (m *DeleteVariantSetRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteVariantSetRequest) ProtoMessage()               {}
func (*DeleteVariantSetRequest) Descriptor() ([]byte, []int) { return fileDescriptor11, []int{13} }

func (m *DeleteVariantSetRequest) GetVariantSetId() string {
	if m != nil {
		return m.VariantSetId
	}
	return ""
}

type UpdateVariantSetRequest struct {
	// The ID of the variant to be updated (must already exist).
	VariantSetId string `protobuf:"bytes,1,opt,name=variant_set_id,json=variantSetId" json:"variant_set_id,omitempty"`
	// The new variant data. Only the variant_set.metadata will be considered
	// for update.
	VariantSet *VariantSet `protobuf:"bytes,2,opt,name=variant_set,json=variantSet" json:"variant_set,omitempty"`
	// An optional mask specifying which fields to update. Supported fields:
	//
	// * [metadata][google.genomics.v1.VariantSet.metadata].
	// * [name][google.genomics.v1.VariantSet.name].
	// * [description][google.genomics.v1.VariantSet.description].
	//
	// Leaving `updateMask` unset is equivalent to specifying all mutable
	// fields.
	UpdateMask *google_protobuf2.FieldMask `protobuf:"bytes,5,opt,name=update_mask,json=updateMask" json:"update_mask,omitempty"`
}

func (m *UpdateVariantSetRequest) Reset()                    { *m = UpdateVariantSetRequest{} }
func (m *UpdateVariantSetRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateVariantSetRequest) ProtoMessage()               {}
func (*UpdateVariantSetRequest) Descriptor() ([]byte, []int) { return fileDescriptor11, []int{14} }

func (m *UpdateVariantSetRequest) GetVariantSetId() string {
	if m != nil {
		return m.VariantSetId
	}
	return ""
}

func (m *UpdateVariantSetRequest) GetVariantSet() *VariantSet {
	if m != nil {
		return m.VariantSet
	}
	return nil
}

func (m *UpdateVariantSetRequest) GetUpdateMask() *google_protobuf2.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// The variant search request.
type SearchVariantsRequest struct {
	// At most one variant set ID must be provided. Only variants from this
	// variant set will be returned. If omitted, a call set id must be included in
	// the request.
	VariantSetIds []string `protobuf:"bytes,1,rep,name=variant_set_ids,json=variantSetIds" json:"variant_set_ids,omitempty"`
	// Only return variants which have exactly this name.
	VariantName string `protobuf:"bytes,2,opt,name=variant_name,json=variantName" json:"variant_name,omitempty"`
	// Only return variant calls which belong to call sets with these ids.
	// Leaving this blank returns all variant calls. If a variant has no
	// calls belonging to any of these call sets, it won't be returned at all.
	CallSetIds []string `protobuf:"bytes,3,rep,name=call_set_ids,json=callSetIds" json:"call_set_ids,omitempty"`
	// Required. Only return variants in this reference sequence.
	ReferenceName string `protobuf:"bytes,4,opt,name=reference_name,json=referenceName" json:"reference_name,omitempty"`
	// The beginning of the window (0-based, inclusive) for which
	// overlapping variants should be returned. If unspecified, defaults to 0.
	Start int64 `protobuf:"varint,5,opt,name=start" json:"start,omitempty"`
	// The end of the window, 0-based exclusive. If unspecified or 0, defaults to
	// the length of the reference.
	End int64 `protobuf:"varint,6,opt,name=end" json:"end,omitempty"`
	// The continuation token, which is used to page through large result sets.
	// To get the next page of results, set this parameter to the value of
	// `nextPageToken` from the previous response.
	PageToken string `protobuf:"bytes,7,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
	// The maximum number of variants to return in a single page. If unspecified,
	// defaults to 5000. The maximum value is 10000.
	PageSize int32 `protobuf:"varint,8,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
	// The maximum number of calls to return in a single page. Note that this
	// limit may be exceeded in the event that a matching variant contains more
	// calls than the requested maximum. If unspecified, defaults to 5000. The
	// maximum value is 10000.
	MaxCalls int32 `protobuf:"varint,9,opt,name=max_calls,json=maxCalls" json:"max_calls,omitempty"`
}

func (m *SearchVariantsRequest) Reset()                    { *m = SearchVariantsRequest{} }
func (m *SearchVariantsRequest) String() string            { return proto.CompactTextString(m) }
func (*SearchVariantsRequest) ProtoMessage()               {}
func (*SearchVariantsRequest) Descriptor() ([]byte, []int) { return fileDescriptor11, []int{15} }

func (m *SearchVariantsRequest) GetVariantSetIds() []string {
	if m != nil {
		return m.VariantSetIds
	}
	return nil
}

func (m *SearchVariantsRequest) GetVariantName() string {
	if m != nil {
		return m.VariantName
	}
	return ""
}

func (m *SearchVariantsRequest) GetCallSetIds() []string {
	if m != nil {
		return m.CallSetIds
	}
	return nil
}

func (m *SearchVariantsRequest) GetReferenceName() string {
	if m != nil {
		return m.ReferenceName
	}
	return ""
}

func (m *SearchVariantsRequest) GetStart() int64 {
	if m != nil {
		return m.Start
	}
	return 0
}

func (m *SearchVariantsRequest) GetEnd() int64 {
	if m != nil {
		return m.End
	}
	return 0
}

func (m *SearchVariantsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *SearchVariantsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *SearchVariantsRequest) GetMaxCalls() int32 {
	if m != nil {
		return m.MaxCalls
	}
	return 0
}

// The variant search response.
type SearchVariantsResponse struct {
	// The list of matching Variants.
	Variants []*Variant `protobuf:"bytes,1,rep,name=variants" json:"variants,omitempty"`
	// The continuation token, which is used to page through large result sets.
	// Provide this value in a subsequent request to return the next page of
	// results. This field will be empty if there aren't any additional results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *SearchVariantsResponse) Reset()                    { *m = SearchVariantsResponse{} }
func (m *SearchVariantsResponse) String() string            { return proto.CompactTextString(m) }
func (*SearchVariantsResponse) ProtoMessage()               {}
func (*SearchVariantsResponse) Descriptor() ([]byte, []int) { return fileDescriptor11, []int{16} }

func (m *SearchVariantsResponse) GetVariants() []*Variant {
	if m != nil {
		return m.Variants
	}
	return nil
}

func (m *SearchVariantsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

type CreateVariantRequest struct {
	// The variant to be created.
	Variant *Variant `protobuf:"bytes,1,opt,name=variant" json:"variant,omitempty"`
}

func (m *CreateVariantRequest) Reset()                    { *m = CreateVariantRequest{} }
func (m *CreateVariantRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateVariantRequest) ProtoMessage()               {}
func (*CreateVariantRequest) Descriptor() ([]byte, []int) { return fileDescriptor11, []int{17} }

func (m *CreateVariantRequest) GetVariant() *Variant {
	if m != nil {
		return m.Variant
	}
	return nil
}

type UpdateVariantRequest struct {
	// The ID of the variant to be updated.
	VariantId string `protobuf:"bytes,1,opt,name=variant_id,json=variantId" json:"variant_id,omitempty"`
	// The new variant data.
	Variant *Variant `protobuf:"bytes,2,opt,name=variant" json:"variant,omitempty"`
	// An optional mask specifying which fields to update. At this time, mutable
	// fields are [names][google.genomics.v1.Variant.names] and
	// [info][google.genomics.v1.Variant.info]. Acceptable values are "names" and
	// "info". If unspecified, all mutable fields will be updated.
	UpdateMask *google_protobuf2.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask" json:"update_mask,omitempty"`
}

func (m *UpdateVariantRequest) Reset()                    { *m = UpdateVariantRequest{} }
func (m *UpdateVariantRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateVariantRequest) ProtoMessage()               {}
func (*UpdateVariantRequest) Descriptor() ([]byte, []int) { return fileDescriptor11, []int{18} }

func (m *UpdateVariantRequest) GetVariantId() string {
	if m != nil {
		return m.VariantId
	}
	return ""
}

func (m *UpdateVariantRequest) GetVariant() *Variant {
	if m != nil {
		return m.Variant
	}
	return nil
}

func (m *UpdateVariantRequest) GetUpdateMask() *google_protobuf2.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

type DeleteVariantRequest struct {
	// The ID of the variant to be deleted.
	VariantId string `protobuf:"bytes,1,opt,name=variant_id,json=variantId" json:"variant_id,omitempty"`
}

func (m *DeleteVariantRequest) Reset()                    { *m = DeleteVariantRequest{} }
func (m *DeleteVariantRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteVariantRequest) ProtoMessage()               {}
func (*DeleteVariantRequest) Descriptor() ([]byte, []int) { return fileDescriptor11, []int{19} }

func (m *DeleteVariantRequest) GetVariantId() string {
	if m != nil {
		return m.VariantId
	}
	return ""
}

type GetVariantRequest struct {
	// The ID of the variant.
	VariantId string `protobuf:"bytes,1,opt,name=variant_id,json=variantId" json:"variant_id,omitempty"`
}

func (m *GetVariantRequest) Reset()                    { *m = GetVariantRequest{} }
func (m *GetVariantRequest) String() string            { return proto.CompactTextString(m) }
func (*GetVariantRequest) ProtoMessage()               {}
func (*GetVariantRequest) Descriptor() ([]byte, []int) { return fileDescriptor11, []int{20} }

func (m *GetVariantRequest) GetVariantId() string {
	if m != nil {
		return m.VariantId
	}
	return ""
}

type MergeVariantsRequest struct {
	// The destination variant set.
	VariantSetId string `protobuf:"bytes,1,opt,name=variant_set_id,json=variantSetId" json:"variant_set_id,omitempty"`
	// The variants to be merged with existing variants.
	Variants []*Variant `protobuf:"bytes,2,rep,name=variants" json:"variants,omitempty"`
	// A mapping between info field keys and the InfoMergeOperations to
	// be performed on them.
	InfoMergeConfig map[string]InfoMergeOperation `protobuf:"bytes,3,rep,name=info_merge_config,json=infoMergeConfig" json:"info_merge_config,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"varint,2,opt,name=value,enum=google.genomics.v1.InfoMergeOperation"`
}

func (m *MergeVariantsRequest) Reset()                    { *m = MergeVariantsRequest{} }
func (m *MergeVariantsRequest) String() string            { return proto.CompactTextString(m) }
func (*MergeVariantsRequest) ProtoMessage()               {}
func (*MergeVariantsRequest) Descriptor() ([]byte, []int) { return fileDescriptor11, []int{21} }

func (m *MergeVariantsRequest) GetVariantSetId() string {
	if m != nil {
		return m.VariantSetId
	}
	return ""
}

func (m *MergeVariantsRequest) GetVariants() []*Variant {
	if m != nil {
		return m.Variants
	}
	return nil
}

func (m *MergeVariantsRequest) GetInfoMergeConfig() map[string]InfoMergeOperation {
	if m != nil {
		return m.InfoMergeConfig
	}
	return nil
}

// The call set search request.
type SearchCallSetsRequest struct {
	// Restrict the query to call sets within the given variant sets. At least one
	// ID must be provided.
	VariantSetIds []string `protobuf:"bytes,1,rep,name=variant_set_ids,json=variantSetIds" json:"variant_set_ids,omitempty"`
	// Only return call sets for which a substring of the name matches this
	// string.
	Name string `protobuf:"bytes,2,opt,name=name" json:"name,omitempty"`
	// The continuation token, which is used to page through large result sets.
	// To get the next page of results, set this parameter to the value of
	// `nextPageToken` from the previous response.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken" json:"page_token,omitempty"`
	// The maximum number of results to return in a single page. If unspecified,
	// defaults to 1024.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize" json:"page_size,omitempty"`
}

func (m *SearchCallSetsRequest) Reset()                    { *m = SearchCallSetsRequest{} }
func (m *SearchCallSetsRequest) String() string            { return proto.CompactTextString(m) }
func (*SearchCallSetsRequest) ProtoMessage()               {}
func (*SearchCallSetsRequest) Descriptor() ([]byte, []int) { return fileDescriptor11, []int{22} }

func (m *SearchCallSetsRequest) GetVariantSetIds() []string {
	if m != nil {
		return m.VariantSetIds
	}
	return nil
}

func (m *SearchCallSetsRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *SearchCallSetsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *SearchCallSetsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

// The call set search response.
type SearchCallSetsResponse struct {
	// The list of matching call sets.
	CallSets []*CallSet `protobuf:"bytes,1,rep,name=call_sets,json=callSets" json:"call_sets,omitempty"`
	// The continuation token, which is used to page through large result sets.
	// Provide this value in a subsequent request to return the next page of
	// results. This field will be empty if there aren't any additional results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken" json:"next_page_token,omitempty"`
}

func (m *SearchCallSetsResponse) Reset()                    { *m = SearchCallSetsResponse{} }
func (m *SearchCallSetsResponse) String() string            { return proto.CompactTextString(m) }
func (*SearchCallSetsResponse) ProtoMessage()               {}
func (*SearchCallSetsResponse) Descriptor() ([]byte, []int) { return fileDescriptor11, []int{23} }

func (m *SearchCallSetsResponse) GetCallSets() []*CallSet {
	if m != nil {
		return m.CallSets
	}
	return nil
}

func (m *SearchCallSetsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

type CreateCallSetRequest struct {
	// The call set to be created.
	CallSet *CallSet `protobuf:"bytes,1,opt,name=call_set,json=callSet" json:"call_set,omitempty"`
}

func (m *CreateCallSetRequest) Reset()                    { *m = CreateCallSetRequest{} }
func (m *CreateCallSetRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateCallSetRequest) ProtoMessage()               {}
func (*CreateCallSetRequest) Descriptor() ([]byte, []int) { return fileDescriptor11, []int{24} }

func (m *CreateCallSetRequest) GetCallSet() *CallSet {
	if m != nil {
		return m.CallSet
	}
	return nil
}

type UpdateCallSetRequest struct {
	// The ID of the call set to be updated.
	CallSetId string `protobuf:"bytes,1,opt,name=call_set_id,json=callSetId" json:"call_set_id,omitempty"`
	// The new call set data.
	CallSet *CallSet `protobuf:"bytes,2,opt,name=call_set,json=callSet" json:"call_set,omitempty"`
	// An optional mask specifying which fields to update. At this time, the only
	// mutable field is [name][google.genomics.v1.CallSet.name]. The only
	// acceptable value is "name". If unspecified, all mutable fields will be
	// updated.
	UpdateMask *google_protobuf2.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask" json:"update_mask,omitempty"`
}

func (m *UpdateCallSetRequest) Reset()                    { *m = UpdateCallSetRequest{} }
func (m *UpdateCallSetRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateCallSetRequest) ProtoMessage()               {}
func (*UpdateCallSetRequest) Descriptor() ([]byte, []int) { return fileDescriptor11, []int{25} }

func (m *UpdateCallSetRequest) GetCallSetId() string {
	if m != nil {
		return m.CallSetId
	}
	return ""
}

func (m *UpdateCallSetRequest) GetCallSet() *CallSet {
	if m != nil {
		return m.CallSet
	}
	return nil
}

func (m *UpdateCallSetRequest) GetUpdateMask() *google_protobuf2.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

type DeleteCallSetRequest struct {
	// The ID of the call set to be deleted.
	CallSetId string `protobuf:"bytes,1,opt,name=call_set_id,json=callSetId" json:"call_set_id,omitempty"`
}

func (m *DeleteCallSetRequest) Reset()                    { *m = DeleteCallSetRequest{} }
func (m *DeleteCallSetRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteCallSetRequest) ProtoMessage()               {}
func (*DeleteCallSetRequest) Descriptor() ([]byte, []int) { return fileDescriptor11, []int{26} }

func (m *DeleteCallSetRequest) GetCallSetId() string {
	if m != nil {
		return m.CallSetId
	}
	return ""
}

type GetCallSetRequest struct {
	// The ID of the call set.
	CallSetId string `protobuf:"bytes,1,opt,name=call_set_id,json=callSetId" json:"call_set_id,omitempty"`
}

func (m *GetCallSetRequest) Reset()                    { *m = GetCallSetRequest{} }
func (m *GetCallSetRequest) String() string            { return proto.CompactTextString(m) }
func (*GetCallSetRequest) ProtoMessage()               {}
func (*GetCallSetRequest) Descriptor() ([]byte, []int) { return fileDescriptor11, []int{27} }

func (m *GetCallSetRequest) GetCallSetId() string {
	if m != nil {
		return m.CallSetId
	}
	return ""
}

// The stream variants request.
type StreamVariantsRequest struct {
	// The Google Cloud project ID which will be billed
	// for this access. The caller must have WRITE access to this project.
	// Required.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId" json:"project_id,omitempty"`
	// The variant set ID from which to stream variants.
	VariantSetId string `protobuf:"bytes,2,opt,name=variant_set_id,json=variantSetId" json:"variant_set_id,omitempty"`
	// Only return variant calls which belong to call sets with these IDs.
	// Leaving this blank returns all variant calls.
	CallSetIds []string `protobuf:"bytes,3,rep,name=call_set_ids,json=callSetIds" json:"call_set_ids,omitempty"`
	// Required. Only return variants in this reference sequence.
	ReferenceName string `protobuf:"bytes,4,opt,name=reference_name,json=referenceName" json:"reference_name,omitempty"`
	// The beginning of the window (0-based, inclusive) for which
	// overlapping variants should be returned.
	Start int64 `protobuf:"varint,5,opt,name=start" json:"start,omitempty"`
	// The end of the window (0-based, exclusive) for which overlapping
	// variants should be returned.
	End int64 `protobuf:"varint,6,opt,name=end" json:"end,omitempty"`
}

func (m *StreamVariantsRequest) Reset()                    { *m = StreamVariantsRequest{} }
func (m *StreamVariantsRequest) String() string            { return proto.CompactTextString(m) }
func (*StreamVariantsRequest) ProtoMessage()               {}
func (*StreamVariantsRequest) Descriptor() ([]byte, []int) { return fileDescriptor11, []int{28} }

func (m *StreamVariantsRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *StreamVariantsRequest) GetVariantSetId() string {
	if m != nil {
		return m.VariantSetId
	}
	return ""
}

func (m *StreamVariantsRequest) GetCallSetIds() []string {
	if m != nil {
		return m.CallSetIds
	}
	return nil
}

func (m *StreamVariantsRequest) GetReferenceName() string {
	if m != nil {
		return m.ReferenceName
	}
	return ""
}

func (m *StreamVariantsRequest) GetStart() int64 {
	if m != nil {
		return m.Start
	}
	return 0
}

func (m *StreamVariantsRequest) GetEnd() int64 {
	if m != nil {
		return m.End
	}
	return 0
}

type StreamVariantsResponse struct {
	Variants []*Variant `protobuf:"bytes,1,rep,name=variants" json:"variants,omitempty"`
}

func (m *StreamVariantsResponse) Reset()                    { *m = StreamVariantsResponse{} }
func (m *StreamVariantsResponse) String() string            { return proto.CompactTextString(m) }
func (*StreamVariantsResponse) ProtoMessage()               {}
func (*StreamVariantsResponse) Descriptor() ([]byte, []int) { return fileDescriptor11, []int{29} }

func (m *StreamVariantsResponse) GetVariants() []*Variant {
	if m != nil {
		return m.Variants
	}
	return nil
}

func init() {
	proto.RegisterType((*VariantSetMetadata)(nil), "google.genomics.v1.VariantSetMetadata")
	proto.RegisterType((*VariantSet)(nil), "google.genomics.v1.VariantSet")
	proto.RegisterType((*Variant)(nil), "google.genomics.v1.Variant")
	proto.RegisterType((*VariantCall)(nil), "google.genomics.v1.VariantCall")
	proto.RegisterType((*CallSet)(nil), "google.genomics.v1.CallSet")
	proto.RegisterType((*ReferenceBound)(nil), "google.genomics.v1.ReferenceBound")
	proto.RegisterType((*ImportVariantsRequest)(nil), "google.genomics.v1.ImportVariantsRequest")
	proto.RegisterType((*ImportVariantsResponse)(nil), "google.genomics.v1.ImportVariantsResponse")
	proto.RegisterType((*CreateVariantSetRequest)(nil), "google.genomics.v1.CreateVariantSetRequest")
	proto.RegisterType((*ExportVariantSetRequest)(nil), "google.genomics.v1.ExportVariantSetRequest")
	proto.RegisterType((*GetVariantSetRequest)(nil), "google.genomics.v1.GetVariantSetRequest")
	proto.RegisterType((*SearchVariantSetsRequest)(nil), "google.genomics.v1.SearchVariantSetsRequest")
	proto.RegisterType((*SearchVariantSetsResponse)(nil), "google.genomics.v1.SearchVariantSetsResponse")
	proto.RegisterType((*DeleteVariantSetRequest)(nil), "google.genomics.v1.DeleteVariantSetRequest")
	proto.RegisterType((*UpdateVariantSetRequest)(nil), "google.genomics.v1.UpdateVariantSetRequest")
	proto.RegisterType((*SearchVariantsRequest)(nil), "google.genomics.v1.SearchVariantsRequest")
	proto.RegisterType((*SearchVariantsResponse)(nil), "google.genomics.v1.SearchVariantsResponse")
	proto.RegisterType((*CreateVariantRequest)(nil), "google.genomics.v1.CreateVariantRequest")
	proto.RegisterType((*UpdateVariantRequest)(nil), "google.genomics.v1.UpdateVariantRequest")
	proto.RegisterType((*DeleteVariantRequest)(nil), "google.genomics.v1.DeleteVariantRequest")
	proto.RegisterType((*GetVariantRequest)(nil), "google.genomics.v1.GetVariantRequest")
	proto.RegisterType((*MergeVariantsRequest)(nil), "google.genomics.v1.MergeVariantsRequest")
	proto.RegisterType((*SearchCallSetsRequest)(nil), "google.genomics.v1.SearchCallSetsRequest")
	proto.RegisterType((*SearchCallSetsResponse)(nil), "google.genomics.v1.SearchCallSetsResponse")
	proto.RegisterType((*CreateCallSetRequest)(nil), "google.genomics.v1.CreateCallSetRequest")
	proto.RegisterType((*UpdateCallSetRequest)(nil), "google.genomics.v1.UpdateCallSetRequest")
	proto.RegisterType((*DeleteCallSetRequest)(nil), "google.genomics.v1.DeleteCallSetRequest")
	proto.RegisterType((*GetCallSetRequest)(nil), "google.genomics.v1.GetCallSetRequest")
	proto.RegisterType((*StreamVariantsRequest)(nil), "google.genomics.v1.StreamVariantsRequest")
	proto.RegisterType((*StreamVariantsResponse)(nil), "google.genomics.v1.StreamVariantsResponse")
	proto.RegisterEnum("google.genomics.v1.InfoMergeOperation", InfoMergeOperation_name, InfoMergeOperation_value)
	proto.RegisterEnum("google.genomics.v1.VariantSetMetadata_Type", VariantSetMetadata_Type_name, VariantSetMetadata_Type_value)
	proto.RegisterEnum("google.genomics.v1.ImportVariantsRequest_Format", ImportVariantsRequest_Format_name, ImportVariantsRequest_Format_value)
	proto.RegisterEnum("google.genomics.v1.ExportVariantSetRequest_Format", ExportVariantSetRequest_Format_name, ExportVariantSetRequest_Format_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for StreamingVariantService service

type StreamingVariantServiceClient interface {
	// Returns a stream of all the variants matching the search request, ordered
	// by reference name, position, and ID.
	StreamVariants(ctx context.Context, in *StreamVariantsRequest, opts ...grpc.CallOption) (StreamingVariantService_StreamVariantsClient, error)
}

type streamingVariantServiceClient struct {
	cc *grpc.ClientConn
}

func NewStreamingVariantServiceClient(cc *grpc.ClientConn) StreamingVariantServiceClient {
	return &streamingVariantServiceClient{cc}
}

func (c *streamingVariantServiceClient) StreamVariants(ctx context.Context, in *StreamVariantsRequest, opts ...grpc.CallOption) (StreamingVariantService_StreamVariantsClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_StreamingVariantService_serviceDesc.Streams[0], c.cc, "/google.genomics.v1.StreamingVariantService/StreamVariants", opts...)
	if err != nil {
		return nil, err
	}
	x := &streamingVariantServiceStreamVariantsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type StreamingVariantService_StreamVariantsClient interface {
	Recv() (*StreamVariantsResponse, error)
	grpc.ClientStream
}

type streamingVariantServiceStreamVariantsClient struct {
	grpc.ClientStream
}

func (x *streamingVariantServiceStreamVariantsClient) Recv() (*StreamVariantsResponse, error) {
	m := new(StreamVariantsResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// Server API for StreamingVariantService service

type StreamingVariantServiceServer interface {
	// Returns a stream of all the variants matching the search request, ordered
	// by reference name, position, and ID.
	StreamVariants(*StreamVariantsRequest, StreamingVariantService_StreamVariantsServer) error
}

func RegisterStreamingVariantServiceServer(s *grpc.Server, srv StreamingVariantServiceServer) {
	s.RegisterService(&_StreamingVariantService_serviceDesc, srv)
}

func _StreamingVariantService_StreamVariants_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(StreamVariantsRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(StreamingVariantServiceServer).StreamVariants(m, &streamingVariantServiceStreamVariantsServer{stream})
}

type StreamingVariantService_StreamVariantsServer interface {
	Send(*StreamVariantsResponse) error
	grpc.ServerStream
}

type streamingVariantServiceStreamVariantsServer struct {
	grpc.ServerStream
}

func (x *streamingVariantServiceStreamVariantsServer) Send(m *StreamVariantsResponse) error {
	return x.ServerStream.SendMsg(m)
}

var _StreamingVariantService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.genomics.v1.StreamingVariantService",
	HandlerType: (*StreamingVariantServiceServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "StreamVariants",
			Handler:       _StreamingVariantService_StreamVariants_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "google/genomics/v1/variants.proto",
}

// Client API for VariantServiceV1 service

type VariantServiceV1Client interface {
	// Creates variant data by asynchronously importing the provided information.
	//
	// For the definitions of variant sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// The variants for import will be merged with any existing variant that
	// matches its reference sequence, start, end, reference bases, and
	// alternative bases. If no such variant exists, a new one will be created.
	//
	// When variants are merged, the call information from the new variant
	// is added to the existing variant, and Variant info fields are merged
	// as specified in
	// [infoMergeConfig][google.genomics.v1.ImportVariantsRequest.info_merge_config].
	// As a special case, for single-sample VCF files, QUAL and FILTER fields will
	// be moved to the call level; these are sometimes interpreted in a
	// call-specific context.
	// Imported VCF headers are appended to the metadata already in a variant set.
	ImportVariants(ctx context.Context, in *ImportVariantsRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
	// Creates a new variant set.
	//
	// For the definitions of variant sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// The provided variant set must have a valid `datasetId` set - all other
	// fields are optional. Note that the `id` field will be ignored, as this is
	// assigned by the server.
	CreateVariantSet(ctx context.Context, in *CreateVariantSetRequest, opts ...grpc.CallOption) (*VariantSet, error)
	// Exports variant set data to an external destination.
	//
	// For the definitions of variant sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	ExportVariantSet(ctx context.Context, in *ExportVariantSetRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error)
	// Gets a variant set by ID.
	//
	// For the definitions of variant sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	GetVariantSet(ctx context.Context, in *GetVariantSetRequest, opts ...grpc.CallOption) (*VariantSet, error)
	// Returns a list of all variant sets matching search criteria.
	//
	// For the definitions of variant sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// Implements
	// [GlobalAllianceApi.searchVariantSets](https://github.com/ga4gh/schemas/blob/v0.5.1/src/main/resources/avro/variantmethods.avdl#L49).
	SearchVariantSets(ctx context.Context, in *SearchVariantSetsRequest, opts ...grpc.CallOption) (*SearchVariantSetsResponse, error)
	// Deletes a variant set including all variants, call sets, and calls within.
	// This is not reversible.
	//
	// For the definitions of variant sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	DeleteVariantSet(ctx context.Context, in *DeleteVariantSetRequest, opts ...grpc.CallOption) (*google_protobuf1.Empty, error)
	// Updates a variant set using patch semantics.
	//
	// For the definitions of variant sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	UpdateVariantSet(ctx context.Context, in *UpdateVariantSetRequest, opts ...grpc.CallOption) (*VariantSet, error)
	// Gets a list of variants matching the criteria.
	//
	// For the definitions of variants and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// Implements
	// [GlobalAllianceApi.searchVariants](https://github.com/ga4gh/schemas/blob/v0.5.1/src/main/resources/avro/variantmethods.avdl#L126).
	SearchVariants(ctx context.Context, in *SearchVariantsRequest, opts ...grpc.CallOption) (*SearchVariantsResponse, error)
	// Creates a new variant.
	//
	// For the definitions of variants and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	CreateVariant(ctx context.Context, in *CreateVariantRequest, opts ...grpc.CallOption) (*Variant, error)
	// Updates a variant.
	//
	// For the definitions of variants and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// This method supports patch semantics. Returns the modified variant without
	// its calls.
	UpdateVariant(ctx context.Context, in *UpdateVariantRequest, opts ...grpc.CallOption) (*Variant, error)
	// Deletes a variant.
	//
	// For the definitions of variants and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	DeleteVariant(ctx context.Context, in *DeleteVariantRequest, opts ...grpc.CallOption) (*google_protobuf1.Empty, error)
	// Gets a variant by ID.
	//
	// For the definitions of variants and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	GetVariant(ctx context.Context, in *GetVariantRequest, opts ...grpc.CallOption) (*Variant, error)
	// Merges the given variants with existing variants.
	//
	// For the definitions of variants and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// Each variant will be
	// merged with an existing variant that matches its reference sequence,
	// start, end, reference bases, and alternative bases. If no such variant
	// exists, a new one will be created.
	//
	// When variants are merged, the call information from the new variant
	// is added to the existing variant. Variant info fields are merged as
	// specified in the
	// [infoMergeConfig][google.genomics.v1.MergeVariantsRequest.info_merge_config]
	// field of the MergeVariantsRequest.
	//
	// Please exercise caution when using this method!  It is easy to introduce
	// mistakes in existing variants and difficult to back out of them.  For
	// example,
	// suppose you were trying to merge a new variant with an existing one and
	// both
	// variants contain calls that belong to callsets with the same callset ID.
	//
	//     // Existing variant - irrelevant fields trimmed for clarity
	//     {
	//         "variantSetId": "10473108253681171589",
	//         "referenceName": "1",
	//         "start": "10582",
	//         "referenceBases": "G",
	//         "alternateBases": [
	//             "A"
	//         ],
	//         "calls": [
	//             {
	//                 "callSetId": "10473108253681171589-0",
	//                 "callSetName": "CALLSET0",
	//                 "genotype": [
	//                     0,
	//                     1
	//                 ],
	//             }
	//         ]
	//     }
	//
	//     // New variant with conflicting call information
	//     {
	//         "variantSetId": "10473108253681171589",
	//         "referenceName": "1",
	//         "start": "10582",
	//         "referenceBases": "G",
	//         "alternateBases": [
	//             "A"
	//         ],
	//         "calls": [
	//             {
	//                 "callSetId": "10473108253681171589-0",
	//                 "callSetName": "CALLSET0",
	//                 "genotype": [
	//                     1,
	//                     1
	//                 ],
	//             }
	//         ]
	//     }
	//
	// The resulting merged variant would overwrite the existing calls with those
	// from the new variant:
	//
	//     {
	//         "variantSetId": "10473108253681171589",
	//         "referenceName": "1",
	//         "start": "10582",
	//         "referenceBases": "G",
	//         "alternateBases": [
	//             "A"
	//         ],
	//         "calls": [
	//             {
	//                 "callSetId": "10473108253681171589-0",
	//                 "callSetName": "CALLSET0",
	//                 "genotype": [
	//                     1,
	//                     1
	//                 ],
	//             }
	//         ]
	//     }
	//
	// This may be the desired outcome, but it is up to the user to determine if
	// if that is indeed the case.
	MergeVariants(ctx context.Context, in *MergeVariantsRequest, opts ...grpc.CallOption) (*google_protobuf1.Empty, error)
	// Gets a list of call sets matching the criteria.
	//
	// For the definitions of call sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// Implements
	// [GlobalAllianceApi.searchCallSets](https://github.com/ga4gh/schemas/blob/v0.5.1/src/main/resources/avro/variantmethods.avdl#L178).
	SearchCallSets(ctx context.Context, in *SearchCallSetsRequest, opts ...grpc.CallOption) (*SearchCallSetsResponse, error)
	// Creates a new call set.
	//
	// For the definitions of call sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	CreateCallSet(ctx context.Context, in *CreateCallSetRequest, opts ...grpc.CallOption) (*CallSet, error)
	// Updates a call set.
	//
	// For the definitions of call sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// This method supports patch semantics.
	UpdateCallSet(ctx context.Context, in *UpdateCallSetRequest, opts ...grpc.CallOption) (*CallSet, error)
	// Deletes a call set.
	//
	// For the definitions of call sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	DeleteCallSet(ctx context.Context, in *DeleteCallSetRequest, opts ...grpc.CallOption) (*google_protobuf1.Empty, error)
	// Gets a call set by ID.
	//
	// For the definitions of call sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	GetCallSet(ctx context.Context, in *GetCallSetRequest, opts ...grpc.CallOption) (*CallSet, error)
}

type variantServiceV1Client struct {
	cc *grpc.ClientConn
}

func NewVariantServiceV1Client(cc *grpc.ClientConn) VariantServiceV1Client {
	return &variantServiceV1Client{cc}
}

func (c *variantServiceV1Client) ImportVariants(ctx context.Context, in *ImportVariantsRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.genomics.v1.VariantServiceV1/ImportVariants", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *variantServiceV1Client) CreateVariantSet(ctx context.Context, in *CreateVariantSetRequest, opts ...grpc.CallOption) (*VariantSet, error) {
	out := new(VariantSet)
	err := grpc.Invoke(ctx, "/google.genomics.v1.VariantServiceV1/CreateVariantSet", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *variantServiceV1Client) ExportVariantSet(ctx context.Context, in *ExportVariantSetRequest, opts ...grpc.CallOption) (*google_longrunning.Operation, error) {
	out := new(google_longrunning.Operation)
	err := grpc.Invoke(ctx, "/google.genomics.v1.VariantServiceV1/ExportVariantSet", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *variantServiceV1Client) GetVariantSet(ctx context.Context, in *GetVariantSetRequest, opts ...grpc.CallOption) (*VariantSet, error) {
	out := new(VariantSet)
	err := grpc.Invoke(ctx, "/google.genomics.v1.VariantServiceV1/GetVariantSet", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *variantServiceV1Client) SearchVariantSets(ctx context.Context, in *SearchVariantSetsRequest, opts ...grpc.CallOption) (*SearchVariantSetsResponse, error) {
	out := new(SearchVariantSetsResponse)
	err := grpc.Invoke(ctx, "/google.genomics.v1.VariantServiceV1/SearchVariantSets", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *variantServiceV1Client) DeleteVariantSet(ctx context.Context, in *DeleteVariantSetRequest, opts ...grpc.CallOption) (*google_protobuf1.Empty, error) {
	out := new(google_protobuf1.Empty)
	err := grpc.Invoke(ctx, "/google.genomics.v1.VariantServiceV1/DeleteVariantSet", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *variantServiceV1Client) UpdateVariantSet(ctx context.Context, in *UpdateVariantSetRequest, opts ...grpc.CallOption) (*VariantSet, error) {
	out := new(VariantSet)
	err := grpc.Invoke(ctx, "/google.genomics.v1.VariantServiceV1/UpdateVariantSet", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *variantServiceV1Client) SearchVariants(ctx context.Context, in *SearchVariantsRequest, opts ...grpc.CallOption) (*SearchVariantsResponse, error) {
	out := new(SearchVariantsResponse)
	err := grpc.Invoke(ctx, "/google.genomics.v1.VariantServiceV1/SearchVariants", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *variantServiceV1Client) CreateVariant(ctx context.Context, in *CreateVariantRequest, opts ...grpc.CallOption) (*Variant, error) {
	out := new(Variant)
	err := grpc.Invoke(ctx, "/google.genomics.v1.VariantServiceV1/CreateVariant", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *variantServiceV1Client) UpdateVariant(ctx context.Context, in *UpdateVariantRequest, opts ...grpc.CallOption) (*Variant, error) {
	out := new(Variant)
	err := grpc.Invoke(ctx, "/google.genomics.v1.VariantServiceV1/UpdateVariant", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *variantServiceV1Client) DeleteVariant(ctx context.Context, in *DeleteVariantRequest, opts ...grpc.CallOption) (*google_protobuf1.Empty, error) {
	out := new(google_protobuf1.Empty)
	err := grpc.Invoke(ctx, "/google.genomics.v1.VariantServiceV1/DeleteVariant", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *variantServiceV1Client) GetVariant(ctx context.Context, in *GetVariantRequest, opts ...grpc.CallOption) (*Variant, error) {
	out := new(Variant)
	err := grpc.Invoke(ctx, "/google.genomics.v1.VariantServiceV1/GetVariant", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *variantServiceV1Client) MergeVariants(ctx context.Context, in *MergeVariantsRequest, opts ...grpc.CallOption) (*google_protobuf1.Empty, error) {
	out := new(google_protobuf1.Empty)
	err := grpc.Invoke(ctx, "/google.genomics.v1.VariantServiceV1/MergeVariants", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *variantServiceV1Client) SearchCallSets(ctx context.Context, in *SearchCallSetsRequest, opts ...grpc.CallOption) (*SearchCallSetsResponse, error) {
	out := new(SearchCallSetsResponse)
	err := grpc.Invoke(ctx, "/google.genomics.v1.VariantServiceV1/SearchCallSets", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *variantServiceV1Client) CreateCallSet(ctx context.Context, in *CreateCallSetRequest, opts ...grpc.CallOption) (*CallSet, error) {
	out := new(CallSet)
	err := grpc.Invoke(ctx, "/google.genomics.v1.VariantServiceV1/CreateCallSet", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *variantServiceV1Client) UpdateCallSet(ctx context.Context, in *UpdateCallSetRequest, opts ...grpc.CallOption) (*CallSet, error) {
	out := new(CallSet)
	err := grpc.Invoke(ctx, "/google.genomics.v1.VariantServiceV1/UpdateCallSet", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *variantServiceV1Client) DeleteCallSet(ctx context.Context, in *DeleteCallSetRequest, opts ...grpc.CallOption) (*google_protobuf1.Empty, error) {
	out := new(google_protobuf1.Empty)
	err := grpc.Invoke(ctx, "/google.genomics.v1.VariantServiceV1/DeleteCallSet", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *variantServiceV1Client) GetCallSet(ctx context.Context, in *GetCallSetRequest, opts ...grpc.CallOption) (*CallSet, error) {
	out := new(CallSet)
	err := grpc.Invoke(ctx, "/google.genomics.v1.VariantServiceV1/GetCallSet", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for VariantServiceV1 service

type VariantServiceV1Server interface {
	// Creates variant data by asynchronously importing the provided information.
	//
	// For the definitions of variant sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// The variants for import will be merged with any existing variant that
	// matches its reference sequence, start, end, reference bases, and
	// alternative bases. If no such variant exists, a new one will be created.
	//
	// When variants are merged, the call information from the new variant
	// is added to the existing variant, and Variant info fields are merged
	// as specified in
	// [infoMergeConfig][google.genomics.v1.ImportVariantsRequest.info_merge_config].
	// As a special case, for single-sample VCF files, QUAL and FILTER fields will
	// be moved to the call level; these are sometimes interpreted in a
	// call-specific context.
	// Imported VCF headers are appended to the metadata already in a variant set.
	ImportVariants(context.Context, *ImportVariantsRequest) (*google_longrunning.Operation, error)
	// Creates a new variant set.
	//
	// For the definitions of variant sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// The provided variant set must have a valid `datasetId` set - all other
	// fields are optional. Note that the `id` field will be ignored, as this is
	// assigned by the server.
	CreateVariantSet(context.Context, *CreateVariantSetRequest) (*VariantSet, error)
	// Exports variant set data to an external destination.
	//
	// For the definitions of variant sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	ExportVariantSet(context.Context, *ExportVariantSetRequest) (*google_longrunning.Operation, error)
	// Gets a variant set by ID.
	//
	// For the definitions of variant sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	GetVariantSet(context.Context, *GetVariantSetRequest) (*VariantSet, error)
	// Returns a list of all variant sets matching search criteria.
	//
	// For the definitions of variant sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// Implements
	// [GlobalAllianceApi.searchVariantSets](https://github.com/ga4gh/schemas/blob/v0.5.1/src/main/resources/avro/variantmethods.avdl#L49).
	SearchVariantSets(context.Context, *SearchVariantSetsRequest) (*SearchVariantSetsResponse, error)
	// Deletes a variant set including all variants, call sets, and calls within.
	// This is not reversible.
	//
	// For the definitions of variant sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	DeleteVariantSet(context.Context, *DeleteVariantSetRequest) (*google_protobuf1.Empty, error)
	// Updates a variant set using patch semantics.
	//
	// For the definitions of variant sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	UpdateVariantSet(context.Context, *UpdateVariantSetRequest) (*VariantSet, error)
	// Gets a list of variants matching the criteria.
	//
	// For the definitions of variants and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// Implements
	// [GlobalAllianceApi.searchVariants](https://github.com/ga4gh/schemas/blob/v0.5.1/src/main/resources/avro/variantmethods.avdl#L126).
	SearchVariants(context.Context, *SearchVariantsRequest) (*SearchVariantsResponse, error)
	// Creates a new variant.
	//
	// For the definitions of variants and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	CreateVariant(context.Context, *CreateVariantRequest) (*Variant, error)
	// Updates a variant.
	//
	// For the definitions of variants and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// This method supports patch semantics. Returns the modified variant without
	// its calls.
	UpdateVariant(context.Context, *UpdateVariantRequest) (*Variant, error)
	// Deletes a variant.
	//
	// For the definitions of variants and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	DeleteVariant(context.Context, *DeleteVariantRequest) (*google_protobuf1.Empty, error)
	// Gets a variant by ID.
	//
	// For the definitions of variants and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	GetVariant(context.Context, *GetVariantRequest) (*Variant, error)
	// Merges the given variants with existing variants.
	//
	// For the definitions of variants and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// Each variant will be
	// merged with an existing variant that matches its reference sequence,
	// start, end, reference bases, and alternative bases. If no such variant
	// exists, a new one will be created.
	//
	// When variants are merged, the call information from the new variant
	// is added to the existing variant. Variant info fields are merged as
	// specified in the
	// [infoMergeConfig][google.genomics.v1.MergeVariantsRequest.info_merge_config]
	// field of the MergeVariantsRequest.
	//
	// Please exercise caution when using this method!  It is easy to introduce
	// mistakes in existing variants and difficult to back out of them.  For
	// example,
	// suppose you were trying to merge a new variant with an existing one and
	// both
	// variants contain calls that belong to callsets with the same callset ID.
	//
	//     // Existing variant - irrelevant fields trimmed for clarity
	//     {
	//         "variantSetId": "10473108253681171589",
	//         "referenceName": "1",
	//         "start": "10582",
	//         "referenceBases": "G",
	//         "alternateBases": [
	//             "A"
	//         ],
	//         "calls": [
	//             {
	//                 "callSetId": "10473108253681171589-0",
	//                 "callSetName": "CALLSET0",
	//                 "genotype": [
	//                     0,
	//                     1
	//                 ],
	//             }
	//         ]
	//     }
	//
	//     // New variant with conflicting call information
	//     {
	//         "variantSetId": "10473108253681171589",
	//         "referenceName": "1",
	//         "start": "10582",
	//         "referenceBases": "G",
	//         "alternateBases": [
	//             "A"
	//         ],
	//         "calls": [
	//             {
	//                 "callSetId": "10473108253681171589-0",
	//                 "callSetName": "CALLSET0",
	//                 "genotype": [
	//                     1,
	//                     1
	//                 ],
	//             }
	//         ]
	//     }
	//
	// The resulting merged variant would overwrite the existing calls with those
	// from the new variant:
	//
	//     {
	//         "variantSetId": "10473108253681171589",
	//         "referenceName": "1",
	//         "start": "10582",
	//         "referenceBases": "G",
	//         "alternateBases": [
	//             "A"
	//         ],
	//         "calls": [
	//             {
	//                 "callSetId": "10473108253681171589-0",
	//                 "callSetName": "CALLSET0",
	//                 "genotype": [
	//                     1,
	//                     1
	//                 ],
	//             }
	//         ]
	//     }
	//
	// This may be the desired outcome, but it is up to the user to determine if
	// if that is indeed the case.
	MergeVariants(context.Context, *MergeVariantsRequest) (*google_protobuf1.Empty, error)
	// Gets a list of call sets matching the criteria.
	//
	// For the definitions of call sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// Implements
	// [GlobalAllianceApi.searchCallSets](https://github.com/ga4gh/schemas/blob/v0.5.1/src/main/resources/avro/variantmethods.avdl#L178).
	SearchCallSets(context.Context, *SearchCallSetsRequest) (*SearchCallSetsResponse, error)
	// Creates a new call set.
	//
	// For the definitions of call sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	CreateCallSet(context.Context, *CreateCallSetRequest) (*CallSet, error)
	// Updates a call set.
	//
	// For the definitions of call sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// This method supports patch semantics.
	UpdateCallSet(context.Context, *UpdateCallSetRequest) (*CallSet, error)
	// Deletes a call set.
	//
	// For the definitions of call sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	DeleteCallSet(context.Context, *DeleteCallSetRequest) (*google_protobuf1.Empty, error)
	// Gets a call set by ID.
	//
	// For the definitions of call sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	GetCallSet(context.Context, *GetCallSetRequest) (*CallSet, error)
}

func RegisterVariantServiceV1Server(s *grpc.Server, srv VariantServiceV1Server) {
	s.RegisterService(&_VariantServiceV1_serviceDesc, srv)
}

func _VariantServiceV1_ImportVariants_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportVariantsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VariantServiceV1Server).ImportVariants(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.VariantServiceV1/ImportVariants",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VariantServiceV1Server).ImportVariants(ctx, req.(*ImportVariantsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VariantServiceV1_CreateVariantSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateVariantSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VariantServiceV1Server).CreateVariantSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.VariantServiceV1/CreateVariantSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VariantServiceV1Server).CreateVariantSet(ctx, req.(*CreateVariantSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VariantServiceV1_ExportVariantSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportVariantSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VariantServiceV1Server).ExportVariantSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.VariantServiceV1/ExportVariantSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VariantServiceV1Server).ExportVariantSet(ctx, req.(*ExportVariantSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VariantServiceV1_GetVariantSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetVariantSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VariantServiceV1Server).GetVariantSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.VariantServiceV1/GetVariantSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VariantServiceV1Server).GetVariantSet(ctx, req.(*GetVariantSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VariantServiceV1_SearchVariantSets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchVariantSetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VariantServiceV1Server).SearchVariantSets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.VariantServiceV1/SearchVariantSets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VariantServiceV1Server).SearchVariantSets(ctx, req.(*SearchVariantSetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VariantServiceV1_DeleteVariantSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteVariantSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VariantServiceV1Server).DeleteVariantSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.VariantServiceV1/DeleteVariantSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VariantServiceV1Server).DeleteVariantSet(ctx, req.(*DeleteVariantSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VariantServiceV1_UpdateVariantSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateVariantSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VariantServiceV1Server).UpdateVariantSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.VariantServiceV1/UpdateVariantSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VariantServiceV1Server).UpdateVariantSet(ctx, req.(*UpdateVariantSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VariantServiceV1_SearchVariants_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchVariantsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VariantServiceV1Server).SearchVariants(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.VariantServiceV1/SearchVariants",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VariantServiceV1Server).SearchVariants(ctx, req.(*SearchVariantsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VariantServiceV1_CreateVariant_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateVariantRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VariantServiceV1Server).CreateVariant(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.VariantServiceV1/CreateVariant",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VariantServiceV1Server).CreateVariant(ctx, req.(*CreateVariantRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VariantServiceV1_UpdateVariant_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateVariantRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VariantServiceV1Server).UpdateVariant(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.VariantServiceV1/UpdateVariant",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VariantServiceV1Server).UpdateVariant(ctx, req.(*UpdateVariantRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VariantServiceV1_DeleteVariant_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteVariantRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VariantServiceV1Server).DeleteVariant(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.VariantServiceV1/DeleteVariant",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VariantServiceV1Server).DeleteVariant(ctx, req.(*DeleteVariantRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VariantServiceV1_GetVariant_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetVariantRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VariantServiceV1Server).GetVariant(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.VariantServiceV1/GetVariant",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VariantServiceV1Server).GetVariant(ctx, req.(*GetVariantRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VariantServiceV1_MergeVariants_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MergeVariantsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VariantServiceV1Server).MergeVariants(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.VariantServiceV1/MergeVariants",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VariantServiceV1Server).MergeVariants(ctx, req.(*MergeVariantsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VariantServiceV1_SearchCallSets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchCallSetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VariantServiceV1Server).SearchCallSets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.VariantServiceV1/SearchCallSets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VariantServiceV1Server).SearchCallSets(ctx, req.(*SearchCallSetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VariantServiceV1_CreateCallSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateCallSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VariantServiceV1Server).CreateCallSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.VariantServiceV1/CreateCallSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VariantServiceV1Server).CreateCallSet(ctx, req.(*CreateCallSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VariantServiceV1_UpdateCallSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateCallSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VariantServiceV1Server).UpdateCallSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.VariantServiceV1/UpdateCallSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VariantServiceV1Server).UpdateCallSet(ctx, req.(*UpdateCallSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VariantServiceV1_DeleteCallSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteCallSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VariantServiceV1Server).DeleteCallSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.VariantServiceV1/DeleteCallSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VariantServiceV1Server).DeleteCallSet(ctx, req.(*DeleteCallSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VariantServiceV1_GetCallSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCallSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VariantServiceV1Server).GetCallSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.VariantServiceV1/GetCallSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VariantServiceV1Server).GetCallSet(ctx, req.(*GetCallSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _VariantServiceV1_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.genomics.v1.VariantServiceV1",
	HandlerType: (*VariantServiceV1Server)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ImportVariants",
			Handler:    _VariantServiceV1_ImportVariants_Handler,
		},
		{
			MethodName: "CreateVariantSet",
			Handler:    _VariantServiceV1_CreateVariantSet_Handler,
		},
		{
			MethodName: "ExportVariantSet",
			Handler:    _VariantServiceV1_ExportVariantSet_Handler,
		},
		{
			MethodName: "GetVariantSet",
			Handler:    _VariantServiceV1_GetVariantSet_Handler,
		},
		{
			MethodName: "SearchVariantSets",
			Handler:    _VariantServiceV1_SearchVariantSets_Handler,
		},
		{
			MethodName: "DeleteVariantSet",
			Handler:    _VariantServiceV1_DeleteVariantSet_Handler,
		},
		{
			MethodName: "UpdateVariantSet",
			Handler:    _VariantServiceV1_UpdateVariantSet_Handler,
		},
		{
			MethodName: "SearchVariants",
			Handler:    _VariantServiceV1_SearchVariants_Handler,
		},
		{
			MethodName: "CreateVariant",
			Handler:    _VariantServiceV1_CreateVariant_Handler,
		},
		{
			MethodName: "UpdateVariant",
			Handler:    _VariantServiceV1_UpdateVariant_Handler,
		},
		{
			MethodName: "DeleteVariant",
			Handler:    _VariantServiceV1_DeleteVariant_Handler,
		},
		{
			MethodName: "GetVariant",
			Handler:    _VariantServiceV1_GetVariant_Handler,
		},
		{
			MethodName: "MergeVariants",
			Handler:    _VariantServiceV1_MergeVariants_Handler,
		},
		{
			MethodName: "SearchCallSets",
			Handler:    _VariantServiceV1_SearchCallSets_Handler,
		},
		{
			MethodName: "CreateCallSet",
			Handler:    _VariantServiceV1_CreateCallSet_Handler,
		},
		{
			MethodName: "UpdateCallSet",
			Handler:    _VariantServiceV1_UpdateCallSet_Handler,
		},
		{
			MethodName: "DeleteCallSet",
			Handler:    _VariantServiceV1_DeleteCallSet_Handler,
		},
		{
			MethodName: "GetCallSet",
			Handler:    _VariantServiceV1_GetCallSet_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/genomics/v1/variants.proto",
}

func init() { proto.RegisterFile("google/genomics/v1/variants.proto", fileDescriptor11) }

var fileDescriptor11 = []byte{
	// 2348 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x5a, 0xdd, 0x6e, 0x1b, 0xc7,
	0xf5, 0xff, 0xef, 0x92, 0x94, 0xc8, 0x43, 0x91, 0x5a, 0x4f, 0x14, 0x69, 0x43, 0x7f, 0xc9, 0xfb,
	0xb7, 0x1d, 0x45, 0x75, 0x45, 0x9b, 0x81, 0xd3, 0x54, 0x49, 0x6a, 0x48, 0x34, 0xa5, 0xb0, 0x90,
	0x48, 0x65, 0x45, 0xbb, 0x75, 0x80, 0x82, 0x58, 0x91, 0x23, 0x7a, 0x6d, 0x72, 0x97, 0xde, 0x5d,
	0xaa, 0x96, 0x0d, 0x5f, 0x34, 0xfd, 0x42, 0x80, 0x02, 0x05, 0x1a, 0xa0, 0x57, 0xbd, 0xed, 0x45,
	0xd1, 0xa2, 0x6f, 0xe0, 0x37, 0x68, 0x7b, 0x53, 0xf4, 0x0d, 0xfa, 0x10, 0xbd, 0x2c, 0x66, 0x76,
	0x66, 0xb9, 0xbb, 0x1c, 0xae, 0x28, 0x07, 0x09, 0x7a, 0xc7, 0x39, 0x73, 0x66, 0xce, 0xd7, 0xef,
	0x9c, 0x39, 0x67, 0x25, 0xb8, 0xd6, 0xb3, 0xed, 0x5e, 0x1f, 0x97, 0x7b, 0xd8, 0xb2, 0x07, 0x66,
	0xc7, 0x2d, 0x9f, 0xdc, 0x29, 0x9f, 0x18, 0x8e, 0x69, 0x58, 0x9e, 0xbb, 0x31, 0x74, 0x6c, 0xcf,
	0x46, 0xc8, 0x67, 0xd9, 0xe0, 0x2c, 0x1b, 0x27, 0x77, 0x4a, 0x97, 0xd8, 0x31, 0x63, 0x68, 0x96,
	0x0d, 0xcb, 0xb2, 0x3d, 0xc3, 0x33, 0x6d, 0x8b, 0x9d, 0x28, 0xfd, 0x3f, 0xdb, 0xed, 0xdb, 0x56,
	0xcf, 0x19, 0x59, 0x96, 0x69, 0xf5, 0xca, 0xf6, 0x10, 0x3b, 0x11, 0xa6, 0x8b, 0x8c, 0x89, 0xae,
	0x8e, 0x46, 0xc7, 0x65, 0x3c, 0x18, 0x7a, 0xa7, 0x6c, 0x73, 0x35, 0xbe, 0x79, 0x6c, 0xe2, 0x7e,
	0xb7, 0x3d, 0x30, 0xdc, 0xa7, 0x8c, 0xe3, 0x52, 0x9c, 0xc3, 0xf5, 0x9c, 0x51, 0xc7, 0xf3, 0x77,
	0xb5, 0xd7, 0x29, 0x40, 0x0f, 0x7d, 0x33, 0x0e, 0xb1, 0xb7, 0x8f, 0x3d, 0xa3, 0x6b, 0x78, 0x06,
	0x52, 0x20, 0xf5, 0x14, 0x9f, 0xaa, 0xd2, 0xaa, 0xb4, 0x96, 0xd3, 0xc9, 0x4f, 0xb4, 0x04, 0x99,
	0x13, 0xa3, 0x3f, 0xc2, 0xaa, 0x4c, 0x69, 0xfe, 0x02, 0x15, 0x41, 0x36, 0xbb, 0x6a, 0x9a, 0x92,
	0x64, 0xb3, 0x8b, 0xee, 0x41, 0xda, 0x3b, 0x1d, 0x62, 0x35, 0xb3, 0x2a, 0xad, 0x15, 0x2b, 0xdf,
	0xd9, 0x98, 0xf4, 0xc8, 0xc6, 0xa4, 0xb4, 0x8d, 0xd6, 0xe9, 0x10, 0xeb, 0xf4, 0x20, 0x5a, 0x86,
	0x39, 0x6b, 0x34, 0x38, 0xc2, 0x8e, 0x9a, 0xa5, 0x97, 0xb2, 0x15, 0x5a, 0x85, 0x7c, 0x17, 0xbb,
	0x1d, 0xc7, 0x1c, 0x12, 0xd7, 0xa8, 0xf3, 0x74, 0x33, 0x4c, 0x42, 0xf7, 0x21, 0x6d, 0x5a, 0xc7,
	0xb6, 0x9a, 0x5a, 0x4d, 0xad, 0xe5, 0x2b, 0xb7, 0x67, 0x14, 0x5d, 0xb7, 0x8e, 0xed, 0x9a, 0xe5,
	0x39, 0xa7, 0x3a, 0x3d, 0x5d, 0x3a, 0x84, 0x5c, 0x40, 0x12, 0x78, 0xe1, 0x76, 0xd8, 0x0b, 0xf9,
	0x4a, 0x89, 0x4b, 0xe1, 0xce, 0xdd, 0xd8, 0x33, 0x5d, 0xef, 0x21, 0xe1, 0x60, 0x1e, 0xda, 0x94,
	0x3f, 0x94, 0xb4, 0x47, 0x90, 0x26, 0x26, 0xa2, 0x25, 0x50, 0x5a, 0x8f, 0x0e, 0x6a, 0xed, 0x07,
	0x8d, 0xc3, 0x83, 0x5a, 0xb5, 0xbe, 0x53, 0xaf, 0xdd, 0x57, 0xfe, 0x0f, 0xe5, 0x61, 0xbe, 0xde,
	0x68, 0xd5, 0x76, 0x6b, 0xba, 0x22, 0xa1, 0x1c, 0x64, 0x76, 0xf6, 0x9a, 0x5b, 0x2d, 0x45, 0x46,
	0x59, 0x48, 0xef, 0xec, 0x6d, 0xed, 0x2a, 0x29, 0x54, 0x80, 0x5c, 0xf5, 0xd3, 0x2d, 0x7d, 0xab,
	0xda, 0xaa, 0xe9, 0x4a, 0x1a, 0x01, 0xcc, 0x1d, 0xb6, 0xf4, 0x7a, 0x63, 0x57, 0xc9, 0x68, 0x7f,
	0x95, 0x01, 0xc6, 0x66, 0xa1, 0xcb, 0x00, 0xc4, 0x2c, 0x17, 0x7b, 0x6d, 0xb3, 0xcb, 0x14, 0xcf,
	0x31, 0x4a, 0xbd, 0xcb, 0xc2, 0x25, 0x07, 0xe1, 0x5a, 0x03, 0xc5, 0xc1, 0xc7, 0xd8, 0xc1, 0x56,
	0x07, 0xb7, 0xd9, 0xa1, 0x39, 0xba, 0x5b, 0x0c, 0xe8, 0x87, 0xf4, 0xe4, 0x7e, 0x98, 0xf3, 0xc8,
	0x1e, 0x59, 0x5d, 0x57, 0xcd, 0x50, 0x4f, 0x6b, 0x22, 0x4f, 0xeb, 0x9c, 0x77, 0x9b, 0xb0, 0xea,
	0x8b, 0x4e, 0x64, 0xed, 0xa2, 0x6d, 0xc8, 0x0e, 0x58, 0x08, 0xd4, 0x34, 0xbd, 0xe6, 0xe6, 0x6c,
	0x01, 0xd3, 0x83, 0x73, 0x08, 0x41, 0xda, 0x32, 0x06, 0x98, 0x61, 0x81, 0xfe, 0x8e, 0xc3, 0x24,
	0x3b, 0x01, 0x13, 0xed, 0xcb, 0x34, 0xcc, 0xb3, 0x6b, 0xd1, 0x75, 0x28, 0xb2, 0x14, 0xe6, 0xc6,
	0x2f, 0xd2, 0x03, 0x0b, 0x27, 0x81, 0x5c, 0x81, 0xd3, 0x96, 0x20, 0x43, 0x64, 0xb9, 0x14, 0x69,
	0x39, 0xdd, 0x5f, 0x20, 0x15, 0xe6, 0x3b, 0x0e, 0x36, 0x3c, 0xdc, 0x55, 0x17, 0x56, 0xa5, 0xb5,
	0x94, 0xce, 0x97, 0xe8, 0x06, 0x8c, 0x9d, 0xd9, 0xa6, 0x1a, 0x17, 0xe9, 0x5d, 0x85, 0x80, 0xda,
	0x20, 0xaa, 0x2f, 0x41, 0xc6, 0xf5, 0x0c, 0xc7, 0x53, 0x15, 0x7a, 0xdc, 0x5f, 0x10, 0x08, 0x62,
	0xab, 0xab, 0x16, 0x28, 0x8d, 0xfc, 0x44, 0xef, 0xc2, 0x62, 0x28, 0x12, 0x86, 0x8b, 0xdd, 0x89,
	0x90, 0x6d, 0x13, 0x2a, 0x61, 0x34, 0xfa, 0x1e, 0x76, 0x2c, 0xc3, 0xe3, 0x8c, 0xf3, 0x54, 0xe3,
	0x62, 0x40, 0xf6, 0x19, 0x55, 0x98, 0x7f, 0x36, 0x32, 0xfa, 0xa6, 0x77, 0x4a, 0x1d, 0x26, 0xe9,
	0x7c, 0x49, 0xb2, 0xf1, 0xd8, 0x24, 0xcc, 0x6a, 0x8e, 0x9e, 0x64, 0x2b, 0xf4, 0x7d, 0x96, 0x6b,
	0x40, 0x43, 0x77, 0x23, 0x21, 0x74, 0xf1, 0x04, 0x43, 0x77, 0x21, 0xd3, 0x31, 0xfa, 0x7d, 0x57,
	0xcd, 0xd3, 0xb3, 0x57, 0x13, 0xce, 0x56, 0x8d, 0x7e, 0x5f, 0xf7, 0xb9, 0xbf, 0x99, 0xbc, 0xfc,
	0x87, 0x0c, 0xf9, 0x90, 0x2c, 0x74, 0x05, 0xf2, 0x44, 0x1a, 0x07, 0x83, 0x8f, 0x9e, 0x1c, 0x21,
	0xf9, 0x48, 0xd0, 0xa0, 0x10, 0xec, 0xd3, 0x40, 0xe6, 0x7c, 0x7c, 0x31, 0x0e, 0x1a, 0xc6, 0x12,
	0x64, 0x89, 0x29, 0xb4, 0x0a, 0x12, 0x77, 0x67, 0xf4, 0x60, 0x4d, 0xf6, 0x86, 0x8f, 0x89, 0xcb,
	0xb1, 0x47, 0x2b, 0x64, 0x4e, 0x0f, 0xd6, 0xa8, 0x0c, 0x6f, 0x71, 0xbe, 0x76, 0xdf, 0x7c, 0x8a,
	0xfb, 0xe6, 0x63, 0xdb, 0x26, 0xd9, 0x98, 0x5a, 0x93, 0x74, 0xc4, 0xb7, 0xf6, 0x82, 0x1d, 0xf4,
	0x09, 0x8b, 0x81, 0x4c, 0xfd, 0xf8, 0xde, 0x19, 0x7e, 0xfc, 0x76, 0x0a, 0xdd, 0x1f, 0x64, 0x98,
	0xaf, 0xfa, 0xce, 0x60, 0x69, 0x23, 0x05, 0x69, 0xc3, 0xd3, 0x55, 0x0e, 0xa5, 0xeb, 0x45, 0xc8,
	0xb9, 0xc6, 0x60, 0xd8, 0xc7, 0xc4, 0xdd, 0x7e, 0x1e, 0x67, 0x7d, 0x42, 0xbd, 0x8b, 0x6e, 0xc2,
	0x62, 0x34, 0x3b, 0x5d, 0xea, 0x8d, 0x9c, 0x5e, 0x08, 0xa7, 0x67, 0x24, 0xf3, 0x32, 0xd1, 0xcc,
	0xe3, 0x30, 0x4d, 0x4f, 0x87, 0x29, 0xd3, 0xf6, 0xdb, 0x71, 0xcf, 0x8f, 0xa1, 0x18, 0x2d, 0x8c,
	0x82, 0xda, 0x20, 0x89, 0x6a, 0xc3, 0x55, 0xc8, 0x8f, 0x86, 0x43, 0xec, 0xf8, 0x95, 0x97, 0x0a,
	0x4d, 0xe9, 0x40, 0x49, 0xf4, 0x1e, 0xed, 0x37, 0x69, 0x78, 0xbb, 0x3e, 0x18, 0xda, 0x8e, 0xc7,
	0x62, 0xee, 0xea, 0xf8, 0xd9, 0x08, 0xbb, 0xa2, 0x1a, 0x27, 0x09, 0x6a, 0xdc, 0x55, 0xc8, 0xbb,
	0xf6, 0xc8, 0xe9, 0xe0, 0xf6, 0xc8, 0x31, 0x5d, 0x8a, 0xa9, 0x9c, 0x0e, 0x3e, 0xe9, 0x81, 0x63,
	0xba, 0xe8, 0x53, 0x98, 0x3b, 0xb6, 0x9d, 0x81, 0xe1, 0xa9, 0x29, 0xfa, 0xb4, 0x0b, 0xdf, 0x57,
	0xa1, 0x06, 0x1b, 0x3b, 0xf4, 0x9c, 0xce, 0xce, 0xa3, 0x4d, 0x78, 0xc7, 0x22, 0xbf, 0xfa, 0xe6,
	0x0b, 0xdc, 0x8e, 0x1a, 0xef, 0xd2, 0x00, 0x66, 0xf5, 0x95, 0x80, 0x41, 0x0f, 0xbb, 0xc1, 0x45,
	0x4f, 0xe0, 0x02, 0x89, 0x4e, 0x7b, 0x80, 0x9d, 0x1e, 0x6e, 0x77, 0x6c, 0xeb, 0xd8, 0xec, 0x51,
	0x50, 0xe4, 0x2b, 0x3f, 0x98, 0x5d, 0x21, 0x12, 0xd8, 0x7d, 0x72, 0x43, 0x95, 0x5e, 0xe0, 0x87,
	0x7d, 0xd1, 0x8c, 0x52, 0x4b, 0x4f, 0x60, 0x49, 0xc4, 0x28, 0x00, 0xc3, 0xc7, 0x61, 0x30, 0x14,
	0xc5, 0x2f, 0x59, 0x70, 0x55, 0x93, 0xb7, 0x77, 0x61, 0x60, 0x34, 0x60, 0xce, 0xf7, 0x12, 0x5a,
	0x06, 0xb4, 0xd3, 0xd4, 0xf7, 0xb7, 0x5a, 0xb1, 0x26, 0xa1, 0x08, 0xc0, 0xe8, 0x0f, 0xab, 0x3b,
	0x8a, 0x84, 0x2e, 0x81, 0xca, 0xd6, 0xd5, 0xe6, 0xfe, 0xc1, 0x5e, 0xad, 0x55, 0x6b, 0xef, 0xd6,
	0x1a, 0xcd, 0xfd, 0x7a, 0xf5, 0x50, 0x91, 0xb5, 0x4d, 0x58, 0x8e, 0x9b, 0xee, 0x0e, 0x6d, 0xcb,
	0x25, 0x0f, 0xe4, 0x42, 0xa8, 0xc4, 0xb9, 0xaa, 0xe4, 0x47, 0x3a, 0xa8, 0x71, 0xae, 0xf6, 0x39,
	0xac, 0x54, 0x69, 0xfe, 0x8c, 0x1f, 0x5f, 0x8e, 0xa5, 0x7b, 0x90, 0x0f, 0x61, 0x89, 0xba, 0x20,
	0x5f, 0xb9, 0x92, 0xfc, 0x70, 0xeb, 0x30, 0x06, 0x9a, 0xf6, 0x2f, 0x19, 0x56, 0x6a, 0xcf, 0x43,
	0x8a, 0x85, 0x2e, 0x9f, 0x0d, 0xa8, 0x71, 0xfd, 0xe5, 0xb8, 0xfe, 0xa4, 0x05, 0x1a, 0x3a, 0xf6,
	0x13, 0xdc, 0xa1, 0x77, 0xa4, 0xfc, 0x1a, 0xce, 0x28, 0xf5, 0x2e, 0xfa, 0x61, 0x00, 0xe4, 0x34,
	0x8d, 0x56, 0x45, 0xa4, 0xfe, 0x14, 0x1d, 0xe3, 0x50, 0x7e, 0x0f, 0x94, 0x23, 0xb3, 0xf7, 0x6c,
	0x84, 0x9d, 0xd3, 0x36, 0x6b, 0xb2, 0x58, 0x5d, 0x5f, 0xe4, 0xf4, 0xfb, 0x3e, 0x99, 0x24, 0x7a,
	0xc0, 0xea, 0x19, 0x47, 0x7d, 0xcc, 0x1e, 0xed, 0x02, 0xa7, 0xb6, 0x08, 0x51, 0xbb, 0x7b, 0x26,
	0x10, 0xde, 0x82, 0x45, 0x46, 0xdf, 0xae, 0xef, 0x7e, 0xf6, 0xa0, 0xa6, 0x3f, 0x52, 0x24, 0xed,
	0x63, 0x58, 0xda, 0xc5, 0x6f, 0xea, 0x53, 0xed, 0xa7, 0xa0, 0x1e, 0x62, 0xc3, 0xe9, 0x3c, 0x1e,
	0x5f, 0x10, 0x94, 0x8f, 0xab, 0x90, 0x1f, 0x37, 0x94, 0x01, 0x5c, 0x82, 0x8e, 0xd2, 0x77, 0xb7,
	0xd1, 0xc3, 0x6d, 0xcf, 0x7e, 0x8a, 0x2d, 0x56, 0xdc, 0x73, 0x84, 0xd2, 0x22, 0x04, 0x52, 0xe1,
	0xe9, 0xb6, 0x6b, 0xbe, 0xc0, 0x34, 0x18, 0x19, 0x3d, 0x4b, 0x08, 0x87, 0xe6, 0x0b, 0xac, 0xfd,
	0x4a, 0x82, 0x77, 0x04, 0x92, 0x19, 0x54, 0xb7, 0x60, 0x21, 0xa4, 0xbc, 0x2f, 0xfb, 0x6c, 0xb8,
	0xe5, 0xc7, 0xa6, 0xb9, 0xe4, 0x09, 0xb1, 0xf0, 0x73, 0xaf, 0x3d, 0xa1, 0x61, 0x81, 0x90, 0x0f,
	0xb8, 0x96, 0xda, 0x3d, 0x58, 0xb9, 0x8f, 0xfb, 0x58, 0x84, 0xf9, 0xd9, 0x5c, 0xf8, 0x5a, 0x82,
	0x95, 0x07, 0xc3, 0xae, 0xf1, 0xc6, 0x37, 0xc4, 0x73, 0x4b, 0x3e, 0x6f, 0x6e, 0xa1, 0x8f, 0xc8,
	0x1b, 0x41, 0x34, 0xa0, 0xc3, 0x1f, 0xc5, 0xa1, 0xe8, 0x61, 0xda, 0x21, 0xf3, 0xe1, 0xbe, 0xe1,
	0x3e, 0x25, 0xef, 0x07, 0x61, 0x27, 0xbf, 0xb5, 0xbf, 0xc8, 0xf0, 0x76, 0x24, 0x12, 0x01, 0x00,
	0x04, 0xaf, 0xb0, 0x24, 0x7a, 0x85, 0xaf, 0x8d, 0xa3, 0x15, 0x7a, 0xe6, 0xb9, 0x4d, 0x0d, 0xbf,
	0x39, 0x8f, 0xe6, 0x6e, 0x6a, 0x22, 0x77, 0x27, 0x9f, 0xc3, 0x74, 0x62, 0xab, 0x9c, 0x11, 0xb4,
	0xca, 0x73, 0xe3, 0x56, 0x39, 0x8a, 0xcd, 0xf9, 0x44, 0x6c, 0x66, 0xa3, 0xd8, 0x24, 0x9b, 0x03,
	0xe3, 0x79, 0xdb, 0xef, 0x55, 0x73, 0xfe, 0xe6, 0xc0, 0x78, 0x4e, 0xfa, 0x05, 0x57, 0x3b, 0x85,
	0xe5, 0xb8, 0xb7, 0x18, 0x68, 0xbf, 0x07, 0x59, 0xfe, 0x55, 0x80, 0x01, 0xf6, 0x62, 0x42, 0x0c,
	0xf5, 0x80, 0x79, 0x66, 0xa8, 0xee, 0xc3, 0x52, 0xa4, 0x3c, 0xf3, 0x38, 0xdd, 0x85, 0x79, 0x76,
	0x17, 0xab, 0xcb, 0x89, 0x72, 0x39, 0xaf, 0xf6, 0x27, 0x09, 0x96, 0x22, 0xc0, 0xe5, 0xf7, 0x5d,
	0x06, 0x0e, 0xae, 0xd0, 0x24, 0xc9, 0x28, 0xf5, 0x6e, 0x58, 0x9c, 0x3c, 0xbb, 0xb8, 0x38, 0x48,
	0x53, 0xe7, 0x02, 0xe9, 0x5d, 0x58, 0x8a, 0x64, 0xe9, 0x6c, 0xaa, 0x6a, 0x15, 0xb8, 0x30, 0x2e,
	0x8e, 0x33, 0x9e, 0xf9, 0x9b, 0x0c, 0x4b, 0xf4, 0xb9, 0x7e, 0xb3, 0x76, 0x2a, 0x8c, 0x02, 0xf9,
	0x3c, 0x28, 0x30, 0x45, 0x0d, 0x8e, 0xff, 0x45, 0xe3, 0x13, 0xd1, 0x0d, 0x22, 0x1d, 0xff, 0x07,
	0xfb, 0x9b, 0xdf, 0x4a, 0xbc, 0xbc, 0xb0, 0x7e, 0xfb, 0xdc, 0xe5, 0x45, 0x34, 0x3d, 0x44, 0xd3,
	0x3b, 0x95, 0x98, 0xde, 0xe9, 0xd8, 0xd3, 0xf3, 0x82, 0x67, 0xf0, 0x58, 0x21, 0x96, 0xc1, 0x1f,
	0x42, 0x8e, 0x57, 0xa9, 0xc4, 0x14, 0x66, 0x07, 0xf5, 0x2c, 0xab, 0x5f, 0xb3, 0xa7, 0x70, 0x83,
	0xa7, 0x30, 0xbf, 0x82, 0xf9, 0xe2, 0x03, 0xc8, 0x72, 0xc9, 0x49, 0x39, 0xcc, 0x4f, 0xcd, 0x33,
	0xc1, 0xda, 0x9f, 0x83, 0x1c, 0x8e, 0x5d, 0x18, 0x9b, 0x67, 0xa5, 0xf8, 0x3c, 0x1b, 0x16, 0x28,
	0xcf, 0x2e, 0xf0, 0xeb, 0x65, 0xf1, 0x07, 0x3c, 0x8b, 0xcf, 0xa7, 0xac, 0xf6, 0x3e, 0x4d, 0xe3,
	0x73, 0x1e, 0xfa, 0x3b, 0x01, 0x9e, 0xe7, 0x60, 0x63, 0x10, 0x4f, 0xe4, 0x68, 0x9b, 0x28, 0xc5,
	0xdb, 0xc4, 0xc9, 0x3c, 0x97, 0x67, 0xe8, 0x46, 0xbf, 0xe9, 0x17, 0x4d, 0xfb, 0x0c, 0x96, 0xe3,
	0xe6, 0x7c, 0xcd, 0x87, 0x67, 0xfd, 0x27, 0x80, 0x26, 0x93, 0x17, 0x5d, 0x87, 0xd5, 0x7a, 0x63,
	0xa7, 0xd9, 0xde, 0xaf, 0xe9, 0xbb, 0xb5, 0x76, 0xf3, 0xa0, 0xa6, 0x6f, 0xb5, 0xea, 0xcd, 0xc6,
	0xe4, 0x54, 0x52, 0xdf, 0x6d, 0x34, 0xf5, 0x5a, 0xbb, 0x51, 0xfb, 0x91, 0x22, 0xa1, 0x0b, 0x50,
	0xd8, 0x6f, 0x3e, 0xac, 0xb5, 0x5b, 0xcd, 0x76, 0x75, 0x6b, 0x6f, 0xef, 0x50, 0x91, 0x2b, 0x7f,
	0x94, 0x60, 0xc5, 0x57, 0xd9, 0xb4, 0x7a, 0x41, 0xeb, 0xe2, 0x9c, 0x98, 0x1d, 0x8c, 0xbe, 0x94,
	0xa0, 0x18, 0x35, 0x07, 0x09, 0xbf, 0x63, 0x08, 0x23, 0x58, 0x5a, 0x9f, 0x85, 0xd5, 0xf7, 0x8e,
	0x76, 0xe5, 0x8b, 0x7f, 0xfe, 0xfb, 0x2b, 0x59, 0xd5, 0xde, 0x0a, 0x7f, 0xb6, 0xdf, 0x74, 0x29,
	0xf3, 0xa6, 0xb4, 0x7e, 0x5b, 0xaa, 0xbc, 0x46, 0xa0, 0x44, 0xd5, 0x7b, 0x78, 0x07, 0xbd, 0x80,
	0x62, 0x74, 0x8e, 0x12, 0xeb, 0x27, 0x1c, 0x33, 0x4b, 0x97, 0x39, 0x6b, 0xe8, 0xeb, 0xfe, 0x46,
	0xe0, 0xe1, 0x29, 0x2a, 0x99, 0xf4, 0xaa, 0x4d, 0x69, 0x1d, 0xfd, 0x52, 0x02, 0x25, 0x3e, 0x88,
	0x21, 0xe1, 0x17, 0xf5, 0x29, 0xe3, 0x5a, 0xe9, 0x8c, 0xee, 0x51, 0xbb, 0x4e, 0x35, 0xb8, 0xa2,
	0x2d, 0x86, 0x35, 0xc0, 0x9e, 0xbb, 0x19, 0xee, 0x44, 0xd1, 0xef, 0x24, 0x50, 0xe2, 0xf3, 0x90,
	0x58, 0x8f, 0x29, 0x53, 0xd3, 0x59, 0x8e, 0xa8, 0x50, 0x35, 0x6e, 0x69, 0xef, 0xc6, 0xd4, 0x28,
	0xbf, 0x8c, 0x66, 0xe0, 0xab, 0x4d, 0xfc, 0x9c, 0x3b, 0xe7, 0xe7, 0x12, 0x14, 0x22, 0x13, 0x0f,
	0x5a, 0x13, 0x69, 0x24, 0x1a, 0x8a, 0xce, 0x74, 0xcb, 0x1a, 0xd5, 0x47, 0x43, 0xab, 0x67, 0xe9,
	0x83, 0xbe, 0x92, 0xe0, 0xc2, 0xc4, 0xfc, 0x82, 0x6e, 0x09, 0x71, 0x39, 0x65, 0xc0, 0x2a, 0x7d,
	0x77, 0x46, 0x6e, 0x06, 0xe4, 0x6b, 0x54, 0xb9, 0x8b, 0xda, 0x72, 0x5c, 0x39, 0x97, 0x1e, 0x21,
	0xbe, 0xf9, 0x99, 0x04, 0x4a, 0x7c, 0x9a, 0x11, 0x07, 0x6c, 0xca, 0xcc, 0x53, 0x5a, 0x9e, 0x28,
	0xe5, 0xb5, 0xc1, 0xd0, 0x3b, 0xe5, 0x9e, 0x59, 0x3f, 0xdb, 0x33, 0xbf, 0x97, 0x40, 0x89, 0xcf,
	0x43, 0x62, 0x1d, 0xa6, 0x4c, 0x4d, 0x67, 0x46, 0xe9, 0x2e, 0xd5, 0xa5, 0x5c, 0x39, 0x53, 0x97,
	0x28, 0x9a, 0x7f, 0x4d, 0x4a, 0x4e, 0xa4, 0x75, 0x9f, 0x52, 0x72, 0x44, 0xc3, 0xd0, 0x94, 0x92,
	0x23, 0x9c, 0x04, 0xc4, 0xf9, 0x1d, 0x0a, 0xd3, 0x08, 0x0a, 0x91, 0xc4, 0x15, 0x23, 0x58, 0xd4,
	0xeb, 0x97, 0x92, 0x2a, 0xbb, 0x76, 0x99, 0xca, 0x5d, 0xd1, 0x16, 0x22, 0x75, 0x25, 0xe8, 0xc0,
	0xbf, 0x90, 0xa0, 0x10, 0xf1, 0xb9, 0x58, 0xae, 0x68, 0x26, 0x48, 0x96, 0xbb, 0x4e, 0xe5, 0x5e,
	0xaf, 0xbc, 0x13, 0xb1, 0xf7, 0xe5, 0xb8, 0xcb, 0x7e, 0x35, 0x56, 0xc2, 0x83, 0x42, 0x04, 0x7b,
	0x62, 0x1d, 0x44, 0xcd, 0xfe, 0x54, 0x6c, 0xb2, 0xc4, 0x58, 0x9f, 0x2e, 0x1e, 0xb9, 0x00, 0xe3,
	0x82, 0x80, 0x6e, 0x24, 0x17, 0x8c, 0x99, 0x6c, 0x66, 0x42, 0x51, 0x82, 0xd0, 0x21, 0x14, 0x22,
	0x4d, 0xba, 0xd8, 0x54, 0x51, 0x1f, 0x3f, 0xd5, 0x54, 0x1e, 0x61, 0x14, 0x89, 0x30, 0x1d, 0x19,
	0x08, 0xb0, 0xc6, 0x10, 0xe7, 0xbd, 0x6d, 0x12, 0xc4, 0x63, 0x0d, 0x79, 0x12, 0xc4, 0xe3, 0xad,
	0x72, 0x14, 0xe2, 0x74, 0x52, 0x8e, 0x56, 0xa2, 0x13, 0x0e, 0x71, 0xfe, 0x37, 0x81, 0x04, 0x88,
	0x47, 0x1b, 0xbb, 0x52, 0x52, 0x23, 0x1a, 0xc8, 0x5d, 0x08, 0xcb, 0xdd, 0x0c, 0x7a, 0x59, 0xf4,
	0x8b, 0x00, 0xe3, 0x89, 0x82, 0x45, 0x3d, 0x73, 0xb2, 0xe0, 0x5b, 0x54, 0xf0, 0xcd, 0x4a, 0x29,
	0x62, 0xf0, 0xcb, 0x50, 0x0f, 0xf8, 0x2a, 0xa4, 0xc6, 0x88, 0xa3, 0x3c, 0x51, 0x0b, 0x51, 0x33,
	0x3c, 0x35, 0xf4, 0x1a, 0x55, 0xe0, 0xd2, 0x7a, 0x82, 0x02, 0xc8, 0xa3, 0x30, 0xe7, 0x32, 0xa7,
	0xc1, 0xfc, 0x3c, 0x66, 0x33, 0xa9, 0x28, 0x41, 0xea, 0xf6, 0x63, 0x58, 0xee, 0xd8, 0x03, 0xc1,
	0x2d, 0xdb, 0x05, 0x8e, 0xeb, 0x03, 0x62, 0xcb, 0x81, 0xf4, 0xf9, 0x26, 0x67, 0xb2, 0xfb, 0x86,
	0xd5, 0xdb, 0xb0, 0x9d, 0x5e, 0xb9, 0x87, 0x2d, 0x6a, 0x69, 0xd9, 0xdf, 0x32, 0x86, 0xa6, 0x1b,
	0xfe, 0x4f, 0x8b, 0x8f, 0xf8, 0xef, 0xff, 0x48, 0xd2, 0xd1, 0x1c, 0xe5, 0x7c, 0xff, 0xbf, 0x01,
	0x00, 0x00, 0xff, 0xff, 0x7e, 0x5e, 0x37, 0xc0, 0x92, 0x21, 0x00, 0x00,
}
