#!/bin/sh

# generate Makefile.am from the directory contents

MAKE_FILE=Makefile.am

cat > $MAKE_FILE <<\_ACEOF
## This file was automatically generated by Makefile.sh

pkgdatadir = @GPUTILS_LKR_PATH@

LKR_FILES =\
_ACEOF

# count the number of items in the list
let count=0
for x in *.lkr
  do
    let count=count+1
  done

# output the file list
let number=0
for x in *.lkr
  do
    let number=number+1
    if [ $number -eq $count ]; then
      echo "	$x" >> $MAKE_FILE
    else
      echo "	$x \\" >> $MAKE_FILE
    fi
  done

cat >> $MAKE_FILE <<\_ACEOF

pkgdata_DATA = $(LKR_FILES)

EXTRA_DIST = $(LKR_FILES) Makefile.sh
_ACEOF
