/*
 * Copyright (C) 2008 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.google.common.collect;
public class StreamsTest_gwt extends com.google.gwt.junit.client.GWTTestCase {
@Override public String getModuleName() {
  return "com.google.common.collect.testModule";
}
public void testConcatInfiniteStream() throws Exception {
  com.google.common.collect.StreamsTest testCase = new com.google.common.collect.StreamsTest();
  testCase.testConcatInfiniteStream();
}

public void testConcatInfiniteStream_double() throws Exception {
  com.google.common.collect.StreamsTest testCase = new com.google.common.collect.StreamsTest();
  testCase.testConcatInfiniteStream_double();
}

public void testConcatInfiniteStream_int() throws Exception {
  com.google.common.collect.StreamsTest testCase = new com.google.common.collect.StreamsTest();
  testCase.testConcatInfiniteStream_int();
}

public void testConcatInfiniteStream_long() throws Exception {
  com.google.common.collect.StreamsTest testCase = new com.google.common.collect.StreamsTest();
  testCase.testConcatInfiniteStream_long();
}

public void testConcat_doubleStream() throws Exception {
  com.google.common.collect.StreamsTest testCase = new com.google.common.collect.StreamsTest();
  testCase.testConcat_doubleStream();
}

public void testConcat_intStream() throws Exception {
  com.google.common.collect.StreamsTest testCase = new com.google.common.collect.StreamsTest();
  testCase.testConcat_intStream();
}

public void testConcat_longStream() throws Exception {
  com.google.common.collect.StreamsTest testCase = new com.google.common.collect.StreamsTest();
  testCase.testConcat_longStream();
}

public void testConcat_refStream() throws Exception {
  com.google.common.collect.StreamsTest testCase = new com.google.common.collect.StreamsTest();
  testCase.testConcat_refStream();
}

public void testConcat_refStream_closeIsPropagated() throws Exception {
  com.google.common.collect.StreamsTest testCase = new com.google.common.collect.StreamsTest();
  testCase.testConcat_refStream_closeIsPropagated();
}

public void testConcat_refStream_closeIsPropagated_Stream_concat() throws Exception {
  com.google.common.collect.StreamsTest testCase = new com.google.common.collect.StreamsTest();
  testCase.testConcat_refStream_closeIsPropagated_Stream_concat();
}

public void testConcat_refStream_closeIsPropagated_Stream_flatMap() throws Exception {
  com.google.common.collect.StreamsTest testCase = new com.google.common.collect.StreamsTest();
  testCase.testConcat_refStream_closeIsPropagated_Stream_flatMap();
}

public void testConcat_refStream_parallel() throws Exception {
  com.google.common.collect.StreamsTest testCase = new com.google.common.collect.StreamsTest();
  testCase.testConcat_refStream_parallel();
}

public void testForEachPair() throws Exception {
  com.google.common.collect.StreamsTest testCase = new com.google.common.collect.StreamsTest();
  testCase.testForEachPair();
}

public void testForEachPair_differingLengths1() throws Exception {
  com.google.common.collect.StreamsTest testCase = new com.google.common.collect.StreamsTest();
  testCase.testForEachPair_differingLengths1();
}

public void testForEachPair_differingLengths2() throws Exception {
  com.google.common.collect.StreamsTest testCase = new com.google.common.collect.StreamsTest();
  testCase.testForEachPair_differingLengths2();
}

public void testForEachPair_finiteWithInfinite() throws Exception {
  com.google.common.collect.StreamsTest testCase = new com.google.common.collect.StreamsTest();
  testCase.testForEachPair_finiteWithInfinite();
}

public void testForEachPair_oneEmpty() throws Exception {
  com.google.common.collect.StreamsTest testCase = new com.google.common.collect.StreamsTest();
  testCase.testForEachPair_oneEmpty();
}

public void testForEachPair_parallel() throws Exception {
  com.google.common.collect.StreamsTest testCase = new com.google.common.collect.StreamsTest();
  testCase.testForEachPair_parallel();
}

public void testMapWithIndex_arrayListSource() throws Exception {
  com.google.common.collect.StreamsTest testCase = new com.google.common.collect.StreamsTest();
  testCase.testMapWithIndex_arrayListSource();
}

public void testMapWithIndex_closeIsPropagated_sizedSource() throws Exception {
  com.google.common.collect.StreamsTest testCase = new com.google.common.collect.StreamsTest();
  testCase.testMapWithIndex_closeIsPropagated_sizedSource();
}

public void testMapWithIndex_closeIsPropagated_unsizedSource() throws Exception {
  com.google.common.collect.StreamsTest testCase = new com.google.common.collect.StreamsTest();
  testCase.testMapWithIndex_closeIsPropagated_unsizedSource();
}

public void testMapWithIndex_doubleStream_closeIsPropagated_sized() throws Exception {
  com.google.common.collect.StreamsTest testCase = new com.google.common.collect.StreamsTest();
  testCase.testMapWithIndex_doubleStream_closeIsPropagated_sized();
}

public void testMapWithIndex_doubleStream_closeIsPropagated_unsized() throws Exception {
  com.google.common.collect.StreamsTest testCase = new com.google.common.collect.StreamsTest();
  testCase.testMapWithIndex_doubleStream_closeIsPropagated_unsized();
}

public void testMapWithIndex_intStream() throws Exception {
  com.google.common.collect.StreamsTest testCase = new com.google.common.collect.StreamsTest();
  testCase.testMapWithIndex_intStream();
}

public void testMapWithIndex_intStream_closeIsPropagated_sized() throws Exception {
  com.google.common.collect.StreamsTest testCase = new com.google.common.collect.StreamsTest();
  testCase.testMapWithIndex_intStream_closeIsPropagated_sized();
}

public void testMapWithIndex_intStream_closeIsPropagated_unsized() throws Exception {
  com.google.common.collect.StreamsTest testCase = new com.google.common.collect.StreamsTest();
  testCase.testMapWithIndex_intStream_closeIsPropagated_unsized();
}

public void testMapWithIndex_linkedHashSetSource() throws Exception {
  com.google.common.collect.StreamsTest testCase = new com.google.common.collect.StreamsTest();
  testCase.testMapWithIndex_linkedHashSetSource();
}

public void testMapWithIndex_longStream() throws Exception {
  com.google.common.collect.StreamsTest testCase = new com.google.common.collect.StreamsTest();
  testCase.testMapWithIndex_longStream();
}

public void testMapWithIndex_longStream_closeIsPropagated_sized() throws Exception {
  com.google.common.collect.StreamsTest testCase = new com.google.common.collect.StreamsTest();
  testCase.testMapWithIndex_longStream_closeIsPropagated_sized();
}

public void testMapWithIndex_longStream_closeIsPropagated_unsized() throws Exception {
  com.google.common.collect.StreamsTest testCase = new com.google.common.collect.StreamsTest();
  testCase.testMapWithIndex_longStream_closeIsPropagated_unsized();
}

public void testMapWithIndex_unsizedSource() throws Exception {
  com.google.common.collect.StreamsTest testCase = new com.google.common.collect.StreamsTest();
  testCase.testMapWithIndex_unsizedSource();
}

public void testStream_collection() throws Exception {
  com.google.common.collect.StreamsTest testCase = new com.google.common.collect.StreamsTest();
  testCase.testStream_collection();
}

public void testStream_googleOptional() throws Exception {
  com.google.common.collect.StreamsTest testCase = new com.google.common.collect.StreamsTest();
  testCase.testStream_googleOptional();
}

public void testStream_iterator() throws Exception {
  com.google.common.collect.StreamsTest testCase = new com.google.common.collect.StreamsTest();
  testCase.testStream_iterator();
}

public void testStream_javaOptional() throws Exception {
  com.google.common.collect.StreamsTest testCase = new com.google.common.collect.StreamsTest();
  testCase.testStream_javaOptional();
}

public void testStream_nonCollection() throws Exception {
  com.google.common.collect.StreamsTest testCase = new com.google.common.collect.StreamsTest();
  testCase.testStream_nonCollection();
}

public void testStream_optionalDouble() throws Exception {
  com.google.common.collect.StreamsTest testCase = new com.google.common.collect.StreamsTest();
  testCase.testStream_optionalDouble();
}

public void testStream_optionalInt() throws Exception {
  com.google.common.collect.StreamsTest testCase = new com.google.common.collect.StreamsTest();
  testCase.testStream_optionalInt();
}

public void testStream_optionalLong() throws Exception {
  com.google.common.collect.StreamsTest testCase = new com.google.common.collect.StreamsTest();
  testCase.testStream_optionalLong();
}

public void testZip() throws Exception {
  com.google.common.collect.StreamsTest testCase = new com.google.common.collect.StreamsTest();
  testCase.testZip();
}

public void testZipDifferingLengths() throws Exception {
  com.google.common.collect.StreamsTest testCase = new com.google.common.collect.StreamsTest();
  testCase.testZipDifferingLengths();
}

public void testZipFiniteWithInfinite() throws Exception {
  com.google.common.collect.StreamsTest testCase = new com.google.common.collect.StreamsTest();
  testCase.testZipFiniteWithInfinite();
}

public void testZipInfiniteWithInfinite() throws Exception {
  com.google.common.collect.StreamsTest testCase = new com.google.common.collect.StreamsTest();
  testCase.testZipInfiniteWithInfinite();
}

public void testZip_closeIsPropagated() throws Exception {
  com.google.common.collect.StreamsTest testCase = new com.google.common.collect.StreamsTest();
  testCase.testZip_closeIsPropagated();
}
}
