-- | The multi-valued version of mtl's RWS / RWST
module Control.Monad.Trans.MultiRWS
  (
  -- * MultiRWST
    MultiRWST(..)
  , MultiRWSTNull
  , MultiRWS
  -- * MonadMulti classes
  , MonadMultiReader(..)
  , MonadMultiWriter(..)
  , MonadMultiGet(..)
  , MonadMultiState(..)
  -- * run-functions (extracting from RWST)
  , runMultiRWST
  , runMultiRWSTASW
  , runMultiRWSTW
  , runMultiRWSTAW
  , runMultiRWSTSW
  , runMultiRWSTNil
  , runMultiRWSTNil_
  -- * with-functions (extending an RWST)
  , withMultiReader
  , withMultiReader_
  , withMultiReaders
  , withMultiReaders_
  , withMultiWriter
  , withMultiWriterAW
  , withMultiWriterWA
  , withMultiWriterW
  , withMultiWriters
  , withMultiWritersAW
  , withMultiWritersWA
  , withMultiWritersW
  , withMultiState
  , withMultiStateAS
  , withMultiStateSA
  , withMultiStateA
  , withMultiStateS
  , withMultiState_
  , withMultiStates
  , withMultiStatesAS
  , withMultiStatesSA
  , withMultiStatesA
  , withMultiStatesS
  , withMultiStates_
  -- * without-functions (reducing an RWST; inverse of with)
  , withoutMultiReader
  , withoutMultiState
  -- * inflate-functions (run simple transformer in MultiRWST)
  , inflateReader
  , inflateMultiReader
  , inflateWriter
  , inflateMultiWriter
  , inflateState
  , inflateMultiState
  -- * other functions
  , mapMultiRWST
  , mGetRawR
  , mGetRawW
  , mGetRawS
  , mPutRawR
  , mPutRawW
  , mPutRawS
) where



-- just re-export
import Control.Monad.Trans.MultiRWS.Lazy
