module Test.Utility where

import Test.QuickCheck (Arbitrary(..))

import qualified Numeric.NonNegative.Wrapper as NonNeg
import Control.Monad (liftM)
import Data.Char (chr)


type TimeDiff = NonNeg.Int

timeToDouble :: TimeDiff -> NonNeg.Double
timeToDouble = fromIntegral

makeFracTime :: (TimeDiff, TimeDiff) -> NonNeg.Double
makeFracTime (n,d) =
   timeToDouble n / (timeToDouble d + 1)


instance Arbitrary Char where
   arbitrary = liftM (chr . (32+) . flip mod 96) arbitrary
   coarbitrary = undefined

instance Arbitrary a => Arbitrary (Maybe a) where
   arbitrary =
      arbitrary >>=
         \b -> if b then fmap Just arbitrary else return Nothing
   coarbitrary = undefined
