**Overview**

The HDMF-common specification documentation uses Sphinx [http://www.sphinx-doc.org/en/stable/index.html](http://www.sphinx-doc.org/en/stable/index.html)

**Prerequisites**

```pip install hdmf-docutils```

**Rebuilding All**

To rebuild the full documentation in html, latex, and PDF simply run:

```make fulldoc```

This is a convenience function that is equivalent to:

```
make allclean
make apidoc
make html
make latexpdf
```

**Generating the format documentation from the format spec**

The format documentation is auto-generated from the format specification (YAML/JSON) sources via:

```make apidoc```

This will invoke the ``hdmf_generate_format_docs`` executable provided by ``hdmf-docutils`` package to automatically generate a series of .rst, .png, and .pdf files that are stored in the folder ```source/_format_auto_docs```. The generated .rst files are included in ```source/format.rst``` and the png and pdf files are used as figures in the autogenerated docs. The folder ```source/format_auto_docs``` is reserved for autogenerated files, i.e., files in the folder should not be added or edited by hand as they will be deleted and rebuilt during the full build of the documentation.

By default the Sphinx configuration is setup to always regenerate the sources whenever the docs are being built (see next section). This behavior can be customized via the ```spec_doc_rebuild_always``` parameter in ```source/conf.py```

**Building a specific document type**

To build the documentation simply:

```make <doctype>```

where ```<doctype>``` is, e.g., ```latexpdf```, ```html```, ```singlehtml``` or ```man```. For a complete list of supported doc-types see:

```make help```

**Cleaning up**

```make clean``` cleans up all builds of the documentation located in ```_build```.

```make allclean``` cleans up all builds of the documentation located in ```_build``` as wellas  all autogenerated sources stored in ```source/format_auto_docs```.

**Configuration**

The build of the documentation can be customized via a broad range of Sphinx options in:

```source/conf_doc_autogen.py```

In addition to standard Sphinx options, there are a number of additional options used to customize the content and structure of the autogenerated documents, e.g.:

* ```spec_show_yaml_src``` Boolean indicating whether the YAML sources should be included for the different neurodata types
* ```spec_show_json_src``` Boolean indicating whether the JSON sources should be included for the different neurodata types
* ```spec_generate_src_file``` Boolean indicating whether the YAML/JSON sources of the neurodata_types should be rendered in a separate section (True) or in the same location as the main documentation
* ```spec_show_hierarchy_plots ``` Boolean indicating whether we should generate and show figures of the hierarchy defined by the specifications as part of the documentation
* ```spec_file_per_type``` Boolean indicating whether we should generate separate .inc reStructuredText for each neurodata_type (True)
or should all text be added to the main file (False)
* ```spec_show_subgroups_in_tables``` Should subgroups of the main groups be rendered in the table as well. Usually this is disabled since groups are rendered as separate sections in the tex
* ```spec_appreviate_main_object_doc_in_tables``` Appreviate the documentation of the main object for which a table is rendered in the table. This is commonly set to True as doc of the main object is alrready rendered as the main intro for the section describing the object
* ```spec_show_title_for_tables``` Add a title for the table showing the specifications.
* ```spec_show_subgroups_in_seperate_table``` Should top-level subgroups be listed in a separate table or as part of the main dataset and attributes table
* ```spec_table_depth_char``` Char to be used as prefix to indicate the depth of an object in the specification hierarchy. NOTE: The char used should be supported by LaTeX.
* ```spec_add_latex_clearpage_after_ndt_sections``` Add a LaTeX clearpage after each main section describing a neurodata_type. This helps in LaTeX to keep the ordering of figures, tables, and code blocks consistent in particular when the hierarchy_plots are included.
* ```spec_resolve_type_inc``` Resolve includes to always show the full list of objects that are part of a type (True) or to show only the parts that are actually new to a current type while only linking to base types (False)

In addition, the location of the input format specification can be customized as follows:


* ```spec_input_spec_dir```  Directory where the YAML files for the namespace to be documented are located
* ```spec_input_namespace_filename```  Name of the YAML (or JSON) file with the specification of the Namespace to be documented
* ```spec_input_default_namespace``` Name of the default namespace in the file

Finally, the name and location of output files can be customized as follows:


* ```spec_output_dir```  Directory where the autogenerated files should be stored
* ```spec_output_master_filename```  Name of the master rst file that includes all the autogenerated docs
* ```spec_output_doc_filename```  Name of the file where the main documentation goes
* ```spec_output_src_filename```  Name of the file where the sources of the format spec go. NOTE: This file is only generated if spec_generate_src_file is enabled
* ```spec_output_doc_type_hierarchy_filename```  Name of the file containing the type hierarchy. (Included in spec_output_doc_filename)

To speed up the build of the format docs we can prevent the ``hdmf_generate_format_docs`` executable from regenerating the sources from YAML if the git-hash from the previous build is still current. This is controlled via the following options:

* ``spec_clean_output_dir_if_old_git_hash`` Clean up the output directory before we generate the source if the git hash is out of date

* ``spec_skip_doc_autogen_if_current_git_hash`` Do not rebuild the format sources if we have previously build the sources and the git hash matches

In the regular Sphinx ```source/conf.py``` file we can then also set:

* ```spec_doc_rebuild_always``` Boolean to define to always rebuild the source docs from YAML when doing a regular build of the sources (e.g., via ```make html```) even if the folder with the source files already exists
