/* 
 * Copyright (C) 2001-2013 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.progress;

public interface ProgressListener {

	/**
	 * Die Methode <code>progress</code> wird aufgerufen, wenn ein
	 * Fortschrittsereignis ausgelöst wurde.
	 *
	 * @param event Das Fortschrittsereignis (<code>ProgressEvent</code>).
	 *
	 * @return <code>boolean</code> Der Rückgabewert muß auf <code>false</code>
	 * gesetzt werden, wenn der Sender des Fortschrittsereignisses die
	 * Verarbeitung abbrechen soll.
	 */
	public boolean progress(ProgressEvent event);

    /**
     * Setzt die maximale Anzahl von protokollierten Verarbeitungsschritten, die
     * ein berechenbares Fortschrittsereignis auslösen.
     */
    public void setProgressMaximum(int max);

}