# -*- coding: utf-8 -*-
#/usr/bin/python

from __future__ import with_statement # This isn't required in Python 2.6
import sys

def convert(oldFile):

  ParamMap = {
  '$DEFAULTCOLOUR': 'Default',
  '$BGCOLOUR' : 'Canvas' ,
  '$NUMBER' : 'Number' ,
  '$ESCAPECHAR' : 'Escape' ,
  '$STRING' : 'String' ,
  '$STRING-DIRECTIVE' : 'StringPreProc' ,
  '$COMMENT' : 'BlockComment' ,
  '$SL-COMMENT' : 'LineComment' ,
  '$DIRECTIVE' : 'PreProcessor' ,
  '$LINE' : 'LineNum' ,
  '$SYMBOL' : 'Operator' ,
  }

  KeywordGroupMap = []
  slcDefined=0
  newFile=oldFile[0:oldFile.rfind('.')] + ".theme"
  with open(newFile,'w') as outfile:
    with open(oldFile) as f:
      outfile.write('-- Theme generated by theme2to3\n\n')
      for line in f:
	  values =line.rstrip().split('=',1)
	  if (values[0] in ParamMap):
	    if (values[0].lower()=='$sl-comment'): slcDefined=1
	    attributes=values[1].split(' ')
	    line= "%-14s = { Colour=\"%s\"" % (ParamMap[values[0]], attributes[0])
	    for a in attributes[1:]:
	      if a=='bold': line=line+", Bold=true"
	      elif a=='italic': line=line+", Italic=true"
	      elif a=='underline': line=line+", Underline=true"
	    line=line+" }\n"
	    outfile.write( line )
	  elif values[0].startswith('$KW')==True:
	    attributes=values[1].split(' ')
	    KeywordGroupMap.append(attributes)
      if (slcDefined == 0):
	outfile.write( 'LineComment = BlockComment\n')
      outfile.write( '\nKeywords = {\n')
      for kwGroup in KeywordGroupMap:
	line =  "  { Colour= \"%s\"" % kwGroup[0]
	for a in kwGroup[1:]:
	      if a=='bold': line=line+", Bold=true"
	      elif a=='italic': line=line+", Italic=true"
	      elif a=='underline': line=line+", Underline=true"
	line = line + ' },\n'
	outfile.write( line )
      outfile.write( '}\n' )

if __name__ == "__main__":
  if len(sys.argv) < 2:
    print "USAGE: %s old_theme.style" % sys.argv[0]
  else:
    for f in sys.argv[1:]:
      convert(f)
