import re
from debian_linux.debian import Version

class VersionIbm3270(Version):
    __rules = ur"""
^
(?P<version>
    \d+\.\d+\.\d+((p|ga)\d+)?
)
(?:
    \.dfsg\.
    (?P<dfsg>
        \d+
    )
)?
-
(?:[^-]+)
$
"""
    __re = re.compile(__rules, re.X)

    def __init__(self, version):
        super(VersionIbm3270, self).__init__(version)
        match = self.__re.match(version)
        if match is None:
            raise RuntimeError, "Invalid version"
        d = match.groupdict()
        self.ibm3270_version = d['version']
        self.ibm3270_dfsg = d['dfsg']

