#!/bin/sh
# $Id: nonroot.sh,v 1.1.1.1 2005/08/04 19:45:19 jim-campbell Exp $
#
# nonroot.sh -- Add permission to usb device file for run ifp by non-root user

# uid check
if [ ! `id -u` = 0 ]; then
    echo "You are not root.  Cannot run this script."
    exit
fi

case `uname` in
Linux)
    if [ ! -d /etc/udev ]; then
	echo "This script needs udev support."
	exit
    fi

    # cite from giriver README.

    # if group "ifp" exist, groupadd exit with error message.
    /usr/sbin/groupadd ifp
    echo
    echo "****************************************************************"
    echo "Please add iFP users to group \"users\"."
    echo "****************************************************************"
    echo

    if [ -d  /etc/udev/rules.d/90-iRiver.rules ]; then
	echo "/etc/udev/rules.d/90-iRiver.rules exists."
	echo "Please modify it yourself if necessary."

    else
	cat >> /etc/udev/rules.d/90-iRiver.rules << EOF

# for iRiver iFP MP3 player
SUBSYSTEM=="usb", ENV{DEVTYPE}=="usb_device", ATTR{idVendor}=="4102", ATTR{idProduct}=="1001", MODE="0664", GROUP="users"
SUBSYSTEM=="usb", ENV{DEVTYPE}=="usb_device", ATTR{idVendor}=="4102", ATTR{idProduct}=="1003", MODE="0664", GROUP="users"
SUBSYSTEM=="usb", ENV{DEVTYPE}=="usb_device", ATTR{idVendor}=="4102", ATTR{idProduct}=="1005", MODE="0664", GROUP="users"
SUBSYSTEM=="usb", ENV{DEVTYPE}=="usb_device", ATTR{idVendor}=="4102", ATTR{idProduct}=="1007", MODE="0664", GROUP="users"
SUBSYSTEM=="usb", ENV{DEVTYPE}=="usb_device", ATTR{idVendor}=="4102", ATTR{idProduct}=="1008", MODE="0664", GROUP="users"
SUBSYSTEM=="usb", ENV{DEVTYPE}=="usb_device", ATTR{idVendor}=="4102", ATTR{idProduct}=="1009", MODE="0664", GROUP="users"
SUBSYSTEM=="usb", ENV{DEVTYPE}=="usb_device", ATTR{idVendor}=="4102", ATTR{idProduct}=="1010", MODE="0664", GROUP="users"

EOF
	echo "/etc/udev/rules.d/90-iRiver.rules created"
    fi
    ;;

FreeBSD)
    if [ -f /etc/defaults/devfs.rules ]; then
	# for after FreeBSD 5.2-RELEASE. 
	if egrep -q '^add[[:blank:]]path[[:blank:]][[:punct:]]*ugen' /etc/devfs.rules; then
	    echo "****************************************************************"
	    echo "/etc/devfs.rules already changed."
	    echo "Please modify yourself for your system."

	else 
	    echo "/etc/devfs.rules changed."; \
	    cat >> /etc/devfs.rules << EOF

# for iRiver iFP MP3 player
[iriver_ruleset=4012]
add	path	'ugen*'	mode	664

EOF

	    if egrep -q '^devfs_system_ruleset=' /etc/rc.conf; then
		echo "****************************************************************"
		echo "/etc/rc.conf already changed."
		echo "Please modify yourself for your system."
		echo
		echo "example /etc/devfs.rules:"
		echo "	[iriver_ruleset=4012]"
		echo "	add path 'ugen*' mode 664"
		echo 
		echo "example /etc/rc.conf:"
		echo "	devfs_system_ruleset=\"iriver_ruleset\""

	    else
		echo 'devfs_system_ruleset="iriver_ruleset"' >> /etc/rc.conf; \
		echo "/etc/rc.conf changed."; \
		/etc/rc.d/devfs start
	    fi
	fi
		
    else
	# for 4.*
	chmod g+rw /dev/usb* /dev/ugen*
    fi

    echo
    echo "****************************************************************"
    echo "Please add iFP users to group \"operator\"."
    echo "****************************************************************"
    echo
    ;;

NetBSD)
    chmod g+rw /dev/usb* /dev/ugen*

    echo
    echo "****************************************************************"
    echo "Please add iFP users to group \"wheel\"."
    echo "****************************************************************"
    echo
    ;;

Darwin)
    # Mac OS X
    echo "No need to configuration for run ifp by non-root user on Mac OS X"
    ;;

*)
    echo "Sorry, this script did not support your OS."
    ;;
esac

