/*
 * Project       : ipv6calc
 * File          : dbipv6_assignment.h
 * Version       : $Id: 50b378572d2490dfe31f1c8d016fe2f8e75157f0 $
 * Generated     : 20230608-183030+0200 CEST
 * Data copyright: IANA ARIN RIPENCC APNIC LACNIC AFRINIC
 *
 * Information:
 *  Additional header file for databases/lib/libipv6calc_db_wrapper_BuiltIn.c
 */

#include "databases/lib/libipv6calc_db_wrapper_BuiltIn.h"

static const char* dbipv6addr_registry_status __attribute__ ((__unused__)) = "AFRINIC/20230608 APNIC/20230608 ARIN/20230608 IANA/20191106 LACNIC/20230607 LISP/20200318 RIPENCC/20230607";
static const time_t dbipv6addr_registry_unixtime __attribute__ ((__unused__)) = 1686241830;

static const s_ipv6addr_assignment dbipv6addr_assignment[] = {
	//ipv6_00_31, ipv6_32_63, mask_00_31, mask_32_63, mask_length, registry  
	{ 0x20010000, 0x00000000, 0xfffffe00, 0x00000000,  23, REGISTRY_IANA       },
	{ 0x20010200, 0x00000000, 0xfffffe00, 0x00000000,  23, REGISTRY_APNIC      },
	{ 0x20010400, 0x00000000, 0xfffffe00, 0x00000000,  23, REGISTRY_ARIN       },
	{ 0x20010600, 0x00000000, 0xfffffe00, 0x00000000,  23, REGISTRY_RIPENCC    },
	{ 0x200107fa, 0x00000001, 0xffffffff, 0xffffffff,  64, REGISTRY_APNIC      },
	{ 0x200107fa, 0x00000002, 0xffffffff, 0xffffffff,  64, REGISTRY_APNIC      },
	{ 0x200107fa, 0x00000003, 0xffffffff, 0xffffffff,  64, REGISTRY_APNIC      },
	{ 0x200107fa, 0x00010000, 0xffffffff, 0xffff0000,  48, REGISTRY_APNIC      },
	{ 0x200107fa, 0x00020000, 0xffffffff, 0xffff0000,  48, REGISTRY_APNIC      },
	{ 0x200107fa, 0x00030000, 0xffffffff, 0xffff0000,  48, REGISTRY_APNIC      },
	{ 0x200107fa, 0x00040000, 0xffffffff, 0xffff0000,  48, REGISTRY_APNIC      },
	{ 0x200107fa, 0x00050000, 0xffffffff, 0xffff0000,  48, REGISTRY_APNIC      },
	{ 0x200107fa, 0x00060000, 0xffffffff, 0xffff0000,  48, REGISTRY_APNIC      },
	{ 0x200107fa, 0x00070000, 0xffffffff, 0xffff0000,  48, REGISTRY_APNIC      },
	{ 0x200107fa, 0x00080000, 0xffffffff, 0xffff0000,  48, REGISTRY_APNIC      },
	{ 0x200107fa, 0x00090000, 0xffffffff, 0xffff0000,  48, REGISTRY_APNIC      },
	{ 0x200107fa, 0x000a0000, 0xffffffff, 0xffff0000,  48, REGISTRY_APNIC      },
	{ 0x200107fa, 0x000b0000, 0xffffffff, 0xffff0000,  48, REGISTRY_APNIC      },
	{ 0x200107fa, 0x000c0000, 0xffffffff, 0xfffe0000,  47, REGISTRY_APNIC      },
	{ 0x200107fa, 0x000e0000, 0xffffffff, 0xffff0000,  48, REGISTRY_APNIC      },
	{ 0x200107fa, 0x000f0000, 0xffffffff, 0xffff0000,  48, REGISTRY_APNIC      },
	{ 0x200107fa, 0x00100000, 0xffffffff, 0xffff0000,  48, REGISTRY_APNIC      },
	{ 0x200107fa, 0x00110000, 0xffffffff, 0xffff0000,  48, REGISTRY_APNIC      },
	{ 0x20010800, 0x00000000, 0xfffffc00, 0x00000000,  22, REGISTRY_RIPENCC    },
	{ 0x20010c00, 0x00000000, 0xfffffe00, 0x00000000,  23, REGISTRY_APNIC      },
	{ 0x20010e00, 0x00000000, 0xfffffe00, 0x00000000,  23, REGISTRY_APNIC      },
	{ 0x20011200, 0x00000000, 0xfffffe00, 0x00000000,  23, REGISTRY_LACNIC     },
	{ 0x20011400, 0x00000000, 0xfffffc00, 0x00000000,  22, REGISTRY_RIPENCC    },
	{ 0x20011800, 0x00000000, 0xfffffe00, 0x00000000,  23, REGISTRY_ARIN       },
	{ 0x20011a00, 0x00000000, 0xfffffe00, 0x00000000,  23, REGISTRY_RIPENCC    },
	{ 0x20011c00, 0x00000000, 0xfffffc00, 0x00000000,  22, REGISTRY_RIPENCC    },
	{ 0x20012000, 0x00000000, 0xffffe000, 0x00000000,  19, REGISTRY_RIPENCC    },
	{ 0x20014000, 0x00000000, 0xfffffe00, 0x00000000,  23, REGISTRY_RIPENCC    },
	{ 0x20014200, 0x00000000, 0xfffffe00, 0x00000000,  23, REGISTRY_AFRINIC    },
	{ 0x20014400, 0x00000000, 0xfffffe00, 0x00000000,  23, REGISTRY_APNIC      },
	{ 0x20014600, 0x00000000, 0xfffffe00, 0x00000000,  23, REGISTRY_RIPENCC    },
	{ 0x20014800, 0x00000000, 0xfffffe00, 0x00000000,  23, REGISTRY_ARIN       },
	{ 0x20014a00, 0x00000000, 0xfffffe00, 0x00000000,  23, REGISTRY_RIPENCC    },
	{ 0x20014c00, 0x00000000, 0xfffffe00, 0x00000000,  23, REGISTRY_RIPENCC    },
	{ 0x20015000, 0x00000000, 0xfffff000, 0x00000000,  20, REGISTRY_RIPENCC    },
	{ 0x20018000, 0x00000000, 0xffffe000, 0x00000000,  19, REGISTRY_APNIC      },
	{ 0x2001a000, 0x00000000, 0xfffff000, 0x00000000,  20, REGISTRY_APNIC      },
	{ 0x2001b000, 0x00000000, 0xfffff000, 0x00000000,  20, REGISTRY_APNIC      },
	{ 0x20020000, 0x00000000, 0xffff0000, 0x00000000,  16, REGISTRY_6TO4       },
	{ 0x20030000, 0x00000000, 0xffffc000, 0x00000000,  18, REGISTRY_RIPENCC    },
	{ 0x24000000, 0x00000000, 0xfff00000, 0x00000000,  12, REGISTRY_APNIC      },
	{ 0x26000000, 0x00000000, 0xfff00000, 0x00000000,  12, REGISTRY_ARIN       },
	{ 0x26100000, 0x00000000, 0xfffffe00, 0x00000000,  23, REGISTRY_ARIN       },
	{ 0x26200000, 0x00000000, 0xfffffe00, 0x00000000,  23, REGISTRY_ARIN       },
	{ 0x26300000, 0x00000000, 0xfff00000, 0x00000000,  12, REGISTRY_ARIN       },
	{ 0x28000000, 0x00000000, 0xfff00000, 0x00000000,  12, REGISTRY_LACNIC     },
	{ 0x2a000000, 0x00000000, 0xfff00000, 0x00000000,  12, REGISTRY_RIPENCC    },
	{ 0x2a100000, 0x00000000, 0xfff00000, 0x00000000,  12, REGISTRY_RIPENCC    },
	{ 0x2c000000, 0x00000000, 0xfff00000, 0x00000000,  12, REGISTRY_AFRINIC    },
	{ 0x2d000000, 0x00000000, 0xff000000, 0x00000000,   8, REGISTRY_IANA       },
	{ 0x2e000000, 0x00000000, 0xfe000000, 0x00000000,   7, REGISTRY_IANA       },
	{ 0x30000000, 0x00000000, 0xf0000000, 0x00000000,   4, REGISTRY_IANA       },
	{ 0x3ffe0000, 0x00000000, 0xffff0000, 0x00000000,  16, REGISTRY_IANA       },
	{ 0x5f000000, 0x00000000, 0xff000000, 0x00000000,   8, REGISTRY_IANA       },
};

static const s_ipv6addr_info dbipv6addr_info[] = {
	//ipv6_00_31, ipv6_32_63, mask_00_31, mask_32_63, mask_length, info      
	{ 0x261000d0, 0x11000000, 0xffffffff, 0xffff0000,  48, "LISP#asp-xtr" },
	{ 0x261000d0, 0x11010000, 0xffffffff, 0xffff0000,  48, "LISP#ntt-xtr" },
	{ 0x261000d0, 0x11020000, 0xffffffff, 0xffff0000,  48, "LISP#bell-ca-xtr" },
	{ 0x261000d0, 0x11030000, 0xffffffff, 0xffff0000,  48, "LISP#nyu-xtr" },
	{ 0x261000d0, 0x11040000, 0xffffffff, 0xffff0000,  48, "LISP#epulvino-xtr" },
	{ 0x261000d0, 0x11050000, 0xffffffff, 0xffff0000,  48, "LISP#asp-n7k-xtr" },
	{ 0x261000d0, 0x11060000, 0xffffffff, 0xffff0000,  48, "LISP#rymcdowe-xtr" },
	{ 0x261000d0, 0x11070000, 0xffffffff, 0xffff0000,  48, "LISP#icann-xtr" },
	{ 0x261000d0, 0x11080000, 0xffffffff, 0xffff0000,  48, "LISP#genworth-xtr" },
	{ 0x261000d0, 0x110a0000, 0xffffffff, 0xffff0000,  48, "LISP#google-xtr" },
	{ 0x261000d0, 0x110b0000, 0xffffffff, 0xffff0000,  48, "LISP#manhoo-xtr" },
	{ 0x261000d0, 0x110c0000, 0xffffffff, 0xffff0000,  48, "LISP#cisco-it-xtr" },
	{ 0x261000d0, 0x110d0000, 0xffffffff, 0xffff0000,  48, "LISP#miles-xtr" },
	{ 0x261000d0, 0x110e0000, 0xffffffff, 0xffff0000,  48, "LISP#smith-xtr" },
	{ 0x261000d0, 0x110f0000, 0xffffffff, 0xffff0000,  48, "LISP#mikea-xtr" },
	{ 0x261000d0, 0x11100000, 0xffffffff, 0xffff0000,  48, "LISP#ge-tsg-xtr" },
	{ 0x261000d0, 0x11110000, 0xffffffff, 0xffff0000,  48, "LISP#crhill-xtr" },
	{ 0x261000d0, 0x11120000, 0xffffffff, 0xffff0000,  48, "LISP#smadley-xtr" },
	{ 0x261000d0, 0x11130000, 0xffffffff, 0xffff0000,  48, "LISP#mbirkner-xtr" },
	{ 0x261000d0, 0x11140000, 0xffffffff, 0xffff0000,  48, "LISP#attpoc-xtr" },
	{ 0x261000d0, 0x11150000, 0xffffffff, 0xffff0000,  48, "LISP#jemannin-xtr" },
	{ 0x261000d0, 0x11160000, 0xffffffff, 0xffff0000,  48, "LISP#chcoutur-xtr" },
	{ 0x261000d0, 0x11170000, 0xffffffff, 0xffff0000,  48, "LISP#bluethunder-xtr" },
	{ 0x261000d0, 0x11180000, 0xffffffff, 0xffff0000,  48, "LISP#marknguy-xtr" },
	{ 0x261000d0, 0x11190000, 0xffffffff, 0xffff0000,  48, "LISP#marcairn-xtr" },
	{ 0x261000d0, 0x111a0000, 0xffffffff, 0xffff0000,  48, "LISP#jason-xtr" },
	{ 0x261000d0, 0x111b0000, 0xffffffff, 0xffff0000,  48, "LISP#groff-xtr" },
	{ 0x261000d0, 0x111d0000, 0xffffffff, 0xffff0000,  48, "LISP#mwhitley-xtr" },
	{ 0x261000d0, 0x111e0000, 0xffffffff, 0xffff0000,  48, "LISP#attpoc-xtr-2" },
	{ 0x261000d0, 0x111f0000, 0xffffffff, 0xffff0000,  48, "LISP#dlapiper-xtr" },
	{ 0x261000d0, 0x11200000, 0xffffffff, 0xffff0000,  48, "LISP#manjeet-xtr" },
	{ 0x261000d0, 0x11210000, 0xffffffff, 0xffff0000,  48, "LISP#dudek-xtr" },
	{ 0x261000d0, 0x11220000, 0xffffffff, 0xffff0000,  48, "LISP#georgy-xtr" },
	{ 0x261000d0, 0x11230000, 0xffffffff, 0xffff0000,  48, "LISP#cbc-xtr" },
	{ 0x261000d0, 0x11240000, 0xffffffff, 0xffff0000,  48, "LISP#jhippen-xtr" },
	{ 0x261000d0, 0x11250000, 0xffffffff, 0xffff0000,  48, "LISP#garydla-xtr" },
	{ 0x261000d0, 0x11260000, 0xffffffff, 0xffff0000,  48, "LISP#scalan-xtr" },
	{ 0x261000d0, 0x11270000, 0xffffffff, 0xffff0000,  48, "LISP#donkdla-xtr" },
	{ 0x261000d0, 0x11280000, 0xffffffff, 0xffff0000,  48, "LISP#jamwheat-xtr" },
	{ 0x261000d0, 0x11290000, 0xffffffff, 0xffff0000,  48, "LISP#umissouri-xtr" },
	{ 0x261000d0, 0x112a0000, 0xffffffff, 0xffff0000,  48, "LISP#uvahs-xtr" },
	{ 0x261000d0, 0x112b0000, 0xffffffff, 0xffff0000,  48, "LISP#zavarce-xtr" },
	{ 0x261000d0, 0x112c0000, 0xffffffff, 0xffff0000,  48, "LISP#jansen-xtr" },
	{ 0x261000d0, 0x112d0000, 0xffffffff, 0xffff0000,  48, "LISP#netorian-xtr" },
	{ 0x261000d0, 0x112e0000, 0xffffffff, 0xffff0000,  48, "LISP#chris-ge-xtr" },
	{ 0x261000d0, 0x112f0000, 0xffffffff, 0xffff0000,  48, "LISP#ineteng-xtr" },
	{ 0x261000d0, 0x11300000, 0xffffffff, 0xffff0000,  48, "LISP#force3a-xtr" },
	{ 0x261000d0, 0x11310000, 0xffffffff, 0xffff0000,  48, "LISP#force3b-xtr" },
	{ 0x261000d0, 0x11320000, 0xffffffff, 0xffff0000,  48, "LISP#force3-xtr" },
	{ 0x261000d0, 0x11330000, 0xffffffff, 0xffff0000,  48, "LISP#wason-xtr" },
	{ 0x261000d0, 0x11340000, 0xffffffff, 0xffff0000,  48, "LISP#c819-LTE-xtr" },
	{ 0x261000d0, 0x11350000, 0xffffffff, 0xffff0000,  48, "LISP#schlutter-xtr" },
	{ 0x261000d0, 0x11360000, 0xffffffff, 0xffff0000,  48, "LISP#bguldan-xtr" },
	{ 0x261000d0, 0x11370000, 0xffffffff, 0xffff0000,  48, "LISP#naasief-xtr" },
	{ 0x261000d0, 0x11380000, 0xffffffff, 0xffff0000,  48, "LISP#ciecior-xtr" },
	{ 0x261000d0, 0x11390000, 0xffffffff, 0xffff0000,  48, "LISP#coopergeneral-xtr" },
	{ 0x261000d0, 0x113a0000, 0xffffffff, 0xffff0000,  48, "LISP#plixer-xtr" },
	{ 0x261000d0, 0x113b0000, 0xffffffff, 0xffff0000,  48, "LISP#halifaxmediagroup-xtr" },
	{ 0x261000d0, 0x113c0000, 0xffffffff, 0xffff0000,  48, "LISP#ec2test-xtr" },
	{ 0x261000d0, 0x113d0000, 0xffffffff, 0xffff0000,  48, "LISP#perry-xtr" },
	{ 0x261000d0, 0x113e0000, 0xffffffff, 0xffff0000,  48, "LISP#fortinet-xtr" },
	{ 0x261000d0, 0x113f0000, 0xffffffff, 0xffff0000,  48, "LISP#djustice-xtr" },
	{ 0x261000d0, 0x11400000, 0xffffffff, 0xffff0000,  48, "LISP#apparatus-xtr" },
	{ 0x261000d0, 0x11410000, 0xffffffff, 0xffff0000,  48, "LISP#cdw-xtr" },
	{ 0x261000d0, 0x11420000, 0xffffffff, 0xffff0000,  48, "LISP#krunal-xtr" },
	{ 0x261000d0, 0x11430000, 0xffffffff, 0xffff0000,  48, "LISP#gar-xtr" },
	{ 0x261000d0, 0x11440000, 0xffffffff, 0xffff0000,  48, "LISP#jbert-xtr" },
	{ 0x261000d0, 0x11450000, 0xffffffff, 0xffff0000,  48, "LISP#rajiva-xtr" },
	{ 0x261000d0, 0x11460000, 0xffffffff, 0xffff0000,  48, "LISP#oneok-xtr" },
	{ 0x261000d0, 0x11470000, 0xffffffff, 0xffff0000,  48, "LISP#sjury-xtr" },
	{ 0x261000d0, 0x11480000, 0xffffffff, 0xffff0000,  48, "LISP#dbuleza-xtr" },
	{ 0x261000d0, 0x11490000, 0xffffffff, 0xffff0000,  48, "LISP#tommille-xtr" },
	{ 0x261000d0, 0x114a0000, 0xffffffff, 0xffff0000,  48, "LISP#uer3-xtr" },
	{ 0x261000d0, 0x114b0000, 0xffffffff, 0xffff0000,  48, "LISP#tdstelecom-xtr" },
	{ 0x261000d0, 0x114c0000, 0xffffffff, 0xffff0000,  48, "LISP#dustin-xtr" },
	{ 0x261000d0, 0x114d0000, 0xffffffff, 0xffff0000,  48, "LISP#jpcaron-xtr" },
	{ 0x261000d0, 0x114e0000, 0xffffffff, 0xffff0000,  48, "LISP#pogue-xtr" },
	{ 0x261000d0, 0x114f0000, 0xffffffff, 0xffff0000,  48, "LISP#msales-xtr" },
	{ 0x261000d0, 0x11500000, 0xffffffff, 0xffff0000,  48, "LISP#spisati-xtr-2" },
	{ 0x261000d0, 0x11510000, 0xffffffff, 0xffff0000,  48, "LISP#lprat-xtr" },
	{ 0x261000d0, 0x11520000, 0xffffffff, 0xffff0000,  48, "LISP#triple-xtr" },
	{ 0x261000d0, 0x11530000, 0xffffffff, 0xffff0000,  48, "LISP#cmich-xtr" },
	{ 0x261000d0, 0x11540000, 0xffffffff, 0xffff0000,  48, "LISP#rtajvar-xtr" },
	{ 0x261000d0, 0x11550000, 0xffffffff, 0xffff0000,  48, "LISP#snicholas-xtr" },
	{ 0x261000d0, 0x11560000, 0xffffffff, 0xffff0000,  48, "LISP#nist-xtr" },
	{ 0x261000d0, 0x12020000, 0xffffffff, 0xffff0000,  48, "LISP#icox-xtr" },
	{ 0x261000d0, 0x12030000, 0xffffffff, 0xffff0000,  48, "LISP#gregg-xtr" },
	{ 0x261000d0, 0x12050000, 0xffffffff, 0xffff0000,  48, "LISP#snoble-xtr" },
	{ 0x261000d0, 0x12060000, 0xffffffff, 0xffff0000,  48, "LISP#dalvarez-xtr" },
	{ 0x261000d0, 0x12070000, 0xffffffff, 0xffff0000,  48, "LISP#ucla-xtr" },
	{ 0x261000d0, 0x12080000, 0xffffffff, 0xffff0000,  48, "LISP#asr1knat64-xtr" },
	{ 0x261000d0, 0x120a0000, 0xffffffff, 0xffff0000,  48, "LISP#tosterbe-xtr" },
	{ 0x261000d0, 0x120b0000, 0xffffffff, 0xffff0000,  48, "LISP#srin-xtr" },
	{ 0x261000d0, 0x120c0000, 0xffffffff, 0xffff0000,  48, "LISP#wwt-xtr" },
	{ 0x261000d0, 0x120d0000, 0xffffffff, 0xffff0000,  48, "LISP#qcom-corp-xtr" },
	{ 0x261000d0, 0x120f0000, 0xffffffff, 0xffff0000,  48, "LISP#wally-world-xtr" },
	{ 0x261000d0, 0x12110000, 0xffffffff, 0xffff0000,  48, "LISP#amit-xtr" },
	{ 0x261000d0, 0x12120000, 0xffffffff, 0xffff0000,  48, "LISP#srin-demo-xtr" },
	{ 0x261000d0, 0x12130000, 0xffffffff, 0xffff0000,  48, "LISP#stevenca-xtr" },
	{ 0x261000d0, 0x12140000, 0xffffffff, 0xffff0000,  48, "LISP#jearango-xtr" },
	{ 0x261000d0, 0x12150000, 0xffffffff, 0xffff0000,  48, "LISP#sulrich-xtr" },
	{ 0x261000d0, 0x12160000, 0xffffffff, 0xffff0000,  48, "LISP#manishee-xtr" },
	{ 0x261000d0, 0x12170000, 0xffffffff, 0xffff0000,  48, "LISP#aaronm-xtr" },
	{ 0x261000d0, 0x12180000, 0xffffffff, 0xffff0000,  48, "LISP#samuel-xtr" },
	{ 0x261000d0, 0x121a0000, 0xffffffff, 0xffff0000,  48, "LISP#fabio-new-mn" },
	{ 0x261000d0, 0x121b0000, 0xffffffff, 0xffff0000,  48, "LISP#nmaadara-xtr" },
	{ 0x261000d0, 0x121c0000, 0xffffffff, 0xffff0000,  48, "LISP#liguori-xtr" },
	{ 0x261000d0, 0x121d0000, 0xffffffff, 0xffff0000,  48, "LISP#kecorbin-xtr" },
	{ 0x261000d0, 0x121e0000, 0xffffffff, 0xffff0000,  48, "LISP#dstsyst-xtr" },
	{ 0x261000d0, 0x12200000, 0xffffffff, 0xffff0000,  48, "LISP#ufrj-xtr" },
	{ 0x261000d0, 0x12210000, 0xffffffff, 0xffff0000,  48, "LISP#machilde-xtr" },
	{ 0x261000d0, 0x12220000, 0xffffffff, 0xffff0000,  48, "LISP#jessica-xtr" },
	{ 0x261000d0, 0x12230000, 0xffffffff, 0xffff0000,  48, "LISP#archana-xtr" },
	{ 0x261000d0, 0x12240000, 0xffffffff, 0xffff0000,  48, "LISP#jadumars-xtr" },
	{ 0x261000d0, 0x12250000, 0xffffffff, 0xffff0000,  48, "LISP#gorhughe-xtr" },
	{ 0x261000d0, 0x12260000, 0xffffffff, 0xffff0000,  48, "LISP#gbumgard-xtr" },
	{ 0x261000d0, 0x12270000, 0xffffffff, 0xffff0000,  48, "LISP#chuljin-xtr" },
	{ 0x261000d0, 0x12280000, 0xffffffff, 0xffff0000,  48, "LISP#linh-xtr" },
	{ 0x261000d0, 0x12290000, 0xffffffff, 0xffff0000,  48, "LISP#sfu-bcnet-xtr" },
	{ 0x261000d0, 0x122a0000, 0xffffffff, 0xffff0000,  48, "LISP#dipsingh-xtr" },
	{ 0x261000d0, 0x122b0000, 0xffffffff, 0xffff0000,  48, "LISP#trevlac-xtr" },
	{ 0x261000d0, 0x122c0000, 0xffffffff, 0xffff0000,  48, "LISP#robert-cdw-xtr" },
	{ 0x261000d0, 0x122d0000, 0xffffffff, 0xffff0000,  48, "LISP#parna-lev-xtr" },
	{ 0x261000d0, 0x122e0000, 0xffffffff, 0xffff0000,  48, "LISP#rob-cdw-xtr" },
	{ 0x261000d0, 0x122f0000, 0xffffffff, 0xffff0000,  48, "LISP#scv-xtr" },
	{ 0x261000d0, 0x12300000, 0xffffffff, 0xffff0000,  48, "LISP#muabid-xtr" },
	{ 0x261000d0, 0x12310000, 0xffffffff, 0xffff0000,  48, "LISP#steve-apple-xtr" },
	{ 0x261000d0, 0x12320000, 0xffffffff, 0xffff0000,  48, "LISP#kleinart-xtr" },
	{ 0x261000d0, 0x12330000, 0xffffffff, 0xffff0000,  48, "LISP#akennedy-xtr" },
	{ 0x261000d0, 0x12340000, 0xffffffff, 0xffff0000,  48, "LISP#jcolin-xtr" },
	{ 0x261000d0, 0x12350000, 0xffffffff, 0xffff0000,  48, "LISP#rbonnell-xtr" },
	{ 0x261000d0, 0x12360000, 0xffffffff, 0xffff0000,  48, "LISP#jalberti-xtr" },
	{ 0x261000d0, 0x12370000, 0xffffffff, 0xffff0000,  48, "LISP#cisco-natal2-xtr" },
	{ 0x261000d0, 0x12380000, 0xffffffff, 0xffff0000,  48, "LISP#lfiegl-xtr" },
	{ 0x261000d0, 0x12390000, 0xffffffff, 0xffff0000,  48, "LISP#upc-arin-xtr" },
	{ 0x261000d0, 0x123a0000, 0xffffffff, 0xffff0000,  48, "LISP#azure-xtr" },
	{ 0x261000d0, 0x13020000, 0xffffffff, 0xffff0000,  48, "LISP#wnellis-xtr" },
	{ 0x261000d0, 0x13030000, 0xffffffff, 0xffff0000,  48, "LISP#darrel-xtr" },
	{ 0x261000d0, 0x13040000, 0xffffffff, 0xffff0000,  48, "LISP#vaf-xtr" },
	{ 0x261000d0, 0x13050000, 0xffffffff, 0xffff0000,  48, "LISP#vl-openwrt1-xtr" },
	{ 0x261000d0, 0x13060000, 0xffffffff, 0xffff0000,  48, "LISP#vl-openwrt2-xtr" },
	{ 0x261000d0, 0x13070000, 0xffffffff, 0xffff0000,  48, "LISP#vl-openwrt3-xtr" },
	{ 0x261000d0, 0x13080000, 0xffffffff, 0xffff0000,  48, "LISP#zhicheng-xtr" },
	{ 0x261000d0, 0x13090000, 0xffffffff, 0xffff0000,  48, "LISP#nattrav-test-arin" },
	{ 0x261000d0, 0x130a0000, 0xffffffff, 0xffff0000,  48, "LISP#djcalif-xtr" },
	{ 0x261000d0, 0x130b0000, 0xffffffff, 0xffff0000,  48, "LISP#dehrle1-xtr" },
	{ 0x261000d0, 0x130c0000, 0xffffffff, 0xffff0000,  48, "LISP#divya-xtr" },
	{ 0x261000d0, 0x130d0000, 0xffffffff, 0xffff0000,  48, "LISP#jhennessy-xtr" },
	{ 0x261000d0, 0x130e0000, 0xffffffff, 0xffff0000,  48, "LISP#martin-xtr" },
	{ 0x261000d0, 0x130f0000, 0xffffffff, 0xffff0000,  48, "LISP#dehrle2-xtr" },
	{ 0x261000d0, 0x13100000, 0xffffffff, 0xffff0000,  48, "LISP#chanu-xtr" },
	{ 0x261000d0, 0x13110000, 0xffffffff, 0xffff0000,  48, "LISP#lierop-xtr" },
	{ 0x261000d0, 0x13120000, 0xffffffff, 0xffff0000,  48, "LISP#cmh-xtr" },
	{ 0x261000d0, 0x13140000, 0xffffffff, 0xffff0000,  48, "LISP#mhaaksma-xtr" },
	{ 0x261000d0, 0x13150000, 0xffffffff, 0xffff0000,  48, "LISP#tellis-xtr" },
	{ 0x261000d0, 0x13160000, 0xffffffff, 0xffff0000,  48, "LISP#jade-xtr" },
	{ 0x261000d0, 0x13170000, 0xffffffff, 0xffff0000,  48, "LISP#neno-xtr" },
	{ 0x261000d0, 0x13180000, 0xffffffff, 0xffff0000,  48, "LISP#elsen-xtr" },
	{ 0x261000d0, 0x132a0000, 0xffffffff, 0xffff0000,  48, "LISP#comfort-xtr" },
	{ 0x261000d0, 0x21000000, 0xffffffff, 0xffff0000,  48, "LISP#thkernen-xtr" },
	{ 0x261000d0, 0x21010000, 0xffffffff, 0xffff0000,  48, "LISP#gerd-xtr" },
	{ 0x261000d0, 0x21020000, 0xffffffff, 0xffff0000,  48, "LISP#luigi-xtr" },
	{ 0x261000d0, 0x21030000, 0xffffffff, 0xffff0000,  48, "LISP#damien-xtr" },
	{ 0x261000d0, 0x21040000, 0xffffffff, 0xffff0000,  48, "LISP#jakab-xtr" },
	{ 0x261000d0, 0x21050000, 0xffffffff, 0xffff0000,  48, "LISP#dino-xtr" },
	{ 0x261000d0, 0x21060000, 0xffffffff, 0xffff0000,  48, "LISP#lbromirs-xtr" },
	{ 0x261000d0, 0x21070000, 0xffffffff, 0xffff0000,  48, "LISP#wolfgang-client-xtr" },
	{ 0x261000d0, 0x21080000, 0xffffffff, 0xffff0000,  48, "LISP#simlo-xtr" },
	{ 0x261000d0, 0x21090000, 0xffffffff, 0xffff0000,  48, "LISP#wolfgang-odd-xtr" },
	{ 0x261000d0, 0x210a0000, 0xffffffff, 0xffff0000,  48, "LISP#wolfgang-even-xtr" },
	{ 0x261000d0, 0x210b0000, 0xffffffff, 0xffff0000,  48, "LISP#jesper-xtr" },
	{ 0x261000d0, 0x210c0000, 0xffffffff, 0xffff0000,  48, "LISP#isidor-xtr" },
	{ 0x261000d0, 0x210d0000, 0xffffffff, 0xffff0000,  48, "LISP#jobsnijders-home-xtr" },
	{ 0x261000d0, 0x210e0000, 0xffffffff, 0xffff0000,  48, "LISP#intouch-office-xtr" },
	{ 0x261000d0, 0x210f0000, 0xffffffff, 0xffff0000,  48, "LISP#intouch-dc1-xtr-1" },
	{ 0x261000d0, 0x21100000, 0xffffffff, 0xffff0000,  48, "LISP#intouch-dc2-xtr-1" },
	{ 0x261000d0, 0x21110000, 0xffffffff, 0xffff0000,  48, "LISP#lukasm-xtr" },
	{ 0x261000d0, 0x21120000, 0xffffffff, 0xffff0000,  48, "LISP#marc-xtr" },
	{ 0x261000d0, 0x21130000, 0xffffffff, 0xffff0000,  48, "LISP#deutsche-bank-xtr" },
	{ 0x261000d0, 0x21140000, 0xffffffff, 0xffff0000,  48, "LISP#gerd-cbc-xtr" },
	{ 0x261000d0, 0x21150000, 0xffffffff, 0xffff0000,  48, "LISP#65bit-xtr" },
	{ 0x261000d0, 0x21160000, 0xffffffff, 0xffff0000,  48, "LISP#rolfs-xtr" },
	{ 0x261000d0, 0x21170000, 0xffffffff, 0xffff0000,  48, "LISP#dimitris-xtr" },
	{ 0x261000d0, 0x21180000, 0xffffffff, 0xffff0000,  48, "LISP#markus-xtr" },
	{ 0x261000d0, 0x21190000, 0xffffffff, 0xffff0000,  48, "LISP#mkramoli-xtr" },
	{ 0x261000d0, 0x211a0000, 0xffffffff, 0xffff0000,  48, "LISP#pcharalampou-xtr" },
	{ 0x261000d0, 0x211c0000, 0xffffffff, 0xffff0000,  48, "LISP#mironto-xtr" },
	{ 0x261000d0, 0x211d0000, 0xffffffff, 0xffff0000,  48, "LISP#munich-arpt-xtr" },
	{ 0x261000d0, 0x211e0000, 0xffffffff, 0xffff0000,  48, "LISP#mitko-xtr" },
	{ 0x261000d0, 0x211f0000, 0xffffffff, 0xffff0000,  48, "LISP#isarnet-xtr" },
	{ 0x261000d0, 0x21200000, 0xffffffff, 0xffff0000,  48, "LISP#tetaneutral-xtr" },
	{ 0x261000d0, 0x21210000, 0xffffffff, 0xffff0000,  48, "LISP#lip6-fr-xtr" },
	{ 0x261000d0, 0x21220000, 0xffffffff, 0xffff0000,  48, "LISP#korpo-tp-xtr" },
	{ 0x261000d0, 0x21230000, 0xffffffff, 0xffff0000,  48, "LISP#mbosecki-xtr" },
	{ 0x261000d0, 0x21240000, 0xffffffff, 0xffff0000,  48, "LISP#experteach-xtr" },
	{ 0x261000d0, 0x21250000, 0xffffffff, 0xffff0000,  48, "LISP#globalknowledge-xtr" },
	{ 0x261000d0, 0x21260000, 0xffffffff, 0xffff0000,  48, "LISP#moreas-xtr" },
	{ 0x261000d0, 0x21270000, 0xffffffff, 0xffff0000,  48, "LISP#bayer-xtr" },
	{ 0x261000d0, 0x21280000, 0xffffffff, 0xffff0000,  48, "LISP#giheron-xtr" },
	{ 0x261000d0, 0x21290000, 0xffffffff, 0xffff0000,  48, "LISP#antoine-xtr" },
	{ 0x261000d0, 0x212a0000, 0xffffffff, 0xffff0000,  48, "LISP#uniroma-xtr" },
	{ 0x261000d0, 0x212b0000, 0xffffffff, 0xffff0000,  48, "LISP#mcenteme-xtr" },
	{ 0x261000d0, 0x212c0000, 0xffffffff, 0xffff0000,  48, "LISP#jjstevens-xtr" },
	{ 0x261000d0, 0x212d0000, 0xffffffff, 0xffff0000,  48, "LISP#planete-xtr" },
	{ 0x261000d0, 0x212e0000, 0xffffffff, 0xffff0000,  48, "LISP#atle-xtr" },
	{ 0x261000d0, 0x21300000, 0xffffffff, 0xffff0000,  48, "LISP#geert-xtr" },
	{ 0x261000d0, 0x21310000, 0xffffffff, 0xffff0000,  48, "LISP#zilina-xtr" },
	{ 0x261000d0, 0x21320000, 0xffffffff, 0xffff0000,  48, "LISP#chrisgray-xtr" },
	{ 0x261000d0, 0x21340000, 0xffffffff, 0xffff0000,  48, "LISP#mblokzij-xtr" },
	{ 0x261000d0, 0x21350000, 0xffffffff, 0xffff0000,  48, "LISP#ataf-xtr" },
	{ 0x261000d0, 0x21360000, 0xffffffff, 0xffff0000,  48, "LISP#adittman-xtr" },
	{ 0x261000d0, 0x21370000, 0xffffffff, 0xffff0000,  48, "LISP#runar-xtr" },
	{ 0x261000d0, 0x21380000, 0xffffffff, 0xffff0000,  48, "LISP#iceland-xtr" },
	{ 0x261000d0, 0x21390000, 0xffffffff, 0xffff0000,  48, "LISP#raabo-xtr" },
	{ 0x261000d0, 0x213a0000, 0xffffffff, 0xffff0000,  48, "LISP#alex-xtr" },
	{ 0x261000d0, 0x213b0000, 0xffffffff, 0xffff0000,  48, "LISP#avm-gmbh1-xtr" },
	{ 0x261000d0, 0x213c0000, 0xffffffff, 0xffff0000,  48, "LISP#avm-gmbh2-xtr" },
	{ 0x261000d0, 0x213d0000, 0xffffffff, 0xffff0000,  48, "LISP#francesco-xtr" },
	{ 0x261000d0, 0x213e0000, 0xffffffff, 0xffff0000,  48, "LISP#fraunhofer-igd-xtr" },
	{ 0x261000d0, 0x21400000, 0xffffffff, 0xffff0000,  48, "LISP#smirnov-xtr" },
	{ 0x261000d0, 0x21410000, 0xffffffff, 0xffff0000,  48, "LISP#cegal-xtr" },
	{ 0x261000d0, 0x21420000, 0xffffffff, 0xffff0000,  48, "LISP#gloudemans-xtr" },
	{ 0x261000d0, 0x21430000, 0xffffffff, 0xffff0000,  48, "LISP#claes-xtr" },
	{ 0x261000d0, 0x21440000, 0xffffffff, 0xffff0000,  48, "LISP#hu-uasu-xtr" },
	{ 0x261000d0, 0x21450000, 0xffffffff, 0xffff0000,  48, "LISP#umurcia-1-xtr" },
	{ 0x261000d0, 0x21460000, 0xffffffff, 0xffff0000,  48, "LISP#umurcia-2-xtr" },
	{ 0x261000d0, 0x21470000, 0xffffffff, 0xffff0000,  48, "LISP#umurcia-3-xtr" },
	{ 0x261000d0, 0x21490000, 0xffffffff, 0xffff0000,  48, "LISP#hauschild-xtr" },
	{ 0x261000d0, 0x214a0000, 0xffffffff, 0xffff0000,  48, "LISP#cat6k-demo-uk" },
	{ 0x261000d0, 0x214b0000, 0xffffffff, 0xffff0000,  48, "LISP#roel-xtr" },
	{ 0x261000d0, 0x214c0000, 0xffffffff, 0xffff0000,  48, "LISP#clemens-xtr" },
	{ 0x261000d0, 0x214d0000, 0xffffffff, 0xffff0000,  48, "LISP#fit-xtr" },
	{ 0x261000d0, 0x214e0000, 0xffffffff, 0xffff0000,  48, "LISP#level-it-xtr" },
	{ 0x261000d0, 0x214f0000, 0xffffffff, 0xffff0000,  48, "LISP#AVM01-xtr" },
	{ 0x261000d0, 0x21500000, 0xffffffff, 0xffff0000,  48, "LISP#AVM02-xtr" },
	{ 0x261000d0, 0x21510000, 0xffffffff, 0xffff0000,  48, "LISP#AVM03-xtr" },
	{ 0x261000d0, 0x21520000, 0xffffffff, 0xffff0000,  48, "LISP#AVM04-xtr" },
	{ 0x261000d0, 0x21530000, 0xffffffff, 0xffff0000,  48, "LISP#AVM05-xtr" },
	{ 0x261000d0, 0x21540000, 0xffffffff, 0xffff0000,  48, "LISP#AVM06-xtr" },
	{ 0x261000d0, 0x21550000, 0xffffffff, 0xffff0000,  48, "LISP#AVM07-xtr" },
	{ 0x261000d0, 0x21560000, 0xffffffff, 0xffff0000,  48, "LISP#AVM08-xtr" },
	{ 0x261000d0, 0x21570000, 0xffffffff, 0xffff0000,  48, "LISP#AVM09-xtr" },
	{ 0x261000d0, 0x21580000, 0xffffffff, 0xffff0000,  48, "LISP#vz-niko-ch" },
	{ 0x261000d0, 0x21590000, 0xffffffff, 0xffff0000,  48, "LISP#dipesh-xtr" },
	{ 0x261000d0, 0x215a0000, 0xffffffff, 0xffff0000,  48, "LISP#quenzer-xtr" },
	{ 0x261000d0, 0x215b0000, 0xffffffff, 0xffff0000,  48, "LISP#turnerhouse-xtr" },
	{ 0x261000d0, 0x215c0000, 0xffffffff, 0xffff0000,  48, "LISP#lhsystems-xtr" },
	{ 0x261000d0, 0x215d0000, 0xffffffff, 0xffff0000,  48, "LISP#coudron-xtr" },
	{ 0x261000d0, 0x215e0000, 0xffffffff, 0xffff0000,  48, "LISP#hubers-xtr" },
	{ 0x261000d0, 0x215f0000, 0xffffffff, 0xffff0000,  48, "LISP#woellhaf-xtr" },
	{ 0x261000d0, 0x21600000, 0xffffffff, 0xffff0000,  48, "LISP#damjan-xtr" },
	{ 0x261000d0, 0x21610000, 0xffffffff, 0xffff0000,  48, "LISP#leander-xtr" },
	{ 0x261000d0, 0x21620000, 0xffffffff, 0xffff0000,  48, "LISP#nikolay-xtr" },
	{ 0x261000d0, 0x21630000, 0xffffffff, 0xffff0000,  48, "LISP#moritz-xtr" },
	{ 0x261000d0, 0x21640000, 0xffffffff, 0xffff0000,  48, "LISP#skonecki-xtr" },
	{ 0x261000d0, 0x21650000, 0xffffffff, 0xffff0000,  48, "LISP#thoene-xtr" },
	{ 0x261000d0, 0x21660000, 0xffffffff, 0xffff0000,  48, "LISP#lori-xtr" },
	{ 0x261000d0, 0x21670000, 0xffffffff, 0xffff0000,  48, "LISP#reitz-xtr" },
	{ 0x261000d0, 0x21680000, 0xffffffff, 0xffff0000,  48, "LISP#jerome-xtr" },
	{ 0x261000d0, 0x21690000, 0xffffffff, 0xffff0000,  48, "LISP#netcloud-xtr" },
	{ 0x261000d0, 0x216a0000, 0xffffffff, 0xffff0000,  48, "LISP#dschulz-xtr" },
	{ 0x261000d0, 0x216b0000, 0xffffffff, 0xffff0000,  48, "LISP#atea-xtr" },
	{ 0x261000d0, 0x216c0000, 0xffffffff, 0xffff0000,  48, "LISP#atea2-xtr" },
	{ 0x261000d0, 0x216d0000, 0xffffffff, 0xffff0000,  48, "LISP#cschmidt-xtr" },
	{ 0x261000d0, 0x216e0000, 0xffffffff, 0xffff0000,  48, "LISP#eantc-xtr" },
	{ 0x261000d0, 0x216f0000, 0xffffffff, 0xffff0000,  48, "LISP#sleiweke-xtr" },
	{ 0x261000d0, 0x21700000, 0xffffffff, 0xffff0000,  48, "LISP#marcel-xtr" },
	{ 0x261000d0, 0x21710000, 0xffffffff, 0xffff0000,  48, "LISP#goudswaard-xtr" },
	{ 0x261000d0, 0x21720000, 0xffffffff, 0xffff0000,  48, "LISP#axel-xtr" },
	{ 0x261000d0, 0x21730000, 0xffffffff, 0xffff0000,  48, "LISP#trieb-xtr" },
	{ 0x261000d0, 0x21740000, 0xffffffff, 0xffff0000,  48, "LISP#strasser-xtr" },
	{ 0x261000d0, 0x21750000, 0xffffffff, 0xffff0000,  48, "LISP#haase-xtr" },
	{ 0x261000d0, 0x21760000, 0xffffffff, 0xffff0000,  48, "LISP#hendrickx-xtr" },
	{ 0x261000d0, 0x21770000, 0xffffffff, 0xffff0000,  48, "LISP#keronet-xtr" },
	{ 0x261000d0, 0x21780000, 0xffffffff, 0xffff0000,  48, "LISP#sarton-xtr" },
	{ 0x261000d0, 0x21790000, 0xffffffff, 0xffff0000,  48, "LISP#nattrav-test" },
	{ 0x261000d0, 0x217a0000, 0xffffffff, 0xffff0000,  48, "LISP#ermidoro-xtr" },
	{ 0x261000d0, 0x217b0000, 0xffffffff, 0xffff0000,  48, "LISP#scv-xtr" },
	{ 0x261000d0, 0x217c0000, 0xffffffff, 0xffff0000,  48, "LISP#rjm-xtr" },
	{ 0x261000d0, 0x217d0000, 0xffffffff, 0xffff0000,  48, "LISP#answanso-xtr" },
	{ 0x261000d0, 0x217e0000, 0xffffffff, 0xffff0000,  48, "LISP#strehhuber-xtr" },
	{ 0x261000d0, 0x217f0000, 0xffffffff, 0xffff0000,  48, "LISP#hintermayr-xtr" },
	{ 0x261000d0, 0x21800000, 0xffffffff, 0xffff0000,  48, "LISP#gruber-xtr" },
	{ 0x261000d0, 0x21810000, 0xffffffff, 0xffff0000,  48, "LISP#boardrunner-xtr" },
	{ 0x261000d0, 0x21820000, 0xffffffff, 0xffff0000,  48, "LISP#adwin-xtr" },
	{ 0x261000d0, 0x21830000, 0xffffffff, 0xffff0000,  48, "LISP#bartschnet-xtr" },
	{ 0x261000d0, 0x21840000, 0xffffffff, 0xffff0000,  48, "LISP#netgaroo-xtr" },
	{ 0x261000d0, 0x21850000, 0xffffffff, 0xffff0000,  48, "LISP#gensonline-xtr" },
	{ 0x261000d0, 0x21860000, 0xffffffff, 0xffff0000,  48, "LISP#nuage-lisp-xtr" },
	{ 0x261000d0, 0x21870000, 0xffffffff, 0xffff0000,  48, "LISP#ch-marcel-xtr" },
	{ 0x261000d0, 0x21880000, 0xffffffff, 0xffff0000,  48, "LISP#uaveiro-xtr" },
	{ 0x261000d0, 0x21890000, 0xffffffff, 0xffff0000,  48, "LISP#caspary-xtr" },
	{ 0x261000d0, 0x218a0000, 0xffffffff, 0xffff0000,  48, "LISP#maxried-xtr" },
	{ 0x261000d0, 0x218b0000, 0xffffffff, 0xffff0000,  48, "LISP#yun-xtr" },
	{ 0x261000d0, 0x218c0000, 0xffffffff, 0xffff0000,  48, "LISP#tietze-xtr" },
	{ 0x261000d0, 0x218d0000, 0xffffffff, 0xffff0000,  48, "LISP#jkuhn-xtr" },
	{ 0x261000d0, 0x218e0000, 0xffffffff, 0xffff0000,  48, "LISP#a1-telekom-xtr" },
	{ 0x261000d0, 0x218f0000, 0xffffffff, 0xffff0000,  48, "LISP#renne-xtr" },
	{ 0x261000d0, 0x21900000, 0xffffffff, 0xffff0000,  48, "LISP#mblokzij-pi-xtr" },
	{ 0x261000d0, 0x21910000, 0xffffffff, 0xffff0000,  48, "LISP#lueers-xtr" },
	{ 0x261000d0, 0x21920000, 0xffffffff, 0xffff0000,  48, "LISP#hkoerth-xtr" },
	{ 0x261000d0, 0x21930000, 0xffffffff, 0xffff0000,  48, "LISP#nclark-xtr" },
	{ 0x261000d0, 0x21940000, 0xffffffff, 0xffff0000,  48, "LISP#teridion-xtr" },
	{ 0x261000d0, 0x21950000, 0xffffffff, 0xffff0000,  48, "LISP#mgrabner-xtr" },
	{ 0x261000d0, 0x21960000, 0xffffffff, 0xffff0000,  48, "LISP#albring-xtr" },
	{ 0x261000d0, 0x21970000, 0xffffffff, 0xffff0000,  48, "LISP#kmartini-xtr" },
	{ 0x261000d0, 0x21980000, 0xffffffff, 0xffff0000,  48, "LISP#hs-fulda-xtr" },
	{ 0x261000d0, 0x21990000, 0xffffffff, 0xffff0000,  48, "LISP#datenschleuder-xtr" },
	{ 0x261000d0, 0x219a0000, 0xffffffff, 0xffff0000,  48, "LISP#airmaxx-xtr" },
	{ 0x261000d0, 0x219b0000, 0xffffffff, 0xffff0000,  48, "LISP#kewisch-xtr" },
	{ 0x261000d0, 0x219c0000, 0xffffffff, 0xffff0000,  48, "LISP#cybernet-xtr" },
	{ 0x261000d0, 0x219d0000, 0xffffffff, 0xffff0000,  48, "LISP#krzbia-xtr" },
	{ 0x261000d0, 0x219e0000, 0xffffffff, 0xffff0000,  48, "LISP#twarwick-xtr" },
	{ 0x261000d0, 0x219f0000, 0xffffffff, 0xffff0000,  48, "LISP#fuhge-xtr" },
	{ 0x261000d0, 0x21a00000, 0xffffffff, 0xffff0000,  48, "LISP#isah-xtr" },
	{ 0x261000d0, 0x21a10000, 0xffffffff, 0xffff0000,  48, "LISP#lovison-xtr" },
	{ 0x261000d0, 0x21a20000, 0xffffffff, 0xffff0000,  48, "LISP#jens-xtr" },
	{ 0x261000d0, 0x21a30000, 0xffffffff, 0xffff0000,  48, "LISP#naundorf-xtr" },
	{ 0x261000d0, 0x21a40000, 0xffffffff, 0xffff0000,  48, "LISP#leon-xtr" },
	{ 0x261000d0, 0x21a50000, 0xffffffff, 0xffff0000,  48, "LISP#orottler-xtr" },
	{ 0x261000d0, 0x21a60000, 0xffffffff, 0xffff0000,  48, "LISP#gschell-xtr" },
	{ 0x261000d0, 0x21a70000, 0xffffffff, 0xffff0000,  48, "LISP#x10103-xtr" },
	{ 0x261000d0, 0x21a80000, 0xffffffff, 0xffff0000,  48, "LISP#jps-networks-xtr" },
	{ 0x261000d0, 0x21a90000, 0xffffffff, 0xffff0000,  48, "LISP#mamouni-xtr" },
	{ 0x261000d0, 0x21aa0000, 0xffffffff, 0xffff0000,  48, "LISP#hakkarainen-xtr" },
	{ 0x261000d0, 0x21ab0000, 0xffffffff, 0xffff0000,  48, "LISP#posteo-xtr" },
	{ 0x261000d0, 0x21ac0000, 0xffffffff, 0xffff0000,  48, "LISP#pierson-xtr" },
	{ 0x261000d0, 0x21ad0000, 0xffffffff, 0xffff0000,  48, "LISP#hulsmann-xtr" },
	{ 0x261000d0, 0x21ae0000, 0xffffffff, 0xffff0000,  48, "LISP#mdavids-xtr" },
	{ 0x261000d0, 0x21af0000, 0xffffffff, 0xffff0000,  48, "LISP#erikbent-xtr" },
	{ 0x261000d0, 0x21b00000, 0xffffffff, 0xffff0000,  48, "LISP#CiscoConnect-xtr" },
	{ 0x261000d0, 0x21b10000, 0xffffffff, 0xffff0000,  48, "LISP#polimi-xtr" },
	{ 0x261000d0, 0x21b20000, 0xffffffff, 0xffff0000,  48, "LISP#panix-xtr" },
	{ 0x261000d0, 0x21b30000, 0xffffffff, 0xffff0000,  48, "LISP#glindhart-xtr" },
	{ 0x261000d0, 0x21b40000, 0xffffffff, 0xffff0000,  48, "LISP#dimensiondata-xtr" },
	{ 0x261000d0, 0x21b50000, 0xffffffff, 0xffff0000,  48, "LISP#pcforce-xtr" },
	{ 0x261000d0, 0x21b60000, 0xffffffff, 0xffff0000,  48, "LISP#plotnicu-xtr" },
	{ 0x261000d0, 0x21b70000, 0xffffffff, 0xffff0000,  48, "LISP#zimperfeld-xtr" },
	{ 0x261000d0, 0x21b80000, 0xffffffff, 0xffff0000,  48, "LISP#vanlid-xtr" },
	{ 0x261000d0, 0x21b90000, 0xffffffff, 0xffff0000,  48, "LISP#kohlstedde-xtr" },
	{ 0x261000d0, 0x21ba0000, 0xffffffff, 0xffff0000,  48, "LISP#wiegleb-xtr" },
	{ 0x261000d0, 0x21bb0000, 0xffffffff, 0xffff0000,  48, "LISP#dirks-xtr" },
	{ 0x261000d0, 0x21bc0000, 0xffffffff, 0xffff0000,  48, "LISP#cbursch-xtr" },
	{ 0x261000d0, 0x21bd0000, 0xffffffff, 0xffff0000,  48, "LISP#aflorio-cz-xtr" },
	{ 0x261000d0, 0x21be0000, 0xffffffff, 0xffff0000,  48, "LISP#aflorio-it-xtr" },
	{ 0x261000d0, 0x21bf0000, 0xffffffff, 0xffff0000,  48, "LISP#vz-niko-ge" },
	{ 0x261000d0, 0x21c00000, 0xffffffff, 0xffff0000,  48, "LISP#vz-niko-de" },
	{ 0x261000d0, 0x21c10000, 0xffffffff, 0xffff0000,  48, "LISP#voos-xtr" },
	{ 0x261000d0, 0x21c20000, 0xffffffff, 0xffff0000,  48, "LISP#plominski-xtr" },
	{ 0x261000d0, 0x21c30000, 0xffffffff, 0xffff0000,  48, "LISP#eison-xtr" },
	{ 0x261000d0, 0x21c40000, 0xffffffff, 0xffff0000,  48, "LISP#a1-telekom2-xtr" },
	{ 0x261000d0, 0x21c50000, 0xffffffff, 0xffff0000,  48, "LISP#nord-west-xtr" },
	{ 0x261000d0, 0x21c60000, 0xffffffff, 0xffff0000,  48, "LISP#frank-xtr" },
	{ 0x261000d0, 0x21c70000, 0xffffffff, 0xffff0000,  48, "LISP#uni-obuda-xtr" },
	{ 0x261000d0, 0x21c80000, 0xffffffff, 0xffff0000,  48, "LISP#raiffeisen-hu-xtr" },
	{ 0x261000d0, 0x21c90000, 0xffffffff, 0xffff0000,  48, "LISP#dev252-xtr" },
	{ 0x261000d0, 0x21ca0000, 0xffffffff, 0xffff0000,  48, "LISP#smit-hague-xtr" },
	{ 0x261000d0, 0x21cb0000, 0xffffffff, 0xffff0000,  48, "LISP#gierschner-xtr" },
	{ 0x261000d0, 0x21cc0000, 0xffffffff, 0xffff0000,  48, "LISP#lukasm2-xtr" },
	{ 0x261000d0, 0x21cd0000, 0xffffffff, 0xffff0000,  48, "LISP#sacherer-xtr" },
	{ 0x261000d0, 0x21ce0000, 0xffffffff, 0xffff0000,  48, "LISP#gunis-xtr" },
	{ 0x261000d0, 0x21cf0000, 0xffffffff, 0xffff0000,  48, "LISP#hilger-xtr" },
	{ 0x261000d0, 0x21d00000, 0xffffffff, 0xffff0000,  48, "LISP#schad-xtr" },
	{ 0x261000d0, 0x21d10000, 0xffffffff, 0xffff0000,  48, "LISP#hagenhoff-xtr" },
	{ 0x261000d0, 0x21d20000, 0xffffffff, 0xffff0000,  48, "LISP#ibm-gr-xtr" },
	{ 0x261000d0, 0x21d30000, 0xffffffff, 0xffff0000,  48, "LISP#coldharbour-xtr" },
	{ 0x261000d0, 0x21d40000, 0xffffffff, 0xffff0000,  48, "LISP#bach-xtr" },
	{ 0x261000d0, 0x21d50000, 0xffffffff, 0xffff0000,  48, "LISP#jschmidle-xtr" },
	{ 0x261000d0, 0x21d60000, 0xffffffff, 0xffff0000,  48, "LISP#zilina2-xtr" },
	{ 0x261000d0, 0x21d70000, 0xffffffff, 0xffff0000,  48, "LISP#dogscafe-xtr" },
	{ 0x261000d0, 0x21d80000, 0xffffffff, 0xffff0000,  48, "LISP#mgliwka-xtr" },
	{ 0x261000d0, 0x21d90000, 0xffffffff, 0xffff0000,  48, "LISP#krunal-eu-xtr" },
	{ 0x261000d0, 0x21da0000, 0xffffffff, 0xffff0000,  48, "LISP#cstephens-xtr-1" },
	{ 0x261000d0, 0x21db0000, 0xffffffff, 0xffff0000,  48, "LISP#demierre-xtr" },
	{ 0x261000d0, 0x21dc0000, 0xffffffff, 0xffff0000,  48, "LISP#somogyvari-xtr" },
	{ 0x261000d0, 0x21dd0000, 0xffffffff, 0xffff0000,  48, "LISP#spisati-xtr" },
	{ 0x261000d0, 0x21de0000, 0xffffffff, 0xffff0000,  48, "LISP#tao-networks-xtr" },
	{ 0x261000d0, 0x21df0000, 0xffffffff, 0xffff0000,  48, "LISP#willekens-xtr" },
	{ 0x261000d0, 0x21e00000, 0xffffffff, 0xffff0000,  48, "LISP#jclayton-xtr" },
	{ 0x261000d0, 0x21e10000, 0xffffffff, 0xffff0000,  48, "LISP#niek-xtr" },
	{ 0x261000d0, 0x21e20000, 0xffffffff, 0xffff0000,  48, "LISP#mbar-xtr" },
	{ 0x261000d0, 0x21e30000, 0xffffffff, 0xffff0000,  48, "LISP#lsd-xtr" },
	{ 0x261000d0, 0x21e40000, 0xffffffff, 0xffff0000,  48, "LISP#rfurda-xtr" },
	{ 0x261000d0, 0x21e50000, 0xffffffff, 0xffff0000,  48, "LISP#gmaricau-xtr" },
	{ 0x261000d0, 0x21e70000, 0xffffffff, 0xffff0000,  48, "LISP#dzeitler-xtr" },
	{ 0x261000d0, 0x21e80000, 0xffffffff, 0xffff0000,  48, "LISP#garndt-xtr" },
	{ 0x261000d0, 0x21e90000, 0xffffffff, 0xffff0000,  48, "LISP#jpreuss-xtr" },
	{ 0x261000d0, 0x21ea0000, 0xffffffff, 0xffff0000,  48, "LISP#smondwurf-xtr" },
	{ 0x261000d0, 0x21eb0000, 0xffffffff, 0xffff0000,  48, "LISP#tbonitz-xtr" },
	{ 0x261000d0, 0x21ec0000, 0xffffffff, 0xffff0000,  48, "LISP#cisco-natal1-xtr" },
	{ 0x261000d0, 0x21ed0000, 0xffffffff, 0xffff0000,  48, "LISP#cglasmeyer-xtr" },
	{ 0x261000d0, 0x21ee0000, 0xffffffff, 0xffff0000,  48, "LISP#rengel-xtr" },
	{ 0x261000d0, 0x21ef0000, 0xffffffff, 0xffff0000,  48, "LISP#hgojny-xtr" },
	{ 0x261000d0, 0x21f10000, 0xffffffff, 0xffff0000,  48, "LISP#rkohn-xtr" },
	{ 0x261000d0, 0x21f20000, 0xffffffff, 0xffff0000,  48, "LISP#jpkoegeler-xtr" },
	{ 0x261000d0, 0x21f30000, 0xffffffff, 0xffff0000,  48, "LISP#gniederwimmer-xtr" },
	{ 0x261000d0, 0x21f50000, 0xffffffff, 0xffff0000,  48, "LISP#mmikulenas-xtr" },
	{ 0x261000d0, 0x21f60000, 0xffffffff, 0xffff0000,  48, "LISP#cbretterhofer-xtr" },
	{ 0x261000d0, 0x21f70000, 0xffffffff, 0xffff0000,  48, "LISP#mgoebel-xtr" },
	{ 0x261000d0, 0x21f80000, 0xffffffff, 0xffff0000,  48, "LISP#bmorcinkowski-xtr" },
	{ 0x261000d0, 0x21f90000, 0xffffffff, 0xffff0000,  48, "LISP#jbaumann-xtr" },
	{ 0x261000d0, 0x21fa0000, 0xffffffff, 0xffff0000,  48, "LISP#mfey-xtr" },
	{ 0x261000d0, 0x21fb0000, 0xffffffff, 0xffff0000,  48, "LISP#mmuller-xtr" },
	{ 0x261000d0, 0x21fc0000, 0xffffffff, 0xffff0000,  48, "LISP#rjud-xtr" },
	{ 0x261000d0, 0x21fd0000, 0xffffffff, 0xffff0000,  48, "LISP#theinz-xtr" },
	{ 0x261000d0, 0x21fe0000, 0xffffffff, 0xffff0000,  48, "LISP#fzahn-xtr" },
	{ 0x261000d0, 0x22000000, 0xffffffff, 0xffff0000,  48, "LISP#ahugi-xtr" },
	{ 0x261000d0, 0x22010000, 0xffffffff, 0xffff0000,  48, "LISP#niekvanderven-xtr" },
	{ 0x261000d0, 0x22020000, 0xffffffff, 0xffff0000,  48, "LISP#jdechert-xtr" },
	{ 0x261000d0, 0x22030000, 0xffffffff, 0xffff0000,  48, "LISP#crothlander-xtr" },
	{ 0x261000d0, 0x22050000, 0xffffffff, 0xffff0000,  48, "LISP#wvanlid-xtr" },
	{ 0x261000d0, 0x22060000, 0xffffffff, 0xffff0000,  48, "LISP#upc-oor-xtr" },
	{ 0x261000d0, 0x22080000, 0xffffffff, 0xffff0000,  48, "LISP#tivano-software-xtr" },
	{ 0x261000d0, 0x22090000, 0xffffffff, 0xffff0000,  48, "LISP#ngunther-xtr" },
	{ 0x261000d0, 0x220a0000, 0xffffffff, 0xffff0000,  48, "LISP#gthor-xtr" },
	{ 0x261000d0, 0x220b0000, 0xffffffff, 0xffff0000,  48, "LISP#wonken-xtr" },
	{ 0x261000d0, 0x220d0000, 0xffffffff, 0xffff0000,  48, "LISP#tzapala-xtr" },
	{ 0x261000d0, 0x220e0000, 0xffffffff, 0xffff0000,  48, "LISP#rmller-xtr" },
	{ 0x261000d0, 0x22100000, 0xffffffff, 0xffff0000,  48, "LISP#feul-xtr" },
	{ 0x261000d0, 0x22110000, 0xffffffff, 0xffff0000,  48, "LISP#asunnetci-xtr" },
	{ 0x261000d0, 0x22130000, 0xffffffff, 0xffff0000,  48, "LISP#dfett-xtr" },
	{ 0x261000d0, 0x22140000, 0xffffffff, 0xffff0000,  48, "LISP#mklingspor-xtr" },
	{ 0x261000d0, 0x22150000, 0xffffffff, 0xffff0000,  48, "LISP#gsanjay-xtr" },
	{ 0x261000d0, 0x22160000, 0xffffffff, 0xffff0000,  48, "LISP#tkoch-xtr" },
	{ 0x261000d0, 0x22170000, 0xffffffff, 0xffff0000,  48, "LISP#hrenz-xtr" },
	{ 0x261000d0, 0x22180000, 0xffffffff, 0xffff0000,  48, "LISP#blawall-xtr" },
	{ 0x261000d0, 0x22190000, 0xffffffff, 0xffff0000,  48, "LISP#unitbv-xtr" },
	{ 0x261000d0, 0x222a0000, 0xffffffff, 0xffff0000,  48, "LISP#hketele-xtr" },
	{ 0x261000d0, 0x222b0000, 0xffffffff, 0xffff0000,  48, "LISP#rdchragner-xtr" },
	{ 0x261000d0, 0x222c0000, 0xffffffff, 0xffff0000,  48, "LISP#mamin-xtr" },
	{ 0x261000d0, 0x222e0000, 0xffffffff, 0xffff0000,  48, "LISP#twittenberg-xtr" },
	{ 0x261000d0, 0x222f0000, 0xffffffff, 0xffff0000,  48, "LISP#bwieder-xtr" },
	{ 0x261000d0, 0x22300000, 0xffffffff, 0xffff0000,  48, "LISP#sbethge-xtr" },
	{ 0x261000d0, 0x22310000, 0xffffffff, 0xffff0000,  48, "LISP#jdornauf-xtr" },
	{ 0x261000d0, 0x22330000, 0xffffffff, 0xffff0000,  48, "LISP#mmiller-xtr" },
	{ 0x261000d0, 0x22340000, 0xffffffff, 0xffff0000,  48, "LISP#cfertig-xtr" },
	{ 0x261000d0, 0x22350000, 0xffffffff, 0xffff0000,  48, "LISP#jkatolla-xtr" },
	{ 0x261000d0, 0x22360000, 0xffffffff, 0xffff0000,  48, "LISP#freenet-xtr" },
	{ 0x261000d0, 0x22370000, 0xffffffff, 0xffff0000,  48, "LISP#nweissbach-xtr" },
	{ 0x261000d0, 0x22380000, 0xffffffff, 0xffff0000,  48, "LISP#owas-xtr" },
	{ 0x261000d0, 0x22390000, 0xffffffff, 0xffff0000,  48, "LISP#rspickers-xtr" },
	{ 0x261000d0, 0x223a0000, 0xffffffff, 0xffff0000,  48, "LISP#pcech-xtr" },
	{ 0x261000d0, 0x223b0000, 0xffffffff, 0xffff0000,  48, "LISP#cpalm-xtr" },
	{ 0x261000d0, 0x223c0000, 0xffffffff, 0xffff0000,  48, "LISP#asellmann-xtr" },
	{ 0x261000d0, 0x223d0000, 0xffffffff, 0xffff0000,  48, "LISP#mluckert-xtr" },
	{ 0x261000d0, 0x223e0000, 0xffffffff, 0xffff0000,  48, "LISP#tzimmermann-xtr" },
	{ 0x261000d0, 0x223f0000, 0xffffffff, 0xffff0000,  48, "LISP#dpeshev-xtr" },
	{ 0x261000d0, 0x31000000, 0xffffffff, 0xffff0000,  48, "LISP#iij-xtr" },
	{ 0x261000d0, 0x32000000, 0xffffffff, 0xffff0000,  48, "LISP#hughes-xtr" },
	{ 0x261000d0, 0x32010000, 0xffffffff, 0xffff0000,  48, "LISP#apan-xtr" },
	{ 0x261000d0, 0x32020000, 0xffffffff, 0xffff0000,  48, "LISP#kddi-labs-xtr" },
	{ 0x261000d0, 0x32030000, 0xffffffff, 0xffff0000,  48, "LISP#ntt-com-xtr" },
	{ 0x261000d0, 0x32040000, 0xffffffff, 0xffff0000,  48, "LISP#tata-xtr" },
	{ 0x261000d0, 0x32050000, 0xffffffff, 0xffff0000,  48, "LISP#jiwang-xtr" },
	{ 0x261000d0, 0x32060000, 0xffffffff, 0xffff0000,  48, "LISP#layim-xtr" },
	{ 0x261000d0, 0x32070000, 0xffffffff, 0xffff0000,  48, "LISP#cfwong-xtr" },
	{ 0x261000d0, 0x32080000, 0xffffffff, 0xffff0000,  48, "LISP#logicalis-xtr" },
	{ 0x261000d0, 0x32090000, 0xffffffff, 0xffff0000,  48, "LISP#cht-xtr" },
	{ 0x261000d0, 0x320a0000, 0xffffffff, 0xffff0000,  48, "LISP#oasis-tech-xtr" },
	{ 0x261000d0, 0x320b0000, 0xffffffff, 0xffff0000,  48, "LISP#wide-xtr" },
	{ 0x261000d0, 0x320c0000, 0xffffffff, 0xffff0000,  48, "LISP#mingchow-xtr" },
	{ 0x261000d0, 0x320d0000, 0xffffffff, 0xffff0000,  48, "LISP#jiwang2-xtr" },
	{ 0x261000d0, 0x320e0000, 0xffffffff, 0xffff0000,  48, "LISP#fnsc-xtr" },
	{ 0x261000d0, 0x320f0000, 0xffffffff, 0xffff0000,  48, "LISP#nagoya-u-xtr" },
	{ 0x261000d0, 0x32100000, 0xffffffff, 0xffff0000,  48, "LISP#yuyarin-xtr" },
	{ 0x261000d0, 0x32110000, 0xffffffff, 0xffff0000,  48, "LISP#matsumoto-xtr" },
	{ 0x261000d0, 0x32120000, 0xffffffff, 0xffff0000,  48, "LISP#vhan-xtr" },
	{ 0x261000d0, 0x32130000, 0xffffffff, 0xffff0000,  48, "LISP#alphawest-xtr" },
	{ 0x261000d0, 0x32140000, 0xffffffff, 0xffff0000,  48, "LISP#mra4d-xtr" },
	{ 0x261000d0, 0x32150000, 0xffffffff, 0xffff0000,  48, "LISP#uet-vnu-xtr" },
	{ 0x261000d0, 0x32160000, 0xffffffff, 0xffff0000,  48, "LISP#pgear-xtr" },
	{ 0x261000d0, 0x32170000, 0xffffffff, 0xffff0000,  48, "LISP#pccw-xtr" },
	{ 0x261000d0, 0x32180000, 0xffffffff, 0xffff0000,  48, "LISP#fitac-xtr" },
	{ 0x261000d0, 0x32190000, 0xffffffff, 0xffff0000,  48, "LISP#layim2-xtr" },
	{ 0x261000d0, 0x321a0000, 0xffffffff, 0xffff0000,  48, "LISP#daniel-xtr-1" },
	{ 0x261000d0, 0x321b0000, 0xffffffff, 0xffff0000,  48, "LISP#daniel-xtr-2" },
	{ 0x261000d0, 0x321c0000, 0xffffffff, 0xffff0000,  48, "LISP#daniel-xtr-3" },
	{ 0x261000d0, 0x321e0000, 0xffffffff, 0xffff0000,  48, "LISP#hongang-xtr" },
	{ 0x261000d0, 0x321f0000, 0xffffffff, 0xffff0000,  48, "LISP#chaney-xtr" },
	{ 0x261000d0, 0x32200000, 0xffffffff, 0xffff0000,  48, "LISP#kozuka-xtr" },
	{ 0x261000d0, 0x32210000, 0xffffffff, 0xffff0000,  48, "LISP#nattrav-test-apnic" },
	{ 0x261000d0, 0x32220000, 0xffffffff, 0xffff0000,  48, "LISP#ydpark-xtr" },
	{ 0x261000d0, 0x32230000, 0xffffffff, 0xffff0000,  48, "LISP#farhadsh-xtr" },
	{ 0x261000d0, 0x32240000, 0xffffffff, 0xffff0000,  48, "LISP#hawthorne-xtr" },
	{ 0x261000d0, 0x32250000, 0xffffffff, 0xffff0000,  48, "LISP#hyunsoo-xtr" },
	{ 0x261000d0, 0x32260000, 0xffffffff, 0xffff0000,  48, "LISP#ykenu-xtr" },
	{ 0x261000d0, 0x32270000, 0xffffffff, 0xffff0000,  48, "LISP#gsik-xtr" },
	{ 0x261000d0, 0x32280000, 0xffffffff, 0xffff0000,  48, "LISP#yshiin-xtr" },
	{ 0x261000d0, 0x32290000, 0xffffffff, 0xffff0000,  48, "LISP#tao-networks2-xtr" },
	{ 0x261000d0, 0x322a0000, 0xffffffff, 0xffff0000,  48, "LISP#rdines-xtr" },
	{ 0x261000d0, 0x322b0000, 0xffffffff, 0xffff0000,  48, "LISP#upc-oor2-xtr" },
	{ 0x261000d0, 0x322c0000, 0xffffffff, 0xffff0000,  48, "LISP#ietf100-xtr" },
	{ 0x261000d0, 0x322d0000, 0xffffffff, 0xffff0000,  48, "LISP#sukiyaki-proj-xtr" },
	{ 0x261000d0, 0x322e0000, 0xffffffff, 0xffff0000,  48, "LISP#sukiyaki2-proj-xtr" },
	{ 0x261000d0, 0x322f0000, 0xffffffff, 0xffff0000,  48, "LISP#gtja-xtr" },
	{ 0x261000d0, 0x32300000, 0xffffffff, 0xffff0000,  48, "LISP#hcmus-xtr" },
	{ 0x261000d0, 0x32310000, 0xffffffff, 0xffff0000,  48, "LISP#amacuz-xtr" },
	{ 0x261000d0, 0x323f0000, 0xffffffff, 0xffff0000,  48, "LISP#gs9591-xtr" },
	{ 0x261000d0, 0x50000000, 0xffffffff, 0xffff0000,  48, "LISP#ufba-xtr" },
	{ 0x261000d0, 0xface0000, 0xffffffff, 0xffff0000,  48, "LISP#facebook-xtr-2" },
};
