/*
 * Copyright 2018 Igor Maznitsa.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.igormaznitsa.jbbp.model;

/**
 * The Interface describes array which elements can be provided as number or boolean.
 *
 * @since 1.4.0
 */
public interface JBBPNumericArray {

  /**
   * Get element as integer.
   *
   * @param index index of element in array
   * @return the element as integer
   */
  int getAsInt(int index);

  /**
   * Get element as long.
   *
   * @param index index of element in array
   * @return the element as long
   */
  long getAsLong(int index);

  /**
   * Get element as boolean.
   *
   * @param index index of element in array
   * @return the element as boolean
   */
  boolean getAsBool(final int index);

}
