# Setup a macro for compiling resources ...
MACRO(K3D_COMPILE_RESOURCE OUTPUT INPUT RESOURCE_PATH)

	SET(INPUT_FILE "${CMAKE_CURRENT_SOURCE_DIR}/${INPUT}")
	SET(OUTPUT_FILE "${CMAKE_CURRENT_BINARY_DIR}/${INPUT}.cpp")
	GET_FILENAME_COMPONENT(OUTPUT_PATH ${OUTPUT_FILE} PATH)

	GET_TARGET_PROPERTY(K3D_RESOURCE_COMPILER k3d-resource-compiler LOCATION)

	ADD_CUSTOM_COMMAND(
		DEPENDS k3d-resource-compiler
		DEPENDS ${INPUT_FILE}
		COMMAND ${CMAKE_COMMAND} -E make_directory ${OUTPUT_PATH}
		COMMAND ${K3D_RESOURCE_COMPILER} --input ${INPUT_FILE} --path \"<path>${RESOURCE_PATH}</path>\" --output ${OUTPUT_FILE}
		OUTPUT ${OUTPUT_FILE}
		COMMENT "Compiling resource ${INPUT_FILE}"
		)

	LIST(APPEND ${OUTPUT} ${OUTPUT_FILE})

ENDMACRO(K3D_COMPILE_RESOURCE)
