/* ============================================================
 *
 * This file is a part of KDE project
 *
 *
 * Date        : 2010-02-01
 * Description : a kipi plugin to export images to Picasa web service
 *
 * Copyright (C) 2010 by Jens Mueller <tschenser at gmx dot de>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

#include "newalbumdlg.h"

// Qt includes

#include <QFormLayout>
#include <QVBoxLayout>
#include <QHBoxLayout>
#include <QGroupBox>
#include <QRadioButton>
#include <QDialogButtonBox>
#include <QIcon>
#include <QApplication>
#include <QPushButton>

namespace KIPIImageshackPlugin
{

NewAlbumDlg::NewAlbumDlg(QWidget* const parent, const QString& pluginName)
    : KPNewAlbumDialog(parent, pluginName)
{
    hideDateTime();
    hideDesc();
    hideLocation();
    getMainWidget()->setMinimumSize(300,0);
}

NewAlbumDlg::~NewAlbumDlg()
{
}

QString NewAlbumDlg::getAlbumTitle()
{
    return getTitleEdit()->text();
}

} // namespace KIPIImageshackPlugin
