
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2024 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQImageCapture.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QImageCapture>
#include <QChildEvent>
#include <QEvent>
#include <QImage>
#include <QMediaCaptureSession>
#include <QMediaMetaData>
#include <QMetaMethod>
#include <QObject>
#include <QSize>
#include <QThread>
#include <QTimerEvent>
#include <QVideoFrame>
#include "gsiQt.h"
#include "gsiQtMultimediaCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QImageCapture

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QImageCapture::staticMetaObject);
}


// void QImageCapture::addMetaData(const QMediaMetaData &metaData)


static void _init_f_addMetaData_2643 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("metaData");
  decl->add_arg<const QMediaMetaData & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_addMetaData_2643 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMediaMetaData &arg1 = gsi::arg_reader<const QMediaMetaData & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QImageCapture *)cls)->addMetaData (arg1);
}


// int QImageCapture::capture()


static void _init_f_capture_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_capture_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QImageCapture *)cls)->capture ());
}


// QMediaCaptureSession *QImageCapture::captureSession()


static void _init_f_captureSession_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMediaCaptureSession * > ();
}

static void _call_f_captureSession_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QMediaCaptureSession * > ((QMediaCaptureSession *)((QImageCapture *)cls)->captureSession ());
}


// int QImageCapture::captureToFile(const QString &location)


static void _init_f_captureToFile_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("location", true, "QString()");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_captureToFile_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = args ? gsi::arg_reader<const QString & >() (args, heap) : gsi::arg_maker<const QString & >() (QString(), heap);
  ret.write<int > ((int)((QImageCapture *)cls)->captureToFile (arg1));
}


// QImageCapture::Error QImageCapture::error()


static void _init_f_error_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QImageCapture::Error>::target_type > ();
}

static void _call_f_error_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QImageCapture::Error>::target_type > ((qt_gsi::Converter<QImageCapture::Error>::target_type)qt_gsi::CppToQtAdaptor<QImageCapture::Error>(((QImageCapture *)cls)->error ()));
}


// void QImageCapture::errorChanged()


static void _init_f_errorChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_errorChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QImageCapture *)cls)->errorChanged ();
}


// void QImageCapture::errorOccurred(int id, QImageCapture::Error error, const QString &errorString)


static void _init_f_errorOccurred_4938 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("id");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("error");
  decl->add_arg<const qt_gsi::Converter<QImageCapture::Error>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("errorString");
  decl->add_arg<const QString & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_errorOccurred_4938 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const qt_gsi::Converter<QImageCapture::Error>::target_type & arg2 = gsi::arg_reader<const qt_gsi::Converter<QImageCapture::Error>::target_type & >() (args, heap);
  const QString &arg3 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QImageCapture *)cls)->errorOccurred (arg1, qt_gsi::QtToCppAdaptor<QImageCapture::Error>(arg2).cref(), arg3);
}


// QString QImageCapture::errorString()


static void _init_f_errorString_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_errorString_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QImageCapture *)cls)->errorString ());
}


// QImageCapture::FileFormat QImageCapture::fileFormat()


static void _init_f_fileFormat_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QImageCapture::FileFormat>::target_type > ();
}

static void _call_f_fileFormat_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QImageCapture::FileFormat>::target_type > ((qt_gsi::Converter<QImageCapture::FileFormat>::target_type)qt_gsi::CppToQtAdaptor<QImageCapture::FileFormat>(((QImageCapture *)cls)->fileFormat ()));
}


// void QImageCapture::fileFormatChanged()


static void _init_f_fileFormatChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_fileFormatChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QImageCapture *)cls)->fileFormatChanged ();
}


// void QImageCapture::imageAvailable(int id, const QVideoFrame &frame)


static void _init_f_imageAvailable_3047 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("id");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("frame");
  decl->add_arg<const QVideoFrame & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_imageAvailable_3047 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const QVideoFrame &arg2 = gsi::arg_reader<const QVideoFrame & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QImageCapture *)cls)->imageAvailable (arg1, arg2);
}


// void QImageCapture::imageCaptured(int id, const QImage &preview)


static void _init_f_imageCaptured_2536 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("id");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("preview");
  decl->add_arg<const QImage & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_imageCaptured_2536 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const QImage &arg2 = gsi::arg_reader<const QImage & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QImageCapture *)cls)->imageCaptured (arg1, arg2);
}


// void QImageCapture::imageExposed(int id)


static void _init_f_imageExposed_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("id");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_imageExposed_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QImageCapture *)cls)->imageExposed (arg1);
}


// void QImageCapture::imageMetadataAvailable(int id, const QMediaMetaData &metaData)


static void _init_f_imageMetadataAvailable_3302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("id");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("metaData");
  decl->add_arg<const QMediaMetaData & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_imageMetadataAvailable_3302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const QMediaMetaData &arg2 = gsi::arg_reader<const QMediaMetaData & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QImageCapture *)cls)->imageMetadataAvailable (arg1, arg2);
}


// void QImageCapture::imageSaved(int id, const QString &fileName)


static void _init_f_imageSaved_2684 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("id");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("fileName");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_imageSaved_2684 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QImageCapture *)cls)->imageSaved (arg1, arg2);
}


// bool QImageCapture::isAvailable()


static void _init_f_isAvailable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isAvailable_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QImageCapture *)cls)->isAvailable ());
}


// bool QImageCapture::isReadyForCapture()


static void _init_f_isReadyForCapture_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isReadyForCapture_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QImageCapture *)cls)->isReadyForCapture ());
}


// QMediaMetaData QImageCapture::metaData()


static void _init_f_metaData_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMediaMetaData > ();
}

static void _call_f_metaData_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QMediaMetaData > ((QMediaMetaData)((QImageCapture *)cls)->metaData ());
}


// void QImageCapture::metaDataChanged()


static void _init_f_metaDataChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_metaDataChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QImageCapture *)cls)->metaDataChanged ();
}


// QImageCapture::Quality QImageCapture::quality()


static void _init_f_quality_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QImageCapture::Quality>::target_type > ();
}

static void _call_f_quality_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QImageCapture::Quality>::target_type > ((qt_gsi::Converter<QImageCapture::Quality>::target_type)qt_gsi::CppToQtAdaptor<QImageCapture::Quality>(((QImageCapture *)cls)->quality ()));
}


// void QImageCapture::qualityChanged()


static void _init_f_qualityChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_qualityChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QImageCapture *)cls)->qualityChanged ();
}


// void QImageCapture::readyForCaptureChanged(bool ready)


static void _init_f_readyForCaptureChanged_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("ready");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_readyForCaptureChanged_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QImageCapture *)cls)->readyForCaptureChanged (arg1);
}


// QSize QImageCapture::resolution()


static void _init_f_resolution_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_resolution_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QImageCapture *)cls)->resolution ());
}


// void QImageCapture::resolutionChanged()


static void _init_f_resolutionChanged_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_resolutionChanged_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QImageCapture *)cls)->resolutionChanged ();
}


// void QImageCapture::setFileFormat(QImageCapture::FileFormat format)


static void _init_f_setFileFormat_2841 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const qt_gsi::Converter<QImageCapture::FileFormat>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFileFormat_2841 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QImageCapture::FileFormat>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QImageCapture::FileFormat>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QImageCapture *)cls)->setFileFormat (qt_gsi::QtToCppAdaptor<QImageCapture::FileFormat>(arg1).cref());
}


// void QImageCapture::setMetaData(const QMediaMetaData &metaData)


static void _init_f_setMetaData_2643 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("metaData");
  decl->add_arg<const QMediaMetaData & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMetaData_2643 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMediaMetaData &arg1 = gsi::arg_reader<const QMediaMetaData & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QImageCapture *)cls)->setMetaData (arg1);
}


// void QImageCapture::setQuality(QImageCapture::Quality quality)


static void _init_f_setQuality_2585 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("quality");
  decl->add_arg<const qt_gsi::Converter<QImageCapture::Quality>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setQuality_2585 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QImageCapture::Quality>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QImageCapture::Quality>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QImageCapture *)cls)->setQuality (qt_gsi::QtToCppAdaptor<QImageCapture::Quality>(arg1).cref());
}


// void QImageCapture::setResolution(const QSize &)


static void _init_f_setResolution_1805 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QSize & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setResolution_1805 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QSize &arg1 = gsi::arg_reader<const QSize & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QImageCapture *)cls)->setResolution (arg1);
}


// void QImageCapture::setResolution(int width, int height)


static void _init_f_setResolution_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("width");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("height");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setResolution_1426 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int arg2 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QImageCapture *)cls)->setResolution (arg1, arg2);
}


// static QString QImageCapture::fileFormatDescription(QImageCapture::FileFormat c)


static void _init_f_fileFormatDescription_2841 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("c");
  decl->add_arg<const qt_gsi::Converter<QImageCapture::FileFormat>::target_type & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_fileFormatDescription_2841 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QImageCapture::FileFormat>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QImageCapture::FileFormat>::target_type & >() (args, heap);
  ret.write<QString > ((QString)QImageCapture::fileFormatDescription (qt_gsi::QtToCppAdaptor<QImageCapture::FileFormat>(arg1).cref()));
}


// static QString QImageCapture::fileFormatName(QImageCapture::FileFormat c)


static void _init_f_fileFormatName_2841 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("c");
  decl->add_arg<const qt_gsi::Converter<QImageCapture::FileFormat>::target_type & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_fileFormatName_2841 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QImageCapture::FileFormat>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QImageCapture::FileFormat>::target_type & >() (args, heap);
  ret.write<QString > ((QString)QImageCapture::fileFormatName (qt_gsi::QtToCppAdaptor<QImageCapture::FileFormat>(arg1).cref()));
}


// static QList<QImageCapture::FileFormat> QImageCapture::supportedFormats()


static void _init_f_supportedFormats_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QList<QImageCapture::FileFormat> > ();
}

static void _call_f_supportedFormats_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QImageCapture::FileFormat> > ((QList<QImageCapture::FileFormat>)QImageCapture::supportedFormats ());
}


// static QString QImageCapture::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QImageCapture::tr (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QImageCapture () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("addMetaData", "@brief Method void QImageCapture::addMetaData(const QMediaMetaData &metaData)\n", false, &_init_f_addMetaData_2643, &_call_f_addMetaData_2643);
  methods += new qt_gsi::GenericMethod ("capture", "@brief Method int QImageCapture::capture()\n", false, &_init_f_capture_0, &_call_f_capture_0);
  methods += new qt_gsi::GenericMethod ("captureSession", "@brief Method QMediaCaptureSession *QImageCapture::captureSession()\n", true, &_init_f_captureSession_c0, &_call_f_captureSession_c0);
  methods += new qt_gsi::GenericMethod ("captureToFile", "@brief Method int QImageCapture::captureToFile(const QString &location)\n", false, &_init_f_captureToFile_2025, &_call_f_captureToFile_2025);
  methods += new qt_gsi::GenericMethod ("error", "@brief Method QImageCapture::Error QImageCapture::error()\n", true, &_init_f_error_c0, &_call_f_error_c0);
  methods += new qt_gsi::GenericMethod ("errorChanged", "@brief Method void QImageCapture::errorChanged()\n", false, &_init_f_errorChanged_0, &_call_f_errorChanged_0);
  methods += new qt_gsi::GenericMethod ("errorOccurred", "@brief Method void QImageCapture::errorOccurred(int id, QImageCapture::Error error, const QString &errorString)\n", false, &_init_f_errorOccurred_4938, &_call_f_errorOccurred_4938);
  methods += new qt_gsi::GenericMethod ("errorString", "@brief Method QString QImageCapture::errorString()\n", true, &_init_f_errorString_c0, &_call_f_errorString_c0);
  methods += new qt_gsi::GenericMethod ("fileFormat", "@brief Method QImageCapture::FileFormat QImageCapture::fileFormat()\n", true, &_init_f_fileFormat_c0, &_call_f_fileFormat_c0);
  methods += new qt_gsi::GenericMethod ("fileFormatChanged", "@brief Method void QImageCapture::fileFormatChanged()\n", false, &_init_f_fileFormatChanged_0, &_call_f_fileFormatChanged_0);
  methods += new qt_gsi::GenericMethod ("imageAvailable", "@brief Method void QImageCapture::imageAvailable(int id, const QVideoFrame &frame)\n", false, &_init_f_imageAvailable_3047, &_call_f_imageAvailable_3047);
  methods += new qt_gsi::GenericMethod ("imageCaptured", "@brief Method void QImageCapture::imageCaptured(int id, const QImage &preview)\n", false, &_init_f_imageCaptured_2536, &_call_f_imageCaptured_2536);
  methods += new qt_gsi::GenericMethod ("imageExposed", "@brief Method void QImageCapture::imageExposed(int id)\n", false, &_init_f_imageExposed_767, &_call_f_imageExposed_767);
  methods += new qt_gsi::GenericMethod ("imageMetadataAvailable", "@brief Method void QImageCapture::imageMetadataAvailable(int id, const QMediaMetaData &metaData)\n", false, &_init_f_imageMetadataAvailable_3302, &_call_f_imageMetadataAvailable_3302);
  methods += new qt_gsi::GenericMethod ("imageSaved", "@brief Method void QImageCapture::imageSaved(int id, const QString &fileName)\n", false, &_init_f_imageSaved_2684, &_call_f_imageSaved_2684);
  methods += new qt_gsi::GenericMethod ("isAvailable?", "@brief Method bool QImageCapture::isAvailable()\n", true, &_init_f_isAvailable_c0, &_call_f_isAvailable_c0);
  methods += new qt_gsi::GenericMethod ("isReadyForCapture?", "@brief Method bool QImageCapture::isReadyForCapture()\n", true, &_init_f_isReadyForCapture_c0, &_call_f_isReadyForCapture_c0);
  methods += new qt_gsi::GenericMethod ("metaData", "@brief Method QMediaMetaData QImageCapture::metaData()\n", true, &_init_f_metaData_c0, &_call_f_metaData_c0);
  methods += new qt_gsi::GenericMethod ("metaDataChanged", "@brief Method void QImageCapture::metaDataChanged()\n", false, &_init_f_metaDataChanged_0, &_call_f_metaDataChanged_0);
  methods += new qt_gsi::GenericMethod ("quality", "@brief Method QImageCapture::Quality QImageCapture::quality()\n", true, &_init_f_quality_c0, &_call_f_quality_c0);
  methods += new qt_gsi::GenericMethod ("qualityChanged", "@brief Method void QImageCapture::qualityChanged()\n", false, &_init_f_qualityChanged_0, &_call_f_qualityChanged_0);
  methods += new qt_gsi::GenericMethod ("readyForCaptureChanged", "@brief Method void QImageCapture::readyForCaptureChanged(bool ready)\n", false, &_init_f_readyForCaptureChanged_864, &_call_f_readyForCaptureChanged_864);
  methods += new qt_gsi::GenericMethod ("resolution", "@brief Method QSize QImageCapture::resolution()\n", true, &_init_f_resolution_c0, &_call_f_resolution_c0);
  methods += new qt_gsi::GenericMethod ("resolutionChanged", "@brief Method void QImageCapture::resolutionChanged()\n", false, &_init_f_resolutionChanged_0, &_call_f_resolutionChanged_0);
  methods += new qt_gsi::GenericMethod ("setFileFormat", "@brief Method void QImageCapture::setFileFormat(QImageCapture::FileFormat format)\n", false, &_init_f_setFileFormat_2841, &_call_f_setFileFormat_2841);
  methods += new qt_gsi::GenericMethod ("setMetaData", "@brief Method void QImageCapture::setMetaData(const QMediaMetaData &metaData)\n", false, &_init_f_setMetaData_2643, &_call_f_setMetaData_2643);
  methods += new qt_gsi::GenericMethod ("setQuality", "@brief Method void QImageCapture::setQuality(QImageCapture::Quality quality)\n", false, &_init_f_setQuality_2585, &_call_f_setQuality_2585);
  methods += new qt_gsi::GenericMethod ("setResolution", "@brief Method void QImageCapture::setResolution(const QSize &)\n", false, &_init_f_setResolution_1805, &_call_f_setResolution_1805);
  methods += new qt_gsi::GenericMethod ("setResolution", "@brief Method void QImageCapture::setResolution(int width, int height)\n", false, &_init_f_setResolution_1426, &_call_f_setResolution_1426);
  methods += new qt_gsi::GenericStaticMethod ("fileFormatDescription", "@brief Static method QString QImageCapture::fileFormatDescription(QImageCapture::FileFormat c)\nThis method is static and can be called without an instance.", &_init_f_fileFormatDescription_2841, &_call_f_fileFormatDescription_2841);
  methods += new qt_gsi::GenericStaticMethod ("fileFormatName", "@brief Static method QString QImageCapture::fileFormatName(QImageCapture::FileFormat c)\nThis method is static and can be called without an instance.", &_init_f_fileFormatName_2841, &_call_f_fileFormatName_2841);
  methods += new qt_gsi::GenericStaticMethod ("supportedFormats", "@brief Static method QList<QImageCapture::FileFormat> QImageCapture::supportedFormats()\nThis method is static and can be called without an instance.", &_init_f_supportedFormats_0, &_call_f_supportedFormats_0);
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QImageCapture::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  return methods;
}

gsi::Class<QObject> &qtdecl_QObject ();

qt_gsi::QtNativeClass<QImageCapture> decl_QImageCapture (qtdecl_QObject (), "QtMultimedia", "QImageCapture_Native",
  methods_QImageCapture (),
  "@hide\n@alias QImageCapture");

GSI_QTMULTIMEDIA_PUBLIC gsi::Class<QImageCapture> &qtdecl_QImageCapture () { return decl_QImageCapture; }

}


class QImageCapture_Adaptor : public QImageCapture, public qt_gsi::QtObjectBase
{
public:

  virtual ~QImageCapture_Adaptor();

  //  [adaptor ctor] QImageCapture::QImageCapture(QObject *parent)
  QImageCapture_Adaptor() : QImageCapture()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QImageCapture::QImageCapture(QObject *parent)
  QImageCapture_Adaptor(QObject *parent) : QImageCapture(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] bool QImageCapture::isSignalConnected(const QMetaMethod &signal)
  bool fp_QImageCapture_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QImageCapture::isSignalConnected(signal);
  }

  //  [expose] int QImageCapture::receivers(const char *signal)
  int fp_QImageCapture_receivers_c1731 (const char *signal) const {
    return QImageCapture::receivers(signal);
  }

  //  [expose] QObject *QImageCapture::sender()
  QObject * fp_QImageCapture_sender_c0 () const {
    return QImageCapture::sender();
  }

  //  [expose] int QImageCapture::senderSignalIndex()
  int fp_QImageCapture_senderSignalIndex_c0 () const {
    return QImageCapture::senderSignalIndex();
  }

  //  [adaptor impl] bool QImageCapture::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QImageCapture::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QImageCapture_Adaptor, bool, QEvent *>(&QImageCapture_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QImageCapture::event(_event);
    }
  }

  //  [adaptor impl] bool QImageCapture::eventFilter(QObject *watched, QEvent *event)
  bool cbs_eventFilter_2411_0(QObject *watched, QEvent *event)
  {
    return QImageCapture::eventFilter(watched, event);
  }

  virtual bool eventFilter(QObject *watched, QEvent *event)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QImageCapture_Adaptor, bool, QObject *, QEvent *>(&QImageCapture_Adaptor::cbs_eventFilter_2411_0, watched, event);
    } else {
      return QImageCapture::eventFilter(watched, event);
    }
  }

  //  [adaptor impl] void QImageCapture::childEvent(QChildEvent *event)
  void cbs_childEvent_1701_0(QChildEvent *event)
  {
    QImageCapture::childEvent(event);
  }

  virtual void childEvent(QChildEvent *event)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QImageCapture_Adaptor, QChildEvent *>(&QImageCapture_Adaptor::cbs_childEvent_1701_0, event);
    } else {
      QImageCapture::childEvent(event);
    }
  }

  //  [adaptor impl] void QImageCapture::customEvent(QEvent *event)
  void cbs_customEvent_1217_0(QEvent *event)
  {
    QImageCapture::customEvent(event);
  }

  virtual void customEvent(QEvent *event)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QImageCapture_Adaptor, QEvent *>(&QImageCapture_Adaptor::cbs_customEvent_1217_0, event);
    } else {
      QImageCapture::customEvent(event);
    }
  }

  //  [adaptor impl] void QImageCapture::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QImageCapture::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QImageCapture_Adaptor, const QMetaMethod &>(&QImageCapture_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QImageCapture::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QImageCapture::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QImageCapture::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QImageCapture_Adaptor, QTimerEvent *>(&QImageCapture_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QImageCapture::timerEvent(event);
    }
  }

  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QImageCapture_Adaptor::~QImageCapture_Adaptor() { }

//  Constructor QImageCapture::QImageCapture(QObject *parent) (adaptor class)

static void _init_ctor_QImageCapture_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QImageCapture_Adaptor> ();
}

static void _call_ctor_QImageCapture_Adaptor_1302 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ret.write<QImageCapture_Adaptor *> (new QImageCapture_Adaptor (arg1));
}


// void QImageCapture::childEvent(QChildEvent *event)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QImageCapture_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QImageCapture_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QImageCapture::customEvent(QEvent *event)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QImageCapture_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QImageCapture_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// void QImageCapture::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QImageCapture_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QImageCapture_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// bool QImageCapture::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QImageCapture_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QImageCapture_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QImageCapture::eventFilter(QObject *watched, QEvent *event)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("watched");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QImageCapture_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QImageCapture_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// exposed bool QImageCapture::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QImageCapture_Adaptor *)cls)->fp_QImageCapture_isSignalConnected_c2394 (arg1));
}


// exposed int QImageCapture::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QImageCapture_Adaptor *)cls)->fp_QImageCapture_receivers_c1731 (arg1));
}


// exposed QObject *QImageCapture::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QImageCapture_Adaptor *)cls)->fp_QImageCapture_sender_c0 ());
}


// exposed int QImageCapture::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QImageCapture_Adaptor *)cls)->fp_QImageCapture_senderSignalIndex_c0 ());
}


// void QImageCapture::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QImageCapture_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QImageCapture_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


namespace gsi
{

gsi::Class<QImageCapture> &qtdecl_QImageCapture ();

static gsi::Methods methods_QImageCapture_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QImageCapture::QImageCapture(QObject *parent)\nThis method creates an object of class QImageCapture.", &_init_ctor_QImageCapture_Adaptor_1302, &_call_ctor_QImageCapture_Adaptor_1302);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QImageCapture::childEvent(QChildEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QImageCapture::customEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QImageCapture::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QImageCapture::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QImageCapture::eventFilter(QObject *watched, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QImageCapture::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QImageCapture::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QImageCapture::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QImageCapture::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QImageCapture::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  return methods;
}

gsi::Class<QImageCapture_Adaptor> decl_QImageCapture_Adaptor (qtdecl_QImageCapture (), "QtMultimedia", "QImageCapture",
  methods_QImageCapture_Adaptor (),
  "@qt\n@brief Binding of QImageCapture");

}


//  Implementation of the enum wrapper class for QImageCapture::Error
namespace qt_gsi
{

static gsi::Enum<QImageCapture::Error> decl_QImageCapture_Error_Enum ("QtMultimedia", "QImageCapture_Error",
    gsi::enum_const ("NoError", QImageCapture::NoError, "@brief Enum constant QImageCapture::NoError") +
    gsi::enum_const ("NotReadyError", QImageCapture::NotReadyError, "@brief Enum constant QImageCapture::NotReadyError") +
    gsi::enum_const ("ResourceError", QImageCapture::ResourceError, "@brief Enum constant QImageCapture::ResourceError") +
    gsi::enum_const ("OutOfSpaceError", QImageCapture::OutOfSpaceError, "@brief Enum constant QImageCapture::OutOfSpaceError") +
    gsi::enum_const ("NotSupportedFeatureError", QImageCapture::NotSupportedFeatureError, "@brief Enum constant QImageCapture::NotSupportedFeatureError") +
    gsi::enum_const ("FormatError", QImageCapture::FormatError, "@brief Enum constant QImageCapture::FormatError"),
  "@qt\n@brief This class represents the QImageCapture::Error enum");

static gsi::QFlagsClass<QImageCapture::Error > decl_QImageCapture_Error_Enums ("QtMultimedia", "QImageCapture_QFlags_Error",
  "@qt\n@brief This class represents the QFlags<QImageCapture::Error> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QImageCapture> inject_QImageCapture_Error_Enum_in_parent (decl_QImageCapture_Error_Enum.defs ());
static gsi::ClassExt<QImageCapture> decl_QImageCapture_Error_Enum_as_child (decl_QImageCapture_Error_Enum, "Error");
static gsi::ClassExt<QImageCapture> decl_QImageCapture_Error_Enums_as_child (decl_QImageCapture_Error_Enums, "QFlags_Error");

}


//  Implementation of the enum wrapper class for QImageCapture::FileFormat
namespace qt_gsi
{

static gsi::Enum<QImageCapture::FileFormat> decl_QImageCapture_FileFormat_Enum ("QtMultimedia", "QImageCapture_FileFormat",
    gsi::enum_const ("UnspecifiedFormat", QImageCapture::UnspecifiedFormat, "@brief Enum constant QImageCapture::UnspecifiedFormat") +
    gsi::enum_const ("JPEG", QImageCapture::JPEG, "@brief Enum constant QImageCapture::JPEG") +
    gsi::enum_const ("PNG", QImageCapture::PNG, "@brief Enum constant QImageCapture::PNG") +
    gsi::enum_const ("WebP", QImageCapture::WebP, "@brief Enum constant QImageCapture::WebP") +
    gsi::enum_const ("Tiff", QImageCapture::Tiff, "@brief Enum constant QImageCapture::Tiff") +
    gsi::enum_const ("LastFileFormat", QImageCapture::LastFileFormat, "@brief Enum constant QImageCapture::LastFileFormat"),
  "@qt\n@brief This class represents the QImageCapture::FileFormat enum");

static gsi::QFlagsClass<QImageCapture::FileFormat > decl_QImageCapture_FileFormat_Enums ("QtMultimedia", "QImageCapture_QFlags_FileFormat",
  "@qt\n@brief This class represents the QFlags<QImageCapture::FileFormat> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QImageCapture> inject_QImageCapture_FileFormat_Enum_in_parent (decl_QImageCapture_FileFormat_Enum.defs ());
static gsi::ClassExt<QImageCapture> decl_QImageCapture_FileFormat_Enum_as_child (decl_QImageCapture_FileFormat_Enum, "FileFormat");
static gsi::ClassExt<QImageCapture> decl_QImageCapture_FileFormat_Enums_as_child (decl_QImageCapture_FileFormat_Enums, "QFlags_FileFormat");

}


//  Implementation of the enum wrapper class for QImageCapture::Quality
namespace qt_gsi
{

static gsi::Enum<QImageCapture::Quality> decl_QImageCapture_Quality_Enum ("QtMultimedia", "QImageCapture_Quality",
    gsi::enum_const ("VeryLowQuality", QImageCapture::VeryLowQuality, "@brief Enum constant QImageCapture::VeryLowQuality") +
    gsi::enum_const ("LowQuality", QImageCapture::LowQuality, "@brief Enum constant QImageCapture::LowQuality") +
    gsi::enum_const ("NormalQuality", QImageCapture::NormalQuality, "@brief Enum constant QImageCapture::NormalQuality") +
    gsi::enum_const ("HighQuality", QImageCapture::HighQuality, "@brief Enum constant QImageCapture::HighQuality") +
    gsi::enum_const ("VeryHighQuality", QImageCapture::VeryHighQuality, "@brief Enum constant QImageCapture::VeryHighQuality"),
  "@qt\n@brief This class represents the QImageCapture::Quality enum");

static gsi::QFlagsClass<QImageCapture::Quality > decl_QImageCapture_Quality_Enums ("QtMultimedia", "QImageCapture_QFlags_Quality",
  "@qt\n@brief This class represents the QFlags<QImageCapture::Quality> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QImageCapture> inject_QImageCapture_Quality_Enum_in_parent (decl_QImageCapture_Quality_Enum.defs ());
static gsi::ClassExt<QImageCapture> decl_QImageCapture_Quality_Enum_as_child (decl_QImageCapture_Quality_Enum, "Quality");
static gsi::ClassExt<QImageCapture> decl_QImageCapture_Quality_Enums_as_child (decl_QImageCapture_Quality_Enums, "QFlags_Quality");

}

