/***************************************************************************
                          kmessdebug.h  -  description
                             -------------------
    begin                : Sun Jan 5 2003
    copyright            : (C) 2003 by Mike K. Bennett
    email                : mkb137b@hotmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KMESSDEBUG_H
#define KMESSDEBUG_H

#include "config-kmess.h"

#include <kdeversion.h>

// Since all debugging code uses kmDebug(), this is also a good
// reason to include this file by default so no one else has to.
#include <KDebug>


#if ( KMESS_DEBUG == 1 )

  #define KMESSTEST
  #define KMESS_NETWORK_WINDOW

  #define KMESSDEBUG_KMESS
  #define KMESSDEBUG_LIKEBACK
  #define KMESSDEBUG_KMESSAPPLICATION
  #define KMESSDEBUG_KMESSINTERFACE
  #define KMESSDEBUG_KMESSVIEW
  #define KMESSDEBUG_INITIALVIEW
  #define KMESSDEBUG_SETTINGSDIALOG
  #define KMESSDEBUG_CONTACTPROPERTIES
  #define KMESSDEBUG_TRANSFERENTRY
  #define KMESSDEBUG_TRANSFERWINDOW
  #define KMESSDEBUG_CHATHISTORYDIALOG


  #define KMESSDEBUG_CONNECTION
  #define KMESSDEBUG_NOTIFICATION
//   #define KMESSDEBUG_CHALLENGEHANDLER
  #define KMESSDEBUG_SWITCHBOARD
  #define KMESSDEBUG_SERVERMESSAGES
  #define KMESSDEBUG_SSLLOGINHANDLER
  #define KMESSDEBUG_MSNFTP
  #define KMESSDEBUG_DIRECTCONNECTION
  #define KMESSDEBUG_TCPCONNECTION
  #define KMESSDEBUG_OFFLINE_IM

  #define KMESSDEBUG_ACCOUNT
  #define KMESSDEBUG_CURRENTACCOUNT
  #define KMESSDEBUG_ACCOUNTSMANAGER
  #define KMESSDEBUG_CONTACT
  #define KMESSDEBUG_CONTACTBASE
  #define KMESSDEBUG_CONTACTEXTENSION
  #define KMESSDEBUG_CONTACTLIST
  #define KMESSDEBUG_CONTACTLISTMODELTEST
 #define KMESSDEBUG_CONTACTLISTMODEL
  #define KMESSDEBUG_GROUP


  #define KMESSDEBUG_CHATMASTER
  #define KMESSDEBUG_CHAT
  #define KMESSDEBUG_CHATHISTORYMANAGER
  #define KMESSDEBUG_CHATHISTORYWRITER
  #define KMESSDEBUG_CHATWINDOW
  #define KMESSDEBUG_CHATVIEW
  #define KMESSDEBUG_CHATMESSAGEVIEW
  #define KMESSDEBUG_CONTACTSWIDGET
  #define KMESSDEBUG_EMOTICONSWIDGET
  #define KMESSDEBUG_WINKSWIDGET
  #define KMESSDEBUG_CONTACTFRAME
  #define KMESSDEBUG_INVITEDCONTACT
  #define KMESSDEBUG_INKEDIT

  #define KMESSDEBUG_EMOTICONS
//   #define KMESSDEBUG_RICHTEXTPARSER
//   #define KMESSDEBUG_IDLETIMER
  #define KMESSDEBUG_AUTOLOCK
  #define KMESSDEBUG_NOWLISTENINGCLIENT
  #define KMESSDEBUG_XSLTRANSFORMATION
  #define KMESSDEBUG_THUMBNAILPROVIDER
  #define KMESSDEBUG_SYSTEMTRAY
  #define KMESSDEBUG_CRASHHANDLER
  #define KMESSDEBUG_SHAREDMETHODS
  #define KMESSDEBUG_KMESSDBUS
  #define KMESSDEBUG_KMESSSENDPLUGIN

  #define KMESSDEBUG_MIMEMESSAGE
  #define KMESSDEBUG_MULTIPACKETMESSAGE
  #define KMESSDEBUG_P2PMESSAGE
  #define KMESSDEBUG_APPLICATION
  #define KMESSDEBUG_APPLICATIONLIST
  #define KMESSDEBUG_MIMEAPPLICATION
  #define KMESSDEBUG_P2PAPPLICATION
  #define KMESSDEBUG_FILETRANSFER_P2P
  #define KMESSDEBUG_MSNOBJECTTRANSFER_P2P
  #define KMESSDEBUG_FILETRANSFER

  #define KMESSDEBUG_SOAPMESSAGE
  #define KMESSDEBUG_HTTPSOAPCONNECTION
  #define KMESSDEBUG_APPDIRECTORYSERVICE
  #define KMESSDEBUG_PASSPORTLOGINSERVICE
//   #define KMESSDEBUG_XMLFUNCTIONS
  #define KMESSDEBUG_ROAMINGSERVICE


  #define KMESSDEBUG_PASSIVEPOPUP
  #define KMESSDEBUG_NOTIFICATIONMANAGER
  #define KMESSDEBUG_CONTACTSTATUSNOTIFICATION
  #define KMESSDEBUG_CHATNOTIFICATION
  #define KMESSDEBUG_NEWEMAILNOTIFICATION
  #define KMESSDEBUG_ADDRESSBOOKNOTIFICATIONS

#endif


// k_funcinfo in c-string style.
#ifdef __GNUC__
#define c_funcinfo __PRETTY_FUNCTION__
#else
#define c_funcinfo "<unknown>"
#endif


// Fix compiling with KDE 3.2
#ifndef KDE_ISUNLIKELY
  #define KDE_ISUNLIKELY
#endif



// KDE custom debug logging functions

/**
 * @brief Register a KDE debug area.
 *
 * This function will be used by kmDebug(), kWarning() calls throughout KMess
 * to enable debug output.
 *
 * @return Debug area number
 */
inline int debugArea()
{
#if KDE_IS_VERSION( 4, 4, 0 )
  static int s_area = KDebug::registerArea( "kmess" );
  return s_area;
#else
  return 5130; // This number was assigned to us in KDE 4.3
#endif
}

#define kmDebug()    kDebug( debugArea() )
#define kmWarning()  kWarning( debugArea() )
#define kmError()    kError( debugArea() )



// Debug macro to warn for null pointers
#ifdef KMESSTEST
  // Warns that a pointer was null, full debug version
  bool _kmessWarnNull(bool isNull, const char *var, const char *funcinfo, const char *file, int line);
  // Warn if a pre- or post- condition fails
  bool _kmessAssert(const char *condition, const char *file, int line);

  // Wrapper macro for warn-if-null methods.
  // This idea was taken from Q_ASSERT (qglobal.h).
  // Using KDE_ISUNLIKELY so the compiler optimizes branching.
  // Silent version:  #define KMESS_NULL(x) (x != 0)
  #define KMESS_NULL(x) ( KDE_ISUNLIKELY((x) == 0) && _kmessWarnNull((x) == 0, #x, c_funcinfo, __FILE__, __LINE__) )

  // Warn if a pre- or post- condition fails
  // Idea taken from Q_ASSERT, too, but without terminating the application;
  // this is often useful with P2P code, some details may change and using KMESS_ASSERT
  // KMess would die a lot.
  #define KMESS_ASSERT(cond) ( KDE_ISUNLIKELY((cond) == 0) && _kmessAssert( #cond, __FILE__, __LINE__) )
#else
  // Warns that a pointer was null
  bool _kmessWarnNull(bool isNull, const char *var, const char *funcinfo);

  #define KMESS_NULL(x) ( KDE_ISUNLIKELY((x) == 0) && _kmessWarnNull((x) == 0, #x, c_funcinfo) )

  // Avoid asserts in release versions
  #define KMESS_ASSERT(cond)
#endif


// Debug macro to add messages to the network window
#ifdef KMESS_NETWORK_WINDOW
  class QObject;

  // Inform the network window the connection was closed
  extern void _kmessNetClose(QObject *connection);

  // Inform the network window about a new connection
  extern void _kmessNetInit(QObject *connection, const QString &title);

  // Add the received data to the network window
  extern void _kmessNetReceived(QObject *connection, const QByteArray &message);

  // Add the sent data to the network window
  extern void _kmessNetSent(QObject *connection, const QByteArray &message);

  // Wrapper macro, call network window when it's compiled
  #define KMESS_NET_CLOSE(c)      (_kmessNetClose(c))
  #define KMESS_NET_INIT(c,t)     (_kmessNetInit(c, t))
  #define KMESS_NET_RECEIVED(c,d) (_kmessNetReceived(c, d))
  #define KMESS_NET_SENT(c,d)     (_kmessNetSent(c, d))
#else
  #define KMESS_NET_CLOSE(c)
  #define KMESS_NET_INIT(c,t)
  #define KMESS_NET_RECEIVED(c,d)
  #define KMESS_NET_SENT(c,d)
#endif


// A Qt debug message handler to avoid unwanted exit(1) or abort() calls.
void  kmessDebugPrinter( QtMsgType type, const char *msg );


#endif  // KMESSDEBUG_H
