/*
    This file is part of KolabAdmin.

    Copyright (C) 2006 Tobias Koenig <tobias.koenig@credativ.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#ifndef FORM_ACCOUNTTYPEFIELD_H
#define FORM_ACCOUNTTYPEFIELD_H

#include "field.h"

class QComboBox;

namespace Form
{

class AccountTypeField : public Field
{
  public:
    AccountTypeField( const QString &name, QWidget *parent );

    virtual void loadEntry( const Entry &entry );
    virtual void saveEntry( Entry &entry ) const;

    virtual bool isValid( QString &message, PagePolicy::State state ) const;

    virtual void setEditable( bool editable );

  private:
    QComboBox* mComboBox;
};

}

#endif
