/***************************************************************************
*   Copyright (C) 2007-2010 by Thomas Thelliez aka jblud                  *
*   Contact : <admin.kontrol@gmail.com>                                   *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as               *
*   published by the Free Software Foundation; either version 2.0 of      *
*   the License, or (at your option) any later version.                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
*   General Public License for more details.                              *
*                                                                         *
*   You should have received a copy of the GNU General Public             *
*   License along with this program; if not, write to                     *
*   the Free Software Foundation, Inc.,                                   *
*   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          *
***************************************************************************/

#include <QWidget>
#include <QTextEdit>
#include <QLabel>
#include <QGridLayout>
#include <QGroupBox>
#include <QSplitter>
#include <QHostInfo>
#include <QHostAddress>
#include <QNetworkInterface>
#include <QGroupBox>
#include <QListWidget>
#include <QStandardItemModel>
#include <QStandardItem>
#include "dns/dns_resolver.h"
#include "../../commons/win32/qtwin.h"
#include "../../commons/constants.h"
#include "../core/bean/remote_computer_info.h"

class ClientHome : public QFrame
{
    Q_OBJECT

public:
    ClientHome(QTextEdit *textBrowser, QList<RemoteComputerInfo*> clientsList);
    QList<QHostAddress> addresses;
    QLabel *image;
    QTextEdit *textEdit;
    QGroupBox *groupBox;
    QLabel *path;
    QPushButton *addComputerButton;
    void refreshCLientsList(QList<RemoteComputerInfo*> remote_info_list);
signals:
    void connect_remote_clients(QString ip, QString port, QString port_file);

public slots:
    void showDNSResolver();
    void doubleClicSelection();

private:
    QListView *list;
    DnsResolver *resolver;
    QList<RemoteComputerInfo*> remote_info_list;
};


