/**************************************************************************
*   Copyright (C) 2007-2010 by Thomas Thelliez aka jblud                  *
*   Contact : <admin.kontrol@gmail.com>                                   *
*                                                                         *
* This program is free software; you can redistribute it and/or           *
* modify it either under the terms of the GNU Lesser General Public       *
* License version 3 as published by the Free Software Foundation          *
* (the "LGPL") or, at your option, any later version.                     *
* If you do not alter this notice, a recipient may use your version       *
* of this file under the LGPL.                                            *
*                                                                         *
* You should have received a copy of the LGPL along with this library     *
* in the file COPYING; if not, write to the Free Software                 *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA *
*                                                                         *
* This software is distributed on an "AS IS" basis, WITHOUT WARRANTY      *
* OF ANY KIND, either express or implied. See the LGPL for                *
* the specific language governing rights and limitations.                 *
**************************************************************************/

#ifndef HEADER_SERVER_AUTH
#define HEADER_SERVER_AUTH

#include <QString>
#include <QHostAddress>
#include <QTcpServer>
#include <dirent.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include "auth_session.h"
#include "../utils/utils.h"
#include <QMap>
#include <QStringList>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <openssl/evp.h>
#include <openssl/aes.h>


#define MAX_CLIENTS 	10000

class auth_server : public QTcpServer
{
    Q_OBJECT

public:
    int port_server;
    const char* ip_server;
    auth_server(QString server_password,
                QObject *parent = 0);
    QMap<int, auth_session*> *client_list;
    int nbr_client;
    QMap<int,auth_session*>* get_client_list();
    int get_client_number();
    int write_encrypted_data_to_socket(char* buffer, int nbr);
    int write_data_to_socket(char* buffer, int nbr);
    QString encrypt_message(char* buffer, int nbr);
    int stop_server();
    void disconnect_client(int nbr);

signals:
    void received_stream_signal(QString message, int client_nbr);
    void signals_state(int state, int client_nbr);
    void auth_succeeded(int client_nbr);
    void emit_error(int client_nbr);
    void wrong_password(QString msg);

public slots:
    void add_new_client();
    void tcp_state(int state, int client_nbr);
    void auth_error_handler(int client_nbr);
    void auth_suceeded(int client_nbr);
    void received_stream_slot(QString message, int client_nbr);
    void remove_client(int nbr);

private:
    QString password;

};

#endif



