#ifndef _TOUCHPAD_H
#define _TOUCHPAD_H

#include <string>
#include <vector>
#include "applet.h"

class Touchpad : public Applet {
  public:
    Touchpad(AppletWindowParams params, const std::string& pointer_img, double move_ratio);
    virtual AppAction OnMousePress(int x, int y);
    virtual AppAction OnMouseMove(int x, int y);
    virtual AppAction OnMouseRelease(int x, int y);
    virtual void OnRotate(Rotation r);
    virtual void OnShow();
    virtual void OnHide();
    virtual ~Touchpad(){}

  private:
    struct Button {
	int px, py, w, h;
	int num_but;
	std::string look;
	Button(int a, int b, int c, int d, int num, const std::string& l):px(a), py(b), w(c), h(d), num_but(num), look(l){}
    };
    std::vector<Button> buttons;
    void DrawButtons();
    double move_ratio;
    MyWindow pointer;
    int lastx, lasty;
    int last_px, last_py;
    int pressed_button;
};

#endif
