/* (C) Marcin Kwadrans <quarter@users.sourceforge.net> */

/*! \file value.h
	\brief Value managing
*/

#ifndef __LW_VALUE_H
#define __LW_VALUE_H

#include "pixmap.h"

/*! \class LWValue
	\brief Value managing

	Class represents values of arguments of commands	
*/

class LWValue {
protected:
gboolean is_list;	
union {
LWPixmap *pixmap;
GSList *list;
};
void convertToList();
public:
LWValue ();
LWValue (LWPixmap *pixmap);
LWValue (gint ivalue);
LWValue (const LWValue *value);
virtual ~LWValue ();
virtual gboolean isSpecial();
virtual void clear ();
virtual void append (LWPixmap *pixmap);
virtual void concat (LWValue *value);
virtual gboolean isInt ();
virtual gint toInt ();
virtual gboolean checkRange ();
virtual gint compare (LWValue *v);
virtual gboolean canBeIndexed ();
virtual LWValue *getIndex (guint n);
virtual void deleteIndex (guint n);
virtual GSList *getListPixmap ();
virtual LWPixmap *getPixmap ();
virtual void set (LWValue *value);
virtual LWValue *get ();
virtual guint count ();
virtual gboolean isVariable ();
};

#endif
