; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-pc-linux-gnu | FileCheck %s -check-prefix=DEFAULT
; RUN: llc < %s -mtriple=i686-pc-linux-gnu -x86-experimental-pref-innermost-loop-alignment=5 | FileCheck %s -check-prefix=ALIGN32
; RUN: llc < %s -mtriple=i686-pc-linux-gnu -x86-experimental-pref-loop-alignment=5 -x86-experimental-pref-innermost-loop-alignment=6 | FileCheck %s -check-prefix=ALIGN64

declare void @foo()

define void @test(i32 %n, i32 %m) {
; DEFAULT-LABEL: test:
; DEFAULT:         .p2align 4, 0x90
; DEFAULT-NEXT:  .LBB0_1: # %outer
; DEFAULT-NEXT:    # =>This Loop Header: Depth=1
; DEFAULT-NEXT:    # Child Loop BB0_2 Depth 2
; DEFAULT:         .p2align 4, 0x90
; DEFAULT-NEXT:  .LBB0_2: # %inner
; DEFAULT-NEXT:    # Parent Loop BB0_1 Depth=1

; ALIGN32-LABEL: test:
; ALIGN32:         .p2align 4, 0x90
; ALIGN32-NEXT:  .LBB0_1: # %outer
; ALIGN32-NEXT:    # =>This Loop Header: Depth=1
; ALIGN32-NEXT:    # Child Loop BB0_2 Depth 2
; ALIGN32:         .p2align 5, 0x90
; ALIGN32-NEXT:  .LBB0_2: # %inner
; ALIGN32-NEXT:    # Parent Loop BB0_1 Depth=1
; ALIGN32-NEXT:    # => This Inner Loop Header: Depth=2

; ALIGN64-LABEL: test:
; ALIGN64:         .p2align 5, 0x90
; ALIGN64-NEXT:  .LBB0_1: # %outer
; ALIGN64-NEXT:    # =>This Loop Header: Depth=1
; ALIGN64-NEXT:    # Child Loop BB0_2 Depth 2
; ALIGN64:         .p2align 6, 0x90
; ALIGN64-NEXT:  .LBB0_2: # %inner
; ALIGN64-NEXT:    # Parent Loop BB0_1 Depth=1
; ALIGN64-NEXT:    # => This Inner Loop Header: Depth=2

entry:
  br label %outer

outer:
  %outer.iv = phi i32 [0, %entry], [%outer.iv.next, %outer_bb]
  br label %inner

inner:
  %inner.iv = phi i32 [0, %outer], [%inner.iv.next, %inner]
  call void @foo()
  %inner.iv.next = add i32 %inner.iv, 1
  %inner.cond = icmp ne i32 %inner.iv.next, %m
  br i1 %inner.cond, label %inner, label %outer_bb

outer_bb:
  %outer.iv.next = add i32 %outer.iv, 1
  %outer.cond = icmp ne i32 %outer.iv.next, %n
  br i1 %outer.cond, label %outer, label %exit

exit:
  ret void
}
