// RUN: llvm-mc -arch=amdgcn -mcpu=bonaire -show-encoding %s | FileCheck %s

ds_add_u32 v1, v2 offset:65535
// CHECK: [0xff,0xff,0x00,0xd8,0x01,0x02,0x00,0x00]

ds_add_u32 v255, v2 offset:65535
// CHECK: [0xff,0xff,0x00,0xd8,0xff,0x02,0x00,0x00]

ds_add_u32 v1, v255 offset:65535
// CHECK: [0xff,0xff,0x00,0xd8,0x01,0xff,0x00,0x00]

ds_add_u32 v1, v2
// CHECK: [0x00,0x00,0x00,0xd8,0x01,0x02,0x00,0x00]

ds_add_u32 v1, v2 offset:0
// CHECK: [0x00,0x00,0x00,0xd8,0x01,0x02,0x00,0x00]

ds_add_u32 v1, v2 offset:4
// CHECK: [0x04,0x00,0x00,0xd8,0x01,0x02,0x00,0x00]

ds_add_u32 v1, v2 offset:65535 gds
// CHECK: [0xff,0xff,0x02,0xd8,0x01,0x02,0x00,0x00]

ds_sub_u32 v1, v2 offset:65535
// CHECK: [0xff,0xff,0x04,0xd8,0x01,0x02,0x00,0x00]

ds_sub_u32 v255, v2 offset:65535
// CHECK: [0xff,0xff,0x04,0xd8,0xff,0x02,0x00,0x00]

ds_sub_u32 v1, v255 offset:65535
// CHECK: [0xff,0xff,0x04,0xd8,0x01,0xff,0x00,0x00]

ds_sub_u32 v1, v2
// CHECK: [0x00,0x00,0x04,0xd8,0x01,0x02,0x00,0x00]

ds_sub_u32 v1, v2 offset:0
// CHECK: [0x00,0x00,0x04,0xd8,0x01,0x02,0x00,0x00]

ds_sub_u32 v1, v2 offset:4
// CHECK: [0x04,0x00,0x04,0xd8,0x01,0x02,0x00,0x00]

ds_sub_u32 v1, v2 offset:65535 gds
// CHECK: [0xff,0xff,0x06,0xd8,0x01,0x02,0x00,0x00]

ds_rsub_u32 v1, v2 offset:65535
// CHECK: [0xff,0xff,0x08,0xd8,0x01,0x02,0x00,0x00]

ds_rsub_u32 v255, v2 offset:65535
// CHECK: [0xff,0xff,0x08,0xd8,0xff,0x02,0x00,0x00]

ds_rsub_u32 v1, v255 offset:65535
// CHECK: [0xff,0xff,0x08,0xd8,0x01,0xff,0x00,0x00]

ds_rsub_u32 v1, v2
// CHECK: [0x00,0x00,0x08,0xd8,0x01,0x02,0x00,0x00]

ds_rsub_u32 v1, v2 offset:0
// CHECK: [0x00,0x00,0x08,0xd8,0x01,0x02,0x00,0x00]

ds_rsub_u32 v1, v2 offset:4
// CHECK: [0x04,0x00,0x08,0xd8,0x01,0x02,0x00,0x00]

ds_rsub_u32 v1, v2 offset:65535 gds
// CHECK: [0xff,0xff,0x0a,0xd8,0x01,0x02,0x00,0x00]

ds_inc_u32 v1, v2 offset:65535
// CHECK: [0xff,0xff,0x0c,0xd8,0x01,0x02,0x00,0x00]

ds_inc_u32 v255, v2 offset:65535
// CHECK: [0xff,0xff,0x0c,0xd8,0xff,0x02,0x00,0x00]

ds_inc_u32 v1, v255 offset:65535
// CHECK: [0xff,0xff,0x0c,0xd8,0x01,0xff,0x00,0x00]

ds_inc_u32 v1, v2
// CHECK: [0x00,0x00,0x0c,0xd8,0x01,0x02,0x00,0x00]

ds_inc_u32 v1, v2 offset:0
// CHECK: [0x00,0x00,0x0c,0xd8,0x01,0x02,0x00,0x00]

ds_inc_u32 v1, v2 offset:4
// CHECK: [0x04,0x00,0x0c,0xd8,0x01,0x02,0x00,0x00]

ds_inc_u32 v1, v2 offset:65535 gds
// CHECK: [0xff,0xff,0x0e,0xd8,0x01,0x02,0x00,0x00]

ds_dec_u32 v1, v2 offset:65535
// CHECK: [0xff,0xff,0x10,0xd8,0x01,0x02,0x00,0x00]

ds_dec_u32 v255, v2 offset:65535
// CHECK: [0xff,0xff,0x10,0xd8,0xff,0x02,0x00,0x00]

ds_dec_u32 v1, v255 offset:65535
// CHECK: [0xff,0xff,0x10,0xd8,0x01,0xff,0x00,0x00]

ds_dec_u32 v1, v2
// CHECK: [0x00,0x00,0x10,0xd8,0x01,0x02,0x00,0x00]

ds_dec_u32 v1, v2 offset:0
// CHECK: [0x00,0x00,0x10,0xd8,0x01,0x02,0x00,0x00]

ds_dec_u32 v1, v2 offset:4
// CHECK: [0x04,0x00,0x10,0xd8,0x01,0x02,0x00,0x00]

ds_dec_u32 v1, v2 offset:65535 gds
// CHECK: [0xff,0xff,0x12,0xd8,0x01,0x02,0x00,0x00]

ds_min_i32 v1, v2 offset:65535
// CHECK: [0xff,0xff,0x14,0xd8,0x01,0x02,0x00,0x00]

ds_min_i32 v255, v2 offset:65535
// CHECK: [0xff,0xff,0x14,0xd8,0xff,0x02,0x00,0x00]

ds_min_i32 v1, v255 offset:65535
// CHECK: [0xff,0xff,0x14,0xd8,0x01,0xff,0x00,0x00]

ds_min_i32 v1, v2
// CHECK: [0x00,0x00,0x14,0xd8,0x01,0x02,0x00,0x00]

ds_min_i32 v1, v2 offset:0
// CHECK: [0x00,0x00,0x14,0xd8,0x01,0x02,0x00,0x00]

ds_min_i32 v1, v2 offset:4
// CHECK: [0x04,0x00,0x14,0xd8,0x01,0x02,0x00,0x00]

ds_min_i32 v1, v2 offset:65535 gds
// CHECK: [0xff,0xff,0x16,0xd8,0x01,0x02,0x00,0x00]

ds_max_i32 v1, v2 offset:65535
// CHECK: [0xff,0xff,0x18,0xd8,0x01,0x02,0x00,0x00]

ds_max_i32 v255, v2 offset:65535
// CHECK: [0xff,0xff,0x18,0xd8,0xff,0x02,0x00,0x00]

ds_max_i32 v1, v255 offset:65535
// CHECK: [0xff,0xff,0x18,0xd8,0x01,0xff,0x00,0x00]

ds_max_i32 v1, v2
// CHECK: [0x00,0x00,0x18,0xd8,0x01,0x02,0x00,0x00]

ds_max_i32 v1, v2 offset:0
// CHECK: [0x00,0x00,0x18,0xd8,0x01,0x02,0x00,0x00]

ds_max_i32 v1, v2 offset:4
// CHECK: [0x04,0x00,0x18,0xd8,0x01,0x02,0x00,0x00]

ds_max_i32 v1, v2 offset:65535 gds
// CHECK: [0xff,0xff,0x1a,0xd8,0x01,0x02,0x00,0x00]

ds_min_u32 v1, v2 offset:65535
// CHECK: [0xff,0xff,0x1c,0xd8,0x01,0x02,0x00,0x00]

ds_min_u32 v255, v2 offset:65535
// CHECK: [0xff,0xff,0x1c,0xd8,0xff,0x02,0x00,0x00]

ds_min_u32 v1, v255 offset:65535
// CHECK: [0xff,0xff,0x1c,0xd8,0x01,0xff,0x00,0x00]

ds_min_u32 v1, v2
// CHECK: [0x00,0x00,0x1c,0xd8,0x01,0x02,0x00,0x00]

ds_min_u32 v1, v2 offset:0
// CHECK: [0x00,0x00,0x1c,0xd8,0x01,0x02,0x00,0x00]

ds_min_u32 v1, v2 offset:4
// CHECK: [0x04,0x00,0x1c,0xd8,0x01,0x02,0x00,0x00]

ds_min_u32 v1, v2 offset:65535 gds
// CHECK: [0xff,0xff,0x1e,0xd8,0x01,0x02,0x00,0x00]

ds_max_u32 v1, v2 offset:65535
// CHECK: [0xff,0xff,0x20,0xd8,0x01,0x02,0x00,0x00]

ds_max_u32 v255, v2 offset:65535
// CHECK: [0xff,0xff,0x20,0xd8,0xff,0x02,0x00,0x00]

ds_max_u32 v1, v255 offset:65535
// CHECK: [0xff,0xff,0x20,0xd8,0x01,0xff,0x00,0x00]

ds_max_u32 v1, v2
// CHECK: [0x00,0x00,0x20,0xd8,0x01,0x02,0x00,0x00]

ds_max_u32 v1, v2 offset:0
// CHECK: [0x00,0x00,0x20,0xd8,0x01,0x02,0x00,0x00]

ds_max_u32 v1, v2 offset:4
// CHECK: [0x04,0x00,0x20,0xd8,0x01,0x02,0x00,0x00]

ds_max_u32 v1, v2 offset:65535 gds
// CHECK: [0xff,0xff,0x22,0xd8,0x01,0x02,0x00,0x00]

ds_and_b32 v1, v2 offset:65535
// CHECK: [0xff,0xff,0x24,0xd8,0x01,0x02,0x00,0x00]

ds_and_b32 v255, v2 offset:65535
// CHECK: [0xff,0xff,0x24,0xd8,0xff,0x02,0x00,0x00]

ds_and_b32 v1, v255 offset:65535
// CHECK: [0xff,0xff,0x24,0xd8,0x01,0xff,0x00,0x00]

ds_and_b32 v1, v2
// CHECK: [0x00,0x00,0x24,0xd8,0x01,0x02,0x00,0x00]

ds_and_b32 v1, v2 offset:0
// CHECK: [0x00,0x00,0x24,0xd8,0x01,0x02,0x00,0x00]

ds_and_b32 v1, v2 offset:4
// CHECK: [0x04,0x00,0x24,0xd8,0x01,0x02,0x00,0x00]

ds_and_b32 v1, v2 offset:65535 gds
// CHECK: [0xff,0xff,0x26,0xd8,0x01,0x02,0x00,0x00]

ds_or_b32 v1, v2 offset:65535
// CHECK: [0xff,0xff,0x28,0xd8,0x01,0x02,0x00,0x00]

ds_or_b32 v255, v2 offset:65535
// CHECK: [0xff,0xff,0x28,0xd8,0xff,0x02,0x00,0x00]

ds_or_b32 v1, v255 offset:65535
// CHECK: [0xff,0xff,0x28,0xd8,0x01,0xff,0x00,0x00]

ds_or_b32 v1, v2
// CHECK: [0x00,0x00,0x28,0xd8,0x01,0x02,0x00,0x00]

ds_or_b32 v1, v2 offset:0
// CHECK: [0x00,0x00,0x28,0xd8,0x01,0x02,0x00,0x00]

ds_or_b32 v1, v2 offset:4
// CHECK: [0x04,0x00,0x28,0xd8,0x01,0x02,0x00,0x00]

ds_or_b32 v1, v2 offset:65535 gds
// CHECK: [0xff,0xff,0x2a,0xd8,0x01,0x02,0x00,0x00]

ds_xor_b32 v1, v2 offset:65535
// CHECK: [0xff,0xff,0x2c,0xd8,0x01,0x02,0x00,0x00]

ds_xor_b32 v255, v2 offset:65535
// CHECK: [0xff,0xff,0x2c,0xd8,0xff,0x02,0x00,0x00]

ds_xor_b32 v1, v255 offset:65535
// CHECK: [0xff,0xff,0x2c,0xd8,0x01,0xff,0x00,0x00]

ds_xor_b32 v1, v2
// CHECK: [0x00,0x00,0x2c,0xd8,0x01,0x02,0x00,0x00]

ds_xor_b32 v1, v2 offset:0
// CHECK: [0x00,0x00,0x2c,0xd8,0x01,0x02,0x00,0x00]

ds_xor_b32 v1, v2 offset:4
// CHECK: [0x04,0x00,0x2c,0xd8,0x01,0x02,0x00,0x00]

ds_xor_b32 v1, v2 offset:65535 gds
// CHECK: [0xff,0xff,0x2e,0xd8,0x01,0x02,0x00,0x00]

ds_mskor_b32 v1, v2, v3 offset:65535
// CHECK: [0xff,0xff,0x30,0xd8,0x01,0x02,0x03,0x00]

ds_mskor_b32 v255, v2, v3 offset:65535
// CHECK: [0xff,0xff,0x30,0xd8,0xff,0x02,0x03,0x00]

ds_mskor_b32 v1, v255, v3 offset:65535
// CHECK: [0xff,0xff,0x30,0xd8,0x01,0xff,0x03,0x00]

ds_mskor_b32 v1, v2, v255 offset:65535
// CHECK: [0xff,0xff,0x30,0xd8,0x01,0x02,0xff,0x00]

ds_mskor_b32 v1, v2, v3
// CHECK: [0x00,0x00,0x30,0xd8,0x01,0x02,0x03,0x00]

ds_mskor_b32 v1, v2, v3 offset:0
// CHECK: [0x00,0x00,0x30,0xd8,0x01,0x02,0x03,0x00]

ds_mskor_b32 v1, v2, v3 offset:4
// CHECK: [0x04,0x00,0x30,0xd8,0x01,0x02,0x03,0x00]

ds_mskor_b32 v1, v2, v3 offset:65535 gds
// CHECK: [0xff,0xff,0x32,0xd8,0x01,0x02,0x03,0x00]

ds_write_b32 v1, v2 offset:65535
// CHECK: [0xff,0xff,0x34,0xd8,0x01,0x02,0x00,0x00]

ds_write_b32 v255, v2 offset:65535
// CHECK: [0xff,0xff,0x34,0xd8,0xff,0x02,0x00,0x00]

ds_write_b32 v1, v255 offset:65535
// CHECK: [0xff,0xff,0x34,0xd8,0x01,0xff,0x00,0x00]

ds_write_b32 v1, v2
// CHECK: [0x00,0x00,0x34,0xd8,0x01,0x02,0x00,0x00]

ds_write_b32 v1, v2 offset:0
// CHECK: [0x00,0x00,0x34,0xd8,0x01,0x02,0x00,0x00]

ds_write_b32 v1, v2 offset:4
// CHECK: [0x04,0x00,0x34,0xd8,0x01,0x02,0x00,0x00]

ds_write_b32 v1, v2 offset:65535 gds
// CHECK: [0xff,0xff,0x36,0xd8,0x01,0x02,0x00,0x00]

ds_write2_b32 v1, v2, v3 offset0:127 offset1:255
// CHECK: [0x7f,0xff,0x38,0xd8,0x01,0x02,0x03,0x00]

ds_write2_b32 v255, v2, v3 offset0:127 offset1:255
// CHECK: [0x7f,0xff,0x38,0xd8,0xff,0x02,0x03,0x00]

ds_write2_b32 v1, v255, v3 offset0:127 offset1:255
// CHECK: [0x7f,0xff,0x38,0xd8,0x01,0xff,0x03,0x00]

ds_write2_b32 v1, v2, v255 offset0:127 offset1:255
// CHECK: [0x7f,0xff,0x38,0xd8,0x01,0x02,0xff,0x00]

ds_write2_b32 v1, v2, v3 offset1:255
// CHECK: [0x00,0xff,0x38,0xd8,0x01,0x02,0x03,0x00]

ds_write2_b32 v1, v2, v3 offset0:0 offset1:255
// CHECK: [0x00,0xff,0x38,0xd8,0x01,0x02,0x03,0x00]

ds_write2_b32 v1, v2, v3 offset0:16 offset1:255
// CHECK: [0x10,0xff,0x38,0xd8,0x01,0x02,0x03,0x00]

ds_write2_b32 v1, v2, v3 offset0:127
// CHECK: [0x7f,0x00,0x38,0xd8,0x01,0x02,0x03,0x00]

ds_write2_b32 v1, v2, v3 offset0:127 offset1:0
// CHECK: [0x7f,0x00,0x38,0xd8,0x01,0x02,0x03,0x00]

ds_write2_b32 v1, v2, v3 offset0:127 offset1:1
// CHECK: [0x7f,0x01,0x38,0xd8,0x01,0x02,0x03,0x00]

ds_write2_b32 v1, v2, v3 offset0:127 offset1:255 gds
// CHECK: [0x7f,0xff,0x3a,0xd8,0x01,0x02,0x03,0x00]

ds_write2st64_b32 v1, v2, v3 offset0:127 offset1:255
// CHECK: [0x7f,0xff,0x3c,0xd8,0x01,0x02,0x03,0x00]

ds_write2st64_b32 v255, v2, v3 offset0:127 offset1:255
// CHECK: [0x7f,0xff,0x3c,0xd8,0xff,0x02,0x03,0x00]

ds_write2st64_b32 v1, v255, v3 offset0:127 offset1:255
// CHECK: [0x7f,0xff,0x3c,0xd8,0x01,0xff,0x03,0x00]

ds_write2st64_b32 v1, v2, v255 offset0:127 offset1:255
// CHECK: [0x7f,0xff,0x3c,0xd8,0x01,0x02,0xff,0x00]

ds_write2st64_b32 v1, v2, v3 offset1:255
// CHECK: [0x00,0xff,0x3c,0xd8,0x01,0x02,0x03,0x00]

ds_write2st64_b32 v1, v2, v3 offset0:0 offset1:255
// CHECK: [0x00,0xff,0x3c,0xd8,0x01,0x02,0x03,0x00]

ds_write2st64_b32 v1, v2, v3 offset0:16 offset1:255
// CHECK: [0x10,0xff,0x3c,0xd8,0x01,0x02,0x03,0x00]

ds_write2st64_b32 v1, v2, v3 offset0:127
// CHECK: [0x7f,0x00,0x3c,0xd8,0x01,0x02,0x03,0x00]

ds_write2st64_b32 v1, v2, v3 offset0:127 offset1:0
// CHECK: [0x7f,0x00,0x3c,0xd8,0x01,0x02,0x03,0x00]

ds_write2st64_b32 v1, v2, v3 offset0:127 offset1:1
// CHECK: [0x7f,0x01,0x3c,0xd8,0x01,0x02,0x03,0x00]

ds_write2st64_b32 v1, v2, v3 offset0:127 offset1:255 gds
// CHECK: [0x7f,0xff,0x3e,0xd8,0x01,0x02,0x03,0x00]

ds_cmpst_b32 v1, v2, v3 offset:65535
// CHECK: [0xff,0xff,0x40,0xd8,0x01,0x02,0x03,0x00]

ds_cmpst_b32 v255, v2, v3 offset:65535
// CHECK: [0xff,0xff,0x40,0xd8,0xff,0x02,0x03,0x00]

ds_cmpst_b32 v1, v255, v3 offset:65535
// CHECK: [0xff,0xff,0x40,0xd8,0x01,0xff,0x03,0x00]

ds_cmpst_b32 v1, v2, v255 offset:65535
// CHECK: [0xff,0xff,0x40,0xd8,0x01,0x02,0xff,0x00]

ds_cmpst_b32 v1, v2, v3
// CHECK: [0x00,0x00,0x40,0xd8,0x01,0x02,0x03,0x00]

ds_cmpst_b32 v1, v2, v3 offset:0
// CHECK: [0x00,0x00,0x40,0xd8,0x01,0x02,0x03,0x00]

ds_cmpst_b32 v1, v2, v3 offset:4
// CHECK: [0x04,0x00,0x40,0xd8,0x01,0x02,0x03,0x00]

ds_cmpst_b32 v1, v2, v3 offset:65535 gds
// CHECK: [0xff,0xff,0x42,0xd8,0x01,0x02,0x03,0x00]

ds_cmpst_f32 v1, v2, v3 offset:65535
// CHECK: [0xff,0xff,0x44,0xd8,0x01,0x02,0x03,0x00]

ds_cmpst_f32 v255, v2, v3 offset:65535
// CHECK: [0xff,0xff,0x44,0xd8,0xff,0x02,0x03,0x00]

ds_cmpst_f32 v1, v255, v3 offset:65535
// CHECK: [0xff,0xff,0x44,0xd8,0x01,0xff,0x03,0x00]

ds_cmpst_f32 v1, v2, v255 offset:65535
// CHECK: [0xff,0xff,0x44,0xd8,0x01,0x02,0xff,0x00]

ds_cmpst_f32 v1, v2, v3
// CHECK: [0x00,0x00,0x44,0xd8,0x01,0x02,0x03,0x00]

ds_cmpst_f32 v1, v2, v3 offset:0
// CHECK: [0x00,0x00,0x44,0xd8,0x01,0x02,0x03,0x00]

ds_cmpst_f32 v1, v2, v3 offset:4
// CHECK: [0x04,0x00,0x44,0xd8,0x01,0x02,0x03,0x00]

ds_cmpst_f32 v1, v2, v3 offset:65535 gds
// CHECK: [0xff,0xff,0x46,0xd8,0x01,0x02,0x03,0x00]

ds_min_f32 v1, v2 offset:65535
// CHECK: [0xff,0xff,0x48,0xd8,0x01,0x02,0x00,0x00]

ds_min_f32 v255, v2 offset:65535
// CHECK: [0xff,0xff,0x48,0xd8,0xff,0x02,0x00,0x00]

ds_min_f32 v1, v255 offset:65535
// CHECK: [0xff,0xff,0x48,0xd8,0x01,0xff,0x00,0x00]

ds_min_f32 v1, v2
// CHECK: [0x00,0x00,0x48,0xd8,0x01,0x02,0x00,0x00]

ds_min_f32 v1, v2 offset:0
// CHECK: [0x00,0x00,0x48,0xd8,0x01,0x02,0x00,0x00]

ds_min_f32 v1, v2 offset:4
// CHECK: [0x04,0x00,0x48,0xd8,0x01,0x02,0x00,0x00]

ds_min_f32 v1, v2 offset:65535 gds
// CHECK: [0xff,0xff,0x4a,0xd8,0x01,0x02,0x00,0x00]

ds_max_f32 v1, v2 offset:65535
// CHECK: [0xff,0xff,0x4c,0xd8,0x01,0x02,0x00,0x00]

ds_max_f32 v255, v2 offset:65535
// CHECK: [0xff,0xff,0x4c,0xd8,0xff,0x02,0x00,0x00]

ds_max_f32 v1, v255 offset:65535
// CHECK: [0xff,0xff,0x4c,0xd8,0x01,0xff,0x00,0x00]

ds_max_f32 v1, v2
// CHECK: [0x00,0x00,0x4c,0xd8,0x01,0x02,0x00,0x00]

ds_max_f32 v1, v2 offset:0
// CHECK: [0x00,0x00,0x4c,0xd8,0x01,0x02,0x00,0x00]

ds_max_f32 v1, v2 offset:4
// CHECK: [0x04,0x00,0x4c,0xd8,0x01,0x02,0x00,0x00]

ds_max_f32 v1, v2 offset:65535 gds
// CHECK: [0xff,0xff,0x4e,0xd8,0x01,0x02,0x00,0x00]

ds_nop
// CHECK: [0x00,0x00,0x50,0xd8,0x00,0x00,0x00,0x00]

ds_gws_sema_release_all offset:65535 gds
// CHECK: [0xff,0xff,0x62,0xd8,0x00,0x00,0x00,0x00]

ds_gws_sema_release_all gds
// CHECK: [0x00,0x00,0x62,0xd8,0x00,0x00,0x00,0x00]

ds_gws_sema_release_all offset:0 gds
// CHECK: [0x00,0x00,0x62,0xd8,0x00,0x00,0x00,0x00]

ds_gws_sema_release_all offset:4 gds
// CHECK: [0x04,0x00,0x62,0xd8,0x00,0x00,0x00,0x00]

ds_gws_init v1 offset:65535 gds
// CHECK: [0xff,0xff,0x66,0xd8,0x00,0x01,0x00,0x00]

ds_gws_init v255 offset:65535 gds
// CHECK: [0xff,0xff,0x66,0xd8,0x00,0xff,0x00,0x00]

ds_gws_init v1 gds
// CHECK: [0x00,0x00,0x66,0xd8,0x00,0x01,0x00,0x00]

ds_gws_init v1 offset:0 gds
// CHECK: [0x00,0x00,0x66,0xd8,0x00,0x01,0x00,0x00]

ds_gws_init v1 offset:4 gds
// CHECK: [0x04,0x00,0x66,0xd8,0x00,0x01,0x00,0x00]

ds_gws_sema_v offset:65535 gds
// CHECK: [0xff,0xff,0x6a,0xd8,0x00,0x00,0x00,0x00]

ds_gws_sema_v gds
// CHECK: [0x00,0x00,0x6a,0xd8,0x00,0x00,0x00,0x00]

ds_gws_sema_v offset:0 gds
// CHECK: [0x00,0x00,0x6a,0xd8,0x00,0x00,0x00,0x00]

ds_gws_sema_v offset:4 gds
// CHECK: [0x04,0x00,0x6a,0xd8,0x00,0x00,0x00,0x00]

ds_gws_sema_br v1 offset:65535 gds
// CHECK: [0xff,0xff,0x6e,0xd8,0x00,0x01,0x00,0x00]

ds_gws_sema_br v255 offset:65535 gds
// CHECK: [0xff,0xff,0x6e,0xd8,0x00,0xff,0x00,0x00]

ds_gws_sema_br v1 gds
// CHECK: [0x00,0x00,0x6e,0xd8,0x00,0x01,0x00,0x00]

ds_gws_sema_br v1 offset:0 gds
// CHECK: [0x00,0x00,0x6e,0xd8,0x00,0x01,0x00,0x00]

ds_gws_sema_br v1 offset:4 gds
// CHECK: [0x04,0x00,0x6e,0xd8,0x00,0x01,0x00,0x00]

ds_gws_sema_p offset:65535 gds
// CHECK: [0xff,0xff,0x72,0xd8,0x00,0x00,0x00,0x00]

ds_gws_sema_p gds
// CHECK: [0x00,0x00,0x72,0xd8,0x00,0x00,0x00,0x00]

ds_gws_sema_p offset:0 gds
// CHECK: [0x00,0x00,0x72,0xd8,0x00,0x00,0x00,0x00]

ds_gws_sema_p offset:4 gds
// CHECK: [0x04,0x00,0x72,0xd8,0x00,0x00,0x00,0x00]

ds_gws_barrier v1 offset:65535 gds
// CHECK: [0xff,0xff,0x76,0xd8,0x00,0x01,0x00,0x00]

ds_gws_barrier v255 offset:65535 gds
// CHECK: [0xff,0xff,0x76,0xd8,0x00,0xff,0x00,0x00]

ds_gws_barrier v1 gds
// CHECK: [0x00,0x00,0x76,0xd8,0x00,0x01,0x00,0x00]

ds_gws_barrier v1 offset:0 gds
// CHECK: [0x00,0x00,0x76,0xd8,0x00,0x01,0x00,0x00]

ds_gws_barrier v1 offset:4 gds
// CHECK: [0x04,0x00,0x76,0xd8,0x00,0x01,0x00,0x00]

ds_write_b8 v1, v2 offset:65535
// CHECK: [0xff,0xff,0x78,0xd8,0x01,0x02,0x00,0x00]

ds_write_b8 v255, v2 offset:65535
// CHECK: [0xff,0xff,0x78,0xd8,0xff,0x02,0x00,0x00]

ds_write_b8 v1, v255 offset:65535
// CHECK: [0xff,0xff,0x78,0xd8,0x01,0xff,0x00,0x00]

ds_write_b8 v1, v2
// CHECK: [0x00,0x00,0x78,0xd8,0x01,0x02,0x00,0x00]

ds_write_b8 v1, v2 offset:0
// CHECK: [0x00,0x00,0x78,0xd8,0x01,0x02,0x00,0x00]

ds_write_b8 v1, v2 offset:4
// CHECK: [0x04,0x00,0x78,0xd8,0x01,0x02,0x00,0x00]

ds_write_b8 v1, v2 offset:65535 gds
// CHECK: [0xff,0xff,0x7a,0xd8,0x01,0x02,0x00,0x00]

ds_write_b16 v1, v2 offset:65535
// CHECK: [0xff,0xff,0x7c,0xd8,0x01,0x02,0x00,0x00]

ds_write_b16 v255, v2 offset:65535
// CHECK: [0xff,0xff,0x7c,0xd8,0xff,0x02,0x00,0x00]

ds_write_b16 v1, v255 offset:65535
// CHECK: [0xff,0xff,0x7c,0xd8,0x01,0xff,0x00,0x00]

ds_write_b16 v1, v2
// CHECK: [0x00,0x00,0x7c,0xd8,0x01,0x02,0x00,0x00]

ds_write_b16 v1, v2 offset:0
// CHECK: [0x00,0x00,0x7c,0xd8,0x01,0x02,0x00,0x00]

ds_write_b16 v1, v2 offset:4
// CHECK: [0x04,0x00,0x7c,0xd8,0x01,0x02,0x00,0x00]

ds_write_b16 v1, v2 offset:65535 gds
// CHECK: [0xff,0xff,0x7e,0xd8,0x01,0x02,0x00,0x00]

ds_add_rtn_u32 v5, v1, v2 offset:65535
// CHECK: [0xff,0xff,0x80,0xd8,0x01,0x02,0x00,0x05]

ds_add_rtn_u32 v255, v1, v2 offset:65535
// CHECK: [0xff,0xff,0x80,0xd8,0x01,0x02,0x00,0xff]

ds_add_rtn_u32 v5, v255, v2 offset:65535
// CHECK: [0xff,0xff,0x80,0xd8,0xff,0x02,0x00,0x05]

ds_add_rtn_u32 v5, v1, v255 offset:65535
// CHECK: [0xff,0xff,0x80,0xd8,0x01,0xff,0x00,0x05]

ds_add_rtn_u32 v5, v1, v2
// CHECK: [0x00,0x00,0x80,0xd8,0x01,0x02,0x00,0x05]

ds_add_rtn_u32 v5, v1, v2 offset:0
// CHECK: [0x00,0x00,0x80,0xd8,0x01,0x02,0x00,0x05]

ds_add_rtn_u32 v5, v1, v2 offset:4
// CHECK: [0x04,0x00,0x80,0xd8,0x01,0x02,0x00,0x05]

ds_add_rtn_u32 v5, v1, v2 offset:65535 gds
// CHECK: [0xff,0xff,0x82,0xd8,0x01,0x02,0x00,0x05]

ds_sub_rtn_u32 v5, v1, v2 offset:65535
// CHECK: [0xff,0xff,0x84,0xd8,0x01,0x02,0x00,0x05]

ds_sub_rtn_u32 v255, v1, v2 offset:65535
// CHECK: [0xff,0xff,0x84,0xd8,0x01,0x02,0x00,0xff]

ds_sub_rtn_u32 v5, v255, v2 offset:65535
// CHECK: [0xff,0xff,0x84,0xd8,0xff,0x02,0x00,0x05]

ds_sub_rtn_u32 v5, v1, v255 offset:65535
// CHECK: [0xff,0xff,0x84,0xd8,0x01,0xff,0x00,0x05]

ds_sub_rtn_u32 v5, v1, v2
// CHECK: [0x00,0x00,0x84,0xd8,0x01,0x02,0x00,0x05]

ds_sub_rtn_u32 v5, v1, v2 offset:0
// CHECK: [0x00,0x00,0x84,0xd8,0x01,0x02,0x00,0x05]

ds_sub_rtn_u32 v5, v1, v2 offset:4
// CHECK: [0x04,0x00,0x84,0xd8,0x01,0x02,0x00,0x05]

ds_sub_rtn_u32 v5, v1, v2 offset:65535 gds
// CHECK: [0xff,0xff,0x86,0xd8,0x01,0x02,0x00,0x05]

ds_rsub_rtn_u32 v5, v1, v2 offset:65535
// CHECK: [0xff,0xff,0x88,0xd8,0x01,0x02,0x00,0x05]

ds_rsub_rtn_u32 v255, v1, v2 offset:65535
// CHECK: [0xff,0xff,0x88,0xd8,0x01,0x02,0x00,0xff]

ds_rsub_rtn_u32 v5, v255, v2 offset:65535
// CHECK: [0xff,0xff,0x88,0xd8,0xff,0x02,0x00,0x05]

ds_rsub_rtn_u32 v5, v1, v255 offset:65535
// CHECK: [0xff,0xff,0x88,0xd8,0x01,0xff,0x00,0x05]

ds_rsub_rtn_u32 v5, v1, v2
// CHECK: [0x00,0x00,0x88,0xd8,0x01,0x02,0x00,0x05]

ds_rsub_rtn_u32 v5, v1, v2 offset:0
// CHECK: [0x00,0x00,0x88,0xd8,0x01,0x02,0x00,0x05]

ds_rsub_rtn_u32 v5, v1, v2 offset:4
// CHECK: [0x04,0x00,0x88,0xd8,0x01,0x02,0x00,0x05]

ds_rsub_rtn_u32 v5, v1, v2 offset:65535 gds
// CHECK: [0xff,0xff,0x8a,0xd8,0x01,0x02,0x00,0x05]

ds_inc_rtn_u32 v5, v1, v2 offset:65535
// CHECK: [0xff,0xff,0x8c,0xd8,0x01,0x02,0x00,0x05]

ds_inc_rtn_u32 v255, v1, v2 offset:65535
// CHECK: [0xff,0xff,0x8c,0xd8,0x01,0x02,0x00,0xff]

ds_inc_rtn_u32 v5, v255, v2 offset:65535
// CHECK: [0xff,0xff,0x8c,0xd8,0xff,0x02,0x00,0x05]

ds_inc_rtn_u32 v5, v1, v255 offset:65535
// CHECK: [0xff,0xff,0x8c,0xd8,0x01,0xff,0x00,0x05]

ds_inc_rtn_u32 v5, v1, v2
// CHECK: [0x00,0x00,0x8c,0xd8,0x01,0x02,0x00,0x05]

ds_inc_rtn_u32 v5, v1, v2 offset:0
// CHECK: [0x00,0x00,0x8c,0xd8,0x01,0x02,0x00,0x05]

ds_inc_rtn_u32 v5, v1, v2 offset:4
// CHECK: [0x04,0x00,0x8c,0xd8,0x01,0x02,0x00,0x05]

ds_inc_rtn_u32 v5, v1, v2 offset:65535 gds
// CHECK: [0xff,0xff,0x8e,0xd8,0x01,0x02,0x00,0x05]

ds_dec_rtn_u32 v5, v1, v2 offset:65535
// CHECK: [0xff,0xff,0x90,0xd8,0x01,0x02,0x00,0x05]

ds_dec_rtn_u32 v255, v1, v2 offset:65535
// CHECK: [0xff,0xff,0x90,0xd8,0x01,0x02,0x00,0xff]

ds_dec_rtn_u32 v5, v255, v2 offset:65535
// CHECK: [0xff,0xff,0x90,0xd8,0xff,0x02,0x00,0x05]

ds_dec_rtn_u32 v5, v1, v255 offset:65535
// CHECK: [0xff,0xff,0x90,0xd8,0x01,0xff,0x00,0x05]

ds_dec_rtn_u32 v5, v1, v2
// CHECK: [0x00,0x00,0x90,0xd8,0x01,0x02,0x00,0x05]

ds_dec_rtn_u32 v5, v1, v2 offset:0
// CHECK: [0x00,0x00,0x90,0xd8,0x01,0x02,0x00,0x05]

ds_dec_rtn_u32 v5, v1, v2 offset:4
// CHECK: [0x04,0x00,0x90,0xd8,0x01,0x02,0x00,0x05]

ds_dec_rtn_u32 v5, v1, v2 offset:65535 gds
// CHECK: [0xff,0xff,0x92,0xd8,0x01,0x02,0x00,0x05]

ds_min_rtn_i32 v5, v1, v2 offset:65535
// CHECK: [0xff,0xff,0x94,0xd8,0x01,0x02,0x00,0x05]

ds_min_rtn_i32 v255, v1, v2 offset:65535
// CHECK: [0xff,0xff,0x94,0xd8,0x01,0x02,0x00,0xff]

ds_min_rtn_i32 v5, v255, v2 offset:65535
// CHECK: [0xff,0xff,0x94,0xd8,0xff,0x02,0x00,0x05]

ds_min_rtn_i32 v5, v1, v255 offset:65535
// CHECK: [0xff,0xff,0x94,0xd8,0x01,0xff,0x00,0x05]

ds_min_rtn_i32 v5, v1, v2
// CHECK: [0x00,0x00,0x94,0xd8,0x01,0x02,0x00,0x05]

ds_min_rtn_i32 v5, v1, v2 offset:0
// CHECK: [0x00,0x00,0x94,0xd8,0x01,0x02,0x00,0x05]

ds_min_rtn_i32 v5, v1, v2 offset:4
// CHECK: [0x04,0x00,0x94,0xd8,0x01,0x02,0x00,0x05]

ds_min_rtn_i32 v5, v1, v2 offset:65535 gds
// CHECK: [0xff,0xff,0x96,0xd8,0x01,0x02,0x00,0x05]

ds_max_rtn_i32 v5, v1, v2 offset:65535
// CHECK: [0xff,0xff,0x98,0xd8,0x01,0x02,0x00,0x05]

ds_max_rtn_i32 v255, v1, v2 offset:65535
// CHECK: [0xff,0xff,0x98,0xd8,0x01,0x02,0x00,0xff]

ds_max_rtn_i32 v5, v255, v2 offset:65535
// CHECK: [0xff,0xff,0x98,0xd8,0xff,0x02,0x00,0x05]

ds_max_rtn_i32 v5, v1, v255 offset:65535
// CHECK: [0xff,0xff,0x98,0xd8,0x01,0xff,0x00,0x05]

ds_max_rtn_i32 v5, v1, v2
// CHECK: [0x00,0x00,0x98,0xd8,0x01,0x02,0x00,0x05]

ds_max_rtn_i32 v5, v1, v2 offset:0
// CHECK: [0x00,0x00,0x98,0xd8,0x01,0x02,0x00,0x05]

ds_max_rtn_i32 v5, v1, v2 offset:4
// CHECK: [0x04,0x00,0x98,0xd8,0x01,0x02,0x00,0x05]

ds_max_rtn_i32 v5, v1, v2 offset:65535 gds
// CHECK: [0xff,0xff,0x9a,0xd8,0x01,0x02,0x00,0x05]

ds_min_rtn_u32 v5, v1, v2 offset:65535
// CHECK: [0xff,0xff,0x9c,0xd8,0x01,0x02,0x00,0x05]

ds_min_rtn_u32 v255, v1, v2 offset:65535
// CHECK: [0xff,0xff,0x9c,0xd8,0x01,0x02,0x00,0xff]

ds_min_rtn_u32 v5, v255, v2 offset:65535
// CHECK: [0xff,0xff,0x9c,0xd8,0xff,0x02,0x00,0x05]

ds_min_rtn_u32 v5, v1, v255 offset:65535
// CHECK: [0xff,0xff,0x9c,0xd8,0x01,0xff,0x00,0x05]

ds_min_rtn_u32 v5, v1, v2
// CHECK: [0x00,0x00,0x9c,0xd8,0x01,0x02,0x00,0x05]

ds_min_rtn_u32 v5, v1, v2 offset:0
// CHECK: [0x00,0x00,0x9c,0xd8,0x01,0x02,0x00,0x05]

ds_min_rtn_u32 v5, v1, v2 offset:4
// CHECK: [0x04,0x00,0x9c,0xd8,0x01,0x02,0x00,0x05]

ds_min_rtn_u32 v5, v1, v2 offset:65535 gds
// CHECK: [0xff,0xff,0x9e,0xd8,0x01,0x02,0x00,0x05]

ds_max_rtn_u32 v5, v1, v2 offset:65535
// CHECK: [0xff,0xff,0xa0,0xd8,0x01,0x02,0x00,0x05]

ds_max_rtn_u32 v255, v1, v2 offset:65535
// CHECK: [0xff,0xff,0xa0,0xd8,0x01,0x02,0x00,0xff]

ds_max_rtn_u32 v5, v255, v2 offset:65535
// CHECK: [0xff,0xff,0xa0,0xd8,0xff,0x02,0x00,0x05]

ds_max_rtn_u32 v5, v1, v255 offset:65535
// CHECK: [0xff,0xff,0xa0,0xd8,0x01,0xff,0x00,0x05]

ds_max_rtn_u32 v5, v1, v2
// CHECK: [0x00,0x00,0xa0,0xd8,0x01,0x02,0x00,0x05]

ds_max_rtn_u32 v5, v1, v2 offset:0
// CHECK: [0x00,0x00,0xa0,0xd8,0x01,0x02,0x00,0x05]

ds_max_rtn_u32 v5, v1, v2 offset:4
// CHECK: [0x04,0x00,0xa0,0xd8,0x01,0x02,0x00,0x05]

ds_max_rtn_u32 v5, v1, v2 offset:65535 gds
// CHECK: [0xff,0xff,0xa2,0xd8,0x01,0x02,0x00,0x05]

ds_and_rtn_b32 v5, v1, v2 offset:65535
// CHECK: [0xff,0xff,0xa4,0xd8,0x01,0x02,0x00,0x05]

ds_and_rtn_b32 v255, v1, v2 offset:65535
// CHECK: [0xff,0xff,0xa4,0xd8,0x01,0x02,0x00,0xff]

ds_and_rtn_b32 v5, v255, v2 offset:65535
// CHECK: [0xff,0xff,0xa4,0xd8,0xff,0x02,0x00,0x05]

ds_and_rtn_b32 v5, v1, v255 offset:65535
// CHECK: [0xff,0xff,0xa4,0xd8,0x01,0xff,0x00,0x05]

ds_and_rtn_b32 v5, v1, v2
// CHECK: [0x00,0x00,0xa4,0xd8,0x01,0x02,0x00,0x05]

ds_and_rtn_b32 v5, v1, v2 offset:0
// CHECK: [0x00,0x00,0xa4,0xd8,0x01,0x02,0x00,0x05]

ds_and_rtn_b32 v5, v1, v2 offset:4
// CHECK: [0x04,0x00,0xa4,0xd8,0x01,0x02,0x00,0x05]

ds_and_rtn_b32 v5, v1, v2 offset:65535 gds
// CHECK: [0xff,0xff,0xa6,0xd8,0x01,0x02,0x00,0x05]

ds_or_rtn_b32 v5, v1, v2 offset:65535
// CHECK: [0xff,0xff,0xa8,0xd8,0x01,0x02,0x00,0x05]

ds_or_rtn_b32 v255, v1, v2 offset:65535
// CHECK: [0xff,0xff,0xa8,0xd8,0x01,0x02,0x00,0xff]

ds_or_rtn_b32 v5, v255, v2 offset:65535
// CHECK: [0xff,0xff,0xa8,0xd8,0xff,0x02,0x00,0x05]

ds_or_rtn_b32 v5, v1, v255 offset:65535
// CHECK: [0xff,0xff,0xa8,0xd8,0x01,0xff,0x00,0x05]

ds_or_rtn_b32 v5, v1, v2
// CHECK: [0x00,0x00,0xa8,0xd8,0x01,0x02,0x00,0x05]

ds_or_rtn_b32 v5, v1, v2 offset:0
// CHECK: [0x00,0x00,0xa8,0xd8,0x01,0x02,0x00,0x05]

ds_or_rtn_b32 v5, v1, v2 offset:4
// CHECK: [0x04,0x00,0xa8,0xd8,0x01,0x02,0x00,0x05]

ds_or_rtn_b32 v5, v1, v2 offset:65535 gds
// CHECK: [0xff,0xff,0xaa,0xd8,0x01,0x02,0x00,0x05]

ds_xor_rtn_b32 v5, v1, v2 offset:65535
// CHECK: [0xff,0xff,0xac,0xd8,0x01,0x02,0x00,0x05]

ds_xor_rtn_b32 v255, v1, v2 offset:65535
// CHECK: [0xff,0xff,0xac,0xd8,0x01,0x02,0x00,0xff]

ds_xor_rtn_b32 v5, v255, v2 offset:65535
// CHECK: [0xff,0xff,0xac,0xd8,0xff,0x02,0x00,0x05]

ds_xor_rtn_b32 v5, v1, v255 offset:65535
// CHECK: [0xff,0xff,0xac,0xd8,0x01,0xff,0x00,0x05]

ds_xor_rtn_b32 v5, v1, v2
// CHECK: [0x00,0x00,0xac,0xd8,0x01,0x02,0x00,0x05]

ds_xor_rtn_b32 v5, v1, v2 offset:0
// CHECK: [0x00,0x00,0xac,0xd8,0x01,0x02,0x00,0x05]

ds_xor_rtn_b32 v5, v1, v2 offset:4
// CHECK: [0x04,0x00,0xac,0xd8,0x01,0x02,0x00,0x05]

ds_xor_rtn_b32 v5, v1, v2 offset:65535 gds
// CHECK: [0xff,0xff,0xae,0xd8,0x01,0x02,0x00,0x05]

ds_mskor_rtn_b32 v5, v1, v2, v3 offset:65535
// CHECK: [0xff,0xff,0xb0,0xd8,0x01,0x02,0x03,0x05]

ds_mskor_rtn_b32 v255, v1, v2, v3 offset:65535
// CHECK: [0xff,0xff,0xb0,0xd8,0x01,0x02,0x03,0xff]

ds_mskor_rtn_b32 v5, v255, v2, v3 offset:65535
// CHECK: [0xff,0xff,0xb0,0xd8,0xff,0x02,0x03,0x05]

ds_mskor_rtn_b32 v5, v1, v255, v3 offset:65535
// CHECK: [0xff,0xff,0xb0,0xd8,0x01,0xff,0x03,0x05]

ds_mskor_rtn_b32 v5, v1, v2, v255 offset:65535
// CHECK: [0xff,0xff,0xb0,0xd8,0x01,0x02,0xff,0x05]

ds_mskor_rtn_b32 v5, v1, v2, v3
// CHECK: [0x00,0x00,0xb0,0xd8,0x01,0x02,0x03,0x05]

ds_mskor_rtn_b32 v5, v1, v2, v3 offset:0
// CHECK: [0x00,0x00,0xb0,0xd8,0x01,0x02,0x03,0x05]

ds_mskor_rtn_b32 v5, v1, v2, v3 offset:4
// CHECK: [0x04,0x00,0xb0,0xd8,0x01,0x02,0x03,0x05]

ds_mskor_rtn_b32 v5, v1, v2, v3 offset:65535 gds
// CHECK: [0xff,0xff,0xb2,0xd8,0x01,0x02,0x03,0x05]

ds_wrxchg_rtn_b32 v5, v1, v2 offset:65535
// CHECK: [0xff,0xff,0xb4,0xd8,0x01,0x02,0x00,0x05]

ds_wrxchg_rtn_b32 v255, v1, v2 offset:65535
// CHECK: [0xff,0xff,0xb4,0xd8,0x01,0x02,0x00,0xff]

ds_wrxchg_rtn_b32 v5, v255, v2 offset:65535
// CHECK: [0xff,0xff,0xb4,0xd8,0xff,0x02,0x00,0x05]

ds_wrxchg_rtn_b32 v5, v1, v255 offset:65535
// CHECK: [0xff,0xff,0xb4,0xd8,0x01,0xff,0x00,0x05]

ds_wrxchg_rtn_b32 v5, v1, v2
// CHECK: [0x00,0x00,0xb4,0xd8,0x01,0x02,0x00,0x05]

ds_wrxchg_rtn_b32 v5, v1, v2 offset:0
// CHECK: [0x00,0x00,0xb4,0xd8,0x01,0x02,0x00,0x05]

ds_wrxchg_rtn_b32 v5, v1, v2 offset:4
// CHECK: [0x04,0x00,0xb4,0xd8,0x01,0x02,0x00,0x05]

ds_wrxchg_rtn_b32 v5, v1, v2 offset:65535 gds
// CHECK: [0xff,0xff,0xb6,0xd8,0x01,0x02,0x00,0x05]

ds_wrxchg2_rtn_b32 v[5:6], v1, v2, v3 offset0:127 offset1:255
// CHECK: [0x7f,0xff,0xb8,0xd8,0x01,0x02,0x03,0x05]

ds_wrxchg2_rtn_b32 v[254:255], v1, v2, v3 offset0:127 offset1:255
// CHECK: [0x7f,0xff,0xb8,0xd8,0x01,0x02,0x03,0xfe]

ds_wrxchg2_rtn_b32 v[5:6], v255, v2, v3 offset0:127 offset1:255
// CHECK: [0x7f,0xff,0xb8,0xd8,0xff,0x02,0x03,0x05]

ds_wrxchg2_rtn_b32 v[5:6], v1, v255, v3 offset0:127 offset1:255
// CHECK: [0x7f,0xff,0xb8,0xd8,0x01,0xff,0x03,0x05]

ds_wrxchg2_rtn_b32 v[5:6], v1, v2, v255 offset0:127 offset1:255
// CHECK: [0x7f,0xff,0xb8,0xd8,0x01,0x02,0xff,0x05]

ds_wrxchg2_rtn_b32 v[5:6], v1, v2, v3 offset1:255
// CHECK: [0x00,0xff,0xb8,0xd8,0x01,0x02,0x03,0x05]

ds_wrxchg2_rtn_b32 v[5:6], v1, v2, v3 offset0:0 offset1:255
// CHECK: [0x00,0xff,0xb8,0xd8,0x01,0x02,0x03,0x05]

ds_wrxchg2_rtn_b32 v[5:6], v1, v2, v3 offset0:16 offset1:255
// CHECK: [0x10,0xff,0xb8,0xd8,0x01,0x02,0x03,0x05]

ds_wrxchg2_rtn_b32 v[5:6], v1, v2, v3 offset0:127
// CHECK: [0x7f,0x00,0xb8,0xd8,0x01,0x02,0x03,0x05]

ds_wrxchg2_rtn_b32 v[5:6], v1, v2, v3 offset0:127 offset1:0
// CHECK: [0x7f,0x00,0xb8,0xd8,0x01,0x02,0x03,0x05]

ds_wrxchg2_rtn_b32 v[5:6], v1, v2, v3 offset0:127 offset1:1
// CHECK: [0x7f,0x01,0xb8,0xd8,0x01,0x02,0x03,0x05]

ds_wrxchg2_rtn_b32 v[5:6], v1, v2, v3 offset0:127 offset1:255 gds
// CHECK: [0x7f,0xff,0xba,0xd8,0x01,0x02,0x03,0x05]

ds_wrxchg2st64_rtn_b32 v[5:6], v1, v2, v3 offset0:127 offset1:255
// CHECK: [0x7f,0xff,0xbc,0xd8,0x01,0x02,0x03,0x05]

ds_wrxchg2st64_rtn_b32 v[254:255], v1, v2, v3 offset0:127 offset1:255
// CHECK: [0x7f,0xff,0xbc,0xd8,0x01,0x02,0x03,0xfe]

ds_wrxchg2st64_rtn_b32 v[5:6], v255, v2, v3 offset0:127 offset1:255
// CHECK: [0x7f,0xff,0xbc,0xd8,0xff,0x02,0x03,0x05]

ds_wrxchg2st64_rtn_b32 v[5:6], v1, v255, v3 offset0:127 offset1:255
// CHECK: [0x7f,0xff,0xbc,0xd8,0x01,0xff,0x03,0x05]

ds_wrxchg2st64_rtn_b32 v[5:6], v1, v2, v255 offset0:127 offset1:255
// CHECK: [0x7f,0xff,0xbc,0xd8,0x01,0x02,0xff,0x05]

ds_wrxchg2st64_rtn_b32 v[5:6], v1, v2, v3 offset1:255
// CHECK: [0x00,0xff,0xbc,0xd8,0x01,0x02,0x03,0x05]

ds_wrxchg2st64_rtn_b32 v[5:6], v1, v2, v3 offset0:0 offset1:255
// CHECK: [0x00,0xff,0xbc,0xd8,0x01,0x02,0x03,0x05]

ds_wrxchg2st64_rtn_b32 v[5:6], v1, v2, v3 offset0:16 offset1:255
// CHECK: [0x10,0xff,0xbc,0xd8,0x01,0x02,0x03,0x05]

ds_wrxchg2st64_rtn_b32 v[5:6], v1, v2, v3 offset0:127
// CHECK: [0x7f,0x00,0xbc,0xd8,0x01,0x02,0x03,0x05]

ds_wrxchg2st64_rtn_b32 v[5:6], v1, v2, v3 offset0:127 offset1:0
// CHECK: [0x7f,0x00,0xbc,0xd8,0x01,0x02,0x03,0x05]

ds_wrxchg2st64_rtn_b32 v[5:6], v1, v2, v3 offset0:127 offset1:1
// CHECK: [0x7f,0x01,0xbc,0xd8,0x01,0x02,0x03,0x05]

ds_wrxchg2st64_rtn_b32 v[5:6], v1, v2, v3 offset0:127 offset1:255 gds
// CHECK: [0x7f,0xff,0xbe,0xd8,0x01,0x02,0x03,0x05]

ds_cmpst_rtn_b32 v5, v1, v2, v3 offset:65535
// CHECK: [0xff,0xff,0xc0,0xd8,0x01,0x02,0x03,0x05]

ds_cmpst_rtn_b32 v255, v1, v2, v3 offset:65535
// CHECK: [0xff,0xff,0xc0,0xd8,0x01,0x02,0x03,0xff]

ds_cmpst_rtn_b32 v5, v255, v2, v3 offset:65535
// CHECK: [0xff,0xff,0xc0,0xd8,0xff,0x02,0x03,0x05]

ds_cmpst_rtn_b32 v5, v1, v255, v3 offset:65535
// CHECK: [0xff,0xff,0xc0,0xd8,0x01,0xff,0x03,0x05]

ds_cmpst_rtn_b32 v5, v1, v2, v255 offset:65535
// CHECK: [0xff,0xff,0xc0,0xd8,0x01,0x02,0xff,0x05]

ds_cmpst_rtn_b32 v5, v1, v2, v3
// CHECK: [0x00,0x00,0xc0,0xd8,0x01,0x02,0x03,0x05]

ds_cmpst_rtn_b32 v5, v1, v2, v3 offset:0
// CHECK: [0x00,0x00,0xc0,0xd8,0x01,0x02,0x03,0x05]

ds_cmpst_rtn_b32 v5, v1, v2, v3 offset:4
// CHECK: [0x04,0x00,0xc0,0xd8,0x01,0x02,0x03,0x05]

ds_cmpst_rtn_b32 v5, v1, v2, v3 offset:65535 gds
// CHECK: [0xff,0xff,0xc2,0xd8,0x01,0x02,0x03,0x05]

ds_cmpst_rtn_f32 v5, v1, v2, v3 offset:65535
// CHECK: [0xff,0xff,0xc4,0xd8,0x01,0x02,0x03,0x05]

ds_cmpst_rtn_f32 v255, v1, v2, v3 offset:65535
// CHECK: [0xff,0xff,0xc4,0xd8,0x01,0x02,0x03,0xff]

ds_cmpst_rtn_f32 v5, v255, v2, v3 offset:65535
// CHECK: [0xff,0xff,0xc4,0xd8,0xff,0x02,0x03,0x05]

ds_cmpst_rtn_f32 v5, v1, v255, v3 offset:65535
// CHECK: [0xff,0xff,0xc4,0xd8,0x01,0xff,0x03,0x05]

ds_cmpst_rtn_f32 v5, v1, v2, v255 offset:65535
// CHECK: [0xff,0xff,0xc4,0xd8,0x01,0x02,0xff,0x05]

ds_cmpst_rtn_f32 v5, v1, v2, v3
// CHECK: [0x00,0x00,0xc4,0xd8,0x01,0x02,0x03,0x05]

ds_cmpst_rtn_f32 v5, v1, v2, v3 offset:0
// CHECK: [0x00,0x00,0xc4,0xd8,0x01,0x02,0x03,0x05]

ds_cmpst_rtn_f32 v5, v1, v2, v3 offset:4
// CHECK: [0x04,0x00,0xc4,0xd8,0x01,0x02,0x03,0x05]

ds_cmpst_rtn_f32 v5, v1, v2, v3 offset:65535 gds
// CHECK: [0xff,0xff,0xc6,0xd8,0x01,0x02,0x03,0x05]

ds_min_rtn_f32 v5, v1, v2 offset:65535
// CHECK: [0xff,0xff,0xc8,0xd8,0x01,0x02,0x00,0x05]

ds_min_rtn_f32 v255, v1, v2 offset:65535
// CHECK: [0xff,0xff,0xc8,0xd8,0x01,0x02,0x00,0xff]

ds_min_rtn_f32 v5, v255, v2 offset:65535
// CHECK: [0xff,0xff,0xc8,0xd8,0xff,0x02,0x00,0x05]

ds_min_rtn_f32 v5, v1, v255 offset:65535
// CHECK: [0xff,0xff,0xc8,0xd8,0x01,0xff,0x00,0x05]

ds_min_rtn_f32 v5, v1, v2
// CHECK: [0x00,0x00,0xc8,0xd8,0x01,0x02,0x00,0x05]

ds_min_rtn_f32 v5, v1, v2 offset:0
// CHECK: [0x00,0x00,0xc8,0xd8,0x01,0x02,0x00,0x05]

ds_min_rtn_f32 v5, v1, v2 offset:4
// CHECK: [0x04,0x00,0xc8,0xd8,0x01,0x02,0x00,0x05]

ds_min_rtn_f32 v5, v1, v2 offset:65535 gds
// CHECK: [0xff,0xff,0xca,0xd8,0x01,0x02,0x00,0x05]

ds_max_rtn_f32 v5, v1, v2 offset:65535
// CHECK: [0xff,0xff,0xcc,0xd8,0x01,0x02,0x00,0x05]

ds_max_rtn_f32 v255, v1, v2 offset:65535
// CHECK: [0xff,0xff,0xcc,0xd8,0x01,0x02,0x00,0xff]

ds_max_rtn_f32 v5, v255, v2 offset:65535
// CHECK: [0xff,0xff,0xcc,0xd8,0xff,0x02,0x00,0x05]

ds_max_rtn_f32 v5, v1, v255 offset:65535
// CHECK: [0xff,0xff,0xcc,0xd8,0x01,0xff,0x00,0x05]

ds_max_rtn_f32 v5, v1, v2
// CHECK: [0x00,0x00,0xcc,0xd8,0x01,0x02,0x00,0x05]

ds_max_rtn_f32 v5, v1, v2 offset:0
// CHECK: [0x00,0x00,0xcc,0xd8,0x01,0x02,0x00,0x05]

ds_max_rtn_f32 v5, v1, v2 offset:4
// CHECK: [0x04,0x00,0xcc,0xd8,0x01,0x02,0x00,0x05]

ds_max_rtn_f32 v5, v1, v2 offset:65535 gds
// CHECK: [0xff,0xff,0xce,0xd8,0x01,0x02,0x00,0x05]

ds_wrap_rtn_b32 v5, v1, v2, v3 offset:65535
// CHECK: [0xff,0xff,0xd0,0xd8,0x01,0x02,0x03,0x05]

ds_wrap_rtn_b32 v255, v1, v2, v3 offset:65535
// CHECK: [0xff,0xff,0xd0,0xd8,0x01,0x02,0x03,0xff]

ds_wrap_rtn_b32 v5, v255, v2, v3 offset:65535
// CHECK: [0xff,0xff,0xd0,0xd8,0xff,0x02,0x03,0x05]

ds_wrap_rtn_b32 v5, v1, v255, v3 offset:65535
// CHECK: [0xff,0xff,0xd0,0xd8,0x01,0xff,0x03,0x05]

ds_wrap_rtn_b32 v5, v1, v2, v255 offset:65535
// CHECK: [0xff,0xff,0xd0,0xd8,0x01,0x02,0xff,0x05]

ds_wrap_rtn_b32 v5, v1, v2, v3
// CHECK: [0x00,0x00,0xd0,0xd8,0x01,0x02,0x03,0x05]

ds_wrap_rtn_b32 v5, v1, v2, v3 offset:0
// CHECK: [0x00,0x00,0xd0,0xd8,0x01,0x02,0x03,0x05]

ds_wrap_rtn_b32 v5, v1, v2, v3 offset:4
// CHECK: [0x04,0x00,0xd0,0xd8,0x01,0x02,0x03,0x05]

ds_wrap_rtn_b32 v5, v1, v2, v3 offset:65535 gds
// CHECK: [0xff,0xff,0xd2,0xd8,0x01,0x02,0x03,0x05]

ds_swizzle_b32 v5, v1 offset:65535
// CHECK: [0xff,0xff,0xd4,0xd8,0x01,0x00,0x00,0x05]

ds_swizzle_b32 v255, v1 offset:65535
// CHECK: [0xff,0xff,0xd4,0xd8,0x01,0x00,0x00,0xff]

ds_swizzle_b32 v5, v255 offset:65535
// CHECK: [0xff,0xff,0xd4,0xd8,0xff,0x00,0x00,0x05]

ds_swizzle_b32 v5, v1
// CHECK: [0x00,0x00,0xd4,0xd8,0x01,0x00,0x00,0x05]

ds_swizzle_b32 v5, v1 offset:0
// CHECK: [0x00,0x00,0xd4,0xd8,0x01,0x00,0x00,0x05]

ds_swizzle_b32 v5, v1 offset:4
// CHECK: [0x04,0x00,0xd4,0xd8,0x01,0x00,0x00,0x05]

ds_swizzle_b32 v5, v1 offset:65535 gds
// CHECK: [0xff,0xff,0xd6,0xd8,0x01,0x00,0x00,0x05]

ds_read_b32 v5, v1 offset:65535
// CHECK: [0xff,0xff,0xd8,0xd8,0x01,0x00,0x00,0x05]

ds_read_b32 v255, v1 offset:65535
// CHECK: [0xff,0xff,0xd8,0xd8,0x01,0x00,0x00,0xff]

ds_read_b32 v5, v255 offset:65535
// CHECK: [0xff,0xff,0xd8,0xd8,0xff,0x00,0x00,0x05]

ds_read_b32 v5, v1
// CHECK: [0x00,0x00,0xd8,0xd8,0x01,0x00,0x00,0x05]

ds_read_b32 v5, v1 offset:0
// CHECK: [0x00,0x00,0xd8,0xd8,0x01,0x00,0x00,0x05]

ds_read_b32 v5, v1 offset:4
// CHECK: [0x04,0x00,0xd8,0xd8,0x01,0x00,0x00,0x05]

ds_read_b32 v5, v1 offset:65535 gds
// CHECK: [0xff,0xff,0xda,0xd8,0x01,0x00,0x00,0x05]

ds_read2_b32 v[5:6], v1 offset0:127 offset1:255
// CHECK: [0x7f,0xff,0xdc,0xd8,0x01,0x00,0x00,0x05]

ds_read2_b32 v[254:255], v1 offset0:127 offset1:255
// CHECK: [0x7f,0xff,0xdc,0xd8,0x01,0x00,0x00,0xfe]

ds_read2_b32 v[5:6], v255 offset0:127 offset1:255
// CHECK: [0x7f,0xff,0xdc,0xd8,0xff,0x00,0x00,0x05]

ds_read2_b32 v[5:6], v1 offset1:255
// CHECK: [0x00,0xff,0xdc,0xd8,0x01,0x00,0x00,0x05]

ds_read2_b32 v[5:6], v1 offset0:0 offset1:255
// CHECK: [0x00,0xff,0xdc,0xd8,0x01,0x00,0x00,0x05]

ds_read2_b32 v[5:6], v1 offset0:16 offset1:255
// CHECK: [0x10,0xff,0xdc,0xd8,0x01,0x00,0x00,0x05]

ds_read2_b32 v[5:6], v1 offset0:127
// CHECK: [0x7f,0x00,0xdc,0xd8,0x01,0x00,0x00,0x05]

ds_read2_b32 v[5:6], v1 offset0:127 offset1:0
// CHECK: [0x7f,0x00,0xdc,0xd8,0x01,0x00,0x00,0x05]

ds_read2_b32 v[5:6], v1 offset0:127 offset1:1
// CHECK: [0x7f,0x01,0xdc,0xd8,0x01,0x00,0x00,0x05]

ds_read2_b32 v[5:6], v1 offset0:127 offset1:255 gds
// CHECK: [0x7f,0xff,0xde,0xd8,0x01,0x00,0x00,0x05]

ds_read2st64_b32 v[5:6], v1 offset0:127 offset1:255
// CHECK: [0x7f,0xff,0xe0,0xd8,0x01,0x00,0x00,0x05]

ds_read2st64_b32 v[254:255], v1 offset0:127 offset1:255
// CHECK: [0x7f,0xff,0xe0,0xd8,0x01,0x00,0x00,0xfe]

ds_read2st64_b32 v[5:6], v255 offset0:127 offset1:255
// CHECK: [0x7f,0xff,0xe0,0xd8,0xff,0x00,0x00,0x05]

ds_read2st64_b32 v[5:6], v1 offset1:255
// CHECK: [0x00,0xff,0xe0,0xd8,0x01,0x00,0x00,0x05]

ds_read2st64_b32 v[5:6], v1 offset0:0 offset1:255
// CHECK: [0x00,0xff,0xe0,0xd8,0x01,0x00,0x00,0x05]

ds_read2st64_b32 v[5:6], v1 offset0:16 offset1:255
// CHECK: [0x10,0xff,0xe0,0xd8,0x01,0x00,0x00,0x05]

ds_read2st64_b32 v[5:6], v1 offset0:127
// CHECK: [0x7f,0x00,0xe0,0xd8,0x01,0x00,0x00,0x05]

ds_read2st64_b32 v[5:6], v1 offset0:127 offset1:0
// CHECK: [0x7f,0x00,0xe0,0xd8,0x01,0x00,0x00,0x05]

ds_read2st64_b32 v[5:6], v1 offset0:127 offset1:1
// CHECK: [0x7f,0x01,0xe0,0xd8,0x01,0x00,0x00,0x05]

ds_read2st64_b32 v[5:6], v1 offset0:127 offset1:255 gds
// CHECK: [0x7f,0xff,0xe2,0xd8,0x01,0x00,0x00,0x05]

ds_read_i8 v5, v1 offset:65535
// CHECK: [0xff,0xff,0xe4,0xd8,0x01,0x00,0x00,0x05]

ds_read_i8 v255, v1 offset:65535
// CHECK: [0xff,0xff,0xe4,0xd8,0x01,0x00,0x00,0xff]

ds_read_i8 v5, v255 offset:65535
// CHECK: [0xff,0xff,0xe4,0xd8,0xff,0x00,0x00,0x05]

ds_read_i8 v5, v1
// CHECK: [0x00,0x00,0xe4,0xd8,0x01,0x00,0x00,0x05]

ds_read_i8 v5, v1 offset:0
// CHECK: [0x00,0x00,0xe4,0xd8,0x01,0x00,0x00,0x05]

ds_read_i8 v5, v1 offset:4
// CHECK: [0x04,0x00,0xe4,0xd8,0x01,0x00,0x00,0x05]

ds_read_i8 v5, v1 offset:65535 gds
// CHECK: [0xff,0xff,0xe6,0xd8,0x01,0x00,0x00,0x05]

ds_read_u8 v5, v1 offset:65535
// CHECK: [0xff,0xff,0xe8,0xd8,0x01,0x00,0x00,0x05]

ds_read_u8 v255, v1 offset:65535
// CHECK: [0xff,0xff,0xe8,0xd8,0x01,0x00,0x00,0xff]

ds_read_u8 v5, v255 offset:65535
// CHECK: [0xff,0xff,0xe8,0xd8,0xff,0x00,0x00,0x05]

ds_read_u8 v5, v1
// CHECK: [0x00,0x00,0xe8,0xd8,0x01,0x00,0x00,0x05]

ds_read_u8 v5, v1 offset:0
// CHECK: [0x00,0x00,0xe8,0xd8,0x01,0x00,0x00,0x05]

ds_read_u8 v5, v1 offset:4
// CHECK: [0x04,0x00,0xe8,0xd8,0x01,0x00,0x00,0x05]

ds_read_u8 v5, v1 offset:65535 gds
// CHECK: [0xff,0xff,0xea,0xd8,0x01,0x00,0x00,0x05]

ds_read_i16 v5, v1 offset:65535
// CHECK: [0xff,0xff,0xec,0xd8,0x01,0x00,0x00,0x05]

ds_read_i16 v255, v1 offset:65535
// CHECK: [0xff,0xff,0xec,0xd8,0x01,0x00,0x00,0xff]

ds_read_i16 v5, v255 offset:65535
// CHECK: [0xff,0xff,0xec,0xd8,0xff,0x00,0x00,0x05]

ds_read_i16 v5, v1
// CHECK: [0x00,0x00,0xec,0xd8,0x01,0x00,0x00,0x05]

ds_read_i16 v5, v1 offset:0
// CHECK: [0x00,0x00,0xec,0xd8,0x01,0x00,0x00,0x05]

ds_read_i16 v5, v1 offset:4
// CHECK: [0x04,0x00,0xec,0xd8,0x01,0x00,0x00,0x05]

ds_read_i16 v5, v1 offset:65535 gds
// CHECK: [0xff,0xff,0xee,0xd8,0x01,0x00,0x00,0x05]

ds_read_u16 v5, v1 offset:65535
// CHECK: [0xff,0xff,0xf0,0xd8,0x01,0x00,0x00,0x05]

ds_read_u16 v255, v1 offset:65535
// CHECK: [0xff,0xff,0xf0,0xd8,0x01,0x00,0x00,0xff]

ds_read_u16 v5, v255 offset:65535
// CHECK: [0xff,0xff,0xf0,0xd8,0xff,0x00,0x00,0x05]

ds_read_u16 v5, v1
// CHECK: [0x00,0x00,0xf0,0xd8,0x01,0x00,0x00,0x05]

ds_read_u16 v5, v1 offset:0
// CHECK: [0x00,0x00,0xf0,0xd8,0x01,0x00,0x00,0x05]

ds_read_u16 v5, v1 offset:4
// CHECK: [0x04,0x00,0xf0,0xd8,0x01,0x00,0x00,0x05]

ds_read_u16 v5, v1 offset:65535 gds
// CHECK: [0xff,0xff,0xf2,0xd8,0x01,0x00,0x00,0x05]

ds_consume v5 offset:65535
// CHECK: [0xff,0xff,0xf4,0xd8,0x00,0x00,0x00,0x05]

ds_consume v255 offset:65535
// CHECK: [0xff,0xff,0xf4,0xd8,0x00,0x00,0x00,0xff]

ds_consume v5
// CHECK: [0x00,0x00,0xf4,0xd8,0x00,0x00,0x00,0x05]

ds_consume v5 offset:0
// CHECK: [0x00,0x00,0xf4,0xd8,0x00,0x00,0x00,0x05]

ds_consume v5 offset:4
// CHECK: [0x04,0x00,0xf4,0xd8,0x00,0x00,0x00,0x05]

ds_consume v5 offset:65535 gds
// CHECK: [0xff,0xff,0xf6,0xd8,0x00,0x00,0x00,0x05]

ds_append v5 offset:65535
// CHECK: [0xff,0xff,0xf8,0xd8,0x00,0x00,0x00,0x05]

ds_append v255 offset:65535
// CHECK: [0xff,0xff,0xf8,0xd8,0x00,0x00,0x00,0xff]

ds_append v5
// CHECK: [0x00,0x00,0xf8,0xd8,0x00,0x00,0x00,0x05]

ds_append v5 offset:0
// CHECK: [0x00,0x00,0xf8,0xd8,0x00,0x00,0x00,0x05]

ds_append v5 offset:4
// CHECK: [0x04,0x00,0xf8,0xd8,0x00,0x00,0x00,0x05]

ds_append v5 offset:65535 gds
// CHECK: [0xff,0xff,0xfa,0xd8,0x00,0x00,0x00,0x05]

ds_ordered_count v5, v1 offset:65535 gds
// CHECK: [0xff,0xff,0xfe,0xd8,0x01,0x00,0x00,0x05]

ds_ordered_count v255, v1 offset:65535 gds
// CHECK: [0xff,0xff,0xfe,0xd8,0x01,0x00,0x00,0xff]

ds_ordered_count v5, v255 offset:65535 gds
// CHECK: [0xff,0xff,0xfe,0xd8,0xff,0x00,0x00,0x05]

ds_ordered_count v5, v1 gds
// CHECK: [0x00,0x00,0xfe,0xd8,0x01,0x00,0x00,0x05]

ds_ordered_count v5, v1 offset:0 gds
// CHECK: [0x00,0x00,0xfe,0xd8,0x01,0x00,0x00,0x05]

ds_ordered_count v5, v1 offset:4 gds
// CHECK: [0x04,0x00,0xfe,0xd8,0x01,0x00,0x00,0x05]

ds_add_u64 v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x00,0xd9,0x01,0x02,0x00,0x00]

ds_add_u64 v255, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x00,0xd9,0xff,0x02,0x00,0x00]

ds_add_u64 v1, v[254:255] offset:65535
// CHECK: [0xff,0xff,0x00,0xd9,0x01,0xfe,0x00,0x00]

ds_add_u64 v1, v[2:3]
// CHECK: [0x00,0x00,0x00,0xd9,0x01,0x02,0x00,0x00]

ds_add_u64 v1, v[2:3] offset:0
// CHECK: [0x00,0x00,0x00,0xd9,0x01,0x02,0x00,0x00]

ds_add_u64 v1, v[2:3] offset:4
// CHECK: [0x04,0x00,0x00,0xd9,0x01,0x02,0x00,0x00]

ds_add_u64 v1, v[2:3] offset:65535 gds
// CHECK: [0xff,0xff,0x02,0xd9,0x01,0x02,0x00,0x00]

ds_sub_u64 v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x04,0xd9,0x01,0x02,0x00,0x00]

ds_sub_u64 v255, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x04,0xd9,0xff,0x02,0x00,0x00]

ds_sub_u64 v1, v[254:255] offset:65535
// CHECK: [0xff,0xff,0x04,0xd9,0x01,0xfe,0x00,0x00]

ds_sub_u64 v1, v[2:3]
// CHECK: [0x00,0x00,0x04,0xd9,0x01,0x02,0x00,0x00]

ds_sub_u64 v1, v[2:3] offset:0
// CHECK: [0x00,0x00,0x04,0xd9,0x01,0x02,0x00,0x00]

ds_sub_u64 v1, v[2:3] offset:4
// CHECK: [0x04,0x00,0x04,0xd9,0x01,0x02,0x00,0x00]

ds_sub_u64 v1, v[2:3] offset:65535 gds
// CHECK: [0xff,0xff,0x06,0xd9,0x01,0x02,0x00,0x00]

ds_rsub_u64 v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x08,0xd9,0x01,0x02,0x00,0x00]

ds_rsub_u64 v255, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x08,0xd9,0xff,0x02,0x00,0x00]

ds_rsub_u64 v1, v[254:255] offset:65535
// CHECK: [0xff,0xff,0x08,0xd9,0x01,0xfe,0x00,0x00]

ds_rsub_u64 v1, v[2:3]
// CHECK: [0x00,0x00,0x08,0xd9,0x01,0x02,0x00,0x00]

ds_rsub_u64 v1, v[2:3] offset:0
// CHECK: [0x00,0x00,0x08,0xd9,0x01,0x02,0x00,0x00]

ds_rsub_u64 v1, v[2:3] offset:4
// CHECK: [0x04,0x00,0x08,0xd9,0x01,0x02,0x00,0x00]

ds_rsub_u64 v1, v[2:3] offset:65535 gds
// CHECK: [0xff,0xff,0x0a,0xd9,0x01,0x02,0x00,0x00]

ds_inc_u64 v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x0c,0xd9,0x01,0x02,0x00,0x00]

ds_inc_u64 v255, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x0c,0xd9,0xff,0x02,0x00,0x00]

ds_inc_u64 v1, v[254:255] offset:65535
// CHECK: [0xff,0xff,0x0c,0xd9,0x01,0xfe,0x00,0x00]

ds_inc_u64 v1, v[2:3]
// CHECK: [0x00,0x00,0x0c,0xd9,0x01,0x02,0x00,0x00]

ds_inc_u64 v1, v[2:3] offset:0
// CHECK: [0x00,0x00,0x0c,0xd9,0x01,0x02,0x00,0x00]

ds_inc_u64 v1, v[2:3] offset:4
// CHECK: [0x04,0x00,0x0c,0xd9,0x01,0x02,0x00,0x00]

ds_inc_u64 v1, v[2:3] offset:65535 gds
// CHECK: [0xff,0xff,0x0e,0xd9,0x01,0x02,0x00,0x00]

ds_dec_u64 v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x10,0xd9,0x01,0x02,0x00,0x00]

ds_dec_u64 v255, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x10,0xd9,0xff,0x02,0x00,0x00]

ds_dec_u64 v1, v[254:255] offset:65535
// CHECK: [0xff,0xff,0x10,0xd9,0x01,0xfe,0x00,0x00]

ds_dec_u64 v1, v[2:3]
// CHECK: [0x00,0x00,0x10,0xd9,0x01,0x02,0x00,0x00]

ds_dec_u64 v1, v[2:3] offset:0
// CHECK: [0x00,0x00,0x10,0xd9,0x01,0x02,0x00,0x00]

ds_dec_u64 v1, v[2:3] offset:4
// CHECK: [0x04,0x00,0x10,0xd9,0x01,0x02,0x00,0x00]

ds_dec_u64 v1, v[2:3] offset:65535 gds
// CHECK: [0xff,0xff,0x12,0xd9,0x01,0x02,0x00,0x00]

ds_min_i64 v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x14,0xd9,0x01,0x02,0x00,0x00]

ds_min_i64 v255, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x14,0xd9,0xff,0x02,0x00,0x00]

ds_min_i64 v1, v[254:255] offset:65535
// CHECK: [0xff,0xff,0x14,0xd9,0x01,0xfe,0x00,0x00]

ds_min_i64 v1, v[2:3]
// CHECK: [0x00,0x00,0x14,0xd9,0x01,0x02,0x00,0x00]

ds_min_i64 v1, v[2:3] offset:0
// CHECK: [0x00,0x00,0x14,0xd9,0x01,0x02,0x00,0x00]

ds_min_i64 v1, v[2:3] offset:4
// CHECK: [0x04,0x00,0x14,0xd9,0x01,0x02,0x00,0x00]

ds_min_i64 v1, v[2:3] offset:65535 gds
// CHECK: [0xff,0xff,0x16,0xd9,0x01,0x02,0x00,0x00]

ds_max_i64 v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x18,0xd9,0x01,0x02,0x00,0x00]

ds_max_i64 v255, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x18,0xd9,0xff,0x02,0x00,0x00]

ds_max_i64 v1, v[254:255] offset:65535
// CHECK: [0xff,0xff,0x18,0xd9,0x01,0xfe,0x00,0x00]

ds_max_i64 v1, v[2:3]
// CHECK: [0x00,0x00,0x18,0xd9,0x01,0x02,0x00,0x00]

ds_max_i64 v1, v[2:3] offset:0
// CHECK: [0x00,0x00,0x18,0xd9,0x01,0x02,0x00,0x00]

ds_max_i64 v1, v[2:3] offset:4
// CHECK: [0x04,0x00,0x18,0xd9,0x01,0x02,0x00,0x00]

ds_max_i64 v1, v[2:3] offset:65535 gds
// CHECK: [0xff,0xff,0x1a,0xd9,0x01,0x02,0x00,0x00]

ds_min_u64 v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x1c,0xd9,0x01,0x02,0x00,0x00]

ds_min_u64 v255, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x1c,0xd9,0xff,0x02,0x00,0x00]

ds_min_u64 v1, v[254:255] offset:65535
// CHECK: [0xff,0xff,0x1c,0xd9,0x01,0xfe,0x00,0x00]

ds_min_u64 v1, v[2:3]
// CHECK: [0x00,0x00,0x1c,0xd9,0x01,0x02,0x00,0x00]

ds_min_u64 v1, v[2:3] offset:0
// CHECK: [0x00,0x00,0x1c,0xd9,0x01,0x02,0x00,0x00]

ds_min_u64 v1, v[2:3] offset:4
// CHECK: [0x04,0x00,0x1c,0xd9,0x01,0x02,0x00,0x00]

ds_min_u64 v1, v[2:3] offset:65535 gds
// CHECK: [0xff,0xff,0x1e,0xd9,0x01,0x02,0x00,0x00]

ds_max_u64 v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x20,0xd9,0x01,0x02,0x00,0x00]

ds_max_u64 v255, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x20,0xd9,0xff,0x02,0x00,0x00]

ds_max_u64 v1, v[254:255] offset:65535
// CHECK: [0xff,0xff,0x20,0xd9,0x01,0xfe,0x00,0x00]

ds_max_u64 v1, v[2:3]
// CHECK: [0x00,0x00,0x20,0xd9,0x01,0x02,0x00,0x00]

ds_max_u64 v1, v[2:3] offset:0
// CHECK: [0x00,0x00,0x20,0xd9,0x01,0x02,0x00,0x00]

ds_max_u64 v1, v[2:3] offset:4
// CHECK: [0x04,0x00,0x20,0xd9,0x01,0x02,0x00,0x00]

ds_max_u64 v1, v[2:3] offset:65535 gds
// CHECK: [0xff,0xff,0x22,0xd9,0x01,0x02,0x00,0x00]

ds_and_b64 v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x24,0xd9,0x01,0x02,0x00,0x00]

ds_and_b64 v255, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x24,0xd9,0xff,0x02,0x00,0x00]

ds_and_b64 v1, v[254:255] offset:65535
// CHECK: [0xff,0xff,0x24,0xd9,0x01,0xfe,0x00,0x00]

ds_and_b64 v1, v[2:3]
// CHECK: [0x00,0x00,0x24,0xd9,0x01,0x02,0x00,0x00]

ds_and_b64 v1, v[2:3] offset:0
// CHECK: [0x00,0x00,0x24,0xd9,0x01,0x02,0x00,0x00]

ds_and_b64 v1, v[2:3] offset:4
// CHECK: [0x04,0x00,0x24,0xd9,0x01,0x02,0x00,0x00]

ds_and_b64 v1, v[2:3] offset:65535 gds
// CHECK: [0xff,0xff,0x26,0xd9,0x01,0x02,0x00,0x00]

ds_or_b64 v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x28,0xd9,0x01,0x02,0x00,0x00]

ds_or_b64 v255, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x28,0xd9,0xff,0x02,0x00,0x00]

ds_or_b64 v1, v[254:255] offset:65535
// CHECK: [0xff,0xff,0x28,0xd9,0x01,0xfe,0x00,0x00]

ds_or_b64 v1, v[2:3]
// CHECK: [0x00,0x00,0x28,0xd9,0x01,0x02,0x00,0x00]

ds_or_b64 v1, v[2:3] offset:0
// CHECK: [0x00,0x00,0x28,0xd9,0x01,0x02,0x00,0x00]

ds_or_b64 v1, v[2:3] offset:4
// CHECK: [0x04,0x00,0x28,0xd9,0x01,0x02,0x00,0x00]

ds_or_b64 v1, v[2:3] offset:65535 gds
// CHECK: [0xff,0xff,0x2a,0xd9,0x01,0x02,0x00,0x00]

ds_xor_b64 v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x2c,0xd9,0x01,0x02,0x00,0x00]

ds_xor_b64 v255, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x2c,0xd9,0xff,0x02,0x00,0x00]

ds_xor_b64 v1, v[254:255] offset:65535
// CHECK: [0xff,0xff,0x2c,0xd9,0x01,0xfe,0x00,0x00]

ds_xor_b64 v1, v[2:3]
// CHECK: [0x00,0x00,0x2c,0xd9,0x01,0x02,0x00,0x00]

ds_xor_b64 v1, v[2:3] offset:0
// CHECK: [0x00,0x00,0x2c,0xd9,0x01,0x02,0x00,0x00]

ds_xor_b64 v1, v[2:3] offset:4
// CHECK: [0x04,0x00,0x2c,0xd9,0x01,0x02,0x00,0x00]

ds_xor_b64 v1, v[2:3] offset:65535 gds
// CHECK: [0xff,0xff,0x2e,0xd9,0x01,0x02,0x00,0x00]

ds_mskor_b64 v1, v[2:3], v[3:4] offset:65535
// CHECK: [0xff,0xff,0x30,0xd9,0x01,0x02,0x03,0x00]

ds_mskor_b64 v255, v[2:3], v[3:4] offset:65535
// CHECK: [0xff,0xff,0x30,0xd9,0xff,0x02,0x03,0x00]

ds_mskor_b64 v1, v[254:255], v[3:4] offset:65535
// CHECK: [0xff,0xff,0x30,0xd9,0x01,0xfe,0x03,0x00]

ds_mskor_b64 v1, v[2:3], v[254:255] offset:65535
// CHECK: [0xff,0xff,0x30,0xd9,0x01,0x02,0xfe,0x00]

ds_mskor_b64 v1, v[2:3], v[3:4]
// CHECK: [0x00,0x00,0x30,0xd9,0x01,0x02,0x03,0x00]

ds_mskor_b64 v1, v[2:3], v[3:4] offset:0
// CHECK: [0x00,0x00,0x30,0xd9,0x01,0x02,0x03,0x00]

ds_mskor_b64 v1, v[2:3], v[3:4] offset:4
// CHECK: [0x04,0x00,0x30,0xd9,0x01,0x02,0x03,0x00]

ds_mskor_b64 v1, v[2:3], v[3:4] offset:65535 gds
// CHECK: [0xff,0xff,0x32,0xd9,0x01,0x02,0x03,0x00]

ds_write_b64 v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x34,0xd9,0x01,0x02,0x00,0x00]

ds_write_b64 v255, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x34,0xd9,0xff,0x02,0x00,0x00]

ds_write_b64 v1, v[254:255] offset:65535
// CHECK: [0xff,0xff,0x34,0xd9,0x01,0xfe,0x00,0x00]

ds_write_b64 v1, v[2:3]
// CHECK: [0x00,0x00,0x34,0xd9,0x01,0x02,0x00,0x00]

ds_write_b64 v1, v[2:3] offset:0
// CHECK: [0x00,0x00,0x34,0xd9,0x01,0x02,0x00,0x00]

ds_write_b64 v1, v[2:3] offset:4
// CHECK: [0x04,0x00,0x34,0xd9,0x01,0x02,0x00,0x00]

ds_write_b64 v1, v[2:3] offset:65535 gds
// CHECK: [0xff,0xff,0x36,0xd9,0x01,0x02,0x00,0x00]

ds_write2_b64 v1, v[2:3], v[3:4] offset0:127 offset1:255
// CHECK: [0x7f,0xff,0x38,0xd9,0x01,0x02,0x03,0x00]

ds_write2_b64 v255, v[2:3], v[3:4] offset0:127 offset1:255
// CHECK: [0x7f,0xff,0x38,0xd9,0xff,0x02,0x03,0x00]

ds_write2_b64 v1, v[254:255], v[3:4] offset0:127 offset1:255
// CHECK: [0x7f,0xff,0x38,0xd9,0x01,0xfe,0x03,0x00]

ds_write2_b64 v1, v[2:3], v[254:255] offset0:127 offset1:255
// CHECK: [0x7f,0xff,0x38,0xd9,0x01,0x02,0xfe,0x00]

ds_write2_b64 v1, v[2:3], v[3:4] offset1:255
// CHECK: [0x00,0xff,0x38,0xd9,0x01,0x02,0x03,0x00]

ds_write2_b64 v1, v[2:3], v[3:4] offset0:0 offset1:255
// CHECK: [0x00,0xff,0x38,0xd9,0x01,0x02,0x03,0x00]

ds_write2_b64 v1, v[2:3], v[3:4] offset0:16 offset1:255
// CHECK: [0x10,0xff,0x38,0xd9,0x01,0x02,0x03,0x00]

ds_write2_b64 v1, v[2:3], v[3:4] offset0:127
// CHECK: [0x7f,0x00,0x38,0xd9,0x01,0x02,0x03,0x00]

ds_write2_b64 v1, v[2:3], v[3:4] offset0:127 offset1:0
// CHECK: [0x7f,0x00,0x38,0xd9,0x01,0x02,0x03,0x00]

ds_write2_b64 v1, v[2:3], v[3:4] offset0:127 offset1:1
// CHECK: [0x7f,0x01,0x38,0xd9,0x01,0x02,0x03,0x00]

ds_write2_b64 v1, v[2:3], v[3:4] offset0:127 offset1:255 gds
// CHECK: [0x7f,0xff,0x3a,0xd9,0x01,0x02,0x03,0x00]

ds_write2st64_b64 v1, v[2:3], v[3:4] offset0:127 offset1:255
// CHECK: [0x7f,0xff,0x3c,0xd9,0x01,0x02,0x03,0x00]

ds_write2st64_b64 v255, v[2:3], v[3:4] offset0:127 offset1:255
// CHECK: [0x7f,0xff,0x3c,0xd9,0xff,0x02,0x03,0x00]

ds_write2st64_b64 v1, v[254:255], v[3:4] offset0:127 offset1:255
// CHECK: [0x7f,0xff,0x3c,0xd9,0x01,0xfe,0x03,0x00]

ds_write2st64_b64 v1, v[2:3], v[254:255] offset0:127 offset1:255
// CHECK: [0x7f,0xff,0x3c,0xd9,0x01,0x02,0xfe,0x00]

ds_write2st64_b64 v1, v[2:3], v[3:4] offset1:255
// CHECK: [0x00,0xff,0x3c,0xd9,0x01,0x02,0x03,0x00]

ds_write2st64_b64 v1, v[2:3], v[3:4] offset0:0 offset1:255
// CHECK: [0x00,0xff,0x3c,0xd9,0x01,0x02,0x03,0x00]

ds_write2st64_b64 v1, v[2:3], v[3:4] offset0:16 offset1:255
// CHECK: [0x10,0xff,0x3c,0xd9,0x01,0x02,0x03,0x00]

ds_write2st64_b64 v1, v[2:3], v[3:4] offset0:127
// CHECK: [0x7f,0x00,0x3c,0xd9,0x01,0x02,0x03,0x00]

ds_write2st64_b64 v1, v[2:3], v[3:4] offset0:127 offset1:0
// CHECK: [0x7f,0x00,0x3c,0xd9,0x01,0x02,0x03,0x00]

ds_write2st64_b64 v1, v[2:3], v[3:4] offset0:127 offset1:1
// CHECK: [0x7f,0x01,0x3c,0xd9,0x01,0x02,0x03,0x00]

ds_write2st64_b64 v1, v[2:3], v[3:4] offset0:127 offset1:255 gds
// CHECK: [0x7f,0xff,0x3e,0xd9,0x01,0x02,0x03,0x00]

ds_cmpst_b64 v1, v[2:3], v[3:4] offset:65535
// CHECK: [0xff,0xff,0x40,0xd9,0x01,0x02,0x03,0x00]

ds_cmpst_b64 v255, v[2:3], v[3:4] offset:65535
// CHECK: [0xff,0xff,0x40,0xd9,0xff,0x02,0x03,0x00]

ds_cmpst_b64 v1, v[254:255], v[3:4] offset:65535
// CHECK: [0xff,0xff,0x40,0xd9,0x01,0xfe,0x03,0x00]

ds_cmpst_b64 v1, v[2:3], v[254:255] offset:65535
// CHECK: [0xff,0xff,0x40,0xd9,0x01,0x02,0xfe,0x00]

ds_cmpst_b64 v1, v[2:3], v[3:4]
// CHECK: [0x00,0x00,0x40,0xd9,0x01,0x02,0x03,0x00]

ds_cmpst_b64 v1, v[2:3], v[3:4] offset:0
// CHECK: [0x00,0x00,0x40,0xd9,0x01,0x02,0x03,0x00]

ds_cmpst_b64 v1, v[2:3], v[3:4] offset:4
// CHECK: [0x04,0x00,0x40,0xd9,0x01,0x02,0x03,0x00]

ds_cmpst_b64 v1, v[2:3], v[3:4] offset:65535 gds
// CHECK: [0xff,0xff,0x42,0xd9,0x01,0x02,0x03,0x00]

ds_cmpst_f64 v1, v[2:3], v[3:4] offset:65535
// CHECK: [0xff,0xff,0x44,0xd9,0x01,0x02,0x03,0x00]

ds_cmpst_f64 v255, v[2:3], v[3:4] offset:65535
// CHECK: [0xff,0xff,0x44,0xd9,0xff,0x02,0x03,0x00]

ds_cmpst_f64 v1, v[254:255], v[3:4] offset:65535
// CHECK: [0xff,0xff,0x44,0xd9,0x01,0xfe,0x03,0x00]

ds_cmpst_f64 v1, v[2:3], v[254:255] offset:65535
// CHECK: [0xff,0xff,0x44,0xd9,0x01,0x02,0xfe,0x00]

ds_cmpst_f64 v1, v[2:3], v[3:4]
// CHECK: [0x00,0x00,0x44,0xd9,0x01,0x02,0x03,0x00]

ds_cmpst_f64 v1, v[2:3], v[3:4] offset:0
// CHECK: [0x00,0x00,0x44,0xd9,0x01,0x02,0x03,0x00]

ds_cmpst_f64 v1, v[2:3], v[3:4] offset:4
// CHECK: [0x04,0x00,0x44,0xd9,0x01,0x02,0x03,0x00]

ds_cmpst_f64 v1, v[2:3], v[3:4] offset:65535 gds
// CHECK: [0xff,0xff,0x46,0xd9,0x01,0x02,0x03,0x00]

ds_min_f64 v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x48,0xd9,0x01,0x02,0x00,0x00]

ds_min_f64 v255, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x48,0xd9,0xff,0x02,0x00,0x00]

ds_min_f64 v1, v[254:255] offset:65535
// CHECK: [0xff,0xff,0x48,0xd9,0x01,0xfe,0x00,0x00]

ds_min_f64 v1, v[2:3]
// CHECK: [0x00,0x00,0x48,0xd9,0x01,0x02,0x00,0x00]

ds_min_f64 v1, v[2:3] offset:0
// CHECK: [0x00,0x00,0x48,0xd9,0x01,0x02,0x00,0x00]

ds_min_f64 v1, v[2:3] offset:4
// CHECK: [0x04,0x00,0x48,0xd9,0x01,0x02,0x00,0x00]

ds_min_f64 v1, v[2:3] offset:65535 gds
// CHECK: [0xff,0xff,0x4a,0xd9,0x01,0x02,0x00,0x00]

ds_max_f64 v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x4c,0xd9,0x01,0x02,0x00,0x00]

ds_max_f64 v255, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x4c,0xd9,0xff,0x02,0x00,0x00]

ds_max_f64 v1, v[254:255] offset:65535
// CHECK: [0xff,0xff,0x4c,0xd9,0x01,0xfe,0x00,0x00]

ds_max_f64 v1, v[2:3]
// CHECK: [0x00,0x00,0x4c,0xd9,0x01,0x02,0x00,0x00]

ds_max_f64 v1, v[2:3] offset:0
// CHECK: [0x00,0x00,0x4c,0xd9,0x01,0x02,0x00,0x00]

ds_max_f64 v1, v[2:3] offset:4
// CHECK: [0x04,0x00,0x4c,0xd9,0x01,0x02,0x00,0x00]

ds_max_f64 v1, v[2:3] offset:65535 gds
// CHECK: [0xff,0xff,0x4e,0xd9,0x01,0x02,0x00,0x00]

ds_add_rtn_u64 v[5:6], v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x80,0xd9,0x01,0x02,0x00,0x05]

ds_add_rtn_u64 v[254:255], v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x80,0xd9,0x01,0x02,0x00,0xfe]

ds_add_rtn_u64 v[5:6], v255, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x80,0xd9,0xff,0x02,0x00,0x05]

ds_add_rtn_u64 v[5:6], v1, v[254:255] offset:65535
// CHECK: [0xff,0xff,0x80,0xd9,0x01,0xfe,0x00,0x05]

ds_add_rtn_u64 v[5:6], v1, v[2:3]
// CHECK: [0x00,0x00,0x80,0xd9,0x01,0x02,0x00,0x05]

ds_add_rtn_u64 v[5:6], v1, v[2:3] offset:0
// CHECK: [0x00,0x00,0x80,0xd9,0x01,0x02,0x00,0x05]

ds_add_rtn_u64 v[5:6], v1, v[2:3] offset:4
// CHECK: [0x04,0x00,0x80,0xd9,0x01,0x02,0x00,0x05]

ds_add_rtn_u64 v[5:6], v1, v[2:3] offset:65535 gds
// CHECK: [0xff,0xff,0x82,0xd9,0x01,0x02,0x00,0x05]

ds_sub_rtn_u64 v[5:6], v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x84,0xd9,0x01,0x02,0x00,0x05]

ds_sub_rtn_u64 v[254:255], v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x84,0xd9,0x01,0x02,0x00,0xfe]

ds_sub_rtn_u64 v[5:6], v255, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x84,0xd9,0xff,0x02,0x00,0x05]

ds_sub_rtn_u64 v[5:6], v1, v[254:255] offset:65535
// CHECK: [0xff,0xff,0x84,0xd9,0x01,0xfe,0x00,0x05]

ds_sub_rtn_u64 v[5:6], v1, v[2:3]
// CHECK: [0x00,0x00,0x84,0xd9,0x01,0x02,0x00,0x05]

ds_sub_rtn_u64 v[5:6], v1, v[2:3] offset:0
// CHECK: [0x00,0x00,0x84,0xd9,0x01,0x02,0x00,0x05]

ds_sub_rtn_u64 v[5:6], v1, v[2:3] offset:4
// CHECK: [0x04,0x00,0x84,0xd9,0x01,0x02,0x00,0x05]

ds_sub_rtn_u64 v[5:6], v1, v[2:3] offset:65535 gds
// CHECK: [0xff,0xff,0x86,0xd9,0x01,0x02,0x00,0x05]

ds_rsub_rtn_u64 v[5:6], v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x88,0xd9,0x01,0x02,0x00,0x05]

ds_rsub_rtn_u64 v[254:255], v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x88,0xd9,0x01,0x02,0x00,0xfe]

ds_rsub_rtn_u64 v[5:6], v255, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x88,0xd9,0xff,0x02,0x00,0x05]

ds_rsub_rtn_u64 v[5:6], v1, v[254:255] offset:65535
// CHECK: [0xff,0xff,0x88,0xd9,0x01,0xfe,0x00,0x05]

ds_rsub_rtn_u64 v[5:6], v1, v[2:3]
// CHECK: [0x00,0x00,0x88,0xd9,0x01,0x02,0x00,0x05]

ds_rsub_rtn_u64 v[5:6], v1, v[2:3] offset:0
// CHECK: [0x00,0x00,0x88,0xd9,0x01,0x02,0x00,0x05]

ds_rsub_rtn_u64 v[5:6], v1, v[2:3] offset:4
// CHECK: [0x04,0x00,0x88,0xd9,0x01,0x02,0x00,0x05]

ds_rsub_rtn_u64 v[5:6], v1, v[2:3] offset:65535 gds
// CHECK: [0xff,0xff,0x8a,0xd9,0x01,0x02,0x00,0x05]

ds_inc_rtn_u64 v[5:6], v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x8c,0xd9,0x01,0x02,0x00,0x05]

ds_inc_rtn_u64 v[254:255], v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x8c,0xd9,0x01,0x02,0x00,0xfe]

ds_inc_rtn_u64 v[5:6], v255, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x8c,0xd9,0xff,0x02,0x00,0x05]

ds_inc_rtn_u64 v[5:6], v1, v[254:255] offset:65535
// CHECK: [0xff,0xff,0x8c,0xd9,0x01,0xfe,0x00,0x05]

ds_inc_rtn_u64 v[5:6], v1, v[2:3]
// CHECK: [0x00,0x00,0x8c,0xd9,0x01,0x02,0x00,0x05]

ds_inc_rtn_u64 v[5:6], v1, v[2:3] offset:0
// CHECK: [0x00,0x00,0x8c,0xd9,0x01,0x02,0x00,0x05]

ds_inc_rtn_u64 v[5:6], v1, v[2:3] offset:4
// CHECK: [0x04,0x00,0x8c,0xd9,0x01,0x02,0x00,0x05]

ds_inc_rtn_u64 v[5:6], v1, v[2:3] offset:65535 gds
// CHECK: [0xff,0xff,0x8e,0xd9,0x01,0x02,0x00,0x05]

ds_dec_rtn_u64 v[5:6], v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x90,0xd9,0x01,0x02,0x00,0x05]

ds_dec_rtn_u64 v[254:255], v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x90,0xd9,0x01,0x02,0x00,0xfe]

ds_dec_rtn_u64 v[5:6], v255, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x90,0xd9,0xff,0x02,0x00,0x05]

ds_dec_rtn_u64 v[5:6], v1, v[254:255] offset:65535
// CHECK: [0xff,0xff,0x90,0xd9,0x01,0xfe,0x00,0x05]

ds_dec_rtn_u64 v[5:6], v1, v[2:3]
// CHECK: [0x00,0x00,0x90,0xd9,0x01,0x02,0x00,0x05]

ds_dec_rtn_u64 v[5:6], v1, v[2:3] offset:0
// CHECK: [0x00,0x00,0x90,0xd9,0x01,0x02,0x00,0x05]

ds_dec_rtn_u64 v[5:6], v1, v[2:3] offset:4
// CHECK: [0x04,0x00,0x90,0xd9,0x01,0x02,0x00,0x05]

ds_dec_rtn_u64 v[5:6], v1, v[2:3] offset:65535 gds
// CHECK: [0xff,0xff,0x92,0xd9,0x01,0x02,0x00,0x05]

ds_min_rtn_i64 v[5:6], v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x94,0xd9,0x01,0x02,0x00,0x05]

ds_min_rtn_i64 v[254:255], v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x94,0xd9,0x01,0x02,0x00,0xfe]

ds_min_rtn_i64 v[5:6], v255, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x94,0xd9,0xff,0x02,0x00,0x05]

ds_min_rtn_i64 v[5:6], v1, v[254:255] offset:65535
// CHECK: [0xff,0xff,0x94,0xd9,0x01,0xfe,0x00,0x05]

ds_min_rtn_i64 v[5:6], v1, v[2:3]
// CHECK: [0x00,0x00,0x94,0xd9,0x01,0x02,0x00,0x05]

ds_min_rtn_i64 v[5:6], v1, v[2:3] offset:0
// CHECK: [0x00,0x00,0x94,0xd9,0x01,0x02,0x00,0x05]

ds_min_rtn_i64 v[5:6], v1, v[2:3] offset:4
// CHECK: [0x04,0x00,0x94,0xd9,0x01,0x02,0x00,0x05]

ds_min_rtn_i64 v[5:6], v1, v[2:3] offset:65535 gds
// CHECK: [0xff,0xff,0x96,0xd9,0x01,0x02,0x00,0x05]

ds_max_rtn_i64 v[5:6], v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x98,0xd9,0x01,0x02,0x00,0x05]

ds_max_rtn_i64 v[254:255], v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x98,0xd9,0x01,0x02,0x00,0xfe]

ds_max_rtn_i64 v[5:6], v255, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x98,0xd9,0xff,0x02,0x00,0x05]

ds_max_rtn_i64 v[5:6], v1, v[254:255] offset:65535
// CHECK: [0xff,0xff,0x98,0xd9,0x01,0xfe,0x00,0x05]

ds_max_rtn_i64 v[5:6], v1, v[2:3]
// CHECK: [0x00,0x00,0x98,0xd9,0x01,0x02,0x00,0x05]

ds_max_rtn_i64 v[5:6], v1, v[2:3] offset:0
// CHECK: [0x00,0x00,0x98,0xd9,0x01,0x02,0x00,0x05]

ds_max_rtn_i64 v[5:6], v1, v[2:3] offset:4
// CHECK: [0x04,0x00,0x98,0xd9,0x01,0x02,0x00,0x05]

ds_max_rtn_i64 v[5:6], v1, v[2:3] offset:65535 gds
// CHECK: [0xff,0xff,0x9a,0xd9,0x01,0x02,0x00,0x05]

ds_min_rtn_u64 v[5:6], v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x9c,0xd9,0x01,0x02,0x00,0x05]

ds_min_rtn_u64 v[254:255], v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x9c,0xd9,0x01,0x02,0x00,0xfe]

ds_min_rtn_u64 v[5:6], v255, v[2:3] offset:65535
// CHECK: [0xff,0xff,0x9c,0xd9,0xff,0x02,0x00,0x05]

ds_min_rtn_u64 v[5:6], v1, v[254:255] offset:65535
// CHECK: [0xff,0xff,0x9c,0xd9,0x01,0xfe,0x00,0x05]

ds_min_rtn_u64 v[5:6], v1, v[2:3]
// CHECK: [0x00,0x00,0x9c,0xd9,0x01,0x02,0x00,0x05]

ds_min_rtn_u64 v[5:6], v1, v[2:3] offset:0
// CHECK: [0x00,0x00,0x9c,0xd9,0x01,0x02,0x00,0x05]

ds_min_rtn_u64 v[5:6], v1, v[2:3] offset:4
// CHECK: [0x04,0x00,0x9c,0xd9,0x01,0x02,0x00,0x05]

ds_min_rtn_u64 v[5:6], v1, v[2:3] offset:65535 gds
// CHECK: [0xff,0xff,0x9e,0xd9,0x01,0x02,0x00,0x05]

ds_max_rtn_u64 v[5:6], v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0xa0,0xd9,0x01,0x02,0x00,0x05]

ds_max_rtn_u64 v[254:255], v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0xa0,0xd9,0x01,0x02,0x00,0xfe]

ds_max_rtn_u64 v[5:6], v255, v[2:3] offset:65535
// CHECK: [0xff,0xff,0xa0,0xd9,0xff,0x02,0x00,0x05]

ds_max_rtn_u64 v[5:6], v1, v[254:255] offset:65535
// CHECK: [0xff,0xff,0xa0,0xd9,0x01,0xfe,0x00,0x05]

ds_max_rtn_u64 v[5:6], v1, v[2:3]
// CHECK: [0x00,0x00,0xa0,0xd9,0x01,0x02,0x00,0x05]

ds_max_rtn_u64 v[5:6], v1, v[2:3] offset:0
// CHECK: [0x00,0x00,0xa0,0xd9,0x01,0x02,0x00,0x05]

ds_max_rtn_u64 v[5:6], v1, v[2:3] offset:4
// CHECK: [0x04,0x00,0xa0,0xd9,0x01,0x02,0x00,0x05]

ds_max_rtn_u64 v[5:6], v1, v[2:3] offset:65535 gds
// CHECK: [0xff,0xff,0xa2,0xd9,0x01,0x02,0x00,0x05]

ds_and_rtn_b64 v[5:6], v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0xa4,0xd9,0x01,0x02,0x00,0x05]

ds_and_rtn_b64 v[254:255], v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0xa4,0xd9,0x01,0x02,0x00,0xfe]

ds_and_rtn_b64 v[5:6], v255, v[2:3] offset:65535
// CHECK: [0xff,0xff,0xa4,0xd9,0xff,0x02,0x00,0x05]

ds_and_rtn_b64 v[5:6], v1, v[254:255] offset:65535
// CHECK: [0xff,0xff,0xa4,0xd9,0x01,0xfe,0x00,0x05]

ds_and_rtn_b64 v[5:6], v1, v[2:3]
// CHECK: [0x00,0x00,0xa4,0xd9,0x01,0x02,0x00,0x05]

ds_and_rtn_b64 v[5:6], v1, v[2:3] offset:0
// CHECK: [0x00,0x00,0xa4,0xd9,0x01,0x02,0x00,0x05]

ds_and_rtn_b64 v[5:6], v1, v[2:3] offset:4
// CHECK: [0x04,0x00,0xa4,0xd9,0x01,0x02,0x00,0x05]

ds_and_rtn_b64 v[5:6], v1, v[2:3] offset:65535 gds
// CHECK: [0xff,0xff,0xa6,0xd9,0x01,0x02,0x00,0x05]

ds_or_rtn_b64 v[5:6], v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0xa8,0xd9,0x01,0x02,0x00,0x05]

ds_or_rtn_b64 v[254:255], v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0xa8,0xd9,0x01,0x02,0x00,0xfe]

ds_or_rtn_b64 v[5:6], v255, v[2:3] offset:65535
// CHECK: [0xff,0xff,0xa8,0xd9,0xff,0x02,0x00,0x05]

ds_or_rtn_b64 v[5:6], v1, v[254:255] offset:65535
// CHECK: [0xff,0xff,0xa8,0xd9,0x01,0xfe,0x00,0x05]

ds_or_rtn_b64 v[5:6], v1, v[2:3]
// CHECK: [0x00,0x00,0xa8,0xd9,0x01,0x02,0x00,0x05]

ds_or_rtn_b64 v[5:6], v1, v[2:3] offset:0
// CHECK: [0x00,0x00,0xa8,0xd9,0x01,0x02,0x00,0x05]

ds_or_rtn_b64 v[5:6], v1, v[2:3] offset:4
// CHECK: [0x04,0x00,0xa8,0xd9,0x01,0x02,0x00,0x05]

ds_or_rtn_b64 v[5:6], v1, v[2:3] offset:65535 gds
// CHECK: [0xff,0xff,0xaa,0xd9,0x01,0x02,0x00,0x05]

ds_xor_rtn_b64 v[5:6], v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0xac,0xd9,0x01,0x02,0x00,0x05]

ds_xor_rtn_b64 v[254:255], v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0xac,0xd9,0x01,0x02,0x00,0xfe]

ds_xor_rtn_b64 v[5:6], v255, v[2:3] offset:65535
// CHECK: [0xff,0xff,0xac,0xd9,0xff,0x02,0x00,0x05]

ds_xor_rtn_b64 v[5:6], v1, v[254:255] offset:65535
// CHECK: [0xff,0xff,0xac,0xd9,0x01,0xfe,0x00,0x05]

ds_xor_rtn_b64 v[5:6], v1, v[2:3]
// CHECK: [0x00,0x00,0xac,0xd9,0x01,0x02,0x00,0x05]

ds_xor_rtn_b64 v[5:6], v1, v[2:3] offset:0
// CHECK: [0x00,0x00,0xac,0xd9,0x01,0x02,0x00,0x05]

ds_xor_rtn_b64 v[5:6], v1, v[2:3] offset:4
// CHECK: [0x04,0x00,0xac,0xd9,0x01,0x02,0x00,0x05]

ds_xor_rtn_b64 v[5:6], v1, v[2:3] offset:65535 gds
// CHECK: [0xff,0xff,0xae,0xd9,0x01,0x02,0x00,0x05]

ds_mskor_rtn_b64 v[5:6], v1, v[2:3], v[3:4] offset:65535
// CHECK: [0xff,0xff,0xb0,0xd9,0x01,0x02,0x03,0x05]

ds_mskor_rtn_b64 v[254:255], v1, v[2:3], v[3:4] offset:65535
// CHECK: [0xff,0xff,0xb0,0xd9,0x01,0x02,0x03,0xfe]

ds_mskor_rtn_b64 v[5:6], v255, v[2:3], v[3:4] offset:65535
// CHECK: [0xff,0xff,0xb0,0xd9,0xff,0x02,0x03,0x05]

ds_mskor_rtn_b64 v[5:6], v1, v[254:255], v[3:4] offset:65535
// CHECK: [0xff,0xff,0xb0,0xd9,0x01,0xfe,0x03,0x05]

ds_mskor_rtn_b64 v[5:6], v1, v[2:3], v[254:255] offset:65535
// CHECK: [0xff,0xff,0xb0,0xd9,0x01,0x02,0xfe,0x05]

ds_mskor_rtn_b64 v[5:6], v1, v[2:3], v[3:4]
// CHECK: [0x00,0x00,0xb0,0xd9,0x01,0x02,0x03,0x05]

ds_mskor_rtn_b64 v[5:6], v1, v[2:3], v[3:4] offset:0
// CHECK: [0x00,0x00,0xb0,0xd9,0x01,0x02,0x03,0x05]

ds_mskor_rtn_b64 v[5:6], v1, v[2:3], v[3:4] offset:4
// CHECK: [0x04,0x00,0xb0,0xd9,0x01,0x02,0x03,0x05]

ds_mskor_rtn_b64 v[5:6], v1, v[2:3], v[3:4] offset:65535 gds
// CHECK: [0xff,0xff,0xb2,0xd9,0x01,0x02,0x03,0x05]

ds_wrxchg_rtn_b64 v[5:6], v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0xb4,0xd9,0x01,0x02,0x00,0x05]

ds_wrxchg_rtn_b64 v[254:255], v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0xb4,0xd9,0x01,0x02,0x00,0xfe]

ds_wrxchg_rtn_b64 v[5:6], v255, v[2:3] offset:65535
// CHECK: [0xff,0xff,0xb4,0xd9,0xff,0x02,0x00,0x05]

ds_wrxchg_rtn_b64 v[5:6], v1, v[254:255] offset:65535
// CHECK: [0xff,0xff,0xb4,0xd9,0x01,0xfe,0x00,0x05]

ds_wrxchg_rtn_b64 v[5:6], v1, v[2:3]
// CHECK: [0x00,0x00,0xb4,0xd9,0x01,0x02,0x00,0x05]

ds_wrxchg_rtn_b64 v[5:6], v1, v[2:3] offset:0
// CHECK: [0x00,0x00,0xb4,0xd9,0x01,0x02,0x00,0x05]

ds_wrxchg_rtn_b64 v[5:6], v1, v[2:3] offset:4
// CHECK: [0x04,0x00,0xb4,0xd9,0x01,0x02,0x00,0x05]

ds_wrxchg_rtn_b64 v[5:6], v1, v[2:3] offset:65535 gds
// CHECK: [0xff,0xff,0xb6,0xd9,0x01,0x02,0x00,0x05]

ds_wrxchg2_rtn_b64 v[5:8], v1, v[2:3], v[3:4] offset0:127 offset1:255
// CHECK: [0x7f,0xff,0xb8,0xd9,0x01,0x02,0x03,0x05]

ds_wrxchg2_rtn_b64 v[252:255], v1, v[2:3], v[3:4] offset0:127 offset1:255
// CHECK: [0x7f,0xff,0xb8,0xd9,0x01,0x02,0x03,0xfc]

ds_wrxchg2_rtn_b64 v[5:8], v255, v[2:3], v[3:4] offset0:127 offset1:255
// CHECK: [0x7f,0xff,0xb8,0xd9,0xff,0x02,0x03,0x05]

ds_wrxchg2_rtn_b64 v[5:8], v1, v[254:255], v[3:4] offset0:127 offset1:255
// CHECK: [0x7f,0xff,0xb8,0xd9,0x01,0xfe,0x03,0x05]

ds_wrxchg2_rtn_b64 v[5:8], v1, v[2:3], v[254:255] offset0:127 offset1:255
// CHECK: [0x7f,0xff,0xb8,0xd9,0x01,0x02,0xfe,0x05]

ds_wrxchg2_rtn_b64 v[5:8], v1, v[2:3], v[3:4] offset1:255
// CHECK: [0x00,0xff,0xb8,0xd9,0x01,0x02,0x03,0x05]

ds_wrxchg2_rtn_b64 v[5:8], v1, v[2:3], v[3:4] offset0:0 offset1:255
// CHECK: [0x00,0xff,0xb8,0xd9,0x01,0x02,0x03,0x05]

ds_wrxchg2_rtn_b64 v[5:8], v1, v[2:3], v[3:4] offset0:16 offset1:255
// CHECK: [0x10,0xff,0xb8,0xd9,0x01,0x02,0x03,0x05]

ds_wrxchg2_rtn_b64 v[5:8], v1, v[2:3], v[3:4] offset0:127
// CHECK: [0x7f,0x00,0xb8,0xd9,0x01,0x02,0x03,0x05]

ds_wrxchg2_rtn_b64 v[5:8], v1, v[2:3], v[3:4] offset0:127 offset1:0
// CHECK: [0x7f,0x00,0xb8,0xd9,0x01,0x02,0x03,0x05]

ds_wrxchg2_rtn_b64 v[5:8], v1, v[2:3], v[3:4] offset0:127 offset1:1
// CHECK: [0x7f,0x01,0xb8,0xd9,0x01,0x02,0x03,0x05]

ds_wrxchg2_rtn_b64 v[5:8], v1, v[2:3], v[3:4] offset0:127 offset1:255 gds
// CHECK: [0x7f,0xff,0xba,0xd9,0x01,0x02,0x03,0x05]

ds_wrxchg2st64_rtn_b64 v[5:8], v1, v[2:3], v[3:4] offset0:127 offset1:255
// CHECK: [0x7f,0xff,0xbc,0xd9,0x01,0x02,0x03,0x05]

ds_wrxchg2st64_rtn_b64 v[252:255], v1, v[2:3], v[3:4] offset0:127 offset1:255
// CHECK: [0x7f,0xff,0xbc,0xd9,0x01,0x02,0x03,0xfc]

ds_wrxchg2st64_rtn_b64 v[5:8], v255, v[2:3], v[3:4] offset0:127 offset1:255
// CHECK: [0x7f,0xff,0xbc,0xd9,0xff,0x02,0x03,0x05]

ds_wrxchg2st64_rtn_b64 v[5:8], v1, v[254:255], v[3:4] offset0:127 offset1:255
// CHECK: [0x7f,0xff,0xbc,0xd9,0x01,0xfe,0x03,0x05]

ds_wrxchg2st64_rtn_b64 v[5:8], v1, v[2:3], v[254:255] offset0:127 offset1:255
// CHECK: [0x7f,0xff,0xbc,0xd9,0x01,0x02,0xfe,0x05]

ds_wrxchg2st64_rtn_b64 v[5:8], v1, v[2:3], v[3:4] offset1:255
// CHECK: [0x00,0xff,0xbc,0xd9,0x01,0x02,0x03,0x05]

ds_wrxchg2st64_rtn_b64 v[5:8], v1, v[2:3], v[3:4] offset0:0 offset1:255
// CHECK: [0x00,0xff,0xbc,0xd9,0x01,0x02,0x03,0x05]

ds_wrxchg2st64_rtn_b64 v[5:8], v1, v[2:3], v[3:4] offset0:16 offset1:255
// CHECK: [0x10,0xff,0xbc,0xd9,0x01,0x02,0x03,0x05]

ds_wrxchg2st64_rtn_b64 v[5:8], v1, v[2:3], v[3:4] offset0:127
// CHECK: [0x7f,0x00,0xbc,0xd9,0x01,0x02,0x03,0x05]

ds_wrxchg2st64_rtn_b64 v[5:8], v1, v[2:3], v[3:4] offset0:127 offset1:0
// CHECK: [0x7f,0x00,0xbc,0xd9,0x01,0x02,0x03,0x05]

ds_wrxchg2st64_rtn_b64 v[5:8], v1, v[2:3], v[3:4] offset0:127 offset1:1
// CHECK: [0x7f,0x01,0xbc,0xd9,0x01,0x02,0x03,0x05]

ds_wrxchg2st64_rtn_b64 v[5:8], v1, v[2:3], v[3:4] offset0:127 offset1:255 gds
// CHECK: [0x7f,0xff,0xbe,0xd9,0x01,0x02,0x03,0x05]

ds_cmpst_rtn_b64 v[5:6], v1, v[2:3], v[3:4] offset:65535
// CHECK: [0xff,0xff,0xc0,0xd9,0x01,0x02,0x03,0x05]

ds_cmpst_rtn_b64 v[254:255], v1, v[2:3], v[3:4] offset:65535
// CHECK: [0xff,0xff,0xc0,0xd9,0x01,0x02,0x03,0xfe]

ds_cmpst_rtn_b64 v[5:6], v255, v[2:3], v[3:4] offset:65535
// CHECK: [0xff,0xff,0xc0,0xd9,0xff,0x02,0x03,0x05]

ds_cmpst_rtn_b64 v[5:6], v1, v[254:255], v[3:4] offset:65535
// CHECK: [0xff,0xff,0xc0,0xd9,0x01,0xfe,0x03,0x05]

ds_cmpst_rtn_b64 v[5:6], v1, v[2:3], v[254:255] offset:65535
// CHECK: [0xff,0xff,0xc0,0xd9,0x01,0x02,0xfe,0x05]

ds_cmpst_rtn_b64 v[5:6], v1, v[2:3], v[3:4]
// CHECK: [0x00,0x00,0xc0,0xd9,0x01,0x02,0x03,0x05]

ds_cmpst_rtn_b64 v[5:6], v1, v[2:3], v[3:4] offset:0
// CHECK: [0x00,0x00,0xc0,0xd9,0x01,0x02,0x03,0x05]

ds_cmpst_rtn_b64 v[5:6], v1, v[2:3], v[3:4] offset:4
// CHECK: [0x04,0x00,0xc0,0xd9,0x01,0x02,0x03,0x05]

ds_cmpst_rtn_b64 v[5:6], v1, v[2:3], v[3:4] offset:65535 gds
// CHECK: [0xff,0xff,0xc2,0xd9,0x01,0x02,0x03,0x05]

ds_cmpst_rtn_f64 v[5:6], v1, v[2:3], v[3:4] offset:65535
// CHECK: [0xff,0xff,0xc4,0xd9,0x01,0x02,0x03,0x05]

ds_cmpst_rtn_f64 v[254:255], v1, v[2:3], v[3:4] offset:65535
// CHECK: [0xff,0xff,0xc4,0xd9,0x01,0x02,0x03,0xfe]

ds_cmpst_rtn_f64 v[5:6], v255, v[2:3], v[3:4] offset:65535
// CHECK: [0xff,0xff,0xc4,0xd9,0xff,0x02,0x03,0x05]

ds_cmpst_rtn_f64 v[5:6], v1, v[254:255], v[3:4] offset:65535
// CHECK: [0xff,0xff,0xc4,0xd9,0x01,0xfe,0x03,0x05]

ds_cmpst_rtn_f64 v[5:6], v1, v[2:3], v[254:255] offset:65535
// CHECK: [0xff,0xff,0xc4,0xd9,0x01,0x02,0xfe,0x05]

ds_cmpst_rtn_f64 v[5:6], v1, v[2:3], v[3:4]
// CHECK: [0x00,0x00,0xc4,0xd9,0x01,0x02,0x03,0x05]

ds_cmpst_rtn_f64 v[5:6], v1, v[2:3], v[3:4] offset:0
// CHECK: [0x00,0x00,0xc4,0xd9,0x01,0x02,0x03,0x05]

ds_cmpst_rtn_f64 v[5:6], v1, v[2:3], v[3:4] offset:4
// CHECK: [0x04,0x00,0xc4,0xd9,0x01,0x02,0x03,0x05]

ds_cmpst_rtn_f64 v[5:6], v1, v[2:3], v[3:4] offset:65535 gds
// CHECK: [0xff,0xff,0xc6,0xd9,0x01,0x02,0x03,0x05]

ds_min_rtn_f64 v[5:6], v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0xc8,0xd9,0x01,0x02,0x00,0x05]

ds_min_rtn_f64 v[254:255], v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0xc8,0xd9,0x01,0x02,0x00,0xfe]

ds_min_rtn_f64 v[5:6], v255, v[2:3] offset:65535
// CHECK: [0xff,0xff,0xc8,0xd9,0xff,0x02,0x00,0x05]

ds_min_rtn_f64 v[5:6], v1, v[254:255] offset:65535
// CHECK: [0xff,0xff,0xc8,0xd9,0x01,0xfe,0x00,0x05]

ds_min_rtn_f64 v[5:6], v1, v[2:3]
// CHECK: [0x00,0x00,0xc8,0xd9,0x01,0x02,0x00,0x05]

ds_min_rtn_f64 v[5:6], v1, v[2:3] offset:0
// CHECK: [0x00,0x00,0xc8,0xd9,0x01,0x02,0x00,0x05]

ds_min_rtn_f64 v[5:6], v1, v[2:3] offset:4
// CHECK: [0x04,0x00,0xc8,0xd9,0x01,0x02,0x00,0x05]

ds_min_rtn_f64 v[5:6], v1, v[2:3] offset:65535 gds
// CHECK: [0xff,0xff,0xca,0xd9,0x01,0x02,0x00,0x05]

ds_max_rtn_f64 v[5:6], v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0xcc,0xd9,0x01,0x02,0x00,0x05]

ds_max_rtn_f64 v[254:255], v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0xcc,0xd9,0x01,0x02,0x00,0xfe]

ds_max_rtn_f64 v[5:6], v255, v[2:3] offset:65535
// CHECK: [0xff,0xff,0xcc,0xd9,0xff,0x02,0x00,0x05]

ds_max_rtn_f64 v[5:6], v1, v[254:255] offset:65535
// CHECK: [0xff,0xff,0xcc,0xd9,0x01,0xfe,0x00,0x05]

ds_max_rtn_f64 v[5:6], v1, v[2:3]
// CHECK: [0x00,0x00,0xcc,0xd9,0x01,0x02,0x00,0x05]

ds_max_rtn_f64 v[5:6], v1, v[2:3] offset:0
// CHECK: [0x00,0x00,0xcc,0xd9,0x01,0x02,0x00,0x05]

ds_max_rtn_f64 v[5:6], v1, v[2:3] offset:4
// CHECK: [0x04,0x00,0xcc,0xd9,0x01,0x02,0x00,0x05]

ds_max_rtn_f64 v[5:6], v1, v[2:3] offset:65535 gds
// CHECK: [0xff,0xff,0xce,0xd9,0x01,0x02,0x00,0x05]

ds_read_b64 v[5:6], v1 offset:65535
// CHECK: [0xff,0xff,0xd8,0xd9,0x01,0x00,0x00,0x05]

ds_read_b64 v[254:255], v1 offset:65535
// CHECK: [0xff,0xff,0xd8,0xd9,0x01,0x00,0x00,0xfe]

ds_read_b64 v[5:6], v255 offset:65535
// CHECK: [0xff,0xff,0xd8,0xd9,0xff,0x00,0x00,0x05]

ds_read_b64 v[5:6], v1
// CHECK: [0x00,0x00,0xd8,0xd9,0x01,0x00,0x00,0x05]

ds_read_b64 v[5:6], v1 offset:0
// CHECK: [0x00,0x00,0xd8,0xd9,0x01,0x00,0x00,0x05]

ds_read_b64 v[5:6], v1 offset:4
// CHECK: [0x04,0x00,0xd8,0xd9,0x01,0x00,0x00,0x05]

ds_read_b64 v[5:6], v1 offset:65535 gds
// CHECK: [0xff,0xff,0xda,0xd9,0x01,0x00,0x00,0x05]

ds_read2_b64 v[5:8], v1 offset0:127 offset1:255
// CHECK: [0x7f,0xff,0xdc,0xd9,0x01,0x00,0x00,0x05]

ds_read2_b64 v[252:255], v1 offset0:127 offset1:255
// CHECK: [0x7f,0xff,0xdc,0xd9,0x01,0x00,0x00,0xfc]

ds_read2_b64 v[5:8], v255 offset0:127 offset1:255
// CHECK: [0x7f,0xff,0xdc,0xd9,0xff,0x00,0x00,0x05]

ds_read2_b64 v[5:8], v1 offset1:255
// CHECK: [0x00,0xff,0xdc,0xd9,0x01,0x00,0x00,0x05]

ds_read2_b64 v[5:8], v1 offset0:0 offset1:255
// CHECK: [0x00,0xff,0xdc,0xd9,0x01,0x00,0x00,0x05]

ds_read2_b64 v[5:8], v1 offset0:16 offset1:255
// CHECK: [0x10,0xff,0xdc,0xd9,0x01,0x00,0x00,0x05]

ds_read2_b64 v[5:8], v1 offset0:127
// CHECK: [0x7f,0x00,0xdc,0xd9,0x01,0x00,0x00,0x05]

ds_read2_b64 v[5:8], v1 offset0:127 offset1:0
// CHECK: [0x7f,0x00,0xdc,0xd9,0x01,0x00,0x00,0x05]

ds_read2_b64 v[5:8], v1 offset0:127 offset1:1
// CHECK: [0x7f,0x01,0xdc,0xd9,0x01,0x00,0x00,0x05]

ds_read2_b64 v[5:8], v1 offset0:127 offset1:255 gds
// CHECK: [0x7f,0xff,0xde,0xd9,0x01,0x00,0x00,0x05]

ds_read2st64_b64 v[5:8], v1 offset0:127 offset1:255
// CHECK: [0x7f,0xff,0xe0,0xd9,0x01,0x00,0x00,0x05]

ds_read2st64_b64 v[252:255], v1 offset0:127 offset1:255
// CHECK: [0x7f,0xff,0xe0,0xd9,0x01,0x00,0x00,0xfc]

ds_read2st64_b64 v[5:8], v255 offset0:127 offset1:255
// CHECK: [0x7f,0xff,0xe0,0xd9,0xff,0x00,0x00,0x05]

ds_read2st64_b64 v[5:8], v1 offset1:255
// CHECK: [0x00,0xff,0xe0,0xd9,0x01,0x00,0x00,0x05]

ds_read2st64_b64 v[5:8], v1 offset0:0 offset1:255
// CHECK: [0x00,0xff,0xe0,0xd9,0x01,0x00,0x00,0x05]

ds_read2st64_b64 v[5:8], v1 offset0:16 offset1:255
// CHECK: [0x10,0xff,0xe0,0xd9,0x01,0x00,0x00,0x05]

ds_read2st64_b64 v[5:8], v1 offset0:127
// CHECK: [0x7f,0x00,0xe0,0xd9,0x01,0x00,0x00,0x05]

ds_read2st64_b64 v[5:8], v1 offset0:127 offset1:0
// CHECK: [0x7f,0x00,0xe0,0xd9,0x01,0x00,0x00,0x05]

ds_read2st64_b64 v[5:8], v1 offset0:127 offset1:1
// CHECK: [0x7f,0x01,0xe0,0xd9,0x01,0x00,0x00,0x05]

ds_read2st64_b64 v[5:8], v1 offset0:127 offset1:255 gds
// CHECK: [0x7f,0xff,0xe2,0xd9,0x01,0x00,0x00,0x05]

ds_condxchg32_rtn_b64 v[5:6], v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0xf8,0xd9,0x01,0x02,0x00,0x05]

ds_condxchg32_rtn_b64 v[254:255], v1, v[2:3] offset:65535
// CHECK: [0xff,0xff,0xf8,0xd9,0x01,0x02,0x00,0xfe]

ds_condxchg32_rtn_b64 v[5:6], v255, v[2:3] offset:65535
// CHECK: [0xff,0xff,0xf8,0xd9,0xff,0x02,0x00,0x05]

ds_condxchg32_rtn_b64 v[5:6], v1, v[254:255] offset:65535
// CHECK: [0xff,0xff,0xf8,0xd9,0x01,0xfe,0x00,0x05]

ds_condxchg32_rtn_b64 v[5:6], v1, v[2:3]
// CHECK: [0x00,0x00,0xf8,0xd9,0x01,0x02,0x00,0x05]

ds_condxchg32_rtn_b64 v[5:6], v1, v[2:3] offset:0
// CHECK: [0x00,0x00,0xf8,0xd9,0x01,0x02,0x00,0x05]

ds_condxchg32_rtn_b64 v[5:6], v1, v[2:3] offset:4
// CHECK: [0x04,0x00,0xf8,0xd9,0x01,0x02,0x00,0x05]

ds_condxchg32_rtn_b64 v[5:6], v1, v[2:3] offset:65535 gds
// CHECK: [0xff,0xff,0xfa,0xd9,0x01,0x02,0x00,0x05]

ds_add_src2_u32 v1 offset:65535
// CHECK: [0xff,0xff,0x00,0xda,0x01,0x00,0x00,0x00]

ds_add_src2_u32 v255 offset:65535
// CHECK: [0xff,0xff,0x00,0xda,0xff,0x00,0x00,0x00]

ds_add_src2_u32 v1
// CHECK: [0x00,0x00,0x00,0xda,0x01,0x00,0x00,0x00]

ds_add_src2_u32 v1 offset:0
// CHECK: [0x00,0x00,0x00,0xda,0x01,0x00,0x00,0x00]

ds_add_src2_u32 v1 offset:4
// CHECK: [0x04,0x00,0x00,0xda,0x01,0x00,0x00,0x00]

ds_add_src2_u32 v1 offset:65535 gds
// CHECK: [0xff,0xff,0x02,0xda,0x01,0x00,0x00,0x00]

ds_sub_src2_u32 v1 offset:65535
// CHECK: [0xff,0xff,0x04,0xda,0x01,0x00,0x00,0x00]

ds_sub_src2_u32 v255 offset:65535
// CHECK: [0xff,0xff,0x04,0xda,0xff,0x00,0x00,0x00]

ds_sub_src2_u32 v1
// CHECK: [0x00,0x00,0x04,0xda,0x01,0x00,0x00,0x00]

ds_sub_src2_u32 v1 offset:0
// CHECK: [0x00,0x00,0x04,0xda,0x01,0x00,0x00,0x00]

ds_sub_src2_u32 v1 offset:4
// CHECK: [0x04,0x00,0x04,0xda,0x01,0x00,0x00,0x00]

ds_sub_src2_u32 v1 offset:65535 gds
// CHECK: [0xff,0xff,0x06,0xda,0x01,0x00,0x00,0x00]

ds_rsub_src2_u32 v1 offset:65535
// CHECK: [0xff,0xff,0x08,0xda,0x01,0x00,0x00,0x00]

ds_rsub_src2_u32 v255 offset:65535
// CHECK: [0xff,0xff,0x08,0xda,0xff,0x00,0x00,0x00]

ds_rsub_src2_u32 v1
// CHECK: [0x00,0x00,0x08,0xda,0x01,0x00,0x00,0x00]

ds_rsub_src2_u32 v1 offset:0
// CHECK: [0x00,0x00,0x08,0xda,0x01,0x00,0x00,0x00]

ds_rsub_src2_u32 v1 offset:4
// CHECK: [0x04,0x00,0x08,0xda,0x01,0x00,0x00,0x00]

ds_rsub_src2_u32 v1 offset:65535 gds
// CHECK: [0xff,0xff,0x0a,0xda,0x01,0x00,0x00,0x00]

ds_inc_src2_u32 v1 offset:65535
// CHECK: [0xff,0xff,0x0c,0xda,0x01,0x00,0x00,0x00]

ds_inc_src2_u32 v255 offset:65535
// CHECK: [0xff,0xff,0x0c,0xda,0xff,0x00,0x00,0x00]

ds_inc_src2_u32 v1
// CHECK: [0x00,0x00,0x0c,0xda,0x01,0x00,0x00,0x00]

ds_inc_src2_u32 v1 offset:0
// CHECK: [0x00,0x00,0x0c,0xda,0x01,0x00,0x00,0x00]

ds_inc_src2_u32 v1 offset:4
// CHECK: [0x04,0x00,0x0c,0xda,0x01,0x00,0x00,0x00]

ds_inc_src2_u32 v1 offset:65535 gds
// CHECK: [0xff,0xff,0x0e,0xda,0x01,0x00,0x00,0x00]

ds_dec_src2_u32 v1 offset:65535
// CHECK: [0xff,0xff,0x10,0xda,0x01,0x00,0x00,0x00]

ds_dec_src2_u32 v255 offset:65535
// CHECK: [0xff,0xff,0x10,0xda,0xff,0x00,0x00,0x00]

ds_dec_src2_u32 v1
// CHECK: [0x00,0x00,0x10,0xda,0x01,0x00,0x00,0x00]

ds_dec_src2_u32 v1 offset:0
// CHECK: [0x00,0x00,0x10,0xda,0x01,0x00,0x00,0x00]

ds_dec_src2_u32 v1 offset:4
// CHECK: [0x04,0x00,0x10,0xda,0x01,0x00,0x00,0x00]

ds_dec_src2_u32 v1 offset:65535 gds
// CHECK: [0xff,0xff,0x12,0xda,0x01,0x00,0x00,0x00]

ds_min_src2_i32 v1 offset:65535
// CHECK: [0xff,0xff,0x14,0xda,0x01,0x00,0x00,0x00]

ds_min_src2_i32 v255 offset:65535
// CHECK: [0xff,0xff,0x14,0xda,0xff,0x00,0x00,0x00]

ds_min_src2_i32 v1
// CHECK: [0x00,0x00,0x14,0xda,0x01,0x00,0x00,0x00]

ds_min_src2_i32 v1 offset:0
// CHECK: [0x00,0x00,0x14,0xda,0x01,0x00,0x00,0x00]

ds_min_src2_i32 v1 offset:4
// CHECK: [0x04,0x00,0x14,0xda,0x01,0x00,0x00,0x00]

ds_min_src2_i32 v1 offset:65535 gds
// CHECK: [0xff,0xff,0x16,0xda,0x01,0x00,0x00,0x00]

ds_max_src2_i32 v1 offset:65535
// CHECK: [0xff,0xff,0x18,0xda,0x01,0x00,0x00,0x00]

ds_max_src2_i32 v255 offset:65535
// CHECK: [0xff,0xff,0x18,0xda,0xff,0x00,0x00,0x00]

ds_max_src2_i32 v1
// CHECK: [0x00,0x00,0x18,0xda,0x01,0x00,0x00,0x00]

ds_max_src2_i32 v1 offset:0
// CHECK: [0x00,0x00,0x18,0xda,0x01,0x00,0x00,0x00]

ds_max_src2_i32 v1 offset:4
// CHECK: [0x04,0x00,0x18,0xda,0x01,0x00,0x00,0x00]

ds_max_src2_i32 v1 offset:65535 gds
// CHECK: [0xff,0xff,0x1a,0xda,0x01,0x00,0x00,0x00]

ds_min_src2_u32 v1 offset:65535
// CHECK: [0xff,0xff,0x1c,0xda,0x01,0x00,0x00,0x00]

ds_min_src2_u32 v255 offset:65535
// CHECK: [0xff,0xff,0x1c,0xda,0xff,0x00,0x00,0x00]

ds_min_src2_u32 v1
// CHECK: [0x00,0x00,0x1c,0xda,0x01,0x00,0x00,0x00]

ds_min_src2_u32 v1 offset:0
// CHECK: [0x00,0x00,0x1c,0xda,0x01,0x00,0x00,0x00]

ds_min_src2_u32 v1 offset:4
// CHECK: [0x04,0x00,0x1c,0xda,0x01,0x00,0x00,0x00]

ds_min_src2_u32 v1 offset:65535 gds
// CHECK: [0xff,0xff,0x1e,0xda,0x01,0x00,0x00,0x00]

ds_max_src2_u32 v1 offset:65535
// CHECK: [0xff,0xff,0x20,0xda,0x01,0x00,0x00,0x00]

ds_max_src2_u32 v255 offset:65535
// CHECK: [0xff,0xff,0x20,0xda,0xff,0x00,0x00,0x00]

ds_max_src2_u32 v1
// CHECK: [0x00,0x00,0x20,0xda,0x01,0x00,0x00,0x00]

ds_max_src2_u32 v1 offset:0
// CHECK: [0x00,0x00,0x20,0xda,0x01,0x00,0x00,0x00]

ds_max_src2_u32 v1 offset:4
// CHECK: [0x04,0x00,0x20,0xda,0x01,0x00,0x00,0x00]

ds_max_src2_u32 v1 offset:65535 gds
// CHECK: [0xff,0xff,0x22,0xda,0x01,0x00,0x00,0x00]

ds_and_src2_b32 v1 offset:65535
// CHECK: [0xff,0xff,0x24,0xda,0x01,0x00,0x00,0x00]

ds_and_src2_b32 v255 offset:65535
// CHECK: [0xff,0xff,0x24,0xda,0xff,0x00,0x00,0x00]

ds_and_src2_b32 v1
// CHECK: [0x00,0x00,0x24,0xda,0x01,0x00,0x00,0x00]

ds_and_src2_b32 v1 offset:0
// CHECK: [0x00,0x00,0x24,0xda,0x01,0x00,0x00,0x00]

ds_and_src2_b32 v1 offset:4
// CHECK: [0x04,0x00,0x24,0xda,0x01,0x00,0x00,0x00]

ds_and_src2_b32 v1 offset:65535 gds
// CHECK: [0xff,0xff,0x26,0xda,0x01,0x00,0x00,0x00]

ds_or_src2_b32 v1 offset:65535
// CHECK: [0xff,0xff,0x28,0xda,0x01,0x00,0x00,0x00]

ds_or_src2_b32 v255 offset:65535
// CHECK: [0xff,0xff,0x28,0xda,0xff,0x00,0x00,0x00]

ds_or_src2_b32 v1
// CHECK: [0x00,0x00,0x28,0xda,0x01,0x00,0x00,0x00]

ds_or_src2_b32 v1 offset:0
// CHECK: [0x00,0x00,0x28,0xda,0x01,0x00,0x00,0x00]

ds_or_src2_b32 v1 offset:4
// CHECK: [0x04,0x00,0x28,0xda,0x01,0x00,0x00,0x00]

ds_or_src2_b32 v1 offset:65535 gds
// CHECK: [0xff,0xff,0x2a,0xda,0x01,0x00,0x00,0x00]

ds_xor_src2_b32 v1 offset:65535
// CHECK: [0xff,0xff,0x2c,0xda,0x01,0x00,0x00,0x00]

ds_xor_src2_b32 v255 offset:65535
// CHECK: [0xff,0xff,0x2c,0xda,0xff,0x00,0x00,0x00]

ds_xor_src2_b32 v1
// CHECK: [0x00,0x00,0x2c,0xda,0x01,0x00,0x00,0x00]

ds_xor_src2_b32 v1 offset:0
// CHECK: [0x00,0x00,0x2c,0xda,0x01,0x00,0x00,0x00]

ds_xor_src2_b32 v1 offset:4
// CHECK: [0x04,0x00,0x2c,0xda,0x01,0x00,0x00,0x00]

ds_xor_src2_b32 v1 offset:65535 gds
// CHECK: [0xff,0xff,0x2e,0xda,0x01,0x00,0x00,0x00]

ds_write_src2_b32 v1 offset:65535
// CHECK: [0xff,0xff,0x34,0xda,0x01,0x00,0x00,0x00]

ds_write_src2_b32 v255 offset:65535
// CHECK: [0xff,0xff,0x34,0xda,0xff,0x00,0x00,0x00]

ds_write_src2_b32 v1
// CHECK: [0x00,0x00,0x34,0xda,0x01,0x00,0x00,0x00]

ds_write_src2_b32 v1 offset:0
// CHECK: [0x00,0x00,0x34,0xda,0x01,0x00,0x00,0x00]

ds_write_src2_b32 v1 offset:4
// CHECK: [0x04,0x00,0x34,0xda,0x01,0x00,0x00,0x00]

ds_write_src2_b32 v1 offset:65535 gds
// CHECK: [0xff,0xff,0x36,0xda,0x01,0x00,0x00,0x00]

ds_min_src2_f32 v1 offset:65535
// CHECK: [0xff,0xff,0x48,0xda,0x01,0x00,0x00,0x00]

ds_min_src2_f32 v255 offset:65535
// CHECK: [0xff,0xff,0x48,0xda,0xff,0x00,0x00,0x00]

ds_min_src2_f32 v1
// CHECK: [0x00,0x00,0x48,0xda,0x01,0x00,0x00,0x00]

ds_min_src2_f32 v1 offset:0
// CHECK: [0x00,0x00,0x48,0xda,0x01,0x00,0x00,0x00]

ds_min_src2_f32 v1 offset:4
// CHECK: [0x04,0x00,0x48,0xda,0x01,0x00,0x00,0x00]

ds_min_src2_f32 v1 offset:65535 gds
// CHECK: [0xff,0xff,0x4a,0xda,0x01,0x00,0x00,0x00]

ds_max_src2_f32 v1 offset:65535
// CHECK: [0xff,0xff,0x4c,0xda,0x01,0x00,0x00,0x00]

ds_max_src2_f32 v255 offset:65535
// CHECK: [0xff,0xff,0x4c,0xda,0xff,0x00,0x00,0x00]

ds_max_src2_f32 v1
// CHECK: [0x00,0x00,0x4c,0xda,0x01,0x00,0x00,0x00]

ds_max_src2_f32 v1 offset:0
// CHECK: [0x00,0x00,0x4c,0xda,0x01,0x00,0x00,0x00]

ds_max_src2_f32 v1 offset:4
// CHECK: [0x04,0x00,0x4c,0xda,0x01,0x00,0x00,0x00]

ds_max_src2_f32 v1 offset:65535 gds
// CHECK: [0xff,0xff,0x4e,0xda,0x01,0x00,0x00,0x00]

ds_add_src2_u64 v1 offset:65535
// CHECK: [0xff,0xff,0x00,0xdb,0x01,0x00,0x00,0x00]

ds_add_src2_u64 v255 offset:65535
// CHECK: [0xff,0xff,0x00,0xdb,0xff,0x00,0x00,0x00]

ds_add_src2_u64 v1
// CHECK: [0x00,0x00,0x00,0xdb,0x01,0x00,0x00,0x00]

ds_add_src2_u64 v1 offset:0
// CHECK: [0x00,0x00,0x00,0xdb,0x01,0x00,0x00,0x00]

ds_add_src2_u64 v1 offset:4
// CHECK: [0x04,0x00,0x00,0xdb,0x01,0x00,0x00,0x00]

ds_add_src2_u64 v1 offset:65535 gds
// CHECK: [0xff,0xff,0x02,0xdb,0x01,0x00,0x00,0x00]

ds_sub_src2_u64 v1 offset:65535
// CHECK: [0xff,0xff,0x04,0xdb,0x01,0x00,0x00,0x00]

ds_sub_src2_u64 v255 offset:65535
// CHECK: [0xff,0xff,0x04,0xdb,0xff,0x00,0x00,0x00]

ds_sub_src2_u64 v1
// CHECK: [0x00,0x00,0x04,0xdb,0x01,0x00,0x00,0x00]

ds_sub_src2_u64 v1 offset:0
// CHECK: [0x00,0x00,0x04,0xdb,0x01,0x00,0x00,0x00]

ds_sub_src2_u64 v1 offset:4
// CHECK: [0x04,0x00,0x04,0xdb,0x01,0x00,0x00,0x00]

ds_sub_src2_u64 v1 offset:65535 gds
// CHECK: [0xff,0xff,0x06,0xdb,0x01,0x00,0x00,0x00]

ds_rsub_src2_u64 v1 offset:65535
// CHECK: [0xff,0xff,0x08,0xdb,0x01,0x00,0x00,0x00]

ds_rsub_src2_u64 v255 offset:65535
// CHECK: [0xff,0xff,0x08,0xdb,0xff,0x00,0x00,0x00]

ds_rsub_src2_u64 v1
// CHECK: [0x00,0x00,0x08,0xdb,0x01,0x00,0x00,0x00]

ds_rsub_src2_u64 v1 offset:0
// CHECK: [0x00,0x00,0x08,0xdb,0x01,0x00,0x00,0x00]

ds_rsub_src2_u64 v1 offset:4
// CHECK: [0x04,0x00,0x08,0xdb,0x01,0x00,0x00,0x00]

ds_rsub_src2_u64 v1 offset:65535 gds
// CHECK: [0xff,0xff,0x0a,0xdb,0x01,0x00,0x00,0x00]

ds_inc_src2_u64 v1 offset:65535
// CHECK: [0xff,0xff,0x0c,0xdb,0x01,0x00,0x00,0x00]

ds_inc_src2_u64 v255 offset:65535
// CHECK: [0xff,0xff,0x0c,0xdb,0xff,0x00,0x00,0x00]

ds_inc_src2_u64 v1
// CHECK: [0x00,0x00,0x0c,0xdb,0x01,0x00,0x00,0x00]

ds_inc_src2_u64 v1 offset:0
// CHECK: [0x00,0x00,0x0c,0xdb,0x01,0x00,0x00,0x00]

ds_inc_src2_u64 v1 offset:4
// CHECK: [0x04,0x00,0x0c,0xdb,0x01,0x00,0x00,0x00]

ds_inc_src2_u64 v1 offset:65535 gds
// CHECK: [0xff,0xff,0x0e,0xdb,0x01,0x00,0x00,0x00]

ds_dec_src2_u64 v1 offset:65535
// CHECK: [0xff,0xff,0x10,0xdb,0x01,0x00,0x00,0x00]

ds_dec_src2_u64 v255 offset:65535
// CHECK: [0xff,0xff,0x10,0xdb,0xff,0x00,0x00,0x00]

ds_dec_src2_u64 v1
// CHECK: [0x00,0x00,0x10,0xdb,0x01,0x00,0x00,0x00]

ds_dec_src2_u64 v1 offset:0
// CHECK: [0x00,0x00,0x10,0xdb,0x01,0x00,0x00,0x00]

ds_dec_src2_u64 v1 offset:4
// CHECK: [0x04,0x00,0x10,0xdb,0x01,0x00,0x00,0x00]

ds_dec_src2_u64 v1 offset:65535 gds
// CHECK: [0xff,0xff,0x12,0xdb,0x01,0x00,0x00,0x00]

ds_min_src2_i64 v1 offset:65535
// CHECK: [0xff,0xff,0x14,0xdb,0x01,0x00,0x00,0x00]

ds_min_src2_i64 v255 offset:65535
// CHECK: [0xff,0xff,0x14,0xdb,0xff,0x00,0x00,0x00]

ds_min_src2_i64 v1
// CHECK: [0x00,0x00,0x14,0xdb,0x01,0x00,0x00,0x00]

ds_min_src2_i64 v1 offset:0
// CHECK: [0x00,0x00,0x14,0xdb,0x01,0x00,0x00,0x00]

ds_min_src2_i64 v1 offset:4
// CHECK: [0x04,0x00,0x14,0xdb,0x01,0x00,0x00,0x00]

ds_min_src2_i64 v1 offset:65535 gds
// CHECK: [0xff,0xff,0x16,0xdb,0x01,0x00,0x00,0x00]

ds_max_src2_i64 v1 offset:65535
// CHECK: [0xff,0xff,0x18,0xdb,0x01,0x00,0x00,0x00]

ds_max_src2_i64 v255 offset:65535
// CHECK: [0xff,0xff,0x18,0xdb,0xff,0x00,0x00,0x00]

ds_max_src2_i64 v1
// CHECK: [0x00,0x00,0x18,0xdb,0x01,0x00,0x00,0x00]

ds_max_src2_i64 v1 offset:0
// CHECK: [0x00,0x00,0x18,0xdb,0x01,0x00,0x00,0x00]

ds_max_src2_i64 v1 offset:4
// CHECK: [0x04,0x00,0x18,0xdb,0x01,0x00,0x00,0x00]

ds_max_src2_i64 v1 offset:65535 gds
// CHECK: [0xff,0xff,0x1a,0xdb,0x01,0x00,0x00,0x00]

ds_min_src2_u64 v1 offset:65535
// CHECK: [0xff,0xff,0x1c,0xdb,0x01,0x00,0x00,0x00]

ds_min_src2_u64 v255 offset:65535
// CHECK: [0xff,0xff,0x1c,0xdb,0xff,0x00,0x00,0x00]

ds_min_src2_u64 v1
// CHECK: [0x00,0x00,0x1c,0xdb,0x01,0x00,0x00,0x00]

ds_min_src2_u64 v1 offset:0
// CHECK: [0x00,0x00,0x1c,0xdb,0x01,0x00,0x00,0x00]

ds_min_src2_u64 v1 offset:4
// CHECK: [0x04,0x00,0x1c,0xdb,0x01,0x00,0x00,0x00]

ds_min_src2_u64 v1 offset:65535 gds
// CHECK: [0xff,0xff,0x1e,0xdb,0x01,0x00,0x00,0x00]

ds_max_src2_u64 v1 offset:65535
// CHECK: [0xff,0xff,0x20,0xdb,0x01,0x00,0x00,0x00]

ds_max_src2_u64 v255 offset:65535
// CHECK: [0xff,0xff,0x20,0xdb,0xff,0x00,0x00,0x00]

ds_max_src2_u64 v1
// CHECK: [0x00,0x00,0x20,0xdb,0x01,0x00,0x00,0x00]

ds_max_src2_u64 v1 offset:0
// CHECK: [0x00,0x00,0x20,0xdb,0x01,0x00,0x00,0x00]

ds_max_src2_u64 v1 offset:4
// CHECK: [0x04,0x00,0x20,0xdb,0x01,0x00,0x00,0x00]

ds_max_src2_u64 v1 offset:65535 gds
// CHECK: [0xff,0xff,0x22,0xdb,0x01,0x00,0x00,0x00]

ds_and_src2_b64 v1 offset:65535
// CHECK: [0xff,0xff,0x24,0xdb,0x01,0x00,0x00,0x00]

ds_and_src2_b64 v255 offset:65535
// CHECK: [0xff,0xff,0x24,0xdb,0xff,0x00,0x00,0x00]

ds_and_src2_b64 v1
// CHECK: [0x00,0x00,0x24,0xdb,0x01,0x00,0x00,0x00]

ds_and_src2_b64 v1 offset:0
// CHECK: [0x00,0x00,0x24,0xdb,0x01,0x00,0x00,0x00]

ds_and_src2_b64 v1 offset:4
// CHECK: [0x04,0x00,0x24,0xdb,0x01,0x00,0x00,0x00]

ds_and_src2_b64 v1 offset:65535 gds
// CHECK: [0xff,0xff,0x26,0xdb,0x01,0x00,0x00,0x00]

ds_or_src2_b64 v1 offset:65535
// CHECK: [0xff,0xff,0x28,0xdb,0x01,0x00,0x00,0x00]

ds_or_src2_b64 v255 offset:65535
// CHECK: [0xff,0xff,0x28,0xdb,0xff,0x00,0x00,0x00]

ds_or_src2_b64 v1
// CHECK: [0x00,0x00,0x28,0xdb,0x01,0x00,0x00,0x00]

ds_or_src2_b64 v1 offset:0
// CHECK: [0x00,0x00,0x28,0xdb,0x01,0x00,0x00,0x00]

ds_or_src2_b64 v1 offset:4
// CHECK: [0x04,0x00,0x28,0xdb,0x01,0x00,0x00,0x00]

ds_or_src2_b64 v1 offset:65535 gds
// CHECK: [0xff,0xff,0x2a,0xdb,0x01,0x00,0x00,0x00]

ds_xor_src2_b64 v1 offset:65535
// CHECK: [0xff,0xff,0x2c,0xdb,0x01,0x00,0x00,0x00]

ds_xor_src2_b64 v255 offset:65535
// CHECK: [0xff,0xff,0x2c,0xdb,0xff,0x00,0x00,0x00]

ds_xor_src2_b64 v1
// CHECK: [0x00,0x00,0x2c,0xdb,0x01,0x00,0x00,0x00]

ds_xor_src2_b64 v1 offset:0
// CHECK: [0x00,0x00,0x2c,0xdb,0x01,0x00,0x00,0x00]

ds_xor_src2_b64 v1 offset:4
// CHECK: [0x04,0x00,0x2c,0xdb,0x01,0x00,0x00,0x00]

ds_xor_src2_b64 v1 offset:65535 gds
// CHECK: [0xff,0xff,0x2e,0xdb,0x01,0x00,0x00,0x00]

ds_write_src2_b64 v1 offset:65535
// CHECK: [0xff,0xff,0x34,0xdb,0x01,0x00,0x00,0x00]

ds_write_src2_b64 v255 offset:65535
// CHECK: [0xff,0xff,0x34,0xdb,0xff,0x00,0x00,0x00]

ds_write_src2_b64 v1
// CHECK: [0x00,0x00,0x34,0xdb,0x01,0x00,0x00,0x00]

ds_write_src2_b64 v1 offset:0
// CHECK: [0x00,0x00,0x34,0xdb,0x01,0x00,0x00,0x00]

ds_write_src2_b64 v1 offset:4
// CHECK: [0x04,0x00,0x34,0xdb,0x01,0x00,0x00,0x00]

ds_write_src2_b64 v1 offset:65535 gds
// CHECK: [0xff,0xff,0x36,0xdb,0x01,0x00,0x00,0x00]

ds_min_src2_f64 v1 offset:65535
// CHECK: [0xff,0xff,0x48,0xdb,0x01,0x00,0x00,0x00]

ds_min_src2_f64 v255 offset:65535
// CHECK: [0xff,0xff,0x48,0xdb,0xff,0x00,0x00,0x00]

ds_min_src2_f64 v1
// CHECK: [0x00,0x00,0x48,0xdb,0x01,0x00,0x00,0x00]

ds_min_src2_f64 v1 offset:0
// CHECK: [0x00,0x00,0x48,0xdb,0x01,0x00,0x00,0x00]

ds_min_src2_f64 v1 offset:4
// CHECK: [0x04,0x00,0x48,0xdb,0x01,0x00,0x00,0x00]

ds_min_src2_f64 v1 offset:65535 gds
// CHECK: [0xff,0xff,0x4a,0xdb,0x01,0x00,0x00,0x00]

ds_max_src2_f64 v1 offset:65535
// CHECK: [0xff,0xff,0x4c,0xdb,0x01,0x00,0x00,0x00]

ds_max_src2_f64 v255 offset:65535
// CHECK: [0xff,0xff,0x4c,0xdb,0xff,0x00,0x00,0x00]

ds_max_src2_f64 v1
// CHECK: [0x00,0x00,0x4c,0xdb,0x01,0x00,0x00,0x00]

ds_max_src2_f64 v1 offset:0
// CHECK: [0x00,0x00,0x4c,0xdb,0x01,0x00,0x00,0x00]

ds_max_src2_f64 v1 offset:4
// CHECK: [0x04,0x00,0x4c,0xdb,0x01,0x00,0x00,0x00]

ds_max_src2_f64 v1 offset:65535 gds
// CHECK: [0xff,0xff,0x4e,0xdb,0x01,0x00,0x00,0x00]

ds_write_b96 v1, v[2:4] offset:65535
// CHECK: [0xff,0xff,0x78,0xdb,0x01,0x02,0x00,0x00]

ds_write_b96 v255, v[2:4] offset:65535
// CHECK: [0xff,0xff,0x78,0xdb,0xff,0x02,0x00,0x00]

ds_write_b96 v1, v[253:255] offset:65535
// CHECK: [0xff,0xff,0x78,0xdb,0x01,0xfd,0x00,0x00]

ds_write_b96 v1, v[2:4]
// CHECK: [0x00,0x00,0x78,0xdb,0x01,0x02,0x00,0x00]

ds_write_b96 v1, v[2:4] offset:0
// CHECK: [0x00,0x00,0x78,0xdb,0x01,0x02,0x00,0x00]

ds_write_b96 v1, v[2:4] offset:4
// CHECK: [0x04,0x00,0x78,0xdb,0x01,0x02,0x00,0x00]

ds_write_b96 v1, v[2:4] offset:65535 gds
// CHECK: [0xff,0xff,0x7a,0xdb,0x01,0x02,0x00,0x00]

ds_write_b128 v1, v[2:5] offset:65535
// CHECK: [0xff,0xff,0x7c,0xdb,0x01,0x02,0x00,0x00]

ds_write_b128 v255, v[2:5] offset:65535
// CHECK: [0xff,0xff,0x7c,0xdb,0xff,0x02,0x00,0x00]

ds_write_b128 v1, v[252:255] offset:65535
// CHECK: [0xff,0xff,0x7c,0xdb,0x01,0xfc,0x00,0x00]

ds_write_b128 v1, v[2:5]
// CHECK: [0x00,0x00,0x7c,0xdb,0x01,0x02,0x00,0x00]

ds_write_b128 v1, v[2:5] offset:0
// CHECK: [0x00,0x00,0x7c,0xdb,0x01,0x02,0x00,0x00]

ds_write_b128 v1, v[2:5] offset:4
// CHECK: [0x04,0x00,0x7c,0xdb,0x01,0x02,0x00,0x00]

ds_write_b128 v1, v[2:5] offset:65535 gds
// CHECK: [0xff,0xff,0x7e,0xdb,0x01,0x02,0x00,0x00]

ds_read_b96 v[5:7], v1 offset:65535
// CHECK: [0xff,0xff,0xf8,0xdb,0x01,0x00,0x00,0x05]

ds_read_b96 v[253:255], v1 offset:65535
// CHECK: [0xff,0xff,0xf8,0xdb,0x01,0x00,0x00,0xfd]

ds_read_b96 v[5:7], v255 offset:65535
// CHECK: [0xff,0xff,0xf8,0xdb,0xff,0x00,0x00,0x05]

ds_read_b96 v[5:7], v1
// CHECK: [0x00,0x00,0xf8,0xdb,0x01,0x00,0x00,0x05]

ds_read_b96 v[5:7], v1 offset:0
// CHECK: [0x00,0x00,0xf8,0xdb,0x01,0x00,0x00,0x05]

ds_read_b96 v[5:7], v1 offset:4
// CHECK: [0x04,0x00,0xf8,0xdb,0x01,0x00,0x00,0x05]

ds_read_b96 v[5:7], v1 offset:65535 gds
// CHECK: [0xff,0xff,0xfa,0xdb,0x01,0x00,0x00,0x05]

ds_read_b128 v[5:8], v1 offset:65535
// CHECK: [0xff,0xff,0xfc,0xdb,0x01,0x00,0x00,0x05]

ds_read_b128 v[252:255], v1 offset:65535
// CHECK: [0xff,0xff,0xfc,0xdb,0x01,0x00,0x00,0xfc]

ds_read_b128 v[5:8], v255 offset:65535
// CHECK: [0xff,0xff,0xfc,0xdb,0xff,0x00,0x00,0x05]

ds_read_b128 v[5:8], v1
// CHECK: [0x00,0x00,0xfc,0xdb,0x01,0x00,0x00,0x05]

ds_read_b128 v[5:8], v1 offset:0
// CHECK: [0x00,0x00,0xfc,0xdb,0x01,0x00,0x00,0x05]

ds_read_b128 v[5:8], v1 offset:4
// CHECK: [0x04,0x00,0xfc,0xdb,0x01,0x00,0x00,0x05]

ds_read_b128 v[5:8], v1 offset:65535 gds
// CHECK: [0xff,0xff,0xfe,0xdb,0x01,0x00,0x00,0x05]

exp mrt0 v0, v0, v0, v0
// CHECK: [0x0f,0x00,0x00,0xf8,0x00,0x00,0x00,0x00]

exp mrtz v0, v0, v0, v0
// CHECK: [0x8f,0x00,0x00,0xf8,0x00,0x00,0x00,0x00]

exp null v0, v0, v0, v0
// CHECK: [0x9f,0x00,0x00,0xf8,0x00,0x00,0x00,0x00]

exp pos0 v0, v0, v0, v0
// CHECK: [0xcf,0x00,0x00,0xf8,0x00,0x00,0x00,0x00]

exp param0 v0, v0, v0, v0
// CHECK: [0x0f,0x02,0x00,0xf8,0x00,0x00,0x00,0x00]

exp mrt0 v255, v0, v0, v0
// CHECK: [0x0f,0x00,0x00,0xf8,0xff,0x00,0x00,0x00]

exp mrt0 v0, v255, v0, v0
// CHECK: [0x0f,0x00,0x00,0xf8,0x00,0xff,0x00,0x00]

exp mrt0 v0, v0, v255, v0
// CHECK: [0x0f,0x00,0x00,0xf8,0x00,0x00,0xff,0x00]

exp mrt0 v0, v0, v0, v255
// CHECK: [0x0f,0x00,0x00,0xf8,0x00,0x00,0x00,0xff]

exp mrt0 v0, off, off, off
// CHECK: [0x01,0x00,0x00,0xf8,0x00,0x00,0x00,0x00]

exp mrt0 off, v0, off, off
// CHECK: [0x02,0x00,0x00,0xf8,0x00,0x00,0x00,0x00]

exp mrt0 v0, v0, off, off
// CHECK: [0x03,0x00,0x00,0xf8,0x00,0x00,0x00,0x00]

exp mrt0 off, off, v0, off
// CHECK: [0x04,0x00,0x00,0xf8,0x00,0x00,0x00,0x00]

exp mrt0 v0, off, v0, off
// CHECK: [0x05,0x00,0x00,0xf8,0x00,0x00,0x00,0x00]

exp mrt0 off, v0, v0, off
// CHECK: [0x06,0x00,0x00,0xf8,0x00,0x00,0x00,0x00]

exp mrt0 v0, v0, v0, off
// CHECK: [0x07,0x00,0x00,0xf8,0x00,0x00,0x00,0x00]

exp mrt0 off, off, off, v0
// CHECK: [0x08,0x00,0x00,0xf8,0x00,0x00,0x00,0x00]

exp mrt0 v0, off, off, v0
// CHECK: [0x09,0x00,0x00,0xf8,0x00,0x00,0x00,0x00]

exp mrt0 off, v0, off, v0
// CHECK: [0x0a,0x00,0x00,0xf8,0x00,0x00,0x00,0x00]

exp mrt0 v0, v0, off, v0
// CHECK: [0x0b,0x00,0x00,0xf8,0x00,0x00,0x00,0x00]

exp mrt0 off, off, v0, v0
// CHECK: [0x0c,0x00,0x00,0xf8,0x00,0x00,0x00,0x00]

exp mrt0 v0, off, v0, v0
// CHECK: [0x0d,0x00,0x00,0xf8,0x00,0x00,0x00,0x00]

exp mrt0 off, v0, v0, v0
// CHECK: [0x0e,0x00,0x00,0xf8,0x00,0x00,0x00,0x00]

exp mrt0 off, off, off, off
// CHECK: [0x00,0x00,0x00,0xf8,0x00,0x00,0x00,0x00]

exp mrt0 v0, v0, v0, v0 done
// CHECK: [0x0f,0x08,0x00,0xf8,0x00,0x00,0x00,0x00]

exp mrt0 v0, v0, v0, v0 compr
// CHECK: [0x0f,0x04,0x00,0xf8,0x00,0x00,0x00,0x00]

exp mrt0 v0, v0, v0, v0 vm
// CHECK: [0x0f,0x10,0x00,0xf8,0x00,0x00,0x00,0x00]

flat_load_ubyte v5, v[1:2]
// CHECK: [0x00,0x00,0x20,0xdc,0x01,0x00,0x00,0x05]

flat_load_ubyte v255, v[1:2]
// CHECK: [0x00,0x00,0x20,0xdc,0x01,0x00,0x00,0xff]

flat_load_ubyte v5, v[254:255]
// CHECK: [0x00,0x00,0x20,0xdc,0xfe,0x00,0x00,0x05]

flat_load_ubyte v5, v[1:2] glc
// CHECK: [0x00,0x00,0x21,0xdc,0x01,0x00,0x00,0x05]

flat_load_ubyte v5, v[1:2] slc
// CHECK: [0x00,0x00,0x22,0xdc,0x01,0x00,0x00,0x05]

flat_load_sbyte v5, v[1:2]
// CHECK: [0x00,0x00,0x24,0xdc,0x01,0x00,0x00,0x05]

flat_load_sbyte v255, v[1:2]
// CHECK: [0x00,0x00,0x24,0xdc,0x01,0x00,0x00,0xff]

flat_load_sbyte v5, v[254:255]
// CHECK: [0x00,0x00,0x24,0xdc,0xfe,0x00,0x00,0x05]

flat_load_sbyte v5, v[1:2] glc
// CHECK: [0x00,0x00,0x25,0xdc,0x01,0x00,0x00,0x05]

flat_load_sbyte v5, v[1:2] slc
// CHECK: [0x00,0x00,0x26,0xdc,0x01,0x00,0x00,0x05]

flat_load_ushort v5, v[1:2]
// CHECK: [0x00,0x00,0x28,0xdc,0x01,0x00,0x00,0x05]

flat_load_ushort v255, v[1:2]
// CHECK: [0x00,0x00,0x28,0xdc,0x01,0x00,0x00,0xff]

flat_load_ushort v5, v[254:255]
// CHECK: [0x00,0x00,0x28,0xdc,0xfe,0x00,0x00,0x05]

flat_load_ushort v5, v[1:2] glc
// CHECK: [0x00,0x00,0x29,0xdc,0x01,0x00,0x00,0x05]

flat_load_ushort v5, v[1:2] slc
// CHECK: [0x00,0x00,0x2a,0xdc,0x01,0x00,0x00,0x05]

flat_load_sshort v5, v[1:2]
// CHECK: [0x00,0x00,0x2c,0xdc,0x01,0x00,0x00,0x05]

flat_load_sshort v255, v[1:2]
// CHECK: [0x00,0x00,0x2c,0xdc,0x01,0x00,0x00,0xff]

flat_load_sshort v5, v[254:255]
// CHECK: [0x00,0x00,0x2c,0xdc,0xfe,0x00,0x00,0x05]

flat_load_sshort v5, v[1:2] glc
// CHECK: [0x00,0x00,0x2d,0xdc,0x01,0x00,0x00,0x05]

flat_load_sshort v5, v[1:2] slc
// CHECK: [0x00,0x00,0x2e,0xdc,0x01,0x00,0x00,0x05]

flat_load_dword v5, v[1:2]
// CHECK: [0x00,0x00,0x30,0xdc,0x01,0x00,0x00,0x05]

flat_load_dword v255, v[1:2]
// CHECK: [0x00,0x00,0x30,0xdc,0x01,0x00,0x00,0xff]

flat_load_dword v5, v[254:255]
// CHECK: [0x00,0x00,0x30,0xdc,0xfe,0x00,0x00,0x05]

flat_load_dword v5, v[1:2] glc
// CHECK: [0x00,0x00,0x31,0xdc,0x01,0x00,0x00,0x05]

flat_load_dword v5, v[1:2] slc
// CHECK: [0x00,0x00,0x32,0xdc,0x01,0x00,0x00,0x05]

flat_load_dwordx2 v[5:6], v[1:2]
// CHECK: [0x00,0x00,0x34,0xdc,0x01,0x00,0x00,0x05]

flat_load_dwordx2 v[254:255], v[1:2]
// CHECK: [0x00,0x00,0x34,0xdc,0x01,0x00,0x00,0xfe]

flat_load_dwordx2 v[5:6], v[254:255]
// CHECK: [0x00,0x00,0x34,0xdc,0xfe,0x00,0x00,0x05]

flat_load_dwordx2 v[5:6], v[1:2] glc
// CHECK: [0x00,0x00,0x35,0xdc,0x01,0x00,0x00,0x05]

flat_load_dwordx2 v[5:6], v[1:2] slc
// CHECK: [0x00,0x00,0x36,0xdc,0x01,0x00,0x00,0x05]

flat_load_dwordx4 v[5:8], v[1:2]
// CHECK: [0x00,0x00,0x38,0xdc,0x01,0x00,0x00,0x05]

flat_load_dwordx4 v[252:255], v[1:2]
// CHECK: [0x00,0x00,0x38,0xdc,0x01,0x00,0x00,0xfc]

flat_load_dwordx4 v[5:8], v[254:255]
// CHECK: [0x00,0x00,0x38,0xdc,0xfe,0x00,0x00,0x05]

flat_load_dwordx4 v[5:8], v[1:2] glc
// CHECK: [0x00,0x00,0x39,0xdc,0x01,0x00,0x00,0x05]

flat_load_dwordx4 v[5:8], v[1:2] slc
// CHECK: [0x00,0x00,0x3a,0xdc,0x01,0x00,0x00,0x05]

flat_load_dwordx3 v[5:7], v[1:2]
// CHECK: [0x00,0x00,0x3c,0xdc,0x01,0x00,0x00,0x05]

flat_load_dwordx3 v[253:255], v[1:2]
// CHECK: [0x00,0x00,0x3c,0xdc,0x01,0x00,0x00,0xfd]

flat_load_dwordx3 v[5:7], v[254:255]
// CHECK: [0x00,0x00,0x3c,0xdc,0xfe,0x00,0x00,0x05]

flat_load_dwordx3 v[5:7], v[1:2] glc
// CHECK: [0x00,0x00,0x3d,0xdc,0x01,0x00,0x00,0x05]

flat_load_dwordx3 v[5:7], v[1:2] slc
// CHECK: [0x00,0x00,0x3e,0xdc,0x01,0x00,0x00,0x05]

flat_store_byte v[1:2], v2
// CHECK: [0x00,0x00,0x60,0xdc,0x01,0x02,0x00,0x00]

flat_store_byte v[254:255], v2
// CHECK: [0x00,0x00,0x60,0xdc,0xfe,0x02,0x00,0x00]

flat_store_byte v[1:2], v255
// CHECK: [0x00,0x00,0x60,0xdc,0x01,0xff,0x00,0x00]

flat_store_byte v[1:2], v2 glc
// CHECK: [0x00,0x00,0x61,0xdc,0x01,0x02,0x00,0x00]

flat_store_byte v[1:2], v2 slc
// CHECK: [0x00,0x00,0x62,0xdc,0x01,0x02,0x00,0x00]

flat_store_short v[1:2], v2
// CHECK: [0x00,0x00,0x68,0xdc,0x01,0x02,0x00,0x00]

flat_store_short v[254:255], v2
// CHECK: [0x00,0x00,0x68,0xdc,0xfe,0x02,0x00,0x00]

flat_store_short v[1:2], v255
// CHECK: [0x00,0x00,0x68,0xdc,0x01,0xff,0x00,0x00]

flat_store_short v[1:2], v2 glc
// CHECK: [0x00,0x00,0x69,0xdc,0x01,0x02,0x00,0x00]

flat_store_short v[1:2], v2 slc
// CHECK: [0x00,0x00,0x6a,0xdc,0x01,0x02,0x00,0x00]

flat_store_dword v[1:2], v2
// CHECK: [0x00,0x00,0x70,0xdc,0x01,0x02,0x00,0x00]

flat_store_dword v[254:255], v2
// CHECK: [0x00,0x00,0x70,0xdc,0xfe,0x02,0x00,0x00]

flat_store_dword v[1:2], v255
// CHECK: [0x00,0x00,0x70,0xdc,0x01,0xff,0x00,0x00]

flat_store_dword v[1:2], v2 glc
// CHECK: [0x00,0x00,0x71,0xdc,0x01,0x02,0x00,0x00]

flat_store_dword v[1:2], v2 slc
// CHECK: [0x00,0x00,0x72,0xdc,0x01,0x02,0x00,0x00]

flat_store_dwordx2 v[1:2], v[2:3]
// CHECK: [0x00,0x00,0x74,0xdc,0x01,0x02,0x00,0x00]

flat_store_dwordx2 v[254:255], v[2:3]
// CHECK: [0x00,0x00,0x74,0xdc,0xfe,0x02,0x00,0x00]

flat_store_dwordx2 v[1:2], v[254:255]
// CHECK: [0x00,0x00,0x74,0xdc,0x01,0xfe,0x00,0x00]

flat_store_dwordx2 v[1:2], v[2:3] glc
// CHECK: [0x00,0x00,0x75,0xdc,0x01,0x02,0x00,0x00]

flat_store_dwordx2 v[1:2], v[2:3] slc
// CHECK: [0x00,0x00,0x76,0xdc,0x01,0x02,0x00,0x00]

flat_store_dwordx4 v[1:2], v[2:5]
// CHECK: [0x00,0x00,0x78,0xdc,0x01,0x02,0x00,0x00]

flat_store_dwordx4 v[254:255], v[2:5]
// CHECK: [0x00,0x00,0x78,0xdc,0xfe,0x02,0x00,0x00]

flat_store_dwordx4 v[1:2], v[252:255]
// CHECK: [0x00,0x00,0x78,0xdc,0x01,0xfc,0x00,0x00]

flat_store_dwordx4 v[1:2], v[2:5] glc
// CHECK: [0x00,0x00,0x79,0xdc,0x01,0x02,0x00,0x00]

flat_store_dwordx4 v[1:2], v[2:5] slc
// CHECK: [0x00,0x00,0x7a,0xdc,0x01,0x02,0x00,0x00]

flat_store_dwordx3 v[1:2], v[2:4]
// CHECK: [0x00,0x00,0x7c,0xdc,0x01,0x02,0x00,0x00]

flat_store_dwordx3 v[254:255], v[2:4]
// CHECK: [0x00,0x00,0x7c,0xdc,0xfe,0x02,0x00,0x00]

flat_store_dwordx3 v[1:2], v[253:255]
// CHECK: [0x00,0x00,0x7c,0xdc,0x01,0xfd,0x00,0x00]

flat_store_dwordx3 v[1:2], v[2:4] glc
// CHECK: [0x00,0x00,0x7d,0xdc,0x01,0x02,0x00,0x00]

flat_store_dwordx3 v[1:2], v[2:4] slc
// CHECK: [0x00,0x00,0x7e,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_swap v[1:2], v2
// CHECK: [0x00,0x00,0xc0,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_swap v[254:255], v2
// CHECK: [0x00,0x00,0xc0,0xdc,0xfe,0x02,0x00,0x00]

flat_atomic_swap v[1:2], v255
// CHECK: [0x00,0x00,0xc0,0xdc,0x01,0xff,0x00,0x00]

flat_atomic_swap v0, v[1:2], v2 glc
// CHECK: [0x00,0x00,0xc1,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_swap v[1:2], v2 slc
// CHECK: [0x00,0x00,0xc2,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_cmpswap v[1:2], v[2:3]
// CHECK: [0x00,0x00,0xc4,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_cmpswap v[254:255], v[2:3]
// CHECK: [0x00,0x00,0xc4,0xdc,0xfe,0x02,0x00,0x00]

flat_atomic_cmpswap v[1:2], v[254:255]
// CHECK: [0x00,0x00,0xc4,0xdc,0x01,0xfe,0x00,0x00]

flat_atomic_cmpswap v0, v[1:2], v[2:3] glc
// CHECK: [0x00,0x00,0xc5,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_cmpswap v[1:2], v[2:3] slc
// CHECK: [0x00,0x00,0xc6,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_add v[1:2], v2
// CHECK: [0x00,0x00,0xc8,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_add v[254:255], v2
// CHECK: [0x00,0x00,0xc8,0xdc,0xfe,0x02,0x00,0x00]

flat_atomic_add v[1:2], v255
// CHECK: [0x00,0x00,0xc8,0xdc,0x01,0xff,0x00,0x00]

flat_atomic_add v0, v[1:2], v2 glc
// CHECK: [0x00,0x00,0xc9,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_add v[1:2], v2 slc
// CHECK: [0x00,0x00,0xca,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_sub v[1:2], v2
// CHECK: [0x00,0x00,0xcc,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_sub v[254:255], v2
// CHECK: [0x00,0x00,0xcc,0xdc,0xfe,0x02,0x00,0x00]

flat_atomic_sub v[1:2], v255
// CHECK: [0x00,0x00,0xcc,0xdc,0x01,0xff,0x00,0x00]

flat_atomic_sub v0, v[1:2], v2 glc
// CHECK: [0x00,0x00,0xcd,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_sub v[1:2], v2 slc
// CHECK: [0x00,0x00,0xce,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_smin v[1:2], v2
// CHECK: [0x00,0x00,0xd4,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_smin v[254:255], v2
// CHECK: [0x00,0x00,0xd4,0xdc,0xfe,0x02,0x00,0x00]

flat_atomic_smin v[1:2], v255
// CHECK: [0x00,0x00,0xd4,0xdc,0x01,0xff,0x00,0x00]

flat_atomic_smin v0, v[1:2], v2 glc
// CHECK: [0x00,0x00,0xd5,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_smin v[1:2], v2 slc
// CHECK: [0x00,0x00,0xd6,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_umin v[1:2], v2
// CHECK: [0x00,0x00,0xd8,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_umin v[254:255], v2
// CHECK: [0x00,0x00,0xd8,0xdc,0xfe,0x02,0x00,0x00]

flat_atomic_umin v[1:2], v255
// CHECK: [0x00,0x00,0xd8,0xdc,0x01,0xff,0x00,0x00]

flat_atomic_umin v0, v[1:2], v2 glc
// CHECK: [0x00,0x00,0xd9,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_umin v[1:2], v2 slc
// CHECK: [0x00,0x00,0xda,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_smax v[1:2], v2
// CHECK: [0x00,0x00,0xdc,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_smax v[254:255], v2
// CHECK: [0x00,0x00,0xdc,0xdc,0xfe,0x02,0x00,0x00]

flat_atomic_smax v[1:2], v255
// CHECK: [0x00,0x00,0xdc,0xdc,0x01,0xff,0x00,0x00]

flat_atomic_smax v0, v[1:2], v2 glc
// CHECK: [0x00,0x00,0xdd,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_smax v[1:2], v2 slc
// CHECK: [0x00,0x00,0xde,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_umax v[1:2], v2
// CHECK: [0x00,0x00,0xe0,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_umax v[254:255], v2
// CHECK: [0x00,0x00,0xe0,0xdc,0xfe,0x02,0x00,0x00]

flat_atomic_umax v[1:2], v255
// CHECK: [0x00,0x00,0xe0,0xdc,0x01,0xff,0x00,0x00]

flat_atomic_umax v0, v[1:2], v2 glc
// CHECK: [0x00,0x00,0xe1,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_umax v[1:2], v2 slc
// CHECK: [0x00,0x00,0xe2,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_and v[1:2], v2
// CHECK: [0x00,0x00,0xe4,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_and v[254:255], v2
// CHECK: [0x00,0x00,0xe4,0xdc,0xfe,0x02,0x00,0x00]

flat_atomic_and v[1:2], v255
// CHECK: [0x00,0x00,0xe4,0xdc,0x01,0xff,0x00,0x00]

flat_atomic_and v0, v[1:2], v2 glc
// CHECK: [0x00,0x00,0xe5,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_and v[1:2], v2 slc
// CHECK: [0x00,0x00,0xe6,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_or v[1:2], v2
// CHECK: [0x00,0x00,0xe8,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_or v[254:255], v2
// CHECK: [0x00,0x00,0xe8,0xdc,0xfe,0x02,0x00,0x00]

flat_atomic_or v[1:2], v255
// CHECK: [0x00,0x00,0xe8,0xdc,0x01,0xff,0x00,0x00]

flat_atomic_or v0, v[1:2], v2 glc
// CHECK: [0x00,0x00,0xe9,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_or v[1:2], v2 slc
// CHECK: [0x00,0x00,0xea,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_xor v[1:2], v2
// CHECK: [0x00,0x00,0xec,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_xor v[254:255], v2
// CHECK: [0x00,0x00,0xec,0xdc,0xfe,0x02,0x00,0x00]

flat_atomic_xor v[1:2], v255
// CHECK: [0x00,0x00,0xec,0xdc,0x01,0xff,0x00,0x00]

flat_atomic_xor v0, v[1:2], v2 glc
// CHECK: [0x00,0x00,0xed,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_xor v[1:2], v2 slc
// CHECK: [0x00,0x00,0xee,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_inc v[1:2], v2
// CHECK: [0x00,0x00,0xf0,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_inc v[254:255], v2
// CHECK: [0x00,0x00,0xf0,0xdc,0xfe,0x02,0x00,0x00]

flat_atomic_inc v[1:2], v255
// CHECK: [0x00,0x00,0xf0,0xdc,0x01,0xff,0x00,0x00]

flat_atomic_inc v0, v[1:2], v2 glc
// CHECK: [0x00,0x00,0xf1,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_inc v[1:2], v2 slc
// CHECK: [0x00,0x00,0xf2,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_dec v[1:2], v2
// CHECK: [0x00,0x00,0xf4,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_dec v[254:255], v2
// CHECK: [0x00,0x00,0xf4,0xdc,0xfe,0x02,0x00,0x00]

flat_atomic_dec v[1:2], v255
// CHECK: [0x00,0x00,0xf4,0xdc,0x01,0xff,0x00,0x00]

flat_atomic_dec v0, v[1:2], v2 glc
// CHECK: [0x00,0x00,0xf5,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_dec v[1:2], v2 slc
// CHECK: [0x00,0x00,0xf6,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_fcmpswap v[1:2], v[2:3]
// CHECK: [0x00,0x00,0xf8,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_fcmpswap v[254:255], v[2:3]
// CHECK: [0x00,0x00,0xf8,0xdc,0xfe,0x02,0x00,0x00]

flat_atomic_fcmpswap v[1:2], v[254:255]
// CHECK: [0x00,0x00,0xf8,0xdc,0x01,0xfe,0x00,0x00]

flat_atomic_fcmpswap v0, v[1:2], v[2:3] glc
// CHECK: [0x00,0x00,0xf9,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_fcmpswap v[1:2], v[2:3] slc
// CHECK: [0x00,0x00,0xfa,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_fmin v[1:2], v2
// CHECK: [0x00,0x00,0xfc,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_fmin v[254:255], v2
// CHECK: [0x00,0x00,0xfc,0xdc,0xfe,0x02,0x00,0x00]

flat_atomic_fmin v[1:2], v255
// CHECK: [0x00,0x00,0xfc,0xdc,0x01,0xff,0x00,0x00]

flat_atomic_fmin v0, v[1:2], v2 glc
// CHECK: [0x00,0x00,0xfd,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_fmin v[1:2], v2 slc
// CHECK: [0x00,0x00,0xfe,0xdc,0x01,0x02,0x00,0x00]

flat_atomic_fmax v[1:2], v2
// CHECK: [0x00,0x00,0x00,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_fmax v[254:255], v2
// CHECK: [0x00,0x00,0x00,0xdd,0xfe,0x02,0x00,0x00]

flat_atomic_fmax v[1:2], v255
// CHECK: [0x00,0x00,0x00,0xdd,0x01,0xff,0x00,0x00]

flat_atomic_fmax v0, v[1:2], v2 glc
// CHECK: [0x00,0x00,0x01,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_fmax v[1:2], v2 slc
// CHECK: [0x00,0x00,0x02,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_swap_x2 v[1:2], v[2:3]
// CHECK: [0x00,0x00,0x40,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_swap_x2 v[254:255], v[2:3]
// CHECK: [0x00,0x00,0x40,0xdd,0xfe,0x02,0x00,0x00]

flat_atomic_swap_x2 v[1:2], v[254:255]
// CHECK: [0x00,0x00,0x40,0xdd,0x01,0xfe,0x00,0x00]

flat_atomic_swap_x2 v[0:1], v[1:2], v[2:3] glc
// CHECK: [0x00,0x00,0x41,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_swap_x2 v[1:2], v[2:3] slc
// CHECK: [0x00,0x00,0x42,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_cmpswap_x2 v[1:2], v[2:5]
// CHECK: [0x00,0x00,0x44,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_cmpswap_x2 v[254:255], v[2:5]
// CHECK: [0x00,0x00,0x44,0xdd,0xfe,0x02,0x00,0x00]

flat_atomic_cmpswap_x2 v[1:2], v[252:255]
// CHECK: [0x00,0x00,0x44,0xdd,0x01,0xfc,0x00,0x00]

flat_atomic_cmpswap_x2 v[0:1], v[1:2], v[2:5] glc
// CHECK: [0x00,0x00,0x45,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_cmpswap_x2 v[1:2], v[2:5] slc
// CHECK: [0x00,0x00,0x46,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_add_x2 v[1:2], v[2:3]
// CHECK: [0x00,0x00,0x48,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_add_x2 v[254:255], v[2:3]
// CHECK: [0x00,0x00,0x48,0xdd,0xfe,0x02,0x00,0x00]

flat_atomic_add_x2 v[1:2], v[254:255]
// CHECK: [0x00,0x00,0x48,0xdd,0x01,0xfe,0x00,0x00]

flat_atomic_add_x2 v[0:1], v[1:2], v[2:3] glc
// CHECK: [0x00,0x00,0x49,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_add_x2 v[1:2], v[2:3] slc
// CHECK: [0x00,0x00,0x4a,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_sub_x2 v[1:2], v[2:3]
// CHECK: [0x00,0x00,0x4c,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_sub_x2 v[254:255], v[2:3]
// CHECK: [0x00,0x00,0x4c,0xdd,0xfe,0x02,0x00,0x00]

flat_atomic_sub_x2 v[1:2], v[254:255]
// CHECK: [0x00,0x00,0x4c,0xdd,0x01,0xfe,0x00,0x00]

flat_atomic_sub_x2 v[0:1], v[1:2], v[2:3] glc
// CHECK: [0x00,0x00,0x4d,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_sub_x2 v[1:2], v[2:3] slc
// CHECK: [0x00,0x00,0x4e,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_smin_x2 v[1:2], v[2:3]
// CHECK: [0x00,0x00,0x54,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_smin_x2 v[254:255], v[2:3]
// CHECK: [0x00,0x00,0x54,0xdd,0xfe,0x02,0x00,0x00]

flat_atomic_smin_x2 v[1:2], v[254:255]
// CHECK: [0x00,0x00,0x54,0xdd,0x01,0xfe,0x00,0x00]

flat_atomic_smin_x2 v[0:1], v[1:2], v[2:3] glc
// CHECK: [0x00,0x00,0x55,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_smin_x2 v[1:2], v[2:3] slc
// CHECK: [0x00,0x00,0x56,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_umin_x2 v[1:2], v[2:3]
// CHECK: [0x00,0x00,0x58,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_umin_x2 v[254:255], v[2:3]
// CHECK: [0x00,0x00,0x58,0xdd,0xfe,0x02,0x00,0x00]

flat_atomic_umin_x2 v[1:2], v[254:255]
// CHECK: [0x00,0x00,0x58,0xdd,0x01,0xfe,0x00,0x00]

flat_atomic_umin_x2 v[0:1], v[1:2], v[2:3] glc
// CHECK: [0x00,0x00,0x59,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_umin_x2 v[1:2], v[2:3] slc
// CHECK: [0x00,0x00,0x5a,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_smax_x2 v[1:2], v[2:3]
// CHECK: [0x00,0x00,0x5c,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_smax_x2 v[254:255], v[2:3]
// CHECK: [0x00,0x00,0x5c,0xdd,0xfe,0x02,0x00,0x00]

flat_atomic_smax_x2 v[1:2], v[254:255]
// CHECK: [0x00,0x00,0x5c,0xdd,0x01,0xfe,0x00,0x00]

flat_atomic_smax_x2 v[0:1], v[1:2], v[2:3] glc
// CHECK: [0x00,0x00,0x5d,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_smax_x2 v[1:2], v[2:3] slc
// CHECK: [0x00,0x00,0x5e,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_umax_x2 v[1:2], v[2:3]
// CHECK: [0x00,0x00,0x60,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_umax_x2 v[254:255], v[2:3]
// CHECK: [0x00,0x00,0x60,0xdd,0xfe,0x02,0x00,0x00]

flat_atomic_umax_x2 v[1:2], v[254:255]
// CHECK: [0x00,0x00,0x60,0xdd,0x01,0xfe,0x00,0x00]

flat_atomic_umax_x2 v[0:1], v[1:2], v[2:3] glc
// CHECK: [0x00,0x00,0x61,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_umax_x2 v[1:2], v[2:3] slc
// CHECK: [0x00,0x00,0x62,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_and_x2 v[1:2], v[2:3]
// CHECK: [0x00,0x00,0x64,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_and_x2 v[254:255], v[2:3]
// CHECK: [0x00,0x00,0x64,0xdd,0xfe,0x02,0x00,0x00]

flat_atomic_and_x2 v[1:2], v[254:255]
// CHECK: [0x00,0x00,0x64,0xdd,0x01,0xfe,0x00,0x00]

flat_atomic_and_x2 v[0:1], v[1:2], v[2:3] glc
// CHECK: [0x00,0x00,0x65,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_and_x2 v[1:2], v[2:3] slc
// CHECK: [0x00,0x00,0x66,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_or_x2 v[1:2], v[2:3]
// CHECK: [0x00,0x00,0x68,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_or_x2 v[254:255], v[2:3]
// CHECK: [0x00,0x00,0x68,0xdd,0xfe,0x02,0x00,0x00]

flat_atomic_or_x2 v[1:2], v[254:255]
// CHECK: [0x00,0x00,0x68,0xdd,0x01,0xfe,0x00,0x00]

flat_atomic_or_x2 v[0:1], v[1:2], v[2:3] glc
// CHECK: [0x00,0x00,0x69,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_or_x2 v[1:2], v[2:3] slc
// CHECK: [0x00,0x00,0x6a,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_xor_x2 v[1:2], v[2:3]
// CHECK: [0x00,0x00,0x6c,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_xor_x2 v[254:255], v[2:3]
// CHECK: [0x00,0x00,0x6c,0xdd,0xfe,0x02,0x00,0x00]

flat_atomic_xor_x2 v[1:2], v[254:255]
// CHECK: [0x00,0x00,0x6c,0xdd,0x01,0xfe,0x00,0x00]

flat_atomic_xor_x2 v[0:1], v[1:2], v[2:3] glc
// CHECK: [0x00,0x00,0x6d,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_xor_x2 v[1:2], v[2:3] slc
// CHECK: [0x00,0x00,0x6e,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_inc_x2 v[1:2], v[2:3]
// CHECK: [0x00,0x00,0x70,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_inc_x2 v[254:255], v[2:3]
// CHECK: [0x00,0x00,0x70,0xdd,0xfe,0x02,0x00,0x00]

flat_atomic_inc_x2 v[1:2], v[254:255]
// CHECK: [0x00,0x00,0x70,0xdd,0x01,0xfe,0x00,0x00]

flat_atomic_inc_x2 v[0:1], v[1:2], v[2:3] glc
// CHECK: [0x00,0x00,0x71,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_inc_x2 v[1:2], v[2:3] slc
// CHECK: [0x00,0x00,0x72,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_dec_x2 v[1:2], v[2:3]
// CHECK: [0x00,0x00,0x74,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_dec_x2 v[254:255], v[2:3]
// CHECK: [0x00,0x00,0x74,0xdd,0xfe,0x02,0x00,0x00]

flat_atomic_dec_x2 v[1:2], v[254:255]
// CHECK: [0x00,0x00,0x74,0xdd,0x01,0xfe,0x00,0x00]

flat_atomic_dec_x2 v[0:1], v[1:2], v[2:3] glc
// CHECK: [0x00,0x00,0x75,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_dec_x2 v[1:2], v[2:3] slc
// CHECK: [0x00,0x00,0x76,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_fcmpswap_x2 v[1:2], v[2:5]
// CHECK: [0x00,0x00,0x78,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_fcmpswap_x2 v[254:255], v[2:5]
// CHECK: [0x00,0x00,0x78,0xdd,0xfe,0x02,0x00,0x00]

flat_atomic_fcmpswap_x2 v[1:2], v[252:255]
// CHECK: [0x00,0x00,0x78,0xdd,0x01,0xfc,0x00,0x00]

flat_atomic_fcmpswap_x2 v[0:1], v[1:2], v[2:5] glc
// CHECK: [0x00,0x00,0x79,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_fcmpswap_x2 v[1:2], v[2:5] slc
// CHECK: [0x00,0x00,0x7a,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_fmin_x2 v[1:2], v[2:3]
// CHECK: [0x00,0x00,0x7c,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_fmin_x2 v[254:255], v[2:3]
// CHECK: [0x00,0x00,0x7c,0xdd,0xfe,0x02,0x00,0x00]

flat_atomic_fmin_x2 v[1:2], v[254:255]
// CHECK: [0x00,0x00,0x7c,0xdd,0x01,0xfe,0x00,0x00]

flat_atomic_fmin_x2 v[0:1], v[1:2], v[2:3] glc
// CHECK: [0x00,0x00,0x7d,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_fmin_x2 v[1:2], v[2:3] slc
// CHECK: [0x00,0x00,0x7e,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_fmax_x2 v[1:2], v[2:3]
// CHECK: [0x00,0x00,0x80,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_fmax_x2 v[254:255], v[2:3]
// CHECK: [0x00,0x00,0x80,0xdd,0xfe,0x02,0x00,0x00]

flat_atomic_fmax_x2 v[1:2], v[254:255]
// CHECK: [0x00,0x00,0x80,0xdd,0x01,0xfe,0x00,0x00]

flat_atomic_fmax_x2 v[0:1], v[1:2], v[2:3] glc
// CHECK: [0x00,0x00,0x81,0xdd,0x01,0x02,0x00,0x00]

flat_atomic_fmax_x2 v[1:2], v[2:3] slc
// CHECK: [0x00,0x00,0x82,0xdd,0x01,0x02,0x00,0x00]

image_load v5, v[1:4], s[8:15] dmask:0x1
// CHECK: [0x00,0x01,0x00,0xf0,0x01,0x05,0x02,0x00]

image_load v252, v[1:4], s[8:15] dmask:0x1
// CHECK: [0x00,0x01,0x00,0xf0,0x01,0xfc,0x02,0x00]

image_load v5, v[252:255], s[8:15] dmask:0x1
// CHECK: [0x00,0x01,0x00,0xf0,0xfc,0x05,0x02,0x00]

image_load v5, v[1:4], s[12:19] dmask:0x1
// CHECK: [0x00,0x01,0x00,0xf0,0x01,0x05,0x03,0x00]

image_load v5, v[1:4], s[96:103] dmask:0x1
// CHECK: [0x00,0x01,0x00,0xf0,0x01,0x05,0x18,0x00]

image_load v5, v[1:4], ttmp[4:11] dmask:0x1
// CHECK: [0x00,0x01,0x00,0xf0,0x01,0x05,0x1d,0x00]

image_load v5, v[1:4], s[8:15] dmask:0x2
// CHECK: [0x00,0x02,0x00,0xf0,0x01,0x05,0x02,0x00]

image_load v[5:6], v[1:4], s[8:15] dmask:0x3
// CHECK: [0x00,0x03,0x00,0xf0,0x01,0x05,0x02,0x00]

image_load v5, v[1:4], s[8:15] dmask:0x4
// CHECK: [0x00,0x04,0x00,0xf0,0x01,0x05,0x02,0x00]

image_load v[5:6], v[1:4], s[8:15] dmask:0x5
// CHECK: [0x00,0x05,0x00,0xf0,0x01,0x05,0x02,0x00]

image_load v[5:6], v[1:4], s[8:15] dmask:0x6
// CHECK: [0x00,0x06,0x00,0xf0,0x01,0x05,0x02,0x00]

image_load v[5:7], v[1:4], s[8:15] dmask:0x7
// CHECK: [0x00,0x07,0x00,0xf0,0x01,0x05,0x02,0x00]

image_load v5, v[1:4], s[8:15] dmask:0x8
// CHECK: [0x00,0x08,0x00,0xf0,0x01,0x05,0x02,0x00]

image_load v[5:6], v[1:4], s[8:15] dmask:0x9
// CHECK: [0x00,0x09,0x00,0xf0,0x01,0x05,0x02,0x00]

image_load v[5:6], v[1:4], s[8:15] dmask:0xa
// CHECK: [0x00,0x0a,0x00,0xf0,0x01,0x05,0x02,0x00]

image_load v[5:7], v[1:4], s[8:15] dmask:0xb
// CHECK: [0x00,0x0b,0x00,0xf0,0x01,0x05,0x02,0x00]

image_load v[5:6], v[1:4], s[8:15] dmask:0xc
// CHECK: [0x00,0x0c,0x00,0xf0,0x01,0x05,0x02,0x00]

image_load v[5:7], v[1:4], s[8:15] dmask:0xd
// CHECK: [0x00,0x0d,0x00,0xf0,0x01,0x05,0x02,0x00]

image_load v[5:7], v[1:4], s[8:15] dmask:0xe
// CHECK: [0x00,0x0e,0x00,0xf0,0x01,0x05,0x02,0x00]

image_load v5, v[1:4], s[8:15] dmask:0x0
// CHECK: [0x00,0x00,0x00,0xf0,0x01,0x05,0x02,0x00]

image_load v5, v[1:4], s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x00,0xf0,0x01,0x05,0x02,0x00]

image_load v5, v[1:4], s[8:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0x00,0xf0,0x01,0x05,0x02,0x00]

image_load v5, v[1:4], s[8:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0x00,0xf2,0x01,0x05,0x02,0x00]

image_load v[5:6], v[1:4], s[8:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0x01,0xf0,0x01,0x05,0x02,0x00]

image_load v5, v[1:4], s[8:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0x02,0xf0,0x01,0x05,0x02,0x00]

image_load v5, v[1:4], s[8:15] dmask:0x1 da
// CHECK: [0x00,0x41,0x00,0xf0,0x01,0x05,0x02,0x00]

image_load_mip v5, v[1:4], s[8:15] dmask:0x1
// CHECK: [0x00,0x01,0x04,0xf0,0x01,0x05,0x02,0x00]

image_load_mip v252, v[1:4], s[8:15] dmask:0x1
// CHECK: [0x00,0x01,0x04,0xf0,0x01,0xfc,0x02,0x00]

image_load_mip v5, v[252:255], s[8:15] dmask:0x1
// CHECK: [0x00,0x01,0x04,0xf0,0xfc,0x05,0x02,0x00]

image_load_mip v5, v[1:4], s[12:19] dmask:0x1
// CHECK: [0x00,0x01,0x04,0xf0,0x01,0x05,0x03,0x00]

image_load_mip v5, v[1:4], s[96:103] dmask:0x1
// CHECK: [0x00,0x01,0x04,0xf0,0x01,0x05,0x18,0x00]

image_load_mip v5, v[1:4], ttmp[4:11] dmask:0x1
// CHECK: [0x00,0x01,0x04,0xf0,0x01,0x05,0x1d,0x00]

image_load_mip v5, v[1:4], s[8:15] dmask:0x2
// CHECK: [0x00,0x02,0x04,0xf0,0x01,0x05,0x02,0x00]

image_load_mip v[5:6], v[1:4], s[8:15] dmask:0x3
// CHECK: [0x00,0x03,0x04,0xf0,0x01,0x05,0x02,0x00]

image_load_mip v5, v[1:4], s[8:15] dmask:0x4
// CHECK: [0x00,0x04,0x04,0xf0,0x01,0x05,0x02,0x00]

image_load_mip v[5:6], v[1:4], s[8:15] dmask:0x5
// CHECK: [0x00,0x05,0x04,0xf0,0x01,0x05,0x02,0x00]

image_load_mip v[5:6], v[1:4], s[8:15] dmask:0x6
// CHECK: [0x00,0x06,0x04,0xf0,0x01,0x05,0x02,0x00]

image_load_mip v[5:7], v[1:4], s[8:15] dmask:0x7
// CHECK: [0x00,0x07,0x04,0xf0,0x01,0x05,0x02,0x00]

image_load_mip v5, v[1:4], s[8:15] dmask:0x8
// CHECK: [0x00,0x08,0x04,0xf0,0x01,0x05,0x02,0x00]

image_load_mip v[5:6], v[1:4], s[8:15] dmask:0x9
// CHECK: [0x00,0x09,0x04,0xf0,0x01,0x05,0x02,0x00]

image_load_mip v[5:6], v[1:4], s[8:15] dmask:0xa
// CHECK: [0x00,0x0a,0x04,0xf0,0x01,0x05,0x02,0x00]

image_load_mip v[5:7], v[1:4], s[8:15] dmask:0xb
// CHECK: [0x00,0x0b,0x04,0xf0,0x01,0x05,0x02,0x00]

image_load_mip v[5:6], v[1:4], s[8:15] dmask:0xc
// CHECK: [0x00,0x0c,0x04,0xf0,0x01,0x05,0x02,0x00]

image_load_mip v[5:7], v[1:4], s[8:15] dmask:0xd
// CHECK: [0x00,0x0d,0x04,0xf0,0x01,0x05,0x02,0x00]

image_load_mip v[5:7], v[1:4], s[8:15] dmask:0xe
// CHECK: [0x00,0x0e,0x04,0xf0,0x01,0x05,0x02,0x00]

image_load_mip v5, v[1:4], s[8:15] dmask:0x0
// CHECK: [0x00,0x00,0x04,0xf0,0x01,0x05,0x02,0x00]

image_load_mip v5, v[1:4], s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x04,0xf0,0x01,0x05,0x02,0x00]

image_load_mip v5, v[1:4], s[8:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0x04,0xf0,0x01,0x05,0x02,0x00]

image_load_mip v5, v[1:4], s[8:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0x04,0xf2,0x01,0x05,0x02,0x00]

image_load_mip v[5:6], v[1:4], s[8:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0x05,0xf0,0x01,0x05,0x02,0x00]

image_load_mip v5, v[1:4], s[8:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0x06,0xf0,0x01,0x05,0x02,0x00]

image_load_mip v5, v[1:4], s[8:15] dmask:0x1 da
// CHECK: [0x00,0x41,0x04,0xf0,0x01,0x05,0x02,0x00]

image_store v1, v[2:5], s[12:19] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x20,0xf0,0x02,0x01,0x03,0x00]

image_store v252, v[2:5], s[12:19] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x20,0xf0,0x02,0xfc,0x03,0x00]

image_store v1, v[252:255], s[12:19] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x20,0xf0,0xfc,0x01,0x03,0x00]

image_store v1, v[2:5], s[16:23] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x20,0xf0,0x02,0x01,0x04,0x00]

image_store v1, v[2:5], s[96:103] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x20,0xf0,0x02,0x01,0x18,0x00]

image_store v1, v[2:5], ttmp[4:11] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x20,0xf0,0x02,0x01,0x1d,0x00]

image_store v1, v[2:5], s[12:19] dmask:0x2 unorm
// CHECK: [0x00,0x12,0x20,0xf0,0x02,0x01,0x03,0x00]

image_store v[1:2], v[2:5], s[12:19] dmask:0x3 unorm
// CHECK: [0x00,0x13,0x20,0xf0,0x02,0x01,0x03,0x00]

image_store v1, v[2:5], s[12:19] dmask:0x4 unorm
// CHECK: [0x00,0x14,0x20,0xf0,0x02,0x01,0x03,0x00]

image_store v[1:2], v[2:5], s[12:19] dmask:0x5 unorm
// CHECK: [0x00,0x15,0x20,0xf0,0x02,0x01,0x03,0x00]

image_store v[1:2], v[2:5], s[12:19] dmask:0x6 unorm
// CHECK: [0x00,0x16,0x20,0xf0,0x02,0x01,0x03,0x00]

image_store v[1:3], v[2:5], s[12:19] dmask:0x7 unorm
// CHECK: [0x00,0x17,0x20,0xf0,0x02,0x01,0x03,0x00]

image_store v1, v[2:5], s[12:19] dmask:0x8 unorm
// CHECK: [0x00,0x18,0x20,0xf0,0x02,0x01,0x03,0x00]

image_store v[1:2], v[2:5], s[12:19] dmask:0x9 unorm
// CHECK: [0x00,0x19,0x20,0xf0,0x02,0x01,0x03,0x00]

image_store v[1:2], v[2:5], s[12:19] dmask:0xa unorm
// CHECK: [0x00,0x1a,0x20,0xf0,0x02,0x01,0x03,0x00]

image_store v[1:3], v[2:5], s[12:19] dmask:0xb unorm
// CHECK: [0x00,0x1b,0x20,0xf0,0x02,0x01,0x03,0x00]

image_store v[1:2], v[2:5], s[12:19] dmask:0xc unorm
// CHECK: [0x00,0x1c,0x20,0xf0,0x02,0x01,0x03,0x00]

image_store v[1:3], v[2:5], s[12:19] dmask:0xd unorm
// CHECK: [0x00,0x1d,0x20,0xf0,0x02,0x01,0x03,0x00]

image_store v[1:3], v[2:5], s[12:19] dmask:0xe unorm
// CHECK: [0x00,0x1e,0x20,0xf0,0x02,0x01,0x03,0x00]

image_store v[1:4], v[2:5], s[12:19] dmask:0xf unorm
// CHECK: [0x00,0x1f,0x20,0xf0,0x02,0x01,0x03,0x00]

image_store v1, v[2:5], s[12:19] dmask:0x0 unorm
// CHECK: [0x00,0x10,0x20,0xf0,0x02,0x01,0x03,0x00]

image_store v1, v[2:5], s[12:19] dmask:0x1 unorm glc
// CHECK: [0x00,0x31,0x20,0xf0,0x02,0x01,0x03,0x00]

image_store v1, v[2:5], s[12:19] dmask:0x1 unorm slc
// CHECK: [0x00,0x11,0x20,0xf2,0x02,0x01,0x03,0x00]

image_store v1, v[2:5], s[12:19] dmask:0x1 unorm lwe
// CHECK: [0x00,0x11,0x22,0xf0,0x02,0x01,0x03,0x00]

image_store v1, v[2:5], s[12:19] dmask:0x1 unorm da
// CHECK: [0x00,0x51,0x20,0xf0,0x02,0x01,0x03,0x00]

image_store_mip v1, v[2:5], s[12:19] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x24,0xf0,0x02,0x01,0x03,0x00]

image_store_mip v252, v[2:5], s[12:19] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x24,0xf0,0x02,0xfc,0x03,0x00]

image_store_mip v1, v[252:255], s[12:19] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x24,0xf0,0xfc,0x01,0x03,0x00]

image_store_mip v1, v[2:5], s[16:23] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x24,0xf0,0x02,0x01,0x04,0x00]

image_store_mip v1, v[2:5], s[96:103] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x24,0xf0,0x02,0x01,0x18,0x00]

image_store_mip v1, v[2:5], ttmp[4:11] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x24,0xf0,0x02,0x01,0x1d,0x00]

image_store_mip v1, v[2:5], s[12:19] dmask:0x2 unorm
// CHECK: [0x00,0x12,0x24,0xf0,0x02,0x01,0x03,0x00]

image_store_mip v[1:2], v[2:5], s[12:19] dmask:0x3 unorm
// CHECK: [0x00,0x13,0x24,0xf0,0x02,0x01,0x03,0x00]

image_store_mip v1, v[2:5], s[12:19] dmask:0x4 unorm
// CHECK: [0x00,0x14,0x24,0xf0,0x02,0x01,0x03,0x00]

image_store_mip v[1:2], v[2:5], s[12:19] dmask:0x5 unorm
// CHECK: [0x00,0x15,0x24,0xf0,0x02,0x01,0x03,0x00]

image_store_mip v[1:2], v[2:5], s[12:19] dmask:0x6 unorm
// CHECK: [0x00,0x16,0x24,0xf0,0x02,0x01,0x03,0x00]

image_store_mip v[1:3], v[2:5], s[12:19] dmask:0x7 unorm
// CHECK: [0x00,0x17,0x24,0xf0,0x02,0x01,0x03,0x00]

image_store_mip v1, v[2:5], s[12:19] dmask:0x8 unorm
// CHECK: [0x00,0x18,0x24,0xf0,0x02,0x01,0x03,0x00]

image_store_mip v[1:2], v[2:5], s[12:19] dmask:0x9 unorm
// CHECK: [0x00,0x19,0x24,0xf0,0x02,0x01,0x03,0x00]

image_store_mip v[1:2], v[2:5], s[12:19] dmask:0xa unorm
// CHECK: [0x00,0x1a,0x24,0xf0,0x02,0x01,0x03,0x00]

image_store_mip v[1:3], v[2:5], s[12:19] dmask:0xb unorm
// CHECK: [0x00,0x1b,0x24,0xf0,0x02,0x01,0x03,0x00]

image_store_mip v[1:2], v[2:5], s[12:19] dmask:0xc unorm
// CHECK: [0x00,0x1c,0x24,0xf0,0x02,0x01,0x03,0x00]

image_store_mip v[1:3], v[2:5], s[12:19] dmask:0xd unorm
// CHECK: [0x00,0x1d,0x24,0xf0,0x02,0x01,0x03,0x00]

image_store_mip v[1:3], v[2:5], s[12:19] dmask:0xe unorm
// CHECK: [0x00,0x1e,0x24,0xf0,0x02,0x01,0x03,0x00]

image_store_mip v[1:4], v[2:5], s[12:19] dmask:0xf unorm
// CHECK: [0x00,0x1f,0x24,0xf0,0x02,0x01,0x03,0x00]

image_store_mip v1, v[2:5], s[12:19] dmask:0x0 unorm
// CHECK: [0x00,0x10,0x24,0xf0,0x02,0x01,0x03,0x00]

image_store_mip v1, v[2:5], s[12:19] dmask:0x1 unorm glc
// CHECK: [0x00,0x31,0x24,0xf0,0x02,0x01,0x03,0x00]

image_store_mip v1, v[2:5], s[12:19] dmask:0x1 unorm slc
// CHECK: [0x00,0x11,0x24,0xf2,0x02,0x01,0x03,0x00]

image_store_mip v1, v[2:5], s[12:19] dmask:0x1 unorm lwe
// CHECK: [0x00,0x11,0x26,0xf0,0x02,0x01,0x03,0x00]

image_store_mip v1, v[2:5], s[12:19] dmask:0x1 unorm da
// CHECK: [0x00,0x51,0x24,0xf0,0x02,0x01,0x03,0x00]

image_get_resinfo v5, v[1:4], s[8:15] dmask:0x1
// CHECK: [0x00,0x01,0x38,0xf0,0x01,0x05,0x02,0x00]

image_get_resinfo v252, v[1:4], s[8:15] dmask:0x1
// CHECK: [0x00,0x01,0x38,0xf0,0x01,0xfc,0x02,0x00]

image_get_resinfo v5, v[252:255], s[8:15] dmask:0x1
// CHECK: [0x00,0x01,0x38,0xf0,0xfc,0x05,0x02,0x00]

image_get_resinfo v5, v[1:4], s[12:19] dmask:0x1
// CHECK: [0x00,0x01,0x38,0xf0,0x01,0x05,0x03,0x00]

image_get_resinfo v5, v[1:4], s[96:103] dmask:0x1
// CHECK: [0x00,0x01,0x38,0xf0,0x01,0x05,0x18,0x00]

image_get_resinfo v5, v[1:4], ttmp[4:11] dmask:0x1
// CHECK: [0x00,0x01,0x38,0xf0,0x01,0x05,0x1d,0x00]

image_get_resinfo v5, v[1:4], s[8:15] dmask:0x2
// CHECK: [0x00,0x02,0x38,0xf0,0x01,0x05,0x02,0x00]

image_get_resinfo v[5:6], v[1:4], s[8:15] dmask:0x3
// CHECK: [0x00,0x03,0x38,0xf0,0x01,0x05,0x02,0x00]

image_get_resinfo v5, v[1:4], s[8:15] dmask:0x4
// CHECK: [0x00,0x04,0x38,0xf0,0x01,0x05,0x02,0x00]

image_get_resinfo v[5:6], v[1:4], s[8:15] dmask:0x5
// CHECK: [0x00,0x05,0x38,0xf0,0x01,0x05,0x02,0x00]

image_get_resinfo v[5:6], v[1:4], s[8:15] dmask:0x6
// CHECK: [0x00,0x06,0x38,0xf0,0x01,0x05,0x02,0x00]

image_get_resinfo v[5:7], v[1:4], s[8:15] dmask:0x7
// CHECK: [0x00,0x07,0x38,0xf0,0x01,0x05,0x02,0x00]

image_get_resinfo v5, v[1:4], s[8:15] dmask:0x8
// CHECK: [0x00,0x08,0x38,0xf0,0x01,0x05,0x02,0x00]

image_get_resinfo v[5:6], v[1:4], s[8:15] dmask:0x9
// CHECK: [0x00,0x09,0x38,0xf0,0x01,0x05,0x02,0x00]

image_get_resinfo v[5:6], v[1:4], s[8:15] dmask:0xa
// CHECK: [0x00,0x0a,0x38,0xf0,0x01,0x05,0x02,0x00]

image_get_resinfo v[5:7], v[1:4], s[8:15] dmask:0xb
// CHECK: [0x00,0x0b,0x38,0xf0,0x01,0x05,0x02,0x00]

image_get_resinfo v[5:6], v[1:4], s[8:15] dmask:0xc
// CHECK: [0x00,0x0c,0x38,0xf0,0x01,0x05,0x02,0x00]

image_get_resinfo v[5:7], v[1:4], s[8:15] dmask:0xd
// CHECK: [0x00,0x0d,0x38,0xf0,0x01,0x05,0x02,0x00]

image_get_resinfo v[5:7], v[1:4], s[8:15] dmask:0xe
// CHECK: [0x00,0x0e,0x38,0xf0,0x01,0x05,0x02,0x00]

image_get_resinfo v5, v[1:4], s[8:15] dmask:0x0
// CHECK: [0x00,0x00,0x38,0xf0,0x01,0x05,0x02,0x00]

image_get_resinfo v5, v[1:4], s[8:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x38,0xf0,0x01,0x05,0x02,0x00]

image_get_resinfo v5, v[1:4], s[8:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0x38,0xf0,0x01,0x05,0x02,0x00]

image_get_resinfo v5, v[1:4], s[8:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0x38,0xf2,0x01,0x05,0x02,0x00]

image_get_resinfo v[5:6], v[1:4], s[8:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0x39,0xf0,0x01,0x05,0x02,0x00]

image_get_resinfo v5, v[1:4], s[8:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0x3a,0xf0,0x01,0x05,0x02,0x00]

image_get_resinfo v5, v[1:4], s[8:15] dmask:0x1 da
// CHECK: [0x00,0x41,0x38,0xf0,0x01,0x05,0x02,0x00]

image_atomic_swap v1, v2, s[12:19] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x3c,0xf0,0x02,0x01,0x03,0x00]

image_atomic_swap v252, v2, s[12:19] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x3c,0xf0,0x02,0xfc,0x03,0x00]

image_atomic_swap v1, v255, s[12:19] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x3c,0xf0,0xff,0x01,0x03,0x00]

image_atomic_swap v1, v2, s[16:23] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x3c,0xf0,0x02,0x01,0x04,0x00]

image_atomic_swap v1, v2, s[96:103] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x3c,0xf0,0x02,0x01,0x18,0x00]

image_atomic_swap v1, v2, ttmp[4:11] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x3c,0xf0,0x02,0x01,0x1d,0x00]

image_atomic_swap v[1:2], v2, s[12:19] dmask:0x3 unorm
// CHECK: [0x00,0x13,0x3c,0xf0,0x02,0x01,0x03,0x00]

image_atomic_swap v1, v2, s[12:19] dmask:0x1 unorm glc
// CHECK: [0x00,0x31,0x3c,0xf0,0x02,0x01,0x03,0x00]

image_atomic_swap v1, v2, s[12:19] dmask:0x1 unorm slc
// CHECK: [0x00,0x11,0x3c,0xf2,0x02,0x01,0x03,0x00]

image_atomic_swap v1, v2, s[12:19] dmask:0x1 unorm lwe
// CHECK: [0x00,0x11,0x3e,0xf0,0x02,0x01,0x03,0x00]

image_atomic_swap v1, v2, s[12:19] dmask:0x1 unorm da
// CHECK: [0x00,0x51,0x3c,0xf0,0x02,0x01,0x03,0x00]

image_atomic_cmpswap v[1:2], v2, s[12:19] dmask:0x3 unorm
// CHECK: [0x00,0x13,0x40,0xf0,0x02,0x01,0x03,0x00]

image_atomic_cmpswap v[252:253], v2, s[12:19] dmask:0x3 unorm
// CHECK: [0x00,0x13,0x40,0xf0,0x02,0xfc,0x03,0x00]

image_atomic_cmpswap v[1:2], v255, s[12:19] dmask:0x3 unorm
// CHECK: [0x00,0x13,0x40,0xf0,0xff,0x01,0x03,0x00]

image_atomic_cmpswap v[1:2], v2, s[16:23] dmask:0x3 unorm
// CHECK: [0x00,0x13,0x40,0xf0,0x02,0x01,0x04,0x00]

image_atomic_cmpswap v[1:2], v2, s[96:103] dmask:0x3 unorm
// CHECK: [0x00,0x13,0x40,0xf0,0x02,0x01,0x18,0x00]

image_atomic_cmpswap v[1:2], v2, ttmp[4:11] dmask:0x3 unorm
// CHECK: [0x00,0x13,0x40,0xf0,0x02,0x01,0x1d,0x00]

image_atomic_cmpswap v[1:4], v2, s[12:19] dmask:0xf unorm
// CHECK: [0x00,0x1f,0x40,0xf0,0x02,0x01,0x03,0x00]

image_atomic_cmpswap v[1:2], v2, s[12:19] dmask:0x3 unorm glc
// CHECK: [0x00,0x33,0x40,0xf0,0x02,0x01,0x03,0x00]

image_atomic_cmpswap v[1:2], v2, s[12:19] dmask:0x3 unorm slc
// CHECK: [0x00,0x13,0x40,0xf2,0x02,0x01,0x03,0x00]

image_atomic_cmpswap v[1:2], v2, s[12:19] dmask:0x3 unorm lwe
// CHECK: [0x00,0x13,0x42,0xf0,0x02,0x01,0x03,0x00]

image_atomic_cmpswap v[1:2], v2, s[12:19] dmask:0x3 unorm da
// CHECK: [0x00,0x53,0x40,0xf0,0x02,0x01,0x03,0x00]

image_atomic_add v1, v2, s[12:19] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x44,0xf0,0x02,0x01,0x03,0x00]

image_atomic_add v252, v2, s[12:19] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x44,0xf0,0x02,0xfc,0x03,0x00]

image_atomic_add v1, v255, s[12:19] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x44,0xf0,0xff,0x01,0x03,0x00]

image_atomic_add v1, v2, s[16:23] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x44,0xf0,0x02,0x01,0x04,0x00]

image_atomic_add v1, v2, s[96:103] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x44,0xf0,0x02,0x01,0x18,0x00]

image_atomic_add v1, v2, ttmp[4:11] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x44,0xf0,0x02,0x01,0x1d,0x00]

image_atomic_add v[1:2], v2, s[12:19] dmask:0x3 unorm
// CHECK: [0x00,0x13,0x44,0xf0,0x02,0x01,0x03,0x00]

image_atomic_add v1, v2, s[12:19] dmask:0x1 unorm glc
// CHECK: [0x00,0x31,0x44,0xf0,0x02,0x01,0x03,0x00]

image_atomic_add v1, v2, s[12:19] dmask:0x1 unorm slc
// CHECK: [0x00,0x11,0x44,0xf2,0x02,0x01,0x03,0x00]

image_atomic_add v1, v2, s[12:19] dmask:0x1 unorm lwe
// CHECK: [0x00,0x11,0x46,0xf0,0x02,0x01,0x03,0x00]

image_atomic_add v1, v2, s[12:19] dmask:0x1 unorm da
// CHECK: [0x00,0x51,0x44,0xf0,0x02,0x01,0x03,0x00]

image_atomic_sub v1, v2, s[12:19] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x48,0xf0,0x02,0x01,0x03,0x00]

image_atomic_sub v252, v2, s[12:19] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x48,0xf0,0x02,0xfc,0x03,0x00]

image_atomic_sub v1, v255, s[12:19] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x48,0xf0,0xff,0x01,0x03,0x00]

image_atomic_sub v1, v2, s[16:23] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x48,0xf0,0x02,0x01,0x04,0x00]

image_atomic_sub v1, v2, s[96:103] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x48,0xf0,0x02,0x01,0x18,0x00]

image_atomic_sub v1, v2, ttmp[4:11] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x48,0xf0,0x02,0x01,0x1d,0x00]

image_atomic_sub v[1:2], v2, s[12:19] dmask:0x3 unorm
// CHECK: [0x00,0x13,0x48,0xf0,0x02,0x01,0x03,0x00]

image_atomic_sub v1, v2, s[12:19] dmask:0x1 unorm glc
// CHECK: [0x00,0x31,0x48,0xf0,0x02,0x01,0x03,0x00]

image_atomic_sub v1, v2, s[12:19] dmask:0x1 unorm slc
// CHECK: [0x00,0x11,0x48,0xf2,0x02,0x01,0x03,0x00]

image_atomic_sub v1, v2, s[12:19] dmask:0x1 unorm lwe
// CHECK: [0x00,0x11,0x4a,0xf0,0x02,0x01,0x03,0x00]

image_atomic_sub v1, v2, s[12:19] dmask:0x1 unorm da
// CHECK: [0x00,0x51,0x48,0xf0,0x02,0x01,0x03,0x00]

image_atomic_smin v1, v2, s[12:19] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x50,0xf0,0x02,0x01,0x03,0x00]

image_atomic_smin v252, v2, s[12:19] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x50,0xf0,0x02,0xfc,0x03,0x00]

image_atomic_smin v1, v255, s[12:19] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x50,0xf0,0xff,0x01,0x03,0x00]

image_atomic_smin v1, v2, s[16:23] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x50,0xf0,0x02,0x01,0x04,0x00]

image_atomic_smin v1, v2, s[96:103] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x50,0xf0,0x02,0x01,0x18,0x00]

image_atomic_smin v1, v2, ttmp[4:11] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x50,0xf0,0x02,0x01,0x1d,0x00]

image_atomic_smin v[1:2], v2, s[12:19] dmask:0x3 unorm
// CHECK: [0x00,0x13,0x50,0xf0,0x02,0x01,0x03,0x00]

image_atomic_smin v1, v2, s[12:19] dmask:0x1 unorm glc
// CHECK: [0x00,0x31,0x50,0xf0,0x02,0x01,0x03,0x00]

image_atomic_smin v1, v2, s[12:19] dmask:0x1 unorm slc
// CHECK: [0x00,0x11,0x50,0xf2,0x02,0x01,0x03,0x00]

image_atomic_smin v1, v2, s[12:19] dmask:0x1 unorm lwe
// CHECK: [0x00,0x11,0x52,0xf0,0x02,0x01,0x03,0x00]

image_atomic_smin v1, v2, s[12:19] dmask:0x1 unorm da
// CHECK: [0x00,0x51,0x50,0xf0,0x02,0x01,0x03,0x00]

image_atomic_umin v1, v2, s[12:19] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x54,0xf0,0x02,0x01,0x03,0x00]

image_atomic_umin v252, v2, s[12:19] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x54,0xf0,0x02,0xfc,0x03,0x00]

image_atomic_umin v1, v255, s[12:19] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x54,0xf0,0xff,0x01,0x03,0x00]

image_atomic_umin v1, v2, s[16:23] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x54,0xf0,0x02,0x01,0x04,0x00]

image_atomic_umin v1, v2, s[96:103] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x54,0xf0,0x02,0x01,0x18,0x00]

image_atomic_umin v1, v2, ttmp[4:11] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x54,0xf0,0x02,0x01,0x1d,0x00]

image_atomic_umin v[1:2], v2, s[12:19] dmask:0x3 unorm
// CHECK: [0x00,0x13,0x54,0xf0,0x02,0x01,0x03,0x00]

image_atomic_umin v1, v2, s[12:19] dmask:0x1 unorm glc
// CHECK: [0x00,0x31,0x54,0xf0,0x02,0x01,0x03,0x00]

image_atomic_umin v1, v2, s[12:19] dmask:0x1 unorm slc
// CHECK: [0x00,0x11,0x54,0xf2,0x02,0x01,0x03,0x00]

image_atomic_umin v1, v2, s[12:19] dmask:0x1 unorm lwe
// CHECK: [0x00,0x11,0x56,0xf0,0x02,0x01,0x03,0x00]

image_atomic_umin v1, v2, s[12:19] dmask:0x1 unorm da
// CHECK: [0x00,0x51,0x54,0xf0,0x02,0x01,0x03,0x00]

image_atomic_smax v1, v2, s[12:19] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x58,0xf0,0x02,0x01,0x03,0x00]

image_atomic_smax v252, v2, s[12:19] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x58,0xf0,0x02,0xfc,0x03,0x00]

image_atomic_smax v1, v255, s[12:19] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x58,0xf0,0xff,0x01,0x03,0x00]

image_atomic_smax v1, v2, s[16:23] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x58,0xf0,0x02,0x01,0x04,0x00]

image_atomic_smax v1, v2, s[96:103] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x58,0xf0,0x02,0x01,0x18,0x00]

image_atomic_smax v1, v2, ttmp[4:11] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x58,0xf0,0x02,0x01,0x1d,0x00]

image_atomic_smax v[1:2], v2, s[12:19] dmask:0x3 unorm
// CHECK: [0x00,0x13,0x58,0xf0,0x02,0x01,0x03,0x00]

image_atomic_smax v1, v2, s[12:19] dmask:0x1 unorm glc
// CHECK: [0x00,0x31,0x58,0xf0,0x02,0x01,0x03,0x00]

image_atomic_smax v1, v2, s[12:19] dmask:0x1 unorm slc
// CHECK: [0x00,0x11,0x58,0xf2,0x02,0x01,0x03,0x00]

image_atomic_smax v1, v2, s[12:19] dmask:0x1 unorm lwe
// CHECK: [0x00,0x11,0x5a,0xf0,0x02,0x01,0x03,0x00]

image_atomic_smax v1, v2, s[12:19] dmask:0x1 unorm da
// CHECK: [0x00,0x51,0x58,0xf0,0x02,0x01,0x03,0x00]

image_atomic_umax v1, v2, s[12:19] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x5c,0xf0,0x02,0x01,0x03,0x00]

image_atomic_umax v252, v2, s[12:19] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x5c,0xf0,0x02,0xfc,0x03,0x00]

image_atomic_umax v1, v255, s[12:19] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x5c,0xf0,0xff,0x01,0x03,0x00]

image_atomic_umax v1, v2, s[16:23] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x5c,0xf0,0x02,0x01,0x04,0x00]

image_atomic_umax v1, v2, s[96:103] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x5c,0xf0,0x02,0x01,0x18,0x00]

image_atomic_umax v1, v2, ttmp[4:11] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x5c,0xf0,0x02,0x01,0x1d,0x00]

image_atomic_umax v[1:2], v2, s[12:19] dmask:0x3 unorm
// CHECK: [0x00,0x13,0x5c,0xf0,0x02,0x01,0x03,0x00]

image_atomic_umax v1, v2, s[12:19] dmask:0x1 unorm glc
// CHECK: [0x00,0x31,0x5c,0xf0,0x02,0x01,0x03,0x00]

image_atomic_umax v1, v2, s[12:19] dmask:0x1 unorm slc
// CHECK: [0x00,0x11,0x5c,0xf2,0x02,0x01,0x03,0x00]

image_atomic_umax v1, v2, s[12:19] dmask:0x1 unorm lwe
// CHECK: [0x00,0x11,0x5e,0xf0,0x02,0x01,0x03,0x00]

image_atomic_umax v1, v2, s[12:19] dmask:0x1 unorm da
// CHECK: [0x00,0x51,0x5c,0xf0,0x02,0x01,0x03,0x00]

image_atomic_and v1, v2, s[12:19] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x60,0xf0,0x02,0x01,0x03,0x00]

image_atomic_and v252, v2, s[12:19] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x60,0xf0,0x02,0xfc,0x03,0x00]

image_atomic_and v1, v255, s[12:19] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x60,0xf0,0xff,0x01,0x03,0x00]

image_atomic_and v1, v2, s[16:23] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x60,0xf0,0x02,0x01,0x04,0x00]

image_atomic_and v1, v2, s[96:103] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x60,0xf0,0x02,0x01,0x18,0x00]

image_atomic_and v1, v2, ttmp[4:11] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x60,0xf0,0x02,0x01,0x1d,0x00]

image_atomic_and v[1:2], v2, s[12:19] dmask:0x3 unorm
// CHECK: [0x00,0x13,0x60,0xf0,0x02,0x01,0x03,0x00]

image_atomic_and v1, v2, s[12:19] dmask:0x1 unorm glc
// CHECK: [0x00,0x31,0x60,0xf0,0x02,0x01,0x03,0x00]

image_atomic_and v1, v2, s[12:19] dmask:0x1 unorm slc
// CHECK: [0x00,0x11,0x60,0xf2,0x02,0x01,0x03,0x00]

image_atomic_and v1, v2, s[12:19] dmask:0x1 unorm lwe
// CHECK: [0x00,0x11,0x62,0xf0,0x02,0x01,0x03,0x00]

image_atomic_and v1, v2, s[12:19] dmask:0x1 unorm da
// CHECK: [0x00,0x51,0x60,0xf0,0x02,0x01,0x03,0x00]

image_atomic_or v1, v2, s[12:19] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x64,0xf0,0x02,0x01,0x03,0x00]

image_atomic_or v252, v2, s[12:19] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x64,0xf0,0x02,0xfc,0x03,0x00]

image_atomic_or v1, v255, s[12:19] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x64,0xf0,0xff,0x01,0x03,0x00]

image_atomic_or v1, v2, s[16:23] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x64,0xf0,0x02,0x01,0x04,0x00]

image_atomic_or v1, v2, s[96:103] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x64,0xf0,0x02,0x01,0x18,0x00]

image_atomic_or v1, v2, ttmp[4:11] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x64,0xf0,0x02,0x01,0x1d,0x00]

image_atomic_or v[1:2], v2, s[12:19] dmask:0x3 unorm
// CHECK: [0x00,0x13,0x64,0xf0,0x02,0x01,0x03,0x00]

image_atomic_or v1, v2, s[12:19] dmask:0x1 unorm glc
// CHECK: [0x00,0x31,0x64,0xf0,0x02,0x01,0x03,0x00]

image_atomic_or v1, v2, s[12:19] dmask:0x1 unorm slc
// CHECK: [0x00,0x11,0x64,0xf2,0x02,0x01,0x03,0x00]

image_atomic_or v1, v2, s[12:19] dmask:0x1 unorm lwe
// CHECK: [0x00,0x11,0x66,0xf0,0x02,0x01,0x03,0x00]

image_atomic_or v1, v2, s[12:19] dmask:0x1 unorm da
// CHECK: [0x00,0x51,0x64,0xf0,0x02,0x01,0x03,0x00]

image_atomic_xor v1, v2, s[12:19] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x68,0xf0,0x02,0x01,0x03,0x00]

image_atomic_xor v252, v2, s[12:19] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x68,0xf0,0x02,0xfc,0x03,0x00]

image_atomic_xor v1, v255, s[12:19] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x68,0xf0,0xff,0x01,0x03,0x00]

image_atomic_xor v1, v2, s[16:23] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x68,0xf0,0x02,0x01,0x04,0x00]

image_atomic_xor v1, v2, s[96:103] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x68,0xf0,0x02,0x01,0x18,0x00]

image_atomic_xor v1, v2, ttmp[4:11] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x68,0xf0,0x02,0x01,0x1d,0x00]

image_atomic_xor v[1:2], v2, s[12:19] dmask:0x3 unorm
// CHECK: [0x00,0x13,0x68,0xf0,0x02,0x01,0x03,0x00]

image_atomic_xor v1, v2, s[12:19] dmask:0x1 unorm glc
// CHECK: [0x00,0x31,0x68,0xf0,0x02,0x01,0x03,0x00]

image_atomic_xor v1, v2, s[12:19] dmask:0x1 unorm slc
// CHECK: [0x00,0x11,0x68,0xf2,0x02,0x01,0x03,0x00]

image_atomic_xor v1, v2, s[12:19] dmask:0x1 unorm lwe
// CHECK: [0x00,0x11,0x6a,0xf0,0x02,0x01,0x03,0x00]

image_atomic_xor v1, v2, s[12:19] dmask:0x1 unorm da
// CHECK: [0x00,0x51,0x68,0xf0,0x02,0x01,0x03,0x00]

image_atomic_inc v1, v2, s[12:19] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x6c,0xf0,0x02,0x01,0x03,0x00]

image_atomic_inc v252, v2, s[12:19] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x6c,0xf0,0x02,0xfc,0x03,0x00]

image_atomic_inc v1, v255, s[12:19] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x6c,0xf0,0xff,0x01,0x03,0x00]

image_atomic_inc v1, v2, s[16:23] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x6c,0xf0,0x02,0x01,0x04,0x00]

image_atomic_inc v1, v2, s[96:103] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x6c,0xf0,0x02,0x01,0x18,0x00]

image_atomic_inc v1, v2, ttmp[4:11] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x6c,0xf0,0x02,0x01,0x1d,0x00]

image_atomic_inc v[1:2], v2, s[12:19] dmask:0x3 unorm
// CHECK: [0x00,0x13,0x6c,0xf0,0x02,0x01,0x03,0x00]

image_atomic_inc v1, v2, s[12:19] dmask:0x1 unorm glc
// CHECK: [0x00,0x31,0x6c,0xf0,0x02,0x01,0x03,0x00]

image_atomic_inc v1, v2, s[12:19] dmask:0x1 unorm slc
// CHECK: [0x00,0x11,0x6c,0xf2,0x02,0x01,0x03,0x00]

image_atomic_inc v1, v2, s[12:19] dmask:0x1 unorm lwe
// CHECK: [0x00,0x11,0x6e,0xf0,0x02,0x01,0x03,0x00]

image_atomic_inc v1, v2, s[12:19] dmask:0x1 unorm da
// CHECK: [0x00,0x51,0x6c,0xf0,0x02,0x01,0x03,0x00]

image_atomic_dec v1, v2, s[12:19] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x70,0xf0,0x02,0x01,0x03,0x00]

image_atomic_dec v252, v2, s[12:19] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x70,0xf0,0x02,0xfc,0x03,0x00]

image_atomic_dec v1, v255, s[12:19] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x70,0xf0,0xff,0x01,0x03,0x00]

image_atomic_dec v1, v2, s[16:23] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x70,0xf0,0x02,0x01,0x04,0x00]

image_atomic_dec v1, v2, s[96:103] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x70,0xf0,0x02,0x01,0x18,0x00]

image_atomic_dec v1, v2, ttmp[4:11] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x70,0xf0,0x02,0x01,0x1d,0x00]

image_atomic_dec v[1:2], v2, s[12:19] dmask:0x3 unorm
// CHECK: [0x00,0x13,0x70,0xf0,0x02,0x01,0x03,0x00]

image_atomic_dec v1, v2, s[12:19] dmask:0x1 unorm glc
// CHECK: [0x00,0x31,0x70,0xf0,0x02,0x01,0x03,0x00]

image_atomic_dec v1, v2, s[12:19] dmask:0x1 unorm slc
// CHECK: [0x00,0x11,0x70,0xf2,0x02,0x01,0x03,0x00]

image_atomic_dec v1, v2, s[12:19] dmask:0x1 unorm lwe
// CHECK: [0x00,0x11,0x72,0xf0,0x02,0x01,0x03,0x00]

image_atomic_dec v1, v2, s[12:19] dmask:0x1 unorm da
// CHECK: [0x00,0x51,0x70,0xf0,0x02,0x01,0x03,0x00]

image_sample v5, v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x80,0xf0,0x01,0x05,0x62,0x00]

image_sample v252, v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x80,0xf0,0x01,0xfc,0x62,0x00]

image_sample v5, v[252:255], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x80,0xf0,0xfc,0x05,0x62,0x00]

image_sample v5, v[1:4], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x80,0xf0,0x01,0x05,0x63,0x00]

image_sample v5, v[1:4], s[96:103], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x80,0xf0,0x01,0x05,0x78,0x00]

image_sample v5, v[1:4], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x80,0xf0,0x01,0x05,0x7d,0x00]

image_sample v5, v[1:4], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0x80,0xf0,0x01,0x05,0x82,0x00]

image_sample v5, v[1:4], s[8:15], s[100:103] dmask:0x1
// CHECK: [0x00,0x01,0x80,0xf0,0x01,0x05,0x22,0x03]

image_sample v5, v[1:4], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0x80,0xf0,0x01,0x05,0xc2,0x03]

image_sample v5, v[1:4], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0x80,0xf0,0x01,0x05,0x62,0x00]

image_sample v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x3
// CHECK: [0x00,0x03,0x80,0xf0,0x01,0x05,0x62,0x00]

image_sample v5, v[1:4], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0x80,0xf0,0x01,0x05,0x62,0x00]

image_sample v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x5
// CHECK: [0x00,0x05,0x80,0xf0,0x01,0x05,0x62,0x00]

image_sample v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x6
// CHECK: [0x00,0x06,0x80,0xf0,0x01,0x05,0x62,0x00]

image_sample v[5:7], v[1:4], s[8:15], s[12:15] dmask:0x7
// CHECK: [0x00,0x07,0x80,0xf0,0x01,0x05,0x62,0x00]

image_sample v5, v[1:4], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0x80,0xf0,0x01,0x05,0x62,0x00]

image_sample v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x9
// CHECK: [0x00,0x09,0x80,0xf0,0x01,0x05,0x62,0x00]

image_sample v[5:6], v[1:4], s[8:15], s[12:15] dmask:0xa
// CHECK: [0x00,0x0a,0x80,0xf0,0x01,0x05,0x62,0x00]

image_sample v[5:7], v[1:4], s[8:15], s[12:15] dmask:0xb
// CHECK: [0x00,0x0b,0x80,0xf0,0x01,0x05,0x62,0x00]

image_sample v[5:6], v[1:4], s[8:15], s[12:15] dmask:0xc
// CHECK: [0x00,0x0c,0x80,0xf0,0x01,0x05,0x62,0x00]

image_sample v[5:7], v[1:4], s[8:15], s[12:15] dmask:0xd
// CHECK: [0x00,0x0d,0x80,0xf0,0x01,0x05,0x62,0x00]

image_sample v[5:7], v[1:4], s[8:15], s[12:15] dmask:0xe
// CHECK: [0x00,0x0e,0x80,0xf0,0x01,0x05,0x62,0x00]

image_sample v5, v[1:4], s[8:15], s[12:15] dmask:0x0
// CHECK: [0x00,0x00,0x80,0xf0,0x01,0x05,0x62,0x00]

image_sample v5, v[1:4], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x80,0xf0,0x01,0x05,0x62,0x00]

image_sample v5, v[1:4], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0x80,0xf0,0x01,0x05,0x62,0x00]

image_sample v5, v[1:4], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0x80,0xf2,0x01,0x05,0x62,0x00]

image_sample v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0x81,0xf0,0x01,0x05,0x62,0x00]

image_sample v5, v[1:4], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0x82,0xf0,0x01,0x05,0x62,0x00]

image_sample v5, v[1:4], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0x80,0xf0,0x01,0x05,0x62,0x00]

image_sample_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x84,0xf0,0x01,0x05,0x62,0x00]

image_sample_cl v252, v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x84,0xf0,0x01,0xfc,0x62,0x00]

image_sample_cl v5, v[252:255], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x84,0xf0,0xfc,0x05,0x62,0x00]

image_sample_cl v5, v[1:4], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x84,0xf0,0x01,0x05,0x63,0x00]

image_sample_cl v5, v[1:4], s[96:103], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x84,0xf0,0x01,0x05,0x78,0x00]

image_sample_cl v5, v[1:4], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x84,0xf0,0x01,0x05,0x7d,0x00]

image_sample_cl v5, v[1:4], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0x84,0xf0,0x01,0x05,0x82,0x00]

image_sample_cl v5, v[1:4], s[8:15], s[100:103] dmask:0x1
// CHECK: [0x00,0x01,0x84,0xf0,0x01,0x05,0x22,0x03]

image_sample_cl v5, v[1:4], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0x84,0xf0,0x01,0x05,0xc2,0x03]

image_sample_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0x84,0xf0,0x01,0x05,0x62,0x00]

image_sample_cl v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x3
// CHECK: [0x00,0x03,0x84,0xf0,0x01,0x05,0x62,0x00]

image_sample_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0x84,0xf0,0x01,0x05,0x62,0x00]

image_sample_cl v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x5
// CHECK: [0x00,0x05,0x84,0xf0,0x01,0x05,0x62,0x00]

image_sample_cl v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x6
// CHECK: [0x00,0x06,0x84,0xf0,0x01,0x05,0x62,0x00]

image_sample_cl v[5:7], v[1:4], s[8:15], s[12:15] dmask:0x7
// CHECK: [0x00,0x07,0x84,0xf0,0x01,0x05,0x62,0x00]

image_sample_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0x84,0xf0,0x01,0x05,0x62,0x00]

image_sample_cl v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x9
// CHECK: [0x00,0x09,0x84,0xf0,0x01,0x05,0x62,0x00]

image_sample_cl v[5:6], v[1:4], s[8:15], s[12:15] dmask:0xa
// CHECK: [0x00,0x0a,0x84,0xf0,0x01,0x05,0x62,0x00]

image_sample_cl v[5:7], v[1:4], s[8:15], s[12:15] dmask:0xb
// CHECK: [0x00,0x0b,0x84,0xf0,0x01,0x05,0x62,0x00]

image_sample_cl v[5:6], v[1:4], s[8:15], s[12:15] dmask:0xc
// CHECK: [0x00,0x0c,0x84,0xf0,0x01,0x05,0x62,0x00]

image_sample_cl v[5:7], v[1:4], s[8:15], s[12:15] dmask:0xd
// CHECK: [0x00,0x0d,0x84,0xf0,0x01,0x05,0x62,0x00]

image_sample_cl v[5:7], v[1:4], s[8:15], s[12:15] dmask:0xe
// CHECK: [0x00,0x0e,0x84,0xf0,0x01,0x05,0x62,0x00]

image_sample_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x0
// CHECK: [0x00,0x00,0x84,0xf0,0x01,0x05,0x62,0x00]

image_sample_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x84,0xf0,0x01,0x05,0x62,0x00]

image_sample_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0x84,0xf0,0x01,0x05,0x62,0x00]

image_sample_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0x84,0xf2,0x01,0x05,0x62,0x00]

image_sample_cl v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0x85,0xf0,0x01,0x05,0x62,0x00]

image_sample_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0x86,0xf0,0x01,0x05,0x62,0x00]

image_sample_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0x84,0xf0,0x01,0x05,0x62,0x00]

image_sample_l v5, v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x90,0xf0,0x01,0x05,0x62,0x00]

image_sample_l v252, v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x90,0xf0,0x01,0xfc,0x62,0x00]

image_sample_l v5, v[252:255], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x90,0xf0,0xfc,0x05,0x62,0x00]

image_sample_l v5, v[1:4], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x90,0xf0,0x01,0x05,0x63,0x00]

image_sample_l v5, v[1:4], s[96:103], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x90,0xf0,0x01,0x05,0x78,0x00]

image_sample_l v5, v[1:4], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x90,0xf0,0x01,0x05,0x7d,0x00]

image_sample_l v5, v[1:4], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0x90,0xf0,0x01,0x05,0x82,0x00]

image_sample_l v5, v[1:4], s[8:15], s[100:103] dmask:0x1
// CHECK: [0x00,0x01,0x90,0xf0,0x01,0x05,0x22,0x03]

image_sample_l v5, v[1:4], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0x90,0xf0,0x01,0x05,0xc2,0x03]

image_sample_l v5, v[1:4], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0x90,0xf0,0x01,0x05,0x62,0x00]

image_sample_l v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x3
// CHECK: [0x00,0x03,0x90,0xf0,0x01,0x05,0x62,0x00]

image_sample_l v5, v[1:4], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0x90,0xf0,0x01,0x05,0x62,0x00]

image_sample_l v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x5
// CHECK: [0x00,0x05,0x90,0xf0,0x01,0x05,0x62,0x00]

image_sample_l v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x6
// CHECK: [0x00,0x06,0x90,0xf0,0x01,0x05,0x62,0x00]

image_sample_l v[5:7], v[1:4], s[8:15], s[12:15] dmask:0x7
// CHECK: [0x00,0x07,0x90,0xf0,0x01,0x05,0x62,0x00]

image_sample_l v5, v[1:4], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0x90,0xf0,0x01,0x05,0x62,0x00]

image_sample_l v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x9
// CHECK: [0x00,0x09,0x90,0xf0,0x01,0x05,0x62,0x00]

image_sample_l v[5:6], v[1:4], s[8:15], s[12:15] dmask:0xa
// CHECK: [0x00,0x0a,0x90,0xf0,0x01,0x05,0x62,0x00]

image_sample_l v[5:7], v[1:4], s[8:15], s[12:15] dmask:0xb
// CHECK: [0x00,0x0b,0x90,0xf0,0x01,0x05,0x62,0x00]

image_sample_l v[5:6], v[1:4], s[8:15], s[12:15] dmask:0xc
// CHECK: [0x00,0x0c,0x90,0xf0,0x01,0x05,0x62,0x00]

image_sample_l v[5:7], v[1:4], s[8:15], s[12:15] dmask:0xd
// CHECK: [0x00,0x0d,0x90,0xf0,0x01,0x05,0x62,0x00]

image_sample_l v[5:7], v[1:4], s[8:15], s[12:15] dmask:0xe
// CHECK: [0x00,0x0e,0x90,0xf0,0x01,0x05,0x62,0x00]

image_sample_l v5, v[1:4], s[8:15], s[12:15] dmask:0x0
// CHECK: [0x00,0x00,0x90,0xf0,0x01,0x05,0x62,0x00]

image_sample_l v5, v[1:4], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x90,0xf0,0x01,0x05,0x62,0x00]

image_sample_l v5, v[1:4], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0x90,0xf0,0x01,0x05,0x62,0x00]

image_sample_l v5, v[1:4], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0x90,0xf2,0x01,0x05,0x62,0x00]

image_sample_l v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0x91,0xf0,0x01,0x05,0x62,0x00]

image_sample_l v5, v[1:4], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0x92,0xf0,0x01,0x05,0x62,0x00]

image_sample_l v5, v[1:4], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0x90,0xf0,0x01,0x05,0x62,0x00]

image_sample_b v5, v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x94,0xf0,0x01,0x05,0x62,0x00]

image_sample_b v252, v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x94,0xf0,0x01,0xfc,0x62,0x00]

image_sample_b v5, v[252:255], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x94,0xf0,0xfc,0x05,0x62,0x00]

image_sample_b v5, v[1:4], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x94,0xf0,0x01,0x05,0x63,0x00]

image_sample_b v5, v[1:4], s[96:103], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x94,0xf0,0x01,0x05,0x78,0x00]

image_sample_b v5, v[1:4], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x94,0xf0,0x01,0x05,0x7d,0x00]

image_sample_b v5, v[1:4], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0x94,0xf0,0x01,0x05,0x82,0x00]

image_sample_b v5, v[1:4], s[8:15], s[100:103] dmask:0x1
// CHECK: [0x00,0x01,0x94,0xf0,0x01,0x05,0x22,0x03]

image_sample_b v5, v[1:4], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0x94,0xf0,0x01,0x05,0xc2,0x03]

image_sample_b v5, v[1:4], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0x94,0xf0,0x01,0x05,0x62,0x00]

image_sample_b v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x3
// CHECK: [0x00,0x03,0x94,0xf0,0x01,0x05,0x62,0x00]

image_sample_b v5, v[1:4], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0x94,0xf0,0x01,0x05,0x62,0x00]

image_sample_b v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x5
// CHECK: [0x00,0x05,0x94,0xf0,0x01,0x05,0x62,0x00]

image_sample_b v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x6
// CHECK: [0x00,0x06,0x94,0xf0,0x01,0x05,0x62,0x00]

image_sample_b v[5:7], v[1:4], s[8:15], s[12:15] dmask:0x7
// CHECK: [0x00,0x07,0x94,0xf0,0x01,0x05,0x62,0x00]

image_sample_b v5, v[1:4], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0x94,0xf0,0x01,0x05,0x62,0x00]

image_sample_b v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x9
// CHECK: [0x00,0x09,0x94,0xf0,0x01,0x05,0x62,0x00]

image_sample_b v[5:6], v[1:4], s[8:15], s[12:15] dmask:0xa
// CHECK: [0x00,0x0a,0x94,0xf0,0x01,0x05,0x62,0x00]

image_sample_b v[5:7], v[1:4], s[8:15], s[12:15] dmask:0xb
// CHECK: [0x00,0x0b,0x94,0xf0,0x01,0x05,0x62,0x00]

image_sample_b v[5:6], v[1:4], s[8:15], s[12:15] dmask:0xc
// CHECK: [0x00,0x0c,0x94,0xf0,0x01,0x05,0x62,0x00]

image_sample_b v[5:7], v[1:4], s[8:15], s[12:15] dmask:0xd
// CHECK: [0x00,0x0d,0x94,0xf0,0x01,0x05,0x62,0x00]

image_sample_b v[5:7], v[1:4], s[8:15], s[12:15] dmask:0xe
// CHECK: [0x00,0x0e,0x94,0xf0,0x01,0x05,0x62,0x00]

image_sample_b v5, v[1:4], s[8:15], s[12:15] dmask:0x0
// CHECK: [0x00,0x00,0x94,0xf0,0x01,0x05,0x62,0x00]

image_sample_b v5, v[1:4], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x94,0xf0,0x01,0x05,0x62,0x00]

image_sample_b v5, v[1:4], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0x94,0xf0,0x01,0x05,0x62,0x00]

image_sample_b v5, v[1:4], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0x94,0xf2,0x01,0x05,0x62,0x00]

image_sample_b v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0x95,0xf0,0x01,0x05,0x62,0x00]

image_sample_b v5, v[1:4], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0x96,0xf0,0x01,0x05,0x62,0x00]

image_sample_b v5, v[1:4], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0x94,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x98,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_cl v252, v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x98,0xf0,0x01,0xfc,0x62,0x00]

image_sample_b_cl v5, v[252:255], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x98,0xf0,0xfc,0x05,0x62,0x00]

image_sample_b_cl v5, v[1:4], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x98,0xf0,0x01,0x05,0x63,0x00]

image_sample_b_cl v5, v[1:4], s[96:103], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x98,0xf0,0x01,0x05,0x78,0x00]

image_sample_b_cl v5, v[1:4], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x98,0xf0,0x01,0x05,0x7d,0x00]

image_sample_b_cl v5, v[1:4], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0x98,0xf0,0x01,0x05,0x82,0x00]

image_sample_b_cl v5, v[1:4], s[8:15], s[100:103] dmask:0x1
// CHECK: [0x00,0x01,0x98,0xf0,0x01,0x05,0x22,0x03]

image_sample_b_cl v5, v[1:4], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0x98,0xf0,0x01,0x05,0xc2,0x03]

image_sample_b_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0x98,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_cl v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x3
// CHECK: [0x00,0x03,0x98,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0x98,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_cl v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x5
// CHECK: [0x00,0x05,0x98,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_cl v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x6
// CHECK: [0x00,0x06,0x98,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_cl v[5:7], v[1:4], s[8:15], s[12:15] dmask:0x7
// CHECK: [0x00,0x07,0x98,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0x98,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_cl v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x9
// CHECK: [0x00,0x09,0x98,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_cl v[5:6], v[1:4], s[8:15], s[12:15] dmask:0xa
// CHECK: [0x00,0x0a,0x98,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_cl v[5:7], v[1:4], s[8:15], s[12:15] dmask:0xb
// CHECK: [0x00,0x0b,0x98,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_cl v[5:6], v[1:4], s[8:15], s[12:15] dmask:0xc
// CHECK: [0x00,0x0c,0x98,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_cl v[5:7], v[1:4], s[8:15], s[12:15] dmask:0xd
// CHECK: [0x00,0x0d,0x98,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_cl v[5:7], v[1:4], s[8:15], s[12:15] dmask:0xe
// CHECK: [0x00,0x0e,0x98,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x0
// CHECK: [0x00,0x00,0x98,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x98,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0x98,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0x98,0xf2,0x01,0x05,0x62,0x00]

image_sample_b_cl v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0x99,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0x9a,0xf0,0x01,0x05,0x62,0x00]

image_sample_b_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0x98,0xf0,0x01,0x05,0x62,0x00]

image_sample_lz v5, v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x9c,0xf0,0x01,0x05,0x62,0x00]

image_sample_lz v252, v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x9c,0xf0,0x01,0xfc,0x62,0x00]

image_sample_lz v5, v[252:255], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x9c,0xf0,0xfc,0x05,0x62,0x00]

image_sample_lz v5, v[1:4], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x9c,0xf0,0x01,0x05,0x63,0x00]

image_sample_lz v5, v[1:4], s[96:103], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x9c,0xf0,0x01,0x05,0x78,0x00]

image_sample_lz v5, v[1:4], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x9c,0xf0,0x01,0x05,0x7d,0x00]

image_sample_lz v5, v[1:4], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0x9c,0xf0,0x01,0x05,0x82,0x00]

image_sample_lz v5, v[1:4], s[8:15], s[100:103] dmask:0x1
// CHECK: [0x00,0x01,0x9c,0xf0,0x01,0x05,0x22,0x03]

image_sample_lz v5, v[1:4], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0x9c,0xf0,0x01,0x05,0xc2,0x03]

image_sample_lz v5, v[1:4], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0x9c,0xf0,0x01,0x05,0x62,0x00]

image_sample_lz v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x3
// CHECK: [0x00,0x03,0x9c,0xf0,0x01,0x05,0x62,0x00]

image_sample_lz v5, v[1:4], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0x9c,0xf0,0x01,0x05,0x62,0x00]

image_sample_lz v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x5
// CHECK: [0x00,0x05,0x9c,0xf0,0x01,0x05,0x62,0x00]

image_sample_lz v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x6
// CHECK: [0x00,0x06,0x9c,0xf0,0x01,0x05,0x62,0x00]

image_sample_lz v[5:7], v[1:4], s[8:15], s[12:15] dmask:0x7
// CHECK: [0x00,0x07,0x9c,0xf0,0x01,0x05,0x62,0x00]

image_sample_lz v5, v[1:4], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0x9c,0xf0,0x01,0x05,0x62,0x00]

image_sample_lz v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x9
// CHECK: [0x00,0x09,0x9c,0xf0,0x01,0x05,0x62,0x00]

image_sample_lz v[5:6], v[1:4], s[8:15], s[12:15] dmask:0xa
// CHECK: [0x00,0x0a,0x9c,0xf0,0x01,0x05,0x62,0x00]

image_sample_lz v[5:7], v[1:4], s[8:15], s[12:15] dmask:0xb
// CHECK: [0x00,0x0b,0x9c,0xf0,0x01,0x05,0x62,0x00]

image_sample_lz v[5:6], v[1:4], s[8:15], s[12:15] dmask:0xc
// CHECK: [0x00,0x0c,0x9c,0xf0,0x01,0x05,0x62,0x00]

image_sample_lz v[5:7], v[1:4], s[8:15], s[12:15] dmask:0xd
// CHECK: [0x00,0x0d,0x9c,0xf0,0x01,0x05,0x62,0x00]

image_sample_lz v[5:7], v[1:4], s[8:15], s[12:15] dmask:0xe
// CHECK: [0x00,0x0e,0x9c,0xf0,0x01,0x05,0x62,0x00]

image_sample_lz v5, v[1:4], s[8:15], s[12:15] dmask:0x0
// CHECK: [0x00,0x00,0x9c,0xf0,0x01,0x05,0x62,0x00]

image_sample_lz v5, v[1:4], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x9c,0xf0,0x01,0x05,0x62,0x00]

image_sample_lz v5, v[1:4], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0x9c,0xf0,0x01,0x05,0x62,0x00]

image_sample_lz v5, v[1:4], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0x9c,0xf2,0x01,0x05,0x62,0x00]

image_sample_lz v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0x9d,0xf0,0x01,0x05,0x62,0x00]

image_sample_lz v5, v[1:4], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0x9e,0xf0,0x01,0x05,0x62,0x00]

image_sample_lz v5, v[1:4], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0x9c,0xf0,0x01,0x05,0x62,0x00]

image_sample_c v5, v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xa0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c v252, v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xa0,0xf0,0x01,0xfc,0x62,0x00]

image_sample_c v5, v[252:255], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xa0,0xf0,0xfc,0x05,0x62,0x00]

image_sample_c v5, v[1:4], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xa0,0xf0,0x01,0x05,0x63,0x00]

image_sample_c v5, v[1:4], s[96:103], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xa0,0xf0,0x01,0x05,0x78,0x00]

image_sample_c v5, v[1:4], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xa0,0xf0,0x01,0x05,0x7d,0x00]

image_sample_c v5, v[1:4], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0xa0,0xf0,0x01,0x05,0x82,0x00]

image_sample_c v5, v[1:4], s[8:15], s[100:103] dmask:0x1
// CHECK: [0x00,0x01,0xa0,0xf0,0x01,0x05,0x22,0x03]

image_sample_c v5, v[1:4], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0xa0,0xf0,0x01,0x05,0xc2,0x03]

image_sample_c v5, v[1:4], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0xa0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x3
// CHECK: [0x00,0x03,0xa0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c v5, v[1:4], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0xa0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x5
// CHECK: [0x00,0x05,0xa0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x6
// CHECK: [0x00,0x06,0xa0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c v[5:7], v[1:4], s[8:15], s[12:15] dmask:0x7
// CHECK: [0x00,0x07,0xa0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c v5, v[1:4], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0xa0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x9
// CHECK: [0x00,0x09,0xa0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c v[5:6], v[1:4], s[8:15], s[12:15] dmask:0xa
// CHECK: [0x00,0x0a,0xa0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c v[5:7], v[1:4], s[8:15], s[12:15] dmask:0xb
// CHECK: [0x00,0x0b,0xa0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c v[5:6], v[1:4], s[8:15], s[12:15] dmask:0xc
// CHECK: [0x00,0x0c,0xa0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c v[5:7], v[1:4], s[8:15], s[12:15] dmask:0xd
// CHECK: [0x00,0x0d,0xa0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c v[5:7], v[1:4], s[8:15], s[12:15] dmask:0xe
// CHECK: [0x00,0x0e,0xa0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c v5, v[1:4], s[8:15], s[12:15] dmask:0x0
// CHECK: [0x00,0x00,0xa0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c v5, v[1:4], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0xa0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c v5, v[1:4], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0xa0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c v5, v[1:4], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0xa0,0xf2,0x01,0x05,0x62,0x00]

image_sample_c v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0xa1,0xf0,0x01,0x05,0x62,0x00]

image_sample_c v5, v[1:4], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0xa2,0xf0,0x01,0x05,0x62,0x00]

image_sample_c v5, v[1:4], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0xa0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xa4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_cl v252, v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xa4,0xf0,0x01,0xfc,0x62,0x00]

image_sample_c_cl v5, v[252:255], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xa4,0xf0,0xfc,0x05,0x62,0x00]

image_sample_c_cl v5, v[1:4], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xa4,0xf0,0x01,0x05,0x63,0x00]

image_sample_c_cl v5, v[1:4], s[96:103], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xa4,0xf0,0x01,0x05,0x78,0x00]

image_sample_c_cl v5, v[1:4], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xa4,0xf0,0x01,0x05,0x7d,0x00]

image_sample_c_cl v5, v[1:4], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0xa4,0xf0,0x01,0x05,0x82,0x00]

image_sample_c_cl v5, v[1:4], s[8:15], s[100:103] dmask:0x1
// CHECK: [0x00,0x01,0xa4,0xf0,0x01,0x05,0x22,0x03]

image_sample_c_cl v5, v[1:4], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0xa4,0xf0,0x01,0x05,0xc2,0x03]

image_sample_c_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0xa4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_cl v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x3
// CHECK: [0x00,0x03,0xa4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0xa4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_cl v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x5
// CHECK: [0x00,0x05,0xa4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_cl v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x6
// CHECK: [0x00,0x06,0xa4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_cl v[5:7], v[1:4], s[8:15], s[12:15] dmask:0x7
// CHECK: [0x00,0x07,0xa4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0xa4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_cl v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x9
// CHECK: [0x00,0x09,0xa4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_cl v[5:6], v[1:4], s[8:15], s[12:15] dmask:0xa
// CHECK: [0x00,0x0a,0xa4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_cl v[5:7], v[1:4], s[8:15], s[12:15] dmask:0xb
// CHECK: [0x00,0x0b,0xa4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_cl v[5:6], v[1:4], s[8:15], s[12:15] dmask:0xc
// CHECK: [0x00,0x0c,0xa4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_cl v[5:7], v[1:4], s[8:15], s[12:15] dmask:0xd
// CHECK: [0x00,0x0d,0xa4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_cl v[5:7], v[1:4], s[8:15], s[12:15] dmask:0xe
// CHECK: [0x00,0x0e,0xa4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x0
// CHECK: [0x00,0x00,0xa4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0xa4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0xa4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0xa4,0xf2,0x01,0x05,0x62,0x00]

image_sample_c_cl v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0xa5,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0xa6,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0xa4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d v5, v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xa8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d v252, v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xa8,0xf0,0x01,0xfc,0x62,0x00]

image_sample_c_d v5, v[252:255], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xa8,0xf0,0xfc,0x05,0x62,0x00]

image_sample_c_d v5, v[1:4], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xa8,0xf0,0x01,0x05,0x63,0x00]

image_sample_c_d v5, v[1:4], s[96:103], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xa8,0xf0,0x01,0x05,0x78,0x00]

image_sample_c_d v5, v[1:4], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xa8,0xf0,0x01,0x05,0x7d,0x00]

image_sample_c_d v5, v[1:4], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0xa8,0xf0,0x01,0x05,0x82,0x00]

image_sample_c_d v5, v[1:4], s[8:15], s[100:103] dmask:0x1
// CHECK: [0x00,0x01,0xa8,0xf0,0x01,0x05,0x22,0x03]

image_sample_c_d v5, v[1:4], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0xa8,0xf0,0x01,0x05,0xc2,0x03]

image_sample_c_d v5, v[1:4], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0xa8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x3
// CHECK: [0x00,0x03,0xa8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d v5, v[1:4], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0xa8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x5
// CHECK: [0x00,0x05,0xa8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x6
// CHECK: [0x00,0x06,0xa8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d v[5:7], v[1:4], s[8:15], s[12:15] dmask:0x7
// CHECK: [0x00,0x07,0xa8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d v5, v[1:4], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0xa8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x9
// CHECK: [0x00,0x09,0xa8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d v[5:6], v[1:4], s[8:15], s[12:15] dmask:0xa
// CHECK: [0x00,0x0a,0xa8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d v[5:7], v[1:4], s[8:15], s[12:15] dmask:0xb
// CHECK: [0x00,0x0b,0xa8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d v[5:6], v[1:4], s[8:15], s[12:15] dmask:0xc
// CHECK: [0x00,0x0c,0xa8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d v[5:7], v[1:4], s[8:15], s[12:15] dmask:0xd
// CHECK: [0x00,0x0d,0xa8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d v[5:7], v[1:4], s[8:15], s[12:15] dmask:0xe
// CHECK: [0x00,0x0e,0xa8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d v5, v[1:4], s[8:15], s[12:15] dmask:0x0
// CHECK: [0x00,0x00,0xa8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d v5, v[1:4], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0xa8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d v5, v[1:4], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0xa8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d v5, v[1:4], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0xa8,0xf2,0x01,0x05,0x62,0x00]

image_sample_c_d v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0xa9,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d v5, v[1:4], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0xaa,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_d v5, v[1:4], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0xa8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_l v5, v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xb0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_l v252, v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xb0,0xf0,0x01,0xfc,0x62,0x00]

image_sample_c_l v5, v[252:255], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xb0,0xf0,0xfc,0x05,0x62,0x00]

image_sample_c_l v5, v[1:4], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xb0,0xf0,0x01,0x05,0x63,0x00]

image_sample_c_l v5, v[1:4], s[96:103], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xb0,0xf0,0x01,0x05,0x78,0x00]

image_sample_c_l v5, v[1:4], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xb0,0xf0,0x01,0x05,0x7d,0x00]

image_sample_c_l v5, v[1:4], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0xb0,0xf0,0x01,0x05,0x82,0x00]

image_sample_c_l v5, v[1:4], s[8:15], s[100:103] dmask:0x1
// CHECK: [0x00,0x01,0xb0,0xf0,0x01,0x05,0x22,0x03]

image_sample_c_l v5, v[1:4], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0xb0,0xf0,0x01,0x05,0xc2,0x03]

image_sample_c_l v5, v[1:4], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0xb0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_l v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x3
// CHECK: [0x00,0x03,0xb0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_l v5, v[1:4], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0xb0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_l v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x5
// CHECK: [0x00,0x05,0xb0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_l v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x6
// CHECK: [0x00,0x06,0xb0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_l v[5:7], v[1:4], s[8:15], s[12:15] dmask:0x7
// CHECK: [0x00,0x07,0xb0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_l v5, v[1:4], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0xb0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_l v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x9
// CHECK: [0x00,0x09,0xb0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_l v[5:6], v[1:4], s[8:15], s[12:15] dmask:0xa
// CHECK: [0x00,0x0a,0xb0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_l v[5:7], v[1:4], s[8:15], s[12:15] dmask:0xb
// CHECK: [0x00,0x0b,0xb0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_l v[5:6], v[1:4], s[8:15], s[12:15] dmask:0xc
// CHECK: [0x00,0x0c,0xb0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_l v[5:7], v[1:4], s[8:15], s[12:15] dmask:0xd
// CHECK: [0x00,0x0d,0xb0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_l v[5:7], v[1:4], s[8:15], s[12:15] dmask:0xe
// CHECK: [0x00,0x0e,0xb0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_l v5, v[1:4], s[8:15], s[12:15] dmask:0x0
// CHECK: [0x00,0x00,0xb0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_l v5, v[1:4], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0xb0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_l v5, v[1:4], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0xb0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_l v5, v[1:4], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0xb0,0xf2,0x01,0x05,0x62,0x00]

image_sample_c_l v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0xb1,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_l v5, v[1:4], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0xb2,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_l v5, v[1:4], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0xb0,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b v5, v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xb4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b v252, v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xb4,0xf0,0x01,0xfc,0x62,0x00]

image_sample_c_b v5, v[252:255], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xb4,0xf0,0xfc,0x05,0x62,0x00]

image_sample_c_b v5, v[1:4], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xb4,0xf0,0x01,0x05,0x63,0x00]

image_sample_c_b v5, v[1:4], s[96:103], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xb4,0xf0,0x01,0x05,0x78,0x00]

image_sample_c_b v5, v[1:4], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xb4,0xf0,0x01,0x05,0x7d,0x00]

image_sample_c_b v5, v[1:4], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0xb4,0xf0,0x01,0x05,0x82,0x00]

image_sample_c_b v5, v[1:4], s[8:15], s[100:103] dmask:0x1
// CHECK: [0x00,0x01,0xb4,0xf0,0x01,0x05,0x22,0x03]

image_sample_c_b v5, v[1:4], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0xb4,0xf0,0x01,0x05,0xc2,0x03]

image_sample_c_b v5, v[1:4], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0xb4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x3
// CHECK: [0x00,0x03,0xb4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b v5, v[1:4], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0xb4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x5
// CHECK: [0x00,0x05,0xb4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x6
// CHECK: [0x00,0x06,0xb4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b v[5:7], v[1:4], s[8:15], s[12:15] dmask:0x7
// CHECK: [0x00,0x07,0xb4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b v5, v[1:4], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0xb4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x9
// CHECK: [0x00,0x09,0xb4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b v[5:6], v[1:4], s[8:15], s[12:15] dmask:0xa
// CHECK: [0x00,0x0a,0xb4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b v[5:7], v[1:4], s[8:15], s[12:15] dmask:0xb
// CHECK: [0x00,0x0b,0xb4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b v[5:6], v[1:4], s[8:15], s[12:15] dmask:0xc
// CHECK: [0x00,0x0c,0xb4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b v[5:7], v[1:4], s[8:15], s[12:15] dmask:0xd
// CHECK: [0x00,0x0d,0xb4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b v[5:7], v[1:4], s[8:15], s[12:15] dmask:0xe
// CHECK: [0x00,0x0e,0xb4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b v5, v[1:4], s[8:15], s[12:15] dmask:0x0
// CHECK: [0x00,0x00,0xb4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b v5, v[1:4], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0xb4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b v5, v[1:4], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0xb4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b v5, v[1:4], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0xb4,0xf2,0x01,0x05,0x62,0x00]

image_sample_c_b v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0xb5,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b v5, v[1:4], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0xb6,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b v5, v[1:4], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0xb4,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xb8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_cl v252, v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xb8,0xf0,0x01,0xfc,0x62,0x00]

image_sample_c_b_cl v5, v[252:255], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xb8,0xf0,0xfc,0x05,0x62,0x00]

image_sample_c_b_cl v5, v[1:4], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xb8,0xf0,0x01,0x05,0x63,0x00]

image_sample_c_b_cl v5, v[1:4], s[96:103], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xb8,0xf0,0x01,0x05,0x78,0x00]

image_sample_c_b_cl v5, v[1:4], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xb8,0xf0,0x01,0x05,0x7d,0x00]

image_sample_c_b_cl v5, v[1:4], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0xb8,0xf0,0x01,0x05,0x82,0x00]

image_sample_c_b_cl v5, v[1:4], s[8:15], s[100:103] dmask:0x1
// CHECK: [0x00,0x01,0xb8,0xf0,0x01,0x05,0x22,0x03]

image_sample_c_b_cl v5, v[1:4], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0xb8,0xf0,0x01,0x05,0xc2,0x03]

image_sample_c_b_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0xb8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_cl v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x3
// CHECK: [0x00,0x03,0xb8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0xb8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_cl v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x5
// CHECK: [0x00,0x05,0xb8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_cl v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x6
// CHECK: [0x00,0x06,0xb8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_cl v[5:7], v[1:4], s[8:15], s[12:15] dmask:0x7
// CHECK: [0x00,0x07,0xb8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0xb8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_cl v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x9
// CHECK: [0x00,0x09,0xb8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_cl v[5:6], v[1:4], s[8:15], s[12:15] dmask:0xa
// CHECK: [0x00,0x0a,0xb8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_cl v[5:7], v[1:4], s[8:15], s[12:15] dmask:0xb
// CHECK: [0x00,0x0b,0xb8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_cl v[5:6], v[1:4], s[8:15], s[12:15] dmask:0xc
// CHECK: [0x00,0x0c,0xb8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_cl v[5:7], v[1:4], s[8:15], s[12:15] dmask:0xd
// CHECK: [0x00,0x0d,0xb8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_cl v[5:7], v[1:4], s[8:15], s[12:15] dmask:0xe
// CHECK: [0x00,0x0e,0xb8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x0
// CHECK: [0x00,0x00,0xb8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0xb8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0xb8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0xb8,0xf2,0x01,0x05,0x62,0x00]

image_sample_c_b_cl v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0xb9,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0xba,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_b_cl v5, v[1:4], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0xb8,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_lz v5, v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xbc,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_lz v252, v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xbc,0xf0,0x01,0xfc,0x62,0x00]

image_sample_c_lz v5, v[252:255], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xbc,0xf0,0xfc,0x05,0x62,0x00]

image_sample_c_lz v5, v[1:4], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xbc,0xf0,0x01,0x05,0x63,0x00]

image_sample_c_lz v5, v[1:4], s[96:103], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xbc,0xf0,0x01,0x05,0x78,0x00]

image_sample_c_lz v5, v[1:4], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xbc,0xf0,0x01,0x05,0x7d,0x00]

image_sample_c_lz v5, v[1:4], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0xbc,0xf0,0x01,0x05,0x82,0x00]

image_sample_c_lz v5, v[1:4], s[8:15], s[100:103] dmask:0x1
// CHECK: [0x00,0x01,0xbc,0xf0,0x01,0x05,0x22,0x03]

image_sample_c_lz v5, v[1:4], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0xbc,0xf0,0x01,0x05,0xc2,0x03]

image_sample_c_lz v5, v[1:4], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0xbc,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_lz v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x3
// CHECK: [0x00,0x03,0xbc,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_lz v5, v[1:4], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0xbc,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_lz v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x5
// CHECK: [0x00,0x05,0xbc,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_lz v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x6
// CHECK: [0x00,0x06,0xbc,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_lz v[5:7], v[1:4], s[8:15], s[12:15] dmask:0x7
// CHECK: [0x00,0x07,0xbc,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_lz v5, v[1:4], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0xbc,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_lz v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x9
// CHECK: [0x00,0x09,0xbc,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_lz v[5:6], v[1:4], s[8:15], s[12:15] dmask:0xa
// CHECK: [0x00,0x0a,0xbc,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_lz v[5:7], v[1:4], s[8:15], s[12:15] dmask:0xb
// CHECK: [0x00,0x0b,0xbc,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_lz v[5:6], v[1:4], s[8:15], s[12:15] dmask:0xc
// CHECK: [0x00,0x0c,0xbc,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_lz v[5:7], v[1:4], s[8:15], s[12:15] dmask:0xd
// CHECK: [0x00,0x0d,0xbc,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_lz v[5:7], v[1:4], s[8:15], s[12:15] dmask:0xe
// CHECK: [0x00,0x0e,0xbc,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_lz v5, v[1:4], s[8:15], s[12:15] dmask:0x0
// CHECK: [0x00,0x00,0xbc,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_lz v5, v[1:4], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0xbc,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_lz v5, v[1:4], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0xbc,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_lz v5, v[1:4], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0xbc,0xf2,0x01,0x05,0x62,0x00]

image_sample_c_lz v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0xbd,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_lz v5, v[1:4], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0xbe,0xf0,0x01,0x05,0x62,0x00]

image_sample_c_lz v5, v[1:4], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0xbc,0xf0,0x01,0x05,0x62,0x00]

image_gather4 v[5:8], v1, s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x00,0xf1,0x01,0x05,0x62,0x00]

image_gather4 v[252:255], v1, s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x00,0xf1,0x01,0xfc,0x62,0x00]

image_gather4 v[5:8], v255, s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x00,0xf1,0xff,0x05,0x62,0x00]

image_gather4 v[5:8], v1, s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x00,0xf1,0x01,0x05,0x63,0x00]

image_gather4 v[5:8], v1, s[96:103], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x00,0xf1,0x01,0x05,0x78,0x00]

image_gather4 v[5:8], v1, ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x00,0xf1,0x01,0x05,0x7d,0x00]

image_gather4 v[5:8], v1, s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0x00,0xf1,0x01,0x05,0x82,0x00]

image_gather4 v[5:8], v1, s[8:15], s[100:103] dmask:0x1
// CHECK: [0x00,0x01,0x00,0xf1,0x01,0x05,0x22,0x03]

image_gather4 v[5:8], v1, s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0x00,0xf1,0x01,0x05,0xc2,0x03]

image_gather4 v[5:8], v1, s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0x00,0xf1,0x01,0x05,0x62,0x00]

image_gather4 v[5:8], v1, s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0x00,0xf1,0x01,0x05,0x62,0x00]

image_gather4 v[5:8], v1, s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0x00,0xf1,0x01,0x05,0x62,0x00]

image_gather4 v[5:8], v1, s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x00,0xf1,0x01,0x05,0x62,0x00]

image_gather4 v[5:8], v1, s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0x00,0xf1,0x01,0x05,0x62,0x00]

image_gather4 v[5:8], v1, s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0x00,0xf3,0x01,0x05,0x62,0x00]

image_gather4 v[5:8], v1, s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0x02,0xf1,0x01,0x05,0x62,0x00]

image_gather4 v[5:8], v1, s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0x00,0xf1,0x01,0x05,0x62,0x00]

image_gather4_cl v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x04,0xf1,0x01,0x05,0x62,0x00]

image_gather4_cl v[252:255], v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x04,0xf1,0x01,0xfc,0x62,0x00]

image_gather4_cl v[5:8], v[254:255], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x04,0xf1,0xfe,0x05,0x62,0x00]

image_gather4_cl v[5:8], v[1:4], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x04,0xf1,0x01,0x05,0x63,0x00]

image_gather4_cl v[5:8], v[1:4], s[96:103], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x04,0xf1,0x01,0x05,0x78,0x00]

image_gather4_cl v[5:8], v[1:4], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x04,0xf1,0x01,0x05,0x7d,0x00]

image_gather4_cl v[5:8], v[1:4], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0x04,0xf1,0x01,0x05,0x82,0x00]

image_gather4_cl v[5:8], v[1:4], s[8:15], s[100:103] dmask:0x1
// CHECK: [0x00,0x01,0x04,0xf1,0x01,0x05,0x22,0x03]

image_gather4_cl v[5:8], v[1:4], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0x04,0xf1,0x01,0x05,0xc2,0x03]

image_gather4_cl v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0x04,0xf1,0x01,0x05,0x62,0x00]

image_gather4_cl v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0x04,0xf1,0x01,0x05,0x62,0x00]

image_gather4_cl v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0x04,0xf1,0x01,0x05,0x62,0x00]

image_gather4_cl v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x04,0xf1,0x01,0x05,0x62,0x00]

image_gather4_cl v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0x04,0xf1,0x01,0x05,0x62,0x00]

image_gather4_cl v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0x04,0xf3,0x01,0x05,0x62,0x00]

image_gather4_cl v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0x06,0xf1,0x01,0x05,0x62,0x00]

image_gather4_cl v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0x04,0xf1,0x01,0x05,0x62,0x00]

image_gather4_l v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x10,0xf1,0x01,0x05,0x62,0x00]

image_gather4_l v[252:255], v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x10,0xf1,0x01,0xfc,0x62,0x00]

image_gather4_l v[5:8], v255, s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x10,0xf1,0xff,0x05,0x62,0x00]

image_gather4_l v[5:8], v[1:4], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x10,0xf1,0x01,0x05,0x63,0x00]

image_gather4_l v[5:8], v[1:4], s[96:103], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x10,0xf1,0x01,0x05,0x78,0x00]

image_gather4_l v[5:8], v1, ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x10,0xf1,0x01,0x05,0x7d,0x00]

image_gather4_l v[5:8], v[1:4], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0x10,0xf1,0x01,0x05,0x82,0x00]

image_gather4_l v[5:8], v[1:4], s[8:15], s[100:103] dmask:0x1
// CHECK: [0x00,0x01,0x10,0xf1,0x01,0x05,0x22,0x03]

image_gather4_l v[5:8], v[1:4], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0x10,0xf1,0x01,0x05,0xc2,0x03]

image_gather4_l v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0x10,0xf1,0x01,0x05,0x62,0x00]

image_gather4_l v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0x10,0xf1,0x01,0x05,0x62,0x00]

image_gather4_l v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0x10,0xf1,0x01,0x05,0x62,0x00]

image_gather4_l v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x10,0xf1,0x01,0x05,0x62,0x00]

image_gather4_l v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0x10,0xf1,0x01,0x05,0x62,0x00]

image_gather4_l v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0x10,0xf3,0x01,0x05,0x62,0x00]

image_gather4_l v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0x12,0xf1,0x01,0x05,0x62,0x00]

image_gather4_l v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0x10,0xf1,0x01,0x05,0x62,0x00]

image_gather4_b v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x14,0xf1,0x01,0x05,0x62,0x00]

image_gather4_b v[252:255], v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x14,0xf1,0x01,0xfc,0x62,0x00]

image_gather4_b v[5:8], v[254:255], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x14,0xf1,0xfe,0x05,0x62,0x00]

image_gather4_b v[5:8], v[1:4], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x14,0xf1,0x01,0x05,0x63,0x00]

image_gather4_b v[5:8], v[1:4], s[96:103], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x14,0xf1,0x01,0x05,0x78,0x00]

image_gather4_b v[5:8], v[1:4], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x14,0xf1,0x01,0x05,0x7d,0x00]

image_gather4_b v[5:8], v[1:4], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0x14,0xf1,0x01,0x05,0x82,0x00]

image_gather4_b v[5:8], v[1:4], s[8:15], s[100:103] dmask:0x1
// CHECK: [0x00,0x01,0x14,0xf1,0x01,0x05,0x22,0x03]

image_gather4_b v[5:8], v[1:4], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0x14,0xf1,0x01,0x05,0xc2,0x03]

image_gather4_b v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0x14,0xf1,0x01,0x05,0x62,0x00]

image_gather4_b v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0x14,0xf1,0x01,0x05,0x62,0x00]

image_gather4_b v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0x14,0xf1,0x01,0x05,0x62,0x00]

image_gather4_b v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x14,0xf1,0x01,0x05,0x62,0x00]

image_gather4_b v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0x14,0xf1,0x01,0x05,0x62,0x00]

image_gather4_b v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0x14,0xf3,0x01,0x05,0x62,0x00]

image_gather4_b v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0x16,0xf1,0x01,0x05,0x62,0x00]

image_gather4_b v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0x14,0xf1,0x01,0x05,0x62,0x00]

image_gather4_b_cl v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x18,0xf1,0x01,0x05,0x62,0x00]

image_gather4_b_cl v[252:255], v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x18,0xf1,0x01,0xfc,0x62,0x00]

image_gather4_b_cl v[5:8], v[253:255], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x18,0xf1,0xfd,0x05,0x62,0x00]

image_gather4_b_cl v[5:8], v[1:4], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x18,0xf1,0x01,0x05,0x63,0x00]

image_gather4_b_cl v[5:8], v[1:4], s[96:103], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x18,0xf1,0x01,0x05,0x78,0x00]

image_gather4_b_cl v[5:8], v[1:4], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x18,0xf1,0x01,0x05,0x7d,0x00]

image_gather4_b_cl v[5:8], v[1:4], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0x18,0xf1,0x01,0x05,0x82,0x00]

image_gather4_b_cl v[5:8], v[1:4], s[8:15], s[100:103] dmask:0x1
// CHECK: [0x00,0x01,0x18,0xf1,0x01,0x05,0x22,0x03]

image_gather4_b_cl v[5:8], v[1:4], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0x18,0xf1,0x01,0x05,0xc2,0x03]

image_gather4_b_cl v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0x18,0xf1,0x01,0x05,0x62,0x00]

image_gather4_b_cl v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0x18,0xf1,0x01,0x05,0x62,0x00]

image_gather4_b_cl v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0x18,0xf1,0x01,0x05,0x62,0x00]

image_gather4_b_cl v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x18,0xf1,0x01,0x05,0x62,0x00]

image_gather4_b_cl v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0x18,0xf1,0x01,0x05,0x62,0x00]

image_gather4_b_cl v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0x18,0xf3,0x01,0x05,0x62,0x00]

image_gather4_b_cl v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0x1a,0xf1,0x01,0x05,0x62,0x00]

image_gather4_b_cl v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0x18,0xf1,0x01,0x05,0x62,0x00]

image_gather4_lz v[5:8], v1, s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x1c,0xf1,0x01,0x05,0x62,0x00]

image_gather4_lz v[252:255], v1, s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x1c,0xf1,0x01,0xfc,0x62,0x00]

image_gather4_lz v[5:8], v255, s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x1c,0xf1,0xff,0x05,0x62,0x00]

image_gather4_lz v[5:8], v1, s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x1c,0xf1,0x01,0x05,0x63,0x00]

image_gather4_lz v[5:8], v1, s[96:103], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x1c,0xf1,0x01,0x05,0x78,0x00]

image_gather4_lz v[5:8], v1, ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x1c,0xf1,0x01,0x05,0x7d,0x00]

image_gather4_lz v[5:8], v1, s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0x1c,0xf1,0x01,0x05,0x82,0x00]

image_gather4_lz v[5:8], v1, s[8:15], s[100:103] dmask:0x1
// CHECK: [0x00,0x01,0x1c,0xf1,0x01,0x05,0x22,0x03]

image_gather4_lz v[5:8], v1, s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0x1c,0xf1,0x01,0x05,0xc2,0x03]

image_gather4_lz v[5:8], v1, s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0x1c,0xf1,0x01,0x05,0x62,0x00]

image_gather4_lz v[5:8], v1, s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0x1c,0xf1,0x01,0x05,0x62,0x00]

image_gather4_lz v[5:8], v1, s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0x1c,0xf1,0x01,0x05,0x62,0x00]

image_gather4_lz v[5:8], v1, s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x1c,0xf1,0x01,0x05,0x62,0x00]

image_gather4_lz v[5:8], v1, s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0x1c,0xf1,0x01,0x05,0x62,0x00]

image_gather4_lz v[5:8], v1, s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0x1c,0xf3,0x01,0x05,0x62,0x00]

image_gather4_lz v[5:8], v1, s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0x1e,0xf1,0x01,0x05,0x62,0x00]

image_gather4_lz v[5:8], v1, s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0x1c,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x20,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c v[252:255], v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x20,0xf1,0x01,0xfc,0x62,0x00]

image_gather4_c v[5:8], v[254:255], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x20,0xf1,0xfe,0x05,0x62,0x00]

image_gather4_c v[5:8], v[1:4], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x20,0xf1,0x01,0x05,0x63,0x00]

image_gather4_c v[5:8], v[1:4], s[96:103], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x20,0xf1,0x01,0x05,0x78,0x00]

image_gather4_c v[5:8], v[1:4], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x20,0xf1,0x01,0x05,0x7d,0x00]

image_gather4_c v[5:8], v[1:4], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0x20,0xf1,0x01,0x05,0x82,0x00]

image_gather4_c v[5:8], v[1:4], s[8:15], s[100:103] dmask:0x1
// CHECK: [0x00,0x01,0x20,0xf1,0x01,0x05,0x22,0x03]

image_gather4_c v[5:8], v[1:4], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0x20,0xf1,0x01,0x05,0xc2,0x03]

image_gather4_c v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0x20,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0x20,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0x20,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x20,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0x20,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0x20,0xf3,0x01,0x05,0x62,0x00]

image_gather4_c v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0x22,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0x20,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_cl v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x24,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_cl v[252:255], v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x24,0xf1,0x01,0xfc,0x62,0x00]

image_gather4_c_cl v[5:8], v[253:255], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x24,0xf1,0xfd,0x05,0x62,0x00]

image_gather4_c_cl v[5:8], v[1:4], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x24,0xf1,0x01,0x05,0x63,0x00]

image_gather4_c_cl v[5:8], v[1:4], s[96:103], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x24,0xf1,0x01,0x05,0x78,0x00]

image_gather4_c_cl v[5:8], v[1:4], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x24,0xf1,0x01,0x05,0x7d,0x00]

image_gather4_c_cl v[5:8], v[1:4], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0x24,0xf1,0x01,0x05,0x82,0x00]

image_gather4_c_cl v[5:8], v[1:4], s[8:15], s[100:103] dmask:0x1
// CHECK: [0x00,0x01,0x24,0xf1,0x01,0x05,0x22,0x03]

image_gather4_c_cl v[5:8], v[1:4], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0x24,0xf1,0x01,0x05,0xc2,0x03]

image_gather4_c_cl v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0x24,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_cl v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0x24,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_cl v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0x24,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_cl v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x24,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_cl v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0x24,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_cl v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0x24,0xf3,0x01,0x05,0x62,0x00]

image_gather4_c_cl v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0x26,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_cl v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0x24,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_l v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x30,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_l v[252:255], v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x30,0xf1,0x01,0xfc,0x62,0x00]

image_gather4_c_l v[5:8], v[253:255], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x30,0xf1,0xfd,0x05,0x62,0x00]

image_gather4_c_l v[5:8], v[1:4], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x30,0xf1,0x01,0x05,0x63,0x00]

image_gather4_c_l v[5:8], v[1:4], s[96:103], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x30,0xf1,0x01,0x05,0x78,0x00]

image_gather4_c_l v[5:8], v[1:4], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x30,0xf1,0x01,0x05,0x7d,0x00]

image_gather4_c_l v[5:8], v[1:4], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0x30,0xf1,0x01,0x05,0x82,0x00]

image_gather4_c_l v[5:8], v[1:4], s[8:15], s[100:103] dmask:0x1
// CHECK: [0x00,0x01,0x30,0xf1,0x01,0x05,0x22,0x03]

image_gather4_c_l v[5:8], v[1:4], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0x30,0xf1,0x01,0x05,0xc2,0x03]

image_gather4_c_l v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0x30,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_l v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0x30,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_l v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0x30,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_l v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x30,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_l v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0x30,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_l v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0x30,0xf3,0x01,0x05,0x62,0x00]

image_gather4_c_l v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0x32,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_l v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0x30,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_b v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x34,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_b v[252:255], v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x34,0xf1,0x01,0xfc,0x62,0x00]

image_gather4_c_b v[5:8], v[253:255], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x34,0xf1,0xfd,0x05,0x62,0x00]

image_gather4_c_b v[5:8], v[1:4], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x34,0xf1,0x01,0x05,0x63,0x00]

image_gather4_c_b v[5:8], v[1:4], s[96:103], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x34,0xf1,0x01,0x05,0x78,0x00]

image_gather4_c_b v[5:8], v[1:4], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x34,0xf1,0x01,0x05,0x7d,0x00]

image_gather4_c_b v[5:8], v[1:4], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0x34,0xf1,0x01,0x05,0x82,0x00]

image_gather4_c_b v[5:8], v[1:4], s[8:15], s[100:103] dmask:0x1
// CHECK: [0x00,0x01,0x34,0xf1,0x01,0x05,0x22,0x03]

image_gather4_c_b v[5:8], v[1:4], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0x34,0xf1,0x01,0x05,0xc2,0x03]

image_gather4_c_b v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0x34,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_b v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0x34,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_b v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0x34,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_b v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x34,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_b v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0x34,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_b v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0x34,0xf3,0x01,0x05,0x62,0x00]

image_gather4_c_b v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0x36,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_b v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0x34,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_b_cl v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x38,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_b_cl v[252:255], v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x38,0xf1,0x01,0xfc,0x62,0x00]

image_gather4_c_b_cl v[5:8], v[252:255], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x38,0xf1,0xfc,0x05,0x62,0x00]

image_gather4_c_b_cl v[5:8], v[1:4], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x38,0xf1,0x01,0x05,0x63,0x00]

image_gather4_c_b_cl v[5:8], v[1:4], s[96:103], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x38,0xf1,0x01,0x05,0x78,0x00]

image_gather4_c_b_cl v[5:8], v[1:4], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x38,0xf1,0x01,0x05,0x7d,0x00]

image_gather4_c_b_cl v[5:8], v[1:4], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0x38,0xf1,0x01,0x05,0x82,0x00]

image_gather4_c_b_cl v[5:8], v[1:4], s[8:15], s[100:103] dmask:0x1
// CHECK: [0x00,0x01,0x38,0xf1,0x01,0x05,0x22,0x03]

image_gather4_c_b_cl v[5:8], v[1:4], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0x38,0xf1,0x01,0x05,0xc2,0x03]

image_gather4_c_b_cl v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0x38,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_b_cl v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0x38,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_b_cl v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0x38,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_b_cl v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x38,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_b_cl v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0x38,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_b_cl v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0x38,0xf3,0x01,0x05,0x62,0x00]

image_gather4_c_b_cl v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0x3a,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_b_cl v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0x38,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_lz v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x3c,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_lz v[252:255], v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x3c,0xf1,0x01,0xfc,0x62,0x00]

image_gather4_c_lz v[5:8], v[254:255], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x3c,0xf1,0xfe,0x05,0x62,0x00]

image_gather4_c_lz v[5:8], v[1:4], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x3c,0xf1,0x01,0x05,0x63,0x00]

image_gather4_c_lz v[5:8], v[1:4], s[96:103], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x3c,0xf1,0x01,0x05,0x78,0x00]

image_gather4_c_lz v[5:8], v[1:4], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x3c,0xf1,0x01,0x05,0x7d,0x00]

image_gather4_c_lz v[5:8], v[1:4], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0x3c,0xf1,0x01,0x05,0x82,0x00]

image_gather4_c_lz v[5:8], v[1:4], s[8:15], s[100:103] dmask:0x1
// CHECK: [0x00,0x01,0x3c,0xf1,0x01,0x05,0x22,0x03]

image_gather4_c_lz v[5:8], v[1:4], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0x3c,0xf1,0x01,0x05,0xc2,0x03]

image_gather4_c_lz v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0x3c,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_lz v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0x3c,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_lz v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0x3c,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_lz v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x3c,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_lz v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0x3c,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_lz v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0x3c,0xf3,0x01,0x05,0x62,0x00]

image_gather4_c_lz v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0x3e,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_lz v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0x3c,0xf1,0x01,0x05,0x62,0x00]

image_gather4_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x40,0xf1,0x01,0x05,0x62,0x00]

image_gather4_o v[252:255], v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x40,0xf1,0x01,0xfc,0x62,0x00]

image_gather4_o v[5:8], v[254:255], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x40,0xf1,0xfe,0x05,0x62,0x00]

image_gather4_o v[5:8], v[1:4], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x40,0xf1,0x01,0x05,0x63,0x00]

image_gather4_o v[5:8], v[1:4], s[96:103], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x40,0xf1,0x01,0x05,0x78,0x00]

image_gather4_o v[5:8], v[1:4], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x40,0xf1,0x01,0x05,0x7d,0x00]

image_gather4_o v[5:8], v[1:4], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0x40,0xf1,0x01,0x05,0x82,0x00]

image_gather4_o v[5:8], v[1:4], s[8:15], s[100:103] dmask:0x1
// CHECK: [0x00,0x01,0x40,0xf1,0x01,0x05,0x22,0x03]

image_gather4_o v[5:8], v[1:4], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0x40,0xf1,0x01,0x05,0xc2,0x03]

image_gather4_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0x40,0xf1,0x01,0x05,0x62,0x00]

image_gather4_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0x40,0xf1,0x01,0x05,0x62,0x00]

image_gather4_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0x40,0xf1,0x01,0x05,0x62,0x00]

image_gather4_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x40,0xf1,0x01,0x05,0x62,0x00]

image_gather4_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0x40,0xf1,0x01,0x05,0x62,0x00]

image_gather4_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0x40,0xf3,0x01,0x05,0x62,0x00]

image_gather4_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0x42,0xf1,0x01,0x05,0x62,0x00]

image_gather4_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0x40,0xf1,0x01,0x05,0x62,0x00]

image_gather4_cl_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x44,0xf1,0x01,0x05,0x62,0x00]

image_gather4_cl_o v[252:255], v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x44,0xf1,0x01,0xfc,0x62,0x00]

image_gather4_cl_o v[5:8], v[253:255], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x44,0xf1,0xfd,0x05,0x62,0x00]

image_gather4_cl_o v[5:8], v[1:4], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x44,0xf1,0x01,0x05,0x63,0x00]

image_gather4_cl_o v[5:8], v[1:4], s[96:103], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x44,0xf1,0x01,0x05,0x78,0x00]

image_gather4_cl_o v[5:8], v[1:4], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x44,0xf1,0x01,0x05,0x7d,0x00]

image_gather4_cl_o v[5:8], v[1:4], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0x44,0xf1,0x01,0x05,0x82,0x00]

image_gather4_cl_o v[5:8], v[1:4], s[8:15], s[100:103] dmask:0x1
// CHECK: [0x00,0x01,0x44,0xf1,0x01,0x05,0x22,0x03]

image_gather4_cl_o v[5:8], v[1:4], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0x44,0xf1,0x01,0x05,0xc2,0x03]

image_gather4_cl_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0x44,0xf1,0x01,0x05,0x62,0x00]

image_gather4_cl_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0x44,0xf1,0x01,0x05,0x62,0x00]

image_gather4_cl_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0x44,0xf1,0x01,0x05,0x62,0x00]

image_gather4_cl_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x44,0xf1,0x01,0x05,0x62,0x00]

image_gather4_cl_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0x44,0xf1,0x01,0x05,0x62,0x00]

image_gather4_cl_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0x44,0xf3,0x01,0x05,0x62,0x00]

image_gather4_cl_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0x46,0xf1,0x01,0x05,0x62,0x00]

image_gather4_cl_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0x44,0xf1,0x01,0x05,0x62,0x00]

image_gather4_l_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x50,0xf1,0x01,0x05,0x62,0x00]

image_gather4_l_o v[252:255], v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x50,0xf1,0x01,0xfc,0x62,0x00]

image_gather4_l_o v[5:8], v[253:255], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x50,0xf1,0xfd,0x05,0x62,0x00]

image_gather4_l_o v[5:8], v[1:4], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x50,0xf1,0x01,0x05,0x63,0x00]

image_gather4_l_o v[5:8], v[1:4], s[96:103], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x50,0xf1,0x01,0x05,0x78,0x00]

image_gather4_l_o v[5:8], v[1:4], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x50,0xf1,0x01,0x05,0x7d,0x00]

image_gather4_l_o v[5:8], v[1:4], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0x50,0xf1,0x01,0x05,0x82,0x00]

image_gather4_l_o v[5:8], v[1:4], s[8:15], s[100:103] dmask:0x1
// CHECK: [0x00,0x01,0x50,0xf1,0x01,0x05,0x22,0x03]

image_gather4_l_o v[5:8], v[1:4], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0x50,0xf1,0x01,0x05,0xc2,0x03]

image_gather4_l_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0x50,0xf1,0x01,0x05,0x62,0x00]

image_gather4_l_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0x50,0xf1,0x01,0x05,0x62,0x00]

image_gather4_l_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0x50,0xf1,0x01,0x05,0x62,0x00]

image_gather4_l_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x50,0xf1,0x01,0x05,0x62,0x00]

image_gather4_l_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0x50,0xf1,0x01,0x05,0x62,0x00]

image_gather4_l_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0x50,0xf3,0x01,0x05,0x62,0x00]

image_gather4_l_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0x52,0xf1,0x01,0x05,0x62,0x00]

image_gather4_l_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0x50,0xf1,0x01,0x05,0x62,0x00]

image_gather4_b_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x54,0xf1,0x01,0x05,0x62,0x00]

image_gather4_b_o v[252:255], v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x54,0xf1,0x01,0xfc,0x62,0x00]

image_gather4_b_o v[5:8], v[253:255], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x54,0xf1,0xfd,0x05,0x62,0x00]

image_gather4_b_o v[5:8], v[1:4], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x54,0xf1,0x01,0x05,0x63,0x00]

image_gather4_b_o v[5:8], v[1:4], s[96:103], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x54,0xf1,0x01,0x05,0x78,0x00]

image_gather4_b_o v[5:8], v[1:4], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x54,0xf1,0x01,0x05,0x7d,0x00]

image_gather4_b_o v[5:8], v[1:4], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0x54,0xf1,0x01,0x05,0x82,0x00]

image_gather4_b_o v[5:8], v[1:4], s[8:15], s[100:103] dmask:0x1
// CHECK: [0x00,0x01,0x54,0xf1,0x01,0x05,0x22,0x03]

image_gather4_b_o v[5:8], v[1:4], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0x54,0xf1,0x01,0x05,0xc2,0x03]

image_gather4_b_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0x54,0xf1,0x01,0x05,0x62,0x00]

image_gather4_b_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0x54,0xf1,0x01,0x05,0x62,0x00]

image_gather4_b_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0x54,0xf1,0x01,0x05,0x62,0x00]

image_gather4_b_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x54,0xf1,0x01,0x05,0x62,0x00]

image_gather4_b_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0x54,0xf1,0x01,0x05,0x62,0x00]

image_gather4_b_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0x54,0xf3,0x01,0x05,0x62,0x00]

image_gather4_b_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0x56,0xf1,0x01,0x05,0x62,0x00]

image_gather4_b_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0x54,0xf1,0x01,0x05,0x62,0x00]

image_gather4_b_cl_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x58,0xf1,0x01,0x05,0x62,0x00]

image_gather4_b_cl_o v[252:255], v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x58,0xf1,0x01,0xfc,0x62,0x00]

image_gather4_b_cl_o v[5:8], v[252:255], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x58,0xf1,0xfc,0x05,0x62,0x00]

image_gather4_b_cl_o v[5:8], v[1:4], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x58,0xf1,0x01,0x05,0x63,0x00]

image_gather4_b_cl_o v[5:8], v[1:4], s[96:103], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x58,0xf1,0x01,0x05,0x78,0x00]

image_gather4_b_cl_o v[5:8], v[1:4], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x58,0xf1,0x01,0x05,0x7d,0x00]

image_gather4_b_cl_o v[5:8], v[1:4], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0x58,0xf1,0x01,0x05,0x82,0x00]

image_gather4_b_cl_o v[5:8], v[1:4], s[8:15], s[100:103] dmask:0x1
// CHECK: [0x00,0x01,0x58,0xf1,0x01,0x05,0x22,0x03]

image_gather4_b_cl_o v[5:8], v[1:4], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0x58,0xf1,0x01,0x05,0xc2,0x03]

image_gather4_b_cl_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0x58,0xf1,0x01,0x05,0x62,0x00]

image_gather4_b_cl_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0x58,0xf1,0x01,0x05,0x62,0x00]

image_gather4_b_cl_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0x58,0xf1,0x01,0x05,0x62,0x00]

image_gather4_b_cl_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x58,0xf1,0x01,0x05,0x62,0x00]

image_gather4_b_cl_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0x58,0xf1,0x01,0x05,0x62,0x00]

image_gather4_b_cl_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0x58,0xf3,0x01,0x05,0x62,0x00]

image_gather4_b_cl_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0x5a,0xf1,0x01,0x05,0x62,0x00]

image_gather4_b_cl_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0x58,0xf1,0x01,0x05,0x62,0x00]

image_gather4_lz_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x5c,0xf1,0x01,0x05,0x62,0x00]

image_gather4_lz_o v[252:255], v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x5c,0xf1,0x01,0xfc,0x62,0x00]

image_gather4_lz_o v[5:8], v[253:255], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x5c,0xf1,0xfd,0x05,0x62,0x00]

image_gather4_lz_o v[5:8], v[1:4], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x5c,0xf1,0x01,0x05,0x63,0x00]

image_gather4_lz_o v[5:8], v[1:4], s[96:103], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x5c,0xf1,0x01,0x05,0x78,0x00]

image_gather4_lz_o v[5:8], v[1:4], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x5c,0xf1,0x01,0x05,0x7d,0x00]

image_gather4_lz_o v[5:8], v[1:4], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0x5c,0xf1,0x01,0x05,0x82,0x00]

image_gather4_lz_o v[5:8], v[1:4], s[8:15], s[100:103] dmask:0x1
// CHECK: [0x00,0x01,0x5c,0xf1,0x01,0x05,0x22,0x03]

image_gather4_lz_o v[5:8], v[1:4], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0x5c,0xf1,0x01,0x05,0xc2,0x03]

image_gather4_lz_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0x5c,0xf1,0x01,0x05,0x62,0x00]

image_gather4_lz_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0x5c,0xf1,0x01,0x05,0x62,0x00]

image_gather4_lz_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0x5c,0xf1,0x01,0x05,0x62,0x00]

image_gather4_lz_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x5c,0xf1,0x01,0x05,0x62,0x00]

image_gather4_lz_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0x5c,0xf1,0x01,0x05,0x62,0x00]

image_gather4_lz_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0x5c,0xf3,0x01,0x05,0x62,0x00]

image_gather4_lz_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0x5e,0xf1,0x01,0x05,0x62,0x00]

image_gather4_lz_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0x5c,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x60,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_o v[252:255], v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x60,0xf1,0x01,0xfc,0x62,0x00]

image_gather4_c_o v[5:8], v[253:255], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x60,0xf1,0xfd,0x05,0x62,0x00]

image_gather4_c_o v[5:8], v[1:4], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x60,0xf1,0x01,0x05,0x63,0x00]

image_gather4_c_o v[5:8], v[1:4], s[96:103], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x60,0xf1,0x01,0x05,0x78,0x00]

image_gather4_c_o v[5:8], v[1:4], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x60,0xf1,0x01,0x05,0x7d,0x00]

image_gather4_c_o v[5:8], v[1:4], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0x60,0xf1,0x01,0x05,0x82,0x00]

image_gather4_c_o v[5:8], v[1:4], s[8:15], s[100:103] dmask:0x1
// CHECK: [0x00,0x01,0x60,0xf1,0x01,0x05,0x22,0x03]

image_gather4_c_o v[5:8], v[1:4], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0x60,0xf1,0x01,0x05,0xc2,0x03]

image_gather4_c_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0x60,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0x60,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0x60,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x60,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0x60,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0x60,0xf3,0x01,0x05,0x62,0x00]

image_gather4_c_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0x62,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0x60,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_cl_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x64,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_cl_o v[252:255], v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x64,0xf1,0x01,0xfc,0x62,0x00]

image_gather4_c_cl_o v[5:8], v[252:255], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x64,0xf1,0xfc,0x05,0x62,0x00]

image_gather4_c_cl_o v[5:8], v[1:4], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x64,0xf1,0x01,0x05,0x63,0x00]

image_gather4_c_cl_o v[5:8], v[1:4], s[96:103], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x64,0xf1,0x01,0x05,0x78,0x00]

image_gather4_c_cl_o v[5:8], v[1:4], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x64,0xf1,0x01,0x05,0x7d,0x00]

image_gather4_c_cl_o v[5:8], v[1:4], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0x64,0xf1,0x01,0x05,0x82,0x00]

image_gather4_c_cl_o v[5:8], v[1:4], s[8:15], s[100:103] dmask:0x1
// CHECK: [0x00,0x01,0x64,0xf1,0x01,0x05,0x22,0x03]

image_gather4_c_cl_o v[5:8], v[1:4], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0x64,0xf1,0x01,0x05,0xc2,0x03]

image_gather4_c_cl_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0x64,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_cl_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0x64,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_cl_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0x64,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_cl_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x64,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_cl_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0x64,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_cl_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0x64,0xf3,0x01,0x05,0x62,0x00]

image_gather4_c_cl_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0x66,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_cl_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0x64,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_l_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x70,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_l_o v[252:255], v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x70,0xf1,0x01,0xfc,0x62,0x00]

image_gather4_c_l_o v[5:8], v[252:255], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x70,0xf1,0xfc,0x05,0x62,0x00]

image_gather4_c_l_o v[5:8], v[1:4], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x70,0xf1,0x01,0x05,0x63,0x00]

image_gather4_c_l_o v[5:8], v[1:4], s[96:103], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x70,0xf1,0x01,0x05,0x78,0x00]

image_gather4_c_l_o v[5:8], v[1:4], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x70,0xf1,0x01,0x05,0x7d,0x00]

image_gather4_c_l_o v[5:8], v[1:4], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0x70,0xf1,0x01,0x05,0x82,0x00]

image_gather4_c_l_o v[5:8], v[1:4], s[8:15], s[100:103] dmask:0x1
// CHECK: [0x00,0x01,0x70,0xf1,0x01,0x05,0x22,0x03]

image_gather4_c_l_o v[5:8], v[1:4], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0x70,0xf1,0x01,0x05,0xc2,0x03]

image_gather4_c_l_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0x70,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_l_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0x70,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_l_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0x70,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_l_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x70,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_l_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0x70,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_l_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0x70,0xf3,0x01,0x05,0x62,0x00]

image_gather4_c_l_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0x72,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_l_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0x70,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_b_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x74,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_b_o v[252:255], v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x74,0xf1,0x01,0xfc,0x62,0x00]

image_gather4_c_b_o v[5:8], v[252:255], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x74,0xf1,0xfc,0x05,0x62,0x00]

image_gather4_c_b_o v[5:8], v[1:4], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x74,0xf1,0x01,0x05,0x63,0x00]

image_gather4_c_b_o v[5:8], v[1:4], s[96:103], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x74,0xf1,0x01,0x05,0x78,0x00]

image_gather4_c_b_o v[5:8], v[1:4], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x74,0xf1,0x01,0x05,0x7d,0x00]

image_gather4_c_b_o v[5:8], v[1:4], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0x74,0xf1,0x01,0x05,0x82,0x00]

image_gather4_c_b_o v[5:8], v[1:4], s[8:15], s[100:103] dmask:0x1
// CHECK: [0x00,0x01,0x74,0xf1,0x01,0x05,0x22,0x03]

image_gather4_c_b_o v[5:8], v[1:4], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0x74,0xf1,0x01,0x05,0xc2,0x03]

image_gather4_c_b_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0x74,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_b_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0x74,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_b_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0x74,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_b_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x74,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_b_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0x74,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_b_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0x74,0xf3,0x01,0x05,0x62,0x00]

image_gather4_c_b_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0x76,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_b_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0x74,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_b_cl_o v[5:8], v[1:8], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x78,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_b_cl_o v[252:255], v[1:8], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x78,0xf1,0x01,0xfc,0x62,0x00]

image_gather4_c_b_cl_o v[5:8], v[248:255], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x78,0xf1,0xf8,0x05,0x62,0x00]

image_gather4_c_b_cl_o v[5:8], v[1:8], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x78,0xf1,0x01,0x05,0x63,0x00]

image_gather4_c_b_cl_o v[5:8], v[1:8], s[96:103], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x78,0xf1,0x01,0x05,0x78,0x00]

image_gather4_c_b_cl_o v[5:8], v[1:8], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x78,0xf1,0x01,0x05,0x7d,0x00]

image_gather4_c_b_cl_o v[5:8], v[1:8], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0x78,0xf1,0x01,0x05,0x82,0x00]

image_gather4_c_b_cl_o v[5:8], v[1:8], s[8:15], s[100:103] dmask:0x1
// CHECK: [0x00,0x01,0x78,0xf1,0x01,0x05,0x22,0x03]

image_gather4_c_b_cl_o v[5:8], v[1:8], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0x78,0xf1,0x01,0x05,0xc2,0x03]

image_gather4_c_b_cl_o v[5:8], v[1:8], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0x78,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_b_cl_o v[5:8], v[1:8], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0x78,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_b_cl_o v[5:8], v[1:8], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0x78,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_b_cl_o v[5:8], v[1:8], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x78,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_b_cl_o v[5:8], v[1:8], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0x78,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_b_cl_o v[5:8], v[1:8], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0x78,0xf3,0x01,0x05,0x62,0x00]

image_gather4_c_b_cl_o v[5:8], v[1:8], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0x7a,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_b_cl_o v[5:8], v[1:8], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0x78,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_lz_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x7c,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_lz_o v[252:255], v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x7c,0xf1,0x01,0xfc,0x62,0x00]

image_gather4_c_lz_o v[5:8], v[252:255], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x7c,0xf1,0xfc,0x05,0x62,0x00]

image_gather4_c_lz_o v[5:8], v[1:4], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x7c,0xf1,0x01,0x05,0x63,0x00]

image_gather4_c_lz_o v[5:8], v[1:4], s[96:103], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x7c,0xf1,0x01,0x05,0x78,0x00]

image_gather4_c_lz_o v[5:8], v[1:4], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x7c,0xf1,0x01,0x05,0x7d,0x00]

image_gather4_c_lz_o v[5:8], v[1:4], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0x7c,0xf1,0x01,0x05,0x82,0x00]

image_gather4_c_lz_o v[5:8], v[1:4], s[8:15], s[100:103] dmask:0x1
// CHECK: [0x00,0x01,0x7c,0xf1,0x01,0x05,0x22,0x03]

image_gather4_c_lz_o v[5:8], v[1:4], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0x7c,0xf1,0x01,0x05,0xc2,0x03]

image_gather4_c_lz_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0x7c,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_lz_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0x7c,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_lz_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0x7c,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_lz_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x7c,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_lz_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0x7c,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_lz_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0x7c,0xf3,0x01,0x05,0x62,0x00]

image_gather4_c_lz_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0x7e,0xf1,0x01,0x05,0x62,0x00]

image_gather4_c_lz_o v[5:8], v[1:4], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0x7c,0xf1,0x01,0x05,0x62,0x00]

image_get_lod v5, v1, s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x80,0xf1,0x01,0x05,0x62,0x00]

image_get_lod v252, v1, s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x80,0xf1,0x01,0xfc,0x62,0x00]

image_get_lod v5, v255, s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x80,0xf1,0xff,0x05,0x62,0x00]

image_get_lod v5, v1, s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x80,0xf1,0x01,0x05,0x63,0x00]

image_get_lod v5, v1, s[96:103], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x80,0xf1,0x01,0x05,0x78,0x00]

image_get_lod v5, v1, ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0x80,0xf1,0x01,0x05,0x7d,0x00]

image_get_lod v5, v1, s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0x80,0xf1,0x01,0x05,0x82,0x00]

image_get_lod v5, v1, s[8:15], s[100:103] dmask:0x1
// CHECK: [0x00,0x01,0x80,0xf1,0x01,0x05,0x22,0x03]

image_get_lod v5, v1, s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0x80,0xf1,0x01,0x05,0xc2,0x03]

image_get_lod v5, v1, s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0x80,0xf1,0x01,0x05,0x62,0x00]

image_get_lod v[5:6], v1, s[8:15], s[12:15] dmask:0x3
// CHECK: [0x00,0x03,0x80,0xf1,0x01,0x05,0x62,0x00]

image_get_lod v5, v1, s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0x80,0xf1,0x01,0x05,0x62,0x00]

image_get_lod v[5:6], v1, s[8:15], s[12:15] dmask:0x5
// CHECK: [0x00,0x05,0x80,0xf1,0x01,0x05,0x62,0x00]

image_get_lod v[5:6], v1, s[8:15], s[12:15] dmask:0x6
// CHECK: [0x00,0x06,0x80,0xf1,0x01,0x05,0x62,0x00]

image_get_lod v[5:7], v1, s[8:15], s[12:15] dmask:0x7
// CHECK: [0x00,0x07,0x80,0xf1,0x01,0x05,0x62,0x00]

image_get_lod v5, v1, s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0x80,0xf1,0x01,0x05,0x62,0x00]

image_get_lod v[5:6], v1, s[8:15], s[12:15] dmask:0x9
// CHECK: [0x00,0x09,0x80,0xf1,0x01,0x05,0x62,0x00]

image_get_lod v[5:6], v1, s[8:15], s[12:15] dmask:0xa
// CHECK: [0x00,0x0a,0x80,0xf1,0x01,0x05,0x62,0x00]

image_get_lod v[5:7], v1, s[8:15], s[12:15] dmask:0xb
// CHECK: [0x00,0x0b,0x80,0xf1,0x01,0x05,0x62,0x00]

image_get_lod v[5:6], v1, s[8:15], s[12:15] dmask:0xc
// CHECK: [0x00,0x0c,0x80,0xf1,0x01,0x05,0x62,0x00]

image_get_lod v[5:7], v1, s[8:15], s[12:15] dmask:0xd
// CHECK: [0x00,0x0d,0x80,0xf1,0x01,0x05,0x62,0x00]

image_get_lod v[5:7], v1, s[8:15], s[12:15] dmask:0xe
// CHECK: [0x00,0x0e,0x80,0xf1,0x01,0x05,0x62,0x00]

image_get_lod v5, v1, s[8:15], s[12:15] dmask:0x0
// CHECK: [0x00,0x00,0x80,0xf1,0x01,0x05,0x62,0x00]

image_get_lod v5, v1, s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0x80,0xf1,0x01,0x05,0x62,0x00]

image_get_lod v5, v1, s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0x80,0xf1,0x01,0x05,0x62,0x00]

image_get_lod v5, v1, s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0x80,0xf3,0x01,0x05,0x62,0x00]

image_get_lod v[5:6], v1, s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0x81,0xf1,0x01,0x05,0x62,0x00]

image_get_lod v5, v1, s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0x82,0xf1,0x01,0x05,0x62,0x00]

image_get_lod v5, v1, s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0x80,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd v5, v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xa8,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd v252, v[1:4], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xa8,0xf1,0x01,0xfc,0x62,0x00]

image_sample_c_cd v5, v[252:255], s[8:15], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xa8,0xf1,0xfc,0x05,0x62,0x00]

image_sample_c_cd v5, v[1:4], s[12:19], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xa8,0xf1,0x01,0x05,0x63,0x00]

image_sample_c_cd v5, v[1:4], s[96:103], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xa8,0xf1,0x01,0x05,0x78,0x00]

image_sample_c_cd v5, v[1:4], ttmp[4:11], s[12:15] dmask:0x1
// CHECK: [0x00,0x01,0xa8,0xf1,0x01,0x05,0x7d,0x00]

image_sample_c_cd v5, v[1:4], s[8:15], s[16:19] dmask:0x1
// CHECK: [0x00,0x01,0xa8,0xf1,0x01,0x05,0x82,0x00]

image_sample_c_cd v5, v[1:4], s[8:15], s[100:103] dmask:0x1
// CHECK: [0x00,0x01,0xa8,0xf1,0x01,0x05,0x22,0x03]

image_sample_c_cd v5, v[1:4], s[8:15], ttmp[8:11] dmask:0x1
// CHECK: [0x00,0x01,0xa8,0xf1,0x01,0x05,0xc2,0x03]

image_sample_c_cd v5, v[1:4], s[8:15], s[12:15] dmask:0x2
// CHECK: [0x00,0x02,0xa8,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x3
// CHECK: [0x00,0x03,0xa8,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd v5, v[1:4], s[8:15], s[12:15] dmask:0x4
// CHECK: [0x00,0x04,0xa8,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x5
// CHECK: [0x00,0x05,0xa8,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x6
// CHECK: [0x00,0x06,0xa8,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd v[5:7], v[1:4], s[8:15], s[12:15] dmask:0x7
// CHECK: [0x00,0x07,0xa8,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd v5, v[1:4], s[8:15], s[12:15] dmask:0x8
// CHECK: [0x00,0x08,0xa8,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x9
// CHECK: [0x00,0x09,0xa8,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd v[5:6], v[1:4], s[8:15], s[12:15] dmask:0xa
// CHECK: [0x00,0x0a,0xa8,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd v[5:7], v[1:4], s[8:15], s[12:15] dmask:0xb
// CHECK: [0x00,0x0b,0xa8,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd v[5:6], v[1:4], s[8:15], s[12:15] dmask:0xc
// CHECK: [0x00,0x0c,0xa8,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd v[5:7], v[1:4], s[8:15], s[12:15] dmask:0xd
// CHECK: [0x00,0x0d,0xa8,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd v[5:7], v[1:4], s[8:15], s[12:15] dmask:0xe
// CHECK: [0x00,0x0e,0xa8,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd v5, v[1:4], s[8:15], s[12:15] dmask:0x0
// CHECK: [0x00,0x00,0xa8,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd v5, v[1:4], s[8:15], s[12:15] dmask:0x1 unorm
// CHECK: [0x00,0x11,0xa8,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd v5, v[1:4], s[8:15], s[12:15] dmask:0x1 glc
// CHECK: [0x00,0x21,0xa8,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd v5, v[1:4], s[8:15], s[12:15] dmask:0x1 slc
// CHECK: [0x00,0x01,0xa8,0xf3,0x01,0x05,0x62,0x00]

image_sample_c_cd v[5:6], v[1:4], s[8:15], s[12:15] dmask:0x1 tfe
// CHECK: [0x00,0x01,0xa9,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd v5, v[1:4], s[8:15], s[12:15] dmask:0x1 lwe
// CHECK: [0x00,0x01,0xaa,0xf1,0x01,0x05,0x62,0x00]

image_sample_c_cd v5, v[1:4], s[8:15], s[12:15] dmask:0x1 da
// CHECK: [0x00,0x41,0xa8,0xf1,0x01,0x05,0x62,0x00]

buffer_load_format_x v5, off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x00,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_x v255, off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x00,0xe0,0x00,0xff,0x02,0x03]

buffer_load_format_x v5, off, s[12:15], s3 offset:4095
// CHECK: [0xff,0x0f,0x00,0xe0,0x00,0x05,0x03,0x03]

buffer_load_format_x v5, off, s[100:103], s3 offset:4095
// CHECK: [0xff,0x0f,0x00,0xe0,0x00,0x05,0x19,0x03]

buffer_load_format_x v5, off, ttmp[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x00,0xe0,0x00,0x05,0x1e,0x03]

buffer_load_format_x v5, off, s[8:11], s103 offset:4095
// CHECK: [0xff,0x0f,0x00,0xe0,0x00,0x05,0x02,0x67]

buffer_load_format_x v5, off, s[8:11], m0 offset:4095
// CHECK: [0xff,0x0f,0x00,0xe0,0x00,0x05,0x02,0x7c]

buffer_load_format_x v5, off, s[8:11], 0 offset:4095
// CHECK: [0xff,0x0f,0x00,0xe0,0x00,0x05,0x02,0x80]

buffer_load_format_x v5, off, s[8:11], -1 offset:4095
// CHECK: [0xff,0x0f,0x00,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_format_x v5, off, s[8:11], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x00,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_format_x v5, off, s[8:11], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x00,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_format_x v5, v0, s[8:11], s3 idxen offset:4095
// CHECK: [0xff,0x2f,0x00,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_x v5, v0, s[8:11], s3 offen offset:4095
// CHECK: [0xff,0x1f,0x00,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_x v5, v[0:1], s[8:11], s3 addr64 offset:4095
// CHECK: [0xff,0x8f,0x00,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_x v5, off, s[8:11], s3
// CHECK: [0x00,0x00,0x00,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_x v5, off, s[8:11], s3 offset:0
// CHECK: [0x00,0x00,0x00,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_x v5, off, s[8:11], s3 offset:7
// CHECK: [0x07,0x00,0x00,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_x v5, off, s[8:11], s3 offset:4095 glc
// CHECK: [0xff,0x4f,0x00,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_x v5, off, s[8:11], s3 offset:4095 slc
// CHECK: [0xff,0x0f,0x00,0xe0,0x00,0x05,0x42,0x03]

buffer_load_format_x v5, off, s[8:11], s3 offset:4095 lds
// CHECK: [0xff,0x0f,0x01,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xy v[5:6], off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x04,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xy v[254:255], off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x04,0xe0,0x00,0xfe,0x02,0x03]

buffer_load_format_xy v[5:6], off, s[12:15], s3 offset:4095
// CHECK: [0xff,0x0f,0x04,0xe0,0x00,0x05,0x03,0x03]

buffer_load_format_xy v[5:6], off, s[100:103], s3 offset:4095
// CHECK: [0xff,0x0f,0x04,0xe0,0x00,0x05,0x19,0x03]

buffer_load_format_xy v[5:6], off, ttmp[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x04,0xe0,0x00,0x05,0x1e,0x03]

buffer_load_format_xy v[5:6], off, s[8:11], s103 offset:4095
// CHECK: [0xff,0x0f,0x04,0xe0,0x00,0x05,0x02,0x67]

buffer_load_format_xy v[5:6], off, s[8:11], m0 offset:4095
// CHECK: [0xff,0x0f,0x04,0xe0,0x00,0x05,0x02,0x7c]

buffer_load_format_xy v[5:6], off, s[8:11], 0 offset:4095
// CHECK: [0xff,0x0f,0x04,0xe0,0x00,0x05,0x02,0x80]

buffer_load_format_xy v[5:6], off, s[8:11], -1 offset:4095
// CHECK: [0xff,0x0f,0x04,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_format_xy v[5:6], off, s[8:11], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x04,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_format_xy v[5:6], off, s[8:11], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x04,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_format_xy v[5:6], v0, s[8:11], s3 idxen offset:4095
// CHECK: [0xff,0x2f,0x04,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xy v[5:6], v0, s[8:11], s3 offen offset:4095
// CHECK: [0xff,0x1f,0x04,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xy v[5:6], v[0:1], s[8:11], s3 addr64 offset:4095
// CHECK: [0xff,0x8f,0x04,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xy v[5:6], off, s[8:11], s3
// CHECK: [0x00,0x00,0x04,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xy v[5:6], off, s[8:11], s3 offset:0
// CHECK: [0x00,0x00,0x04,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xy v[5:6], off, s[8:11], s3 offset:7
// CHECK: [0x07,0x00,0x04,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xy v[5:6], off, s[8:11], s3 offset:4095 glc
// CHECK: [0xff,0x4f,0x04,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xy v[5:6], off, s[8:11], s3 offset:4095 slc
// CHECK: [0xff,0x0f,0x04,0xe0,0x00,0x05,0x42,0x03]

buffer_load_format_xyz v[5:7], off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x08,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xyz v[253:255], off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x08,0xe0,0x00,0xfd,0x02,0x03]

buffer_load_format_xyz v[5:7], off, s[12:15], s3 offset:4095
// CHECK: [0xff,0x0f,0x08,0xe0,0x00,0x05,0x03,0x03]

buffer_load_format_xyz v[5:7], off, s[100:103], s3 offset:4095
// CHECK: [0xff,0x0f,0x08,0xe0,0x00,0x05,0x19,0x03]

buffer_load_format_xyz v[5:7], off, ttmp[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x08,0xe0,0x00,0x05,0x1e,0x03]

buffer_load_format_xyz v[5:7], off, s[8:11], s103 offset:4095
// CHECK: [0xff,0x0f,0x08,0xe0,0x00,0x05,0x02,0x67]

buffer_load_format_xyz v[5:7], off, s[8:11], m0 offset:4095
// CHECK: [0xff,0x0f,0x08,0xe0,0x00,0x05,0x02,0x7c]

buffer_load_format_xyz v[5:7], off, s[8:11], 0 offset:4095
// CHECK: [0xff,0x0f,0x08,0xe0,0x00,0x05,0x02,0x80]

buffer_load_format_xyz v[5:7], off, s[8:11], -1 offset:4095
// CHECK: [0xff,0x0f,0x08,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_format_xyz v[5:7], off, s[8:11], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x08,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_format_xyz v[5:7], off, s[8:11], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x08,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_format_xyz v[5:7], v0, s[8:11], s3 idxen offset:4095
// CHECK: [0xff,0x2f,0x08,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xyz v[5:7], v0, s[8:11], s3 offen offset:4095
// CHECK: [0xff,0x1f,0x08,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xyz v[5:7], v[0:1], s[8:11], s3 addr64 offset:4095
// CHECK: [0xff,0x8f,0x08,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xyz v[5:7], off, s[8:11], s3
// CHECK: [0x00,0x00,0x08,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xyz v[5:7], off, s[8:11], s3 offset:0
// CHECK: [0x00,0x00,0x08,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xyz v[5:7], off, s[8:11], s3 offset:7
// CHECK: [0x07,0x00,0x08,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xyz v[5:7], off, s[8:11], s3 offset:4095 glc
// CHECK: [0xff,0x4f,0x08,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xyz v[5:7], off, s[8:11], s3 offset:4095 slc
// CHECK: [0xff,0x0f,0x08,0xe0,0x00,0x05,0x42,0x03]

buffer_load_format_xyzw v[5:8], off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xyzw v[252:255], off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe0,0x00,0xfc,0x02,0x03]

buffer_load_format_xyzw v[5:8], off, s[12:15], s3 offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe0,0x00,0x05,0x03,0x03]

buffer_load_format_xyzw v[5:8], off, s[100:103], s3 offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe0,0x00,0x05,0x19,0x03]

buffer_load_format_xyzw v[5:8], off, ttmp[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe0,0x00,0x05,0x1e,0x03]

buffer_load_format_xyzw v[5:8], off, s[8:11], s103 offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe0,0x00,0x05,0x02,0x67]

buffer_load_format_xyzw v[5:8], off, s[8:11], m0 offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe0,0x00,0x05,0x02,0x7c]

buffer_load_format_xyzw v[5:8], off, s[8:11], 0 offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe0,0x00,0x05,0x02,0x80]

buffer_load_format_xyzw v[5:8], off, s[8:11], -1 offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_format_xyzw v[5:8], off, s[8:11], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_format_xyzw v[5:8], off, s[8:11], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x0c,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_format_xyzw v[5:8], v0, s[8:11], s3 idxen offset:4095
// CHECK: [0xff,0x2f,0x0c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xyzw v[5:8], v0, s[8:11], s3 offen offset:4095
// CHECK: [0xff,0x1f,0x0c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xyzw v[5:8], v[0:1], s[8:11], s3 addr64 offset:4095
// CHECK: [0xff,0x8f,0x0c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xyzw v[5:8], off, s[8:11], s3
// CHECK: [0x00,0x00,0x0c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xyzw v[5:8], off, s[8:11], s3 offset:0
// CHECK: [0x00,0x00,0x0c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xyzw v[5:8], off, s[8:11], s3 offset:7
// CHECK: [0x07,0x00,0x0c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xyzw v[5:8], off, s[8:11], s3 offset:4095 glc
// CHECK: [0xff,0x4f,0x0c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_format_xyzw v[5:8], off, s[8:11], s3 offset:4095 slc
// CHECK: [0xff,0x0f,0x0c,0xe0,0x00,0x05,0x42,0x03]

buffer_store_format_x v1, off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x10,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_x v255, off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x10,0xe0,0x00,0xff,0x03,0x04]

buffer_store_format_x v1, off, s[16:19], s4 offset:4095
// CHECK: [0xff,0x0f,0x10,0xe0,0x00,0x01,0x04,0x04]

buffer_store_format_x v1, off, s[100:103], s4 offset:4095
// CHECK: [0xff,0x0f,0x10,0xe0,0x00,0x01,0x19,0x04]

buffer_store_format_x v1, off, ttmp[8:11], s4 offset:4095
// CHECK: [0xff,0x0f,0x10,0xe0,0x00,0x01,0x1e,0x04]

buffer_store_format_x v1, off, s[12:15], s103 offset:4095
// CHECK: [0xff,0x0f,0x10,0xe0,0x00,0x01,0x03,0x67]

buffer_store_format_x v1, off, s[12:15], m0 offset:4095
// CHECK: [0xff,0x0f,0x10,0xe0,0x00,0x01,0x03,0x7c]

buffer_store_format_x v1, off, s[12:15], 0 offset:4095
// CHECK: [0xff,0x0f,0x10,0xe0,0x00,0x01,0x03,0x80]

buffer_store_format_x v1, off, s[12:15], -1 offset:4095
// CHECK: [0xff,0x0f,0x10,0xe0,0x00,0x01,0x03,0xc1]

buffer_store_format_x v1, off, s[12:15], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x10,0xe0,0x00,0x01,0x03,0xf0]

buffer_store_format_x v1, off, s[12:15], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x10,0xe0,0x00,0x01,0x03,0xf7]

buffer_store_format_x v1, v0, s[12:15], s4 idxen offset:4095
// CHECK: [0xff,0x2f,0x10,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_x v1, v0, s[12:15], s4 offen offset:4095
// CHECK: [0xff,0x1f,0x10,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_x v1, v[0:1], s[12:15], s4 addr64 offset:4095
// CHECK: [0xff,0x8f,0x10,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_x v1, off, s[12:15], s4
// CHECK: [0x00,0x00,0x10,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_x v1, off, s[12:15], s4 offset:0
// CHECK: [0x00,0x00,0x10,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_x v1, off, s[12:15], s4 offset:7
// CHECK: [0x07,0x00,0x10,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_x v1, off, s[12:15], s4 offset:4095 glc
// CHECK: [0xff,0x4f,0x10,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_x v1, off, s[12:15], s4 offset:4095 slc
// CHECK: [0xff,0x0f,0x10,0xe0,0x00,0x01,0x43,0x04]

buffer_store_format_xy v[1:2], off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x14,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xy v[254:255], off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x14,0xe0,0x00,0xfe,0x03,0x04]

buffer_store_format_xy v[1:2], off, s[16:19], s4 offset:4095
// CHECK: [0xff,0x0f,0x14,0xe0,0x00,0x01,0x04,0x04]

buffer_store_format_xy v[1:2], off, s[100:103], s4 offset:4095
// CHECK: [0xff,0x0f,0x14,0xe0,0x00,0x01,0x19,0x04]

buffer_store_format_xy v[1:2], off, ttmp[8:11], s4 offset:4095
// CHECK: [0xff,0x0f,0x14,0xe0,0x00,0x01,0x1e,0x04]

buffer_store_format_xy v[1:2], off, s[12:15], s103 offset:4095
// CHECK: [0xff,0x0f,0x14,0xe0,0x00,0x01,0x03,0x67]

buffer_store_format_xy v[1:2], off, s[12:15], m0 offset:4095
// CHECK: [0xff,0x0f,0x14,0xe0,0x00,0x01,0x03,0x7c]

buffer_store_format_xy v[1:2], off, s[12:15], 0 offset:4095
// CHECK: [0xff,0x0f,0x14,0xe0,0x00,0x01,0x03,0x80]

buffer_store_format_xy v[1:2], off, s[12:15], -1 offset:4095
// CHECK: [0xff,0x0f,0x14,0xe0,0x00,0x01,0x03,0xc1]

buffer_store_format_xy v[1:2], off, s[12:15], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x14,0xe0,0x00,0x01,0x03,0xf0]

buffer_store_format_xy v[1:2], off, s[12:15], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x14,0xe0,0x00,0x01,0x03,0xf7]

buffer_store_format_xy v[1:2], v0, s[12:15], s4 idxen offset:4095
// CHECK: [0xff,0x2f,0x14,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xy v[1:2], v0, s[12:15], s4 offen offset:4095
// CHECK: [0xff,0x1f,0x14,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xy v[1:2], v[0:1], s[12:15], s4 addr64 offset:4095
// CHECK: [0xff,0x8f,0x14,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xy v[1:2], off, s[12:15], s4
// CHECK: [0x00,0x00,0x14,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xy v[1:2], off, s[12:15], s4 offset:0
// CHECK: [0x00,0x00,0x14,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xy v[1:2], off, s[12:15], s4 offset:7
// CHECK: [0x07,0x00,0x14,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xy v[1:2], off, s[12:15], s4 offset:4095 glc
// CHECK: [0xff,0x4f,0x14,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xy v[1:2], off, s[12:15], s4 offset:4095 slc
// CHECK: [0xff,0x0f,0x14,0xe0,0x00,0x01,0x43,0x04]

buffer_store_format_xyz v[1:3], off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x18,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xyz v[253:255], off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x18,0xe0,0x00,0xfd,0x03,0x04]

buffer_store_format_xyz v[1:3], off, s[16:19], s4 offset:4095
// CHECK: [0xff,0x0f,0x18,0xe0,0x00,0x01,0x04,0x04]

buffer_store_format_xyz v[1:3], off, s[100:103], s4 offset:4095
// CHECK: [0xff,0x0f,0x18,0xe0,0x00,0x01,0x19,0x04]

buffer_store_format_xyz v[1:3], off, ttmp[8:11], s4 offset:4095
// CHECK: [0xff,0x0f,0x18,0xe0,0x00,0x01,0x1e,0x04]

buffer_store_format_xyz v[1:3], off, s[12:15], s103 offset:4095
// CHECK: [0xff,0x0f,0x18,0xe0,0x00,0x01,0x03,0x67]

buffer_store_format_xyz v[1:3], off, s[12:15], m0 offset:4095
// CHECK: [0xff,0x0f,0x18,0xe0,0x00,0x01,0x03,0x7c]

buffer_store_format_xyz v[1:3], off, s[12:15], 0 offset:4095
// CHECK: [0xff,0x0f,0x18,0xe0,0x00,0x01,0x03,0x80]

buffer_store_format_xyz v[1:3], off, s[12:15], -1 offset:4095
// CHECK: [0xff,0x0f,0x18,0xe0,0x00,0x01,0x03,0xc1]

buffer_store_format_xyz v[1:3], off, s[12:15], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x18,0xe0,0x00,0x01,0x03,0xf0]

buffer_store_format_xyz v[1:3], off, s[12:15], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x18,0xe0,0x00,0x01,0x03,0xf7]

buffer_store_format_xyz v[1:3], v0, s[12:15], s4 idxen offset:4095
// CHECK: [0xff,0x2f,0x18,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xyz v[1:3], v0, s[12:15], s4 offen offset:4095
// CHECK: [0xff,0x1f,0x18,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xyz v[1:3], v[0:1], s[12:15], s4 addr64 offset:4095
// CHECK: [0xff,0x8f,0x18,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xyz v[1:3], off, s[12:15], s4
// CHECK: [0x00,0x00,0x18,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xyz v[1:3], off, s[12:15], s4 offset:0
// CHECK: [0x00,0x00,0x18,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xyz v[1:3], off, s[12:15], s4 offset:7
// CHECK: [0x07,0x00,0x18,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xyz v[1:3], off, s[12:15], s4 offset:4095 glc
// CHECK: [0xff,0x4f,0x18,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xyz v[1:3], off, s[12:15], s4 offset:4095 slc
// CHECK: [0xff,0x0f,0x18,0xe0,0x00,0x01,0x43,0x04]

buffer_store_format_xyzw v[1:4], off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x1c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xyzw v[252:255], off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x1c,0xe0,0x00,0xfc,0x03,0x04]

buffer_store_format_xyzw v[1:4], off, s[16:19], s4 offset:4095
// CHECK: [0xff,0x0f,0x1c,0xe0,0x00,0x01,0x04,0x04]

buffer_store_format_xyzw v[1:4], off, s[100:103], s4 offset:4095
// CHECK: [0xff,0x0f,0x1c,0xe0,0x00,0x01,0x19,0x04]

buffer_store_format_xyzw v[1:4], off, ttmp[8:11], s4 offset:4095
// CHECK: [0xff,0x0f,0x1c,0xe0,0x00,0x01,0x1e,0x04]

buffer_store_format_xyzw v[1:4], off, s[12:15], s103 offset:4095
// CHECK: [0xff,0x0f,0x1c,0xe0,0x00,0x01,0x03,0x67]

buffer_store_format_xyzw v[1:4], off, s[12:15], m0 offset:4095
// CHECK: [0xff,0x0f,0x1c,0xe0,0x00,0x01,0x03,0x7c]

buffer_store_format_xyzw v[1:4], off, s[12:15], 0 offset:4095
// CHECK: [0xff,0x0f,0x1c,0xe0,0x00,0x01,0x03,0x80]

buffer_store_format_xyzw v[1:4], off, s[12:15], -1 offset:4095
// CHECK: [0xff,0x0f,0x1c,0xe0,0x00,0x01,0x03,0xc1]

buffer_store_format_xyzw v[1:4], off, s[12:15], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x1c,0xe0,0x00,0x01,0x03,0xf0]

buffer_store_format_xyzw v[1:4], off, s[12:15], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x1c,0xe0,0x00,0x01,0x03,0xf7]

buffer_store_format_xyzw v[1:4], v0, s[12:15], s4 idxen offset:4095
// CHECK: [0xff,0x2f,0x1c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xyzw v[1:4], v0, s[12:15], s4 offen offset:4095
// CHECK: [0xff,0x1f,0x1c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xyzw v[1:4], v[0:1], s[12:15], s4 addr64 offset:4095
// CHECK: [0xff,0x8f,0x1c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xyzw v[1:4], off, s[12:15], s4
// CHECK: [0x00,0x00,0x1c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xyzw v[1:4], off, s[12:15], s4 offset:0
// CHECK: [0x00,0x00,0x1c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xyzw v[1:4], off, s[12:15], s4 offset:7
// CHECK: [0x07,0x00,0x1c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xyzw v[1:4], off, s[12:15], s4 offset:4095 glc
// CHECK: [0xff,0x4f,0x1c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_format_xyzw v[1:4], off, s[12:15], s4 offset:4095 slc
// CHECK: [0xff,0x0f,0x1c,0xe0,0x00,0x01,0x43,0x04]

buffer_load_ubyte v5, off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x20,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ubyte v255, off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x20,0xe0,0x00,0xff,0x02,0x03]

buffer_load_ubyte v5, off, s[12:15], s3 offset:4095
// CHECK: [0xff,0x0f,0x20,0xe0,0x00,0x05,0x03,0x03]

buffer_load_ubyte v5, off, s[100:103], s3 offset:4095
// CHECK: [0xff,0x0f,0x20,0xe0,0x00,0x05,0x19,0x03]

buffer_load_ubyte v5, off, ttmp[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x20,0xe0,0x00,0x05,0x1e,0x03]

buffer_load_ubyte v5, off, s[8:11], s103 offset:4095
// CHECK: [0xff,0x0f,0x20,0xe0,0x00,0x05,0x02,0x67]

buffer_load_ubyte v5, off, s[8:11], m0 offset:4095
// CHECK: [0xff,0x0f,0x20,0xe0,0x00,0x05,0x02,0x7c]

buffer_load_ubyte v5, off, s[8:11], 0 offset:4095
// CHECK: [0xff,0x0f,0x20,0xe0,0x00,0x05,0x02,0x80]

buffer_load_ubyte v5, off, s[8:11], -1 offset:4095
// CHECK: [0xff,0x0f,0x20,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_ubyte v5, off, s[8:11], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x20,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_ubyte v5, off, s[8:11], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x20,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_ubyte v5, v0, s[8:11], s3 idxen offset:4095
// CHECK: [0xff,0x2f,0x20,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ubyte v5, v0, s[8:11], s3 offen offset:4095
// CHECK: [0xff,0x1f,0x20,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ubyte v5, v[0:1], s[8:11], s3 addr64 offset:4095
// CHECK: [0xff,0x8f,0x20,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ubyte v5, off, s[8:11], s3
// CHECK: [0x00,0x00,0x20,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ubyte v5, off, s[8:11], s3 offset:0
// CHECK: [0x00,0x00,0x20,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ubyte v5, off, s[8:11], s3 offset:7
// CHECK: [0x07,0x00,0x20,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ubyte v5, off, s[8:11], s3 offset:4095 glc
// CHECK: [0xff,0x4f,0x20,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ubyte v5, off, s[8:11], s3 offset:4095 slc
// CHECK: [0xff,0x0f,0x20,0xe0,0x00,0x05,0x42,0x03]

buffer_load_ubyte v5, off, s[8:11], s3 offset:4095 lds
// CHECK: [0xff,0x0f,0x21,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sbyte v5, off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x24,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sbyte v255, off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x24,0xe0,0x00,0xff,0x02,0x03]

buffer_load_sbyte v5, off, s[12:15], s3 offset:4095
// CHECK: [0xff,0x0f,0x24,0xe0,0x00,0x05,0x03,0x03]

buffer_load_sbyte v5, off, s[100:103], s3 offset:4095
// CHECK: [0xff,0x0f,0x24,0xe0,0x00,0x05,0x19,0x03]

buffer_load_sbyte v5, off, ttmp[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x24,0xe0,0x00,0x05,0x1e,0x03]

buffer_load_sbyte v5, off, s[8:11], s103 offset:4095
// CHECK: [0xff,0x0f,0x24,0xe0,0x00,0x05,0x02,0x67]

buffer_load_sbyte v5, off, s[8:11], m0 offset:4095
// CHECK: [0xff,0x0f,0x24,0xe0,0x00,0x05,0x02,0x7c]

buffer_load_sbyte v5, off, s[8:11], 0 offset:4095
// CHECK: [0xff,0x0f,0x24,0xe0,0x00,0x05,0x02,0x80]

buffer_load_sbyte v5, off, s[8:11], -1 offset:4095
// CHECK: [0xff,0x0f,0x24,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_sbyte v5, off, s[8:11], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x24,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_sbyte v5, off, s[8:11], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x24,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_sbyte v5, v0, s[8:11], s3 idxen offset:4095
// CHECK: [0xff,0x2f,0x24,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sbyte v5, v0, s[8:11], s3 offen offset:4095
// CHECK: [0xff,0x1f,0x24,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sbyte v5, v[0:1], s[8:11], s3 addr64 offset:4095
// CHECK: [0xff,0x8f,0x24,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sbyte v5, off, s[8:11], s3
// CHECK: [0x00,0x00,0x24,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sbyte v5, off, s[8:11], s3 offset:0
// CHECK: [0x00,0x00,0x24,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sbyte v5, off, s[8:11], s3 offset:7
// CHECK: [0x07,0x00,0x24,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sbyte v5, off, s[8:11], s3 offset:4095 glc
// CHECK: [0xff,0x4f,0x24,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sbyte v5, off, s[8:11], s3 offset:4095 slc
// CHECK: [0xff,0x0f,0x24,0xe0,0x00,0x05,0x42,0x03]

buffer_load_sbyte v5, off, s[8:11], s3 offset:4095 lds
// CHECK: [0xff,0x0f,0x25,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ushort v5, off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x28,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ushort v255, off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x28,0xe0,0x00,0xff,0x02,0x03]

buffer_load_ushort v5, off, s[12:15], s3 offset:4095
// CHECK: [0xff,0x0f,0x28,0xe0,0x00,0x05,0x03,0x03]

buffer_load_ushort v5, off, s[100:103], s3 offset:4095
// CHECK: [0xff,0x0f,0x28,0xe0,0x00,0x05,0x19,0x03]

buffer_load_ushort v5, off, ttmp[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x28,0xe0,0x00,0x05,0x1e,0x03]

buffer_load_ushort v5, off, s[8:11], s103 offset:4095
// CHECK: [0xff,0x0f,0x28,0xe0,0x00,0x05,0x02,0x67]

buffer_load_ushort v5, off, s[8:11], m0 offset:4095
// CHECK: [0xff,0x0f,0x28,0xe0,0x00,0x05,0x02,0x7c]

buffer_load_ushort v5, off, s[8:11], 0 offset:4095
// CHECK: [0xff,0x0f,0x28,0xe0,0x00,0x05,0x02,0x80]

buffer_load_ushort v5, off, s[8:11], -1 offset:4095
// CHECK: [0xff,0x0f,0x28,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_ushort v5, off, s[8:11], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x28,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_ushort v5, off, s[8:11], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x28,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_ushort v5, v0, s[8:11], s3 idxen offset:4095
// CHECK: [0xff,0x2f,0x28,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ushort v5, v0, s[8:11], s3 offen offset:4095
// CHECK: [0xff,0x1f,0x28,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ushort v5, v[0:1], s[8:11], s3 addr64 offset:4095
// CHECK: [0xff,0x8f,0x28,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ushort v5, off, s[8:11], s3
// CHECK: [0x00,0x00,0x28,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ushort v5, off, s[8:11], s3 offset:0
// CHECK: [0x00,0x00,0x28,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ushort v5, off, s[8:11], s3 offset:7
// CHECK: [0x07,0x00,0x28,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ushort v5, off, s[8:11], s3 offset:4095 glc
// CHECK: [0xff,0x4f,0x28,0xe0,0x00,0x05,0x02,0x03]

buffer_load_ushort v5, off, s[8:11], s3 offset:4095 slc
// CHECK: [0xff,0x0f,0x28,0xe0,0x00,0x05,0x42,0x03]

buffer_load_ushort v5, off, s[8:11], s3 offset:4095 lds
// CHECK: [0xff,0x0f,0x29,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sshort v5, off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x2c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sshort v255, off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x2c,0xe0,0x00,0xff,0x02,0x03]

buffer_load_sshort v5, off, s[12:15], s3 offset:4095
// CHECK: [0xff,0x0f,0x2c,0xe0,0x00,0x05,0x03,0x03]

buffer_load_sshort v5, off, s[100:103], s3 offset:4095
// CHECK: [0xff,0x0f,0x2c,0xe0,0x00,0x05,0x19,0x03]

buffer_load_sshort v5, off, ttmp[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x2c,0xe0,0x00,0x05,0x1e,0x03]

buffer_load_sshort v5, off, s[8:11], s103 offset:4095
// CHECK: [0xff,0x0f,0x2c,0xe0,0x00,0x05,0x02,0x67]

buffer_load_sshort v5, off, s[8:11], m0 offset:4095
// CHECK: [0xff,0x0f,0x2c,0xe0,0x00,0x05,0x02,0x7c]

buffer_load_sshort v5, off, s[8:11], 0 offset:4095
// CHECK: [0xff,0x0f,0x2c,0xe0,0x00,0x05,0x02,0x80]

buffer_load_sshort v5, off, s[8:11], -1 offset:4095
// CHECK: [0xff,0x0f,0x2c,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_sshort v5, off, s[8:11], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x2c,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_sshort v5, off, s[8:11], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x2c,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_sshort v5, v0, s[8:11], s3 idxen offset:4095
// CHECK: [0xff,0x2f,0x2c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sshort v5, v0, s[8:11], s3 offen offset:4095
// CHECK: [0xff,0x1f,0x2c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sshort v5, v[0:1], s[8:11], s3 addr64 offset:4095
// CHECK: [0xff,0x8f,0x2c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sshort v5, off, s[8:11], s3
// CHECK: [0x00,0x00,0x2c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sshort v5, off, s[8:11], s3 offset:0
// CHECK: [0x00,0x00,0x2c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sshort v5, off, s[8:11], s3 offset:7
// CHECK: [0x07,0x00,0x2c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sshort v5, off, s[8:11], s3 offset:4095 glc
// CHECK: [0xff,0x4f,0x2c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_sshort v5, off, s[8:11], s3 offset:4095 slc
// CHECK: [0xff,0x0f,0x2c,0xe0,0x00,0x05,0x42,0x03]

buffer_load_sshort v5, off, s[8:11], s3 offset:4095 lds
// CHECK: [0xff,0x0f,0x2d,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dword v5, off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x30,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dword v255, off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x30,0xe0,0x00,0xff,0x02,0x03]

buffer_load_dword v5, off, s[12:15], s3 offset:4095
// CHECK: [0xff,0x0f,0x30,0xe0,0x00,0x05,0x03,0x03]

buffer_load_dword v5, off, s[100:103], s3 offset:4095
// CHECK: [0xff,0x0f,0x30,0xe0,0x00,0x05,0x19,0x03]

buffer_load_dword v5, off, ttmp[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x30,0xe0,0x00,0x05,0x1e,0x03]

buffer_load_dword v5, off, s[8:11], s103 offset:4095
// CHECK: [0xff,0x0f,0x30,0xe0,0x00,0x05,0x02,0x67]

buffer_load_dword v5, off, s[8:11], m0 offset:4095
// CHECK: [0xff,0x0f,0x30,0xe0,0x00,0x05,0x02,0x7c]

buffer_load_dword v5, off, s[8:11], 0 offset:4095
// CHECK: [0xff,0x0f,0x30,0xe0,0x00,0x05,0x02,0x80]

buffer_load_dword v5, off, s[8:11], -1 offset:4095
// CHECK: [0xff,0x0f,0x30,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_dword v5, off, s[8:11], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x30,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_dword v5, off, s[8:11], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x30,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_dword v5, v0, s[8:11], s3 idxen offset:4095
// CHECK: [0xff,0x2f,0x30,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dword v5, v0, s[8:11], s3 offen offset:4095
// CHECK: [0xff,0x1f,0x30,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dword v5, v[0:1], s[8:11], s3 addr64 offset:4095
// CHECK: [0xff,0x8f,0x30,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dword v5, off, s[8:11], s3
// CHECK: [0x00,0x00,0x30,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dword v5, off, s[8:11], s3 offset:0
// CHECK: [0x00,0x00,0x30,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dword v5, off, s[8:11], s3 offset:7
// CHECK: [0x07,0x00,0x30,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dword v5, off, s[8:11], s3 offset:4095 glc
// CHECK: [0xff,0x4f,0x30,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dword v5, off, s[8:11], s3 offset:4095 slc
// CHECK: [0xff,0x0f,0x30,0xe0,0x00,0x05,0x42,0x03]

buffer_load_dword v5, off, s[8:11], s3 offset:4095 lds
// CHECK: [0xff,0x0f,0x31,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx2 v[5:6], off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x34,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx2 v[254:255], off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x34,0xe0,0x00,0xfe,0x02,0x03]

buffer_load_dwordx2 v[5:6], off, s[12:15], s3 offset:4095
// CHECK: [0xff,0x0f,0x34,0xe0,0x00,0x05,0x03,0x03]

buffer_load_dwordx2 v[5:6], off, s[100:103], s3 offset:4095
// CHECK: [0xff,0x0f,0x34,0xe0,0x00,0x05,0x19,0x03]

buffer_load_dwordx2 v[5:6], off, ttmp[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x34,0xe0,0x00,0x05,0x1e,0x03]

buffer_load_dwordx2 v[5:6], off, s[8:11], s103 offset:4095
// CHECK: [0xff,0x0f,0x34,0xe0,0x00,0x05,0x02,0x67]

buffer_load_dwordx2 v[5:6], off, s[8:11], m0 offset:4095
// CHECK: [0xff,0x0f,0x34,0xe0,0x00,0x05,0x02,0x7c]

buffer_load_dwordx2 v[5:6], off, s[8:11], 0 offset:4095
// CHECK: [0xff,0x0f,0x34,0xe0,0x00,0x05,0x02,0x80]

buffer_load_dwordx2 v[5:6], off, s[8:11], -1 offset:4095
// CHECK: [0xff,0x0f,0x34,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_dwordx2 v[5:6], off, s[8:11], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x34,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_dwordx2 v[5:6], off, s[8:11], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x34,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_dwordx2 v[5:6], v0, s[8:11], s3 idxen offset:4095
// CHECK: [0xff,0x2f,0x34,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx2 v[5:6], v0, s[8:11], s3 offen offset:4095
// CHECK: [0xff,0x1f,0x34,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx2 v[5:6], v[0:1], s[8:11], s3 addr64 offset:4095
// CHECK: [0xff,0x8f,0x34,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx2 v[5:6], off, s[8:11], s3
// CHECK: [0x00,0x00,0x34,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx2 v[5:6], off, s[8:11], s3 offset:0
// CHECK: [0x00,0x00,0x34,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx2 v[5:6], off, s[8:11], s3 offset:7
// CHECK: [0x07,0x00,0x34,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx2 v[5:6], off, s[8:11], s3 offset:4095 glc
// CHECK: [0xff,0x4f,0x34,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx2 v[5:6], off, s[8:11], s3 offset:4095 slc
// CHECK: [0xff,0x0f,0x34,0xe0,0x00,0x05,0x42,0x03]

buffer_load_dwordx4 v[5:8], off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x38,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx4 v[252:255], off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x38,0xe0,0x00,0xfc,0x02,0x03]

buffer_load_dwordx4 v[5:8], off, s[12:15], s3 offset:4095
// CHECK: [0xff,0x0f,0x38,0xe0,0x00,0x05,0x03,0x03]

buffer_load_dwordx4 v[5:8], off, s[100:103], s3 offset:4095
// CHECK: [0xff,0x0f,0x38,0xe0,0x00,0x05,0x19,0x03]

buffer_load_dwordx4 v[5:8], off, ttmp[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x38,0xe0,0x00,0x05,0x1e,0x03]

buffer_load_dwordx4 v[5:8], off, s[8:11], s103 offset:4095
// CHECK: [0xff,0x0f,0x38,0xe0,0x00,0x05,0x02,0x67]

buffer_load_dwordx4 v[5:8], off, s[8:11], m0 offset:4095
// CHECK: [0xff,0x0f,0x38,0xe0,0x00,0x05,0x02,0x7c]

buffer_load_dwordx4 v[5:8], off, s[8:11], 0 offset:4095
// CHECK: [0xff,0x0f,0x38,0xe0,0x00,0x05,0x02,0x80]

buffer_load_dwordx4 v[5:8], off, s[8:11], -1 offset:4095
// CHECK: [0xff,0x0f,0x38,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_dwordx4 v[5:8], off, s[8:11], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x38,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_dwordx4 v[5:8], off, s[8:11], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x38,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_dwordx4 v[5:8], v0, s[8:11], s3 idxen offset:4095
// CHECK: [0xff,0x2f,0x38,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx4 v[5:8], v0, s[8:11], s3 offen offset:4095
// CHECK: [0xff,0x1f,0x38,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx4 v[5:8], v[0:1], s[8:11], s3 addr64 offset:4095
// CHECK: [0xff,0x8f,0x38,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx4 v[5:8], off, s[8:11], s3
// CHECK: [0x00,0x00,0x38,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx4 v[5:8], off, s[8:11], s3 offset:0
// CHECK: [0x00,0x00,0x38,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx4 v[5:8], off, s[8:11], s3 offset:7
// CHECK: [0x07,0x00,0x38,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx4 v[5:8], off, s[8:11], s3 offset:4095 glc
// CHECK: [0xff,0x4f,0x38,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx4 v[5:8], off, s[8:11], s3 offset:4095 slc
// CHECK: [0xff,0x0f,0x38,0xe0,0x00,0x05,0x42,0x03]

buffer_load_dwordx3 v[5:7], off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x3c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx3 v[253:255], off, s[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x3c,0xe0,0x00,0xfd,0x02,0x03]

buffer_load_dwordx3 v[5:7], off, s[12:15], s3 offset:4095
// CHECK: [0xff,0x0f,0x3c,0xe0,0x00,0x05,0x03,0x03]

buffer_load_dwordx3 v[5:7], off, s[100:103], s3 offset:4095
// CHECK: [0xff,0x0f,0x3c,0xe0,0x00,0x05,0x19,0x03]

buffer_load_dwordx3 v[5:7], off, ttmp[8:11], s3 offset:4095
// CHECK: [0xff,0x0f,0x3c,0xe0,0x00,0x05,0x1e,0x03]

buffer_load_dwordx3 v[5:7], off, s[8:11], s103 offset:4095
// CHECK: [0xff,0x0f,0x3c,0xe0,0x00,0x05,0x02,0x67]

buffer_load_dwordx3 v[5:7], off, s[8:11], m0 offset:4095
// CHECK: [0xff,0x0f,0x3c,0xe0,0x00,0x05,0x02,0x7c]

buffer_load_dwordx3 v[5:7], off, s[8:11], 0 offset:4095
// CHECK: [0xff,0x0f,0x3c,0xe0,0x00,0x05,0x02,0x80]

buffer_load_dwordx3 v[5:7], off, s[8:11], -1 offset:4095
// CHECK: [0xff,0x0f,0x3c,0xe0,0x00,0x05,0x02,0xc1]

buffer_load_dwordx3 v[5:7], off, s[8:11], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x3c,0xe0,0x00,0x05,0x02,0xf0]

buffer_load_dwordx3 v[5:7], off, s[8:11], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x3c,0xe0,0x00,0x05,0x02,0xf7]

buffer_load_dwordx3 v[5:7], v0, s[8:11], s3 idxen offset:4095
// CHECK: [0xff,0x2f,0x3c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx3 v[5:7], v0, s[8:11], s3 offen offset:4095
// CHECK: [0xff,0x1f,0x3c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx3 v[5:7], v[0:1], s[8:11], s3 addr64 offset:4095
// CHECK: [0xff,0x8f,0x3c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx3 v[5:7], off, s[8:11], s3
// CHECK: [0x00,0x00,0x3c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx3 v[5:7], off, s[8:11], s3 offset:0
// CHECK: [0x00,0x00,0x3c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx3 v[5:7], off, s[8:11], s3 offset:7
// CHECK: [0x07,0x00,0x3c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx3 v[5:7], off, s[8:11], s3 offset:4095 glc
// CHECK: [0xff,0x4f,0x3c,0xe0,0x00,0x05,0x02,0x03]

buffer_load_dwordx3 v[5:7], off, s[8:11], s3 offset:4095 slc
// CHECK: [0xff,0x0f,0x3c,0xe0,0x00,0x05,0x42,0x03]

buffer_store_byte v1, off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x60,0xe0,0x00,0x01,0x03,0x04]

buffer_store_byte v255, off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x60,0xe0,0x00,0xff,0x03,0x04]

buffer_store_byte v1, off, s[16:19], s4 offset:4095
// CHECK: [0xff,0x0f,0x60,0xe0,0x00,0x01,0x04,0x04]

buffer_store_byte v1, off, s[100:103], s4 offset:4095
// CHECK: [0xff,0x0f,0x60,0xe0,0x00,0x01,0x19,0x04]

buffer_store_byte v1, off, ttmp[8:11], s4 offset:4095
// CHECK: [0xff,0x0f,0x60,0xe0,0x00,0x01,0x1e,0x04]

buffer_store_byte v1, off, s[12:15], s103 offset:4095
// CHECK: [0xff,0x0f,0x60,0xe0,0x00,0x01,0x03,0x67]

buffer_store_byte v1, off, s[12:15], m0 offset:4095
// CHECK: [0xff,0x0f,0x60,0xe0,0x00,0x01,0x03,0x7c]

buffer_store_byte v1, off, s[12:15], 0 offset:4095
// CHECK: [0xff,0x0f,0x60,0xe0,0x00,0x01,0x03,0x80]

buffer_store_byte v1, off, s[12:15], -1 offset:4095
// CHECK: [0xff,0x0f,0x60,0xe0,0x00,0x01,0x03,0xc1]

buffer_store_byte v1, off, s[12:15], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x60,0xe0,0x00,0x01,0x03,0xf0]

buffer_store_byte v1, off, s[12:15], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x60,0xe0,0x00,0x01,0x03,0xf7]

buffer_store_byte v1, v0, s[12:15], s4 idxen offset:4095
// CHECK: [0xff,0x2f,0x60,0xe0,0x00,0x01,0x03,0x04]

buffer_store_byte v1, v0, s[12:15], s4 offen offset:4095
// CHECK: [0xff,0x1f,0x60,0xe0,0x00,0x01,0x03,0x04]

buffer_store_byte v1, v[0:1], s[12:15], s4 addr64 offset:4095
// CHECK: [0xff,0x8f,0x60,0xe0,0x00,0x01,0x03,0x04]

buffer_store_byte v1, off, s[12:15], s4
// CHECK: [0x00,0x00,0x60,0xe0,0x00,0x01,0x03,0x04]

buffer_store_byte v1, off, s[12:15], s4 offset:0
// CHECK: [0x00,0x00,0x60,0xe0,0x00,0x01,0x03,0x04]

buffer_store_byte v1, off, s[12:15], s4 offset:7
// CHECK: [0x07,0x00,0x60,0xe0,0x00,0x01,0x03,0x04]

buffer_store_byte v1, off, s[12:15], s4 offset:4095 glc
// CHECK: [0xff,0x4f,0x60,0xe0,0x00,0x01,0x03,0x04]

buffer_store_byte v1, off, s[12:15], s4 offset:4095 slc
// CHECK: [0xff,0x0f,0x60,0xe0,0x00,0x01,0x43,0x04]

buffer_store_short v1, off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x68,0xe0,0x00,0x01,0x03,0x04]

buffer_store_short v255, off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x68,0xe0,0x00,0xff,0x03,0x04]

buffer_store_short v1, off, s[16:19], s4 offset:4095
// CHECK: [0xff,0x0f,0x68,0xe0,0x00,0x01,0x04,0x04]

buffer_store_short v1, off, s[100:103], s4 offset:4095
// CHECK: [0xff,0x0f,0x68,0xe0,0x00,0x01,0x19,0x04]

buffer_store_short v1, off, ttmp[8:11], s4 offset:4095
// CHECK: [0xff,0x0f,0x68,0xe0,0x00,0x01,0x1e,0x04]

buffer_store_short v1, off, s[12:15], s103 offset:4095
// CHECK: [0xff,0x0f,0x68,0xe0,0x00,0x01,0x03,0x67]

buffer_store_short v1, off, s[12:15], m0 offset:4095
// CHECK: [0xff,0x0f,0x68,0xe0,0x00,0x01,0x03,0x7c]

buffer_store_short v1, off, s[12:15], 0 offset:4095
// CHECK: [0xff,0x0f,0x68,0xe0,0x00,0x01,0x03,0x80]

buffer_store_short v1, off, s[12:15], -1 offset:4095
// CHECK: [0xff,0x0f,0x68,0xe0,0x00,0x01,0x03,0xc1]

buffer_store_short v1, off, s[12:15], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x68,0xe0,0x00,0x01,0x03,0xf0]

buffer_store_short v1, off, s[12:15], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x68,0xe0,0x00,0x01,0x03,0xf7]

buffer_store_short v1, v0, s[12:15], s4 idxen offset:4095
// CHECK: [0xff,0x2f,0x68,0xe0,0x00,0x01,0x03,0x04]

buffer_store_short v1, v0, s[12:15], s4 offen offset:4095
// CHECK: [0xff,0x1f,0x68,0xe0,0x00,0x01,0x03,0x04]

buffer_store_short v1, v[0:1], s[12:15], s4 addr64 offset:4095
// CHECK: [0xff,0x8f,0x68,0xe0,0x00,0x01,0x03,0x04]

buffer_store_short v1, off, s[12:15], s4
// CHECK: [0x00,0x00,0x68,0xe0,0x00,0x01,0x03,0x04]

buffer_store_short v1, off, s[12:15], s4 offset:0
// CHECK: [0x00,0x00,0x68,0xe0,0x00,0x01,0x03,0x04]

buffer_store_short v1, off, s[12:15], s4 offset:7
// CHECK: [0x07,0x00,0x68,0xe0,0x00,0x01,0x03,0x04]

buffer_store_short v1, off, s[12:15], s4 offset:4095 glc
// CHECK: [0xff,0x4f,0x68,0xe0,0x00,0x01,0x03,0x04]

buffer_store_short v1, off, s[12:15], s4 offset:4095 slc
// CHECK: [0xff,0x0f,0x68,0xe0,0x00,0x01,0x43,0x04]

buffer_store_dword v1, off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x70,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dword v255, off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x70,0xe0,0x00,0xff,0x03,0x04]

buffer_store_dword v1, off, s[16:19], s4 offset:4095
// CHECK: [0xff,0x0f,0x70,0xe0,0x00,0x01,0x04,0x04]

buffer_store_dword v1, off, s[100:103], s4 offset:4095
// CHECK: [0xff,0x0f,0x70,0xe0,0x00,0x01,0x19,0x04]

buffer_store_dword v1, off, ttmp[8:11], s4 offset:4095
// CHECK: [0xff,0x0f,0x70,0xe0,0x00,0x01,0x1e,0x04]

buffer_store_dword v1, off, s[12:15], s103 offset:4095
// CHECK: [0xff,0x0f,0x70,0xe0,0x00,0x01,0x03,0x67]

buffer_store_dword v1, off, s[12:15], m0 offset:4095
// CHECK: [0xff,0x0f,0x70,0xe0,0x00,0x01,0x03,0x7c]

buffer_store_dword v1, off, s[12:15], 0 offset:4095
// CHECK: [0xff,0x0f,0x70,0xe0,0x00,0x01,0x03,0x80]

buffer_store_dword v1, off, s[12:15], -1 offset:4095
// CHECK: [0xff,0x0f,0x70,0xe0,0x00,0x01,0x03,0xc1]

buffer_store_dword v1, off, s[12:15], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x70,0xe0,0x00,0x01,0x03,0xf0]

buffer_store_dword v1, off, s[12:15], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x70,0xe0,0x00,0x01,0x03,0xf7]

buffer_store_dword v1, v0, s[12:15], s4 idxen offset:4095
// CHECK: [0xff,0x2f,0x70,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dword v1, v0, s[12:15], s4 offen offset:4095
// CHECK: [0xff,0x1f,0x70,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dword v1, v[0:1], s[12:15], s4 addr64 offset:4095
// CHECK: [0xff,0x8f,0x70,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dword v1, off, s[12:15], s4
// CHECK: [0x00,0x00,0x70,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dword v1, off, s[12:15], s4 offset:0
// CHECK: [0x00,0x00,0x70,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dword v1, off, s[12:15], s4 offset:7
// CHECK: [0x07,0x00,0x70,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dword v1, off, s[12:15], s4 offset:4095 glc
// CHECK: [0xff,0x4f,0x70,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dword v1, off, s[12:15], s4 offset:4095 slc
// CHECK: [0xff,0x0f,0x70,0xe0,0x00,0x01,0x43,0x04]

buffer_store_dwordx2 v[1:2], off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x74,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx2 v[254:255], off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x74,0xe0,0x00,0xfe,0x03,0x04]

buffer_store_dwordx2 v[1:2], off, s[16:19], s4 offset:4095
// CHECK: [0xff,0x0f,0x74,0xe0,0x00,0x01,0x04,0x04]

buffer_store_dwordx2 v[1:2], off, s[100:103], s4 offset:4095
// CHECK: [0xff,0x0f,0x74,0xe0,0x00,0x01,0x19,0x04]

buffer_store_dwordx2 v[1:2], off, ttmp[8:11], s4 offset:4095
// CHECK: [0xff,0x0f,0x74,0xe0,0x00,0x01,0x1e,0x04]

buffer_store_dwordx2 v[1:2], off, s[12:15], s103 offset:4095
// CHECK: [0xff,0x0f,0x74,0xe0,0x00,0x01,0x03,0x67]

buffer_store_dwordx2 v[1:2], off, s[12:15], m0 offset:4095
// CHECK: [0xff,0x0f,0x74,0xe0,0x00,0x01,0x03,0x7c]

buffer_store_dwordx2 v[1:2], off, s[12:15], 0 offset:4095
// CHECK: [0xff,0x0f,0x74,0xe0,0x00,0x01,0x03,0x80]

buffer_store_dwordx2 v[1:2], off, s[12:15], -1 offset:4095
// CHECK: [0xff,0x0f,0x74,0xe0,0x00,0x01,0x03,0xc1]

buffer_store_dwordx2 v[1:2], off, s[12:15], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x74,0xe0,0x00,0x01,0x03,0xf0]

buffer_store_dwordx2 v[1:2], off, s[12:15], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x74,0xe0,0x00,0x01,0x03,0xf7]

buffer_store_dwordx2 v[1:2], v0, s[12:15], s4 idxen offset:4095
// CHECK: [0xff,0x2f,0x74,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx2 v[1:2], v0, s[12:15], s4 offen offset:4095
// CHECK: [0xff,0x1f,0x74,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx2 v[1:2], v[0:1], s[12:15], s4 addr64 offset:4095
// CHECK: [0xff,0x8f,0x74,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx2 v[1:2], off, s[12:15], s4
// CHECK: [0x00,0x00,0x74,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx2 v[1:2], off, s[12:15], s4 offset:0
// CHECK: [0x00,0x00,0x74,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx2 v[1:2], off, s[12:15], s4 offset:7
// CHECK: [0x07,0x00,0x74,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx2 v[1:2], off, s[12:15], s4 offset:4095 glc
// CHECK: [0xff,0x4f,0x74,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx2 v[1:2], off, s[12:15], s4 offset:4095 slc
// CHECK: [0xff,0x0f,0x74,0xe0,0x00,0x01,0x43,0x04]

buffer_store_dwordx4 v[1:4], off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x78,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx4 v[252:255], off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x78,0xe0,0x00,0xfc,0x03,0x04]

buffer_store_dwordx4 v[1:4], off, s[16:19], s4 offset:4095
// CHECK: [0xff,0x0f,0x78,0xe0,0x00,0x01,0x04,0x04]

buffer_store_dwordx4 v[1:4], off, s[100:103], s4 offset:4095
// CHECK: [0xff,0x0f,0x78,0xe0,0x00,0x01,0x19,0x04]

buffer_store_dwordx4 v[1:4], off, ttmp[8:11], s4 offset:4095
// CHECK: [0xff,0x0f,0x78,0xe0,0x00,0x01,0x1e,0x04]

buffer_store_dwordx4 v[1:4], off, s[12:15], s103 offset:4095
// CHECK: [0xff,0x0f,0x78,0xe0,0x00,0x01,0x03,0x67]

buffer_store_dwordx4 v[1:4], off, s[12:15], m0 offset:4095
// CHECK: [0xff,0x0f,0x78,0xe0,0x00,0x01,0x03,0x7c]

buffer_store_dwordx4 v[1:4], off, s[12:15], 0 offset:4095
// CHECK: [0xff,0x0f,0x78,0xe0,0x00,0x01,0x03,0x80]

buffer_store_dwordx4 v[1:4], off, s[12:15], -1 offset:4095
// CHECK: [0xff,0x0f,0x78,0xe0,0x00,0x01,0x03,0xc1]

buffer_store_dwordx4 v[1:4], off, s[12:15], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x78,0xe0,0x00,0x01,0x03,0xf0]

buffer_store_dwordx4 v[1:4], off, s[12:15], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x78,0xe0,0x00,0x01,0x03,0xf7]

buffer_store_dwordx4 v[1:4], v0, s[12:15], s4 idxen offset:4095
// CHECK: [0xff,0x2f,0x78,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx4 v[1:4], v0, s[12:15], s4 offen offset:4095
// CHECK: [0xff,0x1f,0x78,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx4 v[1:4], v[0:1], s[12:15], s4 addr64 offset:4095
// CHECK: [0xff,0x8f,0x78,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx4 v[1:4], off, s[12:15], s4
// CHECK: [0x00,0x00,0x78,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx4 v[1:4], off, s[12:15], s4 offset:0
// CHECK: [0x00,0x00,0x78,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx4 v[1:4], off, s[12:15], s4 offset:7
// CHECK: [0x07,0x00,0x78,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx4 v[1:4], off, s[12:15], s4 offset:4095 glc
// CHECK: [0xff,0x4f,0x78,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx4 v[1:4], off, s[12:15], s4 offset:4095 slc
// CHECK: [0xff,0x0f,0x78,0xe0,0x00,0x01,0x43,0x04]

buffer_store_dwordx3 v[1:3], off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x7c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx3 v[253:255], off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x7c,0xe0,0x00,0xfd,0x03,0x04]

buffer_store_dwordx3 v[1:3], off, s[16:19], s4 offset:4095
// CHECK: [0xff,0x0f,0x7c,0xe0,0x00,0x01,0x04,0x04]

buffer_store_dwordx3 v[1:3], off, s[100:103], s4 offset:4095
// CHECK: [0xff,0x0f,0x7c,0xe0,0x00,0x01,0x19,0x04]

buffer_store_dwordx3 v[1:3], off, ttmp[8:11], s4 offset:4095
// CHECK: [0xff,0x0f,0x7c,0xe0,0x00,0x01,0x1e,0x04]

buffer_store_dwordx3 v[1:3], off, s[12:15], s103 offset:4095
// CHECK: [0xff,0x0f,0x7c,0xe0,0x00,0x01,0x03,0x67]

buffer_store_dwordx3 v[1:3], off, s[12:15], m0 offset:4095
// CHECK: [0xff,0x0f,0x7c,0xe0,0x00,0x01,0x03,0x7c]

buffer_store_dwordx3 v[1:3], off, s[12:15], 0 offset:4095
// CHECK: [0xff,0x0f,0x7c,0xe0,0x00,0x01,0x03,0x80]

buffer_store_dwordx3 v[1:3], off, s[12:15], -1 offset:4095
// CHECK: [0xff,0x0f,0x7c,0xe0,0x00,0x01,0x03,0xc1]

buffer_store_dwordx3 v[1:3], off, s[12:15], 0.5 offset:4095
// CHECK: [0xff,0x0f,0x7c,0xe0,0x00,0x01,0x03,0xf0]

buffer_store_dwordx3 v[1:3], off, s[12:15], -4.0 offset:4095
// CHECK: [0xff,0x0f,0x7c,0xe0,0x00,0x01,0x03,0xf7]

buffer_store_dwordx3 v[1:3], v0, s[12:15], s4 idxen offset:4095
// CHECK: [0xff,0x2f,0x7c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx3 v[1:3], v0, s[12:15], s4 offen offset:4095
// CHECK: [0xff,0x1f,0x7c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx3 v[1:3], v[0:1], s[12:15], s4 addr64 offset:4095
// CHECK: [0xff,0x8f,0x7c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx3 v[1:3], off, s[12:15], s4
// CHECK: [0x00,0x00,0x7c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx3 v[1:3], off, s[12:15], s4 offset:0
// CHECK: [0x00,0x00,0x7c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx3 v[1:3], off, s[12:15], s4 offset:7
// CHECK: [0x07,0x00,0x7c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx3 v[1:3], off, s[12:15], s4 offset:4095 glc
// CHECK: [0xff,0x4f,0x7c,0xe0,0x00,0x01,0x03,0x04]

buffer_store_dwordx3 v[1:3], off, s[12:15], s4 offset:4095 slc
// CHECK: [0xff,0x0f,0x7c,0xe0,0x00,0x01,0x43,0x04]

buffer_atomic_swap v1, off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0xc0,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_swap v255, off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0xc0,0xe0,0x00,0xff,0x03,0x04]

buffer_atomic_swap v1, off, s[16:19], s4 offset:4095
// CHECK: [0xff,0x0f,0xc0,0xe0,0x00,0x01,0x04,0x04]

buffer_atomic_swap v1, off, s[100:103], s4 offset:4095
// CHECK: [0xff,0x0f,0xc0,0xe0,0x00,0x01,0x19,0x04]

buffer_atomic_swap v1, off, ttmp[8:11], s4 offset:4095
// CHECK: [0xff,0x0f,0xc0,0xe0,0x00,0x01,0x1e,0x04]

buffer_atomic_swap v1, off, s[12:15], s103 offset:4095
// CHECK: [0xff,0x0f,0xc0,0xe0,0x00,0x01,0x03,0x67]

buffer_atomic_swap v1, off, s[12:15], m0 offset:4095
// CHECK: [0xff,0x0f,0xc0,0xe0,0x00,0x01,0x03,0x7c]

buffer_atomic_swap v1, off, s[12:15], 0 offset:4095
// CHECK: [0xff,0x0f,0xc0,0xe0,0x00,0x01,0x03,0x80]

buffer_atomic_swap v1, off, s[12:15], -1 offset:4095
// CHECK: [0xff,0x0f,0xc0,0xe0,0x00,0x01,0x03,0xc1]

buffer_atomic_swap v1, v0, s[12:15], s4 idxen offset:4095
// CHECK: [0xff,0x2f,0xc0,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_swap v1, v0, s[12:15], s4 offen offset:4095
// CHECK: [0xff,0x1f,0xc0,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_swap v1, v[0:1], s[12:15], s4 addr64 offset:4095
// CHECK: [0xff,0x8f,0xc0,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_swap v1, off, s[12:15], s4
// CHECK: [0x00,0x00,0xc0,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_swap v1, off, s[12:15], s4 offset:0
// CHECK: [0x00,0x00,0xc0,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_swap v1, off, s[12:15], s4 offset:7
// CHECK: [0x07,0x00,0xc0,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_swap v1, off, s[12:15], s4 offset:4095 glc
// CHECK: [0xff,0x4f,0xc0,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_swap v1, off, s[12:15], s4 offset:4095 slc
// CHECK: [0xff,0x0f,0xc0,0xe0,0x00,0x01,0x43,0x04]

buffer_atomic_cmpswap v[1:2], off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0xc4,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_cmpswap v[254:255], off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0xc4,0xe0,0x00,0xfe,0x03,0x04]

buffer_atomic_cmpswap v[1:2], off, s[16:19], s4 offset:4095
// CHECK: [0xff,0x0f,0xc4,0xe0,0x00,0x01,0x04,0x04]

buffer_atomic_cmpswap v[1:2], off, s[100:103], s4 offset:4095
// CHECK: [0xff,0x0f,0xc4,0xe0,0x00,0x01,0x19,0x04]

buffer_atomic_cmpswap v[1:2], off, ttmp[8:11], s4 offset:4095
// CHECK: [0xff,0x0f,0xc4,0xe0,0x00,0x01,0x1e,0x04]

buffer_atomic_cmpswap v[1:2], off, s[12:15], s103 offset:4095
// CHECK: [0xff,0x0f,0xc4,0xe0,0x00,0x01,0x03,0x67]

buffer_atomic_cmpswap v[1:2], off, s[12:15], m0 offset:4095
// CHECK: [0xff,0x0f,0xc4,0xe0,0x00,0x01,0x03,0x7c]

buffer_atomic_cmpswap v[1:2], off, s[12:15], 0 offset:4095
// CHECK: [0xff,0x0f,0xc4,0xe0,0x00,0x01,0x03,0x80]

buffer_atomic_cmpswap v[1:2], off, s[12:15], -1 offset:4095
// CHECK: [0xff,0x0f,0xc4,0xe0,0x00,0x01,0x03,0xc1]

buffer_atomic_cmpswap v[1:2], v0, s[12:15], s4 idxen offset:4095
// CHECK: [0xff,0x2f,0xc4,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_cmpswap v[1:2], v0, s[12:15], s4 offen offset:4095
// CHECK: [0xff,0x1f,0xc4,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_cmpswap v[1:2], v[0:1], s[12:15], s4 addr64 offset:4095
// CHECK: [0xff,0x8f,0xc4,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_cmpswap v[1:2], off, s[12:15], s4
// CHECK: [0x00,0x00,0xc4,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_cmpswap v[1:2], off, s[12:15], s4 offset:0
// CHECK: [0x00,0x00,0xc4,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_cmpswap v[1:2], off, s[12:15], s4 offset:7
// CHECK: [0x07,0x00,0xc4,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_cmpswap v[1:2], off, s[12:15], s4 offset:4095 glc
// CHECK: [0xff,0x4f,0xc4,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_cmpswap v[1:2], off, s[12:15], s4 offset:4095 slc
// CHECK: [0xff,0x0f,0xc4,0xe0,0x00,0x01,0x43,0x04]

buffer_atomic_add v1, off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0xc8,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_add v255, off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0xc8,0xe0,0x00,0xff,0x03,0x04]

buffer_atomic_add v1, off, s[16:19], s4 offset:4095
// CHECK: [0xff,0x0f,0xc8,0xe0,0x00,0x01,0x04,0x04]

buffer_atomic_add v1, off, s[100:103], s4 offset:4095
// CHECK: [0xff,0x0f,0xc8,0xe0,0x00,0x01,0x19,0x04]

buffer_atomic_add v1, off, ttmp[8:11], s4 offset:4095
// CHECK: [0xff,0x0f,0xc8,0xe0,0x00,0x01,0x1e,0x04]

buffer_atomic_add v1, off, s[12:15], s103 offset:4095
// CHECK: [0xff,0x0f,0xc8,0xe0,0x00,0x01,0x03,0x67]

buffer_atomic_add v1, off, s[12:15], m0 offset:4095
// CHECK: [0xff,0x0f,0xc8,0xe0,0x00,0x01,0x03,0x7c]

buffer_atomic_add v1, off, s[12:15], 0 offset:4095
// CHECK: [0xff,0x0f,0xc8,0xe0,0x00,0x01,0x03,0x80]

buffer_atomic_add v1, off, s[12:15], -1 offset:4095
// CHECK: [0xff,0x0f,0xc8,0xe0,0x00,0x01,0x03,0xc1]

buffer_atomic_add v1, v0, s[12:15], s4 idxen offset:4095
// CHECK: [0xff,0x2f,0xc8,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_add v1, v0, s[12:15], s4 offen offset:4095
// CHECK: [0xff,0x1f,0xc8,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_add v1, v[0:1], s[12:15], s4 addr64 offset:4095
// CHECK: [0xff,0x8f,0xc8,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_add v1, off, s[12:15], s4
// CHECK: [0x00,0x00,0xc8,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_add v1, off, s[12:15], s4 offset:0
// CHECK: [0x00,0x00,0xc8,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_add v1, off, s[12:15], s4 offset:7
// CHECK: [0x07,0x00,0xc8,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_add v1, off, s[12:15], s4 offset:4095 glc
// CHECK: [0xff,0x4f,0xc8,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_add v1, off, s[12:15], s4 offset:4095 slc
// CHECK: [0xff,0x0f,0xc8,0xe0,0x00,0x01,0x43,0x04]

buffer_atomic_sub v1, off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0xcc,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_sub v255, off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0xcc,0xe0,0x00,0xff,0x03,0x04]

buffer_atomic_sub v1, off, s[16:19], s4 offset:4095
// CHECK: [0xff,0x0f,0xcc,0xe0,0x00,0x01,0x04,0x04]

buffer_atomic_sub v1, off, s[100:103], s4 offset:4095
// CHECK: [0xff,0x0f,0xcc,0xe0,0x00,0x01,0x19,0x04]

buffer_atomic_sub v1, off, ttmp[8:11], s4 offset:4095
// CHECK: [0xff,0x0f,0xcc,0xe0,0x00,0x01,0x1e,0x04]

buffer_atomic_sub v1, off, s[12:15], s103 offset:4095
// CHECK: [0xff,0x0f,0xcc,0xe0,0x00,0x01,0x03,0x67]

buffer_atomic_sub v1, off, s[12:15], m0 offset:4095
// CHECK: [0xff,0x0f,0xcc,0xe0,0x00,0x01,0x03,0x7c]

buffer_atomic_sub v1, off, s[12:15], 0 offset:4095
// CHECK: [0xff,0x0f,0xcc,0xe0,0x00,0x01,0x03,0x80]

buffer_atomic_sub v1, off, s[12:15], -1 offset:4095
// CHECK: [0xff,0x0f,0xcc,0xe0,0x00,0x01,0x03,0xc1]

buffer_atomic_sub v1, v0, s[12:15], s4 idxen offset:4095
// CHECK: [0xff,0x2f,0xcc,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_sub v1, v0, s[12:15], s4 offen offset:4095
// CHECK: [0xff,0x1f,0xcc,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_sub v1, v[0:1], s[12:15], s4 addr64 offset:4095
// CHECK: [0xff,0x8f,0xcc,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_sub v1, off, s[12:15], s4
// CHECK: [0x00,0x00,0xcc,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_sub v1, off, s[12:15], s4 offset:0
// CHECK: [0x00,0x00,0xcc,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_sub v1, off, s[12:15], s4 offset:7
// CHECK: [0x07,0x00,0xcc,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_sub v1, off, s[12:15], s4 offset:4095 glc
// CHECK: [0xff,0x4f,0xcc,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_sub v1, off, s[12:15], s4 offset:4095 slc
// CHECK: [0xff,0x0f,0xcc,0xe0,0x00,0x01,0x43,0x04]

buffer_atomic_smin v1, off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0xd4,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_smin v255, off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0xd4,0xe0,0x00,0xff,0x03,0x04]

buffer_atomic_smin v1, off, s[16:19], s4 offset:4095
// CHECK: [0xff,0x0f,0xd4,0xe0,0x00,0x01,0x04,0x04]

buffer_atomic_smin v1, off, s[100:103], s4 offset:4095
// CHECK: [0xff,0x0f,0xd4,0xe0,0x00,0x01,0x19,0x04]

buffer_atomic_smin v1, off, ttmp[8:11], s4 offset:4095
// CHECK: [0xff,0x0f,0xd4,0xe0,0x00,0x01,0x1e,0x04]

buffer_atomic_smin v1, off, s[12:15], s103 offset:4095
// CHECK: [0xff,0x0f,0xd4,0xe0,0x00,0x01,0x03,0x67]

buffer_atomic_smin v1, off, s[12:15], m0 offset:4095
// CHECK: [0xff,0x0f,0xd4,0xe0,0x00,0x01,0x03,0x7c]

buffer_atomic_smin v1, off, s[12:15], 0 offset:4095
// CHECK: [0xff,0x0f,0xd4,0xe0,0x00,0x01,0x03,0x80]

buffer_atomic_smin v1, off, s[12:15], -1 offset:4095
// CHECK: [0xff,0x0f,0xd4,0xe0,0x00,0x01,0x03,0xc1]

buffer_atomic_smin v1, v0, s[12:15], s4 idxen offset:4095
// CHECK: [0xff,0x2f,0xd4,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_smin v1, v0, s[12:15], s4 offen offset:4095
// CHECK: [0xff,0x1f,0xd4,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_smin v1, v[0:1], s[12:15], s4 addr64 offset:4095
// CHECK: [0xff,0x8f,0xd4,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_smin v1, off, s[12:15], s4
// CHECK: [0x00,0x00,0xd4,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_smin v1, off, s[12:15], s4 offset:0
// CHECK: [0x00,0x00,0xd4,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_smin v1, off, s[12:15], s4 offset:7
// CHECK: [0x07,0x00,0xd4,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_smin v1, off, s[12:15], s4 offset:4095 glc
// CHECK: [0xff,0x4f,0xd4,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_smin v1, off, s[12:15], s4 offset:4095 slc
// CHECK: [0xff,0x0f,0xd4,0xe0,0x00,0x01,0x43,0x04]

buffer_atomic_umin v1, off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0xd8,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_umin v255, off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0xd8,0xe0,0x00,0xff,0x03,0x04]

buffer_atomic_umin v1, off, s[16:19], s4 offset:4095
// CHECK: [0xff,0x0f,0xd8,0xe0,0x00,0x01,0x04,0x04]

buffer_atomic_umin v1, off, s[100:103], s4 offset:4095
// CHECK: [0xff,0x0f,0xd8,0xe0,0x00,0x01,0x19,0x04]

buffer_atomic_umin v1, off, ttmp[8:11], s4 offset:4095
// CHECK: [0xff,0x0f,0xd8,0xe0,0x00,0x01,0x1e,0x04]

buffer_atomic_umin v1, off, s[12:15], s103 offset:4095
// CHECK: [0xff,0x0f,0xd8,0xe0,0x00,0x01,0x03,0x67]

buffer_atomic_umin v1, off, s[12:15], m0 offset:4095
// CHECK: [0xff,0x0f,0xd8,0xe0,0x00,0x01,0x03,0x7c]

buffer_atomic_umin v1, off, s[12:15], 0 offset:4095
// CHECK: [0xff,0x0f,0xd8,0xe0,0x00,0x01,0x03,0x80]

buffer_atomic_umin v1, off, s[12:15], -1 offset:4095
// CHECK: [0xff,0x0f,0xd8,0xe0,0x00,0x01,0x03,0xc1]

buffer_atomic_umin v1, v0, s[12:15], s4 idxen offset:4095
// CHECK: [0xff,0x2f,0xd8,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_umin v1, v0, s[12:15], s4 offen offset:4095
// CHECK: [0xff,0x1f,0xd8,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_umin v1, v[0:1], s[12:15], s4 addr64 offset:4095
// CHECK: [0xff,0x8f,0xd8,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_umin v1, off, s[12:15], s4
// CHECK: [0x00,0x00,0xd8,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_umin v1, off, s[12:15], s4 offset:0
// CHECK: [0x00,0x00,0xd8,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_umin v1, off, s[12:15], s4 offset:7
// CHECK: [0x07,0x00,0xd8,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_umin v1, off, s[12:15], s4 offset:4095 glc
// CHECK: [0xff,0x4f,0xd8,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_umin v1, off, s[12:15], s4 offset:4095 slc
// CHECK: [0xff,0x0f,0xd8,0xe0,0x00,0x01,0x43,0x04]

buffer_atomic_smax v1, off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0xdc,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_smax v255, off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0xdc,0xe0,0x00,0xff,0x03,0x04]

buffer_atomic_smax v1, off, s[16:19], s4 offset:4095
// CHECK: [0xff,0x0f,0xdc,0xe0,0x00,0x01,0x04,0x04]

buffer_atomic_smax v1, off, s[100:103], s4 offset:4095
// CHECK: [0xff,0x0f,0xdc,0xe0,0x00,0x01,0x19,0x04]

buffer_atomic_smax v1, off, ttmp[8:11], s4 offset:4095
// CHECK: [0xff,0x0f,0xdc,0xe0,0x00,0x01,0x1e,0x04]

buffer_atomic_smax v1, off, s[12:15], s103 offset:4095
// CHECK: [0xff,0x0f,0xdc,0xe0,0x00,0x01,0x03,0x67]

buffer_atomic_smax v1, off, s[12:15], m0 offset:4095
// CHECK: [0xff,0x0f,0xdc,0xe0,0x00,0x01,0x03,0x7c]

buffer_atomic_smax v1, off, s[12:15], 0 offset:4095
// CHECK: [0xff,0x0f,0xdc,0xe0,0x00,0x01,0x03,0x80]

buffer_atomic_smax v1, off, s[12:15], -1 offset:4095
// CHECK: [0xff,0x0f,0xdc,0xe0,0x00,0x01,0x03,0xc1]

buffer_atomic_smax v1, v0, s[12:15], s4 idxen offset:4095
// CHECK: [0xff,0x2f,0xdc,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_smax v1, v0, s[12:15], s4 offen offset:4095
// CHECK: [0xff,0x1f,0xdc,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_smax v1, v[0:1], s[12:15], s4 addr64 offset:4095
// CHECK: [0xff,0x8f,0xdc,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_smax v1, off, s[12:15], s4
// CHECK: [0x00,0x00,0xdc,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_smax v1, off, s[12:15], s4 offset:0
// CHECK: [0x00,0x00,0xdc,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_smax v1, off, s[12:15], s4 offset:7
// CHECK: [0x07,0x00,0xdc,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_smax v1, off, s[12:15], s4 offset:4095 glc
// CHECK: [0xff,0x4f,0xdc,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_smax v1, off, s[12:15], s4 offset:4095 slc
// CHECK: [0xff,0x0f,0xdc,0xe0,0x00,0x01,0x43,0x04]

buffer_atomic_umax v1, off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0xe0,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_umax v255, off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0xe0,0xe0,0x00,0xff,0x03,0x04]

buffer_atomic_umax v1, off, s[16:19], s4 offset:4095
// CHECK: [0xff,0x0f,0xe0,0xe0,0x00,0x01,0x04,0x04]

buffer_atomic_umax v1, off, s[100:103], s4 offset:4095
// CHECK: [0xff,0x0f,0xe0,0xe0,0x00,0x01,0x19,0x04]

buffer_atomic_umax v1, off, ttmp[8:11], s4 offset:4095
// CHECK: [0xff,0x0f,0xe0,0xe0,0x00,0x01,0x1e,0x04]

buffer_atomic_umax v1, off, s[12:15], s103 offset:4095
// CHECK: [0xff,0x0f,0xe0,0xe0,0x00,0x01,0x03,0x67]

buffer_atomic_umax v1, off, s[12:15], m0 offset:4095
// CHECK: [0xff,0x0f,0xe0,0xe0,0x00,0x01,0x03,0x7c]

buffer_atomic_umax v1, off, s[12:15], 0 offset:4095
// CHECK: [0xff,0x0f,0xe0,0xe0,0x00,0x01,0x03,0x80]

buffer_atomic_umax v1, off, s[12:15], -1 offset:4095
// CHECK: [0xff,0x0f,0xe0,0xe0,0x00,0x01,0x03,0xc1]

buffer_atomic_umax v1, v0, s[12:15], s4 idxen offset:4095
// CHECK: [0xff,0x2f,0xe0,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_umax v1, v0, s[12:15], s4 offen offset:4095
// CHECK: [0xff,0x1f,0xe0,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_umax v1, v[0:1], s[12:15], s4 addr64 offset:4095
// CHECK: [0xff,0x8f,0xe0,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_umax v1, off, s[12:15], s4
// CHECK: [0x00,0x00,0xe0,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_umax v1, off, s[12:15], s4 offset:0
// CHECK: [0x00,0x00,0xe0,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_umax v1, off, s[12:15], s4 offset:7
// CHECK: [0x07,0x00,0xe0,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_umax v1, off, s[12:15], s4 offset:4095 glc
// CHECK: [0xff,0x4f,0xe0,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_umax v1, off, s[12:15], s4 offset:4095 slc
// CHECK: [0xff,0x0f,0xe0,0xe0,0x00,0x01,0x43,0x04]

buffer_atomic_and v1, off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0xe4,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_and v255, off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0xe4,0xe0,0x00,0xff,0x03,0x04]

buffer_atomic_and v1, off, s[16:19], s4 offset:4095
// CHECK: [0xff,0x0f,0xe4,0xe0,0x00,0x01,0x04,0x04]

buffer_atomic_and v1, off, s[100:103], s4 offset:4095
// CHECK: [0xff,0x0f,0xe4,0xe0,0x00,0x01,0x19,0x04]

buffer_atomic_and v1, off, ttmp[8:11], s4 offset:4095
// CHECK: [0xff,0x0f,0xe4,0xe0,0x00,0x01,0x1e,0x04]

buffer_atomic_and v1, off, s[12:15], s103 offset:4095
// CHECK: [0xff,0x0f,0xe4,0xe0,0x00,0x01,0x03,0x67]

buffer_atomic_and v1, off, s[12:15], m0 offset:4095
// CHECK: [0xff,0x0f,0xe4,0xe0,0x00,0x01,0x03,0x7c]

buffer_atomic_and v1, off, s[12:15], 0 offset:4095
// CHECK: [0xff,0x0f,0xe4,0xe0,0x00,0x01,0x03,0x80]

buffer_atomic_and v1, off, s[12:15], -1 offset:4095
// CHECK: [0xff,0x0f,0xe4,0xe0,0x00,0x01,0x03,0xc1]

buffer_atomic_and v1, v0, s[12:15], s4 idxen offset:4095
// CHECK: [0xff,0x2f,0xe4,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_and v1, v0, s[12:15], s4 offen offset:4095
// CHECK: [0xff,0x1f,0xe4,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_and v1, v[0:1], s[12:15], s4 addr64 offset:4095
// CHECK: [0xff,0x8f,0xe4,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_and v1, off, s[12:15], s4
// CHECK: [0x00,0x00,0xe4,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_and v1, off, s[12:15], s4 offset:0
// CHECK: [0x00,0x00,0xe4,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_and v1, off, s[12:15], s4 offset:7
// CHECK: [0x07,0x00,0xe4,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_and v1, off, s[12:15], s4 offset:4095 glc
// CHECK: [0xff,0x4f,0xe4,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_and v1, off, s[12:15], s4 offset:4095 slc
// CHECK: [0xff,0x0f,0xe4,0xe0,0x00,0x01,0x43,0x04]

buffer_atomic_or v1, off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0xe8,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_or v255, off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0xe8,0xe0,0x00,0xff,0x03,0x04]

buffer_atomic_or v1, off, s[16:19], s4 offset:4095
// CHECK: [0xff,0x0f,0xe8,0xe0,0x00,0x01,0x04,0x04]

buffer_atomic_or v1, off, s[100:103], s4 offset:4095
// CHECK: [0xff,0x0f,0xe8,0xe0,0x00,0x01,0x19,0x04]

buffer_atomic_or v1, off, ttmp[8:11], s4 offset:4095
// CHECK: [0xff,0x0f,0xe8,0xe0,0x00,0x01,0x1e,0x04]

buffer_atomic_or v1, off, s[12:15], s103 offset:4095
// CHECK: [0xff,0x0f,0xe8,0xe0,0x00,0x01,0x03,0x67]

buffer_atomic_or v1, off, s[12:15], m0 offset:4095
// CHECK: [0xff,0x0f,0xe8,0xe0,0x00,0x01,0x03,0x7c]

buffer_atomic_or v1, off, s[12:15], 0 offset:4095
// CHECK: [0xff,0x0f,0xe8,0xe0,0x00,0x01,0x03,0x80]

buffer_atomic_or v1, off, s[12:15], -1 offset:4095
// CHECK: [0xff,0x0f,0xe8,0xe0,0x00,0x01,0x03,0xc1]

buffer_atomic_or v1, v0, s[12:15], s4 idxen offset:4095
// CHECK: [0xff,0x2f,0xe8,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_or v1, v0, s[12:15], s4 offen offset:4095
// CHECK: [0xff,0x1f,0xe8,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_or v1, v[0:1], s[12:15], s4 addr64 offset:4095
// CHECK: [0xff,0x8f,0xe8,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_or v1, off, s[12:15], s4
// CHECK: [0x00,0x00,0xe8,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_or v1, off, s[12:15], s4 offset:0
// CHECK: [0x00,0x00,0xe8,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_or v1, off, s[12:15], s4 offset:7
// CHECK: [0x07,0x00,0xe8,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_or v1, off, s[12:15], s4 offset:4095 glc
// CHECK: [0xff,0x4f,0xe8,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_or v1, off, s[12:15], s4 offset:4095 slc
// CHECK: [0xff,0x0f,0xe8,0xe0,0x00,0x01,0x43,0x04]

buffer_atomic_xor v1, off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0xec,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_xor v255, off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0xec,0xe0,0x00,0xff,0x03,0x04]

buffer_atomic_xor v1, off, s[16:19], s4 offset:4095
// CHECK: [0xff,0x0f,0xec,0xe0,0x00,0x01,0x04,0x04]

buffer_atomic_xor v1, off, s[100:103], s4 offset:4095
// CHECK: [0xff,0x0f,0xec,0xe0,0x00,0x01,0x19,0x04]

buffer_atomic_xor v1, off, ttmp[8:11], s4 offset:4095
// CHECK: [0xff,0x0f,0xec,0xe0,0x00,0x01,0x1e,0x04]

buffer_atomic_xor v1, off, s[12:15], s103 offset:4095
// CHECK: [0xff,0x0f,0xec,0xe0,0x00,0x01,0x03,0x67]

buffer_atomic_xor v1, off, s[12:15], m0 offset:4095
// CHECK: [0xff,0x0f,0xec,0xe0,0x00,0x01,0x03,0x7c]

buffer_atomic_xor v1, off, s[12:15], 0 offset:4095
// CHECK: [0xff,0x0f,0xec,0xe0,0x00,0x01,0x03,0x80]

buffer_atomic_xor v1, off, s[12:15], -1 offset:4095
// CHECK: [0xff,0x0f,0xec,0xe0,0x00,0x01,0x03,0xc1]

buffer_atomic_xor v1, v0, s[12:15], s4 idxen offset:4095
// CHECK: [0xff,0x2f,0xec,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_xor v1, v0, s[12:15], s4 offen offset:4095
// CHECK: [0xff,0x1f,0xec,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_xor v1, v[0:1], s[12:15], s4 addr64 offset:4095
// CHECK: [0xff,0x8f,0xec,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_xor v1, off, s[12:15], s4
// CHECK: [0x00,0x00,0xec,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_xor v1, off, s[12:15], s4 offset:0
// CHECK: [0x00,0x00,0xec,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_xor v1, off, s[12:15], s4 offset:7
// CHECK: [0x07,0x00,0xec,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_xor v1, off, s[12:15], s4 offset:4095 glc
// CHECK: [0xff,0x4f,0xec,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_xor v1, off, s[12:15], s4 offset:4095 slc
// CHECK: [0xff,0x0f,0xec,0xe0,0x00,0x01,0x43,0x04]

buffer_atomic_inc v1, off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0xf0,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_inc v255, off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0xf0,0xe0,0x00,0xff,0x03,0x04]

buffer_atomic_inc v1, off, s[16:19], s4 offset:4095
// CHECK: [0xff,0x0f,0xf0,0xe0,0x00,0x01,0x04,0x04]

buffer_atomic_inc v1, off, s[100:103], s4 offset:4095
// CHECK: [0xff,0x0f,0xf0,0xe0,0x00,0x01,0x19,0x04]

buffer_atomic_inc v1, off, ttmp[8:11], s4 offset:4095
// CHECK: [0xff,0x0f,0xf0,0xe0,0x00,0x01,0x1e,0x04]

buffer_atomic_inc v1, off, s[12:15], s103 offset:4095
// CHECK: [0xff,0x0f,0xf0,0xe0,0x00,0x01,0x03,0x67]

buffer_atomic_inc v1, off, s[12:15], m0 offset:4095
// CHECK: [0xff,0x0f,0xf0,0xe0,0x00,0x01,0x03,0x7c]

buffer_atomic_inc v1, off, s[12:15], 0 offset:4095
// CHECK: [0xff,0x0f,0xf0,0xe0,0x00,0x01,0x03,0x80]

buffer_atomic_inc v1, off, s[12:15], -1 offset:4095
// CHECK: [0xff,0x0f,0xf0,0xe0,0x00,0x01,0x03,0xc1]

buffer_atomic_inc v1, v0, s[12:15], s4 idxen offset:4095
// CHECK: [0xff,0x2f,0xf0,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_inc v1, v0, s[12:15], s4 offen offset:4095
// CHECK: [0xff,0x1f,0xf0,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_inc v1, v[0:1], s[12:15], s4 addr64 offset:4095
// CHECK: [0xff,0x8f,0xf0,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_inc v1, off, s[12:15], s4
// CHECK: [0x00,0x00,0xf0,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_inc v1, off, s[12:15], s4 offset:0
// CHECK: [0x00,0x00,0xf0,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_inc v1, off, s[12:15], s4 offset:7
// CHECK: [0x07,0x00,0xf0,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_inc v1, off, s[12:15], s4 offset:4095 glc
// CHECK: [0xff,0x4f,0xf0,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_inc v1, off, s[12:15], s4 offset:4095 slc
// CHECK: [0xff,0x0f,0xf0,0xe0,0x00,0x01,0x43,0x04]

buffer_atomic_dec v1, off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0xf4,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_dec v255, off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0xf4,0xe0,0x00,0xff,0x03,0x04]

buffer_atomic_dec v1, off, s[16:19], s4 offset:4095
// CHECK: [0xff,0x0f,0xf4,0xe0,0x00,0x01,0x04,0x04]

buffer_atomic_dec v1, off, s[100:103], s4 offset:4095
// CHECK: [0xff,0x0f,0xf4,0xe0,0x00,0x01,0x19,0x04]

buffer_atomic_dec v1, off, ttmp[8:11], s4 offset:4095
// CHECK: [0xff,0x0f,0xf4,0xe0,0x00,0x01,0x1e,0x04]

buffer_atomic_dec v1, off, s[12:15], s103 offset:4095
// CHECK: [0xff,0x0f,0xf4,0xe0,0x00,0x01,0x03,0x67]

buffer_atomic_dec v1, off, s[12:15], m0 offset:4095
// CHECK: [0xff,0x0f,0xf4,0xe0,0x00,0x01,0x03,0x7c]

buffer_atomic_dec v1, off, s[12:15], 0 offset:4095
// CHECK: [0xff,0x0f,0xf4,0xe0,0x00,0x01,0x03,0x80]

buffer_atomic_dec v1, off, s[12:15], -1 offset:4095
// CHECK: [0xff,0x0f,0xf4,0xe0,0x00,0x01,0x03,0xc1]

buffer_atomic_dec v1, v0, s[12:15], s4 idxen offset:4095
// CHECK: [0xff,0x2f,0xf4,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_dec v1, v0, s[12:15], s4 offen offset:4095
// CHECK: [0xff,0x1f,0xf4,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_dec v1, v[0:1], s[12:15], s4 addr64 offset:4095
// CHECK: [0xff,0x8f,0xf4,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_dec v1, off, s[12:15], s4
// CHECK: [0x00,0x00,0xf4,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_dec v1, off, s[12:15], s4 offset:0
// CHECK: [0x00,0x00,0xf4,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_dec v1, off, s[12:15], s4 offset:7
// CHECK: [0x07,0x00,0xf4,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_dec v1, off, s[12:15], s4 offset:4095 glc
// CHECK: [0xff,0x4f,0xf4,0xe0,0x00,0x01,0x03,0x04]

buffer_atomic_dec v1, off, s[12:15], s4 offset:4095 slc
// CHECK: [0xff,0x0f,0xf4,0xe0,0x00,0x01,0x43,0x04]

buffer_atomic_swap_x2 v[1:2], off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x40,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_swap_x2 v[254:255], off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x40,0xe1,0x00,0xfe,0x03,0x04]

buffer_atomic_swap_x2 v[1:2], off, s[16:19], s4 offset:4095
// CHECK: [0xff,0x0f,0x40,0xe1,0x00,0x01,0x04,0x04]

buffer_atomic_swap_x2 v[1:2], off, s[100:103], s4 offset:4095
// CHECK: [0xff,0x0f,0x40,0xe1,0x00,0x01,0x19,0x04]

buffer_atomic_swap_x2 v[1:2], off, ttmp[8:11], s4 offset:4095
// CHECK: [0xff,0x0f,0x40,0xe1,0x00,0x01,0x1e,0x04]

buffer_atomic_swap_x2 v[1:2], off, s[12:15], s103 offset:4095
// CHECK: [0xff,0x0f,0x40,0xe1,0x00,0x01,0x03,0x67]

buffer_atomic_swap_x2 v[1:2], off, s[12:15], m0 offset:4095
// CHECK: [0xff,0x0f,0x40,0xe1,0x00,0x01,0x03,0x7c]

buffer_atomic_swap_x2 v[1:2], off, s[12:15], 0 offset:4095
// CHECK: [0xff,0x0f,0x40,0xe1,0x00,0x01,0x03,0x80]

buffer_atomic_swap_x2 v[1:2], off, s[12:15], -1 offset:4095
// CHECK: [0xff,0x0f,0x40,0xe1,0x00,0x01,0x03,0xc1]

buffer_atomic_swap_x2 v[1:2], v0, s[12:15], s4 idxen offset:4095
// CHECK: [0xff,0x2f,0x40,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_swap_x2 v[1:2], v0, s[12:15], s4 offen offset:4095
// CHECK: [0xff,0x1f,0x40,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_swap_x2 v[1:2], v[0:1], s[12:15], s4 addr64 offset:4095
// CHECK: [0xff,0x8f,0x40,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_swap_x2 v[1:2], off, s[12:15], s4
// CHECK: [0x00,0x00,0x40,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_swap_x2 v[1:2], off, s[12:15], s4 offset:0
// CHECK: [0x00,0x00,0x40,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_swap_x2 v[1:2], off, s[12:15], s4 offset:7
// CHECK: [0x07,0x00,0x40,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_swap_x2 v[1:2], off, s[12:15], s4 offset:4095 glc
// CHECK: [0xff,0x4f,0x40,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_swap_x2 v[1:2], off, s[12:15], s4 offset:4095 slc
// CHECK: [0xff,0x0f,0x40,0xe1,0x00,0x01,0x43,0x04]

buffer_atomic_cmpswap_x2 v[1:4], off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x44,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_cmpswap_x2 v[252:255], off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x44,0xe1,0x00,0xfc,0x03,0x04]

buffer_atomic_cmpswap_x2 v[1:4], off, s[16:19], s4 offset:4095
// CHECK: [0xff,0x0f,0x44,0xe1,0x00,0x01,0x04,0x04]

buffer_atomic_cmpswap_x2 v[1:4], off, s[100:103], s4 offset:4095
// CHECK: [0xff,0x0f,0x44,0xe1,0x00,0x01,0x19,0x04]

buffer_atomic_cmpswap_x2 v[1:4], off, ttmp[8:11], s4 offset:4095
// CHECK: [0xff,0x0f,0x44,0xe1,0x00,0x01,0x1e,0x04]

buffer_atomic_cmpswap_x2 v[1:4], off, s[12:15], s103 offset:4095
// CHECK: [0xff,0x0f,0x44,0xe1,0x00,0x01,0x03,0x67]

buffer_atomic_cmpswap_x2 v[1:4], off, s[12:15], m0 offset:4095
// CHECK: [0xff,0x0f,0x44,0xe1,0x00,0x01,0x03,0x7c]

buffer_atomic_cmpswap_x2 v[1:4], off, s[12:15], 0 offset:4095
// CHECK: [0xff,0x0f,0x44,0xe1,0x00,0x01,0x03,0x80]

buffer_atomic_cmpswap_x2 v[1:4], off, s[12:15], -1 offset:4095
// CHECK: [0xff,0x0f,0x44,0xe1,0x00,0x01,0x03,0xc1]

buffer_atomic_cmpswap_x2 v[1:4], v0, s[12:15], s4 idxen offset:4095
// CHECK: [0xff,0x2f,0x44,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_cmpswap_x2 v[1:4], v0, s[12:15], s4 offen offset:4095
// CHECK: [0xff,0x1f,0x44,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_cmpswap_x2 v[1:4], v[0:1], s[12:15], s4 addr64 offset:4095
// CHECK: [0xff,0x8f,0x44,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_cmpswap_x2 v[1:4], off, s[12:15], s4
// CHECK: [0x00,0x00,0x44,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_cmpswap_x2 v[1:4], off, s[12:15], s4 offset:0
// CHECK: [0x00,0x00,0x44,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_cmpswap_x2 v[1:4], off, s[12:15], s4 offset:7
// CHECK: [0x07,0x00,0x44,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_cmpswap_x2 v[1:4], off, s[12:15], s4 offset:4095 glc
// CHECK: [0xff,0x4f,0x44,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_cmpswap_x2 v[1:4], off, s[12:15], s4 offset:4095 slc
// CHECK: [0xff,0x0f,0x44,0xe1,0x00,0x01,0x43,0x04]

buffer_atomic_add_x2 v[1:2], off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x48,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_add_x2 v[254:255], off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x48,0xe1,0x00,0xfe,0x03,0x04]

buffer_atomic_add_x2 v[1:2], off, s[16:19], s4 offset:4095
// CHECK: [0xff,0x0f,0x48,0xe1,0x00,0x01,0x04,0x04]

buffer_atomic_add_x2 v[1:2], off, s[100:103], s4 offset:4095
// CHECK: [0xff,0x0f,0x48,0xe1,0x00,0x01,0x19,0x04]

buffer_atomic_add_x2 v[1:2], off, ttmp[8:11], s4 offset:4095
// CHECK: [0xff,0x0f,0x48,0xe1,0x00,0x01,0x1e,0x04]

buffer_atomic_add_x2 v[1:2], off, s[12:15], s103 offset:4095
// CHECK: [0xff,0x0f,0x48,0xe1,0x00,0x01,0x03,0x67]

buffer_atomic_add_x2 v[1:2], off, s[12:15], m0 offset:4095
// CHECK: [0xff,0x0f,0x48,0xe1,0x00,0x01,0x03,0x7c]

buffer_atomic_add_x2 v[1:2], off, s[12:15], 0 offset:4095
// CHECK: [0xff,0x0f,0x48,0xe1,0x00,0x01,0x03,0x80]

buffer_atomic_add_x2 v[1:2], off, s[12:15], -1 offset:4095
// CHECK: [0xff,0x0f,0x48,0xe1,0x00,0x01,0x03,0xc1]

buffer_atomic_add_x2 v[1:2], v0, s[12:15], s4 idxen offset:4095
// CHECK: [0xff,0x2f,0x48,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_add_x2 v[1:2], v0, s[12:15], s4 offen offset:4095
// CHECK: [0xff,0x1f,0x48,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_add_x2 v[1:2], v[0:1], s[12:15], s4 addr64 offset:4095
// CHECK: [0xff,0x8f,0x48,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_add_x2 v[1:2], off, s[12:15], s4
// CHECK: [0x00,0x00,0x48,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_add_x2 v[1:2], off, s[12:15], s4 offset:0
// CHECK: [0x00,0x00,0x48,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_add_x2 v[1:2], off, s[12:15], s4 offset:7
// CHECK: [0x07,0x00,0x48,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_add_x2 v[1:2], off, s[12:15], s4 offset:4095 glc
// CHECK: [0xff,0x4f,0x48,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_add_x2 v[1:2], off, s[12:15], s4 offset:4095 slc
// CHECK: [0xff,0x0f,0x48,0xe1,0x00,0x01,0x43,0x04]

buffer_atomic_sub_x2 v[1:2], off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x4c,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_sub_x2 v[254:255], off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x4c,0xe1,0x00,0xfe,0x03,0x04]

buffer_atomic_sub_x2 v[1:2], off, s[16:19], s4 offset:4095
// CHECK: [0xff,0x0f,0x4c,0xe1,0x00,0x01,0x04,0x04]

buffer_atomic_sub_x2 v[1:2], off, s[100:103], s4 offset:4095
// CHECK: [0xff,0x0f,0x4c,0xe1,0x00,0x01,0x19,0x04]

buffer_atomic_sub_x2 v[1:2], off, ttmp[8:11], s4 offset:4095
// CHECK: [0xff,0x0f,0x4c,0xe1,0x00,0x01,0x1e,0x04]

buffer_atomic_sub_x2 v[1:2], off, s[12:15], s103 offset:4095
// CHECK: [0xff,0x0f,0x4c,0xe1,0x00,0x01,0x03,0x67]

buffer_atomic_sub_x2 v[1:2], off, s[12:15], m0 offset:4095
// CHECK: [0xff,0x0f,0x4c,0xe1,0x00,0x01,0x03,0x7c]

buffer_atomic_sub_x2 v[1:2], off, s[12:15], 0 offset:4095
// CHECK: [0xff,0x0f,0x4c,0xe1,0x00,0x01,0x03,0x80]

buffer_atomic_sub_x2 v[1:2], off, s[12:15], -1 offset:4095
// CHECK: [0xff,0x0f,0x4c,0xe1,0x00,0x01,0x03,0xc1]

buffer_atomic_sub_x2 v[1:2], v0, s[12:15], s4 idxen offset:4095
// CHECK: [0xff,0x2f,0x4c,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_sub_x2 v[1:2], v0, s[12:15], s4 offen offset:4095
// CHECK: [0xff,0x1f,0x4c,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_sub_x2 v[1:2], v[0:1], s[12:15], s4 addr64 offset:4095
// CHECK: [0xff,0x8f,0x4c,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_sub_x2 v[1:2], off, s[12:15], s4
// CHECK: [0x00,0x00,0x4c,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_sub_x2 v[1:2], off, s[12:15], s4 offset:0
// CHECK: [0x00,0x00,0x4c,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_sub_x2 v[1:2], off, s[12:15], s4 offset:7
// CHECK: [0x07,0x00,0x4c,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_sub_x2 v[1:2], off, s[12:15], s4 offset:4095 glc
// CHECK: [0xff,0x4f,0x4c,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_sub_x2 v[1:2], off, s[12:15], s4 offset:4095 slc
// CHECK: [0xff,0x0f,0x4c,0xe1,0x00,0x01,0x43,0x04]

buffer_atomic_smin_x2 v[1:2], off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x54,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_smin_x2 v[254:255], off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x54,0xe1,0x00,0xfe,0x03,0x04]

buffer_atomic_smin_x2 v[1:2], off, s[16:19], s4 offset:4095
// CHECK: [0xff,0x0f,0x54,0xe1,0x00,0x01,0x04,0x04]

buffer_atomic_smin_x2 v[1:2], off, s[100:103], s4 offset:4095
// CHECK: [0xff,0x0f,0x54,0xe1,0x00,0x01,0x19,0x04]

buffer_atomic_smin_x2 v[1:2], off, ttmp[8:11], s4 offset:4095
// CHECK: [0xff,0x0f,0x54,0xe1,0x00,0x01,0x1e,0x04]

buffer_atomic_smin_x2 v[1:2], off, s[12:15], s103 offset:4095
// CHECK: [0xff,0x0f,0x54,0xe1,0x00,0x01,0x03,0x67]

buffer_atomic_smin_x2 v[1:2], off, s[12:15], m0 offset:4095
// CHECK: [0xff,0x0f,0x54,0xe1,0x00,0x01,0x03,0x7c]

buffer_atomic_smin_x2 v[1:2], off, s[12:15], 0 offset:4095
// CHECK: [0xff,0x0f,0x54,0xe1,0x00,0x01,0x03,0x80]

buffer_atomic_smin_x2 v[1:2], off, s[12:15], -1 offset:4095
// CHECK: [0xff,0x0f,0x54,0xe1,0x00,0x01,0x03,0xc1]

buffer_atomic_smin_x2 v[1:2], v0, s[12:15], s4 idxen offset:4095
// CHECK: [0xff,0x2f,0x54,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_smin_x2 v[1:2], v0, s[12:15], s4 offen offset:4095
// CHECK: [0xff,0x1f,0x54,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_smin_x2 v[1:2], v[0:1], s[12:15], s4 addr64 offset:4095
// CHECK: [0xff,0x8f,0x54,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_smin_x2 v[1:2], off, s[12:15], s4
// CHECK: [0x00,0x00,0x54,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_smin_x2 v[1:2], off, s[12:15], s4 offset:0
// CHECK: [0x00,0x00,0x54,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_smin_x2 v[1:2], off, s[12:15], s4 offset:7
// CHECK: [0x07,0x00,0x54,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_smin_x2 v[1:2], off, s[12:15], s4 offset:4095 glc
// CHECK: [0xff,0x4f,0x54,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_smin_x2 v[1:2], off, s[12:15], s4 offset:4095 slc
// CHECK: [0xff,0x0f,0x54,0xe1,0x00,0x01,0x43,0x04]

buffer_atomic_umin_x2 v[1:2], off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x58,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_umin_x2 v[254:255], off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x58,0xe1,0x00,0xfe,0x03,0x04]

buffer_atomic_umin_x2 v[1:2], off, s[16:19], s4 offset:4095
// CHECK: [0xff,0x0f,0x58,0xe1,0x00,0x01,0x04,0x04]

buffer_atomic_umin_x2 v[1:2], off, s[100:103], s4 offset:4095
// CHECK: [0xff,0x0f,0x58,0xe1,0x00,0x01,0x19,0x04]

buffer_atomic_umin_x2 v[1:2], off, ttmp[8:11], s4 offset:4095
// CHECK: [0xff,0x0f,0x58,0xe1,0x00,0x01,0x1e,0x04]

buffer_atomic_umin_x2 v[1:2], off, s[12:15], s103 offset:4095
// CHECK: [0xff,0x0f,0x58,0xe1,0x00,0x01,0x03,0x67]

buffer_atomic_umin_x2 v[1:2], off, s[12:15], m0 offset:4095
// CHECK: [0xff,0x0f,0x58,0xe1,0x00,0x01,0x03,0x7c]

buffer_atomic_umin_x2 v[1:2], off, s[12:15], 0 offset:4095
// CHECK: [0xff,0x0f,0x58,0xe1,0x00,0x01,0x03,0x80]

buffer_atomic_umin_x2 v[1:2], off, s[12:15], -1 offset:4095
// CHECK: [0xff,0x0f,0x58,0xe1,0x00,0x01,0x03,0xc1]

buffer_atomic_umin_x2 v[1:2], v0, s[12:15], s4 idxen offset:4095
// CHECK: [0xff,0x2f,0x58,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_umin_x2 v[1:2], v0, s[12:15], s4 offen offset:4095
// CHECK: [0xff,0x1f,0x58,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_umin_x2 v[1:2], v[0:1], s[12:15], s4 addr64 offset:4095
// CHECK: [0xff,0x8f,0x58,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_umin_x2 v[1:2], off, s[12:15], s4
// CHECK: [0x00,0x00,0x58,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_umin_x2 v[1:2], off, s[12:15], s4 offset:0
// CHECK: [0x00,0x00,0x58,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_umin_x2 v[1:2], off, s[12:15], s4 offset:7
// CHECK: [0x07,0x00,0x58,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_umin_x2 v[1:2], off, s[12:15], s4 offset:4095 glc
// CHECK: [0xff,0x4f,0x58,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_umin_x2 v[1:2], off, s[12:15], s4 offset:4095 slc
// CHECK: [0xff,0x0f,0x58,0xe1,0x00,0x01,0x43,0x04]

buffer_atomic_smax_x2 v[1:2], off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x5c,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_smax_x2 v[254:255], off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x5c,0xe1,0x00,0xfe,0x03,0x04]

buffer_atomic_smax_x2 v[1:2], off, s[16:19], s4 offset:4095
// CHECK: [0xff,0x0f,0x5c,0xe1,0x00,0x01,0x04,0x04]

buffer_atomic_smax_x2 v[1:2], off, s[100:103], s4 offset:4095
// CHECK: [0xff,0x0f,0x5c,0xe1,0x00,0x01,0x19,0x04]

buffer_atomic_smax_x2 v[1:2], off, ttmp[8:11], s4 offset:4095
// CHECK: [0xff,0x0f,0x5c,0xe1,0x00,0x01,0x1e,0x04]

buffer_atomic_smax_x2 v[1:2], off, s[12:15], s103 offset:4095
// CHECK: [0xff,0x0f,0x5c,0xe1,0x00,0x01,0x03,0x67]

buffer_atomic_smax_x2 v[1:2], off, s[12:15], m0 offset:4095
// CHECK: [0xff,0x0f,0x5c,0xe1,0x00,0x01,0x03,0x7c]

buffer_atomic_smax_x2 v[1:2], off, s[12:15], 0 offset:4095
// CHECK: [0xff,0x0f,0x5c,0xe1,0x00,0x01,0x03,0x80]

buffer_atomic_smax_x2 v[1:2], off, s[12:15], -1 offset:4095
// CHECK: [0xff,0x0f,0x5c,0xe1,0x00,0x01,0x03,0xc1]

buffer_atomic_smax_x2 v[1:2], v0, s[12:15], s4 idxen offset:4095
// CHECK: [0xff,0x2f,0x5c,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_smax_x2 v[1:2], v0, s[12:15], s4 offen offset:4095
// CHECK: [0xff,0x1f,0x5c,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_smax_x2 v[1:2], v[0:1], s[12:15], s4 addr64 offset:4095
// CHECK: [0xff,0x8f,0x5c,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_smax_x2 v[1:2], off, s[12:15], s4
// CHECK: [0x00,0x00,0x5c,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_smax_x2 v[1:2], off, s[12:15], s4 offset:0
// CHECK: [0x00,0x00,0x5c,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_smax_x2 v[1:2], off, s[12:15], s4 offset:7
// CHECK: [0x07,0x00,0x5c,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_smax_x2 v[1:2], off, s[12:15], s4 offset:4095 glc
// CHECK: [0xff,0x4f,0x5c,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_smax_x2 v[1:2], off, s[12:15], s4 offset:4095 slc
// CHECK: [0xff,0x0f,0x5c,0xe1,0x00,0x01,0x43,0x04]

buffer_atomic_umax_x2 v[1:2], off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x60,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_umax_x2 v[254:255], off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x60,0xe1,0x00,0xfe,0x03,0x04]

buffer_atomic_umax_x2 v[1:2], off, s[16:19], s4 offset:4095
// CHECK: [0xff,0x0f,0x60,0xe1,0x00,0x01,0x04,0x04]

buffer_atomic_umax_x2 v[1:2], off, s[100:103], s4 offset:4095
// CHECK: [0xff,0x0f,0x60,0xe1,0x00,0x01,0x19,0x04]

buffer_atomic_umax_x2 v[1:2], off, ttmp[8:11], s4 offset:4095
// CHECK: [0xff,0x0f,0x60,0xe1,0x00,0x01,0x1e,0x04]

buffer_atomic_umax_x2 v[1:2], off, s[12:15], s103 offset:4095
// CHECK: [0xff,0x0f,0x60,0xe1,0x00,0x01,0x03,0x67]

buffer_atomic_umax_x2 v[1:2], off, s[12:15], m0 offset:4095
// CHECK: [0xff,0x0f,0x60,0xe1,0x00,0x01,0x03,0x7c]

buffer_atomic_umax_x2 v[1:2], off, s[12:15], 0 offset:4095
// CHECK: [0xff,0x0f,0x60,0xe1,0x00,0x01,0x03,0x80]

buffer_atomic_umax_x2 v[1:2], off, s[12:15], -1 offset:4095
// CHECK: [0xff,0x0f,0x60,0xe1,0x00,0x01,0x03,0xc1]

buffer_atomic_umax_x2 v[1:2], v0, s[12:15], s4 idxen offset:4095
// CHECK: [0xff,0x2f,0x60,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_umax_x2 v[1:2], v0, s[12:15], s4 offen offset:4095
// CHECK: [0xff,0x1f,0x60,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_umax_x2 v[1:2], v[0:1], s[12:15], s4 addr64 offset:4095
// CHECK: [0xff,0x8f,0x60,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_umax_x2 v[1:2], off, s[12:15], s4
// CHECK: [0x00,0x00,0x60,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_umax_x2 v[1:2], off, s[12:15], s4 offset:0
// CHECK: [0x00,0x00,0x60,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_umax_x2 v[1:2], off, s[12:15], s4 offset:7
// CHECK: [0x07,0x00,0x60,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_umax_x2 v[1:2], off, s[12:15], s4 offset:4095 glc
// CHECK: [0xff,0x4f,0x60,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_umax_x2 v[1:2], off, s[12:15], s4 offset:4095 slc
// CHECK: [0xff,0x0f,0x60,0xe1,0x00,0x01,0x43,0x04]

buffer_atomic_and_x2 v[1:2], off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x64,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_and_x2 v[254:255], off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x64,0xe1,0x00,0xfe,0x03,0x04]

buffer_atomic_and_x2 v[1:2], off, s[16:19], s4 offset:4095
// CHECK: [0xff,0x0f,0x64,0xe1,0x00,0x01,0x04,0x04]

buffer_atomic_and_x2 v[1:2], off, s[100:103], s4 offset:4095
// CHECK: [0xff,0x0f,0x64,0xe1,0x00,0x01,0x19,0x04]

buffer_atomic_and_x2 v[1:2], off, ttmp[8:11], s4 offset:4095
// CHECK: [0xff,0x0f,0x64,0xe1,0x00,0x01,0x1e,0x04]

buffer_atomic_and_x2 v[1:2], off, s[12:15], s103 offset:4095
// CHECK: [0xff,0x0f,0x64,0xe1,0x00,0x01,0x03,0x67]

buffer_atomic_and_x2 v[1:2], off, s[12:15], m0 offset:4095
// CHECK: [0xff,0x0f,0x64,0xe1,0x00,0x01,0x03,0x7c]

buffer_atomic_and_x2 v[1:2], off, s[12:15], 0 offset:4095
// CHECK: [0xff,0x0f,0x64,0xe1,0x00,0x01,0x03,0x80]

buffer_atomic_and_x2 v[1:2], off, s[12:15], -1 offset:4095
// CHECK: [0xff,0x0f,0x64,0xe1,0x00,0x01,0x03,0xc1]

buffer_atomic_and_x2 v[1:2], v0, s[12:15], s4 idxen offset:4095
// CHECK: [0xff,0x2f,0x64,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_and_x2 v[1:2], v0, s[12:15], s4 offen offset:4095
// CHECK: [0xff,0x1f,0x64,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_and_x2 v[1:2], v[0:1], s[12:15], s4 addr64 offset:4095
// CHECK: [0xff,0x8f,0x64,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_and_x2 v[1:2], off, s[12:15], s4
// CHECK: [0x00,0x00,0x64,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_and_x2 v[1:2], off, s[12:15], s4 offset:0
// CHECK: [0x00,0x00,0x64,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_and_x2 v[1:2], off, s[12:15], s4 offset:7
// CHECK: [0x07,0x00,0x64,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_and_x2 v[1:2], off, s[12:15], s4 offset:4095 glc
// CHECK: [0xff,0x4f,0x64,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_and_x2 v[1:2], off, s[12:15], s4 offset:4095 slc
// CHECK: [0xff,0x0f,0x64,0xe1,0x00,0x01,0x43,0x04]

buffer_atomic_or_x2 v[1:2], off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x68,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_or_x2 v[254:255], off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x68,0xe1,0x00,0xfe,0x03,0x04]

buffer_atomic_or_x2 v[1:2], off, s[16:19], s4 offset:4095
// CHECK: [0xff,0x0f,0x68,0xe1,0x00,0x01,0x04,0x04]

buffer_atomic_or_x2 v[1:2], off, s[100:103], s4 offset:4095
// CHECK: [0xff,0x0f,0x68,0xe1,0x00,0x01,0x19,0x04]

buffer_atomic_or_x2 v[1:2], off, ttmp[8:11], s4 offset:4095
// CHECK: [0xff,0x0f,0x68,0xe1,0x00,0x01,0x1e,0x04]

buffer_atomic_or_x2 v[1:2], off, s[12:15], s103 offset:4095
// CHECK: [0xff,0x0f,0x68,0xe1,0x00,0x01,0x03,0x67]

buffer_atomic_or_x2 v[1:2], off, s[12:15], m0 offset:4095
// CHECK: [0xff,0x0f,0x68,0xe1,0x00,0x01,0x03,0x7c]

buffer_atomic_or_x2 v[1:2], off, s[12:15], 0 offset:4095
// CHECK: [0xff,0x0f,0x68,0xe1,0x00,0x01,0x03,0x80]

buffer_atomic_or_x2 v[1:2], off, s[12:15], -1 offset:4095
// CHECK: [0xff,0x0f,0x68,0xe1,0x00,0x01,0x03,0xc1]

buffer_atomic_or_x2 v[1:2], v0, s[12:15], s4 idxen offset:4095
// CHECK: [0xff,0x2f,0x68,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_or_x2 v[1:2], v0, s[12:15], s4 offen offset:4095
// CHECK: [0xff,0x1f,0x68,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_or_x2 v[1:2], v[0:1], s[12:15], s4 addr64 offset:4095
// CHECK: [0xff,0x8f,0x68,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_or_x2 v[1:2], off, s[12:15], s4
// CHECK: [0x00,0x00,0x68,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_or_x2 v[1:2], off, s[12:15], s4 offset:0
// CHECK: [0x00,0x00,0x68,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_or_x2 v[1:2], off, s[12:15], s4 offset:7
// CHECK: [0x07,0x00,0x68,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_or_x2 v[1:2], off, s[12:15], s4 offset:4095 glc
// CHECK: [0xff,0x4f,0x68,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_or_x2 v[1:2], off, s[12:15], s4 offset:4095 slc
// CHECK: [0xff,0x0f,0x68,0xe1,0x00,0x01,0x43,0x04]

buffer_atomic_xor_x2 v[1:2], off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x6c,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_xor_x2 v[254:255], off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x6c,0xe1,0x00,0xfe,0x03,0x04]

buffer_atomic_xor_x2 v[1:2], off, s[16:19], s4 offset:4095
// CHECK: [0xff,0x0f,0x6c,0xe1,0x00,0x01,0x04,0x04]

buffer_atomic_xor_x2 v[1:2], off, s[100:103], s4 offset:4095
// CHECK: [0xff,0x0f,0x6c,0xe1,0x00,0x01,0x19,0x04]

buffer_atomic_xor_x2 v[1:2], off, ttmp[8:11], s4 offset:4095
// CHECK: [0xff,0x0f,0x6c,0xe1,0x00,0x01,0x1e,0x04]

buffer_atomic_xor_x2 v[1:2], off, s[12:15], s103 offset:4095
// CHECK: [0xff,0x0f,0x6c,0xe1,0x00,0x01,0x03,0x67]

buffer_atomic_xor_x2 v[1:2], off, s[12:15], m0 offset:4095
// CHECK: [0xff,0x0f,0x6c,0xe1,0x00,0x01,0x03,0x7c]

buffer_atomic_xor_x2 v[1:2], off, s[12:15], 0 offset:4095
// CHECK: [0xff,0x0f,0x6c,0xe1,0x00,0x01,0x03,0x80]

buffer_atomic_xor_x2 v[1:2], off, s[12:15], -1 offset:4095
// CHECK: [0xff,0x0f,0x6c,0xe1,0x00,0x01,0x03,0xc1]

buffer_atomic_xor_x2 v[1:2], v0, s[12:15], s4 idxen offset:4095
// CHECK: [0xff,0x2f,0x6c,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_xor_x2 v[1:2], v0, s[12:15], s4 offen offset:4095
// CHECK: [0xff,0x1f,0x6c,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_xor_x2 v[1:2], v[0:1], s[12:15], s4 addr64 offset:4095
// CHECK: [0xff,0x8f,0x6c,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_xor_x2 v[1:2], off, s[12:15], s4
// CHECK: [0x00,0x00,0x6c,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_xor_x2 v[1:2], off, s[12:15], s4 offset:0
// CHECK: [0x00,0x00,0x6c,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_xor_x2 v[1:2], off, s[12:15], s4 offset:7
// CHECK: [0x07,0x00,0x6c,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_xor_x2 v[1:2], off, s[12:15], s4 offset:4095 glc
// CHECK: [0xff,0x4f,0x6c,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_xor_x2 v[1:2], off, s[12:15], s4 offset:4095 slc
// CHECK: [0xff,0x0f,0x6c,0xe1,0x00,0x01,0x43,0x04]

buffer_atomic_inc_x2 v[1:2], off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x70,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_inc_x2 v[254:255], off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x70,0xe1,0x00,0xfe,0x03,0x04]

buffer_atomic_inc_x2 v[1:2], off, s[16:19], s4 offset:4095
// CHECK: [0xff,0x0f,0x70,0xe1,0x00,0x01,0x04,0x04]

buffer_atomic_inc_x2 v[1:2], off, s[100:103], s4 offset:4095
// CHECK: [0xff,0x0f,0x70,0xe1,0x00,0x01,0x19,0x04]

buffer_atomic_inc_x2 v[1:2], off, ttmp[8:11], s4 offset:4095
// CHECK: [0xff,0x0f,0x70,0xe1,0x00,0x01,0x1e,0x04]

buffer_atomic_inc_x2 v[1:2], off, s[12:15], s103 offset:4095
// CHECK: [0xff,0x0f,0x70,0xe1,0x00,0x01,0x03,0x67]

buffer_atomic_inc_x2 v[1:2], off, s[12:15], m0 offset:4095
// CHECK: [0xff,0x0f,0x70,0xe1,0x00,0x01,0x03,0x7c]

buffer_atomic_inc_x2 v[1:2], off, s[12:15], 0 offset:4095
// CHECK: [0xff,0x0f,0x70,0xe1,0x00,0x01,0x03,0x80]

buffer_atomic_inc_x2 v[1:2], off, s[12:15], -1 offset:4095
// CHECK: [0xff,0x0f,0x70,0xe1,0x00,0x01,0x03,0xc1]

buffer_atomic_inc_x2 v[1:2], v0, s[12:15], s4 idxen offset:4095
// CHECK: [0xff,0x2f,0x70,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_inc_x2 v[1:2], v0, s[12:15], s4 offen offset:4095
// CHECK: [0xff,0x1f,0x70,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_inc_x2 v[1:2], v[0:1], s[12:15], s4 addr64 offset:4095
// CHECK: [0xff,0x8f,0x70,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_inc_x2 v[1:2], off, s[12:15], s4
// CHECK: [0x00,0x00,0x70,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_inc_x2 v[1:2], off, s[12:15], s4 offset:0
// CHECK: [0x00,0x00,0x70,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_inc_x2 v[1:2], off, s[12:15], s4 offset:7
// CHECK: [0x07,0x00,0x70,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_inc_x2 v[1:2], off, s[12:15], s4 offset:4095 glc
// CHECK: [0xff,0x4f,0x70,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_inc_x2 v[1:2], off, s[12:15], s4 offset:4095 slc
// CHECK: [0xff,0x0f,0x70,0xe1,0x00,0x01,0x43,0x04]

buffer_atomic_dec_x2 v[1:2], off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x74,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_dec_x2 v[254:255], off, s[12:15], s4 offset:4095
// CHECK: [0xff,0x0f,0x74,0xe1,0x00,0xfe,0x03,0x04]

buffer_atomic_dec_x2 v[1:2], off, s[16:19], s4 offset:4095
// CHECK: [0xff,0x0f,0x74,0xe1,0x00,0x01,0x04,0x04]

buffer_atomic_dec_x2 v[1:2], off, s[100:103], s4 offset:4095
// CHECK: [0xff,0x0f,0x74,0xe1,0x00,0x01,0x19,0x04]

buffer_atomic_dec_x2 v[1:2], off, ttmp[8:11], s4 offset:4095
// CHECK: [0xff,0x0f,0x74,0xe1,0x00,0x01,0x1e,0x04]

buffer_atomic_dec_x2 v[1:2], off, s[12:15], s103 offset:4095
// CHECK: [0xff,0x0f,0x74,0xe1,0x00,0x01,0x03,0x67]

buffer_atomic_dec_x2 v[1:2], off, s[12:15], m0 offset:4095
// CHECK: [0xff,0x0f,0x74,0xe1,0x00,0x01,0x03,0x7c]

buffer_atomic_dec_x2 v[1:2], off, s[12:15], 0 offset:4095
// CHECK: [0xff,0x0f,0x74,0xe1,0x00,0x01,0x03,0x80]

buffer_atomic_dec_x2 v[1:2], off, s[12:15], -1 offset:4095
// CHECK: [0xff,0x0f,0x74,0xe1,0x00,0x01,0x03,0xc1]

buffer_atomic_dec_x2 v[1:2], v0, s[12:15], s4 idxen offset:4095
// CHECK: [0xff,0x2f,0x74,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_dec_x2 v[1:2], v0, s[12:15], s4 offen offset:4095
// CHECK: [0xff,0x1f,0x74,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_dec_x2 v[1:2], v[0:1], s[12:15], s4 addr64 offset:4095
// CHECK: [0xff,0x8f,0x74,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_dec_x2 v[1:2], off, s[12:15], s4
// CHECK: [0x00,0x00,0x74,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_dec_x2 v[1:2], off, s[12:15], s4 offset:0
// CHECK: [0x00,0x00,0x74,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_dec_x2 v[1:2], off, s[12:15], s4 offset:7
// CHECK: [0x07,0x00,0x74,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_dec_x2 v[1:2], off, s[12:15], s4 offset:4095 glc
// CHECK: [0xff,0x4f,0x74,0xe1,0x00,0x01,0x03,0x04]

buffer_atomic_dec_x2 v[1:2], off, s[12:15], s4 offset:4095 slc
// CHECK: [0xff,0x0f,0x74,0xe1,0x00,0x01,0x43,0x04]

buffer_wbinvl1_vol
// CHECK: [0x00,0x00,0xc0,0xe1,0x00,0x00,0x00,0x00]

buffer_wbinvl1
// CHECK: [0x00,0x00,0xc4,0xe1,0x00,0x00,0x00,0x00]

s_load_dword s5, s[2:3], s2
// CHECK: [0x02,0x82,0x02,0xc0]

s_load_dword s103, s[2:3], s2
// CHECK: [0x02,0x82,0x33,0xc0]

s_load_dword vcc_lo, s[2:3], s2
// CHECK: [0x02,0x02,0x35,0xc0]

s_load_dword vcc_hi, s[2:3], s2
// CHECK: [0x02,0x82,0x35,0xc0]

s_load_dword s5, s[4:5], s2
// CHECK: [0x02,0x84,0x02,0xc0]

s_load_dword s5, s[102:103], s2
// CHECK: [0x02,0xe6,0x02,0xc0]

s_load_dword s5, flat_scratch, s2
// CHECK: [0x02,0xe8,0x02,0xc0]

s_load_dword s5, vcc, s2
// CHECK: [0x02,0xea,0x02,0xc0]

s_load_dword s5, tba, s2
// CHECK: [0x02,0xec,0x02,0xc0]

s_load_dword s5, tma, s2
// CHECK: [0x02,0xee,0x02,0xc0]

s_load_dword s5, ttmp[10:11], s2
// CHECK: [0x02,0xfa,0x02,0xc0]

s_load_dword s5, s[2:3], s103
// CHECK: [0x67,0x82,0x02,0xc0]

s_load_dword s5, s[2:3], flat_scratch_lo
// CHECK: [0x68,0x82,0x02,0xc0]

s_load_dword s5, s[2:3], flat_scratch_hi
// CHECK: [0x69,0x82,0x02,0xc0]

s_load_dword s5, s[2:3], vcc_lo
// CHECK: [0x6a,0x82,0x02,0xc0]

s_load_dword s5, s[2:3], vcc_hi
// CHECK: [0x6b,0x82,0x02,0xc0]

s_load_dword s5, s[2:3], tba_lo
// CHECK: [0x6c,0x82,0x02,0xc0]

s_load_dword s5, s[2:3], tba_hi
// CHECK: [0x6d,0x82,0x02,0xc0]

s_load_dword s5, s[2:3], tma_lo
// CHECK: [0x6e,0x82,0x02,0xc0]

s_load_dword s5, s[2:3], tma_hi
// CHECK: [0x6f,0x82,0x02,0xc0]

s_load_dword s5, s[2:3], ttmp11
// CHECK: [0x7b,0x82,0x02,0xc0]

s_load_dword s5, s[2:3], 0xaf123456
// CHECK: [0xff,0x82,0x02,0xc0,0x56,0x34,0x12,0xaf]

s_load_dword s5, s[2:3], 0x3f717273
// CHECK: [0xff,0x82,0x02,0xc0,0x73,0x72,0x71,0x3f]

s_load_dword s5, s[2:3], 0x7f
// CHECK: [0x7f,0x83,0x02,0xc0]

s_load_dwordx2 s[10:11], s[2:3], s2
// CHECK: [0x02,0x02,0x45,0xc0]

s_load_dwordx2 s[12:13], s[2:3], s2
// CHECK: [0x02,0x02,0x46,0xc0]

s_load_dwordx2 s[102:103], s[2:3], s2
// CHECK: [0x02,0x02,0x73,0xc0]

s_load_dwordx2 vcc, s[2:3], s2
// CHECK: [0x02,0x02,0x75,0xc0]

s_load_dwordx2 s[10:11], s[4:5], s2
// CHECK: [0x02,0x04,0x45,0xc0]

s_load_dwordx2 s[10:11], s[102:103], s2
// CHECK: [0x02,0x66,0x45,0xc0]

s_load_dwordx2 s[10:11], flat_scratch, s2
// CHECK: [0x02,0x68,0x45,0xc0]

s_load_dwordx2 s[10:11], vcc, s2
// CHECK: [0x02,0x6a,0x45,0xc0]

s_load_dwordx2 s[10:11], tba, s2
// CHECK: [0x02,0x6c,0x45,0xc0]

s_load_dwordx2 s[10:11], tma, s2
// CHECK: [0x02,0x6e,0x45,0xc0]

s_load_dwordx2 s[10:11], ttmp[10:11], s2
// CHECK: [0x02,0x7a,0x45,0xc0]

s_load_dwordx2 s[10:11], s[2:3], s103
// CHECK: [0x67,0x02,0x45,0xc0]

s_load_dwordx2 s[10:11], s[2:3], flat_scratch_lo
// CHECK: [0x68,0x02,0x45,0xc0]

s_load_dwordx2 s[10:11], s[2:3], flat_scratch_hi
// CHECK: [0x69,0x02,0x45,0xc0]

s_load_dwordx2 s[10:11], s[2:3], vcc_lo
// CHECK: [0x6a,0x02,0x45,0xc0]

s_load_dwordx2 s[10:11], s[2:3], vcc_hi
// CHECK: [0x6b,0x02,0x45,0xc0]

s_load_dwordx2 s[10:11], s[2:3], tba_lo
// CHECK: [0x6c,0x02,0x45,0xc0]

s_load_dwordx2 s[10:11], s[2:3], tba_hi
// CHECK: [0x6d,0x02,0x45,0xc0]

s_load_dwordx2 s[10:11], s[2:3], tma_lo
// CHECK: [0x6e,0x02,0x45,0xc0]

s_load_dwordx2 s[10:11], s[2:3], tma_hi
// CHECK: [0x6f,0x02,0x45,0xc0]

s_load_dwordx2 s[10:11], s[2:3], ttmp11
// CHECK: [0x7b,0x02,0x45,0xc0]

s_load_dwordx2 s[10:11], s[2:3], 0xaf123456
// CHECK: [0xff,0x02,0x45,0xc0,0x56,0x34,0x12,0xaf]

s_load_dwordx2 s[10:11], s[2:3], 0x3f717273
// CHECK: [0xff,0x02,0x45,0xc0,0x73,0x72,0x71,0x3f]

s_load_dwordx2 s[10:11], s[2:3], 0x7f
// CHECK: [0x7f,0x03,0x45,0xc0]

s_load_dwordx4 s[20:23], s[2:3], s2
// CHECK: [0x02,0x02,0x8a,0xc0]

s_load_dwordx4 s[24:27], s[2:3], s2
// CHECK: [0x02,0x02,0x8c,0xc0]

s_load_dwordx4 s[100:103], s[2:3], s2
// CHECK: [0x02,0x02,0xb2,0xc0]

s_load_dwordx4 s[20:23], s[4:5], s2
// CHECK: [0x02,0x04,0x8a,0xc0]

s_load_dwordx4 s[20:23], s[102:103], s2
// CHECK: [0x02,0x66,0x8a,0xc0]

s_load_dwordx4 s[20:23], flat_scratch, s2
// CHECK: [0x02,0x68,0x8a,0xc0]

s_load_dwordx4 s[20:23], vcc, s2
// CHECK: [0x02,0x6a,0x8a,0xc0]

s_load_dwordx4 s[20:23], tba, s2
// CHECK: [0x02,0x6c,0x8a,0xc0]

s_load_dwordx4 s[20:23], tma, s2
// CHECK: [0x02,0x6e,0x8a,0xc0]

s_load_dwordx4 s[20:23], ttmp[10:11], s2
// CHECK: [0x02,0x7a,0x8a,0xc0]

s_load_dwordx4 s[20:23], s[2:3], s103
// CHECK: [0x67,0x02,0x8a,0xc0]

s_load_dwordx4 s[20:23], s[2:3], flat_scratch_lo
// CHECK: [0x68,0x02,0x8a,0xc0]

s_load_dwordx4 s[20:23], s[2:3], flat_scratch_hi
// CHECK: [0x69,0x02,0x8a,0xc0]

s_load_dwordx4 s[20:23], s[2:3], vcc_lo
// CHECK: [0x6a,0x02,0x8a,0xc0]

s_load_dwordx4 s[20:23], s[2:3], vcc_hi
// CHECK: [0x6b,0x02,0x8a,0xc0]

s_load_dwordx4 s[20:23], s[2:3], tba_lo
// CHECK: [0x6c,0x02,0x8a,0xc0]

s_load_dwordx4 s[20:23], s[2:3], tba_hi
// CHECK: [0x6d,0x02,0x8a,0xc0]

s_load_dwordx4 s[20:23], s[2:3], tma_lo
// CHECK: [0x6e,0x02,0x8a,0xc0]

s_load_dwordx4 s[20:23], s[2:3], tma_hi
// CHECK: [0x6f,0x02,0x8a,0xc0]

s_load_dwordx4 s[20:23], s[2:3], ttmp11
// CHECK: [0x7b,0x02,0x8a,0xc0]

s_load_dwordx4 s[20:23], s[2:3], 0xaf123456
// CHECK: [0xff,0x02,0x8a,0xc0,0x56,0x34,0x12,0xaf]

s_load_dwordx4 s[20:23], s[2:3], 0x3f717273
// CHECK: [0xff,0x02,0x8a,0xc0,0x73,0x72,0x71,0x3f]

s_load_dwordx4 s[20:23], s[2:3], 0x7f
// CHECK: [0x7f,0x03,0x8a,0xc0]

s_load_dwordx8 s[20:27], s[2:3], s2
// CHECK: [0x02,0x02,0xca,0xc0]

s_load_dwordx8 s[24:31], s[2:3], s2
// CHECK: [0x02,0x02,0xcc,0xc0]

s_load_dwordx8 s[96:103], s[2:3], s2
// CHECK: [0x02,0x02,0xf0,0xc0]

s_load_dwordx8 s[20:27], s[4:5], s2
// CHECK: [0x02,0x04,0xca,0xc0]

s_load_dwordx8 s[20:27], s[102:103], s2
// CHECK: [0x02,0x66,0xca,0xc0]

s_load_dwordx8 s[20:27], flat_scratch, s2
// CHECK: [0x02,0x68,0xca,0xc0]

s_load_dwordx8 s[20:27], vcc, s2
// CHECK: [0x02,0x6a,0xca,0xc0]

s_load_dwordx8 s[20:27], tba, s2
// CHECK: [0x02,0x6c,0xca,0xc0]

s_load_dwordx8 s[20:27], tma, s2
// CHECK: [0x02,0x6e,0xca,0xc0]

s_load_dwordx8 s[20:27], ttmp[10:11], s2
// CHECK: [0x02,0x7a,0xca,0xc0]

s_load_dwordx8 s[20:27], s[2:3], s103
// CHECK: [0x67,0x02,0xca,0xc0]

s_load_dwordx8 s[20:27], s[2:3], flat_scratch_lo
// CHECK: [0x68,0x02,0xca,0xc0]

s_load_dwordx8 s[20:27], s[2:3], flat_scratch_hi
// CHECK: [0x69,0x02,0xca,0xc0]

s_load_dwordx8 s[20:27], s[2:3], vcc_lo
// CHECK: [0x6a,0x02,0xca,0xc0]

s_load_dwordx8 s[20:27], s[2:3], vcc_hi
// CHECK: [0x6b,0x02,0xca,0xc0]

s_load_dwordx8 s[20:27], s[2:3], tba_lo
// CHECK: [0x6c,0x02,0xca,0xc0]

s_load_dwordx8 s[20:27], s[2:3], tba_hi
// CHECK: [0x6d,0x02,0xca,0xc0]

s_load_dwordx8 s[20:27], s[2:3], tma_lo
// CHECK: [0x6e,0x02,0xca,0xc0]

s_load_dwordx8 s[20:27], s[2:3], tma_hi
// CHECK: [0x6f,0x02,0xca,0xc0]

s_load_dwordx8 s[20:27], s[2:3], ttmp11
// CHECK: [0x7b,0x02,0xca,0xc0]

s_load_dwordx8 s[20:27], s[2:3], 0xaf123456
// CHECK: [0xff,0x02,0xca,0xc0,0x56,0x34,0x12,0xaf]

s_load_dwordx8 s[20:27], s[2:3], 0x3f717273
// CHECK: [0xff,0x02,0xca,0xc0,0x73,0x72,0x71,0x3f]

s_load_dwordx8 s[20:27], s[2:3], 0x7f
// CHECK: [0x7f,0x03,0xca,0xc0]

s_load_dwordx16 s[20:35], s[2:3], s2
// CHECK: [0x02,0x02,0x0a,0xc1]

s_load_dwordx16 s[24:39], s[2:3], s2
// CHECK: [0x02,0x02,0x0c,0xc1]

s_load_dwordx16 s[88:103], s[2:3], s2
// CHECK: [0x02,0x02,0x2c,0xc1]

s_load_dwordx16 s[20:35], s[4:5], s2
// CHECK: [0x02,0x04,0x0a,0xc1]

s_load_dwordx16 s[20:35], s[102:103], s2
// CHECK: [0x02,0x66,0x0a,0xc1]

s_load_dwordx16 s[20:35], flat_scratch, s2
// CHECK: [0x02,0x68,0x0a,0xc1]

s_load_dwordx16 s[20:35], vcc, s2
// CHECK: [0x02,0x6a,0x0a,0xc1]

s_load_dwordx16 s[20:35], tba, s2
// CHECK: [0x02,0x6c,0x0a,0xc1]

s_load_dwordx16 s[20:35], tma, s2
// CHECK: [0x02,0x6e,0x0a,0xc1]

s_load_dwordx16 s[20:35], ttmp[10:11], s2
// CHECK: [0x02,0x7a,0x0a,0xc1]

s_load_dwordx16 s[20:35], s[2:3], s103
// CHECK: [0x67,0x02,0x0a,0xc1]

s_load_dwordx16 s[20:35], s[2:3], flat_scratch_lo
// CHECK: [0x68,0x02,0x0a,0xc1]

s_load_dwordx16 s[20:35], s[2:3], flat_scratch_hi
// CHECK: [0x69,0x02,0x0a,0xc1]

s_load_dwordx16 s[20:35], s[2:3], vcc_lo
// CHECK: [0x6a,0x02,0x0a,0xc1]

s_load_dwordx16 s[20:35], s[2:3], vcc_hi
// CHECK: [0x6b,0x02,0x0a,0xc1]

s_load_dwordx16 s[20:35], s[2:3], tba_lo
// CHECK: [0x6c,0x02,0x0a,0xc1]

s_load_dwordx16 s[20:35], s[2:3], tba_hi
// CHECK: [0x6d,0x02,0x0a,0xc1]

s_load_dwordx16 s[20:35], s[2:3], tma_lo
// CHECK: [0x6e,0x02,0x0a,0xc1]

s_load_dwordx16 s[20:35], s[2:3], tma_hi
// CHECK: [0x6f,0x02,0x0a,0xc1]

s_load_dwordx16 s[20:35], s[2:3], ttmp11
// CHECK: [0x7b,0x02,0x0a,0xc1]

s_load_dwordx16 s[20:35], s[2:3], 0xaf123456
// CHECK: [0xff,0x02,0x0a,0xc1,0x56,0x34,0x12,0xaf]

s_load_dwordx16 s[20:35], s[2:3], 0x3f717273
// CHECK: [0xff,0x02,0x0a,0xc1,0x73,0x72,0x71,0x3f]

s_load_dwordx16 s[20:35], s[2:3], 0x7f
// CHECK: [0x7f,0x03,0x0a,0xc1]

s_buffer_load_dword s5, s[4:7], s2
// CHECK: [0x02,0x84,0x02,0xc2]

s_buffer_load_dword s103, s[4:7], s2
// CHECK: [0x02,0x84,0x33,0xc2]

s_buffer_load_dword vcc_lo, s[4:7], s2
// CHECK: [0x02,0x04,0x35,0xc2]

s_buffer_load_dword vcc_hi, s[4:7], s2
// CHECK: [0x02,0x84,0x35,0xc2]

s_buffer_load_dword s5, s[8:11], s2
// CHECK: [0x02,0x88,0x02,0xc2]

s_buffer_load_dword s5, s[100:103], s2
// CHECK: [0x02,0xe4,0x02,0xc2]

s_buffer_load_dword s5, ttmp[8:11], s2
// CHECK: [0x02,0xf8,0x02,0xc2]

s_buffer_load_dword s5, s[4:7], s103
// CHECK: [0x67,0x84,0x02,0xc2]

s_buffer_load_dword s5, s[4:7], flat_scratch_lo
// CHECK: [0x68,0x84,0x02,0xc2]

s_buffer_load_dword s5, s[4:7], flat_scratch_hi
// CHECK: [0x69,0x84,0x02,0xc2]

s_buffer_load_dword s5, s[4:7], vcc_lo
// CHECK: [0x6a,0x84,0x02,0xc2]

s_buffer_load_dword s5, s[4:7], vcc_hi
// CHECK: [0x6b,0x84,0x02,0xc2]

s_buffer_load_dword s5, s[4:7], tba_lo
// CHECK: [0x6c,0x84,0x02,0xc2]

s_buffer_load_dword s5, s[4:7], tba_hi
// CHECK: [0x6d,0x84,0x02,0xc2]

s_buffer_load_dword s5, s[4:7], tma_lo
// CHECK: [0x6e,0x84,0x02,0xc2]

s_buffer_load_dword s5, s[4:7], tma_hi
// CHECK: [0x6f,0x84,0x02,0xc2]

s_buffer_load_dword s5, s[4:7], ttmp11
// CHECK: [0x7b,0x84,0x02,0xc2]

s_buffer_load_dword s5, s[4:7], 0xaf123456
// CHECK: [0xff,0x84,0x02,0xc2,0x56,0x34,0x12,0xaf]

s_buffer_load_dword s5, s[4:7], 0x3f717273
// CHECK: [0xff,0x84,0x02,0xc2,0x73,0x72,0x71,0x3f]

s_buffer_load_dword s5, s[4:7], 0x7f
// CHECK: [0x7f,0x85,0x02,0xc2]

s_buffer_load_dwordx2 s[10:11], s[4:7], s2
// CHECK: [0x02,0x04,0x45,0xc2]

s_buffer_load_dwordx2 s[12:13], s[4:7], s2
// CHECK: [0x02,0x04,0x46,0xc2]

s_buffer_load_dwordx2 s[102:103], s[4:7], s2
// CHECK: [0x02,0x04,0x73,0xc2]

s_buffer_load_dwordx2 vcc, s[4:7], s2
// CHECK: [0x02,0x04,0x75,0xc2]

s_buffer_load_dwordx2 s[10:11], s[8:11], s2
// CHECK: [0x02,0x08,0x45,0xc2]

s_buffer_load_dwordx2 s[10:11], s[100:103], s2
// CHECK: [0x02,0x64,0x45,0xc2]

s_buffer_load_dwordx2 s[10:11], ttmp[8:11], s2
// CHECK: [0x02,0x78,0x45,0xc2]

s_buffer_load_dwordx2 s[10:11], s[4:7], s103
// CHECK: [0x67,0x04,0x45,0xc2]

s_buffer_load_dwordx2 s[10:11], s[4:7], flat_scratch_lo
// CHECK: [0x68,0x04,0x45,0xc2]

s_buffer_load_dwordx2 s[10:11], s[4:7], flat_scratch_hi
// CHECK: [0x69,0x04,0x45,0xc2]

s_buffer_load_dwordx2 s[10:11], s[4:7], vcc_lo
// CHECK: [0x6a,0x04,0x45,0xc2]

s_buffer_load_dwordx2 s[10:11], s[4:7], vcc_hi
// CHECK: [0x6b,0x04,0x45,0xc2]

s_buffer_load_dwordx2 s[10:11], s[4:7], tba_lo
// CHECK: [0x6c,0x04,0x45,0xc2]

s_buffer_load_dwordx2 s[10:11], s[4:7], tba_hi
// CHECK: [0x6d,0x04,0x45,0xc2]

s_buffer_load_dwordx2 s[10:11], s[4:7], tma_lo
// CHECK: [0x6e,0x04,0x45,0xc2]

s_buffer_load_dwordx2 s[10:11], s[4:7], tma_hi
// CHECK: [0x6f,0x04,0x45,0xc2]

s_buffer_load_dwordx2 s[10:11], s[4:7], ttmp11
// CHECK: [0x7b,0x04,0x45,0xc2]

s_buffer_load_dwordx2 s[10:11], s[4:7], 0xaf123456
// CHECK: [0xff,0x04,0x45,0xc2,0x56,0x34,0x12,0xaf]

s_buffer_load_dwordx2 s[10:11], s[4:7], 0x3f717273
// CHECK: [0xff,0x04,0x45,0xc2,0x73,0x72,0x71,0x3f]

s_buffer_load_dwordx2 s[10:11], s[4:7], 0x7f
// CHECK: [0x7f,0x05,0x45,0xc2]

s_buffer_load_dwordx4 s[20:23], s[4:7], s2
// CHECK: [0x02,0x04,0x8a,0xc2]

s_buffer_load_dwordx4 s[24:27], s[4:7], s2
// CHECK: [0x02,0x04,0x8c,0xc2]

s_buffer_load_dwordx4 s[100:103], s[4:7], s2
// CHECK: [0x02,0x04,0xb2,0xc2]

s_buffer_load_dwordx4 s[20:23], s[8:11], s2
// CHECK: [0x02,0x08,0x8a,0xc2]

s_buffer_load_dwordx4 s[20:23], s[100:103], s2
// CHECK: [0x02,0x64,0x8a,0xc2]

s_buffer_load_dwordx4 s[20:23], ttmp[8:11], s2
// CHECK: [0x02,0x78,0x8a,0xc2]

s_buffer_load_dwordx4 s[20:23], s[4:7], s103
// CHECK: [0x67,0x04,0x8a,0xc2]

s_buffer_load_dwordx4 s[20:23], s[4:7], flat_scratch_lo
// CHECK: [0x68,0x04,0x8a,0xc2]

s_buffer_load_dwordx4 s[20:23], s[4:7], flat_scratch_hi
// CHECK: [0x69,0x04,0x8a,0xc2]

s_buffer_load_dwordx4 s[20:23], s[4:7], vcc_lo
// CHECK: [0x6a,0x04,0x8a,0xc2]

s_buffer_load_dwordx4 s[20:23], s[4:7], vcc_hi
// CHECK: [0x6b,0x04,0x8a,0xc2]

s_buffer_load_dwordx4 s[20:23], s[4:7], tba_lo
// CHECK: [0x6c,0x04,0x8a,0xc2]

s_buffer_load_dwordx4 s[20:23], s[4:7], tba_hi
// CHECK: [0x6d,0x04,0x8a,0xc2]

s_buffer_load_dwordx4 s[20:23], s[4:7], tma_lo
// CHECK: [0x6e,0x04,0x8a,0xc2]

s_buffer_load_dwordx4 s[20:23], s[4:7], tma_hi
// CHECK: [0x6f,0x04,0x8a,0xc2]

s_buffer_load_dwordx4 s[20:23], s[4:7], ttmp11
// CHECK: [0x7b,0x04,0x8a,0xc2]

s_buffer_load_dwordx4 s[20:23], s[4:7], 0xaf123456
// CHECK: [0xff,0x04,0x8a,0xc2,0x56,0x34,0x12,0xaf]

s_buffer_load_dwordx4 s[20:23], s[4:7], 0x3f717273
// CHECK: [0xff,0x04,0x8a,0xc2,0x73,0x72,0x71,0x3f]

s_buffer_load_dwordx4 s[20:23], s[4:7], 0x7f
// CHECK: [0x7f,0x05,0x8a,0xc2]

s_buffer_load_dwordx8 s[20:27], s[4:7], s2
// CHECK: [0x02,0x04,0xca,0xc2]

s_buffer_load_dwordx8 s[24:31], s[4:7], s2
// CHECK: [0x02,0x04,0xcc,0xc2]

s_buffer_load_dwordx8 s[96:103], s[4:7], s2
// CHECK: [0x02,0x04,0xf0,0xc2]

s_buffer_load_dwordx8 s[20:27], s[8:11], s2
// CHECK: [0x02,0x08,0xca,0xc2]

s_buffer_load_dwordx8 s[20:27], s[100:103], s2
// CHECK: [0x02,0x64,0xca,0xc2]

s_buffer_load_dwordx8 s[20:27], ttmp[8:11], s2
// CHECK: [0x02,0x78,0xca,0xc2]

s_buffer_load_dwordx8 s[20:27], s[4:7], s103
// CHECK: [0x67,0x04,0xca,0xc2]

s_buffer_load_dwordx8 s[20:27], s[4:7], flat_scratch_lo
// CHECK: [0x68,0x04,0xca,0xc2]

s_buffer_load_dwordx8 s[20:27], s[4:7], flat_scratch_hi
// CHECK: [0x69,0x04,0xca,0xc2]

s_buffer_load_dwordx8 s[20:27], s[4:7], vcc_lo
// CHECK: [0x6a,0x04,0xca,0xc2]

s_buffer_load_dwordx8 s[20:27], s[4:7], vcc_hi
// CHECK: [0x6b,0x04,0xca,0xc2]

s_buffer_load_dwordx8 s[20:27], s[4:7], tba_lo
// CHECK: [0x6c,0x04,0xca,0xc2]

s_buffer_load_dwordx8 s[20:27], s[4:7], tba_hi
// CHECK: [0x6d,0x04,0xca,0xc2]

s_buffer_load_dwordx8 s[20:27], s[4:7], tma_lo
// CHECK: [0x6e,0x04,0xca,0xc2]

s_buffer_load_dwordx8 s[20:27], s[4:7], tma_hi
// CHECK: [0x6f,0x04,0xca,0xc2]

s_buffer_load_dwordx8 s[20:27], s[4:7], ttmp11
// CHECK: [0x7b,0x04,0xca,0xc2]

s_buffer_load_dwordx8 s[20:27], s[4:7], 0xaf123456
// CHECK: [0xff,0x04,0xca,0xc2,0x56,0x34,0x12,0xaf]

s_buffer_load_dwordx8 s[20:27], s[4:7], 0x3f717273
// CHECK: [0xff,0x04,0xca,0xc2,0x73,0x72,0x71,0x3f]

s_buffer_load_dwordx8 s[20:27], s[4:7], 0x7f
// CHECK: [0x7f,0x05,0xca,0xc2]

s_buffer_load_dwordx16 s[20:35], s[4:7], s2
// CHECK: [0x02,0x04,0x0a,0xc3]

s_buffer_load_dwordx16 s[24:39], s[4:7], s2
// CHECK: [0x02,0x04,0x0c,0xc3]

s_buffer_load_dwordx16 s[88:103], s[4:7], s2
// CHECK: [0x02,0x04,0x2c,0xc3]

s_buffer_load_dwordx16 s[20:35], s[8:11], s2
// CHECK: [0x02,0x08,0x0a,0xc3]

s_buffer_load_dwordx16 s[20:35], s[100:103], s2
// CHECK: [0x02,0x64,0x0a,0xc3]

s_buffer_load_dwordx16 s[20:35], ttmp[8:11], s2
// CHECK: [0x02,0x78,0x0a,0xc3]

s_buffer_load_dwordx16 s[20:35], s[4:7], s103
// CHECK: [0x67,0x04,0x0a,0xc3]

s_buffer_load_dwordx16 s[20:35], s[4:7], flat_scratch_lo
// CHECK: [0x68,0x04,0x0a,0xc3]

s_buffer_load_dwordx16 s[20:35], s[4:7], flat_scratch_hi
// CHECK: [0x69,0x04,0x0a,0xc3]

s_buffer_load_dwordx16 s[20:35], s[4:7], vcc_lo
// CHECK: [0x6a,0x04,0x0a,0xc3]

s_buffer_load_dwordx16 s[20:35], s[4:7], vcc_hi
// CHECK: [0x6b,0x04,0x0a,0xc3]

s_buffer_load_dwordx16 s[20:35], s[4:7], tba_lo
// CHECK: [0x6c,0x04,0x0a,0xc3]

s_buffer_load_dwordx16 s[20:35], s[4:7], tba_hi
// CHECK: [0x6d,0x04,0x0a,0xc3]

s_buffer_load_dwordx16 s[20:35], s[4:7], tma_lo
// CHECK: [0x6e,0x04,0x0a,0xc3]

s_buffer_load_dwordx16 s[20:35], s[4:7], tma_hi
// CHECK: [0x6f,0x04,0x0a,0xc3]

s_buffer_load_dwordx16 s[20:35], s[4:7], ttmp11
// CHECK: [0x7b,0x04,0x0a,0xc3]

s_buffer_load_dwordx16 s[20:35], s[4:7], 0xaf123456
// CHECK: [0xff,0x04,0x0a,0xc3,0x56,0x34,0x12,0xaf]

s_buffer_load_dwordx16 s[20:35], s[4:7], 0x3f717273
// CHECK: [0xff,0x04,0x0a,0xc3,0x73,0x72,0x71,0x3f]

s_buffer_load_dwordx16 s[20:35], s[4:7], 0x7f
// CHECK: [0x7f,0x05,0x0a,0xc3]

s_dcache_inv_vol
// CHECK: [0x00,0x00,0x40,0xc7]

s_memtime s[10:11]
// CHECK: [0x00,0x00,0x85,0xc7]

s_memtime s[12:13]
// CHECK: [0x00,0x00,0x86,0xc7]

s_memtime s[102:103]
// CHECK: [0x00,0x00,0xb3,0xc7]

s_memtime vcc
// CHECK: [0x00,0x00,0xb5,0xc7]

s_dcache_inv
// CHECK: [0x00,0x00,0xc0,0xc7]

s_mov_b32 s5, s1
// CHECK: [0x01,0x03,0x85,0xbe]

s_mov_b32 s103, s1
// CHECK: [0x01,0x03,0xe7,0xbe]

s_mov_b32 flat_scratch_lo, s1
// CHECK: [0x01,0x03,0xe8,0xbe]

s_mov_b32 flat_scratch_hi, s1
// CHECK: [0x01,0x03,0xe9,0xbe]

s_mov_b32 vcc_lo, s1
// CHECK: [0x01,0x03,0xea,0xbe]

s_mov_b32 vcc_hi, s1
// CHECK: [0x01,0x03,0xeb,0xbe]

s_mov_b32 tba_lo, s1
// CHECK: [0x01,0x03,0xec,0xbe]

s_mov_b32 tba_hi, s1
// CHECK: [0x01,0x03,0xed,0xbe]

s_mov_b32 tma_lo, s1
// CHECK: [0x01,0x03,0xee,0xbe]

s_mov_b32 tma_hi, s1
// CHECK: [0x01,0x03,0xef,0xbe]

s_mov_b32 ttmp11, s1
// CHECK: [0x01,0x03,0xfb,0xbe]

s_mov_b32 m0, s1
// CHECK: [0x01,0x03,0xfc,0xbe]

s_mov_b32 exec_lo, s1
// CHECK: [0x01,0x03,0xfe,0xbe]

s_mov_b32 exec_hi, s1
// CHECK: [0x01,0x03,0xff,0xbe]

s_mov_b32 s5, s103
// CHECK: [0x67,0x03,0x85,0xbe]

s_mov_b32 s5, flat_scratch_lo
// CHECK: [0x68,0x03,0x85,0xbe]

s_mov_b32 s5, flat_scratch_hi
// CHECK: [0x69,0x03,0x85,0xbe]

s_mov_b32 s5, vcc_lo
// CHECK: [0x6a,0x03,0x85,0xbe]

s_mov_b32 s5, vcc_hi
// CHECK: [0x6b,0x03,0x85,0xbe]

s_mov_b32 s5, tba_lo
// CHECK: [0x6c,0x03,0x85,0xbe]

s_mov_b32 s5, tba_hi
// CHECK: [0x6d,0x03,0x85,0xbe]

s_mov_b32 s5, tma_lo
// CHECK: [0x6e,0x03,0x85,0xbe]

s_mov_b32 s5, tma_hi
// CHECK: [0x6f,0x03,0x85,0xbe]

s_mov_b32 s5, ttmp11
// CHECK: [0x7b,0x03,0x85,0xbe]

s_mov_b32 s5, m0
// CHECK: [0x7c,0x03,0x85,0xbe]

s_mov_b32 s5, exec_lo
// CHECK: [0x7e,0x03,0x85,0xbe]

s_mov_b32 s5, exec_hi
// CHECK: [0x7f,0x03,0x85,0xbe]

s_mov_b32 s5, 0
// CHECK: [0x80,0x03,0x85,0xbe]

s_mov_b32 s5, -1
// CHECK: [0xc1,0x03,0x85,0xbe]

s_mov_b32 s5, 0.5
// CHECK: [0xf0,0x03,0x85,0xbe]

s_mov_b32 s5, -4.0
// CHECK: [0xf7,0x03,0x85,0xbe]

s_mov_b32 s5, 0xaf123456
// CHECK: [0xff,0x03,0x85,0xbe,0x56,0x34,0x12,0xaf]

s_mov_b32 s5, 0x3f717273
// CHECK: [0xff,0x03,0x85,0xbe,0x73,0x72,0x71,0x3f]

s_mov_b64 s[10:11], s[2:3]
// CHECK: [0x02,0x04,0x8a,0xbe]

s_mov_b64 s[12:13], s[2:3]
// CHECK: [0x02,0x04,0x8c,0xbe]

s_mov_b64 s[102:103], s[2:3]
// CHECK: [0x02,0x04,0xe6,0xbe]

s_mov_b64 flat_scratch, s[2:3]
// CHECK: [0x02,0x04,0xe8,0xbe]

s_mov_b64 vcc, s[2:3]
// CHECK: [0x02,0x04,0xea,0xbe]

s_mov_b64 tba, s[2:3]
// CHECK: [0x02,0x04,0xec,0xbe]

s_mov_b64 tma, s[2:3]
// CHECK: [0x02,0x04,0xee,0xbe]

s_mov_b64 ttmp[10:11], s[2:3]
// CHECK: [0x02,0x04,0xfa,0xbe]

s_mov_b64 exec, s[2:3]
// CHECK: [0x02,0x04,0xfe,0xbe]

s_mov_b64 s[10:11], s[4:5]
// CHECK: [0x04,0x04,0x8a,0xbe]

s_mov_b64 s[10:11], s[102:103]
// CHECK: [0x66,0x04,0x8a,0xbe]

s_mov_b64 s[10:11], flat_scratch
// CHECK: [0x68,0x04,0x8a,0xbe]

s_mov_b64 s[10:11], vcc
// CHECK: [0x6a,0x04,0x8a,0xbe]

s_mov_b64 s[10:11], tba
// CHECK: [0x6c,0x04,0x8a,0xbe]

s_mov_b64 s[10:11], tma
// CHECK: [0x6e,0x04,0x8a,0xbe]

s_mov_b64 s[10:11], ttmp[10:11]
// CHECK: [0x7a,0x04,0x8a,0xbe]

s_mov_b64 s[10:11], exec
// CHECK: [0x7e,0x04,0x8a,0xbe]

s_mov_b64 s[10:11], 0
// CHECK: [0x80,0x04,0x8a,0xbe]

s_mov_b64 s[10:11], -1
// CHECK: [0xc1,0x04,0x8a,0xbe]

s_mov_b64 s[10:11], 0.5
// CHECK: [0xf0,0x04,0x8a,0xbe]

s_mov_b64 s[10:11], -4.0
// CHECK: [0xf7,0x04,0x8a,0xbe]

s_mov_b64 s[10:11], 0xaf123456
// CHECK: [0xff,0x04,0x8a,0xbe,0x56,0x34,0x12,0xaf]

s_mov_b64 s[10:11], 0x3f717273
// CHECK: [0xff,0x04,0x8a,0xbe,0x73,0x72,0x71,0x3f]

s_cmov_b32 s5, s1
// CHECK: [0x01,0x05,0x85,0xbe]

s_cmov_b32 s103, s1
// CHECK: [0x01,0x05,0xe7,0xbe]

s_cmov_b32 flat_scratch_lo, s1
// CHECK: [0x01,0x05,0xe8,0xbe]

s_cmov_b32 flat_scratch_hi, s1
// CHECK: [0x01,0x05,0xe9,0xbe]

s_cmov_b32 vcc_lo, s1
// CHECK: [0x01,0x05,0xea,0xbe]

s_cmov_b32 vcc_hi, s1
// CHECK: [0x01,0x05,0xeb,0xbe]

s_cmov_b32 tba_lo, s1
// CHECK: [0x01,0x05,0xec,0xbe]

s_cmov_b32 tba_hi, s1
// CHECK: [0x01,0x05,0xed,0xbe]

s_cmov_b32 tma_lo, s1
// CHECK: [0x01,0x05,0xee,0xbe]

s_cmov_b32 tma_hi, s1
// CHECK: [0x01,0x05,0xef,0xbe]

s_cmov_b32 ttmp11, s1
// CHECK: [0x01,0x05,0xfb,0xbe]

s_cmov_b32 m0, s1
// CHECK: [0x01,0x05,0xfc,0xbe]

s_cmov_b32 exec_lo, s1
// CHECK: [0x01,0x05,0xfe,0xbe]

s_cmov_b32 exec_hi, s1
// CHECK: [0x01,0x05,0xff,0xbe]

s_cmov_b32 s5, s103
// CHECK: [0x67,0x05,0x85,0xbe]

s_cmov_b32 s5, flat_scratch_lo
// CHECK: [0x68,0x05,0x85,0xbe]

s_cmov_b32 s5, flat_scratch_hi
// CHECK: [0x69,0x05,0x85,0xbe]

s_cmov_b32 s5, vcc_lo
// CHECK: [0x6a,0x05,0x85,0xbe]

s_cmov_b32 s5, vcc_hi
// CHECK: [0x6b,0x05,0x85,0xbe]

s_cmov_b32 s5, tba_lo
// CHECK: [0x6c,0x05,0x85,0xbe]

s_cmov_b32 s5, tba_hi
// CHECK: [0x6d,0x05,0x85,0xbe]

s_cmov_b32 s5, tma_lo
// CHECK: [0x6e,0x05,0x85,0xbe]

s_cmov_b32 s5, tma_hi
// CHECK: [0x6f,0x05,0x85,0xbe]

s_cmov_b32 s5, ttmp11
// CHECK: [0x7b,0x05,0x85,0xbe]

s_cmov_b32 s5, m0
// CHECK: [0x7c,0x05,0x85,0xbe]

s_cmov_b32 s5, exec_lo
// CHECK: [0x7e,0x05,0x85,0xbe]

s_cmov_b32 s5, exec_hi
// CHECK: [0x7f,0x05,0x85,0xbe]

s_cmov_b32 s5, 0
// CHECK: [0x80,0x05,0x85,0xbe]

s_cmov_b32 s5, -1
// CHECK: [0xc1,0x05,0x85,0xbe]

s_cmov_b32 s5, 0.5
// CHECK: [0xf0,0x05,0x85,0xbe]

s_cmov_b32 s5, -4.0
// CHECK: [0xf7,0x05,0x85,0xbe]

s_cmov_b32 s5, 0xaf123456
// CHECK: [0xff,0x05,0x85,0xbe,0x56,0x34,0x12,0xaf]

s_cmov_b32 s5, 0x3f717273
// CHECK: [0xff,0x05,0x85,0xbe,0x73,0x72,0x71,0x3f]

s_cmov_b64 s[10:11], s[2:3]
// CHECK: [0x02,0x06,0x8a,0xbe]

s_cmov_b64 s[12:13], s[2:3]
// CHECK: [0x02,0x06,0x8c,0xbe]

s_cmov_b64 s[102:103], s[2:3]
// CHECK: [0x02,0x06,0xe6,0xbe]

s_cmov_b64 flat_scratch, s[2:3]
// CHECK: [0x02,0x06,0xe8,0xbe]

s_cmov_b64 vcc, s[2:3]
// CHECK: [0x02,0x06,0xea,0xbe]

s_cmov_b64 tba, s[2:3]
// CHECK: [0x02,0x06,0xec,0xbe]

s_cmov_b64 tma, s[2:3]
// CHECK: [0x02,0x06,0xee,0xbe]

s_cmov_b64 ttmp[10:11], s[2:3]
// CHECK: [0x02,0x06,0xfa,0xbe]

s_cmov_b64 exec, s[2:3]
// CHECK: [0x02,0x06,0xfe,0xbe]

s_cmov_b64 s[10:11], s[4:5]
// CHECK: [0x04,0x06,0x8a,0xbe]

s_cmov_b64 s[10:11], s[102:103]
// CHECK: [0x66,0x06,0x8a,0xbe]

s_cmov_b64 s[10:11], flat_scratch
// CHECK: [0x68,0x06,0x8a,0xbe]

s_cmov_b64 s[10:11], vcc
// CHECK: [0x6a,0x06,0x8a,0xbe]

s_cmov_b64 s[10:11], tba
// CHECK: [0x6c,0x06,0x8a,0xbe]

s_cmov_b64 s[10:11], tma
// CHECK: [0x6e,0x06,0x8a,0xbe]

s_cmov_b64 s[10:11], ttmp[10:11]
// CHECK: [0x7a,0x06,0x8a,0xbe]

s_cmov_b64 s[10:11], exec
// CHECK: [0x7e,0x06,0x8a,0xbe]

s_cmov_b64 s[10:11], 0
// CHECK: [0x80,0x06,0x8a,0xbe]

s_cmov_b64 s[10:11], -1
// CHECK: [0xc1,0x06,0x8a,0xbe]

s_cmov_b64 s[10:11], 0.5
// CHECK: [0xf0,0x06,0x8a,0xbe]

s_cmov_b64 s[10:11], -4.0
// CHECK: [0xf7,0x06,0x8a,0xbe]

s_cmov_b64 s[10:11], 0xaf123456
// CHECK: [0xff,0x06,0x8a,0xbe,0x56,0x34,0x12,0xaf]

s_cmov_b64 s[10:11], 0x3f717273
// CHECK: [0xff,0x06,0x8a,0xbe,0x73,0x72,0x71,0x3f]

s_not_b32 s5, s1
// CHECK: [0x01,0x07,0x85,0xbe]

s_not_b32 s103, s1
// CHECK: [0x01,0x07,0xe7,0xbe]

s_not_b32 flat_scratch_lo, s1
// CHECK: [0x01,0x07,0xe8,0xbe]

s_not_b32 flat_scratch_hi, s1
// CHECK: [0x01,0x07,0xe9,0xbe]

s_not_b32 vcc_lo, s1
// CHECK: [0x01,0x07,0xea,0xbe]

s_not_b32 vcc_hi, s1
// CHECK: [0x01,0x07,0xeb,0xbe]

s_not_b32 tba_lo, s1
// CHECK: [0x01,0x07,0xec,0xbe]

s_not_b32 tba_hi, s1
// CHECK: [0x01,0x07,0xed,0xbe]

s_not_b32 tma_lo, s1
// CHECK: [0x01,0x07,0xee,0xbe]

s_not_b32 tma_hi, s1
// CHECK: [0x01,0x07,0xef,0xbe]

s_not_b32 ttmp11, s1
// CHECK: [0x01,0x07,0xfb,0xbe]

s_not_b32 m0, s1
// CHECK: [0x01,0x07,0xfc,0xbe]

s_not_b32 exec_lo, s1
// CHECK: [0x01,0x07,0xfe,0xbe]

s_not_b32 exec_hi, s1
// CHECK: [0x01,0x07,0xff,0xbe]

s_not_b32 s5, s103
// CHECK: [0x67,0x07,0x85,0xbe]

s_not_b32 s5, flat_scratch_lo
// CHECK: [0x68,0x07,0x85,0xbe]

s_not_b32 s5, flat_scratch_hi
// CHECK: [0x69,0x07,0x85,0xbe]

s_not_b32 s5, vcc_lo
// CHECK: [0x6a,0x07,0x85,0xbe]

s_not_b32 s5, vcc_hi
// CHECK: [0x6b,0x07,0x85,0xbe]

s_not_b32 s5, tba_lo
// CHECK: [0x6c,0x07,0x85,0xbe]

s_not_b32 s5, tba_hi
// CHECK: [0x6d,0x07,0x85,0xbe]

s_not_b32 s5, tma_lo
// CHECK: [0x6e,0x07,0x85,0xbe]

s_not_b32 s5, tma_hi
// CHECK: [0x6f,0x07,0x85,0xbe]

s_not_b32 s5, ttmp11
// CHECK: [0x7b,0x07,0x85,0xbe]

s_not_b32 s5, m0
// CHECK: [0x7c,0x07,0x85,0xbe]

s_not_b32 s5, exec_lo
// CHECK: [0x7e,0x07,0x85,0xbe]

s_not_b32 s5, exec_hi
// CHECK: [0x7f,0x07,0x85,0xbe]

s_not_b32 s5, 0
// CHECK: [0x80,0x07,0x85,0xbe]

s_not_b32 s5, -1
// CHECK: [0xc1,0x07,0x85,0xbe]

s_not_b32 s5, 0.5
// CHECK: [0xf0,0x07,0x85,0xbe]

s_not_b32 s5, -4.0
// CHECK: [0xf7,0x07,0x85,0xbe]

s_not_b32 s5, 0xaf123456
// CHECK: [0xff,0x07,0x85,0xbe,0x56,0x34,0x12,0xaf]

s_not_b32 s5, 0x3f717273
// CHECK: [0xff,0x07,0x85,0xbe,0x73,0x72,0x71,0x3f]

s_not_b64 s[10:11], s[2:3]
// CHECK: [0x02,0x08,0x8a,0xbe]

s_not_b64 s[12:13], s[2:3]
// CHECK: [0x02,0x08,0x8c,0xbe]

s_not_b64 s[102:103], s[2:3]
// CHECK: [0x02,0x08,0xe6,0xbe]

s_not_b64 flat_scratch, s[2:3]
// CHECK: [0x02,0x08,0xe8,0xbe]

s_not_b64 vcc, s[2:3]
// CHECK: [0x02,0x08,0xea,0xbe]

s_not_b64 tba, s[2:3]
// CHECK: [0x02,0x08,0xec,0xbe]

s_not_b64 tma, s[2:3]
// CHECK: [0x02,0x08,0xee,0xbe]

s_not_b64 ttmp[10:11], s[2:3]
// CHECK: [0x02,0x08,0xfa,0xbe]

s_not_b64 exec, s[2:3]
// CHECK: [0x02,0x08,0xfe,0xbe]

s_not_b64 s[10:11], s[4:5]
// CHECK: [0x04,0x08,0x8a,0xbe]

s_not_b64 s[10:11], s[102:103]
// CHECK: [0x66,0x08,0x8a,0xbe]

s_not_b64 s[10:11], flat_scratch
// CHECK: [0x68,0x08,0x8a,0xbe]

s_not_b64 s[10:11], vcc
// CHECK: [0x6a,0x08,0x8a,0xbe]

s_not_b64 s[10:11], tba
// CHECK: [0x6c,0x08,0x8a,0xbe]

s_not_b64 s[10:11], tma
// CHECK: [0x6e,0x08,0x8a,0xbe]

s_not_b64 s[10:11], ttmp[10:11]
// CHECK: [0x7a,0x08,0x8a,0xbe]

s_not_b64 s[10:11], exec
// CHECK: [0x7e,0x08,0x8a,0xbe]

s_not_b64 s[10:11], 0
// CHECK: [0x80,0x08,0x8a,0xbe]

s_not_b64 s[10:11], -1
// CHECK: [0xc1,0x08,0x8a,0xbe]

s_not_b64 s[10:11], 0.5
// CHECK: [0xf0,0x08,0x8a,0xbe]

s_not_b64 s[10:11], -4.0
// CHECK: [0xf7,0x08,0x8a,0xbe]

s_not_b64 s[10:11], 0xaf123456
// CHECK: [0xff,0x08,0x8a,0xbe,0x56,0x34,0x12,0xaf]

s_not_b64 s[10:11], 0x3f717273
// CHECK: [0xff,0x08,0x8a,0xbe,0x73,0x72,0x71,0x3f]

s_wqm_b32 s5, s1
// CHECK: [0x01,0x09,0x85,0xbe]

s_wqm_b32 s103, s1
// CHECK: [0x01,0x09,0xe7,0xbe]

s_wqm_b32 flat_scratch_lo, s1
// CHECK: [0x01,0x09,0xe8,0xbe]

s_wqm_b32 flat_scratch_hi, s1
// CHECK: [0x01,0x09,0xe9,0xbe]

s_wqm_b32 vcc_lo, s1
// CHECK: [0x01,0x09,0xea,0xbe]

s_wqm_b32 vcc_hi, s1
// CHECK: [0x01,0x09,0xeb,0xbe]

s_wqm_b32 tba_lo, s1
// CHECK: [0x01,0x09,0xec,0xbe]

s_wqm_b32 tba_hi, s1
// CHECK: [0x01,0x09,0xed,0xbe]

s_wqm_b32 tma_lo, s1
// CHECK: [0x01,0x09,0xee,0xbe]

s_wqm_b32 tma_hi, s1
// CHECK: [0x01,0x09,0xef,0xbe]

s_wqm_b32 ttmp11, s1
// CHECK: [0x01,0x09,0xfb,0xbe]

s_wqm_b32 m0, s1
// CHECK: [0x01,0x09,0xfc,0xbe]

s_wqm_b32 exec_lo, s1
// CHECK: [0x01,0x09,0xfe,0xbe]

s_wqm_b32 exec_hi, s1
// CHECK: [0x01,0x09,0xff,0xbe]

s_wqm_b32 s5, s103
// CHECK: [0x67,0x09,0x85,0xbe]

s_wqm_b32 s5, flat_scratch_lo
// CHECK: [0x68,0x09,0x85,0xbe]

s_wqm_b32 s5, flat_scratch_hi
// CHECK: [0x69,0x09,0x85,0xbe]

s_wqm_b32 s5, vcc_lo
// CHECK: [0x6a,0x09,0x85,0xbe]

s_wqm_b32 s5, vcc_hi
// CHECK: [0x6b,0x09,0x85,0xbe]

s_wqm_b32 s5, tba_lo
// CHECK: [0x6c,0x09,0x85,0xbe]

s_wqm_b32 s5, tba_hi
// CHECK: [0x6d,0x09,0x85,0xbe]

s_wqm_b32 s5, tma_lo
// CHECK: [0x6e,0x09,0x85,0xbe]

s_wqm_b32 s5, tma_hi
// CHECK: [0x6f,0x09,0x85,0xbe]

s_wqm_b32 s5, ttmp11
// CHECK: [0x7b,0x09,0x85,0xbe]

s_wqm_b32 s5, m0
// CHECK: [0x7c,0x09,0x85,0xbe]

s_wqm_b32 s5, exec_lo
// CHECK: [0x7e,0x09,0x85,0xbe]

s_wqm_b32 s5, exec_hi
// CHECK: [0x7f,0x09,0x85,0xbe]

s_wqm_b32 s5, 0
// CHECK: [0x80,0x09,0x85,0xbe]

s_wqm_b32 s5, -1
// CHECK: [0xc1,0x09,0x85,0xbe]

s_wqm_b32 s5, 0.5
// CHECK: [0xf0,0x09,0x85,0xbe]

s_wqm_b32 s5, -4.0
// CHECK: [0xf7,0x09,0x85,0xbe]

s_wqm_b32 s5, 0xaf123456
// CHECK: [0xff,0x09,0x85,0xbe,0x56,0x34,0x12,0xaf]

s_wqm_b32 s5, 0x3f717273
// CHECK: [0xff,0x09,0x85,0xbe,0x73,0x72,0x71,0x3f]

s_wqm_b64 s[10:11], s[2:3]
// CHECK: [0x02,0x0a,0x8a,0xbe]

s_wqm_b64 s[12:13], s[2:3]
// CHECK: [0x02,0x0a,0x8c,0xbe]

s_wqm_b64 s[102:103], s[2:3]
// CHECK: [0x02,0x0a,0xe6,0xbe]

s_wqm_b64 flat_scratch, s[2:3]
// CHECK: [0x02,0x0a,0xe8,0xbe]

s_wqm_b64 vcc, s[2:3]
// CHECK: [0x02,0x0a,0xea,0xbe]

s_wqm_b64 tba, s[2:3]
// CHECK: [0x02,0x0a,0xec,0xbe]

s_wqm_b64 tma, s[2:3]
// CHECK: [0x02,0x0a,0xee,0xbe]

s_wqm_b64 ttmp[10:11], s[2:3]
// CHECK: [0x02,0x0a,0xfa,0xbe]

s_wqm_b64 exec, s[2:3]
// CHECK: [0x02,0x0a,0xfe,0xbe]

s_wqm_b64 s[10:11], s[4:5]
// CHECK: [0x04,0x0a,0x8a,0xbe]

s_wqm_b64 s[10:11], s[102:103]
// CHECK: [0x66,0x0a,0x8a,0xbe]

s_wqm_b64 s[10:11], flat_scratch
// CHECK: [0x68,0x0a,0x8a,0xbe]

s_wqm_b64 s[10:11], vcc
// CHECK: [0x6a,0x0a,0x8a,0xbe]

s_wqm_b64 s[10:11], tba
// CHECK: [0x6c,0x0a,0x8a,0xbe]

s_wqm_b64 s[10:11], tma
// CHECK: [0x6e,0x0a,0x8a,0xbe]

s_wqm_b64 s[10:11], ttmp[10:11]
// CHECK: [0x7a,0x0a,0x8a,0xbe]

s_wqm_b64 s[10:11], exec
// CHECK: [0x7e,0x0a,0x8a,0xbe]

s_wqm_b64 s[10:11], 0
// CHECK: [0x80,0x0a,0x8a,0xbe]

s_wqm_b64 s[10:11], -1
// CHECK: [0xc1,0x0a,0x8a,0xbe]

s_wqm_b64 s[10:11], 0.5
// CHECK: [0xf0,0x0a,0x8a,0xbe]

s_wqm_b64 s[10:11], -4.0
// CHECK: [0xf7,0x0a,0x8a,0xbe]

s_wqm_b64 s[10:11], 0xaf123456
// CHECK: [0xff,0x0a,0x8a,0xbe,0x56,0x34,0x12,0xaf]

s_wqm_b64 s[10:11], 0x3f717273
// CHECK: [0xff,0x0a,0x8a,0xbe,0x73,0x72,0x71,0x3f]

s_brev_b32 s5, s1
// CHECK: [0x01,0x0b,0x85,0xbe]

s_brev_b32 s103, s1
// CHECK: [0x01,0x0b,0xe7,0xbe]

s_brev_b32 flat_scratch_lo, s1
// CHECK: [0x01,0x0b,0xe8,0xbe]

s_brev_b32 flat_scratch_hi, s1
// CHECK: [0x01,0x0b,0xe9,0xbe]

s_brev_b32 vcc_lo, s1
// CHECK: [0x01,0x0b,0xea,0xbe]

s_brev_b32 vcc_hi, s1
// CHECK: [0x01,0x0b,0xeb,0xbe]

s_brev_b32 tba_lo, s1
// CHECK: [0x01,0x0b,0xec,0xbe]

s_brev_b32 tba_hi, s1
// CHECK: [0x01,0x0b,0xed,0xbe]

s_brev_b32 tma_lo, s1
// CHECK: [0x01,0x0b,0xee,0xbe]

s_brev_b32 tma_hi, s1
// CHECK: [0x01,0x0b,0xef,0xbe]

s_brev_b32 ttmp11, s1
// CHECK: [0x01,0x0b,0xfb,0xbe]

s_brev_b32 m0, s1
// CHECK: [0x01,0x0b,0xfc,0xbe]

s_brev_b32 exec_lo, s1
// CHECK: [0x01,0x0b,0xfe,0xbe]

s_brev_b32 exec_hi, s1
// CHECK: [0x01,0x0b,0xff,0xbe]

s_brev_b32 s5, s103
// CHECK: [0x67,0x0b,0x85,0xbe]

s_brev_b32 s5, flat_scratch_lo
// CHECK: [0x68,0x0b,0x85,0xbe]

s_brev_b32 s5, flat_scratch_hi
// CHECK: [0x69,0x0b,0x85,0xbe]

s_brev_b32 s5, vcc_lo
// CHECK: [0x6a,0x0b,0x85,0xbe]

s_brev_b32 s5, vcc_hi
// CHECK: [0x6b,0x0b,0x85,0xbe]

s_brev_b32 s5, tba_lo
// CHECK: [0x6c,0x0b,0x85,0xbe]

s_brev_b32 s5, tba_hi
// CHECK: [0x6d,0x0b,0x85,0xbe]

s_brev_b32 s5, tma_lo
// CHECK: [0x6e,0x0b,0x85,0xbe]

s_brev_b32 s5, tma_hi
// CHECK: [0x6f,0x0b,0x85,0xbe]

s_brev_b32 s5, ttmp11
// CHECK: [0x7b,0x0b,0x85,0xbe]

s_brev_b32 s5, m0
// CHECK: [0x7c,0x0b,0x85,0xbe]

s_brev_b32 s5, exec_lo
// CHECK: [0x7e,0x0b,0x85,0xbe]

s_brev_b32 s5, exec_hi
// CHECK: [0x7f,0x0b,0x85,0xbe]

s_brev_b32 s5, 0
// CHECK: [0x80,0x0b,0x85,0xbe]

s_brev_b32 s5, -1
// CHECK: [0xc1,0x0b,0x85,0xbe]

s_brev_b32 s5, 0.5
// CHECK: [0xf0,0x0b,0x85,0xbe]

s_brev_b32 s5, -4.0
// CHECK: [0xf7,0x0b,0x85,0xbe]

s_brev_b32 s5, 0xaf123456
// CHECK: [0xff,0x0b,0x85,0xbe,0x56,0x34,0x12,0xaf]

s_brev_b32 s5, 0x3f717273
// CHECK: [0xff,0x0b,0x85,0xbe,0x73,0x72,0x71,0x3f]

s_brev_b64 s[10:11], s[2:3]
// CHECK: [0x02,0x0c,0x8a,0xbe]

s_brev_b64 s[12:13], s[2:3]
// CHECK: [0x02,0x0c,0x8c,0xbe]

s_brev_b64 s[102:103], s[2:3]
// CHECK: [0x02,0x0c,0xe6,0xbe]

s_brev_b64 flat_scratch, s[2:3]
// CHECK: [0x02,0x0c,0xe8,0xbe]

s_brev_b64 vcc, s[2:3]
// CHECK: [0x02,0x0c,0xea,0xbe]

s_brev_b64 tba, s[2:3]
// CHECK: [0x02,0x0c,0xec,0xbe]

s_brev_b64 tma, s[2:3]
// CHECK: [0x02,0x0c,0xee,0xbe]

s_brev_b64 ttmp[10:11], s[2:3]
// CHECK: [0x02,0x0c,0xfa,0xbe]

s_brev_b64 exec, s[2:3]
// CHECK: [0x02,0x0c,0xfe,0xbe]

s_brev_b64 s[10:11], s[4:5]
// CHECK: [0x04,0x0c,0x8a,0xbe]

s_brev_b64 s[10:11], s[102:103]
// CHECK: [0x66,0x0c,0x8a,0xbe]

s_brev_b64 s[10:11], flat_scratch
// CHECK: [0x68,0x0c,0x8a,0xbe]

s_brev_b64 s[10:11], vcc
// CHECK: [0x6a,0x0c,0x8a,0xbe]

s_brev_b64 s[10:11], tba
// CHECK: [0x6c,0x0c,0x8a,0xbe]

s_brev_b64 s[10:11], tma
// CHECK: [0x6e,0x0c,0x8a,0xbe]

s_brev_b64 s[10:11], ttmp[10:11]
// CHECK: [0x7a,0x0c,0x8a,0xbe]

s_brev_b64 s[10:11], exec
// CHECK: [0x7e,0x0c,0x8a,0xbe]

s_brev_b64 s[10:11], 0
// CHECK: [0x80,0x0c,0x8a,0xbe]

s_brev_b64 s[10:11], -1
// CHECK: [0xc1,0x0c,0x8a,0xbe]

s_brev_b64 s[10:11], 0.5
// CHECK: [0xf0,0x0c,0x8a,0xbe]

s_brev_b64 s[10:11], -4.0
// CHECK: [0xf7,0x0c,0x8a,0xbe]

s_brev_b64 s[10:11], 0xaf123456
// CHECK: [0xff,0x0c,0x8a,0xbe,0x56,0x34,0x12,0xaf]

s_brev_b64 s[10:11], 0x3f717273
// CHECK: [0xff,0x0c,0x8a,0xbe,0x73,0x72,0x71,0x3f]

s_bcnt0_i32_b32 s5, s1
// CHECK: [0x01,0x0d,0x85,0xbe]

s_bcnt0_i32_b32 s103, s1
// CHECK: [0x01,0x0d,0xe7,0xbe]

s_bcnt0_i32_b32 flat_scratch_lo, s1
// CHECK: [0x01,0x0d,0xe8,0xbe]

s_bcnt0_i32_b32 flat_scratch_hi, s1
// CHECK: [0x01,0x0d,0xe9,0xbe]

s_bcnt0_i32_b32 vcc_lo, s1
// CHECK: [0x01,0x0d,0xea,0xbe]

s_bcnt0_i32_b32 vcc_hi, s1
// CHECK: [0x01,0x0d,0xeb,0xbe]

s_bcnt0_i32_b32 tba_lo, s1
// CHECK: [0x01,0x0d,0xec,0xbe]

s_bcnt0_i32_b32 tba_hi, s1
// CHECK: [0x01,0x0d,0xed,0xbe]

s_bcnt0_i32_b32 tma_lo, s1
// CHECK: [0x01,0x0d,0xee,0xbe]

s_bcnt0_i32_b32 tma_hi, s1
// CHECK: [0x01,0x0d,0xef,0xbe]

s_bcnt0_i32_b32 ttmp11, s1
// CHECK: [0x01,0x0d,0xfb,0xbe]

s_bcnt0_i32_b32 m0, s1
// CHECK: [0x01,0x0d,0xfc,0xbe]

s_bcnt0_i32_b32 exec_lo, s1
// CHECK: [0x01,0x0d,0xfe,0xbe]

s_bcnt0_i32_b32 exec_hi, s1
// CHECK: [0x01,0x0d,0xff,0xbe]

s_bcnt0_i32_b32 s5, s103
// CHECK: [0x67,0x0d,0x85,0xbe]

s_bcnt0_i32_b32 s5, flat_scratch_lo
// CHECK: [0x68,0x0d,0x85,0xbe]

s_bcnt0_i32_b32 s5, flat_scratch_hi
// CHECK: [0x69,0x0d,0x85,0xbe]

s_bcnt0_i32_b32 s5, vcc_lo
// CHECK: [0x6a,0x0d,0x85,0xbe]

s_bcnt0_i32_b32 s5, vcc_hi
// CHECK: [0x6b,0x0d,0x85,0xbe]

s_bcnt0_i32_b32 s5, tba_lo
// CHECK: [0x6c,0x0d,0x85,0xbe]

s_bcnt0_i32_b32 s5, tba_hi
// CHECK: [0x6d,0x0d,0x85,0xbe]

s_bcnt0_i32_b32 s5, tma_lo
// CHECK: [0x6e,0x0d,0x85,0xbe]

s_bcnt0_i32_b32 s5, tma_hi
// CHECK: [0x6f,0x0d,0x85,0xbe]

s_bcnt0_i32_b32 s5, ttmp11
// CHECK: [0x7b,0x0d,0x85,0xbe]

s_bcnt0_i32_b32 s5, m0
// CHECK: [0x7c,0x0d,0x85,0xbe]

s_bcnt0_i32_b32 s5, exec_lo
// CHECK: [0x7e,0x0d,0x85,0xbe]

s_bcnt0_i32_b32 s5, exec_hi
// CHECK: [0x7f,0x0d,0x85,0xbe]

s_bcnt0_i32_b32 s5, 0
// CHECK: [0x80,0x0d,0x85,0xbe]

s_bcnt0_i32_b32 s5, -1
// CHECK: [0xc1,0x0d,0x85,0xbe]

s_bcnt0_i32_b32 s5, 0.5
// CHECK: [0xf0,0x0d,0x85,0xbe]

s_bcnt0_i32_b32 s5, -4.0
// CHECK: [0xf7,0x0d,0x85,0xbe]

s_bcnt0_i32_b32 s5, 0xaf123456
// CHECK: [0xff,0x0d,0x85,0xbe,0x56,0x34,0x12,0xaf]

s_bcnt0_i32_b32 s5, 0x3f717273
// CHECK: [0xff,0x0d,0x85,0xbe,0x73,0x72,0x71,0x3f]

s_bcnt0_i32_b64 s5, s[2:3]
// CHECK: [0x02,0x0e,0x85,0xbe]

s_bcnt0_i32_b64 s103, s[2:3]
// CHECK: [0x02,0x0e,0xe7,0xbe]

s_bcnt0_i32_b64 flat_scratch_lo, s[2:3]
// CHECK: [0x02,0x0e,0xe8,0xbe]

s_bcnt0_i32_b64 flat_scratch_hi, s[2:3]
// CHECK: [0x02,0x0e,0xe9,0xbe]

s_bcnt0_i32_b64 vcc_lo, s[2:3]
// CHECK: [0x02,0x0e,0xea,0xbe]

s_bcnt0_i32_b64 vcc_hi, s[2:3]
// CHECK: [0x02,0x0e,0xeb,0xbe]

s_bcnt0_i32_b64 tba_lo, s[2:3]
// CHECK: [0x02,0x0e,0xec,0xbe]

s_bcnt0_i32_b64 tba_hi, s[2:3]
// CHECK: [0x02,0x0e,0xed,0xbe]

s_bcnt0_i32_b64 tma_lo, s[2:3]
// CHECK: [0x02,0x0e,0xee,0xbe]

s_bcnt0_i32_b64 tma_hi, s[2:3]
// CHECK: [0x02,0x0e,0xef,0xbe]

s_bcnt0_i32_b64 ttmp11, s[2:3]
// CHECK: [0x02,0x0e,0xfb,0xbe]

s_bcnt0_i32_b64 m0, s[2:3]
// CHECK: [0x02,0x0e,0xfc,0xbe]

s_bcnt0_i32_b64 exec_lo, s[2:3]
// CHECK: [0x02,0x0e,0xfe,0xbe]

s_bcnt0_i32_b64 exec_hi, s[2:3]
// CHECK: [0x02,0x0e,0xff,0xbe]

s_bcnt0_i32_b64 s5, s[4:5]
// CHECK: [0x04,0x0e,0x85,0xbe]

s_bcnt0_i32_b64 s5, s[102:103]
// CHECK: [0x66,0x0e,0x85,0xbe]

s_bcnt0_i32_b64 s5, flat_scratch
// CHECK: [0x68,0x0e,0x85,0xbe]

s_bcnt0_i32_b64 s5, vcc
// CHECK: [0x6a,0x0e,0x85,0xbe]

s_bcnt0_i32_b64 s5, tba
// CHECK: [0x6c,0x0e,0x85,0xbe]

s_bcnt0_i32_b64 s5, tma
// CHECK: [0x6e,0x0e,0x85,0xbe]

s_bcnt0_i32_b64 s5, ttmp[10:11]
// CHECK: [0x7a,0x0e,0x85,0xbe]

s_bcnt0_i32_b64 s5, exec
// CHECK: [0x7e,0x0e,0x85,0xbe]

s_bcnt0_i32_b64 s5, 0
// CHECK: [0x80,0x0e,0x85,0xbe]

s_bcnt0_i32_b64 s5, -1
// CHECK: [0xc1,0x0e,0x85,0xbe]

s_bcnt0_i32_b64 s5, 0.5
// CHECK: [0xf0,0x0e,0x85,0xbe]

s_bcnt0_i32_b64 s5, -4.0
// CHECK: [0xf7,0x0e,0x85,0xbe]

s_bcnt0_i32_b64 s5, 0xaf123456
// CHECK: [0xff,0x0e,0x85,0xbe,0x56,0x34,0x12,0xaf]

s_bcnt0_i32_b64 s5, 0x3f717273
// CHECK: [0xff,0x0e,0x85,0xbe,0x73,0x72,0x71,0x3f]

s_bcnt1_i32_b32 s5, s1
// CHECK: [0x01,0x0f,0x85,0xbe]

s_bcnt1_i32_b32 s103, s1
// CHECK: [0x01,0x0f,0xe7,0xbe]

s_bcnt1_i32_b32 flat_scratch_lo, s1
// CHECK: [0x01,0x0f,0xe8,0xbe]

s_bcnt1_i32_b32 flat_scratch_hi, s1
// CHECK: [0x01,0x0f,0xe9,0xbe]

s_bcnt1_i32_b32 vcc_lo, s1
// CHECK: [0x01,0x0f,0xea,0xbe]

s_bcnt1_i32_b32 vcc_hi, s1
// CHECK: [0x01,0x0f,0xeb,0xbe]

s_bcnt1_i32_b32 tba_lo, s1
// CHECK: [0x01,0x0f,0xec,0xbe]

s_bcnt1_i32_b32 tba_hi, s1
// CHECK: [0x01,0x0f,0xed,0xbe]

s_bcnt1_i32_b32 tma_lo, s1
// CHECK: [0x01,0x0f,0xee,0xbe]

s_bcnt1_i32_b32 tma_hi, s1
// CHECK: [0x01,0x0f,0xef,0xbe]

s_bcnt1_i32_b32 ttmp11, s1
// CHECK: [0x01,0x0f,0xfb,0xbe]

s_bcnt1_i32_b32 m0, s1
// CHECK: [0x01,0x0f,0xfc,0xbe]

s_bcnt1_i32_b32 exec_lo, s1
// CHECK: [0x01,0x0f,0xfe,0xbe]

s_bcnt1_i32_b32 exec_hi, s1
// CHECK: [0x01,0x0f,0xff,0xbe]

s_bcnt1_i32_b32 s5, s103
// CHECK: [0x67,0x0f,0x85,0xbe]

s_bcnt1_i32_b32 s5, flat_scratch_lo
// CHECK: [0x68,0x0f,0x85,0xbe]

s_bcnt1_i32_b32 s5, flat_scratch_hi
// CHECK: [0x69,0x0f,0x85,0xbe]

s_bcnt1_i32_b32 s5, vcc_lo
// CHECK: [0x6a,0x0f,0x85,0xbe]

s_bcnt1_i32_b32 s5, vcc_hi
// CHECK: [0x6b,0x0f,0x85,0xbe]

s_bcnt1_i32_b32 s5, tba_lo
// CHECK: [0x6c,0x0f,0x85,0xbe]

s_bcnt1_i32_b32 s5, tba_hi
// CHECK: [0x6d,0x0f,0x85,0xbe]

s_bcnt1_i32_b32 s5, tma_lo
// CHECK: [0x6e,0x0f,0x85,0xbe]

s_bcnt1_i32_b32 s5, tma_hi
// CHECK: [0x6f,0x0f,0x85,0xbe]

s_bcnt1_i32_b32 s5, ttmp11
// CHECK: [0x7b,0x0f,0x85,0xbe]

s_bcnt1_i32_b32 s5, m0
// CHECK: [0x7c,0x0f,0x85,0xbe]

s_bcnt1_i32_b32 s5, exec_lo
// CHECK: [0x7e,0x0f,0x85,0xbe]

s_bcnt1_i32_b32 s5, exec_hi
// CHECK: [0x7f,0x0f,0x85,0xbe]

s_bcnt1_i32_b32 s5, 0
// CHECK: [0x80,0x0f,0x85,0xbe]

s_bcnt1_i32_b32 s5, -1
// CHECK: [0xc1,0x0f,0x85,0xbe]

s_bcnt1_i32_b32 s5, 0.5
// CHECK: [0xf0,0x0f,0x85,0xbe]

s_bcnt1_i32_b32 s5, -4.0
// CHECK: [0xf7,0x0f,0x85,0xbe]

s_bcnt1_i32_b32 s5, 0xaf123456
// CHECK: [0xff,0x0f,0x85,0xbe,0x56,0x34,0x12,0xaf]

s_bcnt1_i32_b32 s5, 0x3f717273
// CHECK: [0xff,0x0f,0x85,0xbe,0x73,0x72,0x71,0x3f]

s_bcnt1_i32_b64 s5, s[2:3]
// CHECK: [0x02,0x10,0x85,0xbe]

s_bcnt1_i32_b64 s103, s[2:3]
// CHECK: [0x02,0x10,0xe7,0xbe]

s_bcnt1_i32_b64 flat_scratch_lo, s[2:3]
// CHECK: [0x02,0x10,0xe8,0xbe]

s_bcnt1_i32_b64 flat_scratch_hi, s[2:3]
// CHECK: [0x02,0x10,0xe9,0xbe]

s_bcnt1_i32_b64 vcc_lo, s[2:3]
// CHECK: [0x02,0x10,0xea,0xbe]

s_bcnt1_i32_b64 vcc_hi, s[2:3]
// CHECK: [0x02,0x10,0xeb,0xbe]

s_bcnt1_i32_b64 tba_lo, s[2:3]
// CHECK: [0x02,0x10,0xec,0xbe]

s_bcnt1_i32_b64 tba_hi, s[2:3]
// CHECK: [0x02,0x10,0xed,0xbe]

s_bcnt1_i32_b64 tma_lo, s[2:3]
// CHECK: [0x02,0x10,0xee,0xbe]

s_bcnt1_i32_b64 tma_hi, s[2:3]
// CHECK: [0x02,0x10,0xef,0xbe]

s_bcnt1_i32_b64 ttmp11, s[2:3]
// CHECK: [0x02,0x10,0xfb,0xbe]

s_bcnt1_i32_b64 m0, s[2:3]
// CHECK: [0x02,0x10,0xfc,0xbe]

s_bcnt1_i32_b64 exec_lo, s[2:3]
// CHECK: [0x02,0x10,0xfe,0xbe]

s_bcnt1_i32_b64 exec_hi, s[2:3]
// CHECK: [0x02,0x10,0xff,0xbe]

s_bcnt1_i32_b64 s5, s[4:5]
// CHECK: [0x04,0x10,0x85,0xbe]

s_bcnt1_i32_b64 s5, s[102:103]
// CHECK: [0x66,0x10,0x85,0xbe]

s_bcnt1_i32_b64 s5, flat_scratch
// CHECK: [0x68,0x10,0x85,0xbe]

s_bcnt1_i32_b64 s5, vcc
// CHECK: [0x6a,0x10,0x85,0xbe]

s_bcnt1_i32_b64 s5, tba
// CHECK: [0x6c,0x10,0x85,0xbe]

s_bcnt1_i32_b64 s5, tma
// CHECK: [0x6e,0x10,0x85,0xbe]

s_bcnt1_i32_b64 s5, ttmp[10:11]
// CHECK: [0x7a,0x10,0x85,0xbe]

s_bcnt1_i32_b64 s5, exec
// CHECK: [0x7e,0x10,0x85,0xbe]

s_bcnt1_i32_b64 s5, 0
// CHECK: [0x80,0x10,0x85,0xbe]

s_bcnt1_i32_b64 s5, -1
// CHECK: [0xc1,0x10,0x85,0xbe]

s_bcnt1_i32_b64 s5, 0.5
// CHECK: [0xf0,0x10,0x85,0xbe]

s_bcnt1_i32_b64 s5, -4.0
// CHECK: [0xf7,0x10,0x85,0xbe]

s_bcnt1_i32_b64 s5, 0xaf123456
// CHECK: [0xff,0x10,0x85,0xbe,0x56,0x34,0x12,0xaf]

s_bcnt1_i32_b64 s5, 0x3f717273
// CHECK: [0xff,0x10,0x85,0xbe,0x73,0x72,0x71,0x3f]

s_ff0_i32_b32 s5, s1
// CHECK: [0x01,0x11,0x85,0xbe]

s_ff0_i32_b32 s103, s1
// CHECK: [0x01,0x11,0xe7,0xbe]

s_ff0_i32_b32 flat_scratch_lo, s1
// CHECK: [0x01,0x11,0xe8,0xbe]

s_ff0_i32_b32 flat_scratch_hi, s1
// CHECK: [0x01,0x11,0xe9,0xbe]

s_ff0_i32_b32 vcc_lo, s1
// CHECK: [0x01,0x11,0xea,0xbe]

s_ff0_i32_b32 vcc_hi, s1
// CHECK: [0x01,0x11,0xeb,0xbe]

s_ff0_i32_b32 tba_lo, s1
// CHECK: [0x01,0x11,0xec,0xbe]

s_ff0_i32_b32 tba_hi, s1
// CHECK: [0x01,0x11,0xed,0xbe]

s_ff0_i32_b32 tma_lo, s1
// CHECK: [0x01,0x11,0xee,0xbe]

s_ff0_i32_b32 tma_hi, s1
// CHECK: [0x01,0x11,0xef,0xbe]

s_ff0_i32_b32 ttmp11, s1
// CHECK: [0x01,0x11,0xfb,0xbe]

s_ff0_i32_b32 m0, s1
// CHECK: [0x01,0x11,0xfc,0xbe]

s_ff0_i32_b32 exec_lo, s1
// CHECK: [0x01,0x11,0xfe,0xbe]

s_ff0_i32_b32 exec_hi, s1
// CHECK: [0x01,0x11,0xff,0xbe]

s_ff0_i32_b32 s5, s103
// CHECK: [0x67,0x11,0x85,0xbe]

s_ff0_i32_b32 s5, flat_scratch_lo
// CHECK: [0x68,0x11,0x85,0xbe]

s_ff0_i32_b32 s5, flat_scratch_hi
// CHECK: [0x69,0x11,0x85,0xbe]

s_ff0_i32_b32 s5, vcc_lo
// CHECK: [0x6a,0x11,0x85,0xbe]

s_ff0_i32_b32 s5, vcc_hi
// CHECK: [0x6b,0x11,0x85,0xbe]

s_ff0_i32_b32 s5, tba_lo
// CHECK: [0x6c,0x11,0x85,0xbe]

s_ff0_i32_b32 s5, tba_hi
// CHECK: [0x6d,0x11,0x85,0xbe]

s_ff0_i32_b32 s5, tma_lo
// CHECK: [0x6e,0x11,0x85,0xbe]

s_ff0_i32_b32 s5, tma_hi
// CHECK: [0x6f,0x11,0x85,0xbe]

s_ff0_i32_b32 s5, ttmp11
// CHECK: [0x7b,0x11,0x85,0xbe]

s_ff0_i32_b32 s5, m0
// CHECK: [0x7c,0x11,0x85,0xbe]

s_ff0_i32_b32 s5, exec_lo
// CHECK: [0x7e,0x11,0x85,0xbe]

s_ff0_i32_b32 s5, exec_hi
// CHECK: [0x7f,0x11,0x85,0xbe]

s_ff0_i32_b32 s5, 0
// CHECK: [0x80,0x11,0x85,0xbe]

s_ff0_i32_b32 s5, -1
// CHECK: [0xc1,0x11,0x85,0xbe]

s_ff0_i32_b32 s5, 0.5
// CHECK: [0xf0,0x11,0x85,0xbe]

s_ff0_i32_b32 s5, -4.0
// CHECK: [0xf7,0x11,0x85,0xbe]

s_ff0_i32_b32 s5, 0xaf123456
// CHECK: [0xff,0x11,0x85,0xbe,0x56,0x34,0x12,0xaf]

s_ff0_i32_b32 s5, 0x3f717273
// CHECK: [0xff,0x11,0x85,0xbe,0x73,0x72,0x71,0x3f]

s_ff0_i32_b64 s5, s[2:3]
// CHECK: [0x02,0x12,0x85,0xbe]

s_ff0_i32_b64 s103, s[2:3]
// CHECK: [0x02,0x12,0xe7,0xbe]

s_ff0_i32_b64 flat_scratch_lo, s[2:3]
// CHECK: [0x02,0x12,0xe8,0xbe]

s_ff0_i32_b64 flat_scratch_hi, s[2:3]
// CHECK: [0x02,0x12,0xe9,0xbe]

s_ff0_i32_b64 vcc_lo, s[2:3]
// CHECK: [0x02,0x12,0xea,0xbe]

s_ff0_i32_b64 vcc_hi, s[2:3]
// CHECK: [0x02,0x12,0xeb,0xbe]

s_ff0_i32_b64 tba_lo, s[2:3]
// CHECK: [0x02,0x12,0xec,0xbe]

s_ff0_i32_b64 tba_hi, s[2:3]
// CHECK: [0x02,0x12,0xed,0xbe]

s_ff0_i32_b64 tma_lo, s[2:3]
// CHECK: [0x02,0x12,0xee,0xbe]

s_ff0_i32_b64 tma_hi, s[2:3]
// CHECK: [0x02,0x12,0xef,0xbe]

s_ff0_i32_b64 ttmp11, s[2:3]
// CHECK: [0x02,0x12,0xfb,0xbe]

s_ff0_i32_b64 m0, s[2:3]
// CHECK: [0x02,0x12,0xfc,0xbe]

s_ff0_i32_b64 exec_lo, s[2:3]
// CHECK: [0x02,0x12,0xfe,0xbe]

s_ff0_i32_b64 exec_hi, s[2:3]
// CHECK: [0x02,0x12,0xff,0xbe]

s_ff0_i32_b64 s5, s[4:5]
// CHECK: [0x04,0x12,0x85,0xbe]

s_ff0_i32_b64 s5, s[102:103]
// CHECK: [0x66,0x12,0x85,0xbe]

s_ff0_i32_b64 s5, flat_scratch
// CHECK: [0x68,0x12,0x85,0xbe]

s_ff0_i32_b64 s5, vcc
// CHECK: [0x6a,0x12,0x85,0xbe]

s_ff0_i32_b64 s5, tba
// CHECK: [0x6c,0x12,0x85,0xbe]

s_ff0_i32_b64 s5, tma
// CHECK: [0x6e,0x12,0x85,0xbe]

s_ff0_i32_b64 s5, ttmp[10:11]
// CHECK: [0x7a,0x12,0x85,0xbe]

s_ff0_i32_b64 s5, exec
// CHECK: [0x7e,0x12,0x85,0xbe]

s_ff0_i32_b64 s5, 0
// CHECK: [0x80,0x12,0x85,0xbe]

s_ff0_i32_b64 s5, -1
// CHECK: [0xc1,0x12,0x85,0xbe]

s_ff0_i32_b64 s5, 0.5
// CHECK: [0xf0,0x12,0x85,0xbe]

s_ff0_i32_b64 s5, -4.0
// CHECK: [0xf7,0x12,0x85,0xbe]

s_ff0_i32_b64 s5, 0xaf123456
// CHECK: [0xff,0x12,0x85,0xbe,0x56,0x34,0x12,0xaf]

s_ff0_i32_b64 s5, 0x3f717273
// CHECK: [0xff,0x12,0x85,0xbe,0x73,0x72,0x71,0x3f]

s_ff1_i32_b32 s5, s1
// CHECK: [0x01,0x13,0x85,0xbe]

s_ff1_i32_b32 s103, s1
// CHECK: [0x01,0x13,0xe7,0xbe]

s_ff1_i32_b32 flat_scratch_lo, s1
// CHECK: [0x01,0x13,0xe8,0xbe]

s_ff1_i32_b32 flat_scratch_hi, s1
// CHECK: [0x01,0x13,0xe9,0xbe]

s_ff1_i32_b32 vcc_lo, s1
// CHECK: [0x01,0x13,0xea,0xbe]

s_ff1_i32_b32 vcc_hi, s1
// CHECK: [0x01,0x13,0xeb,0xbe]

s_ff1_i32_b32 tba_lo, s1
// CHECK: [0x01,0x13,0xec,0xbe]

s_ff1_i32_b32 tba_hi, s1
// CHECK: [0x01,0x13,0xed,0xbe]

s_ff1_i32_b32 tma_lo, s1
// CHECK: [0x01,0x13,0xee,0xbe]

s_ff1_i32_b32 tma_hi, s1
// CHECK: [0x01,0x13,0xef,0xbe]

s_ff1_i32_b32 ttmp11, s1
// CHECK: [0x01,0x13,0xfb,0xbe]

s_ff1_i32_b32 m0, s1
// CHECK: [0x01,0x13,0xfc,0xbe]

s_ff1_i32_b32 exec_lo, s1
// CHECK: [0x01,0x13,0xfe,0xbe]

s_ff1_i32_b32 exec_hi, s1
// CHECK: [0x01,0x13,0xff,0xbe]

s_ff1_i32_b32 s5, s103
// CHECK: [0x67,0x13,0x85,0xbe]

s_ff1_i32_b32 s5, flat_scratch_lo
// CHECK: [0x68,0x13,0x85,0xbe]

s_ff1_i32_b32 s5, flat_scratch_hi
// CHECK: [0x69,0x13,0x85,0xbe]

s_ff1_i32_b32 s5, vcc_lo
// CHECK: [0x6a,0x13,0x85,0xbe]

s_ff1_i32_b32 s5, vcc_hi
// CHECK: [0x6b,0x13,0x85,0xbe]

s_ff1_i32_b32 s5, tba_lo
// CHECK: [0x6c,0x13,0x85,0xbe]

s_ff1_i32_b32 s5, tba_hi
// CHECK: [0x6d,0x13,0x85,0xbe]

s_ff1_i32_b32 s5, tma_lo
// CHECK: [0x6e,0x13,0x85,0xbe]

s_ff1_i32_b32 s5, tma_hi
// CHECK: [0x6f,0x13,0x85,0xbe]

s_ff1_i32_b32 s5, ttmp11
// CHECK: [0x7b,0x13,0x85,0xbe]

s_ff1_i32_b32 s5, m0
// CHECK: [0x7c,0x13,0x85,0xbe]

s_ff1_i32_b32 s5, exec_lo
// CHECK: [0x7e,0x13,0x85,0xbe]

s_ff1_i32_b32 s5, exec_hi
// CHECK: [0x7f,0x13,0x85,0xbe]

s_ff1_i32_b32 s5, 0
// CHECK: [0x80,0x13,0x85,0xbe]

s_ff1_i32_b32 s5, -1
// CHECK: [0xc1,0x13,0x85,0xbe]

s_ff1_i32_b32 s5, 0.5
// CHECK: [0xf0,0x13,0x85,0xbe]

s_ff1_i32_b32 s5, -4.0
// CHECK: [0xf7,0x13,0x85,0xbe]

s_ff1_i32_b32 s5, 0xaf123456
// CHECK: [0xff,0x13,0x85,0xbe,0x56,0x34,0x12,0xaf]

s_ff1_i32_b32 s5, 0x3f717273
// CHECK: [0xff,0x13,0x85,0xbe,0x73,0x72,0x71,0x3f]

s_ff1_i32_b64 s5, s[2:3]
// CHECK: [0x02,0x14,0x85,0xbe]

s_ff1_i32_b64 s103, s[2:3]
// CHECK: [0x02,0x14,0xe7,0xbe]

s_ff1_i32_b64 flat_scratch_lo, s[2:3]
// CHECK: [0x02,0x14,0xe8,0xbe]

s_ff1_i32_b64 flat_scratch_hi, s[2:3]
// CHECK: [0x02,0x14,0xe9,0xbe]

s_ff1_i32_b64 vcc_lo, s[2:3]
// CHECK: [0x02,0x14,0xea,0xbe]

s_ff1_i32_b64 vcc_hi, s[2:3]
// CHECK: [0x02,0x14,0xeb,0xbe]

s_ff1_i32_b64 tba_lo, s[2:3]
// CHECK: [0x02,0x14,0xec,0xbe]

s_ff1_i32_b64 tba_hi, s[2:3]
// CHECK: [0x02,0x14,0xed,0xbe]

s_ff1_i32_b64 tma_lo, s[2:3]
// CHECK: [0x02,0x14,0xee,0xbe]

s_ff1_i32_b64 tma_hi, s[2:3]
// CHECK: [0x02,0x14,0xef,0xbe]

s_ff1_i32_b64 ttmp11, s[2:3]
// CHECK: [0x02,0x14,0xfb,0xbe]

s_ff1_i32_b64 m0, s[2:3]
// CHECK: [0x02,0x14,0xfc,0xbe]

s_ff1_i32_b64 exec_lo, s[2:3]
// CHECK: [0x02,0x14,0xfe,0xbe]

s_ff1_i32_b64 exec_hi, s[2:3]
// CHECK: [0x02,0x14,0xff,0xbe]

s_ff1_i32_b64 s5, s[4:5]
// CHECK: [0x04,0x14,0x85,0xbe]

s_ff1_i32_b64 s5, s[102:103]
// CHECK: [0x66,0x14,0x85,0xbe]

s_ff1_i32_b64 s5, flat_scratch
// CHECK: [0x68,0x14,0x85,0xbe]

s_ff1_i32_b64 s5, vcc
// CHECK: [0x6a,0x14,0x85,0xbe]

s_ff1_i32_b64 s5, tba
// CHECK: [0x6c,0x14,0x85,0xbe]

s_ff1_i32_b64 s5, tma
// CHECK: [0x6e,0x14,0x85,0xbe]

s_ff1_i32_b64 s5, ttmp[10:11]
// CHECK: [0x7a,0x14,0x85,0xbe]

s_ff1_i32_b64 s5, exec
// CHECK: [0x7e,0x14,0x85,0xbe]

s_ff1_i32_b64 s5, 0
// CHECK: [0x80,0x14,0x85,0xbe]

s_ff1_i32_b64 s5, -1
// CHECK: [0xc1,0x14,0x85,0xbe]

s_ff1_i32_b64 s5, 0.5
// CHECK: [0xf0,0x14,0x85,0xbe]

s_ff1_i32_b64 s5, -4.0
// CHECK: [0xf7,0x14,0x85,0xbe]

s_ff1_i32_b64 s5, 0xaf123456
// CHECK: [0xff,0x14,0x85,0xbe,0x56,0x34,0x12,0xaf]

s_ff1_i32_b64 s5, 0x3f717273
// CHECK: [0xff,0x14,0x85,0xbe,0x73,0x72,0x71,0x3f]

s_flbit_i32_b32 s5, s1
// CHECK: [0x01,0x15,0x85,0xbe]

s_flbit_i32_b32 s103, s1
// CHECK: [0x01,0x15,0xe7,0xbe]

s_flbit_i32_b32 flat_scratch_lo, s1
// CHECK: [0x01,0x15,0xe8,0xbe]

s_flbit_i32_b32 flat_scratch_hi, s1
// CHECK: [0x01,0x15,0xe9,0xbe]

s_flbit_i32_b32 vcc_lo, s1
// CHECK: [0x01,0x15,0xea,0xbe]

s_flbit_i32_b32 vcc_hi, s1
// CHECK: [0x01,0x15,0xeb,0xbe]

s_flbit_i32_b32 tba_lo, s1
// CHECK: [0x01,0x15,0xec,0xbe]

s_flbit_i32_b32 tba_hi, s1
// CHECK: [0x01,0x15,0xed,0xbe]

s_flbit_i32_b32 tma_lo, s1
// CHECK: [0x01,0x15,0xee,0xbe]

s_flbit_i32_b32 tma_hi, s1
// CHECK: [0x01,0x15,0xef,0xbe]

s_flbit_i32_b32 ttmp11, s1
// CHECK: [0x01,0x15,0xfb,0xbe]

s_flbit_i32_b32 m0, s1
// CHECK: [0x01,0x15,0xfc,0xbe]

s_flbit_i32_b32 exec_lo, s1
// CHECK: [0x01,0x15,0xfe,0xbe]

s_flbit_i32_b32 exec_hi, s1
// CHECK: [0x01,0x15,0xff,0xbe]

s_flbit_i32_b32 s5, s103
// CHECK: [0x67,0x15,0x85,0xbe]

s_flbit_i32_b32 s5, flat_scratch_lo
// CHECK: [0x68,0x15,0x85,0xbe]

s_flbit_i32_b32 s5, flat_scratch_hi
// CHECK: [0x69,0x15,0x85,0xbe]

s_flbit_i32_b32 s5, vcc_lo
// CHECK: [0x6a,0x15,0x85,0xbe]

s_flbit_i32_b32 s5, vcc_hi
// CHECK: [0x6b,0x15,0x85,0xbe]

s_flbit_i32_b32 s5, tba_lo
// CHECK: [0x6c,0x15,0x85,0xbe]

s_flbit_i32_b32 s5, tba_hi
// CHECK: [0x6d,0x15,0x85,0xbe]

s_flbit_i32_b32 s5, tma_lo
// CHECK: [0x6e,0x15,0x85,0xbe]

s_flbit_i32_b32 s5, tma_hi
// CHECK: [0x6f,0x15,0x85,0xbe]

s_flbit_i32_b32 s5, ttmp11
// CHECK: [0x7b,0x15,0x85,0xbe]

s_flbit_i32_b32 s5, m0
// CHECK: [0x7c,0x15,0x85,0xbe]

s_flbit_i32_b32 s5, exec_lo
// CHECK: [0x7e,0x15,0x85,0xbe]

s_flbit_i32_b32 s5, exec_hi
// CHECK: [0x7f,0x15,0x85,0xbe]

s_flbit_i32_b32 s5, 0
// CHECK: [0x80,0x15,0x85,0xbe]

s_flbit_i32_b32 s5, -1
// CHECK: [0xc1,0x15,0x85,0xbe]

s_flbit_i32_b32 s5, 0.5
// CHECK: [0xf0,0x15,0x85,0xbe]

s_flbit_i32_b32 s5, -4.0
// CHECK: [0xf7,0x15,0x85,0xbe]

s_flbit_i32_b32 s5, 0xaf123456
// CHECK: [0xff,0x15,0x85,0xbe,0x56,0x34,0x12,0xaf]

s_flbit_i32_b32 s5, 0x3f717273
// CHECK: [0xff,0x15,0x85,0xbe,0x73,0x72,0x71,0x3f]

s_flbit_i32_b64 s5, s[2:3]
// CHECK: [0x02,0x16,0x85,0xbe]

s_flbit_i32_b64 s103, s[2:3]
// CHECK: [0x02,0x16,0xe7,0xbe]

s_flbit_i32_b64 flat_scratch_lo, s[2:3]
// CHECK: [0x02,0x16,0xe8,0xbe]

s_flbit_i32_b64 flat_scratch_hi, s[2:3]
// CHECK: [0x02,0x16,0xe9,0xbe]

s_flbit_i32_b64 vcc_lo, s[2:3]
// CHECK: [0x02,0x16,0xea,0xbe]

s_flbit_i32_b64 vcc_hi, s[2:3]
// CHECK: [0x02,0x16,0xeb,0xbe]

s_flbit_i32_b64 tba_lo, s[2:3]
// CHECK: [0x02,0x16,0xec,0xbe]

s_flbit_i32_b64 tba_hi, s[2:3]
// CHECK: [0x02,0x16,0xed,0xbe]

s_flbit_i32_b64 tma_lo, s[2:3]
// CHECK: [0x02,0x16,0xee,0xbe]

s_flbit_i32_b64 tma_hi, s[2:3]
// CHECK: [0x02,0x16,0xef,0xbe]

s_flbit_i32_b64 ttmp11, s[2:3]
// CHECK: [0x02,0x16,0xfb,0xbe]

s_flbit_i32_b64 m0, s[2:3]
// CHECK: [0x02,0x16,0xfc,0xbe]

s_flbit_i32_b64 exec_lo, s[2:3]
// CHECK: [0x02,0x16,0xfe,0xbe]

s_flbit_i32_b64 exec_hi, s[2:3]
// CHECK: [0x02,0x16,0xff,0xbe]

s_flbit_i32_b64 s5, s[4:5]
// CHECK: [0x04,0x16,0x85,0xbe]

s_flbit_i32_b64 s5, s[102:103]
// CHECK: [0x66,0x16,0x85,0xbe]

s_flbit_i32_b64 s5, flat_scratch
// CHECK: [0x68,0x16,0x85,0xbe]

s_flbit_i32_b64 s5, vcc
// CHECK: [0x6a,0x16,0x85,0xbe]

s_flbit_i32_b64 s5, tba
// CHECK: [0x6c,0x16,0x85,0xbe]

s_flbit_i32_b64 s5, tma
// CHECK: [0x6e,0x16,0x85,0xbe]

s_flbit_i32_b64 s5, ttmp[10:11]
// CHECK: [0x7a,0x16,0x85,0xbe]

s_flbit_i32_b64 s5, exec
// CHECK: [0x7e,0x16,0x85,0xbe]

s_flbit_i32_b64 s5, 0
// CHECK: [0x80,0x16,0x85,0xbe]

s_flbit_i32_b64 s5, -1
// CHECK: [0xc1,0x16,0x85,0xbe]

s_flbit_i32_b64 s5, 0.5
// CHECK: [0xf0,0x16,0x85,0xbe]

s_flbit_i32_b64 s5, -4.0
// CHECK: [0xf7,0x16,0x85,0xbe]

s_flbit_i32_b64 s5, 0xaf123456
// CHECK: [0xff,0x16,0x85,0xbe,0x56,0x34,0x12,0xaf]

s_flbit_i32_b64 s5, 0x3f717273
// CHECK: [0xff,0x16,0x85,0xbe,0x73,0x72,0x71,0x3f]

s_flbit_i32 s5, s1
// CHECK: [0x01,0x17,0x85,0xbe]

s_flbit_i32 s103, s1
// CHECK: [0x01,0x17,0xe7,0xbe]

s_flbit_i32 flat_scratch_lo, s1
// CHECK: [0x01,0x17,0xe8,0xbe]

s_flbit_i32 flat_scratch_hi, s1
// CHECK: [0x01,0x17,0xe9,0xbe]

s_flbit_i32 vcc_lo, s1
// CHECK: [0x01,0x17,0xea,0xbe]

s_flbit_i32 vcc_hi, s1
// CHECK: [0x01,0x17,0xeb,0xbe]

s_flbit_i32 tba_lo, s1
// CHECK: [0x01,0x17,0xec,0xbe]

s_flbit_i32 tba_hi, s1
// CHECK: [0x01,0x17,0xed,0xbe]

s_flbit_i32 tma_lo, s1
// CHECK: [0x01,0x17,0xee,0xbe]

s_flbit_i32 tma_hi, s1
// CHECK: [0x01,0x17,0xef,0xbe]

s_flbit_i32 ttmp11, s1
// CHECK: [0x01,0x17,0xfb,0xbe]

s_flbit_i32 m0, s1
// CHECK: [0x01,0x17,0xfc,0xbe]

s_flbit_i32 exec_lo, s1
// CHECK: [0x01,0x17,0xfe,0xbe]

s_flbit_i32 exec_hi, s1
// CHECK: [0x01,0x17,0xff,0xbe]

s_flbit_i32 s5, s103
// CHECK: [0x67,0x17,0x85,0xbe]

s_flbit_i32 s5, flat_scratch_lo
// CHECK: [0x68,0x17,0x85,0xbe]

s_flbit_i32 s5, flat_scratch_hi
// CHECK: [0x69,0x17,0x85,0xbe]

s_flbit_i32 s5, vcc_lo
// CHECK: [0x6a,0x17,0x85,0xbe]

s_flbit_i32 s5, vcc_hi
// CHECK: [0x6b,0x17,0x85,0xbe]

s_flbit_i32 s5, tba_lo
// CHECK: [0x6c,0x17,0x85,0xbe]

s_flbit_i32 s5, tba_hi
// CHECK: [0x6d,0x17,0x85,0xbe]

s_flbit_i32 s5, tma_lo
// CHECK: [0x6e,0x17,0x85,0xbe]

s_flbit_i32 s5, tma_hi
// CHECK: [0x6f,0x17,0x85,0xbe]

s_flbit_i32 s5, ttmp11
// CHECK: [0x7b,0x17,0x85,0xbe]

s_flbit_i32 s5, m0
// CHECK: [0x7c,0x17,0x85,0xbe]

s_flbit_i32 s5, exec_lo
// CHECK: [0x7e,0x17,0x85,0xbe]

s_flbit_i32 s5, exec_hi
// CHECK: [0x7f,0x17,0x85,0xbe]

s_flbit_i32 s5, 0
// CHECK: [0x80,0x17,0x85,0xbe]

s_flbit_i32 s5, -1
// CHECK: [0xc1,0x17,0x85,0xbe]

s_flbit_i32 s5, 0.5
// CHECK: [0xf0,0x17,0x85,0xbe]

s_flbit_i32 s5, -4.0
// CHECK: [0xf7,0x17,0x85,0xbe]

s_flbit_i32 s5, 0xaf123456
// CHECK: [0xff,0x17,0x85,0xbe,0x56,0x34,0x12,0xaf]

s_flbit_i32 s5, 0x3f717273
// CHECK: [0xff,0x17,0x85,0xbe,0x73,0x72,0x71,0x3f]

s_flbit_i32_i64 s5, s[2:3]
// CHECK: [0x02,0x18,0x85,0xbe]

s_flbit_i32_i64 s103, s[2:3]
// CHECK: [0x02,0x18,0xe7,0xbe]

s_flbit_i32_i64 flat_scratch_lo, s[2:3]
// CHECK: [0x02,0x18,0xe8,0xbe]

s_flbit_i32_i64 flat_scratch_hi, s[2:3]
// CHECK: [0x02,0x18,0xe9,0xbe]

s_flbit_i32_i64 vcc_lo, s[2:3]
// CHECK: [0x02,0x18,0xea,0xbe]

s_flbit_i32_i64 vcc_hi, s[2:3]
// CHECK: [0x02,0x18,0xeb,0xbe]

s_flbit_i32_i64 tba_lo, s[2:3]
// CHECK: [0x02,0x18,0xec,0xbe]

s_flbit_i32_i64 tba_hi, s[2:3]
// CHECK: [0x02,0x18,0xed,0xbe]

s_flbit_i32_i64 tma_lo, s[2:3]
// CHECK: [0x02,0x18,0xee,0xbe]

s_flbit_i32_i64 tma_hi, s[2:3]
// CHECK: [0x02,0x18,0xef,0xbe]

s_flbit_i32_i64 ttmp11, s[2:3]
// CHECK: [0x02,0x18,0xfb,0xbe]

s_flbit_i32_i64 m0, s[2:3]
// CHECK: [0x02,0x18,0xfc,0xbe]

s_flbit_i32_i64 exec_lo, s[2:3]
// CHECK: [0x02,0x18,0xfe,0xbe]

s_flbit_i32_i64 exec_hi, s[2:3]
// CHECK: [0x02,0x18,0xff,0xbe]

s_flbit_i32_i64 s5, s[4:5]
// CHECK: [0x04,0x18,0x85,0xbe]

s_flbit_i32_i64 s5, s[102:103]
// CHECK: [0x66,0x18,0x85,0xbe]

s_flbit_i32_i64 s5, flat_scratch
// CHECK: [0x68,0x18,0x85,0xbe]

s_flbit_i32_i64 s5, vcc
// CHECK: [0x6a,0x18,0x85,0xbe]

s_flbit_i32_i64 s5, tba
// CHECK: [0x6c,0x18,0x85,0xbe]

s_flbit_i32_i64 s5, tma
// CHECK: [0x6e,0x18,0x85,0xbe]

s_flbit_i32_i64 s5, ttmp[10:11]
// CHECK: [0x7a,0x18,0x85,0xbe]

s_flbit_i32_i64 s5, exec
// CHECK: [0x7e,0x18,0x85,0xbe]

s_flbit_i32_i64 s5, 0
// CHECK: [0x80,0x18,0x85,0xbe]

s_flbit_i32_i64 s5, -1
// CHECK: [0xc1,0x18,0x85,0xbe]

s_flbit_i32_i64 s5, 0.5
// CHECK: [0xf0,0x18,0x85,0xbe]

s_flbit_i32_i64 s5, -4.0
// CHECK: [0xf7,0x18,0x85,0xbe]

s_flbit_i32_i64 s5, 0xaf123456
// CHECK: [0xff,0x18,0x85,0xbe,0x56,0x34,0x12,0xaf]

s_flbit_i32_i64 s5, 0x3f717273
// CHECK: [0xff,0x18,0x85,0xbe,0x73,0x72,0x71,0x3f]

s_sext_i32_i8 s5, s1
// CHECK: [0x01,0x19,0x85,0xbe]

s_sext_i32_i8 s103, s1
// CHECK: [0x01,0x19,0xe7,0xbe]

s_sext_i32_i8 flat_scratch_lo, s1
// CHECK: [0x01,0x19,0xe8,0xbe]

s_sext_i32_i8 flat_scratch_hi, s1
// CHECK: [0x01,0x19,0xe9,0xbe]

s_sext_i32_i8 vcc_lo, s1
// CHECK: [0x01,0x19,0xea,0xbe]

s_sext_i32_i8 vcc_hi, s1
// CHECK: [0x01,0x19,0xeb,0xbe]

s_sext_i32_i8 tba_lo, s1
// CHECK: [0x01,0x19,0xec,0xbe]

s_sext_i32_i8 tba_hi, s1
// CHECK: [0x01,0x19,0xed,0xbe]

s_sext_i32_i8 tma_lo, s1
// CHECK: [0x01,0x19,0xee,0xbe]

s_sext_i32_i8 tma_hi, s1
// CHECK: [0x01,0x19,0xef,0xbe]

s_sext_i32_i8 ttmp11, s1
// CHECK: [0x01,0x19,0xfb,0xbe]

s_sext_i32_i8 m0, s1
// CHECK: [0x01,0x19,0xfc,0xbe]

s_sext_i32_i8 exec_lo, s1
// CHECK: [0x01,0x19,0xfe,0xbe]

s_sext_i32_i8 exec_hi, s1
// CHECK: [0x01,0x19,0xff,0xbe]

s_sext_i32_i8 s5, s103
// CHECK: [0x67,0x19,0x85,0xbe]

s_sext_i32_i8 s5, flat_scratch_lo
// CHECK: [0x68,0x19,0x85,0xbe]

s_sext_i32_i8 s5, flat_scratch_hi
// CHECK: [0x69,0x19,0x85,0xbe]

s_sext_i32_i8 s5, vcc_lo
// CHECK: [0x6a,0x19,0x85,0xbe]

s_sext_i32_i8 s5, vcc_hi
// CHECK: [0x6b,0x19,0x85,0xbe]

s_sext_i32_i8 s5, tba_lo
// CHECK: [0x6c,0x19,0x85,0xbe]

s_sext_i32_i8 s5, tba_hi
// CHECK: [0x6d,0x19,0x85,0xbe]

s_sext_i32_i8 s5, tma_lo
// CHECK: [0x6e,0x19,0x85,0xbe]

s_sext_i32_i8 s5, tma_hi
// CHECK: [0x6f,0x19,0x85,0xbe]

s_sext_i32_i8 s5, ttmp11
// CHECK: [0x7b,0x19,0x85,0xbe]

s_sext_i32_i8 s5, m0
// CHECK: [0x7c,0x19,0x85,0xbe]

s_sext_i32_i8 s5, exec_lo
// CHECK: [0x7e,0x19,0x85,0xbe]

s_sext_i32_i8 s5, exec_hi
// CHECK: [0x7f,0x19,0x85,0xbe]

s_sext_i32_i8 s5, 0
// CHECK: [0x80,0x19,0x85,0xbe]

s_sext_i32_i8 s5, -1
// CHECK: [0xc1,0x19,0x85,0xbe]

s_sext_i32_i8 s5, 0x71
// CHECK: [0xff,0x19,0x85,0xbe,0x71,0x00,0x00,0x00]

s_sext_i32_i8 s5, 0xf0
// CHECK: [0xff,0x19,0x85,0xbe,0xf0,0x00,0x00,0x00]

s_sext_i32_i16 s5, s1
// CHECK: [0x01,0x1a,0x85,0xbe]

s_sext_i32_i16 s103, s1
// CHECK: [0x01,0x1a,0xe7,0xbe]

s_sext_i32_i16 flat_scratch_lo, s1
// CHECK: [0x01,0x1a,0xe8,0xbe]

s_sext_i32_i16 flat_scratch_hi, s1
// CHECK: [0x01,0x1a,0xe9,0xbe]

s_sext_i32_i16 vcc_lo, s1
// CHECK: [0x01,0x1a,0xea,0xbe]

s_sext_i32_i16 vcc_hi, s1
// CHECK: [0x01,0x1a,0xeb,0xbe]

s_sext_i32_i16 tba_lo, s1
// CHECK: [0x01,0x1a,0xec,0xbe]

s_sext_i32_i16 tba_hi, s1
// CHECK: [0x01,0x1a,0xed,0xbe]

s_sext_i32_i16 tma_lo, s1
// CHECK: [0x01,0x1a,0xee,0xbe]

s_sext_i32_i16 tma_hi, s1
// CHECK: [0x01,0x1a,0xef,0xbe]

s_sext_i32_i16 ttmp11, s1
// CHECK: [0x01,0x1a,0xfb,0xbe]

s_sext_i32_i16 m0, s1
// CHECK: [0x01,0x1a,0xfc,0xbe]

s_sext_i32_i16 exec_lo, s1
// CHECK: [0x01,0x1a,0xfe,0xbe]

s_sext_i32_i16 exec_hi, s1
// CHECK: [0x01,0x1a,0xff,0xbe]

s_sext_i32_i16 s5, s103
// CHECK: [0x67,0x1a,0x85,0xbe]

s_sext_i32_i16 s5, flat_scratch_lo
// CHECK: [0x68,0x1a,0x85,0xbe]

s_sext_i32_i16 s5, flat_scratch_hi
// CHECK: [0x69,0x1a,0x85,0xbe]

s_sext_i32_i16 s5, vcc_lo
// CHECK: [0x6a,0x1a,0x85,0xbe]

s_sext_i32_i16 s5, vcc_hi
// CHECK: [0x6b,0x1a,0x85,0xbe]

s_sext_i32_i16 s5, tba_lo
// CHECK: [0x6c,0x1a,0x85,0xbe]

s_sext_i32_i16 s5, tba_hi
// CHECK: [0x6d,0x1a,0x85,0xbe]

s_sext_i32_i16 s5, tma_lo
// CHECK: [0x6e,0x1a,0x85,0xbe]

s_sext_i32_i16 s5, tma_hi
// CHECK: [0x6f,0x1a,0x85,0xbe]

s_sext_i32_i16 s5, ttmp11
// CHECK: [0x7b,0x1a,0x85,0xbe]

s_sext_i32_i16 s5, m0
// CHECK: [0x7c,0x1a,0x85,0xbe]

s_sext_i32_i16 s5, exec_lo
// CHECK: [0x7e,0x1a,0x85,0xbe]

s_sext_i32_i16 s5, exec_hi
// CHECK: [0x7f,0x1a,0x85,0xbe]

s_sext_i32_i16 s5, 0
// CHECK: [0x80,0x1a,0x85,0xbe]

s_sext_i32_i16 s5, -1
// CHECK: [0xc1,0x1a,0x85,0xbe]

s_sext_i32_i16 s5, 0xfe0b
// CHECK: [0xff,0x1a,0x85,0xbe,0x0b,0xfe,0x00,0x00]

s_sext_i32_i16 s5, 0x3456
// CHECK: [0xff,0x1a,0x85,0xbe,0x56,0x34,0x00,0x00]

s_bitset0_b32 s5, s1
// CHECK: [0x01,0x1b,0x85,0xbe]

s_bitset0_b32 s103, s1
// CHECK: [0x01,0x1b,0xe7,0xbe]

s_bitset0_b32 flat_scratch_lo, s1
// CHECK: [0x01,0x1b,0xe8,0xbe]

s_bitset0_b32 flat_scratch_hi, s1
// CHECK: [0x01,0x1b,0xe9,0xbe]

s_bitset0_b32 vcc_lo, s1
// CHECK: [0x01,0x1b,0xea,0xbe]

s_bitset0_b32 vcc_hi, s1
// CHECK: [0x01,0x1b,0xeb,0xbe]

s_bitset0_b32 tba_lo, s1
// CHECK: [0x01,0x1b,0xec,0xbe]

s_bitset0_b32 tba_hi, s1
// CHECK: [0x01,0x1b,0xed,0xbe]

s_bitset0_b32 tma_lo, s1
// CHECK: [0x01,0x1b,0xee,0xbe]

s_bitset0_b32 tma_hi, s1
// CHECK: [0x01,0x1b,0xef,0xbe]

s_bitset0_b32 ttmp11, s1
// CHECK: [0x01,0x1b,0xfb,0xbe]

s_bitset0_b32 m0, s1
// CHECK: [0x01,0x1b,0xfc,0xbe]

s_bitset0_b32 exec_lo, s1
// CHECK: [0x01,0x1b,0xfe,0xbe]

s_bitset0_b32 exec_hi, s1
// CHECK: [0x01,0x1b,0xff,0xbe]

s_bitset0_b32 s5, s103
// CHECK: [0x67,0x1b,0x85,0xbe]

s_bitset0_b32 s5, flat_scratch_lo
// CHECK: [0x68,0x1b,0x85,0xbe]

s_bitset0_b32 s5, flat_scratch_hi
// CHECK: [0x69,0x1b,0x85,0xbe]

s_bitset0_b32 s5, vcc_lo
// CHECK: [0x6a,0x1b,0x85,0xbe]

s_bitset0_b32 s5, vcc_hi
// CHECK: [0x6b,0x1b,0x85,0xbe]

s_bitset0_b32 s5, tba_lo
// CHECK: [0x6c,0x1b,0x85,0xbe]

s_bitset0_b32 s5, tba_hi
// CHECK: [0x6d,0x1b,0x85,0xbe]

s_bitset0_b32 s5, tma_lo
// CHECK: [0x6e,0x1b,0x85,0xbe]

s_bitset0_b32 s5, tma_hi
// CHECK: [0x6f,0x1b,0x85,0xbe]

s_bitset0_b32 s5, ttmp11
// CHECK: [0x7b,0x1b,0x85,0xbe]

s_bitset0_b32 s5, m0
// CHECK: [0x7c,0x1b,0x85,0xbe]

s_bitset0_b32 s5, exec_lo
// CHECK: [0x7e,0x1b,0x85,0xbe]

s_bitset0_b32 s5, exec_hi
// CHECK: [0x7f,0x1b,0x85,0xbe]

s_bitset0_b32 s5, 0
// CHECK: [0x80,0x1b,0x85,0xbe]

s_bitset0_b32 s5, -1
// CHECK: [0xc1,0x1b,0x85,0xbe]

s_bitset0_b32 s5, 0.5
// CHECK: [0xf0,0x1b,0x85,0xbe]

s_bitset0_b32 s5, -4.0
// CHECK: [0xf7,0x1b,0x85,0xbe]

s_bitset0_b32 s5, 0xaf123456
// CHECK: [0xff,0x1b,0x85,0xbe,0x56,0x34,0x12,0xaf]

s_bitset0_b32 s5, 0x3f717273
// CHECK: [0xff,0x1b,0x85,0xbe,0x73,0x72,0x71,0x3f]

s_bitset0_b64 s[10:11], s1
// CHECK: [0x01,0x1c,0x8a,0xbe]

s_bitset0_b64 s[12:13], s1
// CHECK: [0x01,0x1c,0x8c,0xbe]

s_bitset0_b64 s[102:103], s1
// CHECK: [0x01,0x1c,0xe6,0xbe]

s_bitset0_b64 flat_scratch, s1
// CHECK: [0x01,0x1c,0xe8,0xbe]

s_bitset0_b64 vcc, s1
// CHECK: [0x01,0x1c,0xea,0xbe]

s_bitset0_b64 tba, s1
// CHECK: [0x01,0x1c,0xec,0xbe]

s_bitset0_b64 tma, s1
// CHECK: [0x01,0x1c,0xee,0xbe]

s_bitset0_b64 ttmp[10:11], s1
// CHECK: [0x01,0x1c,0xfa,0xbe]

s_bitset0_b64 exec, s1
// CHECK: [0x01,0x1c,0xfe,0xbe]

s_bitset0_b64 s[10:11], s103
// CHECK: [0x67,0x1c,0x8a,0xbe]

s_bitset0_b64 s[10:11], flat_scratch_lo
// CHECK: [0x68,0x1c,0x8a,0xbe]

s_bitset0_b64 s[10:11], flat_scratch_hi
// CHECK: [0x69,0x1c,0x8a,0xbe]

s_bitset0_b64 s[10:11], vcc_lo
// CHECK: [0x6a,0x1c,0x8a,0xbe]

s_bitset0_b64 s[10:11], vcc_hi
// CHECK: [0x6b,0x1c,0x8a,0xbe]

s_bitset0_b64 s[10:11], tba_lo
// CHECK: [0x6c,0x1c,0x8a,0xbe]

s_bitset0_b64 s[10:11], tba_hi
// CHECK: [0x6d,0x1c,0x8a,0xbe]

s_bitset0_b64 s[10:11], tma_lo
// CHECK: [0x6e,0x1c,0x8a,0xbe]

s_bitset0_b64 s[10:11], tma_hi
// CHECK: [0x6f,0x1c,0x8a,0xbe]

s_bitset0_b64 s[10:11], ttmp11
// CHECK: [0x7b,0x1c,0x8a,0xbe]

s_bitset0_b64 s[10:11], m0
// CHECK: [0x7c,0x1c,0x8a,0xbe]

s_bitset0_b64 s[10:11], exec_lo
// CHECK: [0x7e,0x1c,0x8a,0xbe]

s_bitset0_b64 s[10:11], exec_hi
// CHECK: [0x7f,0x1c,0x8a,0xbe]

s_bitset0_b64 s[10:11], 0
// CHECK: [0x80,0x1c,0x8a,0xbe]

s_bitset0_b64 s[10:11], -1
// CHECK: [0xc1,0x1c,0x8a,0xbe]

s_bitset0_b64 s[10:11], 0.5
// CHECK: [0xf0,0x1c,0x8a,0xbe]

s_bitset0_b64 s[10:11], -4.0
// CHECK: [0xf7,0x1c,0x8a,0xbe]

s_bitset0_b64 s[10:11], 0xaf123456
// CHECK: [0xff,0x1c,0x8a,0xbe,0x56,0x34,0x12,0xaf]

s_bitset0_b64 s[10:11], 0x3f717273
// CHECK: [0xff,0x1c,0x8a,0xbe,0x73,0x72,0x71,0x3f]

s_bitset1_b32 s5, s1
// CHECK: [0x01,0x1d,0x85,0xbe]

s_bitset1_b32 s103, s1
// CHECK: [0x01,0x1d,0xe7,0xbe]

s_bitset1_b32 flat_scratch_lo, s1
// CHECK: [0x01,0x1d,0xe8,0xbe]

s_bitset1_b32 flat_scratch_hi, s1
// CHECK: [0x01,0x1d,0xe9,0xbe]

s_bitset1_b32 vcc_lo, s1
// CHECK: [0x01,0x1d,0xea,0xbe]

s_bitset1_b32 vcc_hi, s1
// CHECK: [0x01,0x1d,0xeb,0xbe]

s_bitset1_b32 tba_lo, s1
// CHECK: [0x01,0x1d,0xec,0xbe]

s_bitset1_b32 tba_hi, s1
// CHECK: [0x01,0x1d,0xed,0xbe]

s_bitset1_b32 tma_lo, s1
// CHECK: [0x01,0x1d,0xee,0xbe]

s_bitset1_b32 tma_hi, s1
// CHECK: [0x01,0x1d,0xef,0xbe]

s_bitset1_b32 ttmp11, s1
// CHECK: [0x01,0x1d,0xfb,0xbe]

s_bitset1_b32 m0, s1
// CHECK: [0x01,0x1d,0xfc,0xbe]

s_bitset1_b32 exec_lo, s1
// CHECK: [0x01,0x1d,0xfe,0xbe]

s_bitset1_b32 exec_hi, s1
// CHECK: [0x01,0x1d,0xff,0xbe]

s_bitset1_b32 s5, s103
// CHECK: [0x67,0x1d,0x85,0xbe]

s_bitset1_b32 s5, flat_scratch_lo
// CHECK: [0x68,0x1d,0x85,0xbe]

s_bitset1_b32 s5, flat_scratch_hi
// CHECK: [0x69,0x1d,0x85,0xbe]

s_bitset1_b32 s5, vcc_lo
// CHECK: [0x6a,0x1d,0x85,0xbe]

s_bitset1_b32 s5, vcc_hi
// CHECK: [0x6b,0x1d,0x85,0xbe]

s_bitset1_b32 s5, tba_lo
// CHECK: [0x6c,0x1d,0x85,0xbe]

s_bitset1_b32 s5, tba_hi
// CHECK: [0x6d,0x1d,0x85,0xbe]

s_bitset1_b32 s5, tma_lo
// CHECK: [0x6e,0x1d,0x85,0xbe]

s_bitset1_b32 s5, tma_hi
// CHECK: [0x6f,0x1d,0x85,0xbe]

s_bitset1_b32 s5, ttmp11
// CHECK: [0x7b,0x1d,0x85,0xbe]

s_bitset1_b32 s5, m0
// CHECK: [0x7c,0x1d,0x85,0xbe]

s_bitset1_b32 s5, exec_lo
// CHECK: [0x7e,0x1d,0x85,0xbe]

s_bitset1_b32 s5, exec_hi
// CHECK: [0x7f,0x1d,0x85,0xbe]

s_bitset1_b32 s5, 0
// CHECK: [0x80,0x1d,0x85,0xbe]

s_bitset1_b32 s5, -1
// CHECK: [0xc1,0x1d,0x85,0xbe]

s_bitset1_b32 s5, 0.5
// CHECK: [0xf0,0x1d,0x85,0xbe]

s_bitset1_b32 s5, -4.0
// CHECK: [0xf7,0x1d,0x85,0xbe]

s_bitset1_b32 s5, 0xaf123456
// CHECK: [0xff,0x1d,0x85,0xbe,0x56,0x34,0x12,0xaf]

s_bitset1_b32 s5, 0x3f717273
// CHECK: [0xff,0x1d,0x85,0xbe,0x73,0x72,0x71,0x3f]

s_bitset1_b64 s[10:11], s1
// CHECK: [0x01,0x1e,0x8a,0xbe]

s_bitset1_b64 s[12:13], s1
// CHECK: [0x01,0x1e,0x8c,0xbe]

s_bitset1_b64 s[102:103], s1
// CHECK: [0x01,0x1e,0xe6,0xbe]

s_bitset1_b64 flat_scratch, s1
// CHECK: [0x01,0x1e,0xe8,0xbe]

s_bitset1_b64 vcc, s1
// CHECK: [0x01,0x1e,0xea,0xbe]

s_bitset1_b64 tba, s1
// CHECK: [0x01,0x1e,0xec,0xbe]

s_bitset1_b64 tma, s1
// CHECK: [0x01,0x1e,0xee,0xbe]

s_bitset1_b64 ttmp[10:11], s1
// CHECK: [0x01,0x1e,0xfa,0xbe]

s_bitset1_b64 exec, s1
// CHECK: [0x01,0x1e,0xfe,0xbe]

s_bitset1_b64 s[10:11], s103
// CHECK: [0x67,0x1e,0x8a,0xbe]

s_bitset1_b64 s[10:11], flat_scratch_lo
// CHECK: [0x68,0x1e,0x8a,0xbe]

s_bitset1_b64 s[10:11], flat_scratch_hi
// CHECK: [0x69,0x1e,0x8a,0xbe]

s_bitset1_b64 s[10:11], vcc_lo
// CHECK: [0x6a,0x1e,0x8a,0xbe]

s_bitset1_b64 s[10:11], vcc_hi
// CHECK: [0x6b,0x1e,0x8a,0xbe]

s_bitset1_b64 s[10:11], tba_lo
// CHECK: [0x6c,0x1e,0x8a,0xbe]

s_bitset1_b64 s[10:11], tba_hi
// CHECK: [0x6d,0x1e,0x8a,0xbe]

s_bitset1_b64 s[10:11], tma_lo
// CHECK: [0x6e,0x1e,0x8a,0xbe]

s_bitset1_b64 s[10:11], tma_hi
// CHECK: [0x6f,0x1e,0x8a,0xbe]

s_bitset1_b64 s[10:11], ttmp11
// CHECK: [0x7b,0x1e,0x8a,0xbe]

s_bitset1_b64 s[10:11], m0
// CHECK: [0x7c,0x1e,0x8a,0xbe]

s_bitset1_b64 s[10:11], exec_lo
// CHECK: [0x7e,0x1e,0x8a,0xbe]

s_bitset1_b64 s[10:11], exec_hi
// CHECK: [0x7f,0x1e,0x8a,0xbe]

s_bitset1_b64 s[10:11], 0
// CHECK: [0x80,0x1e,0x8a,0xbe]

s_bitset1_b64 s[10:11], -1
// CHECK: [0xc1,0x1e,0x8a,0xbe]

s_bitset1_b64 s[10:11], 0.5
// CHECK: [0xf0,0x1e,0x8a,0xbe]

s_bitset1_b64 s[10:11], -4.0
// CHECK: [0xf7,0x1e,0x8a,0xbe]

s_bitset1_b64 s[10:11], 0xaf123456
// CHECK: [0xff,0x1e,0x8a,0xbe,0x56,0x34,0x12,0xaf]

s_bitset1_b64 s[10:11], 0x3f717273
// CHECK: [0xff,0x1e,0x8a,0xbe,0x73,0x72,0x71,0x3f]

s_getpc_b64 s[10:11]
// CHECK: [0x00,0x1f,0x8a,0xbe]

s_getpc_b64 s[12:13]
// CHECK: [0x00,0x1f,0x8c,0xbe]

s_getpc_b64 s[102:103]
// CHECK: [0x00,0x1f,0xe6,0xbe]

s_getpc_b64 flat_scratch
// CHECK: [0x00,0x1f,0xe8,0xbe]

s_getpc_b64 vcc
// CHECK: [0x00,0x1f,0xea,0xbe]

s_getpc_b64 tba
// CHECK: [0x00,0x1f,0xec,0xbe]

s_getpc_b64 tma
// CHECK: [0x00,0x1f,0xee,0xbe]

s_getpc_b64 ttmp[10:11]
// CHECK: [0x00,0x1f,0xfa,0xbe]

s_getpc_b64 exec
// CHECK: [0x00,0x1f,0xfe,0xbe]

s_setpc_b64 s[2:3]
// CHECK: [0x02,0x20,0x80,0xbe]

s_setpc_b64 s[4:5]
// CHECK: [0x04,0x20,0x80,0xbe]

s_setpc_b64 s[102:103]
// CHECK: [0x66,0x20,0x80,0xbe]

s_setpc_b64 flat_scratch
// CHECK: [0x68,0x20,0x80,0xbe]

s_setpc_b64 vcc
// CHECK: [0x6a,0x20,0x80,0xbe]

s_setpc_b64 tba
// CHECK: [0x6c,0x20,0x80,0xbe]

s_setpc_b64 tma
// CHECK: [0x6e,0x20,0x80,0xbe]

s_setpc_b64 ttmp[10:11]
// CHECK: [0x7a,0x20,0x80,0xbe]

s_swappc_b64 s[10:11], s[2:3]
// CHECK: [0x02,0x21,0x8a,0xbe]

s_swappc_b64 s[12:13], s[2:3]
// CHECK: [0x02,0x21,0x8c,0xbe]

s_swappc_b64 s[102:103], s[2:3]
// CHECK: [0x02,0x21,0xe6,0xbe]

s_swappc_b64 flat_scratch, s[2:3]
// CHECK: [0x02,0x21,0xe8,0xbe]

s_swappc_b64 vcc, s[2:3]
// CHECK: [0x02,0x21,0xea,0xbe]

s_swappc_b64 tba, s[2:3]
// CHECK: [0x02,0x21,0xec,0xbe]

s_swappc_b64 tma, s[2:3]
// CHECK: [0x02,0x21,0xee,0xbe]

s_swappc_b64 ttmp[10:11], s[2:3]
// CHECK: [0x02,0x21,0xfa,0xbe]

s_swappc_b64 exec, s[2:3]
// CHECK: [0x02,0x21,0xfe,0xbe]

s_swappc_b64 s[10:11], s[4:5]
// CHECK: [0x04,0x21,0x8a,0xbe]

s_swappc_b64 s[10:11], s[102:103]
// CHECK: [0x66,0x21,0x8a,0xbe]

s_swappc_b64 s[10:11], flat_scratch
// CHECK: [0x68,0x21,0x8a,0xbe]

s_swappc_b64 s[10:11], vcc
// CHECK: [0x6a,0x21,0x8a,0xbe]

s_swappc_b64 s[10:11], tba
// CHECK: [0x6c,0x21,0x8a,0xbe]

s_swappc_b64 s[10:11], tma
// CHECK: [0x6e,0x21,0x8a,0xbe]

s_swappc_b64 s[10:11], ttmp[10:11]
// CHECK: [0x7a,0x21,0x8a,0xbe]

s_rfe_b64 s[2:3]
// CHECK: [0x02,0x22,0x80,0xbe]

s_rfe_b64 s[4:5]
// CHECK: [0x04,0x22,0x80,0xbe]

s_rfe_b64 s[102:103]
// CHECK: [0x66,0x22,0x80,0xbe]

s_rfe_b64 flat_scratch
// CHECK: [0x68,0x22,0x80,0xbe]

s_rfe_b64 vcc
// CHECK: [0x6a,0x22,0x80,0xbe]

s_rfe_b64 tba
// CHECK: [0x6c,0x22,0x80,0xbe]

s_rfe_b64 tma
// CHECK: [0x6e,0x22,0x80,0xbe]

s_rfe_b64 ttmp[10:11]
// CHECK: [0x7a,0x22,0x80,0xbe]

s_and_saveexec_b64 s[10:11], s[2:3]
// CHECK: [0x02,0x24,0x8a,0xbe]

s_and_saveexec_b64 s[12:13], s[2:3]
// CHECK: [0x02,0x24,0x8c,0xbe]

s_and_saveexec_b64 s[102:103], s[2:3]
// CHECK: [0x02,0x24,0xe6,0xbe]

s_and_saveexec_b64 flat_scratch, s[2:3]
// CHECK: [0x02,0x24,0xe8,0xbe]

s_and_saveexec_b64 vcc, s[2:3]
// CHECK: [0x02,0x24,0xea,0xbe]

s_and_saveexec_b64 tba, s[2:3]
// CHECK: [0x02,0x24,0xec,0xbe]

s_and_saveexec_b64 tma, s[2:3]
// CHECK: [0x02,0x24,0xee,0xbe]

s_and_saveexec_b64 ttmp[10:11], s[2:3]
// CHECK: [0x02,0x24,0xfa,0xbe]

s_and_saveexec_b64 s[10:11], s[4:5]
// CHECK: [0x04,0x24,0x8a,0xbe]

s_and_saveexec_b64 s[10:11], s[102:103]
// CHECK: [0x66,0x24,0x8a,0xbe]

s_and_saveexec_b64 s[10:11], flat_scratch
// CHECK: [0x68,0x24,0x8a,0xbe]

s_and_saveexec_b64 s[10:11], vcc
// CHECK: [0x6a,0x24,0x8a,0xbe]

s_and_saveexec_b64 s[10:11], tba
// CHECK: [0x6c,0x24,0x8a,0xbe]

s_and_saveexec_b64 s[10:11], tma
// CHECK: [0x6e,0x24,0x8a,0xbe]

s_and_saveexec_b64 s[10:11], ttmp[10:11]
// CHECK: [0x7a,0x24,0x8a,0xbe]

s_and_saveexec_b64 s[10:11], exec
// CHECK: [0x7e,0x24,0x8a,0xbe]

s_and_saveexec_b64 s[10:11], 0
// CHECK: [0x80,0x24,0x8a,0xbe]

s_and_saveexec_b64 s[10:11], -1
// CHECK: [0xc1,0x24,0x8a,0xbe]

s_and_saveexec_b64 s[10:11], 0.5
// CHECK: [0xf0,0x24,0x8a,0xbe]

s_and_saveexec_b64 s[10:11], -4.0
// CHECK: [0xf7,0x24,0x8a,0xbe]

s_and_saveexec_b64 s[10:11], 0xaf123456
// CHECK: [0xff,0x24,0x8a,0xbe,0x56,0x34,0x12,0xaf]

s_and_saveexec_b64 s[10:11], 0x3f717273
// CHECK: [0xff,0x24,0x8a,0xbe,0x73,0x72,0x71,0x3f]

s_or_saveexec_b64 s[10:11], s[2:3]
// CHECK: [0x02,0x25,0x8a,0xbe]

s_or_saveexec_b64 s[12:13], s[2:3]
// CHECK: [0x02,0x25,0x8c,0xbe]

s_or_saveexec_b64 s[102:103], s[2:3]
// CHECK: [0x02,0x25,0xe6,0xbe]

s_or_saveexec_b64 flat_scratch, s[2:3]
// CHECK: [0x02,0x25,0xe8,0xbe]

s_or_saveexec_b64 vcc, s[2:3]
// CHECK: [0x02,0x25,0xea,0xbe]

s_or_saveexec_b64 tba, s[2:3]
// CHECK: [0x02,0x25,0xec,0xbe]

s_or_saveexec_b64 tma, s[2:3]
// CHECK: [0x02,0x25,0xee,0xbe]

s_or_saveexec_b64 ttmp[10:11], s[2:3]
// CHECK: [0x02,0x25,0xfa,0xbe]

s_or_saveexec_b64 s[10:11], s[4:5]
// CHECK: [0x04,0x25,0x8a,0xbe]

s_or_saveexec_b64 s[10:11], s[102:103]
// CHECK: [0x66,0x25,0x8a,0xbe]

s_or_saveexec_b64 s[10:11], flat_scratch
// CHECK: [0x68,0x25,0x8a,0xbe]

s_or_saveexec_b64 s[10:11], vcc
// CHECK: [0x6a,0x25,0x8a,0xbe]

s_or_saveexec_b64 s[10:11], tba
// CHECK: [0x6c,0x25,0x8a,0xbe]

s_or_saveexec_b64 s[10:11], tma
// CHECK: [0x6e,0x25,0x8a,0xbe]

s_or_saveexec_b64 s[10:11], ttmp[10:11]
// CHECK: [0x7a,0x25,0x8a,0xbe]

s_or_saveexec_b64 s[10:11], exec
// CHECK: [0x7e,0x25,0x8a,0xbe]

s_or_saveexec_b64 s[10:11], 0
// CHECK: [0x80,0x25,0x8a,0xbe]

s_or_saveexec_b64 s[10:11], -1
// CHECK: [0xc1,0x25,0x8a,0xbe]

s_or_saveexec_b64 s[10:11], 0.5
// CHECK: [0xf0,0x25,0x8a,0xbe]

s_or_saveexec_b64 s[10:11], -4.0
// CHECK: [0xf7,0x25,0x8a,0xbe]

s_or_saveexec_b64 s[10:11], 0xaf123456
// CHECK: [0xff,0x25,0x8a,0xbe,0x56,0x34,0x12,0xaf]

s_or_saveexec_b64 s[10:11], 0x3f717273
// CHECK: [0xff,0x25,0x8a,0xbe,0x73,0x72,0x71,0x3f]

s_xor_saveexec_b64 s[10:11], s[2:3]
// CHECK: [0x02,0x26,0x8a,0xbe]

s_xor_saveexec_b64 s[12:13], s[2:3]
// CHECK: [0x02,0x26,0x8c,0xbe]

s_xor_saveexec_b64 s[102:103], s[2:3]
// CHECK: [0x02,0x26,0xe6,0xbe]

s_xor_saveexec_b64 flat_scratch, s[2:3]
// CHECK: [0x02,0x26,0xe8,0xbe]

s_xor_saveexec_b64 vcc, s[2:3]
// CHECK: [0x02,0x26,0xea,0xbe]

s_xor_saveexec_b64 tba, s[2:3]
// CHECK: [0x02,0x26,0xec,0xbe]

s_xor_saveexec_b64 tma, s[2:3]
// CHECK: [0x02,0x26,0xee,0xbe]

s_xor_saveexec_b64 ttmp[10:11], s[2:3]
// CHECK: [0x02,0x26,0xfa,0xbe]

s_xor_saveexec_b64 s[10:11], s[4:5]
// CHECK: [0x04,0x26,0x8a,0xbe]

s_xor_saveexec_b64 s[10:11], s[102:103]
// CHECK: [0x66,0x26,0x8a,0xbe]

s_xor_saveexec_b64 s[10:11], flat_scratch
// CHECK: [0x68,0x26,0x8a,0xbe]

s_xor_saveexec_b64 s[10:11], vcc
// CHECK: [0x6a,0x26,0x8a,0xbe]

s_xor_saveexec_b64 s[10:11], tba
// CHECK: [0x6c,0x26,0x8a,0xbe]

s_xor_saveexec_b64 s[10:11], tma
// CHECK: [0x6e,0x26,0x8a,0xbe]

s_xor_saveexec_b64 s[10:11], ttmp[10:11]
// CHECK: [0x7a,0x26,0x8a,0xbe]

s_xor_saveexec_b64 s[10:11], exec
// CHECK: [0x7e,0x26,0x8a,0xbe]

s_xor_saveexec_b64 s[10:11], 0
// CHECK: [0x80,0x26,0x8a,0xbe]

s_xor_saveexec_b64 s[10:11], -1
// CHECK: [0xc1,0x26,0x8a,0xbe]

s_xor_saveexec_b64 s[10:11], 0.5
// CHECK: [0xf0,0x26,0x8a,0xbe]

s_xor_saveexec_b64 s[10:11], -4.0
// CHECK: [0xf7,0x26,0x8a,0xbe]

s_xor_saveexec_b64 s[10:11], 0xaf123456
// CHECK: [0xff,0x26,0x8a,0xbe,0x56,0x34,0x12,0xaf]

s_xor_saveexec_b64 s[10:11], 0x3f717273
// CHECK: [0xff,0x26,0x8a,0xbe,0x73,0x72,0x71,0x3f]

s_andn2_saveexec_b64 s[10:11], s[2:3]
// CHECK: [0x02,0x27,0x8a,0xbe]

s_andn2_saveexec_b64 s[12:13], s[2:3]
// CHECK: [0x02,0x27,0x8c,0xbe]

s_andn2_saveexec_b64 s[102:103], s[2:3]
// CHECK: [0x02,0x27,0xe6,0xbe]

s_andn2_saveexec_b64 flat_scratch, s[2:3]
// CHECK: [0x02,0x27,0xe8,0xbe]

s_andn2_saveexec_b64 vcc, s[2:3]
// CHECK: [0x02,0x27,0xea,0xbe]

s_andn2_saveexec_b64 tba, s[2:3]
// CHECK: [0x02,0x27,0xec,0xbe]

s_andn2_saveexec_b64 tma, s[2:3]
// CHECK: [0x02,0x27,0xee,0xbe]

s_andn2_saveexec_b64 ttmp[10:11], s[2:3]
// CHECK: [0x02,0x27,0xfa,0xbe]

s_andn2_saveexec_b64 s[10:11], s[4:5]
// CHECK: [0x04,0x27,0x8a,0xbe]

s_andn2_saveexec_b64 s[10:11], s[102:103]
// CHECK: [0x66,0x27,0x8a,0xbe]

s_andn2_saveexec_b64 s[10:11], flat_scratch
// CHECK: [0x68,0x27,0x8a,0xbe]

s_andn2_saveexec_b64 s[10:11], vcc
// CHECK: [0x6a,0x27,0x8a,0xbe]

s_andn2_saveexec_b64 s[10:11], tba
// CHECK: [0x6c,0x27,0x8a,0xbe]

s_andn2_saveexec_b64 s[10:11], tma
// CHECK: [0x6e,0x27,0x8a,0xbe]

s_andn2_saveexec_b64 s[10:11], ttmp[10:11]
// CHECK: [0x7a,0x27,0x8a,0xbe]

s_andn2_saveexec_b64 s[10:11], exec
// CHECK: [0x7e,0x27,0x8a,0xbe]

s_andn2_saveexec_b64 s[10:11], 0
// CHECK: [0x80,0x27,0x8a,0xbe]

s_andn2_saveexec_b64 s[10:11], -1
// CHECK: [0xc1,0x27,0x8a,0xbe]

s_andn2_saveexec_b64 s[10:11], 0.5
// CHECK: [0xf0,0x27,0x8a,0xbe]

s_andn2_saveexec_b64 s[10:11], -4.0
// CHECK: [0xf7,0x27,0x8a,0xbe]

s_andn2_saveexec_b64 s[10:11], 0xaf123456
// CHECK: [0xff,0x27,0x8a,0xbe,0x56,0x34,0x12,0xaf]

s_andn2_saveexec_b64 s[10:11], 0x3f717273
// CHECK: [0xff,0x27,0x8a,0xbe,0x73,0x72,0x71,0x3f]

s_orn2_saveexec_b64 s[10:11], s[2:3]
// CHECK: [0x02,0x28,0x8a,0xbe]

s_orn2_saveexec_b64 s[12:13], s[2:3]
// CHECK: [0x02,0x28,0x8c,0xbe]

s_orn2_saveexec_b64 s[102:103], s[2:3]
// CHECK: [0x02,0x28,0xe6,0xbe]

s_orn2_saveexec_b64 flat_scratch, s[2:3]
// CHECK: [0x02,0x28,0xe8,0xbe]

s_orn2_saveexec_b64 vcc, s[2:3]
// CHECK: [0x02,0x28,0xea,0xbe]

s_orn2_saveexec_b64 tba, s[2:3]
// CHECK: [0x02,0x28,0xec,0xbe]

s_orn2_saveexec_b64 tma, s[2:3]
// CHECK: [0x02,0x28,0xee,0xbe]

s_orn2_saveexec_b64 ttmp[10:11], s[2:3]
// CHECK: [0x02,0x28,0xfa,0xbe]

s_orn2_saveexec_b64 s[10:11], s[4:5]
// CHECK: [0x04,0x28,0x8a,0xbe]

s_orn2_saveexec_b64 s[10:11], s[102:103]
// CHECK: [0x66,0x28,0x8a,0xbe]

s_orn2_saveexec_b64 s[10:11], flat_scratch
// CHECK: [0x68,0x28,0x8a,0xbe]

s_orn2_saveexec_b64 s[10:11], vcc
// CHECK: [0x6a,0x28,0x8a,0xbe]

s_orn2_saveexec_b64 s[10:11], tba
// CHECK: [0x6c,0x28,0x8a,0xbe]

s_orn2_saveexec_b64 s[10:11], tma
// CHECK: [0x6e,0x28,0x8a,0xbe]

s_orn2_saveexec_b64 s[10:11], ttmp[10:11]
// CHECK: [0x7a,0x28,0x8a,0xbe]

s_orn2_saveexec_b64 s[10:11], exec
// CHECK: [0x7e,0x28,0x8a,0xbe]

s_orn2_saveexec_b64 s[10:11], 0
// CHECK: [0x80,0x28,0x8a,0xbe]

s_orn2_saveexec_b64 s[10:11], -1
// CHECK: [0xc1,0x28,0x8a,0xbe]

s_orn2_saveexec_b64 s[10:11], 0.5
// CHECK: [0xf0,0x28,0x8a,0xbe]

s_orn2_saveexec_b64 s[10:11], -4.0
// CHECK: [0xf7,0x28,0x8a,0xbe]

s_orn2_saveexec_b64 s[10:11], 0xaf123456
// CHECK: [0xff,0x28,0x8a,0xbe,0x56,0x34,0x12,0xaf]

s_orn2_saveexec_b64 s[10:11], 0x3f717273
// CHECK: [0xff,0x28,0x8a,0xbe,0x73,0x72,0x71,0x3f]

s_nand_saveexec_b64 s[10:11], s[2:3]
// CHECK: [0x02,0x29,0x8a,0xbe]

s_nand_saveexec_b64 s[12:13], s[2:3]
// CHECK: [0x02,0x29,0x8c,0xbe]

s_nand_saveexec_b64 s[102:103], s[2:3]
// CHECK: [0x02,0x29,0xe6,0xbe]

s_nand_saveexec_b64 flat_scratch, s[2:3]
// CHECK: [0x02,0x29,0xe8,0xbe]

s_nand_saveexec_b64 vcc, s[2:3]
// CHECK: [0x02,0x29,0xea,0xbe]

s_nand_saveexec_b64 tba, s[2:3]
// CHECK: [0x02,0x29,0xec,0xbe]

s_nand_saveexec_b64 tma, s[2:3]
// CHECK: [0x02,0x29,0xee,0xbe]

s_nand_saveexec_b64 ttmp[10:11], s[2:3]
// CHECK: [0x02,0x29,0xfa,0xbe]

s_nand_saveexec_b64 s[10:11], s[4:5]
// CHECK: [0x04,0x29,0x8a,0xbe]

s_nand_saveexec_b64 s[10:11], s[102:103]
// CHECK: [0x66,0x29,0x8a,0xbe]

s_nand_saveexec_b64 s[10:11], flat_scratch
// CHECK: [0x68,0x29,0x8a,0xbe]

s_nand_saveexec_b64 s[10:11], vcc
// CHECK: [0x6a,0x29,0x8a,0xbe]

s_nand_saveexec_b64 s[10:11], tba
// CHECK: [0x6c,0x29,0x8a,0xbe]

s_nand_saveexec_b64 s[10:11], tma
// CHECK: [0x6e,0x29,0x8a,0xbe]

s_nand_saveexec_b64 s[10:11], ttmp[10:11]
// CHECK: [0x7a,0x29,0x8a,0xbe]

s_nand_saveexec_b64 s[10:11], exec
// CHECK: [0x7e,0x29,0x8a,0xbe]

s_nand_saveexec_b64 s[10:11], 0
// CHECK: [0x80,0x29,0x8a,0xbe]

s_nand_saveexec_b64 s[10:11], -1
// CHECK: [0xc1,0x29,0x8a,0xbe]

s_nand_saveexec_b64 s[10:11], 0.5
// CHECK: [0xf0,0x29,0x8a,0xbe]

s_nand_saveexec_b64 s[10:11], -4.0
// CHECK: [0xf7,0x29,0x8a,0xbe]

s_nand_saveexec_b64 s[10:11], 0xaf123456
// CHECK: [0xff,0x29,0x8a,0xbe,0x56,0x34,0x12,0xaf]

s_nand_saveexec_b64 s[10:11], 0x3f717273
// CHECK: [0xff,0x29,0x8a,0xbe,0x73,0x72,0x71,0x3f]

s_nor_saveexec_b64 s[10:11], s[2:3]
// CHECK: [0x02,0x2a,0x8a,0xbe]

s_nor_saveexec_b64 s[12:13], s[2:3]
// CHECK: [0x02,0x2a,0x8c,0xbe]

s_nor_saveexec_b64 s[102:103], s[2:3]
// CHECK: [0x02,0x2a,0xe6,0xbe]

s_nor_saveexec_b64 flat_scratch, s[2:3]
// CHECK: [0x02,0x2a,0xe8,0xbe]

s_nor_saveexec_b64 vcc, s[2:3]
// CHECK: [0x02,0x2a,0xea,0xbe]

s_nor_saveexec_b64 tba, s[2:3]
// CHECK: [0x02,0x2a,0xec,0xbe]

s_nor_saveexec_b64 tma, s[2:3]
// CHECK: [0x02,0x2a,0xee,0xbe]

s_nor_saveexec_b64 ttmp[10:11], s[2:3]
// CHECK: [0x02,0x2a,0xfa,0xbe]

s_nor_saveexec_b64 s[10:11], s[4:5]
// CHECK: [0x04,0x2a,0x8a,0xbe]

s_nor_saveexec_b64 s[10:11], s[102:103]
// CHECK: [0x66,0x2a,0x8a,0xbe]

s_nor_saveexec_b64 s[10:11], flat_scratch
// CHECK: [0x68,0x2a,0x8a,0xbe]

s_nor_saveexec_b64 s[10:11], vcc
// CHECK: [0x6a,0x2a,0x8a,0xbe]

s_nor_saveexec_b64 s[10:11], tba
// CHECK: [0x6c,0x2a,0x8a,0xbe]

s_nor_saveexec_b64 s[10:11], tma
// CHECK: [0x6e,0x2a,0x8a,0xbe]

s_nor_saveexec_b64 s[10:11], ttmp[10:11]
// CHECK: [0x7a,0x2a,0x8a,0xbe]

s_nor_saveexec_b64 s[10:11], exec
// CHECK: [0x7e,0x2a,0x8a,0xbe]

s_nor_saveexec_b64 s[10:11], 0
// CHECK: [0x80,0x2a,0x8a,0xbe]

s_nor_saveexec_b64 s[10:11], -1
// CHECK: [0xc1,0x2a,0x8a,0xbe]

s_nor_saveexec_b64 s[10:11], 0.5
// CHECK: [0xf0,0x2a,0x8a,0xbe]

s_nor_saveexec_b64 s[10:11], -4.0
// CHECK: [0xf7,0x2a,0x8a,0xbe]

s_nor_saveexec_b64 s[10:11], 0xaf123456
// CHECK: [0xff,0x2a,0x8a,0xbe,0x56,0x34,0x12,0xaf]

s_nor_saveexec_b64 s[10:11], 0x3f717273
// CHECK: [0xff,0x2a,0x8a,0xbe,0x73,0x72,0x71,0x3f]

s_xnor_saveexec_b64 s[10:11], s[2:3]
// CHECK: [0x02,0x2b,0x8a,0xbe]

s_xnor_saveexec_b64 s[12:13], s[2:3]
// CHECK: [0x02,0x2b,0x8c,0xbe]

s_xnor_saveexec_b64 s[102:103], s[2:3]
// CHECK: [0x02,0x2b,0xe6,0xbe]

s_xnor_saveexec_b64 flat_scratch, s[2:3]
// CHECK: [0x02,0x2b,0xe8,0xbe]

s_xnor_saveexec_b64 vcc, s[2:3]
// CHECK: [0x02,0x2b,0xea,0xbe]

s_xnor_saveexec_b64 tba, s[2:3]
// CHECK: [0x02,0x2b,0xec,0xbe]

s_xnor_saveexec_b64 tma, s[2:3]
// CHECK: [0x02,0x2b,0xee,0xbe]

s_xnor_saveexec_b64 ttmp[10:11], s[2:3]
// CHECK: [0x02,0x2b,0xfa,0xbe]

s_xnor_saveexec_b64 s[10:11], s[4:5]
// CHECK: [0x04,0x2b,0x8a,0xbe]

s_xnor_saveexec_b64 s[10:11], s[102:103]
// CHECK: [0x66,0x2b,0x8a,0xbe]

s_xnor_saveexec_b64 s[10:11], flat_scratch
// CHECK: [0x68,0x2b,0x8a,0xbe]

s_xnor_saveexec_b64 s[10:11], vcc
// CHECK: [0x6a,0x2b,0x8a,0xbe]

s_xnor_saveexec_b64 s[10:11], tba
// CHECK: [0x6c,0x2b,0x8a,0xbe]

s_xnor_saveexec_b64 s[10:11], tma
// CHECK: [0x6e,0x2b,0x8a,0xbe]

s_xnor_saveexec_b64 s[10:11], ttmp[10:11]
// CHECK: [0x7a,0x2b,0x8a,0xbe]

s_xnor_saveexec_b64 s[10:11], exec
// CHECK: [0x7e,0x2b,0x8a,0xbe]

s_xnor_saveexec_b64 s[10:11], 0
// CHECK: [0x80,0x2b,0x8a,0xbe]

s_xnor_saveexec_b64 s[10:11], -1
// CHECK: [0xc1,0x2b,0x8a,0xbe]

s_xnor_saveexec_b64 s[10:11], 0.5
// CHECK: [0xf0,0x2b,0x8a,0xbe]

s_xnor_saveexec_b64 s[10:11], -4.0
// CHECK: [0xf7,0x2b,0x8a,0xbe]

s_xnor_saveexec_b64 s[10:11], 0xaf123456
// CHECK: [0xff,0x2b,0x8a,0xbe,0x56,0x34,0x12,0xaf]

s_xnor_saveexec_b64 s[10:11], 0x3f717273
// CHECK: [0xff,0x2b,0x8a,0xbe,0x73,0x72,0x71,0x3f]

s_quadmask_b32 s5, s1
// CHECK: [0x01,0x2c,0x85,0xbe]

s_quadmask_b32 s103, s1
// CHECK: [0x01,0x2c,0xe7,0xbe]

s_quadmask_b32 flat_scratch_lo, s1
// CHECK: [0x01,0x2c,0xe8,0xbe]

s_quadmask_b32 flat_scratch_hi, s1
// CHECK: [0x01,0x2c,0xe9,0xbe]

s_quadmask_b32 vcc_lo, s1
// CHECK: [0x01,0x2c,0xea,0xbe]

s_quadmask_b32 vcc_hi, s1
// CHECK: [0x01,0x2c,0xeb,0xbe]

s_quadmask_b32 tba_lo, s1
// CHECK: [0x01,0x2c,0xec,0xbe]

s_quadmask_b32 tba_hi, s1
// CHECK: [0x01,0x2c,0xed,0xbe]

s_quadmask_b32 tma_lo, s1
// CHECK: [0x01,0x2c,0xee,0xbe]

s_quadmask_b32 tma_hi, s1
// CHECK: [0x01,0x2c,0xef,0xbe]

s_quadmask_b32 ttmp11, s1
// CHECK: [0x01,0x2c,0xfb,0xbe]

s_quadmask_b32 m0, s1
// CHECK: [0x01,0x2c,0xfc,0xbe]

s_quadmask_b32 exec_lo, s1
// CHECK: [0x01,0x2c,0xfe,0xbe]

s_quadmask_b32 exec_hi, s1
// CHECK: [0x01,0x2c,0xff,0xbe]

s_quadmask_b32 s5, s103
// CHECK: [0x67,0x2c,0x85,0xbe]

s_quadmask_b32 s5, flat_scratch_lo
// CHECK: [0x68,0x2c,0x85,0xbe]

s_quadmask_b32 s5, flat_scratch_hi
// CHECK: [0x69,0x2c,0x85,0xbe]

s_quadmask_b32 s5, vcc_lo
// CHECK: [0x6a,0x2c,0x85,0xbe]

s_quadmask_b32 s5, vcc_hi
// CHECK: [0x6b,0x2c,0x85,0xbe]

s_quadmask_b32 s5, tba_lo
// CHECK: [0x6c,0x2c,0x85,0xbe]

s_quadmask_b32 s5, tba_hi
// CHECK: [0x6d,0x2c,0x85,0xbe]

s_quadmask_b32 s5, tma_lo
// CHECK: [0x6e,0x2c,0x85,0xbe]

s_quadmask_b32 s5, tma_hi
// CHECK: [0x6f,0x2c,0x85,0xbe]

s_quadmask_b32 s5, ttmp11
// CHECK: [0x7b,0x2c,0x85,0xbe]

s_quadmask_b32 s5, m0
// CHECK: [0x7c,0x2c,0x85,0xbe]

s_quadmask_b32 s5, exec_lo
// CHECK: [0x7e,0x2c,0x85,0xbe]

s_quadmask_b32 s5, exec_hi
// CHECK: [0x7f,0x2c,0x85,0xbe]

s_quadmask_b32 s5, 0
// CHECK: [0x80,0x2c,0x85,0xbe]

s_quadmask_b32 s5, -1
// CHECK: [0xc1,0x2c,0x85,0xbe]

s_quadmask_b32 s5, 0.5
// CHECK: [0xf0,0x2c,0x85,0xbe]

s_quadmask_b32 s5, -4.0
// CHECK: [0xf7,0x2c,0x85,0xbe]

s_quadmask_b32 s5, 0xaf123456
// CHECK: [0xff,0x2c,0x85,0xbe,0x56,0x34,0x12,0xaf]

s_quadmask_b32 s5, 0x3f717273
// CHECK: [0xff,0x2c,0x85,0xbe,0x73,0x72,0x71,0x3f]

s_quadmask_b64 s[10:11], s[2:3]
// CHECK: [0x02,0x2d,0x8a,0xbe]

s_quadmask_b64 s[12:13], s[2:3]
// CHECK: [0x02,0x2d,0x8c,0xbe]

s_quadmask_b64 s[102:103], s[2:3]
// CHECK: [0x02,0x2d,0xe6,0xbe]

s_quadmask_b64 flat_scratch, s[2:3]
// CHECK: [0x02,0x2d,0xe8,0xbe]

s_quadmask_b64 vcc, s[2:3]
// CHECK: [0x02,0x2d,0xea,0xbe]

s_quadmask_b64 tba, s[2:3]
// CHECK: [0x02,0x2d,0xec,0xbe]

s_quadmask_b64 tma, s[2:3]
// CHECK: [0x02,0x2d,0xee,0xbe]

s_quadmask_b64 ttmp[10:11], s[2:3]
// CHECK: [0x02,0x2d,0xfa,0xbe]

s_quadmask_b64 exec, s[2:3]
// CHECK: [0x02,0x2d,0xfe,0xbe]

s_quadmask_b64 s[10:11], s[4:5]
// CHECK: [0x04,0x2d,0x8a,0xbe]

s_quadmask_b64 s[10:11], s[102:103]
// CHECK: [0x66,0x2d,0x8a,0xbe]

s_quadmask_b64 s[10:11], flat_scratch
// CHECK: [0x68,0x2d,0x8a,0xbe]

s_quadmask_b64 s[10:11], vcc
// CHECK: [0x6a,0x2d,0x8a,0xbe]

s_quadmask_b64 s[10:11], tba
// CHECK: [0x6c,0x2d,0x8a,0xbe]

s_quadmask_b64 s[10:11], tma
// CHECK: [0x6e,0x2d,0x8a,0xbe]

s_quadmask_b64 s[10:11], ttmp[10:11]
// CHECK: [0x7a,0x2d,0x8a,0xbe]

s_quadmask_b64 s[10:11], exec
// CHECK: [0x7e,0x2d,0x8a,0xbe]

s_quadmask_b64 s[10:11], 0
// CHECK: [0x80,0x2d,0x8a,0xbe]

s_quadmask_b64 s[10:11], -1
// CHECK: [0xc1,0x2d,0x8a,0xbe]

s_quadmask_b64 s[10:11], 0.5
// CHECK: [0xf0,0x2d,0x8a,0xbe]

s_quadmask_b64 s[10:11], -4.0
// CHECK: [0xf7,0x2d,0x8a,0xbe]

s_quadmask_b64 s[10:11], 0xaf123456
// CHECK: [0xff,0x2d,0x8a,0xbe,0x56,0x34,0x12,0xaf]

s_quadmask_b64 s[10:11], 0x3f717273
// CHECK: [0xff,0x2d,0x8a,0xbe,0x73,0x72,0x71,0x3f]

s_movrels_b32 s5, s1
// CHECK: [0x01,0x2e,0x85,0xbe]

s_movrels_b32 s103, s1
// CHECK: [0x01,0x2e,0xe7,0xbe]

s_movrels_b32 flat_scratch_lo, s1
// CHECK: [0x01,0x2e,0xe8,0xbe]

s_movrels_b32 flat_scratch_hi, s1
// CHECK: [0x01,0x2e,0xe9,0xbe]

s_movrels_b32 vcc_lo, s1
// CHECK: [0x01,0x2e,0xea,0xbe]

s_movrels_b32 vcc_hi, s1
// CHECK: [0x01,0x2e,0xeb,0xbe]

s_movrels_b32 tba_lo, s1
// CHECK: [0x01,0x2e,0xec,0xbe]

s_movrels_b32 tba_hi, s1
// CHECK: [0x01,0x2e,0xed,0xbe]

s_movrels_b32 tma_lo, s1
// CHECK: [0x01,0x2e,0xee,0xbe]

s_movrels_b32 tma_hi, s1
// CHECK: [0x01,0x2e,0xef,0xbe]

s_movrels_b32 ttmp11, s1
// CHECK: [0x01,0x2e,0xfb,0xbe]

s_movrels_b32 m0, s1
// CHECK: [0x01,0x2e,0xfc,0xbe]

s_movrels_b32 exec_lo, s1
// CHECK: [0x01,0x2e,0xfe,0xbe]

s_movrels_b32 exec_hi, s1
// CHECK: [0x01,0x2e,0xff,0xbe]

s_movrels_b32 s5, s103
// CHECK: [0x67,0x2e,0x85,0xbe]

s_movrels_b32 s5, flat_scratch_lo
// CHECK: [0x68,0x2e,0x85,0xbe]

s_movrels_b32 s5, flat_scratch_hi
// CHECK: [0x69,0x2e,0x85,0xbe]

s_movrels_b32 s5, vcc_lo
// CHECK: [0x6a,0x2e,0x85,0xbe]

s_movrels_b32 s5, vcc_hi
// CHECK: [0x6b,0x2e,0x85,0xbe]

s_movrels_b32 s5, tba_lo
// CHECK: [0x6c,0x2e,0x85,0xbe]

s_movrels_b32 s5, tba_hi
// CHECK: [0x6d,0x2e,0x85,0xbe]

s_movrels_b32 s5, tma_lo
// CHECK: [0x6e,0x2e,0x85,0xbe]

s_movrels_b32 s5, tma_hi
// CHECK: [0x6f,0x2e,0x85,0xbe]

s_movrels_b32 s5, ttmp11
// CHECK: [0x7b,0x2e,0x85,0xbe]

s_movrels_b64 s[10:11], s[2:3]
// CHECK: [0x02,0x2f,0x8a,0xbe]

s_movrels_b64 s[12:13], s[2:3]
// CHECK: [0x02,0x2f,0x8c,0xbe]

s_movrels_b64 s[102:103], s[2:3]
// CHECK: [0x02,0x2f,0xe6,0xbe]

s_movrels_b64 flat_scratch, s[2:3]
// CHECK: [0x02,0x2f,0xe8,0xbe]

s_movrels_b64 vcc, s[2:3]
// CHECK: [0x02,0x2f,0xea,0xbe]

s_movrels_b64 tba, s[2:3]
// CHECK: [0x02,0x2f,0xec,0xbe]

s_movrels_b64 tma, s[2:3]
// CHECK: [0x02,0x2f,0xee,0xbe]

s_movrels_b64 ttmp[10:11], s[2:3]
// CHECK: [0x02,0x2f,0xfa,0xbe]

s_movrels_b64 exec, s[2:3]
// CHECK: [0x02,0x2f,0xfe,0xbe]

s_movrels_b64 s[10:11], s[4:5]
// CHECK: [0x04,0x2f,0x8a,0xbe]

s_movrels_b64 s[10:11], s[102:103]
// CHECK: [0x66,0x2f,0x8a,0xbe]

s_movrels_b64 s[10:11], flat_scratch
// CHECK: [0x68,0x2f,0x8a,0xbe]

s_movrels_b64 s[10:11], vcc
// CHECK: [0x6a,0x2f,0x8a,0xbe]

s_movrels_b64 s[10:11], tba
// CHECK: [0x6c,0x2f,0x8a,0xbe]

s_movrels_b64 s[10:11], tma
// CHECK: [0x6e,0x2f,0x8a,0xbe]

s_movrels_b64 s[10:11], ttmp[10:11]
// CHECK: [0x7a,0x2f,0x8a,0xbe]

s_movreld_b32 s5, s1
// CHECK: [0x01,0x30,0x85,0xbe]

s_movreld_b32 s103, s1
// CHECK: [0x01,0x30,0xe7,0xbe]

s_movreld_b32 flat_scratch_lo, s1
// CHECK: [0x01,0x30,0xe8,0xbe]

s_movreld_b32 flat_scratch_hi, s1
// CHECK: [0x01,0x30,0xe9,0xbe]

s_movreld_b32 vcc_lo, s1
// CHECK: [0x01,0x30,0xea,0xbe]

s_movreld_b32 vcc_hi, s1
// CHECK: [0x01,0x30,0xeb,0xbe]

s_movreld_b32 tba_lo, s1
// CHECK: [0x01,0x30,0xec,0xbe]

s_movreld_b32 tba_hi, s1
// CHECK: [0x01,0x30,0xed,0xbe]

s_movreld_b32 tma_lo, s1
// CHECK: [0x01,0x30,0xee,0xbe]

s_movreld_b32 tma_hi, s1
// CHECK: [0x01,0x30,0xef,0xbe]

s_movreld_b32 ttmp11, s1
// CHECK: [0x01,0x30,0xfb,0xbe]

s_movreld_b32 s5, s103
// CHECK: [0x67,0x30,0x85,0xbe]

s_movreld_b32 s5, flat_scratch_lo
// CHECK: [0x68,0x30,0x85,0xbe]

s_movreld_b32 s5, flat_scratch_hi
// CHECK: [0x69,0x30,0x85,0xbe]

s_movreld_b32 s5, vcc_lo
// CHECK: [0x6a,0x30,0x85,0xbe]

s_movreld_b32 s5, vcc_hi
// CHECK: [0x6b,0x30,0x85,0xbe]

s_movreld_b32 s5, tba_lo
// CHECK: [0x6c,0x30,0x85,0xbe]

s_movreld_b32 s5, tba_hi
// CHECK: [0x6d,0x30,0x85,0xbe]

s_movreld_b32 s5, tma_lo
// CHECK: [0x6e,0x30,0x85,0xbe]

s_movreld_b32 s5, tma_hi
// CHECK: [0x6f,0x30,0x85,0xbe]

s_movreld_b32 s5, ttmp11
// CHECK: [0x7b,0x30,0x85,0xbe]

s_movreld_b32 s5, m0
// CHECK: [0x7c,0x30,0x85,0xbe]

s_movreld_b32 s5, 0
// CHECK: [0x80,0x30,0x85,0xbe]

s_movreld_b32 s5, -1
// CHECK: [0xc1,0x30,0x85,0xbe]

s_movreld_b32 s5, 0.5
// CHECK: [0xf0,0x30,0x85,0xbe]

s_movreld_b32 s5, -4.0
// CHECK: [0xf7,0x30,0x85,0xbe]

s_movreld_b32 s5, 0xaf123456
// CHECK: [0xff,0x30,0x85,0xbe,0x56,0x34,0x12,0xaf]

s_movreld_b32 s5, 0x3f717273
// CHECK: [0xff,0x30,0x85,0xbe,0x73,0x72,0x71,0x3f]

s_movreld_b64 s[10:11], s[2:3]
// CHECK: [0x02,0x31,0x8a,0xbe]

s_movreld_b64 s[12:13], s[2:3]
// CHECK: [0x02,0x31,0x8c,0xbe]

s_movreld_b64 s[102:103], s[2:3]
// CHECK: [0x02,0x31,0xe6,0xbe]

s_movreld_b64 flat_scratch, s[2:3]
// CHECK: [0x02,0x31,0xe8,0xbe]

s_movreld_b64 vcc, s[2:3]
// CHECK: [0x02,0x31,0xea,0xbe]

s_movreld_b64 tba, s[2:3]
// CHECK: [0x02,0x31,0xec,0xbe]

s_movreld_b64 tma, s[2:3]
// CHECK: [0x02,0x31,0xee,0xbe]

s_movreld_b64 ttmp[10:11], s[2:3]
// CHECK: [0x02,0x31,0xfa,0xbe]

s_movreld_b64 s[10:11], s[4:5]
// CHECK: [0x04,0x31,0x8a,0xbe]

s_movreld_b64 s[10:11], s[102:103]
// CHECK: [0x66,0x31,0x8a,0xbe]

s_movreld_b64 s[10:11], flat_scratch
// CHECK: [0x68,0x31,0x8a,0xbe]

s_movreld_b64 s[10:11], vcc
// CHECK: [0x6a,0x31,0x8a,0xbe]

s_movreld_b64 s[10:11], tba
// CHECK: [0x6c,0x31,0x8a,0xbe]

s_movreld_b64 s[10:11], tma
// CHECK: [0x6e,0x31,0x8a,0xbe]

s_movreld_b64 s[10:11], ttmp[10:11]
// CHECK: [0x7a,0x31,0x8a,0xbe]

s_movreld_b64 s[10:11], 0
// CHECK: [0x80,0x31,0x8a,0xbe]

s_movreld_b64 s[10:11], -1
// CHECK: [0xc1,0x31,0x8a,0xbe]

s_movreld_b64 s[10:11], 0.5
// CHECK: [0xf0,0x31,0x8a,0xbe]

s_movreld_b64 s[10:11], -4.0
// CHECK: [0xf7,0x31,0x8a,0xbe]

s_movreld_b64 s[10:11], 0xaf123456
// CHECK: [0xff,0x31,0x8a,0xbe,0x56,0x34,0x12,0xaf]

s_movreld_b64 s[10:11], 0x3f717273
// CHECK: [0xff,0x31,0x8a,0xbe,0x73,0x72,0x71,0x3f]

s_cbranch_join s1
// CHECK: [0x01,0x32,0x80,0xbe]

s_cbranch_join s103
// CHECK: [0x67,0x32,0x80,0xbe]

s_cbranch_join flat_scratch_lo
// CHECK: [0x68,0x32,0x80,0xbe]

s_cbranch_join flat_scratch_hi
// CHECK: [0x69,0x32,0x80,0xbe]

s_cbranch_join vcc_lo
// CHECK: [0x6a,0x32,0x80,0xbe]

s_cbranch_join vcc_hi
// CHECK: [0x6b,0x32,0x80,0xbe]

s_cbranch_join tba_lo
// CHECK: [0x6c,0x32,0x80,0xbe]

s_cbranch_join tba_hi
// CHECK: [0x6d,0x32,0x80,0xbe]

s_cbranch_join tma_lo
// CHECK: [0x6e,0x32,0x80,0xbe]

s_cbranch_join tma_hi
// CHECK: [0x6f,0x32,0x80,0xbe]

s_cbranch_join ttmp11
// CHECK: [0x7b,0x32,0x80,0xbe]

s_cbranch_join m0
// CHECK: [0x7c,0x32,0x80,0xbe]

s_cbranch_join exec_lo
// CHECK: [0x7e,0x32,0x80,0xbe]

s_cbranch_join exec_hi
// CHECK: [0x7f,0x32,0x80,0xbe]

s_abs_i32 s5, s1
// CHECK: [0x01,0x34,0x85,0xbe]

s_abs_i32 s103, s1
// CHECK: [0x01,0x34,0xe7,0xbe]

s_abs_i32 flat_scratch_lo, s1
// CHECK: [0x01,0x34,0xe8,0xbe]

s_abs_i32 flat_scratch_hi, s1
// CHECK: [0x01,0x34,0xe9,0xbe]

s_abs_i32 vcc_lo, s1
// CHECK: [0x01,0x34,0xea,0xbe]

s_abs_i32 vcc_hi, s1
// CHECK: [0x01,0x34,0xeb,0xbe]

s_abs_i32 tba_lo, s1
// CHECK: [0x01,0x34,0xec,0xbe]

s_abs_i32 tba_hi, s1
// CHECK: [0x01,0x34,0xed,0xbe]

s_abs_i32 tma_lo, s1
// CHECK: [0x01,0x34,0xee,0xbe]

s_abs_i32 tma_hi, s1
// CHECK: [0x01,0x34,0xef,0xbe]

s_abs_i32 ttmp11, s1
// CHECK: [0x01,0x34,0xfb,0xbe]

s_abs_i32 m0, s1
// CHECK: [0x01,0x34,0xfc,0xbe]

s_abs_i32 exec_lo, s1
// CHECK: [0x01,0x34,0xfe,0xbe]

s_abs_i32 exec_hi, s1
// CHECK: [0x01,0x34,0xff,0xbe]

s_abs_i32 s5, s103
// CHECK: [0x67,0x34,0x85,0xbe]

s_abs_i32 s5, flat_scratch_lo
// CHECK: [0x68,0x34,0x85,0xbe]

s_abs_i32 s5, flat_scratch_hi
// CHECK: [0x69,0x34,0x85,0xbe]

s_abs_i32 s5, vcc_lo
// CHECK: [0x6a,0x34,0x85,0xbe]

s_abs_i32 s5, vcc_hi
// CHECK: [0x6b,0x34,0x85,0xbe]

s_abs_i32 s5, tba_lo
// CHECK: [0x6c,0x34,0x85,0xbe]

s_abs_i32 s5, tba_hi
// CHECK: [0x6d,0x34,0x85,0xbe]

s_abs_i32 s5, tma_lo
// CHECK: [0x6e,0x34,0x85,0xbe]

s_abs_i32 s5, tma_hi
// CHECK: [0x6f,0x34,0x85,0xbe]

s_abs_i32 s5, ttmp11
// CHECK: [0x7b,0x34,0x85,0xbe]

s_abs_i32 s5, m0
// CHECK: [0x7c,0x34,0x85,0xbe]

s_abs_i32 s5, exec_lo
// CHECK: [0x7e,0x34,0x85,0xbe]

s_abs_i32 s5, exec_hi
// CHECK: [0x7f,0x34,0x85,0xbe]

s_abs_i32 s5, 0
// CHECK: [0x80,0x34,0x85,0xbe]

s_abs_i32 s5, -1
// CHECK: [0xc1,0x34,0x85,0xbe]

s_abs_i32 s5, 0.5
// CHECK: [0xf0,0x34,0x85,0xbe]

s_abs_i32 s5, -4.0
// CHECK: [0xf7,0x34,0x85,0xbe]

s_abs_i32 s5, 0xaf123456
// CHECK: [0xff,0x34,0x85,0xbe,0x56,0x34,0x12,0xaf]

s_abs_i32 s5, 0x3f717273
// CHECK: [0xff,0x34,0x85,0xbe,0x73,0x72,0x71,0x3f]

s_mov_fed_b32 s5, s1
// CHECK: [0x01,0x35,0x85,0xbe]

s_mov_fed_b32 s103, s1
// CHECK: [0x01,0x35,0xe7,0xbe]

s_mov_fed_b32 flat_scratch_lo, s1
// CHECK: [0x01,0x35,0xe8,0xbe]

s_mov_fed_b32 flat_scratch_hi, s1
// CHECK: [0x01,0x35,0xe9,0xbe]

s_mov_fed_b32 vcc_lo, s1
// CHECK: [0x01,0x35,0xea,0xbe]

s_mov_fed_b32 vcc_hi, s1
// CHECK: [0x01,0x35,0xeb,0xbe]

s_mov_fed_b32 tba_lo, s1
// CHECK: [0x01,0x35,0xec,0xbe]

s_mov_fed_b32 tba_hi, s1
// CHECK: [0x01,0x35,0xed,0xbe]

s_mov_fed_b32 tma_lo, s1
// CHECK: [0x01,0x35,0xee,0xbe]

s_mov_fed_b32 tma_hi, s1
// CHECK: [0x01,0x35,0xef,0xbe]

s_mov_fed_b32 ttmp11, s1
// CHECK: [0x01,0x35,0xfb,0xbe]

s_mov_fed_b32 m0, s1
// CHECK: [0x01,0x35,0xfc,0xbe]

s_mov_fed_b32 exec_lo, s1
// CHECK: [0x01,0x35,0xfe,0xbe]

s_mov_fed_b32 exec_hi, s1
// CHECK: [0x01,0x35,0xff,0xbe]

s_mov_fed_b32 s5, s103
// CHECK: [0x67,0x35,0x85,0xbe]

s_mov_fed_b32 s5, flat_scratch_lo
// CHECK: [0x68,0x35,0x85,0xbe]

s_mov_fed_b32 s5, flat_scratch_hi
// CHECK: [0x69,0x35,0x85,0xbe]

s_mov_fed_b32 s5, vcc_lo
// CHECK: [0x6a,0x35,0x85,0xbe]

s_mov_fed_b32 s5, vcc_hi
// CHECK: [0x6b,0x35,0x85,0xbe]

s_mov_fed_b32 s5, tba_lo
// CHECK: [0x6c,0x35,0x85,0xbe]

s_mov_fed_b32 s5, tba_hi
// CHECK: [0x6d,0x35,0x85,0xbe]

s_mov_fed_b32 s5, tma_lo
// CHECK: [0x6e,0x35,0x85,0xbe]

s_mov_fed_b32 s5, tma_hi
// CHECK: [0x6f,0x35,0x85,0xbe]

s_mov_fed_b32 s5, ttmp11
// CHECK: [0x7b,0x35,0x85,0xbe]

s_mov_fed_b32 s5, m0
// CHECK: [0x7c,0x35,0x85,0xbe]

s_mov_fed_b32 s5, exec_lo
// CHECK: [0x7e,0x35,0x85,0xbe]

s_mov_fed_b32 s5, exec_hi
// CHECK: [0x7f,0x35,0x85,0xbe]

s_mov_fed_b32 s5, 0
// CHECK: [0x80,0x35,0x85,0xbe]

s_mov_fed_b32 s5, -1
// CHECK: [0xc1,0x35,0x85,0xbe]

s_mov_fed_b32 s5, 0.5
// CHECK: [0xf0,0x35,0x85,0xbe]

s_mov_fed_b32 s5, -4.0
// CHECK: [0xf7,0x35,0x85,0xbe]

s_mov_fed_b32 s5, 0xaf123456
// CHECK: [0xff,0x35,0x85,0xbe,0x56,0x34,0x12,0xaf]

s_mov_fed_b32 s5, 0x3f717273
// CHECK: [0xff,0x35,0x85,0xbe,0x73,0x72,0x71,0x3f]

s_add_u32 s5, s1, s2
// CHECK: [0x01,0x02,0x05,0x80]

s_add_u32 s103, s1, s2
// CHECK: [0x01,0x02,0x67,0x80]

s_add_u32 flat_scratch_lo, s1, s2
// CHECK: [0x01,0x02,0x68,0x80]

s_add_u32 flat_scratch_hi, s1, s2
// CHECK: [0x01,0x02,0x69,0x80]

s_add_u32 vcc_lo, s1, s2
// CHECK: [0x01,0x02,0x6a,0x80]

s_add_u32 vcc_hi, s1, s2
// CHECK: [0x01,0x02,0x6b,0x80]

s_add_u32 tba_lo, s1, s2
// CHECK: [0x01,0x02,0x6c,0x80]

s_add_u32 tba_hi, s1, s2
// CHECK: [0x01,0x02,0x6d,0x80]

s_add_u32 tma_lo, s1, s2
// CHECK: [0x01,0x02,0x6e,0x80]

s_add_u32 tma_hi, s1, s2
// CHECK: [0x01,0x02,0x6f,0x80]

s_add_u32 ttmp11, s1, s2
// CHECK: [0x01,0x02,0x7b,0x80]

s_add_u32 m0, s1, s2
// CHECK: [0x01,0x02,0x7c,0x80]

s_add_u32 exec_lo, s1, s2
// CHECK: [0x01,0x02,0x7e,0x80]

s_add_u32 exec_hi, s1, s2
// CHECK: [0x01,0x02,0x7f,0x80]

s_add_u32 s5, s103, s2
// CHECK: [0x67,0x02,0x05,0x80]

s_add_u32 s5, flat_scratch_lo, s2
// CHECK: [0x68,0x02,0x05,0x80]

s_add_u32 s5, flat_scratch_hi, s2
// CHECK: [0x69,0x02,0x05,0x80]

s_add_u32 s5, vcc_lo, s2
// CHECK: [0x6a,0x02,0x05,0x80]

s_add_u32 s5, vcc_hi, s2
// CHECK: [0x6b,0x02,0x05,0x80]

s_add_u32 s5, tba_lo, s2
// CHECK: [0x6c,0x02,0x05,0x80]

s_add_u32 s5, tba_hi, s2
// CHECK: [0x6d,0x02,0x05,0x80]

s_add_u32 s5, tma_lo, s2
// CHECK: [0x6e,0x02,0x05,0x80]

s_add_u32 s5, tma_hi, s2
// CHECK: [0x6f,0x02,0x05,0x80]

s_add_u32 s5, ttmp11, s2
// CHECK: [0x7b,0x02,0x05,0x80]

s_add_u32 s5, m0, s2
// CHECK: [0x7c,0x02,0x05,0x80]

s_add_u32 s5, exec_lo, s2
// CHECK: [0x7e,0x02,0x05,0x80]

s_add_u32 s5, exec_hi, s2
// CHECK: [0x7f,0x02,0x05,0x80]

s_add_u32 s5, 0, s2
// CHECK: [0x80,0x02,0x05,0x80]

s_add_u32 s5, -1, s2
// CHECK: [0xc1,0x02,0x05,0x80]

s_add_u32 s5, 0.5, s2
// CHECK: [0xf0,0x02,0x05,0x80]

s_add_u32 s5, -4.0, s2
// CHECK: [0xf7,0x02,0x05,0x80]

s_add_u32 s5, 0xaf123456, s2
// CHECK: [0xff,0x02,0x05,0x80,0x56,0x34,0x12,0xaf]

s_add_u32 s5, 0x3f717273, s2
// CHECK: [0xff,0x02,0x05,0x80,0x73,0x72,0x71,0x3f]

s_add_u32 s5, s1, s103
// CHECK: [0x01,0x67,0x05,0x80]

s_add_u32 s5, s1, flat_scratch_lo
// CHECK: [0x01,0x68,0x05,0x80]

s_add_u32 s5, s1, flat_scratch_hi
// CHECK: [0x01,0x69,0x05,0x80]

s_add_u32 s5, s1, vcc_lo
// CHECK: [0x01,0x6a,0x05,0x80]

s_add_u32 s5, s1, vcc_hi
// CHECK: [0x01,0x6b,0x05,0x80]

s_add_u32 s5, s1, tba_lo
// CHECK: [0x01,0x6c,0x05,0x80]

s_add_u32 s5, s1, tba_hi
// CHECK: [0x01,0x6d,0x05,0x80]

s_add_u32 s5, s1, tma_lo
// CHECK: [0x01,0x6e,0x05,0x80]

s_add_u32 s5, s1, tma_hi
// CHECK: [0x01,0x6f,0x05,0x80]

s_add_u32 s5, s1, ttmp11
// CHECK: [0x01,0x7b,0x05,0x80]

s_add_u32 s5, s1, m0
// CHECK: [0x01,0x7c,0x05,0x80]

s_add_u32 s5, s1, exec_lo
// CHECK: [0x01,0x7e,0x05,0x80]

s_add_u32 s5, s1, exec_hi
// CHECK: [0x01,0x7f,0x05,0x80]

s_add_u32 s5, s1, 0
// CHECK: [0x01,0x80,0x05,0x80]

s_add_u32 s5, s1, -1
// CHECK: [0x01,0xc1,0x05,0x80]

s_add_u32 s5, s1, 0.5
// CHECK: [0x01,0xf0,0x05,0x80]

s_add_u32 s5, s1, -4.0
// CHECK: [0x01,0xf7,0x05,0x80]

s_add_u32 s5, s1, 0xaf123456
// CHECK: [0x01,0xff,0x05,0x80,0x56,0x34,0x12,0xaf]

s_add_u32 s5, s1, 0x3f717273
// CHECK: [0x01,0xff,0x05,0x80,0x73,0x72,0x71,0x3f]

s_sub_u32 s5, s1, s2
// CHECK: [0x01,0x02,0x85,0x80]

s_sub_u32 s103, s1, s2
// CHECK: [0x01,0x02,0xe7,0x80]

s_sub_u32 flat_scratch_lo, s1, s2
// CHECK: [0x01,0x02,0xe8,0x80]

s_sub_u32 flat_scratch_hi, s1, s2
// CHECK: [0x01,0x02,0xe9,0x80]

s_sub_u32 vcc_lo, s1, s2
// CHECK: [0x01,0x02,0xea,0x80]

s_sub_u32 vcc_hi, s1, s2
// CHECK: [0x01,0x02,0xeb,0x80]

s_sub_u32 tba_lo, s1, s2
// CHECK: [0x01,0x02,0xec,0x80]

s_sub_u32 tba_hi, s1, s2
// CHECK: [0x01,0x02,0xed,0x80]

s_sub_u32 tma_lo, s1, s2
// CHECK: [0x01,0x02,0xee,0x80]

s_sub_u32 tma_hi, s1, s2
// CHECK: [0x01,0x02,0xef,0x80]

s_sub_u32 ttmp11, s1, s2
// CHECK: [0x01,0x02,0xfb,0x80]

s_sub_u32 m0, s1, s2
// CHECK: [0x01,0x02,0xfc,0x80]

s_sub_u32 exec_lo, s1, s2
// CHECK: [0x01,0x02,0xfe,0x80]

s_sub_u32 exec_hi, s1, s2
// CHECK: [0x01,0x02,0xff,0x80]

s_sub_u32 s5, s103, s2
// CHECK: [0x67,0x02,0x85,0x80]

s_sub_u32 s5, flat_scratch_lo, s2
// CHECK: [0x68,0x02,0x85,0x80]

s_sub_u32 s5, flat_scratch_hi, s2
// CHECK: [0x69,0x02,0x85,0x80]

s_sub_u32 s5, vcc_lo, s2
// CHECK: [0x6a,0x02,0x85,0x80]

s_sub_u32 s5, vcc_hi, s2
// CHECK: [0x6b,0x02,0x85,0x80]

s_sub_u32 s5, tba_lo, s2
// CHECK: [0x6c,0x02,0x85,0x80]

s_sub_u32 s5, tba_hi, s2
// CHECK: [0x6d,0x02,0x85,0x80]

s_sub_u32 s5, tma_lo, s2
// CHECK: [0x6e,0x02,0x85,0x80]

s_sub_u32 s5, tma_hi, s2
// CHECK: [0x6f,0x02,0x85,0x80]

s_sub_u32 s5, ttmp11, s2
// CHECK: [0x7b,0x02,0x85,0x80]

s_sub_u32 s5, m0, s2
// CHECK: [0x7c,0x02,0x85,0x80]

s_sub_u32 s5, exec_lo, s2
// CHECK: [0x7e,0x02,0x85,0x80]

s_sub_u32 s5, exec_hi, s2
// CHECK: [0x7f,0x02,0x85,0x80]

s_sub_u32 s5, 0, s2
// CHECK: [0x80,0x02,0x85,0x80]

s_sub_u32 s5, -1, s2
// CHECK: [0xc1,0x02,0x85,0x80]

s_sub_u32 s5, 0.5, s2
// CHECK: [0xf0,0x02,0x85,0x80]

s_sub_u32 s5, -4.0, s2
// CHECK: [0xf7,0x02,0x85,0x80]

s_sub_u32 s5, 0xaf123456, s2
// CHECK: [0xff,0x02,0x85,0x80,0x56,0x34,0x12,0xaf]

s_sub_u32 s5, 0x3f717273, s2
// CHECK: [0xff,0x02,0x85,0x80,0x73,0x72,0x71,0x3f]

s_sub_u32 s5, s1, s103
// CHECK: [0x01,0x67,0x85,0x80]

s_sub_u32 s5, s1, flat_scratch_lo
// CHECK: [0x01,0x68,0x85,0x80]

s_sub_u32 s5, s1, flat_scratch_hi
// CHECK: [0x01,0x69,0x85,0x80]

s_sub_u32 s5, s1, vcc_lo
// CHECK: [0x01,0x6a,0x85,0x80]

s_sub_u32 s5, s1, vcc_hi
// CHECK: [0x01,0x6b,0x85,0x80]

s_sub_u32 s5, s1, tba_lo
// CHECK: [0x01,0x6c,0x85,0x80]

s_sub_u32 s5, s1, tba_hi
// CHECK: [0x01,0x6d,0x85,0x80]

s_sub_u32 s5, s1, tma_lo
// CHECK: [0x01,0x6e,0x85,0x80]

s_sub_u32 s5, s1, tma_hi
// CHECK: [0x01,0x6f,0x85,0x80]

s_sub_u32 s5, s1, ttmp11
// CHECK: [0x01,0x7b,0x85,0x80]

s_sub_u32 s5, s1, m0
// CHECK: [0x01,0x7c,0x85,0x80]

s_sub_u32 s5, s1, exec_lo
// CHECK: [0x01,0x7e,0x85,0x80]

s_sub_u32 s5, s1, exec_hi
// CHECK: [0x01,0x7f,0x85,0x80]

s_sub_u32 s5, s1, 0
// CHECK: [0x01,0x80,0x85,0x80]

s_sub_u32 s5, s1, -1
// CHECK: [0x01,0xc1,0x85,0x80]

s_sub_u32 s5, s1, 0.5
// CHECK: [0x01,0xf0,0x85,0x80]

s_sub_u32 s5, s1, -4.0
// CHECK: [0x01,0xf7,0x85,0x80]

s_sub_u32 s5, s1, 0xaf123456
// CHECK: [0x01,0xff,0x85,0x80,0x56,0x34,0x12,0xaf]

s_sub_u32 s5, s1, 0x3f717273
// CHECK: [0x01,0xff,0x85,0x80,0x73,0x72,0x71,0x3f]

s_add_i32 s5, s1, s2
// CHECK: [0x01,0x02,0x05,0x81]

s_add_i32 s103, s1, s2
// CHECK: [0x01,0x02,0x67,0x81]

s_add_i32 flat_scratch_lo, s1, s2
// CHECK: [0x01,0x02,0x68,0x81]

s_add_i32 flat_scratch_hi, s1, s2
// CHECK: [0x01,0x02,0x69,0x81]

s_add_i32 vcc_lo, s1, s2
// CHECK: [0x01,0x02,0x6a,0x81]

s_add_i32 vcc_hi, s1, s2
// CHECK: [0x01,0x02,0x6b,0x81]

s_add_i32 tba_lo, s1, s2
// CHECK: [0x01,0x02,0x6c,0x81]

s_add_i32 tba_hi, s1, s2
// CHECK: [0x01,0x02,0x6d,0x81]

s_add_i32 tma_lo, s1, s2
// CHECK: [0x01,0x02,0x6e,0x81]

s_add_i32 tma_hi, s1, s2
// CHECK: [0x01,0x02,0x6f,0x81]

s_add_i32 ttmp11, s1, s2
// CHECK: [0x01,0x02,0x7b,0x81]

s_add_i32 m0, s1, s2
// CHECK: [0x01,0x02,0x7c,0x81]

s_add_i32 exec_lo, s1, s2
// CHECK: [0x01,0x02,0x7e,0x81]

s_add_i32 exec_hi, s1, s2
// CHECK: [0x01,0x02,0x7f,0x81]

s_add_i32 s5, s103, s2
// CHECK: [0x67,0x02,0x05,0x81]

s_add_i32 s5, flat_scratch_lo, s2
// CHECK: [0x68,0x02,0x05,0x81]

s_add_i32 s5, flat_scratch_hi, s2
// CHECK: [0x69,0x02,0x05,0x81]

s_add_i32 s5, vcc_lo, s2
// CHECK: [0x6a,0x02,0x05,0x81]

s_add_i32 s5, vcc_hi, s2
// CHECK: [0x6b,0x02,0x05,0x81]

s_add_i32 s5, tba_lo, s2
// CHECK: [0x6c,0x02,0x05,0x81]

s_add_i32 s5, tba_hi, s2
// CHECK: [0x6d,0x02,0x05,0x81]

s_add_i32 s5, tma_lo, s2
// CHECK: [0x6e,0x02,0x05,0x81]

s_add_i32 s5, tma_hi, s2
// CHECK: [0x6f,0x02,0x05,0x81]

s_add_i32 s5, ttmp11, s2
// CHECK: [0x7b,0x02,0x05,0x81]

s_add_i32 s5, m0, s2
// CHECK: [0x7c,0x02,0x05,0x81]

s_add_i32 s5, exec_lo, s2
// CHECK: [0x7e,0x02,0x05,0x81]

s_add_i32 s5, exec_hi, s2
// CHECK: [0x7f,0x02,0x05,0x81]

s_add_i32 s5, 0, s2
// CHECK: [0x80,0x02,0x05,0x81]

s_add_i32 s5, -1, s2
// CHECK: [0xc1,0x02,0x05,0x81]

s_add_i32 s5, 0.5, s2
// CHECK: [0xf0,0x02,0x05,0x81]

s_add_i32 s5, -4.0, s2
// CHECK: [0xf7,0x02,0x05,0x81]

s_add_i32 s5, 0xaf123456, s2
// CHECK: [0xff,0x02,0x05,0x81,0x56,0x34,0x12,0xaf]

s_add_i32 s5, 0x3f717273, s2
// CHECK: [0xff,0x02,0x05,0x81,0x73,0x72,0x71,0x3f]

s_add_i32 s5, s1, s103
// CHECK: [0x01,0x67,0x05,0x81]

s_add_i32 s5, s1, flat_scratch_lo
// CHECK: [0x01,0x68,0x05,0x81]

s_add_i32 s5, s1, flat_scratch_hi
// CHECK: [0x01,0x69,0x05,0x81]

s_add_i32 s5, s1, vcc_lo
// CHECK: [0x01,0x6a,0x05,0x81]

s_add_i32 s5, s1, vcc_hi
// CHECK: [0x01,0x6b,0x05,0x81]

s_add_i32 s5, s1, tba_lo
// CHECK: [0x01,0x6c,0x05,0x81]

s_add_i32 s5, s1, tba_hi
// CHECK: [0x01,0x6d,0x05,0x81]

s_add_i32 s5, s1, tma_lo
// CHECK: [0x01,0x6e,0x05,0x81]

s_add_i32 s5, s1, tma_hi
// CHECK: [0x01,0x6f,0x05,0x81]

s_add_i32 s5, s1, ttmp11
// CHECK: [0x01,0x7b,0x05,0x81]

s_add_i32 s5, s1, m0
// CHECK: [0x01,0x7c,0x05,0x81]

s_add_i32 s5, s1, exec_lo
// CHECK: [0x01,0x7e,0x05,0x81]

s_add_i32 s5, s1, exec_hi
// CHECK: [0x01,0x7f,0x05,0x81]

s_add_i32 s5, s1, 0
// CHECK: [0x01,0x80,0x05,0x81]

s_add_i32 s5, s1, -1
// CHECK: [0x01,0xc1,0x05,0x81]

s_add_i32 s5, s1, 0.5
// CHECK: [0x01,0xf0,0x05,0x81]

s_add_i32 s5, s1, -4.0
// CHECK: [0x01,0xf7,0x05,0x81]

s_add_i32 s5, s1, 0xaf123456
// CHECK: [0x01,0xff,0x05,0x81,0x56,0x34,0x12,0xaf]

s_add_i32 s5, s1, 0x3f717273
// CHECK: [0x01,0xff,0x05,0x81,0x73,0x72,0x71,0x3f]

s_sub_i32 s5, s1, s2
// CHECK: [0x01,0x02,0x85,0x81]

s_sub_i32 s103, s1, s2
// CHECK: [0x01,0x02,0xe7,0x81]

s_sub_i32 flat_scratch_lo, s1, s2
// CHECK: [0x01,0x02,0xe8,0x81]

s_sub_i32 flat_scratch_hi, s1, s2
// CHECK: [0x01,0x02,0xe9,0x81]

s_sub_i32 vcc_lo, s1, s2
// CHECK: [0x01,0x02,0xea,0x81]

s_sub_i32 vcc_hi, s1, s2
// CHECK: [0x01,0x02,0xeb,0x81]

s_sub_i32 tba_lo, s1, s2
// CHECK: [0x01,0x02,0xec,0x81]

s_sub_i32 tba_hi, s1, s2
// CHECK: [0x01,0x02,0xed,0x81]

s_sub_i32 tma_lo, s1, s2
// CHECK: [0x01,0x02,0xee,0x81]

s_sub_i32 tma_hi, s1, s2
// CHECK: [0x01,0x02,0xef,0x81]

s_sub_i32 ttmp11, s1, s2
// CHECK: [0x01,0x02,0xfb,0x81]

s_sub_i32 m0, s1, s2
// CHECK: [0x01,0x02,0xfc,0x81]

s_sub_i32 exec_lo, s1, s2
// CHECK: [0x01,0x02,0xfe,0x81]

s_sub_i32 exec_hi, s1, s2
// CHECK: [0x01,0x02,0xff,0x81]

s_sub_i32 s5, s103, s2
// CHECK: [0x67,0x02,0x85,0x81]

s_sub_i32 s5, flat_scratch_lo, s2
// CHECK: [0x68,0x02,0x85,0x81]

s_sub_i32 s5, flat_scratch_hi, s2
// CHECK: [0x69,0x02,0x85,0x81]

s_sub_i32 s5, vcc_lo, s2
// CHECK: [0x6a,0x02,0x85,0x81]

s_sub_i32 s5, vcc_hi, s2
// CHECK: [0x6b,0x02,0x85,0x81]

s_sub_i32 s5, tba_lo, s2
// CHECK: [0x6c,0x02,0x85,0x81]

s_sub_i32 s5, tba_hi, s2
// CHECK: [0x6d,0x02,0x85,0x81]

s_sub_i32 s5, tma_lo, s2
// CHECK: [0x6e,0x02,0x85,0x81]

s_sub_i32 s5, tma_hi, s2
// CHECK: [0x6f,0x02,0x85,0x81]

s_sub_i32 s5, ttmp11, s2
// CHECK: [0x7b,0x02,0x85,0x81]

s_sub_i32 s5, m0, s2
// CHECK: [0x7c,0x02,0x85,0x81]

s_sub_i32 s5, exec_lo, s2
// CHECK: [0x7e,0x02,0x85,0x81]

s_sub_i32 s5, exec_hi, s2
// CHECK: [0x7f,0x02,0x85,0x81]

s_sub_i32 s5, 0, s2
// CHECK: [0x80,0x02,0x85,0x81]

s_sub_i32 s5, -1, s2
// CHECK: [0xc1,0x02,0x85,0x81]

s_sub_i32 s5, 0.5, s2
// CHECK: [0xf0,0x02,0x85,0x81]

s_sub_i32 s5, -4.0, s2
// CHECK: [0xf7,0x02,0x85,0x81]

s_sub_i32 s5, 0xaf123456, s2
// CHECK: [0xff,0x02,0x85,0x81,0x56,0x34,0x12,0xaf]

s_sub_i32 s5, 0x3f717273, s2
// CHECK: [0xff,0x02,0x85,0x81,0x73,0x72,0x71,0x3f]

s_sub_i32 s5, s1, s103
// CHECK: [0x01,0x67,0x85,0x81]

s_sub_i32 s5, s1, flat_scratch_lo
// CHECK: [0x01,0x68,0x85,0x81]

s_sub_i32 s5, s1, flat_scratch_hi
// CHECK: [0x01,0x69,0x85,0x81]

s_sub_i32 s5, s1, vcc_lo
// CHECK: [0x01,0x6a,0x85,0x81]

s_sub_i32 s5, s1, vcc_hi
// CHECK: [0x01,0x6b,0x85,0x81]

s_sub_i32 s5, s1, tba_lo
// CHECK: [0x01,0x6c,0x85,0x81]

s_sub_i32 s5, s1, tba_hi
// CHECK: [0x01,0x6d,0x85,0x81]

s_sub_i32 s5, s1, tma_lo
// CHECK: [0x01,0x6e,0x85,0x81]

s_sub_i32 s5, s1, tma_hi
// CHECK: [0x01,0x6f,0x85,0x81]

s_sub_i32 s5, s1, ttmp11
// CHECK: [0x01,0x7b,0x85,0x81]

s_sub_i32 s5, s1, m0
// CHECK: [0x01,0x7c,0x85,0x81]

s_sub_i32 s5, s1, exec_lo
// CHECK: [0x01,0x7e,0x85,0x81]

s_sub_i32 s5, s1, exec_hi
// CHECK: [0x01,0x7f,0x85,0x81]

s_sub_i32 s5, s1, 0
// CHECK: [0x01,0x80,0x85,0x81]

s_sub_i32 s5, s1, -1
// CHECK: [0x01,0xc1,0x85,0x81]

s_sub_i32 s5, s1, 0.5
// CHECK: [0x01,0xf0,0x85,0x81]

s_sub_i32 s5, s1, -4.0
// CHECK: [0x01,0xf7,0x85,0x81]

s_sub_i32 s5, s1, 0xaf123456
// CHECK: [0x01,0xff,0x85,0x81,0x56,0x34,0x12,0xaf]

s_sub_i32 s5, s1, 0x3f717273
// CHECK: [0x01,0xff,0x85,0x81,0x73,0x72,0x71,0x3f]

s_addc_u32 s5, s1, s2
// CHECK: [0x01,0x02,0x05,0x82]

s_addc_u32 s103, s1, s2
// CHECK: [0x01,0x02,0x67,0x82]

s_addc_u32 flat_scratch_lo, s1, s2
// CHECK: [0x01,0x02,0x68,0x82]

s_addc_u32 flat_scratch_hi, s1, s2
// CHECK: [0x01,0x02,0x69,0x82]

s_addc_u32 vcc_lo, s1, s2
// CHECK: [0x01,0x02,0x6a,0x82]

s_addc_u32 vcc_hi, s1, s2
// CHECK: [0x01,0x02,0x6b,0x82]

s_addc_u32 tba_lo, s1, s2
// CHECK: [0x01,0x02,0x6c,0x82]

s_addc_u32 tba_hi, s1, s2
// CHECK: [0x01,0x02,0x6d,0x82]

s_addc_u32 tma_lo, s1, s2
// CHECK: [0x01,0x02,0x6e,0x82]

s_addc_u32 tma_hi, s1, s2
// CHECK: [0x01,0x02,0x6f,0x82]

s_addc_u32 ttmp11, s1, s2
// CHECK: [0x01,0x02,0x7b,0x82]

s_addc_u32 m0, s1, s2
// CHECK: [0x01,0x02,0x7c,0x82]

s_addc_u32 exec_lo, s1, s2
// CHECK: [0x01,0x02,0x7e,0x82]

s_addc_u32 exec_hi, s1, s2
// CHECK: [0x01,0x02,0x7f,0x82]

s_addc_u32 s5, s103, s2
// CHECK: [0x67,0x02,0x05,0x82]

s_addc_u32 s5, flat_scratch_lo, s2
// CHECK: [0x68,0x02,0x05,0x82]

s_addc_u32 s5, flat_scratch_hi, s2
// CHECK: [0x69,0x02,0x05,0x82]

s_addc_u32 s5, vcc_lo, s2
// CHECK: [0x6a,0x02,0x05,0x82]

s_addc_u32 s5, vcc_hi, s2
// CHECK: [0x6b,0x02,0x05,0x82]

s_addc_u32 s5, tba_lo, s2
// CHECK: [0x6c,0x02,0x05,0x82]

s_addc_u32 s5, tba_hi, s2
// CHECK: [0x6d,0x02,0x05,0x82]

s_addc_u32 s5, tma_lo, s2
// CHECK: [0x6e,0x02,0x05,0x82]

s_addc_u32 s5, tma_hi, s2
// CHECK: [0x6f,0x02,0x05,0x82]

s_addc_u32 s5, ttmp11, s2
// CHECK: [0x7b,0x02,0x05,0x82]

s_addc_u32 s5, m0, s2
// CHECK: [0x7c,0x02,0x05,0x82]

s_addc_u32 s5, exec_lo, s2
// CHECK: [0x7e,0x02,0x05,0x82]

s_addc_u32 s5, exec_hi, s2
// CHECK: [0x7f,0x02,0x05,0x82]

s_addc_u32 s5, 0, s2
// CHECK: [0x80,0x02,0x05,0x82]

s_addc_u32 s5, -1, s2
// CHECK: [0xc1,0x02,0x05,0x82]

s_addc_u32 s5, 0.5, s2
// CHECK: [0xf0,0x02,0x05,0x82]

s_addc_u32 s5, -4.0, s2
// CHECK: [0xf7,0x02,0x05,0x82]

s_addc_u32 s5, 0xaf123456, s2
// CHECK: [0xff,0x02,0x05,0x82,0x56,0x34,0x12,0xaf]

s_addc_u32 s5, 0x3f717273, s2
// CHECK: [0xff,0x02,0x05,0x82,0x73,0x72,0x71,0x3f]

s_addc_u32 s5, s1, s103
// CHECK: [0x01,0x67,0x05,0x82]

s_addc_u32 s5, s1, flat_scratch_lo
// CHECK: [0x01,0x68,0x05,0x82]

s_addc_u32 s5, s1, flat_scratch_hi
// CHECK: [0x01,0x69,0x05,0x82]

s_addc_u32 s5, s1, vcc_lo
// CHECK: [0x01,0x6a,0x05,0x82]

s_addc_u32 s5, s1, vcc_hi
// CHECK: [0x01,0x6b,0x05,0x82]

s_addc_u32 s5, s1, tba_lo
// CHECK: [0x01,0x6c,0x05,0x82]

s_addc_u32 s5, s1, tba_hi
// CHECK: [0x01,0x6d,0x05,0x82]

s_addc_u32 s5, s1, tma_lo
// CHECK: [0x01,0x6e,0x05,0x82]

s_addc_u32 s5, s1, tma_hi
// CHECK: [0x01,0x6f,0x05,0x82]

s_addc_u32 s5, s1, ttmp11
// CHECK: [0x01,0x7b,0x05,0x82]

s_addc_u32 s5, s1, m0
// CHECK: [0x01,0x7c,0x05,0x82]

s_addc_u32 s5, s1, exec_lo
// CHECK: [0x01,0x7e,0x05,0x82]

s_addc_u32 s5, s1, exec_hi
// CHECK: [0x01,0x7f,0x05,0x82]

s_addc_u32 s5, s1, 0
// CHECK: [0x01,0x80,0x05,0x82]

s_addc_u32 s5, s1, -1
// CHECK: [0x01,0xc1,0x05,0x82]

s_addc_u32 s5, s1, 0.5
// CHECK: [0x01,0xf0,0x05,0x82]

s_addc_u32 s5, s1, -4.0
// CHECK: [0x01,0xf7,0x05,0x82]

s_addc_u32 s5, s1, 0xaf123456
// CHECK: [0x01,0xff,0x05,0x82,0x56,0x34,0x12,0xaf]

s_addc_u32 s5, s1, 0x3f717273
// CHECK: [0x01,0xff,0x05,0x82,0x73,0x72,0x71,0x3f]

s_subb_u32 s5, s1, s2
// CHECK: [0x01,0x02,0x85,0x82]

s_subb_u32 s103, s1, s2
// CHECK: [0x01,0x02,0xe7,0x82]

s_subb_u32 flat_scratch_lo, s1, s2
// CHECK: [0x01,0x02,0xe8,0x82]

s_subb_u32 flat_scratch_hi, s1, s2
// CHECK: [0x01,0x02,0xe9,0x82]

s_subb_u32 vcc_lo, s1, s2
// CHECK: [0x01,0x02,0xea,0x82]

s_subb_u32 vcc_hi, s1, s2
// CHECK: [0x01,0x02,0xeb,0x82]

s_subb_u32 tba_lo, s1, s2
// CHECK: [0x01,0x02,0xec,0x82]

s_subb_u32 tba_hi, s1, s2
// CHECK: [0x01,0x02,0xed,0x82]

s_subb_u32 tma_lo, s1, s2
// CHECK: [0x01,0x02,0xee,0x82]

s_subb_u32 tma_hi, s1, s2
// CHECK: [0x01,0x02,0xef,0x82]

s_subb_u32 ttmp11, s1, s2
// CHECK: [0x01,0x02,0xfb,0x82]

s_subb_u32 m0, s1, s2
// CHECK: [0x01,0x02,0xfc,0x82]

s_subb_u32 exec_lo, s1, s2
// CHECK: [0x01,0x02,0xfe,0x82]

s_subb_u32 exec_hi, s1, s2
// CHECK: [0x01,0x02,0xff,0x82]

s_subb_u32 s5, s103, s2
// CHECK: [0x67,0x02,0x85,0x82]

s_subb_u32 s5, flat_scratch_lo, s2
// CHECK: [0x68,0x02,0x85,0x82]

s_subb_u32 s5, flat_scratch_hi, s2
// CHECK: [0x69,0x02,0x85,0x82]

s_subb_u32 s5, vcc_lo, s2
// CHECK: [0x6a,0x02,0x85,0x82]

s_subb_u32 s5, vcc_hi, s2
// CHECK: [0x6b,0x02,0x85,0x82]

s_subb_u32 s5, tba_lo, s2
// CHECK: [0x6c,0x02,0x85,0x82]

s_subb_u32 s5, tba_hi, s2
// CHECK: [0x6d,0x02,0x85,0x82]

s_subb_u32 s5, tma_lo, s2
// CHECK: [0x6e,0x02,0x85,0x82]

s_subb_u32 s5, tma_hi, s2
// CHECK: [0x6f,0x02,0x85,0x82]

s_subb_u32 s5, ttmp11, s2
// CHECK: [0x7b,0x02,0x85,0x82]

s_subb_u32 s5, m0, s2
// CHECK: [0x7c,0x02,0x85,0x82]

s_subb_u32 s5, exec_lo, s2
// CHECK: [0x7e,0x02,0x85,0x82]

s_subb_u32 s5, exec_hi, s2
// CHECK: [0x7f,0x02,0x85,0x82]

s_subb_u32 s5, 0, s2
// CHECK: [0x80,0x02,0x85,0x82]

s_subb_u32 s5, -1, s2
// CHECK: [0xc1,0x02,0x85,0x82]

s_subb_u32 s5, 0.5, s2
// CHECK: [0xf0,0x02,0x85,0x82]

s_subb_u32 s5, -4.0, s2
// CHECK: [0xf7,0x02,0x85,0x82]

s_subb_u32 s5, 0xaf123456, s2
// CHECK: [0xff,0x02,0x85,0x82,0x56,0x34,0x12,0xaf]

s_subb_u32 s5, 0x3f717273, s2
// CHECK: [0xff,0x02,0x85,0x82,0x73,0x72,0x71,0x3f]

s_subb_u32 s5, s1, s103
// CHECK: [0x01,0x67,0x85,0x82]

s_subb_u32 s5, s1, flat_scratch_lo
// CHECK: [0x01,0x68,0x85,0x82]

s_subb_u32 s5, s1, flat_scratch_hi
// CHECK: [0x01,0x69,0x85,0x82]

s_subb_u32 s5, s1, vcc_lo
// CHECK: [0x01,0x6a,0x85,0x82]

s_subb_u32 s5, s1, vcc_hi
// CHECK: [0x01,0x6b,0x85,0x82]

s_subb_u32 s5, s1, tba_lo
// CHECK: [0x01,0x6c,0x85,0x82]

s_subb_u32 s5, s1, tba_hi
// CHECK: [0x01,0x6d,0x85,0x82]

s_subb_u32 s5, s1, tma_lo
// CHECK: [0x01,0x6e,0x85,0x82]

s_subb_u32 s5, s1, tma_hi
// CHECK: [0x01,0x6f,0x85,0x82]

s_subb_u32 s5, s1, ttmp11
// CHECK: [0x01,0x7b,0x85,0x82]

s_subb_u32 s5, s1, m0
// CHECK: [0x01,0x7c,0x85,0x82]

s_subb_u32 s5, s1, exec_lo
// CHECK: [0x01,0x7e,0x85,0x82]

s_subb_u32 s5, s1, exec_hi
// CHECK: [0x01,0x7f,0x85,0x82]

s_subb_u32 s5, s1, 0
// CHECK: [0x01,0x80,0x85,0x82]

s_subb_u32 s5, s1, -1
// CHECK: [0x01,0xc1,0x85,0x82]

s_subb_u32 s5, s1, 0.5
// CHECK: [0x01,0xf0,0x85,0x82]

s_subb_u32 s5, s1, -4.0
// CHECK: [0x01,0xf7,0x85,0x82]

s_subb_u32 s5, s1, 0xaf123456
// CHECK: [0x01,0xff,0x85,0x82,0x56,0x34,0x12,0xaf]

s_subb_u32 s5, s1, 0x3f717273
// CHECK: [0x01,0xff,0x85,0x82,0x73,0x72,0x71,0x3f]

s_min_i32 s5, s1, s2
// CHECK: [0x01,0x02,0x05,0x83]

s_min_i32 s103, s1, s2
// CHECK: [0x01,0x02,0x67,0x83]

s_min_i32 flat_scratch_lo, s1, s2
// CHECK: [0x01,0x02,0x68,0x83]

s_min_i32 flat_scratch_hi, s1, s2
// CHECK: [0x01,0x02,0x69,0x83]

s_min_i32 vcc_lo, s1, s2
// CHECK: [0x01,0x02,0x6a,0x83]

s_min_i32 vcc_hi, s1, s2
// CHECK: [0x01,0x02,0x6b,0x83]

s_min_i32 tba_lo, s1, s2
// CHECK: [0x01,0x02,0x6c,0x83]

s_min_i32 tba_hi, s1, s2
// CHECK: [0x01,0x02,0x6d,0x83]

s_min_i32 tma_lo, s1, s2
// CHECK: [0x01,0x02,0x6e,0x83]

s_min_i32 tma_hi, s1, s2
// CHECK: [0x01,0x02,0x6f,0x83]

s_min_i32 ttmp11, s1, s2
// CHECK: [0x01,0x02,0x7b,0x83]

s_min_i32 m0, s1, s2
// CHECK: [0x01,0x02,0x7c,0x83]

s_min_i32 exec_lo, s1, s2
// CHECK: [0x01,0x02,0x7e,0x83]

s_min_i32 exec_hi, s1, s2
// CHECK: [0x01,0x02,0x7f,0x83]

s_min_i32 s5, s103, s2
// CHECK: [0x67,0x02,0x05,0x83]

s_min_i32 s5, flat_scratch_lo, s2
// CHECK: [0x68,0x02,0x05,0x83]

s_min_i32 s5, flat_scratch_hi, s2
// CHECK: [0x69,0x02,0x05,0x83]

s_min_i32 s5, vcc_lo, s2
// CHECK: [0x6a,0x02,0x05,0x83]

s_min_i32 s5, vcc_hi, s2
// CHECK: [0x6b,0x02,0x05,0x83]

s_min_i32 s5, tba_lo, s2
// CHECK: [0x6c,0x02,0x05,0x83]

s_min_i32 s5, tba_hi, s2
// CHECK: [0x6d,0x02,0x05,0x83]

s_min_i32 s5, tma_lo, s2
// CHECK: [0x6e,0x02,0x05,0x83]

s_min_i32 s5, tma_hi, s2
// CHECK: [0x6f,0x02,0x05,0x83]

s_min_i32 s5, ttmp11, s2
// CHECK: [0x7b,0x02,0x05,0x83]

s_min_i32 s5, m0, s2
// CHECK: [0x7c,0x02,0x05,0x83]

s_min_i32 s5, exec_lo, s2
// CHECK: [0x7e,0x02,0x05,0x83]

s_min_i32 s5, exec_hi, s2
// CHECK: [0x7f,0x02,0x05,0x83]

s_min_i32 s5, 0, s2
// CHECK: [0x80,0x02,0x05,0x83]

s_min_i32 s5, -1, s2
// CHECK: [0xc1,0x02,0x05,0x83]

s_min_i32 s5, 0.5, s2
// CHECK: [0xf0,0x02,0x05,0x83]

s_min_i32 s5, -4.0, s2
// CHECK: [0xf7,0x02,0x05,0x83]

s_min_i32 s5, 0xaf123456, s2
// CHECK: [0xff,0x02,0x05,0x83,0x56,0x34,0x12,0xaf]

s_min_i32 s5, 0x3f717273, s2
// CHECK: [0xff,0x02,0x05,0x83,0x73,0x72,0x71,0x3f]

s_min_i32 s5, s1, s103
// CHECK: [0x01,0x67,0x05,0x83]

s_min_i32 s5, s1, flat_scratch_lo
// CHECK: [0x01,0x68,0x05,0x83]

s_min_i32 s5, s1, flat_scratch_hi
// CHECK: [0x01,0x69,0x05,0x83]

s_min_i32 s5, s1, vcc_lo
// CHECK: [0x01,0x6a,0x05,0x83]

s_min_i32 s5, s1, vcc_hi
// CHECK: [0x01,0x6b,0x05,0x83]

s_min_i32 s5, s1, tba_lo
// CHECK: [0x01,0x6c,0x05,0x83]

s_min_i32 s5, s1, tba_hi
// CHECK: [0x01,0x6d,0x05,0x83]

s_min_i32 s5, s1, tma_lo
// CHECK: [0x01,0x6e,0x05,0x83]

s_min_i32 s5, s1, tma_hi
// CHECK: [0x01,0x6f,0x05,0x83]

s_min_i32 s5, s1, ttmp11
// CHECK: [0x01,0x7b,0x05,0x83]

s_min_i32 s5, s1, m0
// CHECK: [0x01,0x7c,0x05,0x83]

s_min_i32 s5, s1, exec_lo
// CHECK: [0x01,0x7e,0x05,0x83]

s_min_i32 s5, s1, exec_hi
// CHECK: [0x01,0x7f,0x05,0x83]

s_min_i32 s5, s1, 0
// CHECK: [0x01,0x80,0x05,0x83]

s_min_i32 s5, s1, -1
// CHECK: [0x01,0xc1,0x05,0x83]

s_min_i32 s5, s1, 0.5
// CHECK: [0x01,0xf0,0x05,0x83]

s_min_i32 s5, s1, -4.0
// CHECK: [0x01,0xf7,0x05,0x83]

s_min_i32 s5, s1, 0xaf123456
// CHECK: [0x01,0xff,0x05,0x83,0x56,0x34,0x12,0xaf]

s_min_i32 s5, s1, 0x3f717273
// CHECK: [0x01,0xff,0x05,0x83,0x73,0x72,0x71,0x3f]

s_min_u32 s5, s1, s2
// CHECK: [0x01,0x02,0x85,0x83]

s_min_u32 s103, s1, s2
// CHECK: [0x01,0x02,0xe7,0x83]

s_min_u32 flat_scratch_lo, s1, s2
// CHECK: [0x01,0x02,0xe8,0x83]

s_min_u32 flat_scratch_hi, s1, s2
// CHECK: [0x01,0x02,0xe9,0x83]

s_min_u32 vcc_lo, s1, s2
// CHECK: [0x01,0x02,0xea,0x83]

s_min_u32 vcc_hi, s1, s2
// CHECK: [0x01,0x02,0xeb,0x83]

s_min_u32 tba_lo, s1, s2
// CHECK: [0x01,0x02,0xec,0x83]

s_min_u32 tba_hi, s1, s2
// CHECK: [0x01,0x02,0xed,0x83]

s_min_u32 tma_lo, s1, s2
// CHECK: [0x01,0x02,0xee,0x83]

s_min_u32 tma_hi, s1, s2
// CHECK: [0x01,0x02,0xef,0x83]

s_min_u32 ttmp11, s1, s2
// CHECK: [0x01,0x02,0xfb,0x83]

s_min_u32 m0, s1, s2
// CHECK: [0x01,0x02,0xfc,0x83]

s_min_u32 exec_lo, s1, s2
// CHECK: [0x01,0x02,0xfe,0x83]

s_min_u32 exec_hi, s1, s2
// CHECK: [0x01,0x02,0xff,0x83]

s_min_u32 s5, s103, s2
// CHECK: [0x67,0x02,0x85,0x83]

s_min_u32 s5, flat_scratch_lo, s2
// CHECK: [0x68,0x02,0x85,0x83]

s_min_u32 s5, flat_scratch_hi, s2
// CHECK: [0x69,0x02,0x85,0x83]

s_min_u32 s5, vcc_lo, s2
// CHECK: [0x6a,0x02,0x85,0x83]

s_min_u32 s5, vcc_hi, s2
// CHECK: [0x6b,0x02,0x85,0x83]

s_min_u32 s5, tba_lo, s2
// CHECK: [0x6c,0x02,0x85,0x83]

s_min_u32 s5, tba_hi, s2
// CHECK: [0x6d,0x02,0x85,0x83]

s_min_u32 s5, tma_lo, s2
// CHECK: [0x6e,0x02,0x85,0x83]

s_min_u32 s5, tma_hi, s2
// CHECK: [0x6f,0x02,0x85,0x83]

s_min_u32 s5, ttmp11, s2
// CHECK: [0x7b,0x02,0x85,0x83]

s_min_u32 s5, m0, s2
// CHECK: [0x7c,0x02,0x85,0x83]

s_min_u32 s5, exec_lo, s2
// CHECK: [0x7e,0x02,0x85,0x83]

s_min_u32 s5, exec_hi, s2
// CHECK: [0x7f,0x02,0x85,0x83]

s_min_u32 s5, 0, s2
// CHECK: [0x80,0x02,0x85,0x83]

s_min_u32 s5, -1, s2
// CHECK: [0xc1,0x02,0x85,0x83]

s_min_u32 s5, 0.5, s2
// CHECK: [0xf0,0x02,0x85,0x83]

s_min_u32 s5, -4.0, s2
// CHECK: [0xf7,0x02,0x85,0x83]

s_min_u32 s5, 0xaf123456, s2
// CHECK: [0xff,0x02,0x85,0x83,0x56,0x34,0x12,0xaf]

s_min_u32 s5, 0x3f717273, s2
// CHECK: [0xff,0x02,0x85,0x83,0x73,0x72,0x71,0x3f]

s_min_u32 s5, s1, s103
// CHECK: [0x01,0x67,0x85,0x83]

s_min_u32 s5, s1, flat_scratch_lo
// CHECK: [0x01,0x68,0x85,0x83]

s_min_u32 s5, s1, flat_scratch_hi
// CHECK: [0x01,0x69,0x85,0x83]

s_min_u32 s5, s1, vcc_lo
// CHECK: [0x01,0x6a,0x85,0x83]

s_min_u32 s5, s1, vcc_hi
// CHECK: [0x01,0x6b,0x85,0x83]

s_min_u32 s5, s1, tba_lo
// CHECK: [0x01,0x6c,0x85,0x83]

s_min_u32 s5, s1, tba_hi
// CHECK: [0x01,0x6d,0x85,0x83]

s_min_u32 s5, s1, tma_lo
// CHECK: [0x01,0x6e,0x85,0x83]

s_min_u32 s5, s1, tma_hi
// CHECK: [0x01,0x6f,0x85,0x83]

s_min_u32 s5, s1, ttmp11
// CHECK: [0x01,0x7b,0x85,0x83]

s_min_u32 s5, s1, m0
// CHECK: [0x01,0x7c,0x85,0x83]

s_min_u32 s5, s1, exec_lo
// CHECK: [0x01,0x7e,0x85,0x83]

s_min_u32 s5, s1, exec_hi
// CHECK: [0x01,0x7f,0x85,0x83]

s_min_u32 s5, s1, 0
// CHECK: [0x01,0x80,0x85,0x83]

s_min_u32 s5, s1, -1
// CHECK: [0x01,0xc1,0x85,0x83]

s_min_u32 s5, s1, 0.5
// CHECK: [0x01,0xf0,0x85,0x83]

s_min_u32 s5, s1, -4.0
// CHECK: [0x01,0xf7,0x85,0x83]

s_min_u32 s5, s1, 0xaf123456
// CHECK: [0x01,0xff,0x85,0x83,0x56,0x34,0x12,0xaf]

s_min_u32 s5, s1, 0x3f717273
// CHECK: [0x01,0xff,0x85,0x83,0x73,0x72,0x71,0x3f]

s_max_i32 s5, s1, s2
// CHECK: [0x01,0x02,0x05,0x84]

s_max_i32 s103, s1, s2
// CHECK: [0x01,0x02,0x67,0x84]

s_max_i32 flat_scratch_lo, s1, s2
// CHECK: [0x01,0x02,0x68,0x84]

s_max_i32 flat_scratch_hi, s1, s2
// CHECK: [0x01,0x02,0x69,0x84]

s_max_i32 vcc_lo, s1, s2
// CHECK: [0x01,0x02,0x6a,0x84]

s_max_i32 vcc_hi, s1, s2
// CHECK: [0x01,0x02,0x6b,0x84]

s_max_i32 tba_lo, s1, s2
// CHECK: [0x01,0x02,0x6c,0x84]

s_max_i32 tba_hi, s1, s2
// CHECK: [0x01,0x02,0x6d,0x84]

s_max_i32 tma_lo, s1, s2
// CHECK: [0x01,0x02,0x6e,0x84]

s_max_i32 tma_hi, s1, s2
// CHECK: [0x01,0x02,0x6f,0x84]

s_max_i32 ttmp11, s1, s2
// CHECK: [0x01,0x02,0x7b,0x84]

s_max_i32 m0, s1, s2
// CHECK: [0x01,0x02,0x7c,0x84]

s_max_i32 exec_lo, s1, s2
// CHECK: [0x01,0x02,0x7e,0x84]

s_max_i32 exec_hi, s1, s2
// CHECK: [0x01,0x02,0x7f,0x84]

s_max_i32 s5, s103, s2
// CHECK: [0x67,0x02,0x05,0x84]

s_max_i32 s5, flat_scratch_lo, s2
// CHECK: [0x68,0x02,0x05,0x84]

s_max_i32 s5, flat_scratch_hi, s2
// CHECK: [0x69,0x02,0x05,0x84]

s_max_i32 s5, vcc_lo, s2
// CHECK: [0x6a,0x02,0x05,0x84]

s_max_i32 s5, vcc_hi, s2
// CHECK: [0x6b,0x02,0x05,0x84]

s_max_i32 s5, tba_lo, s2
// CHECK: [0x6c,0x02,0x05,0x84]

s_max_i32 s5, tba_hi, s2
// CHECK: [0x6d,0x02,0x05,0x84]

s_max_i32 s5, tma_lo, s2
// CHECK: [0x6e,0x02,0x05,0x84]

s_max_i32 s5, tma_hi, s2
// CHECK: [0x6f,0x02,0x05,0x84]

s_max_i32 s5, ttmp11, s2
// CHECK: [0x7b,0x02,0x05,0x84]

s_max_i32 s5, m0, s2
// CHECK: [0x7c,0x02,0x05,0x84]

s_max_i32 s5, exec_lo, s2
// CHECK: [0x7e,0x02,0x05,0x84]

s_max_i32 s5, exec_hi, s2
// CHECK: [0x7f,0x02,0x05,0x84]

s_max_i32 s5, 0, s2
// CHECK: [0x80,0x02,0x05,0x84]

s_max_i32 s5, -1, s2
// CHECK: [0xc1,0x02,0x05,0x84]

s_max_i32 s5, 0.5, s2
// CHECK: [0xf0,0x02,0x05,0x84]

s_max_i32 s5, -4.0, s2
// CHECK: [0xf7,0x02,0x05,0x84]

s_max_i32 s5, 0xaf123456, s2
// CHECK: [0xff,0x02,0x05,0x84,0x56,0x34,0x12,0xaf]

s_max_i32 s5, 0x3f717273, s2
// CHECK: [0xff,0x02,0x05,0x84,0x73,0x72,0x71,0x3f]

s_max_i32 s5, s1, s103
// CHECK: [0x01,0x67,0x05,0x84]

s_max_i32 s5, s1, flat_scratch_lo
// CHECK: [0x01,0x68,0x05,0x84]

s_max_i32 s5, s1, flat_scratch_hi
// CHECK: [0x01,0x69,0x05,0x84]

s_max_i32 s5, s1, vcc_lo
// CHECK: [0x01,0x6a,0x05,0x84]

s_max_i32 s5, s1, vcc_hi
// CHECK: [0x01,0x6b,0x05,0x84]

s_max_i32 s5, s1, tba_lo
// CHECK: [0x01,0x6c,0x05,0x84]

s_max_i32 s5, s1, tba_hi
// CHECK: [0x01,0x6d,0x05,0x84]

s_max_i32 s5, s1, tma_lo
// CHECK: [0x01,0x6e,0x05,0x84]

s_max_i32 s5, s1, tma_hi
// CHECK: [0x01,0x6f,0x05,0x84]

s_max_i32 s5, s1, ttmp11
// CHECK: [0x01,0x7b,0x05,0x84]

s_max_i32 s5, s1, m0
// CHECK: [0x01,0x7c,0x05,0x84]

s_max_i32 s5, s1, exec_lo
// CHECK: [0x01,0x7e,0x05,0x84]

s_max_i32 s5, s1, exec_hi
// CHECK: [0x01,0x7f,0x05,0x84]

s_max_i32 s5, s1, 0
// CHECK: [0x01,0x80,0x05,0x84]

s_max_i32 s5, s1, -1
// CHECK: [0x01,0xc1,0x05,0x84]

s_max_i32 s5, s1, 0.5
// CHECK: [0x01,0xf0,0x05,0x84]

s_max_i32 s5, s1, -4.0
// CHECK: [0x01,0xf7,0x05,0x84]

s_max_i32 s5, s1, 0xaf123456
// CHECK: [0x01,0xff,0x05,0x84,0x56,0x34,0x12,0xaf]

s_max_i32 s5, s1, 0x3f717273
// CHECK: [0x01,0xff,0x05,0x84,0x73,0x72,0x71,0x3f]

s_max_u32 s5, s1, s2
// CHECK: [0x01,0x02,0x85,0x84]

s_max_u32 s103, s1, s2
// CHECK: [0x01,0x02,0xe7,0x84]

s_max_u32 flat_scratch_lo, s1, s2
// CHECK: [0x01,0x02,0xe8,0x84]

s_max_u32 flat_scratch_hi, s1, s2
// CHECK: [0x01,0x02,0xe9,0x84]

s_max_u32 vcc_lo, s1, s2
// CHECK: [0x01,0x02,0xea,0x84]

s_max_u32 vcc_hi, s1, s2
// CHECK: [0x01,0x02,0xeb,0x84]

s_max_u32 tba_lo, s1, s2
// CHECK: [0x01,0x02,0xec,0x84]

s_max_u32 tba_hi, s1, s2
// CHECK: [0x01,0x02,0xed,0x84]

s_max_u32 tma_lo, s1, s2
// CHECK: [0x01,0x02,0xee,0x84]

s_max_u32 tma_hi, s1, s2
// CHECK: [0x01,0x02,0xef,0x84]

s_max_u32 ttmp11, s1, s2
// CHECK: [0x01,0x02,0xfb,0x84]

s_max_u32 m0, s1, s2
// CHECK: [0x01,0x02,0xfc,0x84]

s_max_u32 exec_lo, s1, s2
// CHECK: [0x01,0x02,0xfe,0x84]

s_max_u32 exec_hi, s1, s2
// CHECK: [0x01,0x02,0xff,0x84]

s_max_u32 s5, s103, s2
// CHECK: [0x67,0x02,0x85,0x84]

s_max_u32 s5, flat_scratch_lo, s2
// CHECK: [0x68,0x02,0x85,0x84]

s_max_u32 s5, flat_scratch_hi, s2
// CHECK: [0x69,0x02,0x85,0x84]

s_max_u32 s5, vcc_lo, s2
// CHECK: [0x6a,0x02,0x85,0x84]

s_max_u32 s5, vcc_hi, s2
// CHECK: [0x6b,0x02,0x85,0x84]

s_max_u32 s5, tba_lo, s2
// CHECK: [0x6c,0x02,0x85,0x84]

s_max_u32 s5, tba_hi, s2
// CHECK: [0x6d,0x02,0x85,0x84]

s_max_u32 s5, tma_lo, s2
// CHECK: [0x6e,0x02,0x85,0x84]

s_max_u32 s5, tma_hi, s2
// CHECK: [0x6f,0x02,0x85,0x84]

s_max_u32 s5, ttmp11, s2
// CHECK: [0x7b,0x02,0x85,0x84]

s_max_u32 s5, m0, s2
// CHECK: [0x7c,0x02,0x85,0x84]

s_max_u32 s5, exec_lo, s2
// CHECK: [0x7e,0x02,0x85,0x84]

s_max_u32 s5, exec_hi, s2
// CHECK: [0x7f,0x02,0x85,0x84]

s_max_u32 s5, 0, s2
// CHECK: [0x80,0x02,0x85,0x84]

s_max_u32 s5, -1, s2
// CHECK: [0xc1,0x02,0x85,0x84]

s_max_u32 s5, 0.5, s2
// CHECK: [0xf0,0x02,0x85,0x84]

s_max_u32 s5, -4.0, s2
// CHECK: [0xf7,0x02,0x85,0x84]

s_max_u32 s5, 0xaf123456, s2
// CHECK: [0xff,0x02,0x85,0x84,0x56,0x34,0x12,0xaf]

s_max_u32 s5, 0x3f717273, s2
// CHECK: [0xff,0x02,0x85,0x84,0x73,0x72,0x71,0x3f]

s_max_u32 s5, s1, s103
// CHECK: [0x01,0x67,0x85,0x84]

s_max_u32 s5, s1, flat_scratch_lo
// CHECK: [0x01,0x68,0x85,0x84]

s_max_u32 s5, s1, flat_scratch_hi
// CHECK: [0x01,0x69,0x85,0x84]

s_max_u32 s5, s1, vcc_lo
// CHECK: [0x01,0x6a,0x85,0x84]

s_max_u32 s5, s1, vcc_hi
// CHECK: [0x01,0x6b,0x85,0x84]

s_max_u32 s5, s1, tba_lo
// CHECK: [0x01,0x6c,0x85,0x84]

s_max_u32 s5, s1, tba_hi
// CHECK: [0x01,0x6d,0x85,0x84]

s_max_u32 s5, s1, tma_lo
// CHECK: [0x01,0x6e,0x85,0x84]

s_max_u32 s5, s1, tma_hi
// CHECK: [0x01,0x6f,0x85,0x84]

s_max_u32 s5, s1, ttmp11
// CHECK: [0x01,0x7b,0x85,0x84]

s_max_u32 s5, s1, m0
// CHECK: [0x01,0x7c,0x85,0x84]

s_max_u32 s5, s1, exec_lo
// CHECK: [0x01,0x7e,0x85,0x84]

s_max_u32 s5, s1, exec_hi
// CHECK: [0x01,0x7f,0x85,0x84]

s_max_u32 s5, s1, 0
// CHECK: [0x01,0x80,0x85,0x84]

s_max_u32 s5, s1, -1
// CHECK: [0x01,0xc1,0x85,0x84]

s_max_u32 s5, s1, 0.5
// CHECK: [0x01,0xf0,0x85,0x84]

s_max_u32 s5, s1, -4.0
// CHECK: [0x01,0xf7,0x85,0x84]

s_max_u32 s5, s1, 0xaf123456
// CHECK: [0x01,0xff,0x85,0x84,0x56,0x34,0x12,0xaf]

s_max_u32 s5, s1, 0x3f717273
// CHECK: [0x01,0xff,0x85,0x84,0x73,0x72,0x71,0x3f]

s_cselect_b32 s5, s1, s2
// CHECK: [0x01,0x02,0x05,0x85]

s_cselect_b32 s103, s1, s2
// CHECK: [0x01,0x02,0x67,0x85]

s_cselect_b32 flat_scratch_lo, s1, s2
// CHECK: [0x01,0x02,0x68,0x85]

s_cselect_b32 flat_scratch_hi, s1, s2
// CHECK: [0x01,0x02,0x69,0x85]

s_cselect_b32 vcc_lo, s1, s2
// CHECK: [0x01,0x02,0x6a,0x85]

s_cselect_b32 vcc_hi, s1, s2
// CHECK: [0x01,0x02,0x6b,0x85]

s_cselect_b32 tba_lo, s1, s2
// CHECK: [0x01,0x02,0x6c,0x85]

s_cselect_b32 tba_hi, s1, s2
// CHECK: [0x01,0x02,0x6d,0x85]

s_cselect_b32 tma_lo, s1, s2
// CHECK: [0x01,0x02,0x6e,0x85]

s_cselect_b32 tma_hi, s1, s2
// CHECK: [0x01,0x02,0x6f,0x85]

s_cselect_b32 ttmp11, s1, s2
// CHECK: [0x01,0x02,0x7b,0x85]

s_cselect_b32 m0, s1, s2
// CHECK: [0x01,0x02,0x7c,0x85]

s_cselect_b32 exec_lo, s1, s2
// CHECK: [0x01,0x02,0x7e,0x85]

s_cselect_b32 exec_hi, s1, s2
// CHECK: [0x01,0x02,0x7f,0x85]

s_cselect_b32 s5, s103, s2
// CHECK: [0x67,0x02,0x05,0x85]

s_cselect_b32 s5, flat_scratch_lo, s2
// CHECK: [0x68,0x02,0x05,0x85]

s_cselect_b32 s5, flat_scratch_hi, s2
// CHECK: [0x69,0x02,0x05,0x85]

s_cselect_b32 s5, vcc_lo, s2
// CHECK: [0x6a,0x02,0x05,0x85]

s_cselect_b32 s5, vcc_hi, s2
// CHECK: [0x6b,0x02,0x05,0x85]

s_cselect_b32 s5, tba_lo, s2
// CHECK: [0x6c,0x02,0x05,0x85]

s_cselect_b32 s5, tba_hi, s2
// CHECK: [0x6d,0x02,0x05,0x85]

s_cselect_b32 s5, tma_lo, s2
// CHECK: [0x6e,0x02,0x05,0x85]

s_cselect_b32 s5, tma_hi, s2
// CHECK: [0x6f,0x02,0x05,0x85]

s_cselect_b32 s5, ttmp11, s2
// CHECK: [0x7b,0x02,0x05,0x85]

s_cselect_b32 s5, m0, s2
// CHECK: [0x7c,0x02,0x05,0x85]

s_cselect_b32 s5, exec_lo, s2
// CHECK: [0x7e,0x02,0x05,0x85]

s_cselect_b32 s5, exec_hi, s2
// CHECK: [0x7f,0x02,0x05,0x85]

s_cselect_b32 s5, 0, s2
// CHECK: [0x80,0x02,0x05,0x85]

s_cselect_b32 s5, -1, s2
// CHECK: [0xc1,0x02,0x05,0x85]

s_cselect_b32 s5, 0.5, s2
// CHECK: [0xf0,0x02,0x05,0x85]

s_cselect_b32 s5, -4.0, s2
// CHECK: [0xf7,0x02,0x05,0x85]

s_cselect_b32 s5, 0xaf123456, s2
// CHECK: [0xff,0x02,0x05,0x85,0x56,0x34,0x12,0xaf]

s_cselect_b32 s5, 0x3f717273, s2
// CHECK: [0xff,0x02,0x05,0x85,0x73,0x72,0x71,0x3f]

s_cselect_b32 s5, s1, s103
// CHECK: [0x01,0x67,0x05,0x85]

s_cselect_b32 s5, s1, flat_scratch_lo
// CHECK: [0x01,0x68,0x05,0x85]

s_cselect_b32 s5, s1, flat_scratch_hi
// CHECK: [0x01,0x69,0x05,0x85]

s_cselect_b32 s5, s1, vcc_lo
// CHECK: [0x01,0x6a,0x05,0x85]

s_cselect_b32 s5, s1, vcc_hi
// CHECK: [0x01,0x6b,0x05,0x85]

s_cselect_b32 s5, s1, tba_lo
// CHECK: [0x01,0x6c,0x05,0x85]

s_cselect_b32 s5, s1, tba_hi
// CHECK: [0x01,0x6d,0x05,0x85]

s_cselect_b32 s5, s1, tma_lo
// CHECK: [0x01,0x6e,0x05,0x85]

s_cselect_b32 s5, s1, tma_hi
// CHECK: [0x01,0x6f,0x05,0x85]

s_cselect_b32 s5, s1, ttmp11
// CHECK: [0x01,0x7b,0x05,0x85]

s_cselect_b32 s5, s1, m0
// CHECK: [0x01,0x7c,0x05,0x85]

s_cselect_b32 s5, s1, exec_lo
// CHECK: [0x01,0x7e,0x05,0x85]

s_cselect_b32 s5, s1, exec_hi
// CHECK: [0x01,0x7f,0x05,0x85]

s_cselect_b32 s5, s1, 0
// CHECK: [0x01,0x80,0x05,0x85]

s_cselect_b32 s5, s1, -1
// CHECK: [0x01,0xc1,0x05,0x85]

s_cselect_b32 s5, s1, 0.5
// CHECK: [0x01,0xf0,0x05,0x85]

s_cselect_b32 s5, s1, -4.0
// CHECK: [0x01,0xf7,0x05,0x85]

s_cselect_b32 s5, s1, 0xaf123456
// CHECK: [0x01,0xff,0x05,0x85,0x56,0x34,0x12,0xaf]

s_cselect_b32 s5, s1, 0x3f717273
// CHECK: [0x01,0xff,0x05,0x85,0x73,0x72,0x71,0x3f]

s_cselect_b64 s[10:11], s[2:3], s[4:5]
// CHECK: [0x02,0x04,0x8a,0x85]

s_cselect_b64 s[12:13], s[2:3], s[4:5]
// CHECK: [0x02,0x04,0x8c,0x85]

s_cselect_b64 s[102:103], s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xe6,0x85]

s_cselect_b64 flat_scratch, s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xe8,0x85]

s_cselect_b64 vcc, s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xea,0x85]

s_cselect_b64 tba, s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xec,0x85]

s_cselect_b64 tma, s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xee,0x85]

s_cselect_b64 ttmp[10:11], s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xfa,0x85]

s_cselect_b64 exec, s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xfe,0x85]

s_cselect_b64 s[10:11], s[4:5], s[4:5]
// CHECK: [0x04,0x04,0x8a,0x85]

s_cselect_b64 s[10:11], s[102:103], s[4:5]
// CHECK: [0x66,0x04,0x8a,0x85]

s_cselect_b64 s[10:11], flat_scratch, s[4:5]
// CHECK: [0x68,0x04,0x8a,0x85]

s_cselect_b64 s[10:11], vcc, s[4:5]
// CHECK: [0x6a,0x04,0x8a,0x85]

s_cselect_b64 s[10:11], tba, s[4:5]
// CHECK: [0x6c,0x04,0x8a,0x85]

s_cselect_b64 s[10:11], tma, s[4:5]
// CHECK: [0x6e,0x04,0x8a,0x85]

s_cselect_b64 s[10:11], ttmp[10:11], s[4:5]
// CHECK: [0x7a,0x04,0x8a,0x85]

s_cselect_b64 s[10:11], exec, s[4:5]
// CHECK: [0x7e,0x04,0x8a,0x85]

s_cselect_b64 s[10:11], 0, s[4:5]
// CHECK: [0x80,0x04,0x8a,0x85]

s_cselect_b64 s[10:11], -1, s[4:5]
// CHECK: [0xc1,0x04,0x8a,0x85]

s_cselect_b64 s[10:11], 0.5, s[4:5]
// CHECK: [0xf0,0x04,0x8a,0x85]

s_cselect_b64 s[10:11], -4.0, s[4:5]
// CHECK: [0xf7,0x04,0x8a,0x85]

s_cselect_b64 s[10:11], 0xaf123456, s[4:5]
// CHECK: [0xff,0x04,0x8a,0x85,0x56,0x34,0x12,0xaf]

s_cselect_b64 s[10:11], 0x3f717273, s[4:5]
// CHECK: [0xff,0x04,0x8a,0x85,0x73,0x72,0x71,0x3f]

s_cselect_b64 s[10:11], s[2:3], s[6:7]
// CHECK: [0x02,0x06,0x8a,0x85]

s_cselect_b64 s[10:11], s[2:3], s[102:103]
// CHECK: [0x02,0x66,0x8a,0x85]

s_cselect_b64 s[10:11], s[2:3], flat_scratch
// CHECK: [0x02,0x68,0x8a,0x85]

s_cselect_b64 s[10:11], s[2:3], vcc
// CHECK: [0x02,0x6a,0x8a,0x85]

s_cselect_b64 s[10:11], s[2:3], tba
// CHECK: [0x02,0x6c,0x8a,0x85]

s_cselect_b64 s[10:11], s[2:3], tma
// CHECK: [0x02,0x6e,0x8a,0x85]

s_cselect_b64 s[10:11], s[2:3], ttmp[10:11]
// CHECK: [0x02,0x7a,0x8a,0x85]

s_cselect_b64 s[10:11], s[2:3], exec
// CHECK: [0x02,0x7e,0x8a,0x85]

s_cselect_b64 s[10:11], s[2:3], 0
// CHECK: [0x02,0x80,0x8a,0x85]

s_cselect_b64 s[10:11], s[2:3], -1
// CHECK: [0x02,0xc1,0x8a,0x85]

s_cselect_b64 s[10:11], s[2:3], 0.5
// CHECK: [0x02,0xf0,0x8a,0x85]

s_cselect_b64 s[10:11], s[2:3], -4.0
// CHECK: [0x02,0xf7,0x8a,0x85]

s_cselect_b64 s[10:11], s[2:3], 0xaf123456
// CHECK: [0x02,0xff,0x8a,0x85,0x56,0x34,0x12,0xaf]

s_cselect_b64 s[10:11], s[2:3], 0x3f717273
// CHECK: [0x02,0xff,0x8a,0x85,0x73,0x72,0x71,0x3f]

s_and_b32 s5, s1, s2
// CHECK: [0x01,0x02,0x05,0x87]

s_and_b32 s103, s1, s2
// CHECK: [0x01,0x02,0x67,0x87]

s_and_b32 flat_scratch_lo, s1, s2
// CHECK: [0x01,0x02,0x68,0x87]

s_and_b32 flat_scratch_hi, s1, s2
// CHECK: [0x01,0x02,0x69,0x87]

s_and_b32 vcc_lo, s1, s2
// CHECK: [0x01,0x02,0x6a,0x87]

s_and_b32 vcc_hi, s1, s2
// CHECK: [0x01,0x02,0x6b,0x87]

s_and_b32 tba_lo, s1, s2
// CHECK: [0x01,0x02,0x6c,0x87]

s_and_b32 tba_hi, s1, s2
// CHECK: [0x01,0x02,0x6d,0x87]

s_and_b32 tma_lo, s1, s2
// CHECK: [0x01,0x02,0x6e,0x87]

s_and_b32 tma_hi, s1, s2
// CHECK: [0x01,0x02,0x6f,0x87]

s_and_b32 ttmp11, s1, s2
// CHECK: [0x01,0x02,0x7b,0x87]

s_and_b32 m0, s1, s2
// CHECK: [0x01,0x02,0x7c,0x87]

s_and_b32 exec_lo, s1, s2
// CHECK: [0x01,0x02,0x7e,0x87]

s_and_b32 exec_hi, s1, s2
// CHECK: [0x01,0x02,0x7f,0x87]

s_and_b32 s5, s103, s2
// CHECK: [0x67,0x02,0x05,0x87]

s_and_b32 s5, flat_scratch_lo, s2
// CHECK: [0x68,0x02,0x05,0x87]

s_and_b32 s5, flat_scratch_hi, s2
// CHECK: [0x69,0x02,0x05,0x87]

s_and_b32 s5, vcc_lo, s2
// CHECK: [0x6a,0x02,0x05,0x87]

s_and_b32 s5, vcc_hi, s2
// CHECK: [0x6b,0x02,0x05,0x87]

s_and_b32 s5, tba_lo, s2
// CHECK: [0x6c,0x02,0x05,0x87]

s_and_b32 s5, tba_hi, s2
// CHECK: [0x6d,0x02,0x05,0x87]

s_and_b32 s5, tma_lo, s2
// CHECK: [0x6e,0x02,0x05,0x87]

s_and_b32 s5, tma_hi, s2
// CHECK: [0x6f,0x02,0x05,0x87]

s_and_b32 s5, ttmp11, s2
// CHECK: [0x7b,0x02,0x05,0x87]

s_and_b32 s5, m0, s2
// CHECK: [0x7c,0x02,0x05,0x87]

s_and_b32 s5, exec_lo, s2
// CHECK: [0x7e,0x02,0x05,0x87]

s_and_b32 s5, exec_hi, s2
// CHECK: [0x7f,0x02,0x05,0x87]

s_and_b32 s5, 0, s2
// CHECK: [0x80,0x02,0x05,0x87]

s_and_b32 s5, -1, s2
// CHECK: [0xc1,0x02,0x05,0x87]

s_and_b32 s5, 0.5, s2
// CHECK: [0xf0,0x02,0x05,0x87]

s_and_b32 s5, -4.0, s2
// CHECK: [0xf7,0x02,0x05,0x87]

s_and_b32 s5, 0xaf123456, s2
// CHECK: [0xff,0x02,0x05,0x87,0x56,0x34,0x12,0xaf]

s_and_b32 s5, 0x3f717273, s2
// CHECK: [0xff,0x02,0x05,0x87,0x73,0x72,0x71,0x3f]

s_and_b32 s5, s1, s103
// CHECK: [0x01,0x67,0x05,0x87]

s_and_b32 s5, s1, flat_scratch_lo
// CHECK: [0x01,0x68,0x05,0x87]

s_and_b32 s5, s1, flat_scratch_hi
// CHECK: [0x01,0x69,0x05,0x87]

s_and_b32 s5, s1, vcc_lo
// CHECK: [0x01,0x6a,0x05,0x87]

s_and_b32 s5, s1, vcc_hi
// CHECK: [0x01,0x6b,0x05,0x87]

s_and_b32 s5, s1, tba_lo
// CHECK: [0x01,0x6c,0x05,0x87]

s_and_b32 s5, s1, tba_hi
// CHECK: [0x01,0x6d,0x05,0x87]

s_and_b32 s5, s1, tma_lo
// CHECK: [0x01,0x6e,0x05,0x87]

s_and_b32 s5, s1, tma_hi
// CHECK: [0x01,0x6f,0x05,0x87]

s_and_b32 s5, s1, ttmp11
// CHECK: [0x01,0x7b,0x05,0x87]

s_and_b32 s5, s1, m0
// CHECK: [0x01,0x7c,0x05,0x87]

s_and_b32 s5, s1, exec_lo
// CHECK: [0x01,0x7e,0x05,0x87]

s_and_b32 s5, s1, exec_hi
// CHECK: [0x01,0x7f,0x05,0x87]

s_and_b32 s5, s1, 0
// CHECK: [0x01,0x80,0x05,0x87]

s_and_b32 s5, s1, -1
// CHECK: [0x01,0xc1,0x05,0x87]

s_and_b32 s5, s1, 0.5
// CHECK: [0x01,0xf0,0x05,0x87]

s_and_b32 s5, s1, -4.0
// CHECK: [0x01,0xf7,0x05,0x87]

s_and_b32 s5, s1, 0xaf123456
// CHECK: [0x01,0xff,0x05,0x87,0x56,0x34,0x12,0xaf]

s_and_b32 s5, s1, 0x3f717273
// CHECK: [0x01,0xff,0x05,0x87,0x73,0x72,0x71,0x3f]

s_and_b64 s[10:11], s[2:3], s[4:5]
// CHECK: [0x02,0x04,0x8a,0x87]

s_and_b64 s[12:13], s[2:3], s[4:5]
// CHECK: [0x02,0x04,0x8c,0x87]

s_and_b64 s[102:103], s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xe6,0x87]

s_and_b64 flat_scratch, s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xe8,0x87]

s_and_b64 vcc, s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xea,0x87]

s_and_b64 tba, s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xec,0x87]

s_and_b64 tma, s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xee,0x87]

s_and_b64 ttmp[10:11], s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xfa,0x87]

s_and_b64 exec, s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xfe,0x87]

s_and_b64 s[10:11], s[4:5], s[4:5]
// CHECK: [0x04,0x04,0x8a,0x87]

s_and_b64 s[10:11], s[102:103], s[4:5]
// CHECK: [0x66,0x04,0x8a,0x87]

s_and_b64 s[10:11], flat_scratch, s[4:5]
// CHECK: [0x68,0x04,0x8a,0x87]

s_and_b64 s[10:11], vcc, s[4:5]
// CHECK: [0x6a,0x04,0x8a,0x87]

s_and_b64 s[10:11], tba, s[4:5]
// CHECK: [0x6c,0x04,0x8a,0x87]

s_and_b64 s[10:11], tma, s[4:5]
// CHECK: [0x6e,0x04,0x8a,0x87]

s_and_b64 s[10:11], ttmp[10:11], s[4:5]
// CHECK: [0x7a,0x04,0x8a,0x87]

s_and_b64 s[10:11], exec, s[4:5]
// CHECK: [0x7e,0x04,0x8a,0x87]

s_and_b64 s[10:11], 0, s[4:5]
// CHECK: [0x80,0x04,0x8a,0x87]

s_and_b64 s[10:11], -1, s[4:5]
// CHECK: [0xc1,0x04,0x8a,0x87]

s_and_b64 s[10:11], 0.5, s[4:5]
// CHECK: [0xf0,0x04,0x8a,0x87]

s_and_b64 s[10:11], -4.0, s[4:5]
// CHECK: [0xf7,0x04,0x8a,0x87]

s_and_b64 s[10:11], 0xaf123456, s[4:5]
// CHECK: [0xff,0x04,0x8a,0x87,0x56,0x34,0x12,0xaf]

s_and_b64 s[10:11], 0x3f717273, s[4:5]
// CHECK: [0xff,0x04,0x8a,0x87,0x73,0x72,0x71,0x3f]

s_and_b64 s[10:11], s[2:3], s[6:7]
// CHECK: [0x02,0x06,0x8a,0x87]

s_and_b64 s[10:11], s[2:3], s[102:103]
// CHECK: [0x02,0x66,0x8a,0x87]

s_and_b64 s[10:11], s[2:3], flat_scratch
// CHECK: [0x02,0x68,0x8a,0x87]

s_and_b64 s[10:11], s[2:3], vcc
// CHECK: [0x02,0x6a,0x8a,0x87]

s_and_b64 s[10:11], s[2:3], tba
// CHECK: [0x02,0x6c,0x8a,0x87]

s_and_b64 s[10:11], s[2:3], tma
// CHECK: [0x02,0x6e,0x8a,0x87]

s_and_b64 s[10:11], s[2:3], ttmp[10:11]
// CHECK: [0x02,0x7a,0x8a,0x87]

s_and_b64 s[10:11], s[2:3], exec
// CHECK: [0x02,0x7e,0x8a,0x87]

s_and_b64 s[10:11], s[2:3], 0
// CHECK: [0x02,0x80,0x8a,0x87]

s_and_b64 s[10:11], s[2:3], -1
// CHECK: [0x02,0xc1,0x8a,0x87]

s_and_b64 s[10:11], s[2:3], 0.5
// CHECK: [0x02,0xf0,0x8a,0x87]

s_and_b64 s[10:11], s[2:3], -4.0
// CHECK: [0x02,0xf7,0x8a,0x87]

s_and_b64 s[10:11], s[2:3], 0xaf123456
// CHECK: [0x02,0xff,0x8a,0x87,0x56,0x34,0x12,0xaf]

s_and_b64 s[10:11], s[2:3], 0x3f717273
// CHECK: [0x02,0xff,0x8a,0x87,0x73,0x72,0x71,0x3f]

s_or_b32 s5, s1, s2
// CHECK: [0x01,0x02,0x05,0x88]

s_or_b32 s103, s1, s2
// CHECK: [0x01,0x02,0x67,0x88]

s_or_b32 flat_scratch_lo, s1, s2
// CHECK: [0x01,0x02,0x68,0x88]

s_or_b32 flat_scratch_hi, s1, s2
// CHECK: [0x01,0x02,0x69,0x88]

s_or_b32 vcc_lo, s1, s2
// CHECK: [0x01,0x02,0x6a,0x88]

s_or_b32 vcc_hi, s1, s2
// CHECK: [0x01,0x02,0x6b,0x88]

s_or_b32 tba_lo, s1, s2
// CHECK: [0x01,0x02,0x6c,0x88]

s_or_b32 tba_hi, s1, s2
// CHECK: [0x01,0x02,0x6d,0x88]

s_or_b32 tma_lo, s1, s2
// CHECK: [0x01,0x02,0x6e,0x88]

s_or_b32 tma_hi, s1, s2
// CHECK: [0x01,0x02,0x6f,0x88]

s_or_b32 ttmp11, s1, s2
// CHECK: [0x01,0x02,0x7b,0x88]

s_or_b32 m0, s1, s2
// CHECK: [0x01,0x02,0x7c,0x88]

s_or_b32 exec_lo, s1, s2
// CHECK: [0x01,0x02,0x7e,0x88]

s_or_b32 exec_hi, s1, s2
// CHECK: [0x01,0x02,0x7f,0x88]

s_or_b32 s5, s103, s2
// CHECK: [0x67,0x02,0x05,0x88]

s_or_b32 s5, flat_scratch_lo, s2
// CHECK: [0x68,0x02,0x05,0x88]

s_or_b32 s5, flat_scratch_hi, s2
// CHECK: [0x69,0x02,0x05,0x88]

s_or_b32 s5, vcc_lo, s2
// CHECK: [0x6a,0x02,0x05,0x88]

s_or_b32 s5, vcc_hi, s2
// CHECK: [0x6b,0x02,0x05,0x88]

s_or_b32 s5, tba_lo, s2
// CHECK: [0x6c,0x02,0x05,0x88]

s_or_b32 s5, tba_hi, s2
// CHECK: [0x6d,0x02,0x05,0x88]

s_or_b32 s5, tma_lo, s2
// CHECK: [0x6e,0x02,0x05,0x88]

s_or_b32 s5, tma_hi, s2
// CHECK: [0x6f,0x02,0x05,0x88]

s_or_b32 s5, ttmp11, s2
// CHECK: [0x7b,0x02,0x05,0x88]

s_or_b32 s5, m0, s2
// CHECK: [0x7c,0x02,0x05,0x88]

s_or_b32 s5, exec_lo, s2
// CHECK: [0x7e,0x02,0x05,0x88]

s_or_b32 s5, exec_hi, s2
// CHECK: [0x7f,0x02,0x05,0x88]

s_or_b32 s5, 0, s2
// CHECK: [0x80,0x02,0x05,0x88]

s_or_b32 s5, -1, s2
// CHECK: [0xc1,0x02,0x05,0x88]

s_or_b32 s5, 0.5, s2
// CHECK: [0xf0,0x02,0x05,0x88]

s_or_b32 s5, -4.0, s2
// CHECK: [0xf7,0x02,0x05,0x88]

s_or_b32 s5, 0xaf123456, s2
// CHECK: [0xff,0x02,0x05,0x88,0x56,0x34,0x12,0xaf]

s_or_b32 s5, 0x3f717273, s2
// CHECK: [0xff,0x02,0x05,0x88,0x73,0x72,0x71,0x3f]

s_or_b32 s5, s1, s103
// CHECK: [0x01,0x67,0x05,0x88]

s_or_b32 s5, s1, flat_scratch_lo
// CHECK: [0x01,0x68,0x05,0x88]

s_or_b32 s5, s1, flat_scratch_hi
// CHECK: [0x01,0x69,0x05,0x88]

s_or_b32 s5, s1, vcc_lo
// CHECK: [0x01,0x6a,0x05,0x88]

s_or_b32 s5, s1, vcc_hi
// CHECK: [0x01,0x6b,0x05,0x88]

s_or_b32 s5, s1, tba_lo
// CHECK: [0x01,0x6c,0x05,0x88]

s_or_b32 s5, s1, tba_hi
// CHECK: [0x01,0x6d,0x05,0x88]

s_or_b32 s5, s1, tma_lo
// CHECK: [0x01,0x6e,0x05,0x88]

s_or_b32 s5, s1, tma_hi
// CHECK: [0x01,0x6f,0x05,0x88]

s_or_b32 s5, s1, ttmp11
// CHECK: [0x01,0x7b,0x05,0x88]

s_or_b32 s5, s1, m0
// CHECK: [0x01,0x7c,0x05,0x88]

s_or_b32 s5, s1, exec_lo
// CHECK: [0x01,0x7e,0x05,0x88]

s_or_b32 s5, s1, exec_hi
// CHECK: [0x01,0x7f,0x05,0x88]

s_or_b32 s5, s1, 0
// CHECK: [0x01,0x80,0x05,0x88]

s_or_b32 s5, s1, -1
// CHECK: [0x01,0xc1,0x05,0x88]

s_or_b32 s5, s1, 0.5
// CHECK: [0x01,0xf0,0x05,0x88]

s_or_b32 s5, s1, -4.0
// CHECK: [0x01,0xf7,0x05,0x88]

s_or_b32 s5, s1, 0xaf123456
// CHECK: [0x01,0xff,0x05,0x88,0x56,0x34,0x12,0xaf]

s_or_b32 s5, s1, 0x3f717273
// CHECK: [0x01,0xff,0x05,0x88,0x73,0x72,0x71,0x3f]

s_or_b64 s[10:11], s[2:3], s[4:5]
// CHECK: [0x02,0x04,0x8a,0x88]

s_or_b64 s[12:13], s[2:3], s[4:5]
// CHECK: [0x02,0x04,0x8c,0x88]

s_or_b64 s[102:103], s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xe6,0x88]

s_or_b64 flat_scratch, s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xe8,0x88]

s_or_b64 vcc, s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xea,0x88]

s_or_b64 tba, s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xec,0x88]

s_or_b64 tma, s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xee,0x88]

s_or_b64 ttmp[10:11], s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xfa,0x88]

s_or_b64 exec, s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xfe,0x88]

s_or_b64 s[10:11], s[4:5], s[4:5]
// CHECK: [0x04,0x04,0x8a,0x88]

s_or_b64 s[10:11], s[102:103], s[4:5]
// CHECK: [0x66,0x04,0x8a,0x88]

s_or_b64 s[10:11], flat_scratch, s[4:5]
// CHECK: [0x68,0x04,0x8a,0x88]

s_or_b64 s[10:11], vcc, s[4:5]
// CHECK: [0x6a,0x04,0x8a,0x88]

s_or_b64 s[10:11], tba, s[4:5]
// CHECK: [0x6c,0x04,0x8a,0x88]

s_or_b64 s[10:11], tma, s[4:5]
// CHECK: [0x6e,0x04,0x8a,0x88]

s_or_b64 s[10:11], ttmp[10:11], s[4:5]
// CHECK: [0x7a,0x04,0x8a,0x88]

s_or_b64 s[10:11], exec, s[4:5]
// CHECK: [0x7e,0x04,0x8a,0x88]

s_or_b64 s[10:11], 0, s[4:5]
// CHECK: [0x80,0x04,0x8a,0x88]

s_or_b64 s[10:11], -1, s[4:5]
// CHECK: [0xc1,0x04,0x8a,0x88]

s_or_b64 s[10:11], 0.5, s[4:5]
// CHECK: [0xf0,0x04,0x8a,0x88]

s_or_b64 s[10:11], -4.0, s[4:5]
// CHECK: [0xf7,0x04,0x8a,0x88]

s_or_b64 s[10:11], 0xaf123456, s[4:5]
// CHECK: [0xff,0x04,0x8a,0x88,0x56,0x34,0x12,0xaf]

s_or_b64 s[10:11], 0x3f717273, s[4:5]
// CHECK: [0xff,0x04,0x8a,0x88,0x73,0x72,0x71,0x3f]

s_or_b64 s[10:11], s[2:3], s[6:7]
// CHECK: [0x02,0x06,0x8a,0x88]

s_or_b64 s[10:11], s[2:3], s[102:103]
// CHECK: [0x02,0x66,0x8a,0x88]

s_or_b64 s[10:11], s[2:3], flat_scratch
// CHECK: [0x02,0x68,0x8a,0x88]

s_or_b64 s[10:11], s[2:3], vcc
// CHECK: [0x02,0x6a,0x8a,0x88]

s_or_b64 s[10:11], s[2:3], tba
// CHECK: [0x02,0x6c,0x8a,0x88]

s_or_b64 s[10:11], s[2:3], tma
// CHECK: [0x02,0x6e,0x8a,0x88]

s_or_b64 s[10:11], s[2:3], ttmp[10:11]
// CHECK: [0x02,0x7a,0x8a,0x88]

s_or_b64 s[10:11], s[2:3], exec
// CHECK: [0x02,0x7e,0x8a,0x88]

s_or_b64 s[10:11], s[2:3], 0
// CHECK: [0x02,0x80,0x8a,0x88]

s_or_b64 s[10:11], s[2:3], -1
// CHECK: [0x02,0xc1,0x8a,0x88]

s_or_b64 s[10:11], s[2:3], 0.5
// CHECK: [0x02,0xf0,0x8a,0x88]

s_or_b64 s[10:11], s[2:3], -4.0
// CHECK: [0x02,0xf7,0x8a,0x88]

s_or_b64 s[10:11], s[2:3], 0xaf123456
// CHECK: [0x02,0xff,0x8a,0x88,0x56,0x34,0x12,0xaf]

s_or_b64 s[10:11], s[2:3], 0x3f717273
// CHECK: [0x02,0xff,0x8a,0x88,0x73,0x72,0x71,0x3f]

s_xor_b32 s5, s1, s2
// CHECK: [0x01,0x02,0x05,0x89]

s_xor_b32 s103, s1, s2
// CHECK: [0x01,0x02,0x67,0x89]

s_xor_b32 flat_scratch_lo, s1, s2
// CHECK: [0x01,0x02,0x68,0x89]

s_xor_b32 flat_scratch_hi, s1, s2
// CHECK: [0x01,0x02,0x69,0x89]

s_xor_b32 vcc_lo, s1, s2
// CHECK: [0x01,0x02,0x6a,0x89]

s_xor_b32 vcc_hi, s1, s2
// CHECK: [0x01,0x02,0x6b,0x89]

s_xor_b32 tba_lo, s1, s2
// CHECK: [0x01,0x02,0x6c,0x89]

s_xor_b32 tba_hi, s1, s2
// CHECK: [0x01,0x02,0x6d,0x89]

s_xor_b32 tma_lo, s1, s2
// CHECK: [0x01,0x02,0x6e,0x89]

s_xor_b32 tma_hi, s1, s2
// CHECK: [0x01,0x02,0x6f,0x89]

s_xor_b32 ttmp11, s1, s2
// CHECK: [0x01,0x02,0x7b,0x89]

s_xor_b32 m0, s1, s2
// CHECK: [0x01,0x02,0x7c,0x89]

s_xor_b32 exec_lo, s1, s2
// CHECK: [0x01,0x02,0x7e,0x89]

s_xor_b32 exec_hi, s1, s2
// CHECK: [0x01,0x02,0x7f,0x89]

s_xor_b32 s5, s103, s2
// CHECK: [0x67,0x02,0x05,0x89]

s_xor_b32 s5, flat_scratch_lo, s2
// CHECK: [0x68,0x02,0x05,0x89]

s_xor_b32 s5, flat_scratch_hi, s2
// CHECK: [0x69,0x02,0x05,0x89]

s_xor_b32 s5, vcc_lo, s2
// CHECK: [0x6a,0x02,0x05,0x89]

s_xor_b32 s5, vcc_hi, s2
// CHECK: [0x6b,0x02,0x05,0x89]

s_xor_b32 s5, tba_lo, s2
// CHECK: [0x6c,0x02,0x05,0x89]

s_xor_b32 s5, tba_hi, s2
// CHECK: [0x6d,0x02,0x05,0x89]

s_xor_b32 s5, tma_lo, s2
// CHECK: [0x6e,0x02,0x05,0x89]

s_xor_b32 s5, tma_hi, s2
// CHECK: [0x6f,0x02,0x05,0x89]

s_xor_b32 s5, ttmp11, s2
// CHECK: [0x7b,0x02,0x05,0x89]

s_xor_b32 s5, m0, s2
// CHECK: [0x7c,0x02,0x05,0x89]

s_xor_b32 s5, exec_lo, s2
// CHECK: [0x7e,0x02,0x05,0x89]

s_xor_b32 s5, exec_hi, s2
// CHECK: [0x7f,0x02,0x05,0x89]

s_xor_b32 s5, 0, s2
// CHECK: [0x80,0x02,0x05,0x89]

s_xor_b32 s5, -1, s2
// CHECK: [0xc1,0x02,0x05,0x89]

s_xor_b32 s5, 0.5, s2
// CHECK: [0xf0,0x02,0x05,0x89]

s_xor_b32 s5, -4.0, s2
// CHECK: [0xf7,0x02,0x05,0x89]

s_xor_b32 s5, 0xaf123456, s2
// CHECK: [0xff,0x02,0x05,0x89,0x56,0x34,0x12,0xaf]

s_xor_b32 s5, 0x3f717273, s2
// CHECK: [0xff,0x02,0x05,0x89,0x73,0x72,0x71,0x3f]

s_xor_b32 s5, s1, s103
// CHECK: [0x01,0x67,0x05,0x89]

s_xor_b32 s5, s1, flat_scratch_lo
// CHECK: [0x01,0x68,0x05,0x89]

s_xor_b32 s5, s1, flat_scratch_hi
// CHECK: [0x01,0x69,0x05,0x89]

s_xor_b32 s5, s1, vcc_lo
// CHECK: [0x01,0x6a,0x05,0x89]

s_xor_b32 s5, s1, vcc_hi
// CHECK: [0x01,0x6b,0x05,0x89]

s_xor_b32 s5, s1, tba_lo
// CHECK: [0x01,0x6c,0x05,0x89]

s_xor_b32 s5, s1, tba_hi
// CHECK: [0x01,0x6d,0x05,0x89]

s_xor_b32 s5, s1, tma_lo
// CHECK: [0x01,0x6e,0x05,0x89]

s_xor_b32 s5, s1, tma_hi
// CHECK: [0x01,0x6f,0x05,0x89]

s_xor_b32 s5, s1, ttmp11
// CHECK: [0x01,0x7b,0x05,0x89]

s_xor_b32 s5, s1, m0
// CHECK: [0x01,0x7c,0x05,0x89]

s_xor_b32 s5, s1, exec_lo
// CHECK: [0x01,0x7e,0x05,0x89]

s_xor_b32 s5, s1, exec_hi
// CHECK: [0x01,0x7f,0x05,0x89]

s_xor_b32 s5, s1, 0
// CHECK: [0x01,0x80,0x05,0x89]

s_xor_b32 s5, s1, -1
// CHECK: [0x01,0xc1,0x05,0x89]

s_xor_b32 s5, s1, 0.5
// CHECK: [0x01,0xf0,0x05,0x89]

s_xor_b32 s5, s1, -4.0
// CHECK: [0x01,0xf7,0x05,0x89]

s_xor_b32 s5, s1, 0xaf123456
// CHECK: [0x01,0xff,0x05,0x89,0x56,0x34,0x12,0xaf]

s_xor_b32 s5, s1, 0x3f717273
// CHECK: [0x01,0xff,0x05,0x89,0x73,0x72,0x71,0x3f]

s_xor_b64 s[10:11], s[2:3], s[4:5]
// CHECK: [0x02,0x04,0x8a,0x89]

s_xor_b64 s[12:13], s[2:3], s[4:5]
// CHECK: [0x02,0x04,0x8c,0x89]

s_xor_b64 s[102:103], s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xe6,0x89]

s_xor_b64 flat_scratch, s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xe8,0x89]

s_xor_b64 vcc, s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xea,0x89]

s_xor_b64 tba, s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xec,0x89]

s_xor_b64 tma, s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xee,0x89]

s_xor_b64 ttmp[10:11], s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xfa,0x89]

s_xor_b64 exec, s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xfe,0x89]

s_xor_b64 s[10:11], s[4:5], s[4:5]
// CHECK: [0x04,0x04,0x8a,0x89]

s_xor_b64 s[10:11], s[102:103], s[4:5]
// CHECK: [0x66,0x04,0x8a,0x89]

s_xor_b64 s[10:11], flat_scratch, s[4:5]
// CHECK: [0x68,0x04,0x8a,0x89]

s_xor_b64 s[10:11], vcc, s[4:5]
// CHECK: [0x6a,0x04,0x8a,0x89]

s_xor_b64 s[10:11], tba, s[4:5]
// CHECK: [0x6c,0x04,0x8a,0x89]

s_xor_b64 s[10:11], tma, s[4:5]
// CHECK: [0x6e,0x04,0x8a,0x89]

s_xor_b64 s[10:11], ttmp[10:11], s[4:5]
// CHECK: [0x7a,0x04,0x8a,0x89]

s_xor_b64 s[10:11], exec, s[4:5]
// CHECK: [0x7e,0x04,0x8a,0x89]

s_xor_b64 s[10:11], 0, s[4:5]
// CHECK: [0x80,0x04,0x8a,0x89]

s_xor_b64 s[10:11], -1, s[4:5]
// CHECK: [0xc1,0x04,0x8a,0x89]

s_xor_b64 s[10:11], 0.5, s[4:5]
// CHECK: [0xf0,0x04,0x8a,0x89]

s_xor_b64 s[10:11], -4.0, s[4:5]
// CHECK: [0xf7,0x04,0x8a,0x89]

s_xor_b64 s[10:11], 0xaf123456, s[4:5]
// CHECK: [0xff,0x04,0x8a,0x89,0x56,0x34,0x12,0xaf]

s_xor_b64 s[10:11], 0x3f717273, s[4:5]
// CHECK: [0xff,0x04,0x8a,0x89,0x73,0x72,0x71,0x3f]

s_xor_b64 s[10:11], s[2:3], s[6:7]
// CHECK: [0x02,0x06,0x8a,0x89]

s_xor_b64 s[10:11], s[2:3], s[102:103]
// CHECK: [0x02,0x66,0x8a,0x89]

s_xor_b64 s[10:11], s[2:3], flat_scratch
// CHECK: [0x02,0x68,0x8a,0x89]

s_xor_b64 s[10:11], s[2:3], vcc
// CHECK: [0x02,0x6a,0x8a,0x89]

s_xor_b64 s[10:11], s[2:3], tba
// CHECK: [0x02,0x6c,0x8a,0x89]

s_xor_b64 s[10:11], s[2:3], tma
// CHECK: [0x02,0x6e,0x8a,0x89]

s_xor_b64 s[10:11], s[2:3], ttmp[10:11]
// CHECK: [0x02,0x7a,0x8a,0x89]

s_xor_b64 s[10:11], s[2:3], exec
// CHECK: [0x02,0x7e,0x8a,0x89]

s_xor_b64 s[10:11], s[2:3], 0
// CHECK: [0x02,0x80,0x8a,0x89]

s_xor_b64 s[10:11], s[2:3], -1
// CHECK: [0x02,0xc1,0x8a,0x89]

s_xor_b64 s[10:11], s[2:3], 0.5
// CHECK: [0x02,0xf0,0x8a,0x89]

s_xor_b64 s[10:11], s[2:3], -4.0
// CHECK: [0x02,0xf7,0x8a,0x89]

s_xor_b64 s[10:11], s[2:3], 0xaf123456
// CHECK: [0x02,0xff,0x8a,0x89,0x56,0x34,0x12,0xaf]

s_xor_b64 s[10:11], s[2:3], 0x3f717273
// CHECK: [0x02,0xff,0x8a,0x89,0x73,0x72,0x71,0x3f]

s_andn2_b32 s5, s1, s2
// CHECK: [0x01,0x02,0x05,0x8a]

s_andn2_b32 s103, s1, s2
// CHECK: [0x01,0x02,0x67,0x8a]

s_andn2_b32 flat_scratch_lo, s1, s2
// CHECK: [0x01,0x02,0x68,0x8a]

s_andn2_b32 flat_scratch_hi, s1, s2
// CHECK: [0x01,0x02,0x69,0x8a]

s_andn2_b32 vcc_lo, s1, s2
// CHECK: [0x01,0x02,0x6a,0x8a]

s_andn2_b32 vcc_hi, s1, s2
// CHECK: [0x01,0x02,0x6b,0x8a]

s_andn2_b32 tba_lo, s1, s2
// CHECK: [0x01,0x02,0x6c,0x8a]

s_andn2_b32 tba_hi, s1, s2
// CHECK: [0x01,0x02,0x6d,0x8a]

s_andn2_b32 tma_lo, s1, s2
// CHECK: [0x01,0x02,0x6e,0x8a]

s_andn2_b32 tma_hi, s1, s2
// CHECK: [0x01,0x02,0x6f,0x8a]

s_andn2_b32 ttmp11, s1, s2
// CHECK: [0x01,0x02,0x7b,0x8a]

s_andn2_b32 m0, s1, s2
// CHECK: [0x01,0x02,0x7c,0x8a]

s_andn2_b32 exec_lo, s1, s2
// CHECK: [0x01,0x02,0x7e,0x8a]

s_andn2_b32 exec_hi, s1, s2
// CHECK: [0x01,0x02,0x7f,0x8a]

s_andn2_b32 s5, s103, s2
// CHECK: [0x67,0x02,0x05,0x8a]

s_andn2_b32 s5, flat_scratch_lo, s2
// CHECK: [0x68,0x02,0x05,0x8a]

s_andn2_b32 s5, flat_scratch_hi, s2
// CHECK: [0x69,0x02,0x05,0x8a]

s_andn2_b32 s5, vcc_lo, s2
// CHECK: [0x6a,0x02,0x05,0x8a]

s_andn2_b32 s5, vcc_hi, s2
// CHECK: [0x6b,0x02,0x05,0x8a]

s_andn2_b32 s5, tba_lo, s2
// CHECK: [0x6c,0x02,0x05,0x8a]

s_andn2_b32 s5, tba_hi, s2
// CHECK: [0x6d,0x02,0x05,0x8a]

s_andn2_b32 s5, tma_lo, s2
// CHECK: [0x6e,0x02,0x05,0x8a]

s_andn2_b32 s5, tma_hi, s2
// CHECK: [0x6f,0x02,0x05,0x8a]

s_andn2_b32 s5, ttmp11, s2
// CHECK: [0x7b,0x02,0x05,0x8a]

s_andn2_b32 s5, m0, s2
// CHECK: [0x7c,0x02,0x05,0x8a]

s_andn2_b32 s5, exec_lo, s2
// CHECK: [0x7e,0x02,0x05,0x8a]

s_andn2_b32 s5, exec_hi, s2
// CHECK: [0x7f,0x02,0x05,0x8a]

s_andn2_b32 s5, 0, s2
// CHECK: [0x80,0x02,0x05,0x8a]

s_andn2_b32 s5, -1, s2
// CHECK: [0xc1,0x02,0x05,0x8a]

s_andn2_b32 s5, 0.5, s2
// CHECK: [0xf0,0x02,0x05,0x8a]

s_andn2_b32 s5, -4.0, s2
// CHECK: [0xf7,0x02,0x05,0x8a]

s_andn2_b32 s5, 0xaf123456, s2
// CHECK: [0xff,0x02,0x05,0x8a,0x56,0x34,0x12,0xaf]

s_andn2_b32 s5, 0x3f717273, s2
// CHECK: [0xff,0x02,0x05,0x8a,0x73,0x72,0x71,0x3f]

s_andn2_b32 s5, s1, s103
// CHECK: [0x01,0x67,0x05,0x8a]

s_andn2_b32 s5, s1, flat_scratch_lo
// CHECK: [0x01,0x68,0x05,0x8a]

s_andn2_b32 s5, s1, flat_scratch_hi
// CHECK: [0x01,0x69,0x05,0x8a]

s_andn2_b32 s5, s1, vcc_lo
// CHECK: [0x01,0x6a,0x05,0x8a]

s_andn2_b32 s5, s1, vcc_hi
// CHECK: [0x01,0x6b,0x05,0x8a]

s_andn2_b32 s5, s1, tba_lo
// CHECK: [0x01,0x6c,0x05,0x8a]

s_andn2_b32 s5, s1, tba_hi
// CHECK: [0x01,0x6d,0x05,0x8a]

s_andn2_b32 s5, s1, tma_lo
// CHECK: [0x01,0x6e,0x05,0x8a]

s_andn2_b32 s5, s1, tma_hi
// CHECK: [0x01,0x6f,0x05,0x8a]

s_andn2_b32 s5, s1, ttmp11
// CHECK: [0x01,0x7b,0x05,0x8a]

s_andn2_b32 s5, s1, m0
// CHECK: [0x01,0x7c,0x05,0x8a]

s_andn2_b32 s5, s1, exec_lo
// CHECK: [0x01,0x7e,0x05,0x8a]

s_andn2_b32 s5, s1, exec_hi
// CHECK: [0x01,0x7f,0x05,0x8a]

s_andn2_b32 s5, s1, 0
// CHECK: [0x01,0x80,0x05,0x8a]

s_andn2_b32 s5, s1, -1
// CHECK: [0x01,0xc1,0x05,0x8a]

s_andn2_b32 s5, s1, 0.5
// CHECK: [0x01,0xf0,0x05,0x8a]

s_andn2_b32 s5, s1, -4.0
// CHECK: [0x01,0xf7,0x05,0x8a]

s_andn2_b32 s5, s1, 0xaf123456
// CHECK: [0x01,0xff,0x05,0x8a,0x56,0x34,0x12,0xaf]

s_andn2_b32 s5, s1, 0x3f717273
// CHECK: [0x01,0xff,0x05,0x8a,0x73,0x72,0x71,0x3f]

s_andn2_b64 s[10:11], s[2:3], s[4:5]
// CHECK: [0x02,0x04,0x8a,0x8a]

s_andn2_b64 s[12:13], s[2:3], s[4:5]
// CHECK: [0x02,0x04,0x8c,0x8a]

s_andn2_b64 s[102:103], s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xe6,0x8a]

s_andn2_b64 flat_scratch, s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xe8,0x8a]

s_andn2_b64 vcc, s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xea,0x8a]

s_andn2_b64 tba, s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xec,0x8a]

s_andn2_b64 tma, s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xee,0x8a]

s_andn2_b64 ttmp[10:11], s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xfa,0x8a]

s_andn2_b64 exec, s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xfe,0x8a]

s_andn2_b64 s[10:11], s[4:5], s[4:5]
// CHECK: [0x04,0x04,0x8a,0x8a]

s_andn2_b64 s[10:11], s[102:103], s[4:5]
// CHECK: [0x66,0x04,0x8a,0x8a]

s_andn2_b64 s[10:11], flat_scratch, s[4:5]
// CHECK: [0x68,0x04,0x8a,0x8a]

s_andn2_b64 s[10:11], vcc, s[4:5]
// CHECK: [0x6a,0x04,0x8a,0x8a]

s_andn2_b64 s[10:11], tba, s[4:5]
// CHECK: [0x6c,0x04,0x8a,0x8a]

s_andn2_b64 s[10:11], tma, s[4:5]
// CHECK: [0x6e,0x04,0x8a,0x8a]

s_andn2_b64 s[10:11], ttmp[10:11], s[4:5]
// CHECK: [0x7a,0x04,0x8a,0x8a]

s_andn2_b64 s[10:11], exec, s[4:5]
// CHECK: [0x7e,0x04,0x8a,0x8a]

s_andn2_b64 s[10:11], 0, s[4:5]
// CHECK: [0x80,0x04,0x8a,0x8a]

s_andn2_b64 s[10:11], -1, s[4:5]
// CHECK: [0xc1,0x04,0x8a,0x8a]

s_andn2_b64 s[10:11], 0.5, s[4:5]
// CHECK: [0xf0,0x04,0x8a,0x8a]

s_andn2_b64 s[10:11], -4.0, s[4:5]
// CHECK: [0xf7,0x04,0x8a,0x8a]

s_andn2_b64 s[10:11], 0xaf123456, s[4:5]
// CHECK: [0xff,0x04,0x8a,0x8a,0x56,0x34,0x12,0xaf]

s_andn2_b64 s[10:11], 0x3f717273, s[4:5]
// CHECK: [0xff,0x04,0x8a,0x8a,0x73,0x72,0x71,0x3f]

s_andn2_b64 s[10:11], s[2:3], s[6:7]
// CHECK: [0x02,0x06,0x8a,0x8a]

s_andn2_b64 s[10:11], s[2:3], s[102:103]
// CHECK: [0x02,0x66,0x8a,0x8a]

s_andn2_b64 s[10:11], s[2:3], flat_scratch
// CHECK: [0x02,0x68,0x8a,0x8a]

s_andn2_b64 s[10:11], s[2:3], vcc
// CHECK: [0x02,0x6a,0x8a,0x8a]

s_andn2_b64 s[10:11], s[2:3], tba
// CHECK: [0x02,0x6c,0x8a,0x8a]

s_andn2_b64 s[10:11], s[2:3], tma
// CHECK: [0x02,0x6e,0x8a,0x8a]

s_andn2_b64 s[10:11], s[2:3], ttmp[10:11]
// CHECK: [0x02,0x7a,0x8a,0x8a]

s_andn2_b64 s[10:11], s[2:3], exec
// CHECK: [0x02,0x7e,0x8a,0x8a]

s_andn2_b64 s[10:11], s[2:3], 0
// CHECK: [0x02,0x80,0x8a,0x8a]

s_andn2_b64 s[10:11], s[2:3], -1
// CHECK: [0x02,0xc1,0x8a,0x8a]

s_andn2_b64 s[10:11], s[2:3], 0.5
// CHECK: [0x02,0xf0,0x8a,0x8a]

s_andn2_b64 s[10:11], s[2:3], -4.0
// CHECK: [0x02,0xf7,0x8a,0x8a]

s_andn2_b64 s[10:11], s[2:3], 0xaf123456
// CHECK: [0x02,0xff,0x8a,0x8a,0x56,0x34,0x12,0xaf]

s_andn2_b64 s[10:11], s[2:3], 0x3f717273
// CHECK: [0x02,0xff,0x8a,0x8a,0x73,0x72,0x71,0x3f]

s_orn2_b32 s5, s1, s2
// CHECK: [0x01,0x02,0x05,0x8b]

s_orn2_b32 s103, s1, s2
// CHECK: [0x01,0x02,0x67,0x8b]

s_orn2_b32 flat_scratch_lo, s1, s2
// CHECK: [0x01,0x02,0x68,0x8b]

s_orn2_b32 flat_scratch_hi, s1, s2
// CHECK: [0x01,0x02,0x69,0x8b]

s_orn2_b32 vcc_lo, s1, s2
// CHECK: [0x01,0x02,0x6a,0x8b]

s_orn2_b32 vcc_hi, s1, s2
// CHECK: [0x01,0x02,0x6b,0x8b]

s_orn2_b32 tba_lo, s1, s2
// CHECK: [0x01,0x02,0x6c,0x8b]

s_orn2_b32 tba_hi, s1, s2
// CHECK: [0x01,0x02,0x6d,0x8b]

s_orn2_b32 tma_lo, s1, s2
// CHECK: [0x01,0x02,0x6e,0x8b]

s_orn2_b32 tma_hi, s1, s2
// CHECK: [0x01,0x02,0x6f,0x8b]

s_orn2_b32 ttmp11, s1, s2
// CHECK: [0x01,0x02,0x7b,0x8b]

s_orn2_b32 m0, s1, s2
// CHECK: [0x01,0x02,0x7c,0x8b]

s_orn2_b32 exec_lo, s1, s2
// CHECK: [0x01,0x02,0x7e,0x8b]

s_orn2_b32 exec_hi, s1, s2
// CHECK: [0x01,0x02,0x7f,0x8b]

s_orn2_b32 s5, s103, s2
// CHECK: [0x67,0x02,0x05,0x8b]

s_orn2_b32 s5, flat_scratch_lo, s2
// CHECK: [0x68,0x02,0x05,0x8b]

s_orn2_b32 s5, flat_scratch_hi, s2
// CHECK: [0x69,0x02,0x05,0x8b]

s_orn2_b32 s5, vcc_lo, s2
// CHECK: [0x6a,0x02,0x05,0x8b]

s_orn2_b32 s5, vcc_hi, s2
// CHECK: [0x6b,0x02,0x05,0x8b]

s_orn2_b32 s5, tba_lo, s2
// CHECK: [0x6c,0x02,0x05,0x8b]

s_orn2_b32 s5, tba_hi, s2
// CHECK: [0x6d,0x02,0x05,0x8b]

s_orn2_b32 s5, tma_lo, s2
// CHECK: [0x6e,0x02,0x05,0x8b]

s_orn2_b32 s5, tma_hi, s2
// CHECK: [0x6f,0x02,0x05,0x8b]

s_orn2_b32 s5, ttmp11, s2
// CHECK: [0x7b,0x02,0x05,0x8b]

s_orn2_b32 s5, m0, s2
// CHECK: [0x7c,0x02,0x05,0x8b]

s_orn2_b32 s5, exec_lo, s2
// CHECK: [0x7e,0x02,0x05,0x8b]

s_orn2_b32 s5, exec_hi, s2
// CHECK: [0x7f,0x02,0x05,0x8b]

s_orn2_b32 s5, 0, s2
// CHECK: [0x80,0x02,0x05,0x8b]

s_orn2_b32 s5, -1, s2
// CHECK: [0xc1,0x02,0x05,0x8b]

s_orn2_b32 s5, 0.5, s2
// CHECK: [0xf0,0x02,0x05,0x8b]

s_orn2_b32 s5, -4.0, s2
// CHECK: [0xf7,0x02,0x05,0x8b]

s_orn2_b32 s5, 0xaf123456, s2
// CHECK: [0xff,0x02,0x05,0x8b,0x56,0x34,0x12,0xaf]

s_orn2_b32 s5, 0x3f717273, s2
// CHECK: [0xff,0x02,0x05,0x8b,0x73,0x72,0x71,0x3f]

s_orn2_b32 s5, s1, s103
// CHECK: [0x01,0x67,0x05,0x8b]

s_orn2_b32 s5, s1, flat_scratch_lo
// CHECK: [0x01,0x68,0x05,0x8b]

s_orn2_b32 s5, s1, flat_scratch_hi
// CHECK: [0x01,0x69,0x05,0x8b]

s_orn2_b32 s5, s1, vcc_lo
// CHECK: [0x01,0x6a,0x05,0x8b]

s_orn2_b32 s5, s1, vcc_hi
// CHECK: [0x01,0x6b,0x05,0x8b]

s_orn2_b32 s5, s1, tba_lo
// CHECK: [0x01,0x6c,0x05,0x8b]

s_orn2_b32 s5, s1, tba_hi
// CHECK: [0x01,0x6d,0x05,0x8b]

s_orn2_b32 s5, s1, tma_lo
// CHECK: [0x01,0x6e,0x05,0x8b]

s_orn2_b32 s5, s1, tma_hi
// CHECK: [0x01,0x6f,0x05,0x8b]

s_orn2_b32 s5, s1, ttmp11
// CHECK: [0x01,0x7b,0x05,0x8b]

s_orn2_b32 s5, s1, m0
// CHECK: [0x01,0x7c,0x05,0x8b]

s_orn2_b32 s5, s1, exec_lo
// CHECK: [0x01,0x7e,0x05,0x8b]

s_orn2_b32 s5, s1, exec_hi
// CHECK: [0x01,0x7f,0x05,0x8b]

s_orn2_b32 s5, s1, 0
// CHECK: [0x01,0x80,0x05,0x8b]

s_orn2_b32 s5, s1, -1
// CHECK: [0x01,0xc1,0x05,0x8b]

s_orn2_b32 s5, s1, 0.5
// CHECK: [0x01,0xf0,0x05,0x8b]

s_orn2_b32 s5, s1, -4.0
// CHECK: [0x01,0xf7,0x05,0x8b]

s_orn2_b32 s5, s1, 0xaf123456
// CHECK: [0x01,0xff,0x05,0x8b,0x56,0x34,0x12,0xaf]

s_orn2_b32 s5, s1, 0x3f717273
// CHECK: [0x01,0xff,0x05,0x8b,0x73,0x72,0x71,0x3f]

s_orn2_b64 s[10:11], s[2:3], s[4:5]
// CHECK: [0x02,0x04,0x8a,0x8b]

s_orn2_b64 s[12:13], s[2:3], s[4:5]
// CHECK: [0x02,0x04,0x8c,0x8b]

s_orn2_b64 s[102:103], s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xe6,0x8b]

s_orn2_b64 flat_scratch, s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xe8,0x8b]

s_orn2_b64 vcc, s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xea,0x8b]

s_orn2_b64 tba, s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xec,0x8b]

s_orn2_b64 tma, s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xee,0x8b]

s_orn2_b64 ttmp[10:11], s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xfa,0x8b]

s_orn2_b64 exec, s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xfe,0x8b]

s_orn2_b64 s[10:11], s[4:5], s[4:5]
// CHECK: [0x04,0x04,0x8a,0x8b]

s_orn2_b64 s[10:11], s[102:103], s[4:5]
// CHECK: [0x66,0x04,0x8a,0x8b]

s_orn2_b64 s[10:11], flat_scratch, s[4:5]
// CHECK: [0x68,0x04,0x8a,0x8b]

s_orn2_b64 s[10:11], vcc, s[4:5]
// CHECK: [0x6a,0x04,0x8a,0x8b]

s_orn2_b64 s[10:11], tba, s[4:5]
// CHECK: [0x6c,0x04,0x8a,0x8b]

s_orn2_b64 s[10:11], tma, s[4:5]
// CHECK: [0x6e,0x04,0x8a,0x8b]

s_orn2_b64 s[10:11], ttmp[10:11], s[4:5]
// CHECK: [0x7a,0x04,0x8a,0x8b]

s_orn2_b64 s[10:11], exec, s[4:5]
// CHECK: [0x7e,0x04,0x8a,0x8b]

s_orn2_b64 s[10:11], 0, s[4:5]
// CHECK: [0x80,0x04,0x8a,0x8b]

s_orn2_b64 s[10:11], -1, s[4:5]
// CHECK: [0xc1,0x04,0x8a,0x8b]

s_orn2_b64 s[10:11], 0.5, s[4:5]
// CHECK: [0xf0,0x04,0x8a,0x8b]

s_orn2_b64 s[10:11], -4.0, s[4:5]
// CHECK: [0xf7,0x04,0x8a,0x8b]

s_orn2_b64 s[10:11], 0xaf123456, s[4:5]
// CHECK: [0xff,0x04,0x8a,0x8b,0x56,0x34,0x12,0xaf]

s_orn2_b64 s[10:11], 0x3f717273, s[4:5]
// CHECK: [0xff,0x04,0x8a,0x8b,0x73,0x72,0x71,0x3f]

s_orn2_b64 s[10:11], s[2:3], s[6:7]
// CHECK: [0x02,0x06,0x8a,0x8b]

s_orn2_b64 s[10:11], s[2:3], s[102:103]
// CHECK: [0x02,0x66,0x8a,0x8b]

s_orn2_b64 s[10:11], s[2:3], flat_scratch
// CHECK: [0x02,0x68,0x8a,0x8b]

s_orn2_b64 s[10:11], s[2:3], vcc
// CHECK: [0x02,0x6a,0x8a,0x8b]

s_orn2_b64 s[10:11], s[2:3], tba
// CHECK: [0x02,0x6c,0x8a,0x8b]

s_orn2_b64 s[10:11], s[2:3], tma
// CHECK: [0x02,0x6e,0x8a,0x8b]

s_orn2_b64 s[10:11], s[2:3], ttmp[10:11]
// CHECK: [0x02,0x7a,0x8a,0x8b]

s_orn2_b64 s[10:11], s[2:3], exec
// CHECK: [0x02,0x7e,0x8a,0x8b]

s_orn2_b64 s[10:11], s[2:3], 0
// CHECK: [0x02,0x80,0x8a,0x8b]

s_orn2_b64 s[10:11], s[2:3], -1
// CHECK: [0x02,0xc1,0x8a,0x8b]

s_orn2_b64 s[10:11], s[2:3], 0.5
// CHECK: [0x02,0xf0,0x8a,0x8b]

s_orn2_b64 s[10:11], s[2:3], -4.0
// CHECK: [0x02,0xf7,0x8a,0x8b]

s_orn2_b64 s[10:11], s[2:3], 0xaf123456
// CHECK: [0x02,0xff,0x8a,0x8b,0x56,0x34,0x12,0xaf]

s_orn2_b64 s[10:11], s[2:3], 0x3f717273
// CHECK: [0x02,0xff,0x8a,0x8b,0x73,0x72,0x71,0x3f]

s_nand_b32 s5, s1, s2
// CHECK: [0x01,0x02,0x05,0x8c]

s_nand_b32 s103, s1, s2
// CHECK: [0x01,0x02,0x67,0x8c]

s_nand_b32 flat_scratch_lo, s1, s2
// CHECK: [0x01,0x02,0x68,0x8c]

s_nand_b32 flat_scratch_hi, s1, s2
// CHECK: [0x01,0x02,0x69,0x8c]

s_nand_b32 vcc_lo, s1, s2
// CHECK: [0x01,0x02,0x6a,0x8c]

s_nand_b32 vcc_hi, s1, s2
// CHECK: [0x01,0x02,0x6b,0x8c]

s_nand_b32 tba_lo, s1, s2
// CHECK: [0x01,0x02,0x6c,0x8c]

s_nand_b32 tba_hi, s1, s2
// CHECK: [0x01,0x02,0x6d,0x8c]

s_nand_b32 tma_lo, s1, s2
// CHECK: [0x01,0x02,0x6e,0x8c]

s_nand_b32 tma_hi, s1, s2
// CHECK: [0x01,0x02,0x6f,0x8c]

s_nand_b32 ttmp11, s1, s2
// CHECK: [0x01,0x02,0x7b,0x8c]

s_nand_b32 m0, s1, s2
// CHECK: [0x01,0x02,0x7c,0x8c]

s_nand_b32 exec_lo, s1, s2
// CHECK: [0x01,0x02,0x7e,0x8c]

s_nand_b32 exec_hi, s1, s2
// CHECK: [0x01,0x02,0x7f,0x8c]

s_nand_b32 s5, s103, s2
// CHECK: [0x67,0x02,0x05,0x8c]

s_nand_b32 s5, flat_scratch_lo, s2
// CHECK: [0x68,0x02,0x05,0x8c]

s_nand_b32 s5, flat_scratch_hi, s2
// CHECK: [0x69,0x02,0x05,0x8c]

s_nand_b32 s5, vcc_lo, s2
// CHECK: [0x6a,0x02,0x05,0x8c]

s_nand_b32 s5, vcc_hi, s2
// CHECK: [0x6b,0x02,0x05,0x8c]

s_nand_b32 s5, tba_lo, s2
// CHECK: [0x6c,0x02,0x05,0x8c]

s_nand_b32 s5, tba_hi, s2
// CHECK: [0x6d,0x02,0x05,0x8c]

s_nand_b32 s5, tma_lo, s2
// CHECK: [0x6e,0x02,0x05,0x8c]

s_nand_b32 s5, tma_hi, s2
// CHECK: [0x6f,0x02,0x05,0x8c]

s_nand_b32 s5, ttmp11, s2
// CHECK: [0x7b,0x02,0x05,0x8c]

s_nand_b32 s5, m0, s2
// CHECK: [0x7c,0x02,0x05,0x8c]

s_nand_b32 s5, exec_lo, s2
// CHECK: [0x7e,0x02,0x05,0x8c]

s_nand_b32 s5, exec_hi, s2
// CHECK: [0x7f,0x02,0x05,0x8c]

s_nand_b32 s5, 0, s2
// CHECK: [0x80,0x02,0x05,0x8c]

s_nand_b32 s5, -1, s2
// CHECK: [0xc1,0x02,0x05,0x8c]

s_nand_b32 s5, 0.5, s2
// CHECK: [0xf0,0x02,0x05,0x8c]

s_nand_b32 s5, -4.0, s2
// CHECK: [0xf7,0x02,0x05,0x8c]

s_nand_b32 s5, 0xaf123456, s2
// CHECK: [0xff,0x02,0x05,0x8c,0x56,0x34,0x12,0xaf]

s_nand_b32 s5, 0x3f717273, s2
// CHECK: [0xff,0x02,0x05,0x8c,0x73,0x72,0x71,0x3f]

s_nand_b32 s5, s1, s103
// CHECK: [0x01,0x67,0x05,0x8c]

s_nand_b32 s5, s1, flat_scratch_lo
// CHECK: [0x01,0x68,0x05,0x8c]

s_nand_b32 s5, s1, flat_scratch_hi
// CHECK: [0x01,0x69,0x05,0x8c]

s_nand_b32 s5, s1, vcc_lo
// CHECK: [0x01,0x6a,0x05,0x8c]

s_nand_b32 s5, s1, vcc_hi
// CHECK: [0x01,0x6b,0x05,0x8c]

s_nand_b32 s5, s1, tba_lo
// CHECK: [0x01,0x6c,0x05,0x8c]

s_nand_b32 s5, s1, tba_hi
// CHECK: [0x01,0x6d,0x05,0x8c]

s_nand_b32 s5, s1, tma_lo
// CHECK: [0x01,0x6e,0x05,0x8c]

s_nand_b32 s5, s1, tma_hi
// CHECK: [0x01,0x6f,0x05,0x8c]

s_nand_b32 s5, s1, ttmp11
// CHECK: [0x01,0x7b,0x05,0x8c]

s_nand_b32 s5, s1, m0
// CHECK: [0x01,0x7c,0x05,0x8c]

s_nand_b32 s5, s1, exec_lo
// CHECK: [0x01,0x7e,0x05,0x8c]

s_nand_b32 s5, s1, exec_hi
// CHECK: [0x01,0x7f,0x05,0x8c]

s_nand_b32 s5, s1, 0
// CHECK: [0x01,0x80,0x05,0x8c]

s_nand_b32 s5, s1, -1
// CHECK: [0x01,0xc1,0x05,0x8c]

s_nand_b32 s5, s1, 0.5
// CHECK: [0x01,0xf0,0x05,0x8c]

s_nand_b32 s5, s1, -4.0
// CHECK: [0x01,0xf7,0x05,0x8c]

s_nand_b32 s5, s1, 0xaf123456
// CHECK: [0x01,0xff,0x05,0x8c,0x56,0x34,0x12,0xaf]

s_nand_b32 s5, s1, 0x3f717273
// CHECK: [0x01,0xff,0x05,0x8c,0x73,0x72,0x71,0x3f]

s_nand_b64 s[10:11], s[2:3], s[4:5]
// CHECK: [0x02,0x04,0x8a,0x8c]

s_nand_b64 s[12:13], s[2:3], s[4:5]
// CHECK: [0x02,0x04,0x8c,0x8c]

s_nand_b64 s[102:103], s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xe6,0x8c]

s_nand_b64 flat_scratch, s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xe8,0x8c]

s_nand_b64 vcc, s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xea,0x8c]

s_nand_b64 tba, s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xec,0x8c]

s_nand_b64 tma, s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xee,0x8c]

s_nand_b64 ttmp[10:11], s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xfa,0x8c]

s_nand_b64 exec, s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xfe,0x8c]

s_nand_b64 s[10:11], s[4:5], s[4:5]
// CHECK: [0x04,0x04,0x8a,0x8c]

s_nand_b64 s[10:11], s[102:103], s[4:5]
// CHECK: [0x66,0x04,0x8a,0x8c]

s_nand_b64 s[10:11], flat_scratch, s[4:5]
// CHECK: [0x68,0x04,0x8a,0x8c]

s_nand_b64 s[10:11], vcc, s[4:5]
// CHECK: [0x6a,0x04,0x8a,0x8c]

s_nand_b64 s[10:11], tba, s[4:5]
// CHECK: [0x6c,0x04,0x8a,0x8c]

s_nand_b64 s[10:11], tma, s[4:5]
// CHECK: [0x6e,0x04,0x8a,0x8c]

s_nand_b64 s[10:11], ttmp[10:11], s[4:5]
// CHECK: [0x7a,0x04,0x8a,0x8c]

s_nand_b64 s[10:11], exec, s[4:5]
// CHECK: [0x7e,0x04,0x8a,0x8c]

s_nand_b64 s[10:11], 0, s[4:5]
// CHECK: [0x80,0x04,0x8a,0x8c]

s_nand_b64 s[10:11], -1, s[4:5]
// CHECK: [0xc1,0x04,0x8a,0x8c]

s_nand_b64 s[10:11], 0.5, s[4:5]
// CHECK: [0xf0,0x04,0x8a,0x8c]

s_nand_b64 s[10:11], -4.0, s[4:5]
// CHECK: [0xf7,0x04,0x8a,0x8c]

s_nand_b64 s[10:11], 0xaf123456, s[4:5]
// CHECK: [0xff,0x04,0x8a,0x8c,0x56,0x34,0x12,0xaf]

s_nand_b64 s[10:11], 0x3f717273, s[4:5]
// CHECK: [0xff,0x04,0x8a,0x8c,0x73,0x72,0x71,0x3f]

s_nand_b64 s[10:11], s[2:3], s[6:7]
// CHECK: [0x02,0x06,0x8a,0x8c]

s_nand_b64 s[10:11], s[2:3], s[102:103]
// CHECK: [0x02,0x66,0x8a,0x8c]

s_nand_b64 s[10:11], s[2:3], flat_scratch
// CHECK: [0x02,0x68,0x8a,0x8c]

s_nand_b64 s[10:11], s[2:3], vcc
// CHECK: [0x02,0x6a,0x8a,0x8c]

s_nand_b64 s[10:11], s[2:3], tba
// CHECK: [0x02,0x6c,0x8a,0x8c]

s_nand_b64 s[10:11], s[2:3], tma
// CHECK: [0x02,0x6e,0x8a,0x8c]

s_nand_b64 s[10:11], s[2:3], ttmp[10:11]
// CHECK: [0x02,0x7a,0x8a,0x8c]

s_nand_b64 s[10:11], s[2:3], exec
// CHECK: [0x02,0x7e,0x8a,0x8c]

s_nand_b64 s[10:11], s[2:3], 0
// CHECK: [0x02,0x80,0x8a,0x8c]

s_nand_b64 s[10:11], s[2:3], -1
// CHECK: [0x02,0xc1,0x8a,0x8c]

s_nand_b64 s[10:11], s[2:3], 0.5
// CHECK: [0x02,0xf0,0x8a,0x8c]

s_nand_b64 s[10:11], s[2:3], -4.0
// CHECK: [0x02,0xf7,0x8a,0x8c]

s_nand_b64 s[10:11], s[2:3], 0xaf123456
// CHECK: [0x02,0xff,0x8a,0x8c,0x56,0x34,0x12,0xaf]

s_nand_b64 s[10:11], s[2:3], 0x3f717273
// CHECK: [0x02,0xff,0x8a,0x8c,0x73,0x72,0x71,0x3f]

s_nor_b32 s5, s1, s2
// CHECK: [0x01,0x02,0x05,0x8d]

s_nor_b32 s103, s1, s2
// CHECK: [0x01,0x02,0x67,0x8d]

s_nor_b32 flat_scratch_lo, s1, s2
// CHECK: [0x01,0x02,0x68,0x8d]

s_nor_b32 flat_scratch_hi, s1, s2
// CHECK: [0x01,0x02,0x69,0x8d]

s_nor_b32 vcc_lo, s1, s2
// CHECK: [0x01,0x02,0x6a,0x8d]

s_nor_b32 vcc_hi, s1, s2
// CHECK: [0x01,0x02,0x6b,0x8d]

s_nor_b32 tba_lo, s1, s2
// CHECK: [0x01,0x02,0x6c,0x8d]

s_nor_b32 tba_hi, s1, s2
// CHECK: [0x01,0x02,0x6d,0x8d]

s_nor_b32 tma_lo, s1, s2
// CHECK: [0x01,0x02,0x6e,0x8d]

s_nor_b32 tma_hi, s1, s2
// CHECK: [0x01,0x02,0x6f,0x8d]

s_nor_b32 ttmp11, s1, s2
// CHECK: [0x01,0x02,0x7b,0x8d]

s_nor_b32 m0, s1, s2
// CHECK: [0x01,0x02,0x7c,0x8d]

s_nor_b32 exec_lo, s1, s2
// CHECK: [0x01,0x02,0x7e,0x8d]

s_nor_b32 exec_hi, s1, s2
// CHECK: [0x01,0x02,0x7f,0x8d]

s_nor_b32 s5, s103, s2
// CHECK: [0x67,0x02,0x05,0x8d]

s_nor_b32 s5, flat_scratch_lo, s2
// CHECK: [0x68,0x02,0x05,0x8d]

s_nor_b32 s5, flat_scratch_hi, s2
// CHECK: [0x69,0x02,0x05,0x8d]

s_nor_b32 s5, vcc_lo, s2
// CHECK: [0x6a,0x02,0x05,0x8d]

s_nor_b32 s5, vcc_hi, s2
// CHECK: [0x6b,0x02,0x05,0x8d]

s_nor_b32 s5, tba_lo, s2
// CHECK: [0x6c,0x02,0x05,0x8d]

s_nor_b32 s5, tba_hi, s2
// CHECK: [0x6d,0x02,0x05,0x8d]

s_nor_b32 s5, tma_lo, s2
// CHECK: [0x6e,0x02,0x05,0x8d]

s_nor_b32 s5, tma_hi, s2
// CHECK: [0x6f,0x02,0x05,0x8d]

s_nor_b32 s5, ttmp11, s2
// CHECK: [0x7b,0x02,0x05,0x8d]

s_nor_b32 s5, m0, s2
// CHECK: [0x7c,0x02,0x05,0x8d]

s_nor_b32 s5, exec_lo, s2
// CHECK: [0x7e,0x02,0x05,0x8d]

s_nor_b32 s5, exec_hi, s2
// CHECK: [0x7f,0x02,0x05,0x8d]

s_nor_b32 s5, 0, s2
// CHECK: [0x80,0x02,0x05,0x8d]

s_nor_b32 s5, -1, s2
// CHECK: [0xc1,0x02,0x05,0x8d]

s_nor_b32 s5, 0.5, s2
// CHECK: [0xf0,0x02,0x05,0x8d]

s_nor_b32 s5, -4.0, s2
// CHECK: [0xf7,0x02,0x05,0x8d]

s_nor_b32 s5, 0xaf123456, s2
// CHECK: [0xff,0x02,0x05,0x8d,0x56,0x34,0x12,0xaf]

s_nor_b32 s5, 0x3f717273, s2
// CHECK: [0xff,0x02,0x05,0x8d,0x73,0x72,0x71,0x3f]

s_nor_b32 s5, s1, s103
// CHECK: [0x01,0x67,0x05,0x8d]

s_nor_b32 s5, s1, flat_scratch_lo
// CHECK: [0x01,0x68,0x05,0x8d]

s_nor_b32 s5, s1, flat_scratch_hi
// CHECK: [0x01,0x69,0x05,0x8d]

s_nor_b32 s5, s1, vcc_lo
// CHECK: [0x01,0x6a,0x05,0x8d]

s_nor_b32 s5, s1, vcc_hi
// CHECK: [0x01,0x6b,0x05,0x8d]

s_nor_b32 s5, s1, tba_lo
// CHECK: [0x01,0x6c,0x05,0x8d]

s_nor_b32 s5, s1, tba_hi
// CHECK: [0x01,0x6d,0x05,0x8d]

s_nor_b32 s5, s1, tma_lo
// CHECK: [0x01,0x6e,0x05,0x8d]

s_nor_b32 s5, s1, tma_hi
// CHECK: [0x01,0x6f,0x05,0x8d]

s_nor_b32 s5, s1, ttmp11
// CHECK: [0x01,0x7b,0x05,0x8d]

s_nor_b32 s5, s1, m0
// CHECK: [0x01,0x7c,0x05,0x8d]

s_nor_b32 s5, s1, exec_lo
// CHECK: [0x01,0x7e,0x05,0x8d]

s_nor_b32 s5, s1, exec_hi
// CHECK: [0x01,0x7f,0x05,0x8d]

s_nor_b32 s5, s1, 0
// CHECK: [0x01,0x80,0x05,0x8d]

s_nor_b32 s5, s1, -1
// CHECK: [0x01,0xc1,0x05,0x8d]

s_nor_b32 s5, s1, 0.5
// CHECK: [0x01,0xf0,0x05,0x8d]

s_nor_b32 s5, s1, -4.0
// CHECK: [0x01,0xf7,0x05,0x8d]

s_nor_b32 s5, s1, 0xaf123456
// CHECK: [0x01,0xff,0x05,0x8d,0x56,0x34,0x12,0xaf]

s_nor_b32 s5, s1, 0x3f717273
// CHECK: [0x01,0xff,0x05,0x8d,0x73,0x72,0x71,0x3f]

s_nor_b64 s[10:11], s[2:3], s[4:5]
// CHECK: [0x02,0x04,0x8a,0x8d]

s_nor_b64 s[12:13], s[2:3], s[4:5]
// CHECK: [0x02,0x04,0x8c,0x8d]

s_nor_b64 s[102:103], s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xe6,0x8d]

s_nor_b64 flat_scratch, s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xe8,0x8d]

s_nor_b64 vcc, s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xea,0x8d]

s_nor_b64 tba, s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xec,0x8d]

s_nor_b64 tma, s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xee,0x8d]

s_nor_b64 ttmp[10:11], s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xfa,0x8d]

s_nor_b64 exec, s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xfe,0x8d]

s_nor_b64 s[10:11], s[4:5], s[4:5]
// CHECK: [0x04,0x04,0x8a,0x8d]

s_nor_b64 s[10:11], s[102:103], s[4:5]
// CHECK: [0x66,0x04,0x8a,0x8d]

s_nor_b64 s[10:11], flat_scratch, s[4:5]
// CHECK: [0x68,0x04,0x8a,0x8d]

s_nor_b64 s[10:11], vcc, s[4:5]
// CHECK: [0x6a,0x04,0x8a,0x8d]

s_nor_b64 s[10:11], tba, s[4:5]
// CHECK: [0x6c,0x04,0x8a,0x8d]

s_nor_b64 s[10:11], tma, s[4:5]
// CHECK: [0x6e,0x04,0x8a,0x8d]

s_nor_b64 s[10:11], ttmp[10:11], s[4:5]
// CHECK: [0x7a,0x04,0x8a,0x8d]

s_nor_b64 s[10:11], exec, s[4:5]
// CHECK: [0x7e,0x04,0x8a,0x8d]

s_nor_b64 s[10:11], 0, s[4:5]
// CHECK: [0x80,0x04,0x8a,0x8d]

s_nor_b64 s[10:11], -1, s[4:5]
// CHECK: [0xc1,0x04,0x8a,0x8d]

s_nor_b64 s[10:11], 0.5, s[4:5]
// CHECK: [0xf0,0x04,0x8a,0x8d]

s_nor_b64 s[10:11], -4.0, s[4:5]
// CHECK: [0xf7,0x04,0x8a,0x8d]

s_nor_b64 s[10:11], 0xaf123456, s[4:5]
// CHECK: [0xff,0x04,0x8a,0x8d,0x56,0x34,0x12,0xaf]

s_nor_b64 s[10:11], 0x3f717273, s[4:5]
// CHECK: [0xff,0x04,0x8a,0x8d,0x73,0x72,0x71,0x3f]

s_nor_b64 s[10:11], s[2:3], s[6:7]
// CHECK: [0x02,0x06,0x8a,0x8d]

s_nor_b64 s[10:11], s[2:3], s[102:103]
// CHECK: [0x02,0x66,0x8a,0x8d]

s_nor_b64 s[10:11], s[2:3], flat_scratch
// CHECK: [0x02,0x68,0x8a,0x8d]

s_nor_b64 s[10:11], s[2:3], vcc
// CHECK: [0x02,0x6a,0x8a,0x8d]

s_nor_b64 s[10:11], s[2:3], tba
// CHECK: [0x02,0x6c,0x8a,0x8d]

s_nor_b64 s[10:11], s[2:3], tma
// CHECK: [0x02,0x6e,0x8a,0x8d]

s_nor_b64 s[10:11], s[2:3], ttmp[10:11]
// CHECK: [0x02,0x7a,0x8a,0x8d]

s_nor_b64 s[10:11], s[2:3], exec
// CHECK: [0x02,0x7e,0x8a,0x8d]

s_nor_b64 s[10:11], s[2:3], 0
// CHECK: [0x02,0x80,0x8a,0x8d]

s_nor_b64 s[10:11], s[2:3], -1
// CHECK: [0x02,0xc1,0x8a,0x8d]

s_nor_b64 s[10:11], s[2:3], 0.5
// CHECK: [0x02,0xf0,0x8a,0x8d]

s_nor_b64 s[10:11], s[2:3], -4.0
// CHECK: [0x02,0xf7,0x8a,0x8d]

s_nor_b64 s[10:11], s[2:3], 0xaf123456
// CHECK: [0x02,0xff,0x8a,0x8d,0x56,0x34,0x12,0xaf]

s_nor_b64 s[10:11], s[2:3], 0x3f717273
// CHECK: [0x02,0xff,0x8a,0x8d,0x73,0x72,0x71,0x3f]

s_xnor_b32 s5, s1, s2
// CHECK: [0x01,0x02,0x05,0x8e]

s_xnor_b32 s103, s1, s2
// CHECK: [0x01,0x02,0x67,0x8e]

s_xnor_b32 flat_scratch_lo, s1, s2
// CHECK: [0x01,0x02,0x68,0x8e]

s_xnor_b32 flat_scratch_hi, s1, s2
// CHECK: [0x01,0x02,0x69,0x8e]

s_xnor_b32 vcc_lo, s1, s2
// CHECK: [0x01,0x02,0x6a,0x8e]

s_xnor_b32 vcc_hi, s1, s2
// CHECK: [0x01,0x02,0x6b,0x8e]

s_xnor_b32 tba_lo, s1, s2
// CHECK: [0x01,0x02,0x6c,0x8e]

s_xnor_b32 tba_hi, s1, s2
// CHECK: [0x01,0x02,0x6d,0x8e]

s_xnor_b32 tma_lo, s1, s2
// CHECK: [0x01,0x02,0x6e,0x8e]

s_xnor_b32 tma_hi, s1, s2
// CHECK: [0x01,0x02,0x6f,0x8e]

s_xnor_b32 ttmp11, s1, s2
// CHECK: [0x01,0x02,0x7b,0x8e]

s_xnor_b32 m0, s1, s2
// CHECK: [0x01,0x02,0x7c,0x8e]

s_xnor_b32 exec_lo, s1, s2
// CHECK: [0x01,0x02,0x7e,0x8e]

s_xnor_b32 exec_hi, s1, s2
// CHECK: [0x01,0x02,0x7f,0x8e]

s_xnor_b32 s5, s103, s2
// CHECK: [0x67,0x02,0x05,0x8e]

s_xnor_b32 s5, flat_scratch_lo, s2
// CHECK: [0x68,0x02,0x05,0x8e]

s_xnor_b32 s5, flat_scratch_hi, s2
// CHECK: [0x69,0x02,0x05,0x8e]

s_xnor_b32 s5, vcc_lo, s2
// CHECK: [0x6a,0x02,0x05,0x8e]

s_xnor_b32 s5, vcc_hi, s2
// CHECK: [0x6b,0x02,0x05,0x8e]

s_xnor_b32 s5, tba_lo, s2
// CHECK: [0x6c,0x02,0x05,0x8e]

s_xnor_b32 s5, tba_hi, s2
// CHECK: [0x6d,0x02,0x05,0x8e]

s_xnor_b32 s5, tma_lo, s2
// CHECK: [0x6e,0x02,0x05,0x8e]

s_xnor_b32 s5, tma_hi, s2
// CHECK: [0x6f,0x02,0x05,0x8e]

s_xnor_b32 s5, ttmp11, s2
// CHECK: [0x7b,0x02,0x05,0x8e]

s_xnor_b32 s5, m0, s2
// CHECK: [0x7c,0x02,0x05,0x8e]

s_xnor_b32 s5, exec_lo, s2
// CHECK: [0x7e,0x02,0x05,0x8e]

s_xnor_b32 s5, exec_hi, s2
// CHECK: [0x7f,0x02,0x05,0x8e]

s_xnor_b32 s5, 0, s2
// CHECK: [0x80,0x02,0x05,0x8e]

s_xnor_b32 s5, -1, s2
// CHECK: [0xc1,0x02,0x05,0x8e]

s_xnor_b32 s5, 0.5, s2
// CHECK: [0xf0,0x02,0x05,0x8e]

s_xnor_b32 s5, -4.0, s2
// CHECK: [0xf7,0x02,0x05,0x8e]

s_xnor_b32 s5, 0xaf123456, s2
// CHECK: [0xff,0x02,0x05,0x8e,0x56,0x34,0x12,0xaf]

s_xnor_b32 s5, 0x3f717273, s2
// CHECK: [0xff,0x02,0x05,0x8e,0x73,0x72,0x71,0x3f]

s_xnor_b32 s5, s1, s103
// CHECK: [0x01,0x67,0x05,0x8e]

s_xnor_b32 s5, s1, flat_scratch_lo
// CHECK: [0x01,0x68,0x05,0x8e]

s_xnor_b32 s5, s1, flat_scratch_hi
// CHECK: [0x01,0x69,0x05,0x8e]

s_xnor_b32 s5, s1, vcc_lo
// CHECK: [0x01,0x6a,0x05,0x8e]

s_xnor_b32 s5, s1, vcc_hi
// CHECK: [0x01,0x6b,0x05,0x8e]

s_xnor_b32 s5, s1, tba_lo
// CHECK: [0x01,0x6c,0x05,0x8e]

s_xnor_b32 s5, s1, tba_hi
// CHECK: [0x01,0x6d,0x05,0x8e]

s_xnor_b32 s5, s1, tma_lo
// CHECK: [0x01,0x6e,0x05,0x8e]

s_xnor_b32 s5, s1, tma_hi
// CHECK: [0x01,0x6f,0x05,0x8e]

s_xnor_b32 s5, s1, ttmp11
// CHECK: [0x01,0x7b,0x05,0x8e]

s_xnor_b32 s5, s1, m0
// CHECK: [0x01,0x7c,0x05,0x8e]

s_xnor_b32 s5, s1, exec_lo
// CHECK: [0x01,0x7e,0x05,0x8e]

s_xnor_b32 s5, s1, exec_hi
// CHECK: [0x01,0x7f,0x05,0x8e]

s_xnor_b32 s5, s1, 0
// CHECK: [0x01,0x80,0x05,0x8e]

s_xnor_b32 s5, s1, -1
// CHECK: [0x01,0xc1,0x05,0x8e]

s_xnor_b32 s5, s1, 0.5
// CHECK: [0x01,0xf0,0x05,0x8e]

s_xnor_b32 s5, s1, -4.0
// CHECK: [0x01,0xf7,0x05,0x8e]

s_xnor_b32 s5, s1, 0xaf123456
// CHECK: [0x01,0xff,0x05,0x8e,0x56,0x34,0x12,0xaf]

s_xnor_b32 s5, s1, 0x3f717273
// CHECK: [0x01,0xff,0x05,0x8e,0x73,0x72,0x71,0x3f]

s_xnor_b64 s[10:11], s[2:3], s[4:5]
// CHECK: [0x02,0x04,0x8a,0x8e]

s_xnor_b64 s[12:13], s[2:3], s[4:5]
// CHECK: [0x02,0x04,0x8c,0x8e]

s_xnor_b64 s[102:103], s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xe6,0x8e]

s_xnor_b64 flat_scratch, s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xe8,0x8e]

s_xnor_b64 vcc, s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xea,0x8e]

s_xnor_b64 tba, s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xec,0x8e]

s_xnor_b64 tma, s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xee,0x8e]

s_xnor_b64 ttmp[10:11], s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xfa,0x8e]

s_xnor_b64 exec, s[2:3], s[4:5]
// CHECK: [0x02,0x04,0xfe,0x8e]

s_xnor_b64 s[10:11], s[4:5], s[4:5]
// CHECK: [0x04,0x04,0x8a,0x8e]

s_xnor_b64 s[10:11], s[102:103], s[4:5]
// CHECK: [0x66,0x04,0x8a,0x8e]

s_xnor_b64 s[10:11], flat_scratch, s[4:5]
// CHECK: [0x68,0x04,0x8a,0x8e]

s_xnor_b64 s[10:11], vcc, s[4:5]
// CHECK: [0x6a,0x04,0x8a,0x8e]

s_xnor_b64 s[10:11], tba, s[4:5]
// CHECK: [0x6c,0x04,0x8a,0x8e]

s_xnor_b64 s[10:11], tma, s[4:5]
// CHECK: [0x6e,0x04,0x8a,0x8e]

s_xnor_b64 s[10:11], ttmp[10:11], s[4:5]
// CHECK: [0x7a,0x04,0x8a,0x8e]

s_xnor_b64 s[10:11], exec, s[4:5]
// CHECK: [0x7e,0x04,0x8a,0x8e]

s_xnor_b64 s[10:11], 0, s[4:5]
// CHECK: [0x80,0x04,0x8a,0x8e]

s_xnor_b64 s[10:11], -1, s[4:5]
// CHECK: [0xc1,0x04,0x8a,0x8e]

s_xnor_b64 s[10:11], 0.5, s[4:5]
// CHECK: [0xf0,0x04,0x8a,0x8e]

s_xnor_b64 s[10:11], -4.0, s[4:5]
// CHECK: [0xf7,0x04,0x8a,0x8e]

s_xnor_b64 s[10:11], 0xaf123456, s[4:5]
// CHECK: [0xff,0x04,0x8a,0x8e,0x56,0x34,0x12,0xaf]

s_xnor_b64 s[10:11], 0x3f717273, s[4:5]
// CHECK: [0xff,0x04,0x8a,0x8e,0x73,0x72,0x71,0x3f]

s_xnor_b64 s[10:11], s[2:3], s[6:7]
// CHECK: [0x02,0x06,0x8a,0x8e]

s_xnor_b64 s[10:11], s[2:3], s[102:103]
// CHECK: [0x02,0x66,0x8a,0x8e]

s_xnor_b64 s[10:11], s[2:3], flat_scratch
// CHECK: [0x02,0x68,0x8a,0x8e]

s_xnor_b64 s[10:11], s[2:3], vcc
// CHECK: [0x02,0x6a,0x8a,0x8e]

s_xnor_b64 s[10:11], s[2:3], tba
// CHECK: [0x02,0x6c,0x8a,0x8e]

s_xnor_b64 s[10:11], s[2:3], tma
// CHECK: [0x02,0x6e,0x8a,0x8e]

s_xnor_b64 s[10:11], s[2:3], ttmp[10:11]
// CHECK: [0x02,0x7a,0x8a,0x8e]

s_xnor_b64 s[10:11], s[2:3], exec
// CHECK: [0x02,0x7e,0x8a,0x8e]

s_xnor_b64 s[10:11], s[2:3], 0
// CHECK: [0x02,0x80,0x8a,0x8e]

s_xnor_b64 s[10:11], s[2:3], -1
// CHECK: [0x02,0xc1,0x8a,0x8e]

s_xnor_b64 s[10:11], s[2:3], 0.5
// CHECK: [0x02,0xf0,0x8a,0x8e]

s_xnor_b64 s[10:11], s[2:3], -4.0
// CHECK: [0x02,0xf7,0x8a,0x8e]

s_xnor_b64 s[10:11], s[2:3], 0xaf123456
// CHECK: [0x02,0xff,0x8a,0x8e,0x56,0x34,0x12,0xaf]

s_xnor_b64 s[10:11], s[2:3], 0x3f717273
// CHECK: [0x02,0xff,0x8a,0x8e,0x73,0x72,0x71,0x3f]

s_lshl_b32 s5, s1, s2
// CHECK: [0x01,0x02,0x05,0x8f]

s_lshl_b32 s103, s1, s2
// CHECK: [0x01,0x02,0x67,0x8f]

s_lshl_b32 flat_scratch_lo, s1, s2
// CHECK: [0x01,0x02,0x68,0x8f]

s_lshl_b32 flat_scratch_hi, s1, s2
// CHECK: [0x01,0x02,0x69,0x8f]

s_lshl_b32 vcc_lo, s1, s2
// CHECK: [0x01,0x02,0x6a,0x8f]

s_lshl_b32 vcc_hi, s1, s2
// CHECK: [0x01,0x02,0x6b,0x8f]

s_lshl_b32 tba_lo, s1, s2
// CHECK: [0x01,0x02,0x6c,0x8f]

s_lshl_b32 tba_hi, s1, s2
// CHECK: [0x01,0x02,0x6d,0x8f]

s_lshl_b32 tma_lo, s1, s2
// CHECK: [0x01,0x02,0x6e,0x8f]

s_lshl_b32 tma_hi, s1, s2
// CHECK: [0x01,0x02,0x6f,0x8f]

s_lshl_b32 ttmp11, s1, s2
// CHECK: [0x01,0x02,0x7b,0x8f]

s_lshl_b32 m0, s1, s2
// CHECK: [0x01,0x02,0x7c,0x8f]

s_lshl_b32 exec_lo, s1, s2
// CHECK: [0x01,0x02,0x7e,0x8f]

s_lshl_b32 exec_hi, s1, s2
// CHECK: [0x01,0x02,0x7f,0x8f]

s_lshl_b32 s5, s103, s2
// CHECK: [0x67,0x02,0x05,0x8f]

s_lshl_b32 s5, flat_scratch_lo, s2
// CHECK: [0x68,0x02,0x05,0x8f]

s_lshl_b32 s5, flat_scratch_hi, s2
// CHECK: [0x69,0x02,0x05,0x8f]

s_lshl_b32 s5, vcc_lo, s2
// CHECK: [0x6a,0x02,0x05,0x8f]

s_lshl_b32 s5, vcc_hi, s2
// CHECK: [0x6b,0x02,0x05,0x8f]

s_lshl_b32 s5, tba_lo, s2
// CHECK: [0x6c,0x02,0x05,0x8f]

s_lshl_b32 s5, tba_hi, s2
// CHECK: [0x6d,0x02,0x05,0x8f]

s_lshl_b32 s5, tma_lo, s2
// CHECK: [0x6e,0x02,0x05,0x8f]

s_lshl_b32 s5, tma_hi, s2
// CHECK: [0x6f,0x02,0x05,0x8f]

s_lshl_b32 s5, ttmp11, s2
// CHECK: [0x7b,0x02,0x05,0x8f]

s_lshl_b32 s5, m0, s2
// CHECK: [0x7c,0x02,0x05,0x8f]

s_lshl_b32 s5, exec_lo, s2
// CHECK: [0x7e,0x02,0x05,0x8f]

s_lshl_b32 s5, exec_hi, s2
// CHECK: [0x7f,0x02,0x05,0x8f]

s_lshl_b32 s5, 0, s2
// CHECK: [0x80,0x02,0x05,0x8f]

s_lshl_b32 s5, -1, s2
// CHECK: [0xc1,0x02,0x05,0x8f]

s_lshl_b32 s5, 0.5, s2
// CHECK: [0xf0,0x02,0x05,0x8f]

s_lshl_b32 s5, -4.0, s2
// CHECK: [0xf7,0x02,0x05,0x8f]

s_lshl_b32 s5, 0xaf123456, s2
// CHECK: [0xff,0x02,0x05,0x8f,0x56,0x34,0x12,0xaf]

s_lshl_b32 s5, 0x3f717273, s2
// CHECK: [0xff,0x02,0x05,0x8f,0x73,0x72,0x71,0x3f]

s_lshl_b32 s5, s1, s103
// CHECK: [0x01,0x67,0x05,0x8f]

s_lshl_b32 s5, s1, flat_scratch_lo
// CHECK: [0x01,0x68,0x05,0x8f]

s_lshl_b32 s5, s1, flat_scratch_hi
// CHECK: [0x01,0x69,0x05,0x8f]

s_lshl_b32 s5, s1, vcc_lo
// CHECK: [0x01,0x6a,0x05,0x8f]

s_lshl_b32 s5, s1, vcc_hi
// CHECK: [0x01,0x6b,0x05,0x8f]

s_lshl_b32 s5, s1, tba_lo
// CHECK: [0x01,0x6c,0x05,0x8f]

s_lshl_b32 s5, s1, tba_hi
// CHECK: [0x01,0x6d,0x05,0x8f]

s_lshl_b32 s5, s1, tma_lo
// CHECK: [0x01,0x6e,0x05,0x8f]

s_lshl_b32 s5, s1, tma_hi
// CHECK: [0x01,0x6f,0x05,0x8f]

s_lshl_b32 s5, s1, ttmp11
// CHECK: [0x01,0x7b,0x05,0x8f]

s_lshl_b32 s5, s1, m0
// CHECK: [0x01,0x7c,0x05,0x8f]

s_lshl_b32 s5, s1, exec_lo
// CHECK: [0x01,0x7e,0x05,0x8f]

s_lshl_b32 s5, s1, exec_hi
// CHECK: [0x01,0x7f,0x05,0x8f]

s_lshl_b32 s5, s1, 0
// CHECK: [0x01,0x80,0x05,0x8f]

s_lshl_b32 s5, s1, -1
// CHECK: [0x01,0xc1,0x05,0x8f]

s_lshl_b32 s5, s1, 0.5
// CHECK: [0x01,0xf0,0x05,0x8f]

s_lshl_b32 s5, s1, -4.0
// CHECK: [0x01,0xf7,0x05,0x8f]

s_lshl_b32 s5, s1, 0xaf123456
// CHECK: [0x01,0xff,0x05,0x8f,0x56,0x34,0x12,0xaf]

s_lshl_b32 s5, s1, 0x3f717273
// CHECK: [0x01,0xff,0x05,0x8f,0x73,0x72,0x71,0x3f]

s_lshl_b64 s[10:11], s[2:3], s2
// CHECK: [0x02,0x02,0x8a,0x8f]

s_lshl_b64 s[12:13], s[2:3], s2
// CHECK: [0x02,0x02,0x8c,0x8f]

s_lshl_b64 s[102:103], s[2:3], s2
// CHECK: [0x02,0x02,0xe6,0x8f]

s_lshl_b64 flat_scratch, s[2:3], s2
// CHECK: [0x02,0x02,0xe8,0x8f]

s_lshl_b64 vcc, s[2:3], s2
// CHECK: [0x02,0x02,0xea,0x8f]

s_lshl_b64 tba, s[2:3], s2
// CHECK: [0x02,0x02,0xec,0x8f]

s_lshl_b64 tma, s[2:3], s2
// CHECK: [0x02,0x02,0xee,0x8f]

s_lshl_b64 ttmp[10:11], s[2:3], s2
// CHECK: [0x02,0x02,0xfa,0x8f]

s_lshl_b64 exec, s[2:3], s2
// CHECK: [0x02,0x02,0xfe,0x8f]

s_lshl_b64 s[10:11], s[4:5], s2
// CHECK: [0x04,0x02,0x8a,0x8f]

s_lshl_b64 s[10:11], s[102:103], s2
// CHECK: [0x66,0x02,0x8a,0x8f]

s_lshl_b64 s[10:11], flat_scratch, s2
// CHECK: [0x68,0x02,0x8a,0x8f]

s_lshl_b64 s[10:11], vcc, s2
// CHECK: [0x6a,0x02,0x8a,0x8f]

s_lshl_b64 s[10:11], tba, s2
// CHECK: [0x6c,0x02,0x8a,0x8f]

s_lshl_b64 s[10:11], tma, s2
// CHECK: [0x6e,0x02,0x8a,0x8f]

s_lshl_b64 s[10:11], ttmp[10:11], s2
// CHECK: [0x7a,0x02,0x8a,0x8f]

s_lshl_b64 s[10:11], exec, s2
// CHECK: [0x7e,0x02,0x8a,0x8f]

s_lshl_b64 s[10:11], 0, s2
// CHECK: [0x80,0x02,0x8a,0x8f]

s_lshl_b64 s[10:11], -1, s2
// CHECK: [0xc1,0x02,0x8a,0x8f]

s_lshl_b64 s[10:11], 0.5, s2
// CHECK: [0xf0,0x02,0x8a,0x8f]

s_lshl_b64 s[10:11], -4.0, s2
// CHECK: [0xf7,0x02,0x8a,0x8f]

s_lshl_b64 s[10:11], 0xaf123456, s2
// CHECK: [0xff,0x02,0x8a,0x8f,0x56,0x34,0x12,0xaf]

s_lshl_b64 s[10:11], 0x3f717273, s2
// CHECK: [0xff,0x02,0x8a,0x8f,0x73,0x72,0x71,0x3f]

s_lshl_b64 s[10:11], s[2:3], s103
// CHECK: [0x02,0x67,0x8a,0x8f]

s_lshl_b64 s[10:11], s[2:3], flat_scratch_lo
// CHECK: [0x02,0x68,0x8a,0x8f]

s_lshl_b64 s[10:11], s[2:3], flat_scratch_hi
// CHECK: [0x02,0x69,0x8a,0x8f]

s_lshl_b64 s[10:11], s[2:3], vcc_lo
// CHECK: [0x02,0x6a,0x8a,0x8f]

s_lshl_b64 s[10:11], s[2:3], vcc_hi
// CHECK: [0x02,0x6b,0x8a,0x8f]

s_lshl_b64 s[10:11], s[2:3], tba_lo
// CHECK: [0x02,0x6c,0x8a,0x8f]

s_lshl_b64 s[10:11], s[2:3], tba_hi
// CHECK: [0x02,0x6d,0x8a,0x8f]

s_lshl_b64 s[10:11], s[2:3], tma_lo
// CHECK: [0x02,0x6e,0x8a,0x8f]

s_lshl_b64 s[10:11], s[2:3], tma_hi
// CHECK: [0x02,0x6f,0x8a,0x8f]

s_lshl_b64 s[10:11], s[2:3], ttmp11
// CHECK: [0x02,0x7b,0x8a,0x8f]

s_lshl_b64 s[10:11], s[2:3], m0
// CHECK: [0x02,0x7c,0x8a,0x8f]

s_lshl_b64 s[10:11], s[2:3], exec_lo
// CHECK: [0x02,0x7e,0x8a,0x8f]

s_lshl_b64 s[10:11], s[2:3], exec_hi
// CHECK: [0x02,0x7f,0x8a,0x8f]

s_lshl_b64 s[10:11], s[2:3], 0
// CHECK: [0x02,0x80,0x8a,0x8f]

s_lshl_b64 s[10:11], s[2:3], -1
// CHECK: [0x02,0xc1,0x8a,0x8f]

s_lshl_b64 s[10:11], s[2:3], 0.5
// CHECK: [0x02,0xf0,0x8a,0x8f]

s_lshl_b64 s[10:11], s[2:3], -4.0
// CHECK: [0x02,0xf7,0x8a,0x8f]

s_lshl_b64 s[10:11], s[2:3], 0xaf123456
// CHECK: [0x02,0xff,0x8a,0x8f,0x56,0x34,0x12,0xaf]

s_lshl_b64 s[10:11], s[2:3], 0x3f717273
// CHECK: [0x02,0xff,0x8a,0x8f,0x73,0x72,0x71,0x3f]

s_lshr_b32 s5, s1, s2
// CHECK: [0x01,0x02,0x05,0x90]

s_lshr_b32 s103, s1, s2
// CHECK: [0x01,0x02,0x67,0x90]

s_lshr_b32 flat_scratch_lo, s1, s2
// CHECK: [0x01,0x02,0x68,0x90]

s_lshr_b32 flat_scratch_hi, s1, s2
// CHECK: [0x01,0x02,0x69,0x90]

s_lshr_b32 vcc_lo, s1, s2
// CHECK: [0x01,0x02,0x6a,0x90]

s_lshr_b32 vcc_hi, s1, s2
// CHECK: [0x01,0x02,0x6b,0x90]

s_lshr_b32 tba_lo, s1, s2
// CHECK: [0x01,0x02,0x6c,0x90]

s_lshr_b32 tba_hi, s1, s2
// CHECK: [0x01,0x02,0x6d,0x90]

s_lshr_b32 tma_lo, s1, s2
// CHECK: [0x01,0x02,0x6e,0x90]

s_lshr_b32 tma_hi, s1, s2
// CHECK: [0x01,0x02,0x6f,0x90]

s_lshr_b32 ttmp11, s1, s2
// CHECK: [0x01,0x02,0x7b,0x90]

s_lshr_b32 m0, s1, s2
// CHECK: [0x01,0x02,0x7c,0x90]

s_lshr_b32 exec_lo, s1, s2
// CHECK: [0x01,0x02,0x7e,0x90]

s_lshr_b32 exec_hi, s1, s2
// CHECK: [0x01,0x02,0x7f,0x90]

s_lshr_b32 s5, s103, s2
// CHECK: [0x67,0x02,0x05,0x90]

s_lshr_b32 s5, flat_scratch_lo, s2
// CHECK: [0x68,0x02,0x05,0x90]

s_lshr_b32 s5, flat_scratch_hi, s2
// CHECK: [0x69,0x02,0x05,0x90]

s_lshr_b32 s5, vcc_lo, s2
// CHECK: [0x6a,0x02,0x05,0x90]

s_lshr_b32 s5, vcc_hi, s2
// CHECK: [0x6b,0x02,0x05,0x90]

s_lshr_b32 s5, tba_lo, s2
// CHECK: [0x6c,0x02,0x05,0x90]

s_lshr_b32 s5, tba_hi, s2
// CHECK: [0x6d,0x02,0x05,0x90]

s_lshr_b32 s5, tma_lo, s2
// CHECK: [0x6e,0x02,0x05,0x90]

s_lshr_b32 s5, tma_hi, s2
// CHECK: [0x6f,0x02,0x05,0x90]

s_lshr_b32 s5, ttmp11, s2
// CHECK: [0x7b,0x02,0x05,0x90]

s_lshr_b32 s5, m0, s2
// CHECK: [0x7c,0x02,0x05,0x90]

s_lshr_b32 s5, exec_lo, s2
// CHECK: [0x7e,0x02,0x05,0x90]

s_lshr_b32 s5, exec_hi, s2
// CHECK: [0x7f,0x02,0x05,0x90]

s_lshr_b32 s5, 0, s2
// CHECK: [0x80,0x02,0x05,0x90]

s_lshr_b32 s5, -1, s2
// CHECK: [0xc1,0x02,0x05,0x90]

s_lshr_b32 s5, 0.5, s2
// CHECK: [0xf0,0x02,0x05,0x90]

s_lshr_b32 s5, -4.0, s2
// CHECK: [0xf7,0x02,0x05,0x90]

s_lshr_b32 s5, 0xaf123456, s2
// CHECK: [0xff,0x02,0x05,0x90,0x56,0x34,0x12,0xaf]

s_lshr_b32 s5, 0x3f717273, s2
// CHECK: [0xff,0x02,0x05,0x90,0x73,0x72,0x71,0x3f]

s_lshr_b32 s5, s1, s103
// CHECK: [0x01,0x67,0x05,0x90]

s_lshr_b32 s5, s1, flat_scratch_lo
// CHECK: [0x01,0x68,0x05,0x90]

s_lshr_b32 s5, s1, flat_scratch_hi
// CHECK: [0x01,0x69,0x05,0x90]

s_lshr_b32 s5, s1, vcc_lo
// CHECK: [0x01,0x6a,0x05,0x90]

s_lshr_b32 s5, s1, vcc_hi
// CHECK: [0x01,0x6b,0x05,0x90]

s_lshr_b32 s5, s1, tba_lo
// CHECK: [0x01,0x6c,0x05,0x90]

s_lshr_b32 s5, s1, tba_hi
// CHECK: [0x01,0x6d,0x05,0x90]

s_lshr_b32 s5, s1, tma_lo
// CHECK: [0x01,0x6e,0x05,0x90]

s_lshr_b32 s5, s1, tma_hi
// CHECK: [0x01,0x6f,0x05,0x90]

s_lshr_b32 s5, s1, ttmp11
// CHECK: [0x01,0x7b,0x05,0x90]

s_lshr_b32 s5, s1, m0
// CHECK: [0x01,0x7c,0x05,0x90]

s_lshr_b32 s5, s1, exec_lo
// CHECK: [0x01,0x7e,0x05,0x90]

s_lshr_b32 s5, s1, exec_hi
// CHECK: [0x01,0x7f,0x05,0x90]

s_lshr_b32 s5, s1, 0
// CHECK: [0x01,0x80,0x05,0x90]

s_lshr_b32 s5, s1, -1
// CHECK: [0x01,0xc1,0x05,0x90]

s_lshr_b32 s5, s1, 0.5
// CHECK: [0x01,0xf0,0x05,0x90]

s_lshr_b32 s5, s1, -4.0
// CHECK: [0x01,0xf7,0x05,0x90]

s_lshr_b32 s5, s1, 0xaf123456
// CHECK: [0x01,0xff,0x05,0x90,0x56,0x34,0x12,0xaf]

s_lshr_b32 s5, s1, 0x3f717273
// CHECK: [0x01,0xff,0x05,0x90,0x73,0x72,0x71,0x3f]

s_lshr_b64 s[10:11], s[2:3], s2
// CHECK: [0x02,0x02,0x8a,0x90]

s_lshr_b64 s[12:13], s[2:3], s2
// CHECK: [0x02,0x02,0x8c,0x90]

s_lshr_b64 s[102:103], s[2:3], s2
// CHECK: [0x02,0x02,0xe6,0x90]

s_lshr_b64 flat_scratch, s[2:3], s2
// CHECK: [0x02,0x02,0xe8,0x90]

s_lshr_b64 vcc, s[2:3], s2
// CHECK: [0x02,0x02,0xea,0x90]

s_lshr_b64 tba, s[2:3], s2
// CHECK: [0x02,0x02,0xec,0x90]

s_lshr_b64 tma, s[2:3], s2
// CHECK: [0x02,0x02,0xee,0x90]

s_lshr_b64 ttmp[10:11], s[2:3], s2
// CHECK: [0x02,0x02,0xfa,0x90]

s_lshr_b64 exec, s[2:3], s2
// CHECK: [0x02,0x02,0xfe,0x90]

s_lshr_b64 s[10:11], s[4:5], s2
// CHECK: [0x04,0x02,0x8a,0x90]

s_lshr_b64 s[10:11], s[102:103], s2
// CHECK: [0x66,0x02,0x8a,0x90]

s_lshr_b64 s[10:11], flat_scratch, s2
// CHECK: [0x68,0x02,0x8a,0x90]

s_lshr_b64 s[10:11], vcc, s2
// CHECK: [0x6a,0x02,0x8a,0x90]

s_lshr_b64 s[10:11], tba, s2
// CHECK: [0x6c,0x02,0x8a,0x90]

s_lshr_b64 s[10:11], tma, s2
// CHECK: [0x6e,0x02,0x8a,0x90]

s_lshr_b64 s[10:11], ttmp[10:11], s2
// CHECK: [0x7a,0x02,0x8a,0x90]

s_lshr_b64 s[10:11], exec, s2
// CHECK: [0x7e,0x02,0x8a,0x90]

s_lshr_b64 s[10:11], 0, s2
// CHECK: [0x80,0x02,0x8a,0x90]

s_lshr_b64 s[10:11], -1, s2
// CHECK: [0xc1,0x02,0x8a,0x90]

s_lshr_b64 s[10:11], 0.5, s2
// CHECK: [0xf0,0x02,0x8a,0x90]

s_lshr_b64 s[10:11], -4.0, s2
// CHECK: [0xf7,0x02,0x8a,0x90]

s_lshr_b64 s[10:11], 0xaf123456, s2
// CHECK: [0xff,0x02,0x8a,0x90,0x56,0x34,0x12,0xaf]

s_lshr_b64 s[10:11], 0x3f717273, s2
// CHECK: [0xff,0x02,0x8a,0x90,0x73,0x72,0x71,0x3f]

s_lshr_b64 s[10:11], s[2:3], s103
// CHECK: [0x02,0x67,0x8a,0x90]

s_lshr_b64 s[10:11], s[2:3], flat_scratch_lo
// CHECK: [0x02,0x68,0x8a,0x90]

s_lshr_b64 s[10:11], s[2:3], flat_scratch_hi
// CHECK: [0x02,0x69,0x8a,0x90]

s_lshr_b64 s[10:11], s[2:3], vcc_lo
// CHECK: [0x02,0x6a,0x8a,0x90]

s_lshr_b64 s[10:11], s[2:3], vcc_hi
// CHECK: [0x02,0x6b,0x8a,0x90]

s_lshr_b64 s[10:11], s[2:3], tba_lo
// CHECK: [0x02,0x6c,0x8a,0x90]

s_lshr_b64 s[10:11], s[2:3], tba_hi
// CHECK: [0x02,0x6d,0x8a,0x90]

s_lshr_b64 s[10:11], s[2:3], tma_lo
// CHECK: [0x02,0x6e,0x8a,0x90]

s_lshr_b64 s[10:11], s[2:3], tma_hi
// CHECK: [0x02,0x6f,0x8a,0x90]

s_lshr_b64 s[10:11], s[2:3], ttmp11
// CHECK: [0x02,0x7b,0x8a,0x90]

s_lshr_b64 s[10:11], s[2:3], m0
// CHECK: [0x02,0x7c,0x8a,0x90]

s_lshr_b64 s[10:11], s[2:3], exec_lo
// CHECK: [0x02,0x7e,0x8a,0x90]

s_lshr_b64 s[10:11], s[2:3], exec_hi
// CHECK: [0x02,0x7f,0x8a,0x90]

s_lshr_b64 s[10:11], s[2:3], 0
// CHECK: [0x02,0x80,0x8a,0x90]

s_lshr_b64 s[10:11], s[2:3], -1
// CHECK: [0x02,0xc1,0x8a,0x90]

s_lshr_b64 s[10:11], s[2:3], 0.5
// CHECK: [0x02,0xf0,0x8a,0x90]

s_lshr_b64 s[10:11], s[2:3], -4.0
// CHECK: [0x02,0xf7,0x8a,0x90]

s_lshr_b64 s[10:11], s[2:3], 0xaf123456
// CHECK: [0x02,0xff,0x8a,0x90,0x56,0x34,0x12,0xaf]

s_lshr_b64 s[10:11], s[2:3], 0x3f717273
// CHECK: [0x02,0xff,0x8a,0x90,0x73,0x72,0x71,0x3f]

s_ashr_i32 s5, s1, s2
// CHECK: [0x01,0x02,0x05,0x91]

s_ashr_i32 s103, s1, s2
// CHECK: [0x01,0x02,0x67,0x91]

s_ashr_i32 flat_scratch_lo, s1, s2
// CHECK: [0x01,0x02,0x68,0x91]

s_ashr_i32 flat_scratch_hi, s1, s2
// CHECK: [0x01,0x02,0x69,0x91]

s_ashr_i32 vcc_lo, s1, s2
// CHECK: [0x01,0x02,0x6a,0x91]

s_ashr_i32 vcc_hi, s1, s2
// CHECK: [0x01,0x02,0x6b,0x91]

s_ashr_i32 tba_lo, s1, s2
// CHECK: [0x01,0x02,0x6c,0x91]

s_ashr_i32 tba_hi, s1, s2
// CHECK: [0x01,0x02,0x6d,0x91]

s_ashr_i32 tma_lo, s1, s2
// CHECK: [0x01,0x02,0x6e,0x91]

s_ashr_i32 tma_hi, s1, s2
// CHECK: [0x01,0x02,0x6f,0x91]

s_ashr_i32 ttmp11, s1, s2
// CHECK: [0x01,0x02,0x7b,0x91]

s_ashr_i32 m0, s1, s2
// CHECK: [0x01,0x02,0x7c,0x91]

s_ashr_i32 exec_lo, s1, s2
// CHECK: [0x01,0x02,0x7e,0x91]

s_ashr_i32 exec_hi, s1, s2
// CHECK: [0x01,0x02,0x7f,0x91]

s_ashr_i32 s5, s103, s2
// CHECK: [0x67,0x02,0x05,0x91]

s_ashr_i32 s5, flat_scratch_lo, s2
// CHECK: [0x68,0x02,0x05,0x91]

s_ashr_i32 s5, flat_scratch_hi, s2
// CHECK: [0x69,0x02,0x05,0x91]

s_ashr_i32 s5, vcc_lo, s2
// CHECK: [0x6a,0x02,0x05,0x91]

s_ashr_i32 s5, vcc_hi, s2
// CHECK: [0x6b,0x02,0x05,0x91]

s_ashr_i32 s5, tba_lo, s2
// CHECK: [0x6c,0x02,0x05,0x91]

s_ashr_i32 s5, tba_hi, s2
// CHECK: [0x6d,0x02,0x05,0x91]

s_ashr_i32 s5, tma_lo, s2
// CHECK: [0x6e,0x02,0x05,0x91]

s_ashr_i32 s5, tma_hi, s2
// CHECK: [0x6f,0x02,0x05,0x91]

s_ashr_i32 s5, ttmp11, s2
// CHECK: [0x7b,0x02,0x05,0x91]

s_ashr_i32 s5, m0, s2
// CHECK: [0x7c,0x02,0x05,0x91]

s_ashr_i32 s5, exec_lo, s2
// CHECK: [0x7e,0x02,0x05,0x91]

s_ashr_i32 s5, exec_hi, s2
// CHECK: [0x7f,0x02,0x05,0x91]

s_ashr_i32 s5, 0, s2
// CHECK: [0x80,0x02,0x05,0x91]

s_ashr_i32 s5, -1, s2
// CHECK: [0xc1,0x02,0x05,0x91]

s_ashr_i32 s5, 0.5, s2
// CHECK: [0xf0,0x02,0x05,0x91]

s_ashr_i32 s5, -4.0, s2
// CHECK: [0xf7,0x02,0x05,0x91]

s_ashr_i32 s5, 0xaf123456, s2
// CHECK: [0xff,0x02,0x05,0x91,0x56,0x34,0x12,0xaf]

s_ashr_i32 s5, 0x3f717273, s2
// CHECK: [0xff,0x02,0x05,0x91,0x73,0x72,0x71,0x3f]

s_ashr_i32 s5, s1, s103
// CHECK: [0x01,0x67,0x05,0x91]

s_ashr_i32 s5, s1, flat_scratch_lo
// CHECK: [0x01,0x68,0x05,0x91]

s_ashr_i32 s5, s1, flat_scratch_hi
// CHECK: [0x01,0x69,0x05,0x91]

s_ashr_i32 s5, s1, vcc_lo
// CHECK: [0x01,0x6a,0x05,0x91]

s_ashr_i32 s5, s1, vcc_hi
// CHECK: [0x01,0x6b,0x05,0x91]

s_ashr_i32 s5, s1, tba_lo
// CHECK: [0x01,0x6c,0x05,0x91]

s_ashr_i32 s5, s1, tba_hi
// CHECK: [0x01,0x6d,0x05,0x91]

s_ashr_i32 s5, s1, tma_lo
// CHECK: [0x01,0x6e,0x05,0x91]

s_ashr_i32 s5, s1, tma_hi
// CHECK: [0x01,0x6f,0x05,0x91]

s_ashr_i32 s5, s1, ttmp11
// CHECK: [0x01,0x7b,0x05,0x91]

s_ashr_i32 s5, s1, m0
// CHECK: [0x01,0x7c,0x05,0x91]

s_ashr_i32 s5, s1, exec_lo
// CHECK: [0x01,0x7e,0x05,0x91]

s_ashr_i32 s5, s1, exec_hi
// CHECK: [0x01,0x7f,0x05,0x91]

s_ashr_i32 s5, s1, 0
// CHECK: [0x01,0x80,0x05,0x91]

s_ashr_i32 s5, s1, -1
// CHECK: [0x01,0xc1,0x05,0x91]

s_ashr_i32 s5, s1, 0.5
// CHECK: [0x01,0xf0,0x05,0x91]

s_ashr_i32 s5, s1, -4.0
// CHECK: [0x01,0xf7,0x05,0x91]

s_ashr_i32 s5, s1, 0xaf123456
// CHECK: [0x01,0xff,0x05,0x91,0x56,0x34,0x12,0xaf]

s_ashr_i32 s5, s1, 0x3f717273
// CHECK: [0x01,0xff,0x05,0x91,0x73,0x72,0x71,0x3f]

s_ashr_i64 s[10:11], s[2:3], s2
// CHECK: [0x02,0x02,0x8a,0x91]

s_ashr_i64 s[12:13], s[2:3], s2
// CHECK: [0x02,0x02,0x8c,0x91]

s_ashr_i64 s[102:103], s[2:3], s2
// CHECK: [0x02,0x02,0xe6,0x91]

s_ashr_i64 flat_scratch, s[2:3], s2
// CHECK: [0x02,0x02,0xe8,0x91]

s_ashr_i64 vcc, s[2:3], s2
// CHECK: [0x02,0x02,0xea,0x91]

s_ashr_i64 tba, s[2:3], s2
// CHECK: [0x02,0x02,0xec,0x91]

s_ashr_i64 tma, s[2:3], s2
// CHECK: [0x02,0x02,0xee,0x91]

s_ashr_i64 ttmp[10:11], s[2:3], s2
// CHECK: [0x02,0x02,0xfa,0x91]

s_ashr_i64 exec, s[2:3], s2
// CHECK: [0x02,0x02,0xfe,0x91]

s_ashr_i64 s[10:11], s[4:5], s2
// CHECK: [0x04,0x02,0x8a,0x91]

s_ashr_i64 s[10:11], s[102:103], s2
// CHECK: [0x66,0x02,0x8a,0x91]

s_ashr_i64 s[10:11], flat_scratch, s2
// CHECK: [0x68,0x02,0x8a,0x91]

s_ashr_i64 s[10:11], vcc, s2
// CHECK: [0x6a,0x02,0x8a,0x91]

s_ashr_i64 s[10:11], tba, s2
// CHECK: [0x6c,0x02,0x8a,0x91]

s_ashr_i64 s[10:11], tma, s2
// CHECK: [0x6e,0x02,0x8a,0x91]

s_ashr_i64 s[10:11], ttmp[10:11], s2
// CHECK: [0x7a,0x02,0x8a,0x91]

s_ashr_i64 s[10:11], exec, s2
// CHECK: [0x7e,0x02,0x8a,0x91]

s_ashr_i64 s[10:11], 0, s2
// CHECK: [0x80,0x02,0x8a,0x91]

s_ashr_i64 s[10:11], -1, s2
// CHECK: [0xc1,0x02,0x8a,0x91]

s_ashr_i64 s[10:11], 0.5, s2
// CHECK: [0xf0,0x02,0x8a,0x91]

s_ashr_i64 s[10:11], -4.0, s2
// CHECK: [0xf7,0x02,0x8a,0x91]

s_ashr_i64 s[10:11], 0xaf123456, s2
// CHECK: [0xff,0x02,0x8a,0x91,0x56,0x34,0x12,0xaf]

s_ashr_i64 s[10:11], 0x3f717273, s2
// CHECK: [0xff,0x02,0x8a,0x91,0x73,0x72,0x71,0x3f]

s_ashr_i64 s[10:11], s[2:3], s103
// CHECK: [0x02,0x67,0x8a,0x91]

s_ashr_i64 s[10:11], s[2:3], flat_scratch_lo
// CHECK: [0x02,0x68,0x8a,0x91]

s_ashr_i64 s[10:11], s[2:3], flat_scratch_hi
// CHECK: [0x02,0x69,0x8a,0x91]

s_ashr_i64 s[10:11], s[2:3], vcc_lo
// CHECK: [0x02,0x6a,0x8a,0x91]

s_ashr_i64 s[10:11], s[2:3], vcc_hi
// CHECK: [0x02,0x6b,0x8a,0x91]

s_ashr_i64 s[10:11], s[2:3], tba_lo
// CHECK: [0x02,0x6c,0x8a,0x91]

s_ashr_i64 s[10:11], s[2:3], tba_hi
// CHECK: [0x02,0x6d,0x8a,0x91]

s_ashr_i64 s[10:11], s[2:3], tma_lo
// CHECK: [0x02,0x6e,0x8a,0x91]

s_ashr_i64 s[10:11], s[2:3], tma_hi
// CHECK: [0x02,0x6f,0x8a,0x91]

s_ashr_i64 s[10:11], s[2:3], ttmp11
// CHECK: [0x02,0x7b,0x8a,0x91]

s_ashr_i64 s[10:11], s[2:3], m0
// CHECK: [0x02,0x7c,0x8a,0x91]

s_ashr_i64 s[10:11], s[2:3], exec_lo
// CHECK: [0x02,0x7e,0x8a,0x91]

s_ashr_i64 s[10:11], s[2:3], exec_hi
// CHECK: [0x02,0x7f,0x8a,0x91]

s_ashr_i64 s[10:11], s[2:3], 0
// CHECK: [0x02,0x80,0x8a,0x91]

s_ashr_i64 s[10:11], s[2:3], -1
// CHECK: [0x02,0xc1,0x8a,0x91]

s_ashr_i64 s[10:11], s[2:3], 0.5
// CHECK: [0x02,0xf0,0x8a,0x91]

s_ashr_i64 s[10:11], s[2:3], -4.0
// CHECK: [0x02,0xf7,0x8a,0x91]

s_ashr_i64 s[10:11], s[2:3], 0xaf123456
// CHECK: [0x02,0xff,0x8a,0x91,0x56,0x34,0x12,0xaf]

s_ashr_i64 s[10:11], s[2:3], 0x3f717273
// CHECK: [0x02,0xff,0x8a,0x91,0x73,0x72,0x71,0x3f]

s_bfm_b32 s5, s1, s2
// CHECK: [0x01,0x02,0x05,0x92]

s_bfm_b32 s103, s1, s2
// CHECK: [0x01,0x02,0x67,0x92]

s_bfm_b32 flat_scratch_lo, s1, s2
// CHECK: [0x01,0x02,0x68,0x92]

s_bfm_b32 flat_scratch_hi, s1, s2
// CHECK: [0x01,0x02,0x69,0x92]

s_bfm_b32 vcc_lo, s1, s2
// CHECK: [0x01,0x02,0x6a,0x92]

s_bfm_b32 vcc_hi, s1, s2
// CHECK: [0x01,0x02,0x6b,0x92]

s_bfm_b32 tba_lo, s1, s2
// CHECK: [0x01,0x02,0x6c,0x92]

s_bfm_b32 tba_hi, s1, s2
// CHECK: [0x01,0x02,0x6d,0x92]

s_bfm_b32 tma_lo, s1, s2
// CHECK: [0x01,0x02,0x6e,0x92]

s_bfm_b32 tma_hi, s1, s2
// CHECK: [0x01,0x02,0x6f,0x92]

s_bfm_b32 ttmp11, s1, s2
// CHECK: [0x01,0x02,0x7b,0x92]

s_bfm_b32 m0, s1, s2
// CHECK: [0x01,0x02,0x7c,0x92]

s_bfm_b32 exec_lo, s1, s2
// CHECK: [0x01,0x02,0x7e,0x92]

s_bfm_b32 exec_hi, s1, s2
// CHECK: [0x01,0x02,0x7f,0x92]

s_bfm_b32 s5, s103, s2
// CHECK: [0x67,0x02,0x05,0x92]

s_bfm_b32 s5, flat_scratch_lo, s2
// CHECK: [0x68,0x02,0x05,0x92]

s_bfm_b32 s5, flat_scratch_hi, s2
// CHECK: [0x69,0x02,0x05,0x92]

s_bfm_b32 s5, vcc_lo, s2
// CHECK: [0x6a,0x02,0x05,0x92]

s_bfm_b32 s5, vcc_hi, s2
// CHECK: [0x6b,0x02,0x05,0x92]

s_bfm_b32 s5, tba_lo, s2
// CHECK: [0x6c,0x02,0x05,0x92]

s_bfm_b32 s5, tba_hi, s2
// CHECK: [0x6d,0x02,0x05,0x92]

s_bfm_b32 s5, tma_lo, s2
// CHECK: [0x6e,0x02,0x05,0x92]

s_bfm_b32 s5, tma_hi, s2
// CHECK: [0x6f,0x02,0x05,0x92]

s_bfm_b32 s5, ttmp11, s2
// CHECK: [0x7b,0x02,0x05,0x92]

s_bfm_b32 s5, m0, s2
// CHECK: [0x7c,0x02,0x05,0x92]

s_bfm_b32 s5, exec_lo, s2
// CHECK: [0x7e,0x02,0x05,0x92]

s_bfm_b32 s5, exec_hi, s2
// CHECK: [0x7f,0x02,0x05,0x92]

s_bfm_b32 s5, 0, s2
// CHECK: [0x80,0x02,0x05,0x92]

s_bfm_b32 s5, -1, s2
// CHECK: [0xc1,0x02,0x05,0x92]

s_bfm_b32 s5, 0.5, s2
// CHECK: [0xf0,0x02,0x05,0x92]

s_bfm_b32 s5, -4.0, s2
// CHECK: [0xf7,0x02,0x05,0x92]

s_bfm_b32 s5, 0xaf123456, s2
// CHECK: [0xff,0x02,0x05,0x92,0x56,0x34,0x12,0xaf]

s_bfm_b32 s5, 0x3f717273, s2
// CHECK: [0xff,0x02,0x05,0x92,0x73,0x72,0x71,0x3f]

s_bfm_b32 s5, s1, s103
// CHECK: [0x01,0x67,0x05,0x92]

s_bfm_b32 s5, s1, flat_scratch_lo
// CHECK: [0x01,0x68,0x05,0x92]

s_bfm_b32 s5, s1, flat_scratch_hi
// CHECK: [0x01,0x69,0x05,0x92]

s_bfm_b32 s5, s1, vcc_lo
// CHECK: [0x01,0x6a,0x05,0x92]

s_bfm_b32 s5, s1, vcc_hi
// CHECK: [0x01,0x6b,0x05,0x92]

s_bfm_b32 s5, s1, tba_lo
// CHECK: [0x01,0x6c,0x05,0x92]

s_bfm_b32 s5, s1, tba_hi
// CHECK: [0x01,0x6d,0x05,0x92]

s_bfm_b32 s5, s1, tma_lo
// CHECK: [0x01,0x6e,0x05,0x92]

s_bfm_b32 s5, s1, tma_hi
// CHECK: [0x01,0x6f,0x05,0x92]

s_bfm_b32 s5, s1, ttmp11
// CHECK: [0x01,0x7b,0x05,0x92]

s_bfm_b32 s5, s1, m0
// CHECK: [0x01,0x7c,0x05,0x92]

s_bfm_b32 s5, s1, exec_lo
// CHECK: [0x01,0x7e,0x05,0x92]

s_bfm_b32 s5, s1, exec_hi
// CHECK: [0x01,0x7f,0x05,0x92]

s_bfm_b32 s5, s1, 0
// CHECK: [0x01,0x80,0x05,0x92]

s_bfm_b32 s5, s1, -1
// CHECK: [0x01,0xc1,0x05,0x92]

s_bfm_b32 s5, s1, 0.5
// CHECK: [0x01,0xf0,0x05,0x92]

s_bfm_b32 s5, s1, -4.0
// CHECK: [0x01,0xf7,0x05,0x92]

s_bfm_b32 s5, s1, 0xaf123456
// CHECK: [0x01,0xff,0x05,0x92,0x56,0x34,0x12,0xaf]

s_bfm_b32 s5, s1, 0x3f717273
// CHECK: [0x01,0xff,0x05,0x92,0x73,0x72,0x71,0x3f]

s_bfm_b64 s[10:11], s1, s2
// CHECK: [0x01,0x02,0x8a,0x92]

s_bfm_b64 s[12:13], s1, s2
// CHECK: [0x01,0x02,0x8c,0x92]

s_bfm_b64 s[102:103], s1, s2
// CHECK: [0x01,0x02,0xe6,0x92]

s_bfm_b64 flat_scratch, s1, s2
// CHECK: [0x01,0x02,0xe8,0x92]

s_bfm_b64 vcc, s1, s2
// CHECK: [0x01,0x02,0xea,0x92]

s_bfm_b64 tba, s1, s2
// CHECK: [0x01,0x02,0xec,0x92]

s_bfm_b64 tma, s1, s2
// CHECK: [0x01,0x02,0xee,0x92]

s_bfm_b64 ttmp[10:11], s1, s2
// CHECK: [0x01,0x02,0xfa,0x92]

s_bfm_b64 exec, s1, s2
// CHECK: [0x01,0x02,0xfe,0x92]

s_bfm_b64 s[10:11], s103, s2
// CHECK: [0x67,0x02,0x8a,0x92]

s_bfm_b64 s[10:11], flat_scratch_lo, s2
// CHECK: [0x68,0x02,0x8a,0x92]

s_bfm_b64 s[10:11], flat_scratch_hi, s2
// CHECK: [0x69,0x02,0x8a,0x92]

s_bfm_b64 s[10:11], vcc_lo, s2
// CHECK: [0x6a,0x02,0x8a,0x92]

s_bfm_b64 s[10:11], vcc_hi, s2
// CHECK: [0x6b,0x02,0x8a,0x92]

s_bfm_b64 s[10:11], tba_lo, s2
// CHECK: [0x6c,0x02,0x8a,0x92]

s_bfm_b64 s[10:11], tba_hi, s2
// CHECK: [0x6d,0x02,0x8a,0x92]

s_bfm_b64 s[10:11], tma_lo, s2
// CHECK: [0x6e,0x02,0x8a,0x92]

s_bfm_b64 s[10:11], tma_hi, s2
// CHECK: [0x6f,0x02,0x8a,0x92]

s_bfm_b64 s[10:11], ttmp11, s2
// CHECK: [0x7b,0x02,0x8a,0x92]

s_bfm_b64 s[10:11], m0, s2
// CHECK: [0x7c,0x02,0x8a,0x92]

s_bfm_b64 s[10:11], exec_lo, s2
// CHECK: [0x7e,0x02,0x8a,0x92]

s_bfm_b64 s[10:11], exec_hi, s2
// CHECK: [0x7f,0x02,0x8a,0x92]

s_bfm_b64 s[10:11], 0, s2
// CHECK: [0x80,0x02,0x8a,0x92]

s_bfm_b64 s[10:11], -1, s2
// CHECK: [0xc1,0x02,0x8a,0x92]

s_bfm_b64 s[10:11], 0.5, s2
// CHECK: [0xf0,0x02,0x8a,0x92]

s_bfm_b64 s[10:11], -4.0, s2
// CHECK: [0xf7,0x02,0x8a,0x92]

s_bfm_b64 s[10:11], 0xaf123456, s2
// CHECK: [0xff,0x02,0x8a,0x92,0x56,0x34,0x12,0xaf]

s_bfm_b64 s[10:11], 0x3f717273, s2
// CHECK: [0xff,0x02,0x8a,0x92,0x73,0x72,0x71,0x3f]

s_bfm_b64 s[10:11], s1, s103
// CHECK: [0x01,0x67,0x8a,0x92]

s_bfm_b64 s[10:11], s1, flat_scratch_lo
// CHECK: [0x01,0x68,0x8a,0x92]

s_bfm_b64 s[10:11], s1, flat_scratch_hi
// CHECK: [0x01,0x69,0x8a,0x92]

s_bfm_b64 s[10:11], s1, vcc_lo
// CHECK: [0x01,0x6a,0x8a,0x92]

s_bfm_b64 s[10:11], s1, vcc_hi
// CHECK: [0x01,0x6b,0x8a,0x92]

s_bfm_b64 s[10:11], s1, tba_lo
// CHECK: [0x01,0x6c,0x8a,0x92]

s_bfm_b64 s[10:11], s1, tba_hi
// CHECK: [0x01,0x6d,0x8a,0x92]

s_bfm_b64 s[10:11], s1, tma_lo
// CHECK: [0x01,0x6e,0x8a,0x92]

s_bfm_b64 s[10:11], s1, tma_hi
// CHECK: [0x01,0x6f,0x8a,0x92]

s_bfm_b64 s[10:11], s1, ttmp11
// CHECK: [0x01,0x7b,0x8a,0x92]

s_bfm_b64 s[10:11], s1, m0
// CHECK: [0x01,0x7c,0x8a,0x92]

s_bfm_b64 s[10:11], s1, exec_lo
// CHECK: [0x01,0x7e,0x8a,0x92]

s_bfm_b64 s[10:11], s1, exec_hi
// CHECK: [0x01,0x7f,0x8a,0x92]

s_bfm_b64 s[10:11], s1, 0
// CHECK: [0x01,0x80,0x8a,0x92]

s_bfm_b64 s[10:11], s1, -1
// CHECK: [0x01,0xc1,0x8a,0x92]

s_bfm_b64 s[10:11], s1, 0.5
// CHECK: [0x01,0xf0,0x8a,0x92]

s_bfm_b64 s[10:11], s1, -4.0
// CHECK: [0x01,0xf7,0x8a,0x92]

s_bfm_b64 s[10:11], s1, 0xaf123456
// CHECK: [0x01,0xff,0x8a,0x92,0x56,0x34,0x12,0xaf]

s_bfm_b64 s[10:11], s1, 0x3f717273
// CHECK: [0x01,0xff,0x8a,0x92,0x73,0x72,0x71,0x3f]

s_mul_i32 s5, s1, s2
// CHECK: [0x01,0x02,0x05,0x93]

s_mul_i32 s103, s1, s2
// CHECK: [0x01,0x02,0x67,0x93]

s_mul_i32 flat_scratch_lo, s1, s2
// CHECK: [0x01,0x02,0x68,0x93]

s_mul_i32 flat_scratch_hi, s1, s2
// CHECK: [0x01,0x02,0x69,0x93]

s_mul_i32 vcc_lo, s1, s2
// CHECK: [0x01,0x02,0x6a,0x93]

s_mul_i32 vcc_hi, s1, s2
// CHECK: [0x01,0x02,0x6b,0x93]

s_mul_i32 tba_lo, s1, s2
// CHECK: [0x01,0x02,0x6c,0x93]

s_mul_i32 tba_hi, s1, s2
// CHECK: [0x01,0x02,0x6d,0x93]

s_mul_i32 tma_lo, s1, s2
// CHECK: [0x01,0x02,0x6e,0x93]

s_mul_i32 tma_hi, s1, s2
// CHECK: [0x01,0x02,0x6f,0x93]

s_mul_i32 ttmp11, s1, s2
// CHECK: [0x01,0x02,0x7b,0x93]

s_mul_i32 m0, s1, s2
// CHECK: [0x01,0x02,0x7c,0x93]

s_mul_i32 exec_lo, s1, s2
// CHECK: [0x01,0x02,0x7e,0x93]

s_mul_i32 exec_hi, s1, s2
// CHECK: [0x01,0x02,0x7f,0x93]

s_mul_i32 s5, s103, s2
// CHECK: [0x67,0x02,0x05,0x93]

s_mul_i32 s5, flat_scratch_lo, s2
// CHECK: [0x68,0x02,0x05,0x93]

s_mul_i32 s5, flat_scratch_hi, s2
// CHECK: [0x69,0x02,0x05,0x93]

s_mul_i32 s5, vcc_lo, s2
// CHECK: [0x6a,0x02,0x05,0x93]

s_mul_i32 s5, vcc_hi, s2
// CHECK: [0x6b,0x02,0x05,0x93]

s_mul_i32 s5, tba_lo, s2
// CHECK: [0x6c,0x02,0x05,0x93]

s_mul_i32 s5, tba_hi, s2
// CHECK: [0x6d,0x02,0x05,0x93]

s_mul_i32 s5, tma_lo, s2
// CHECK: [0x6e,0x02,0x05,0x93]

s_mul_i32 s5, tma_hi, s2
// CHECK: [0x6f,0x02,0x05,0x93]

s_mul_i32 s5, ttmp11, s2
// CHECK: [0x7b,0x02,0x05,0x93]

s_mul_i32 s5, m0, s2
// CHECK: [0x7c,0x02,0x05,0x93]

s_mul_i32 s5, exec_lo, s2
// CHECK: [0x7e,0x02,0x05,0x93]

s_mul_i32 s5, exec_hi, s2
// CHECK: [0x7f,0x02,0x05,0x93]

s_mul_i32 s5, 0, s2
// CHECK: [0x80,0x02,0x05,0x93]

s_mul_i32 s5, -1, s2
// CHECK: [0xc1,0x02,0x05,0x93]

s_mul_i32 s5, 0.5, s2
// CHECK: [0xf0,0x02,0x05,0x93]

s_mul_i32 s5, -4.0, s2
// CHECK: [0xf7,0x02,0x05,0x93]

s_mul_i32 s5, 0xaf123456, s2
// CHECK: [0xff,0x02,0x05,0x93,0x56,0x34,0x12,0xaf]

s_mul_i32 s5, 0x3f717273, s2
// CHECK: [0xff,0x02,0x05,0x93,0x73,0x72,0x71,0x3f]

s_mul_i32 s5, s1, s103
// CHECK: [0x01,0x67,0x05,0x93]

s_mul_i32 s5, s1, flat_scratch_lo
// CHECK: [0x01,0x68,0x05,0x93]

s_mul_i32 s5, s1, flat_scratch_hi
// CHECK: [0x01,0x69,0x05,0x93]

s_mul_i32 s5, s1, vcc_lo
// CHECK: [0x01,0x6a,0x05,0x93]

s_mul_i32 s5, s1, vcc_hi
// CHECK: [0x01,0x6b,0x05,0x93]

s_mul_i32 s5, s1, tba_lo
// CHECK: [0x01,0x6c,0x05,0x93]

s_mul_i32 s5, s1, tba_hi
// CHECK: [0x01,0x6d,0x05,0x93]

s_mul_i32 s5, s1, tma_lo
// CHECK: [0x01,0x6e,0x05,0x93]

s_mul_i32 s5, s1, tma_hi
// CHECK: [0x01,0x6f,0x05,0x93]

s_mul_i32 s5, s1, ttmp11
// CHECK: [0x01,0x7b,0x05,0x93]

s_mul_i32 s5, s1, m0
// CHECK: [0x01,0x7c,0x05,0x93]

s_mul_i32 s5, s1, exec_lo
// CHECK: [0x01,0x7e,0x05,0x93]

s_mul_i32 s5, s1, exec_hi
// CHECK: [0x01,0x7f,0x05,0x93]

s_mul_i32 s5, s1, 0
// CHECK: [0x01,0x80,0x05,0x93]

s_mul_i32 s5, s1, -1
// CHECK: [0x01,0xc1,0x05,0x93]

s_mul_i32 s5, s1, 0.5
// CHECK: [0x01,0xf0,0x05,0x93]

s_mul_i32 s5, s1, -4.0
// CHECK: [0x01,0xf7,0x05,0x93]

s_mul_i32 s5, s1, 0xaf123456
// CHECK: [0x01,0xff,0x05,0x93,0x56,0x34,0x12,0xaf]

s_mul_i32 s5, s1, 0x3f717273
// CHECK: [0x01,0xff,0x05,0x93,0x73,0x72,0x71,0x3f]

s_bfe_u32 s5, s1, s2
// CHECK: [0x01,0x02,0x85,0x93]

s_bfe_u32 s103, s1, s2
// CHECK: [0x01,0x02,0xe7,0x93]

s_bfe_u32 flat_scratch_lo, s1, s2
// CHECK: [0x01,0x02,0xe8,0x93]

s_bfe_u32 flat_scratch_hi, s1, s2
// CHECK: [0x01,0x02,0xe9,0x93]

s_bfe_u32 vcc_lo, s1, s2
// CHECK: [0x01,0x02,0xea,0x93]

s_bfe_u32 vcc_hi, s1, s2
// CHECK: [0x01,0x02,0xeb,0x93]

s_bfe_u32 tba_lo, s1, s2
// CHECK: [0x01,0x02,0xec,0x93]

s_bfe_u32 tba_hi, s1, s2
// CHECK: [0x01,0x02,0xed,0x93]

s_bfe_u32 tma_lo, s1, s2
// CHECK: [0x01,0x02,0xee,0x93]

s_bfe_u32 tma_hi, s1, s2
// CHECK: [0x01,0x02,0xef,0x93]

s_bfe_u32 ttmp11, s1, s2
// CHECK: [0x01,0x02,0xfb,0x93]

s_bfe_u32 m0, s1, s2
// CHECK: [0x01,0x02,0xfc,0x93]

s_bfe_u32 exec_lo, s1, s2
// CHECK: [0x01,0x02,0xfe,0x93]

s_bfe_u32 exec_hi, s1, s2
// CHECK: [0x01,0x02,0xff,0x93]

s_bfe_u32 s5, s103, s2
// CHECK: [0x67,0x02,0x85,0x93]

s_bfe_u32 s5, flat_scratch_lo, s2
// CHECK: [0x68,0x02,0x85,0x93]

s_bfe_u32 s5, flat_scratch_hi, s2
// CHECK: [0x69,0x02,0x85,0x93]

s_bfe_u32 s5, vcc_lo, s2
// CHECK: [0x6a,0x02,0x85,0x93]

s_bfe_u32 s5, vcc_hi, s2
// CHECK: [0x6b,0x02,0x85,0x93]

s_bfe_u32 s5, tba_lo, s2
// CHECK: [0x6c,0x02,0x85,0x93]

s_bfe_u32 s5, tba_hi, s2
// CHECK: [0x6d,0x02,0x85,0x93]

s_bfe_u32 s5, tma_lo, s2
// CHECK: [0x6e,0x02,0x85,0x93]

s_bfe_u32 s5, tma_hi, s2
// CHECK: [0x6f,0x02,0x85,0x93]

s_bfe_u32 s5, ttmp11, s2
// CHECK: [0x7b,0x02,0x85,0x93]

s_bfe_u32 s5, m0, s2
// CHECK: [0x7c,0x02,0x85,0x93]

s_bfe_u32 s5, exec_lo, s2
// CHECK: [0x7e,0x02,0x85,0x93]

s_bfe_u32 s5, exec_hi, s2
// CHECK: [0x7f,0x02,0x85,0x93]

s_bfe_u32 s5, 0, s2
// CHECK: [0x80,0x02,0x85,0x93]

s_bfe_u32 s5, -1, s2
// CHECK: [0xc1,0x02,0x85,0x93]

s_bfe_u32 s5, 0.5, s2
// CHECK: [0xf0,0x02,0x85,0x93]

s_bfe_u32 s5, -4.0, s2
// CHECK: [0xf7,0x02,0x85,0x93]

s_bfe_u32 s5, 0xaf123456, s2
// CHECK: [0xff,0x02,0x85,0x93,0x56,0x34,0x12,0xaf]

s_bfe_u32 s5, 0x3f717273, s2
// CHECK: [0xff,0x02,0x85,0x93,0x73,0x72,0x71,0x3f]

s_bfe_u32 s5, s1, s103
// CHECK: [0x01,0x67,0x85,0x93]

s_bfe_u32 s5, s1, flat_scratch_lo
// CHECK: [0x01,0x68,0x85,0x93]

s_bfe_u32 s5, s1, flat_scratch_hi
// CHECK: [0x01,0x69,0x85,0x93]

s_bfe_u32 s5, s1, vcc_lo
// CHECK: [0x01,0x6a,0x85,0x93]

s_bfe_u32 s5, s1, vcc_hi
// CHECK: [0x01,0x6b,0x85,0x93]

s_bfe_u32 s5, s1, tba_lo
// CHECK: [0x01,0x6c,0x85,0x93]

s_bfe_u32 s5, s1, tba_hi
// CHECK: [0x01,0x6d,0x85,0x93]

s_bfe_u32 s5, s1, tma_lo
// CHECK: [0x01,0x6e,0x85,0x93]

s_bfe_u32 s5, s1, tma_hi
// CHECK: [0x01,0x6f,0x85,0x93]

s_bfe_u32 s5, s1, ttmp11
// CHECK: [0x01,0x7b,0x85,0x93]

s_bfe_u32 s5, s1, m0
// CHECK: [0x01,0x7c,0x85,0x93]

s_bfe_u32 s5, s1, exec_lo
// CHECK: [0x01,0x7e,0x85,0x93]

s_bfe_u32 s5, s1, exec_hi
// CHECK: [0x01,0x7f,0x85,0x93]

s_bfe_u32 s5, s1, 0
// CHECK: [0x01,0x80,0x85,0x93]

s_bfe_u32 s5, s1, -1
// CHECK: [0x01,0xc1,0x85,0x93]

s_bfe_u32 s5, s1, 0.5
// CHECK: [0x01,0xf0,0x85,0x93]

s_bfe_u32 s5, s1, -4.0
// CHECK: [0x01,0xf7,0x85,0x93]

s_bfe_u32 s5, s1, 0xaf123456
// CHECK: [0x01,0xff,0x85,0x93,0x56,0x34,0x12,0xaf]

s_bfe_u32 s5, s1, 0x3f717273
// CHECK: [0x01,0xff,0x85,0x93,0x73,0x72,0x71,0x3f]

s_bfe_i32 s5, s1, s2
// CHECK: [0x01,0x02,0x05,0x94]

s_bfe_i32 s103, s1, s2
// CHECK: [0x01,0x02,0x67,0x94]

s_bfe_i32 flat_scratch_lo, s1, s2
// CHECK: [0x01,0x02,0x68,0x94]

s_bfe_i32 flat_scratch_hi, s1, s2
// CHECK: [0x01,0x02,0x69,0x94]

s_bfe_i32 vcc_lo, s1, s2
// CHECK: [0x01,0x02,0x6a,0x94]

s_bfe_i32 vcc_hi, s1, s2
// CHECK: [0x01,0x02,0x6b,0x94]

s_bfe_i32 tba_lo, s1, s2
// CHECK: [0x01,0x02,0x6c,0x94]

s_bfe_i32 tba_hi, s1, s2
// CHECK: [0x01,0x02,0x6d,0x94]

s_bfe_i32 tma_lo, s1, s2
// CHECK: [0x01,0x02,0x6e,0x94]

s_bfe_i32 tma_hi, s1, s2
// CHECK: [0x01,0x02,0x6f,0x94]

s_bfe_i32 ttmp11, s1, s2
// CHECK: [0x01,0x02,0x7b,0x94]

s_bfe_i32 m0, s1, s2
// CHECK: [0x01,0x02,0x7c,0x94]

s_bfe_i32 exec_lo, s1, s2
// CHECK: [0x01,0x02,0x7e,0x94]

s_bfe_i32 exec_hi, s1, s2
// CHECK: [0x01,0x02,0x7f,0x94]

s_bfe_i32 s5, s103, s2
// CHECK: [0x67,0x02,0x05,0x94]

s_bfe_i32 s5, flat_scratch_lo, s2
// CHECK: [0x68,0x02,0x05,0x94]

s_bfe_i32 s5, flat_scratch_hi, s2
// CHECK: [0x69,0x02,0x05,0x94]

s_bfe_i32 s5, vcc_lo, s2
// CHECK: [0x6a,0x02,0x05,0x94]

s_bfe_i32 s5, vcc_hi, s2
// CHECK: [0x6b,0x02,0x05,0x94]

s_bfe_i32 s5, tba_lo, s2
// CHECK: [0x6c,0x02,0x05,0x94]

s_bfe_i32 s5, tba_hi, s2
// CHECK: [0x6d,0x02,0x05,0x94]

s_bfe_i32 s5, tma_lo, s2
// CHECK: [0x6e,0x02,0x05,0x94]

s_bfe_i32 s5, tma_hi, s2
// CHECK: [0x6f,0x02,0x05,0x94]

s_bfe_i32 s5, ttmp11, s2
// CHECK: [0x7b,0x02,0x05,0x94]

s_bfe_i32 s5, m0, s2
// CHECK: [0x7c,0x02,0x05,0x94]

s_bfe_i32 s5, exec_lo, s2
// CHECK: [0x7e,0x02,0x05,0x94]

s_bfe_i32 s5, exec_hi, s2
// CHECK: [0x7f,0x02,0x05,0x94]

s_bfe_i32 s5, 0, s2
// CHECK: [0x80,0x02,0x05,0x94]

s_bfe_i32 s5, -1, s2
// CHECK: [0xc1,0x02,0x05,0x94]

s_bfe_i32 s5, 0.5, s2
// CHECK: [0xf0,0x02,0x05,0x94]

s_bfe_i32 s5, -4.0, s2
// CHECK: [0xf7,0x02,0x05,0x94]

s_bfe_i32 s5, 0xaf123456, s2
// CHECK: [0xff,0x02,0x05,0x94,0x56,0x34,0x12,0xaf]

s_bfe_i32 s5, 0x3f717273, s2
// CHECK: [0xff,0x02,0x05,0x94,0x73,0x72,0x71,0x3f]

s_bfe_i32 s5, s1, s103
// CHECK: [0x01,0x67,0x05,0x94]

s_bfe_i32 s5, s1, flat_scratch_lo
// CHECK: [0x01,0x68,0x05,0x94]

s_bfe_i32 s5, s1, flat_scratch_hi
// CHECK: [0x01,0x69,0x05,0x94]

s_bfe_i32 s5, s1, vcc_lo
// CHECK: [0x01,0x6a,0x05,0x94]

s_bfe_i32 s5, s1, vcc_hi
// CHECK: [0x01,0x6b,0x05,0x94]

s_bfe_i32 s5, s1, tba_lo
// CHECK: [0x01,0x6c,0x05,0x94]

s_bfe_i32 s5, s1, tba_hi
// CHECK: [0x01,0x6d,0x05,0x94]

s_bfe_i32 s5, s1, tma_lo
// CHECK: [0x01,0x6e,0x05,0x94]

s_bfe_i32 s5, s1, tma_hi
// CHECK: [0x01,0x6f,0x05,0x94]

s_bfe_i32 s5, s1, ttmp11
// CHECK: [0x01,0x7b,0x05,0x94]

s_bfe_i32 s5, s1, m0
// CHECK: [0x01,0x7c,0x05,0x94]

s_bfe_i32 s5, s1, exec_lo
// CHECK: [0x01,0x7e,0x05,0x94]

s_bfe_i32 s5, s1, exec_hi
// CHECK: [0x01,0x7f,0x05,0x94]

s_bfe_i32 s5, s1, 0
// CHECK: [0x01,0x80,0x05,0x94]

s_bfe_i32 s5, s1, -1
// CHECK: [0x01,0xc1,0x05,0x94]

s_bfe_i32 s5, s1, 0.5
// CHECK: [0x01,0xf0,0x05,0x94]

s_bfe_i32 s5, s1, -4.0
// CHECK: [0x01,0xf7,0x05,0x94]

s_bfe_i32 s5, s1, 0xaf123456
// CHECK: [0x01,0xff,0x05,0x94,0x56,0x34,0x12,0xaf]

s_bfe_i32 s5, s1, 0x3f717273
// CHECK: [0x01,0xff,0x05,0x94,0x73,0x72,0x71,0x3f]

s_bfe_u64 s[10:11], s[2:3], s2
// CHECK: [0x02,0x02,0x8a,0x94]

s_bfe_u64 s[12:13], s[2:3], s2
// CHECK: [0x02,0x02,0x8c,0x94]

s_bfe_u64 s[102:103], s[2:3], s2
// CHECK: [0x02,0x02,0xe6,0x94]

s_bfe_u64 flat_scratch, s[2:3], s2
// CHECK: [0x02,0x02,0xe8,0x94]

s_bfe_u64 vcc, s[2:3], s2
// CHECK: [0x02,0x02,0xea,0x94]

s_bfe_u64 tba, s[2:3], s2
// CHECK: [0x02,0x02,0xec,0x94]

s_bfe_u64 tma, s[2:3], s2
// CHECK: [0x02,0x02,0xee,0x94]

s_bfe_u64 ttmp[10:11], s[2:3], s2
// CHECK: [0x02,0x02,0xfa,0x94]

s_bfe_u64 exec, s[2:3], s2
// CHECK: [0x02,0x02,0xfe,0x94]

s_bfe_u64 s[10:11], s[4:5], s2
// CHECK: [0x04,0x02,0x8a,0x94]

s_bfe_u64 s[10:11], s[102:103], s2
// CHECK: [0x66,0x02,0x8a,0x94]

s_bfe_u64 s[10:11], flat_scratch, s2
// CHECK: [0x68,0x02,0x8a,0x94]

s_bfe_u64 s[10:11], vcc, s2
// CHECK: [0x6a,0x02,0x8a,0x94]

s_bfe_u64 s[10:11], tba, s2
// CHECK: [0x6c,0x02,0x8a,0x94]

s_bfe_u64 s[10:11], tma, s2
// CHECK: [0x6e,0x02,0x8a,0x94]

s_bfe_u64 s[10:11], ttmp[10:11], s2
// CHECK: [0x7a,0x02,0x8a,0x94]

s_bfe_u64 s[10:11], exec, s2
// CHECK: [0x7e,0x02,0x8a,0x94]

s_bfe_u64 s[10:11], 0, s2
// CHECK: [0x80,0x02,0x8a,0x94]

s_bfe_u64 s[10:11], -1, s2
// CHECK: [0xc1,0x02,0x8a,0x94]

s_bfe_u64 s[10:11], 0.5, s2
// CHECK: [0xf0,0x02,0x8a,0x94]

s_bfe_u64 s[10:11], -4.0, s2
// CHECK: [0xf7,0x02,0x8a,0x94]

s_bfe_u64 s[10:11], 0xaf123456, s2
// CHECK: [0xff,0x02,0x8a,0x94,0x56,0x34,0x12,0xaf]

s_bfe_u64 s[10:11], 0x3f717273, s2
// CHECK: [0xff,0x02,0x8a,0x94,0x73,0x72,0x71,0x3f]

s_bfe_u64 s[10:11], s[2:3], s103
// CHECK: [0x02,0x67,0x8a,0x94]

s_bfe_u64 s[10:11], s[2:3], flat_scratch_lo
// CHECK: [0x02,0x68,0x8a,0x94]

s_bfe_u64 s[10:11], s[2:3], flat_scratch_hi
// CHECK: [0x02,0x69,0x8a,0x94]

s_bfe_u64 s[10:11], s[2:3], vcc_lo
// CHECK: [0x02,0x6a,0x8a,0x94]

s_bfe_u64 s[10:11], s[2:3], vcc_hi
// CHECK: [0x02,0x6b,0x8a,0x94]

s_bfe_u64 s[10:11], s[2:3], tba_lo
// CHECK: [0x02,0x6c,0x8a,0x94]

s_bfe_u64 s[10:11], s[2:3], tba_hi
// CHECK: [0x02,0x6d,0x8a,0x94]

s_bfe_u64 s[10:11], s[2:3], tma_lo
// CHECK: [0x02,0x6e,0x8a,0x94]

s_bfe_u64 s[10:11], s[2:3], tma_hi
// CHECK: [0x02,0x6f,0x8a,0x94]

s_bfe_u64 s[10:11], s[2:3], ttmp11
// CHECK: [0x02,0x7b,0x8a,0x94]

s_bfe_u64 s[10:11], s[2:3], m0
// CHECK: [0x02,0x7c,0x8a,0x94]

s_bfe_u64 s[10:11], s[2:3], exec_lo
// CHECK: [0x02,0x7e,0x8a,0x94]

s_bfe_u64 s[10:11], s[2:3], exec_hi
// CHECK: [0x02,0x7f,0x8a,0x94]

s_bfe_u64 s[10:11], s[2:3], 0
// CHECK: [0x02,0x80,0x8a,0x94]

s_bfe_u64 s[10:11], s[2:3], -1
// CHECK: [0x02,0xc1,0x8a,0x94]

s_bfe_u64 s[10:11], s[2:3], 0.5
// CHECK: [0x02,0xf0,0x8a,0x94]

s_bfe_u64 s[10:11], s[2:3], -4.0
// CHECK: [0x02,0xf7,0x8a,0x94]

s_bfe_u64 s[10:11], s[2:3], 0xaf123456
// CHECK: [0x02,0xff,0x8a,0x94,0x56,0x34,0x12,0xaf]

s_bfe_u64 s[10:11], s[2:3], 0x3f717273
// CHECK: [0x02,0xff,0x8a,0x94,0x73,0x72,0x71,0x3f]

s_bfe_i64 s[10:11], s[2:3], s2
// CHECK: [0x02,0x02,0x0a,0x95]

s_bfe_i64 s[12:13], s[2:3], s2
// CHECK: [0x02,0x02,0x0c,0x95]

s_bfe_i64 s[102:103], s[2:3], s2
// CHECK: [0x02,0x02,0x66,0x95]

s_bfe_i64 flat_scratch, s[2:3], s2
// CHECK: [0x02,0x02,0x68,0x95]

s_bfe_i64 vcc, s[2:3], s2
// CHECK: [0x02,0x02,0x6a,0x95]

s_bfe_i64 tba, s[2:3], s2
// CHECK: [0x02,0x02,0x6c,0x95]

s_bfe_i64 tma, s[2:3], s2
// CHECK: [0x02,0x02,0x6e,0x95]

s_bfe_i64 ttmp[10:11], s[2:3], s2
// CHECK: [0x02,0x02,0x7a,0x95]

s_bfe_i64 exec, s[2:3], s2
// CHECK: [0x02,0x02,0x7e,0x95]

s_bfe_i64 s[10:11], s[4:5], s2
// CHECK: [0x04,0x02,0x0a,0x95]

s_bfe_i64 s[10:11], s[102:103], s2
// CHECK: [0x66,0x02,0x0a,0x95]

s_bfe_i64 s[10:11], flat_scratch, s2
// CHECK: [0x68,0x02,0x0a,0x95]

s_bfe_i64 s[10:11], vcc, s2
// CHECK: [0x6a,0x02,0x0a,0x95]

s_bfe_i64 s[10:11], tba, s2
// CHECK: [0x6c,0x02,0x0a,0x95]

s_bfe_i64 s[10:11], tma, s2
// CHECK: [0x6e,0x02,0x0a,0x95]

s_bfe_i64 s[10:11], ttmp[10:11], s2
// CHECK: [0x7a,0x02,0x0a,0x95]

s_bfe_i64 s[10:11], exec, s2
// CHECK: [0x7e,0x02,0x0a,0x95]

s_bfe_i64 s[10:11], 0, s2
// CHECK: [0x80,0x02,0x0a,0x95]

s_bfe_i64 s[10:11], -1, s2
// CHECK: [0xc1,0x02,0x0a,0x95]

s_bfe_i64 s[10:11], 0.5, s2
// CHECK: [0xf0,0x02,0x0a,0x95]

s_bfe_i64 s[10:11], -4.0, s2
// CHECK: [0xf7,0x02,0x0a,0x95]

s_bfe_i64 s[10:11], 0xaf123456, s2
// CHECK: [0xff,0x02,0x0a,0x95,0x56,0x34,0x12,0xaf]

s_bfe_i64 s[10:11], 0x3f717273, s2
// CHECK: [0xff,0x02,0x0a,0x95,0x73,0x72,0x71,0x3f]

s_bfe_i64 s[10:11], s[2:3], s103
// CHECK: [0x02,0x67,0x0a,0x95]

s_bfe_i64 s[10:11], s[2:3], flat_scratch_lo
// CHECK: [0x02,0x68,0x0a,0x95]

s_bfe_i64 s[10:11], s[2:3], flat_scratch_hi
// CHECK: [0x02,0x69,0x0a,0x95]

s_bfe_i64 s[10:11], s[2:3], vcc_lo
// CHECK: [0x02,0x6a,0x0a,0x95]

s_bfe_i64 s[10:11], s[2:3], vcc_hi
// CHECK: [0x02,0x6b,0x0a,0x95]

s_bfe_i64 s[10:11], s[2:3], tba_lo
// CHECK: [0x02,0x6c,0x0a,0x95]

s_bfe_i64 s[10:11], s[2:3], tba_hi
// CHECK: [0x02,0x6d,0x0a,0x95]

s_bfe_i64 s[10:11], s[2:3], tma_lo
// CHECK: [0x02,0x6e,0x0a,0x95]

s_bfe_i64 s[10:11], s[2:3], tma_hi
// CHECK: [0x02,0x6f,0x0a,0x95]

s_bfe_i64 s[10:11], s[2:3], ttmp11
// CHECK: [0x02,0x7b,0x0a,0x95]

s_bfe_i64 s[10:11], s[2:3], m0
// CHECK: [0x02,0x7c,0x0a,0x95]

s_bfe_i64 s[10:11], s[2:3], exec_lo
// CHECK: [0x02,0x7e,0x0a,0x95]

s_bfe_i64 s[10:11], s[2:3], exec_hi
// CHECK: [0x02,0x7f,0x0a,0x95]

s_bfe_i64 s[10:11], s[2:3], 0
// CHECK: [0x02,0x80,0x0a,0x95]

s_bfe_i64 s[10:11], s[2:3], -1
// CHECK: [0x02,0xc1,0x0a,0x95]

s_bfe_i64 s[10:11], s[2:3], 0.5
// CHECK: [0x02,0xf0,0x0a,0x95]

s_bfe_i64 s[10:11], s[2:3], -4.0
// CHECK: [0x02,0xf7,0x0a,0x95]

s_bfe_i64 s[10:11], s[2:3], 0xaf123456
// CHECK: [0x02,0xff,0x0a,0x95,0x56,0x34,0x12,0xaf]

s_bfe_i64 s[10:11], s[2:3], 0x3f717273
// CHECK: [0x02,0xff,0x0a,0x95,0x73,0x72,0x71,0x3f]

s_cbranch_g_fork s[2:3], s[4:5]
// CHECK: [0x02,0x04,0x80,0x95]

s_cbranch_g_fork s[4:5], s[4:5]
// CHECK: [0x04,0x04,0x80,0x95]

s_cbranch_g_fork s[102:103], s[4:5]
// CHECK: [0x66,0x04,0x80,0x95]

s_cbranch_g_fork flat_scratch, s[4:5]
// CHECK: [0x68,0x04,0x80,0x95]

s_cbranch_g_fork vcc, s[4:5]
// CHECK: [0x6a,0x04,0x80,0x95]

s_cbranch_g_fork tba, s[4:5]
// CHECK: [0x6c,0x04,0x80,0x95]

s_cbranch_g_fork tma, s[4:5]
// CHECK: [0x6e,0x04,0x80,0x95]

s_cbranch_g_fork ttmp[10:11], s[4:5]
// CHECK: [0x7a,0x04,0x80,0x95]

s_cbranch_g_fork exec, s[4:5]
// CHECK: [0x7e,0x04,0x80,0x95]

s_cbranch_g_fork 0, s[4:5]
// CHECK: [0x80,0x04,0x80,0x95]

s_cbranch_g_fork -1, s[4:5]
// CHECK: [0xc1,0x04,0x80,0x95]

s_cbranch_g_fork 0.5, s[4:5]
// CHECK: [0xf0,0x04,0x80,0x95]

s_cbranch_g_fork -4.0, s[4:5]
// CHECK: [0xf7,0x04,0x80,0x95]

s_cbranch_g_fork s[2:3], s[6:7]
// CHECK: [0x02,0x06,0x80,0x95]

s_cbranch_g_fork s[2:3], s[102:103]
// CHECK: [0x02,0x66,0x80,0x95]

s_cbranch_g_fork s[2:3], flat_scratch
// CHECK: [0x02,0x68,0x80,0x95]

s_cbranch_g_fork s[2:3], vcc
// CHECK: [0x02,0x6a,0x80,0x95]

s_cbranch_g_fork s[2:3], tba
// CHECK: [0x02,0x6c,0x80,0x95]

s_cbranch_g_fork s[2:3], tma
// CHECK: [0x02,0x6e,0x80,0x95]

s_cbranch_g_fork s[2:3], ttmp[10:11]
// CHECK: [0x02,0x7a,0x80,0x95]

s_cbranch_g_fork s[2:3], exec
// CHECK: [0x02,0x7e,0x80,0x95]

s_cbranch_g_fork s[2:3], 0
// CHECK: [0x02,0x80,0x80,0x95]

s_cbranch_g_fork s[2:3], -1
// CHECK: [0x02,0xc1,0x80,0x95]

s_cbranch_g_fork s[2:3], 0.5
// CHECK: [0x02,0xf0,0x80,0x95]

s_cbranch_g_fork s[2:3], -4.0
// CHECK: [0x02,0xf7,0x80,0x95]

s_absdiff_i32 s5, s1, s2
// CHECK: [0x01,0x02,0x05,0x96]

s_absdiff_i32 s103, s1, s2
// CHECK: [0x01,0x02,0x67,0x96]

s_absdiff_i32 flat_scratch_lo, s1, s2
// CHECK: [0x01,0x02,0x68,0x96]

s_absdiff_i32 flat_scratch_hi, s1, s2
// CHECK: [0x01,0x02,0x69,0x96]

s_absdiff_i32 vcc_lo, s1, s2
// CHECK: [0x01,0x02,0x6a,0x96]

s_absdiff_i32 vcc_hi, s1, s2
// CHECK: [0x01,0x02,0x6b,0x96]

s_absdiff_i32 tba_lo, s1, s2
// CHECK: [0x01,0x02,0x6c,0x96]

s_absdiff_i32 tba_hi, s1, s2
// CHECK: [0x01,0x02,0x6d,0x96]

s_absdiff_i32 tma_lo, s1, s2
// CHECK: [0x01,0x02,0x6e,0x96]

s_absdiff_i32 tma_hi, s1, s2
// CHECK: [0x01,0x02,0x6f,0x96]

s_absdiff_i32 ttmp11, s1, s2
// CHECK: [0x01,0x02,0x7b,0x96]

s_absdiff_i32 m0, s1, s2
// CHECK: [0x01,0x02,0x7c,0x96]

s_absdiff_i32 exec_lo, s1, s2
// CHECK: [0x01,0x02,0x7e,0x96]

s_absdiff_i32 exec_hi, s1, s2
// CHECK: [0x01,0x02,0x7f,0x96]

s_absdiff_i32 s5, s103, s2
// CHECK: [0x67,0x02,0x05,0x96]

s_absdiff_i32 s5, flat_scratch_lo, s2
// CHECK: [0x68,0x02,0x05,0x96]

s_absdiff_i32 s5, flat_scratch_hi, s2
// CHECK: [0x69,0x02,0x05,0x96]

s_absdiff_i32 s5, vcc_lo, s2
// CHECK: [0x6a,0x02,0x05,0x96]

s_absdiff_i32 s5, vcc_hi, s2
// CHECK: [0x6b,0x02,0x05,0x96]

s_absdiff_i32 s5, tba_lo, s2
// CHECK: [0x6c,0x02,0x05,0x96]

s_absdiff_i32 s5, tba_hi, s2
// CHECK: [0x6d,0x02,0x05,0x96]

s_absdiff_i32 s5, tma_lo, s2
// CHECK: [0x6e,0x02,0x05,0x96]

s_absdiff_i32 s5, tma_hi, s2
// CHECK: [0x6f,0x02,0x05,0x96]

s_absdiff_i32 s5, ttmp11, s2
// CHECK: [0x7b,0x02,0x05,0x96]

s_absdiff_i32 s5, m0, s2
// CHECK: [0x7c,0x02,0x05,0x96]

s_absdiff_i32 s5, exec_lo, s2
// CHECK: [0x7e,0x02,0x05,0x96]

s_absdiff_i32 s5, exec_hi, s2
// CHECK: [0x7f,0x02,0x05,0x96]

s_absdiff_i32 s5, 0, s2
// CHECK: [0x80,0x02,0x05,0x96]

s_absdiff_i32 s5, -1, s2
// CHECK: [0xc1,0x02,0x05,0x96]

s_absdiff_i32 s5, 0.5, s2
// CHECK: [0xf0,0x02,0x05,0x96]

s_absdiff_i32 s5, -4.0, s2
// CHECK: [0xf7,0x02,0x05,0x96]

s_absdiff_i32 s5, 0xaf123456, s2
// CHECK: [0xff,0x02,0x05,0x96,0x56,0x34,0x12,0xaf]

s_absdiff_i32 s5, 0x3f717273, s2
// CHECK: [0xff,0x02,0x05,0x96,0x73,0x72,0x71,0x3f]

s_absdiff_i32 s5, s1, s103
// CHECK: [0x01,0x67,0x05,0x96]

s_absdiff_i32 s5, s1, flat_scratch_lo
// CHECK: [0x01,0x68,0x05,0x96]

s_absdiff_i32 s5, s1, flat_scratch_hi
// CHECK: [0x01,0x69,0x05,0x96]

s_absdiff_i32 s5, s1, vcc_lo
// CHECK: [0x01,0x6a,0x05,0x96]

s_absdiff_i32 s5, s1, vcc_hi
// CHECK: [0x01,0x6b,0x05,0x96]

s_absdiff_i32 s5, s1, tba_lo
// CHECK: [0x01,0x6c,0x05,0x96]

s_absdiff_i32 s5, s1, tba_hi
// CHECK: [0x01,0x6d,0x05,0x96]

s_absdiff_i32 s5, s1, tma_lo
// CHECK: [0x01,0x6e,0x05,0x96]

s_absdiff_i32 s5, s1, tma_hi
// CHECK: [0x01,0x6f,0x05,0x96]

s_absdiff_i32 s5, s1, ttmp11
// CHECK: [0x01,0x7b,0x05,0x96]

s_absdiff_i32 s5, s1, m0
// CHECK: [0x01,0x7c,0x05,0x96]

s_absdiff_i32 s5, s1, exec_lo
// CHECK: [0x01,0x7e,0x05,0x96]

s_absdiff_i32 s5, s1, exec_hi
// CHECK: [0x01,0x7f,0x05,0x96]

s_absdiff_i32 s5, s1, 0
// CHECK: [0x01,0x80,0x05,0x96]

s_absdiff_i32 s5, s1, -1
// CHECK: [0x01,0xc1,0x05,0x96]

s_absdiff_i32 s5, s1, 0.5
// CHECK: [0x01,0xf0,0x05,0x96]

s_absdiff_i32 s5, s1, -4.0
// CHECK: [0x01,0xf7,0x05,0x96]

s_absdiff_i32 s5, s1, 0xaf123456
// CHECK: [0x01,0xff,0x05,0x96,0x56,0x34,0x12,0xaf]

s_absdiff_i32 s5, s1, 0x3f717273
// CHECK: [0x01,0xff,0x05,0x96,0x73,0x72,0x71,0x3f]

s_cmp_eq_i32 s1, s2
// CHECK: [0x01,0x02,0x00,0xbf]

s_cmp_eq_i32 s103, s2
// CHECK: [0x67,0x02,0x00,0xbf]

s_cmp_eq_i32 flat_scratch_lo, s2
// CHECK: [0x68,0x02,0x00,0xbf]

s_cmp_eq_i32 flat_scratch_hi, s2
// CHECK: [0x69,0x02,0x00,0xbf]

s_cmp_eq_i32 vcc_lo, s2
// CHECK: [0x6a,0x02,0x00,0xbf]

s_cmp_eq_i32 vcc_hi, s2
// CHECK: [0x6b,0x02,0x00,0xbf]

s_cmp_eq_i32 tba_lo, s2
// CHECK: [0x6c,0x02,0x00,0xbf]

s_cmp_eq_i32 tba_hi, s2
// CHECK: [0x6d,0x02,0x00,0xbf]

s_cmp_eq_i32 tma_lo, s2
// CHECK: [0x6e,0x02,0x00,0xbf]

s_cmp_eq_i32 tma_hi, s2
// CHECK: [0x6f,0x02,0x00,0xbf]

s_cmp_eq_i32 ttmp11, s2
// CHECK: [0x7b,0x02,0x00,0xbf]

s_cmp_eq_i32 m0, s2
// CHECK: [0x7c,0x02,0x00,0xbf]

s_cmp_eq_i32 exec_lo, s2
// CHECK: [0x7e,0x02,0x00,0xbf]

s_cmp_eq_i32 exec_hi, s2
// CHECK: [0x7f,0x02,0x00,0xbf]

s_cmp_eq_i32 0, s2
// CHECK: [0x80,0x02,0x00,0xbf]

s_cmp_eq_i32 -1, s2
// CHECK: [0xc1,0x02,0x00,0xbf]

s_cmp_eq_i32 0.5, s2
// CHECK: [0xf0,0x02,0x00,0xbf]

s_cmp_eq_i32 -4.0, s2
// CHECK: [0xf7,0x02,0x00,0xbf]

s_cmp_eq_i32 0xaf123456, s2
// CHECK: [0xff,0x02,0x00,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_eq_i32 0x3f717273, s2
// CHECK: [0xff,0x02,0x00,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_eq_i32 s1, s103
// CHECK: [0x01,0x67,0x00,0xbf]

s_cmp_eq_i32 s1, flat_scratch_lo
// CHECK: [0x01,0x68,0x00,0xbf]

s_cmp_eq_i32 s1, flat_scratch_hi
// CHECK: [0x01,0x69,0x00,0xbf]

s_cmp_eq_i32 s1, vcc_lo
// CHECK: [0x01,0x6a,0x00,0xbf]

s_cmp_eq_i32 s1, vcc_hi
// CHECK: [0x01,0x6b,0x00,0xbf]

s_cmp_eq_i32 s1, tba_lo
// CHECK: [0x01,0x6c,0x00,0xbf]

s_cmp_eq_i32 s1, tba_hi
// CHECK: [0x01,0x6d,0x00,0xbf]

s_cmp_eq_i32 s1, tma_lo
// CHECK: [0x01,0x6e,0x00,0xbf]

s_cmp_eq_i32 s1, tma_hi
// CHECK: [0x01,0x6f,0x00,0xbf]

s_cmp_eq_i32 s1, ttmp11
// CHECK: [0x01,0x7b,0x00,0xbf]

s_cmp_eq_i32 s1, m0
// CHECK: [0x01,0x7c,0x00,0xbf]

s_cmp_eq_i32 s1, exec_lo
// CHECK: [0x01,0x7e,0x00,0xbf]

s_cmp_eq_i32 s1, exec_hi
// CHECK: [0x01,0x7f,0x00,0xbf]

s_cmp_eq_i32 s1, 0
// CHECK: [0x01,0x80,0x00,0xbf]

s_cmp_eq_i32 s1, -1
// CHECK: [0x01,0xc1,0x00,0xbf]

s_cmp_eq_i32 s1, 0.5
// CHECK: [0x01,0xf0,0x00,0xbf]

s_cmp_eq_i32 s1, -4.0
// CHECK: [0x01,0xf7,0x00,0xbf]

s_cmp_eq_i32 s1, 0xaf123456
// CHECK: [0x01,0xff,0x00,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_eq_i32 s1, 0x3f717273
// CHECK: [0x01,0xff,0x00,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_lg_i32 s1, s2
// CHECK: [0x01,0x02,0x01,0xbf]

s_cmp_lg_i32 s103, s2
// CHECK: [0x67,0x02,0x01,0xbf]

s_cmp_lg_i32 flat_scratch_lo, s2
// CHECK: [0x68,0x02,0x01,0xbf]

s_cmp_lg_i32 flat_scratch_hi, s2
// CHECK: [0x69,0x02,0x01,0xbf]

s_cmp_lg_i32 vcc_lo, s2
// CHECK: [0x6a,0x02,0x01,0xbf]

s_cmp_lg_i32 vcc_hi, s2
// CHECK: [0x6b,0x02,0x01,0xbf]

s_cmp_lg_i32 tba_lo, s2
// CHECK: [0x6c,0x02,0x01,0xbf]

s_cmp_lg_i32 tba_hi, s2
// CHECK: [0x6d,0x02,0x01,0xbf]

s_cmp_lg_i32 tma_lo, s2
// CHECK: [0x6e,0x02,0x01,0xbf]

s_cmp_lg_i32 tma_hi, s2
// CHECK: [0x6f,0x02,0x01,0xbf]

s_cmp_lg_i32 ttmp11, s2
// CHECK: [0x7b,0x02,0x01,0xbf]

s_cmp_lg_i32 m0, s2
// CHECK: [0x7c,0x02,0x01,0xbf]

s_cmp_lg_i32 exec_lo, s2
// CHECK: [0x7e,0x02,0x01,0xbf]

s_cmp_lg_i32 exec_hi, s2
// CHECK: [0x7f,0x02,0x01,0xbf]

s_cmp_lg_i32 0, s2
// CHECK: [0x80,0x02,0x01,0xbf]

s_cmp_lg_i32 -1, s2
// CHECK: [0xc1,0x02,0x01,0xbf]

s_cmp_lg_i32 0.5, s2
// CHECK: [0xf0,0x02,0x01,0xbf]

s_cmp_lg_i32 -4.0, s2
// CHECK: [0xf7,0x02,0x01,0xbf]

s_cmp_lg_i32 0xaf123456, s2
// CHECK: [0xff,0x02,0x01,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_lg_i32 0x3f717273, s2
// CHECK: [0xff,0x02,0x01,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_lg_i32 s1, s103
// CHECK: [0x01,0x67,0x01,0xbf]

s_cmp_lg_i32 s1, flat_scratch_lo
// CHECK: [0x01,0x68,0x01,0xbf]

s_cmp_lg_i32 s1, flat_scratch_hi
// CHECK: [0x01,0x69,0x01,0xbf]

s_cmp_lg_i32 s1, vcc_lo
// CHECK: [0x01,0x6a,0x01,0xbf]

s_cmp_lg_i32 s1, vcc_hi
// CHECK: [0x01,0x6b,0x01,0xbf]

s_cmp_lg_i32 s1, tba_lo
// CHECK: [0x01,0x6c,0x01,0xbf]

s_cmp_lg_i32 s1, tba_hi
// CHECK: [0x01,0x6d,0x01,0xbf]

s_cmp_lg_i32 s1, tma_lo
// CHECK: [0x01,0x6e,0x01,0xbf]

s_cmp_lg_i32 s1, tma_hi
// CHECK: [0x01,0x6f,0x01,0xbf]

s_cmp_lg_i32 s1, ttmp11
// CHECK: [0x01,0x7b,0x01,0xbf]

s_cmp_lg_i32 s1, m0
// CHECK: [0x01,0x7c,0x01,0xbf]

s_cmp_lg_i32 s1, exec_lo
// CHECK: [0x01,0x7e,0x01,0xbf]

s_cmp_lg_i32 s1, exec_hi
// CHECK: [0x01,0x7f,0x01,0xbf]

s_cmp_lg_i32 s1, 0
// CHECK: [0x01,0x80,0x01,0xbf]

s_cmp_lg_i32 s1, -1
// CHECK: [0x01,0xc1,0x01,0xbf]

s_cmp_lg_i32 s1, 0.5
// CHECK: [0x01,0xf0,0x01,0xbf]

s_cmp_lg_i32 s1, -4.0
// CHECK: [0x01,0xf7,0x01,0xbf]

s_cmp_lg_i32 s1, 0xaf123456
// CHECK: [0x01,0xff,0x01,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_lg_i32 s1, 0x3f717273
// CHECK: [0x01,0xff,0x01,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_gt_i32 s1, s2
// CHECK: [0x01,0x02,0x02,0xbf]

s_cmp_gt_i32 s103, s2
// CHECK: [0x67,0x02,0x02,0xbf]

s_cmp_gt_i32 flat_scratch_lo, s2
// CHECK: [0x68,0x02,0x02,0xbf]

s_cmp_gt_i32 flat_scratch_hi, s2
// CHECK: [0x69,0x02,0x02,0xbf]

s_cmp_gt_i32 vcc_lo, s2
// CHECK: [0x6a,0x02,0x02,0xbf]

s_cmp_gt_i32 vcc_hi, s2
// CHECK: [0x6b,0x02,0x02,0xbf]

s_cmp_gt_i32 tba_lo, s2
// CHECK: [0x6c,0x02,0x02,0xbf]

s_cmp_gt_i32 tba_hi, s2
// CHECK: [0x6d,0x02,0x02,0xbf]

s_cmp_gt_i32 tma_lo, s2
// CHECK: [0x6e,0x02,0x02,0xbf]

s_cmp_gt_i32 tma_hi, s2
// CHECK: [0x6f,0x02,0x02,0xbf]

s_cmp_gt_i32 ttmp11, s2
// CHECK: [0x7b,0x02,0x02,0xbf]

s_cmp_gt_i32 m0, s2
// CHECK: [0x7c,0x02,0x02,0xbf]

s_cmp_gt_i32 exec_lo, s2
// CHECK: [0x7e,0x02,0x02,0xbf]

s_cmp_gt_i32 exec_hi, s2
// CHECK: [0x7f,0x02,0x02,0xbf]

s_cmp_gt_i32 0, s2
// CHECK: [0x80,0x02,0x02,0xbf]

s_cmp_gt_i32 -1, s2
// CHECK: [0xc1,0x02,0x02,0xbf]

s_cmp_gt_i32 0.5, s2
// CHECK: [0xf0,0x02,0x02,0xbf]

s_cmp_gt_i32 -4.0, s2
// CHECK: [0xf7,0x02,0x02,0xbf]

s_cmp_gt_i32 0xaf123456, s2
// CHECK: [0xff,0x02,0x02,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_gt_i32 0x3f717273, s2
// CHECK: [0xff,0x02,0x02,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_gt_i32 s1, s103
// CHECK: [0x01,0x67,0x02,0xbf]

s_cmp_gt_i32 s1, flat_scratch_lo
// CHECK: [0x01,0x68,0x02,0xbf]

s_cmp_gt_i32 s1, flat_scratch_hi
// CHECK: [0x01,0x69,0x02,0xbf]

s_cmp_gt_i32 s1, vcc_lo
// CHECK: [0x01,0x6a,0x02,0xbf]

s_cmp_gt_i32 s1, vcc_hi
// CHECK: [0x01,0x6b,0x02,0xbf]

s_cmp_gt_i32 s1, tba_lo
// CHECK: [0x01,0x6c,0x02,0xbf]

s_cmp_gt_i32 s1, tba_hi
// CHECK: [0x01,0x6d,0x02,0xbf]

s_cmp_gt_i32 s1, tma_lo
// CHECK: [0x01,0x6e,0x02,0xbf]

s_cmp_gt_i32 s1, tma_hi
// CHECK: [0x01,0x6f,0x02,0xbf]

s_cmp_gt_i32 s1, ttmp11
// CHECK: [0x01,0x7b,0x02,0xbf]

s_cmp_gt_i32 s1, m0
// CHECK: [0x01,0x7c,0x02,0xbf]

s_cmp_gt_i32 s1, exec_lo
// CHECK: [0x01,0x7e,0x02,0xbf]

s_cmp_gt_i32 s1, exec_hi
// CHECK: [0x01,0x7f,0x02,0xbf]

s_cmp_gt_i32 s1, 0
// CHECK: [0x01,0x80,0x02,0xbf]

s_cmp_gt_i32 s1, -1
// CHECK: [0x01,0xc1,0x02,0xbf]

s_cmp_gt_i32 s1, 0.5
// CHECK: [0x01,0xf0,0x02,0xbf]

s_cmp_gt_i32 s1, -4.0
// CHECK: [0x01,0xf7,0x02,0xbf]

s_cmp_gt_i32 s1, 0xaf123456
// CHECK: [0x01,0xff,0x02,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_gt_i32 s1, 0x3f717273
// CHECK: [0x01,0xff,0x02,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_ge_i32 s1, s2
// CHECK: [0x01,0x02,0x03,0xbf]

s_cmp_ge_i32 s103, s2
// CHECK: [0x67,0x02,0x03,0xbf]

s_cmp_ge_i32 flat_scratch_lo, s2
// CHECK: [0x68,0x02,0x03,0xbf]

s_cmp_ge_i32 flat_scratch_hi, s2
// CHECK: [0x69,0x02,0x03,0xbf]

s_cmp_ge_i32 vcc_lo, s2
// CHECK: [0x6a,0x02,0x03,0xbf]

s_cmp_ge_i32 vcc_hi, s2
// CHECK: [0x6b,0x02,0x03,0xbf]

s_cmp_ge_i32 tba_lo, s2
// CHECK: [0x6c,0x02,0x03,0xbf]

s_cmp_ge_i32 tba_hi, s2
// CHECK: [0x6d,0x02,0x03,0xbf]

s_cmp_ge_i32 tma_lo, s2
// CHECK: [0x6e,0x02,0x03,0xbf]

s_cmp_ge_i32 tma_hi, s2
// CHECK: [0x6f,0x02,0x03,0xbf]

s_cmp_ge_i32 ttmp11, s2
// CHECK: [0x7b,0x02,0x03,0xbf]

s_cmp_ge_i32 m0, s2
// CHECK: [0x7c,0x02,0x03,0xbf]

s_cmp_ge_i32 exec_lo, s2
// CHECK: [0x7e,0x02,0x03,0xbf]

s_cmp_ge_i32 exec_hi, s2
// CHECK: [0x7f,0x02,0x03,0xbf]

s_cmp_ge_i32 0, s2
// CHECK: [0x80,0x02,0x03,0xbf]

s_cmp_ge_i32 -1, s2
// CHECK: [0xc1,0x02,0x03,0xbf]

s_cmp_ge_i32 0.5, s2
// CHECK: [0xf0,0x02,0x03,0xbf]

s_cmp_ge_i32 -4.0, s2
// CHECK: [0xf7,0x02,0x03,0xbf]

s_cmp_ge_i32 0xaf123456, s2
// CHECK: [0xff,0x02,0x03,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_ge_i32 0x3f717273, s2
// CHECK: [0xff,0x02,0x03,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_ge_i32 s1, s103
// CHECK: [0x01,0x67,0x03,0xbf]

s_cmp_ge_i32 s1, flat_scratch_lo
// CHECK: [0x01,0x68,0x03,0xbf]

s_cmp_ge_i32 s1, flat_scratch_hi
// CHECK: [0x01,0x69,0x03,0xbf]

s_cmp_ge_i32 s1, vcc_lo
// CHECK: [0x01,0x6a,0x03,0xbf]

s_cmp_ge_i32 s1, vcc_hi
// CHECK: [0x01,0x6b,0x03,0xbf]

s_cmp_ge_i32 s1, tba_lo
// CHECK: [0x01,0x6c,0x03,0xbf]

s_cmp_ge_i32 s1, tba_hi
// CHECK: [0x01,0x6d,0x03,0xbf]

s_cmp_ge_i32 s1, tma_lo
// CHECK: [0x01,0x6e,0x03,0xbf]

s_cmp_ge_i32 s1, tma_hi
// CHECK: [0x01,0x6f,0x03,0xbf]

s_cmp_ge_i32 s1, ttmp11
// CHECK: [0x01,0x7b,0x03,0xbf]

s_cmp_ge_i32 s1, m0
// CHECK: [0x01,0x7c,0x03,0xbf]

s_cmp_ge_i32 s1, exec_lo
// CHECK: [0x01,0x7e,0x03,0xbf]

s_cmp_ge_i32 s1, exec_hi
// CHECK: [0x01,0x7f,0x03,0xbf]

s_cmp_ge_i32 s1, 0
// CHECK: [0x01,0x80,0x03,0xbf]

s_cmp_ge_i32 s1, -1
// CHECK: [0x01,0xc1,0x03,0xbf]

s_cmp_ge_i32 s1, 0.5
// CHECK: [0x01,0xf0,0x03,0xbf]

s_cmp_ge_i32 s1, -4.0
// CHECK: [0x01,0xf7,0x03,0xbf]

s_cmp_ge_i32 s1, 0xaf123456
// CHECK: [0x01,0xff,0x03,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_ge_i32 s1, 0x3f717273
// CHECK: [0x01,0xff,0x03,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_lt_i32 s1, s2
// CHECK: [0x01,0x02,0x04,0xbf]

s_cmp_lt_i32 s103, s2
// CHECK: [0x67,0x02,0x04,0xbf]

s_cmp_lt_i32 flat_scratch_lo, s2
// CHECK: [0x68,0x02,0x04,0xbf]

s_cmp_lt_i32 flat_scratch_hi, s2
// CHECK: [0x69,0x02,0x04,0xbf]

s_cmp_lt_i32 vcc_lo, s2
// CHECK: [0x6a,0x02,0x04,0xbf]

s_cmp_lt_i32 vcc_hi, s2
// CHECK: [0x6b,0x02,0x04,0xbf]

s_cmp_lt_i32 tba_lo, s2
// CHECK: [0x6c,0x02,0x04,0xbf]

s_cmp_lt_i32 tba_hi, s2
// CHECK: [0x6d,0x02,0x04,0xbf]

s_cmp_lt_i32 tma_lo, s2
// CHECK: [0x6e,0x02,0x04,0xbf]

s_cmp_lt_i32 tma_hi, s2
// CHECK: [0x6f,0x02,0x04,0xbf]

s_cmp_lt_i32 ttmp11, s2
// CHECK: [0x7b,0x02,0x04,0xbf]

s_cmp_lt_i32 m0, s2
// CHECK: [0x7c,0x02,0x04,0xbf]

s_cmp_lt_i32 exec_lo, s2
// CHECK: [0x7e,0x02,0x04,0xbf]

s_cmp_lt_i32 exec_hi, s2
// CHECK: [0x7f,0x02,0x04,0xbf]

s_cmp_lt_i32 0, s2
// CHECK: [0x80,0x02,0x04,0xbf]

s_cmp_lt_i32 -1, s2
// CHECK: [0xc1,0x02,0x04,0xbf]

s_cmp_lt_i32 0.5, s2
// CHECK: [0xf0,0x02,0x04,0xbf]

s_cmp_lt_i32 -4.0, s2
// CHECK: [0xf7,0x02,0x04,0xbf]

s_cmp_lt_i32 0xaf123456, s2
// CHECK: [0xff,0x02,0x04,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_lt_i32 0x3f717273, s2
// CHECK: [0xff,0x02,0x04,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_lt_i32 s1, s103
// CHECK: [0x01,0x67,0x04,0xbf]

s_cmp_lt_i32 s1, flat_scratch_lo
// CHECK: [0x01,0x68,0x04,0xbf]

s_cmp_lt_i32 s1, flat_scratch_hi
// CHECK: [0x01,0x69,0x04,0xbf]

s_cmp_lt_i32 s1, vcc_lo
// CHECK: [0x01,0x6a,0x04,0xbf]

s_cmp_lt_i32 s1, vcc_hi
// CHECK: [0x01,0x6b,0x04,0xbf]

s_cmp_lt_i32 s1, tba_lo
// CHECK: [0x01,0x6c,0x04,0xbf]

s_cmp_lt_i32 s1, tba_hi
// CHECK: [0x01,0x6d,0x04,0xbf]

s_cmp_lt_i32 s1, tma_lo
// CHECK: [0x01,0x6e,0x04,0xbf]

s_cmp_lt_i32 s1, tma_hi
// CHECK: [0x01,0x6f,0x04,0xbf]

s_cmp_lt_i32 s1, ttmp11
// CHECK: [0x01,0x7b,0x04,0xbf]

s_cmp_lt_i32 s1, m0
// CHECK: [0x01,0x7c,0x04,0xbf]

s_cmp_lt_i32 s1, exec_lo
// CHECK: [0x01,0x7e,0x04,0xbf]

s_cmp_lt_i32 s1, exec_hi
// CHECK: [0x01,0x7f,0x04,0xbf]

s_cmp_lt_i32 s1, 0
// CHECK: [0x01,0x80,0x04,0xbf]

s_cmp_lt_i32 s1, -1
// CHECK: [0x01,0xc1,0x04,0xbf]

s_cmp_lt_i32 s1, 0.5
// CHECK: [0x01,0xf0,0x04,0xbf]

s_cmp_lt_i32 s1, -4.0
// CHECK: [0x01,0xf7,0x04,0xbf]

s_cmp_lt_i32 s1, 0xaf123456
// CHECK: [0x01,0xff,0x04,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_lt_i32 s1, 0x3f717273
// CHECK: [0x01,0xff,0x04,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_le_i32 s1, s2
// CHECK: [0x01,0x02,0x05,0xbf]

s_cmp_le_i32 s103, s2
// CHECK: [0x67,0x02,0x05,0xbf]

s_cmp_le_i32 flat_scratch_lo, s2
// CHECK: [0x68,0x02,0x05,0xbf]

s_cmp_le_i32 flat_scratch_hi, s2
// CHECK: [0x69,0x02,0x05,0xbf]

s_cmp_le_i32 vcc_lo, s2
// CHECK: [0x6a,0x02,0x05,0xbf]

s_cmp_le_i32 vcc_hi, s2
// CHECK: [0x6b,0x02,0x05,0xbf]

s_cmp_le_i32 tba_lo, s2
// CHECK: [0x6c,0x02,0x05,0xbf]

s_cmp_le_i32 tba_hi, s2
// CHECK: [0x6d,0x02,0x05,0xbf]

s_cmp_le_i32 tma_lo, s2
// CHECK: [0x6e,0x02,0x05,0xbf]

s_cmp_le_i32 tma_hi, s2
// CHECK: [0x6f,0x02,0x05,0xbf]

s_cmp_le_i32 ttmp11, s2
// CHECK: [0x7b,0x02,0x05,0xbf]

s_cmp_le_i32 m0, s2
// CHECK: [0x7c,0x02,0x05,0xbf]

s_cmp_le_i32 exec_lo, s2
// CHECK: [0x7e,0x02,0x05,0xbf]

s_cmp_le_i32 exec_hi, s2
// CHECK: [0x7f,0x02,0x05,0xbf]

s_cmp_le_i32 0, s2
// CHECK: [0x80,0x02,0x05,0xbf]

s_cmp_le_i32 -1, s2
// CHECK: [0xc1,0x02,0x05,0xbf]

s_cmp_le_i32 0.5, s2
// CHECK: [0xf0,0x02,0x05,0xbf]

s_cmp_le_i32 -4.0, s2
// CHECK: [0xf7,0x02,0x05,0xbf]

s_cmp_le_i32 0xaf123456, s2
// CHECK: [0xff,0x02,0x05,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_le_i32 0x3f717273, s2
// CHECK: [0xff,0x02,0x05,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_le_i32 s1, s103
// CHECK: [0x01,0x67,0x05,0xbf]

s_cmp_le_i32 s1, flat_scratch_lo
// CHECK: [0x01,0x68,0x05,0xbf]

s_cmp_le_i32 s1, flat_scratch_hi
// CHECK: [0x01,0x69,0x05,0xbf]

s_cmp_le_i32 s1, vcc_lo
// CHECK: [0x01,0x6a,0x05,0xbf]

s_cmp_le_i32 s1, vcc_hi
// CHECK: [0x01,0x6b,0x05,0xbf]

s_cmp_le_i32 s1, tba_lo
// CHECK: [0x01,0x6c,0x05,0xbf]

s_cmp_le_i32 s1, tba_hi
// CHECK: [0x01,0x6d,0x05,0xbf]

s_cmp_le_i32 s1, tma_lo
// CHECK: [0x01,0x6e,0x05,0xbf]

s_cmp_le_i32 s1, tma_hi
// CHECK: [0x01,0x6f,0x05,0xbf]

s_cmp_le_i32 s1, ttmp11
// CHECK: [0x01,0x7b,0x05,0xbf]

s_cmp_le_i32 s1, m0
// CHECK: [0x01,0x7c,0x05,0xbf]

s_cmp_le_i32 s1, exec_lo
// CHECK: [0x01,0x7e,0x05,0xbf]

s_cmp_le_i32 s1, exec_hi
// CHECK: [0x01,0x7f,0x05,0xbf]

s_cmp_le_i32 s1, 0
// CHECK: [0x01,0x80,0x05,0xbf]

s_cmp_le_i32 s1, -1
// CHECK: [0x01,0xc1,0x05,0xbf]

s_cmp_le_i32 s1, 0.5
// CHECK: [0x01,0xf0,0x05,0xbf]

s_cmp_le_i32 s1, -4.0
// CHECK: [0x01,0xf7,0x05,0xbf]

s_cmp_le_i32 s1, 0xaf123456
// CHECK: [0x01,0xff,0x05,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_le_i32 s1, 0x3f717273
// CHECK: [0x01,0xff,0x05,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_eq_u32 s1, s2
// CHECK: [0x01,0x02,0x06,0xbf]

s_cmp_eq_u32 s103, s2
// CHECK: [0x67,0x02,0x06,0xbf]

s_cmp_eq_u32 flat_scratch_lo, s2
// CHECK: [0x68,0x02,0x06,0xbf]

s_cmp_eq_u32 flat_scratch_hi, s2
// CHECK: [0x69,0x02,0x06,0xbf]

s_cmp_eq_u32 vcc_lo, s2
// CHECK: [0x6a,0x02,0x06,0xbf]

s_cmp_eq_u32 vcc_hi, s2
// CHECK: [0x6b,0x02,0x06,0xbf]

s_cmp_eq_u32 tba_lo, s2
// CHECK: [0x6c,0x02,0x06,0xbf]

s_cmp_eq_u32 tba_hi, s2
// CHECK: [0x6d,0x02,0x06,0xbf]

s_cmp_eq_u32 tma_lo, s2
// CHECK: [0x6e,0x02,0x06,0xbf]

s_cmp_eq_u32 tma_hi, s2
// CHECK: [0x6f,0x02,0x06,0xbf]

s_cmp_eq_u32 ttmp11, s2
// CHECK: [0x7b,0x02,0x06,0xbf]

s_cmp_eq_u32 m0, s2
// CHECK: [0x7c,0x02,0x06,0xbf]

s_cmp_eq_u32 exec_lo, s2
// CHECK: [0x7e,0x02,0x06,0xbf]

s_cmp_eq_u32 exec_hi, s2
// CHECK: [0x7f,0x02,0x06,0xbf]

s_cmp_eq_u32 0, s2
// CHECK: [0x80,0x02,0x06,0xbf]

s_cmp_eq_u32 -1, s2
// CHECK: [0xc1,0x02,0x06,0xbf]

s_cmp_eq_u32 0.5, s2
// CHECK: [0xf0,0x02,0x06,0xbf]

s_cmp_eq_u32 -4.0, s2
// CHECK: [0xf7,0x02,0x06,0xbf]

s_cmp_eq_u32 0xaf123456, s2
// CHECK: [0xff,0x02,0x06,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_eq_u32 0x3f717273, s2
// CHECK: [0xff,0x02,0x06,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_eq_u32 s1, s103
// CHECK: [0x01,0x67,0x06,0xbf]

s_cmp_eq_u32 s1, flat_scratch_lo
// CHECK: [0x01,0x68,0x06,0xbf]

s_cmp_eq_u32 s1, flat_scratch_hi
// CHECK: [0x01,0x69,0x06,0xbf]

s_cmp_eq_u32 s1, vcc_lo
// CHECK: [0x01,0x6a,0x06,0xbf]

s_cmp_eq_u32 s1, vcc_hi
// CHECK: [0x01,0x6b,0x06,0xbf]

s_cmp_eq_u32 s1, tba_lo
// CHECK: [0x01,0x6c,0x06,0xbf]

s_cmp_eq_u32 s1, tba_hi
// CHECK: [0x01,0x6d,0x06,0xbf]

s_cmp_eq_u32 s1, tma_lo
// CHECK: [0x01,0x6e,0x06,0xbf]

s_cmp_eq_u32 s1, tma_hi
// CHECK: [0x01,0x6f,0x06,0xbf]

s_cmp_eq_u32 s1, ttmp11
// CHECK: [0x01,0x7b,0x06,0xbf]

s_cmp_eq_u32 s1, m0
// CHECK: [0x01,0x7c,0x06,0xbf]

s_cmp_eq_u32 s1, exec_lo
// CHECK: [0x01,0x7e,0x06,0xbf]

s_cmp_eq_u32 s1, exec_hi
// CHECK: [0x01,0x7f,0x06,0xbf]

s_cmp_eq_u32 s1, 0
// CHECK: [0x01,0x80,0x06,0xbf]

s_cmp_eq_u32 s1, -1
// CHECK: [0x01,0xc1,0x06,0xbf]

s_cmp_eq_u32 s1, 0.5
// CHECK: [0x01,0xf0,0x06,0xbf]

s_cmp_eq_u32 s1, -4.0
// CHECK: [0x01,0xf7,0x06,0xbf]

s_cmp_eq_u32 s1, 0xaf123456
// CHECK: [0x01,0xff,0x06,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_eq_u32 s1, 0x3f717273
// CHECK: [0x01,0xff,0x06,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_lg_u32 s1, s2
// CHECK: [0x01,0x02,0x07,0xbf]

s_cmp_lg_u32 s103, s2
// CHECK: [0x67,0x02,0x07,0xbf]

s_cmp_lg_u32 flat_scratch_lo, s2
// CHECK: [0x68,0x02,0x07,0xbf]

s_cmp_lg_u32 flat_scratch_hi, s2
// CHECK: [0x69,0x02,0x07,0xbf]

s_cmp_lg_u32 vcc_lo, s2
// CHECK: [0x6a,0x02,0x07,0xbf]

s_cmp_lg_u32 vcc_hi, s2
// CHECK: [0x6b,0x02,0x07,0xbf]

s_cmp_lg_u32 tba_lo, s2
// CHECK: [0x6c,0x02,0x07,0xbf]

s_cmp_lg_u32 tba_hi, s2
// CHECK: [0x6d,0x02,0x07,0xbf]

s_cmp_lg_u32 tma_lo, s2
// CHECK: [0x6e,0x02,0x07,0xbf]

s_cmp_lg_u32 tma_hi, s2
// CHECK: [0x6f,0x02,0x07,0xbf]

s_cmp_lg_u32 ttmp11, s2
// CHECK: [0x7b,0x02,0x07,0xbf]

s_cmp_lg_u32 m0, s2
// CHECK: [0x7c,0x02,0x07,0xbf]

s_cmp_lg_u32 exec_lo, s2
// CHECK: [0x7e,0x02,0x07,0xbf]

s_cmp_lg_u32 exec_hi, s2
// CHECK: [0x7f,0x02,0x07,0xbf]

s_cmp_lg_u32 0, s2
// CHECK: [0x80,0x02,0x07,0xbf]

s_cmp_lg_u32 -1, s2
// CHECK: [0xc1,0x02,0x07,0xbf]

s_cmp_lg_u32 0.5, s2
// CHECK: [0xf0,0x02,0x07,0xbf]

s_cmp_lg_u32 -4.0, s2
// CHECK: [0xf7,0x02,0x07,0xbf]

s_cmp_lg_u32 0xaf123456, s2
// CHECK: [0xff,0x02,0x07,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_lg_u32 0x3f717273, s2
// CHECK: [0xff,0x02,0x07,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_lg_u32 s1, s103
// CHECK: [0x01,0x67,0x07,0xbf]

s_cmp_lg_u32 s1, flat_scratch_lo
// CHECK: [0x01,0x68,0x07,0xbf]

s_cmp_lg_u32 s1, flat_scratch_hi
// CHECK: [0x01,0x69,0x07,0xbf]

s_cmp_lg_u32 s1, vcc_lo
// CHECK: [0x01,0x6a,0x07,0xbf]

s_cmp_lg_u32 s1, vcc_hi
// CHECK: [0x01,0x6b,0x07,0xbf]

s_cmp_lg_u32 s1, tba_lo
// CHECK: [0x01,0x6c,0x07,0xbf]

s_cmp_lg_u32 s1, tba_hi
// CHECK: [0x01,0x6d,0x07,0xbf]

s_cmp_lg_u32 s1, tma_lo
// CHECK: [0x01,0x6e,0x07,0xbf]

s_cmp_lg_u32 s1, tma_hi
// CHECK: [0x01,0x6f,0x07,0xbf]

s_cmp_lg_u32 s1, ttmp11
// CHECK: [0x01,0x7b,0x07,0xbf]

s_cmp_lg_u32 s1, m0
// CHECK: [0x01,0x7c,0x07,0xbf]

s_cmp_lg_u32 s1, exec_lo
// CHECK: [0x01,0x7e,0x07,0xbf]

s_cmp_lg_u32 s1, exec_hi
// CHECK: [0x01,0x7f,0x07,0xbf]

s_cmp_lg_u32 s1, 0
// CHECK: [0x01,0x80,0x07,0xbf]

s_cmp_lg_u32 s1, -1
// CHECK: [0x01,0xc1,0x07,0xbf]

s_cmp_lg_u32 s1, 0.5
// CHECK: [0x01,0xf0,0x07,0xbf]

s_cmp_lg_u32 s1, -4.0
// CHECK: [0x01,0xf7,0x07,0xbf]

s_cmp_lg_u32 s1, 0xaf123456
// CHECK: [0x01,0xff,0x07,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_lg_u32 s1, 0x3f717273
// CHECK: [0x01,0xff,0x07,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_gt_u32 s1, s2
// CHECK: [0x01,0x02,0x08,0xbf]

s_cmp_gt_u32 s103, s2
// CHECK: [0x67,0x02,0x08,0xbf]

s_cmp_gt_u32 flat_scratch_lo, s2
// CHECK: [0x68,0x02,0x08,0xbf]

s_cmp_gt_u32 flat_scratch_hi, s2
// CHECK: [0x69,0x02,0x08,0xbf]

s_cmp_gt_u32 vcc_lo, s2
// CHECK: [0x6a,0x02,0x08,0xbf]

s_cmp_gt_u32 vcc_hi, s2
// CHECK: [0x6b,0x02,0x08,0xbf]

s_cmp_gt_u32 tba_lo, s2
// CHECK: [0x6c,0x02,0x08,0xbf]

s_cmp_gt_u32 tba_hi, s2
// CHECK: [0x6d,0x02,0x08,0xbf]

s_cmp_gt_u32 tma_lo, s2
// CHECK: [0x6e,0x02,0x08,0xbf]

s_cmp_gt_u32 tma_hi, s2
// CHECK: [0x6f,0x02,0x08,0xbf]

s_cmp_gt_u32 ttmp11, s2
// CHECK: [0x7b,0x02,0x08,0xbf]

s_cmp_gt_u32 m0, s2
// CHECK: [0x7c,0x02,0x08,0xbf]

s_cmp_gt_u32 exec_lo, s2
// CHECK: [0x7e,0x02,0x08,0xbf]

s_cmp_gt_u32 exec_hi, s2
// CHECK: [0x7f,0x02,0x08,0xbf]

s_cmp_gt_u32 0, s2
// CHECK: [0x80,0x02,0x08,0xbf]

s_cmp_gt_u32 -1, s2
// CHECK: [0xc1,0x02,0x08,0xbf]

s_cmp_gt_u32 0.5, s2
// CHECK: [0xf0,0x02,0x08,0xbf]

s_cmp_gt_u32 -4.0, s2
// CHECK: [0xf7,0x02,0x08,0xbf]

s_cmp_gt_u32 0xaf123456, s2
// CHECK: [0xff,0x02,0x08,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_gt_u32 0x3f717273, s2
// CHECK: [0xff,0x02,0x08,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_gt_u32 s1, s103
// CHECK: [0x01,0x67,0x08,0xbf]

s_cmp_gt_u32 s1, flat_scratch_lo
// CHECK: [0x01,0x68,0x08,0xbf]

s_cmp_gt_u32 s1, flat_scratch_hi
// CHECK: [0x01,0x69,0x08,0xbf]

s_cmp_gt_u32 s1, vcc_lo
// CHECK: [0x01,0x6a,0x08,0xbf]

s_cmp_gt_u32 s1, vcc_hi
// CHECK: [0x01,0x6b,0x08,0xbf]

s_cmp_gt_u32 s1, tba_lo
// CHECK: [0x01,0x6c,0x08,0xbf]

s_cmp_gt_u32 s1, tba_hi
// CHECK: [0x01,0x6d,0x08,0xbf]

s_cmp_gt_u32 s1, tma_lo
// CHECK: [0x01,0x6e,0x08,0xbf]

s_cmp_gt_u32 s1, tma_hi
// CHECK: [0x01,0x6f,0x08,0xbf]

s_cmp_gt_u32 s1, ttmp11
// CHECK: [0x01,0x7b,0x08,0xbf]

s_cmp_gt_u32 s1, m0
// CHECK: [0x01,0x7c,0x08,0xbf]

s_cmp_gt_u32 s1, exec_lo
// CHECK: [0x01,0x7e,0x08,0xbf]

s_cmp_gt_u32 s1, exec_hi
// CHECK: [0x01,0x7f,0x08,0xbf]

s_cmp_gt_u32 s1, 0
// CHECK: [0x01,0x80,0x08,0xbf]

s_cmp_gt_u32 s1, -1
// CHECK: [0x01,0xc1,0x08,0xbf]

s_cmp_gt_u32 s1, 0.5
// CHECK: [0x01,0xf0,0x08,0xbf]

s_cmp_gt_u32 s1, -4.0
// CHECK: [0x01,0xf7,0x08,0xbf]

s_cmp_gt_u32 s1, 0xaf123456
// CHECK: [0x01,0xff,0x08,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_gt_u32 s1, 0x3f717273
// CHECK: [0x01,0xff,0x08,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_ge_u32 s1, s2
// CHECK: [0x01,0x02,0x09,0xbf]

s_cmp_ge_u32 s103, s2
// CHECK: [0x67,0x02,0x09,0xbf]

s_cmp_ge_u32 flat_scratch_lo, s2
// CHECK: [0x68,0x02,0x09,0xbf]

s_cmp_ge_u32 flat_scratch_hi, s2
// CHECK: [0x69,0x02,0x09,0xbf]

s_cmp_ge_u32 vcc_lo, s2
// CHECK: [0x6a,0x02,0x09,0xbf]

s_cmp_ge_u32 vcc_hi, s2
// CHECK: [0x6b,0x02,0x09,0xbf]

s_cmp_ge_u32 tba_lo, s2
// CHECK: [0x6c,0x02,0x09,0xbf]

s_cmp_ge_u32 tba_hi, s2
// CHECK: [0x6d,0x02,0x09,0xbf]

s_cmp_ge_u32 tma_lo, s2
// CHECK: [0x6e,0x02,0x09,0xbf]

s_cmp_ge_u32 tma_hi, s2
// CHECK: [0x6f,0x02,0x09,0xbf]

s_cmp_ge_u32 ttmp11, s2
// CHECK: [0x7b,0x02,0x09,0xbf]

s_cmp_ge_u32 m0, s2
// CHECK: [0x7c,0x02,0x09,0xbf]

s_cmp_ge_u32 exec_lo, s2
// CHECK: [0x7e,0x02,0x09,0xbf]

s_cmp_ge_u32 exec_hi, s2
// CHECK: [0x7f,0x02,0x09,0xbf]

s_cmp_ge_u32 0, s2
// CHECK: [0x80,0x02,0x09,0xbf]

s_cmp_ge_u32 -1, s2
// CHECK: [0xc1,0x02,0x09,0xbf]

s_cmp_ge_u32 0.5, s2
// CHECK: [0xf0,0x02,0x09,0xbf]

s_cmp_ge_u32 -4.0, s2
// CHECK: [0xf7,0x02,0x09,0xbf]

s_cmp_ge_u32 0xaf123456, s2
// CHECK: [0xff,0x02,0x09,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_ge_u32 0x3f717273, s2
// CHECK: [0xff,0x02,0x09,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_ge_u32 s1, s103
// CHECK: [0x01,0x67,0x09,0xbf]

s_cmp_ge_u32 s1, flat_scratch_lo
// CHECK: [0x01,0x68,0x09,0xbf]

s_cmp_ge_u32 s1, flat_scratch_hi
// CHECK: [0x01,0x69,0x09,0xbf]

s_cmp_ge_u32 s1, vcc_lo
// CHECK: [0x01,0x6a,0x09,0xbf]

s_cmp_ge_u32 s1, vcc_hi
// CHECK: [0x01,0x6b,0x09,0xbf]

s_cmp_ge_u32 s1, tba_lo
// CHECK: [0x01,0x6c,0x09,0xbf]

s_cmp_ge_u32 s1, tba_hi
// CHECK: [0x01,0x6d,0x09,0xbf]

s_cmp_ge_u32 s1, tma_lo
// CHECK: [0x01,0x6e,0x09,0xbf]

s_cmp_ge_u32 s1, tma_hi
// CHECK: [0x01,0x6f,0x09,0xbf]

s_cmp_ge_u32 s1, ttmp11
// CHECK: [0x01,0x7b,0x09,0xbf]

s_cmp_ge_u32 s1, m0
// CHECK: [0x01,0x7c,0x09,0xbf]

s_cmp_ge_u32 s1, exec_lo
// CHECK: [0x01,0x7e,0x09,0xbf]

s_cmp_ge_u32 s1, exec_hi
// CHECK: [0x01,0x7f,0x09,0xbf]

s_cmp_ge_u32 s1, 0
// CHECK: [0x01,0x80,0x09,0xbf]

s_cmp_ge_u32 s1, -1
// CHECK: [0x01,0xc1,0x09,0xbf]

s_cmp_ge_u32 s1, 0.5
// CHECK: [0x01,0xf0,0x09,0xbf]

s_cmp_ge_u32 s1, -4.0
// CHECK: [0x01,0xf7,0x09,0xbf]

s_cmp_ge_u32 s1, 0xaf123456
// CHECK: [0x01,0xff,0x09,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_ge_u32 s1, 0x3f717273
// CHECK: [0x01,0xff,0x09,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_lt_u32 s1, s2
// CHECK: [0x01,0x02,0x0a,0xbf]

s_cmp_lt_u32 s103, s2
// CHECK: [0x67,0x02,0x0a,0xbf]

s_cmp_lt_u32 flat_scratch_lo, s2
// CHECK: [0x68,0x02,0x0a,0xbf]

s_cmp_lt_u32 flat_scratch_hi, s2
// CHECK: [0x69,0x02,0x0a,0xbf]

s_cmp_lt_u32 vcc_lo, s2
// CHECK: [0x6a,0x02,0x0a,0xbf]

s_cmp_lt_u32 vcc_hi, s2
// CHECK: [0x6b,0x02,0x0a,0xbf]

s_cmp_lt_u32 tba_lo, s2
// CHECK: [0x6c,0x02,0x0a,0xbf]

s_cmp_lt_u32 tba_hi, s2
// CHECK: [0x6d,0x02,0x0a,0xbf]

s_cmp_lt_u32 tma_lo, s2
// CHECK: [0x6e,0x02,0x0a,0xbf]

s_cmp_lt_u32 tma_hi, s2
// CHECK: [0x6f,0x02,0x0a,0xbf]

s_cmp_lt_u32 ttmp11, s2
// CHECK: [0x7b,0x02,0x0a,0xbf]

s_cmp_lt_u32 m0, s2
// CHECK: [0x7c,0x02,0x0a,0xbf]

s_cmp_lt_u32 exec_lo, s2
// CHECK: [0x7e,0x02,0x0a,0xbf]

s_cmp_lt_u32 exec_hi, s2
// CHECK: [0x7f,0x02,0x0a,0xbf]

s_cmp_lt_u32 0, s2
// CHECK: [0x80,0x02,0x0a,0xbf]

s_cmp_lt_u32 -1, s2
// CHECK: [0xc1,0x02,0x0a,0xbf]

s_cmp_lt_u32 0.5, s2
// CHECK: [0xf0,0x02,0x0a,0xbf]

s_cmp_lt_u32 -4.0, s2
// CHECK: [0xf7,0x02,0x0a,0xbf]

s_cmp_lt_u32 0xaf123456, s2
// CHECK: [0xff,0x02,0x0a,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_lt_u32 0x3f717273, s2
// CHECK: [0xff,0x02,0x0a,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_lt_u32 s1, s103
// CHECK: [0x01,0x67,0x0a,0xbf]

s_cmp_lt_u32 s1, flat_scratch_lo
// CHECK: [0x01,0x68,0x0a,0xbf]

s_cmp_lt_u32 s1, flat_scratch_hi
// CHECK: [0x01,0x69,0x0a,0xbf]

s_cmp_lt_u32 s1, vcc_lo
// CHECK: [0x01,0x6a,0x0a,0xbf]

s_cmp_lt_u32 s1, vcc_hi
// CHECK: [0x01,0x6b,0x0a,0xbf]

s_cmp_lt_u32 s1, tba_lo
// CHECK: [0x01,0x6c,0x0a,0xbf]

s_cmp_lt_u32 s1, tba_hi
// CHECK: [0x01,0x6d,0x0a,0xbf]

s_cmp_lt_u32 s1, tma_lo
// CHECK: [0x01,0x6e,0x0a,0xbf]

s_cmp_lt_u32 s1, tma_hi
// CHECK: [0x01,0x6f,0x0a,0xbf]

s_cmp_lt_u32 s1, ttmp11
// CHECK: [0x01,0x7b,0x0a,0xbf]

s_cmp_lt_u32 s1, m0
// CHECK: [0x01,0x7c,0x0a,0xbf]

s_cmp_lt_u32 s1, exec_lo
// CHECK: [0x01,0x7e,0x0a,0xbf]

s_cmp_lt_u32 s1, exec_hi
// CHECK: [0x01,0x7f,0x0a,0xbf]

s_cmp_lt_u32 s1, 0
// CHECK: [0x01,0x80,0x0a,0xbf]

s_cmp_lt_u32 s1, -1
// CHECK: [0x01,0xc1,0x0a,0xbf]

s_cmp_lt_u32 s1, 0.5
// CHECK: [0x01,0xf0,0x0a,0xbf]

s_cmp_lt_u32 s1, -4.0
// CHECK: [0x01,0xf7,0x0a,0xbf]

s_cmp_lt_u32 s1, 0xaf123456
// CHECK: [0x01,0xff,0x0a,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_lt_u32 s1, 0x3f717273
// CHECK: [0x01,0xff,0x0a,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_le_u32 s1, s2
// CHECK: [0x01,0x02,0x0b,0xbf]

s_cmp_le_u32 s103, s2
// CHECK: [0x67,0x02,0x0b,0xbf]

s_cmp_le_u32 flat_scratch_lo, s2
// CHECK: [0x68,0x02,0x0b,0xbf]

s_cmp_le_u32 flat_scratch_hi, s2
// CHECK: [0x69,0x02,0x0b,0xbf]

s_cmp_le_u32 vcc_lo, s2
// CHECK: [0x6a,0x02,0x0b,0xbf]

s_cmp_le_u32 vcc_hi, s2
// CHECK: [0x6b,0x02,0x0b,0xbf]

s_cmp_le_u32 tba_lo, s2
// CHECK: [0x6c,0x02,0x0b,0xbf]

s_cmp_le_u32 tba_hi, s2
// CHECK: [0x6d,0x02,0x0b,0xbf]

s_cmp_le_u32 tma_lo, s2
// CHECK: [0x6e,0x02,0x0b,0xbf]

s_cmp_le_u32 tma_hi, s2
// CHECK: [0x6f,0x02,0x0b,0xbf]

s_cmp_le_u32 ttmp11, s2
// CHECK: [0x7b,0x02,0x0b,0xbf]

s_cmp_le_u32 m0, s2
// CHECK: [0x7c,0x02,0x0b,0xbf]

s_cmp_le_u32 exec_lo, s2
// CHECK: [0x7e,0x02,0x0b,0xbf]

s_cmp_le_u32 exec_hi, s2
// CHECK: [0x7f,0x02,0x0b,0xbf]

s_cmp_le_u32 0, s2
// CHECK: [0x80,0x02,0x0b,0xbf]

s_cmp_le_u32 -1, s2
// CHECK: [0xc1,0x02,0x0b,0xbf]

s_cmp_le_u32 0.5, s2
// CHECK: [0xf0,0x02,0x0b,0xbf]

s_cmp_le_u32 -4.0, s2
// CHECK: [0xf7,0x02,0x0b,0xbf]

s_cmp_le_u32 0xaf123456, s2
// CHECK: [0xff,0x02,0x0b,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_le_u32 0x3f717273, s2
// CHECK: [0xff,0x02,0x0b,0xbf,0x73,0x72,0x71,0x3f]

s_cmp_le_u32 s1, s103
// CHECK: [0x01,0x67,0x0b,0xbf]

s_cmp_le_u32 s1, flat_scratch_lo
// CHECK: [0x01,0x68,0x0b,0xbf]

s_cmp_le_u32 s1, flat_scratch_hi
// CHECK: [0x01,0x69,0x0b,0xbf]

s_cmp_le_u32 s1, vcc_lo
// CHECK: [0x01,0x6a,0x0b,0xbf]

s_cmp_le_u32 s1, vcc_hi
// CHECK: [0x01,0x6b,0x0b,0xbf]

s_cmp_le_u32 s1, tba_lo
// CHECK: [0x01,0x6c,0x0b,0xbf]

s_cmp_le_u32 s1, tba_hi
// CHECK: [0x01,0x6d,0x0b,0xbf]

s_cmp_le_u32 s1, tma_lo
// CHECK: [0x01,0x6e,0x0b,0xbf]

s_cmp_le_u32 s1, tma_hi
// CHECK: [0x01,0x6f,0x0b,0xbf]

s_cmp_le_u32 s1, ttmp11
// CHECK: [0x01,0x7b,0x0b,0xbf]

s_cmp_le_u32 s1, m0
// CHECK: [0x01,0x7c,0x0b,0xbf]

s_cmp_le_u32 s1, exec_lo
// CHECK: [0x01,0x7e,0x0b,0xbf]

s_cmp_le_u32 s1, exec_hi
// CHECK: [0x01,0x7f,0x0b,0xbf]

s_cmp_le_u32 s1, 0
// CHECK: [0x01,0x80,0x0b,0xbf]

s_cmp_le_u32 s1, -1
// CHECK: [0x01,0xc1,0x0b,0xbf]

s_cmp_le_u32 s1, 0.5
// CHECK: [0x01,0xf0,0x0b,0xbf]

s_cmp_le_u32 s1, -4.0
// CHECK: [0x01,0xf7,0x0b,0xbf]

s_cmp_le_u32 s1, 0xaf123456
// CHECK: [0x01,0xff,0x0b,0xbf,0x56,0x34,0x12,0xaf]

s_cmp_le_u32 s1, 0x3f717273
// CHECK: [0x01,0xff,0x0b,0xbf,0x73,0x72,0x71,0x3f]

s_bitcmp0_b32 s1, s2
// CHECK: [0x01,0x02,0x0c,0xbf]

s_bitcmp0_b32 s103, s2
// CHECK: [0x67,0x02,0x0c,0xbf]

s_bitcmp0_b32 flat_scratch_lo, s2
// CHECK: [0x68,0x02,0x0c,0xbf]

s_bitcmp0_b32 flat_scratch_hi, s2
// CHECK: [0x69,0x02,0x0c,0xbf]

s_bitcmp0_b32 vcc_lo, s2
// CHECK: [0x6a,0x02,0x0c,0xbf]

s_bitcmp0_b32 vcc_hi, s2
// CHECK: [0x6b,0x02,0x0c,0xbf]

s_bitcmp0_b32 tba_lo, s2
// CHECK: [0x6c,0x02,0x0c,0xbf]

s_bitcmp0_b32 tba_hi, s2
// CHECK: [0x6d,0x02,0x0c,0xbf]

s_bitcmp0_b32 tma_lo, s2
// CHECK: [0x6e,0x02,0x0c,0xbf]

s_bitcmp0_b32 tma_hi, s2
// CHECK: [0x6f,0x02,0x0c,0xbf]

s_bitcmp0_b32 ttmp11, s2
// CHECK: [0x7b,0x02,0x0c,0xbf]

s_bitcmp0_b32 m0, s2
// CHECK: [0x7c,0x02,0x0c,0xbf]

s_bitcmp0_b32 exec_lo, s2
// CHECK: [0x7e,0x02,0x0c,0xbf]

s_bitcmp0_b32 exec_hi, s2
// CHECK: [0x7f,0x02,0x0c,0xbf]

s_bitcmp0_b32 0, s2
// CHECK: [0x80,0x02,0x0c,0xbf]

s_bitcmp0_b32 -1, s2
// CHECK: [0xc1,0x02,0x0c,0xbf]

s_bitcmp0_b32 0.5, s2
// CHECK: [0xf0,0x02,0x0c,0xbf]

s_bitcmp0_b32 -4.0, s2
// CHECK: [0xf7,0x02,0x0c,0xbf]

s_bitcmp0_b32 0xaf123456, s2
// CHECK: [0xff,0x02,0x0c,0xbf,0x56,0x34,0x12,0xaf]

s_bitcmp0_b32 0x3f717273, s2
// CHECK: [0xff,0x02,0x0c,0xbf,0x73,0x72,0x71,0x3f]

s_bitcmp0_b32 s1, s103
// CHECK: [0x01,0x67,0x0c,0xbf]

s_bitcmp0_b32 s1, flat_scratch_lo
// CHECK: [0x01,0x68,0x0c,0xbf]

s_bitcmp0_b32 s1, flat_scratch_hi
// CHECK: [0x01,0x69,0x0c,0xbf]

s_bitcmp0_b32 s1, vcc_lo
// CHECK: [0x01,0x6a,0x0c,0xbf]

s_bitcmp0_b32 s1, vcc_hi
// CHECK: [0x01,0x6b,0x0c,0xbf]

s_bitcmp0_b32 s1, tba_lo
// CHECK: [0x01,0x6c,0x0c,0xbf]

s_bitcmp0_b32 s1, tba_hi
// CHECK: [0x01,0x6d,0x0c,0xbf]

s_bitcmp0_b32 s1, tma_lo
// CHECK: [0x01,0x6e,0x0c,0xbf]

s_bitcmp0_b32 s1, tma_hi
// CHECK: [0x01,0x6f,0x0c,0xbf]

s_bitcmp0_b32 s1, ttmp11
// CHECK: [0x01,0x7b,0x0c,0xbf]

s_bitcmp0_b32 s1, m0
// CHECK: [0x01,0x7c,0x0c,0xbf]

s_bitcmp0_b32 s1, exec_lo
// CHECK: [0x01,0x7e,0x0c,0xbf]

s_bitcmp0_b32 s1, exec_hi
// CHECK: [0x01,0x7f,0x0c,0xbf]

s_bitcmp0_b32 s1, 0
// CHECK: [0x01,0x80,0x0c,0xbf]

s_bitcmp0_b32 s1, -1
// CHECK: [0x01,0xc1,0x0c,0xbf]

s_bitcmp0_b32 s1, 0.5
// CHECK: [0x01,0xf0,0x0c,0xbf]

s_bitcmp0_b32 s1, -4.0
// CHECK: [0x01,0xf7,0x0c,0xbf]

s_bitcmp0_b32 s1, 0xaf123456
// CHECK: [0x01,0xff,0x0c,0xbf,0x56,0x34,0x12,0xaf]

s_bitcmp0_b32 s1, 0x3f717273
// CHECK: [0x01,0xff,0x0c,0xbf,0x73,0x72,0x71,0x3f]

s_bitcmp1_b32 s1, s2
// CHECK: [0x01,0x02,0x0d,0xbf]

s_bitcmp1_b32 s103, s2
// CHECK: [0x67,0x02,0x0d,0xbf]

s_bitcmp1_b32 flat_scratch_lo, s2
// CHECK: [0x68,0x02,0x0d,0xbf]

s_bitcmp1_b32 flat_scratch_hi, s2
// CHECK: [0x69,0x02,0x0d,0xbf]

s_bitcmp1_b32 vcc_lo, s2
// CHECK: [0x6a,0x02,0x0d,0xbf]

s_bitcmp1_b32 vcc_hi, s2
// CHECK: [0x6b,0x02,0x0d,0xbf]

s_bitcmp1_b32 tba_lo, s2
// CHECK: [0x6c,0x02,0x0d,0xbf]

s_bitcmp1_b32 tba_hi, s2
// CHECK: [0x6d,0x02,0x0d,0xbf]

s_bitcmp1_b32 tma_lo, s2
// CHECK: [0x6e,0x02,0x0d,0xbf]

s_bitcmp1_b32 tma_hi, s2
// CHECK: [0x6f,0x02,0x0d,0xbf]

s_bitcmp1_b32 ttmp11, s2
// CHECK: [0x7b,0x02,0x0d,0xbf]

s_bitcmp1_b32 m0, s2
// CHECK: [0x7c,0x02,0x0d,0xbf]

s_bitcmp1_b32 exec_lo, s2
// CHECK: [0x7e,0x02,0x0d,0xbf]

s_bitcmp1_b32 exec_hi, s2
// CHECK: [0x7f,0x02,0x0d,0xbf]

s_bitcmp1_b32 0, s2
// CHECK: [0x80,0x02,0x0d,0xbf]

s_bitcmp1_b32 -1, s2
// CHECK: [0xc1,0x02,0x0d,0xbf]

s_bitcmp1_b32 0.5, s2
// CHECK: [0xf0,0x02,0x0d,0xbf]

s_bitcmp1_b32 -4.0, s2
// CHECK: [0xf7,0x02,0x0d,0xbf]

s_bitcmp1_b32 0xaf123456, s2
// CHECK: [0xff,0x02,0x0d,0xbf,0x56,0x34,0x12,0xaf]

s_bitcmp1_b32 0x3f717273, s2
// CHECK: [0xff,0x02,0x0d,0xbf,0x73,0x72,0x71,0x3f]

s_bitcmp1_b32 s1, s103
// CHECK: [0x01,0x67,0x0d,0xbf]

s_bitcmp1_b32 s1, flat_scratch_lo
// CHECK: [0x01,0x68,0x0d,0xbf]

s_bitcmp1_b32 s1, flat_scratch_hi
// CHECK: [0x01,0x69,0x0d,0xbf]

s_bitcmp1_b32 s1, vcc_lo
// CHECK: [0x01,0x6a,0x0d,0xbf]

s_bitcmp1_b32 s1, vcc_hi
// CHECK: [0x01,0x6b,0x0d,0xbf]

s_bitcmp1_b32 s1, tba_lo
// CHECK: [0x01,0x6c,0x0d,0xbf]

s_bitcmp1_b32 s1, tba_hi
// CHECK: [0x01,0x6d,0x0d,0xbf]

s_bitcmp1_b32 s1, tma_lo
// CHECK: [0x01,0x6e,0x0d,0xbf]

s_bitcmp1_b32 s1, tma_hi
// CHECK: [0x01,0x6f,0x0d,0xbf]

s_bitcmp1_b32 s1, ttmp11
// CHECK: [0x01,0x7b,0x0d,0xbf]

s_bitcmp1_b32 s1, m0
// CHECK: [0x01,0x7c,0x0d,0xbf]

s_bitcmp1_b32 s1, exec_lo
// CHECK: [0x01,0x7e,0x0d,0xbf]

s_bitcmp1_b32 s1, exec_hi
// CHECK: [0x01,0x7f,0x0d,0xbf]

s_bitcmp1_b32 s1, 0
// CHECK: [0x01,0x80,0x0d,0xbf]

s_bitcmp1_b32 s1, -1
// CHECK: [0x01,0xc1,0x0d,0xbf]

s_bitcmp1_b32 s1, 0.5
// CHECK: [0x01,0xf0,0x0d,0xbf]

s_bitcmp1_b32 s1, -4.0
// CHECK: [0x01,0xf7,0x0d,0xbf]

s_bitcmp1_b32 s1, 0xaf123456
// CHECK: [0x01,0xff,0x0d,0xbf,0x56,0x34,0x12,0xaf]

s_bitcmp1_b32 s1, 0x3f717273
// CHECK: [0x01,0xff,0x0d,0xbf,0x73,0x72,0x71,0x3f]

s_bitcmp0_b64 s[2:3], s2
// CHECK: [0x02,0x02,0x0e,0xbf]

s_bitcmp0_b64 s[4:5], s2
// CHECK: [0x04,0x02,0x0e,0xbf]

s_bitcmp0_b64 s[102:103], s2
// CHECK: [0x66,0x02,0x0e,0xbf]

s_bitcmp0_b64 flat_scratch, s2
// CHECK: [0x68,0x02,0x0e,0xbf]

s_bitcmp0_b64 vcc, s2
// CHECK: [0x6a,0x02,0x0e,0xbf]

s_bitcmp0_b64 tba, s2
// CHECK: [0x6c,0x02,0x0e,0xbf]

s_bitcmp0_b64 tma, s2
// CHECK: [0x6e,0x02,0x0e,0xbf]

s_bitcmp0_b64 ttmp[10:11], s2
// CHECK: [0x7a,0x02,0x0e,0xbf]

s_bitcmp0_b64 exec, s2
// CHECK: [0x7e,0x02,0x0e,0xbf]

s_bitcmp0_b64 0, s2
// CHECK: [0x80,0x02,0x0e,0xbf]

s_bitcmp0_b64 -1, s2
// CHECK: [0xc1,0x02,0x0e,0xbf]

s_bitcmp0_b64 0.5, s2
// CHECK: [0xf0,0x02,0x0e,0xbf]

s_bitcmp0_b64 -4.0, s2
// CHECK: [0xf7,0x02,0x0e,0xbf]

s_bitcmp0_b64 0xaf123456, s2
// CHECK: [0xff,0x02,0x0e,0xbf,0x56,0x34,0x12,0xaf]

s_bitcmp0_b64 0x3f717273, s2
// CHECK: [0xff,0x02,0x0e,0xbf,0x73,0x72,0x71,0x3f]

s_bitcmp0_b64 s[2:3], s103
// CHECK: [0x02,0x67,0x0e,0xbf]

s_bitcmp0_b64 s[2:3], flat_scratch_lo
// CHECK: [0x02,0x68,0x0e,0xbf]

s_bitcmp0_b64 s[2:3], flat_scratch_hi
// CHECK: [0x02,0x69,0x0e,0xbf]

s_bitcmp0_b64 s[2:3], vcc_lo
// CHECK: [0x02,0x6a,0x0e,0xbf]

s_bitcmp0_b64 s[2:3], vcc_hi
// CHECK: [0x02,0x6b,0x0e,0xbf]

s_bitcmp0_b64 s[2:3], tba_lo
// CHECK: [0x02,0x6c,0x0e,0xbf]

s_bitcmp0_b64 s[2:3], tba_hi
// CHECK: [0x02,0x6d,0x0e,0xbf]

s_bitcmp0_b64 s[2:3], tma_lo
// CHECK: [0x02,0x6e,0x0e,0xbf]

s_bitcmp0_b64 s[2:3], tma_hi
// CHECK: [0x02,0x6f,0x0e,0xbf]

s_bitcmp0_b64 s[2:3], ttmp11
// CHECK: [0x02,0x7b,0x0e,0xbf]

s_bitcmp0_b64 s[2:3], m0
// CHECK: [0x02,0x7c,0x0e,0xbf]

s_bitcmp0_b64 s[2:3], exec_lo
// CHECK: [0x02,0x7e,0x0e,0xbf]

s_bitcmp0_b64 s[2:3], exec_hi
// CHECK: [0x02,0x7f,0x0e,0xbf]

s_bitcmp0_b64 s[2:3], 0
// CHECK: [0x02,0x80,0x0e,0xbf]

s_bitcmp0_b64 s[2:3], -1
// CHECK: [0x02,0xc1,0x0e,0xbf]

s_bitcmp0_b64 s[2:3], 0.5
// CHECK: [0x02,0xf0,0x0e,0xbf]

s_bitcmp0_b64 s[2:3], -4.0
// CHECK: [0x02,0xf7,0x0e,0xbf]

s_bitcmp0_b64 s[2:3], 0xaf123456
// CHECK: [0x02,0xff,0x0e,0xbf,0x56,0x34,0x12,0xaf]

s_bitcmp0_b64 s[2:3], 0x3f717273
// CHECK: [0x02,0xff,0x0e,0xbf,0x73,0x72,0x71,0x3f]

s_bitcmp1_b64 s[2:3], s2
// CHECK: [0x02,0x02,0x0f,0xbf]

s_bitcmp1_b64 s[4:5], s2
// CHECK: [0x04,0x02,0x0f,0xbf]

s_bitcmp1_b64 s[102:103], s2
// CHECK: [0x66,0x02,0x0f,0xbf]

s_bitcmp1_b64 flat_scratch, s2
// CHECK: [0x68,0x02,0x0f,0xbf]

s_bitcmp1_b64 vcc, s2
// CHECK: [0x6a,0x02,0x0f,0xbf]

s_bitcmp1_b64 tba, s2
// CHECK: [0x6c,0x02,0x0f,0xbf]

s_bitcmp1_b64 tma, s2
// CHECK: [0x6e,0x02,0x0f,0xbf]

s_bitcmp1_b64 ttmp[10:11], s2
// CHECK: [0x7a,0x02,0x0f,0xbf]

s_bitcmp1_b64 exec, s2
// CHECK: [0x7e,0x02,0x0f,0xbf]

s_bitcmp1_b64 0, s2
// CHECK: [0x80,0x02,0x0f,0xbf]

s_bitcmp1_b64 -1, s2
// CHECK: [0xc1,0x02,0x0f,0xbf]

s_bitcmp1_b64 0.5, s2
// CHECK: [0xf0,0x02,0x0f,0xbf]

s_bitcmp1_b64 -4.0, s2
// CHECK: [0xf7,0x02,0x0f,0xbf]

s_bitcmp1_b64 0xaf123456, s2
// CHECK: [0xff,0x02,0x0f,0xbf,0x56,0x34,0x12,0xaf]

s_bitcmp1_b64 0x3f717273, s2
// CHECK: [0xff,0x02,0x0f,0xbf,0x73,0x72,0x71,0x3f]

s_bitcmp1_b64 s[2:3], s103
// CHECK: [0x02,0x67,0x0f,0xbf]

s_bitcmp1_b64 s[2:3], flat_scratch_lo
// CHECK: [0x02,0x68,0x0f,0xbf]

s_bitcmp1_b64 s[2:3], flat_scratch_hi
// CHECK: [0x02,0x69,0x0f,0xbf]

s_bitcmp1_b64 s[2:3], vcc_lo
// CHECK: [0x02,0x6a,0x0f,0xbf]

s_bitcmp1_b64 s[2:3], vcc_hi
// CHECK: [0x02,0x6b,0x0f,0xbf]

s_bitcmp1_b64 s[2:3], tba_lo
// CHECK: [0x02,0x6c,0x0f,0xbf]

s_bitcmp1_b64 s[2:3], tba_hi
// CHECK: [0x02,0x6d,0x0f,0xbf]

s_bitcmp1_b64 s[2:3], tma_lo
// CHECK: [0x02,0x6e,0x0f,0xbf]

s_bitcmp1_b64 s[2:3], tma_hi
// CHECK: [0x02,0x6f,0x0f,0xbf]

s_bitcmp1_b64 s[2:3], ttmp11
// CHECK: [0x02,0x7b,0x0f,0xbf]

s_bitcmp1_b64 s[2:3], m0
// CHECK: [0x02,0x7c,0x0f,0xbf]

s_bitcmp1_b64 s[2:3], exec_lo
// CHECK: [0x02,0x7e,0x0f,0xbf]

s_bitcmp1_b64 s[2:3], exec_hi
// CHECK: [0x02,0x7f,0x0f,0xbf]

s_bitcmp1_b64 s[2:3], 0
// CHECK: [0x02,0x80,0x0f,0xbf]

s_bitcmp1_b64 s[2:3], -1
// CHECK: [0x02,0xc1,0x0f,0xbf]

s_bitcmp1_b64 s[2:3], 0.5
// CHECK: [0x02,0xf0,0x0f,0xbf]

s_bitcmp1_b64 s[2:3], -4.0
// CHECK: [0x02,0xf7,0x0f,0xbf]

s_bitcmp1_b64 s[2:3], 0xaf123456
// CHECK: [0x02,0xff,0x0f,0xbf,0x56,0x34,0x12,0xaf]

s_bitcmp1_b64 s[2:3], 0x3f717273
// CHECK: [0x02,0xff,0x0f,0xbf,0x73,0x72,0x71,0x3f]

s_setvskip s1, s2
// CHECK: [0x01,0x02,0x10,0xbf]

s_setvskip s103, s2
// CHECK: [0x67,0x02,0x10,0xbf]

s_setvskip flat_scratch_lo, s2
// CHECK: [0x68,0x02,0x10,0xbf]

s_setvskip flat_scratch_hi, s2
// CHECK: [0x69,0x02,0x10,0xbf]

s_setvskip vcc_lo, s2
// CHECK: [0x6a,0x02,0x10,0xbf]

s_setvskip vcc_hi, s2
// CHECK: [0x6b,0x02,0x10,0xbf]

s_setvskip tba_lo, s2
// CHECK: [0x6c,0x02,0x10,0xbf]

s_setvskip tba_hi, s2
// CHECK: [0x6d,0x02,0x10,0xbf]

s_setvskip tma_lo, s2
// CHECK: [0x6e,0x02,0x10,0xbf]

s_setvskip tma_hi, s2
// CHECK: [0x6f,0x02,0x10,0xbf]

s_setvskip ttmp11, s2
// CHECK: [0x7b,0x02,0x10,0xbf]

s_setvskip m0, s2
// CHECK: [0x7c,0x02,0x10,0xbf]

s_setvskip exec_lo, s2
// CHECK: [0x7e,0x02,0x10,0xbf]

s_setvskip exec_hi, s2
// CHECK: [0x7f,0x02,0x10,0xbf]

s_setvskip 0, s2
// CHECK: [0x80,0x02,0x10,0xbf]

s_setvskip -1, s2
// CHECK: [0xc1,0x02,0x10,0xbf]

s_setvskip 0.5, s2
// CHECK: [0xf0,0x02,0x10,0xbf]

s_setvskip -4.0, s2
// CHECK: [0xf7,0x02,0x10,0xbf]

s_setvskip 0xaf123456, s2
// CHECK: [0xff,0x02,0x10,0xbf,0x56,0x34,0x12,0xaf]

s_setvskip 0x3f717273, s2
// CHECK: [0xff,0x02,0x10,0xbf,0x73,0x72,0x71,0x3f]

s_setvskip s1, s103
// CHECK: [0x01,0x67,0x10,0xbf]

s_setvskip s1, flat_scratch_lo
// CHECK: [0x01,0x68,0x10,0xbf]

s_setvskip s1, flat_scratch_hi
// CHECK: [0x01,0x69,0x10,0xbf]

s_setvskip s1, vcc_lo
// CHECK: [0x01,0x6a,0x10,0xbf]

s_setvskip s1, vcc_hi
// CHECK: [0x01,0x6b,0x10,0xbf]

s_setvskip s1, tba_lo
// CHECK: [0x01,0x6c,0x10,0xbf]

s_setvskip s1, tba_hi
// CHECK: [0x01,0x6d,0x10,0xbf]

s_setvskip s1, tma_lo
// CHECK: [0x01,0x6e,0x10,0xbf]

s_setvskip s1, tma_hi
// CHECK: [0x01,0x6f,0x10,0xbf]

s_setvskip s1, ttmp11
// CHECK: [0x01,0x7b,0x10,0xbf]

s_setvskip s1, m0
// CHECK: [0x01,0x7c,0x10,0xbf]

s_setvskip s1, exec_lo
// CHECK: [0x01,0x7e,0x10,0xbf]

s_setvskip s1, exec_hi
// CHECK: [0x01,0x7f,0x10,0xbf]

s_setvskip s1, 0
// CHECK: [0x01,0x80,0x10,0xbf]

s_setvskip s1, -1
// CHECK: [0x01,0xc1,0x10,0xbf]

s_setvskip s1, 0.5
// CHECK: [0x01,0xf0,0x10,0xbf]

s_setvskip s1, -4.0
// CHECK: [0x01,0xf7,0x10,0xbf]

s_setvskip s1, 0xaf123456
// CHECK: [0x01,0xff,0x10,0xbf,0x56,0x34,0x12,0xaf]

s_setvskip s1, 0x3f717273
// CHECK: [0x01,0xff,0x10,0xbf,0x73,0x72,0x71,0x3f]

s_movk_i32 s5, 0x3141
// CHECK: [0x41,0x31,0x05,0xb0]

s_movk_i32 s103, 0x3141
// CHECK: [0x41,0x31,0x67,0xb0]

s_movk_i32 flat_scratch_lo, 0x3141
// CHECK: [0x41,0x31,0x68,0xb0]

s_movk_i32 flat_scratch_hi, 0x3141
// CHECK: [0x41,0x31,0x69,0xb0]

s_movk_i32 vcc_lo, 0x3141
// CHECK: [0x41,0x31,0x6a,0xb0]

s_movk_i32 vcc_hi, 0x3141
// CHECK: [0x41,0x31,0x6b,0xb0]

s_movk_i32 tba_lo, 0x3141
// CHECK: [0x41,0x31,0x6c,0xb0]

s_movk_i32 tba_hi, 0x3141
// CHECK: [0x41,0x31,0x6d,0xb0]

s_movk_i32 tma_lo, 0x3141
// CHECK: [0x41,0x31,0x6e,0xb0]

s_movk_i32 tma_hi, 0x3141
// CHECK: [0x41,0x31,0x6f,0xb0]

s_movk_i32 ttmp11, 0x3141
// CHECK: [0x41,0x31,0x7b,0xb0]

s_movk_i32 m0, 0x3141
// CHECK: [0x41,0x31,0x7c,0xb0]

s_movk_i32 exec_lo, 0x3141
// CHECK: [0x41,0x31,0x7e,0xb0]

s_movk_i32 exec_hi, 0x3141
// CHECK: [0x41,0x31,0x7f,0xb0]

s_movk_i32 s5, 0xc1d1
// CHECK: [0xd1,0xc1,0x05,0xb0]

s_cmovk_i32 s5, 0x3141
// CHECK: [0x41,0x31,0x05,0xb1]

s_cmovk_i32 s103, 0x3141
// CHECK: [0x41,0x31,0x67,0xb1]

s_cmovk_i32 flat_scratch_lo, 0x3141
// CHECK: [0x41,0x31,0x68,0xb1]

s_cmovk_i32 flat_scratch_hi, 0x3141
// CHECK: [0x41,0x31,0x69,0xb1]

s_cmovk_i32 vcc_lo, 0x3141
// CHECK: [0x41,0x31,0x6a,0xb1]

s_cmovk_i32 vcc_hi, 0x3141
// CHECK: [0x41,0x31,0x6b,0xb1]

s_cmovk_i32 tba_lo, 0x3141
// CHECK: [0x41,0x31,0x6c,0xb1]

s_cmovk_i32 tba_hi, 0x3141
// CHECK: [0x41,0x31,0x6d,0xb1]

s_cmovk_i32 tma_lo, 0x3141
// CHECK: [0x41,0x31,0x6e,0xb1]

s_cmovk_i32 tma_hi, 0x3141
// CHECK: [0x41,0x31,0x6f,0xb1]

s_cmovk_i32 ttmp11, 0x3141
// CHECK: [0x41,0x31,0x7b,0xb1]

s_cmovk_i32 m0, 0x3141
// CHECK: [0x41,0x31,0x7c,0xb1]

s_cmovk_i32 exec_lo, 0x3141
// CHECK: [0x41,0x31,0x7e,0xb1]

s_cmovk_i32 exec_hi, 0x3141
// CHECK: [0x41,0x31,0x7f,0xb1]

s_cmovk_i32 s5, 0xc1d1
// CHECK: [0xd1,0xc1,0x05,0xb1]

s_cmpk_eq_i32 s1, 0x3141
// CHECK: [0x41,0x31,0x81,0xb1]

s_cmpk_eq_i32 s103, 0x3141
// CHECK: [0x41,0x31,0xe7,0xb1]

s_cmpk_eq_i32 flat_scratch_lo, 0x3141
// CHECK: [0x41,0x31,0xe8,0xb1]

s_cmpk_eq_i32 flat_scratch_hi, 0x3141
// CHECK: [0x41,0x31,0xe9,0xb1]

s_cmpk_eq_i32 vcc_lo, 0x3141
// CHECK: [0x41,0x31,0xea,0xb1]

s_cmpk_eq_i32 vcc_hi, 0x3141
// CHECK: [0x41,0x31,0xeb,0xb1]

s_cmpk_eq_i32 tba_lo, 0x3141
// CHECK: [0x41,0x31,0xec,0xb1]

s_cmpk_eq_i32 tba_hi, 0x3141
// CHECK: [0x41,0x31,0xed,0xb1]

s_cmpk_eq_i32 tma_lo, 0x3141
// CHECK: [0x41,0x31,0xee,0xb1]

s_cmpk_eq_i32 tma_hi, 0x3141
// CHECK: [0x41,0x31,0xef,0xb1]

s_cmpk_eq_i32 ttmp11, 0x3141
// CHECK: [0x41,0x31,0xfb,0xb1]

s_cmpk_eq_i32 m0, 0x3141
// CHECK: [0x41,0x31,0xfc,0xb1]

s_cmpk_eq_i32 exec_lo, 0x3141
// CHECK: [0x41,0x31,0xfe,0xb1]

s_cmpk_eq_i32 exec_hi, 0x3141
// CHECK: [0x41,0x31,0xff,0xb1]

s_cmpk_eq_i32 s1, 0xc1d1
// CHECK: [0xd1,0xc1,0x81,0xb1]

s_cmpk_lg_i32 s1, 0x3141
// CHECK: [0x41,0x31,0x01,0xb2]

s_cmpk_lg_i32 s103, 0x3141
// CHECK: [0x41,0x31,0x67,0xb2]

s_cmpk_lg_i32 flat_scratch_lo, 0x3141
// CHECK: [0x41,0x31,0x68,0xb2]

s_cmpk_lg_i32 flat_scratch_hi, 0x3141
// CHECK: [0x41,0x31,0x69,0xb2]

s_cmpk_lg_i32 vcc_lo, 0x3141
// CHECK: [0x41,0x31,0x6a,0xb2]

s_cmpk_lg_i32 vcc_hi, 0x3141
// CHECK: [0x41,0x31,0x6b,0xb2]

s_cmpk_lg_i32 tba_lo, 0x3141
// CHECK: [0x41,0x31,0x6c,0xb2]

s_cmpk_lg_i32 tba_hi, 0x3141
// CHECK: [0x41,0x31,0x6d,0xb2]

s_cmpk_lg_i32 tma_lo, 0x3141
// CHECK: [0x41,0x31,0x6e,0xb2]

s_cmpk_lg_i32 tma_hi, 0x3141
// CHECK: [0x41,0x31,0x6f,0xb2]

s_cmpk_lg_i32 ttmp11, 0x3141
// CHECK: [0x41,0x31,0x7b,0xb2]

s_cmpk_lg_i32 m0, 0x3141
// CHECK: [0x41,0x31,0x7c,0xb2]

s_cmpk_lg_i32 exec_lo, 0x3141
// CHECK: [0x41,0x31,0x7e,0xb2]

s_cmpk_lg_i32 exec_hi, 0x3141
// CHECK: [0x41,0x31,0x7f,0xb2]

s_cmpk_lg_i32 s1, 0xc1d1
// CHECK: [0xd1,0xc1,0x01,0xb2]

s_cmpk_gt_i32 s1, 0x3141
// CHECK: [0x41,0x31,0x81,0xb2]

s_cmpk_gt_i32 s103, 0x3141
// CHECK: [0x41,0x31,0xe7,0xb2]

s_cmpk_gt_i32 flat_scratch_lo, 0x3141
// CHECK: [0x41,0x31,0xe8,0xb2]

s_cmpk_gt_i32 flat_scratch_hi, 0x3141
// CHECK: [0x41,0x31,0xe9,0xb2]

s_cmpk_gt_i32 vcc_lo, 0x3141
// CHECK: [0x41,0x31,0xea,0xb2]

s_cmpk_gt_i32 vcc_hi, 0x3141
// CHECK: [0x41,0x31,0xeb,0xb2]

s_cmpk_gt_i32 tba_lo, 0x3141
// CHECK: [0x41,0x31,0xec,0xb2]

s_cmpk_gt_i32 tba_hi, 0x3141
// CHECK: [0x41,0x31,0xed,0xb2]

s_cmpk_gt_i32 tma_lo, 0x3141
// CHECK: [0x41,0x31,0xee,0xb2]

s_cmpk_gt_i32 tma_hi, 0x3141
// CHECK: [0x41,0x31,0xef,0xb2]

s_cmpk_gt_i32 ttmp11, 0x3141
// CHECK: [0x41,0x31,0xfb,0xb2]

s_cmpk_gt_i32 m0, 0x3141
// CHECK: [0x41,0x31,0xfc,0xb2]

s_cmpk_gt_i32 exec_lo, 0x3141
// CHECK: [0x41,0x31,0xfe,0xb2]

s_cmpk_gt_i32 exec_hi, 0x3141
// CHECK: [0x41,0x31,0xff,0xb2]

s_cmpk_gt_i32 s1, 0xc1d1
// CHECK: [0xd1,0xc1,0x81,0xb2]

s_cmpk_ge_i32 s1, 0x3141
// CHECK: [0x41,0x31,0x01,0xb3]

s_cmpk_ge_i32 s103, 0x3141
// CHECK: [0x41,0x31,0x67,0xb3]

s_cmpk_ge_i32 flat_scratch_lo, 0x3141
// CHECK: [0x41,0x31,0x68,0xb3]

s_cmpk_ge_i32 flat_scratch_hi, 0x3141
// CHECK: [0x41,0x31,0x69,0xb3]

s_cmpk_ge_i32 vcc_lo, 0x3141
// CHECK: [0x41,0x31,0x6a,0xb3]

s_cmpk_ge_i32 vcc_hi, 0x3141
// CHECK: [0x41,0x31,0x6b,0xb3]

s_cmpk_ge_i32 tba_lo, 0x3141
// CHECK: [0x41,0x31,0x6c,0xb3]

s_cmpk_ge_i32 tba_hi, 0x3141
// CHECK: [0x41,0x31,0x6d,0xb3]

s_cmpk_ge_i32 tma_lo, 0x3141
// CHECK: [0x41,0x31,0x6e,0xb3]

s_cmpk_ge_i32 tma_hi, 0x3141
// CHECK: [0x41,0x31,0x6f,0xb3]

s_cmpk_ge_i32 ttmp11, 0x3141
// CHECK: [0x41,0x31,0x7b,0xb3]

s_cmpk_ge_i32 m0, 0x3141
// CHECK: [0x41,0x31,0x7c,0xb3]

s_cmpk_ge_i32 exec_lo, 0x3141
// CHECK: [0x41,0x31,0x7e,0xb3]

s_cmpk_ge_i32 exec_hi, 0x3141
// CHECK: [0x41,0x31,0x7f,0xb3]

s_cmpk_ge_i32 s1, 0xc1d1
// CHECK: [0xd1,0xc1,0x01,0xb3]

s_cmpk_lt_i32 s1, 0x3141
// CHECK: [0x41,0x31,0x81,0xb3]

s_cmpk_lt_i32 s103, 0x3141
// CHECK: [0x41,0x31,0xe7,0xb3]

s_cmpk_lt_i32 flat_scratch_lo, 0x3141
// CHECK: [0x41,0x31,0xe8,0xb3]

s_cmpk_lt_i32 flat_scratch_hi, 0x3141
// CHECK: [0x41,0x31,0xe9,0xb3]

s_cmpk_lt_i32 vcc_lo, 0x3141
// CHECK: [0x41,0x31,0xea,0xb3]

s_cmpk_lt_i32 vcc_hi, 0x3141
// CHECK: [0x41,0x31,0xeb,0xb3]

s_cmpk_lt_i32 tba_lo, 0x3141
// CHECK: [0x41,0x31,0xec,0xb3]

s_cmpk_lt_i32 tba_hi, 0x3141
// CHECK: [0x41,0x31,0xed,0xb3]

s_cmpk_lt_i32 tma_lo, 0x3141
// CHECK: [0x41,0x31,0xee,0xb3]

s_cmpk_lt_i32 tma_hi, 0x3141
// CHECK: [0x41,0x31,0xef,0xb3]

s_cmpk_lt_i32 ttmp11, 0x3141
// CHECK: [0x41,0x31,0xfb,0xb3]

s_cmpk_lt_i32 m0, 0x3141
// CHECK: [0x41,0x31,0xfc,0xb3]

s_cmpk_lt_i32 exec_lo, 0x3141
// CHECK: [0x41,0x31,0xfe,0xb3]

s_cmpk_lt_i32 exec_hi, 0x3141
// CHECK: [0x41,0x31,0xff,0xb3]

s_cmpk_lt_i32 s1, 0xc1d1
// CHECK: [0xd1,0xc1,0x81,0xb3]

s_cmpk_le_i32 s1, 0x3141
// CHECK: [0x41,0x31,0x01,0xb4]

s_cmpk_le_i32 s103, 0x3141
// CHECK: [0x41,0x31,0x67,0xb4]

s_cmpk_le_i32 flat_scratch_lo, 0x3141
// CHECK: [0x41,0x31,0x68,0xb4]

s_cmpk_le_i32 flat_scratch_hi, 0x3141
// CHECK: [0x41,0x31,0x69,0xb4]

s_cmpk_le_i32 vcc_lo, 0x3141
// CHECK: [0x41,0x31,0x6a,0xb4]

s_cmpk_le_i32 vcc_hi, 0x3141
// CHECK: [0x41,0x31,0x6b,0xb4]

s_cmpk_le_i32 tba_lo, 0x3141
// CHECK: [0x41,0x31,0x6c,0xb4]

s_cmpk_le_i32 tba_hi, 0x3141
// CHECK: [0x41,0x31,0x6d,0xb4]

s_cmpk_le_i32 tma_lo, 0x3141
// CHECK: [0x41,0x31,0x6e,0xb4]

s_cmpk_le_i32 tma_hi, 0x3141
// CHECK: [0x41,0x31,0x6f,0xb4]

s_cmpk_le_i32 ttmp11, 0x3141
// CHECK: [0x41,0x31,0x7b,0xb4]

s_cmpk_le_i32 m0, 0x3141
// CHECK: [0x41,0x31,0x7c,0xb4]

s_cmpk_le_i32 exec_lo, 0x3141
// CHECK: [0x41,0x31,0x7e,0xb4]

s_cmpk_le_i32 exec_hi, 0x3141
// CHECK: [0x41,0x31,0x7f,0xb4]

s_cmpk_le_i32 s1, 0xc1d1
// CHECK: [0xd1,0xc1,0x01,0xb4]

s_cmpk_eq_u32 s1, 0x3141
// CHECK: [0x41,0x31,0x81,0xb4]

s_cmpk_eq_u32 s103, 0x3141
// CHECK: [0x41,0x31,0xe7,0xb4]

s_cmpk_eq_u32 flat_scratch_lo, 0x3141
// CHECK: [0x41,0x31,0xe8,0xb4]

s_cmpk_eq_u32 flat_scratch_hi, 0x3141
// CHECK: [0x41,0x31,0xe9,0xb4]

s_cmpk_eq_u32 vcc_lo, 0x3141
// CHECK: [0x41,0x31,0xea,0xb4]

s_cmpk_eq_u32 vcc_hi, 0x3141
// CHECK: [0x41,0x31,0xeb,0xb4]

s_cmpk_eq_u32 tba_lo, 0x3141
// CHECK: [0x41,0x31,0xec,0xb4]

s_cmpk_eq_u32 tba_hi, 0x3141
// CHECK: [0x41,0x31,0xed,0xb4]

s_cmpk_eq_u32 tma_lo, 0x3141
// CHECK: [0x41,0x31,0xee,0xb4]

s_cmpk_eq_u32 tma_hi, 0x3141
// CHECK: [0x41,0x31,0xef,0xb4]

s_cmpk_eq_u32 ttmp11, 0x3141
// CHECK: [0x41,0x31,0xfb,0xb4]

s_cmpk_eq_u32 m0, 0x3141
// CHECK: [0x41,0x31,0xfc,0xb4]

s_cmpk_eq_u32 exec_lo, 0x3141
// CHECK: [0x41,0x31,0xfe,0xb4]

s_cmpk_eq_u32 exec_hi, 0x3141
// CHECK: [0x41,0x31,0xff,0xb4]

s_cmpk_eq_u32 s1, 0xc1d1
// CHECK: [0xd1,0xc1,0x81,0xb4]

s_cmpk_lg_u32 s1, 0x3141
// CHECK: [0x41,0x31,0x01,0xb5]

s_cmpk_lg_u32 s103, 0x3141
// CHECK: [0x41,0x31,0x67,0xb5]

s_cmpk_lg_u32 flat_scratch_lo, 0x3141
// CHECK: [0x41,0x31,0x68,0xb5]

s_cmpk_lg_u32 flat_scratch_hi, 0x3141
// CHECK: [0x41,0x31,0x69,0xb5]

s_cmpk_lg_u32 vcc_lo, 0x3141
// CHECK: [0x41,0x31,0x6a,0xb5]

s_cmpk_lg_u32 vcc_hi, 0x3141
// CHECK: [0x41,0x31,0x6b,0xb5]

s_cmpk_lg_u32 tba_lo, 0x3141
// CHECK: [0x41,0x31,0x6c,0xb5]

s_cmpk_lg_u32 tba_hi, 0x3141
// CHECK: [0x41,0x31,0x6d,0xb5]

s_cmpk_lg_u32 tma_lo, 0x3141
// CHECK: [0x41,0x31,0x6e,0xb5]

s_cmpk_lg_u32 tma_hi, 0x3141
// CHECK: [0x41,0x31,0x6f,0xb5]

s_cmpk_lg_u32 ttmp11, 0x3141
// CHECK: [0x41,0x31,0x7b,0xb5]

s_cmpk_lg_u32 m0, 0x3141
// CHECK: [0x41,0x31,0x7c,0xb5]

s_cmpk_lg_u32 exec_lo, 0x3141
// CHECK: [0x41,0x31,0x7e,0xb5]

s_cmpk_lg_u32 exec_hi, 0x3141
// CHECK: [0x41,0x31,0x7f,0xb5]

s_cmpk_lg_u32 s1, 0xc1d1
// CHECK: [0xd1,0xc1,0x01,0xb5]

s_cmpk_gt_u32 s1, 0x3141
// CHECK: [0x41,0x31,0x81,0xb5]

s_cmpk_gt_u32 s103, 0x3141
// CHECK: [0x41,0x31,0xe7,0xb5]

s_cmpk_gt_u32 flat_scratch_lo, 0x3141
// CHECK: [0x41,0x31,0xe8,0xb5]

s_cmpk_gt_u32 flat_scratch_hi, 0x3141
// CHECK: [0x41,0x31,0xe9,0xb5]

s_cmpk_gt_u32 vcc_lo, 0x3141
// CHECK: [0x41,0x31,0xea,0xb5]

s_cmpk_gt_u32 vcc_hi, 0x3141
// CHECK: [0x41,0x31,0xeb,0xb5]

s_cmpk_gt_u32 tba_lo, 0x3141
// CHECK: [0x41,0x31,0xec,0xb5]

s_cmpk_gt_u32 tba_hi, 0x3141
// CHECK: [0x41,0x31,0xed,0xb5]

s_cmpk_gt_u32 tma_lo, 0x3141
// CHECK: [0x41,0x31,0xee,0xb5]

s_cmpk_gt_u32 tma_hi, 0x3141
// CHECK: [0x41,0x31,0xef,0xb5]

s_cmpk_gt_u32 ttmp11, 0x3141
// CHECK: [0x41,0x31,0xfb,0xb5]

s_cmpk_gt_u32 m0, 0x3141
// CHECK: [0x41,0x31,0xfc,0xb5]

s_cmpk_gt_u32 exec_lo, 0x3141
// CHECK: [0x41,0x31,0xfe,0xb5]

s_cmpk_gt_u32 exec_hi, 0x3141
// CHECK: [0x41,0x31,0xff,0xb5]

s_cmpk_gt_u32 s1, 0xc1d1
// CHECK: [0xd1,0xc1,0x81,0xb5]

s_cmpk_ge_u32 s1, 0x3141
// CHECK: [0x41,0x31,0x01,0xb6]

s_cmpk_ge_u32 s103, 0x3141
// CHECK: [0x41,0x31,0x67,0xb6]

s_cmpk_ge_u32 flat_scratch_lo, 0x3141
// CHECK: [0x41,0x31,0x68,0xb6]

s_cmpk_ge_u32 flat_scratch_hi, 0x3141
// CHECK: [0x41,0x31,0x69,0xb6]

s_cmpk_ge_u32 vcc_lo, 0x3141
// CHECK: [0x41,0x31,0x6a,0xb6]

s_cmpk_ge_u32 vcc_hi, 0x3141
// CHECK: [0x41,0x31,0x6b,0xb6]

s_cmpk_ge_u32 tba_lo, 0x3141
// CHECK: [0x41,0x31,0x6c,0xb6]

s_cmpk_ge_u32 tba_hi, 0x3141
// CHECK: [0x41,0x31,0x6d,0xb6]

s_cmpk_ge_u32 tma_lo, 0x3141
// CHECK: [0x41,0x31,0x6e,0xb6]

s_cmpk_ge_u32 tma_hi, 0x3141
// CHECK: [0x41,0x31,0x6f,0xb6]

s_cmpk_ge_u32 ttmp11, 0x3141
// CHECK: [0x41,0x31,0x7b,0xb6]

s_cmpk_ge_u32 m0, 0x3141
// CHECK: [0x41,0x31,0x7c,0xb6]

s_cmpk_ge_u32 exec_lo, 0x3141
// CHECK: [0x41,0x31,0x7e,0xb6]

s_cmpk_ge_u32 exec_hi, 0x3141
// CHECK: [0x41,0x31,0x7f,0xb6]

s_cmpk_ge_u32 s1, 0xc1d1
// CHECK: [0xd1,0xc1,0x01,0xb6]

s_cmpk_lt_u32 s1, 0x3141
// CHECK: [0x41,0x31,0x81,0xb6]

s_cmpk_lt_u32 s103, 0x3141
// CHECK: [0x41,0x31,0xe7,0xb6]

s_cmpk_lt_u32 flat_scratch_lo, 0x3141
// CHECK: [0x41,0x31,0xe8,0xb6]

s_cmpk_lt_u32 flat_scratch_hi, 0x3141
// CHECK: [0x41,0x31,0xe9,0xb6]

s_cmpk_lt_u32 vcc_lo, 0x3141
// CHECK: [0x41,0x31,0xea,0xb6]

s_cmpk_lt_u32 vcc_hi, 0x3141
// CHECK: [0x41,0x31,0xeb,0xb6]

s_cmpk_lt_u32 tba_lo, 0x3141
// CHECK: [0x41,0x31,0xec,0xb6]

s_cmpk_lt_u32 tba_hi, 0x3141
// CHECK: [0x41,0x31,0xed,0xb6]

s_cmpk_lt_u32 tma_lo, 0x3141
// CHECK: [0x41,0x31,0xee,0xb6]

s_cmpk_lt_u32 tma_hi, 0x3141
// CHECK: [0x41,0x31,0xef,0xb6]

s_cmpk_lt_u32 ttmp11, 0x3141
// CHECK: [0x41,0x31,0xfb,0xb6]

s_cmpk_lt_u32 m0, 0x3141
// CHECK: [0x41,0x31,0xfc,0xb6]

s_cmpk_lt_u32 exec_lo, 0x3141
// CHECK: [0x41,0x31,0xfe,0xb6]

s_cmpk_lt_u32 exec_hi, 0x3141
// CHECK: [0x41,0x31,0xff,0xb6]

s_cmpk_lt_u32 s1, 0xc1d1
// CHECK: [0xd1,0xc1,0x81,0xb6]

s_cmpk_le_u32 s1, 0x3141
// CHECK: [0x41,0x31,0x01,0xb7]

s_cmpk_le_u32 s103, 0x3141
// CHECK: [0x41,0x31,0x67,0xb7]

s_cmpk_le_u32 flat_scratch_lo, 0x3141
// CHECK: [0x41,0x31,0x68,0xb7]

s_cmpk_le_u32 flat_scratch_hi, 0x3141
// CHECK: [0x41,0x31,0x69,0xb7]

s_cmpk_le_u32 vcc_lo, 0x3141
// CHECK: [0x41,0x31,0x6a,0xb7]

s_cmpk_le_u32 vcc_hi, 0x3141
// CHECK: [0x41,0x31,0x6b,0xb7]

s_cmpk_le_u32 tba_lo, 0x3141
// CHECK: [0x41,0x31,0x6c,0xb7]

s_cmpk_le_u32 tba_hi, 0x3141
// CHECK: [0x41,0x31,0x6d,0xb7]

s_cmpk_le_u32 tma_lo, 0x3141
// CHECK: [0x41,0x31,0x6e,0xb7]

s_cmpk_le_u32 tma_hi, 0x3141
// CHECK: [0x41,0x31,0x6f,0xb7]

s_cmpk_le_u32 ttmp11, 0x3141
// CHECK: [0x41,0x31,0x7b,0xb7]

s_cmpk_le_u32 m0, 0x3141
// CHECK: [0x41,0x31,0x7c,0xb7]

s_cmpk_le_u32 exec_lo, 0x3141
// CHECK: [0x41,0x31,0x7e,0xb7]

s_cmpk_le_u32 exec_hi, 0x3141
// CHECK: [0x41,0x31,0x7f,0xb7]

s_cmpk_le_u32 s1, 0xc1d1
// CHECK: [0xd1,0xc1,0x01,0xb7]

s_addk_i32 s5, 0x3141
// CHECK: [0x41,0x31,0x85,0xb7]

s_addk_i32 s103, 0x3141
// CHECK: [0x41,0x31,0xe7,0xb7]

s_addk_i32 flat_scratch_lo, 0x3141
// CHECK: [0x41,0x31,0xe8,0xb7]

s_addk_i32 flat_scratch_hi, 0x3141
// CHECK: [0x41,0x31,0xe9,0xb7]

s_addk_i32 vcc_lo, 0x3141
// CHECK: [0x41,0x31,0xea,0xb7]

s_addk_i32 vcc_hi, 0x3141
// CHECK: [0x41,0x31,0xeb,0xb7]

s_addk_i32 tba_lo, 0x3141
// CHECK: [0x41,0x31,0xec,0xb7]

s_addk_i32 tba_hi, 0x3141
// CHECK: [0x41,0x31,0xed,0xb7]

s_addk_i32 tma_lo, 0x3141
// CHECK: [0x41,0x31,0xee,0xb7]

s_addk_i32 tma_hi, 0x3141
// CHECK: [0x41,0x31,0xef,0xb7]

s_addk_i32 ttmp11, 0x3141
// CHECK: [0x41,0x31,0xfb,0xb7]

s_addk_i32 m0, 0x3141
// CHECK: [0x41,0x31,0xfc,0xb7]

s_addk_i32 exec_lo, 0x3141
// CHECK: [0x41,0x31,0xfe,0xb7]

s_addk_i32 exec_hi, 0x3141
// CHECK: [0x41,0x31,0xff,0xb7]

s_addk_i32 s5, 0xc1d1
// CHECK: [0xd1,0xc1,0x85,0xb7]

s_mulk_i32 s5, 0x3141
// CHECK: [0x41,0x31,0x05,0xb8]

s_mulk_i32 s103, 0x3141
// CHECK: [0x41,0x31,0x67,0xb8]

s_mulk_i32 flat_scratch_lo, 0x3141
// CHECK: [0x41,0x31,0x68,0xb8]

s_mulk_i32 flat_scratch_hi, 0x3141
// CHECK: [0x41,0x31,0x69,0xb8]

s_mulk_i32 vcc_lo, 0x3141
// CHECK: [0x41,0x31,0x6a,0xb8]

s_mulk_i32 vcc_hi, 0x3141
// CHECK: [0x41,0x31,0x6b,0xb8]

s_mulk_i32 tba_lo, 0x3141
// CHECK: [0x41,0x31,0x6c,0xb8]

s_mulk_i32 tba_hi, 0x3141
// CHECK: [0x41,0x31,0x6d,0xb8]

s_mulk_i32 tma_lo, 0x3141
// CHECK: [0x41,0x31,0x6e,0xb8]

s_mulk_i32 tma_hi, 0x3141
// CHECK: [0x41,0x31,0x6f,0xb8]

s_mulk_i32 ttmp11, 0x3141
// CHECK: [0x41,0x31,0x7b,0xb8]

s_mulk_i32 m0, 0x3141
// CHECK: [0x41,0x31,0x7c,0xb8]

s_mulk_i32 exec_lo, 0x3141
// CHECK: [0x41,0x31,0x7e,0xb8]

s_mulk_i32 exec_hi, 0x3141
// CHECK: [0x41,0x31,0x7f,0xb8]

s_mulk_i32 s5, 0xc1d1
// CHECK: [0xd1,0xc1,0x05,0xb8]

s_cbranch_i_fork s[2:3], 12609
// CHECK: [0x41,0x31,0x82,0xb8]

s_cbranch_i_fork s[4:5], 12609
// CHECK: [0x41,0x31,0x84,0xb8]

s_cbranch_i_fork s[102:103], 12609
// CHECK: [0x41,0x31,0xe6,0xb8]

s_cbranch_i_fork flat_scratch, 12609
// CHECK: [0x41,0x31,0xe8,0xb8]

s_cbranch_i_fork vcc, 12609
// CHECK: [0x41,0x31,0xea,0xb8]

s_cbranch_i_fork tba, 12609
// CHECK: [0x41,0x31,0xec,0xb8]

s_cbranch_i_fork tma, 12609
// CHECK: [0x41,0x31,0xee,0xb8]

s_cbranch_i_fork ttmp[10:11], 12609
// CHECK: [0x41,0x31,0xfa,0xb8]

s_cbranch_i_fork exec, 12609
// CHECK: [0x41,0x31,0xfe,0xb8]

s_cbranch_i_fork s[2:3], 49617
// CHECK: [0xd1,0xc1,0x82,0xb8]

s_getreg_b32 s5, 0x3141
// CHECK: [0x41,0x31,0x05,0xb9]

s_getreg_b32 s103, 0x3141
// CHECK: [0x41,0x31,0x67,0xb9]

s_getreg_b32 flat_scratch_lo, 0x3141
// CHECK: [0x41,0x31,0x68,0xb9]

s_getreg_b32 flat_scratch_hi, 0x3141
// CHECK: [0x41,0x31,0x69,0xb9]

s_getreg_b32 vcc_lo, 0x3141
// CHECK: [0x41,0x31,0x6a,0xb9]

s_getreg_b32 vcc_hi, 0x3141
// CHECK: [0x41,0x31,0x6b,0xb9]

s_getreg_b32 tba_lo, 0x3141
// CHECK: [0x41,0x31,0x6c,0xb9]

s_getreg_b32 tba_hi, 0x3141
// CHECK: [0x41,0x31,0x6d,0xb9]

s_getreg_b32 tma_lo, 0x3141
// CHECK: [0x41,0x31,0x6e,0xb9]

s_getreg_b32 tma_hi, 0x3141
// CHECK: [0x41,0x31,0x6f,0xb9]

s_getreg_b32 ttmp11, 0x3141
// CHECK: [0x41,0x31,0x7b,0xb9]

s_getreg_b32 m0, 0x3141
// CHECK: [0x41,0x31,0x7c,0xb9]

s_getreg_b32 exec_lo, 0x3141
// CHECK: [0x41,0x31,0x7e,0xb9]

s_getreg_b32 exec_hi, 0x3141
// CHECK: [0x41,0x31,0x7f,0xb9]

s_getreg_b32 s5, 0xc1d1
// CHECK: [0xd1,0xc1,0x05,0xb9]

s_setreg_b32 0x3141, s1
// CHECK: [0x41,0x31,0x81,0xb9]

s_setreg_b32 0xc1d1, s1
// CHECK: [0xd1,0xc1,0x81,0xb9]

s_setreg_b32 0x3141, s103
// CHECK: [0x41,0x31,0xe7,0xb9]

s_setreg_b32 0x3141, flat_scratch_lo
// CHECK: [0x41,0x31,0xe8,0xb9]

s_setreg_b32 0x3141, flat_scratch_hi
// CHECK: [0x41,0x31,0xe9,0xb9]

s_setreg_b32 0x3141, vcc_lo
// CHECK: [0x41,0x31,0xea,0xb9]

s_setreg_b32 0x3141, vcc_hi
// CHECK: [0x41,0x31,0xeb,0xb9]

s_setreg_b32 0x3141, tba_lo
// CHECK: [0x41,0x31,0xec,0xb9]

s_setreg_b32 0x3141, tba_hi
// CHECK: [0x41,0x31,0xed,0xb9]

s_setreg_b32 0x3141, tma_lo
// CHECK: [0x41,0x31,0xee,0xb9]

s_setreg_b32 0x3141, tma_hi
// CHECK: [0x41,0x31,0xef,0xb9]

s_setreg_b32 0x3141, ttmp11
// CHECK: [0x41,0x31,0xfb,0xb9]

s_setreg_b32 0x3141, m0
// CHECK: [0x41,0x31,0xfc,0xb9]

s_setreg_b32 0x3141, exec_lo
// CHECK: [0x41,0x31,0xfe,0xb9]

s_setreg_b32 0x3141, exec_hi
// CHECK: [0x41,0x31,0xff,0xb9]

s_setreg_imm32_b32 0x3141, 0x11213141
// CHECK: [0x41,0x31,0x80,0xba,0x41,0x31,0x21,0x11]

s_setreg_imm32_b32 0xc1d1, 0x11213141
// CHECK: [0xd1,0xc1,0x80,0xba,0x41,0x31,0x21,0x11]

s_setreg_imm32_b32 0x3141, 0xa1b1c1d1
// CHECK: [0x41,0x31,0x80,0xba,0xd1,0xc1,0xb1,0xa1]

s_nop 0x3141
// CHECK: [0x41,0x31,0x80,0xbf]

s_nop 0xc1d1
// CHECK: [0xd1,0xc1,0x80,0xbf]

s_endpgm
// CHECK: [0x00,0x00,0x81,0xbf]

s_branch 12609
// CHECK: [0x41,0x31,0x82,0xbf]

s_branch 49617
// CHECK: [0xd1,0xc1,0x82,0xbf]

s_cbranch_scc0 12609
// CHECK: [0x41,0x31,0x84,0xbf]

s_cbranch_scc0 49617
// CHECK: [0xd1,0xc1,0x84,0xbf]

s_cbranch_scc1 12609
// CHECK: [0x41,0x31,0x85,0xbf]

s_cbranch_scc1 49617
// CHECK: [0xd1,0xc1,0x85,0xbf]

s_cbranch_vccz 12609
// CHECK: [0x41,0x31,0x86,0xbf]

s_cbranch_vccz 49617
// CHECK: [0xd1,0xc1,0x86,0xbf]

s_cbranch_vccnz 12609
// CHECK: [0x41,0x31,0x87,0xbf]

s_cbranch_vccnz 49617
// CHECK: [0xd1,0xc1,0x87,0xbf]

s_cbranch_execz 12609
// CHECK: [0x41,0x31,0x88,0xbf]

s_cbranch_execz 49617
// CHECK: [0xd1,0xc1,0x88,0xbf]

s_cbranch_execnz 12609
// CHECK: [0x41,0x31,0x89,0xbf]

s_cbranch_execnz 49617
// CHECK: [0xd1,0xc1,0x89,0xbf]

s_barrier
// CHECK: [0x00,0x00,0x8a,0xbf]

s_setkill 0x3141
// CHECK: [0x41,0x31,0x8b,0xbf]

s_setkill 0xc1d1
// CHECK: [0xd1,0xc1,0x8b,0xbf]

s_waitcnt 0x3141
// CHECK: [0x41,0x31,0x8c,0xbf]

s_waitcnt 0xc1d1
// CHECK: [0xd1,0xc1,0x8c,0xbf]

s_sethalt 0x3141
// CHECK: [0x41,0x31,0x8d,0xbf]

s_sethalt 0xc1d1
// CHECK: [0xd1,0xc1,0x8d,0xbf]

s_sleep 0x3141
// CHECK: [0x41,0x31,0x8e,0xbf]

s_sleep 0xc1d1
// CHECK: [0xd1,0xc1,0x8e,0xbf]

s_setprio 0x3141
// CHECK: [0x41,0x31,0x8f,0xbf]

s_setprio 0xc1d1
// CHECK: [0xd1,0xc1,0x8f,0xbf]

s_sendmsg 0x3141
// CHECK: [0x41,0x31,0x90,0xbf]

s_sendmsg 0xc1d1
// CHECK: [0xd1,0xc1,0x90,0xbf]

s_sendmsghalt 0x3141
// CHECK: [0x41,0x31,0x91,0xbf]

s_sendmsghalt 0xc1d1
// CHECK: [0xd1,0xc1,0x91,0xbf]

s_trap 0x3141
// CHECK: [0x41,0x31,0x92,0xbf]

s_trap 0xc1d1
// CHECK: [0xd1,0xc1,0x92,0xbf]

s_icache_inv
// CHECK: [0x00,0x00,0x93,0xbf]

s_incperflevel 0x3141
// CHECK: [0x41,0x31,0x94,0xbf]

s_incperflevel 0xc1d1
// CHECK: [0xd1,0xc1,0x94,0xbf]

s_decperflevel 0x3141
// CHECK: [0x41,0x31,0x95,0xbf]

s_decperflevel 0xc1d1
// CHECK: [0xd1,0xc1,0x95,0xbf]

s_ttracedata
// CHECK: [0x00,0x00,0x96,0xbf]

s_cbranch_cdbgsys 12609
// CHECK: [0x41,0x31,0x97,0xbf]

s_cbranch_cdbgsys 49617
// CHECK: [0xd1,0xc1,0x97,0xbf]

s_cbranch_cdbguser 12609
// CHECK: [0x41,0x31,0x98,0xbf]

s_cbranch_cdbguser 49617
// CHECK: [0xd1,0xc1,0x98,0xbf]

s_cbranch_cdbgsys_or_user 12609
// CHECK: [0x41,0x31,0x99,0xbf]

s_cbranch_cdbgsys_or_user 49617
// CHECK: [0xd1,0xc1,0x99,0xbf]

s_cbranch_cdbgsys_and_user 12609
// CHECK: [0x41,0x31,0x9a,0xbf]

s_cbranch_cdbgsys_and_user 49617
// CHECK: [0xd1,0xc1,0x9a,0xbf]

v_interp_p1_f32 v5, v1, attr0.x
// CHECK: [0x01,0x00,0x14,0xc8]

v_interp_p1_f32 v255, v1, attr0.x
// CHECK: [0x01,0x00,0xfc,0xcb]

v_interp_p1_f32 v5, v255, attr0.x
// CHECK: [0xff,0x00,0x14,0xc8]

v_interp_p1_f32 v5, v1, attr1.x
// CHECK: [0x01,0x04,0x14,0xc8]

v_interp_p1_f32 v5, v1, attr31.x
// CHECK: [0x01,0x7c,0x14,0xc8]

v_interp_p1_f32 v5, v1, attr32.x
// CHECK: [0x01,0x80,0x14,0xc8]

v_interp_p1_f32 v5, v1, attr0.y
// CHECK: [0x01,0x01,0x14,0xc8]

v_interp_p1_f32 v5, v1, attr0.z
// CHECK: [0x01,0x02,0x14,0xc8]

v_interp_p1_f32 v5, v1, attr0.w
// CHECK: [0x01,0x03,0x14,0xc8]

v_interp_p2_f32 v5, v1, attr0.x
// CHECK: [0x01,0x00,0x15,0xc8]

v_interp_p2_f32 v255, v1, attr0.x
// CHECK: [0x01,0x00,0xfd,0xcb]

v_interp_p2_f32 v5, v255, attr0.x
// CHECK: [0xff,0x00,0x15,0xc8]

v_interp_p2_f32 v5, v1, attr1.x
// CHECK: [0x01,0x04,0x15,0xc8]

v_interp_p2_f32 v5, v1, attr31.x
// CHECK: [0x01,0x7c,0x15,0xc8]

v_interp_p2_f32 v5, v1, attr32.x
// CHECK: [0x01,0x80,0x15,0xc8]

v_interp_p2_f32 v5, v1, attr0.y
// CHECK: [0x01,0x01,0x15,0xc8]

v_interp_p2_f32 v5, v1, attr0.z
// CHECK: [0x01,0x02,0x15,0xc8]

v_interp_p2_f32 v5, v1, attr0.w
// CHECK: [0x01,0x03,0x15,0xc8]

v_interp_mov_f32 v5, p10, attr0.x
// CHECK: [0x00,0x00,0x16,0xc8]

v_interp_mov_f32 v255, p10, attr0.x
// CHECK: [0x00,0x00,0xfe,0xcb]

v_interp_mov_f32 v5, p20, attr0.x
// CHECK: [0x01,0x00,0x16,0xc8]

v_interp_mov_f32 v5, p0, attr0.x
// CHECK: [0x02,0x00,0x16,0xc8]

v_interp_mov_f32 v5, p10, attr1.x
// CHECK: [0x00,0x04,0x16,0xc8]

v_interp_mov_f32 v5, p10, attr31.x
// CHECK: [0x00,0x7c,0x16,0xc8]

v_interp_mov_f32 v5, p10, attr32.x
// CHECK: [0x00,0x80,0x16,0xc8]

v_interp_mov_f32 v5, p10, attr0.y
// CHECK: [0x00,0x01,0x16,0xc8]

v_interp_mov_f32 v5, p10, attr0.z
// CHECK: [0x00,0x02,0x16,0xc8]

v_interp_mov_f32 v5, p10, attr0.w
// CHECK: [0x00,0x03,0x16,0xc8]

v_nop
// CHECK: [0x00,0x00,0x00,0x7e]

v_nop_e64
// CHECK: [0x00,0x00,0x00,0xd3,0x00,0x00,0x00,0x00]

v_mov_b32 v5, v1
// CHECK: [0x01,0x03,0x0a,0x7e]

v_mov_b32 v255, v1
// CHECK: [0x01,0x03,0xfe,0x7f]

v_mov_b32 v5, v255
// CHECK: [0xff,0x03,0x0a,0x7e]

v_mov_b32 v5, s1
// CHECK: [0x01,0x02,0x0a,0x7e]

v_mov_b32 v5, s103
// CHECK: [0x67,0x02,0x0a,0x7e]

v_mov_b32 v5, flat_scratch_lo
// CHECK: [0x68,0x02,0x0a,0x7e]

v_mov_b32 v5, flat_scratch_hi
// CHECK: [0x69,0x02,0x0a,0x7e]

v_mov_b32 v5, vcc_lo
// CHECK: [0x6a,0x02,0x0a,0x7e]

v_mov_b32 v5, vcc_hi
// CHECK: [0x6b,0x02,0x0a,0x7e]

v_mov_b32 v5, tba_lo
// CHECK: [0x6c,0x02,0x0a,0x7e]

v_mov_b32 v5, tba_hi
// CHECK: [0x6d,0x02,0x0a,0x7e]

v_mov_b32 v5, tma_lo
// CHECK: [0x6e,0x02,0x0a,0x7e]

v_mov_b32 v5, tma_hi
// CHECK: [0x6f,0x02,0x0a,0x7e]

v_mov_b32 v5, ttmp11
// CHECK: [0x7b,0x02,0x0a,0x7e]

v_mov_b32 v5, m0
// CHECK: [0x7c,0x02,0x0a,0x7e]

v_mov_b32 v5, exec_lo
// CHECK: [0x7e,0x02,0x0a,0x7e]

v_mov_b32 v5, exec_hi
// CHECK: [0x7f,0x02,0x0a,0x7e]

v_mov_b32 v5, 0
// CHECK: [0x80,0x02,0x0a,0x7e]

v_mov_b32 v5, -1
// CHECK: [0xc1,0x02,0x0a,0x7e]

v_mov_b32 v5, 0.5
// CHECK: [0xf0,0x02,0x0a,0x7e]

v_mov_b32 v5, -4.0
// CHECK: [0xf7,0x02,0x0a,0x7e]

v_mov_b32 v5, 0xaf123456
// CHECK: [0xff,0x02,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_mov_b32 v5, 0x3f717273
// CHECK: [0xff,0x02,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_mov_b32_e64 v5, v1
// CHECK: [0x05,0x00,0x02,0xd3,0x01,0x01,0x00,0x00]

v_mov_b32_e64 v255, v1
// CHECK: [0xff,0x00,0x02,0xd3,0x01,0x01,0x00,0x00]

v_mov_b32_e64 v5, v255
// CHECK: [0x05,0x00,0x02,0xd3,0xff,0x01,0x00,0x00]

v_mov_b32_e64 v5, s1
// CHECK: [0x05,0x00,0x02,0xd3,0x01,0x00,0x00,0x00]

v_mov_b32_e64 v5, s103
// CHECK: [0x05,0x00,0x02,0xd3,0x67,0x00,0x00,0x00]

v_mov_b32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x02,0xd3,0x68,0x00,0x00,0x00]

v_mov_b32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x02,0xd3,0x69,0x00,0x00,0x00]

v_mov_b32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x02,0xd3,0x6a,0x00,0x00,0x00]

v_mov_b32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x02,0xd3,0x6b,0x00,0x00,0x00]

v_mov_b32_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x02,0xd3,0x6c,0x00,0x00,0x00]

v_mov_b32_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x02,0xd3,0x6d,0x00,0x00,0x00]

v_mov_b32_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x02,0xd3,0x6e,0x00,0x00,0x00]

v_mov_b32_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x02,0xd3,0x6f,0x00,0x00,0x00]

v_mov_b32_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x02,0xd3,0x7b,0x00,0x00,0x00]

v_mov_b32_e64 v5, m0
// CHECK: [0x05,0x00,0x02,0xd3,0x7c,0x00,0x00,0x00]

v_mov_b32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x02,0xd3,0x7e,0x00,0x00,0x00]

v_mov_b32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x02,0xd3,0x7f,0x00,0x00,0x00]

v_mov_b32_e64 v5, 0
// CHECK: [0x05,0x00,0x02,0xd3,0x80,0x00,0x00,0x00]

v_mov_b32_e64 v5, -1
// CHECK: [0x05,0x00,0x02,0xd3,0xc1,0x00,0x00,0x00]

v_mov_b32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x02,0xd3,0xf0,0x00,0x00,0x00]

v_mov_b32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x02,0xd3,0xf7,0x00,0x00,0x00]

v_readfirstlane_b32 s5, v1
// CHECK: [0x01,0x05,0x0a,0x7e]

v_readfirstlane_b32 s103, v1
// CHECK: [0x01,0x05,0xce,0x7e]

v_readfirstlane_b32 tba_lo, v1
// CHECK: [0x01,0x05,0xd8,0x7e]

v_readfirstlane_b32 tba_hi, v1
// CHECK: [0x01,0x05,0xda,0x7e]

v_readfirstlane_b32 tma_lo, v1
// CHECK: [0x01,0x05,0xdc,0x7e]

v_readfirstlane_b32 tma_hi, v1
// CHECK: [0x01,0x05,0xde,0x7e]

v_readfirstlane_b32 ttmp11, v1
// CHECK: [0x01,0x05,0xf6,0x7e]

v_readfirstlane_b32 s5, v255
// CHECK: [0xff,0x05,0x0a,0x7e]

v_cvt_i32_f64 v5, v[1:2]
// CHECK: [0x01,0x07,0x0a,0x7e]

v_cvt_i32_f64 v255, v[1:2]
// CHECK: [0x01,0x07,0xfe,0x7f]

v_cvt_i32_f64 v5, v[254:255]
// CHECK: [0xfe,0x07,0x0a,0x7e]

v_cvt_i32_f64 v5, s[2:3]
// CHECK: [0x02,0x06,0x0a,0x7e]

v_cvt_i32_f64 v5, s[4:5]
// CHECK: [0x04,0x06,0x0a,0x7e]

v_cvt_i32_f64 v5, s[102:103]
// CHECK: [0x66,0x06,0x0a,0x7e]

v_cvt_i32_f64 v5, flat_scratch
// CHECK: [0x68,0x06,0x0a,0x7e]

v_cvt_i32_f64 v5, vcc
// CHECK: [0x6a,0x06,0x0a,0x7e]

v_cvt_i32_f64 v5, tba
// CHECK: [0x6c,0x06,0x0a,0x7e]

v_cvt_i32_f64 v5, tma
// CHECK: [0x6e,0x06,0x0a,0x7e]

v_cvt_i32_f64 v5, ttmp[10:11]
// CHECK: [0x7a,0x06,0x0a,0x7e]

v_cvt_i32_f64 v5, exec
// CHECK: [0x7e,0x06,0x0a,0x7e]

v_cvt_i32_f64 v5, 0
// CHECK: [0x80,0x06,0x0a,0x7e]

v_cvt_i32_f64 v5, -1
// CHECK: [0xc1,0x06,0x0a,0x7e]

v_cvt_i32_f64 v5, 0.5
// CHECK: [0xf0,0x06,0x0a,0x7e]

v_cvt_i32_f64 v5, -4.0
// CHECK: [0xf7,0x06,0x0a,0x7e]

v_cvt_i32_f64 v5, 0xaf123456
// CHECK: [0xff,0x06,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cvt_i32_f64 v5, 0x3f717273
// CHECK: [0xff,0x06,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cvt_i32_f64_e64 v5, v[1:2]
// CHECK: [0x05,0x00,0x06,0xd3,0x01,0x01,0x00,0x00]

v_cvt_i32_f64_e64 v255, v[1:2]
// CHECK: [0xff,0x00,0x06,0xd3,0x01,0x01,0x00,0x00]

v_cvt_i32_f64_e64 v5, v[254:255]
// CHECK: [0x05,0x00,0x06,0xd3,0xfe,0x01,0x00,0x00]

v_cvt_i32_f64_e64 v5, s[2:3]
// CHECK: [0x05,0x00,0x06,0xd3,0x02,0x00,0x00,0x00]

v_cvt_i32_f64_e64 v5, s[4:5]
// CHECK: [0x05,0x00,0x06,0xd3,0x04,0x00,0x00,0x00]

v_cvt_i32_f64_e64 v5, s[102:103]
// CHECK: [0x05,0x00,0x06,0xd3,0x66,0x00,0x00,0x00]

v_cvt_i32_f64_e64 v5, flat_scratch
// CHECK: [0x05,0x00,0x06,0xd3,0x68,0x00,0x00,0x00]

v_cvt_i32_f64_e64 v5, vcc
// CHECK: [0x05,0x00,0x06,0xd3,0x6a,0x00,0x00,0x00]

v_cvt_i32_f64_e64 v5, tba
// CHECK: [0x05,0x00,0x06,0xd3,0x6c,0x00,0x00,0x00]

v_cvt_i32_f64_e64 v5, tma
// CHECK: [0x05,0x00,0x06,0xd3,0x6e,0x00,0x00,0x00]

v_cvt_i32_f64_e64 v5, ttmp[10:11]
// CHECK: [0x05,0x00,0x06,0xd3,0x7a,0x00,0x00,0x00]

v_cvt_i32_f64_e64 v5, exec
// CHECK: [0x05,0x00,0x06,0xd3,0x7e,0x00,0x00,0x00]

v_cvt_i32_f64_e64 v5, 0
// CHECK: [0x05,0x00,0x06,0xd3,0x80,0x00,0x00,0x00]

v_cvt_i32_f64_e64 v5, -1
// CHECK: [0x05,0x00,0x06,0xd3,0xc1,0x00,0x00,0x00]

v_cvt_i32_f64_e64 v5, 0.5
// CHECK: [0x05,0x00,0x06,0xd3,0xf0,0x00,0x00,0x00]

v_cvt_i32_f64_e64 v5, -4.0
// CHECK: [0x05,0x00,0x06,0xd3,0xf7,0x00,0x00,0x00]

v_cvt_i32_f64_e64 v5, -v[1:2]
// CHECK: [0x05,0x00,0x06,0xd3,0x01,0x01,0x00,0x20]

v_cvt_i32_f64_e64 v5, |v[1:2]|
// CHECK: [0x05,0x01,0x06,0xd3,0x01,0x01,0x00,0x00]

v_cvt_f64_i32 v[5:6], v1
// CHECK: [0x01,0x09,0x0a,0x7e]

v_cvt_f64_i32 v[254:255], v1
// CHECK: [0x01,0x09,0xfc,0x7f]

v_cvt_f64_i32 v[5:6], v255
// CHECK: [0xff,0x09,0x0a,0x7e]

v_cvt_f64_i32 v[5:6], s1
// CHECK: [0x01,0x08,0x0a,0x7e]

v_cvt_f64_i32 v[5:6], s103
// CHECK: [0x67,0x08,0x0a,0x7e]

v_cvt_f64_i32 v[5:6], flat_scratch_lo
// CHECK: [0x68,0x08,0x0a,0x7e]

v_cvt_f64_i32 v[5:6], flat_scratch_hi
// CHECK: [0x69,0x08,0x0a,0x7e]

v_cvt_f64_i32 v[5:6], vcc_lo
// CHECK: [0x6a,0x08,0x0a,0x7e]

v_cvt_f64_i32 v[5:6], vcc_hi
// CHECK: [0x6b,0x08,0x0a,0x7e]

v_cvt_f64_i32 v[5:6], tba_lo
// CHECK: [0x6c,0x08,0x0a,0x7e]

v_cvt_f64_i32 v[5:6], tba_hi
// CHECK: [0x6d,0x08,0x0a,0x7e]

v_cvt_f64_i32 v[5:6], tma_lo
// CHECK: [0x6e,0x08,0x0a,0x7e]

v_cvt_f64_i32 v[5:6], tma_hi
// CHECK: [0x6f,0x08,0x0a,0x7e]

v_cvt_f64_i32 v[5:6], ttmp11
// CHECK: [0x7b,0x08,0x0a,0x7e]

v_cvt_f64_i32 v[5:6], m0
// CHECK: [0x7c,0x08,0x0a,0x7e]

v_cvt_f64_i32 v[5:6], exec_lo
// CHECK: [0x7e,0x08,0x0a,0x7e]

v_cvt_f64_i32 v[5:6], exec_hi
// CHECK: [0x7f,0x08,0x0a,0x7e]

v_cvt_f64_i32 v[5:6], 0
// CHECK: [0x80,0x08,0x0a,0x7e]

v_cvt_f64_i32 v[5:6], -1
// CHECK: [0xc1,0x08,0x0a,0x7e]

v_cvt_f64_i32 v[5:6], 0.5
// CHECK: [0xf0,0x08,0x0a,0x7e]

v_cvt_f64_i32 v[5:6], -4.0
// CHECK: [0xf7,0x08,0x0a,0x7e]

v_cvt_f64_i32 v[5:6], 0xaf123456
// CHECK: [0xff,0x08,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cvt_f64_i32 v[5:6], 0x3f717273
// CHECK: [0xff,0x08,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cvt_f64_i32_e64 v[5:6], v1
// CHECK: [0x05,0x00,0x08,0xd3,0x01,0x01,0x00,0x00]

v_cvt_f64_i32_e64 v[254:255], v1
// CHECK: [0xfe,0x00,0x08,0xd3,0x01,0x01,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], v255
// CHECK: [0x05,0x00,0x08,0xd3,0xff,0x01,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], s1
// CHECK: [0x05,0x00,0x08,0xd3,0x01,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], s103
// CHECK: [0x05,0x00,0x08,0xd3,0x67,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], flat_scratch_lo
// CHECK: [0x05,0x00,0x08,0xd3,0x68,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], flat_scratch_hi
// CHECK: [0x05,0x00,0x08,0xd3,0x69,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], vcc_lo
// CHECK: [0x05,0x00,0x08,0xd3,0x6a,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], vcc_hi
// CHECK: [0x05,0x00,0x08,0xd3,0x6b,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], tba_lo
// CHECK: [0x05,0x00,0x08,0xd3,0x6c,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], tba_hi
// CHECK: [0x05,0x00,0x08,0xd3,0x6d,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], tma_lo
// CHECK: [0x05,0x00,0x08,0xd3,0x6e,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], tma_hi
// CHECK: [0x05,0x00,0x08,0xd3,0x6f,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], ttmp11
// CHECK: [0x05,0x00,0x08,0xd3,0x7b,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], m0
// CHECK: [0x05,0x00,0x08,0xd3,0x7c,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], exec_lo
// CHECK: [0x05,0x00,0x08,0xd3,0x7e,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], exec_hi
// CHECK: [0x05,0x00,0x08,0xd3,0x7f,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], 0
// CHECK: [0x05,0x00,0x08,0xd3,0x80,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], -1
// CHECK: [0x05,0x00,0x08,0xd3,0xc1,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], 0.5
// CHECK: [0x05,0x00,0x08,0xd3,0xf0,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], -4.0
// CHECK: [0x05,0x00,0x08,0xd3,0xf7,0x00,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], v1 clamp
// CHECK: [0x05,0x08,0x08,0xd3,0x01,0x01,0x00,0x00]

v_cvt_f64_i32_e64 v[5:6], v1 mul:2
// CHECK: [0x05,0x00,0x08,0xd3,0x01,0x01,0x00,0x08]

v_cvt_f64_i32_e64 v[5:6], v1 mul:4
// CHECK: [0x05,0x00,0x08,0xd3,0x01,0x01,0x00,0x10]

v_cvt_f64_i32_e64 v[5:6], v1 div:2
// CHECK: [0x05,0x00,0x08,0xd3,0x01,0x01,0x00,0x18]

v_cvt_f32_i32 v5, v1
// CHECK: [0x01,0x0b,0x0a,0x7e]

v_cvt_f32_i32 v255, v1
// CHECK: [0x01,0x0b,0xfe,0x7f]

v_cvt_f32_i32 v5, v255
// CHECK: [0xff,0x0b,0x0a,0x7e]

v_cvt_f32_i32 v5, s1
// CHECK: [0x01,0x0a,0x0a,0x7e]

v_cvt_f32_i32 v5, s103
// CHECK: [0x67,0x0a,0x0a,0x7e]

v_cvt_f32_i32 v5, flat_scratch_lo
// CHECK: [0x68,0x0a,0x0a,0x7e]

v_cvt_f32_i32 v5, flat_scratch_hi
// CHECK: [0x69,0x0a,0x0a,0x7e]

v_cvt_f32_i32 v5, vcc_lo
// CHECK: [0x6a,0x0a,0x0a,0x7e]

v_cvt_f32_i32 v5, vcc_hi
// CHECK: [0x6b,0x0a,0x0a,0x7e]

v_cvt_f32_i32 v5, tba_lo
// CHECK: [0x6c,0x0a,0x0a,0x7e]

v_cvt_f32_i32 v5, tba_hi
// CHECK: [0x6d,0x0a,0x0a,0x7e]

v_cvt_f32_i32 v5, tma_lo
// CHECK: [0x6e,0x0a,0x0a,0x7e]

v_cvt_f32_i32 v5, tma_hi
// CHECK: [0x6f,0x0a,0x0a,0x7e]

v_cvt_f32_i32 v5, ttmp11
// CHECK: [0x7b,0x0a,0x0a,0x7e]

v_cvt_f32_i32 v5, m0
// CHECK: [0x7c,0x0a,0x0a,0x7e]

v_cvt_f32_i32 v5, exec_lo
// CHECK: [0x7e,0x0a,0x0a,0x7e]

v_cvt_f32_i32 v5, exec_hi
// CHECK: [0x7f,0x0a,0x0a,0x7e]

v_cvt_f32_i32 v5, 0
// CHECK: [0x80,0x0a,0x0a,0x7e]

v_cvt_f32_i32 v5, -1
// CHECK: [0xc1,0x0a,0x0a,0x7e]

v_cvt_f32_i32 v5, 0.5
// CHECK: [0xf0,0x0a,0x0a,0x7e]

v_cvt_f32_i32 v5, -4.0
// CHECK: [0xf7,0x0a,0x0a,0x7e]

v_cvt_f32_i32 v5, 0xaf123456
// CHECK: [0xff,0x0a,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cvt_f32_i32 v5, 0x3f717273
// CHECK: [0xff,0x0a,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cvt_f32_i32_e64 v5, v1
// CHECK: [0x05,0x00,0x0a,0xd3,0x01,0x01,0x00,0x00]

v_cvt_f32_i32_e64 v255, v1
// CHECK: [0xff,0x00,0x0a,0xd3,0x01,0x01,0x00,0x00]

v_cvt_f32_i32_e64 v5, v255
// CHECK: [0x05,0x00,0x0a,0xd3,0xff,0x01,0x00,0x00]

v_cvt_f32_i32_e64 v5, s1
// CHECK: [0x05,0x00,0x0a,0xd3,0x01,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, s103
// CHECK: [0x05,0x00,0x0a,0xd3,0x67,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x0a,0xd3,0x68,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x0a,0xd3,0x69,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x0a,0xd3,0x6a,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x0a,0xd3,0x6b,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x0a,0xd3,0x6c,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x0a,0xd3,0x6d,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x0a,0xd3,0x6e,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x0a,0xd3,0x6f,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x0a,0xd3,0x7b,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, m0
// CHECK: [0x05,0x00,0x0a,0xd3,0x7c,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x0a,0xd3,0x7e,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x0a,0xd3,0x7f,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, 0
// CHECK: [0x05,0x00,0x0a,0xd3,0x80,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, -1
// CHECK: [0x05,0x00,0x0a,0xd3,0xc1,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x0a,0xd3,0xf0,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x0a,0xd3,0xf7,0x00,0x00,0x00]

v_cvt_f32_i32_e64 v5, v1 clamp
// CHECK: [0x05,0x08,0x0a,0xd3,0x01,0x01,0x00,0x00]

v_cvt_f32_i32_e64 v5, v1 mul:2
// CHECK: [0x05,0x00,0x0a,0xd3,0x01,0x01,0x00,0x08]

v_cvt_f32_i32_e64 v5, v1 mul:4
// CHECK: [0x05,0x00,0x0a,0xd3,0x01,0x01,0x00,0x10]

v_cvt_f32_i32_e64 v5, v1 div:2
// CHECK: [0x05,0x00,0x0a,0xd3,0x01,0x01,0x00,0x18]

v_cvt_f32_u32 v5, v1
// CHECK: [0x01,0x0d,0x0a,0x7e]

v_cvt_f32_u32 v255, v1
// CHECK: [0x01,0x0d,0xfe,0x7f]

v_cvt_f32_u32 v5, v255
// CHECK: [0xff,0x0d,0x0a,0x7e]

v_cvt_f32_u32 v5, s1
// CHECK: [0x01,0x0c,0x0a,0x7e]

v_cvt_f32_u32 v5, s103
// CHECK: [0x67,0x0c,0x0a,0x7e]

v_cvt_f32_u32 v5, flat_scratch_lo
// CHECK: [0x68,0x0c,0x0a,0x7e]

v_cvt_f32_u32 v5, flat_scratch_hi
// CHECK: [0x69,0x0c,0x0a,0x7e]

v_cvt_f32_u32 v5, vcc_lo
// CHECK: [0x6a,0x0c,0x0a,0x7e]

v_cvt_f32_u32 v5, vcc_hi
// CHECK: [0x6b,0x0c,0x0a,0x7e]

v_cvt_f32_u32 v5, tba_lo
// CHECK: [0x6c,0x0c,0x0a,0x7e]

v_cvt_f32_u32 v5, tba_hi
// CHECK: [0x6d,0x0c,0x0a,0x7e]

v_cvt_f32_u32 v5, tma_lo
// CHECK: [0x6e,0x0c,0x0a,0x7e]

v_cvt_f32_u32 v5, tma_hi
// CHECK: [0x6f,0x0c,0x0a,0x7e]

v_cvt_f32_u32 v5, ttmp11
// CHECK: [0x7b,0x0c,0x0a,0x7e]

v_cvt_f32_u32 v5, m0
// CHECK: [0x7c,0x0c,0x0a,0x7e]

v_cvt_f32_u32 v5, exec_lo
// CHECK: [0x7e,0x0c,0x0a,0x7e]

v_cvt_f32_u32 v5, exec_hi
// CHECK: [0x7f,0x0c,0x0a,0x7e]

v_cvt_f32_u32 v5, 0
// CHECK: [0x80,0x0c,0x0a,0x7e]

v_cvt_f32_u32 v5, -1
// CHECK: [0xc1,0x0c,0x0a,0x7e]

v_cvt_f32_u32 v5, 0.5
// CHECK: [0xf0,0x0c,0x0a,0x7e]

v_cvt_f32_u32 v5, -4.0
// CHECK: [0xf7,0x0c,0x0a,0x7e]

v_cvt_f32_u32 v5, 0xaf123456
// CHECK: [0xff,0x0c,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cvt_f32_u32 v5, 0x3f717273
// CHECK: [0xff,0x0c,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cvt_f32_u32_e64 v5, v1
// CHECK: [0x05,0x00,0x0c,0xd3,0x01,0x01,0x00,0x00]

v_cvt_f32_u32_e64 v255, v1
// CHECK: [0xff,0x00,0x0c,0xd3,0x01,0x01,0x00,0x00]

v_cvt_f32_u32_e64 v5, v255
// CHECK: [0x05,0x00,0x0c,0xd3,0xff,0x01,0x00,0x00]

v_cvt_f32_u32_e64 v5, s1
// CHECK: [0x05,0x00,0x0c,0xd3,0x01,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, s103
// CHECK: [0x05,0x00,0x0c,0xd3,0x67,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x0c,0xd3,0x68,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x0c,0xd3,0x69,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x0c,0xd3,0x6a,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x0c,0xd3,0x6b,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x0c,0xd3,0x6c,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x0c,0xd3,0x6d,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x0c,0xd3,0x6e,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x0c,0xd3,0x6f,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x0c,0xd3,0x7b,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, m0
// CHECK: [0x05,0x00,0x0c,0xd3,0x7c,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x0c,0xd3,0x7e,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x0c,0xd3,0x7f,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, 0
// CHECK: [0x05,0x00,0x0c,0xd3,0x80,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, -1
// CHECK: [0x05,0x00,0x0c,0xd3,0xc1,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x0c,0xd3,0xf0,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x0c,0xd3,0xf7,0x00,0x00,0x00]

v_cvt_f32_u32_e64 v5, v1 clamp
// CHECK: [0x05,0x08,0x0c,0xd3,0x01,0x01,0x00,0x00]

v_cvt_f32_u32_e64 v5, v1 mul:2
// CHECK: [0x05,0x00,0x0c,0xd3,0x01,0x01,0x00,0x08]

v_cvt_f32_u32_e64 v5, v1 mul:4
// CHECK: [0x05,0x00,0x0c,0xd3,0x01,0x01,0x00,0x10]

v_cvt_f32_u32_e64 v5, v1 div:2
// CHECK: [0x05,0x00,0x0c,0xd3,0x01,0x01,0x00,0x18]

v_cvt_u32_f32 v5, v1
// CHECK: [0x01,0x0f,0x0a,0x7e]

v_cvt_u32_f32 v255, v1
// CHECK: [0x01,0x0f,0xfe,0x7f]

v_cvt_u32_f32 v5, v255
// CHECK: [0xff,0x0f,0x0a,0x7e]

v_cvt_u32_f32 v5, s1
// CHECK: [0x01,0x0e,0x0a,0x7e]

v_cvt_u32_f32 v5, s103
// CHECK: [0x67,0x0e,0x0a,0x7e]

v_cvt_u32_f32 v5, flat_scratch_lo
// CHECK: [0x68,0x0e,0x0a,0x7e]

v_cvt_u32_f32 v5, flat_scratch_hi
// CHECK: [0x69,0x0e,0x0a,0x7e]

v_cvt_u32_f32 v5, vcc_lo
// CHECK: [0x6a,0x0e,0x0a,0x7e]

v_cvt_u32_f32 v5, vcc_hi
// CHECK: [0x6b,0x0e,0x0a,0x7e]

v_cvt_u32_f32 v5, tba_lo
// CHECK: [0x6c,0x0e,0x0a,0x7e]

v_cvt_u32_f32 v5, tba_hi
// CHECK: [0x6d,0x0e,0x0a,0x7e]

v_cvt_u32_f32 v5, tma_lo
// CHECK: [0x6e,0x0e,0x0a,0x7e]

v_cvt_u32_f32 v5, tma_hi
// CHECK: [0x6f,0x0e,0x0a,0x7e]

v_cvt_u32_f32 v5, ttmp11
// CHECK: [0x7b,0x0e,0x0a,0x7e]

v_cvt_u32_f32 v5, m0
// CHECK: [0x7c,0x0e,0x0a,0x7e]

v_cvt_u32_f32 v5, exec_lo
// CHECK: [0x7e,0x0e,0x0a,0x7e]

v_cvt_u32_f32 v5, exec_hi
// CHECK: [0x7f,0x0e,0x0a,0x7e]

v_cvt_u32_f32 v5, 0
// CHECK: [0x80,0x0e,0x0a,0x7e]

v_cvt_u32_f32 v5, -1
// CHECK: [0xc1,0x0e,0x0a,0x7e]

v_cvt_u32_f32 v5, 0.5
// CHECK: [0xf0,0x0e,0x0a,0x7e]

v_cvt_u32_f32 v5, -4.0
// CHECK: [0xf7,0x0e,0x0a,0x7e]

v_cvt_u32_f32 v5, 0xaf123456
// CHECK: [0xff,0x0e,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cvt_u32_f32 v5, 0x3f717273
// CHECK: [0xff,0x0e,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cvt_u32_f32_e64 v5, v1
// CHECK: [0x05,0x00,0x0e,0xd3,0x01,0x01,0x00,0x00]

v_cvt_u32_f32_e64 v255, v1
// CHECK: [0xff,0x00,0x0e,0xd3,0x01,0x01,0x00,0x00]

v_cvt_u32_f32_e64 v5, v255
// CHECK: [0x05,0x00,0x0e,0xd3,0xff,0x01,0x00,0x00]

v_cvt_u32_f32_e64 v5, s1
// CHECK: [0x05,0x00,0x0e,0xd3,0x01,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, s103
// CHECK: [0x05,0x00,0x0e,0xd3,0x67,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x0e,0xd3,0x68,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x0e,0xd3,0x69,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x0e,0xd3,0x6a,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x0e,0xd3,0x6b,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x0e,0xd3,0x6c,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x0e,0xd3,0x6d,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x0e,0xd3,0x6e,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x0e,0xd3,0x6f,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x0e,0xd3,0x7b,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, m0
// CHECK: [0x05,0x00,0x0e,0xd3,0x7c,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x0e,0xd3,0x7e,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x0e,0xd3,0x7f,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, 0
// CHECK: [0x05,0x00,0x0e,0xd3,0x80,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, -1
// CHECK: [0x05,0x00,0x0e,0xd3,0xc1,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x0e,0xd3,0xf0,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x0e,0xd3,0xf7,0x00,0x00,0x00]

v_cvt_u32_f32_e64 v5, -v1
// CHECK: [0x05,0x00,0x0e,0xd3,0x01,0x01,0x00,0x20]

v_cvt_u32_f32_e64 v5, |v1|
// CHECK: [0x05,0x01,0x0e,0xd3,0x01,0x01,0x00,0x00]

v_cvt_i32_f32 v5, v1
// CHECK: [0x01,0x11,0x0a,0x7e]

v_cvt_i32_f32 v255, v1
// CHECK: [0x01,0x11,0xfe,0x7f]

v_cvt_i32_f32 v5, v255
// CHECK: [0xff,0x11,0x0a,0x7e]

v_cvt_i32_f32 v5, s1
// CHECK: [0x01,0x10,0x0a,0x7e]

v_cvt_i32_f32 v5, s103
// CHECK: [0x67,0x10,0x0a,0x7e]

v_cvt_i32_f32 v5, flat_scratch_lo
// CHECK: [0x68,0x10,0x0a,0x7e]

v_cvt_i32_f32 v5, flat_scratch_hi
// CHECK: [0x69,0x10,0x0a,0x7e]

v_cvt_i32_f32 v5, vcc_lo
// CHECK: [0x6a,0x10,0x0a,0x7e]

v_cvt_i32_f32 v5, vcc_hi
// CHECK: [0x6b,0x10,0x0a,0x7e]

v_cvt_i32_f32 v5, tba_lo
// CHECK: [0x6c,0x10,0x0a,0x7e]

v_cvt_i32_f32 v5, tba_hi
// CHECK: [0x6d,0x10,0x0a,0x7e]

v_cvt_i32_f32 v5, tma_lo
// CHECK: [0x6e,0x10,0x0a,0x7e]

v_cvt_i32_f32 v5, tma_hi
// CHECK: [0x6f,0x10,0x0a,0x7e]

v_cvt_i32_f32 v5, ttmp11
// CHECK: [0x7b,0x10,0x0a,0x7e]

v_cvt_i32_f32 v5, m0
// CHECK: [0x7c,0x10,0x0a,0x7e]

v_cvt_i32_f32 v5, exec_lo
// CHECK: [0x7e,0x10,0x0a,0x7e]

v_cvt_i32_f32 v5, exec_hi
// CHECK: [0x7f,0x10,0x0a,0x7e]

v_cvt_i32_f32 v5, 0
// CHECK: [0x80,0x10,0x0a,0x7e]

v_cvt_i32_f32 v5, -1
// CHECK: [0xc1,0x10,0x0a,0x7e]

v_cvt_i32_f32 v5, 0.5
// CHECK: [0xf0,0x10,0x0a,0x7e]

v_cvt_i32_f32 v5, -4.0
// CHECK: [0xf7,0x10,0x0a,0x7e]

v_cvt_i32_f32 v5, 0xaf123456
// CHECK: [0xff,0x10,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cvt_i32_f32 v5, 0x3f717273
// CHECK: [0xff,0x10,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cvt_i32_f32_e64 v5, v1
// CHECK: [0x05,0x00,0x10,0xd3,0x01,0x01,0x00,0x00]

v_cvt_i32_f32_e64 v255, v1
// CHECK: [0xff,0x00,0x10,0xd3,0x01,0x01,0x00,0x00]

v_cvt_i32_f32_e64 v5, v255
// CHECK: [0x05,0x00,0x10,0xd3,0xff,0x01,0x00,0x00]

v_cvt_i32_f32_e64 v5, s1
// CHECK: [0x05,0x00,0x10,0xd3,0x01,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, s103
// CHECK: [0x05,0x00,0x10,0xd3,0x67,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x10,0xd3,0x68,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x10,0xd3,0x69,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x10,0xd3,0x6a,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x10,0xd3,0x6b,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x10,0xd3,0x6c,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x10,0xd3,0x6d,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x10,0xd3,0x6e,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x10,0xd3,0x6f,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x10,0xd3,0x7b,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, m0
// CHECK: [0x05,0x00,0x10,0xd3,0x7c,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x10,0xd3,0x7e,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x10,0xd3,0x7f,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, 0
// CHECK: [0x05,0x00,0x10,0xd3,0x80,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, -1
// CHECK: [0x05,0x00,0x10,0xd3,0xc1,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x10,0xd3,0xf0,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x10,0xd3,0xf7,0x00,0x00,0x00]

v_cvt_i32_f32_e64 v5, -v1
// CHECK: [0x05,0x00,0x10,0xd3,0x01,0x01,0x00,0x20]

v_cvt_i32_f32_e64 v5, |v1|
// CHECK: [0x05,0x01,0x10,0xd3,0x01,0x01,0x00,0x00]

v_mov_fed_b32 v5, v1
// CHECK: [0x01,0x13,0x0a,0x7e]

v_mov_fed_b32 v255, v1
// CHECK: [0x01,0x13,0xfe,0x7f]

v_mov_fed_b32 v5, v255
// CHECK: [0xff,0x13,0x0a,0x7e]

v_mov_fed_b32 v5, s1
// CHECK: [0x01,0x12,0x0a,0x7e]

v_mov_fed_b32 v5, s103
// CHECK: [0x67,0x12,0x0a,0x7e]

v_mov_fed_b32 v5, flat_scratch_lo
// CHECK: [0x68,0x12,0x0a,0x7e]

v_mov_fed_b32 v5, flat_scratch_hi
// CHECK: [0x69,0x12,0x0a,0x7e]

v_mov_fed_b32 v5, vcc_lo
// CHECK: [0x6a,0x12,0x0a,0x7e]

v_mov_fed_b32 v5, vcc_hi
// CHECK: [0x6b,0x12,0x0a,0x7e]

v_mov_fed_b32 v5, tba_lo
// CHECK: [0x6c,0x12,0x0a,0x7e]

v_mov_fed_b32 v5, tba_hi
// CHECK: [0x6d,0x12,0x0a,0x7e]

v_mov_fed_b32 v5, tma_lo
// CHECK: [0x6e,0x12,0x0a,0x7e]

v_mov_fed_b32 v5, tma_hi
// CHECK: [0x6f,0x12,0x0a,0x7e]

v_mov_fed_b32 v5, ttmp11
// CHECK: [0x7b,0x12,0x0a,0x7e]

v_mov_fed_b32 v5, m0
// CHECK: [0x7c,0x12,0x0a,0x7e]

v_mov_fed_b32 v5, exec_lo
// CHECK: [0x7e,0x12,0x0a,0x7e]

v_mov_fed_b32 v5, exec_hi
// CHECK: [0x7f,0x12,0x0a,0x7e]

v_mov_fed_b32 v5, 0
// CHECK: [0x80,0x12,0x0a,0x7e]

v_mov_fed_b32 v5, -1
// CHECK: [0xc1,0x12,0x0a,0x7e]

v_mov_fed_b32 v5, 0.5
// CHECK: [0xf0,0x12,0x0a,0x7e]

v_mov_fed_b32 v5, -4.0
// CHECK: [0xf7,0x12,0x0a,0x7e]

v_mov_fed_b32 v5, 0xaf123456
// CHECK: [0xff,0x12,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_mov_fed_b32 v5, 0x3f717273
// CHECK: [0xff,0x12,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_mov_fed_b32_e64 v5, v1
// CHECK: [0x05,0x00,0x12,0xd3,0x01,0x01,0x00,0x00]

v_mov_fed_b32_e64 v255, v1
// CHECK: [0xff,0x00,0x12,0xd3,0x01,0x01,0x00,0x00]

v_mov_fed_b32_e64 v5, v255
// CHECK: [0x05,0x00,0x12,0xd3,0xff,0x01,0x00,0x00]

v_mov_fed_b32_e64 v5, s1
// CHECK: [0x05,0x00,0x12,0xd3,0x01,0x00,0x00,0x00]

v_mov_fed_b32_e64 v5, s103
// CHECK: [0x05,0x00,0x12,0xd3,0x67,0x00,0x00,0x00]

v_mov_fed_b32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x12,0xd3,0x68,0x00,0x00,0x00]

v_mov_fed_b32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x12,0xd3,0x69,0x00,0x00,0x00]

v_mov_fed_b32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x12,0xd3,0x6a,0x00,0x00,0x00]

v_mov_fed_b32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x12,0xd3,0x6b,0x00,0x00,0x00]

v_mov_fed_b32_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x12,0xd3,0x6c,0x00,0x00,0x00]

v_mov_fed_b32_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x12,0xd3,0x6d,0x00,0x00,0x00]

v_mov_fed_b32_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x12,0xd3,0x6e,0x00,0x00,0x00]

v_mov_fed_b32_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x12,0xd3,0x6f,0x00,0x00,0x00]

v_mov_fed_b32_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x12,0xd3,0x7b,0x00,0x00,0x00]

v_mov_fed_b32_e64 v5, m0
// CHECK: [0x05,0x00,0x12,0xd3,0x7c,0x00,0x00,0x00]

v_mov_fed_b32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x12,0xd3,0x7e,0x00,0x00,0x00]

v_mov_fed_b32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x12,0xd3,0x7f,0x00,0x00,0x00]

v_mov_fed_b32_e64 v5, 0
// CHECK: [0x05,0x00,0x12,0xd3,0x80,0x00,0x00,0x00]

v_mov_fed_b32_e64 v5, -1
// CHECK: [0x05,0x00,0x12,0xd3,0xc1,0x00,0x00,0x00]

v_mov_fed_b32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x12,0xd3,0xf0,0x00,0x00,0x00]

v_mov_fed_b32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x12,0xd3,0xf7,0x00,0x00,0x00]

v_cvt_f16_f32 v5, v1
// CHECK: [0x01,0x15,0x0a,0x7e]

v_cvt_f16_f32 v255, v1
// CHECK: [0x01,0x15,0xfe,0x7f]

v_cvt_f16_f32 v5, v255
// CHECK: [0xff,0x15,0x0a,0x7e]

v_cvt_f16_f32 v5, s1
// CHECK: [0x01,0x14,0x0a,0x7e]

v_cvt_f16_f32 v5, s103
// CHECK: [0x67,0x14,0x0a,0x7e]

v_cvt_f16_f32 v5, flat_scratch_lo
// CHECK: [0x68,0x14,0x0a,0x7e]

v_cvt_f16_f32 v5, flat_scratch_hi
// CHECK: [0x69,0x14,0x0a,0x7e]

v_cvt_f16_f32 v5, vcc_lo
// CHECK: [0x6a,0x14,0x0a,0x7e]

v_cvt_f16_f32 v5, vcc_hi
// CHECK: [0x6b,0x14,0x0a,0x7e]

v_cvt_f16_f32 v5, tba_lo
// CHECK: [0x6c,0x14,0x0a,0x7e]

v_cvt_f16_f32 v5, tba_hi
// CHECK: [0x6d,0x14,0x0a,0x7e]

v_cvt_f16_f32 v5, tma_lo
// CHECK: [0x6e,0x14,0x0a,0x7e]

v_cvt_f16_f32 v5, tma_hi
// CHECK: [0x6f,0x14,0x0a,0x7e]

v_cvt_f16_f32 v5, ttmp11
// CHECK: [0x7b,0x14,0x0a,0x7e]

v_cvt_f16_f32 v5, m0
// CHECK: [0x7c,0x14,0x0a,0x7e]

v_cvt_f16_f32 v5, exec_lo
// CHECK: [0x7e,0x14,0x0a,0x7e]

v_cvt_f16_f32 v5, exec_hi
// CHECK: [0x7f,0x14,0x0a,0x7e]

v_cvt_f16_f32 v5, 0
// CHECK: [0x80,0x14,0x0a,0x7e]

v_cvt_f16_f32 v5, -1
// CHECK: [0xc1,0x14,0x0a,0x7e]

v_cvt_f16_f32 v5, 0.5
// CHECK: [0xf0,0x14,0x0a,0x7e]

v_cvt_f16_f32 v5, -4.0
// CHECK: [0xf7,0x14,0x0a,0x7e]

v_cvt_f16_f32 v5, 0xaf123456
// CHECK: [0xff,0x14,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cvt_f16_f32 v5, 0x3f717273
// CHECK: [0xff,0x14,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cvt_f16_f32_e64 v5, v1
// CHECK: [0x05,0x00,0x14,0xd3,0x01,0x01,0x00,0x00]

v_cvt_f16_f32_e64 v255, v1
// CHECK: [0xff,0x00,0x14,0xd3,0x01,0x01,0x00,0x00]

v_cvt_f16_f32_e64 v5, v255
// CHECK: [0x05,0x00,0x14,0xd3,0xff,0x01,0x00,0x00]

v_cvt_f16_f32_e64 v5, s1
// CHECK: [0x05,0x00,0x14,0xd3,0x01,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, s103
// CHECK: [0x05,0x00,0x14,0xd3,0x67,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x14,0xd3,0x68,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x14,0xd3,0x69,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x14,0xd3,0x6a,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x14,0xd3,0x6b,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x14,0xd3,0x6c,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x14,0xd3,0x6d,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x14,0xd3,0x6e,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x14,0xd3,0x6f,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x14,0xd3,0x7b,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, m0
// CHECK: [0x05,0x00,0x14,0xd3,0x7c,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x14,0xd3,0x7e,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x14,0xd3,0x7f,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, 0
// CHECK: [0x05,0x00,0x14,0xd3,0x80,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, -1
// CHECK: [0x05,0x00,0x14,0xd3,0xc1,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x14,0xd3,0xf0,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x14,0xd3,0xf7,0x00,0x00,0x00]

v_cvt_f16_f32_e64 v5, -v1
// CHECK: [0x05,0x00,0x14,0xd3,0x01,0x01,0x00,0x20]

v_cvt_f16_f32_e64 v5, |v1|
// CHECK: [0x05,0x01,0x14,0xd3,0x01,0x01,0x00,0x00]

v_cvt_f32_f16 v5, v1
// CHECK: [0x01,0x17,0x0a,0x7e]

v_cvt_f32_f16 v255, v1
// CHECK: [0x01,0x17,0xfe,0x7f]

v_cvt_f32_f16 v5, v255
// CHECK: [0xff,0x17,0x0a,0x7e]

v_cvt_f32_f16 v5, s1
// CHECK: [0x01,0x16,0x0a,0x7e]

v_cvt_f32_f16 v5, s103
// CHECK: [0x67,0x16,0x0a,0x7e]

v_cvt_f32_f16 v5, flat_scratch_lo
// CHECK: [0x68,0x16,0x0a,0x7e]

v_cvt_f32_f16 v5, flat_scratch_hi
// CHECK: [0x69,0x16,0x0a,0x7e]

v_cvt_f32_f16 v5, vcc_lo
// CHECK: [0x6a,0x16,0x0a,0x7e]

v_cvt_f32_f16 v5, vcc_hi
// CHECK: [0x6b,0x16,0x0a,0x7e]

v_cvt_f32_f16 v5, tba_lo
// CHECK: [0x6c,0x16,0x0a,0x7e]

v_cvt_f32_f16 v5, tba_hi
// CHECK: [0x6d,0x16,0x0a,0x7e]

v_cvt_f32_f16 v5, tma_lo
// CHECK: [0x6e,0x16,0x0a,0x7e]

v_cvt_f32_f16 v5, tma_hi
// CHECK: [0x6f,0x16,0x0a,0x7e]

v_cvt_f32_f16 v5, ttmp11
// CHECK: [0x7b,0x16,0x0a,0x7e]

v_cvt_f32_f16 v5, m0
// CHECK: [0x7c,0x16,0x0a,0x7e]

v_cvt_f32_f16 v5, exec_lo
// CHECK: [0x7e,0x16,0x0a,0x7e]

v_cvt_f32_f16 v5, exec_hi
// CHECK: [0x7f,0x16,0x0a,0x7e]

v_cvt_f32_f16 v5, 0
// CHECK: [0x80,0x16,0x0a,0x7e]

v_cvt_f32_f16 v5, -1
// CHECK: [0xc1,0x16,0x0a,0x7e]

v_cvt_f32_f16_e64 v5, v1
// CHECK: [0x05,0x00,0x16,0xd3,0x01,0x01,0x00,0x00]

v_cvt_f32_f16_e64 v255, v1
// CHECK: [0xff,0x00,0x16,0xd3,0x01,0x01,0x00,0x00]

v_cvt_f32_f16_e64 v5, v255
// CHECK: [0x05,0x00,0x16,0xd3,0xff,0x01,0x00,0x00]

v_cvt_f32_f16_e64 v5, s1
// CHECK: [0x05,0x00,0x16,0xd3,0x01,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, s103
// CHECK: [0x05,0x00,0x16,0xd3,0x67,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x16,0xd3,0x68,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x16,0xd3,0x69,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x16,0xd3,0x6a,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x16,0xd3,0x6b,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x16,0xd3,0x6c,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x16,0xd3,0x6d,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x16,0xd3,0x6e,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x16,0xd3,0x6f,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x16,0xd3,0x7b,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, m0
// CHECK: [0x05,0x00,0x16,0xd3,0x7c,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x16,0xd3,0x7e,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x16,0xd3,0x7f,0x00,0x00,0x00]

v_cvt_f32_f16_e64 v5, v1 clamp
// CHECK: [0x05,0x08,0x16,0xd3,0x01,0x01,0x00,0x00]

v_cvt_f32_f16_e64 v5, v1 mul:2
// CHECK: [0x05,0x00,0x16,0xd3,0x01,0x01,0x00,0x08]

v_cvt_f32_f16_e64 v5, v1 mul:4
// CHECK: [0x05,0x00,0x16,0xd3,0x01,0x01,0x00,0x10]

v_cvt_f32_f16_e64 v5, v1 div:2
// CHECK: [0x05,0x00,0x16,0xd3,0x01,0x01,0x00,0x18]

v_cvt_rpi_i32_f32 v5, v1
// CHECK: [0x01,0x19,0x0a,0x7e]

v_cvt_rpi_i32_f32 v255, v1
// CHECK: [0x01,0x19,0xfe,0x7f]

v_cvt_rpi_i32_f32 v5, v255
// CHECK: [0xff,0x19,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, s1
// CHECK: [0x01,0x18,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, s103
// CHECK: [0x67,0x18,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, flat_scratch_lo
// CHECK: [0x68,0x18,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, flat_scratch_hi
// CHECK: [0x69,0x18,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, vcc_lo
// CHECK: [0x6a,0x18,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, vcc_hi
// CHECK: [0x6b,0x18,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, tba_lo
// CHECK: [0x6c,0x18,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, tba_hi
// CHECK: [0x6d,0x18,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, tma_lo
// CHECK: [0x6e,0x18,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, tma_hi
// CHECK: [0x6f,0x18,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, ttmp11
// CHECK: [0x7b,0x18,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, m0
// CHECK: [0x7c,0x18,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, exec_lo
// CHECK: [0x7e,0x18,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, exec_hi
// CHECK: [0x7f,0x18,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, 0
// CHECK: [0x80,0x18,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, -1
// CHECK: [0xc1,0x18,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, 0.5
// CHECK: [0xf0,0x18,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, -4.0
// CHECK: [0xf7,0x18,0x0a,0x7e]

v_cvt_rpi_i32_f32 v5, 0xaf123456
// CHECK: [0xff,0x18,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cvt_rpi_i32_f32 v5, 0x3f717273
// CHECK: [0xff,0x18,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cvt_rpi_i32_f32_e64 v5, v1
// CHECK: [0x05,0x00,0x18,0xd3,0x01,0x01,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v255, v1
// CHECK: [0xff,0x00,0x18,0xd3,0x01,0x01,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, v255
// CHECK: [0x05,0x00,0x18,0xd3,0xff,0x01,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, s1
// CHECK: [0x05,0x00,0x18,0xd3,0x01,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, s103
// CHECK: [0x05,0x00,0x18,0xd3,0x67,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x18,0xd3,0x68,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x18,0xd3,0x69,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x18,0xd3,0x6a,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x18,0xd3,0x6b,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x18,0xd3,0x6c,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x18,0xd3,0x6d,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x18,0xd3,0x6e,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x18,0xd3,0x6f,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x18,0xd3,0x7b,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, m0
// CHECK: [0x05,0x00,0x18,0xd3,0x7c,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x18,0xd3,0x7e,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x18,0xd3,0x7f,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, 0
// CHECK: [0x05,0x00,0x18,0xd3,0x80,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, -1
// CHECK: [0x05,0x00,0x18,0xd3,0xc1,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x18,0xd3,0xf0,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x18,0xd3,0xf7,0x00,0x00,0x00]

v_cvt_rpi_i32_f32_e64 v5, -v1
// CHECK: [0x05,0x00,0x18,0xd3,0x01,0x01,0x00,0x20]

v_cvt_rpi_i32_f32_e64 v5, |v1|
// CHECK: [0x05,0x01,0x18,0xd3,0x01,0x01,0x00,0x00]

v_cvt_flr_i32_f32 v5, v1
// CHECK: [0x01,0x1b,0x0a,0x7e]

v_cvt_flr_i32_f32 v255, v1
// CHECK: [0x01,0x1b,0xfe,0x7f]

v_cvt_flr_i32_f32 v5, v255
// CHECK: [0xff,0x1b,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, s1
// CHECK: [0x01,0x1a,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, s103
// CHECK: [0x67,0x1a,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, flat_scratch_lo
// CHECK: [0x68,0x1a,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, flat_scratch_hi
// CHECK: [0x69,0x1a,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, vcc_lo
// CHECK: [0x6a,0x1a,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, vcc_hi
// CHECK: [0x6b,0x1a,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, tba_lo
// CHECK: [0x6c,0x1a,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, tba_hi
// CHECK: [0x6d,0x1a,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, tma_lo
// CHECK: [0x6e,0x1a,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, tma_hi
// CHECK: [0x6f,0x1a,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, ttmp11
// CHECK: [0x7b,0x1a,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, m0
// CHECK: [0x7c,0x1a,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, exec_lo
// CHECK: [0x7e,0x1a,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, exec_hi
// CHECK: [0x7f,0x1a,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, 0
// CHECK: [0x80,0x1a,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, -1
// CHECK: [0xc1,0x1a,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, 0.5
// CHECK: [0xf0,0x1a,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, -4.0
// CHECK: [0xf7,0x1a,0x0a,0x7e]

v_cvt_flr_i32_f32 v5, 0xaf123456
// CHECK: [0xff,0x1a,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cvt_flr_i32_f32 v5, 0x3f717273
// CHECK: [0xff,0x1a,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cvt_flr_i32_f32_e64 v5, v1
// CHECK: [0x05,0x00,0x1a,0xd3,0x01,0x01,0x00,0x00]

v_cvt_flr_i32_f32_e64 v255, v1
// CHECK: [0xff,0x00,0x1a,0xd3,0x01,0x01,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, v255
// CHECK: [0x05,0x00,0x1a,0xd3,0xff,0x01,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, s1
// CHECK: [0x05,0x00,0x1a,0xd3,0x01,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, s103
// CHECK: [0x05,0x00,0x1a,0xd3,0x67,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x1a,0xd3,0x68,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x1a,0xd3,0x69,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x1a,0xd3,0x6a,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x1a,0xd3,0x6b,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x1a,0xd3,0x6c,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x1a,0xd3,0x6d,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x1a,0xd3,0x6e,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x1a,0xd3,0x6f,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x1a,0xd3,0x7b,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, m0
// CHECK: [0x05,0x00,0x1a,0xd3,0x7c,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x1a,0xd3,0x7e,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x1a,0xd3,0x7f,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, 0
// CHECK: [0x05,0x00,0x1a,0xd3,0x80,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, -1
// CHECK: [0x05,0x00,0x1a,0xd3,0xc1,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x1a,0xd3,0xf0,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x1a,0xd3,0xf7,0x00,0x00,0x00]

v_cvt_flr_i32_f32_e64 v5, -v1
// CHECK: [0x05,0x00,0x1a,0xd3,0x01,0x01,0x00,0x20]

v_cvt_flr_i32_f32_e64 v5, |v1|
// CHECK: [0x05,0x01,0x1a,0xd3,0x01,0x01,0x00,0x00]

v_cvt_off_f32_i4 v5, v1
// CHECK: [0x01,0x1d,0x0a,0x7e]

v_cvt_off_f32_i4 v255, v1
// CHECK: [0x01,0x1d,0xfe,0x7f]

v_cvt_off_f32_i4 v5, v255
// CHECK: [0xff,0x1d,0x0a,0x7e]

v_cvt_off_f32_i4 v5, s1
// CHECK: [0x01,0x1c,0x0a,0x7e]

v_cvt_off_f32_i4 v5, s103
// CHECK: [0x67,0x1c,0x0a,0x7e]

v_cvt_off_f32_i4 v5, flat_scratch_lo
// CHECK: [0x68,0x1c,0x0a,0x7e]

v_cvt_off_f32_i4 v5, flat_scratch_hi
// CHECK: [0x69,0x1c,0x0a,0x7e]

v_cvt_off_f32_i4 v5, vcc_lo
// CHECK: [0x6a,0x1c,0x0a,0x7e]

v_cvt_off_f32_i4 v5, vcc_hi
// CHECK: [0x6b,0x1c,0x0a,0x7e]

v_cvt_off_f32_i4 v5, tba_lo
// CHECK: [0x6c,0x1c,0x0a,0x7e]

v_cvt_off_f32_i4 v5, tba_hi
// CHECK: [0x6d,0x1c,0x0a,0x7e]

v_cvt_off_f32_i4 v5, tma_lo
// CHECK: [0x6e,0x1c,0x0a,0x7e]

v_cvt_off_f32_i4 v5, tma_hi
// CHECK: [0x6f,0x1c,0x0a,0x7e]

v_cvt_off_f32_i4 v5, ttmp11
// CHECK: [0x7b,0x1c,0x0a,0x7e]

v_cvt_off_f32_i4 v5, m0
// CHECK: [0x7c,0x1c,0x0a,0x7e]

v_cvt_off_f32_i4 v5, exec_lo
// CHECK: [0x7e,0x1c,0x0a,0x7e]

v_cvt_off_f32_i4 v5, exec_hi
// CHECK: [0x7f,0x1c,0x0a,0x7e]

v_cvt_off_f32_i4 v5, 0
// CHECK: [0x80,0x1c,0x0a,0x7e]

v_cvt_off_f32_i4 v5, -1
// CHECK: [0xc1,0x1c,0x0a,0x7e]

v_cvt_off_f32_i4 v5, 0.5
// CHECK: [0xf0,0x1c,0x0a,0x7e]

v_cvt_off_f32_i4 v5, -4.0
// CHECK: [0xf7,0x1c,0x0a,0x7e]

v_cvt_off_f32_i4 v5, 0x4f
// CHECK: [0xff,0x1c,0x0a,0x7e,0x4f,0x00,0x00,0x00]

v_cvt_off_f32_i4 v5, 0x41
// CHECK: [0xff,0x1c,0x0a,0x7e,0x41,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, v1
// CHECK: [0x05,0x00,0x1c,0xd3,0x01,0x01,0x00,0x00]

v_cvt_off_f32_i4_e64 v255, v1
// CHECK: [0xff,0x00,0x1c,0xd3,0x01,0x01,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, v255
// CHECK: [0x05,0x00,0x1c,0xd3,0xff,0x01,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, s1
// CHECK: [0x05,0x00,0x1c,0xd3,0x01,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, s103
// CHECK: [0x05,0x00,0x1c,0xd3,0x67,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x1c,0xd3,0x68,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x1c,0xd3,0x69,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x1c,0xd3,0x6a,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x1c,0xd3,0x6b,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x1c,0xd3,0x6c,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x1c,0xd3,0x6d,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x1c,0xd3,0x6e,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x1c,0xd3,0x6f,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x1c,0xd3,0x7b,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, m0
// CHECK: [0x05,0x00,0x1c,0xd3,0x7c,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x1c,0xd3,0x7e,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x1c,0xd3,0x7f,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, 0
// CHECK: [0x05,0x00,0x1c,0xd3,0x80,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, -1
// CHECK: [0x05,0x00,0x1c,0xd3,0xc1,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, 0.5
// CHECK: [0x05,0x00,0x1c,0xd3,0xf0,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, -4.0
// CHECK: [0x05,0x00,0x1c,0xd3,0xf7,0x00,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, v1 clamp
// CHECK: [0x05,0x08,0x1c,0xd3,0x01,0x01,0x00,0x00]

v_cvt_off_f32_i4_e64 v5, v1 mul:2
// CHECK: [0x05,0x00,0x1c,0xd3,0x01,0x01,0x00,0x08]

v_cvt_off_f32_i4_e64 v5, v1 mul:4
// CHECK: [0x05,0x00,0x1c,0xd3,0x01,0x01,0x00,0x10]

v_cvt_off_f32_i4_e64 v5, v1 div:2
// CHECK: [0x05,0x00,0x1c,0xd3,0x01,0x01,0x00,0x18]

v_cvt_f32_f64 v5, v[1:2]
// CHECK: [0x01,0x1f,0x0a,0x7e]

v_cvt_f32_f64 v255, v[1:2]
// CHECK: [0x01,0x1f,0xfe,0x7f]

v_cvt_f32_f64 v5, v[254:255]
// CHECK: [0xfe,0x1f,0x0a,0x7e]

v_cvt_f32_f64 v5, s[2:3]
// CHECK: [0x02,0x1e,0x0a,0x7e]

v_cvt_f32_f64 v5, s[4:5]
// CHECK: [0x04,0x1e,0x0a,0x7e]

v_cvt_f32_f64 v5, s[102:103]
// CHECK: [0x66,0x1e,0x0a,0x7e]

v_cvt_f32_f64 v5, flat_scratch
// CHECK: [0x68,0x1e,0x0a,0x7e]

v_cvt_f32_f64 v5, vcc
// CHECK: [0x6a,0x1e,0x0a,0x7e]

v_cvt_f32_f64 v5, tba
// CHECK: [0x6c,0x1e,0x0a,0x7e]

v_cvt_f32_f64 v5, tma
// CHECK: [0x6e,0x1e,0x0a,0x7e]

v_cvt_f32_f64 v5, ttmp[10:11]
// CHECK: [0x7a,0x1e,0x0a,0x7e]

v_cvt_f32_f64 v5, exec
// CHECK: [0x7e,0x1e,0x0a,0x7e]

v_cvt_f32_f64 v5, 0
// CHECK: [0x80,0x1e,0x0a,0x7e]

v_cvt_f32_f64 v5, -1
// CHECK: [0xc1,0x1e,0x0a,0x7e]

v_cvt_f32_f64 v5, 0.5
// CHECK: [0xf0,0x1e,0x0a,0x7e]

v_cvt_f32_f64 v5, -4.0
// CHECK: [0xf7,0x1e,0x0a,0x7e]

v_cvt_f32_f64 v5, 0xaf123456
// CHECK: [0xff,0x1e,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cvt_f32_f64 v5, 0x3f717273
// CHECK: [0xff,0x1e,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cvt_f32_f64_e64 v5, v[1:2]
// CHECK: [0x05,0x00,0x1e,0xd3,0x01,0x01,0x00,0x00]

v_cvt_f32_f64_e64 v255, v[1:2]
// CHECK: [0xff,0x00,0x1e,0xd3,0x01,0x01,0x00,0x00]

v_cvt_f32_f64_e64 v5, v[254:255]
// CHECK: [0x05,0x00,0x1e,0xd3,0xfe,0x01,0x00,0x00]

v_cvt_f32_f64_e64 v5, s[2:3]
// CHECK: [0x05,0x00,0x1e,0xd3,0x02,0x00,0x00,0x00]

v_cvt_f32_f64_e64 v5, s[4:5]
// CHECK: [0x05,0x00,0x1e,0xd3,0x04,0x00,0x00,0x00]

v_cvt_f32_f64_e64 v5, s[102:103]
// CHECK: [0x05,0x00,0x1e,0xd3,0x66,0x00,0x00,0x00]

v_cvt_f32_f64_e64 v5, flat_scratch
// CHECK: [0x05,0x00,0x1e,0xd3,0x68,0x00,0x00,0x00]

v_cvt_f32_f64_e64 v5, vcc
// CHECK: [0x05,0x00,0x1e,0xd3,0x6a,0x00,0x00,0x00]

v_cvt_f32_f64_e64 v5, tba
// CHECK: [0x05,0x00,0x1e,0xd3,0x6c,0x00,0x00,0x00]

v_cvt_f32_f64_e64 v5, tma
// CHECK: [0x05,0x00,0x1e,0xd3,0x6e,0x00,0x00,0x00]

v_cvt_f32_f64_e64 v5, ttmp[10:11]
// CHECK: [0x05,0x00,0x1e,0xd3,0x7a,0x00,0x00,0x00]

v_cvt_f32_f64_e64 v5, exec
// CHECK: [0x05,0x00,0x1e,0xd3,0x7e,0x00,0x00,0x00]

v_cvt_f32_f64_e64 v5, 0
// CHECK: [0x05,0x00,0x1e,0xd3,0x80,0x00,0x00,0x00]

v_cvt_f32_f64_e64 v5, -1
// CHECK: [0x05,0x00,0x1e,0xd3,0xc1,0x00,0x00,0x00]

v_cvt_f32_f64_e64 v5, 0.5
// CHECK: [0x05,0x00,0x1e,0xd3,0xf0,0x00,0x00,0x00]

v_cvt_f32_f64_e64 v5, -4.0
// CHECK: [0x05,0x00,0x1e,0xd3,0xf7,0x00,0x00,0x00]

v_cvt_f32_f64_e64 v5, -v[1:2]
// CHECK: [0x05,0x00,0x1e,0xd3,0x01,0x01,0x00,0x20]

v_cvt_f32_f64_e64 v5, |v[1:2]|
// CHECK: [0x05,0x01,0x1e,0xd3,0x01,0x01,0x00,0x00]

v_cvt_f32_f64_e64 v5, v[1:2] clamp
// CHECK: [0x05,0x08,0x1e,0xd3,0x01,0x01,0x00,0x00]

v_cvt_f32_f64_e64 v5, v[1:2] mul:2
// CHECK: [0x05,0x00,0x1e,0xd3,0x01,0x01,0x00,0x08]

v_cvt_f32_f64_e64 v5, v[1:2] mul:4
// CHECK: [0x05,0x00,0x1e,0xd3,0x01,0x01,0x00,0x10]

v_cvt_f32_f64_e64 v5, v[1:2] div:2
// CHECK: [0x05,0x00,0x1e,0xd3,0x01,0x01,0x00,0x18]

v_cvt_f64_f32 v[5:6], v1
// CHECK: [0x01,0x21,0x0a,0x7e]

v_cvt_f64_f32 v[254:255], v1
// CHECK: [0x01,0x21,0xfc,0x7f]

v_cvt_f64_f32 v[5:6], v255
// CHECK: [0xff,0x21,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], s1
// CHECK: [0x01,0x20,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], s103
// CHECK: [0x67,0x20,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], flat_scratch_lo
// CHECK: [0x68,0x20,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], flat_scratch_hi
// CHECK: [0x69,0x20,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], vcc_lo
// CHECK: [0x6a,0x20,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], vcc_hi
// CHECK: [0x6b,0x20,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], tba_lo
// CHECK: [0x6c,0x20,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], tba_hi
// CHECK: [0x6d,0x20,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], tma_lo
// CHECK: [0x6e,0x20,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], tma_hi
// CHECK: [0x6f,0x20,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], ttmp11
// CHECK: [0x7b,0x20,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], m0
// CHECK: [0x7c,0x20,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], exec_lo
// CHECK: [0x7e,0x20,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], exec_hi
// CHECK: [0x7f,0x20,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], 0
// CHECK: [0x80,0x20,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], -1
// CHECK: [0xc1,0x20,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], 0.5
// CHECK: [0xf0,0x20,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], -4.0
// CHECK: [0xf7,0x20,0x0a,0x7e]

v_cvt_f64_f32 v[5:6], 0xaf123456
// CHECK: [0xff,0x20,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cvt_f64_f32 v[5:6], 0x3f717273
// CHECK: [0xff,0x20,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cvt_f64_f32_e64 v[5:6], v1
// CHECK: [0x05,0x00,0x20,0xd3,0x01,0x01,0x00,0x00]

v_cvt_f64_f32_e64 v[254:255], v1
// CHECK: [0xfe,0x00,0x20,0xd3,0x01,0x01,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], v255
// CHECK: [0x05,0x00,0x20,0xd3,0xff,0x01,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], s1
// CHECK: [0x05,0x00,0x20,0xd3,0x01,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], s103
// CHECK: [0x05,0x00,0x20,0xd3,0x67,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], flat_scratch_lo
// CHECK: [0x05,0x00,0x20,0xd3,0x68,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], flat_scratch_hi
// CHECK: [0x05,0x00,0x20,0xd3,0x69,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], vcc_lo
// CHECK: [0x05,0x00,0x20,0xd3,0x6a,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], vcc_hi
// CHECK: [0x05,0x00,0x20,0xd3,0x6b,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], tba_lo
// CHECK: [0x05,0x00,0x20,0xd3,0x6c,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], tba_hi
// CHECK: [0x05,0x00,0x20,0xd3,0x6d,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], tma_lo
// CHECK: [0x05,0x00,0x20,0xd3,0x6e,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], tma_hi
// CHECK: [0x05,0x00,0x20,0xd3,0x6f,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], ttmp11
// CHECK: [0x05,0x00,0x20,0xd3,0x7b,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], m0
// CHECK: [0x05,0x00,0x20,0xd3,0x7c,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], exec_lo
// CHECK: [0x05,0x00,0x20,0xd3,0x7e,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], exec_hi
// CHECK: [0x05,0x00,0x20,0xd3,0x7f,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], 0
// CHECK: [0x05,0x00,0x20,0xd3,0x80,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], -1
// CHECK: [0x05,0x00,0x20,0xd3,0xc1,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], 0.5
// CHECK: [0x05,0x00,0x20,0xd3,0xf0,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], -4.0
// CHECK: [0x05,0x00,0x20,0xd3,0xf7,0x00,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], -v1
// CHECK: [0x05,0x00,0x20,0xd3,0x01,0x01,0x00,0x20]

v_cvt_f64_f32_e64 v[5:6], |v1|
// CHECK: [0x05,0x01,0x20,0xd3,0x01,0x01,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], v1 clamp
// CHECK: [0x05,0x08,0x20,0xd3,0x01,0x01,0x00,0x00]

v_cvt_f64_f32_e64 v[5:6], v1 mul:2
// CHECK: [0x05,0x00,0x20,0xd3,0x01,0x01,0x00,0x08]

v_cvt_f64_f32_e64 v[5:6], v1 mul:4
// CHECK: [0x05,0x00,0x20,0xd3,0x01,0x01,0x00,0x10]

v_cvt_f64_f32_e64 v[5:6], v1 div:2
// CHECK: [0x05,0x00,0x20,0xd3,0x01,0x01,0x00,0x18]

v_cvt_f32_ubyte0 v5, v1
// CHECK: [0x01,0x23,0x0a,0x7e]

v_cvt_f32_ubyte0 v255, v1
// CHECK: [0x01,0x23,0xfe,0x7f]

v_cvt_f32_ubyte0 v5, v255
// CHECK: [0xff,0x23,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, s1
// CHECK: [0x01,0x22,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, s103
// CHECK: [0x67,0x22,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, flat_scratch_lo
// CHECK: [0x68,0x22,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, flat_scratch_hi
// CHECK: [0x69,0x22,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, vcc_lo
// CHECK: [0x6a,0x22,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, vcc_hi
// CHECK: [0x6b,0x22,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, tba_lo
// CHECK: [0x6c,0x22,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, tba_hi
// CHECK: [0x6d,0x22,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, tma_lo
// CHECK: [0x6e,0x22,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, tma_hi
// CHECK: [0x6f,0x22,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, ttmp11
// CHECK: [0x7b,0x22,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, m0
// CHECK: [0x7c,0x22,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, exec_lo
// CHECK: [0x7e,0x22,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, exec_hi
// CHECK: [0x7f,0x22,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, 0
// CHECK: [0x80,0x22,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, -1
// CHECK: [0xc1,0x22,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, 0.5
// CHECK: [0xf0,0x22,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, -4.0
// CHECK: [0xf7,0x22,0x0a,0x7e]

v_cvt_f32_ubyte0 v5, 0xaf123456
// CHECK: [0xff,0x22,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cvt_f32_ubyte0 v5, 0x3f717273
// CHECK: [0xff,0x22,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cvt_f32_ubyte0_e64 v5, v1
// CHECK: [0x05,0x00,0x22,0xd3,0x01,0x01,0x00,0x00]

v_cvt_f32_ubyte0_e64 v255, v1
// CHECK: [0xff,0x00,0x22,0xd3,0x01,0x01,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, v255
// CHECK: [0x05,0x00,0x22,0xd3,0xff,0x01,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, s1
// CHECK: [0x05,0x00,0x22,0xd3,0x01,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, s103
// CHECK: [0x05,0x00,0x22,0xd3,0x67,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x22,0xd3,0x68,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x22,0xd3,0x69,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x22,0xd3,0x6a,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x22,0xd3,0x6b,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x22,0xd3,0x6c,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x22,0xd3,0x6d,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x22,0xd3,0x6e,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x22,0xd3,0x6f,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x22,0xd3,0x7b,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, m0
// CHECK: [0x05,0x00,0x22,0xd3,0x7c,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x22,0xd3,0x7e,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x22,0xd3,0x7f,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, 0
// CHECK: [0x05,0x00,0x22,0xd3,0x80,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, -1
// CHECK: [0x05,0x00,0x22,0xd3,0xc1,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, 0.5
// CHECK: [0x05,0x00,0x22,0xd3,0xf0,0x00,0x00,0x00]

v_cvt_f32_ubyte0_e64 v5, -4.0
// CHECK: [0x05,0x00,0x22,0xd3,0xf7,0x00,0x00,0x00]

v_cvt_f32_ubyte1 v5, v1
// CHECK: [0x01,0x25,0x0a,0x7e]

v_cvt_f32_ubyte1 v255, v1
// CHECK: [0x01,0x25,0xfe,0x7f]

v_cvt_f32_ubyte1 v5, v255
// CHECK: [0xff,0x25,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, s1
// CHECK: [0x01,0x24,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, s103
// CHECK: [0x67,0x24,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, flat_scratch_lo
// CHECK: [0x68,0x24,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, flat_scratch_hi
// CHECK: [0x69,0x24,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, vcc_lo
// CHECK: [0x6a,0x24,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, vcc_hi
// CHECK: [0x6b,0x24,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, tba_lo
// CHECK: [0x6c,0x24,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, tba_hi
// CHECK: [0x6d,0x24,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, tma_lo
// CHECK: [0x6e,0x24,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, tma_hi
// CHECK: [0x6f,0x24,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, ttmp11
// CHECK: [0x7b,0x24,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, m0
// CHECK: [0x7c,0x24,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, exec_lo
// CHECK: [0x7e,0x24,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, exec_hi
// CHECK: [0x7f,0x24,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, 0
// CHECK: [0x80,0x24,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, -1
// CHECK: [0xc1,0x24,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, 0.5
// CHECK: [0xf0,0x24,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, -4.0
// CHECK: [0xf7,0x24,0x0a,0x7e]

v_cvt_f32_ubyte1 v5, 0xaf123456
// CHECK: [0xff,0x24,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cvt_f32_ubyte1 v5, 0x3f717273
// CHECK: [0xff,0x24,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cvt_f32_ubyte1_e64 v5, v1
// CHECK: [0x05,0x00,0x24,0xd3,0x01,0x01,0x00,0x00]

v_cvt_f32_ubyte1_e64 v255, v1
// CHECK: [0xff,0x00,0x24,0xd3,0x01,0x01,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, v255
// CHECK: [0x05,0x00,0x24,0xd3,0xff,0x01,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, s1
// CHECK: [0x05,0x00,0x24,0xd3,0x01,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, s103
// CHECK: [0x05,0x00,0x24,0xd3,0x67,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x24,0xd3,0x68,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x24,0xd3,0x69,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x24,0xd3,0x6a,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x24,0xd3,0x6b,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x24,0xd3,0x6c,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x24,0xd3,0x6d,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x24,0xd3,0x6e,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x24,0xd3,0x6f,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x24,0xd3,0x7b,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, m0
// CHECK: [0x05,0x00,0x24,0xd3,0x7c,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x24,0xd3,0x7e,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x24,0xd3,0x7f,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, 0
// CHECK: [0x05,0x00,0x24,0xd3,0x80,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, -1
// CHECK: [0x05,0x00,0x24,0xd3,0xc1,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, 0.5
// CHECK: [0x05,0x00,0x24,0xd3,0xf0,0x00,0x00,0x00]

v_cvt_f32_ubyte1_e64 v5, -4.0
// CHECK: [0x05,0x00,0x24,0xd3,0xf7,0x00,0x00,0x00]

v_cvt_f32_ubyte2 v5, v1
// CHECK: [0x01,0x27,0x0a,0x7e]

v_cvt_f32_ubyte2 v255, v1
// CHECK: [0x01,0x27,0xfe,0x7f]

v_cvt_f32_ubyte2 v5, v255
// CHECK: [0xff,0x27,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, s1
// CHECK: [0x01,0x26,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, s103
// CHECK: [0x67,0x26,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, flat_scratch_lo
// CHECK: [0x68,0x26,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, flat_scratch_hi
// CHECK: [0x69,0x26,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, vcc_lo
// CHECK: [0x6a,0x26,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, vcc_hi
// CHECK: [0x6b,0x26,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, tba_lo
// CHECK: [0x6c,0x26,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, tba_hi
// CHECK: [0x6d,0x26,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, tma_lo
// CHECK: [0x6e,0x26,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, tma_hi
// CHECK: [0x6f,0x26,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, ttmp11
// CHECK: [0x7b,0x26,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, m0
// CHECK: [0x7c,0x26,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, exec_lo
// CHECK: [0x7e,0x26,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, exec_hi
// CHECK: [0x7f,0x26,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, 0
// CHECK: [0x80,0x26,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, -1
// CHECK: [0xc1,0x26,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, 0.5
// CHECK: [0xf0,0x26,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, -4.0
// CHECK: [0xf7,0x26,0x0a,0x7e]

v_cvt_f32_ubyte2 v5, 0xaf123456
// CHECK: [0xff,0x26,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cvt_f32_ubyte2 v5, 0x3f717273
// CHECK: [0xff,0x26,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cvt_f32_ubyte2_e64 v5, v1
// CHECK: [0x05,0x00,0x26,0xd3,0x01,0x01,0x00,0x00]

v_cvt_f32_ubyte2_e64 v255, v1
// CHECK: [0xff,0x00,0x26,0xd3,0x01,0x01,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, v255
// CHECK: [0x05,0x00,0x26,0xd3,0xff,0x01,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, s1
// CHECK: [0x05,0x00,0x26,0xd3,0x01,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, s103
// CHECK: [0x05,0x00,0x26,0xd3,0x67,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x26,0xd3,0x68,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x26,0xd3,0x69,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x26,0xd3,0x6a,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x26,0xd3,0x6b,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x26,0xd3,0x6c,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x26,0xd3,0x6d,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x26,0xd3,0x6e,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x26,0xd3,0x6f,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x26,0xd3,0x7b,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, m0
// CHECK: [0x05,0x00,0x26,0xd3,0x7c,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x26,0xd3,0x7e,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x26,0xd3,0x7f,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, 0
// CHECK: [0x05,0x00,0x26,0xd3,0x80,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, -1
// CHECK: [0x05,0x00,0x26,0xd3,0xc1,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, 0.5
// CHECK: [0x05,0x00,0x26,0xd3,0xf0,0x00,0x00,0x00]

v_cvt_f32_ubyte2_e64 v5, -4.0
// CHECK: [0x05,0x00,0x26,0xd3,0xf7,0x00,0x00,0x00]

v_cvt_f32_ubyte3 v5, v1
// CHECK: [0x01,0x29,0x0a,0x7e]

v_cvt_f32_ubyte3 v255, v1
// CHECK: [0x01,0x29,0xfe,0x7f]

v_cvt_f32_ubyte3 v5, v255
// CHECK: [0xff,0x29,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, s1
// CHECK: [0x01,0x28,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, s103
// CHECK: [0x67,0x28,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, flat_scratch_lo
// CHECK: [0x68,0x28,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, flat_scratch_hi
// CHECK: [0x69,0x28,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, vcc_lo
// CHECK: [0x6a,0x28,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, vcc_hi
// CHECK: [0x6b,0x28,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, tba_lo
// CHECK: [0x6c,0x28,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, tba_hi
// CHECK: [0x6d,0x28,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, tma_lo
// CHECK: [0x6e,0x28,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, tma_hi
// CHECK: [0x6f,0x28,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, ttmp11
// CHECK: [0x7b,0x28,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, m0
// CHECK: [0x7c,0x28,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, exec_lo
// CHECK: [0x7e,0x28,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, exec_hi
// CHECK: [0x7f,0x28,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, 0
// CHECK: [0x80,0x28,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, -1
// CHECK: [0xc1,0x28,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, 0.5
// CHECK: [0xf0,0x28,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, -4.0
// CHECK: [0xf7,0x28,0x0a,0x7e]

v_cvt_f32_ubyte3 v5, 0xaf123456
// CHECK: [0xff,0x28,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cvt_f32_ubyte3 v5, 0x3f717273
// CHECK: [0xff,0x28,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cvt_f32_ubyte3_e64 v5, v1
// CHECK: [0x05,0x00,0x28,0xd3,0x01,0x01,0x00,0x00]

v_cvt_f32_ubyte3_e64 v255, v1
// CHECK: [0xff,0x00,0x28,0xd3,0x01,0x01,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, v255
// CHECK: [0x05,0x00,0x28,0xd3,0xff,0x01,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, s1
// CHECK: [0x05,0x00,0x28,0xd3,0x01,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, s103
// CHECK: [0x05,0x00,0x28,0xd3,0x67,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x28,0xd3,0x68,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x28,0xd3,0x69,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x28,0xd3,0x6a,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x28,0xd3,0x6b,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x28,0xd3,0x6c,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x28,0xd3,0x6d,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x28,0xd3,0x6e,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x28,0xd3,0x6f,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x28,0xd3,0x7b,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, m0
// CHECK: [0x05,0x00,0x28,0xd3,0x7c,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x28,0xd3,0x7e,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x28,0xd3,0x7f,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, 0
// CHECK: [0x05,0x00,0x28,0xd3,0x80,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, -1
// CHECK: [0x05,0x00,0x28,0xd3,0xc1,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, 0.5
// CHECK: [0x05,0x00,0x28,0xd3,0xf0,0x00,0x00,0x00]

v_cvt_f32_ubyte3_e64 v5, -4.0
// CHECK: [0x05,0x00,0x28,0xd3,0xf7,0x00,0x00,0x00]

v_cvt_u32_f64 v5, v[1:2]
// CHECK: [0x01,0x2b,0x0a,0x7e]

v_cvt_u32_f64 v255, v[1:2]
// CHECK: [0x01,0x2b,0xfe,0x7f]

v_cvt_u32_f64 v5, v[254:255]
// CHECK: [0xfe,0x2b,0x0a,0x7e]

v_cvt_u32_f64 v5, s[2:3]
// CHECK: [0x02,0x2a,0x0a,0x7e]

v_cvt_u32_f64 v5, s[4:5]
// CHECK: [0x04,0x2a,0x0a,0x7e]

v_cvt_u32_f64 v5, s[102:103]
// CHECK: [0x66,0x2a,0x0a,0x7e]

v_cvt_u32_f64 v5, flat_scratch
// CHECK: [0x68,0x2a,0x0a,0x7e]

v_cvt_u32_f64 v5, vcc
// CHECK: [0x6a,0x2a,0x0a,0x7e]

v_cvt_u32_f64 v5, tba
// CHECK: [0x6c,0x2a,0x0a,0x7e]

v_cvt_u32_f64 v5, tma
// CHECK: [0x6e,0x2a,0x0a,0x7e]

v_cvt_u32_f64 v5, ttmp[10:11]
// CHECK: [0x7a,0x2a,0x0a,0x7e]

v_cvt_u32_f64 v5, exec
// CHECK: [0x7e,0x2a,0x0a,0x7e]

v_cvt_u32_f64 v5, 0
// CHECK: [0x80,0x2a,0x0a,0x7e]

v_cvt_u32_f64 v5, -1
// CHECK: [0xc1,0x2a,0x0a,0x7e]

v_cvt_u32_f64 v5, 0.5
// CHECK: [0xf0,0x2a,0x0a,0x7e]

v_cvt_u32_f64 v5, -4.0
// CHECK: [0xf7,0x2a,0x0a,0x7e]

v_cvt_u32_f64 v5, 0xaf123456
// CHECK: [0xff,0x2a,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cvt_u32_f64 v5, 0x3f717273
// CHECK: [0xff,0x2a,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cvt_u32_f64_e64 v5, v[1:2]
// CHECK: [0x05,0x00,0x2a,0xd3,0x01,0x01,0x00,0x00]

v_cvt_u32_f64_e64 v255, v[1:2]
// CHECK: [0xff,0x00,0x2a,0xd3,0x01,0x01,0x00,0x00]

v_cvt_u32_f64_e64 v5, v[254:255]
// CHECK: [0x05,0x00,0x2a,0xd3,0xfe,0x01,0x00,0x00]

v_cvt_u32_f64_e64 v5, s[2:3]
// CHECK: [0x05,0x00,0x2a,0xd3,0x02,0x00,0x00,0x00]

v_cvt_u32_f64_e64 v5, s[4:5]
// CHECK: [0x05,0x00,0x2a,0xd3,0x04,0x00,0x00,0x00]

v_cvt_u32_f64_e64 v5, s[102:103]
// CHECK: [0x05,0x00,0x2a,0xd3,0x66,0x00,0x00,0x00]

v_cvt_u32_f64_e64 v5, flat_scratch
// CHECK: [0x05,0x00,0x2a,0xd3,0x68,0x00,0x00,0x00]

v_cvt_u32_f64_e64 v5, vcc
// CHECK: [0x05,0x00,0x2a,0xd3,0x6a,0x00,0x00,0x00]

v_cvt_u32_f64_e64 v5, tba
// CHECK: [0x05,0x00,0x2a,0xd3,0x6c,0x00,0x00,0x00]

v_cvt_u32_f64_e64 v5, tma
// CHECK: [0x05,0x00,0x2a,0xd3,0x6e,0x00,0x00,0x00]

v_cvt_u32_f64_e64 v5, ttmp[10:11]
// CHECK: [0x05,0x00,0x2a,0xd3,0x7a,0x00,0x00,0x00]

v_cvt_u32_f64_e64 v5, exec
// CHECK: [0x05,0x00,0x2a,0xd3,0x7e,0x00,0x00,0x00]

v_cvt_u32_f64_e64 v5, 0
// CHECK: [0x05,0x00,0x2a,0xd3,0x80,0x00,0x00,0x00]

v_cvt_u32_f64_e64 v5, -1
// CHECK: [0x05,0x00,0x2a,0xd3,0xc1,0x00,0x00,0x00]

v_cvt_u32_f64_e64 v5, 0.5
// CHECK: [0x05,0x00,0x2a,0xd3,0xf0,0x00,0x00,0x00]

v_cvt_u32_f64_e64 v5, -4.0
// CHECK: [0x05,0x00,0x2a,0xd3,0xf7,0x00,0x00,0x00]

v_cvt_u32_f64_e64 v5, -v[1:2]
// CHECK: [0x05,0x00,0x2a,0xd3,0x01,0x01,0x00,0x20]

v_cvt_u32_f64_e64 v5, |v[1:2]|
// CHECK: [0x05,0x01,0x2a,0xd3,0x01,0x01,0x00,0x00]

v_cvt_f64_u32 v[5:6], v1
// CHECK: [0x01,0x2d,0x0a,0x7e]

v_cvt_f64_u32 v[254:255], v1
// CHECK: [0x01,0x2d,0xfc,0x7f]

v_cvt_f64_u32 v[5:6], v255
// CHECK: [0xff,0x2d,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], s1
// CHECK: [0x01,0x2c,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], s103
// CHECK: [0x67,0x2c,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], flat_scratch_lo
// CHECK: [0x68,0x2c,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], flat_scratch_hi
// CHECK: [0x69,0x2c,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], vcc_lo
// CHECK: [0x6a,0x2c,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], vcc_hi
// CHECK: [0x6b,0x2c,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], tba_lo
// CHECK: [0x6c,0x2c,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], tba_hi
// CHECK: [0x6d,0x2c,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], tma_lo
// CHECK: [0x6e,0x2c,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], tma_hi
// CHECK: [0x6f,0x2c,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], ttmp11
// CHECK: [0x7b,0x2c,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], m0
// CHECK: [0x7c,0x2c,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], exec_lo
// CHECK: [0x7e,0x2c,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], exec_hi
// CHECK: [0x7f,0x2c,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], 0
// CHECK: [0x80,0x2c,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], -1
// CHECK: [0xc1,0x2c,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], 0.5
// CHECK: [0xf0,0x2c,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], -4.0
// CHECK: [0xf7,0x2c,0x0a,0x7e]

v_cvt_f64_u32 v[5:6], 0xaf123456
// CHECK: [0xff,0x2c,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cvt_f64_u32 v[5:6], 0x3f717273
// CHECK: [0xff,0x2c,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cvt_f64_u32_e64 v[5:6], v1
// CHECK: [0x05,0x00,0x2c,0xd3,0x01,0x01,0x00,0x00]

v_cvt_f64_u32_e64 v[254:255], v1
// CHECK: [0xfe,0x00,0x2c,0xd3,0x01,0x01,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], v255
// CHECK: [0x05,0x00,0x2c,0xd3,0xff,0x01,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], s1
// CHECK: [0x05,0x00,0x2c,0xd3,0x01,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], s103
// CHECK: [0x05,0x00,0x2c,0xd3,0x67,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], flat_scratch_lo
// CHECK: [0x05,0x00,0x2c,0xd3,0x68,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], flat_scratch_hi
// CHECK: [0x05,0x00,0x2c,0xd3,0x69,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], vcc_lo
// CHECK: [0x05,0x00,0x2c,0xd3,0x6a,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], vcc_hi
// CHECK: [0x05,0x00,0x2c,0xd3,0x6b,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], tba_lo
// CHECK: [0x05,0x00,0x2c,0xd3,0x6c,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], tba_hi
// CHECK: [0x05,0x00,0x2c,0xd3,0x6d,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], tma_lo
// CHECK: [0x05,0x00,0x2c,0xd3,0x6e,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], tma_hi
// CHECK: [0x05,0x00,0x2c,0xd3,0x6f,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], ttmp11
// CHECK: [0x05,0x00,0x2c,0xd3,0x7b,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], m0
// CHECK: [0x05,0x00,0x2c,0xd3,0x7c,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], exec_lo
// CHECK: [0x05,0x00,0x2c,0xd3,0x7e,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], exec_hi
// CHECK: [0x05,0x00,0x2c,0xd3,0x7f,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], 0
// CHECK: [0x05,0x00,0x2c,0xd3,0x80,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], -1
// CHECK: [0x05,0x00,0x2c,0xd3,0xc1,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], 0.5
// CHECK: [0x05,0x00,0x2c,0xd3,0xf0,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], -4.0
// CHECK: [0x05,0x00,0x2c,0xd3,0xf7,0x00,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], v1 clamp
// CHECK: [0x05,0x08,0x2c,0xd3,0x01,0x01,0x00,0x00]

v_cvt_f64_u32_e64 v[5:6], v1 mul:2
// CHECK: [0x05,0x00,0x2c,0xd3,0x01,0x01,0x00,0x08]

v_cvt_f64_u32_e64 v[5:6], v1 mul:4
// CHECK: [0x05,0x00,0x2c,0xd3,0x01,0x01,0x00,0x10]

v_cvt_f64_u32_e64 v[5:6], v1 div:2
// CHECK: [0x05,0x00,0x2c,0xd3,0x01,0x01,0x00,0x18]

v_trunc_f64 v[5:6], v[1:2]
// CHECK: [0x01,0x2f,0x0a,0x7e]

v_trunc_f64 v[254:255], v[1:2]
// CHECK: [0x01,0x2f,0xfc,0x7f]

v_trunc_f64 v[5:6], v[254:255]
// CHECK: [0xfe,0x2f,0x0a,0x7e]

v_trunc_f64 v[5:6], s[2:3]
// CHECK: [0x02,0x2e,0x0a,0x7e]

v_trunc_f64 v[5:6], s[4:5]
// CHECK: [0x04,0x2e,0x0a,0x7e]

v_trunc_f64 v[5:6], s[102:103]
// CHECK: [0x66,0x2e,0x0a,0x7e]

v_trunc_f64 v[5:6], flat_scratch
// CHECK: [0x68,0x2e,0x0a,0x7e]

v_trunc_f64 v[5:6], vcc
// CHECK: [0x6a,0x2e,0x0a,0x7e]

v_trunc_f64 v[5:6], tba
// CHECK: [0x6c,0x2e,0x0a,0x7e]

v_trunc_f64 v[5:6], tma
// CHECK: [0x6e,0x2e,0x0a,0x7e]

v_trunc_f64 v[5:6], ttmp[10:11]
// CHECK: [0x7a,0x2e,0x0a,0x7e]

v_trunc_f64 v[5:6], exec
// CHECK: [0x7e,0x2e,0x0a,0x7e]

v_trunc_f64 v[5:6], 0
// CHECK: [0x80,0x2e,0x0a,0x7e]

v_trunc_f64 v[5:6], -1
// CHECK: [0xc1,0x2e,0x0a,0x7e]

v_trunc_f64 v[5:6], 0.5
// CHECK: [0xf0,0x2e,0x0a,0x7e]

v_trunc_f64 v[5:6], -4.0
// CHECK: [0xf7,0x2e,0x0a,0x7e]

v_trunc_f64 v[5:6], 0xaf123456
// CHECK: [0xff,0x2e,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_trunc_f64 v[5:6], 0x3f717273
// CHECK: [0xff,0x2e,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_trunc_f64_e64 v[5:6], v[1:2]
// CHECK: [0x05,0x00,0x2e,0xd3,0x01,0x01,0x00,0x00]

v_trunc_f64_e64 v[254:255], v[1:2]
// CHECK: [0xfe,0x00,0x2e,0xd3,0x01,0x01,0x00,0x00]

v_trunc_f64_e64 v[5:6], v[254:255]
// CHECK: [0x05,0x00,0x2e,0xd3,0xfe,0x01,0x00,0x00]

v_trunc_f64_e64 v[5:6], s[2:3]
// CHECK: [0x05,0x00,0x2e,0xd3,0x02,0x00,0x00,0x00]

v_trunc_f64_e64 v[5:6], s[4:5]
// CHECK: [0x05,0x00,0x2e,0xd3,0x04,0x00,0x00,0x00]

v_trunc_f64_e64 v[5:6], s[102:103]
// CHECK: [0x05,0x00,0x2e,0xd3,0x66,0x00,0x00,0x00]

v_trunc_f64_e64 v[5:6], flat_scratch
// CHECK: [0x05,0x00,0x2e,0xd3,0x68,0x00,0x00,0x00]

v_trunc_f64_e64 v[5:6], vcc
// CHECK: [0x05,0x00,0x2e,0xd3,0x6a,0x00,0x00,0x00]

v_trunc_f64_e64 v[5:6], tba
// CHECK: [0x05,0x00,0x2e,0xd3,0x6c,0x00,0x00,0x00]

v_trunc_f64_e64 v[5:6], tma
// CHECK: [0x05,0x00,0x2e,0xd3,0x6e,0x00,0x00,0x00]

v_trunc_f64_e64 v[5:6], ttmp[10:11]
// CHECK: [0x05,0x00,0x2e,0xd3,0x7a,0x00,0x00,0x00]

v_trunc_f64_e64 v[5:6], exec
// CHECK: [0x05,0x00,0x2e,0xd3,0x7e,0x00,0x00,0x00]

v_trunc_f64_e64 v[5:6], 0
// CHECK: [0x05,0x00,0x2e,0xd3,0x80,0x00,0x00,0x00]

v_trunc_f64_e64 v[5:6], -1
// CHECK: [0x05,0x00,0x2e,0xd3,0xc1,0x00,0x00,0x00]

v_trunc_f64_e64 v[5:6], 0.5
// CHECK: [0x05,0x00,0x2e,0xd3,0xf0,0x00,0x00,0x00]

v_trunc_f64_e64 v[5:6], -4.0
// CHECK: [0x05,0x00,0x2e,0xd3,0xf7,0x00,0x00,0x00]

v_trunc_f64_e64 v[5:6], -v[1:2]
// CHECK: [0x05,0x00,0x2e,0xd3,0x01,0x01,0x00,0x20]

v_trunc_f64_e64 v[5:6], |v[1:2]|
// CHECK: [0x05,0x01,0x2e,0xd3,0x01,0x01,0x00,0x00]

v_trunc_f64_e64 v[5:6], v[1:2] clamp
// CHECK: [0x05,0x08,0x2e,0xd3,0x01,0x01,0x00,0x00]

v_trunc_f64_e64 v[5:6], v[1:2] mul:2
// CHECK: [0x05,0x00,0x2e,0xd3,0x01,0x01,0x00,0x08]

v_trunc_f64_e64 v[5:6], v[1:2] mul:4
// CHECK: [0x05,0x00,0x2e,0xd3,0x01,0x01,0x00,0x10]

v_trunc_f64_e64 v[5:6], v[1:2] div:2
// CHECK: [0x05,0x00,0x2e,0xd3,0x01,0x01,0x00,0x18]

v_ceil_f64 v[5:6], v[1:2]
// CHECK: [0x01,0x31,0x0a,0x7e]

v_ceil_f64 v[254:255], v[1:2]
// CHECK: [0x01,0x31,0xfc,0x7f]

v_ceil_f64 v[5:6], v[254:255]
// CHECK: [0xfe,0x31,0x0a,0x7e]

v_ceil_f64 v[5:6], s[2:3]
// CHECK: [0x02,0x30,0x0a,0x7e]

v_ceil_f64 v[5:6], s[4:5]
// CHECK: [0x04,0x30,0x0a,0x7e]

v_ceil_f64 v[5:6], s[102:103]
// CHECK: [0x66,0x30,0x0a,0x7e]

v_ceil_f64 v[5:6], flat_scratch
// CHECK: [0x68,0x30,0x0a,0x7e]

v_ceil_f64 v[5:6], vcc
// CHECK: [0x6a,0x30,0x0a,0x7e]

v_ceil_f64 v[5:6], tba
// CHECK: [0x6c,0x30,0x0a,0x7e]

v_ceil_f64 v[5:6], tma
// CHECK: [0x6e,0x30,0x0a,0x7e]

v_ceil_f64 v[5:6], ttmp[10:11]
// CHECK: [0x7a,0x30,0x0a,0x7e]

v_ceil_f64 v[5:6], exec
// CHECK: [0x7e,0x30,0x0a,0x7e]

v_ceil_f64 v[5:6], 0
// CHECK: [0x80,0x30,0x0a,0x7e]

v_ceil_f64 v[5:6], -1
// CHECK: [0xc1,0x30,0x0a,0x7e]

v_ceil_f64 v[5:6], 0.5
// CHECK: [0xf0,0x30,0x0a,0x7e]

v_ceil_f64 v[5:6], -4.0
// CHECK: [0xf7,0x30,0x0a,0x7e]

v_ceil_f64 v[5:6], 0xaf123456
// CHECK: [0xff,0x30,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_ceil_f64 v[5:6], 0x3f717273
// CHECK: [0xff,0x30,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_ceil_f64_e64 v[5:6], v[1:2]
// CHECK: [0x05,0x00,0x30,0xd3,0x01,0x01,0x00,0x00]

v_ceil_f64_e64 v[254:255], v[1:2]
// CHECK: [0xfe,0x00,0x30,0xd3,0x01,0x01,0x00,0x00]

v_ceil_f64_e64 v[5:6], v[254:255]
// CHECK: [0x05,0x00,0x30,0xd3,0xfe,0x01,0x00,0x00]

v_ceil_f64_e64 v[5:6], s[2:3]
// CHECK: [0x05,0x00,0x30,0xd3,0x02,0x00,0x00,0x00]

v_ceil_f64_e64 v[5:6], s[4:5]
// CHECK: [0x05,0x00,0x30,0xd3,0x04,0x00,0x00,0x00]

v_ceil_f64_e64 v[5:6], s[102:103]
// CHECK: [0x05,0x00,0x30,0xd3,0x66,0x00,0x00,0x00]

v_ceil_f64_e64 v[5:6], flat_scratch
// CHECK: [0x05,0x00,0x30,0xd3,0x68,0x00,0x00,0x00]

v_ceil_f64_e64 v[5:6], vcc
// CHECK: [0x05,0x00,0x30,0xd3,0x6a,0x00,0x00,0x00]

v_ceil_f64_e64 v[5:6], tba
// CHECK: [0x05,0x00,0x30,0xd3,0x6c,0x00,0x00,0x00]

v_ceil_f64_e64 v[5:6], tma
// CHECK: [0x05,0x00,0x30,0xd3,0x6e,0x00,0x00,0x00]

v_ceil_f64_e64 v[5:6], ttmp[10:11]
// CHECK: [0x05,0x00,0x30,0xd3,0x7a,0x00,0x00,0x00]

v_ceil_f64_e64 v[5:6], exec
// CHECK: [0x05,0x00,0x30,0xd3,0x7e,0x00,0x00,0x00]

v_ceil_f64_e64 v[5:6], 0
// CHECK: [0x05,0x00,0x30,0xd3,0x80,0x00,0x00,0x00]

v_ceil_f64_e64 v[5:6], -1
// CHECK: [0x05,0x00,0x30,0xd3,0xc1,0x00,0x00,0x00]

v_ceil_f64_e64 v[5:6], 0.5
// CHECK: [0x05,0x00,0x30,0xd3,0xf0,0x00,0x00,0x00]

v_ceil_f64_e64 v[5:6], -4.0
// CHECK: [0x05,0x00,0x30,0xd3,0xf7,0x00,0x00,0x00]

v_ceil_f64_e64 v[5:6], -v[1:2]
// CHECK: [0x05,0x00,0x30,0xd3,0x01,0x01,0x00,0x20]

v_ceil_f64_e64 v[5:6], |v[1:2]|
// CHECK: [0x05,0x01,0x30,0xd3,0x01,0x01,0x00,0x00]

v_ceil_f64_e64 v[5:6], v[1:2] clamp
// CHECK: [0x05,0x08,0x30,0xd3,0x01,0x01,0x00,0x00]

v_ceil_f64_e64 v[5:6], v[1:2] mul:2
// CHECK: [0x05,0x00,0x30,0xd3,0x01,0x01,0x00,0x08]

v_ceil_f64_e64 v[5:6], v[1:2] mul:4
// CHECK: [0x05,0x00,0x30,0xd3,0x01,0x01,0x00,0x10]

v_ceil_f64_e64 v[5:6], v[1:2] div:2
// CHECK: [0x05,0x00,0x30,0xd3,0x01,0x01,0x00,0x18]

v_rndne_f64 v[5:6], v[1:2]
// CHECK: [0x01,0x33,0x0a,0x7e]

v_rndne_f64 v[254:255], v[1:2]
// CHECK: [0x01,0x33,0xfc,0x7f]

v_rndne_f64 v[5:6], v[254:255]
// CHECK: [0xfe,0x33,0x0a,0x7e]

v_rndne_f64 v[5:6], s[2:3]
// CHECK: [0x02,0x32,0x0a,0x7e]

v_rndne_f64 v[5:6], s[4:5]
// CHECK: [0x04,0x32,0x0a,0x7e]

v_rndne_f64 v[5:6], s[102:103]
// CHECK: [0x66,0x32,0x0a,0x7e]

v_rndne_f64 v[5:6], flat_scratch
// CHECK: [0x68,0x32,0x0a,0x7e]

v_rndne_f64 v[5:6], vcc
// CHECK: [0x6a,0x32,0x0a,0x7e]

v_rndne_f64 v[5:6], tba
// CHECK: [0x6c,0x32,0x0a,0x7e]

v_rndne_f64 v[5:6], tma
// CHECK: [0x6e,0x32,0x0a,0x7e]

v_rndne_f64 v[5:6], ttmp[10:11]
// CHECK: [0x7a,0x32,0x0a,0x7e]

v_rndne_f64 v[5:6], exec
// CHECK: [0x7e,0x32,0x0a,0x7e]

v_rndne_f64 v[5:6], 0
// CHECK: [0x80,0x32,0x0a,0x7e]

v_rndne_f64 v[5:6], -1
// CHECK: [0xc1,0x32,0x0a,0x7e]

v_rndne_f64 v[5:6], 0.5
// CHECK: [0xf0,0x32,0x0a,0x7e]

v_rndne_f64 v[5:6], -4.0
// CHECK: [0xf7,0x32,0x0a,0x7e]

v_rndne_f64 v[5:6], 0xaf123456
// CHECK: [0xff,0x32,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_rndne_f64 v[5:6], 0x3f717273
// CHECK: [0xff,0x32,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_rndne_f64_e64 v[5:6], v[1:2]
// CHECK: [0x05,0x00,0x32,0xd3,0x01,0x01,0x00,0x00]

v_rndne_f64_e64 v[254:255], v[1:2]
// CHECK: [0xfe,0x00,0x32,0xd3,0x01,0x01,0x00,0x00]

v_rndne_f64_e64 v[5:6], v[254:255]
// CHECK: [0x05,0x00,0x32,0xd3,0xfe,0x01,0x00,0x00]

v_rndne_f64_e64 v[5:6], s[2:3]
// CHECK: [0x05,0x00,0x32,0xd3,0x02,0x00,0x00,0x00]

v_rndne_f64_e64 v[5:6], s[4:5]
// CHECK: [0x05,0x00,0x32,0xd3,0x04,0x00,0x00,0x00]

v_rndne_f64_e64 v[5:6], s[102:103]
// CHECK: [0x05,0x00,0x32,0xd3,0x66,0x00,0x00,0x00]

v_rndne_f64_e64 v[5:6], flat_scratch
// CHECK: [0x05,0x00,0x32,0xd3,0x68,0x00,0x00,0x00]

v_rndne_f64_e64 v[5:6], vcc
// CHECK: [0x05,0x00,0x32,0xd3,0x6a,0x00,0x00,0x00]

v_rndne_f64_e64 v[5:6], tba
// CHECK: [0x05,0x00,0x32,0xd3,0x6c,0x00,0x00,0x00]

v_rndne_f64_e64 v[5:6], tma
// CHECK: [0x05,0x00,0x32,0xd3,0x6e,0x00,0x00,0x00]

v_rndne_f64_e64 v[5:6], ttmp[10:11]
// CHECK: [0x05,0x00,0x32,0xd3,0x7a,0x00,0x00,0x00]

v_rndne_f64_e64 v[5:6], exec
// CHECK: [0x05,0x00,0x32,0xd3,0x7e,0x00,0x00,0x00]

v_rndne_f64_e64 v[5:6], 0
// CHECK: [0x05,0x00,0x32,0xd3,0x80,0x00,0x00,0x00]

v_rndne_f64_e64 v[5:6], -1
// CHECK: [0x05,0x00,0x32,0xd3,0xc1,0x00,0x00,0x00]

v_rndne_f64_e64 v[5:6], 0.5
// CHECK: [0x05,0x00,0x32,0xd3,0xf0,0x00,0x00,0x00]

v_rndne_f64_e64 v[5:6], -4.0
// CHECK: [0x05,0x00,0x32,0xd3,0xf7,0x00,0x00,0x00]

v_rndne_f64_e64 v[5:6], -v[1:2]
// CHECK: [0x05,0x00,0x32,0xd3,0x01,0x01,0x00,0x20]

v_rndne_f64_e64 v[5:6], |v[1:2]|
// CHECK: [0x05,0x01,0x32,0xd3,0x01,0x01,0x00,0x00]

v_rndne_f64_e64 v[5:6], v[1:2] clamp
// CHECK: [0x05,0x08,0x32,0xd3,0x01,0x01,0x00,0x00]

v_rndne_f64_e64 v[5:6], v[1:2] mul:2
// CHECK: [0x05,0x00,0x32,0xd3,0x01,0x01,0x00,0x08]

v_rndne_f64_e64 v[5:6], v[1:2] mul:4
// CHECK: [0x05,0x00,0x32,0xd3,0x01,0x01,0x00,0x10]

v_rndne_f64_e64 v[5:6], v[1:2] div:2
// CHECK: [0x05,0x00,0x32,0xd3,0x01,0x01,0x00,0x18]

v_floor_f64 v[5:6], v[1:2]
// CHECK: [0x01,0x35,0x0a,0x7e]

v_floor_f64 v[254:255], v[1:2]
// CHECK: [0x01,0x35,0xfc,0x7f]

v_floor_f64 v[5:6], v[254:255]
// CHECK: [0xfe,0x35,0x0a,0x7e]

v_floor_f64 v[5:6], s[2:3]
// CHECK: [0x02,0x34,0x0a,0x7e]

v_floor_f64 v[5:6], s[4:5]
// CHECK: [0x04,0x34,0x0a,0x7e]

v_floor_f64 v[5:6], s[102:103]
// CHECK: [0x66,0x34,0x0a,0x7e]

v_floor_f64 v[5:6], flat_scratch
// CHECK: [0x68,0x34,0x0a,0x7e]

v_floor_f64 v[5:6], vcc
// CHECK: [0x6a,0x34,0x0a,0x7e]

v_floor_f64 v[5:6], tba
// CHECK: [0x6c,0x34,0x0a,0x7e]

v_floor_f64 v[5:6], tma
// CHECK: [0x6e,0x34,0x0a,0x7e]

v_floor_f64 v[5:6], ttmp[10:11]
// CHECK: [0x7a,0x34,0x0a,0x7e]

v_floor_f64 v[5:6], exec
// CHECK: [0x7e,0x34,0x0a,0x7e]

v_floor_f64 v[5:6], 0
// CHECK: [0x80,0x34,0x0a,0x7e]

v_floor_f64 v[5:6], -1
// CHECK: [0xc1,0x34,0x0a,0x7e]

v_floor_f64 v[5:6], 0.5
// CHECK: [0xf0,0x34,0x0a,0x7e]

v_floor_f64 v[5:6], -4.0
// CHECK: [0xf7,0x34,0x0a,0x7e]

v_floor_f64 v[5:6], 0xaf123456
// CHECK: [0xff,0x34,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_floor_f64 v[5:6], 0x3f717273
// CHECK: [0xff,0x34,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_floor_f64_e64 v[5:6], v[1:2]
// CHECK: [0x05,0x00,0x34,0xd3,0x01,0x01,0x00,0x00]

v_floor_f64_e64 v[254:255], v[1:2]
// CHECK: [0xfe,0x00,0x34,0xd3,0x01,0x01,0x00,0x00]

v_floor_f64_e64 v[5:6], v[254:255]
// CHECK: [0x05,0x00,0x34,0xd3,0xfe,0x01,0x00,0x00]

v_floor_f64_e64 v[5:6], s[2:3]
// CHECK: [0x05,0x00,0x34,0xd3,0x02,0x00,0x00,0x00]

v_floor_f64_e64 v[5:6], s[4:5]
// CHECK: [0x05,0x00,0x34,0xd3,0x04,0x00,0x00,0x00]

v_floor_f64_e64 v[5:6], s[102:103]
// CHECK: [0x05,0x00,0x34,0xd3,0x66,0x00,0x00,0x00]

v_floor_f64_e64 v[5:6], flat_scratch
// CHECK: [0x05,0x00,0x34,0xd3,0x68,0x00,0x00,0x00]

v_floor_f64_e64 v[5:6], vcc
// CHECK: [0x05,0x00,0x34,0xd3,0x6a,0x00,0x00,0x00]

v_floor_f64_e64 v[5:6], tba
// CHECK: [0x05,0x00,0x34,0xd3,0x6c,0x00,0x00,0x00]

v_floor_f64_e64 v[5:6], tma
// CHECK: [0x05,0x00,0x34,0xd3,0x6e,0x00,0x00,0x00]

v_floor_f64_e64 v[5:6], ttmp[10:11]
// CHECK: [0x05,0x00,0x34,0xd3,0x7a,0x00,0x00,0x00]

v_floor_f64_e64 v[5:6], exec
// CHECK: [0x05,0x00,0x34,0xd3,0x7e,0x00,0x00,0x00]

v_floor_f64_e64 v[5:6], 0
// CHECK: [0x05,0x00,0x34,0xd3,0x80,0x00,0x00,0x00]

v_floor_f64_e64 v[5:6], -1
// CHECK: [0x05,0x00,0x34,0xd3,0xc1,0x00,0x00,0x00]

v_floor_f64_e64 v[5:6], 0.5
// CHECK: [0x05,0x00,0x34,0xd3,0xf0,0x00,0x00,0x00]

v_floor_f64_e64 v[5:6], -4.0
// CHECK: [0x05,0x00,0x34,0xd3,0xf7,0x00,0x00,0x00]

v_floor_f64_e64 v[5:6], -v[1:2]
// CHECK: [0x05,0x00,0x34,0xd3,0x01,0x01,0x00,0x20]

v_floor_f64_e64 v[5:6], |v[1:2]|
// CHECK: [0x05,0x01,0x34,0xd3,0x01,0x01,0x00,0x00]

v_floor_f64_e64 v[5:6], v[1:2] clamp
// CHECK: [0x05,0x08,0x34,0xd3,0x01,0x01,0x00,0x00]

v_floor_f64_e64 v[5:6], v[1:2] mul:2
// CHECK: [0x05,0x00,0x34,0xd3,0x01,0x01,0x00,0x08]

v_floor_f64_e64 v[5:6], v[1:2] mul:4
// CHECK: [0x05,0x00,0x34,0xd3,0x01,0x01,0x00,0x10]

v_floor_f64_e64 v[5:6], v[1:2] div:2
// CHECK: [0x05,0x00,0x34,0xd3,0x01,0x01,0x00,0x18]

v_fract_f32 v5, v1
// CHECK: [0x01,0x41,0x0a,0x7e]

v_fract_f32 v255, v1
// CHECK: [0x01,0x41,0xfe,0x7f]

v_fract_f32 v5, v255
// CHECK: [0xff,0x41,0x0a,0x7e]

v_fract_f32 v5, s1
// CHECK: [0x01,0x40,0x0a,0x7e]

v_fract_f32 v5, s103
// CHECK: [0x67,0x40,0x0a,0x7e]

v_fract_f32 v5, flat_scratch_lo
// CHECK: [0x68,0x40,0x0a,0x7e]

v_fract_f32 v5, flat_scratch_hi
// CHECK: [0x69,0x40,0x0a,0x7e]

v_fract_f32 v5, vcc_lo
// CHECK: [0x6a,0x40,0x0a,0x7e]

v_fract_f32 v5, vcc_hi
// CHECK: [0x6b,0x40,0x0a,0x7e]

v_fract_f32 v5, tba_lo
// CHECK: [0x6c,0x40,0x0a,0x7e]

v_fract_f32 v5, tba_hi
// CHECK: [0x6d,0x40,0x0a,0x7e]

v_fract_f32 v5, tma_lo
// CHECK: [0x6e,0x40,0x0a,0x7e]

v_fract_f32 v5, tma_hi
// CHECK: [0x6f,0x40,0x0a,0x7e]

v_fract_f32 v5, ttmp11
// CHECK: [0x7b,0x40,0x0a,0x7e]

v_fract_f32 v5, m0
// CHECK: [0x7c,0x40,0x0a,0x7e]

v_fract_f32 v5, exec_lo
// CHECK: [0x7e,0x40,0x0a,0x7e]

v_fract_f32 v5, exec_hi
// CHECK: [0x7f,0x40,0x0a,0x7e]

v_fract_f32 v5, 0
// CHECK: [0x80,0x40,0x0a,0x7e]

v_fract_f32 v5, -1
// CHECK: [0xc1,0x40,0x0a,0x7e]

v_fract_f32 v5, 0.5
// CHECK: [0xf0,0x40,0x0a,0x7e]

v_fract_f32 v5, -4.0
// CHECK: [0xf7,0x40,0x0a,0x7e]

v_fract_f32 v5, 0xaf123456
// CHECK: [0xff,0x40,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_fract_f32 v5, 0x3f717273
// CHECK: [0xff,0x40,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_fract_f32_e64 v5, v1
// CHECK: [0x05,0x00,0x40,0xd3,0x01,0x01,0x00,0x00]

v_fract_f32_e64 v255, v1
// CHECK: [0xff,0x00,0x40,0xd3,0x01,0x01,0x00,0x00]

v_fract_f32_e64 v5, v255
// CHECK: [0x05,0x00,0x40,0xd3,0xff,0x01,0x00,0x00]

v_fract_f32_e64 v5, s1
// CHECK: [0x05,0x00,0x40,0xd3,0x01,0x00,0x00,0x00]

v_fract_f32_e64 v5, s103
// CHECK: [0x05,0x00,0x40,0xd3,0x67,0x00,0x00,0x00]

v_fract_f32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x40,0xd3,0x68,0x00,0x00,0x00]

v_fract_f32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x40,0xd3,0x69,0x00,0x00,0x00]

v_fract_f32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x40,0xd3,0x6a,0x00,0x00,0x00]

v_fract_f32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x40,0xd3,0x6b,0x00,0x00,0x00]

v_fract_f32_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x40,0xd3,0x6c,0x00,0x00,0x00]

v_fract_f32_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x40,0xd3,0x6d,0x00,0x00,0x00]

v_fract_f32_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x40,0xd3,0x6e,0x00,0x00,0x00]

v_fract_f32_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x40,0xd3,0x6f,0x00,0x00,0x00]

v_fract_f32_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x40,0xd3,0x7b,0x00,0x00,0x00]

v_fract_f32_e64 v5, m0
// CHECK: [0x05,0x00,0x40,0xd3,0x7c,0x00,0x00,0x00]

v_fract_f32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x40,0xd3,0x7e,0x00,0x00,0x00]

v_fract_f32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x40,0xd3,0x7f,0x00,0x00,0x00]

v_fract_f32_e64 v5, 0
// CHECK: [0x05,0x00,0x40,0xd3,0x80,0x00,0x00,0x00]

v_fract_f32_e64 v5, -1
// CHECK: [0x05,0x00,0x40,0xd3,0xc1,0x00,0x00,0x00]

v_fract_f32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x40,0xd3,0xf0,0x00,0x00,0x00]

v_fract_f32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x40,0xd3,0xf7,0x00,0x00,0x00]

v_fract_f32_e64 v5, -v1
// CHECK: [0x05,0x00,0x40,0xd3,0x01,0x01,0x00,0x20]

v_fract_f32_e64 v5, |v1|
// CHECK: [0x05,0x01,0x40,0xd3,0x01,0x01,0x00,0x00]

v_fract_f32_e64 v5, v1 clamp
// CHECK: [0x05,0x08,0x40,0xd3,0x01,0x01,0x00,0x00]

v_fract_f32_e64 v5, v1 mul:2
// CHECK: [0x05,0x00,0x40,0xd3,0x01,0x01,0x00,0x08]

v_fract_f32_e64 v5, v1 mul:4
// CHECK: [0x05,0x00,0x40,0xd3,0x01,0x01,0x00,0x10]

v_fract_f32_e64 v5, v1 div:2
// CHECK: [0x05,0x00,0x40,0xd3,0x01,0x01,0x00,0x18]

v_trunc_f32 v5, v1
// CHECK: [0x01,0x43,0x0a,0x7e]

v_trunc_f32 v255, v1
// CHECK: [0x01,0x43,0xfe,0x7f]

v_trunc_f32 v5, v255
// CHECK: [0xff,0x43,0x0a,0x7e]

v_trunc_f32 v5, s1
// CHECK: [0x01,0x42,0x0a,0x7e]

v_trunc_f32 v5, s103
// CHECK: [0x67,0x42,0x0a,0x7e]

v_trunc_f32 v5, flat_scratch_lo
// CHECK: [0x68,0x42,0x0a,0x7e]

v_trunc_f32 v5, flat_scratch_hi
// CHECK: [0x69,0x42,0x0a,0x7e]

v_trunc_f32 v5, vcc_lo
// CHECK: [0x6a,0x42,0x0a,0x7e]

v_trunc_f32 v5, vcc_hi
// CHECK: [0x6b,0x42,0x0a,0x7e]

v_trunc_f32 v5, tba_lo
// CHECK: [0x6c,0x42,0x0a,0x7e]

v_trunc_f32 v5, tba_hi
// CHECK: [0x6d,0x42,0x0a,0x7e]

v_trunc_f32 v5, tma_lo
// CHECK: [0x6e,0x42,0x0a,0x7e]

v_trunc_f32 v5, tma_hi
// CHECK: [0x6f,0x42,0x0a,0x7e]

v_trunc_f32 v5, ttmp11
// CHECK: [0x7b,0x42,0x0a,0x7e]

v_trunc_f32 v5, m0
// CHECK: [0x7c,0x42,0x0a,0x7e]

v_trunc_f32 v5, exec_lo
// CHECK: [0x7e,0x42,0x0a,0x7e]

v_trunc_f32 v5, exec_hi
// CHECK: [0x7f,0x42,0x0a,0x7e]

v_trunc_f32 v5, 0
// CHECK: [0x80,0x42,0x0a,0x7e]

v_trunc_f32 v5, -1
// CHECK: [0xc1,0x42,0x0a,0x7e]

v_trunc_f32 v5, 0.5
// CHECK: [0xf0,0x42,0x0a,0x7e]

v_trunc_f32 v5, -4.0
// CHECK: [0xf7,0x42,0x0a,0x7e]

v_trunc_f32 v5, 0xaf123456
// CHECK: [0xff,0x42,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_trunc_f32 v5, 0x3f717273
// CHECK: [0xff,0x42,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_trunc_f32_e64 v5, v1
// CHECK: [0x05,0x00,0x42,0xd3,0x01,0x01,0x00,0x00]

v_trunc_f32_e64 v255, v1
// CHECK: [0xff,0x00,0x42,0xd3,0x01,0x01,0x00,0x00]

v_trunc_f32_e64 v5, v255
// CHECK: [0x05,0x00,0x42,0xd3,0xff,0x01,0x00,0x00]

v_trunc_f32_e64 v5, s1
// CHECK: [0x05,0x00,0x42,0xd3,0x01,0x00,0x00,0x00]

v_trunc_f32_e64 v5, s103
// CHECK: [0x05,0x00,0x42,0xd3,0x67,0x00,0x00,0x00]

v_trunc_f32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x42,0xd3,0x68,0x00,0x00,0x00]

v_trunc_f32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x42,0xd3,0x69,0x00,0x00,0x00]

v_trunc_f32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x42,0xd3,0x6a,0x00,0x00,0x00]

v_trunc_f32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x42,0xd3,0x6b,0x00,0x00,0x00]

v_trunc_f32_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x42,0xd3,0x6c,0x00,0x00,0x00]

v_trunc_f32_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x42,0xd3,0x6d,0x00,0x00,0x00]

v_trunc_f32_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x42,0xd3,0x6e,0x00,0x00,0x00]

v_trunc_f32_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x42,0xd3,0x6f,0x00,0x00,0x00]

v_trunc_f32_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x42,0xd3,0x7b,0x00,0x00,0x00]

v_trunc_f32_e64 v5, m0
// CHECK: [0x05,0x00,0x42,0xd3,0x7c,0x00,0x00,0x00]

v_trunc_f32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x42,0xd3,0x7e,0x00,0x00,0x00]

v_trunc_f32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x42,0xd3,0x7f,0x00,0x00,0x00]

v_trunc_f32_e64 v5, 0
// CHECK: [0x05,0x00,0x42,0xd3,0x80,0x00,0x00,0x00]

v_trunc_f32_e64 v5, -1
// CHECK: [0x05,0x00,0x42,0xd3,0xc1,0x00,0x00,0x00]

v_trunc_f32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x42,0xd3,0xf0,0x00,0x00,0x00]

v_trunc_f32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x42,0xd3,0xf7,0x00,0x00,0x00]

v_trunc_f32_e64 v5, -v1
// CHECK: [0x05,0x00,0x42,0xd3,0x01,0x01,0x00,0x20]

v_trunc_f32_e64 v5, |v1|
// CHECK: [0x05,0x01,0x42,0xd3,0x01,0x01,0x00,0x00]

v_trunc_f32_e64 v5, v1 clamp
// CHECK: [0x05,0x08,0x42,0xd3,0x01,0x01,0x00,0x00]

v_trunc_f32_e64 v5, v1 mul:2
// CHECK: [0x05,0x00,0x42,0xd3,0x01,0x01,0x00,0x08]

v_trunc_f32_e64 v5, v1 mul:4
// CHECK: [0x05,0x00,0x42,0xd3,0x01,0x01,0x00,0x10]

v_trunc_f32_e64 v5, v1 div:2
// CHECK: [0x05,0x00,0x42,0xd3,0x01,0x01,0x00,0x18]

v_ceil_f32 v5, v1
// CHECK: [0x01,0x45,0x0a,0x7e]

v_ceil_f32 v255, v1
// CHECK: [0x01,0x45,0xfe,0x7f]

v_ceil_f32 v5, v255
// CHECK: [0xff,0x45,0x0a,0x7e]

v_ceil_f32 v5, s1
// CHECK: [0x01,0x44,0x0a,0x7e]

v_ceil_f32 v5, s103
// CHECK: [0x67,0x44,0x0a,0x7e]

v_ceil_f32 v5, flat_scratch_lo
// CHECK: [0x68,0x44,0x0a,0x7e]

v_ceil_f32 v5, flat_scratch_hi
// CHECK: [0x69,0x44,0x0a,0x7e]

v_ceil_f32 v5, vcc_lo
// CHECK: [0x6a,0x44,0x0a,0x7e]

v_ceil_f32 v5, vcc_hi
// CHECK: [0x6b,0x44,0x0a,0x7e]

v_ceil_f32 v5, tba_lo
// CHECK: [0x6c,0x44,0x0a,0x7e]

v_ceil_f32 v5, tba_hi
// CHECK: [0x6d,0x44,0x0a,0x7e]

v_ceil_f32 v5, tma_lo
// CHECK: [0x6e,0x44,0x0a,0x7e]

v_ceil_f32 v5, tma_hi
// CHECK: [0x6f,0x44,0x0a,0x7e]

v_ceil_f32 v5, ttmp11
// CHECK: [0x7b,0x44,0x0a,0x7e]

v_ceil_f32 v5, m0
// CHECK: [0x7c,0x44,0x0a,0x7e]

v_ceil_f32 v5, exec_lo
// CHECK: [0x7e,0x44,0x0a,0x7e]

v_ceil_f32 v5, exec_hi
// CHECK: [0x7f,0x44,0x0a,0x7e]

v_ceil_f32 v5, 0
// CHECK: [0x80,0x44,0x0a,0x7e]

v_ceil_f32 v5, -1
// CHECK: [0xc1,0x44,0x0a,0x7e]

v_ceil_f32 v5, 0.5
// CHECK: [0xf0,0x44,0x0a,0x7e]

v_ceil_f32 v5, -4.0
// CHECK: [0xf7,0x44,0x0a,0x7e]

v_ceil_f32 v5, 0xaf123456
// CHECK: [0xff,0x44,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_ceil_f32 v5, 0x3f717273
// CHECK: [0xff,0x44,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_ceil_f32_e64 v5, v1
// CHECK: [0x05,0x00,0x44,0xd3,0x01,0x01,0x00,0x00]

v_ceil_f32_e64 v255, v1
// CHECK: [0xff,0x00,0x44,0xd3,0x01,0x01,0x00,0x00]

v_ceil_f32_e64 v5, v255
// CHECK: [0x05,0x00,0x44,0xd3,0xff,0x01,0x00,0x00]

v_ceil_f32_e64 v5, s1
// CHECK: [0x05,0x00,0x44,0xd3,0x01,0x00,0x00,0x00]

v_ceil_f32_e64 v5, s103
// CHECK: [0x05,0x00,0x44,0xd3,0x67,0x00,0x00,0x00]

v_ceil_f32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x44,0xd3,0x68,0x00,0x00,0x00]

v_ceil_f32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x44,0xd3,0x69,0x00,0x00,0x00]

v_ceil_f32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x44,0xd3,0x6a,0x00,0x00,0x00]

v_ceil_f32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x44,0xd3,0x6b,0x00,0x00,0x00]

v_ceil_f32_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x44,0xd3,0x6c,0x00,0x00,0x00]

v_ceil_f32_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x44,0xd3,0x6d,0x00,0x00,0x00]

v_ceil_f32_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x44,0xd3,0x6e,0x00,0x00,0x00]

v_ceil_f32_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x44,0xd3,0x6f,0x00,0x00,0x00]

v_ceil_f32_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x44,0xd3,0x7b,0x00,0x00,0x00]

v_ceil_f32_e64 v5, m0
// CHECK: [0x05,0x00,0x44,0xd3,0x7c,0x00,0x00,0x00]

v_ceil_f32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x44,0xd3,0x7e,0x00,0x00,0x00]

v_ceil_f32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x44,0xd3,0x7f,0x00,0x00,0x00]

v_ceil_f32_e64 v5, 0
// CHECK: [0x05,0x00,0x44,0xd3,0x80,0x00,0x00,0x00]

v_ceil_f32_e64 v5, -1
// CHECK: [0x05,0x00,0x44,0xd3,0xc1,0x00,0x00,0x00]

v_ceil_f32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x44,0xd3,0xf0,0x00,0x00,0x00]

v_ceil_f32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x44,0xd3,0xf7,0x00,0x00,0x00]

v_ceil_f32_e64 v5, -v1
// CHECK: [0x05,0x00,0x44,0xd3,0x01,0x01,0x00,0x20]

v_ceil_f32_e64 v5, |v1|
// CHECK: [0x05,0x01,0x44,0xd3,0x01,0x01,0x00,0x00]

v_ceil_f32_e64 v5, v1 clamp
// CHECK: [0x05,0x08,0x44,0xd3,0x01,0x01,0x00,0x00]

v_ceil_f32_e64 v5, v1 mul:2
// CHECK: [0x05,0x00,0x44,0xd3,0x01,0x01,0x00,0x08]

v_ceil_f32_e64 v5, v1 mul:4
// CHECK: [0x05,0x00,0x44,0xd3,0x01,0x01,0x00,0x10]

v_ceil_f32_e64 v5, v1 div:2
// CHECK: [0x05,0x00,0x44,0xd3,0x01,0x01,0x00,0x18]

v_rndne_f32 v5, v1
// CHECK: [0x01,0x47,0x0a,0x7e]

v_rndne_f32 v255, v1
// CHECK: [0x01,0x47,0xfe,0x7f]

v_rndne_f32 v5, v255
// CHECK: [0xff,0x47,0x0a,0x7e]

v_rndne_f32 v5, s1
// CHECK: [0x01,0x46,0x0a,0x7e]

v_rndne_f32 v5, s103
// CHECK: [0x67,0x46,0x0a,0x7e]

v_rndne_f32 v5, flat_scratch_lo
// CHECK: [0x68,0x46,0x0a,0x7e]

v_rndne_f32 v5, flat_scratch_hi
// CHECK: [0x69,0x46,0x0a,0x7e]

v_rndne_f32 v5, vcc_lo
// CHECK: [0x6a,0x46,0x0a,0x7e]

v_rndne_f32 v5, vcc_hi
// CHECK: [0x6b,0x46,0x0a,0x7e]

v_rndne_f32 v5, tba_lo
// CHECK: [0x6c,0x46,0x0a,0x7e]

v_rndne_f32 v5, tba_hi
// CHECK: [0x6d,0x46,0x0a,0x7e]

v_rndne_f32 v5, tma_lo
// CHECK: [0x6e,0x46,0x0a,0x7e]

v_rndne_f32 v5, tma_hi
// CHECK: [0x6f,0x46,0x0a,0x7e]

v_rndne_f32 v5, ttmp11
// CHECK: [0x7b,0x46,0x0a,0x7e]

v_rndne_f32 v5, m0
// CHECK: [0x7c,0x46,0x0a,0x7e]

v_rndne_f32 v5, exec_lo
// CHECK: [0x7e,0x46,0x0a,0x7e]

v_rndne_f32 v5, exec_hi
// CHECK: [0x7f,0x46,0x0a,0x7e]

v_rndne_f32 v5, 0
// CHECK: [0x80,0x46,0x0a,0x7e]

v_rndne_f32 v5, -1
// CHECK: [0xc1,0x46,0x0a,0x7e]

v_rndne_f32 v5, 0.5
// CHECK: [0xf0,0x46,0x0a,0x7e]

v_rndne_f32 v5, -4.0
// CHECK: [0xf7,0x46,0x0a,0x7e]

v_rndne_f32 v5, 0xaf123456
// CHECK: [0xff,0x46,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_rndne_f32 v5, 0x3f717273
// CHECK: [0xff,0x46,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_rndne_f32_e64 v5, v1
// CHECK: [0x05,0x00,0x46,0xd3,0x01,0x01,0x00,0x00]

v_rndne_f32_e64 v255, v1
// CHECK: [0xff,0x00,0x46,0xd3,0x01,0x01,0x00,0x00]

v_rndne_f32_e64 v5, v255
// CHECK: [0x05,0x00,0x46,0xd3,0xff,0x01,0x00,0x00]

v_rndne_f32_e64 v5, s1
// CHECK: [0x05,0x00,0x46,0xd3,0x01,0x00,0x00,0x00]

v_rndne_f32_e64 v5, s103
// CHECK: [0x05,0x00,0x46,0xd3,0x67,0x00,0x00,0x00]

v_rndne_f32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x46,0xd3,0x68,0x00,0x00,0x00]

v_rndne_f32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x46,0xd3,0x69,0x00,0x00,0x00]

v_rndne_f32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x46,0xd3,0x6a,0x00,0x00,0x00]

v_rndne_f32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x46,0xd3,0x6b,0x00,0x00,0x00]

v_rndne_f32_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x46,0xd3,0x6c,0x00,0x00,0x00]

v_rndne_f32_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x46,0xd3,0x6d,0x00,0x00,0x00]

v_rndne_f32_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x46,0xd3,0x6e,0x00,0x00,0x00]

v_rndne_f32_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x46,0xd3,0x6f,0x00,0x00,0x00]

v_rndne_f32_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x46,0xd3,0x7b,0x00,0x00,0x00]

v_rndne_f32_e64 v5, m0
// CHECK: [0x05,0x00,0x46,0xd3,0x7c,0x00,0x00,0x00]

v_rndne_f32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x46,0xd3,0x7e,0x00,0x00,0x00]

v_rndne_f32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x46,0xd3,0x7f,0x00,0x00,0x00]

v_rndne_f32_e64 v5, 0
// CHECK: [0x05,0x00,0x46,0xd3,0x80,0x00,0x00,0x00]

v_rndne_f32_e64 v5, -1
// CHECK: [0x05,0x00,0x46,0xd3,0xc1,0x00,0x00,0x00]

v_rndne_f32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x46,0xd3,0xf0,0x00,0x00,0x00]

v_rndne_f32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x46,0xd3,0xf7,0x00,0x00,0x00]

v_rndne_f32_e64 v5, -v1
// CHECK: [0x05,0x00,0x46,0xd3,0x01,0x01,0x00,0x20]

v_rndne_f32_e64 v5, |v1|
// CHECK: [0x05,0x01,0x46,0xd3,0x01,0x01,0x00,0x00]

v_rndne_f32_e64 v5, v1 clamp
// CHECK: [0x05,0x08,0x46,0xd3,0x01,0x01,0x00,0x00]

v_rndne_f32_e64 v5, v1 mul:2
// CHECK: [0x05,0x00,0x46,0xd3,0x01,0x01,0x00,0x08]

v_rndne_f32_e64 v5, v1 mul:4
// CHECK: [0x05,0x00,0x46,0xd3,0x01,0x01,0x00,0x10]

v_rndne_f32_e64 v5, v1 div:2
// CHECK: [0x05,0x00,0x46,0xd3,0x01,0x01,0x00,0x18]

v_floor_f32 v5, v1
// CHECK: [0x01,0x49,0x0a,0x7e]

v_floor_f32 v255, v1
// CHECK: [0x01,0x49,0xfe,0x7f]

v_floor_f32 v5, v255
// CHECK: [0xff,0x49,0x0a,0x7e]

v_floor_f32 v5, s1
// CHECK: [0x01,0x48,0x0a,0x7e]

v_floor_f32 v5, s103
// CHECK: [0x67,0x48,0x0a,0x7e]

v_floor_f32 v5, flat_scratch_lo
// CHECK: [0x68,0x48,0x0a,0x7e]

v_floor_f32 v5, flat_scratch_hi
// CHECK: [0x69,0x48,0x0a,0x7e]

v_floor_f32 v5, vcc_lo
// CHECK: [0x6a,0x48,0x0a,0x7e]

v_floor_f32 v5, vcc_hi
// CHECK: [0x6b,0x48,0x0a,0x7e]

v_floor_f32 v5, tba_lo
// CHECK: [0x6c,0x48,0x0a,0x7e]

v_floor_f32 v5, tba_hi
// CHECK: [0x6d,0x48,0x0a,0x7e]

v_floor_f32 v5, tma_lo
// CHECK: [0x6e,0x48,0x0a,0x7e]

v_floor_f32 v5, tma_hi
// CHECK: [0x6f,0x48,0x0a,0x7e]

v_floor_f32 v5, ttmp11
// CHECK: [0x7b,0x48,0x0a,0x7e]

v_floor_f32 v5, m0
// CHECK: [0x7c,0x48,0x0a,0x7e]

v_floor_f32 v5, exec_lo
// CHECK: [0x7e,0x48,0x0a,0x7e]

v_floor_f32 v5, exec_hi
// CHECK: [0x7f,0x48,0x0a,0x7e]

v_floor_f32 v5, 0
// CHECK: [0x80,0x48,0x0a,0x7e]

v_floor_f32 v5, -1
// CHECK: [0xc1,0x48,0x0a,0x7e]

v_floor_f32 v5, 0.5
// CHECK: [0xf0,0x48,0x0a,0x7e]

v_floor_f32 v5, -4.0
// CHECK: [0xf7,0x48,0x0a,0x7e]

v_floor_f32 v5, 0xaf123456
// CHECK: [0xff,0x48,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_floor_f32 v5, 0x3f717273
// CHECK: [0xff,0x48,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_floor_f32_e64 v5, v1
// CHECK: [0x05,0x00,0x48,0xd3,0x01,0x01,0x00,0x00]

v_floor_f32_e64 v255, v1
// CHECK: [0xff,0x00,0x48,0xd3,0x01,0x01,0x00,0x00]

v_floor_f32_e64 v5, v255
// CHECK: [0x05,0x00,0x48,0xd3,0xff,0x01,0x00,0x00]

v_floor_f32_e64 v5, s1
// CHECK: [0x05,0x00,0x48,0xd3,0x01,0x00,0x00,0x00]

v_floor_f32_e64 v5, s103
// CHECK: [0x05,0x00,0x48,0xd3,0x67,0x00,0x00,0x00]

v_floor_f32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x48,0xd3,0x68,0x00,0x00,0x00]

v_floor_f32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x48,0xd3,0x69,0x00,0x00,0x00]

v_floor_f32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x48,0xd3,0x6a,0x00,0x00,0x00]

v_floor_f32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x48,0xd3,0x6b,0x00,0x00,0x00]

v_floor_f32_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x48,0xd3,0x6c,0x00,0x00,0x00]

v_floor_f32_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x48,0xd3,0x6d,0x00,0x00,0x00]

v_floor_f32_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x48,0xd3,0x6e,0x00,0x00,0x00]

v_floor_f32_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x48,0xd3,0x6f,0x00,0x00,0x00]

v_floor_f32_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x48,0xd3,0x7b,0x00,0x00,0x00]

v_floor_f32_e64 v5, m0
// CHECK: [0x05,0x00,0x48,0xd3,0x7c,0x00,0x00,0x00]

v_floor_f32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x48,0xd3,0x7e,0x00,0x00,0x00]

v_floor_f32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x48,0xd3,0x7f,0x00,0x00,0x00]

v_floor_f32_e64 v5, 0
// CHECK: [0x05,0x00,0x48,0xd3,0x80,0x00,0x00,0x00]

v_floor_f32_e64 v5, -1
// CHECK: [0x05,0x00,0x48,0xd3,0xc1,0x00,0x00,0x00]

v_floor_f32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x48,0xd3,0xf0,0x00,0x00,0x00]

v_floor_f32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x48,0xd3,0xf7,0x00,0x00,0x00]

v_floor_f32_e64 v5, -v1
// CHECK: [0x05,0x00,0x48,0xd3,0x01,0x01,0x00,0x20]

v_floor_f32_e64 v5, |v1|
// CHECK: [0x05,0x01,0x48,0xd3,0x01,0x01,0x00,0x00]

v_floor_f32_e64 v5, v1 clamp
// CHECK: [0x05,0x08,0x48,0xd3,0x01,0x01,0x00,0x00]

v_floor_f32_e64 v5, v1 mul:2
// CHECK: [0x05,0x00,0x48,0xd3,0x01,0x01,0x00,0x08]

v_floor_f32_e64 v5, v1 mul:4
// CHECK: [0x05,0x00,0x48,0xd3,0x01,0x01,0x00,0x10]

v_floor_f32_e64 v5, v1 div:2
// CHECK: [0x05,0x00,0x48,0xd3,0x01,0x01,0x00,0x18]

v_exp_f32 v5, v1
// CHECK: [0x01,0x4b,0x0a,0x7e]

v_exp_f32 v255, v1
// CHECK: [0x01,0x4b,0xfe,0x7f]

v_exp_f32 v5, v255
// CHECK: [0xff,0x4b,0x0a,0x7e]

v_exp_f32 v5, s1
// CHECK: [0x01,0x4a,0x0a,0x7e]

v_exp_f32 v5, s103
// CHECK: [0x67,0x4a,0x0a,0x7e]

v_exp_f32 v5, flat_scratch_lo
// CHECK: [0x68,0x4a,0x0a,0x7e]

v_exp_f32 v5, flat_scratch_hi
// CHECK: [0x69,0x4a,0x0a,0x7e]

v_exp_f32 v5, vcc_lo
// CHECK: [0x6a,0x4a,0x0a,0x7e]

v_exp_f32 v5, vcc_hi
// CHECK: [0x6b,0x4a,0x0a,0x7e]

v_exp_f32 v5, tba_lo
// CHECK: [0x6c,0x4a,0x0a,0x7e]

v_exp_f32 v5, tba_hi
// CHECK: [0x6d,0x4a,0x0a,0x7e]

v_exp_f32 v5, tma_lo
// CHECK: [0x6e,0x4a,0x0a,0x7e]

v_exp_f32 v5, tma_hi
// CHECK: [0x6f,0x4a,0x0a,0x7e]

v_exp_f32 v5, ttmp11
// CHECK: [0x7b,0x4a,0x0a,0x7e]

v_exp_f32 v5, m0
// CHECK: [0x7c,0x4a,0x0a,0x7e]

v_exp_f32 v5, exec_lo
// CHECK: [0x7e,0x4a,0x0a,0x7e]

v_exp_f32 v5, exec_hi
// CHECK: [0x7f,0x4a,0x0a,0x7e]

v_exp_f32 v5, 0
// CHECK: [0x80,0x4a,0x0a,0x7e]

v_exp_f32 v5, -1
// CHECK: [0xc1,0x4a,0x0a,0x7e]

v_exp_f32 v5, 0.5
// CHECK: [0xf0,0x4a,0x0a,0x7e]

v_exp_f32 v5, -4.0
// CHECK: [0xf7,0x4a,0x0a,0x7e]

v_exp_f32 v5, 0xaf123456
// CHECK: [0xff,0x4a,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_exp_f32 v5, 0x3f717273
// CHECK: [0xff,0x4a,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_exp_f32_e64 v5, v1
// CHECK: [0x05,0x00,0x4a,0xd3,0x01,0x01,0x00,0x00]

v_exp_f32_e64 v255, v1
// CHECK: [0xff,0x00,0x4a,0xd3,0x01,0x01,0x00,0x00]

v_exp_f32_e64 v5, v255
// CHECK: [0x05,0x00,0x4a,0xd3,0xff,0x01,0x00,0x00]

v_exp_f32_e64 v5, s1
// CHECK: [0x05,0x00,0x4a,0xd3,0x01,0x00,0x00,0x00]

v_exp_f32_e64 v5, s103
// CHECK: [0x05,0x00,0x4a,0xd3,0x67,0x00,0x00,0x00]

v_exp_f32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x4a,0xd3,0x68,0x00,0x00,0x00]

v_exp_f32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x4a,0xd3,0x69,0x00,0x00,0x00]

v_exp_f32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x4a,0xd3,0x6a,0x00,0x00,0x00]

v_exp_f32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x4a,0xd3,0x6b,0x00,0x00,0x00]

v_exp_f32_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x4a,0xd3,0x6c,0x00,0x00,0x00]

v_exp_f32_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x4a,0xd3,0x6d,0x00,0x00,0x00]

v_exp_f32_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x4a,0xd3,0x6e,0x00,0x00,0x00]

v_exp_f32_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x4a,0xd3,0x6f,0x00,0x00,0x00]

v_exp_f32_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x4a,0xd3,0x7b,0x00,0x00,0x00]

v_exp_f32_e64 v5, m0
// CHECK: [0x05,0x00,0x4a,0xd3,0x7c,0x00,0x00,0x00]

v_exp_f32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x4a,0xd3,0x7e,0x00,0x00,0x00]

v_exp_f32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x4a,0xd3,0x7f,0x00,0x00,0x00]

v_exp_f32_e64 v5, 0
// CHECK: [0x05,0x00,0x4a,0xd3,0x80,0x00,0x00,0x00]

v_exp_f32_e64 v5, -1
// CHECK: [0x05,0x00,0x4a,0xd3,0xc1,0x00,0x00,0x00]

v_exp_f32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x4a,0xd3,0xf0,0x00,0x00,0x00]

v_exp_f32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x4a,0xd3,0xf7,0x00,0x00,0x00]

v_exp_f32_e64 v5, -v1
// CHECK: [0x05,0x00,0x4a,0xd3,0x01,0x01,0x00,0x20]

v_exp_f32_e64 v5, v1 mul:2
// CHECK: [0x05,0x00,0x4a,0xd3,0x01,0x01,0x00,0x08]

v_exp_f32_e64 v5, v1 mul:4
// CHECK: [0x05,0x00,0x4a,0xd3,0x01,0x01,0x00,0x10]

v_exp_f32_e64 v5, v1 div:2
// CHECK: [0x05,0x00,0x4a,0xd3,0x01,0x01,0x00,0x18]

v_log_clamp_f32 v5, v1
// CHECK: [0x01,0x4d,0x0a,0x7e]

v_log_clamp_f32 v255, v1
// CHECK: [0x01,0x4d,0xfe,0x7f]

v_log_clamp_f32 v5, v255
// CHECK: [0xff,0x4d,0x0a,0x7e]

v_log_clamp_f32 v5, s1
// CHECK: [0x01,0x4c,0x0a,0x7e]

v_log_clamp_f32 v5, s103
// CHECK: [0x67,0x4c,0x0a,0x7e]

v_log_clamp_f32 v5, flat_scratch_lo
// CHECK: [0x68,0x4c,0x0a,0x7e]

v_log_clamp_f32 v5, flat_scratch_hi
// CHECK: [0x69,0x4c,0x0a,0x7e]

v_log_clamp_f32 v5, vcc_lo
// CHECK: [0x6a,0x4c,0x0a,0x7e]

v_log_clamp_f32 v5, vcc_hi
// CHECK: [0x6b,0x4c,0x0a,0x7e]

v_log_clamp_f32 v5, tba_lo
// CHECK: [0x6c,0x4c,0x0a,0x7e]

v_log_clamp_f32 v5, tba_hi
// CHECK: [0x6d,0x4c,0x0a,0x7e]

v_log_clamp_f32 v5, tma_lo
// CHECK: [0x6e,0x4c,0x0a,0x7e]

v_log_clamp_f32 v5, tma_hi
// CHECK: [0x6f,0x4c,0x0a,0x7e]

v_log_clamp_f32 v5, ttmp11
// CHECK: [0x7b,0x4c,0x0a,0x7e]

v_log_clamp_f32 v5, m0
// CHECK: [0x7c,0x4c,0x0a,0x7e]

v_log_clamp_f32 v5, exec_lo
// CHECK: [0x7e,0x4c,0x0a,0x7e]

v_log_clamp_f32 v5, exec_hi
// CHECK: [0x7f,0x4c,0x0a,0x7e]

v_log_clamp_f32 v5, 0
// CHECK: [0x80,0x4c,0x0a,0x7e]

v_log_clamp_f32 v5, -1
// CHECK: [0xc1,0x4c,0x0a,0x7e]

v_log_clamp_f32 v5, 0.5
// CHECK: [0xf0,0x4c,0x0a,0x7e]

v_log_clamp_f32 v5, -4.0
// CHECK: [0xf7,0x4c,0x0a,0x7e]

v_log_clamp_f32 v5, 0xaf123456
// CHECK: [0xff,0x4c,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_log_clamp_f32 v5, 0x3f717273
// CHECK: [0xff,0x4c,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_log_clamp_f32_e64 v5, v1
// CHECK: [0x05,0x00,0x4c,0xd3,0x01,0x01,0x00,0x00]

v_log_clamp_f32_e64 v255, v1
// CHECK: [0xff,0x00,0x4c,0xd3,0x01,0x01,0x00,0x00]

v_log_clamp_f32_e64 v5, v255
// CHECK: [0x05,0x00,0x4c,0xd3,0xff,0x01,0x00,0x00]

v_log_clamp_f32_e64 v5, s1
// CHECK: [0x05,0x00,0x4c,0xd3,0x01,0x00,0x00,0x00]

v_log_clamp_f32_e64 v5, s103
// CHECK: [0x05,0x00,0x4c,0xd3,0x67,0x00,0x00,0x00]

v_log_clamp_f32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x4c,0xd3,0x68,0x00,0x00,0x00]

v_log_clamp_f32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x4c,0xd3,0x69,0x00,0x00,0x00]

v_log_clamp_f32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x4c,0xd3,0x6a,0x00,0x00,0x00]

v_log_clamp_f32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x4c,0xd3,0x6b,0x00,0x00,0x00]

v_log_clamp_f32_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x4c,0xd3,0x6c,0x00,0x00,0x00]

v_log_clamp_f32_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x4c,0xd3,0x6d,0x00,0x00,0x00]

v_log_clamp_f32_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x4c,0xd3,0x6e,0x00,0x00,0x00]

v_log_clamp_f32_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x4c,0xd3,0x6f,0x00,0x00,0x00]

v_log_clamp_f32_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x4c,0xd3,0x7b,0x00,0x00,0x00]

v_log_clamp_f32_e64 v5, m0
// CHECK: [0x05,0x00,0x4c,0xd3,0x7c,0x00,0x00,0x00]

v_log_clamp_f32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x4c,0xd3,0x7e,0x00,0x00,0x00]

v_log_clamp_f32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x4c,0xd3,0x7f,0x00,0x00,0x00]

v_log_clamp_f32_e64 v5, 0
// CHECK: [0x05,0x00,0x4c,0xd3,0x80,0x00,0x00,0x00]

v_log_clamp_f32_e64 v5, -1
// CHECK: [0x05,0x00,0x4c,0xd3,0xc1,0x00,0x00,0x00]

v_log_clamp_f32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x4c,0xd3,0xf0,0x00,0x00,0x00]

v_log_clamp_f32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x4c,0xd3,0xf7,0x00,0x00,0x00]

v_log_clamp_f32_e64 v5, -v1
// CHECK: [0x05,0x00,0x4c,0xd3,0x01,0x01,0x00,0x20]

v_log_clamp_f32_e64 v5, v1 mul:2
// CHECK: [0x05,0x00,0x4c,0xd3,0x01,0x01,0x00,0x08]

v_log_clamp_f32_e64 v5, v1 mul:4
// CHECK: [0x05,0x00,0x4c,0xd3,0x01,0x01,0x00,0x10]

v_log_clamp_f32_e64 v5, v1 div:2
// CHECK: [0x05,0x00,0x4c,0xd3,0x01,0x01,0x00,0x18]

v_log_f32 v5, v1
// CHECK: [0x01,0x4f,0x0a,0x7e]

v_log_f32 v255, v1
// CHECK: [0x01,0x4f,0xfe,0x7f]

v_log_f32 v5, v255
// CHECK: [0xff,0x4f,0x0a,0x7e]

v_log_f32 v5, s1
// CHECK: [0x01,0x4e,0x0a,0x7e]

v_log_f32 v5, s103
// CHECK: [0x67,0x4e,0x0a,0x7e]

v_log_f32 v5, flat_scratch_lo
// CHECK: [0x68,0x4e,0x0a,0x7e]

v_log_f32 v5, flat_scratch_hi
// CHECK: [0x69,0x4e,0x0a,0x7e]

v_log_f32 v5, vcc_lo
// CHECK: [0x6a,0x4e,0x0a,0x7e]

v_log_f32 v5, vcc_hi
// CHECK: [0x6b,0x4e,0x0a,0x7e]

v_log_f32 v5, tba_lo
// CHECK: [0x6c,0x4e,0x0a,0x7e]

v_log_f32 v5, tba_hi
// CHECK: [0x6d,0x4e,0x0a,0x7e]

v_log_f32 v5, tma_lo
// CHECK: [0x6e,0x4e,0x0a,0x7e]

v_log_f32 v5, tma_hi
// CHECK: [0x6f,0x4e,0x0a,0x7e]

v_log_f32 v5, ttmp11
// CHECK: [0x7b,0x4e,0x0a,0x7e]

v_log_f32 v5, m0
// CHECK: [0x7c,0x4e,0x0a,0x7e]

v_log_f32 v5, exec_lo
// CHECK: [0x7e,0x4e,0x0a,0x7e]

v_log_f32 v5, exec_hi
// CHECK: [0x7f,0x4e,0x0a,0x7e]

v_log_f32 v5, 0
// CHECK: [0x80,0x4e,0x0a,0x7e]

v_log_f32 v5, -1
// CHECK: [0xc1,0x4e,0x0a,0x7e]

v_log_f32 v5, 0.5
// CHECK: [0xf0,0x4e,0x0a,0x7e]

v_log_f32 v5, -4.0
// CHECK: [0xf7,0x4e,0x0a,0x7e]

v_log_f32 v5, 0xaf123456
// CHECK: [0xff,0x4e,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_log_f32 v5, 0x3f717273
// CHECK: [0xff,0x4e,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_log_f32_e64 v5, v1
// CHECK: [0x05,0x00,0x4e,0xd3,0x01,0x01,0x00,0x00]

v_log_f32_e64 v255, v1
// CHECK: [0xff,0x00,0x4e,0xd3,0x01,0x01,0x00,0x00]

v_log_f32_e64 v5, v255
// CHECK: [0x05,0x00,0x4e,0xd3,0xff,0x01,0x00,0x00]

v_log_f32_e64 v5, s1
// CHECK: [0x05,0x00,0x4e,0xd3,0x01,0x00,0x00,0x00]

v_log_f32_e64 v5, s103
// CHECK: [0x05,0x00,0x4e,0xd3,0x67,0x00,0x00,0x00]

v_log_f32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x4e,0xd3,0x68,0x00,0x00,0x00]

v_log_f32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x4e,0xd3,0x69,0x00,0x00,0x00]

v_log_f32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x4e,0xd3,0x6a,0x00,0x00,0x00]

v_log_f32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x4e,0xd3,0x6b,0x00,0x00,0x00]

v_log_f32_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x4e,0xd3,0x6c,0x00,0x00,0x00]

v_log_f32_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x4e,0xd3,0x6d,0x00,0x00,0x00]

v_log_f32_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x4e,0xd3,0x6e,0x00,0x00,0x00]

v_log_f32_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x4e,0xd3,0x6f,0x00,0x00,0x00]

v_log_f32_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x4e,0xd3,0x7b,0x00,0x00,0x00]

v_log_f32_e64 v5, m0
// CHECK: [0x05,0x00,0x4e,0xd3,0x7c,0x00,0x00,0x00]

v_log_f32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x4e,0xd3,0x7e,0x00,0x00,0x00]

v_log_f32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x4e,0xd3,0x7f,0x00,0x00,0x00]

v_log_f32_e64 v5, 0
// CHECK: [0x05,0x00,0x4e,0xd3,0x80,0x00,0x00,0x00]

v_log_f32_e64 v5, -1
// CHECK: [0x05,0x00,0x4e,0xd3,0xc1,0x00,0x00,0x00]

v_log_f32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x4e,0xd3,0xf0,0x00,0x00,0x00]

v_log_f32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x4e,0xd3,0xf7,0x00,0x00,0x00]

v_log_f32_e64 v5, -v1
// CHECK: [0x05,0x00,0x4e,0xd3,0x01,0x01,0x00,0x20]

v_log_f32_e64 v5, v1 mul:2
// CHECK: [0x05,0x00,0x4e,0xd3,0x01,0x01,0x00,0x08]

v_log_f32_e64 v5, v1 mul:4
// CHECK: [0x05,0x00,0x4e,0xd3,0x01,0x01,0x00,0x10]

v_log_f32_e64 v5, v1 div:2
// CHECK: [0x05,0x00,0x4e,0xd3,0x01,0x01,0x00,0x18]

v_rcp_clamp_f32 v5, v1
// CHECK: [0x01,0x51,0x0a,0x7e]

v_rcp_clamp_f32 v255, v1
// CHECK: [0x01,0x51,0xfe,0x7f]

v_rcp_clamp_f32 v5, v255
// CHECK: [0xff,0x51,0x0a,0x7e]

v_rcp_clamp_f32 v5, s1
// CHECK: [0x01,0x50,0x0a,0x7e]

v_rcp_clamp_f32 v5, s103
// CHECK: [0x67,0x50,0x0a,0x7e]

v_rcp_clamp_f32 v5, flat_scratch_lo
// CHECK: [0x68,0x50,0x0a,0x7e]

v_rcp_clamp_f32 v5, flat_scratch_hi
// CHECK: [0x69,0x50,0x0a,0x7e]

v_rcp_clamp_f32 v5, vcc_lo
// CHECK: [0x6a,0x50,0x0a,0x7e]

v_rcp_clamp_f32 v5, vcc_hi
// CHECK: [0x6b,0x50,0x0a,0x7e]

v_rcp_clamp_f32 v5, tba_lo
// CHECK: [0x6c,0x50,0x0a,0x7e]

v_rcp_clamp_f32 v5, tba_hi
// CHECK: [0x6d,0x50,0x0a,0x7e]

v_rcp_clamp_f32 v5, tma_lo
// CHECK: [0x6e,0x50,0x0a,0x7e]

v_rcp_clamp_f32 v5, tma_hi
// CHECK: [0x6f,0x50,0x0a,0x7e]

v_rcp_clamp_f32 v5, ttmp11
// CHECK: [0x7b,0x50,0x0a,0x7e]

v_rcp_clamp_f32 v5, m0
// CHECK: [0x7c,0x50,0x0a,0x7e]

v_rcp_clamp_f32 v5, exec_lo
// CHECK: [0x7e,0x50,0x0a,0x7e]

v_rcp_clamp_f32 v5, exec_hi
// CHECK: [0x7f,0x50,0x0a,0x7e]

v_rcp_clamp_f32 v5, 0
// CHECK: [0x80,0x50,0x0a,0x7e]

v_rcp_clamp_f32 v5, -1
// CHECK: [0xc1,0x50,0x0a,0x7e]

v_rcp_clamp_f32 v5, 0.5
// CHECK: [0xf0,0x50,0x0a,0x7e]

v_rcp_clamp_f32 v5, -4.0
// CHECK: [0xf7,0x50,0x0a,0x7e]

v_rcp_clamp_f32 v5, 0xaf123456
// CHECK: [0xff,0x50,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_rcp_clamp_f32 v5, 0x3f717273
// CHECK: [0xff,0x50,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_rcp_clamp_f32_e64 v5, v1
// CHECK: [0x05,0x00,0x50,0xd3,0x01,0x01,0x00,0x00]

v_rcp_clamp_f32_e64 v255, v1
// CHECK: [0xff,0x00,0x50,0xd3,0x01,0x01,0x00,0x00]

v_rcp_clamp_f32_e64 v5, v255
// CHECK: [0x05,0x00,0x50,0xd3,0xff,0x01,0x00,0x00]

v_rcp_clamp_f32_e64 v5, s1
// CHECK: [0x05,0x00,0x50,0xd3,0x01,0x00,0x00,0x00]

v_rcp_clamp_f32_e64 v5, s103
// CHECK: [0x05,0x00,0x50,0xd3,0x67,0x00,0x00,0x00]

v_rcp_clamp_f32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x50,0xd3,0x68,0x00,0x00,0x00]

v_rcp_clamp_f32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x50,0xd3,0x69,0x00,0x00,0x00]

v_rcp_clamp_f32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x50,0xd3,0x6a,0x00,0x00,0x00]

v_rcp_clamp_f32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x50,0xd3,0x6b,0x00,0x00,0x00]

v_rcp_clamp_f32_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x50,0xd3,0x6c,0x00,0x00,0x00]

v_rcp_clamp_f32_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x50,0xd3,0x6d,0x00,0x00,0x00]

v_rcp_clamp_f32_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x50,0xd3,0x6e,0x00,0x00,0x00]

v_rcp_clamp_f32_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x50,0xd3,0x6f,0x00,0x00,0x00]

v_rcp_clamp_f32_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x50,0xd3,0x7b,0x00,0x00,0x00]

v_rcp_clamp_f32_e64 v5, m0
// CHECK: [0x05,0x00,0x50,0xd3,0x7c,0x00,0x00,0x00]

v_rcp_clamp_f32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x50,0xd3,0x7e,0x00,0x00,0x00]

v_rcp_clamp_f32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x50,0xd3,0x7f,0x00,0x00,0x00]

v_rcp_clamp_f32_e64 v5, 0
// CHECK: [0x05,0x00,0x50,0xd3,0x80,0x00,0x00,0x00]

v_rcp_clamp_f32_e64 v5, -1
// CHECK: [0x05,0x00,0x50,0xd3,0xc1,0x00,0x00,0x00]

v_rcp_clamp_f32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x50,0xd3,0xf0,0x00,0x00,0x00]

v_rcp_clamp_f32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x50,0xd3,0xf7,0x00,0x00,0x00]

v_rcp_clamp_f32_e64 v5, -v1
// CHECK: [0x05,0x00,0x50,0xd3,0x01,0x01,0x00,0x20]

v_rcp_clamp_f32_e64 v5, v1 mul:2
// CHECK: [0x05,0x00,0x50,0xd3,0x01,0x01,0x00,0x08]

v_rcp_clamp_f32_e64 v5, v1 mul:4
// CHECK: [0x05,0x00,0x50,0xd3,0x01,0x01,0x00,0x10]

v_rcp_clamp_f32_e64 v5, v1 div:2
// CHECK: [0x05,0x00,0x50,0xd3,0x01,0x01,0x00,0x18]

v_rcp_legacy_f32 v5, v1
// CHECK: [0x01,0x53,0x0a,0x7e]

v_rcp_legacy_f32 v255, v1
// CHECK: [0x01,0x53,0xfe,0x7f]

v_rcp_legacy_f32 v5, v255
// CHECK: [0xff,0x53,0x0a,0x7e]

v_rcp_legacy_f32 v5, s1
// CHECK: [0x01,0x52,0x0a,0x7e]

v_rcp_legacy_f32 v5, s103
// CHECK: [0x67,0x52,0x0a,0x7e]

v_rcp_legacy_f32 v5, flat_scratch_lo
// CHECK: [0x68,0x52,0x0a,0x7e]

v_rcp_legacy_f32 v5, flat_scratch_hi
// CHECK: [0x69,0x52,0x0a,0x7e]

v_rcp_legacy_f32 v5, vcc_lo
// CHECK: [0x6a,0x52,0x0a,0x7e]

v_rcp_legacy_f32 v5, vcc_hi
// CHECK: [0x6b,0x52,0x0a,0x7e]

v_rcp_legacy_f32 v5, tba_lo
// CHECK: [0x6c,0x52,0x0a,0x7e]

v_rcp_legacy_f32 v5, tba_hi
// CHECK: [0x6d,0x52,0x0a,0x7e]

v_rcp_legacy_f32 v5, tma_lo
// CHECK: [0x6e,0x52,0x0a,0x7e]

v_rcp_legacy_f32 v5, tma_hi
// CHECK: [0x6f,0x52,0x0a,0x7e]

v_rcp_legacy_f32 v5, ttmp11
// CHECK: [0x7b,0x52,0x0a,0x7e]

v_rcp_legacy_f32 v5, m0
// CHECK: [0x7c,0x52,0x0a,0x7e]

v_rcp_legacy_f32 v5, exec_lo
// CHECK: [0x7e,0x52,0x0a,0x7e]

v_rcp_legacy_f32 v5, exec_hi
// CHECK: [0x7f,0x52,0x0a,0x7e]

v_rcp_legacy_f32 v5, 0
// CHECK: [0x80,0x52,0x0a,0x7e]

v_rcp_legacy_f32 v5, -1
// CHECK: [0xc1,0x52,0x0a,0x7e]

v_rcp_legacy_f32 v5, 0.5
// CHECK: [0xf0,0x52,0x0a,0x7e]

v_rcp_legacy_f32 v5, -4.0
// CHECK: [0xf7,0x52,0x0a,0x7e]

v_rcp_legacy_f32 v5, 0xaf123456
// CHECK: [0xff,0x52,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_rcp_legacy_f32 v5, 0x3f717273
// CHECK: [0xff,0x52,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_rcp_legacy_f32_e64 v5, v1
// CHECK: [0x05,0x00,0x52,0xd3,0x01,0x01,0x00,0x00]

v_rcp_legacy_f32_e64 v255, v1
// CHECK: [0xff,0x00,0x52,0xd3,0x01,0x01,0x00,0x00]

v_rcp_legacy_f32_e64 v5, v255
// CHECK: [0x05,0x00,0x52,0xd3,0xff,0x01,0x00,0x00]

v_rcp_legacy_f32_e64 v5, s1
// CHECK: [0x05,0x00,0x52,0xd3,0x01,0x00,0x00,0x00]

v_rcp_legacy_f32_e64 v5, s103
// CHECK: [0x05,0x00,0x52,0xd3,0x67,0x00,0x00,0x00]

v_rcp_legacy_f32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x52,0xd3,0x68,0x00,0x00,0x00]

v_rcp_legacy_f32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x52,0xd3,0x69,0x00,0x00,0x00]

v_rcp_legacy_f32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x52,0xd3,0x6a,0x00,0x00,0x00]

v_rcp_legacy_f32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x52,0xd3,0x6b,0x00,0x00,0x00]

v_rcp_legacy_f32_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x52,0xd3,0x6c,0x00,0x00,0x00]

v_rcp_legacy_f32_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x52,0xd3,0x6d,0x00,0x00,0x00]

v_rcp_legacy_f32_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x52,0xd3,0x6e,0x00,0x00,0x00]

v_rcp_legacy_f32_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x52,0xd3,0x6f,0x00,0x00,0x00]

v_rcp_legacy_f32_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x52,0xd3,0x7b,0x00,0x00,0x00]

v_rcp_legacy_f32_e64 v5, m0
// CHECK: [0x05,0x00,0x52,0xd3,0x7c,0x00,0x00,0x00]

v_rcp_legacy_f32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x52,0xd3,0x7e,0x00,0x00,0x00]

v_rcp_legacy_f32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x52,0xd3,0x7f,0x00,0x00,0x00]

v_rcp_legacy_f32_e64 v5, 0
// CHECK: [0x05,0x00,0x52,0xd3,0x80,0x00,0x00,0x00]

v_rcp_legacy_f32_e64 v5, -1
// CHECK: [0x05,0x00,0x52,0xd3,0xc1,0x00,0x00,0x00]

v_rcp_legacy_f32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x52,0xd3,0xf0,0x00,0x00,0x00]

v_rcp_legacy_f32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x52,0xd3,0xf7,0x00,0x00,0x00]

v_rcp_legacy_f32_e64 v5, -v1
// CHECK: [0x05,0x00,0x52,0xd3,0x01,0x01,0x00,0x20]

v_rcp_legacy_f32_e64 v5, v1 mul:2
// CHECK: [0x05,0x00,0x52,0xd3,0x01,0x01,0x00,0x08]

v_rcp_legacy_f32_e64 v5, v1 mul:4
// CHECK: [0x05,0x00,0x52,0xd3,0x01,0x01,0x00,0x10]

v_rcp_legacy_f32_e64 v5, v1 div:2
// CHECK: [0x05,0x00,0x52,0xd3,0x01,0x01,0x00,0x18]

v_rcp_f32 v5, v1
// CHECK: [0x01,0x55,0x0a,0x7e]

v_rcp_f32 v255, v1
// CHECK: [0x01,0x55,0xfe,0x7f]

v_rcp_f32 v5, v255
// CHECK: [0xff,0x55,0x0a,0x7e]

v_rcp_f32 v5, s1
// CHECK: [0x01,0x54,0x0a,0x7e]

v_rcp_f32 v5, s103
// CHECK: [0x67,0x54,0x0a,0x7e]

v_rcp_f32 v5, flat_scratch_lo
// CHECK: [0x68,0x54,0x0a,0x7e]

v_rcp_f32 v5, flat_scratch_hi
// CHECK: [0x69,0x54,0x0a,0x7e]

v_rcp_f32 v5, vcc_lo
// CHECK: [0x6a,0x54,0x0a,0x7e]

v_rcp_f32 v5, vcc_hi
// CHECK: [0x6b,0x54,0x0a,0x7e]

v_rcp_f32 v5, tba_lo
// CHECK: [0x6c,0x54,0x0a,0x7e]

v_rcp_f32 v5, tba_hi
// CHECK: [0x6d,0x54,0x0a,0x7e]

v_rcp_f32 v5, tma_lo
// CHECK: [0x6e,0x54,0x0a,0x7e]

v_rcp_f32 v5, tma_hi
// CHECK: [0x6f,0x54,0x0a,0x7e]

v_rcp_f32 v5, ttmp11
// CHECK: [0x7b,0x54,0x0a,0x7e]

v_rcp_f32 v5, m0
// CHECK: [0x7c,0x54,0x0a,0x7e]

v_rcp_f32 v5, exec_lo
// CHECK: [0x7e,0x54,0x0a,0x7e]

v_rcp_f32 v5, exec_hi
// CHECK: [0x7f,0x54,0x0a,0x7e]

v_rcp_f32 v5, 0
// CHECK: [0x80,0x54,0x0a,0x7e]

v_rcp_f32 v5, -1
// CHECK: [0xc1,0x54,0x0a,0x7e]

v_rcp_f32 v5, 0.5
// CHECK: [0xf0,0x54,0x0a,0x7e]

v_rcp_f32 v5, -4.0
// CHECK: [0xf7,0x54,0x0a,0x7e]

v_rcp_f32 v5, 0xaf123456
// CHECK: [0xff,0x54,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_rcp_f32 v5, 0x3f717273
// CHECK: [0xff,0x54,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_rcp_f32_e64 v5, v1
// CHECK: [0x05,0x00,0x54,0xd3,0x01,0x01,0x00,0x00]

v_rcp_f32_e64 v255, v1
// CHECK: [0xff,0x00,0x54,0xd3,0x01,0x01,0x00,0x00]

v_rcp_f32_e64 v5, v255
// CHECK: [0x05,0x00,0x54,0xd3,0xff,0x01,0x00,0x00]

v_rcp_f32_e64 v5, s1
// CHECK: [0x05,0x00,0x54,0xd3,0x01,0x00,0x00,0x00]

v_rcp_f32_e64 v5, s103
// CHECK: [0x05,0x00,0x54,0xd3,0x67,0x00,0x00,0x00]

v_rcp_f32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x54,0xd3,0x68,0x00,0x00,0x00]

v_rcp_f32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x54,0xd3,0x69,0x00,0x00,0x00]

v_rcp_f32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x54,0xd3,0x6a,0x00,0x00,0x00]

v_rcp_f32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x54,0xd3,0x6b,0x00,0x00,0x00]

v_rcp_f32_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x54,0xd3,0x6c,0x00,0x00,0x00]

v_rcp_f32_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x54,0xd3,0x6d,0x00,0x00,0x00]

v_rcp_f32_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x54,0xd3,0x6e,0x00,0x00,0x00]

v_rcp_f32_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x54,0xd3,0x6f,0x00,0x00,0x00]

v_rcp_f32_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x54,0xd3,0x7b,0x00,0x00,0x00]

v_rcp_f32_e64 v5, m0
// CHECK: [0x05,0x00,0x54,0xd3,0x7c,0x00,0x00,0x00]

v_rcp_f32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x54,0xd3,0x7e,0x00,0x00,0x00]

v_rcp_f32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x54,0xd3,0x7f,0x00,0x00,0x00]

v_rcp_f32_e64 v5, 0
// CHECK: [0x05,0x00,0x54,0xd3,0x80,0x00,0x00,0x00]

v_rcp_f32_e64 v5, -1
// CHECK: [0x05,0x00,0x54,0xd3,0xc1,0x00,0x00,0x00]

v_rcp_f32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x54,0xd3,0xf0,0x00,0x00,0x00]

v_rcp_f32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x54,0xd3,0xf7,0x00,0x00,0x00]

v_rcp_f32_e64 v5, -v1
// CHECK: [0x05,0x00,0x54,0xd3,0x01,0x01,0x00,0x20]

v_rcp_f32_e64 v5, v1 mul:2
// CHECK: [0x05,0x00,0x54,0xd3,0x01,0x01,0x00,0x08]

v_rcp_f32_e64 v5, v1 mul:4
// CHECK: [0x05,0x00,0x54,0xd3,0x01,0x01,0x00,0x10]

v_rcp_f32_e64 v5, v1 div:2
// CHECK: [0x05,0x00,0x54,0xd3,0x01,0x01,0x00,0x18]

v_rcp_iflag_f32 v5, v1
// CHECK: [0x01,0x57,0x0a,0x7e]

v_rcp_iflag_f32 v255, v1
// CHECK: [0x01,0x57,0xfe,0x7f]

v_rcp_iflag_f32 v5, v255
// CHECK: [0xff,0x57,0x0a,0x7e]

v_rcp_iflag_f32 v5, s1
// CHECK: [0x01,0x56,0x0a,0x7e]

v_rcp_iflag_f32 v5, s103
// CHECK: [0x67,0x56,0x0a,0x7e]

v_rcp_iflag_f32 v5, flat_scratch_lo
// CHECK: [0x68,0x56,0x0a,0x7e]

v_rcp_iflag_f32 v5, flat_scratch_hi
// CHECK: [0x69,0x56,0x0a,0x7e]

v_rcp_iflag_f32 v5, vcc_lo
// CHECK: [0x6a,0x56,0x0a,0x7e]

v_rcp_iflag_f32 v5, vcc_hi
// CHECK: [0x6b,0x56,0x0a,0x7e]

v_rcp_iflag_f32 v5, tba_lo
// CHECK: [0x6c,0x56,0x0a,0x7e]

v_rcp_iflag_f32 v5, tba_hi
// CHECK: [0x6d,0x56,0x0a,0x7e]

v_rcp_iflag_f32 v5, tma_lo
// CHECK: [0x6e,0x56,0x0a,0x7e]

v_rcp_iflag_f32 v5, tma_hi
// CHECK: [0x6f,0x56,0x0a,0x7e]

v_rcp_iflag_f32 v5, ttmp11
// CHECK: [0x7b,0x56,0x0a,0x7e]

v_rcp_iflag_f32 v5, m0
// CHECK: [0x7c,0x56,0x0a,0x7e]

v_rcp_iflag_f32 v5, exec_lo
// CHECK: [0x7e,0x56,0x0a,0x7e]

v_rcp_iflag_f32 v5, exec_hi
// CHECK: [0x7f,0x56,0x0a,0x7e]

v_rcp_iflag_f32 v5, 0
// CHECK: [0x80,0x56,0x0a,0x7e]

v_rcp_iflag_f32 v5, -1
// CHECK: [0xc1,0x56,0x0a,0x7e]

v_rcp_iflag_f32 v5, 0.5
// CHECK: [0xf0,0x56,0x0a,0x7e]

v_rcp_iflag_f32 v5, -4.0
// CHECK: [0xf7,0x56,0x0a,0x7e]

v_rcp_iflag_f32 v5, 0xaf123456
// CHECK: [0xff,0x56,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_rcp_iflag_f32 v5, 0x3f717273
// CHECK: [0xff,0x56,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_rcp_iflag_f32_e64 v5, v1
// CHECK: [0x05,0x00,0x56,0xd3,0x01,0x01,0x00,0x00]

v_rcp_iflag_f32_e64 v255, v1
// CHECK: [0xff,0x00,0x56,0xd3,0x01,0x01,0x00,0x00]

v_rcp_iflag_f32_e64 v5, v255
// CHECK: [0x05,0x00,0x56,0xd3,0xff,0x01,0x00,0x00]

v_rcp_iflag_f32_e64 v5, s1
// CHECK: [0x05,0x00,0x56,0xd3,0x01,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, s103
// CHECK: [0x05,0x00,0x56,0xd3,0x67,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x56,0xd3,0x68,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x56,0xd3,0x69,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x56,0xd3,0x6a,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x56,0xd3,0x6b,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x56,0xd3,0x6c,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x56,0xd3,0x6d,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x56,0xd3,0x6e,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x56,0xd3,0x6f,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x56,0xd3,0x7b,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, m0
// CHECK: [0x05,0x00,0x56,0xd3,0x7c,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x56,0xd3,0x7e,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x56,0xd3,0x7f,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, 0
// CHECK: [0x05,0x00,0x56,0xd3,0x80,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, -1
// CHECK: [0x05,0x00,0x56,0xd3,0xc1,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x56,0xd3,0xf0,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x56,0xd3,0xf7,0x00,0x00,0x00]

v_rcp_iflag_f32_e64 v5, -v1
// CHECK: [0x05,0x00,0x56,0xd3,0x01,0x01,0x00,0x20]

v_rcp_iflag_f32_e64 v5, |v1|
// CHECK: [0x05,0x01,0x56,0xd3,0x01,0x01,0x00,0x00]

v_rcp_iflag_f32_e64 v5, v1 clamp
// CHECK: [0x05,0x08,0x56,0xd3,0x01,0x01,0x00,0x00]

v_rcp_iflag_f32_e64 v5, v1 mul:2
// CHECK: [0x05,0x00,0x56,0xd3,0x01,0x01,0x00,0x08]

v_rcp_iflag_f32_e64 v5, v1 mul:4
// CHECK: [0x05,0x00,0x56,0xd3,0x01,0x01,0x00,0x10]

v_rcp_iflag_f32_e64 v5, v1 div:2
// CHECK: [0x05,0x00,0x56,0xd3,0x01,0x01,0x00,0x18]

v_rsq_clamp_f32 v5, v1
// CHECK: [0x01,0x59,0x0a,0x7e]

v_rsq_clamp_f32 v255, v1
// CHECK: [0x01,0x59,0xfe,0x7f]

v_rsq_clamp_f32 v5, v255
// CHECK: [0xff,0x59,0x0a,0x7e]

v_rsq_clamp_f32 v5, s1
// CHECK: [0x01,0x58,0x0a,0x7e]

v_rsq_clamp_f32 v5, s103
// CHECK: [0x67,0x58,0x0a,0x7e]

v_rsq_clamp_f32 v5, flat_scratch_lo
// CHECK: [0x68,0x58,0x0a,0x7e]

v_rsq_clamp_f32 v5, flat_scratch_hi
// CHECK: [0x69,0x58,0x0a,0x7e]

v_rsq_clamp_f32 v5, vcc_lo
// CHECK: [0x6a,0x58,0x0a,0x7e]

v_rsq_clamp_f32 v5, vcc_hi
// CHECK: [0x6b,0x58,0x0a,0x7e]

v_rsq_clamp_f32 v5, tba_lo
// CHECK: [0x6c,0x58,0x0a,0x7e]

v_rsq_clamp_f32 v5, tba_hi
// CHECK: [0x6d,0x58,0x0a,0x7e]

v_rsq_clamp_f32 v5, tma_lo
// CHECK: [0x6e,0x58,0x0a,0x7e]

v_rsq_clamp_f32 v5, tma_hi
// CHECK: [0x6f,0x58,0x0a,0x7e]

v_rsq_clamp_f32 v5, ttmp11
// CHECK: [0x7b,0x58,0x0a,0x7e]

v_rsq_clamp_f32 v5, m0
// CHECK: [0x7c,0x58,0x0a,0x7e]

v_rsq_clamp_f32 v5, exec_lo
// CHECK: [0x7e,0x58,0x0a,0x7e]

v_rsq_clamp_f32 v5, exec_hi
// CHECK: [0x7f,0x58,0x0a,0x7e]

v_rsq_clamp_f32 v5, 0
// CHECK: [0x80,0x58,0x0a,0x7e]

v_rsq_clamp_f32 v5, -1
// CHECK: [0xc1,0x58,0x0a,0x7e]

v_rsq_clamp_f32 v5, 0.5
// CHECK: [0xf0,0x58,0x0a,0x7e]

v_rsq_clamp_f32 v5, -4.0
// CHECK: [0xf7,0x58,0x0a,0x7e]

v_rsq_clamp_f32 v5, 0xaf123456
// CHECK: [0xff,0x58,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_rsq_clamp_f32 v5, 0x3f717273
// CHECK: [0xff,0x58,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_rsq_clamp_f32_e64 v5, v1
// CHECK: [0x05,0x00,0x58,0xd3,0x01,0x01,0x00,0x00]

v_rsq_clamp_f32_e64 v255, v1
// CHECK: [0xff,0x00,0x58,0xd3,0x01,0x01,0x00,0x00]

v_rsq_clamp_f32_e64 v5, v255
// CHECK: [0x05,0x00,0x58,0xd3,0xff,0x01,0x00,0x00]

v_rsq_clamp_f32_e64 v5, s1
// CHECK: [0x05,0x00,0x58,0xd3,0x01,0x00,0x00,0x00]

v_rsq_clamp_f32_e64 v5, s103
// CHECK: [0x05,0x00,0x58,0xd3,0x67,0x00,0x00,0x00]

v_rsq_clamp_f32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x58,0xd3,0x68,0x00,0x00,0x00]

v_rsq_clamp_f32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x58,0xd3,0x69,0x00,0x00,0x00]

v_rsq_clamp_f32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x58,0xd3,0x6a,0x00,0x00,0x00]

v_rsq_clamp_f32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x58,0xd3,0x6b,0x00,0x00,0x00]

v_rsq_clamp_f32_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x58,0xd3,0x6c,0x00,0x00,0x00]

v_rsq_clamp_f32_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x58,0xd3,0x6d,0x00,0x00,0x00]

v_rsq_clamp_f32_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x58,0xd3,0x6e,0x00,0x00,0x00]

v_rsq_clamp_f32_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x58,0xd3,0x6f,0x00,0x00,0x00]

v_rsq_clamp_f32_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x58,0xd3,0x7b,0x00,0x00,0x00]

v_rsq_clamp_f32_e64 v5, m0
// CHECK: [0x05,0x00,0x58,0xd3,0x7c,0x00,0x00,0x00]

v_rsq_clamp_f32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x58,0xd3,0x7e,0x00,0x00,0x00]

v_rsq_clamp_f32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x58,0xd3,0x7f,0x00,0x00,0x00]

v_rsq_clamp_f32_e64 v5, 0
// CHECK: [0x05,0x00,0x58,0xd3,0x80,0x00,0x00,0x00]

v_rsq_clamp_f32_e64 v5, -1
// CHECK: [0x05,0x00,0x58,0xd3,0xc1,0x00,0x00,0x00]

v_rsq_clamp_f32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x58,0xd3,0xf0,0x00,0x00,0x00]

v_rsq_clamp_f32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x58,0xd3,0xf7,0x00,0x00,0x00]

v_rsq_clamp_f32_e64 v5, -v1
// CHECK: [0x05,0x00,0x58,0xd3,0x01,0x01,0x00,0x20]

v_rsq_clamp_f32_e64 v5, |v1|
// CHECK: [0x05,0x01,0x58,0xd3,0x01,0x01,0x00,0x00]

v_rsq_clamp_f32_e64 v5, v1 clamp
// CHECK: [0x05,0x08,0x58,0xd3,0x01,0x01,0x00,0x00]

v_rsq_clamp_f32_e64 v5, v1 mul:2
// CHECK: [0x05,0x00,0x58,0xd3,0x01,0x01,0x00,0x08]

v_rsq_clamp_f32_e64 v5, v1 mul:4
// CHECK: [0x05,0x00,0x58,0xd3,0x01,0x01,0x00,0x10]

v_rsq_clamp_f32_e64 v5, v1 div:2
// CHECK: [0x05,0x00,0x58,0xd3,0x01,0x01,0x00,0x18]

v_rsq_legacy_f32 v5, v1
// CHECK: [0x01,0x5b,0x0a,0x7e]

v_rsq_legacy_f32 v255, v1
// CHECK: [0x01,0x5b,0xfe,0x7f]

v_rsq_legacy_f32 v5, v255
// CHECK: [0xff,0x5b,0x0a,0x7e]

v_rsq_legacy_f32 v5, s1
// CHECK: [0x01,0x5a,0x0a,0x7e]

v_rsq_legacy_f32 v5, s103
// CHECK: [0x67,0x5a,0x0a,0x7e]

v_rsq_legacy_f32 v5, flat_scratch_lo
// CHECK: [0x68,0x5a,0x0a,0x7e]

v_rsq_legacy_f32 v5, flat_scratch_hi
// CHECK: [0x69,0x5a,0x0a,0x7e]

v_rsq_legacy_f32 v5, vcc_lo
// CHECK: [0x6a,0x5a,0x0a,0x7e]

v_rsq_legacy_f32 v5, vcc_hi
// CHECK: [0x6b,0x5a,0x0a,0x7e]

v_rsq_legacy_f32 v5, tba_lo
// CHECK: [0x6c,0x5a,0x0a,0x7e]

v_rsq_legacy_f32 v5, tba_hi
// CHECK: [0x6d,0x5a,0x0a,0x7e]

v_rsq_legacy_f32 v5, tma_lo
// CHECK: [0x6e,0x5a,0x0a,0x7e]

v_rsq_legacy_f32 v5, tma_hi
// CHECK: [0x6f,0x5a,0x0a,0x7e]

v_rsq_legacy_f32 v5, ttmp11
// CHECK: [0x7b,0x5a,0x0a,0x7e]

v_rsq_legacy_f32 v5, m0
// CHECK: [0x7c,0x5a,0x0a,0x7e]

v_rsq_legacy_f32 v5, exec_lo
// CHECK: [0x7e,0x5a,0x0a,0x7e]

v_rsq_legacy_f32 v5, exec_hi
// CHECK: [0x7f,0x5a,0x0a,0x7e]

v_rsq_legacy_f32 v5, 0
// CHECK: [0x80,0x5a,0x0a,0x7e]

v_rsq_legacy_f32 v5, -1
// CHECK: [0xc1,0x5a,0x0a,0x7e]

v_rsq_legacy_f32 v5, 0.5
// CHECK: [0xf0,0x5a,0x0a,0x7e]

v_rsq_legacy_f32 v5, -4.0
// CHECK: [0xf7,0x5a,0x0a,0x7e]

v_rsq_legacy_f32 v5, 0xaf123456
// CHECK: [0xff,0x5a,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_rsq_legacy_f32 v5, 0x3f717273
// CHECK: [0xff,0x5a,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_rsq_legacy_f32_e64 v5, v1
// CHECK: [0x05,0x00,0x5a,0xd3,0x01,0x01,0x00,0x00]

v_rsq_legacy_f32_e64 v255, v1
// CHECK: [0xff,0x00,0x5a,0xd3,0x01,0x01,0x00,0x00]

v_rsq_legacy_f32_e64 v5, v255
// CHECK: [0x05,0x00,0x5a,0xd3,0xff,0x01,0x00,0x00]

v_rsq_legacy_f32_e64 v5, s1
// CHECK: [0x05,0x00,0x5a,0xd3,0x01,0x00,0x00,0x00]

v_rsq_legacy_f32_e64 v5, s103
// CHECK: [0x05,0x00,0x5a,0xd3,0x67,0x00,0x00,0x00]

v_rsq_legacy_f32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x5a,0xd3,0x68,0x00,0x00,0x00]

v_rsq_legacy_f32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x5a,0xd3,0x69,0x00,0x00,0x00]

v_rsq_legacy_f32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x5a,0xd3,0x6a,0x00,0x00,0x00]

v_rsq_legacy_f32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x5a,0xd3,0x6b,0x00,0x00,0x00]

v_rsq_legacy_f32_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x5a,0xd3,0x6c,0x00,0x00,0x00]

v_rsq_legacy_f32_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x5a,0xd3,0x6d,0x00,0x00,0x00]

v_rsq_legacy_f32_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x5a,0xd3,0x6e,0x00,0x00,0x00]

v_rsq_legacy_f32_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x5a,0xd3,0x6f,0x00,0x00,0x00]

v_rsq_legacy_f32_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x5a,0xd3,0x7b,0x00,0x00,0x00]

v_rsq_legacy_f32_e64 v5, m0
// CHECK: [0x05,0x00,0x5a,0xd3,0x7c,0x00,0x00,0x00]

v_rsq_legacy_f32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x5a,0xd3,0x7e,0x00,0x00,0x00]

v_rsq_legacy_f32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x5a,0xd3,0x7f,0x00,0x00,0x00]

v_rsq_legacy_f32_e64 v5, 0
// CHECK: [0x05,0x00,0x5a,0xd3,0x80,0x00,0x00,0x00]

v_rsq_legacy_f32_e64 v5, -1
// CHECK: [0x05,0x00,0x5a,0xd3,0xc1,0x00,0x00,0x00]

v_rsq_legacy_f32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x5a,0xd3,0xf0,0x00,0x00,0x00]

v_rsq_legacy_f32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x5a,0xd3,0xf7,0x00,0x00,0x00]

v_rsq_legacy_f32_e64 v5, -v1
// CHECK: [0x05,0x00,0x5a,0xd3,0x01,0x01,0x00,0x20]

v_rsq_legacy_f32_e64 v5, |v1|
// CHECK: [0x05,0x01,0x5a,0xd3,0x01,0x01,0x00,0x00]

v_rsq_legacy_f32_e64 v5, v1 clamp
// CHECK: [0x05,0x08,0x5a,0xd3,0x01,0x01,0x00,0x00]

v_rsq_legacy_f32_e64 v5, v1 mul:2
// CHECK: [0x05,0x00,0x5a,0xd3,0x01,0x01,0x00,0x08]

v_rsq_legacy_f32_e64 v5, v1 mul:4
// CHECK: [0x05,0x00,0x5a,0xd3,0x01,0x01,0x00,0x10]

v_rsq_legacy_f32_e64 v5, v1 div:2
// CHECK: [0x05,0x00,0x5a,0xd3,0x01,0x01,0x00,0x18]

v_rsq_f32 v5, v1
// CHECK: [0x01,0x5d,0x0a,0x7e]

v_rsq_f32 v255, v1
// CHECK: [0x01,0x5d,0xfe,0x7f]

v_rsq_f32 v5, v255
// CHECK: [0xff,0x5d,0x0a,0x7e]

v_rsq_f32 v5, s1
// CHECK: [0x01,0x5c,0x0a,0x7e]

v_rsq_f32 v5, s103
// CHECK: [0x67,0x5c,0x0a,0x7e]

v_rsq_f32 v5, flat_scratch_lo
// CHECK: [0x68,0x5c,0x0a,0x7e]

v_rsq_f32 v5, flat_scratch_hi
// CHECK: [0x69,0x5c,0x0a,0x7e]

v_rsq_f32 v5, vcc_lo
// CHECK: [0x6a,0x5c,0x0a,0x7e]

v_rsq_f32 v5, vcc_hi
// CHECK: [0x6b,0x5c,0x0a,0x7e]

v_rsq_f32 v5, tba_lo
// CHECK: [0x6c,0x5c,0x0a,0x7e]

v_rsq_f32 v5, tba_hi
// CHECK: [0x6d,0x5c,0x0a,0x7e]

v_rsq_f32 v5, tma_lo
// CHECK: [0x6e,0x5c,0x0a,0x7e]

v_rsq_f32 v5, tma_hi
// CHECK: [0x6f,0x5c,0x0a,0x7e]

v_rsq_f32 v5, ttmp11
// CHECK: [0x7b,0x5c,0x0a,0x7e]

v_rsq_f32 v5, m0
// CHECK: [0x7c,0x5c,0x0a,0x7e]

v_rsq_f32 v5, exec_lo
// CHECK: [0x7e,0x5c,0x0a,0x7e]

v_rsq_f32 v5, exec_hi
// CHECK: [0x7f,0x5c,0x0a,0x7e]

v_rsq_f32 v5, 0
// CHECK: [0x80,0x5c,0x0a,0x7e]

v_rsq_f32 v5, -1
// CHECK: [0xc1,0x5c,0x0a,0x7e]

v_rsq_f32 v5, 0.5
// CHECK: [0xf0,0x5c,0x0a,0x7e]

v_rsq_f32 v5, -4.0
// CHECK: [0xf7,0x5c,0x0a,0x7e]

v_rsq_f32 v5, 0xaf123456
// CHECK: [0xff,0x5c,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_rsq_f32 v5, 0x3f717273
// CHECK: [0xff,0x5c,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_rsq_f32_e64 v5, v1
// CHECK: [0x05,0x00,0x5c,0xd3,0x01,0x01,0x00,0x00]

v_rsq_f32_e64 v255, v1
// CHECK: [0xff,0x00,0x5c,0xd3,0x01,0x01,0x00,0x00]

v_rsq_f32_e64 v5, v255
// CHECK: [0x05,0x00,0x5c,0xd3,0xff,0x01,0x00,0x00]

v_rsq_f32_e64 v5, s1
// CHECK: [0x05,0x00,0x5c,0xd3,0x01,0x00,0x00,0x00]

v_rsq_f32_e64 v5, s103
// CHECK: [0x05,0x00,0x5c,0xd3,0x67,0x00,0x00,0x00]

v_rsq_f32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x5c,0xd3,0x68,0x00,0x00,0x00]

v_rsq_f32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x5c,0xd3,0x69,0x00,0x00,0x00]

v_rsq_f32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x5c,0xd3,0x6a,0x00,0x00,0x00]

v_rsq_f32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x5c,0xd3,0x6b,0x00,0x00,0x00]

v_rsq_f32_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x5c,0xd3,0x6c,0x00,0x00,0x00]

v_rsq_f32_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x5c,0xd3,0x6d,0x00,0x00,0x00]

v_rsq_f32_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x5c,0xd3,0x6e,0x00,0x00,0x00]

v_rsq_f32_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x5c,0xd3,0x6f,0x00,0x00,0x00]

v_rsq_f32_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x5c,0xd3,0x7b,0x00,0x00,0x00]

v_rsq_f32_e64 v5, m0
// CHECK: [0x05,0x00,0x5c,0xd3,0x7c,0x00,0x00,0x00]

v_rsq_f32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x5c,0xd3,0x7e,0x00,0x00,0x00]

v_rsq_f32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x5c,0xd3,0x7f,0x00,0x00,0x00]

v_rsq_f32_e64 v5, 0
// CHECK: [0x05,0x00,0x5c,0xd3,0x80,0x00,0x00,0x00]

v_rsq_f32_e64 v5, -1
// CHECK: [0x05,0x00,0x5c,0xd3,0xc1,0x00,0x00,0x00]

v_rsq_f32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x5c,0xd3,0xf0,0x00,0x00,0x00]

v_rsq_f32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x5c,0xd3,0xf7,0x00,0x00,0x00]

v_rsq_f32_e64 v5, -v1
// CHECK: [0x05,0x00,0x5c,0xd3,0x01,0x01,0x00,0x20]

v_rsq_f32_e64 v5, |v1|
// CHECK: [0x05,0x01,0x5c,0xd3,0x01,0x01,0x00,0x00]

v_rsq_f32_e64 v5, v1 clamp
// CHECK: [0x05,0x08,0x5c,0xd3,0x01,0x01,0x00,0x00]

v_rsq_f32_e64 v5, v1 mul:2
// CHECK: [0x05,0x00,0x5c,0xd3,0x01,0x01,0x00,0x08]

v_rsq_f32_e64 v5, v1 mul:4
// CHECK: [0x05,0x00,0x5c,0xd3,0x01,0x01,0x00,0x10]

v_rsq_f32_e64 v5, v1 div:2
// CHECK: [0x05,0x00,0x5c,0xd3,0x01,0x01,0x00,0x18]

v_rcp_f64 v[5:6], v[1:2]
// CHECK: [0x01,0x5f,0x0a,0x7e]

v_rcp_f64 v[254:255], v[1:2]
// CHECK: [0x01,0x5f,0xfc,0x7f]

v_rcp_f64 v[5:6], v[254:255]
// CHECK: [0xfe,0x5f,0x0a,0x7e]

v_rcp_f64 v[5:6], s[2:3]
// CHECK: [0x02,0x5e,0x0a,0x7e]

v_rcp_f64 v[5:6], s[4:5]
// CHECK: [0x04,0x5e,0x0a,0x7e]

v_rcp_f64 v[5:6], s[102:103]
// CHECK: [0x66,0x5e,0x0a,0x7e]

v_rcp_f64 v[5:6], flat_scratch
// CHECK: [0x68,0x5e,0x0a,0x7e]

v_rcp_f64 v[5:6], vcc
// CHECK: [0x6a,0x5e,0x0a,0x7e]

v_rcp_f64 v[5:6], tba
// CHECK: [0x6c,0x5e,0x0a,0x7e]

v_rcp_f64 v[5:6], tma
// CHECK: [0x6e,0x5e,0x0a,0x7e]

v_rcp_f64 v[5:6], ttmp[10:11]
// CHECK: [0x7a,0x5e,0x0a,0x7e]

v_rcp_f64 v[5:6], exec
// CHECK: [0x7e,0x5e,0x0a,0x7e]

v_rcp_f64 v[5:6], 0
// CHECK: [0x80,0x5e,0x0a,0x7e]

v_rcp_f64 v[5:6], -1
// CHECK: [0xc1,0x5e,0x0a,0x7e]

v_rcp_f64 v[5:6], 0.5
// CHECK: [0xf0,0x5e,0x0a,0x7e]

v_rcp_f64 v[5:6], -4.0
// CHECK: [0xf7,0x5e,0x0a,0x7e]

v_rcp_f64 v[5:6], 0xaf123456
// CHECK: [0xff,0x5e,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_rcp_f64 v[5:6], 0x3f717273
// CHECK: [0xff,0x5e,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_rcp_f64_e64 v[5:6], v[1:2]
// CHECK: [0x05,0x00,0x5e,0xd3,0x01,0x01,0x00,0x00]

v_rcp_f64_e64 v[254:255], v[1:2]
// CHECK: [0xfe,0x00,0x5e,0xd3,0x01,0x01,0x00,0x00]

v_rcp_f64_e64 v[5:6], v[254:255]
// CHECK: [0x05,0x00,0x5e,0xd3,0xfe,0x01,0x00,0x00]

v_rcp_f64_e64 v[5:6], s[2:3]
// CHECK: [0x05,0x00,0x5e,0xd3,0x02,0x00,0x00,0x00]

v_rcp_f64_e64 v[5:6], s[4:5]
// CHECK: [0x05,0x00,0x5e,0xd3,0x04,0x00,0x00,0x00]

v_rcp_f64_e64 v[5:6], s[102:103]
// CHECK: [0x05,0x00,0x5e,0xd3,0x66,0x00,0x00,0x00]

v_rcp_f64_e64 v[5:6], flat_scratch
// CHECK: [0x05,0x00,0x5e,0xd3,0x68,0x00,0x00,0x00]

v_rcp_f64_e64 v[5:6], vcc
// CHECK: [0x05,0x00,0x5e,0xd3,0x6a,0x00,0x00,0x00]

v_rcp_f64_e64 v[5:6], tba
// CHECK: [0x05,0x00,0x5e,0xd3,0x6c,0x00,0x00,0x00]

v_rcp_f64_e64 v[5:6], tma
// CHECK: [0x05,0x00,0x5e,0xd3,0x6e,0x00,0x00,0x00]

v_rcp_f64_e64 v[5:6], ttmp[10:11]
// CHECK: [0x05,0x00,0x5e,0xd3,0x7a,0x00,0x00,0x00]

v_rcp_f64_e64 v[5:6], exec
// CHECK: [0x05,0x00,0x5e,0xd3,0x7e,0x00,0x00,0x00]

v_rcp_f64_e64 v[5:6], 0
// CHECK: [0x05,0x00,0x5e,0xd3,0x80,0x00,0x00,0x00]

v_rcp_f64_e64 v[5:6], -1
// CHECK: [0x05,0x00,0x5e,0xd3,0xc1,0x00,0x00,0x00]

v_rcp_f64_e64 v[5:6], 0.5
// CHECK: [0x05,0x00,0x5e,0xd3,0xf0,0x00,0x00,0x00]

v_rcp_f64_e64 v[5:6], -4.0
// CHECK: [0x05,0x00,0x5e,0xd3,0xf7,0x00,0x00,0x00]

v_rcp_f64_e64 v[5:6], -v[1:2]
// CHECK: [0x05,0x00,0x5e,0xd3,0x01,0x01,0x00,0x20]

v_rcp_f64_e64 v[5:6], |v[1:2]|
// CHECK: [0x05,0x01,0x5e,0xd3,0x01,0x01,0x00,0x00]

v_rcp_f64_e64 v[5:6], v[1:2] clamp
// CHECK: [0x05,0x08,0x5e,0xd3,0x01,0x01,0x00,0x00]

v_rcp_f64_e64 v[5:6], v[1:2] mul:2
// CHECK: [0x05,0x00,0x5e,0xd3,0x01,0x01,0x00,0x08]

v_rcp_f64_e64 v[5:6], v[1:2] mul:4
// CHECK: [0x05,0x00,0x5e,0xd3,0x01,0x01,0x00,0x10]

v_rcp_f64_e64 v[5:6], v[1:2] div:2
// CHECK: [0x05,0x00,0x5e,0xd3,0x01,0x01,0x00,0x18]

v_rcp_clamp_f64 v[5:6], v[1:2]
// CHECK: [0x01,0x61,0x0a,0x7e]

v_rcp_clamp_f64 v[254:255], v[1:2]
// CHECK: [0x01,0x61,0xfc,0x7f]

v_rcp_clamp_f64 v[5:6], v[254:255]
// CHECK: [0xfe,0x61,0x0a,0x7e]

v_rcp_clamp_f64 v[5:6], s[2:3]
// CHECK: [0x02,0x60,0x0a,0x7e]

v_rcp_clamp_f64 v[5:6], s[4:5]
// CHECK: [0x04,0x60,0x0a,0x7e]

v_rcp_clamp_f64 v[5:6], s[102:103]
// CHECK: [0x66,0x60,0x0a,0x7e]

v_rcp_clamp_f64 v[5:6], flat_scratch
// CHECK: [0x68,0x60,0x0a,0x7e]

v_rcp_clamp_f64 v[5:6], vcc
// CHECK: [0x6a,0x60,0x0a,0x7e]

v_rcp_clamp_f64 v[5:6], tba
// CHECK: [0x6c,0x60,0x0a,0x7e]

v_rcp_clamp_f64 v[5:6], tma
// CHECK: [0x6e,0x60,0x0a,0x7e]

v_rcp_clamp_f64 v[5:6], ttmp[10:11]
// CHECK: [0x7a,0x60,0x0a,0x7e]

v_rcp_clamp_f64 v[5:6], exec
// CHECK: [0x7e,0x60,0x0a,0x7e]

v_rcp_clamp_f64 v[5:6], 0
// CHECK: [0x80,0x60,0x0a,0x7e]

v_rcp_clamp_f64 v[5:6], -1
// CHECK: [0xc1,0x60,0x0a,0x7e]

v_rcp_clamp_f64 v[5:6], 0.5
// CHECK: [0xf0,0x60,0x0a,0x7e]

v_rcp_clamp_f64 v[5:6], -4.0
// CHECK: [0xf7,0x60,0x0a,0x7e]

v_rcp_clamp_f64 v[5:6], 0xaf123456
// CHECK: [0xff,0x60,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_rcp_clamp_f64 v[5:6], 0x3f717273
// CHECK: [0xff,0x60,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_rcp_clamp_f64_e64 v[5:6], v[1:2]
// CHECK: [0x05,0x00,0x60,0xd3,0x01,0x01,0x00,0x00]

v_rcp_clamp_f64_e64 v[254:255], v[1:2]
// CHECK: [0xfe,0x00,0x60,0xd3,0x01,0x01,0x00,0x00]

v_rcp_clamp_f64_e64 v[5:6], v[254:255]
// CHECK: [0x05,0x00,0x60,0xd3,0xfe,0x01,0x00,0x00]

v_rcp_clamp_f64_e64 v[5:6], s[2:3]
// CHECK: [0x05,0x00,0x60,0xd3,0x02,0x00,0x00,0x00]

v_rcp_clamp_f64_e64 v[5:6], s[4:5]
// CHECK: [0x05,0x00,0x60,0xd3,0x04,0x00,0x00,0x00]

v_rcp_clamp_f64_e64 v[5:6], s[102:103]
// CHECK: [0x05,0x00,0x60,0xd3,0x66,0x00,0x00,0x00]

v_rcp_clamp_f64_e64 v[5:6], flat_scratch
// CHECK: [0x05,0x00,0x60,0xd3,0x68,0x00,0x00,0x00]

v_rcp_clamp_f64_e64 v[5:6], vcc
// CHECK: [0x05,0x00,0x60,0xd3,0x6a,0x00,0x00,0x00]

v_rcp_clamp_f64_e64 v[5:6], tba
// CHECK: [0x05,0x00,0x60,0xd3,0x6c,0x00,0x00,0x00]

v_rcp_clamp_f64_e64 v[5:6], tma
// CHECK: [0x05,0x00,0x60,0xd3,0x6e,0x00,0x00,0x00]

v_rcp_clamp_f64_e64 v[5:6], ttmp[10:11]
// CHECK: [0x05,0x00,0x60,0xd3,0x7a,0x00,0x00,0x00]

v_rcp_clamp_f64_e64 v[5:6], exec
// CHECK: [0x05,0x00,0x60,0xd3,0x7e,0x00,0x00,0x00]

v_rcp_clamp_f64_e64 v[5:6], 0
// CHECK: [0x05,0x00,0x60,0xd3,0x80,0x00,0x00,0x00]

v_rcp_clamp_f64_e64 v[5:6], -1
// CHECK: [0x05,0x00,0x60,0xd3,0xc1,0x00,0x00,0x00]

v_rcp_clamp_f64_e64 v[5:6], 0.5
// CHECK: [0x05,0x00,0x60,0xd3,0xf0,0x00,0x00,0x00]

v_rcp_clamp_f64_e64 v[5:6], -4.0
// CHECK: [0x05,0x00,0x60,0xd3,0xf7,0x00,0x00,0x00]

v_rcp_clamp_f64_e64 v[5:6], -v[1:2]
// CHECK: [0x05,0x00,0x60,0xd3,0x01,0x01,0x00,0x20]

v_rcp_clamp_f64_e64 v[5:6], |v[1:2]|
// CHECK: [0x05,0x01,0x60,0xd3,0x01,0x01,0x00,0x00]

v_rcp_clamp_f64_e64 v[5:6], v[1:2] clamp
// CHECK: [0x05,0x08,0x60,0xd3,0x01,0x01,0x00,0x00]

v_rcp_clamp_f64_e64 v[5:6], v[1:2] mul:2
// CHECK: [0x05,0x00,0x60,0xd3,0x01,0x01,0x00,0x08]

v_rcp_clamp_f64_e64 v[5:6], v[1:2] mul:4
// CHECK: [0x05,0x00,0x60,0xd3,0x01,0x01,0x00,0x10]

v_rcp_clamp_f64_e64 v[5:6], v[1:2] div:2
// CHECK: [0x05,0x00,0x60,0xd3,0x01,0x01,0x00,0x18]

v_rsq_f64 v[5:6], v[1:2]
// CHECK: [0x01,0x63,0x0a,0x7e]

v_rsq_f64 v[254:255], v[1:2]
// CHECK: [0x01,0x63,0xfc,0x7f]

v_rsq_f64 v[5:6], v[254:255]
// CHECK: [0xfe,0x63,0x0a,0x7e]

v_rsq_f64 v[5:6], s[2:3]
// CHECK: [0x02,0x62,0x0a,0x7e]

v_rsq_f64 v[5:6], s[4:5]
// CHECK: [0x04,0x62,0x0a,0x7e]

v_rsq_f64 v[5:6], s[102:103]
// CHECK: [0x66,0x62,0x0a,0x7e]

v_rsq_f64 v[5:6], flat_scratch
// CHECK: [0x68,0x62,0x0a,0x7e]

v_rsq_f64 v[5:6], vcc
// CHECK: [0x6a,0x62,0x0a,0x7e]

v_rsq_f64 v[5:6], tba
// CHECK: [0x6c,0x62,0x0a,0x7e]

v_rsq_f64 v[5:6], tma
// CHECK: [0x6e,0x62,0x0a,0x7e]

v_rsq_f64 v[5:6], ttmp[10:11]
// CHECK: [0x7a,0x62,0x0a,0x7e]

v_rsq_f64 v[5:6], exec
// CHECK: [0x7e,0x62,0x0a,0x7e]

v_rsq_f64 v[5:6], 0
// CHECK: [0x80,0x62,0x0a,0x7e]

v_rsq_f64 v[5:6], -1
// CHECK: [0xc1,0x62,0x0a,0x7e]

v_rsq_f64 v[5:6], 0.5
// CHECK: [0xf0,0x62,0x0a,0x7e]

v_rsq_f64 v[5:6], -4.0
// CHECK: [0xf7,0x62,0x0a,0x7e]

v_rsq_f64 v[5:6], 0xaf123456
// CHECK: [0xff,0x62,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_rsq_f64 v[5:6], 0x3f717273
// CHECK: [0xff,0x62,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_rsq_f64_e64 v[5:6], v[1:2]
// CHECK: [0x05,0x00,0x62,0xd3,0x01,0x01,0x00,0x00]

v_rsq_f64_e64 v[254:255], v[1:2]
// CHECK: [0xfe,0x00,0x62,0xd3,0x01,0x01,0x00,0x00]

v_rsq_f64_e64 v[5:6], v[254:255]
// CHECK: [0x05,0x00,0x62,0xd3,0xfe,0x01,0x00,0x00]

v_rsq_f64_e64 v[5:6], s[2:3]
// CHECK: [0x05,0x00,0x62,0xd3,0x02,0x00,0x00,0x00]

v_rsq_f64_e64 v[5:6], s[4:5]
// CHECK: [0x05,0x00,0x62,0xd3,0x04,0x00,0x00,0x00]

v_rsq_f64_e64 v[5:6], s[102:103]
// CHECK: [0x05,0x00,0x62,0xd3,0x66,0x00,0x00,0x00]

v_rsq_f64_e64 v[5:6], flat_scratch
// CHECK: [0x05,0x00,0x62,0xd3,0x68,0x00,0x00,0x00]

v_rsq_f64_e64 v[5:6], vcc
// CHECK: [0x05,0x00,0x62,0xd3,0x6a,0x00,0x00,0x00]

v_rsq_f64_e64 v[5:6], tba
// CHECK: [0x05,0x00,0x62,0xd3,0x6c,0x00,0x00,0x00]

v_rsq_f64_e64 v[5:6], tma
// CHECK: [0x05,0x00,0x62,0xd3,0x6e,0x00,0x00,0x00]

v_rsq_f64_e64 v[5:6], ttmp[10:11]
// CHECK: [0x05,0x00,0x62,0xd3,0x7a,0x00,0x00,0x00]

v_rsq_f64_e64 v[5:6], exec
// CHECK: [0x05,0x00,0x62,0xd3,0x7e,0x00,0x00,0x00]

v_rsq_f64_e64 v[5:6], 0
// CHECK: [0x05,0x00,0x62,0xd3,0x80,0x00,0x00,0x00]

v_rsq_f64_e64 v[5:6], -1
// CHECK: [0x05,0x00,0x62,0xd3,0xc1,0x00,0x00,0x00]

v_rsq_f64_e64 v[5:6], 0.5
// CHECK: [0x05,0x00,0x62,0xd3,0xf0,0x00,0x00,0x00]

v_rsq_f64_e64 v[5:6], -4.0
// CHECK: [0x05,0x00,0x62,0xd3,0xf7,0x00,0x00,0x00]

v_rsq_f64_e64 v[5:6], -v[1:2]
// CHECK: [0x05,0x00,0x62,0xd3,0x01,0x01,0x00,0x20]

v_rsq_f64_e64 v[5:6], |v[1:2]|
// CHECK: [0x05,0x01,0x62,0xd3,0x01,0x01,0x00,0x00]

v_rsq_f64_e64 v[5:6], v[1:2] clamp
// CHECK: [0x05,0x08,0x62,0xd3,0x01,0x01,0x00,0x00]

v_rsq_f64_e64 v[5:6], v[1:2] mul:2
// CHECK: [0x05,0x00,0x62,0xd3,0x01,0x01,0x00,0x08]

v_rsq_f64_e64 v[5:6], v[1:2] mul:4
// CHECK: [0x05,0x00,0x62,0xd3,0x01,0x01,0x00,0x10]

v_rsq_f64_e64 v[5:6], v[1:2] div:2
// CHECK: [0x05,0x00,0x62,0xd3,0x01,0x01,0x00,0x18]

v_rsq_clamp_f64 v[5:6], v[1:2]
// CHECK: [0x01,0x65,0x0a,0x7e]

v_rsq_clamp_f64 v[254:255], v[1:2]
// CHECK: [0x01,0x65,0xfc,0x7f]

v_rsq_clamp_f64 v[5:6], v[254:255]
// CHECK: [0xfe,0x65,0x0a,0x7e]

v_rsq_clamp_f64 v[5:6], s[2:3]
// CHECK: [0x02,0x64,0x0a,0x7e]

v_rsq_clamp_f64 v[5:6], s[4:5]
// CHECK: [0x04,0x64,0x0a,0x7e]

v_rsq_clamp_f64 v[5:6], s[102:103]
// CHECK: [0x66,0x64,0x0a,0x7e]

v_rsq_clamp_f64 v[5:6], flat_scratch
// CHECK: [0x68,0x64,0x0a,0x7e]

v_rsq_clamp_f64 v[5:6], vcc
// CHECK: [0x6a,0x64,0x0a,0x7e]

v_rsq_clamp_f64 v[5:6], tba
// CHECK: [0x6c,0x64,0x0a,0x7e]

v_rsq_clamp_f64 v[5:6], tma
// CHECK: [0x6e,0x64,0x0a,0x7e]

v_rsq_clamp_f64 v[5:6], ttmp[10:11]
// CHECK: [0x7a,0x64,0x0a,0x7e]

v_rsq_clamp_f64 v[5:6], exec
// CHECK: [0x7e,0x64,0x0a,0x7e]

v_rsq_clamp_f64 v[5:6], 0
// CHECK: [0x80,0x64,0x0a,0x7e]

v_rsq_clamp_f64 v[5:6], -1
// CHECK: [0xc1,0x64,0x0a,0x7e]

v_rsq_clamp_f64 v[5:6], 0.5
// CHECK: [0xf0,0x64,0x0a,0x7e]

v_rsq_clamp_f64 v[5:6], -4.0
// CHECK: [0xf7,0x64,0x0a,0x7e]

v_rsq_clamp_f64 v[5:6], 0xaf123456
// CHECK: [0xff,0x64,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_rsq_clamp_f64 v[5:6], 0x3f717273
// CHECK: [0xff,0x64,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_rsq_clamp_f64_e64 v[5:6], v[1:2]
// CHECK: [0x05,0x00,0x64,0xd3,0x01,0x01,0x00,0x00]

v_rsq_clamp_f64_e64 v[254:255], v[1:2]
// CHECK: [0xfe,0x00,0x64,0xd3,0x01,0x01,0x00,0x00]

v_rsq_clamp_f64_e64 v[5:6], v[254:255]
// CHECK: [0x05,0x00,0x64,0xd3,0xfe,0x01,0x00,0x00]

v_rsq_clamp_f64_e64 v[5:6], s[2:3]
// CHECK: [0x05,0x00,0x64,0xd3,0x02,0x00,0x00,0x00]

v_rsq_clamp_f64_e64 v[5:6], s[4:5]
// CHECK: [0x05,0x00,0x64,0xd3,0x04,0x00,0x00,0x00]

v_rsq_clamp_f64_e64 v[5:6], s[102:103]
// CHECK: [0x05,0x00,0x64,0xd3,0x66,0x00,0x00,0x00]

v_rsq_clamp_f64_e64 v[5:6], flat_scratch
// CHECK: [0x05,0x00,0x64,0xd3,0x68,0x00,0x00,0x00]

v_rsq_clamp_f64_e64 v[5:6], vcc
// CHECK: [0x05,0x00,0x64,0xd3,0x6a,0x00,0x00,0x00]

v_rsq_clamp_f64_e64 v[5:6], tba
// CHECK: [0x05,0x00,0x64,0xd3,0x6c,0x00,0x00,0x00]

v_rsq_clamp_f64_e64 v[5:6], tma
// CHECK: [0x05,0x00,0x64,0xd3,0x6e,0x00,0x00,0x00]

v_rsq_clamp_f64_e64 v[5:6], ttmp[10:11]
// CHECK: [0x05,0x00,0x64,0xd3,0x7a,0x00,0x00,0x00]

v_rsq_clamp_f64_e64 v[5:6], exec
// CHECK: [0x05,0x00,0x64,0xd3,0x7e,0x00,0x00,0x00]

v_rsq_clamp_f64_e64 v[5:6], 0
// CHECK: [0x05,0x00,0x64,0xd3,0x80,0x00,0x00,0x00]

v_rsq_clamp_f64_e64 v[5:6], -1
// CHECK: [0x05,0x00,0x64,0xd3,0xc1,0x00,0x00,0x00]

v_rsq_clamp_f64_e64 v[5:6], 0.5
// CHECK: [0x05,0x00,0x64,0xd3,0xf0,0x00,0x00,0x00]

v_rsq_clamp_f64_e64 v[5:6], -4.0
// CHECK: [0x05,0x00,0x64,0xd3,0xf7,0x00,0x00,0x00]

v_rsq_clamp_f64_e64 v[5:6], -v[1:2]
// CHECK: [0x05,0x00,0x64,0xd3,0x01,0x01,0x00,0x20]

v_rsq_clamp_f64_e64 v[5:6], |v[1:2]|
// CHECK: [0x05,0x01,0x64,0xd3,0x01,0x01,0x00,0x00]

v_rsq_clamp_f64_e64 v[5:6], v[1:2] clamp
// CHECK: [0x05,0x08,0x64,0xd3,0x01,0x01,0x00,0x00]

v_rsq_clamp_f64_e64 v[5:6], v[1:2] mul:2
// CHECK: [0x05,0x00,0x64,0xd3,0x01,0x01,0x00,0x08]

v_rsq_clamp_f64_e64 v[5:6], v[1:2] mul:4
// CHECK: [0x05,0x00,0x64,0xd3,0x01,0x01,0x00,0x10]

v_rsq_clamp_f64_e64 v[5:6], v[1:2] div:2
// CHECK: [0x05,0x00,0x64,0xd3,0x01,0x01,0x00,0x18]

v_sqrt_f32 v5, v1
// CHECK: [0x01,0x67,0x0a,0x7e]

v_sqrt_f32 v255, v1
// CHECK: [0x01,0x67,0xfe,0x7f]

v_sqrt_f32 v5, v255
// CHECK: [0xff,0x67,0x0a,0x7e]

v_sqrt_f32 v5, s1
// CHECK: [0x01,0x66,0x0a,0x7e]

v_sqrt_f32 v5, s103
// CHECK: [0x67,0x66,0x0a,0x7e]

v_sqrt_f32 v5, flat_scratch_lo
// CHECK: [0x68,0x66,0x0a,0x7e]

v_sqrt_f32 v5, flat_scratch_hi
// CHECK: [0x69,0x66,0x0a,0x7e]

v_sqrt_f32 v5, vcc_lo
// CHECK: [0x6a,0x66,0x0a,0x7e]

v_sqrt_f32 v5, vcc_hi
// CHECK: [0x6b,0x66,0x0a,0x7e]

v_sqrt_f32 v5, tba_lo
// CHECK: [0x6c,0x66,0x0a,0x7e]

v_sqrt_f32 v5, tba_hi
// CHECK: [0x6d,0x66,0x0a,0x7e]

v_sqrt_f32 v5, tma_lo
// CHECK: [0x6e,0x66,0x0a,0x7e]

v_sqrt_f32 v5, tma_hi
// CHECK: [0x6f,0x66,0x0a,0x7e]

v_sqrt_f32 v5, ttmp11
// CHECK: [0x7b,0x66,0x0a,0x7e]

v_sqrt_f32 v5, m0
// CHECK: [0x7c,0x66,0x0a,0x7e]

v_sqrt_f32 v5, exec_lo
// CHECK: [0x7e,0x66,0x0a,0x7e]

v_sqrt_f32 v5, exec_hi
// CHECK: [0x7f,0x66,0x0a,0x7e]

v_sqrt_f32 v5, 0
// CHECK: [0x80,0x66,0x0a,0x7e]

v_sqrt_f32 v5, -1
// CHECK: [0xc1,0x66,0x0a,0x7e]

v_sqrt_f32 v5, 0.5
// CHECK: [0xf0,0x66,0x0a,0x7e]

v_sqrt_f32 v5, -4.0
// CHECK: [0xf7,0x66,0x0a,0x7e]

v_sqrt_f32 v5, 0xaf123456
// CHECK: [0xff,0x66,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_sqrt_f32 v5, 0x3f717273
// CHECK: [0xff,0x66,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_sqrt_f32_e64 v5, v1
// CHECK: [0x05,0x00,0x66,0xd3,0x01,0x01,0x00,0x00]

v_sqrt_f32_e64 v255, v1
// CHECK: [0xff,0x00,0x66,0xd3,0x01,0x01,0x00,0x00]

v_sqrt_f32_e64 v5, v255
// CHECK: [0x05,0x00,0x66,0xd3,0xff,0x01,0x00,0x00]

v_sqrt_f32_e64 v5, s1
// CHECK: [0x05,0x00,0x66,0xd3,0x01,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, s103
// CHECK: [0x05,0x00,0x66,0xd3,0x67,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x66,0xd3,0x68,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x66,0xd3,0x69,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x66,0xd3,0x6a,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x66,0xd3,0x6b,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x66,0xd3,0x6c,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x66,0xd3,0x6d,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x66,0xd3,0x6e,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x66,0xd3,0x6f,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x66,0xd3,0x7b,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, m0
// CHECK: [0x05,0x00,0x66,0xd3,0x7c,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x66,0xd3,0x7e,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x66,0xd3,0x7f,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, 0
// CHECK: [0x05,0x00,0x66,0xd3,0x80,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, -1
// CHECK: [0x05,0x00,0x66,0xd3,0xc1,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x66,0xd3,0xf0,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x66,0xd3,0xf7,0x00,0x00,0x00]

v_sqrt_f32_e64 v5, -v1
// CHECK: [0x05,0x00,0x66,0xd3,0x01,0x01,0x00,0x20]

v_sqrt_f32_e64 v5, |v1|
// CHECK: [0x05,0x01,0x66,0xd3,0x01,0x01,0x00,0x00]

v_sqrt_f32_e64 v5, v1 clamp
// CHECK: [0x05,0x08,0x66,0xd3,0x01,0x01,0x00,0x00]

v_sqrt_f32_e64 v5, v1 mul:2
// CHECK: [0x05,0x00,0x66,0xd3,0x01,0x01,0x00,0x08]

v_sqrt_f32_e64 v5, v1 mul:4
// CHECK: [0x05,0x00,0x66,0xd3,0x01,0x01,0x00,0x10]

v_sqrt_f32_e64 v5, v1 div:2
// CHECK: [0x05,0x00,0x66,0xd3,0x01,0x01,0x00,0x18]

v_sqrt_f64 v[5:6], v[1:2]
// CHECK: [0x01,0x69,0x0a,0x7e]

v_sqrt_f64 v[254:255], v[1:2]
// CHECK: [0x01,0x69,0xfc,0x7f]

v_sqrt_f64 v[5:6], v[254:255]
// CHECK: [0xfe,0x69,0x0a,0x7e]

v_sqrt_f64 v[5:6], s[2:3]
// CHECK: [0x02,0x68,0x0a,0x7e]

v_sqrt_f64 v[5:6], s[4:5]
// CHECK: [0x04,0x68,0x0a,0x7e]

v_sqrt_f64 v[5:6], s[102:103]
// CHECK: [0x66,0x68,0x0a,0x7e]

v_sqrt_f64 v[5:6], flat_scratch
// CHECK: [0x68,0x68,0x0a,0x7e]

v_sqrt_f64 v[5:6], vcc
// CHECK: [0x6a,0x68,0x0a,0x7e]

v_sqrt_f64 v[5:6], tba
// CHECK: [0x6c,0x68,0x0a,0x7e]

v_sqrt_f64 v[5:6], tma
// CHECK: [0x6e,0x68,0x0a,0x7e]

v_sqrt_f64 v[5:6], ttmp[10:11]
// CHECK: [0x7a,0x68,0x0a,0x7e]

v_sqrt_f64 v[5:6], exec
// CHECK: [0x7e,0x68,0x0a,0x7e]

v_sqrt_f64 v[5:6], 0
// CHECK: [0x80,0x68,0x0a,0x7e]

v_sqrt_f64 v[5:6], -1
// CHECK: [0xc1,0x68,0x0a,0x7e]

v_sqrt_f64 v[5:6], 0.5
// CHECK: [0xf0,0x68,0x0a,0x7e]

v_sqrt_f64 v[5:6], -4.0
// CHECK: [0xf7,0x68,0x0a,0x7e]

v_sqrt_f64 v[5:6], 0xaf123456
// CHECK: [0xff,0x68,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_sqrt_f64 v[5:6], 0x3f717273
// CHECK: [0xff,0x68,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_sqrt_f64_e64 v[5:6], v[1:2]
// CHECK: [0x05,0x00,0x68,0xd3,0x01,0x01,0x00,0x00]

v_sqrt_f64_e64 v[254:255], v[1:2]
// CHECK: [0xfe,0x00,0x68,0xd3,0x01,0x01,0x00,0x00]

v_sqrt_f64_e64 v[5:6], v[254:255]
// CHECK: [0x05,0x00,0x68,0xd3,0xfe,0x01,0x00,0x00]

v_sqrt_f64_e64 v[5:6], s[2:3]
// CHECK: [0x05,0x00,0x68,0xd3,0x02,0x00,0x00,0x00]

v_sqrt_f64_e64 v[5:6], s[4:5]
// CHECK: [0x05,0x00,0x68,0xd3,0x04,0x00,0x00,0x00]

v_sqrt_f64_e64 v[5:6], s[102:103]
// CHECK: [0x05,0x00,0x68,0xd3,0x66,0x00,0x00,0x00]

v_sqrt_f64_e64 v[5:6], flat_scratch
// CHECK: [0x05,0x00,0x68,0xd3,0x68,0x00,0x00,0x00]

v_sqrt_f64_e64 v[5:6], vcc
// CHECK: [0x05,0x00,0x68,0xd3,0x6a,0x00,0x00,0x00]

v_sqrt_f64_e64 v[5:6], tba
// CHECK: [0x05,0x00,0x68,0xd3,0x6c,0x00,0x00,0x00]

v_sqrt_f64_e64 v[5:6], tma
// CHECK: [0x05,0x00,0x68,0xd3,0x6e,0x00,0x00,0x00]

v_sqrt_f64_e64 v[5:6], ttmp[10:11]
// CHECK: [0x05,0x00,0x68,0xd3,0x7a,0x00,0x00,0x00]

v_sqrt_f64_e64 v[5:6], exec
// CHECK: [0x05,0x00,0x68,0xd3,0x7e,0x00,0x00,0x00]

v_sqrt_f64_e64 v[5:6], 0
// CHECK: [0x05,0x00,0x68,0xd3,0x80,0x00,0x00,0x00]

v_sqrt_f64_e64 v[5:6], -1
// CHECK: [0x05,0x00,0x68,0xd3,0xc1,0x00,0x00,0x00]

v_sqrt_f64_e64 v[5:6], 0.5
// CHECK: [0x05,0x00,0x68,0xd3,0xf0,0x00,0x00,0x00]

v_sqrt_f64_e64 v[5:6], -4.0
// CHECK: [0x05,0x00,0x68,0xd3,0xf7,0x00,0x00,0x00]

v_sqrt_f64_e64 v[5:6], -v[1:2]
// CHECK: [0x05,0x00,0x68,0xd3,0x01,0x01,0x00,0x20]

v_sqrt_f64_e64 v[5:6], |v[1:2]|
// CHECK: [0x05,0x01,0x68,0xd3,0x01,0x01,0x00,0x00]

v_sqrt_f64_e64 v[5:6], v[1:2] clamp
// CHECK: [0x05,0x08,0x68,0xd3,0x01,0x01,0x00,0x00]

v_sqrt_f64_e64 v[5:6], v[1:2] mul:2
// CHECK: [0x05,0x00,0x68,0xd3,0x01,0x01,0x00,0x08]

v_sqrt_f64_e64 v[5:6], v[1:2] mul:4
// CHECK: [0x05,0x00,0x68,0xd3,0x01,0x01,0x00,0x10]

v_sqrt_f64_e64 v[5:6], v[1:2] div:2
// CHECK: [0x05,0x00,0x68,0xd3,0x01,0x01,0x00,0x18]

v_sin_f32 v5, v1
// CHECK: [0x01,0x6b,0x0a,0x7e]

v_sin_f32 v255, v1
// CHECK: [0x01,0x6b,0xfe,0x7f]

v_sin_f32 v5, v255
// CHECK: [0xff,0x6b,0x0a,0x7e]

v_sin_f32 v5, s1
// CHECK: [0x01,0x6a,0x0a,0x7e]

v_sin_f32 v5, s103
// CHECK: [0x67,0x6a,0x0a,0x7e]

v_sin_f32 v5, flat_scratch_lo
// CHECK: [0x68,0x6a,0x0a,0x7e]

v_sin_f32 v5, flat_scratch_hi
// CHECK: [0x69,0x6a,0x0a,0x7e]

v_sin_f32 v5, vcc_lo
// CHECK: [0x6a,0x6a,0x0a,0x7e]

v_sin_f32 v5, vcc_hi
// CHECK: [0x6b,0x6a,0x0a,0x7e]

v_sin_f32 v5, tba_lo
// CHECK: [0x6c,0x6a,0x0a,0x7e]

v_sin_f32 v5, tba_hi
// CHECK: [0x6d,0x6a,0x0a,0x7e]

v_sin_f32 v5, tma_lo
// CHECK: [0x6e,0x6a,0x0a,0x7e]

v_sin_f32 v5, tma_hi
// CHECK: [0x6f,0x6a,0x0a,0x7e]

v_sin_f32 v5, ttmp11
// CHECK: [0x7b,0x6a,0x0a,0x7e]

v_sin_f32 v5, m0
// CHECK: [0x7c,0x6a,0x0a,0x7e]

v_sin_f32 v5, exec_lo
// CHECK: [0x7e,0x6a,0x0a,0x7e]

v_sin_f32 v5, exec_hi
// CHECK: [0x7f,0x6a,0x0a,0x7e]

v_sin_f32 v5, 0
// CHECK: [0x80,0x6a,0x0a,0x7e]

v_sin_f32 v5, -1
// CHECK: [0xc1,0x6a,0x0a,0x7e]

v_sin_f32 v5, 0.5
// CHECK: [0xf0,0x6a,0x0a,0x7e]

v_sin_f32 v5, -4.0
// CHECK: [0xf7,0x6a,0x0a,0x7e]

v_sin_f32 v5, 0xaf123456
// CHECK: [0xff,0x6a,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_sin_f32 v5, 0x3f717273
// CHECK: [0xff,0x6a,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_sin_f32_e64 v5, v1
// CHECK: [0x05,0x00,0x6a,0xd3,0x01,0x01,0x00,0x00]

v_sin_f32_e64 v255, v1
// CHECK: [0xff,0x00,0x6a,0xd3,0x01,0x01,0x00,0x00]

v_sin_f32_e64 v5, v255
// CHECK: [0x05,0x00,0x6a,0xd3,0xff,0x01,0x00,0x00]

v_sin_f32_e64 v5, s1
// CHECK: [0x05,0x00,0x6a,0xd3,0x01,0x00,0x00,0x00]

v_sin_f32_e64 v5, s103
// CHECK: [0x05,0x00,0x6a,0xd3,0x67,0x00,0x00,0x00]

v_sin_f32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x6a,0xd3,0x68,0x00,0x00,0x00]

v_sin_f32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x6a,0xd3,0x69,0x00,0x00,0x00]

v_sin_f32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x6a,0xd3,0x6a,0x00,0x00,0x00]

v_sin_f32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x6a,0xd3,0x6b,0x00,0x00,0x00]

v_sin_f32_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x6a,0xd3,0x6c,0x00,0x00,0x00]

v_sin_f32_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x6a,0xd3,0x6d,0x00,0x00,0x00]

v_sin_f32_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x6a,0xd3,0x6e,0x00,0x00,0x00]

v_sin_f32_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x6a,0xd3,0x6f,0x00,0x00,0x00]

v_sin_f32_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x6a,0xd3,0x7b,0x00,0x00,0x00]

v_sin_f32_e64 v5, m0
// CHECK: [0x05,0x00,0x6a,0xd3,0x7c,0x00,0x00,0x00]

v_sin_f32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x6a,0xd3,0x7e,0x00,0x00,0x00]

v_sin_f32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x6a,0xd3,0x7f,0x00,0x00,0x00]

v_sin_f32_e64 v5, 0
// CHECK: [0x05,0x00,0x6a,0xd3,0x80,0x00,0x00,0x00]

v_sin_f32_e64 v5, -1
// CHECK: [0x05,0x00,0x6a,0xd3,0xc1,0x00,0x00,0x00]

v_sin_f32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x6a,0xd3,0xf0,0x00,0x00,0x00]

v_sin_f32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x6a,0xd3,0xf7,0x00,0x00,0x00]

v_sin_f32_e64 v5, -v1
// CHECK: [0x05,0x00,0x6a,0xd3,0x01,0x01,0x00,0x20]

v_sin_f32_e64 v5, |v1|
// CHECK: [0x05,0x01,0x6a,0xd3,0x01,0x01,0x00,0x00]

v_sin_f32_e64 v5, v1 clamp
// CHECK: [0x05,0x08,0x6a,0xd3,0x01,0x01,0x00,0x00]

v_sin_f32_e64 v5, v1 mul:2
// CHECK: [0x05,0x00,0x6a,0xd3,0x01,0x01,0x00,0x08]

v_sin_f32_e64 v5, v1 mul:4
// CHECK: [0x05,0x00,0x6a,0xd3,0x01,0x01,0x00,0x10]

v_sin_f32_e64 v5, v1 div:2
// CHECK: [0x05,0x00,0x6a,0xd3,0x01,0x01,0x00,0x18]

v_cos_f32 v5, v1
// CHECK: [0x01,0x6d,0x0a,0x7e]

v_cos_f32 v255, v1
// CHECK: [0x01,0x6d,0xfe,0x7f]

v_cos_f32 v5, v255
// CHECK: [0xff,0x6d,0x0a,0x7e]

v_cos_f32 v5, s1
// CHECK: [0x01,0x6c,0x0a,0x7e]

v_cos_f32 v5, s103
// CHECK: [0x67,0x6c,0x0a,0x7e]

v_cos_f32 v5, flat_scratch_lo
// CHECK: [0x68,0x6c,0x0a,0x7e]

v_cos_f32 v5, flat_scratch_hi
// CHECK: [0x69,0x6c,0x0a,0x7e]

v_cos_f32 v5, vcc_lo
// CHECK: [0x6a,0x6c,0x0a,0x7e]

v_cos_f32 v5, vcc_hi
// CHECK: [0x6b,0x6c,0x0a,0x7e]

v_cos_f32 v5, tba_lo
// CHECK: [0x6c,0x6c,0x0a,0x7e]

v_cos_f32 v5, tba_hi
// CHECK: [0x6d,0x6c,0x0a,0x7e]

v_cos_f32 v5, tma_lo
// CHECK: [0x6e,0x6c,0x0a,0x7e]

v_cos_f32 v5, tma_hi
// CHECK: [0x6f,0x6c,0x0a,0x7e]

v_cos_f32 v5, ttmp11
// CHECK: [0x7b,0x6c,0x0a,0x7e]

v_cos_f32 v5, m0
// CHECK: [0x7c,0x6c,0x0a,0x7e]

v_cos_f32 v5, exec_lo
// CHECK: [0x7e,0x6c,0x0a,0x7e]

v_cos_f32 v5, exec_hi
// CHECK: [0x7f,0x6c,0x0a,0x7e]

v_cos_f32 v5, 0
// CHECK: [0x80,0x6c,0x0a,0x7e]

v_cos_f32 v5, -1
// CHECK: [0xc1,0x6c,0x0a,0x7e]

v_cos_f32 v5, 0.5
// CHECK: [0xf0,0x6c,0x0a,0x7e]

v_cos_f32 v5, -4.0
// CHECK: [0xf7,0x6c,0x0a,0x7e]

v_cos_f32 v5, 0xaf123456
// CHECK: [0xff,0x6c,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_cos_f32 v5, 0x3f717273
// CHECK: [0xff,0x6c,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_cos_f32_e64 v5, v1
// CHECK: [0x05,0x00,0x6c,0xd3,0x01,0x01,0x00,0x00]

v_cos_f32_e64 v255, v1
// CHECK: [0xff,0x00,0x6c,0xd3,0x01,0x01,0x00,0x00]

v_cos_f32_e64 v5, v255
// CHECK: [0x05,0x00,0x6c,0xd3,0xff,0x01,0x00,0x00]

v_cos_f32_e64 v5, s1
// CHECK: [0x05,0x00,0x6c,0xd3,0x01,0x00,0x00,0x00]

v_cos_f32_e64 v5, s103
// CHECK: [0x05,0x00,0x6c,0xd3,0x67,0x00,0x00,0x00]

v_cos_f32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x6c,0xd3,0x68,0x00,0x00,0x00]

v_cos_f32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x6c,0xd3,0x69,0x00,0x00,0x00]

v_cos_f32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x6c,0xd3,0x6a,0x00,0x00,0x00]

v_cos_f32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x6c,0xd3,0x6b,0x00,0x00,0x00]

v_cos_f32_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x6c,0xd3,0x6c,0x00,0x00,0x00]

v_cos_f32_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x6c,0xd3,0x6d,0x00,0x00,0x00]

v_cos_f32_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x6c,0xd3,0x6e,0x00,0x00,0x00]

v_cos_f32_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x6c,0xd3,0x6f,0x00,0x00,0x00]

v_cos_f32_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x6c,0xd3,0x7b,0x00,0x00,0x00]

v_cos_f32_e64 v5, m0
// CHECK: [0x05,0x00,0x6c,0xd3,0x7c,0x00,0x00,0x00]

v_cos_f32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x6c,0xd3,0x7e,0x00,0x00,0x00]

v_cos_f32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x6c,0xd3,0x7f,0x00,0x00,0x00]

v_cos_f32_e64 v5, 0
// CHECK: [0x05,0x00,0x6c,0xd3,0x80,0x00,0x00,0x00]

v_cos_f32_e64 v5, -1
// CHECK: [0x05,0x00,0x6c,0xd3,0xc1,0x00,0x00,0x00]

v_cos_f32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x6c,0xd3,0xf0,0x00,0x00,0x00]

v_cos_f32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x6c,0xd3,0xf7,0x00,0x00,0x00]

v_cos_f32_e64 v5, -v1
// CHECK: [0x05,0x00,0x6c,0xd3,0x01,0x01,0x00,0x20]

v_cos_f32_e64 v5, |v1|
// CHECK: [0x05,0x01,0x6c,0xd3,0x01,0x01,0x00,0x00]

v_cos_f32_e64 v5, v1 clamp
// CHECK: [0x05,0x08,0x6c,0xd3,0x01,0x01,0x00,0x00]

v_cos_f32_e64 v5, v1 mul:2
// CHECK: [0x05,0x00,0x6c,0xd3,0x01,0x01,0x00,0x08]

v_cos_f32_e64 v5, v1 mul:4
// CHECK: [0x05,0x00,0x6c,0xd3,0x01,0x01,0x00,0x10]

v_cos_f32_e64 v5, v1 div:2
// CHECK: [0x05,0x00,0x6c,0xd3,0x01,0x01,0x00,0x18]

v_not_b32 v5, v1
// CHECK: [0x01,0x6f,0x0a,0x7e]

v_not_b32 v255, v1
// CHECK: [0x01,0x6f,0xfe,0x7f]

v_not_b32 v5, v255
// CHECK: [0xff,0x6f,0x0a,0x7e]

v_not_b32 v5, s1
// CHECK: [0x01,0x6e,0x0a,0x7e]

v_not_b32 v5, s103
// CHECK: [0x67,0x6e,0x0a,0x7e]

v_not_b32 v5, flat_scratch_lo
// CHECK: [0x68,0x6e,0x0a,0x7e]

v_not_b32 v5, flat_scratch_hi
// CHECK: [0x69,0x6e,0x0a,0x7e]

v_not_b32 v5, vcc_lo
// CHECK: [0x6a,0x6e,0x0a,0x7e]

v_not_b32 v5, vcc_hi
// CHECK: [0x6b,0x6e,0x0a,0x7e]

v_not_b32 v5, tba_lo
// CHECK: [0x6c,0x6e,0x0a,0x7e]

v_not_b32 v5, tba_hi
// CHECK: [0x6d,0x6e,0x0a,0x7e]

v_not_b32 v5, tma_lo
// CHECK: [0x6e,0x6e,0x0a,0x7e]

v_not_b32 v5, tma_hi
// CHECK: [0x6f,0x6e,0x0a,0x7e]

v_not_b32 v5, ttmp11
// CHECK: [0x7b,0x6e,0x0a,0x7e]

v_not_b32 v5, m0
// CHECK: [0x7c,0x6e,0x0a,0x7e]

v_not_b32 v5, exec_lo
// CHECK: [0x7e,0x6e,0x0a,0x7e]

v_not_b32 v5, exec_hi
// CHECK: [0x7f,0x6e,0x0a,0x7e]

v_not_b32 v5, 0
// CHECK: [0x80,0x6e,0x0a,0x7e]

v_not_b32 v5, -1
// CHECK: [0xc1,0x6e,0x0a,0x7e]

v_not_b32 v5, 0.5
// CHECK: [0xf0,0x6e,0x0a,0x7e]

v_not_b32 v5, -4.0
// CHECK: [0xf7,0x6e,0x0a,0x7e]

v_not_b32 v5, 0xaf123456
// CHECK: [0xff,0x6e,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_not_b32 v5, 0x3f717273
// CHECK: [0xff,0x6e,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_not_b32_e64 v5, v1
// CHECK: [0x05,0x00,0x6e,0xd3,0x01,0x01,0x00,0x00]

v_not_b32_e64 v255, v1
// CHECK: [0xff,0x00,0x6e,0xd3,0x01,0x01,0x00,0x00]

v_not_b32_e64 v5, v255
// CHECK: [0x05,0x00,0x6e,0xd3,0xff,0x01,0x00,0x00]

v_not_b32_e64 v5, s1
// CHECK: [0x05,0x00,0x6e,0xd3,0x01,0x00,0x00,0x00]

v_not_b32_e64 v5, s103
// CHECK: [0x05,0x00,0x6e,0xd3,0x67,0x00,0x00,0x00]

v_not_b32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x6e,0xd3,0x68,0x00,0x00,0x00]

v_not_b32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x6e,0xd3,0x69,0x00,0x00,0x00]

v_not_b32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x6e,0xd3,0x6a,0x00,0x00,0x00]

v_not_b32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x6e,0xd3,0x6b,0x00,0x00,0x00]

v_not_b32_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x6e,0xd3,0x6c,0x00,0x00,0x00]

v_not_b32_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x6e,0xd3,0x6d,0x00,0x00,0x00]

v_not_b32_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x6e,0xd3,0x6e,0x00,0x00,0x00]

v_not_b32_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x6e,0xd3,0x6f,0x00,0x00,0x00]

v_not_b32_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x6e,0xd3,0x7b,0x00,0x00,0x00]

v_not_b32_e64 v5, m0
// CHECK: [0x05,0x00,0x6e,0xd3,0x7c,0x00,0x00,0x00]

v_not_b32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x6e,0xd3,0x7e,0x00,0x00,0x00]

v_not_b32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x6e,0xd3,0x7f,0x00,0x00,0x00]

v_not_b32_e64 v5, 0
// CHECK: [0x05,0x00,0x6e,0xd3,0x80,0x00,0x00,0x00]

v_not_b32_e64 v5, -1
// CHECK: [0x05,0x00,0x6e,0xd3,0xc1,0x00,0x00,0x00]

v_not_b32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x6e,0xd3,0xf0,0x00,0x00,0x00]

v_not_b32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x6e,0xd3,0xf7,0x00,0x00,0x00]

v_bfrev_b32 v5, v1
// CHECK: [0x01,0x71,0x0a,0x7e]

v_bfrev_b32 v255, v1
// CHECK: [0x01,0x71,0xfe,0x7f]

v_bfrev_b32 v5, v255
// CHECK: [0xff,0x71,0x0a,0x7e]

v_bfrev_b32 v5, s1
// CHECK: [0x01,0x70,0x0a,0x7e]

v_bfrev_b32 v5, s103
// CHECK: [0x67,0x70,0x0a,0x7e]

v_bfrev_b32 v5, flat_scratch_lo
// CHECK: [0x68,0x70,0x0a,0x7e]

v_bfrev_b32 v5, flat_scratch_hi
// CHECK: [0x69,0x70,0x0a,0x7e]

v_bfrev_b32 v5, vcc_lo
// CHECK: [0x6a,0x70,0x0a,0x7e]

v_bfrev_b32 v5, vcc_hi
// CHECK: [0x6b,0x70,0x0a,0x7e]

v_bfrev_b32 v5, tba_lo
// CHECK: [0x6c,0x70,0x0a,0x7e]

v_bfrev_b32 v5, tba_hi
// CHECK: [0x6d,0x70,0x0a,0x7e]

v_bfrev_b32 v5, tma_lo
// CHECK: [0x6e,0x70,0x0a,0x7e]

v_bfrev_b32 v5, tma_hi
// CHECK: [0x6f,0x70,0x0a,0x7e]

v_bfrev_b32 v5, ttmp11
// CHECK: [0x7b,0x70,0x0a,0x7e]

v_bfrev_b32 v5, m0
// CHECK: [0x7c,0x70,0x0a,0x7e]

v_bfrev_b32 v5, exec_lo
// CHECK: [0x7e,0x70,0x0a,0x7e]

v_bfrev_b32 v5, exec_hi
// CHECK: [0x7f,0x70,0x0a,0x7e]

v_bfrev_b32 v5, 0
// CHECK: [0x80,0x70,0x0a,0x7e]

v_bfrev_b32 v5, -1
// CHECK: [0xc1,0x70,0x0a,0x7e]

v_bfrev_b32 v5, 0.5
// CHECK: [0xf0,0x70,0x0a,0x7e]

v_bfrev_b32 v5, -4.0
// CHECK: [0xf7,0x70,0x0a,0x7e]

v_bfrev_b32 v5, 0xaf123456
// CHECK: [0xff,0x70,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_bfrev_b32 v5, 0x3f717273
// CHECK: [0xff,0x70,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_bfrev_b32_e64 v5, v1
// CHECK: [0x05,0x00,0x70,0xd3,0x01,0x01,0x00,0x00]

v_bfrev_b32_e64 v255, v1
// CHECK: [0xff,0x00,0x70,0xd3,0x01,0x01,0x00,0x00]

v_bfrev_b32_e64 v5, v255
// CHECK: [0x05,0x00,0x70,0xd3,0xff,0x01,0x00,0x00]

v_bfrev_b32_e64 v5, s1
// CHECK: [0x05,0x00,0x70,0xd3,0x01,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, s103
// CHECK: [0x05,0x00,0x70,0xd3,0x67,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x70,0xd3,0x68,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x70,0xd3,0x69,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x70,0xd3,0x6a,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x70,0xd3,0x6b,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x70,0xd3,0x6c,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x70,0xd3,0x6d,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x70,0xd3,0x6e,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x70,0xd3,0x6f,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x70,0xd3,0x7b,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, m0
// CHECK: [0x05,0x00,0x70,0xd3,0x7c,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x70,0xd3,0x7e,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x70,0xd3,0x7f,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, 0
// CHECK: [0x05,0x00,0x70,0xd3,0x80,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, -1
// CHECK: [0x05,0x00,0x70,0xd3,0xc1,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x70,0xd3,0xf0,0x00,0x00,0x00]

v_bfrev_b32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x70,0xd3,0xf7,0x00,0x00,0x00]

v_ffbh_u32 v5, v1
// CHECK: [0x01,0x73,0x0a,0x7e]

v_ffbh_u32 v255, v1
// CHECK: [0x01,0x73,0xfe,0x7f]

v_ffbh_u32 v5, v255
// CHECK: [0xff,0x73,0x0a,0x7e]

v_ffbh_u32 v5, s1
// CHECK: [0x01,0x72,0x0a,0x7e]

v_ffbh_u32 v5, s103
// CHECK: [0x67,0x72,0x0a,0x7e]

v_ffbh_u32 v5, flat_scratch_lo
// CHECK: [0x68,0x72,0x0a,0x7e]

v_ffbh_u32 v5, flat_scratch_hi
// CHECK: [0x69,0x72,0x0a,0x7e]

v_ffbh_u32 v5, vcc_lo
// CHECK: [0x6a,0x72,0x0a,0x7e]

v_ffbh_u32 v5, vcc_hi
// CHECK: [0x6b,0x72,0x0a,0x7e]

v_ffbh_u32 v5, tba_lo
// CHECK: [0x6c,0x72,0x0a,0x7e]

v_ffbh_u32 v5, tba_hi
// CHECK: [0x6d,0x72,0x0a,0x7e]

v_ffbh_u32 v5, tma_lo
// CHECK: [0x6e,0x72,0x0a,0x7e]

v_ffbh_u32 v5, tma_hi
// CHECK: [0x6f,0x72,0x0a,0x7e]

v_ffbh_u32 v5, ttmp11
// CHECK: [0x7b,0x72,0x0a,0x7e]

v_ffbh_u32 v5, m0
// CHECK: [0x7c,0x72,0x0a,0x7e]

v_ffbh_u32 v5, exec_lo
// CHECK: [0x7e,0x72,0x0a,0x7e]

v_ffbh_u32 v5, exec_hi
// CHECK: [0x7f,0x72,0x0a,0x7e]

v_ffbh_u32 v5, 0
// CHECK: [0x80,0x72,0x0a,0x7e]

v_ffbh_u32 v5, -1
// CHECK: [0xc1,0x72,0x0a,0x7e]

v_ffbh_u32 v5, 0.5
// CHECK: [0xf0,0x72,0x0a,0x7e]

v_ffbh_u32 v5, -4.0
// CHECK: [0xf7,0x72,0x0a,0x7e]

v_ffbh_u32 v5, 0xaf123456
// CHECK: [0xff,0x72,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_ffbh_u32 v5, 0x3f717273
// CHECK: [0xff,0x72,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_ffbh_u32_e64 v5, v1
// CHECK: [0x05,0x00,0x72,0xd3,0x01,0x01,0x00,0x00]

v_ffbh_u32_e64 v255, v1
// CHECK: [0xff,0x00,0x72,0xd3,0x01,0x01,0x00,0x00]

v_ffbh_u32_e64 v5, v255
// CHECK: [0x05,0x00,0x72,0xd3,0xff,0x01,0x00,0x00]

v_ffbh_u32_e64 v5, s1
// CHECK: [0x05,0x00,0x72,0xd3,0x01,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, s103
// CHECK: [0x05,0x00,0x72,0xd3,0x67,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x72,0xd3,0x68,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x72,0xd3,0x69,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x72,0xd3,0x6a,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x72,0xd3,0x6b,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x72,0xd3,0x6c,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x72,0xd3,0x6d,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x72,0xd3,0x6e,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x72,0xd3,0x6f,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x72,0xd3,0x7b,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, m0
// CHECK: [0x05,0x00,0x72,0xd3,0x7c,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x72,0xd3,0x7e,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x72,0xd3,0x7f,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, 0
// CHECK: [0x05,0x00,0x72,0xd3,0x80,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, -1
// CHECK: [0x05,0x00,0x72,0xd3,0xc1,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x72,0xd3,0xf0,0x00,0x00,0x00]

v_ffbh_u32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x72,0xd3,0xf7,0x00,0x00,0x00]

v_ffbl_b32 v5, v1
// CHECK: [0x01,0x75,0x0a,0x7e]

v_ffbl_b32 v255, v1
// CHECK: [0x01,0x75,0xfe,0x7f]

v_ffbl_b32 v5, v255
// CHECK: [0xff,0x75,0x0a,0x7e]

v_ffbl_b32 v5, s1
// CHECK: [0x01,0x74,0x0a,0x7e]

v_ffbl_b32 v5, s103
// CHECK: [0x67,0x74,0x0a,0x7e]

v_ffbl_b32 v5, flat_scratch_lo
// CHECK: [0x68,0x74,0x0a,0x7e]

v_ffbl_b32 v5, flat_scratch_hi
// CHECK: [0x69,0x74,0x0a,0x7e]

v_ffbl_b32 v5, vcc_lo
// CHECK: [0x6a,0x74,0x0a,0x7e]

v_ffbl_b32 v5, vcc_hi
// CHECK: [0x6b,0x74,0x0a,0x7e]

v_ffbl_b32 v5, tba_lo
// CHECK: [0x6c,0x74,0x0a,0x7e]

v_ffbl_b32 v5, tba_hi
// CHECK: [0x6d,0x74,0x0a,0x7e]

v_ffbl_b32 v5, tma_lo
// CHECK: [0x6e,0x74,0x0a,0x7e]

v_ffbl_b32 v5, tma_hi
// CHECK: [0x6f,0x74,0x0a,0x7e]

v_ffbl_b32 v5, ttmp11
// CHECK: [0x7b,0x74,0x0a,0x7e]

v_ffbl_b32 v5, m0
// CHECK: [0x7c,0x74,0x0a,0x7e]

v_ffbl_b32 v5, exec_lo
// CHECK: [0x7e,0x74,0x0a,0x7e]

v_ffbl_b32 v5, exec_hi
// CHECK: [0x7f,0x74,0x0a,0x7e]

v_ffbl_b32 v5, 0
// CHECK: [0x80,0x74,0x0a,0x7e]

v_ffbl_b32 v5, -1
// CHECK: [0xc1,0x74,0x0a,0x7e]

v_ffbl_b32 v5, 0.5
// CHECK: [0xf0,0x74,0x0a,0x7e]

v_ffbl_b32 v5, -4.0
// CHECK: [0xf7,0x74,0x0a,0x7e]

v_ffbl_b32 v5, 0xaf123456
// CHECK: [0xff,0x74,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_ffbl_b32 v5, 0x3f717273
// CHECK: [0xff,0x74,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_ffbl_b32_e64 v5, v1
// CHECK: [0x05,0x00,0x74,0xd3,0x01,0x01,0x00,0x00]

v_ffbl_b32_e64 v255, v1
// CHECK: [0xff,0x00,0x74,0xd3,0x01,0x01,0x00,0x00]

v_ffbl_b32_e64 v5, v255
// CHECK: [0x05,0x00,0x74,0xd3,0xff,0x01,0x00,0x00]

v_ffbl_b32_e64 v5, s1
// CHECK: [0x05,0x00,0x74,0xd3,0x01,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, s103
// CHECK: [0x05,0x00,0x74,0xd3,0x67,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x74,0xd3,0x68,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x74,0xd3,0x69,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x74,0xd3,0x6a,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x74,0xd3,0x6b,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x74,0xd3,0x6c,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x74,0xd3,0x6d,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x74,0xd3,0x6e,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x74,0xd3,0x6f,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x74,0xd3,0x7b,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, m0
// CHECK: [0x05,0x00,0x74,0xd3,0x7c,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x74,0xd3,0x7e,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x74,0xd3,0x7f,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, 0
// CHECK: [0x05,0x00,0x74,0xd3,0x80,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, -1
// CHECK: [0x05,0x00,0x74,0xd3,0xc1,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x74,0xd3,0xf0,0x00,0x00,0x00]

v_ffbl_b32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x74,0xd3,0xf7,0x00,0x00,0x00]

v_ffbh_i32 v5, v1
// CHECK: [0x01,0x77,0x0a,0x7e]

v_ffbh_i32 v255, v1
// CHECK: [0x01,0x77,0xfe,0x7f]

v_ffbh_i32 v5, v255
// CHECK: [0xff,0x77,0x0a,0x7e]

v_ffbh_i32 v5, s1
// CHECK: [0x01,0x76,0x0a,0x7e]

v_ffbh_i32 v5, s103
// CHECK: [0x67,0x76,0x0a,0x7e]

v_ffbh_i32 v5, flat_scratch_lo
// CHECK: [0x68,0x76,0x0a,0x7e]

v_ffbh_i32 v5, flat_scratch_hi
// CHECK: [0x69,0x76,0x0a,0x7e]

v_ffbh_i32 v5, vcc_lo
// CHECK: [0x6a,0x76,0x0a,0x7e]

v_ffbh_i32 v5, vcc_hi
// CHECK: [0x6b,0x76,0x0a,0x7e]

v_ffbh_i32 v5, tba_lo
// CHECK: [0x6c,0x76,0x0a,0x7e]

v_ffbh_i32 v5, tba_hi
// CHECK: [0x6d,0x76,0x0a,0x7e]

v_ffbh_i32 v5, tma_lo
// CHECK: [0x6e,0x76,0x0a,0x7e]

v_ffbh_i32 v5, tma_hi
// CHECK: [0x6f,0x76,0x0a,0x7e]

v_ffbh_i32 v5, ttmp11
// CHECK: [0x7b,0x76,0x0a,0x7e]

v_ffbh_i32 v5, m0
// CHECK: [0x7c,0x76,0x0a,0x7e]

v_ffbh_i32 v5, exec_lo
// CHECK: [0x7e,0x76,0x0a,0x7e]

v_ffbh_i32 v5, exec_hi
// CHECK: [0x7f,0x76,0x0a,0x7e]

v_ffbh_i32 v5, 0
// CHECK: [0x80,0x76,0x0a,0x7e]

v_ffbh_i32 v5, -1
// CHECK: [0xc1,0x76,0x0a,0x7e]

v_ffbh_i32 v5, 0.5
// CHECK: [0xf0,0x76,0x0a,0x7e]

v_ffbh_i32 v5, -4.0
// CHECK: [0xf7,0x76,0x0a,0x7e]

v_ffbh_i32 v5, 0xaf123456
// CHECK: [0xff,0x76,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_ffbh_i32 v5, 0x3f717273
// CHECK: [0xff,0x76,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_ffbh_i32_e64 v5, v1
// CHECK: [0x05,0x00,0x76,0xd3,0x01,0x01,0x00,0x00]

v_ffbh_i32_e64 v255, v1
// CHECK: [0xff,0x00,0x76,0xd3,0x01,0x01,0x00,0x00]

v_ffbh_i32_e64 v5, v255
// CHECK: [0x05,0x00,0x76,0xd3,0xff,0x01,0x00,0x00]

v_ffbh_i32_e64 v5, s1
// CHECK: [0x05,0x00,0x76,0xd3,0x01,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, s103
// CHECK: [0x05,0x00,0x76,0xd3,0x67,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x76,0xd3,0x68,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x76,0xd3,0x69,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x76,0xd3,0x6a,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x76,0xd3,0x6b,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x76,0xd3,0x6c,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x76,0xd3,0x6d,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x76,0xd3,0x6e,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x76,0xd3,0x6f,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x76,0xd3,0x7b,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, m0
// CHECK: [0x05,0x00,0x76,0xd3,0x7c,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x76,0xd3,0x7e,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x76,0xd3,0x7f,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, 0
// CHECK: [0x05,0x00,0x76,0xd3,0x80,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, -1
// CHECK: [0x05,0x00,0x76,0xd3,0xc1,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x76,0xd3,0xf0,0x00,0x00,0x00]

v_ffbh_i32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x76,0xd3,0xf7,0x00,0x00,0x00]

v_frexp_exp_i32_f64 v5, v[1:2]
// CHECK: [0x01,0x79,0x0a,0x7e]

v_frexp_exp_i32_f64 v255, v[1:2]
// CHECK: [0x01,0x79,0xfe,0x7f]

v_frexp_exp_i32_f64 v5, v[254:255]
// CHECK: [0xfe,0x79,0x0a,0x7e]

v_frexp_exp_i32_f64 v5, s[2:3]
// CHECK: [0x02,0x78,0x0a,0x7e]

v_frexp_exp_i32_f64 v5, s[4:5]
// CHECK: [0x04,0x78,0x0a,0x7e]

v_frexp_exp_i32_f64 v5, s[102:103]
// CHECK: [0x66,0x78,0x0a,0x7e]

v_frexp_exp_i32_f64 v5, flat_scratch
// CHECK: [0x68,0x78,0x0a,0x7e]

v_frexp_exp_i32_f64 v5, vcc
// CHECK: [0x6a,0x78,0x0a,0x7e]

v_frexp_exp_i32_f64 v5, tba
// CHECK: [0x6c,0x78,0x0a,0x7e]

v_frexp_exp_i32_f64 v5, tma
// CHECK: [0x6e,0x78,0x0a,0x7e]

v_frexp_exp_i32_f64 v5, ttmp[10:11]
// CHECK: [0x7a,0x78,0x0a,0x7e]

v_frexp_exp_i32_f64 v5, exec
// CHECK: [0x7e,0x78,0x0a,0x7e]

v_frexp_exp_i32_f64 v5, 0
// CHECK: [0x80,0x78,0x0a,0x7e]

v_frexp_exp_i32_f64 v5, -1
// CHECK: [0xc1,0x78,0x0a,0x7e]

v_frexp_exp_i32_f64 v5, 0.5
// CHECK: [0xf0,0x78,0x0a,0x7e]

v_frexp_exp_i32_f64 v5, -4.0
// CHECK: [0xf7,0x78,0x0a,0x7e]

v_frexp_exp_i32_f64 v5, 0xaf123456
// CHECK: [0xff,0x78,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_frexp_exp_i32_f64 v5, 0x3f717273
// CHECK: [0xff,0x78,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_frexp_exp_i32_f64_e64 v5, v[1:2]
// CHECK: [0x05,0x00,0x78,0xd3,0x01,0x01,0x00,0x00]

v_frexp_exp_i32_f64_e64 v255, v[1:2]
// CHECK: [0xff,0x00,0x78,0xd3,0x01,0x01,0x00,0x00]

v_frexp_exp_i32_f64_e64 v5, v[254:255]
// CHECK: [0x05,0x00,0x78,0xd3,0xfe,0x01,0x00,0x00]

v_frexp_exp_i32_f64_e64 v5, s[2:3]
// CHECK: [0x05,0x00,0x78,0xd3,0x02,0x00,0x00,0x00]

v_frexp_exp_i32_f64_e64 v5, s[4:5]
// CHECK: [0x05,0x00,0x78,0xd3,0x04,0x00,0x00,0x00]

v_frexp_exp_i32_f64_e64 v5, s[102:103]
// CHECK: [0x05,0x00,0x78,0xd3,0x66,0x00,0x00,0x00]

v_frexp_exp_i32_f64_e64 v5, flat_scratch
// CHECK: [0x05,0x00,0x78,0xd3,0x68,0x00,0x00,0x00]

v_frexp_exp_i32_f64_e64 v5, vcc
// CHECK: [0x05,0x00,0x78,0xd3,0x6a,0x00,0x00,0x00]

v_frexp_exp_i32_f64_e64 v5, tba
// CHECK: [0x05,0x00,0x78,0xd3,0x6c,0x00,0x00,0x00]

v_frexp_exp_i32_f64_e64 v5, tma
// CHECK: [0x05,0x00,0x78,0xd3,0x6e,0x00,0x00,0x00]

v_frexp_exp_i32_f64_e64 v5, ttmp[10:11]
// CHECK: [0x05,0x00,0x78,0xd3,0x7a,0x00,0x00,0x00]

v_frexp_exp_i32_f64_e64 v5, exec
// CHECK: [0x05,0x00,0x78,0xd3,0x7e,0x00,0x00,0x00]

v_frexp_exp_i32_f64_e64 v5, 0
// CHECK: [0x05,0x00,0x78,0xd3,0x80,0x00,0x00,0x00]

v_frexp_exp_i32_f64_e64 v5, -1
// CHECK: [0x05,0x00,0x78,0xd3,0xc1,0x00,0x00,0x00]

v_frexp_exp_i32_f64_e64 v5, 0.5
// CHECK: [0x05,0x00,0x78,0xd3,0xf0,0x00,0x00,0x00]

v_frexp_exp_i32_f64_e64 v5, -4.0
// CHECK: [0x05,0x00,0x78,0xd3,0xf7,0x00,0x00,0x00]

v_frexp_exp_i32_f64_e64 v5, -v[1:2]
// CHECK: [0x05,0x00,0x78,0xd3,0x01,0x01,0x00,0x20]

v_frexp_exp_i32_f64_e64 v5, |v[1:2]|
// CHECK: [0x05,0x01,0x78,0xd3,0x01,0x01,0x00,0x00]

v_frexp_mant_f64 v[5:6], v[1:2]
// CHECK: [0x01,0x7b,0x0a,0x7e]

v_frexp_mant_f64 v[254:255], v[1:2]
// CHECK: [0x01,0x7b,0xfc,0x7f]

v_frexp_mant_f64 v[5:6], v[254:255]
// CHECK: [0xfe,0x7b,0x0a,0x7e]

v_frexp_mant_f64 v[5:6], s[2:3]
// CHECK: [0x02,0x7a,0x0a,0x7e]

v_frexp_mant_f64 v[5:6], s[4:5]
// CHECK: [0x04,0x7a,0x0a,0x7e]

v_frexp_mant_f64 v[5:6], s[102:103]
// CHECK: [0x66,0x7a,0x0a,0x7e]

v_frexp_mant_f64 v[5:6], flat_scratch
// CHECK: [0x68,0x7a,0x0a,0x7e]

v_frexp_mant_f64 v[5:6], vcc
// CHECK: [0x6a,0x7a,0x0a,0x7e]

v_frexp_mant_f64 v[5:6], tba
// CHECK: [0x6c,0x7a,0x0a,0x7e]

v_frexp_mant_f64 v[5:6], tma
// CHECK: [0x6e,0x7a,0x0a,0x7e]

v_frexp_mant_f64 v[5:6], ttmp[10:11]
// CHECK: [0x7a,0x7a,0x0a,0x7e]

v_frexp_mant_f64 v[5:6], exec
// CHECK: [0x7e,0x7a,0x0a,0x7e]

v_frexp_mant_f64 v[5:6], 0
// CHECK: [0x80,0x7a,0x0a,0x7e]

v_frexp_mant_f64 v[5:6], -1
// CHECK: [0xc1,0x7a,0x0a,0x7e]

v_frexp_mant_f64 v[5:6], 0.5
// CHECK: [0xf0,0x7a,0x0a,0x7e]

v_frexp_mant_f64 v[5:6], -4.0
// CHECK: [0xf7,0x7a,0x0a,0x7e]

v_frexp_mant_f64 v[5:6], 0xaf123456
// CHECK: [0xff,0x7a,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_frexp_mant_f64 v[5:6], 0x3f717273
// CHECK: [0xff,0x7a,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_frexp_mant_f64_e64 v[5:6], v[1:2]
// CHECK: [0x05,0x00,0x7a,0xd3,0x01,0x01,0x00,0x00]

v_frexp_mant_f64_e64 v[254:255], v[1:2]
// CHECK: [0xfe,0x00,0x7a,0xd3,0x01,0x01,0x00,0x00]

v_frexp_mant_f64_e64 v[5:6], v[254:255]
// CHECK: [0x05,0x00,0x7a,0xd3,0xfe,0x01,0x00,0x00]

v_frexp_mant_f64_e64 v[5:6], s[2:3]
// CHECK: [0x05,0x00,0x7a,0xd3,0x02,0x00,0x00,0x00]

v_frexp_mant_f64_e64 v[5:6], s[4:5]
// CHECK: [0x05,0x00,0x7a,0xd3,0x04,0x00,0x00,0x00]

v_frexp_mant_f64_e64 v[5:6], s[102:103]
// CHECK: [0x05,0x00,0x7a,0xd3,0x66,0x00,0x00,0x00]

v_frexp_mant_f64_e64 v[5:6], flat_scratch
// CHECK: [0x05,0x00,0x7a,0xd3,0x68,0x00,0x00,0x00]

v_frexp_mant_f64_e64 v[5:6], vcc
// CHECK: [0x05,0x00,0x7a,0xd3,0x6a,0x00,0x00,0x00]

v_frexp_mant_f64_e64 v[5:6], tba
// CHECK: [0x05,0x00,0x7a,0xd3,0x6c,0x00,0x00,0x00]

v_frexp_mant_f64_e64 v[5:6], tma
// CHECK: [0x05,0x00,0x7a,0xd3,0x6e,0x00,0x00,0x00]

v_frexp_mant_f64_e64 v[5:6], ttmp[10:11]
// CHECK: [0x05,0x00,0x7a,0xd3,0x7a,0x00,0x00,0x00]

v_frexp_mant_f64_e64 v[5:6], exec
// CHECK: [0x05,0x00,0x7a,0xd3,0x7e,0x00,0x00,0x00]

v_frexp_mant_f64_e64 v[5:6], 0
// CHECK: [0x05,0x00,0x7a,0xd3,0x80,0x00,0x00,0x00]

v_frexp_mant_f64_e64 v[5:6], -1
// CHECK: [0x05,0x00,0x7a,0xd3,0xc1,0x00,0x00,0x00]

v_frexp_mant_f64_e64 v[5:6], 0.5
// CHECK: [0x05,0x00,0x7a,0xd3,0xf0,0x00,0x00,0x00]

v_frexp_mant_f64_e64 v[5:6], -4.0
// CHECK: [0x05,0x00,0x7a,0xd3,0xf7,0x00,0x00,0x00]

v_frexp_mant_f64_e64 v[5:6], -v[1:2]
// CHECK: [0x05,0x00,0x7a,0xd3,0x01,0x01,0x00,0x20]

v_frexp_mant_f64_e64 v[5:6], |v[1:2]|
// CHECK: [0x05,0x01,0x7a,0xd3,0x01,0x01,0x00,0x00]

v_frexp_mant_f64_e64 v[5:6], v[1:2] clamp
// CHECK: [0x05,0x08,0x7a,0xd3,0x01,0x01,0x00,0x00]

v_frexp_mant_f64_e64 v[5:6], v[1:2] mul:2
// CHECK: [0x05,0x00,0x7a,0xd3,0x01,0x01,0x00,0x08]

v_frexp_mant_f64_e64 v[5:6], v[1:2] mul:4
// CHECK: [0x05,0x00,0x7a,0xd3,0x01,0x01,0x00,0x10]

v_frexp_mant_f64_e64 v[5:6], v[1:2] div:2
// CHECK: [0x05,0x00,0x7a,0xd3,0x01,0x01,0x00,0x18]

v_fract_f64 v[5:6], v[1:2]
// CHECK: [0x01,0x7d,0x0a,0x7e]

v_fract_f64 v[254:255], v[1:2]
// CHECK: [0x01,0x7d,0xfc,0x7f]

v_fract_f64 v[5:6], v[254:255]
// CHECK: [0xfe,0x7d,0x0a,0x7e]

v_fract_f64 v[5:6], s[2:3]
// CHECK: [0x02,0x7c,0x0a,0x7e]

v_fract_f64 v[5:6], s[4:5]
// CHECK: [0x04,0x7c,0x0a,0x7e]

v_fract_f64 v[5:6], s[102:103]
// CHECK: [0x66,0x7c,0x0a,0x7e]

v_fract_f64 v[5:6], flat_scratch
// CHECK: [0x68,0x7c,0x0a,0x7e]

v_fract_f64 v[5:6], vcc
// CHECK: [0x6a,0x7c,0x0a,0x7e]

v_fract_f64 v[5:6], tba
// CHECK: [0x6c,0x7c,0x0a,0x7e]

v_fract_f64 v[5:6], tma
// CHECK: [0x6e,0x7c,0x0a,0x7e]

v_fract_f64 v[5:6], ttmp[10:11]
// CHECK: [0x7a,0x7c,0x0a,0x7e]

v_fract_f64 v[5:6], exec
// CHECK: [0x7e,0x7c,0x0a,0x7e]

v_fract_f64 v[5:6], 0
// CHECK: [0x80,0x7c,0x0a,0x7e]

v_fract_f64 v[5:6], -1
// CHECK: [0xc1,0x7c,0x0a,0x7e]

v_fract_f64 v[5:6], 0.5
// CHECK: [0xf0,0x7c,0x0a,0x7e]

v_fract_f64 v[5:6], -4.0
// CHECK: [0xf7,0x7c,0x0a,0x7e]

v_fract_f64 v[5:6], 0xaf123456
// CHECK: [0xff,0x7c,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_fract_f64 v[5:6], 0x3f717273
// CHECK: [0xff,0x7c,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_fract_f64_e64 v[5:6], v[1:2]
// CHECK: [0x05,0x00,0x7c,0xd3,0x01,0x01,0x00,0x00]

v_fract_f64_e64 v[254:255], v[1:2]
// CHECK: [0xfe,0x00,0x7c,0xd3,0x01,0x01,0x00,0x00]

v_fract_f64_e64 v[5:6], v[254:255]
// CHECK: [0x05,0x00,0x7c,0xd3,0xfe,0x01,0x00,0x00]

v_fract_f64_e64 v[5:6], s[2:3]
// CHECK: [0x05,0x00,0x7c,0xd3,0x02,0x00,0x00,0x00]

v_fract_f64_e64 v[5:6], s[4:5]
// CHECK: [0x05,0x00,0x7c,0xd3,0x04,0x00,0x00,0x00]

v_fract_f64_e64 v[5:6], s[102:103]
// CHECK: [0x05,0x00,0x7c,0xd3,0x66,0x00,0x00,0x00]

v_fract_f64_e64 v[5:6], flat_scratch
// CHECK: [0x05,0x00,0x7c,0xd3,0x68,0x00,0x00,0x00]

v_fract_f64_e64 v[5:6], vcc
// CHECK: [0x05,0x00,0x7c,0xd3,0x6a,0x00,0x00,0x00]

v_fract_f64_e64 v[5:6], tba
// CHECK: [0x05,0x00,0x7c,0xd3,0x6c,0x00,0x00,0x00]

v_fract_f64_e64 v[5:6], tma
// CHECK: [0x05,0x00,0x7c,0xd3,0x6e,0x00,0x00,0x00]

v_fract_f64_e64 v[5:6], ttmp[10:11]
// CHECK: [0x05,0x00,0x7c,0xd3,0x7a,0x00,0x00,0x00]

v_fract_f64_e64 v[5:6], exec
// CHECK: [0x05,0x00,0x7c,0xd3,0x7e,0x00,0x00,0x00]

v_fract_f64_e64 v[5:6], 0
// CHECK: [0x05,0x00,0x7c,0xd3,0x80,0x00,0x00,0x00]

v_fract_f64_e64 v[5:6], -1
// CHECK: [0x05,0x00,0x7c,0xd3,0xc1,0x00,0x00,0x00]

v_fract_f64_e64 v[5:6], 0.5
// CHECK: [0x05,0x00,0x7c,0xd3,0xf0,0x00,0x00,0x00]

v_fract_f64_e64 v[5:6], -4.0
// CHECK: [0x05,0x00,0x7c,0xd3,0xf7,0x00,0x00,0x00]

v_fract_f64_e64 v[5:6], -v[1:2]
// CHECK: [0x05,0x00,0x7c,0xd3,0x01,0x01,0x00,0x20]

v_fract_f64_e64 v[5:6], |v[1:2]|
// CHECK: [0x05,0x01,0x7c,0xd3,0x01,0x01,0x00,0x00]

v_fract_f64_e64 v[5:6], v[1:2] clamp
// CHECK: [0x05,0x08,0x7c,0xd3,0x01,0x01,0x00,0x00]

v_fract_f64_e64 v[5:6], v[1:2] mul:2
// CHECK: [0x05,0x00,0x7c,0xd3,0x01,0x01,0x00,0x08]

v_fract_f64_e64 v[5:6], v[1:2] mul:4
// CHECK: [0x05,0x00,0x7c,0xd3,0x01,0x01,0x00,0x10]

v_fract_f64_e64 v[5:6], v[1:2] div:2
// CHECK: [0x05,0x00,0x7c,0xd3,0x01,0x01,0x00,0x18]

v_frexp_exp_i32_f32 v5, v1
// CHECK: [0x01,0x7f,0x0a,0x7e]

v_frexp_exp_i32_f32 v255, v1
// CHECK: [0x01,0x7f,0xfe,0x7f]

v_frexp_exp_i32_f32 v5, v255
// CHECK: [0xff,0x7f,0x0a,0x7e]

v_frexp_exp_i32_f32 v5, s1
// CHECK: [0x01,0x7e,0x0a,0x7e]

v_frexp_exp_i32_f32 v5, s103
// CHECK: [0x67,0x7e,0x0a,0x7e]

v_frexp_exp_i32_f32 v5, flat_scratch_lo
// CHECK: [0x68,0x7e,0x0a,0x7e]

v_frexp_exp_i32_f32 v5, flat_scratch_hi
// CHECK: [0x69,0x7e,0x0a,0x7e]

v_frexp_exp_i32_f32 v5, vcc_lo
// CHECK: [0x6a,0x7e,0x0a,0x7e]

v_frexp_exp_i32_f32 v5, vcc_hi
// CHECK: [0x6b,0x7e,0x0a,0x7e]

v_frexp_exp_i32_f32 v5, tba_lo
// CHECK: [0x6c,0x7e,0x0a,0x7e]

v_frexp_exp_i32_f32 v5, tba_hi
// CHECK: [0x6d,0x7e,0x0a,0x7e]

v_frexp_exp_i32_f32 v5, tma_lo
// CHECK: [0x6e,0x7e,0x0a,0x7e]

v_frexp_exp_i32_f32 v5, tma_hi
// CHECK: [0x6f,0x7e,0x0a,0x7e]

v_frexp_exp_i32_f32 v5, ttmp11
// CHECK: [0x7b,0x7e,0x0a,0x7e]

v_frexp_exp_i32_f32 v5, m0
// CHECK: [0x7c,0x7e,0x0a,0x7e]

v_frexp_exp_i32_f32 v5, exec_lo
// CHECK: [0x7e,0x7e,0x0a,0x7e]

v_frexp_exp_i32_f32 v5, exec_hi
// CHECK: [0x7f,0x7e,0x0a,0x7e]

v_frexp_exp_i32_f32 v5, 0
// CHECK: [0x80,0x7e,0x0a,0x7e]

v_frexp_exp_i32_f32 v5, -1
// CHECK: [0xc1,0x7e,0x0a,0x7e]

v_frexp_exp_i32_f32 v5, 0.5
// CHECK: [0xf0,0x7e,0x0a,0x7e]

v_frexp_exp_i32_f32 v5, -4.0
// CHECK: [0xf7,0x7e,0x0a,0x7e]

v_frexp_exp_i32_f32 v5, 0xaf123456
// CHECK: [0xff,0x7e,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_frexp_exp_i32_f32 v5, 0x3f717273
// CHECK: [0xff,0x7e,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_frexp_exp_i32_f32_e64 v5, v1
// CHECK: [0x05,0x00,0x7e,0xd3,0x01,0x01,0x00,0x00]

v_frexp_exp_i32_f32_e64 v255, v1
// CHECK: [0xff,0x00,0x7e,0xd3,0x01,0x01,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, v255
// CHECK: [0x05,0x00,0x7e,0xd3,0xff,0x01,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, s1
// CHECK: [0x05,0x00,0x7e,0xd3,0x01,0x00,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, s103
// CHECK: [0x05,0x00,0x7e,0xd3,0x67,0x00,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x7e,0xd3,0x68,0x00,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x7e,0xd3,0x69,0x00,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x7e,0xd3,0x6a,0x00,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x7e,0xd3,0x6b,0x00,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x7e,0xd3,0x6c,0x00,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x7e,0xd3,0x6d,0x00,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x7e,0xd3,0x6e,0x00,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x7e,0xd3,0x6f,0x00,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x7e,0xd3,0x7b,0x00,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, m0
// CHECK: [0x05,0x00,0x7e,0xd3,0x7c,0x00,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x7e,0xd3,0x7e,0x00,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x7e,0xd3,0x7f,0x00,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, 0
// CHECK: [0x05,0x00,0x7e,0xd3,0x80,0x00,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, -1
// CHECK: [0x05,0x00,0x7e,0xd3,0xc1,0x00,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x7e,0xd3,0xf0,0x00,0x00,0x00]

v_frexp_exp_i32_f32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x7e,0xd3,0xf7,0x00,0x00,0x00]

v_frexp_mant_f32 v5, v1
// CHECK: [0x01,0x81,0x0a,0x7e]

v_frexp_mant_f32 v255, v1
// CHECK: [0x01,0x81,0xfe,0x7f]

v_frexp_mant_f32 v5, v255
// CHECK: [0xff,0x81,0x0a,0x7e]

v_frexp_mant_f32 v5, s1
// CHECK: [0x01,0x80,0x0a,0x7e]

v_frexp_mant_f32 v5, s103
// CHECK: [0x67,0x80,0x0a,0x7e]

v_frexp_mant_f32 v5, flat_scratch_lo
// CHECK: [0x68,0x80,0x0a,0x7e]

v_frexp_mant_f32 v5, flat_scratch_hi
// CHECK: [0x69,0x80,0x0a,0x7e]

v_frexp_mant_f32 v5, vcc_lo
// CHECK: [0x6a,0x80,0x0a,0x7e]

v_frexp_mant_f32 v5, vcc_hi
// CHECK: [0x6b,0x80,0x0a,0x7e]

v_frexp_mant_f32 v5, tba_lo
// CHECK: [0x6c,0x80,0x0a,0x7e]

v_frexp_mant_f32 v5, tba_hi
// CHECK: [0x6d,0x80,0x0a,0x7e]

v_frexp_mant_f32 v5, tma_lo
// CHECK: [0x6e,0x80,0x0a,0x7e]

v_frexp_mant_f32 v5, tma_hi
// CHECK: [0x6f,0x80,0x0a,0x7e]

v_frexp_mant_f32 v5, ttmp11
// CHECK: [0x7b,0x80,0x0a,0x7e]

v_frexp_mant_f32 v5, m0
// CHECK: [0x7c,0x80,0x0a,0x7e]

v_frexp_mant_f32 v5, exec_lo
// CHECK: [0x7e,0x80,0x0a,0x7e]

v_frexp_mant_f32 v5, exec_hi
// CHECK: [0x7f,0x80,0x0a,0x7e]

v_frexp_mant_f32 v5, 0
// CHECK: [0x80,0x80,0x0a,0x7e]

v_frexp_mant_f32 v5, -1
// CHECK: [0xc1,0x80,0x0a,0x7e]

v_frexp_mant_f32 v5, 0.5
// CHECK: [0xf0,0x80,0x0a,0x7e]

v_frexp_mant_f32 v5, -4.0
// CHECK: [0xf7,0x80,0x0a,0x7e]

v_frexp_mant_f32 v5, 0xaf123456
// CHECK: [0xff,0x80,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_frexp_mant_f32 v5, 0x3f717273
// CHECK: [0xff,0x80,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_frexp_mant_f32_e64 v5, v1
// CHECK: [0x05,0x00,0x80,0xd3,0x01,0x01,0x00,0x00]

v_frexp_mant_f32_e64 v255, v1
// CHECK: [0xff,0x00,0x80,0xd3,0x01,0x01,0x00,0x00]

v_frexp_mant_f32_e64 v5, v255
// CHECK: [0x05,0x00,0x80,0xd3,0xff,0x01,0x00,0x00]

v_frexp_mant_f32_e64 v5, s1
// CHECK: [0x05,0x00,0x80,0xd3,0x01,0x00,0x00,0x00]

v_frexp_mant_f32_e64 v5, s103
// CHECK: [0x05,0x00,0x80,0xd3,0x67,0x00,0x00,0x00]

v_frexp_mant_f32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x80,0xd3,0x68,0x00,0x00,0x00]

v_frexp_mant_f32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x80,0xd3,0x69,0x00,0x00,0x00]

v_frexp_mant_f32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x80,0xd3,0x6a,0x00,0x00,0x00]

v_frexp_mant_f32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x80,0xd3,0x6b,0x00,0x00,0x00]

v_frexp_mant_f32_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x80,0xd3,0x6c,0x00,0x00,0x00]

v_frexp_mant_f32_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x80,0xd3,0x6d,0x00,0x00,0x00]

v_frexp_mant_f32_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x80,0xd3,0x6e,0x00,0x00,0x00]

v_frexp_mant_f32_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x80,0xd3,0x6f,0x00,0x00,0x00]

v_frexp_mant_f32_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x80,0xd3,0x7b,0x00,0x00,0x00]

v_frexp_mant_f32_e64 v5, m0
// CHECK: [0x05,0x00,0x80,0xd3,0x7c,0x00,0x00,0x00]

v_frexp_mant_f32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x80,0xd3,0x7e,0x00,0x00,0x00]

v_frexp_mant_f32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x80,0xd3,0x7f,0x00,0x00,0x00]

v_frexp_mant_f32_e64 v5, 0
// CHECK: [0x05,0x00,0x80,0xd3,0x80,0x00,0x00,0x00]

v_frexp_mant_f32_e64 v5, -1
// CHECK: [0x05,0x00,0x80,0xd3,0xc1,0x00,0x00,0x00]

v_frexp_mant_f32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x80,0xd3,0xf0,0x00,0x00,0x00]

v_frexp_mant_f32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x80,0xd3,0xf7,0x00,0x00,0x00]

v_clrexcp
// CHECK: [0x00,0x82,0x00,0x7e]

v_clrexcp_e64
// CHECK: [0x00,0x00,0x82,0xd3,0x00,0x00,0x00,0x00]

v_movreld_b32 v5, v1
// CHECK: [0x01,0x85,0x0a,0x7e]

v_movreld_b32 v255, v1
// CHECK: [0x01,0x85,0xfe,0x7f]

v_movreld_b32 v5, v255
// CHECK: [0xff,0x85,0x0a,0x7e]

v_movreld_b32 v5, m0
// CHECK: [0x7c,0x84,0x0a,0x7e]

v_movreld_b32 v5, 0
// CHECK: [0x80,0x84,0x0a,0x7e]

v_movreld_b32 v5, -1
// CHECK: [0xc1,0x84,0x0a,0x7e]

v_movreld_b32 v5, 0.5
// CHECK: [0xf0,0x84,0x0a,0x7e]

v_movreld_b32 v5, -4.0
// CHECK: [0xf7,0x84,0x0a,0x7e]

v_movreld_b32_e64 v5, v1
// CHECK: [0x05,0x00,0x84,0xd3,0x01,0x01,0x00,0x00]

v_movreld_b32_e64 v255, v1
// CHECK: [0xff,0x00,0x84,0xd3,0x01,0x01,0x00,0x00]

v_movreld_b32_e64 v5, v255
// CHECK: [0x05,0x00,0x84,0xd3,0xff,0x01,0x00,0x00]

v_movreld_b32_e64 v5, m0
// CHECK: [0x05,0x00,0x84,0xd3,0x7c,0x00,0x00,0x00]

v_movreld_b32_e64 v5, 0
// CHECK: [0x05,0x00,0x84,0xd3,0x80,0x00,0x00,0x00]

v_movreld_b32_e64 v5, -1
// CHECK: [0x05,0x00,0x84,0xd3,0xc1,0x00,0x00,0x00]

v_movreld_b32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x84,0xd3,0xf0,0x00,0x00,0x00]

v_movreld_b32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x84,0xd3,0xf7,0x00,0x00,0x00]

v_movrels_b32 v5, v1
// CHECK: [0x01,0x87,0x0a,0x7e]

v_movrels_b32 v255, v1
// CHECK: [0x01,0x87,0xfe,0x7f]

v_movrels_b32 v5, v255
// CHECK: [0xff,0x87,0x0a,0x7e]

v_movrels_b32_e64 v5, v1
// CHECK: [0x05,0x00,0x86,0xd3,0x01,0x01,0x00,0x00]

v_movrels_b32_e64 v255, v1
// CHECK: [0xff,0x00,0x86,0xd3,0x01,0x01,0x00,0x00]

v_movrels_b32_e64 v5, v255
// CHECK: [0x05,0x00,0x86,0xd3,0xff,0x01,0x00,0x00]

v_movrelsd_b32 v5, v1
// CHECK: [0x01,0x89,0x0a,0x7e]

v_movrelsd_b32 v255, v1
// CHECK: [0x01,0x89,0xfe,0x7f]

v_movrelsd_b32 v5, v255
// CHECK: [0xff,0x89,0x0a,0x7e]

v_movrelsd_b32_e64 v5, v1
// CHECK: [0x05,0x00,0x88,0xd3,0x01,0x01,0x00,0x00]

v_movrelsd_b32_e64 v255, v1
// CHECK: [0xff,0x00,0x88,0xd3,0x01,0x01,0x00,0x00]

v_movrelsd_b32_e64 v5, v255
// CHECK: [0x05,0x00,0x88,0xd3,0xff,0x01,0x00,0x00]

v_log_legacy_f32 v5, v1
// CHECK: [0x01,0x8b,0x0a,0x7e]

v_log_legacy_f32 v255, v1
// CHECK: [0x01,0x8b,0xfe,0x7f]

v_log_legacy_f32 v5, v255
// CHECK: [0xff,0x8b,0x0a,0x7e]

v_log_legacy_f32 v5, s1
// CHECK: [0x01,0x8a,0x0a,0x7e]

v_log_legacy_f32 v5, s103
// CHECK: [0x67,0x8a,0x0a,0x7e]

v_log_legacy_f32 v5, flat_scratch_lo
// CHECK: [0x68,0x8a,0x0a,0x7e]

v_log_legacy_f32 v5, flat_scratch_hi
// CHECK: [0x69,0x8a,0x0a,0x7e]

v_log_legacy_f32 v5, vcc_lo
// CHECK: [0x6a,0x8a,0x0a,0x7e]

v_log_legacy_f32 v5, vcc_hi
// CHECK: [0x6b,0x8a,0x0a,0x7e]

v_log_legacy_f32 v5, tba_lo
// CHECK: [0x6c,0x8a,0x0a,0x7e]

v_log_legacy_f32 v5, tba_hi
// CHECK: [0x6d,0x8a,0x0a,0x7e]

v_log_legacy_f32 v5, tma_lo
// CHECK: [0x6e,0x8a,0x0a,0x7e]

v_log_legacy_f32 v5, tma_hi
// CHECK: [0x6f,0x8a,0x0a,0x7e]

v_log_legacy_f32 v5, ttmp11
// CHECK: [0x7b,0x8a,0x0a,0x7e]

v_log_legacy_f32 v5, m0
// CHECK: [0x7c,0x8a,0x0a,0x7e]

v_log_legacy_f32 v5, exec_lo
// CHECK: [0x7e,0x8a,0x0a,0x7e]

v_log_legacy_f32 v5, exec_hi
// CHECK: [0x7f,0x8a,0x0a,0x7e]

v_log_legacy_f32 v5, 0
// CHECK: [0x80,0x8a,0x0a,0x7e]

v_log_legacy_f32 v5, -1
// CHECK: [0xc1,0x8a,0x0a,0x7e]

v_log_legacy_f32 v5, 0.5
// CHECK: [0xf0,0x8a,0x0a,0x7e]

v_log_legacy_f32 v5, -4.0
// CHECK: [0xf7,0x8a,0x0a,0x7e]

v_log_legacy_f32 v5, 0xaf123456
// CHECK: [0xff,0x8a,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_log_legacy_f32 v5, 0x3f717273
// CHECK: [0xff,0x8a,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_log_legacy_f32_e64 v5, v1
// CHECK: [0x05,0x00,0x8a,0xd3,0x01,0x01,0x00,0x00]

v_log_legacy_f32_e64 v255, v1
// CHECK: [0xff,0x00,0x8a,0xd3,0x01,0x01,0x00,0x00]

v_log_legacy_f32_e64 v5, v255
// CHECK: [0x05,0x00,0x8a,0xd3,0xff,0x01,0x00,0x00]

v_log_legacy_f32_e64 v5, s1
// CHECK: [0x05,0x00,0x8a,0xd3,0x01,0x00,0x00,0x00]

v_log_legacy_f32_e64 v5, s103
// CHECK: [0x05,0x00,0x8a,0xd3,0x67,0x00,0x00,0x00]

v_log_legacy_f32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x8a,0xd3,0x68,0x00,0x00,0x00]

v_log_legacy_f32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x8a,0xd3,0x69,0x00,0x00,0x00]

v_log_legacy_f32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x8a,0xd3,0x6a,0x00,0x00,0x00]

v_log_legacy_f32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x8a,0xd3,0x6b,0x00,0x00,0x00]

v_log_legacy_f32_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x8a,0xd3,0x6c,0x00,0x00,0x00]

v_log_legacy_f32_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x8a,0xd3,0x6d,0x00,0x00,0x00]

v_log_legacy_f32_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x8a,0xd3,0x6e,0x00,0x00,0x00]

v_log_legacy_f32_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x8a,0xd3,0x6f,0x00,0x00,0x00]

v_log_legacy_f32_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x8a,0xd3,0x7b,0x00,0x00,0x00]

v_log_legacy_f32_e64 v5, m0
// CHECK: [0x05,0x00,0x8a,0xd3,0x7c,0x00,0x00,0x00]

v_log_legacy_f32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x8a,0xd3,0x7e,0x00,0x00,0x00]

v_log_legacy_f32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x8a,0xd3,0x7f,0x00,0x00,0x00]

v_log_legacy_f32_e64 v5, 0
// CHECK: [0x05,0x00,0x8a,0xd3,0x80,0x00,0x00,0x00]

v_log_legacy_f32_e64 v5, -1
// CHECK: [0x05,0x00,0x8a,0xd3,0xc1,0x00,0x00,0x00]

v_log_legacy_f32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x8a,0xd3,0xf0,0x00,0x00,0x00]

v_log_legacy_f32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x8a,0xd3,0xf7,0x00,0x00,0x00]

v_log_legacy_f32_e64 v5, -v1
// CHECK: [0x05,0x00,0x8a,0xd3,0x01,0x01,0x00,0x20]

v_log_legacy_f32_e64 v5, |v1|
// CHECK: [0x05,0x01,0x8a,0xd3,0x01,0x01,0x00,0x00]

v_log_legacy_f32_e64 v5, v1 clamp
// CHECK: [0x05,0x08,0x8a,0xd3,0x01,0x01,0x00,0x00]

v_log_legacy_f32_e64 v5, v1 mul:2
// CHECK: [0x05,0x00,0x8a,0xd3,0x01,0x01,0x00,0x08]

v_log_legacy_f32_e64 v5, v1 mul:4
// CHECK: [0x05,0x00,0x8a,0xd3,0x01,0x01,0x00,0x10]

v_log_legacy_f32_e64 v5, v1 div:2
// CHECK: [0x05,0x00,0x8a,0xd3,0x01,0x01,0x00,0x18]

v_exp_legacy_f32 v5, v1
// CHECK: [0x01,0x8d,0x0a,0x7e]

v_exp_legacy_f32 v255, v1
// CHECK: [0x01,0x8d,0xfe,0x7f]

v_exp_legacy_f32 v5, v255
// CHECK: [0xff,0x8d,0x0a,0x7e]

v_exp_legacy_f32 v5, s1
// CHECK: [0x01,0x8c,0x0a,0x7e]

v_exp_legacy_f32 v5, s103
// CHECK: [0x67,0x8c,0x0a,0x7e]

v_exp_legacy_f32 v5, flat_scratch_lo
// CHECK: [0x68,0x8c,0x0a,0x7e]

v_exp_legacy_f32 v5, flat_scratch_hi
// CHECK: [0x69,0x8c,0x0a,0x7e]

v_exp_legacy_f32 v5, vcc_lo
// CHECK: [0x6a,0x8c,0x0a,0x7e]

v_exp_legacy_f32 v5, vcc_hi
// CHECK: [0x6b,0x8c,0x0a,0x7e]

v_exp_legacy_f32 v5, tba_lo
// CHECK: [0x6c,0x8c,0x0a,0x7e]

v_exp_legacy_f32 v5, tba_hi
// CHECK: [0x6d,0x8c,0x0a,0x7e]

v_exp_legacy_f32 v5, tma_lo
// CHECK: [0x6e,0x8c,0x0a,0x7e]

v_exp_legacy_f32 v5, tma_hi
// CHECK: [0x6f,0x8c,0x0a,0x7e]

v_exp_legacy_f32 v5, ttmp11
// CHECK: [0x7b,0x8c,0x0a,0x7e]

v_exp_legacy_f32 v5, m0
// CHECK: [0x7c,0x8c,0x0a,0x7e]

v_exp_legacy_f32 v5, exec_lo
// CHECK: [0x7e,0x8c,0x0a,0x7e]

v_exp_legacy_f32 v5, exec_hi
// CHECK: [0x7f,0x8c,0x0a,0x7e]

v_exp_legacy_f32 v5, 0
// CHECK: [0x80,0x8c,0x0a,0x7e]

v_exp_legacy_f32 v5, -1
// CHECK: [0xc1,0x8c,0x0a,0x7e]

v_exp_legacy_f32 v5, 0.5
// CHECK: [0xf0,0x8c,0x0a,0x7e]

v_exp_legacy_f32 v5, -4.0
// CHECK: [0xf7,0x8c,0x0a,0x7e]

v_exp_legacy_f32 v5, 0xaf123456
// CHECK: [0xff,0x8c,0x0a,0x7e,0x56,0x34,0x12,0xaf]

v_exp_legacy_f32 v5, 0x3f717273
// CHECK: [0xff,0x8c,0x0a,0x7e,0x73,0x72,0x71,0x3f]

v_exp_legacy_f32_e64 v5, v1
// CHECK: [0x05,0x00,0x8c,0xd3,0x01,0x01,0x00,0x00]

v_exp_legacy_f32_e64 v255, v1
// CHECK: [0xff,0x00,0x8c,0xd3,0x01,0x01,0x00,0x00]

v_exp_legacy_f32_e64 v5, v255
// CHECK: [0x05,0x00,0x8c,0xd3,0xff,0x01,0x00,0x00]

v_exp_legacy_f32_e64 v5, s1
// CHECK: [0x05,0x00,0x8c,0xd3,0x01,0x00,0x00,0x00]

v_exp_legacy_f32_e64 v5, s103
// CHECK: [0x05,0x00,0x8c,0xd3,0x67,0x00,0x00,0x00]

v_exp_legacy_f32_e64 v5, flat_scratch_lo
// CHECK: [0x05,0x00,0x8c,0xd3,0x68,0x00,0x00,0x00]

v_exp_legacy_f32_e64 v5, flat_scratch_hi
// CHECK: [0x05,0x00,0x8c,0xd3,0x69,0x00,0x00,0x00]

v_exp_legacy_f32_e64 v5, vcc_lo
// CHECK: [0x05,0x00,0x8c,0xd3,0x6a,0x00,0x00,0x00]

v_exp_legacy_f32_e64 v5, vcc_hi
// CHECK: [0x05,0x00,0x8c,0xd3,0x6b,0x00,0x00,0x00]

v_exp_legacy_f32_e64 v5, tba_lo
// CHECK: [0x05,0x00,0x8c,0xd3,0x6c,0x00,0x00,0x00]

v_exp_legacy_f32_e64 v5, tba_hi
// CHECK: [0x05,0x00,0x8c,0xd3,0x6d,0x00,0x00,0x00]

v_exp_legacy_f32_e64 v5, tma_lo
// CHECK: [0x05,0x00,0x8c,0xd3,0x6e,0x00,0x00,0x00]

v_exp_legacy_f32_e64 v5, tma_hi
// CHECK: [0x05,0x00,0x8c,0xd3,0x6f,0x00,0x00,0x00]

v_exp_legacy_f32_e64 v5, ttmp11
// CHECK: [0x05,0x00,0x8c,0xd3,0x7b,0x00,0x00,0x00]

v_exp_legacy_f32_e64 v5, m0
// CHECK: [0x05,0x00,0x8c,0xd3,0x7c,0x00,0x00,0x00]

v_exp_legacy_f32_e64 v5, exec_lo
// CHECK: [0x05,0x00,0x8c,0xd3,0x7e,0x00,0x00,0x00]

v_exp_legacy_f32_e64 v5, exec_hi
// CHECK: [0x05,0x00,0x8c,0xd3,0x7f,0x00,0x00,0x00]

v_exp_legacy_f32_e64 v5, 0
// CHECK: [0x05,0x00,0x8c,0xd3,0x80,0x00,0x00,0x00]

v_exp_legacy_f32_e64 v5, -1
// CHECK: [0x05,0x00,0x8c,0xd3,0xc1,0x00,0x00,0x00]

v_exp_legacy_f32_e64 v5, 0.5
// CHECK: [0x05,0x00,0x8c,0xd3,0xf0,0x00,0x00,0x00]

v_exp_legacy_f32_e64 v5, -4.0
// CHECK: [0x05,0x00,0x8c,0xd3,0xf7,0x00,0x00,0x00]

v_exp_legacy_f32_e64 v5, -v1
// CHECK: [0x05,0x00,0x8c,0xd3,0x01,0x01,0x00,0x20]

v_exp_legacy_f32_e64 v5, |v1|
// CHECK: [0x05,0x01,0x8c,0xd3,0x01,0x01,0x00,0x00]

v_exp_legacy_f32_e64 v5, v1 clamp
// CHECK: [0x05,0x08,0x8c,0xd3,0x01,0x01,0x00,0x00]

v_exp_legacy_f32_e64 v5, v1 mul:2
// CHECK: [0x05,0x00,0x8c,0xd3,0x01,0x01,0x00,0x08]

v_exp_legacy_f32_e64 v5, v1 mul:4
// CHECK: [0x05,0x00,0x8c,0xd3,0x01,0x01,0x00,0x10]

v_exp_legacy_f32_e64 v5, v1 div:2
// CHECK: [0x05,0x00,0x8c,0xd3,0x01,0x01,0x00,0x18]

v_cndmask_b32 v5, v1, v2, vcc
// CHECK: [0x01,0x05,0x0a,0x00]

v_cndmask_b32 v255, v1, v2, vcc
// CHECK: [0x01,0x05,0xfe,0x01]

v_cndmask_b32 v5, v255, v2, vcc
// CHECK: [0xff,0x05,0x0a,0x00]

v_cndmask_b32 v5, 0, v2, vcc
// CHECK: [0x80,0x04,0x0a,0x00]

v_cndmask_b32 v5, -1, v2, vcc
// CHECK: [0xc1,0x04,0x0a,0x00]

v_cndmask_b32 v5, 0.5, v2, vcc
// CHECK: [0xf0,0x04,0x0a,0x00]

v_cndmask_b32 v5, -4.0, v2, vcc
// CHECK: [0xf7,0x04,0x0a,0x00]

v_cndmask_b32 v5, v1, v255, vcc
// CHECK: [0x01,0xff,0x0b,0x00]

v_cndmask_b32_e64 v5, v1, v2, s[6:7]
// CHECK: [0x05,0x00,0x00,0xd2,0x01,0x05,0x1a,0x00]

v_cndmask_b32_e64 v255, v1, v2, s[6:7]
// CHECK: [0xff,0x00,0x00,0xd2,0x01,0x05,0x1a,0x00]

v_cndmask_b32_e64 v5, v255, v2, s[6:7]
// CHECK: [0x05,0x00,0x00,0xd2,0xff,0x05,0x1a,0x00]

v_cndmask_b32_e64 v5, 0, v2, s[6:7]
// CHECK: [0x05,0x00,0x00,0xd2,0x80,0x04,0x1a,0x00]

v_cndmask_b32_e64 v5, -1, v2, s[6:7]
// CHECK: [0x05,0x00,0x00,0xd2,0xc1,0x04,0x1a,0x00]

v_cndmask_b32_e64 v5, 0.5, v2, s[6:7]
// CHECK: [0x05,0x00,0x00,0xd2,0xf0,0x04,0x1a,0x00]

v_cndmask_b32_e64 v5, -4.0, v2, s[6:7]
// CHECK: [0x05,0x00,0x00,0xd2,0xf7,0x04,0x1a,0x00]

v_cndmask_b32_e64 v5, v1, v255, s[6:7]
// CHECK: [0x05,0x00,0x00,0xd2,0x01,0xff,0x1b,0x00]

v_cndmask_b32_e64 v5, v1, 0, s[6:7]
// CHECK: [0x05,0x00,0x00,0xd2,0x01,0x01,0x19,0x00]

v_cndmask_b32_e64 v5, v1, -1, s[6:7]
// CHECK: [0x05,0x00,0x00,0xd2,0x01,0x83,0x19,0x00]

v_cndmask_b32_e64 v5, v1, 0.5, s[6:7]
// CHECK: [0x05,0x00,0x00,0xd2,0x01,0xe1,0x19,0x00]

v_cndmask_b32_e64 v5, v1, -4.0, s[6:7]
// CHECK: [0x05,0x00,0x00,0xd2,0x01,0xef,0x19,0x00]

v_cndmask_b32_e64 v5, v1, v2, s[8:9]
// CHECK: [0x05,0x00,0x00,0xd2,0x01,0x05,0x22,0x00]

v_cndmask_b32_e64 v5, v1, v2, s[102:103]
// CHECK: [0x05,0x00,0x00,0xd2,0x01,0x05,0x9a,0x01]

v_cndmask_b32_e64 v5, v1, v2, flat_scratch
// CHECK: [0x05,0x00,0x00,0xd2,0x01,0x05,0xa2,0x01]

v_cndmask_b32_e64 v5, v1, v2, vcc
// CHECK: [0x05,0x00,0x00,0xd2,0x01,0x05,0xaa,0x01]

v_cndmask_b32_e64 v5, v1, v2, tba
// CHECK: [0x05,0x00,0x00,0xd2,0x01,0x05,0xb2,0x01]

v_cndmask_b32_e64 v5, v1, v2, tma
// CHECK: [0x05,0x00,0x00,0xd2,0x01,0x05,0xba,0x01]

v_cndmask_b32_e64 v5, v1, v2, ttmp[10:11]
// CHECK: [0x05,0x00,0x00,0xd2,0x01,0x05,0xea,0x01]

v_readlane_b32 s5, v1, s2
// CHECK: [0x01,0x05,0x0a,0x02]

v_readlane_b32 s103, v1, s2
// CHECK: [0x01,0x05,0xce,0x02]

v_readlane_b32 tba_lo, v1, s2
// CHECK: [0x01,0x05,0xd8,0x02]

v_readlane_b32 tba_hi, v1, s2
// CHECK: [0x01,0x05,0xda,0x02]

v_readlane_b32 tma_lo, v1, s2
// CHECK: [0x01,0x05,0xdc,0x02]

v_readlane_b32 tma_hi, v1, s2
// CHECK: [0x01,0x05,0xde,0x02]

v_readlane_b32 ttmp11, v1, s2
// CHECK: [0x01,0x05,0xf6,0x02]

v_readlane_b32 s5, v255, s2
// CHECK: [0xff,0x05,0x0a,0x02]

v_readlane_b32 s5, v1, s103
// CHECK: [0x01,0xcf,0x0a,0x02]

v_readlane_b32 s5, v1, flat_scratch_lo
// CHECK: [0x01,0xd1,0x0a,0x02]

v_readlane_b32 s5, v1, flat_scratch_hi
// CHECK: [0x01,0xd3,0x0a,0x02]

v_readlane_b32 s5, v1, vcc_lo
// CHECK: [0x01,0xd5,0x0a,0x02]

v_readlane_b32 s5, v1, vcc_hi
// CHECK: [0x01,0xd7,0x0a,0x02]

v_readlane_b32 s5, v1, tba_lo
// CHECK: [0x01,0xd9,0x0a,0x02]

v_readlane_b32 s5, v1, tba_hi
// CHECK: [0x01,0xdb,0x0a,0x02]

v_readlane_b32 s5, v1, tma_lo
// CHECK: [0x01,0xdd,0x0a,0x02]

v_readlane_b32 s5, v1, tma_hi
// CHECK: [0x01,0xdf,0x0a,0x02]

v_readlane_b32 s5, v1, ttmp11
// CHECK: [0x01,0xf7,0x0a,0x02]

v_readlane_b32 s5, v1, m0
// CHECK: [0x01,0xf9,0x0a,0x02]

v_readlane_b32 s5, v1, 0
// CHECK: [0x01,0x01,0x0b,0x02]

v_writelane_b32 v5, 0, s2
// CHECK: [0x80,0x04,0x0a,0x04]

v_writelane_b32 v255, 0, s2
// CHECK: [0x80,0x04,0xfe,0x05]

v_writelane_b32 v5, -1, s2
// CHECK: [0xc1,0x04,0x0a,0x04]

v_writelane_b32 v5, 0.5, s2
// CHECK: [0xf0,0x04,0x0a,0x04]

v_writelane_b32 v5, -4.0, s2
// CHECK: [0xf7,0x04,0x0a,0x04]

v_writelane_b32 v5, 0, s103
// CHECK: [0x80,0xce,0x0a,0x04]

v_writelane_b32 v5, 0, flat_scratch_lo
// CHECK: [0x80,0xd0,0x0a,0x04]

v_writelane_b32 v5, 0, flat_scratch_hi
// CHECK: [0x80,0xd2,0x0a,0x04]

v_writelane_b32 v5, 0, vcc_lo
// CHECK: [0x80,0xd4,0x0a,0x04]

v_writelane_b32 v5, 0, vcc_hi
// CHECK: [0x80,0xd6,0x0a,0x04]

v_writelane_b32 v5, 0, tba_lo
// CHECK: [0x80,0xd8,0x0a,0x04]

v_writelane_b32 v5, 0, tba_hi
// CHECK: [0x80,0xda,0x0a,0x04]

v_writelane_b32 v5, 0, tma_lo
// CHECK: [0x80,0xdc,0x0a,0x04]

v_writelane_b32 v5, 0, tma_hi
// CHECK: [0x80,0xde,0x0a,0x04]

v_writelane_b32 v5, 0, ttmp11
// CHECK: [0x80,0xf6,0x0a,0x04]

v_writelane_b32 v5, 0, m0
// CHECK: [0x80,0xf8,0x0a,0x04]

v_writelane_b32 v5, 0, 0
// CHECK: [0x80,0x00,0x0b,0x04]

v_add_f32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x06]

v_add_f32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x07]

v_add_f32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x06]

v_add_f32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x06]

v_add_f32 v5, s103, v2
// CHECK: [0x67,0x04,0x0a,0x06]

v_add_f32 v5, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0a,0x06]

v_add_f32 v5, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0a,0x06]

v_add_f32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x06]

v_add_f32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x06]

v_add_f32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x06]

v_add_f32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x06]

v_add_f32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x06]

v_add_f32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x06]

v_add_f32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x06]

v_add_f32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x06]

v_add_f32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x06]

v_add_f32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x06]

v_add_f32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x06]

v_add_f32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x06]

v_add_f32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x06]

v_add_f32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x06]

v_add_f32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x06,0x56,0x34,0x12,0xaf]

v_add_f32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x06,0x73,0x72,0x71,0x3f]

v_add_f32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x06]

v_add_f32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x06,0xd2,0x01,0x05,0x02,0x00]

v_add_f32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x06,0xd2,0x01,0x05,0x02,0x00]

v_add_f32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x06,0xd2,0xff,0x05,0x02,0x00]

v_add_f32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x06,0xd2,0x01,0x04,0x02,0x00]

v_add_f32_e64 v5, s103, v2
// CHECK: [0x05,0x00,0x06,0xd2,0x67,0x04,0x02,0x00]

v_add_f32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x06,0xd2,0x68,0x04,0x02,0x00]

v_add_f32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x06,0xd2,0x69,0x04,0x02,0x00]

v_add_f32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x06,0xd2,0x6a,0x04,0x02,0x00]

v_add_f32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x06,0xd2,0x6b,0x04,0x02,0x00]

v_add_f32_e64 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x06,0xd2,0x6c,0x04,0x02,0x00]

v_add_f32_e64 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x06,0xd2,0x6d,0x04,0x02,0x00]

v_add_f32_e64 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x06,0xd2,0x6e,0x04,0x02,0x00]

v_add_f32_e64 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x06,0xd2,0x6f,0x04,0x02,0x00]

v_add_f32_e64 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x06,0xd2,0x7b,0x04,0x02,0x00]

v_add_f32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x06,0xd2,0x7c,0x04,0x02,0x00]

v_add_f32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x06,0xd2,0x7e,0x04,0x02,0x00]

v_add_f32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x06,0xd2,0x7f,0x04,0x02,0x00]

v_add_f32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x06,0xd2,0x80,0x04,0x02,0x00]

v_add_f32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x06,0xd2,0xc1,0x04,0x02,0x00]

v_add_f32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x06,0xd2,0xf0,0x04,0x02,0x00]

v_add_f32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x06,0xd2,0xf7,0x04,0x02,0x00]

v_add_f32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x06,0xd2,0x01,0xff,0x03,0x00]

v_add_f32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x06,0xd2,0x01,0x05,0x00,0x00]

v_add_f32_e64 v5, v1, s103
// CHECK: [0x05,0x00,0x06,0xd2,0x01,0xcf,0x00,0x00]

v_add_f32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x06,0xd2,0x01,0xd1,0x00,0x00]

v_add_f32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x06,0xd2,0x01,0xd3,0x00,0x00]

v_add_f32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x06,0xd2,0x01,0xd5,0x00,0x00]

v_add_f32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x06,0xd2,0x01,0xd7,0x00,0x00]

v_add_f32_e64 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x06,0xd2,0x01,0xd9,0x00,0x00]

v_add_f32_e64 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x06,0xd2,0x01,0xdb,0x00,0x00]

v_add_f32_e64 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x06,0xd2,0x01,0xdd,0x00,0x00]

v_add_f32_e64 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x06,0xd2,0x01,0xdf,0x00,0x00]

v_add_f32_e64 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x06,0xd2,0x01,0xf7,0x00,0x00]

v_add_f32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x06,0xd2,0x01,0xf9,0x00,0x00]

v_add_f32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x06,0xd2,0x01,0xfd,0x00,0x00]

v_add_f32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x06,0xd2,0x01,0xff,0x00,0x00]

v_add_f32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x06,0xd2,0x01,0x01,0x01,0x00]

v_add_f32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x06,0xd2,0x01,0x83,0x01,0x00]

v_add_f32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x06,0xd2,0x01,0xe1,0x01,0x00]

v_add_f32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x06,0xd2,0x01,0xef,0x01,0x00]

v_add_f32_e64 v5, -v1, v2
// CHECK: [0x05,0x00,0x06,0xd2,0x01,0x05,0x02,0x20]

v_add_f32_e64 v5, v1, -v2
// CHECK: [0x05,0x00,0x06,0xd2,0x01,0x05,0x02,0x40]

v_add_f32_e64 v5, -v1, -v2
// CHECK: [0x05,0x00,0x06,0xd2,0x01,0x05,0x02,0x60]

v_add_f32_e64 v5, |v1|, v2
// CHECK: [0x05,0x01,0x06,0xd2,0x01,0x05,0x02,0x00]

v_add_f32_e64 v5, v1, |v2|
// CHECK: [0x05,0x02,0x06,0xd2,0x01,0x05,0x02,0x00]

v_add_f32_e64 v5, |v1|, |v2|
// CHECK: [0x05,0x03,0x06,0xd2,0x01,0x05,0x02,0x00]

v_add_f32_e64 v5, v1, v2 clamp
// CHECK: [0x05,0x08,0x06,0xd2,0x01,0x05,0x02,0x00]

v_add_f32_e64 v5, v1, v2 mul:2
// CHECK: [0x05,0x00,0x06,0xd2,0x01,0x05,0x02,0x08]

v_add_f32_e64 v5, v1, v2 mul:4
// CHECK: [0x05,0x00,0x06,0xd2,0x01,0x05,0x02,0x10]

v_add_f32_e64 v5, v1, v2 div:2
// CHECK: [0x05,0x00,0x06,0xd2,0x01,0x05,0x02,0x18]

v_sub_f32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x08]

v_sub_f32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x09]

v_sub_f32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x08]

v_sub_f32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x08]

v_sub_f32 v5, s103, v2
// CHECK: [0x67,0x04,0x0a,0x08]

v_sub_f32 v5, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0a,0x08]

v_sub_f32 v5, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0a,0x08]

v_sub_f32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x08]

v_sub_f32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x08]

v_sub_f32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x08]

v_sub_f32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x08]

v_sub_f32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x08]

v_sub_f32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x08]

v_sub_f32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x08]

v_sub_f32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x08]

v_sub_f32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x08]

v_sub_f32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x08]

v_sub_f32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x08]

v_sub_f32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x08]

v_sub_f32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x08]

v_sub_f32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x08]

v_sub_f32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x08,0x56,0x34,0x12,0xaf]

v_sub_f32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x08,0x73,0x72,0x71,0x3f]

v_sub_f32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x08]

v_sub_f32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x08,0xd2,0x01,0x05,0x02,0x00]

v_sub_f32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x08,0xd2,0x01,0x05,0x02,0x00]

v_sub_f32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x08,0xd2,0xff,0x05,0x02,0x00]

v_sub_f32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x08,0xd2,0x01,0x04,0x02,0x00]

v_sub_f32_e64 v5, s103, v2
// CHECK: [0x05,0x00,0x08,0xd2,0x67,0x04,0x02,0x00]

v_sub_f32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x08,0xd2,0x68,0x04,0x02,0x00]

v_sub_f32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x08,0xd2,0x69,0x04,0x02,0x00]

v_sub_f32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x08,0xd2,0x6a,0x04,0x02,0x00]

v_sub_f32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x08,0xd2,0x6b,0x04,0x02,0x00]

v_sub_f32_e64 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x08,0xd2,0x6c,0x04,0x02,0x00]

v_sub_f32_e64 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x08,0xd2,0x6d,0x04,0x02,0x00]

v_sub_f32_e64 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x08,0xd2,0x6e,0x04,0x02,0x00]

v_sub_f32_e64 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x08,0xd2,0x6f,0x04,0x02,0x00]

v_sub_f32_e64 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x08,0xd2,0x7b,0x04,0x02,0x00]

v_sub_f32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x08,0xd2,0x7c,0x04,0x02,0x00]

v_sub_f32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x08,0xd2,0x7e,0x04,0x02,0x00]

v_sub_f32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x08,0xd2,0x7f,0x04,0x02,0x00]

v_sub_f32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x08,0xd2,0x80,0x04,0x02,0x00]

v_sub_f32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x08,0xd2,0xc1,0x04,0x02,0x00]

v_sub_f32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x08,0xd2,0xf0,0x04,0x02,0x00]

v_sub_f32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x08,0xd2,0xf7,0x04,0x02,0x00]

v_sub_f32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x08,0xd2,0x01,0xff,0x03,0x00]

v_sub_f32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x08,0xd2,0x01,0x05,0x00,0x00]

v_sub_f32_e64 v5, v1, s103
// CHECK: [0x05,0x00,0x08,0xd2,0x01,0xcf,0x00,0x00]

v_sub_f32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x08,0xd2,0x01,0xd1,0x00,0x00]

v_sub_f32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x08,0xd2,0x01,0xd3,0x00,0x00]

v_sub_f32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x08,0xd2,0x01,0xd5,0x00,0x00]

v_sub_f32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x08,0xd2,0x01,0xd7,0x00,0x00]

v_sub_f32_e64 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x08,0xd2,0x01,0xd9,0x00,0x00]

v_sub_f32_e64 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x08,0xd2,0x01,0xdb,0x00,0x00]

v_sub_f32_e64 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x08,0xd2,0x01,0xdd,0x00,0x00]

v_sub_f32_e64 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x08,0xd2,0x01,0xdf,0x00,0x00]

v_sub_f32_e64 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x08,0xd2,0x01,0xf7,0x00,0x00]

v_sub_f32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x08,0xd2,0x01,0xf9,0x00,0x00]

v_sub_f32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x08,0xd2,0x01,0xfd,0x00,0x00]

v_sub_f32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x08,0xd2,0x01,0xff,0x00,0x00]

v_sub_f32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x08,0xd2,0x01,0x01,0x01,0x00]

v_sub_f32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x08,0xd2,0x01,0x83,0x01,0x00]

v_sub_f32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x08,0xd2,0x01,0xe1,0x01,0x00]

v_sub_f32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x08,0xd2,0x01,0xef,0x01,0x00]

v_sub_f32_e64 v5, -v1, v2
// CHECK: [0x05,0x00,0x08,0xd2,0x01,0x05,0x02,0x20]

v_sub_f32_e64 v5, v1, -v2
// CHECK: [0x05,0x00,0x08,0xd2,0x01,0x05,0x02,0x40]

v_sub_f32_e64 v5, -v1, -v2
// CHECK: [0x05,0x00,0x08,0xd2,0x01,0x05,0x02,0x60]

v_sub_f32_e64 v5, |v1|, v2
// CHECK: [0x05,0x01,0x08,0xd2,0x01,0x05,0x02,0x00]

v_sub_f32_e64 v5, v1, |v2|
// CHECK: [0x05,0x02,0x08,0xd2,0x01,0x05,0x02,0x00]

v_sub_f32_e64 v5, |v1|, |v2|
// CHECK: [0x05,0x03,0x08,0xd2,0x01,0x05,0x02,0x00]

v_sub_f32_e64 v5, v1, v2 clamp
// CHECK: [0x05,0x08,0x08,0xd2,0x01,0x05,0x02,0x00]

v_sub_f32_e64 v5, v1, v2 mul:2
// CHECK: [0x05,0x00,0x08,0xd2,0x01,0x05,0x02,0x08]

v_sub_f32_e64 v5, v1, v2 mul:4
// CHECK: [0x05,0x00,0x08,0xd2,0x01,0x05,0x02,0x10]

v_sub_f32_e64 v5, v1, v2 div:2
// CHECK: [0x05,0x00,0x08,0xd2,0x01,0x05,0x02,0x18]

v_subrev_f32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x0a]

v_subrev_f32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x0b]

v_subrev_f32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x0a]

v_subrev_f32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x0a]

v_subrev_f32 v5, s103, v2
// CHECK: [0x67,0x04,0x0a,0x0a]

v_subrev_f32 v5, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0a,0x0a]

v_subrev_f32 v5, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0a,0x0a]

v_subrev_f32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x0a]

v_subrev_f32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x0a]

v_subrev_f32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x0a]

v_subrev_f32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x0a]

v_subrev_f32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x0a]

v_subrev_f32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x0a]

v_subrev_f32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x0a]

v_subrev_f32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x0a]

v_subrev_f32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x0a]

v_subrev_f32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x0a]

v_subrev_f32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x0a]

v_subrev_f32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x0a]

v_subrev_f32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x0a]

v_subrev_f32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x0a]

v_subrev_f32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x0a,0x56,0x34,0x12,0xaf]

v_subrev_f32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x0a,0x73,0x72,0x71,0x3f]

v_subrev_f32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x0a]

v_subrev_f32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x0a,0xd2,0x01,0x05,0x02,0x00]

v_subrev_f32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x0a,0xd2,0x01,0x05,0x02,0x00]

v_subrev_f32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x0a,0xd2,0xff,0x05,0x02,0x00]

v_subrev_f32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x0a,0xd2,0x01,0x04,0x02,0x00]

v_subrev_f32_e64 v5, s103, v2
// CHECK: [0x05,0x00,0x0a,0xd2,0x67,0x04,0x02,0x00]

v_subrev_f32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x0a,0xd2,0x68,0x04,0x02,0x00]

v_subrev_f32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x0a,0xd2,0x69,0x04,0x02,0x00]

v_subrev_f32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x0a,0xd2,0x6a,0x04,0x02,0x00]

v_subrev_f32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x0a,0xd2,0x6b,0x04,0x02,0x00]

v_subrev_f32_e64 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x0a,0xd2,0x6c,0x04,0x02,0x00]

v_subrev_f32_e64 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x0a,0xd2,0x6d,0x04,0x02,0x00]

v_subrev_f32_e64 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x0a,0xd2,0x6e,0x04,0x02,0x00]

v_subrev_f32_e64 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x0a,0xd2,0x6f,0x04,0x02,0x00]

v_subrev_f32_e64 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x0a,0xd2,0x7b,0x04,0x02,0x00]

v_subrev_f32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x0a,0xd2,0x7c,0x04,0x02,0x00]

v_subrev_f32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x0a,0xd2,0x7e,0x04,0x02,0x00]

v_subrev_f32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x0a,0xd2,0x7f,0x04,0x02,0x00]

v_subrev_f32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x0a,0xd2,0x80,0x04,0x02,0x00]

v_subrev_f32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x0a,0xd2,0xc1,0x04,0x02,0x00]

v_subrev_f32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x0a,0xd2,0xf0,0x04,0x02,0x00]

v_subrev_f32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x0a,0xd2,0xf7,0x04,0x02,0x00]

v_subrev_f32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x0a,0xd2,0x01,0xff,0x03,0x00]

v_subrev_f32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x0a,0xd2,0x01,0x05,0x00,0x00]

v_subrev_f32_e64 v5, v1, s103
// CHECK: [0x05,0x00,0x0a,0xd2,0x01,0xcf,0x00,0x00]

v_subrev_f32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x0a,0xd2,0x01,0xd1,0x00,0x00]

v_subrev_f32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x0a,0xd2,0x01,0xd3,0x00,0x00]

v_subrev_f32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x0a,0xd2,0x01,0xd5,0x00,0x00]

v_subrev_f32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x0a,0xd2,0x01,0xd7,0x00,0x00]

v_subrev_f32_e64 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x0a,0xd2,0x01,0xd9,0x00,0x00]

v_subrev_f32_e64 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x0a,0xd2,0x01,0xdb,0x00,0x00]

v_subrev_f32_e64 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x0a,0xd2,0x01,0xdd,0x00,0x00]

v_subrev_f32_e64 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x0a,0xd2,0x01,0xdf,0x00,0x00]

v_subrev_f32_e64 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x0a,0xd2,0x01,0xf7,0x00,0x00]

v_subrev_f32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x0a,0xd2,0x01,0xf9,0x00,0x00]

v_subrev_f32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x0a,0xd2,0x01,0xfd,0x00,0x00]

v_subrev_f32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x0a,0xd2,0x01,0xff,0x00,0x00]

v_subrev_f32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x0a,0xd2,0x01,0x01,0x01,0x00]

v_subrev_f32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x0a,0xd2,0x01,0x83,0x01,0x00]

v_subrev_f32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x0a,0xd2,0x01,0xe1,0x01,0x00]

v_subrev_f32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x0a,0xd2,0x01,0xef,0x01,0x00]

v_subrev_f32_e64 v5, -v1, v2
// CHECK: [0x05,0x00,0x0a,0xd2,0x01,0x05,0x02,0x20]

v_subrev_f32_e64 v5, v1, -v2
// CHECK: [0x05,0x00,0x0a,0xd2,0x01,0x05,0x02,0x40]

v_subrev_f32_e64 v5, -v1, -v2
// CHECK: [0x05,0x00,0x0a,0xd2,0x01,0x05,0x02,0x60]

v_subrev_f32_e64 v5, |v1|, v2
// CHECK: [0x05,0x01,0x0a,0xd2,0x01,0x05,0x02,0x00]

v_subrev_f32_e64 v5, v1, |v2|
// CHECK: [0x05,0x02,0x0a,0xd2,0x01,0x05,0x02,0x00]

v_subrev_f32_e64 v5, |v1|, |v2|
// CHECK: [0x05,0x03,0x0a,0xd2,0x01,0x05,0x02,0x00]

v_subrev_f32_e64 v5, v1, v2 clamp
// CHECK: [0x05,0x08,0x0a,0xd2,0x01,0x05,0x02,0x00]

v_subrev_f32_e64 v5, v1, v2 mul:2
// CHECK: [0x05,0x00,0x0a,0xd2,0x01,0x05,0x02,0x08]

v_subrev_f32_e64 v5, v1, v2 mul:4
// CHECK: [0x05,0x00,0x0a,0xd2,0x01,0x05,0x02,0x10]

v_subrev_f32_e64 v5, v1, v2 div:2
// CHECK: [0x05,0x00,0x0a,0xd2,0x01,0x05,0x02,0x18]

v_mac_legacy_f32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x0c]

v_mac_legacy_f32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x0d]

v_mac_legacy_f32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x0c]

v_mac_legacy_f32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x0c]

v_mac_legacy_f32 v5, s103, v2
// CHECK: [0x67,0x04,0x0a,0x0c]

v_mac_legacy_f32 v5, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0a,0x0c]

v_mac_legacy_f32 v5, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0a,0x0c]

v_mac_legacy_f32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x0c]

v_mac_legacy_f32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x0c]

v_mac_legacy_f32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x0c]

v_mac_legacy_f32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x0c]

v_mac_legacy_f32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x0c]

v_mac_legacy_f32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x0c]

v_mac_legacy_f32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x0c]

v_mac_legacy_f32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x0c]

v_mac_legacy_f32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x0c]

v_mac_legacy_f32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x0c]

v_mac_legacy_f32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x0c]

v_mac_legacy_f32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x0c]

v_mac_legacy_f32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x0c]

v_mac_legacy_f32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x0c]

v_mac_legacy_f32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x0c,0x56,0x34,0x12,0xaf]

v_mac_legacy_f32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x0c,0x73,0x72,0x71,0x3f]

v_mac_legacy_f32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x0c]

v_mac_legacy_f32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x0c,0xd2,0x01,0x05,0x02,0x00]

v_mac_legacy_f32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x0c,0xd2,0x01,0x05,0x02,0x00]

v_mac_legacy_f32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x0c,0xd2,0xff,0x05,0x02,0x00]

v_mac_legacy_f32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x0c,0xd2,0x01,0x04,0x02,0x00]

v_mac_legacy_f32_e64 v5, s103, v2
// CHECK: [0x05,0x00,0x0c,0xd2,0x67,0x04,0x02,0x00]

v_mac_legacy_f32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x0c,0xd2,0x68,0x04,0x02,0x00]

v_mac_legacy_f32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x0c,0xd2,0x69,0x04,0x02,0x00]

v_mac_legacy_f32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x0c,0xd2,0x6a,0x04,0x02,0x00]

v_mac_legacy_f32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x0c,0xd2,0x6b,0x04,0x02,0x00]

v_mac_legacy_f32_e64 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x0c,0xd2,0x6c,0x04,0x02,0x00]

v_mac_legacy_f32_e64 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x0c,0xd2,0x6d,0x04,0x02,0x00]

v_mac_legacy_f32_e64 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x0c,0xd2,0x6e,0x04,0x02,0x00]

v_mac_legacy_f32_e64 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x0c,0xd2,0x6f,0x04,0x02,0x00]

v_mac_legacy_f32_e64 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x0c,0xd2,0x7b,0x04,0x02,0x00]

v_mac_legacy_f32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x0c,0xd2,0x7c,0x04,0x02,0x00]

v_mac_legacy_f32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x0c,0xd2,0x7e,0x04,0x02,0x00]

v_mac_legacy_f32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x0c,0xd2,0x7f,0x04,0x02,0x00]

v_mac_legacy_f32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x0c,0xd2,0x80,0x04,0x02,0x00]

v_mac_legacy_f32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x0c,0xd2,0xc1,0x04,0x02,0x00]

v_mac_legacy_f32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x0c,0xd2,0xf0,0x04,0x02,0x00]

v_mac_legacy_f32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x0c,0xd2,0xf7,0x04,0x02,0x00]

v_mac_legacy_f32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x0c,0xd2,0x01,0xff,0x03,0x00]

v_mac_legacy_f32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x0c,0xd2,0x01,0x05,0x00,0x00]

v_mac_legacy_f32_e64 v5, v1, s103
// CHECK: [0x05,0x00,0x0c,0xd2,0x01,0xcf,0x00,0x00]

v_mac_legacy_f32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x0c,0xd2,0x01,0xd1,0x00,0x00]

v_mac_legacy_f32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x0c,0xd2,0x01,0xd3,0x00,0x00]

v_mac_legacy_f32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x0c,0xd2,0x01,0xd5,0x00,0x00]

v_mac_legacy_f32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x0c,0xd2,0x01,0xd7,0x00,0x00]

v_mac_legacy_f32_e64 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x0c,0xd2,0x01,0xd9,0x00,0x00]

v_mac_legacy_f32_e64 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x0c,0xd2,0x01,0xdb,0x00,0x00]

v_mac_legacy_f32_e64 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x0c,0xd2,0x01,0xdd,0x00,0x00]

v_mac_legacy_f32_e64 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x0c,0xd2,0x01,0xdf,0x00,0x00]

v_mac_legacy_f32_e64 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x0c,0xd2,0x01,0xf7,0x00,0x00]

v_mac_legacy_f32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x0c,0xd2,0x01,0xf9,0x00,0x00]

v_mac_legacy_f32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x0c,0xd2,0x01,0xfd,0x00,0x00]

v_mac_legacy_f32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x0c,0xd2,0x01,0xff,0x00,0x00]

v_mac_legacy_f32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x0c,0xd2,0x01,0x01,0x01,0x00]

v_mac_legacy_f32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x0c,0xd2,0x01,0x83,0x01,0x00]

v_mac_legacy_f32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x0c,0xd2,0x01,0xe1,0x01,0x00]

v_mac_legacy_f32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x0c,0xd2,0x01,0xef,0x01,0x00]

v_mac_legacy_f32_e64 v5, -v1, v2
// CHECK: [0x05,0x00,0x0c,0xd2,0x01,0x05,0x02,0x20]

v_mac_legacy_f32_e64 v5, v1, -v2
// CHECK: [0x05,0x00,0x0c,0xd2,0x01,0x05,0x02,0x40]

v_mac_legacy_f32_e64 v5, -v1, -v2
// CHECK: [0x05,0x00,0x0c,0xd2,0x01,0x05,0x02,0x60]

v_mac_legacy_f32_e64 v5, |v1|, v2
// CHECK: [0x05,0x01,0x0c,0xd2,0x01,0x05,0x02,0x00]

v_mac_legacy_f32_e64 v5, v1, |v2|
// CHECK: [0x05,0x02,0x0c,0xd2,0x01,0x05,0x02,0x00]

v_mac_legacy_f32_e64 v5, |v1|, |v2|
// CHECK: [0x05,0x03,0x0c,0xd2,0x01,0x05,0x02,0x00]

v_mac_legacy_f32_e64 v5, v1, v2 clamp
// CHECK: [0x05,0x08,0x0c,0xd2,0x01,0x05,0x02,0x00]

v_mac_legacy_f32_e64 v5, v1, v2 mul:2
// CHECK: [0x05,0x00,0x0c,0xd2,0x01,0x05,0x02,0x08]

v_mac_legacy_f32_e64 v5, v1, v2 mul:4
// CHECK: [0x05,0x00,0x0c,0xd2,0x01,0x05,0x02,0x10]

v_mac_legacy_f32_e64 v5, v1, v2 div:2
// CHECK: [0x05,0x00,0x0c,0xd2,0x01,0x05,0x02,0x18]

v_mul_legacy_f32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x0e]

v_mul_legacy_f32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x0f]

v_mul_legacy_f32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x0e]

v_mul_legacy_f32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x0e]

v_mul_legacy_f32 v5, s103, v2
// CHECK: [0x67,0x04,0x0a,0x0e]

v_mul_legacy_f32 v5, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0a,0x0e]

v_mul_legacy_f32 v5, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0a,0x0e]

v_mul_legacy_f32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x0e]

v_mul_legacy_f32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x0e]

v_mul_legacy_f32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x0e]

v_mul_legacy_f32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x0e]

v_mul_legacy_f32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x0e]

v_mul_legacy_f32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x0e]

v_mul_legacy_f32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x0e]

v_mul_legacy_f32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x0e]

v_mul_legacy_f32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x0e]

v_mul_legacy_f32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x0e]

v_mul_legacy_f32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x0e]

v_mul_legacy_f32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x0e]

v_mul_legacy_f32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x0e]

v_mul_legacy_f32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x0e]

v_mul_legacy_f32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x0e,0x56,0x34,0x12,0xaf]

v_mul_legacy_f32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x0e,0x73,0x72,0x71,0x3f]

v_mul_legacy_f32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x0e]

v_mul_legacy_f32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x0e,0xd2,0x01,0x05,0x02,0x00]

v_mul_legacy_f32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x0e,0xd2,0x01,0x05,0x02,0x00]

v_mul_legacy_f32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x0e,0xd2,0xff,0x05,0x02,0x00]

v_mul_legacy_f32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x0e,0xd2,0x01,0x04,0x02,0x00]

v_mul_legacy_f32_e64 v5, s103, v2
// CHECK: [0x05,0x00,0x0e,0xd2,0x67,0x04,0x02,0x00]

v_mul_legacy_f32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x0e,0xd2,0x68,0x04,0x02,0x00]

v_mul_legacy_f32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x0e,0xd2,0x69,0x04,0x02,0x00]

v_mul_legacy_f32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x0e,0xd2,0x6a,0x04,0x02,0x00]

v_mul_legacy_f32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x0e,0xd2,0x6b,0x04,0x02,0x00]

v_mul_legacy_f32_e64 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x0e,0xd2,0x6c,0x04,0x02,0x00]

v_mul_legacy_f32_e64 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x0e,0xd2,0x6d,0x04,0x02,0x00]

v_mul_legacy_f32_e64 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x0e,0xd2,0x6e,0x04,0x02,0x00]

v_mul_legacy_f32_e64 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x0e,0xd2,0x6f,0x04,0x02,0x00]

v_mul_legacy_f32_e64 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x0e,0xd2,0x7b,0x04,0x02,0x00]

v_mul_legacy_f32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x0e,0xd2,0x7c,0x04,0x02,0x00]

v_mul_legacy_f32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x0e,0xd2,0x7e,0x04,0x02,0x00]

v_mul_legacy_f32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x0e,0xd2,0x7f,0x04,0x02,0x00]

v_mul_legacy_f32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x0e,0xd2,0x80,0x04,0x02,0x00]

v_mul_legacy_f32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x0e,0xd2,0xc1,0x04,0x02,0x00]

v_mul_legacy_f32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x0e,0xd2,0xf0,0x04,0x02,0x00]

v_mul_legacy_f32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x0e,0xd2,0xf7,0x04,0x02,0x00]

v_mul_legacy_f32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x0e,0xd2,0x01,0xff,0x03,0x00]

v_mul_legacy_f32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x0e,0xd2,0x01,0x05,0x00,0x00]

v_mul_legacy_f32_e64 v5, v1, s103
// CHECK: [0x05,0x00,0x0e,0xd2,0x01,0xcf,0x00,0x00]

v_mul_legacy_f32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x0e,0xd2,0x01,0xd1,0x00,0x00]

v_mul_legacy_f32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x0e,0xd2,0x01,0xd3,0x00,0x00]

v_mul_legacy_f32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x0e,0xd2,0x01,0xd5,0x00,0x00]

v_mul_legacy_f32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x0e,0xd2,0x01,0xd7,0x00,0x00]

v_mul_legacy_f32_e64 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x0e,0xd2,0x01,0xd9,0x00,0x00]

v_mul_legacy_f32_e64 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x0e,0xd2,0x01,0xdb,0x00,0x00]

v_mul_legacy_f32_e64 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x0e,0xd2,0x01,0xdd,0x00,0x00]

v_mul_legacy_f32_e64 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x0e,0xd2,0x01,0xdf,0x00,0x00]

v_mul_legacy_f32_e64 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x0e,0xd2,0x01,0xf7,0x00,0x00]

v_mul_legacy_f32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x0e,0xd2,0x01,0xf9,0x00,0x00]

v_mul_legacy_f32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x0e,0xd2,0x01,0xfd,0x00,0x00]

v_mul_legacy_f32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x0e,0xd2,0x01,0xff,0x00,0x00]

v_mul_legacy_f32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x0e,0xd2,0x01,0x01,0x01,0x00]

v_mul_legacy_f32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x0e,0xd2,0x01,0x83,0x01,0x00]

v_mul_legacy_f32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x0e,0xd2,0x01,0xe1,0x01,0x00]

v_mul_legacy_f32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x0e,0xd2,0x01,0xef,0x01,0x00]

v_mul_legacy_f32_e64 v5, -v1, v2
// CHECK: [0x05,0x00,0x0e,0xd2,0x01,0x05,0x02,0x20]

v_mul_legacy_f32_e64 v5, v1, -v2
// CHECK: [0x05,0x00,0x0e,0xd2,0x01,0x05,0x02,0x40]

v_mul_legacy_f32_e64 v5, -v1, -v2
// CHECK: [0x05,0x00,0x0e,0xd2,0x01,0x05,0x02,0x60]

v_mul_legacy_f32_e64 v5, |v1|, v2
// CHECK: [0x05,0x01,0x0e,0xd2,0x01,0x05,0x02,0x00]

v_mul_legacy_f32_e64 v5, v1, |v2|
// CHECK: [0x05,0x02,0x0e,0xd2,0x01,0x05,0x02,0x00]

v_mul_legacy_f32_e64 v5, |v1|, |v2|
// CHECK: [0x05,0x03,0x0e,0xd2,0x01,0x05,0x02,0x00]

v_mul_legacy_f32_e64 v5, v1, v2 clamp
// CHECK: [0x05,0x08,0x0e,0xd2,0x01,0x05,0x02,0x00]

v_mul_legacy_f32_e64 v5, v1, v2 mul:2
// CHECK: [0x05,0x00,0x0e,0xd2,0x01,0x05,0x02,0x08]

v_mul_legacy_f32_e64 v5, v1, v2 mul:4
// CHECK: [0x05,0x00,0x0e,0xd2,0x01,0x05,0x02,0x10]

v_mul_legacy_f32_e64 v5, v1, v2 div:2
// CHECK: [0x05,0x00,0x0e,0xd2,0x01,0x05,0x02,0x18]

v_mul_f32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x10]

v_mul_f32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x11]

v_mul_f32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x10]

v_mul_f32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x10]

v_mul_f32 v5, s103, v2
// CHECK: [0x67,0x04,0x0a,0x10]

v_mul_f32 v5, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0a,0x10]

v_mul_f32 v5, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0a,0x10]

v_mul_f32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x10]

v_mul_f32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x10]

v_mul_f32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x10]

v_mul_f32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x10]

v_mul_f32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x10]

v_mul_f32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x10]

v_mul_f32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x10]

v_mul_f32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x10]

v_mul_f32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x10]

v_mul_f32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x10]

v_mul_f32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x10]

v_mul_f32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x10]

v_mul_f32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x10]

v_mul_f32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x10]

v_mul_f32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x10,0x56,0x34,0x12,0xaf]

v_mul_f32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x10,0x73,0x72,0x71,0x3f]

v_mul_f32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x10]

v_mul_f32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x10,0xd2,0x01,0x05,0x02,0x00]

v_mul_f32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x10,0xd2,0x01,0x05,0x02,0x00]

v_mul_f32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x10,0xd2,0xff,0x05,0x02,0x00]

v_mul_f32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x10,0xd2,0x01,0x04,0x02,0x00]

v_mul_f32_e64 v5, s103, v2
// CHECK: [0x05,0x00,0x10,0xd2,0x67,0x04,0x02,0x00]

v_mul_f32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x10,0xd2,0x68,0x04,0x02,0x00]

v_mul_f32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x10,0xd2,0x69,0x04,0x02,0x00]

v_mul_f32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x10,0xd2,0x6a,0x04,0x02,0x00]

v_mul_f32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x10,0xd2,0x6b,0x04,0x02,0x00]

v_mul_f32_e64 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x10,0xd2,0x6c,0x04,0x02,0x00]

v_mul_f32_e64 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x10,0xd2,0x6d,0x04,0x02,0x00]

v_mul_f32_e64 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x10,0xd2,0x6e,0x04,0x02,0x00]

v_mul_f32_e64 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x10,0xd2,0x6f,0x04,0x02,0x00]

v_mul_f32_e64 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x10,0xd2,0x7b,0x04,0x02,0x00]

v_mul_f32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x10,0xd2,0x7c,0x04,0x02,0x00]

v_mul_f32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x10,0xd2,0x7e,0x04,0x02,0x00]

v_mul_f32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x10,0xd2,0x7f,0x04,0x02,0x00]

v_mul_f32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x10,0xd2,0x80,0x04,0x02,0x00]

v_mul_f32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x10,0xd2,0xc1,0x04,0x02,0x00]

v_mul_f32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x10,0xd2,0xf0,0x04,0x02,0x00]

v_mul_f32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x10,0xd2,0xf7,0x04,0x02,0x00]

v_mul_f32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x10,0xd2,0x01,0xff,0x03,0x00]

v_mul_f32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x10,0xd2,0x01,0x05,0x00,0x00]

v_mul_f32_e64 v5, v1, s103
// CHECK: [0x05,0x00,0x10,0xd2,0x01,0xcf,0x00,0x00]

v_mul_f32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x10,0xd2,0x01,0xd1,0x00,0x00]

v_mul_f32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x10,0xd2,0x01,0xd3,0x00,0x00]

v_mul_f32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x10,0xd2,0x01,0xd5,0x00,0x00]

v_mul_f32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x10,0xd2,0x01,0xd7,0x00,0x00]

v_mul_f32_e64 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x10,0xd2,0x01,0xd9,0x00,0x00]

v_mul_f32_e64 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x10,0xd2,0x01,0xdb,0x00,0x00]

v_mul_f32_e64 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x10,0xd2,0x01,0xdd,0x00,0x00]

v_mul_f32_e64 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x10,0xd2,0x01,0xdf,0x00,0x00]

v_mul_f32_e64 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x10,0xd2,0x01,0xf7,0x00,0x00]

v_mul_f32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x10,0xd2,0x01,0xf9,0x00,0x00]

v_mul_f32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x10,0xd2,0x01,0xfd,0x00,0x00]

v_mul_f32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x10,0xd2,0x01,0xff,0x00,0x00]

v_mul_f32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x10,0xd2,0x01,0x01,0x01,0x00]

v_mul_f32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x10,0xd2,0x01,0x83,0x01,0x00]

v_mul_f32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x10,0xd2,0x01,0xe1,0x01,0x00]

v_mul_f32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x10,0xd2,0x01,0xef,0x01,0x00]

v_mul_f32_e64 v5, -v1, v2
// CHECK: [0x05,0x00,0x10,0xd2,0x01,0x05,0x02,0x20]

v_mul_f32_e64 v5, v1, -v2
// CHECK: [0x05,0x00,0x10,0xd2,0x01,0x05,0x02,0x40]

v_mul_f32_e64 v5, -v1, -v2
// CHECK: [0x05,0x00,0x10,0xd2,0x01,0x05,0x02,0x60]

v_mul_f32_e64 v5, |v1|, v2
// CHECK: [0x05,0x01,0x10,0xd2,0x01,0x05,0x02,0x00]

v_mul_f32_e64 v5, v1, |v2|
// CHECK: [0x05,0x02,0x10,0xd2,0x01,0x05,0x02,0x00]

v_mul_f32_e64 v5, |v1|, |v2|
// CHECK: [0x05,0x03,0x10,0xd2,0x01,0x05,0x02,0x00]

v_mul_f32_e64 v5, v1, v2 clamp
// CHECK: [0x05,0x08,0x10,0xd2,0x01,0x05,0x02,0x00]

v_mul_f32_e64 v5, v1, v2 mul:2
// CHECK: [0x05,0x00,0x10,0xd2,0x01,0x05,0x02,0x08]

v_mul_f32_e64 v5, v1, v2 mul:4
// CHECK: [0x05,0x00,0x10,0xd2,0x01,0x05,0x02,0x10]

v_mul_f32_e64 v5, v1, v2 div:2
// CHECK: [0x05,0x00,0x10,0xd2,0x01,0x05,0x02,0x18]

v_mul_i32_i24 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x12]

v_mul_i32_i24 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x13]

v_mul_i32_i24 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x12]

v_mul_i32_i24 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x12]

v_mul_i32_i24 v5, s103, v2
// CHECK: [0x67,0x04,0x0a,0x12]

v_mul_i32_i24 v5, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0a,0x12]

v_mul_i32_i24 v5, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0a,0x12]

v_mul_i32_i24 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x12]

v_mul_i32_i24 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x12]

v_mul_i32_i24 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x12]

v_mul_i32_i24 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x12]

v_mul_i32_i24 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x12]

v_mul_i32_i24 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x12]

v_mul_i32_i24 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x12]

v_mul_i32_i24 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x12]

v_mul_i32_i24 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x12]

v_mul_i32_i24 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x12]

v_mul_i32_i24 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x12]

v_mul_i32_i24 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x12]

v_mul_i32_i24 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x12]

v_mul_i32_i24 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x12]

v_mul_i32_i24 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x12,0x56,0x34,0x12,0xaf]

v_mul_i32_i24 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x12,0x73,0x72,0x71,0x3f]

v_mul_i32_i24 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x12]

v_mul_i32_i24_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x12,0xd2,0x01,0x05,0x02,0x00]

v_mul_i32_i24_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x12,0xd2,0x01,0x05,0x02,0x00]

v_mul_i32_i24_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x12,0xd2,0xff,0x05,0x02,0x00]

v_mul_i32_i24_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x12,0xd2,0x01,0x04,0x02,0x00]

v_mul_i32_i24_e64 v5, s103, v2
// CHECK: [0x05,0x00,0x12,0xd2,0x67,0x04,0x02,0x00]

v_mul_i32_i24_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x12,0xd2,0x68,0x04,0x02,0x00]

v_mul_i32_i24_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x12,0xd2,0x69,0x04,0x02,0x00]

v_mul_i32_i24_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x12,0xd2,0x6a,0x04,0x02,0x00]

v_mul_i32_i24_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x12,0xd2,0x6b,0x04,0x02,0x00]

v_mul_i32_i24_e64 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x12,0xd2,0x6c,0x04,0x02,0x00]

v_mul_i32_i24_e64 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x12,0xd2,0x6d,0x04,0x02,0x00]

v_mul_i32_i24_e64 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x12,0xd2,0x6e,0x04,0x02,0x00]

v_mul_i32_i24_e64 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x12,0xd2,0x6f,0x04,0x02,0x00]

v_mul_i32_i24_e64 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x12,0xd2,0x7b,0x04,0x02,0x00]

v_mul_i32_i24_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x12,0xd2,0x7c,0x04,0x02,0x00]

v_mul_i32_i24_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x12,0xd2,0x7e,0x04,0x02,0x00]

v_mul_i32_i24_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x12,0xd2,0x7f,0x04,0x02,0x00]

v_mul_i32_i24_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x12,0xd2,0x80,0x04,0x02,0x00]

v_mul_i32_i24_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x12,0xd2,0xc1,0x04,0x02,0x00]

v_mul_i32_i24_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x12,0xd2,0xf0,0x04,0x02,0x00]

v_mul_i32_i24_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x12,0xd2,0xf7,0x04,0x02,0x00]

v_mul_i32_i24_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x12,0xd2,0x01,0xff,0x03,0x00]

v_mul_i32_i24_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x12,0xd2,0x01,0x05,0x00,0x00]

v_mul_i32_i24_e64 v5, v1, s103
// CHECK: [0x05,0x00,0x12,0xd2,0x01,0xcf,0x00,0x00]

v_mul_i32_i24_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x12,0xd2,0x01,0xd1,0x00,0x00]

v_mul_i32_i24_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x12,0xd2,0x01,0xd3,0x00,0x00]

v_mul_i32_i24_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x12,0xd2,0x01,0xd5,0x00,0x00]

v_mul_i32_i24_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x12,0xd2,0x01,0xd7,0x00,0x00]

v_mul_i32_i24_e64 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x12,0xd2,0x01,0xd9,0x00,0x00]

v_mul_i32_i24_e64 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x12,0xd2,0x01,0xdb,0x00,0x00]

v_mul_i32_i24_e64 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x12,0xd2,0x01,0xdd,0x00,0x00]

v_mul_i32_i24_e64 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x12,0xd2,0x01,0xdf,0x00,0x00]

v_mul_i32_i24_e64 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x12,0xd2,0x01,0xf7,0x00,0x00]

v_mul_i32_i24_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x12,0xd2,0x01,0xf9,0x00,0x00]

v_mul_i32_i24_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x12,0xd2,0x01,0xfd,0x00,0x00]

v_mul_i32_i24_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x12,0xd2,0x01,0xff,0x00,0x00]

v_mul_i32_i24_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x12,0xd2,0x01,0x01,0x01,0x00]

v_mul_i32_i24_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x12,0xd2,0x01,0x83,0x01,0x00]

v_mul_i32_i24_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x12,0xd2,0x01,0xe1,0x01,0x00]

v_mul_i32_i24_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x12,0xd2,0x01,0xef,0x01,0x00]

v_mul_hi_i32_i24 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x14]

v_mul_hi_i32_i24 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x15]

v_mul_hi_i32_i24 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x14]

v_mul_hi_i32_i24 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x14]

v_mul_hi_i32_i24 v5, s103, v2
// CHECK: [0x67,0x04,0x0a,0x14]

v_mul_hi_i32_i24 v5, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0a,0x14]

v_mul_hi_i32_i24 v5, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0a,0x14]

v_mul_hi_i32_i24 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x14]

v_mul_hi_i32_i24 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x14]

v_mul_hi_i32_i24 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x14]

v_mul_hi_i32_i24 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x14]

v_mul_hi_i32_i24 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x14]

v_mul_hi_i32_i24 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x14]

v_mul_hi_i32_i24 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x14]

v_mul_hi_i32_i24 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x14]

v_mul_hi_i32_i24 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x14]

v_mul_hi_i32_i24 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x14]

v_mul_hi_i32_i24 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x14]

v_mul_hi_i32_i24 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x14]

v_mul_hi_i32_i24 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x14]

v_mul_hi_i32_i24 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x14]

v_mul_hi_i32_i24 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x14,0x56,0x34,0x12,0xaf]

v_mul_hi_i32_i24 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x14,0x73,0x72,0x71,0x3f]

v_mul_hi_i32_i24 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x14]

v_mul_hi_i32_i24_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x14,0xd2,0x01,0x05,0x02,0x00]

v_mul_hi_i32_i24_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x14,0xd2,0x01,0x05,0x02,0x00]

v_mul_hi_i32_i24_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x14,0xd2,0xff,0x05,0x02,0x00]

v_mul_hi_i32_i24_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x14,0xd2,0x01,0x04,0x02,0x00]

v_mul_hi_i32_i24_e64 v5, s103, v2
// CHECK: [0x05,0x00,0x14,0xd2,0x67,0x04,0x02,0x00]

v_mul_hi_i32_i24_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x14,0xd2,0x68,0x04,0x02,0x00]

v_mul_hi_i32_i24_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x14,0xd2,0x69,0x04,0x02,0x00]

v_mul_hi_i32_i24_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x14,0xd2,0x6a,0x04,0x02,0x00]

v_mul_hi_i32_i24_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x14,0xd2,0x6b,0x04,0x02,0x00]

v_mul_hi_i32_i24_e64 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x14,0xd2,0x6c,0x04,0x02,0x00]

v_mul_hi_i32_i24_e64 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x14,0xd2,0x6d,0x04,0x02,0x00]

v_mul_hi_i32_i24_e64 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x14,0xd2,0x6e,0x04,0x02,0x00]

v_mul_hi_i32_i24_e64 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x14,0xd2,0x6f,0x04,0x02,0x00]

v_mul_hi_i32_i24_e64 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x14,0xd2,0x7b,0x04,0x02,0x00]

v_mul_hi_i32_i24_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x14,0xd2,0x7c,0x04,0x02,0x00]

v_mul_hi_i32_i24_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x14,0xd2,0x7e,0x04,0x02,0x00]

v_mul_hi_i32_i24_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x14,0xd2,0x7f,0x04,0x02,0x00]

v_mul_hi_i32_i24_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x14,0xd2,0x80,0x04,0x02,0x00]

v_mul_hi_i32_i24_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x14,0xd2,0xc1,0x04,0x02,0x00]

v_mul_hi_i32_i24_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x14,0xd2,0xf0,0x04,0x02,0x00]

v_mul_hi_i32_i24_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x14,0xd2,0xf7,0x04,0x02,0x00]

v_mul_hi_i32_i24_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x14,0xd2,0x01,0xff,0x03,0x00]

v_mul_hi_i32_i24_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x14,0xd2,0x01,0x05,0x00,0x00]

v_mul_hi_i32_i24_e64 v5, v1, s103
// CHECK: [0x05,0x00,0x14,0xd2,0x01,0xcf,0x00,0x00]

v_mul_hi_i32_i24_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x14,0xd2,0x01,0xd1,0x00,0x00]

v_mul_hi_i32_i24_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x14,0xd2,0x01,0xd3,0x00,0x00]

v_mul_hi_i32_i24_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x14,0xd2,0x01,0xd5,0x00,0x00]

v_mul_hi_i32_i24_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x14,0xd2,0x01,0xd7,0x00,0x00]

v_mul_hi_i32_i24_e64 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x14,0xd2,0x01,0xd9,0x00,0x00]

v_mul_hi_i32_i24_e64 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x14,0xd2,0x01,0xdb,0x00,0x00]

v_mul_hi_i32_i24_e64 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x14,0xd2,0x01,0xdd,0x00,0x00]

v_mul_hi_i32_i24_e64 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x14,0xd2,0x01,0xdf,0x00,0x00]

v_mul_hi_i32_i24_e64 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x14,0xd2,0x01,0xf7,0x00,0x00]

v_mul_hi_i32_i24_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x14,0xd2,0x01,0xf9,0x00,0x00]

v_mul_hi_i32_i24_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x14,0xd2,0x01,0xfd,0x00,0x00]

v_mul_hi_i32_i24_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x14,0xd2,0x01,0xff,0x00,0x00]

v_mul_hi_i32_i24_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x14,0xd2,0x01,0x01,0x01,0x00]

v_mul_hi_i32_i24_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x14,0xd2,0x01,0x83,0x01,0x00]

v_mul_hi_i32_i24_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x14,0xd2,0x01,0xe1,0x01,0x00]

v_mul_hi_i32_i24_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x14,0xd2,0x01,0xef,0x01,0x00]

v_mul_u32_u24 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x16]

v_mul_u32_u24 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x17]

v_mul_u32_u24 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x16]

v_mul_u32_u24 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x16]

v_mul_u32_u24 v5, s103, v2
// CHECK: [0x67,0x04,0x0a,0x16]

v_mul_u32_u24 v5, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0a,0x16]

v_mul_u32_u24 v5, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0a,0x16]

v_mul_u32_u24 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x16]

v_mul_u32_u24 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x16]

v_mul_u32_u24 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x16]

v_mul_u32_u24 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x16]

v_mul_u32_u24 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x16]

v_mul_u32_u24 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x16]

v_mul_u32_u24 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x16]

v_mul_u32_u24 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x16]

v_mul_u32_u24 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x16]

v_mul_u32_u24 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x16]

v_mul_u32_u24 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x16]

v_mul_u32_u24 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x16]

v_mul_u32_u24 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x16]

v_mul_u32_u24 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x16]

v_mul_u32_u24 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x16,0x56,0x34,0x12,0xaf]

v_mul_u32_u24 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x16,0x73,0x72,0x71,0x3f]

v_mul_u32_u24 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x16]

v_mul_u32_u24_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x16,0xd2,0x01,0x05,0x02,0x00]

v_mul_u32_u24_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x16,0xd2,0x01,0x05,0x02,0x00]

v_mul_u32_u24_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x16,0xd2,0xff,0x05,0x02,0x00]

v_mul_u32_u24_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x16,0xd2,0x01,0x04,0x02,0x00]

v_mul_u32_u24_e64 v5, s103, v2
// CHECK: [0x05,0x00,0x16,0xd2,0x67,0x04,0x02,0x00]

v_mul_u32_u24_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x16,0xd2,0x68,0x04,0x02,0x00]

v_mul_u32_u24_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x16,0xd2,0x69,0x04,0x02,0x00]

v_mul_u32_u24_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x16,0xd2,0x6a,0x04,0x02,0x00]

v_mul_u32_u24_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x16,0xd2,0x6b,0x04,0x02,0x00]

v_mul_u32_u24_e64 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x16,0xd2,0x6c,0x04,0x02,0x00]

v_mul_u32_u24_e64 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x16,0xd2,0x6d,0x04,0x02,0x00]

v_mul_u32_u24_e64 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x16,0xd2,0x6e,0x04,0x02,0x00]

v_mul_u32_u24_e64 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x16,0xd2,0x6f,0x04,0x02,0x00]

v_mul_u32_u24_e64 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x16,0xd2,0x7b,0x04,0x02,0x00]

v_mul_u32_u24_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x16,0xd2,0x7c,0x04,0x02,0x00]

v_mul_u32_u24_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x16,0xd2,0x7e,0x04,0x02,0x00]

v_mul_u32_u24_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x16,0xd2,0x7f,0x04,0x02,0x00]

v_mul_u32_u24_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x16,0xd2,0x80,0x04,0x02,0x00]

v_mul_u32_u24_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x16,0xd2,0xc1,0x04,0x02,0x00]

v_mul_u32_u24_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x16,0xd2,0xf0,0x04,0x02,0x00]

v_mul_u32_u24_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x16,0xd2,0xf7,0x04,0x02,0x00]

v_mul_u32_u24_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x16,0xd2,0x01,0xff,0x03,0x00]

v_mul_u32_u24_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x16,0xd2,0x01,0x05,0x00,0x00]

v_mul_u32_u24_e64 v5, v1, s103
// CHECK: [0x05,0x00,0x16,0xd2,0x01,0xcf,0x00,0x00]

v_mul_u32_u24_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x16,0xd2,0x01,0xd1,0x00,0x00]

v_mul_u32_u24_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x16,0xd2,0x01,0xd3,0x00,0x00]

v_mul_u32_u24_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x16,0xd2,0x01,0xd5,0x00,0x00]

v_mul_u32_u24_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x16,0xd2,0x01,0xd7,0x00,0x00]

v_mul_u32_u24_e64 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x16,0xd2,0x01,0xd9,0x00,0x00]

v_mul_u32_u24_e64 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x16,0xd2,0x01,0xdb,0x00,0x00]

v_mul_u32_u24_e64 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x16,0xd2,0x01,0xdd,0x00,0x00]

v_mul_u32_u24_e64 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x16,0xd2,0x01,0xdf,0x00,0x00]

v_mul_u32_u24_e64 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x16,0xd2,0x01,0xf7,0x00,0x00]

v_mul_u32_u24_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x16,0xd2,0x01,0xf9,0x00,0x00]

v_mul_u32_u24_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x16,0xd2,0x01,0xfd,0x00,0x00]

v_mul_u32_u24_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x16,0xd2,0x01,0xff,0x00,0x00]

v_mul_u32_u24_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x16,0xd2,0x01,0x01,0x01,0x00]

v_mul_u32_u24_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x16,0xd2,0x01,0x83,0x01,0x00]

v_mul_u32_u24_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x16,0xd2,0x01,0xe1,0x01,0x00]

v_mul_u32_u24_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x16,0xd2,0x01,0xef,0x01,0x00]

v_mul_hi_u32_u24 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x18]

v_mul_hi_u32_u24 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x19]

v_mul_hi_u32_u24 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x18]

v_mul_hi_u32_u24 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x18]

v_mul_hi_u32_u24 v5, s103, v2
// CHECK: [0x67,0x04,0x0a,0x18]

v_mul_hi_u32_u24 v5, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0a,0x18]

v_mul_hi_u32_u24 v5, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0a,0x18]

v_mul_hi_u32_u24 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x18]

v_mul_hi_u32_u24 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x18]

v_mul_hi_u32_u24 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x18]

v_mul_hi_u32_u24 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x18]

v_mul_hi_u32_u24 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x18]

v_mul_hi_u32_u24 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x18]

v_mul_hi_u32_u24 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x18]

v_mul_hi_u32_u24 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x18]

v_mul_hi_u32_u24 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x18]

v_mul_hi_u32_u24 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x18]

v_mul_hi_u32_u24 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x18]

v_mul_hi_u32_u24 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x18]

v_mul_hi_u32_u24 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x18]

v_mul_hi_u32_u24 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x18]

v_mul_hi_u32_u24 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x18,0x56,0x34,0x12,0xaf]

v_mul_hi_u32_u24 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x18,0x73,0x72,0x71,0x3f]

v_mul_hi_u32_u24 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x18]

v_mul_hi_u32_u24_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x18,0xd2,0x01,0x05,0x02,0x00]

v_mul_hi_u32_u24_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x18,0xd2,0x01,0x05,0x02,0x00]

v_mul_hi_u32_u24_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x18,0xd2,0xff,0x05,0x02,0x00]

v_mul_hi_u32_u24_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x18,0xd2,0x01,0x04,0x02,0x00]

v_mul_hi_u32_u24_e64 v5, s103, v2
// CHECK: [0x05,0x00,0x18,0xd2,0x67,0x04,0x02,0x00]

v_mul_hi_u32_u24_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x18,0xd2,0x68,0x04,0x02,0x00]

v_mul_hi_u32_u24_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x18,0xd2,0x69,0x04,0x02,0x00]

v_mul_hi_u32_u24_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x18,0xd2,0x6a,0x04,0x02,0x00]

v_mul_hi_u32_u24_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x18,0xd2,0x6b,0x04,0x02,0x00]

v_mul_hi_u32_u24_e64 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x18,0xd2,0x6c,0x04,0x02,0x00]

v_mul_hi_u32_u24_e64 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x18,0xd2,0x6d,0x04,0x02,0x00]

v_mul_hi_u32_u24_e64 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x18,0xd2,0x6e,0x04,0x02,0x00]

v_mul_hi_u32_u24_e64 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x18,0xd2,0x6f,0x04,0x02,0x00]

v_mul_hi_u32_u24_e64 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x18,0xd2,0x7b,0x04,0x02,0x00]

v_mul_hi_u32_u24_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x18,0xd2,0x7c,0x04,0x02,0x00]

v_mul_hi_u32_u24_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x18,0xd2,0x7e,0x04,0x02,0x00]

v_mul_hi_u32_u24_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x18,0xd2,0x7f,0x04,0x02,0x00]

v_mul_hi_u32_u24_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x18,0xd2,0x80,0x04,0x02,0x00]

v_mul_hi_u32_u24_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x18,0xd2,0xc1,0x04,0x02,0x00]

v_mul_hi_u32_u24_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x18,0xd2,0xf0,0x04,0x02,0x00]

v_mul_hi_u32_u24_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x18,0xd2,0xf7,0x04,0x02,0x00]

v_mul_hi_u32_u24_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x18,0xd2,0x01,0xff,0x03,0x00]

v_mul_hi_u32_u24_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x18,0xd2,0x01,0x05,0x00,0x00]

v_mul_hi_u32_u24_e64 v5, v1, s103
// CHECK: [0x05,0x00,0x18,0xd2,0x01,0xcf,0x00,0x00]

v_mul_hi_u32_u24_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x18,0xd2,0x01,0xd1,0x00,0x00]

v_mul_hi_u32_u24_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x18,0xd2,0x01,0xd3,0x00,0x00]

v_mul_hi_u32_u24_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x18,0xd2,0x01,0xd5,0x00,0x00]

v_mul_hi_u32_u24_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x18,0xd2,0x01,0xd7,0x00,0x00]

v_mul_hi_u32_u24_e64 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x18,0xd2,0x01,0xd9,0x00,0x00]

v_mul_hi_u32_u24_e64 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x18,0xd2,0x01,0xdb,0x00,0x00]

v_mul_hi_u32_u24_e64 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x18,0xd2,0x01,0xdd,0x00,0x00]

v_mul_hi_u32_u24_e64 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x18,0xd2,0x01,0xdf,0x00,0x00]

v_mul_hi_u32_u24_e64 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x18,0xd2,0x01,0xf7,0x00,0x00]

v_mul_hi_u32_u24_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x18,0xd2,0x01,0xf9,0x00,0x00]

v_mul_hi_u32_u24_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x18,0xd2,0x01,0xfd,0x00,0x00]

v_mul_hi_u32_u24_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x18,0xd2,0x01,0xff,0x00,0x00]

v_mul_hi_u32_u24_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x18,0xd2,0x01,0x01,0x01,0x00]

v_mul_hi_u32_u24_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x18,0xd2,0x01,0x83,0x01,0x00]

v_mul_hi_u32_u24_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x18,0xd2,0x01,0xe1,0x01,0x00]

v_mul_hi_u32_u24_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x18,0xd2,0x01,0xef,0x01,0x00]

v_min_legacy_f32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x1a]

v_min_legacy_f32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x1b]

v_min_legacy_f32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x1a]

v_min_legacy_f32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x1a]

v_min_legacy_f32 v5, s103, v2
// CHECK: [0x67,0x04,0x0a,0x1a]

v_min_legacy_f32 v5, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0a,0x1a]

v_min_legacy_f32 v5, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0a,0x1a]

v_min_legacy_f32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x1a]

v_min_legacy_f32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x1a]

v_min_legacy_f32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x1a]

v_min_legacy_f32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x1a]

v_min_legacy_f32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x1a]

v_min_legacy_f32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x1a]

v_min_legacy_f32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x1a]

v_min_legacy_f32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x1a]

v_min_legacy_f32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x1a]

v_min_legacy_f32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x1a]

v_min_legacy_f32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x1a]

v_min_legacy_f32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x1a]

v_min_legacy_f32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x1a]

v_min_legacy_f32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x1a]

v_min_legacy_f32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x1a,0x56,0x34,0x12,0xaf]

v_min_legacy_f32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x1a,0x73,0x72,0x71,0x3f]

v_min_legacy_f32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x1a]

v_min_legacy_f32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x1a,0xd2,0x01,0x05,0x02,0x00]

v_min_legacy_f32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x1a,0xd2,0x01,0x05,0x02,0x00]

v_min_legacy_f32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x1a,0xd2,0xff,0x05,0x02,0x00]

v_min_legacy_f32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x1a,0xd2,0x01,0x04,0x02,0x00]

v_min_legacy_f32_e64 v5, s103, v2
// CHECK: [0x05,0x00,0x1a,0xd2,0x67,0x04,0x02,0x00]

v_min_legacy_f32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x1a,0xd2,0x68,0x04,0x02,0x00]

v_min_legacy_f32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x1a,0xd2,0x69,0x04,0x02,0x00]

v_min_legacy_f32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x1a,0xd2,0x6a,0x04,0x02,0x00]

v_min_legacy_f32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x1a,0xd2,0x6b,0x04,0x02,0x00]

v_min_legacy_f32_e64 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x1a,0xd2,0x6c,0x04,0x02,0x00]

v_min_legacy_f32_e64 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x1a,0xd2,0x6d,0x04,0x02,0x00]

v_min_legacy_f32_e64 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x1a,0xd2,0x6e,0x04,0x02,0x00]

v_min_legacy_f32_e64 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x1a,0xd2,0x6f,0x04,0x02,0x00]

v_min_legacy_f32_e64 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x1a,0xd2,0x7b,0x04,0x02,0x00]

v_min_legacy_f32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x1a,0xd2,0x7c,0x04,0x02,0x00]

v_min_legacy_f32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x1a,0xd2,0x7e,0x04,0x02,0x00]

v_min_legacy_f32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x1a,0xd2,0x7f,0x04,0x02,0x00]

v_min_legacy_f32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x1a,0xd2,0x80,0x04,0x02,0x00]

v_min_legacy_f32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x1a,0xd2,0xc1,0x04,0x02,0x00]

v_min_legacy_f32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x1a,0xd2,0xf0,0x04,0x02,0x00]

v_min_legacy_f32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x1a,0xd2,0xf7,0x04,0x02,0x00]

v_min_legacy_f32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x1a,0xd2,0x01,0xff,0x03,0x00]

v_min_legacy_f32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x1a,0xd2,0x01,0x05,0x00,0x00]

v_min_legacy_f32_e64 v5, v1, s103
// CHECK: [0x05,0x00,0x1a,0xd2,0x01,0xcf,0x00,0x00]

v_min_legacy_f32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x1a,0xd2,0x01,0xd1,0x00,0x00]

v_min_legacy_f32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x1a,0xd2,0x01,0xd3,0x00,0x00]

v_min_legacy_f32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x1a,0xd2,0x01,0xd5,0x00,0x00]

v_min_legacy_f32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x1a,0xd2,0x01,0xd7,0x00,0x00]

v_min_legacy_f32_e64 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x1a,0xd2,0x01,0xd9,0x00,0x00]

v_min_legacy_f32_e64 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x1a,0xd2,0x01,0xdb,0x00,0x00]

v_min_legacy_f32_e64 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x1a,0xd2,0x01,0xdd,0x00,0x00]

v_min_legacy_f32_e64 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x1a,0xd2,0x01,0xdf,0x00,0x00]

v_min_legacy_f32_e64 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x1a,0xd2,0x01,0xf7,0x00,0x00]

v_min_legacy_f32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x1a,0xd2,0x01,0xf9,0x00,0x00]

v_min_legacy_f32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x1a,0xd2,0x01,0xfd,0x00,0x00]

v_min_legacy_f32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x1a,0xd2,0x01,0xff,0x00,0x00]

v_min_legacy_f32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x1a,0xd2,0x01,0x01,0x01,0x00]

v_min_legacy_f32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x1a,0xd2,0x01,0x83,0x01,0x00]

v_min_legacy_f32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x1a,0xd2,0x01,0xe1,0x01,0x00]

v_min_legacy_f32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x1a,0xd2,0x01,0xef,0x01,0x00]

v_min_legacy_f32_e64 v5, -v1, v2
// CHECK: [0x05,0x00,0x1a,0xd2,0x01,0x05,0x02,0x20]

v_min_legacy_f32_e64 v5, v1, -v2
// CHECK: [0x05,0x00,0x1a,0xd2,0x01,0x05,0x02,0x40]

v_min_legacy_f32_e64 v5, -v1, -v2
// CHECK: [0x05,0x00,0x1a,0xd2,0x01,0x05,0x02,0x60]

v_min_legacy_f32_e64 v5, |v1|, v2
// CHECK: [0x05,0x01,0x1a,0xd2,0x01,0x05,0x02,0x00]

v_min_legacy_f32_e64 v5, v1, |v2|
// CHECK: [0x05,0x02,0x1a,0xd2,0x01,0x05,0x02,0x00]

v_min_legacy_f32_e64 v5, |v1|, |v2|
// CHECK: [0x05,0x03,0x1a,0xd2,0x01,0x05,0x02,0x00]

v_min_legacy_f32_e64 v5, v1, v2 clamp
// CHECK: [0x05,0x08,0x1a,0xd2,0x01,0x05,0x02,0x00]

v_min_legacy_f32_e64 v5, v1, v2 mul:2
// CHECK: [0x05,0x00,0x1a,0xd2,0x01,0x05,0x02,0x08]

v_min_legacy_f32_e64 v5, v1, v2 mul:4
// CHECK: [0x05,0x00,0x1a,0xd2,0x01,0x05,0x02,0x10]

v_min_legacy_f32_e64 v5, v1, v2 div:2
// CHECK: [0x05,0x00,0x1a,0xd2,0x01,0x05,0x02,0x18]

v_max_legacy_f32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x1c]

v_max_legacy_f32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x1d]

v_max_legacy_f32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x1c]

v_max_legacy_f32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x1c]

v_max_legacy_f32 v5, s103, v2
// CHECK: [0x67,0x04,0x0a,0x1c]

v_max_legacy_f32 v5, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0a,0x1c]

v_max_legacy_f32 v5, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0a,0x1c]

v_max_legacy_f32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x1c]

v_max_legacy_f32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x1c]

v_max_legacy_f32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x1c]

v_max_legacy_f32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x1c]

v_max_legacy_f32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x1c]

v_max_legacy_f32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x1c]

v_max_legacy_f32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x1c]

v_max_legacy_f32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x1c]

v_max_legacy_f32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x1c]

v_max_legacy_f32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x1c]

v_max_legacy_f32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x1c]

v_max_legacy_f32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x1c]

v_max_legacy_f32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x1c]

v_max_legacy_f32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x1c]

v_max_legacy_f32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x1c,0x56,0x34,0x12,0xaf]

v_max_legacy_f32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x1c,0x73,0x72,0x71,0x3f]

v_max_legacy_f32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x1c]

v_max_legacy_f32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x1c,0xd2,0x01,0x05,0x02,0x00]

v_max_legacy_f32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x1c,0xd2,0x01,0x05,0x02,0x00]

v_max_legacy_f32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x1c,0xd2,0xff,0x05,0x02,0x00]

v_max_legacy_f32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x1c,0xd2,0x01,0x04,0x02,0x00]

v_max_legacy_f32_e64 v5, s103, v2
// CHECK: [0x05,0x00,0x1c,0xd2,0x67,0x04,0x02,0x00]

v_max_legacy_f32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x1c,0xd2,0x68,0x04,0x02,0x00]

v_max_legacy_f32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x1c,0xd2,0x69,0x04,0x02,0x00]

v_max_legacy_f32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x1c,0xd2,0x6a,0x04,0x02,0x00]

v_max_legacy_f32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x1c,0xd2,0x6b,0x04,0x02,0x00]

v_max_legacy_f32_e64 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x1c,0xd2,0x6c,0x04,0x02,0x00]

v_max_legacy_f32_e64 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x1c,0xd2,0x6d,0x04,0x02,0x00]

v_max_legacy_f32_e64 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x1c,0xd2,0x6e,0x04,0x02,0x00]

v_max_legacy_f32_e64 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x1c,0xd2,0x6f,0x04,0x02,0x00]

v_max_legacy_f32_e64 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x1c,0xd2,0x7b,0x04,0x02,0x00]

v_max_legacy_f32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x1c,0xd2,0x7c,0x04,0x02,0x00]

v_max_legacy_f32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x1c,0xd2,0x7e,0x04,0x02,0x00]

v_max_legacy_f32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x1c,0xd2,0x7f,0x04,0x02,0x00]

v_max_legacy_f32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x1c,0xd2,0x80,0x04,0x02,0x00]

v_max_legacy_f32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x1c,0xd2,0xc1,0x04,0x02,0x00]

v_max_legacy_f32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x1c,0xd2,0xf0,0x04,0x02,0x00]

v_max_legacy_f32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x1c,0xd2,0xf7,0x04,0x02,0x00]

v_max_legacy_f32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x1c,0xd2,0x01,0xff,0x03,0x00]

v_max_legacy_f32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x1c,0xd2,0x01,0x05,0x00,0x00]

v_max_legacy_f32_e64 v5, v1, s103
// CHECK: [0x05,0x00,0x1c,0xd2,0x01,0xcf,0x00,0x00]

v_max_legacy_f32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x1c,0xd2,0x01,0xd1,0x00,0x00]

v_max_legacy_f32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x1c,0xd2,0x01,0xd3,0x00,0x00]

v_max_legacy_f32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x1c,0xd2,0x01,0xd5,0x00,0x00]

v_max_legacy_f32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x1c,0xd2,0x01,0xd7,0x00,0x00]

v_max_legacy_f32_e64 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x1c,0xd2,0x01,0xd9,0x00,0x00]

v_max_legacy_f32_e64 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x1c,0xd2,0x01,0xdb,0x00,0x00]

v_max_legacy_f32_e64 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x1c,0xd2,0x01,0xdd,0x00,0x00]

v_max_legacy_f32_e64 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x1c,0xd2,0x01,0xdf,0x00,0x00]

v_max_legacy_f32_e64 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x1c,0xd2,0x01,0xf7,0x00,0x00]

v_max_legacy_f32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x1c,0xd2,0x01,0xf9,0x00,0x00]

v_max_legacy_f32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x1c,0xd2,0x01,0xfd,0x00,0x00]

v_max_legacy_f32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x1c,0xd2,0x01,0xff,0x00,0x00]

v_max_legacy_f32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x1c,0xd2,0x01,0x01,0x01,0x00]

v_max_legacy_f32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x1c,0xd2,0x01,0x83,0x01,0x00]

v_max_legacy_f32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x1c,0xd2,0x01,0xe1,0x01,0x00]

v_max_legacy_f32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x1c,0xd2,0x01,0xef,0x01,0x00]

v_max_legacy_f32_e64 v5, -v1, v2
// CHECK: [0x05,0x00,0x1c,0xd2,0x01,0x05,0x02,0x20]

v_max_legacy_f32_e64 v5, v1, -v2
// CHECK: [0x05,0x00,0x1c,0xd2,0x01,0x05,0x02,0x40]

v_max_legacy_f32_e64 v5, -v1, -v2
// CHECK: [0x05,0x00,0x1c,0xd2,0x01,0x05,0x02,0x60]

v_max_legacy_f32_e64 v5, |v1|, v2
// CHECK: [0x05,0x01,0x1c,0xd2,0x01,0x05,0x02,0x00]

v_max_legacy_f32_e64 v5, v1, |v2|
// CHECK: [0x05,0x02,0x1c,0xd2,0x01,0x05,0x02,0x00]

v_max_legacy_f32_e64 v5, |v1|, |v2|
// CHECK: [0x05,0x03,0x1c,0xd2,0x01,0x05,0x02,0x00]

v_max_legacy_f32_e64 v5, v1, v2 clamp
// CHECK: [0x05,0x08,0x1c,0xd2,0x01,0x05,0x02,0x00]

v_max_legacy_f32_e64 v5, v1, v2 mul:2
// CHECK: [0x05,0x00,0x1c,0xd2,0x01,0x05,0x02,0x08]

v_max_legacy_f32_e64 v5, v1, v2 mul:4
// CHECK: [0x05,0x00,0x1c,0xd2,0x01,0x05,0x02,0x10]

v_max_legacy_f32_e64 v5, v1, v2 div:2
// CHECK: [0x05,0x00,0x1c,0xd2,0x01,0x05,0x02,0x18]

v_min_f32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x1e]

v_min_f32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x1f]

v_min_f32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x1e]

v_min_f32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x1e]

v_min_f32 v5, s103, v2
// CHECK: [0x67,0x04,0x0a,0x1e]

v_min_f32 v5, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0a,0x1e]

v_min_f32 v5, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0a,0x1e]

v_min_f32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x1e]

v_min_f32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x1e]

v_min_f32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x1e]

v_min_f32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x1e]

v_min_f32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x1e]

v_min_f32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x1e]

v_min_f32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x1e]

v_min_f32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x1e]

v_min_f32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x1e]

v_min_f32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x1e]

v_min_f32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x1e]

v_min_f32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x1e]

v_min_f32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x1e]

v_min_f32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x1e]

v_min_f32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x1e,0x56,0x34,0x12,0xaf]

v_min_f32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x1e,0x73,0x72,0x71,0x3f]

v_min_f32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x1e]

v_min_f32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x1e,0xd2,0x01,0x05,0x02,0x00]

v_min_f32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x1e,0xd2,0x01,0x05,0x02,0x00]

v_min_f32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x1e,0xd2,0xff,0x05,0x02,0x00]

v_min_f32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x1e,0xd2,0x01,0x04,0x02,0x00]

v_min_f32_e64 v5, s103, v2
// CHECK: [0x05,0x00,0x1e,0xd2,0x67,0x04,0x02,0x00]

v_min_f32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x1e,0xd2,0x68,0x04,0x02,0x00]

v_min_f32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x1e,0xd2,0x69,0x04,0x02,0x00]

v_min_f32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x1e,0xd2,0x6a,0x04,0x02,0x00]

v_min_f32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x1e,0xd2,0x6b,0x04,0x02,0x00]

v_min_f32_e64 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x1e,0xd2,0x6c,0x04,0x02,0x00]

v_min_f32_e64 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x1e,0xd2,0x6d,0x04,0x02,0x00]

v_min_f32_e64 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x1e,0xd2,0x6e,0x04,0x02,0x00]

v_min_f32_e64 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x1e,0xd2,0x6f,0x04,0x02,0x00]

v_min_f32_e64 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x1e,0xd2,0x7b,0x04,0x02,0x00]

v_min_f32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x1e,0xd2,0x7c,0x04,0x02,0x00]

v_min_f32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x1e,0xd2,0x7e,0x04,0x02,0x00]

v_min_f32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x1e,0xd2,0x7f,0x04,0x02,0x00]

v_min_f32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x1e,0xd2,0x80,0x04,0x02,0x00]

v_min_f32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x1e,0xd2,0xc1,0x04,0x02,0x00]

v_min_f32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x1e,0xd2,0xf0,0x04,0x02,0x00]

v_min_f32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x1e,0xd2,0xf7,0x04,0x02,0x00]

v_min_f32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x1e,0xd2,0x01,0xff,0x03,0x00]

v_min_f32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x1e,0xd2,0x01,0x05,0x00,0x00]

v_min_f32_e64 v5, v1, s103
// CHECK: [0x05,0x00,0x1e,0xd2,0x01,0xcf,0x00,0x00]

v_min_f32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x1e,0xd2,0x01,0xd1,0x00,0x00]

v_min_f32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x1e,0xd2,0x01,0xd3,0x00,0x00]

v_min_f32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x1e,0xd2,0x01,0xd5,0x00,0x00]

v_min_f32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x1e,0xd2,0x01,0xd7,0x00,0x00]

v_min_f32_e64 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x1e,0xd2,0x01,0xd9,0x00,0x00]

v_min_f32_e64 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x1e,0xd2,0x01,0xdb,0x00,0x00]

v_min_f32_e64 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x1e,0xd2,0x01,0xdd,0x00,0x00]

v_min_f32_e64 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x1e,0xd2,0x01,0xdf,0x00,0x00]

v_min_f32_e64 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x1e,0xd2,0x01,0xf7,0x00,0x00]

v_min_f32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x1e,0xd2,0x01,0xf9,0x00,0x00]

v_min_f32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x1e,0xd2,0x01,0xfd,0x00,0x00]

v_min_f32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x1e,0xd2,0x01,0xff,0x00,0x00]

v_min_f32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x1e,0xd2,0x01,0x01,0x01,0x00]

v_min_f32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x1e,0xd2,0x01,0x83,0x01,0x00]

v_min_f32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x1e,0xd2,0x01,0xe1,0x01,0x00]

v_min_f32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x1e,0xd2,0x01,0xef,0x01,0x00]

v_min_f32_e64 v5, -v1, v2
// CHECK: [0x05,0x00,0x1e,0xd2,0x01,0x05,0x02,0x20]

v_min_f32_e64 v5, v1, -v2
// CHECK: [0x05,0x00,0x1e,0xd2,0x01,0x05,0x02,0x40]

v_min_f32_e64 v5, -v1, -v2
// CHECK: [0x05,0x00,0x1e,0xd2,0x01,0x05,0x02,0x60]

v_min_f32_e64 v5, |v1|, v2
// CHECK: [0x05,0x01,0x1e,0xd2,0x01,0x05,0x02,0x00]

v_min_f32_e64 v5, v1, |v2|
// CHECK: [0x05,0x02,0x1e,0xd2,0x01,0x05,0x02,0x00]

v_min_f32_e64 v5, |v1|, |v2|
// CHECK: [0x05,0x03,0x1e,0xd2,0x01,0x05,0x02,0x00]

v_min_f32_e64 v5, v1, v2 clamp
// CHECK: [0x05,0x08,0x1e,0xd2,0x01,0x05,0x02,0x00]

v_min_f32_e64 v5, v1, v2 mul:2
// CHECK: [0x05,0x00,0x1e,0xd2,0x01,0x05,0x02,0x08]

v_min_f32_e64 v5, v1, v2 mul:4
// CHECK: [0x05,0x00,0x1e,0xd2,0x01,0x05,0x02,0x10]

v_min_f32_e64 v5, v1, v2 div:2
// CHECK: [0x05,0x00,0x1e,0xd2,0x01,0x05,0x02,0x18]

v_max_f32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x20]

v_max_f32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x21]

v_max_f32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x20]

v_max_f32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x20]

v_max_f32 v5, s103, v2
// CHECK: [0x67,0x04,0x0a,0x20]

v_max_f32 v5, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0a,0x20]

v_max_f32 v5, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0a,0x20]

v_max_f32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x20]

v_max_f32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x20]

v_max_f32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x20]

v_max_f32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x20]

v_max_f32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x20]

v_max_f32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x20]

v_max_f32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x20]

v_max_f32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x20]

v_max_f32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x20]

v_max_f32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x20]

v_max_f32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x20]

v_max_f32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x20]

v_max_f32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x20]

v_max_f32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x20]

v_max_f32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x20,0x56,0x34,0x12,0xaf]

v_max_f32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x20,0x73,0x72,0x71,0x3f]

v_max_f32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x20]

v_max_f32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x20,0xd2,0x01,0x05,0x02,0x00]

v_max_f32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x20,0xd2,0x01,0x05,0x02,0x00]

v_max_f32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x20,0xd2,0xff,0x05,0x02,0x00]

v_max_f32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x20,0xd2,0x01,0x04,0x02,0x00]

v_max_f32_e64 v5, s103, v2
// CHECK: [0x05,0x00,0x20,0xd2,0x67,0x04,0x02,0x00]

v_max_f32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x20,0xd2,0x68,0x04,0x02,0x00]

v_max_f32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x20,0xd2,0x69,0x04,0x02,0x00]

v_max_f32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x20,0xd2,0x6a,0x04,0x02,0x00]

v_max_f32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x20,0xd2,0x6b,0x04,0x02,0x00]

v_max_f32_e64 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x20,0xd2,0x6c,0x04,0x02,0x00]

v_max_f32_e64 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x20,0xd2,0x6d,0x04,0x02,0x00]

v_max_f32_e64 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x20,0xd2,0x6e,0x04,0x02,0x00]

v_max_f32_e64 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x20,0xd2,0x6f,0x04,0x02,0x00]

v_max_f32_e64 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x20,0xd2,0x7b,0x04,0x02,0x00]

v_max_f32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x20,0xd2,0x7c,0x04,0x02,0x00]

v_max_f32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x20,0xd2,0x7e,0x04,0x02,0x00]

v_max_f32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x20,0xd2,0x7f,0x04,0x02,0x00]

v_max_f32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x20,0xd2,0x80,0x04,0x02,0x00]

v_max_f32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x20,0xd2,0xc1,0x04,0x02,0x00]

v_max_f32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x20,0xd2,0xf0,0x04,0x02,0x00]

v_max_f32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x20,0xd2,0xf7,0x04,0x02,0x00]

v_max_f32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x20,0xd2,0x01,0xff,0x03,0x00]

v_max_f32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x20,0xd2,0x01,0x05,0x00,0x00]

v_max_f32_e64 v5, v1, s103
// CHECK: [0x05,0x00,0x20,0xd2,0x01,0xcf,0x00,0x00]

v_max_f32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x20,0xd2,0x01,0xd1,0x00,0x00]

v_max_f32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x20,0xd2,0x01,0xd3,0x00,0x00]

v_max_f32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x20,0xd2,0x01,0xd5,0x00,0x00]

v_max_f32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x20,0xd2,0x01,0xd7,0x00,0x00]

v_max_f32_e64 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x20,0xd2,0x01,0xd9,0x00,0x00]

v_max_f32_e64 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x20,0xd2,0x01,0xdb,0x00,0x00]

v_max_f32_e64 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x20,0xd2,0x01,0xdd,0x00,0x00]

v_max_f32_e64 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x20,0xd2,0x01,0xdf,0x00,0x00]

v_max_f32_e64 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x20,0xd2,0x01,0xf7,0x00,0x00]

v_max_f32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x20,0xd2,0x01,0xf9,0x00,0x00]

v_max_f32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x20,0xd2,0x01,0xfd,0x00,0x00]

v_max_f32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x20,0xd2,0x01,0xff,0x00,0x00]

v_max_f32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x20,0xd2,0x01,0x01,0x01,0x00]

v_max_f32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x20,0xd2,0x01,0x83,0x01,0x00]

v_max_f32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x20,0xd2,0x01,0xe1,0x01,0x00]

v_max_f32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x20,0xd2,0x01,0xef,0x01,0x00]

v_max_f32_e64 v5, -v1, v2
// CHECK: [0x05,0x00,0x20,0xd2,0x01,0x05,0x02,0x20]

v_max_f32_e64 v5, v1, -v2
// CHECK: [0x05,0x00,0x20,0xd2,0x01,0x05,0x02,0x40]

v_max_f32_e64 v5, -v1, -v2
// CHECK: [0x05,0x00,0x20,0xd2,0x01,0x05,0x02,0x60]

v_max_f32_e64 v5, |v1|, v2
// CHECK: [0x05,0x01,0x20,0xd2,0x01,0x05,0x02,0x00]

v_max_f32_e64 v5, v1, |v2|
// CHECK: [0x05,0x02,0x20,0xd2,0x01,0x05,0x02,0x00]

v_max_f32_e64 v5, |v1|, |v2|
// CHECK: [0x05,0x03,0x20,0xd2,0x01,0x05,0x02,0x00]

v_max_f32_e64 v5, v1, v2 clamp
// CHECK: [0x05,0x08,0x20,0xd2,0x01,0x05,0x02,0x00]

v_max_f32_e64 v5, v1, v2 mul:2
// CHECK: [0x05,0x00,0x20,0xd2,0x01,0x05,0x02,0x08]

v_max_f32_e64 v5, v1, v2 mul:4
// CHECK: [0x05,0x00,0x20,0xd2,0x01,0x05,0x02,0x10]

v_max_f32_e64 v5, v1, v2 div:2
// CHECK: [0x05,0x00,0x20,0xd2,0x01,0x05,0x02,0x18]

v_min_i32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x22]

v_min_i32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x23]

v_min_i32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x22]

v_min_i32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x22]

v_min_i32 v5, s103, v2
// CHECK: [0x67,0x04,0x0a,0x22]

v_min_i32 v5, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0a,0x22]

v_min_i32 v5, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0a,0x22]

v_min_i32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x22]

v_min_i32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x22]

v_min_i32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x22]

v_min_i32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x22]

v_min_i32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x22]

v_min_i32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x22]

v_min_i32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x22]

v_min_i32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x22]

v_min_i32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x22]

v_min_i32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x22]

v_min_i32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x22]

v_min_i32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x22]

v_min_i32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x22]

v_min_i32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x22]

v_min_i32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x22,0x56,0x34,0x12,0xaf]

v_min_i32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x22,0x73,0x72,0x71,0x3f]

v_min_i32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x22]

v_min_i32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x22,0xd2,0x01,0x05,0x02,0x00]

v_min_i32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x22,0xd2,0x01,0x05,0x02,0x00]

v_min_i32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x22,0xd2,0xff,0x05,0x02,0x00]

v_min_i32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x22,0xd2,0x01,0x04,0x02,0x00]

v_min_i32_e64 v5, s103, v2
// CHECK: [0x05,0x00,0x22,0xd2,0x67,0x04,0x02,0x00]

v_min_i32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x22,0xd2,0x68,0x04,0x02,0x00]

v_min_i32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x22,0xd2,0x69,0x04,0x02,0x00]

v_min_i32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x22,0xd2,0x6a,0x04,0x02,0x00]

v_min_i32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x22,0xd2,0x6b,0x04,0x02,0x00]

v_min_i32_e64 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x22,0xd2,0x6c,0x04,0x02,0x00]

v_min_i32_e64 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x22,0xd2,0x6d,0x04,0x02,0x00]

v_min_i32_e64 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x22,0xd2,0x6e,0x04,0x02,0x00]

v_min_i32_e64 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x22,0xd2,0x6f,0x04,0x02,0x00]

v_min_i32_e64 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x22,0xd2,0x7b,0x04,0x02,0x00]

v_min_i32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x22,0xd2,0x7c,0x04,0x02,0x00]

v_min_i32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x22,0xd2,0x7e,0x04,0x02,0x00]

v_min_i32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x22,0xd2,0x7f,0x04,0x02,0x00]

v_min_i32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x22,0xd2,0x80,0x04,0x02,0x00]

v_min_i32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x22,0xd2,0xc1,0x04,0x02,0x00]

v_min_i32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x22,0xd2,0xf0,0x04,0x02,0x00]

v_min_i32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x22,0xd2,0xf7,0x04,0x02,0x00]

v_min_i32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x22,0xd2,0x01,0xff,0x03,0x00]

v_min_i32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x22,0xd2,0x01,0x05,0x00,0x00]

v_min_i32_e64 v5, v1, s103
// CHECK: [0x05,0x00,0x22,0xd2,0x01,0xcf,0x00,0x00]

v_min_i32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x22,0xd2,0x01,0xd1,0x00,0x00]

v_min_i32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x22,0xd2,0x01,0xd3,0x00,0x00]

v_min_i32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x22,0xd2,0x01,0xd5,0x00,0x00]

v_min_i32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x22,0xd2,0x01,0xd7,0x00,0x00]

v_min_i32_e64 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x22,0xd2,0x01,0xd9,0x00,0x00]

v_min_i32_e64 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x22,0xd2,0x01,0xdb,0x00,0x00]

v_min_i32_e64 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x22,0xd2,0x01,0xdd,0x00,0x00]

v_min_i32_e64 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x22,0xd2,0x01,0xdf,0x00,0x00]

v_min_i32_e64 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x22,0xd2,0x01,0xf7,0x00,0x00]

v_min_i32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x22,0xd2,0x01,0xf9,0x00,0x00]

v_min_i32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x22,0xd2,0x01,0xfd,0x00,0x00]

v_min_i32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x22,0xd2,0x01,0xff,0x00,0x00]

v_min_i32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x22,0xd2,0x01,0x01,0x01,0x00]

v_min_i32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x22,0xd2,0x01,0x83,0x01,0x00]

v_min_i32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x22,0xd2,0x01,0xe1,0x01,0x00]

v_min_i32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x22,0xd2,0x01,0xef,0x01,0x00]

v_max_i32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x24]

v_max_i32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x25]

v_max_i32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x24]

v_max_i32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x24]

v_max_i32 v5, s103, v2
// CHECK: [0x67,0x04,0x0a,0x24]

v_max_i32 v5, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0a,0x24]

v_max_i32 v5, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0a,0x24]

v_max_i32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x24]

v_max_i32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x24]

v_max_i32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x24]

v_max_i32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x24]

v_max_i32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x24]

v_max_i32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x24]

v_max_i32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x24]

v_max_i32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x24]

v_max_i32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x24]

v_max_i32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x24]

v_max_i32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x24]

v_max_i32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x24]

v_max_i32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x24]

v_max_i32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x24]

v_max_i32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x24,0x56,0x34,0x12,0xaf]

v_max_i32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x24,0x73,0x72,0x71,0x3f]

v_max_i32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x24]

v_max_i32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x24,0xd2,0x01,0x05,0x02,0x00]

v_max_i32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x24,0xd2,0x01,0x05,0x02,0x00]

v_max_i32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x24,0xd2,0xff,0x05,0x02,0x00]

v_max_i32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x24,0xd2,0x01,0x04,0x02,0x00]

v_max_i32_e64 v5, s103, v2
// CHECK: [0x05,0x00,0x24,0xd2,0x67,0x04,0x02,0x00]

v_max_i32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x24,0xd2,0x68,0x04,0x02,0x00]

v_max_i32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x24,0xd2,0x69,0x04,0x02,0x00]

v_max_i32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x24,0xd2,0x6a,0x04,0x02,0x00]

v_max_i32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x24,0xd2,0x6b,0x04,0x02,0x00]

v_max_i32_e64 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x24,0xd2,0x6c,0x04,0x02,0x00]

v_max_i32_e64 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x24,0xd2,0x6d,0x04,0x02,0x00]

v_max_i32_e64 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x24,0xd2,0x6e,0x04,0x02,0x00]

v_max_i32_e64 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x24,0xd2,0x6f,0x04,0x02,0x00]

v_max_i32_e64 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x24,0xd2,0x7b,0x04,0x02,0x00]

v_max_i32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x24,0xd2,0x7c,0x04,0x02,0x00]

v_max_i32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x24,0xd2,0x7e,0x04,0x02,0x00]

v_max_i32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x24,0xd2,0x7f,0x04,0x02,0x00]

v_max_i32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x24,0xd2,0x80,0x04,0x02,0x00]

v_max_i32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x24,0xd2,0xc1,0x04,0x02,0x00]

v_max_i32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x24,0xd2,0xf0,0x04,0x02,0x00]

v_max_i32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x24,0xd2,0xf7,0x04,0x02,0x00]

v_max_i32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x24,0xd2,0x01,0xff,0x03,0x00]

v_max_i32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x24,0xd2,0x01,0x05,0x00,0x00]

v_max_i32_e64 v5, v1, s103
// CHECK: [0x05,0x00,0x24,0xd2,0x01,0xcf,0x00,0x00]

v_max_i32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x24,0xd2,0x01,0xd1,0x00,0x00]

v_max_i32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x24,0xd2,0x01,0xd3,0x00,0x00]

v_max_i32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x24,0xd2,0x01,0xd5,0x00,0x00]

v_max_i32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x24,0xd2,0x01,0xd7,0x00,0x00]

v_max_i32_e64 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x24,0xd2,0x01,0xd9,0x00,0x00]

v_max_i32_e64 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x24,0xd2,0x01,0xdb,0x00,0x00]

v_max_i32_e64 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x24,0xd2,0x01,0xdd,0x00,0x00]

v_max_i32_e64 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x24,0xd2,0x01,0xdf,0x00,0x00]

v_max_i32_e64 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x24,0xd2,0x01,0xf7,0x00,0x00]

v_max_i32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x24,0xd2,0x01,0xf9,0x00,0x00]

v_max_i32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x24,0xd2,0x01,0xfd,0x00,0x00]

v_max_i32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x24,0xd2,0x01,0xff,0x00,0x00]

v_max_i32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x24,0xd2,0x01,0x01,0x01,0x00]

v_max_i32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x24,0xd2,0x01,0x83,0x01,0x00]

v_max_i32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x24,0xd2,0x01,0xe1,0x01,0x00]

v_max_i32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x24,0xd2,0x01,0xef,0x01,0x00]

v_min_u32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x26]

v_min_u32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x27]

v_min_u32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x26]

v_min_u32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x26]

v_min_u32 v5, s103, v2
// CHECK: [0x67,0x04,0x0a,0x26]

v_min_u32 v5, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0a,0x26]

v_min_u32 v5, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0a,0x26]

v_min_u32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x26]

v_min_u32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x26]

v_min_u32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x26]

v_min_u32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x26]

v_min_u32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x26]

v_min_u32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x26]

v_min_u32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x26]

v_min_u32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x26]

v_min_u32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x26]

v_min_u32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x26]

v_min_u32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x26]

v_min_u32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x26]

v_min_u32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x26]

v_min_u32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x26]

v_min_u32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x26,0x56,0x34,0x12,0xaf]

v_min_u32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x26,0x73,0x72,0x71,0x3f]

v_min_u32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x26]

v_min_u32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x26,0xd2,0x01,0x05,0x02,0x00]

v_min_u32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x26,0xd2,0x01,0x05,0x02,0x00]

v_min_u32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x26,0xd2,0xff,0x05,0x02,0x00]

v_min_u32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x26,0xd2,0x01,0x04,0x02,0x00]

v_min_u32_e64 v5, s103, v2
// CHECK: [0x05,0x00,0x26,0xd2,0x67,0x04,0x02,0x00]

v_min_u32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x26,0xd2,0x68,0x04,0x02,0x00]

v_min_u32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x26,0xd2,0x69,0x04,0x02,0x00]

v_min_u32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x26,0xd2,0x6a,0x04,0x02,0x00]

v_min_u32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x26,0xd2,0x6b,0x04,0x02,0x00]

v_min_u32_e64 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x26,0xd2,0x6c,0x04,0x02,0x00]

v_min_u32_e64 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x26,0xd2,0x6d,0x04,0x02,0x00]

v_min_u32_e64 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x26,0xd2,0x6e,0x04,0x02,0x00]

v_min_u32_e64 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x26,0xd2,0x6f,0x04,0x02,0x00]

v_min_u32_e64 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x26,0xd2,0x7b,0x04,0x02,0x00]

v_min_u32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x26,0xd2,0x7c,0x04,0x02,0x00]

v_min_u32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x26,0xd2,0x7e,0x04,0x02,0x00]

v_min_u32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x26,0xd2,0x7f,0x04,0x02,0x00]

v_min_u32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x26,0xd2,0x80,0x04,0x02,0x00]

v_min_u32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x26,0xd2,0xc1,0x04,0x02,0x00]

v_min_u32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x26,0xd2,0xf0,0x04,0x02,0x00]

v_min_u32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x26,0xd2,0xf7,0x04,0x02,0x00]

v_min_u32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x26,0xd2,0x01,0xff,0x03,0x00]

v_min_u32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x26,0xd2,0x01,0x05,0x00,0x00]

v_min_u32_e64 v5, v1, s103
// CHECK: [0x05,0x00,0x26,0xd2,0x01,0xcf,0x00,0x00]

v_min_u32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x26,0xd2,0x01,0xd1,0x00,0x00]

v_min_u32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x26,0xd2,0x01,0xd3,0x00,0x00]

v_min_u32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x26,0xd2,0x01,0xd5,0x00,0x00]

v_min_u32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x26,0xd2,0x01,0xd7,0x00,0x00]

v_min_u32_e64 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x26,0xd2,0x01,0xd9,0x00,0x00]

v_min_u32_e64 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x26,0xd2,0x01,0xdb,0x00,0x00]

v_min_u32_e64 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x26,0xd2,0x01,0xdd,0x00,0x00]

v_min_u32_e64 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x26,0xd2,0x01,0xdf,0x00,0x00]

v_min_u32_e64 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x26,0xd2,0x01,0xf7,0x00,0x00]

v_min_u32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x26,0xd2,0x01,0xf9,0x00,0x00]

v_min_u32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x26,0xd2,0x01,0xfd,0x00,0x00]

v_min_u32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x26,0xd2,0x01,0xff,0x00,0x00]

v_min_u32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x26,0xd2,0x01,0x01,0x01,0x00]

v_min_u32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x26,0xd2,0x01,0x83,0x01,0x00]

v_min_u32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x26,0xd2,0x01,0xe1,0x01,0x00]

v_min_u32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x26,0xd2,0x01,0xef,0x01,0x00]

v_max_u32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x28]

v_max_u32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x29]

v_max_u32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x28]

v_max_u32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x28]

v_max_u32 v5, s103, v2
// CHECK: [0x67,0x04,0x0a,0x28]

v_max_u32 v5, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0a,0x28]

v_max_u32 v5, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0a,0x28]

v_max_u32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x28]

v_max_u32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x28]

v_max_u32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x28]

v_max_u32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x28]

v_max_u32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x28]

v_max_u32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x28]

v_max_u32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x28]

v_max_u32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x28]

v_max_u32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x28]

v_max_u32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x28]

v_max_u32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x28]

v_max_u32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x28]

v_max_u32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x28]

v_max_u32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x28]

v_max_u32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x28,0x56,0x34,0x12,0xaf]

v_max_u32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x28,0x73,0x72,0x71,0x3f]

v_max_u32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x28]

v_max_u32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x28,0xd2,0x01,0x05,0x02,0x00]

v_max_u32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x28,0xd2,0x01,0x05,0x02,0x00]

v_max_u32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x28,0xd2,0xff,0x05,0x02,0x00]

v_max_u32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x28,0xd2,0x01,0x04,0x02,0x00]

v_max_u32_e64 v5, s103, v2
// CHECK: [0x05,0x00,0x28,0xd2,0x67,0x04,0x02,0x00]

v_max_u32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x28,0xd2,0x68,0x04,0x02,0x00]

v_max_u32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x28,0xd2,0x69,0x04,0x02,0x00]

v_max_u32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x28,0xd2,0x6a,0x04,0x02,0x00]

v_max_u32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x28,0xd2,0x6b,0x04,0x02,0x00]

v_max_u32_e64 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x28,0xd2,0x6c,0x04,0x02,0x00]

v_max_u32_e64 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x28,0xd2,0x6d,0x04,0x02,0x00]

v_max_u32_e64 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x28,0xd2,0x6e,0x04,0x02,0x00]

v_max_u32_e64 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x28,0xd2,0x6f,0x04,0x02,0x00]

v_max_u32_e64 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x28,0xd2,0x7b,0x04,0x02,0x00]

v_max_u32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x28,0xd2,0x7c,0x04,0x02,0x00]

v_max_u32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x28,0xd2,0x7e,0x04,0x02,0x00]

v_max_u32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x28,0xd2,0x7f,0x04,0x02,0x00]

v_max_u32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x28,0xd2,0x80,0x04,0x02,0x00]

v_max_u32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x28,0xd2,0xc1,0x04,0x02,0x00]

v_max_u32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x28,0xd2,0xf0,0x04,0x02,0x00]

v_max_u32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x28,0xd2,0xf7,0x04,0x02,0x00]

v_max_u32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x28,0xd2,0x01,0xff,0x03,0x00]

v_max_u32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x28,0xd2,0x01,0x05,0x00,0x00]

v_max_u32_e64 v5, v1, s103
// CHECK: [0x05,0x00,0x28,0xd2,0x01,0xcf,0x00,0x00]

v_max_u32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x28,0xd2,0x01,0xd1,0x00,0x00]

v_max_u32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x28,0xd2,0x01,0xd3,0x00,0x00]

v_max_u32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x28,0xd2,0x01,0xd5,0x00,0x00]

v_max_u32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x28,0xd2,0x01,0xd7,0x00,0x00]

v_max_u32_e64 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x28,0xd2,0x01,0xd9,0x00,0x00]

v_max_u32_e64 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x28,0xd2,0x01,0xdb,0x00,0x00]

v_max_u32_e64 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x28,0xd2,0x01,0xdd,0x00,0x00]

v_max_u32_e64 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x28,0xd2,0x01,0xdf,0x00,0x00]

v_max_u32_e64 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x28,0xd2,0x01,0xf7,0x00,0x00]

v_max_u32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x28,0xd2,0x01,0xf9,0x00,0x00]

v_max_u32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x28,0xd2,0x01,0xfd,0x00,0x00]

v_max_u32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x28,0xd2,0x01,0xff,0x00,0x00]

v_max_u32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x28,0xd2,0x01,0x01,0x01,0x00]

v_max_u32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x28,0xd2,0x01,0x83,0x01,0x00]

v_max_u32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x28,0xd2,0x01,0xe1,0x01,0x00]

v_max_u32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x28,0xd2,0x01,0xef,0x01,0x00]

v_lshr_b32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x2a]

v_lshr_b32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x2b]

v_lshr_b32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x2a]

v_lshr_b32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x2a]

v_lshr_b32 v5, s103, v2
// CHECK: [0x67,0x04,0x0a,0x2a]

v_lshr_b32 v5, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0a,0x2a]

v_lshr_b32 v5, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0a,0x2a]

v_lshr_b32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x2a]

v_lshr_b32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x2a]

v_lshr_b32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x2a]

v_lshr_b32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x2a]

v_lshr_b32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x2a]

v_lshr_b32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x2a]

v_lshr_b32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x2a]

v_lshr_b32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x2a]

v_lshr_b32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x2a]

v_lshr_b32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x2a]

v_lshr_b32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x2a]

v_lshr_b32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x2a]

v_lshr_b32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x2a]

v_lshr_b32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x2a]

v_lshr_b32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x2a,0x56,0x34,0x12,0xaf]

v_lshr_b32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x2a,0x73,0x72,0x71,0x3f]

v_lshr_b32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x2a]

v_lshr_b32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x2a,0xd2,0x01,0x05,0x02,0x00]

v_lshr_b32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x2a,0xd2,0x01,0x05,0x02,0x00]

v_lshr_b32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x2a,0xd2,0xff,0x05,0x02,0x00]

v_lshr_b32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x2a,0xd2,0x01,0x04,0x02,0x00]

v_lshr_b32_e64 v5, s103, v2
// CHECK: [0x05,0x00,0x2a,0xd2,0x67,0x04,0x02,0x00]

v_lshr_b32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x2a,0xd2,0x68,0x04,0x02,0x00]

v_lshr_b32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x2a,0xd2,0x69,0x04,0x02,0x00]

v_lshr_b32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x2a,0xd2,0x6a,0x04,0x02,0x00]

v_lshr_b32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x2a,0xd2,0x6b,0x04,0x02,0x00]

v_lshr_b32_e64 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x2a,0xd2,0x6c,0x04,0x02,0x00]

v_lshr_b32_e64 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x2a,0xd2,0x6d,0x04,0x02,0x00]

v_lshr_b32_e64 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x2a,0xd2,0x6e,0x04,0x02,0x00]

v_lshr_b32_e64 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x2a,0xd2,0x6f,0x04,0x02,0x00]

v_lshr_b32_e64 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x2a,0xd2,0x7b,0x04,0x02,0x00]

v_lshr_b32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x2a,0xd2,0x7c,0x04,0x02,0x00]

v_lshr_b32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x2a,0xd2,0x7e,0x04,0x02,0x00]

v_lshr_b32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x2a,0xd2,0x7f,0x04,0x02,0x00]

v_lshr_b32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x2a,0xd2,0x80,0x04,0x02,0x00]

v_lshr_b32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x2a,0xd2,0xc1,0x04,0x02,0x00]

v_lshr_b32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x2a,0xd2,0xf0,0x04,0x02,0x00]

v_lshr_b32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x2a,0xd2,0xf7,0x04,0x02,0x00]

v_lshr_b32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x2a,0xd2,0x01,0xff,0x03,0x00]

v_lshr_b32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x2a,0xd2,0x01,0x05,0x00,0x00]

v_lshr_b32_e64 v5, v1, s103
// CHECK: [0x05,0x00,0x2a,0xd2,0x01,0xcf,0x00,0x00]

v_lshr_b32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x2a,0xd2,0x01,0xd1,0x00,0x00]

v_lshr_b32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x2a,0xd2,0x01,0xd3,0x00,0x00]

v_lshr_b32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x2a,0xd2,0x01,0xd5,0x00,0x00]

v_lshr_b32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x2a,0xd2,0x01,0xd7,0x00,0x00]

v_lshr_b32_e64 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x2a,0xd2,0x01,0xd9,0x00,0x00]

v_lshr_b32_e64 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x2a,0xd2,0x01,0xdb,0x00,0x00]

v_lshr_b32_e64 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x2a,0xd2,0x01,0xdd,0x00,0x00]

v_lshr_b32_e64 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x2a,0xd2,0x01,0xdf,0x00,0x00]

v_lshr_b32_e64 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x2a,0xd2,0x01,0xf7,0x00,0x00]

v_lshr_b32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x2a,0xd2,0x01,0xf9,0x00,0x00]

v_lshr_b32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x2a,0xd2,0x01,0xfd,0x00,0x00]

v_lshr_b32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x2a,0xd2,0x01,0xff,0x00,0x00]

v_lshr_b32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x2a,0xd2,0x01,0x01,0x01,0x00]

v_lshr_b32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x2a,0xd2,0x01,0x83,0x01,0x00]

v_lshr_b32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x2a,0xd2,0x01,0xe1,0x01,0x00]

v_lshr_b32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x2a,0xd2,0x01,0xef,0x01,0x00]

v_lshrrev_b32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x2c]

v_lshrrev_b32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x2d]

v_lshrrev_b32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x2c]

v_lshrrev_b32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x2c]

v_lshrrev_b32 v5, s103, v2
// CHECK: [0x67,0x04,0x0a,0x2c]

v_lshrrev_b32 v5, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0a,0x2c]

v_lshrrev_b32 v5, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0a,0x2c]

v_lshrrev_b32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x2c]

v_lshrrev_b32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x2c]

v_lshrrev_b32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x2c]

v_lshrrev_b32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x2c]

v_lshrrev_b32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x2c]

v_lshrrev_b32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x2c]

v_lshrrev_b32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x2c]

v_lshrrev_b32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x2c]

v_lshrrev_b32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x2c]

v_lshrrev_b32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x2c]

v_lshrrev_b32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x2c]

v_lshrrev_b32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x2c]

v_lshrrev_b32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x2c]

v_lshrrev_b32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x2c]

v_lshrrev_b32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x2c,0x56,0x34,0x12,0xaf]

v_lshrrev_b32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x2c,0x73,0x72,0x71,0x3f]

v_lshrrev_b32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x2c]

v_lshrrev_b32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x2c,0xd2,0x01,0x05,0x02,0x00]

v_lshrrev_b32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x2c,0xd2,0x01,0x05,0x02,0x00]

v_lshrrev_b32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x2c,0xd2,0xff,0x05,0x02,0x00]

v_lshrrev_b32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x2c,0xd2,0x01,0x04,0x02,0x00]

v_lshrrev_b32_e64 v5, s103, v2
// CHECK: [0x05,0x00,0x2c,0xd2,0x67,0x04,0x02,0x00]

v_lshrrev_b32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x2c,0xd2,0x68,0x04,0x02,0x00]

v_lshrrev_b32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x2c,0xd2,0x69,0x04,0x02,0x00]

v_lshrrev_b32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x2c,0xd2,0x6a,0x04,0x02,0x00]

v_lshrrev_b32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x2c,0xd2,0x6b,0x04,0x02,0x00]

v_lshrrev_b32_e64 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x2c,0xd2,0x6c,0x04,0x02,0x00]

v_lshrrev_b32_e64 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x2c,0xd2,0x6d,0x04,0x02,0x00]

v_lshrrev_b32_e64 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x2c,0xd2,0x6e,0x04,0x02,0x00]

v_lshrrev_b32_e64 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x2c,0xd2,0x6f,0x04,0x02,0x00]

v_lshrrev_b32_e64 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x2c,0xd2,0x7b,0x04,0x02,0x00]

v_lshrrev_b32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x2c,0xd2,0x7c,0x04,0x02,0x00]

v_lshrrev_b32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x2c,0xd2,0x7e,0x04,0x02,0x00]

v_lshrrev_b32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x2c,0xd2,0x7f,0x04,0x02,0x00]

v_lshrrev_b32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x2c,0xd2,0x80,0x04,0x02,0x00]

v_lshrrev_b32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x2c,0xd2,0xc1,0x04,0x02,0x00]

v_lshrrev_b32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x2c,0xd2,0xf0,0x04,0x02,0x00]

v_lshrrev_b32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x2c,0xd2,0xf7,0x04,0x02,0x00]

v_lshrrev_b32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x2c,0xd2,0x01,0xff,0x03,0x00]

v_lshrrev_b32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x2c,0xd2,0x01,0x05,0x00,0x00]

v_lshrrev_b32_e64 v5, v1, s103
// CHECK: [0x05,0x00,0x2c,0xd2,0x01,0xcf,0x00,0x00]

v_lshrrev_b32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x2c,0xd2,0x01,0xd1,0x00,0x00]

v_lshrrev_b32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x2c,0xd2,0x01,0xd3,0x00,0x00]

v_lshrrev_b32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x2c,0xd2,0x01,0xd5,0x00,0x00]

v_lshrrev_b32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x2c,0xd2,0x01,0xd7,0x00,0x00]

v_lshrrev_b32_e64 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x2c,0xd2,0x01,0xd9,0x00,0x00]

v_lshrrev_b32_e64 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x2c,0xd2,0x01,0xdb,0x00,0x00]

v_lshrrev_b32_e64 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x2c,0xd2,0x01,0xdd,0x00,0x00]

v_lshrrev_b32_e64 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x2c,0xd2,0x01,0xdf,0x00,0x00]

v_lshrrev_b32_e64 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x2c,0xd2,0x01,0xf7,0x00,0x00]

v_lshrrev_b32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x2c,0xd2,0x01,0xf9,0x00,0x00]

v_lshrrev_b32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x2c,0xd2,0x01,0xfd,0x00,0x00]

v_lshrrev_b32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x2c,0xd2,0x01,0xff,0x00,0x00]

v_lshrrev_b32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x2c,0xd2,0x01,0x01,0x01,0x00]

v_lshrrev_b32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x2c,0xd2,0x01,0x83,0x01,0x00]

v_lshrrev_b32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x2c,0xd2,0x01,0xe1,0x01,0x00]

v_lshrrev_b32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x2c,0xd2,0x01,0xef,0x01,0x00]

v_ashr_i32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x2e]

v_ashr_i32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x2f]

v_ashr_i32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x2e]

v_ashr_i32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x2e]

v_ashr_i32 v5, s103, v2
// CHECK: [0x67,0x04,0x0a,0x2e]

v_ashr_i32 v5, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0a,0x2e]

v_ashr_i32 v5, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0a,0x2e]

v_ashr_i32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x2e]

v_ashr_i32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x2e]

v_ashr_i32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x2e]

v_ashr_i32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x2e]

v_ashr_i32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x2e]

v_ashr_i32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x2e]

v_ashr_i32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x2e]

v_ashr_i32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x2e]

v_ashr_i32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x2e]

v_ashr_i32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x2e]

v_ashr_i32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x2e]

v_ashr_i32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x2e]

v_ashr_i32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x2e]

v_ashr_i32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x2e]

v_ashr_i32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x2e,0x56,0x34,0x12,0xaf]

v_ashr_i32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x2e,0x73,0x72,0x71,0x3f]

v_ashr_i32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x2e]

v_ashr_i32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x2e,0xd2,0x01,0x05,0x02,0x00]

v_ashr_i32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x2e,0xd2,0x01,0x05,0x02,0x00]

v_ashr_i32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x2e,0xd2,0xff,0x05,0x02,0x00]

v_ashr_i32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x2e,0xd2,0x01,0x04,0x02,0x00]

v_ashr_i32_e64 v5, s103, v2
// CHECK: [0x05,0x00,0x2e,0xd2,0x67,0x04,0x02,0x00]

v_ashr_i32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x2e,0xd2,0x68,0x04,0x02,0x00]

v_ashr_i32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x2e,0xd2,0x69,0x04,0x02,0x00]

v_ashr_i32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x2e,0xd2,0x6a,0x04,0x02,0x00]

v_ashr_i32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x2e,0xd2,0x6b,0x04,0x02,0x00]

v_ashr_i32_e64 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x2e,0xd2,0x6c,0x04,0x02,0x00]

v_ashr_i32_e64 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x2e,0xd2,0x6d,0x04,0x02,0x00]

v_ashr_i32_e64 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x2e,0xd2,0x6e,0x04,0x02,0x00]

v_ashr_i32_e64 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x2e,0xd2,0x6f,0x04,0x02,0x00]

v_ashr_i32_e64 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x2e,0xd2,0x7b,0x04,0x02,0x00]

v_ashr_i32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x2e,0xd2,0x7c,0x04,0x02,0x00]

v_ashr_i32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x2e,0xd2,0x7e,0x04,0x02,0x00]

v_ashr_i32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x2e,0xd2,0x7f,0x04,0x02,0x00]

v_ashr_i32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x2e,0xd2,0x80,0x04,0x02,0x00]

v_ashr_i32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x2e,0xd2,0xc1,0x04,0x02,0x00]

v_ashr_i32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x2e,0xd2,0xf0,0x04,0x02,0x00]

v_ashr_i32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x2e,0xd2,0xf7,0x04,0x02,0x00]

v_ashr_i32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x2e,0xd2,0x01,0xff,0x03,0x00]

v_ashr_i32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x2e,0xd2,0x01,0x05,0x00,0x00]

v_ashr_i32_e64 v5, v1, s103
// CHECK: [0x05,0x00,0x2e,0xd2,0x01,0xcf,0x00,0x00]

v_ashr_i32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x2e,0xd2,0x01,0xd1,0x00,0x00]

v_ashr_i32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x2e,0xd2,0x01,0xd3,0x00,0x00]

v_ashr_i32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x2e,0xd2,0x01,0xd5,0x00,0x00]

v_ashr_i32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x2e,0xd2,0x01,0xd7,0x00,0x00]

v_ashr_i32_e64 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x2e,0xd2,0x01,0xd9,0x00,0x00]

v_ashr_i32_e64 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x2e,0xd2,0x01,0xdb,0x00,0x00]

v_ashr_i32_e64 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x2e,0xd2,0x01,0xdd,0x00,0x00]

v_ashr_i32_e64 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x2e,0xd2,0x01,0xdf,0x00,0x00]

v_ashr_i32_e64 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x2e,0xd2,0x01,0xf7,0x00,0x00]

v_ashr_i32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x2e,0xd2,0x01,0xf9,0x00,0x00]

v_ashr_i32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x2e,0xd2,0x01,0xfd,0x00,0x00]

v_ashr_i32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x2e,0xd2,0x01,0xff,0x00,0x00]

v_ashr_i32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x2e,0xd2,0x01,0x01,0x01,0x00]

v_ashr_i32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x2e,0xd2,0x01,0x83,0x01,0x00]

v_ashr_i32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x2e,0xd2,0x01,0xe1,0x01,0x00]

v_ashr_i32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x2e,0xd2,0x01,0xef,0x01,0x00]

v_ashrrev_i32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x30]

v_ashrrev_i32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x31]

v_ashrrev_i32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x30]

v_ashrrev_i32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x30]

v_ashrrev_i32 v5, s103, v2
// CHECK: [0x67,0x04,0x0a,0x30]

v_ashrrev_i32 v5, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0a,0x30]

v_ashrrev_i32 v5, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0a,0x30]

v_ashrrev_i32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x30]

v_ashrrev_i32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x30]

v_ashrrev_i32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x30]

v_ashrrev_i32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x30]

v_ashrrev_i32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x30]

v_ashrrev_i32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x30]

v_ashrrev_i32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x30]

v_ashrrev_i32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x30]

v_ashrrev_i32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x30]

v_ashrrev_i32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x30]

v_ashrrev_i32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x30]

v_ashrrev_i32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x30]

v_ashrrev_i32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x30]

v_ashrrev_i32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x30]

v_ashrrev_i32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x30,0x56,0x34,0x12,0xaf]

v_ashrrev_i32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x30,0x73,0x72,0x71,0x3f]

v_ashrrev_i32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x30]

v_ashrrev_i32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x30,0xd2,0x01,0x05,0x02,0x00]

v_ashrrev_i32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x30,0xd2,0x01,0x05,0x02,0x00]

v_ashrrev_i32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x30,0xd2,0xff,0x05,0x02,0x00]

v_ashrrev_i32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x30,0xd2,0x01,0x04,0x02,0x00]

v_ashrrev_i32_e64 v5, s103, v2
// CHECK: [0x05,0x00,0x30,0xd2,0x67,0x04,0x02,0x00]

v_ashrrev_i32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x30,0xd2,0x68,0x04,0x02,0x00]

v_ashrrev_i32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x30,0xd2,0x69,0x04,0x02,0x00]

v_ashrrev_i32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x30,0xd2,0x6a,0x04,0x02,0x00]

v_ashrrev_i32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x30,0xd2,0x6b,0x04,0x02,0x00]

v_ashrrev_i32_e64 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x30,0xd2,0x6c,0x04,0x02,0x00]

v_ashrrev_i32_e64 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x30,0xd2,0x6d,0x04,0x02,0x00]

v_ashrrev_i32_e64 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x30,0xd2,0x6e,0x04,0x02,0x00]

v_ashrrev_i32_e64 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x30,0xd2,0x6f,0x04,0x02,0x00]

v_ashrrev_i32_e64 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x30,0xd2,0x7b,0x04,0x02,0x00]

v_ashrrev_i32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x30,0xd2,0x7c,0x04,0x02,0x00]

v_ashrrev_i32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x30,0xd2,0x7e,0x04,0x02,0x00]

v_ashrrev_i32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x30,0xd2,0x7f,0x04,0x02,0x00]

v_ashrrev_i32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x30,0xd2,0x80,0x04,0x02,0x00]

v_ashrrev_i32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x30,0xd2,0xc1,0x04,0x02,0x00]

v_ashrrev_i32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x30,0xd2,0xf0,0x04,0x02,0x00]

v_ashrrev_i32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x30,0xd2,0xf7,0x04,0x02,0x00]

v_ashrrev_i32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x30,0xd2,0x01,0xff,0x03,0x00]

v_ashrrev_i32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x30,0xd2,0x01,0x05,0x00,0x00]

v_ashrrev_i32_e64 v5, v1, s103
// CHECK: [0x05,0x00,0x30,0xd2,0x01,0xcf,0x00,0x00]

v_ashrrev_i32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x30,0xd2,0x01,0xd1,0x00,0x00]

v_ashrrev_i32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x30,0xd2,0x01,0xd3,0x00,0x00]

v_ashrrev_i32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x30,0xd2,0x01,0xd5,0x00,0x00]

v_ashrrev_i32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x30,0xd2,0x01,0xd7,0x00,0x00]

v_ashrrev_i32_e64 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x30,0xd2,0x01,0xd9,0x00,0x00]

v_ashrrev_i32_e64 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x30,0xd2,0x01,0xdb,0x00,0x00]

v_ashrrev_i32_e64 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x30,0xd2,0x01,0xdd,0x00,0x00]

v_ashrrev_i32_e64 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x30,0xd2,0x01,0xdf,0x00,0x00]

v_ashrrev_i32_e64 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x30,0xd2,0x01,0xf7,0x00,0x00]

v_ashrrev_i32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x30,0xd2,0x01,0xf9,0x00,0x00]

v_ashrrev_i32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x30,0xd2,0x01,0xfd,0x00,0x00]

v_ashrrev_i32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x30,0xd2,0x01,0xff,0x00,0x00]

v_ashrrev_i32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x30,0xd2,0x01,0x01,0x01,0x00]

v_ashrrev_i32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x30,0xd2,0x01,0x83,0x01,0x00]

v_ashrrev_i32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x30,0xd2,0x01,0xe1,0x01,0x00]

v_ashrrev_i32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x30,0xd2,0x01,0xef,0x01,0x00]

v_lshl_b32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x32]

v_lshl_b32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x33]

v_lshl_b32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x32]

v_lshl_b32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x32]

v_lshl_b32 v5, s103, v2
// CHECK: [0x67,0x04,0x0a,0x32]

v_lshl_b32 v5, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0a,0x32]

v_lshl_b32 v5, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0a,0x32]

v_lshl_b32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x32]

v_lshl_b32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x32]

v_lshl_b32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x32]

v_lshl_b32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x32]

v_lshl_b32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x32]

v_lshl_b32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x32]

v_lshl_b32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x32]

v_lshl_b32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x32]

v_lshl_b32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x32]

v_lshl_b32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x32]

v_lshl_b32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x32]

v_lshl_b32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x32]

v_lshl_b32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x32]

v_lshl_b32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x32]

v_lshl_b32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x32,0x56,0x34,0x12,0xaf]

v_lshl_b32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x32,0x73,0x72,0x71,0x3f]

v_lshl_b32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x32]

v_lshl_b32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x32,0xd2,0x01,0x05,0x02,0x00]

v_lshl_b32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x32,0xd2,0x01,0x05,0x02,0x00]

v_lshl_b32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x32,0xd2,0xff,0x05,0x02,0x00]

v_lshl_b32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x32,0xd2,0x01,0x04,0x02,0x00]

v_lshl_b32_e64 v5, s103, v2
// CHECK: [0x05,0x00,0x32,0xd2,0x67,0x04,0x02,0x00]

v_lshl_b32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x32,0xd2,0x68,0x04,0x02,0x00]

v_lshl_b32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x32,0xd2,0x69,0x04,0x02,0x00]

v_lshl_b32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x32,0xd2,0x6a,0x04,0x02,0x00]

v_lshl_b32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x32,0xd2,0x6b,0x04,0x02,0x00]

v_lshl_b32_e64 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x32,0xd2,0x6c,0x04,0x02,0x00]

v_lshl_b32_e64 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x32,0xd2,0x6d,0x04,0x02,0x00]

v_lshl_b32_e64 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x32,0xd2,0x6e,0x04,0x02,0x00]

v_lshl_b32_e64 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x32,0xd2,0x6f,0x04,0x02,0x00]

v_lshl_b32_e64 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x32,0xd2,0x7b,0x04,0x02,0x00]

v_lshl_b32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x32,0xd2,0x7c,0x04,0x02,0x00]

v_lshl_b32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x32,0xd2,0x7e,0x04,0x02,0x00]

v_lshl_b32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x32,0xd2,0x7f,0x04,0x02,0x00]

v_lshl_b32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x32,0xd2,0x80,0x04,0x02,0x00]

v_lshl_b32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x32,0xd2,0xc1,0x04,0x02,0x00]

v_lshl_b32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x32,0xd2,0xf0,0x04,0x02,0x00]

v_lshl_b32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x32,0xd2,0xf7,0x04,0x02,0x00]

v_lshl_b32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x32,0xd2,0x01,0xff,0x03,0x00]

v_lshl_b32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x32,0xd2,0x01,0x05,0x00,0x00]

v_lshl_b32_e64 v5, v1, s103
// CHECK: [0x05,0x00,0x32,0xd2,0x01,0xcf,0x00,0x00]

v_lshl_b32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x32,0xd2,0x01,0xd1,0x00,0x00]

v_lshl_b32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x32,0xd2,0x01,0xd3,0x00,0x00]

v_lshl_b32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x32,0xd2,0x01,0xd5,0x00,0x00]

v_lshl_b32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x32,0xd2,0x01,0xd7,0x00,0x00]

v_lshl_b32_e64 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x32,0xd2,0x01,0xd9,0x00,0x00]

v_lshl_b32_e64 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x32,0xd2,0x01,0xdb,0x00,0x00]

v_lshl_b32_e64 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x32,0xd2,0x01,0xdd,0x00,0x00]

v_lshl_b32_e64 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x32,0xd2,0x01,0xdf,0x00,0x00]

v_lshl_b32_e64 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x32,0xd2,0x01,0xf7,0x00,0x00]

v_lshl_b32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x32,0xd2,0x01,0xf9,0x00,0x00]

v_lshl_b32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x32,0xd2,0x01,0xfd,0x00,0x00]

v_lshl_b32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x32,0xd2,0x01,0xff,0x00,0x00]

v_lshl_b32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x32,0xd2,0x01,0x01,0x01,0x00]

v_lshl_b32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x32,0xd2,0x01,0x83,0x01,0x00]

v_lshl_b32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x32,0xd2,0x01,0xe1,0x01,0x00]

v_lshl_b32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x32,0xd2,0x01,0xef,0x01,0x00]

v_lshlrev_b32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x34]

v_lshlrev_b32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x35]

v_lshlrev_b32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x34]

v_lshlrev_b32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x34]

v_lshlrev_b32 v5, s103, v2
// CHECK: [0x67,0x04,0x0a,0x34]

v_lshlrev_b32 v5, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0a,0x34]

v_lshlrev_b32 v5, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0a,0x34]

v_lshlrev_b32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x34]

v_lshlrev_b32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x34]

v_lshlrev_b32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x34]

v_lshlrev_b32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x34]

v_lshlrev_b32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x34]

v_lshlrev_b32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x34]

v_lshlrev_b32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x34]

v_lshlrev_b32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x34]

v_lshlrev_b32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x34]

v_lshlrev_b32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x34]

v_lshlrev_b32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x34]

v_lshlrev_b32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x34]

v_lshlrev_b32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x34]

v_lshlrev_b32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x34]

v_lshlrev_b32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x34,0x56,0x34,0x12,0xaf]

v_lshlrev_b32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x34,0x73,0x72,0x71,0x3f]

v_lshlrev_b32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x34]

v_lshlrev_b32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x34,0xd2,0x01,0x05,0x02,0x00]

v_lshlrev_b32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x34,0xd2,0x01,0x05,0x02,0x00]

v_lshlrev_b32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x34,0xd2,0xff,0x05,0x02,0x00]

v_lshlrev_b32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x34,0xd2,0x01,0x04,0x02,0x00]

v_lshlrev_b32_e64 v5, s103, v2
// CHECK: [0x05,0x00,0x34,0xd2,0x67,0x04,0x02,0x00]

v_lshlrev_b32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x34,0xd2,0x68,0x04,0x02,0x00]

v_lshlrev_b32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x34,0xd2,0x69,0x04,0x02,0x00]

v_lshlrev_b32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x34,0xd2,0x6a,0x04,0x02,0x00]

v_lshlrev_b32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x34,0xd2,0x6b,0x04,0x02,0x00]

v_lshlrev_b32_e64 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x34,0xd2,0x6c,0x04,0x02,0x00]

v_lshlrev_b32_e64 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x34,0xd2,0x6d,0x04,0x02,0x00]

v_lshlrev_b32_e64 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x34,0xd2,0x6e,0x04,0x02,0x00]

v_lshlrev_b32_e64 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x34,0xd2,0x6f,0x04,0x02,0x00]

v_lshlrev_b32_e64 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x34,0xd2,0x7b,0x04,0x02,0x00]

v_lshlrev_b32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x34,0xd2,0x7c,0x04,0x02,0x00]

v_lshlrev_b32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x34,0xd2,0x7e,0x04,0x02,0x00]

v_lshlrev_b32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x34,0xd2,0x7f,0x04,0x02,0x00]

v_lshlrev_b32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x34,0xd2,0x80,0x04,0x02,0x00]

v_lshlrev_b32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x34,0xd2,0xc1,0x04,0x02,0x00]

v_lshlrev_b32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x34,0xd2,0xf0,0x04,0x02,0x00]

v_lshlrev_b32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x34,0xd2,0xf7,0x04,0x02,0x00]

v_lshlrev_b32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x34,0xd2,0x01,0xff,0x03,0x00]

v_lshlrev_b32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x34,0xd2,0x01,0x05,0x00,0x00]

v_lshlrev_b32_e64 v5, v1, s103
// CHECK: [0x05,0x00,0x34,0xd2,0x01,0xcf,0x00,0x00]

v_lshlrev_b32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x34,0xd2,0x01,0xd1,0x00,0x00]

v_lshlrev_b32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x34,0xd2,0x01,0xd3,0x00,0x00]

v_lshlrev_b32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x34,0xd2,0x01,0xd5,0x00,0x00]

v_lshlrev_b32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x34,0xd2,0x01,0xd7,0x00,0x00]

v_lshlrev_b32_e64 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x34,0xd2,0x01,0xd9,0x00,0x00]

v_lshlrev_b32_e64 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x34,0xd2,0x01,0xdb,0x00,0x00]

v_lshlrev_b32_e64 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x34,0xd2,0x01,0xdd,0x00,0x00]

v_lshlrev_b32_e64 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x34,0xd2,0x01,0xdf,0x00,0x00]

v_lshlrev_b32_e64 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x34,0xd2,0x01,0xf7,0x00,0x00]

v_lshlrev_b32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x34,0xd2,0x01,0xf9,0x00,0x00]

v_lshlrev_b32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x34,0xd2,0x01,0xfd,0x00,0x00]

v_lshlrev_b32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x34,0xd2,0x01,0xff,0x00,0x00]

v_lshlrev_b32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x34,0xd2,0x01,0x01,0x01,0x00]

v_lshlrev_b32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x34,0xd2,0x01,0x83,0x01,0x00]

v_lshlrev_b32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x34,0xd2,0x01,0xe1,0x01,0x00]

v_lshlrev_b32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x34,0xd2,0x01,0xef,0x01,0x00]

v_and_b32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x36]

v_and_b32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x37]

v_and_b32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x36]

v_and_b32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x36]

v_and_b32 v5, s103, v2
// CHECK: [0x67,0x04,0x0a,0x36]

v_and_b32 v5, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0a,0x36]

v_and_b32 v5, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0a,0x36]

v_and_b32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x36]

v_and_b32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x36]

v_and_b32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x36]

v_and_b32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x36]

v_and_b32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x36]

v_and_b32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x36]

v_and_b32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x36]

v_and_b32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x36]

v_and_b32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x36]

v_and_b32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x36]

v_and_b32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x36]

v_and_b32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x36]

v_and_b32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x36]

v_and_b32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x36]

v_and_b32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x36,0x56,0x34,0x12,0xaf]

v_and_b32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x36,0x73,0x72,0x71,0x3f]

v_and_b32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x36]

v_and_b32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x36,0xd2,0x01,0x05,0x02,0x00]

v_and_b32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x36,0xd2,0x01,0x05,0x02,0x00]

v_and_b32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x36,0xd2,0xff,0x05,0x02,0x00]

v_and_b32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x36,0xd2,0x01,0x04,0x02,0x00]

v_and_b32_e64 v5, s103, v2
// CHECK: [0x05,0x00,0x36,0xd2,0x67,0x04,0x02,0x00]

v_and_b32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x36,0xd2,0x68,0x04,0x02,0x00]

v_and_b32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x36,0xd2,0x69,0x04,0x02,0x00]

v_and_b32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x36,0xd2,0x6a,0x04,0x02,0x00]

v_and_b32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x36,0xd2,0x6b,0x04,0x02,0x00]

v_and_b32_e64 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x36,0xd2,0x6c,0x04,0x02,0x00]

v_and_b32_e64 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x36,0xd2,0x6d,0x04,0x02,0x00]

v_and_b32_e64 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x36,0xd2,0x6e,0x04,0x02,0x00]

v_and_b32_e64 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x36,0xd2,0x6f,0x04,0x02,0x00]

v_and_b32_e64 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x36,0xd2,0x7b,0x04,0x02,0x00]

v_and_b32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x36,0xd2,0x7c,0x04,0x02,0x00]

v_and_b32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x36,0xd2,0x7e,0x04,0x02,0x00]

v_and_b32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x36,0xd2,0x7f,0x04,0x02,0x00]

v_and_b32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x36,0xd2,0x80,0x04,0x02,0x00]

v_and_b32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x36,0xd2,0xc1,0x04,0x02,0x00]

v_and_b32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x36,0xd2,0xf0,0x04,0x02,0x00]

v_and_b32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x36,0xd2,0xf7,0x04,0x02,0x00]

v_and_b32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x36,0xd2,0x01,0xff,0x03,0x00]

v_and_b32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x36,0xd2,0x01,0x05,0x00,0x00]

v_and_b32_e64 v5, v1, s103
// CHECK: [0x05,0x00,0x36,0xd2,0x01,0xcf,0x00,0x00]

v_and_b32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x36,0xd2,0x01,0xd1,0x00,0x00]

v_and_b32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x36,0xd2,0x01,0xd3,0x00,0x00]

v_and_b32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x36,0xd2,0x01,0xd5,0x00,0x00]

v_and_b32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x36,0xd2,0x01,0xd7,0x00,0x00]

v_and_b32_e64 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x36,0xd2,0x01,0xd9,0x00,0x00]

v_and_b32_e64 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x36,0xd2,0x01,0xdb,0x00,0x00]

v_and_b32_e64 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x36,0xd2,0x01,0xdd,0x00,0x00]

v_and_b32_e64 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x36,0xd2,0x01,0xdf,0x00,0x00]

v_and_b32_e64 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x36,0xd2,0x01,0xf7,0x00,0x00]

v_and_b32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x36,0xd2,0x01,0xf9,0x00,0x00]

v_and_b32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x36,0xd2,0x01,0xfd,0x00,0x00]

v_and_b32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x36,0xd2,0x01,0xff,0x00,0x00]

v_and_b32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x36,0xd2,0x01,0x01,0x01,0x00]

v_and_b32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x36,0xd2,0x01,0x83,0x01,0x00]

v_and_b32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x36,0xd2,0x01,0xe1,0x01,0x00]

v_and_b32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x36,0xd2,0x01,0xef,0x01,0x00]

v_or_b32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x38]

v_or_b32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x39]

v_or_b32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x38]

v_or_b32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x38]

v_or_b32 v5, s103, v2
// CHECK: [0x67,0x04,0x0a,0x38]

v_or_b32 v5, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0a,0x38]

v_or_b32 v5, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0a,0x38]

v_or_b32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x38]

v_or_b32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x38]

v_or_b32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x38]

v_or_b32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x38]

v_or_b32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x38]

v_or_b32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x38]

v_or_b32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x38]

v_or_b32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x38]

v_or_b32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x38]

v_or_b32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x38]

v_or_b32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x38]

v_or_b32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x38]

v_or_b32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x38]

v_or_b32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x38]

v_or_b32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x38,0x56,0x34,0x12,0xaf]

v_or_b32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x38,0x73,0x72,0x71,0x3f]

v_or_b32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x38]

v_or_b32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x38,0xd2,0x01,0x05,0x02,0x00]

v_or_b32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x38,0xd2,0x01,0x05,0x02,0x00]

v_or_b32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x38,0xd2,0xff,0x05,0x02,0x00]

v_or_b32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x38,0xd2,0x01,0x04,0x02,0x00]

v_or_b32_e64 v5, s103, v2
// CHECK: [0x05,0x00,0x38,0xd2,0x67,0x04,0x02,0x00]

v_or_b32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x38,0xd2,0x68,0x04,0x02,0x00]

v_or_b32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x38,0xd2,0x69,0x04,0x02,0x00]

v_or_b32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x38,0xd2,0x6a,0x04,0x02,0x00]

v_or_b32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x38,0xd2,0x6b,0x04,0x02,0x00]

v_or_b32_e64 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x38,0xd2,0x6c,0x04,0x02,0x00]

v_or_b32_e64 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x38,0xd2,0x6d,0x04,0x02,0x00]

v_or_b32_e64 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x38,0xd2,0x6e,0x04,0x02,0x00]

v_or_b32_e64 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x38,0xd2,0x6f,0x04,0x02,0x00]

v_or_b32_e64 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x38,0xd2,0x7b,0x04,0x02,0x00]

v_or_b32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x38,0xd2,0x7c,0x04,0x02,0x00]

v_or_b32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x38,0xd2,0x7e,0x04,0x02,0x00]

v_or_b32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x38,0xd2,0x7f,0x04,0x02,0x00]

v_or_b32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x38,0xd2,0x80,0x04,0x02,0x00]

v_or_b32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x38,0xd2,0xc1,0x04,0x02,0x00]

v_or_b32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x38,0xd2,0xf0,0x04,0x02,0x00]

v_or_b32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x38,0xd2,0xf7,0x04,0x02,0x00]

v_or_b32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x38,0xd2,0x01,0xff,0x03,0x00]

v_or_b32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x38,0xd2,0x01,0x05,0x00,0x00]

v_or_b32_e64 v5, v1, s103
// CHECK: [0x05,0x00,0x38,0xd2,0x01,0xcf,0x00,0x00]

v_or_b32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x38,0xd2,0x01,0xd1,0x00,0x00]

v_or_b32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x38,0xd2,0x01,0xd3,0x00,0x00]

v_or_b32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x38,0xd2,0x01,0xd5,0x00,0x00]

v_or_b32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x38,0xd2,0x01,0xd7,0x00,0x00]

v_or_b32_e64 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x38,0xd2,0x01,0xd9,0x00,0x00]

v_or_b32_e64 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x38,0xd2,0x01,0xdb,0x00,0x00]

v_or_b32_e64 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x38,0xd2,0x01,0xdd,0x00,0x00]

v_or_b32_e64 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x38,0xd2,0x01,0xdf,0x00,0x00]

v_or_b32_e64 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x38,0xd2,0x01,0xf7,0x00,0x00]

v_or_b32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x38,0xd2,0x01,0xf9,0x00,0x00]

v_or_b32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x38,0xd2,0x01,0xfd,0x00,0x00]

v_or_b32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x38,0xd2,0x01,0xff,0x00,0x00]

v_or_b32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x38,0xd2,0x01,0x01,0x01,0x00]

v_or_b32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x38,0xd2,0x01,0x83,0x01,0x00]

v_or_b32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x38,0xd2,0x01,0xe1,0x01,0x00]

v_or_b32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x38,0xd2,0x01,0xef,0x01,0x00]

v_xor_b32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x3a]

v_xor_b32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x3b]

v_xor_b32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x3a]

v_xor_b32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x3a]

v_xor_b32 v5, s103, v2
// CHECK: [0x67,0x04,0x0a,0x3a]

v_xor_b32 v5, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0a,0x3a]

v_xor_b32 v5, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0a,0x3a]

v_xor_b32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x3a]

v_xor_b32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x3a]

v_xor_b32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x3a]

v_xor_b32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x3a]

v_xor_b32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x3a]

v_xor_b32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x3a]

v_xor_b32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x3a]

v_xor_b32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x3a]

v_xor_b32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x3a]

v_xor_b32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x3a]

v_xor_b32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x3a]

v_xor_b32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x3a]

v_xor_b32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x3a]

v_xor_b32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x3a]

v_xor_b32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x3a,0x56,0x34,0x12,0xaf]

v_xor_b32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x3a,0x73,0x72,0x71,0x3f]

v_xor_b32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x3a]

v_xor_b32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x3a,0xd2,0x01,0x05,0x02,0x00]

v_xor_b32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x3a,0xd2,0x01,0x05,0x02,0x00]

v_xor_b32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x3a,0xd2,0xff,0x05,0x02,0x00]

v_xor_b32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x3a,0xd2,0x01,0x04,0x02,0x00]

v_xor_b32_e64 v5, s103, v2
// CHECK: [0x05,0x00,0x3a,0xd2,0x67,0x04,0x02,0x00]

v_xor_b32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x3a,0xd2,0x68,0x04,0x02,0x00]

v_xor_b32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x3a,0xd2,0x69,0x04,0x02,0x00]

v_xor_b32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x3a,0xd2,0x6a,0x04,0x02,0x00]

v_xor_b32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x3a,0xd2,0x6b,0x04,0x02,0x00]

v_xor_b32_e64 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x3a,0xd2,0x6c,0x04,0x02,0x00]

v_xor_b32_e64 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x3a,0xd2,0x6d,0x04,0x02,0x00]

v_xor_b32_e64 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x3a,0xd2,0x6e,0x04,0x02,0x00]

v_xor_b32_e64 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x3a,0xd2,0x6f,0x04,0x02,0x00]

v_xor_b32_e64 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x3a,0xd2,0x7b,0x04,0x02,0x00]

v_xor_b32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x3a,0xd2,0x7c,0x04,0x02,0x00]

v_xor_b32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x3a,0xd2,0x7e,0x04,0x02,0x00]

v_xor_b32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x3a,0xd2,0x7f,0x04,0x02,0x00]

v_xor_b32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x3a,0xd2,0x80,0x04,0x02,0x00]

v_xor_b32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x3a,0xd2,0xc1,0x04,0x02,0x00]

v_xor_b32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x3a,0xd2,0xf0,0x04,0x02,0x00]

v_xor_b32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x3a,0xd2,0xf7,0x04,0x02,0x00]

v_xor_b32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x3a,0xd2,0x01,0xff,0x03,0x00]

v_xor_b32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x3a,0xd2,0x01,0x05,0x00,0x00]

v_xor_b32_e64 v5, v1, s103
// CHECK: [0x05,0x00,0x3a,0xd2,0x01,0xcf,0x00,0x00]

v_xor_b32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x3a,0xd2,0x01,0xd1,0x00,0x00]

v_xor_b32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x3a,0xd2,0x01,0xd3,0x00,0x00]

v_xor_b32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x3a,0xd2,0x01,0xd5,0x00,0x00]

v_xor_b32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x3a,0xd2,0x01,0xd7,0x00,0x00]

v_xor_b32_e64 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x3a,0xd2,0x01,0xd9,0x00,0x00]

v_xor_b32_e64 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x3a,0xd2,0x01,0xdb,0x00,0x00]

v_xor_b32_e64 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x3a,0xd2,0x01,0xdd,0x00,0x00]

v_xor_b32_e64 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x3a,0xd2,0x01,0xdf,0x00,0x00]

v_xor_b32_e64 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x3a,0xd2,0x01,0xf7,0x00,0x00]

v_xor_b32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x3a,0xd2,0x01,0xf9,0x00,0x00]

v_xor_b32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x3a,0xd2,0x01,0xfd,0x00,0x00]

v_xor_b32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x3a,0xd2,0x01,0xff,0x00,0x00]

v_xor_b32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x3a,0xd2,0x01,0x01,0x01,0x00]

v_xor_b32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x3a,0xd2,0x01,0x83,0x01,0x00]

v_xor_b32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x3a,0xd2,0x01,0xe1,0x01,0x00]

v_xor_b32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x3a,0xd2,0x01,0xef,0x01,0x00]

v_bfm_b32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x3c]

v_bfm_b32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x3d]

v_bfm_b32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x3c]

v_bfm_b32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x3c]

v_bfm_b32 v5, s103, v2
// CHECK: [0x67,0x04,0x0a,0x3c]

v_bfm_b32 v5, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0a,0x3c]

v_bfm_b32 v5, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0a,0x3c]

v_bfm_b32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x3c]

v_bfm_b32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x3c]

v_bfm_b32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x3c]

v_bfm_b32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x3c]

v_bfm_b32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x3c]

v_bfm_b32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x3c]

v_bfm_b32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x3c]

v_bfm_b32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x3c]

v_bfm_b32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x3c]

v_bfm_b32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x3c]

v_bfm_b32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x3c]

v_bfm_b32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x3c]

v_bfm_b32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x3c]

v_bfm_b32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x3c]

v_bfm_b32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x3c,0x56,0x34,0x12,0xaf]

v_bfm_b32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x3c,0x73,0x72,0x71,0x3f]

v_bfm_b32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x3c]

v_bfm_b32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x3c,0xd2,0x01,0x05,0x02,0x00]

v_bfm_b32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x3c,0xd2,0x01,0x05,0x02,0x00]

v_bfm_b32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x3c,0xd2,0xff,0x05,0x02,0x00]

v_bfm_b32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x3c,0xd2,0x01,0x04,0x02,0x00]

v_bfm_b32_e64 v5, s103, v2
// CHECK: [0x05,0x00,0x3c,0xd2,0x67,0x04,0x02,0x00]

v_bfm_b32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x3c,0xd2,0x68,0x04,0x02,0x00]

v_bfm_b32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x3c,0xd2,0x69,0x04,0x02,0x00]

v_bfm_b32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x3c,0xd2,0x6a,0x04,0x02,0x00]

v_bfm_b32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x3c,0xd2,0x6b,0x04,0x02,0x00]

v_bfm_b32_e64 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x3c,0xd2,0x6c,0x04,0x02,0x00]

v_bfm_b32_e64 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x3c,0xd2,0x6d,0x04,0x02,0x00]

v_bfm_b32_e64 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x3c,0xd2,0x6e,0x04,0x02,0x00]

v_bfm_b32_e64 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x3c,0xd2,0x6f,0x04,0x02,0x00]

v_bfm_b32_e64 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x3c,0xd2,0x7b,0x04,0x02,0x00]

v_bfm_b32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x3c,0xd2,0x7c,0x04,0x02,0x00]

v_bfm_b32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x3c,0xd2,0x7e,0x04,0x02,0x00]

v_bfm_b32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x3c,0xd2,0x7f,0x04,0x02,0x00]

v_bfm_b32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x3c,0xd2,0x80,0x04,0x02,0x00]

v_bfm_b32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x3c,0xd2,0xc1,0x04,0x02,0x00]

v_bfm_b32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x3c,0xd2,0xf0,0x04,0x02,0x00]

v_bfm_b32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x3c,0xd2,0xf7,0x04,0x02,0x00]

v_bfm_b32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x3c,0xd2,0x01,0xff,0x03,0x00]

v_bfm_b32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x3c,0xd2,0x01,0x05,0x00,0x00]

v_bfm_b32_e64 v5, v1, s103
// CHECK: [0x05,0x00,0x3c,0xd2,0x01,0xcf,0x00,0x00]

v_bfm_b32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x3c,0xd2,0x01,0xd1,0x00,0x00]

v_bfm_b32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x3c,0xd2,0x01,0xd3,0x00,0x00]

v_bfm_b32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x3c,0xd2,0x01,0xd5,0x00,0x00]

v_bfm_b32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x3c,0xd2,0x01,0xd7,0x00,0x00]

v_bfm_b32_e64 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x3c,0xd2,0x01,0xd9,0x00,0x00]

v_bfm_b32_e64 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x3c,0xd2,0x01,0xdb,0x00,0x00]

v_bfm_b32_e64 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x3c,0xd2,0x01,0xdd,0x00,0x00]

v_bfm_b32_e64 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x3c,0xd2,0x01,0xdf,0x00,0x00]

v_bfm_b32_e64 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x3c,0xd2,0x01,0xf7,0x00,0x00]

v_bfm_b32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x3c,0xd2,0x01,0xf9,0x00,0x00]

v_bfm_b32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x3c,0xd2,0x01,0xfd,0x00,0x00]

v_bfm_b32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x3c,0xd2,0x01,0xff,0x00,0x00]

v_bfm_b32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x3c,0xd2,0x01,0x01,0x01,0x00]

v_bfm_b32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x3c,0xd2,0x01,0x83,0x01,0x00]

v_bfm_b32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x3c,0xd2,0x01,0xe1,0x01,0x00]

v_bfm_b32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x3c,0xd2,0x01,0xef,0x01,0x00]

v_mac_f32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x3e]

v_mac_f32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x3f]

v_mac_f32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x3e]

v_mac_f32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x3e]

v_mac_f32 v5, s103, v2
// CHECK: [0x67,0x04,0x0a,0x3e]

v_mac_f32 v5, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0a,0x3e]

v_mac_f32 v5, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0a,0x3e]

v_mac_f32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x3e]

v_mac_f32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x3e]

v_mac_f32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x3e]

v_mac_f32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x3e]

v_mac_f32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x3e]

v_mac_f32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x3e]

v_mac_f32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x3e]

v_mac_f32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x3e]

v_mac_f32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x3e]

v_mac_f32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x3e]

v_mac_f32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x3e]

v_mac_f32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x3e]

v_mac_f32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x3e]

v_mac_f32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x3e]

v_mac_f32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x3e,0x56,0x34,0x12,0xaf]

v_mac_f32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x3e,0x73,0x72,0x71,0x3f]

v_mac_f32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x3e]

v_mac_f32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x3e,0xd2,0x01,0x05,0x02,0x00]

v_mac_f32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x3e,0xd2,0x01,0x05,0x02,0x00]

v_mac_f32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x3e,0xd2,0xff,0x05,0x02,0x00]

v_mac_f32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x3e,0xd2,0x01,0x04,0x02,0x00]

v_mac_f32_e64 v5, s103, v2
// CHECK: [0x05,0x00,0x3e,0xd2,0x67,0x04,0x02,0x00]

v_mac_f32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x3e,0xd2,0x68,0x04,0x02,0x00]

v_mac_f32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x3e,0xd2,0x69,0x04,0x02,0x00]

v_mac_f32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x3e,0xd2,0x6a,0x04,0x02,0x00]

v_mac_f32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x3e,0xd2,0x6b,0x04,0x02,0x00]

v_mac_f32_e64 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x3e,0xd2,0x6c,0x04,0x02,0x00]

v_mac_f32_e64 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x3e,0xd2,0x6d,0x04,0x02,0x00]

v_mac_f32_e64 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x3e,0xd2,0x6e,0x04,0x02,0x00]

v_mac_f32_e64 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x3e,0xd2,0x6f,0x04,0x02,0x00]

v_mac_f32_e64 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x3e,0xd2,0x7b,0x04,0x02,0x00]

v_mac_f32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x3e,0xd2,0x7c,0x04,0x02,0x00]

v_mac_f32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x3e,0xd2,0x7e,0x04,0x02,0x00]

v_mac_f32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x3e,0xd2,0x7f,0x04,0x02,0x00]

v_mac_f32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x3e,0xd2,0x80,0x04,0x02,0x00]

v_mac_f32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x3e,0xd2,0xc1,0x04,0x02,0x00]

v_mac_f32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x3e,0xd2,0xf0,0x04,0x02,0x00]

v_mac_f32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x3e,0xd2,0xf7,0x04,0x02,0x00]

v_mac_f32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x3e,0xd2,0x01,0xff,0x03,0x00]

v_mac_f32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x3e,0xd2,0x01,0x05,0x00,0x00]

v_mac_f32_e64 v5, v1, s103
// CHECK: [0x05,0x00,0x3e,0xd2,0x01,0xcf,0x00,0x00]

v_mac_f32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x3e,0xd2,0x01,0xd1,0x00,0x00]

v_mac_f32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x3e,0xd2,0x01,0xd3,0x00,0x00]

v_mac_f32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x3e,0xd2,0x01,0xd5,0x00,0x00]

v_mac_f32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x3e,0xd2,0x01,0xd7,0x00,0x00]

v_mac_f32_e64 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x3e,0xd2,0x01,0xd9,0x00,0x00]

v_mac_f32_e64 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x3e,0xd2,0x01,0xdb,0x00,0x00]

v_mac_f32_e64 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x3e,0xd2,0x01,0xdd,0x00,0x00]

v_mac_f32_e64 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x3e,0xd2,0x01,0xdf,0x00,0x00]

v_mac_f32_e64 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x3e,0xd2,0x01,0xf7,0x00,0x00]

v_mac_f32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x3e,0xd2,0x01,0xf9,0x00,0x00]

v_mac_f32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x3e,0xd2,0x01,0xfd,0x00,0x00]

v_mac_f32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x3e,0xd2,0x01,0xff,0x00,0x00]

v_mac_f32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x3e,0xd2,0x01,0x01,0x01,0x00]

v_mac_f32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x3e,0xd2,0x01,0x83,0x01,0x00]

v_mac_f32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x3e,0xd2,0x01,0xe1,0x01,0x00]

v_mac_f32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x3e,0xd2,0x01,0xef,0x01,0x00]

v_mac_f32_e64 v5, -v1, v2
// CHECK: [0x05,0x00,0x3e,0xd2,0x01,0x05,0x02,0x20]

v_mac_f32_e64 v5, v1, -v2
// CHECK: [0x05,0x00,0x3e,0xd2,0x01,0x05,0x02,0x40]

v_mac_f32_e64 v5, -v1, -v2
// CHECK: [0x05,0x00,0x3e,0xd2,0x01,0x05,0x02,0x60]

v_mac_f32_e64 v5, |v1|, v2
// CHECK: [0x05,0x01,0x3e,0xd2,0x01,0x05,0x02,0x00]

v_mac_f32_e64 v5, v1, |v2|
// CHECK: [0x05,0x02,0x3e,0xd2,0x01,0x05,0x02,0x00]

v_mac_f32_e64 v5, |v1|, |v2|
// CHECK: [0x05,0x03,0x3e,0xd2,0x01,0x05,0x02,0x00]

v_mac_f32_e64 v5, v1, v2 clamp
// CHECK: [0x05,0x08,0x3e,0xd2,0x01,0x05,0x02,0x00]

v_mac_f32_e64 v5, v1, v2 mul:2
// CHECK: [0x05,0x00,0x3e,0xd2,0x01,0x05,0x02,0x08]

v_mac_f32_e64 v5, v1, v2 mul:4
// CHECK: [0x05,0x00,0x3e,0xd2,0x01,0x05,0x02,0x10]

v_mac_f32_e64 v5, v1, v2 div:2
// CHECK: [0x05,0x00,0x3e,0xd2,0x01,0x05,0x02,0x18]

v_madmk_f32 v5, v1, 0x11213141, v3
// CHECK: [0x01,0x07,0x0a,0x40,0x41,0x31,0x21,0x11]

v_madmk_f32 v255, v1, 0x11213141, v3
// CHECK: [0x01,0x07,0xfe,0x41,0x41,0x31,0x21,0x11]

v_madmk_f32 v5, v255, 0x11213141, v3
// CHECK: [0xff,0x07,0x0a,0x40,0x41,0x31,0x21,0x11]

v_madmk_f32 v5, 0, 0x11213141, v3
// CHECK: [0x80,0x06,0x0a,0x40,0x41,0x31,0x21,0x11]

v_madmk_f32 v5, -1, 0x11213141, v3
// CHECK: [0xc1,0x06,0x0a,0x40,0x41,0x31,0x21,0x11]

v_madmk_f32 v5, 0.5, 0x11213141, v3
// CHECK: [0xf0,0x06,0x0a,0x40,0x41,0x31,0x21,0x11]

v_madmk_f32 v5, -4.0, 0x11213141, v3
// CHECK: [0xf7,0x06,0x0a,0x40,0x41,0x31,0x21,0x11]

v_madmk_f32 v5, v1, 0xa1b1c1d1, v3
// CHECK: [0x01,0x07,0x0a,0x40,0xd1,0xc1,0xb1,0xa1]

v_madmk_f32 v5, v1, 0x11213141, v255
// CHECK: [0x01,0xff,0x0b,0x40,0x41,0x31,0x21,0x11]

v_madak_f32 v5, v1, v2, 0x11213141
// CHECK: [0x01,0x05,0x0a,0x42,0x41,0x31,0x21,0x11]

v_madak_f32 v255, v1, v2, 0x11213141
// CHECK: [0x01,0x05,0xfe,0x43,0x41,0x31,0x21,0x11]

v_madak_f32 v5, v255, v2, 0x11213141
// CHECK: [0xff,0x05,0x0a,0x42,0x41,0x31,0x21,0x11]

v_madak_f32 v5, 0, v2, 0x11213141
// CHECK: [0x80,0x04,0x0a,0x42,0x41,0x31,0x21,0x11]

v_madak_f32 v5, -1, v2, 0x11213141
// CHECK: [0xc1,0x04,0x0a,0x42,0x41,0x31,0x21,0x11]

v_madak_f32 v5, 0.5, v2, 0x11213141
// CHECK: [0xf0,0x04,0x0a,0x42,0x41,0x31,0x21,0x11]

v_madak_f32 v5, -4.0, v2, 0x11213141
// CHECK: [0xf7,0x04,0x0a,0x42,0x41,0x31,0x21,0x11]

v_madak_f32 v5, v1, v255, 0x11213141
// CHECK: [0x01,0xff,0x0b,0x42,0x41,0x31,0x21,0x11]

v_madak_f32 v5, v1, v2, 0xa1b1c1d1
// CHECK: [0x01,0x05,0x0a,0x42,0xd1,0xc1,0xb1,0xa1]

v_bcnt_u32_b32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x44]

v_bcnt_u32_b32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x45]

v_bcnt_u32_b32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x44]

v_bcnt_u32_b32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x44]

v_bcnt_u32_b32 v5, s103, v2
// CHECK: [0x67,0x04,0x0a,0x44]

v_bcnt_u32_b32 v5, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0a,0x44]

v_bcnt_u32_b32 v5, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0a,0x44]

v_bcnt_u32_b32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x44]

v_bcnt_u32_b32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x44]

v_bcnt_u32_b32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x44]

v_bcnt_u32_b32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x44]

v_bcnt_u32_b32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x44]

v_bcnt_u32_b32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x44]

v_bcnt_u32_b32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x44]

v_bcnt_u32_b32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x44]

v_bcnt_u32_b32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x44]

v_bcnt_u32_b32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x44]

v_bcnt_u32_b32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x44]

v_bcnt_u32_b32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x44]

v_bcnt_u32_b32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x44]

v_bcnt_u32_b32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x44]

v_bcnt_u32_b32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x44,0x56,0x34,0x12,0xaf]

v_bcnt_u32_b32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x44,0x73,0x72,0x71,0x3f]

v_bcnt_u32_b32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x44]

v_bcnt_u32_b32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x44,0xd2,0x01,0x05,0x02,0x00]

v_bcnt_u32_b32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x44,0xd2,0x01,0x05,0x02,0x00]

v_bcnt_u32_b32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x44,0xd2,0xff,0x05,0x02,0x00]

v_bcnt_u32_b32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x44,0xd2,0x01,0x04,0x02,0x00]

v_bcnt_u32_b32_e64 v5, s103, v2
// CHECK: [0x05,0x00,0x44,0xd2,0x67,0x04,0x02,0x00]

v_bcnt_u32_b32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x44,0xd2,0x68,0x04,0x02,0x00]

v_bcnt_u32_b32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x44,0xd2,0x69,0x04,0x02,0x00]

v_bcnt_u32_b32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x44,0xd2,0x6a,0x04,0x02,0x00]

v_bcnt_u32_b32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x44,0xd2,0x6b,0x04,0x02,0x00]

v_bcnt_u32_b32_e64 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x44,0xd2,0x6c,0x04,0x02,0x00]

v_bcnt_u32_b32_e64 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x44,0xd2,0x6d,0x04,0x02,0x00]

v_bcnt_u32_b32_e64 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x44,0xd2,0x6e,0x04,0x02,0x00]

v_bcnt_u32_b32_e64 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x44,0xd2,0x6f,0x04,0x02,0x00]

v_bcnt_u32_b32_e64 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x44,0xd2,0x7b,0x04,0x02,0x00]

v_bcnt_u32_b32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x44,0xd2,0x7c,0x04,0x02,0x00]

v_bcnt_u32_b32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x44,0xd2,0x7e,0x04,0x02,0x00]

v_bcnt_u32_b32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x44,0xd2,0x7f,0x04,0x02,0x00]

v_bcnt_u32_b32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x44,0xd2,0x80,0x04,0x02,0x00]

v_bcnt_u32_b32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x44,0xd2,0xc1,0x04,0x02,0x00]

v_bcnt_u32_b32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x44,0xd2,0xf0,0x04,0x02,0x00]

v_bcnt_u32_b32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x44,0xd2,0xf7,0x04,0x02,0x00]

v_bcnt_u32_b32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x44,0xd2,0x01,0xff,0x03,0x00]

v_bcnt_u32_b32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x44,0xd2,0x01,0x05,0x00,0x00]

v_bcnt_u32_b32_e64 v5, v1, s103
// CHECK: [0x05,0x00,0x44,0xd2,0x01,0xcf,0x00,0x00]

v_bcnt_u32_b32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x44,0xd2,0x01,0xd1,0x00,0x00]

v_bcnt_u32_b32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x44,0xd2,0x01,0xd3,0x00,0x00]

v_bcnt_u32_b32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x44,0xd2,0x01,0xd5,0x00,0x00]

v_bcnt_u32_b32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x44,0xd2,0x01,0xd7,0x00,0x00]

v_bcnt_u32_b32_e64 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x44,0xd2,0x01,0xd9,0x00,0x00]

v_bcnt_u32_b32_e64 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x44,0xd2,0x01,0xdb,0x00,0x00]

v_bcnt_u32_b32_e64 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x44,0xd2,0x01,0xdd,0x00,0x00]

v_bcnt_u32_b32_e64 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x44,0xd2,0x01,0xdf,0x00,0x00]

v_bcnt_u32_b32_e64 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x44,0xd2,0x01,0xf7,0x00,0x00]

v_bcnt_u32_b32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x44,0xd2,0x01,0xf9,0x00,0x00]

v_bcnt_u32_b32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x44,0xd2,0x01,0xfd,0x00,0x00]

v_bcnt_u32_b32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x44,0xd2,0x01,0xff,0x00,0x00]

v_bcnt_u32_b32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x44,0xd2,0x01,0x01,0x01,0x00]

v_bcnt_u32_b32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x44,0xd2,0x01,0x83,0x01,0x00]

v_bcnt_u32_b32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x44,0xd2,0x01,0xe1,0x01,0x00]

v_bcnt_u32_b32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x44,0xd2,0x01,0xef,0x01,0x00]

v_mbcnt_lo_u32_b32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x46]

v_mbcnt_lo_u32_b32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x47]

v_mbcnt_lo_u32_b32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x46]

v_mbcnt_lo_u32_b32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x46]

v_mbcnt_lo_u32_b32 v5, s103, v2
// CHECK: [0x67,0x04,0x0a,0x46]

v_mbcnt_lo_u32_b32 v5, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0a,0x46]

v_mbcnt_lo_u32_b32 v5, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0a,0x46]

v_mbcnt_lo_u32_b32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x46]

v_mbcnt_lo_u32_b32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x46]

v_mbcnt_lo_u32_b32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x46]

v_mbcnt_lo_u32_b32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x46]

v_mbcnt_lo_u32_b32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x46]

v_mbcnt_lo_u32_b32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x46]

v_mbcnt_lo_u32_b32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x46]

v_mbcnt_lo_u32_b32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x46]

v_mbcnt_lo_u32_b32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x46]

v_mbcnt_lo_u32_b32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x46]

v_mbcnt_lo_u32_b32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x46]

v_mbcnt_lo_u32_b32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x46]

v_mbcnt_lo_u32_b32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x46]

v_mbcnt_lo_u32_b32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x46]

v_mbcnt_lo_u32_b32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x46,0x56,0x34,0x12,0xaf]

v_mbcnt_lo_u32_b32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x46,0x73,0x72,0x71,0x3f]

v_mbcnt_lo_u32_b32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x46]

v_mbcnt_lo_u32_b32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x46,0xd2,0x01,0x05,0x02,0x00]

v_mbcnt_lo_u32_b32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x46,0xd2,0x01,0x05,0x02,0x00]

v_mbcnt_lo_u32_b32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x46,0xd2,0xff,0x05,0x02,0x00]

v_mbcnt_lo_u32_b32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x46,0xd2,0x01,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32_e64 v5, s103, v2
// CHECK: [0x05,0x00,0x46,0xd2,0x67,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x46,0xd2,0x68,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x46,0xd2,0x69,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x46,0xd2,0x6a,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x46,0xd2,0x6b,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32_e64 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x46,0xd2,0x6c,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32_e64 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x46,0xd2,0x6d,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32_e64 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x46,0xd2,0x6e,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32_e64 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x46,0xd2,0x6f,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32_e64 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x46,0xd2,0x7b,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x46,0xd2,0x7c,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x46,0xd2,0x7e,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x46,0xd2,0x7f,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x46,0xd2,0x80,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x46,0xd2,0xc1,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x46,0xd2,0xf0,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x46,0xd2,0xf7,0x04,0x02,0x00]

v_mbcnt_lo_u32_b32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x46,0xd2,0x01,0xff,0x03,0x00]

v_mbcnt_lo_u32_b32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x46,0xd2,0x01,0x05,0x00,0x00]

v_mbcnt_lo_u32_b32_e64 v5, v1, s103
// CHECK: [0x05,0x00,0x46,0xd2,0x01,0xcf,0x00,0x00]

v_mbcnt_lo_u32_b32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x46,0xd2,0x01,0xd1,0x00,0x00]

v_mbcnt_lo_u32_b32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x46,0xd2,0x01,0xd3,0x00,0x00]

v_mbcnt_lo_u32_b32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x46,0xd2,0x01,0xd5,0x00,0x00]

v_mbcnt_lo_u32_b32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x46,0xd2,0x01,0xd7,0x00,0x00]

v_mbcnt_lo_u32_b32_e64 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x46,0xd2,0x01,0xd9,0x00,0x00]

v_mbcnt_lo_u32_b32_e64 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x46,0xd2,0x01,0xdb,0x00,0x00]

v_mbcnt_lo_u32_b32_e64 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x46,0xd2,0x01,0xdd,0x00,0x00]

v_mbcnt_lo_u32_b32_e64 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x46,0xd2,0x01,0xdf,0x00,0x00]

v_mbcnt_lo_u32_b32_e64 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x46,0xd2,0x01,0xf7,0x00,0x00]

v_mbcnt_lo_u32_b32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x46,0xd2,0x01,0xf9,0x00,0x00]

v_mbcnt_lo_u32_b32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x46,0xd2,0x01,0xfd,0x00,0x00]

v_mbcnt_lo_u32_b32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x46,0xd2,0x01,0xff,0x00,0x00]

v_mbcnt_lo_u32_b32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x46,0xd2,0x01,0x01,0x01,0x00]

v_mbcnt_lo_u32_b32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x46,0xd2,0x01,0x83,0x01,0x00]

v_mbcnt_lo_u32_b32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x46,0xd2,0x01,0xe1,0x01,0x00]

v_mbcnt_lo_u32_b32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x46,0xd2,0x01,0xef,0x01,0x00]

v_mbcnt_hi_u32_b32 v5, v1, v2
// CHECK: [0x01,0x05,0x0a,0x48]

v_mbcnt_hi_u32_b32 v255, v1, v2
// CHECK: [0x01,0x05,0xfe,0x49]

v_mbcnt_hi_u32_b32 v5, v255, v2
// CHECK: [0xff,0x05,0x0a,0x48]

v_mbcnt_hi_u32_b32 v5, s1, v2
// CHECK: [0x01,0x04,0x0a,0x48]

v_mbcnt_hi_u32_b32 v5, s103, v2
// CHECK: [0x67,0x04,0x0a,0x48]

v_mbcnt_hi_u32_b32 v5, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0a,0x48]

v_mbcnt_hi_u32_b32 v5, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0a,0x48]

v_mbcnt_hi_u32_b32 v5, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x48]

v_mbcnt_hi_u32_b32 v5, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x48]

v_mbcnt_hi_u32_b32 v5, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x48]

v_mbcnt_hi_u32_b32 v5, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x48]

v_mbcnt_hi_u32_b32 v5, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x48]

v_mbcnt_hi_u32_b32 v5, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x48]

v_mbcnt_hi_u32_b32 v5, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x48]

v_mbcnt_hi_u32_b32 v5, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x48]

v_mbcnt_hi_u32_b32 v5, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x48]

v_mbcnt_hi_u32_b32 v5, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x48]

v_mbcnt_hi_u32_b32 v5, 0, v2
// CHECK: [0x80,0x04,0x0a,0x48]

v_mbcnt_hi_u32_b32 v5, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x48]

v_mbcnt_hi_u32_b32 v5, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x48]

v_mbcnt_hi_u32_b32 v5, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x48]

v_mbcnt_hi_u32_b32 v5, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x48,0x56,0x34,0x12,0xaf]

v_mbcnt_hi_u32_b32 v5, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x48,0x73,0x72,0x71,0x3f]

v_mbcnt_hi_u32_b32 v5, v1, v255
// CHECK: [0x01,0xff,0x0b,0x48]

v_mbcnt_hi_u32_b32_e64 v5, v1, v2
// CHECK: [0x05,0x00,0x48,0xd2,0x01,0x05,0x02,0x00]

v_mbcnt_hi_u32_b32_e64 v255, v1, v2
// CHECK: [0xff,0x00,0x48,0xd2,0x01,0x05,0x02,0x00]

v_mbcnt_hi_u32_b32_e64 v5, v255, v2
// CHECK: [0x05,0x00,0x48,0xd2,0xff,0x05,0x02,0x00]

v_mbcnt_hi_u32_b32_e64 v5, s1, v2
// CHECK: [0x05,0x00,0x48,0xd2,0x01,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32_e64 v5, s103, v2
// CHECK: [0x05,0x00,0x48,0xd2,0x67,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32_e64 v5, flat_scratch_lo, v2
// CHECK: [0x05,0x00,0x48,0xd2,0x68,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32_e64 v5, flat_scratch_hi, v2
// CHECK: [0x05,0x00,0x48,0xd2,0x69,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32_e64 v5, vcc_lo, v2
// CHECK: [0x05,0x00,0x48,0xd2,0x6a,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32_e64 v5, vcc_hi, v2
// CHECK: [0x05,0x00,0x48,0xd2,0x6b,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32_e64 v5, tba_lo, v2
// CHECK: [0x05,0x00,0x48,0xd2,0x6c,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32_e64 v5, tba_hi, v2
// CHECK: [0x05,0x00,0x48,0xd2,0x6d,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32_e64 v5, tma_lo, v2
// CHECK: [0x05,0x00,0x48,0xd2,0x6e,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32_e64 v5, tma_hi, v2
// CHECK: [0x05,0x00,0x48,0xd2,0x6f,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32_e64 v5, ttmp11, v2
// CHECK: [0x05,0x00,0x48,0xd2,0x7b,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32_e64 v5, m0, v2
// CHECK: [0x05,0x00,0x48,0xd2,0x7c,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32_e64 v5, exec_lo, v2
// CHECK: [0x05,0x00,0x48,0xd2,0x7e,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32_e64 v5, exec_hi, v2
// CHECK: [0x05,0x00,0x48,0xd2,0x7f,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32_e64 v5, 0, v2
// CHECK: [0x05,0x00,0x48,0xd2,0x80,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32_e64 v5, -1, v2
// CHECK: [0x05,0x00,0x48,0xd2,0xc1,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32_e64 v5, 0.5, v2
// CHECK: [0x05,0x00,0x48,0xd2,0xf0,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32_e64 v5, -4.0, v2
// CHECK: [0x05,0x00,0x48,0xd2,0xf7,0x04,0x02,0x00]

v_mbcnt_hi_u32_b32_e64 v5, v1, v255
// CHECK: [0x05,0x00,0x48,0xd2,0x01,0xff,0x03,0x00]

v_mbcnt_hi_u32_b32_e64 v5, v1, s2
// CHECK: [0x05,0x00,0x48,0xd2,0x01,0x05,0x00,0x00]

v_mbcnt_hi_u32_b32_e64 v5, v1, s103
// CHECK: [0x05,0x00,0x48,0xd2,0x01,0xcf,0x00,0x00]

v_mbcnt_hi_u32_b32_e64 v5, v1, flat_scratch_lo
// CHECK: [0x05,0x00,0x48,0xd2,0x01,0xd1,0x00,0x00]

v_mbcnt_hi_u32_b32_e64 v5, v1, flat_scratch_hi
// CHECK: [0x05,0x00,0x48,0xd2,0x01,0xd3,0x00,0x00]

v_mbcnt_hi_u32_b32_e64 v5, v1, vcc_lo
// CHECK: [0x05,0x00,0x48,0xd2,0x01,0xd5,0x00,0x00]

v_mbcnt_hi_u32_b32_e64 v5, v1, vcc_hi
// CHECK: [0x05,0x00,0x48,0xd2,0x01,0xd7,0x00,0x00]

v_mbcnt_hi_u32_b32_e64 v5, v1, tba_lo
// CHECK: [0x05,0x00,0x48,0xd2,0x01,0xd9,0x00,0x00]

v_mbcnt_hi_u32_b32_e64 v5, v1, tba_hi
// CHECK: [0x05,0x00,0x48,0xd2,0x01,0xdb,0x00,0x00]

v_mbcnt_hi_u32_b32_e64 v5, v1, tma_lo
// CHECK: [0x05,0x00,0x48,0xd2,0x01,0xdd,0x00,0x00]

v_mbcnt_hi_u32_b32_e64 v5, v1, tma_hi
// CHECK: [0x05,0x00,0x48,0xd2,0x01,0xdf,0x00,0x00]

v_mbcnt_hi_u32_b32_e64 v5, v1, ttmp11
// CHECK: [0x05,0x00,0x48,0xd2,0x01,0xf7,0x00,0x00]

v_mbcnt_hi_u32_b32_e64 v5, v1, m0
// CHECK: [0x05,0x00,0x48,0xd2,0x01,0xf9,0x00,0x00]

v_mbcnt_hi_u32_b32_e64 v5, v1, exec_lo
// CHECK: [0x05,0x00,0x48,0xd2,0x01,0xfd,0x00,0x00]

v_mbcnt_hi_u32_b32_e64 v5, v1, exec_hi
// CHECK: [0x05,0x00,0x48,0xd2,0x01,0xff,0x00,0x00]

v_mbcnt_hi_u32_b32_e64 v5, v1, 0
// CHECK: [0x05,0x00,0x48,0xd2,0x01,0x01,0x01,0x00]

v_mbcnt_hi_u32_b32_e64 v5, v1, -1
// CHECK: [0x05,0x00,0x48,0xd2,0x01,0x83,0x01,0x00]

v_mbcnt_hi_u32_b32_e64 v5, v1, 0.5
// CHECK: [0x05,0x00,0x48,0xd2,0x01,0xe1,0x01,0x00]

v_mbcnt_hi_u32_b32_e64 v5, v1, -4.0
// CHECK: [0x05,0x00,0x48,0xd2,0x01,0xef,0x01,0x00]

v_add_i32 v5, vcc, v1, v2
// CHECK: [0x01,0x05,0x0a,0x4a]

v_add_i32 v255, vcc, v1, v2
// CHECK: [0x01,0x05,0xfe,0x4b]

v_add_i32 v5, vcc, v255, v2
// CHECK: [0xff,0x05,0x0a,0x4a]

v_add_i32 v5, vcc, s1, v2
// CHECK: [0x01,0x04,0x0a,0x4a]

v_add_i32 v5, vcc, s103, v2
// CHECK: [0x67,0x04,0x0a,0x4a]

v_add_i32 v5, vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0a,0x4a]

v_add_i32 v5, vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0a,0x4a]

v_add_i32 v5, vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x4a]

v_add_i32 v5, vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x4a]

v_add_i32 v5, vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x4a]

v_add_i32 v5, vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x4a]

v_add_i32 v5, vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x4a]

v_add_i32 v5, vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x4a]

v_add_i32 v5, vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x4a]

v_add_i32 v5, vcc, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x4a]

v_add_i32 v5, vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x4a]

v_add_i32 v5, vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x4a]

v_add_i32 v5, vcc, 0, v2
// CHECK: [0x80,0x04,0x0a,0x4a]

v_add_i32 v5, vcc, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x4a]

v_add_i32 v5, vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x4a]

v_add_i32 v5, vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x4a]

v_add_i32 v5, vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x4a,0x56,0x34,0x12,0xaf]

v_add_i32 v5, vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x4a,0x73,0x72,0x71,0x3f]

v_add_i32 v5, vcc, v1, v255
// CHECK: [0x01,0xff,0x0b,0x4a]

v_add_i32_e64 v5, s[12:13], v1, v2
// CHECK: [0x05,0x0c,0x4a,0xd2,0x01,0x05,0x02,0x00]

v_add_i32_e64 v255, s[12:13], v1, v2
// CHECK: [0xff,0x0c,0x4a,0xd2,0x01,0x05,0x02,0x00]

v_add_i32_e64 v5, s[14:15], v1, v2
// CHECK: [0x05,0x0e,0x4a,0xd2,0x01,0x05,0x02,0x00]

v_add_i32_e64 v5, s[102:103], v1, v2
// CHECK: [0x05,0x66,0x4a,0xd2,0x01,0x05,0x02,0x00]

v_add_i32_e64 v5, flat_scratch, v1, v2
// CHECK: [0x05,0x68,0x4a,0xd2,0x01,0x05,0x02,0x00]

v_add_i32_e64 v5, vcc, v1, v2
// CHECK: [0x05,0x6a,0x4a,0xd2,0x01,0x05,0x02,0x00]

v_add_i32_e64 v5, tba, v1, v2
// CHECK: [0x05,0x6c,0x4a,0xd2,0x01,0x05,0x02,0x00]

v_add_i32_e64 v5, tma, v1, v2
// CHECK: [0x05,0x6e,0x4a,0xd2,0x01,0x05,0x02,0x00]

v_add_i32_e64 v5, ttmp[10:11], v1, v2
// CHECK: [0x05,0x7a,0x4a,0xd2,0x01,0x05,0x02,0x00]

v_add_i32_e64 v5, s[12:13], v255, v2
// CHECK: [0x05,0x0c,0x4a,0xd2,0xff,0x05,0x02,0x00]

v_add_i32_e64 v5, s[12:13], s1, v2
// CHECK: [0x05,0x0c,0x4a,0xd2,0x01,0x04,0x02,0x00]

v_add_i32_e64 v5, s[12:13], s103, v2
// CHECK: [0x05,0x0c,0x4a,0xd2,0x67,0x04,0x02,0x00]

v_add_i32_e64 v5, s[12:13], flat_scratch_lo, v2
// CHECK: [0x05,0x0c,0x4a,0xd2,0x68,0x04,0x02,0x00]

v_add_i32_e64 v5, s[12:13], flat_scratch_hi, v2
// CHECK: [0x05,0x0c,0x4a,0xd2,0x69,0x04,0x02,0x00]

v_add_i32_e64 v5, s[12:13], vcc_lo, v2
// CHECK: [0x05,0x0c,0x4a,0xd2,0x6a,0x04,0x02,0x00]

v_add_i32_e64 v5, s[12:13], vcc_hi, v2
// CHECK: [0x05,0x0c,0x4a,0xd2,0x6b,0x04,0x02,0x00]

v_add_i32_e64 v5, s[12:13], tba_lo, v2
// CHECK: [0x05,0x0c,0x4a,0xd2,0x6c,0x04,0x02,0x00]

v_add_i32_e64 v5, s[12:13], tba_hi, v2
// CHECK: [0x05,0x0c,0x4a,0xd2,0x6d,0x04,0x02,0x00]

v_add_i32_e64 v5, s[12:13], tma_lo, v2
// CHECK: [0x05,0x0c,0x4a,0xd2,0x6e,0x04,0x02,0x00]

v_add_i32_e64 v5, s[12:13], tma_hi, v2
// CHECK: [0x05,0x0c,0x4a,0xd2,0x6f,0x04,0x02,0x00]

v_add_i32_e64 v5, s[12:13], ttmp11, v2
// CHECK: [0x05,0x0c,0x4a,0xd2,0x7b,0x04,0x02,0x00]

v_add_i32_e64 v5, s[12:13], m0, v2
// CHECK: [0x05,0x0c,0x4a,0xd2,0x7c,0x04,0x02,0x00]

v_add_i32_e64 v5, s[12:13], exec_lo, v2
// CHECK: [0x05,0x0c,0x4a,0xd2,0x7e,0x04,0x02,0x00]

v_add_i32_e64 v5, s[12:13], exec_hi, v2
// CHECK: [0x05,0x0c,0x4a,0xd2,0x7f,0x04,0x02,0x00]

v_add_i32_e64 v5, s[12:13], 0, v2
// CHECK: [0x05,0x0c,0x4a,0xd2,0x80,0x04,0x02,0x00]

v_add_i32_e64 v5, s[12:13], -1, v2
// CHECK: [0x05,0x0c,0x4a,0xd2,0xc1,0x04,0x02,0x00]

v_add_i32_e64 v5, s[12:13], 0.5, v2
// CHECK: [0x05,0x0c,0x4a,0xd2,0xf0,0x04,0x02,0x00]

v_add_i32_e64 v5, s[12:13], -4.0, v2
// CHECK: [0x05,0x0c,0x4a,0xd2,0xf7,0x04,0x02,0x00]

v_add_i32_e64 v5, s[12:13], v1, v255
// CHECK: [0x05,0x0c,0x4a,0xd2,0x01,0xff,0x03,0x00]

v_add_i32_e64 v5, s[12:13], v1, s2
// CHECK: [0x05,0x0c,0x4a,0xd2,0x01,0x05,0x00,0x00]

v_add_i32_e64 v5, s[12:13], v1, s103
// CHECK: [0x05,0x0c,0x4a,0xd2,0x01,0xcf,0x00,0x00]

v_add_i32_e64 v5, s[12:13], v1, flat_scratch_lo
// CHECK: [0x05,0x0c,0x4a,0xd2,0x01,0xd1,0x00,0x00]

v_add_i32_e64 v5, s[12:13], v1, flat_scratch_hi
// CHECK: [0x05,0x0c,0x4a,0xd2,0x01,0xd3,0x00,0x00]

v_add_i32_e64 v5, s[12:13], v1, vcc_lo
// CHECK: [0x05,0x0c,0x4a,0xd2,0x01,0xd5,0x00,0x00]

v_add_i32_e64 v5, s[12:13], v1, vcc_hi
// CHECK: [0x05,0x0c,0x4a,0xd2,0x01,0xd7,0x00,0x00]

v_add_i32_e64 v5, s[12:13], v1, tba_lo
// CHECK: [0x05,0x0c,0x4a,0xd2,0x01,0xd9,0x00,0x00]

v_add_i32_e64 v5, s[12:13], v1, tba_hi
// CHECK: [0x05,0x0c,0x4a,0xd2,0x01,0xdb,0x00,0x00]

v_add_i32_e64 v5, s[12:13], v1, tma_lo
// CHECK: [0x05,0x0c,0x4a,0xd2,0x01,0xdd,0x00,0x00]

v_add_i32_e64 v5, s[12:13], v1, tma_hi
// CHECK: [0x05,0x0c,0x4a,0xd2,0x01,0xdf,0x00,0x00]

v_add_i32_e64 v5, s[12:13], v1, ttmp11
// CHECK: [0x05,0x0c,0x4a,0xd2,0x01,0xf7,0x00,0x00]

v_add_i32_e64 v5, s[12:13], v1, m0
// CHECK: [0x05,0x0c,0x4a,0xd2,0x01,0xf9,0x00,0x00]

v_add_i32_e64 v5, s[12:13], v1, exec_lo
// CHECK: [0x05,0x0c,0x4a,0xd2,0x01,0xfd,0x00,0x00]

v_add_i32_e64 v5, s[12:13], v1, exec_hi
// CHECK: [0x05,0x0c,0x4a,0xd2,0x01,0xff,0x00,0x00]

v_add_i32_e64 v5, s[12:13], v1, 0
// CHECK: [0x05,0x0c,0x4a,0xd2,0x01,0x01,0x01,0x00]

v_add_i32_e64 v5, s[12:13], v1, -1
// CHECK: [0x05,0x0c,0x4a,0xd2,0x01,0x83,0x01,0x00]

v_add_i32_e64 v5, s[12:13], v1, 0.5
// CHECK: [0x05,0x0c,0x4a,0xd2,0x01,0xe1,0x01,0x00]

v_add_i32_e64 v5, s[12:13], v1, -4.0
// CHECK: [0x05,0x0c,0x4a,0xd2,0x01,0xef,0x01,0x00]

v_sub_i32 v5, vcc, v1, v2
// CHECK: [0x01,0x05,0x0a,0x4c]

v_sub_i32 v255, vcc, v1, v2
// CHECK: [0x01,0x05,0xfe,0x4d]

v_sub_i32 v5, vcc, v255, v2
// CHECK: [0xff,0x05,0x0a,0x4c]

v_sub_i32 v5, vcc, s1, v2
// CHECK: [0x01,0x04,0x0a,0x4c]

v_sub_i32 v5, vcc, s103, v2
// CHECK: [0x67,0x04,0x0a,0x4c]

v_sub_i32 v5, vcc, flat_scratch_lo, v2
// CHECK: [0x68,0x04,0x0a,0x4c]

v_sub_i32 v5, vcc, flat_scratch_hi, v2
// CHECK: [0x69,0x04,0x0a,0x4c]

v_sub_i32 v5, vcc, vcc_lo, v2
// CHECK: [0x6a,0x04,0x0a,0x4c]

v_sub_i32 v5, vcc, vcc_hi, v2
// CHECK: [0x6b,0x04,0x0a,0x4c]

v_sub_i32 v5, vcc, tba_lo, v2
// CHECK: [0x6c,0x04,0x0a,0x4c]

v_sub_i32 v5, vcc, tba_hi, v2
// CHECK: [0x6d,0x04,0x0a,0x4c]

v_sub_i32 v5, vcc, tma_lo, v2
// CHECK: [0x6e,0x04,0x0a,0x4c]

v_sub_i32 v5, vcc, tma_hi, v2
// CHECK: [0x6f,0x04,0x0a,0x4c]

v_sub_i32 v5, vcc, ttmp11, v2
// CHECK: [0x7b,0x04,0x0a,0x4c]

v_sub_i32 v5, vcc, m0, v2
// CHECK: [0x7c,0x04,0x0a,0x4c]

v_sub_i32 v5, vcc, exec_lo, v2
// CHECK: [0x7e,0x04,0x0a,0x4c]

v_sub_i32 v5, vcc, exec_hi, v2
// CHECK: [0x7f,0x04,0x0a,0x4c]

v_sub_i32 v5, vcc, 0, v2
// CHECK: [0x80,0x04,0x0a,0x4c]

v_sub_i32 v5, vcc, -1, v2
// CHECK: [0xc1,0x04,0x0a,0x4c]

v_sub_i32 v5, vcc, 0.5, v2
// CHECK: [0xf0,0x04,0x0a,0x4c]

v_sub_i32 v5, vcc, -4.0, v2
// CHECK: [0xf7,0x04,0x0a,0x4c]

v_sub_i32 v5, vcc, 0xaf123456, v2
// CHECK: [0xff,0x04,0x0a,0x4c,0x56,0x34,0x12,0xaf]

v_sub_i32 v5, vcc, 0x3f717273, v2
// CHECK: [0xff,0x04,0x0a,0x4c,0x73,0x72,0x71,0x3f]

v_sub_i32 v5, vcc, v1, v255
// CHECK: [0x01,0xff,0x0b,0x4c]

v_sub_i32_e64 v5, s[12:13], v1, v2
// CHECK: [0x05,0x0c,0x4c,0xd2,0x01,0x05,0x02,0x00]

v_sub_i32_e64 v255, s[12:13], v1, v2
// CHECK: [0xff,0x0c,0x4c,0xd2,0x01,0x05,0x02,0x00]

v_sub_i32_e64 v5, s[14:15], v1, v2
// CHECK: [0x05,0x0e,0x4c,0xd2,0x01,0x05,0x02,0x00]

v_sub_i32_e64 v5, s[102:103], v1, v2
// CHECK: [0x05,0x66,0x4c,0xd2,0x01,0x05,0x02,0x00]

v_sub_i32_e64 v5, flat_scratch, v1, v2
// CHECK: [0x05,0x68,0x4c,0xd2,0x01,0x05,0x02,0x00]

v_sub_i32_e64 v5, vcc, v1, v2
// CHECK: [0x05,0x6a,0x4c,0xd2,0x01,0x05,0x02,0x00]

v_sub_i32_e64 v5, tba, v1, v2
// CHECK: [0x05,0x6c,0x4c,0xd2,0x01,0x05,0x02,0x00]

v_sub_i32_e64 v5, tma, v1, v2
// CHECK: [0x05,0x6e,0x4c,0xd2,0x01,0x05,0x02,0x00]

v_sub_i32_e64 v5, ttmp[10:11], v1, v2
// CHECK: [0x05,0x7a,0x4c,0xd2,0x01,0x05,0x02,0x00]

v_sub_i32_e64 v5, s[12:13], v255, v2
// CHECK: [0x05,0x0c,0x4c,0xd2,0xff,0x05,0x02,0x00]

v_sub_i32_e64 v5, s[12:13], s1, v2
// CHECK: [0x05,0x0c,0x4c,0xd2,0x01,0x04,0x02,0x00]

v_sub_i32_e64 v5, s[12:13], s103, v2
// CHECK: [0x05,0x0c,0x4c,0xd2,0x67,0x04,0x02,0x00]

v_sub_i32_e64 v5, s[12:13], flat_scratch_lo, v2
// CHECK: [0x05,0x0c,0x4c,0xd2,0x68,0x04,0x02,0x00]

v_sub_i32_e64 v5, s[12:13], flat_scratch_hi, v2
// CHECK: [0x05,0x0c,0x4c,0xd2,0x69,0x04,0x02,0x00]

v_sub_i32_e64 v5, s[12:13], vcc_lo, v2
// CHECK: [0x05,0x0c,0x4c,0xd2,0x6a,0x04,0x02,0x00]

v_sub_i32_e64 v5, s[12:13], vcc_hi, v2
// CHECK: [0x05,0x0c,0x4c,0xd2,0x6b,0x04,0x02,0x00]

v_sub_i32_e64 v5, s[12:13], tba_lo, v2
// CHECK: [0x05,0x0c,0x4c,0xd2,0x6c,0x04,0x02,0x00]

v_sub_i32_e64 v5, s[12:13], tba_hi, v2
// CHECK: [0x05,0x0c,0x4c,0xd2,0x6d,0x04,0x02,0x00]

v_sub_i32_e64 v5, s[12:13], tma_lo, v2
// CHECK: [0x05,0x0c,0x4c,0xd2,0x6e,0x04,0x02,0x00]

v_sub_i32_e64 v5, s[12:13], tma_hi, v2
// CHECK: [0x05,0x0c,0x4c,0xd2,0x6f,0x04,0x02,0x00]

v_sub_i32_e64 v5, s[12:13], ttmp11, v2
// CHECK: [0x05,0x0c,0x4c,0xd2,0x7b,0x04,0x02,0x00]

v_sub_i32_e64 v5, s[12:13], m0, v2
// CHECK: [0x05,0x0c,0x4c,0xd2,0x7c,0x04,0x02,0x00]

v_sub_i32_e64 v5, s[12:13], exec_lo, v2
// CHECK: [0x05,0x0c,0x4c,0xd2,0x7e,0x04,0x02,0x00]

v_sub_i32_e64 v5, s[12:13], exec_hi, v2
// CHECK: [0x05,0x0c,0x4c,0xd2,0x7f,0x04,0x02,0x00]

v_sub_i32_e64 v5, s[12:13], 0, v2
// CHECK: [0x05,0x0c,0x4c,0xd2,0x80,0x04,0x02,0x00]

v_sub_i32_e64 v5, s[12:13], -1, v2
// CHECK: [0x05,0x0c,0x4c,0xd2,0xc1,0x04,0x02,0x00]

v_sub_i32_e64 v5, s[12:13], 0.5, v2
// CHECK: [0x05,0x0c,0x4c,0xd2,0xf0,0x04,0x02,0x00]

v_sub_i32_e64 v5, s[12:13], -4.0, v2
// CHECK: [0x05,0x0c,0x4c,0xd2,0xf7,0x04,0x02,0x00]

v_sub_i32_e64 v5, s[12:13], v1, v255
// CHECK: [0x05,0x0c,0x4c,0xd2,0x01,0xff,0x03,0x00]

v_sub_i32_e64 v5, s[12:13], v1, s2
// CHECK: [0x05,0x0c,0x4c,0xd2,0x01,0x05,0x00,0x00]

v_sub_i32_e64 v5, s[12:13], v1, s103
// CHECK: [0x05,0x0c,0x4c,0xd2,0x01,0xcf,0x00,0x00]

v_sub_i32_e64 v5, s[12:13], v1, flat_scratch_lo
// CHECK: [0x05,0x0c,0x4c,0xd2,0x01,0xd1,0x00,0x00]

v_sub_i32_e64 v5, s[12:13], v1, flat_scratch_hi
// CHECK: [0x05,0x0c,0x4c,0xd2,0x01,0xd3,0x00,0x00]

v_sub_i32_e64 v5, s[12:13], v1, vcc_lo
// CHECK: [0x05,0x0c,0x4c,0xd2,0x01,0xd5,0x00,0x00]

v_sub_i32_e64 v5, s[12:13], v1, vcc_hi
// CHECK: [0x05,0x0c,0x4c,0xd2,0x01,0xd7,0x00,0x00]

v_sub_i32_e64 v5, s[12:13], v1, tba_lo
// CHECK: [0x05,0x0c,0x4c,0xd2,0x01,0xd9,0x00,0x00]

v_sub_i32_e64 v5, s[12:13], v1, tba_hi
// CHECK: [0x05,0x0c,0x4c,0xd2,0x01,0xdb,0x00,0x00]

v_sub_i32_e64 v5, s[12:13], v1, tma_lo
// CHECK: [0x05,0x0c,0x4c,0xd2,0x01,0xdd,0x00,0x00]

v_sub_i32_e64 v5, s[12:13], v1, tma_hi
// CHECK: [0x05,0x0c,0x4c,0xd2,0x01,0xdf,0x00,0x00]

v_sub_i32_e64 v5, s[12:13], v1, ttmp11
// CHECK: [0x05,0x0c,0x4c,0xd2,0x01,0xf7,0x00,0x00]

v_sub_i32_e64 v5, s[12:13], v1, m0
// CHECK: [0x05,0x0c,0x4c,0xd2,0x01,0xf9,0x00,0x00]

v_sub_i32_e64 v5, s[12:13], v1, exec_lo
// CHECK: [0x05,0x0c,0x4c,0xd2,0x01,0xfd,0x00,0x00]

v_sub_i32_e64 