/////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2009-2011 Alan Wright. All rights reserved.
// Distributable under the terms of either the Apache License (Version 2.0)
// or the GNU Lesser General Public License.
/////////////////////////////////////////////////////////////////////////////

#ifndef CONSTANTSCOREQUERY_H
#define CONSTANTSCOREQUERY_H

#include "Query.h"
#include "Weight.h"
#include "Scorer.h"

namespace Lucene
{
    /// A query that wraps a filter and simply returns a constant score equal to the query boost for every 
    /// document in the filter.
    class LPPAPI ConstantScoreQuery : public Query
    {
    public:
        ConstantScoreQuery(FilterPtr filter);
        virtual ~ConstantScoreQuery();
    
        LUCENE_CLASS(ConstantScoreQuery);
    
    protected:
        FilterPtr filter;
    
    public:
        using Query::toString;
        
        /// Returns the encapsulated filter
        FilterPtr getFilter();
        
        virtual QueryPtr rewrite(IndexReaderPtr reader);
        virtual void extractTerms(SetTerm terms);
        
        virtual WeightPtr createWeight(SearcherPtr searcher);
        
        /// Prints a user-readable version of this query.
        virtual String toString(const String& field);
        
        virtual bool equals(LuceneObjectPtr other);
        virtual int32_t hashCode();
        virtual LuceneObjectPtr clone(LuceneObjectPtr other = LuceneObjectPtr());
        
        friend class ConstantWeight;
        friend class ConstantScorer;
    };
}

#endif
