/***************************************************************************
                          cmutex.h  -  mutex
                             -------------------
    begin                : Sun Sep 30 2001
    copyright            : (C) 2001-2004 by Mathias Küster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CMUTEX_H
#define CMUTEX_H

/**
 * @author Mathias Küster
 *
 * It's a mutex, only one thread can lock a mutex at a time, other threads
 * attempting to lock it when it is already locked will be blocked until it
 * is unlocked.
 *
 * It is not a recursive mutex, a thread locking an already locked mutex
 * will permenantly hang.
 */

#ifndef WIN32
#include <pthread.h>
#endif

#include <dclib/dcos.h>

class CMutex {
public:
	/** */
	CMutex();
	/** */
	virtual ~CMutex();

	/** */
	int Lock();
	/** */
	bool TryLock();
	/** */
	int UnLock();

private:
#ifdef WIN32
	/**
	 * Everything returns void so there's no bool with it.
	 * An exception may be thrown but dclib is not designed to
	 * handle running out of memory.
	 */
	CRITICAL_SECTION m_CS;
#else
	/** */
	bool m_bMutexInit;
	/** */
	pthread_mutex_t mutex;
#endif
};

#endif // CMUTEX_H
