/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper;

import com.google.caliper.ConfiguredBenchmark;
import com.google.caliper.Measurement;
import com.google.caliper.MeasurementSet;
import com.google.caliper.Measurer;
import com.google.caliper.UserException;
import com.google.common.base.Supplier;
import com.google.monitoring.runtime.instrumentation.AllocationRecorder;
import com.google.monitoring.runtime.instrumentation.Sampler;

public abstract class AllocationMeasurer
extends Measurer {
    protected static final int ALLOCATION_DISPLAY_THRESHOLD = 50;
    private boolean log = false;
    private long tempAllocationCount;
    private long allocationsToIgnore = 0L;
    private long numberOfAllocations = 0L;
    private long allocationCount = 0L;
    private long outOfThreadAllocationCount = 0L;
    private boolean recordAllocations = false;
    protected String type;

    protected AllocationMeasurer() {
        final Thread allocatingThread = Thread.currentThread();
        AllocationRecorder.addSampler((Sampler)new Sampler(){

            public void sampleAllocation(int count, String desc, Object newObj, long size) {
                if (AllocationMeasurer.this.recordAllocations) {
                    if (Thread.currentThread().equals(allocatingThread)) {
                        if (AllocationMeasurer.this.log) {
                            AllocationMeasurer.this.logAllocation(count, desc, size);
                        } else if (AllocationMeasurer.this.numberOfAllocations == 0L) {
                            AllocationMeasurer.this.log("see first run for list of allocations");
                        }
                        AllocationMeasurer.this.allocationCount = AllocationMeasurer.this.incrementAllocationCount(AllocationMeasurer.this.allocationCount, count, size);
                        AllocationMeasurer.this.tempAllocationCount++;
                        AllocationMeasurer.this.numberOfAllocations++;
                    } else {
                        AllocationMeasurer.this.outOfThreadAllocationCount = AllocationMeasurer.this.incrementAllocationCount(AllocationMeasurer.this.outOfThreadAllocationCount, count, size);
                        AllocationMeasurer.this.numberOfAllocations++;
                    }
                }
            }
        });
    }

    protected abstract long incrementAllocationCount(long var1, int var3, long var4);

    private void logAllocation(int count, String desc, long size) {
        if (this.numberOfAllocations >= this.allocationsToIgnore) {
            if (this.numberOfAllocations < 50L + this.allocationsToIgnore) {
                this.log("allocating " + desc + (count == -1 ? "" : " array with " + count + " elements") + " with size " + size + " bytes");
            } else if (this.numberOfAllocations == 50L + this.allocationsToIgnore) {
                this.log("...more allocations...");
            }
        }
    }

    @Override
    public MeasurementSet run(Supplier<ConfiguredBenchmark> testSupplier) throws Exception {
        this.measureAllocations((ConfiguredBenchmark)testSupplier.get(), 1, 0L);
        this.tempAllocationCount = 0L;
        long one = this.measureAllocationsTotal((ConfiguredBenchmark)testSupplier.get(), 1);
        long oneAllocations = this.tempAllocationCount;
        this.tempAllocationCount = 0L;
        long two = this.measureAllocationsTotal((ConfiguredBenchmark)testSupplier.get(), 2);
        long twoAllocations = this.tempAllocationCount;
        long expectedDiff = two - one;
        long unitsToIgnore = one - expectedDiff;
        this.allocationsToIgnore = 2L * oneAllocations - twoAllocations;
        this.log("ignoring " + this.allocationsToIgnore + " allocation(s) per measurement as overhead");
        Measurement[] allocationMeasurements = new Measurement[4];
        this.log = true;
        allocationMeasurements[0] = this.measureAllocations((ConfiguredBenchmark)testSupplier.get(), 1, unitsToIgnore);
        this.log = false;
        for (int i = 1; i < allocationMeasurements.length; ++i) {
            allocationMeasurements[i] = this.measureAllocations((ConfiguredBenchmark)testSupplier.get(), i + 1, unitsToIgnore);
            if (Math.round(allocationMeasurements[i].getRaw()) == expectedDiff) continue;
            throw new UserException.NonConstantMemoryUsage();
        }
        this.allocationsToIgnore = 0L;
        return new MeasurementSet(allocationMeasurements[0]);
    }

    private Measurement measureAllocations(ConfiguredBenchmark benchmark, int reps, long toIgnore) throws Exception {
        this.prepareForTest();
        this.log("[starting measured section]");
        this.resetAllocations();
        this.recordAllocations = true;
        benchmark.run(reps);
        this.recordAllocations = false;
        this.log("[done measured section]");
        long allocations = (this.allocationCount - toIgnore) / (long)reps;
        long outOfThreadAllocations = this.outOfThreadAllocationCount;
        this.log(allocations + " " + this.type + "(s) allocated per rep");
        this.log(outOfThreadAllocations + " out of thread " + this.type + "(s) allocated in " + reps + " reps");
        benchmark.close();
        return this.getMeasurement(benchmark, allocations);
    }

    protected abstract Measurement getMeasurement(ConfiguredBenchmark var1, long var2);

    private long measureAllocationsTotal(ConfiguredBenchmark benchmark, int reps) throws Exception {
        this.prepareForTest();
        this.log("[starting measured section]");
        this.resetAllocations();
        this.recordAllocations = true;
        benchmark.run(reps);
        this.recordAllocations = false;
        this.log("[done measured section]");
        long allocations = this.allocationCount;
        long outOfThreadAllocations = this.outOfThreadAllocationCount;
        this.log(allocations + " " + this.type + "(s) allocated in " + reps + " reps");
        if (outOfThreadAllocations > 0L) {
            this.log(outOfThreadAllocations + " out of thread " + this.type + "(s) allocated in " + reps + " reps");
        }
        benchmark.close();
        return allocations;
    }

    private void resetAllocations() {
        this.allocationCount = 0L;
        this.outOfThreadAllocationCount = 0L;
        this.numberOfAllocations = 0L;
    }
}

