/*
 * @(#)IClassMetaDataWriterUTestI.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.codecoverage.v2.datastore;

import java.io.IOException;

import net.sourceforge.groboutils.autodoc.v1.AutoDoc;
import net.sourceforge.groboutils.codecoverage.v2.CCCreatorUtil;
import net.sourceforge.groboutils.codecoverage.v2.compiler.ModifiedClass;
import net.sourceforge.groboutils.junit.v1.iftc.ImplFactory;
import net.sourceforge.groboutils.junit.v1.iftc.InterfaceTestCase;
import net.sourceforge.groboutils.junit.v1.iftc.InterfaceTestSuite;


/**
 * Tests the IClassMetaDataWriter interface.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version   $Date: 2004/04/15 05:48:28 $
 * @since     December 28, 2002
 */
public class IClassMetaDataWriterUTestI extends InterfaceTestCase
{
    //-------------------------------------------------------------------------
    // Standard JUnit Class-specific declarations
    
    private static final Class THIS_CLASS = IClassMetaDataWriterUTestI.class;
    private static final AutoDoc DOC = new AutoDoc( THIS_CLASS );
    
    public IClassMetaDataWriterUTestI( String name, ImplFactory f )
    {
        super( name, IClassMetaDataWriter.class, f );
    }

    
    public IClassMetaDataWriter createIClassMetaDataWriter()
    {
        return (IClassMetaDataWriter)createImplObject();
    }

    
    // This is the set that's used for creating the class records, if you
    // need it.  Note that the DirMetaDataIO class needs to have its set
    // of AMS match the incoming class records.
    public final static AnalysisModuleSet AMS =
        CCCreatorUtil.createAnalysisModuleSet( 2 );
    
    
    //-------------------------------------------------------------------------
    // Tests
    
    public void testWriteClassRecord1() throws Exception
    {
        IClassMetaDataWriter cmdw = createIClassMetaDataWriter();
        try
        {
            cmdw.writeClassRecord( null );
            fail( "Did not throw IllegalArgumentException." );
        }
        catch (IllegalArgumentException ex)
        {
            // test exception
        }
    }
    
    
    public void testWriteClassRecord2() throws Exception
    {
        IClassMetaDataWriter cmdw = createIClassMetaDataWriter();
        ModifiedClass mc = CCCreatorUtil.createModifiedClass( THIS_CLASS );
        ClassRecord cr = mc.createClassRecord( AMS );
        
        cmdw.writeClassRecord( cr );
        
        // any way to check this?
    }
    
    
    public void testClose1() throws Exception
    {
        IClassMetaDataWriter cmdw = createIClassMetaDataWriter();
        cmdw.close();
    }
    
    
    public void testClose2() throws Exception
    {
        IClassMetaDataWriter cmdw = createIClassMetaDataWriter();
        ModifiedClass mc = CCCreatorUtil.createModifiedClass( THIS_CLASS );
        ClassRecord cr = mc.createClassRecord( AMS );
        cmdw.close();
        
        try
        {
            cmdw.writeClassRecord( cr );
            fail( "Did not throw IOException." );
        }
        catch (IOException ex)
        {
            // test exception
        }
    }
    
    
    public void testClose3() throws Exception
    {
        IClassMetaDataWriter cmdw = createIClassMetaDataWriter();
        cmdw.close();
        
        try
        {
            cmdw.writeClassRecord( null );
            fail( "Did not throw IllegalArgumentException or IOException." );
        }
        // either of these two exceptions could be thrown
        catch (IllegalArgumentException ex)
        {
            // test exception
        }
        catch (IOException ex)
        {
            // test exception
        }
    }
    
    
    public void testClose4() throws Exception
    {
        IClassMetaDataWriter cmdw = createIClassMetaDataWriter();
        cmdw.close();
        
        try
        {
            cmdw.close();
            fail( "Did not throw IOException." );
        }
        catch (IOException ex)
        {
            // test exception
        }
    }
     
    
    
    //-------------------------------------------------------------------------
    // Standard JUnit declarations
    
    
    public static InterfaceTestSuite suite()
    {
        InterfaceTestSuite suite = new InterfaceTestSuite( THIS_CLASS );
        
        return suite;
    }
    
    public static void main( String[] args )
    {
        String[] name = { THIS_CLASS.getName() };
        
        // junit.textui.TestRunner.main( name );
        // junit.swingui.TestRunner.main( name );
        
        junit.textui.TestRunner.main( name );
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void setUp() throws Exception
    {
        super.setUp();
        
        // set ourself up
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void tearDown() throws Exception
    {
        // tear ourself down
        
        
        super.tearDown();
    }
}

