/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.managed.api;

import java.util.Map;
import java.util.Set;

import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ManagementObjectID;
import org.jboss.managed.api.annotation.ManagementRuntimeRef;

/**
 * An extension of ManagedObject that allows setting of key values after
 * the ManagedObject has been created.
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision: 80522 $
 */
public interface MutableManagedObject extends ManagedObject
{
   /**
    * Set the external name by which the ManagedObject is known
    * @see {@linkplain ManagementObject#name}}
    * @see {@linkplain ManagementObjectID#name}}
    * @return the name
    */
   public void setName(String name);
   /**
    * Set the runtime component name.
    *
    * @see {@linkplain ManagementRuntimeRef}
    * @return name of runtime component if one exists, null if no component exists.
    */
   public void setComponentName(Object name);
   /**
    * Set the parent ManagedObject.
    * @param parent - the parent ManagedObject, null if no parent exists.
    */
   public void setParent(ManagedObject parent);
   /**
    * Set the metadata attachment.
    * @param attachment - the metadata attachment this ManagedObject maps to.
    */
   public void setAttachment(Object attachment);
   /**
    * Set the ManagedObject ManagedProperty mapping.
    * @param properties - the ManagedProperty mapping.
    */
   public void setProperties(Map<String, ManagedProperty> properties);
   /**
    * Set the ManagedOperation associated with the ManagedObject.
    * @param operations - the ManagedOperations for the ManagedObject.
    */
   public void setOperations(Set<ManagedOperation> operations);
}
