/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteBufferImpl;
import java.nio.ShortBuffer;
import java.nio.ShortBufferImpl;

class HeapShortBuffer
extends ShortBufferImpl {
    HeapShortBuffer(int n, short[] sArray, int n2) {
        super(null, n, sArray, n2);
    }

    public boolean isDirect() {
        return false;
    }

    public ShortBuffer slice() {
        return new HeapShortBuffer(this.limit - this.position, this.array, this.arrayOffset + this.position);
    }

    public short get(int n) {
        return this.array[this.arrayOffset + this.checkIndex(n)];
    }

    final void copyToArray(short[] sArray, int n, int n2) {
        System.arraycopy(this.array, this.arrayOffset + this.position, sArray, n, n2);
    }

    public ShortBuffer put(int n, short s) {
        this.array[this.arrayOffset + this.checkIndex((int)n)] = s;
        return this;
    }

    void copyFromArray(short[] sArray, int n, int n2) {
        System.arraycopy(sArray, n, this.array, this.arrayOffset + this.position, n2);
    }

    void copyToShortBuffer(int n, ShortBuffer shortBuffer) {
        shortBuffer.copyFromHeapShortBuffer(this, n);
    }

    void copyFromHeapShortBuffer(ShortBuffer shortBuffer, int n) {
        System.arraycopy(shortBuffer.array, shortBuffer.arrayOffset + shortBuffer.position, this.array, this.arrayOffset + this.position, n);
    }

    void copyFromByteBufferAsShortBuffer(ShortBuffer shortBuffer, int n) {
        HeapShortBuffer.vanillaCopy(shortBuffer, this, n);
    }

    void copyFromDirectShortBuffer(ShortBuffer shortBuffer, int n) {
        int n2 = shortBuffer.arrayOffset + (shortBuffer.position << 1);
        ByteBufferImpl.memoryToShortArray(n2, this.array, this.arrayOffset + this.position, n);
    }
}

