=head1 NAME

Locale::SubCountry::Codes - data for Locale::SubCountry in JSON format

=head1 DESCRIPTION

Internal data for the Locale::SubCountry module

NOTE, THIS FILE IS CREATED WITH UTF-8 ENCODING. THIS SHOULD NOT BE CHANGED.

=head1 SOURCE

All codes have been downloaded from the latest version of the Debian Salsa project
L<https://salsa.debian.org/iso-codes-team/iso-codes/-/tree/main/data>
and then files iso_3166-1.json, iso_3166-2.json


=cut
#------------------------------------------------------------------------------
use utf8;
use strict;
use warnings;

our $VERSION = '2.07';
package Locale::SubCountry::Codes;

$Locale::SubCountry::Codes::JSON =
q{
{
  "3166-1": [
    {
      "alpha_2": "AW",
      "alpha_3": "ABW",
      "name": "Aruba",
      "numeric": "533"
    },
    {
      "alpha_2": "AF",
      "alpha_3": "AFG",
      "name": "Afghanistan",
      "numeric": "004",
      "official_name": "Islamic Republic of Afghanistan"
    },
    {
      "alpha_2": "AO",
      "alpha_3": "AGO",
      "name": "Angola",
      "numeric": "024",
      "official_name": "Republic of Angola"
    },
    {
      "alpha_2": "AI",
      "alpha_3": "AIA",
      "name": "Anguilla",
      "numeric": "660"
    },
    {
      "alpha_2": "AX",
      "alpha_3": "ALA",
      "name": "Åland Islands",
      "numeric": "248"
    },
    {
      "alpha_2": "AL",
      "alpha_3": "ALB",
      "name": "Albania",
      "numeric": "008",
      "official_name": "Republic of Albania"
    },
    {
      "alpha_2": "AD",
      "alpha_3": "AND",
      "name": "Andorra",
      "numeric": "020",
      "official_name": "Principality of Andorra"
    },
    {
      "alpha_2": "AE",
      "alpha_3": "ARE",
      "name": "United Arab Emirates",
      "numeric": "784"
    },
    {
      "alpha_2": "AR",
      "alpha_3": "ARG",
      "name": "Argentina",
      "numeric": "032",
      "official_name": "Argentine Republic"
    },
    {
      "alpha_2": "AM",
      "alpha_3": "ARM",
      "name": "Armenia",
      "numeric": "051",
      "official_name": "Republic of Armenia"
    },
    {
      "alpha_2": "AS",
      "alpha_3": "ASM",
      "name": "American Samoa",
      "numeric": "016"
    },
    {
      "alpha_2": "AQ",
      "alpha_3": "ATA",
      "name": "Antarctica",
      "numeric": "010"
    },
    {
      "alpha_2": "TF",
      "alpha_3": "ATF",
      "name": "French Southern Territories",
      "numeric": "260"
    },
    {
      "alpha_2": "AG",
      "alpha_3": "ATG",
      "name": "Antigua and Barbuda",
      "numeric": "028"
    },
    {
      "alpha_2": "AU",
      "alpha_3": "AUS",
      "name": "Australia",
      "numeric": "036"
    },
    {
      "alpha_2": "AT",
      "alpha_3": "AUT",
      "name": "Austria",
      "numeric": "040",
      "official_name": "Republic of Austria"
    },
    {
      "alpha_2": "AZ",
      "alpha_3": "AZE",
      "name": "Azerbaijan",
      "numeric": "031",
      "official_name": "Republic of Azerbaijan"
    },
    {
      "alpha_2": "BI",
      "alpha_3": "BDI",
      "name": "Burundi",
      "numeric": "108",
      "official_name": "Republic of Burundi"
    },
    {
      "alpha_2": "BE",
      "alpha_3": "BEL",
      "name": "Belgium",
      "numeric": "056",
      "official_name": "Kingdom of Belgium"
    },
    {
      "alpha_2": "BJ",
      "alpha_3": "BEN",
      "name": "Benin",
      "numeric": "204",
      "official_name": "Republic of Benin"
    },
    {
      "alpha_2": "BQ",
      "alpha_3": "BES",
      "name": "Bonaire, Sint Eustatius and Saba",
      "numeric": "535",
      "official_name": "Bonaire, Sint Eustatius and Saba"
    },
    {
      "alpha_2": "BF",
      "alpha_3": "BFA",
      "name": "Burkina Faso",
      "numeric": "854"
    },
    {
      "alpha_2": "BD",
      "alpha_3": "BGD",
      "name": "Bangladesh",
      "numeric": "050",
      "official_name": "People's Republic of Bangladesh"
    },
    {
      "alpha_2": "BG",
      "alpha_3": "BGR",
      "name": "Bulgaria",
      "numeric": "100",
      "official_name": "Republic of Bulgaria"
    },
    {
      "alpha_2": "BH",
      "alpha_3": "BHR",
      "name": "Bahrain",
      "numeric": "048",
      "official_name": "Kingdom of Bahrain"
    },
    {
      "alpha_2": "BS",
      "alpha_3": "BHS",
      "name": "Bahamas",
      "numeric": "044",
      "official_name": "Commonwealth of the Bahamas"
    },
    {
      "alpha_2": "BA",
      "alpha_3": "BIH",
      "name": "Bosnia and Herzegovina",
      "numeric": "070",
      "official_name": "Republic of Bosnia and Herzegovina"
    },
    {
      "alpha_2": "BL",
      "alpha_3": "BLM",
      "name": "Saint Barthélemy",
      "numeric": "652"
    },
    {
      "alpha_2": "BY",
      "alpha_3": "BLR",
      "name": "Belarus",
      "numeric": "112",
      "official_name": "Republic of Belarus"
    },
    {
      "alpha_2": "BZ",
      "alpha_3": "BLZ",
      "name": "Belize",
      "numeric": "084"
    },
    {
      "alpha_2": "BM",
      "alpha_3": "BMU",
      "name": "Bermuda",
      "numeric": "060"
    },
    {
      "alpha_2": "BO",
      "alpha_3": "BOL",
      "common_name": "Bolivia",
      "name": "Bolivia, Plurinational State of",
      "numeric": "068",
      "official_name": "Plurinational State of Bolivia"
    },
    {
      "alpha_2": "BR",
      "alpha_3": "BRA",
      "name": "Brazil",
      "numeric": "076",
      "official_name": "Federative Republic of Brazil"
    },
    {
      "alpha_2": "BB",
      "alpha_3": "BRB",
      "name": "Barbados",
      "numeric": "052"
    },
    {
      "alpha_2": "BN",
      "alpha_3": "BRN",
      "name": "Brunei Darussalam",
      "numeric": "096"
    },
    {
      "alpha_2": "BT",
      "alpha_3": "BTN",
      "name": "Bhutan",
      "numeric": "064",
      "official_name": "Kingdom of Bhutan"
    },
    {
      "alpha_2": "BV",
      "alpha_3": "BVT",
      "name": "Bouvet Island",
      "numeric": "074"
    },
    {
      "alpha_2": "BW",
      "alpha_3": "BWA",
      "name": "Botswana",
      "numeric": "072",
      "official_name": "Republic of Botswana"
    },
    {
      "alpha_2": "CF",
      "alpha_3": "CAF",
      "name": "Central African Republic",
      "numeric": "140"
    },
    {
      "alpha_2": "CA",
      "alpha_3": "CAN",
      "name": "Canada",
      "numeric": "124"
    },
    {
      "alpha_2": "CC",
      "alpha_3": "CCK",
      "name": "Cocos (Keeling) Islands",
      "numeric": "166"
    },
    {
      "alpha_2": "CH",
      "alpha_3": "CHE",
      "name": "Switzerland",
      "numeric": "756",
      "official_name": "Swiss Confederation"
    },
    {
      "alpha_2": "CL",
      "alpha_3": "CHL",
      "name": "Chile",
      "numeric": "152",
      "official_name": "Republic of Chile"
    },
    {
      "alpha_2": "CN",
      "alpha_3": "CHN",
      "name": "China",
      "numeric": "156",
      "official_name": "People's Republic of China"
    },
    {
      "alpha_2": "CI",
      "alpha_3": "CIV",
      "name": "Côte d'Ivoire",
      "numeric": "384",
      "official_name": "Republic of Côte d'Ivoire"
    },
    {
      "alpha_2": "CM",
      "alpha_3": "CMR",
      "name": "Cameroon",
      "numeric": "120",
      "official_name": "Republic of Cameroon"
    },
    {
      "alpha_2": "CD",
      "alpha_3": "COD",
      "name": "Congo, The Democratic Republic of the",
      "numeric": "180"
    },
    {
      "alpha_2": "CG",
      "alpha_3": "COG",
      "name": "Congo",
      "numeric": "178",
      "official_name": "Republic of the Congo"
    },
    {
      "alpha_2": "CK",
      "alpha_3": "COK",
      "name": "Cook Islands",
      "numeric": "184"
    },
    {
      "alpha_2": "CO",
      "alpha_3": "COL",
      "name": "Colombia",
      "numeric": "170",
      "official_name": "Republic of Colombia"
    },
    {
      "alpha_2": "KM",
      "alpha_3": "COM",
      "name": "Comoros",
      "numeric": "174",
      "official_name": "Union of the Comoros"
    },
    {
      "alpha_2": "CV",
      "alpha_3": "CPV",
      "name": "Cabo Verde",
      "numeric": "132",
      "official_name": "Republic of Cabo Verde"
    },
    {
      "alpha_2": "CR",
      "alpha_3": "CRI",
      "name": "Costa Rica",
      "numeric": "188",
      "official_name": "Republic of Costa Rica"
    },
    {
      "alpha_2": "CU",
      "alpha_3": "CUB",
      "name": "Cuba",
      "numeric": "192",
      "official_name": "Republic of Cuba"
    },
    {
      "alpha_2": "CW",
      "alpha_3": "CUW",
      "name": "Curaçao",
      "numeric": "531",
      "official_name": "Curaçao"
    },
    {
      "alpha_2": "CX",
      "alpha_3": "CXR",
      "name": "Christmas Island",
      "numeric": "162"
    },
    {
      "alpha_2": "KY",
      "alpha_3": "CYM",
      "name": "Cayman Islands",
      "numeric": "136"
    },
    {
      "alpha_2": "CY",
      "alpha_3": "CYP",
      "name": "Cyprus",
      "numeric": "196",
      "official_name": "Republic of Cyprus"
    },
    {
      "alpha_2": "CZ",
      "alpha_3": "CZE",
      "name": "Czechia",
      "numeric": "203",
      "official_name": "Czech Republic"
    },
    {
      "alpha_2": "DE",
      "alpha_3": "DEU",
      "name": "Germany",
      "numeric": "276",
      "official_name": "Federal Republic of Germany"
    },
    {
      "alpha_2": "DJ",
      "alpha_3": "DJI",
      "name": "Djibouti",
      "numeric": "262",
      "official_name": "Republic of Djibouti"
    },
    {
      "alpha_2": "DM",
      "alpha_3": "DMA",
      "name": "Dominica",
      "numeric": "212",
      "official_name": "Commonwealth of Dominica"
    },
    {
      "alpha_2": "DK",
      "alpha_3": "DNK",
      "name": "Denmark",
      "numeric": "208",
      "official_name": "Kingdom of Denmark"
    },
    {
      "alpha_2": "DO",
      "alpha_3": "DOM",
      "name": "Dominican Republic",
      "numeric": "214"
    },
    {
      "alpha_2": "DZ",
      "alpha_3": "DZA",
      "name": "Algeria",
      "numeric": "012",
      "official_name": "People's Democratic Republic of Algeria"
    },
    {
      "alpha_2": "EC",
      "alpha_3": "ECU",
      "name": "Ecuador",
      "numeric": "218",
      "official_name": "Republic of Ecuador"
    },
    {
      "alpha_2": "EG",
      "alpha_3": "EGY",
      "name": "Egypt",
      "numeric": "818",
      "official_name": "Arab Republic of Egypt"
    },
    {
      "alpha_2": "ER",
      "alpha_3": "ERI",
      "name": "Eritrea",
      "numeric": "232",
      "official_name": "the State of Eritrea"
    },
    {
      "alpha_2": "EH",
      "alpha_3": "ESH",
      "name": "Western Sahara",
      "numeric": "732"
    },
    {
      "alpha_2": "ES",
      "alpha_3": "ESP",
      "name": "Spain",
      "numeric": "724",
      "official_name": "Kingdom of Spain"
    },
    {
      "alpha_2": "EE",
      "alpha_3": "EST",
      "name": "Estonia",
      "numeric": "233",
      "official_name": "Republic of Estonia"
    },
    {
      "alpha_2": "ET",
      "alpha_3": "ETH",
      "name": "Ethiopia",
      "numeric": "231",
      "official_name": "Federal Democratic Republic of Ethiopia"
    },
    {
      "alpha_2": "FI",
      "alpha_3": "FIN",
      "name": "Finland",
      "numeric": "246",
      "official_name": "Republic of Finland"
    },
    {
      "alpha_2": "FJ",
      "alpha_3": "FJI",
      "name": "Fiji",
      "numeric": "242",
      "official_name": "Republic of Fiji"
    },
    {
      "alpha_2": "FK",
      "alpha_3": "FLK",
      "name": "Falkland Islands (Malvinas)",
      "numeric": "238"
    },
    {
      "alpha_2": "FR",
      "alpha_3": "FRA",
      "name": "France",
      "numeric": "250",
      "official_name": "French Republic"
    },
    {
      "alpha_2": "FO",
      "alpha_3": "FRO",
      "name": "Faroe Islands",
      "numeric": "234"
    },
    {
      "alpha_2": "FM",
      "alpha_3": "FSM",
      "name": "Micronesia, Federated States of",
      "numeric": "583",
      "official_name": "Federated States of Micronesia"
    },
    {
      "alpha_2": "GA",
      "alpha_3": "GAB",
      "name": "Gabon",
      "numeric": "266",
      "official_name": "Gabonese Republic"
    },
    {
      "alpha_2": "GB",
      "alpha_3": "GBR",
      "name": "United Kingdom",
      "numeric": "826",
      "official_name": "United Kingdom of Great Britain and Northern Ireland"
    },
    {
      "alpha_2": "GE",
      "alpha_3": "GEO",
      "name": "Georgia",
      "numeric": "268"
    },
    {
      "alpha_2": "GG",
      "alpha_3": "GGY",
      "name": "Guernsey",
      "numeric": "831"
    },
    {
      "alpha_2": "GH",
      "alpha_3": "GHA",
      "name": "Ghana",
      "numeric": "288",
      "official_name": "Republic of Ghana"
    },
    {
      "alpha_2": "GI",
      "alpha_3": "GIB",
      "name": "Gibraltar",
      "numeric": "292"
    },
    {
      "alpha_2": "GN",
      "alpha_3": "GIN",
      "name": "Guinea",
      "numeric": "324",
      "official_name": "Republic of Guinea"
    },
    {
      "alpha_2": "GP",
      "alpha_3": "GLP",
      "name": "Guadeloupe",
      "numeric": "312"
    },
    {
      "alpha_2": "GM",
      "alpha_3": "GMB",
      "name": "Gambia",
      "numeric": "270",
      "official_name": "Republic of the Gambia"
    },
    {
      "alpha_2": "GW",
      "alpha_3": "GNB",
      "name": "Guinea-Bissau",
      "numeric": "624",
      "official_name": "Republic of Guinea-Bissau"
    },
    {
      "alpha_2": "GQ",
      "alpha_3": "GNQ",
      "name": "Equatorial Guinea",
      "numeric": "226",
      "official_name": "Republic of Equatorial Guinea"
    },
    {
      "alpha_2": "GR",
      "alpha_3": "GRC",
      "name": "Greece",
      "numeric": "300",
      "official_name": "Hellenic Republic"
    },
    {
      "alpha_2": "GD",
      "alpha_3": "GRD",
      "name": "Grenada",
      "numeric": "308"
    },
    {
      "alpha_2": "GL",
      "alpha_3": "GRL",
      "name": "Greenland",
      "numeric": "304"
    },
    {
      "alpha_2": "GT",
      "alpha_3": "GTM",
      "name": "Guatemala",
      "numeric": "320",
      "official_name": "Republic of Guatemala"
    },
    {
      "alpha_2": "GF",
      "alpha_3": "GUF",
      "name": "French Guiana",
      "numeric": "254"
    },
    {
      "alpha_2": "GU",
      "alpha_3": "GUM",
      "name": "Guam",
      "numeric": "316"
    },
    {
      "alpha_2": "GY",
      "alpha_3": "GUY",
      "name": "Guyana",
      "numeric": "328",
      "official_name": "Republic of Guyana"
    },
    {
      "alpha_2": "HK",
      "alpha_3": "HKG",
      "name": "Hong Kong",
      "numeric": "344",
      "official_name": "Hong Kong Special Administrative Region of China"
    },
    {
      "alpha_2": "HM",
      "alpha_3": "HMD",
      "name": "Heard Island and McDonald Islands",
      "numeric": "334"
    },
    {
      "alpha_2": "HN",
      "alpha_3": "HND",
      "name": "Honduras",
      "numeric": "340",
      "official_name": "Republic of Honduras"
    },
    {
      "alpha_2": "HR",
      "alpha_3": "HRV",
      "name": "Croatia",
      "numeric": "191",
      "official_name": "Republic of Croatia"
    },
    {
      "alpha_2": "HT",
      "alpha_3": "HTI",
      "name": "Haiti",
      "numeric": "332",
      "official_name": "Republic of Haiti"
    },
    {
      "alpha_2": "HU",
      "alpha_3": "HUN",
      "name": "Hungary",
      "numeric": "348",
      "official_name": "Hungary"
    },
    {
      "alpha_2": "ID",
      "alpha_3": "IDN",
      "name": "Indonesia",
      "numeric": "360",
      "official_name": "Republic of Indonesia"
    },
    {
      "alpha_2": "IM",
      "alpha_3": "IMN",
      "name": "Isle of Man",
      "numeric": "833"
    },
    {
      "alpha_2": "IN",
      "alpha_3": "IND",
      "name": "India",
      "numeric": "356",
      "official_name": "Republic of India"
    },
    {
      "alpha_2": "IO",
      "alpha_3": "IOT",
      "name": "British Indian Ocean Territory",
      "numeric": "086"
    },
    {
      "alpha_2": "IE",
      "alpha_3": "IRL",
      "name": "Ireland",
      "numeric": "372"
    },
    {
      "alpha_2": "IR",
      "alpha_3": "IRN",
      "name": "Iran, Islamic Republic of",
      "numeric": "364",
      "official_name": "Islamic Republic of Iran"
    },
    {
      "alpha_2": "IQ",
      "alpha_3": "IRQ",
      "name": "Iraq",
      "numeric": "368",
      "official_name": "Republic of Iraq"
    },
    {
      "alpha_2": "IS",
      "alpha_3": "ISL",
      "name": "Iceland",
      "numeric": "352",
      "official_name": "Republic of Iceland"
    },
    {
      "alpha_2": "IL",
      "alpha_3": "ISR",
      "name": "Israel",
      "numeric": "376",
      "official_name": "State of Israel"
    },
    {
      "alpha_2": "IT",
      "alpha_3": "ITA",
      "name": "Italy",
      "numeric": "380",
      "official_name": "Italian Republic"
    },
    {
      "alpha_2": "JM",
      "alpha_3": "JAM",
      "name": "Jamaica",
      "numeric": "388"
    },
    {
      "alpha_2": "JE",
      "alpha_3": "JEY",
      "name": "Jersey",
      "numeric": "832"
    },
    {
      "alpha_2": "JO",
      "alpha_3": "JOR",
      "name": "Jordan",
      "numeric": "400",
      "official_name": "Hashemite Kingdom of Jordan"
    },
    {
      "alpha_2": "JP",
      "alpha_3": "JPN",
      "name": "Japan",
      "numeric": "392"
    },
    {
      "alpha_2": "KZ",
      "alpha_3": "KAZ",
      "name": "Kazakhstan",
      "numeric": "398",
      "official_name": "Republic of Kazakhstan"
    },
    {
      "alpha_2": "KE",
      "alpha_3": "KEN",
      "name": "Kenya",
      "numeric": "404",
      "official_name": "Republic of Kenya"
    },
    {
      "alpha_2": "KG",
      "alpha_3": "KGZ",
      "name": "Kyrgyzstan",
      "numeric": "417",
      "official_name": "Kyrgyz Republic"
    },
    {
      "alpha_2": "KH",
      "alpha_3": "KHM",
      "name": "Cambodia",
      "numeric": "116",
      "official_name": "Kingdom of Cambodia"
    },
    {
      "alpha_2": "KI",
      "alpha_3": "KIR",
      "name": "Kiribati",
      "numeric": "296",
      "official_name": "Republic of Kiribati"
    },
    {
      "alpha_2": "KN",
      "alpha_3": "KNA",
      "name": "Saint Kitts and Nevis",
      "numeric": "659"
    },
    {
      "alpha_2": "KR",
      "alpha_3": "KOR",
      "name": "Korea, Republic of",
      "numeric": "410"
    },
    {
      "alpha_2": "KW",
      "alpha_3": "KWT",
      "name": "Kuwait",
      "numeric": "414",
      "official_name": "State of Kuwait"
    },
    {
      "alpha_2": "LA",
      "alpha_3": "LAO",
      "name": "Lao People's Democratic Republic",
      "numeric": "418"
    },
    {
      "alpha_2": "LB",
      "alpha_3": "LBN",
      "name": "Lebanon",
      "numeric": "422",
      "official_name": "Lebanese Republic"
    },
    {
      "alpha_2": "LR",
      "alpha_3": "LBR",
      "name": "Liberia",
      "numeric": "430",
      "official_name": "Republic of Liberia"
    },
    {
      "alpha_2": "LY",
      "alpha_3": "LBY",
      "name": "Libya",
      "numeric": "434",
      "official_name": "Libya"
    },
    {
      "alpha_2": "LC",
      "alpha_3": "LCA",
      "name": "Saint Lucia",
      "numeric": "662"
    },
    {
      "alpha_2": "LI",
      "alpha_3": "LIE",
      "name": "Liechtenstein",
      "numeric": "438",
      "official_name": "Principality of Liechtenstein"
    },
    {
      "alpha_2": "LK",
      "alpha_3": "LKA",
      "name": "Sri Lanka",
      "numeric": "144",
      "official_name": "Democratic Socialist Republic of Sri Lanka"
    },
    {
      "alpha_2": "LS",
      "alpha_3": "LSO",
      "name": "Lesotho",
      "numeric": "426",
      "official_name": "Kingdom of Lesotho"
    },
    {
      "alpha_2": "LT",
      "alpha_3": "LTU",
      "name": "Lithuania",
      "numeric": "440",
      "official_name": "Republic of Lithuania"
    },
    {
      "alpha_2": "LU",
      "alpha_3": "LUX",
      "name": "Luxembourg",
      "numeric": "442",
      "official_name": "Grand Duchy of Luxembourg"
    },
    {
      "alpha_2": "LV",
      "alpha_3": "LVA",
      "name": "Latvia",
      "numeric": "428",
      "official_name": "Republic of Latvia"
    },
    {
      "alpha_2": "MO",
      "alpha_3": "MAC",
      "name": "Macao",
      "numeric": "446",
      "official_name": "Macao Special Administrative Region of China"
    },
    {
      "alpha_2": "MF",
      "alpha_3": "MAF",
      "name": "Saint Martin (French part)",
      "numeric": "663"
    },
    {
      "alpha_2": "MA",
      "alpha_3": "MAR",
      "name": "Morocco",
      "numeric": "504",
      "official_name": "Kingdom of Morocco"
    },
    {
      "alpha_2": "MC",
      "alpha_3": "MCO",
      "name": "Monaco",
      "numeric": "492",
      "official_name": "Principality of Monaco"
    },
    {
      "alpha_2": "MD",
      "alpha_3": "MDA",
      "common_name": "Moldova",
      "name": "Moldova, Republic of",
      "numeric": "498",
      "official_name": "Republic of Moldova"
    },
    {
      "alpha_2": "MG",
      "alpha_3": "MDG",
      "name": "Madagascar",
      "numeric": "450",
      "official_name": "Republic of Madagascar"
    },
    {
      "alpha_2": "MV",
      "alpha_3": "MDV",
      "name": "Maldives",
      "numeric": "462",
      "official_name": "Republic of Maldives"
    },
    {
      "alpha_2": "MX",
      "alpha_3": "MEX",
      "name": "Mexico",
      "numeric": "484",
      "official_name": "United Mexican States"
    },
    {
      "alpha_2": "MH",
      "alpha_3": "MHL",
      "name": "Marshall Islands",
      "numeric": "584",
      "official_name": "Republic of the Marshall Islands"
    },
    {
      "alpha_2": "MK",
      "alpha_3": "MKD",
      "name": "North Macedonia",
      "numeric": "807",
      "official_name": "Republic of North Macedonia"
    },
    {
      "alpha_2": "ML",
      "alpha_3": "MLI",
      "name": "Mali",
      "numeric": "466",
      "official_name": "Republic of Mali"
    },
    {
      "alpha_2": "MT",
      "alpha_3": "MLT",
      "name": "Malta",
      "numeric": "470",
      "official_name": "Republic of Malta"
    },
    {
      "alpha_2": "MM",
      "alpha_3": "MMR",
      "name": "Myanmar",
      "numeric": "104",
      "official_name": "Republic of Myanmar"
    },
    {
      "alpha_2": "ME",
      "alpha_3": "MNE",
      "name": "Montenegro",
      "numeric": "499",
      "official_name": "Montenegro"
    },
    {
      "alpha_2": "MN",
      "alpha_3": "MNG",
      "name": "Mongolia",
      "numeric": "496"
    },
    {
      "alpha_2": "MP",
      "alpha_3": "MNP",
      "name": "Northern Mariana Islands",
      "numeric": "580",
      "official_name": "Commonwealth of the Northern Mariana Islands"
    },
    {
      "alpha_2": "MZ",
      "alpha_3": "MOZ",
      "name": "Mozambique",
      "numeric": "508",
      "official_name": "Republic of Mozambique"
    },
    {
      "alpha_2": "MR",
      "alpha_3": "MRT",
      "name": "Mauritania",
      "numeric": "478",
      "official_name": "Islamic Republic of Mauritania"
    },
    {
      "alpha_2": "MS",
      "alpha_3": "MSR",
      "name": "Montserrat",
      "numeric": "500"
    },
    {
      "alpha_2": "MQ",
      "alpha_3": "MTQ",
      "name": "Martinique",
      "numeric": "474"
    },
    {
      "alpha_2": "MU",
      "alpha_3": "MUS",
      "name": "Mauritius",
      "numeric": "480",
      "official_name": "Republic of Mauritius"
    },
    {
      "alpha_2": "MW",
      "alpha_3": "MWI",
      "name": "Malawi",
      "numeric": "454",
      "official_name": "Republic of Malawi"
    },
    {
      "alpha_2": "MY",
      "alpha_3": "MYS",
      "name": "Malaysia",
      "numeric": "458"
    },
    {
      "alpha_2": "YT",
      "alpha_3": "MYT",
      "name": "Mayotte",
      "numeric": "175"
    },
    {
      "alpha_2": "NA",
      "alpha_3": "NAM",
      "name": "Namibia",
      "numeric": "516",
      "official_name": "Republic of Namibia"
    },
    {
      "alpha_2": "NC",
      "alpha_3": "NCL",
      "name": "New Caledonia",
      "numeric": "540"
    },
    {
      "alpha_2": "NE",
      "alpha_3": "NER",
      "name": "Niger",
      "numeric": "562",
      "official_name": "Republic of the Niger"
    },
    {
      "alpha_2": "NF",
      "alpha_3": "NFK",
      "name": "Norfolk Island",
      "numeric": "574"
    },
    {
      "alpha_2": "NG",
      "alpha_3": "NGA",
      "name": "Nigeria",
      "numeric": "566",
      "official_name": "Federal Republic of Nigeria"
    },
    {
      "alpha_2": "NI",
      "alpha_3": "NIC",
      "name": "Nicaragua",
      "numeric": "558",
      "official_name": "Republic of Nicaragua"
    },
    {
      "alpha_2": "NU",
      "alpha_3": "NIU",
      "name": "Niue",
      "numeric": "570",
      "official_name": "Niue"
    },
    {
      "alpha_2": "NL",
      "alpha_3": "NLD",
      "name": "Netherlands",
      "numeric": "528",
      "official_name": "Kingdom of the Netherlands"
    },
    {
      "alpha_2": "NO",
      "alpha_3": "NOR",
      "name": "Norway",
      "numeric": "578",
      "official_name": "Kingdom of Norway"
    },
    {
      "alpha_2": "NP",
      "alpha_3": "NPL",
      "name": "Nepal",
      "numeric": "524",
      "official_name": "Federal Democratic Republic of Nepal"
    },
    {
      "alpha_2": "NR",
      "alpha_3": "NRU",
      "name": "Nauru",
      "numeric": "520",
      "official_name": "Republic of Nauru"
    },
    {
      "alpha_2": "NZ",
      "alpha_3": "NZL",
      "name": "New Zealand",
      "numeric": "554"
    },
    {
      "alpha_2": "OM",
      "alpha_3": "OMN",
      "name": "Oman",
      "numeric": "512",
      "official_name": "Sultanate of Oman"
    },
    {
      "alpha_2": "PK",
      "alpha_3": "PAK",
      "name": "Pakistan",
      "numeric": "586",
      "official_name": "Islamic Republic of Pakistan"
    },
    {
      "alpha_2": "PA",
      "alpha_3": "PAN",
      "name": "Panama",
      "numeric": "591",
      "official_name": "Republic of Panama"
    },
    {
      "alpha_2": "PN",
      "alpha_3": "PCN",
      "name": "Pitcairn",
      "numeric": "612"
    },
    {
      "alpha_2": "PE",
      "alpha_3": "PER",
      "name": "Peru",
      "numeric": "604",
      "official_name": "Republic of Peru"
    },
    {
      "alpha_2": "PH",
      "alpha_3": "PHL",
      "name": "Philippines",
      "numeric": "608",
      "official_name": "Republic of the Philippines"
    },
    {
      "alpha_2": "PW",
      "alpha_3": "PLW",
      "name": "Palau",
      "numeric": "585",
      "official_name": "Republic of Palau"
    },
    {
      "alpha_2": "PG",
      "alpha_3": "PNG",
      "name": "Papua New Guinea",
      "numeric": "598",
      "official_name": "Independent State of Papua New Guinea"
    },
    {
      "alpha_2": "PL",
      "alpha_3": "POL",
      "name": "Poland",
      "numeric": "616",
      "official_name": "Republic of Poland"
    },
    {
      "alpha_2": "PR",
      "alpha_3": "PRI",
      "name": "Puerto Rico",
      "numeric": "630"
    },
    {
      "alpha_2": "KP",
      "alpha_3": "PRK",
      "name": "Korea, Democratic People's Republic of",
      "numeric": "408",
      "official_name": "Democratic People's Republic of Korea"
    },
    {
      "alpha_2": "PT",
      "alpha_3": "PRT",
      "name": "Portugal",
      "numeric": "620",
      "official_name": "Portuguese Republic"
    },
    {
      "alpha_2": "PY",
      "alpha_3": "PRY",
      "name": "Paraguay",
      "numeric": "600",
      "official_name": "Republic of Paraguay"
    },
    {
      "alpha_2": "PS",
      "alpha_3": "PSE",
      "name": "Palestine, State of",
      "numeric": "275",
      "official_name": "the State of Palestine"
    },
    {
      "alpha_2": "PF",
      "alpha_3": "PYF",
      "name": "French Polynesia",
      "numeric": "258"
    },
    {
      "alpha_2": "QA",
      "alpha_3": "QAT",
      "name": "Qatar",
      "numeric": "634",
      "official_name": "State of Qatar"
    },
    {
      "alpha_2": "RE",
      "alpha_3": "REU",
      "name": "Réunion",
      "numeric": "638"
    },
    {
      "alpha_2": "RO",
      "alpha_3": "ROU",
      "name": "Romania",
      "numeric": "642"
    },
    {
      "alpha_2": "RU",
      "alpha_3": "RUS",
      "name": "Russian Federation",
      "numeric": "643"
    },
    {
      "alpha_2": "RW",
      "alpha_3": "RWA",
      "name": "Rwanda",
      "numeric": "646",
      "official_name": "Rwandese Republic"
    },
    {
      "alpha_2": "SA",
      "alpha_3": "SAU",
      "name": "Saudi Arabia",
      "numeric": "682",
      "official_name": "Kingdom of Saudi Arabia"
    },
    {
      "alpha_2": "SD",
      "alpha_3": "SDN",
      "name": "Sudan",
      "numeric": "729",
      "official_name": "Republic of the Sudan"
    },
    {
      "alpha_2": "SN",
      "alpha_3": "SEN",
      "name": "Senegal",
      "numeric": "686",
      "official_name": "Republic of Senegal"
    },
    {
      "alpha_2": "SG",
      "alpha_3": "SGP",
      "name": "Singapore",
      "numeric": "702",
      "official_name": "Republic of Singapore"
    },
    {
      "alpha_2": "GS",
      "alpha_3": "SGS",
      "name": "South Georgia and the South Sandwich Islands",
      "numeric": "239"
    },
    {
      "alpha_2": "SH",
      "alpha_3": "SHN",
      "name": "Saint Helena, Ascension and Tristan da Cunha",
      "numeric": "654"
    },
    {
      "alpha_2": "SJ",
      "alpha_3": "SJM",
      "name": "Svalbard and Jan Mayen",
      "numeric": "744"
    },
    {
      "alpha_2": "SB",
      "alpha_3": "SLB",
      "name": "Solomon Islands",
      "numeric": "090"
    },
    {
      "alpha_2": "SL",
      "alpha_3": "SLE",
      "name": "Sierra Leone",
      "numeric": "694",
      "official_name": "Republic of Sierra Leone"
    },
    {
      "alpha_2": "SV",
      "alpha_3": "SLV",
      "name": "El Salvador",
      "numeric": "222",
      "official_name": "Republic of El Salvador"
    },
    {
      "alpha_2": "SM",
      "alpha_3": "SMR",
      "name": "San Marino",
      "numeric": "674",
      "official_name": "Republic of San Marino"
    },
    {
      "alpha_2": "SO",
      "alpha_3": "SOM",
      "name": "Somalia",
      "numeric": "706",
      "official_name": "Federal Republic of Somalia"
    },
    {
      "alpha_2": "PM",
      "alpha_3": "SPM",
      "name": "Saint Pierre and Miquelon",
      "numeric": "666"
    },
    {
      "alpha_2": "RS",
      "alpha_3": "SRB",
      "name": "Serbia",
      "numeric": "688",
      "official_name": "Republic of Serbia"
    },
    {
      "alpha_2": "SS",
      "alpha_3": "SSD",
      "name": "South Sudan",
      "numeric": "728",
      "official_name": "Republic of South Sudan"
    },
    {
      "alpha_2": "ST",
      "alpha_3": "STP",
      "name": "Sao Tome and Principe",
      "numeric": "678",
      "official_name": "Democratic Republic of Sao Tome and Principe"
    },
    {
      "alpha_2": "SR",
      "alpha_3": "SUR",
      "name": "Suriname",
      "numeric": "740",
      "official_name": "Republic of Suriname"
    },
    {
      "alpha_2": "SK",
      "alpha_3": "SVK",
      "name": "Slovakia",
      "numeric": "703",
      "official_name": "Slovak Republic"
    },
    {
      "alpha_2": "SI",
      "alpha_3": "SVN",
      "name": "Slovenia",
      "numeric": "705",
      "official_name": "Republic of Slovenia"
    },
    {
      "alpha_2": "SE",
      "alpha_3": "SWE",
      "name": "Sweden",
      "numeric": "752",
      "official_name": "Kingdom of Sweden"
    },
    {
      "alpha_2": "SZ",
      "alpha_3": "SWZ",
      "name": "Eswatini",
      "numeric": "748",
      "official_name": "Kingdom of Eswatini"
    },
    {
      "alpha_2": "SX",
      "alpha_3": "SXM",
      "name": "Sint Maarten (Dutch part)",
      "numeric": "534",
      "official_name": "Sint Maarten (Dutch part)"
    },
    {
      "alpha_2": "SC",
      "alpha_3": "SYC",
      "name": "Seychelles",
      "numeric": "690",
      "official_name": "Republic of Seychelles"
    },
    {
      "alpha_2": "SY",
      "alpha_3": "SYR",
      "name": "Syrian Arab Republic",
      "numeric": "760"
    },
    {
      "alpha_2": "TC",
      "alpha_3": "TCA",
      "name": "Turks and Caicos Islands",
      "numeric": "796"
    },
    {
      "alpha_2": "TD",
      "alpha_3": "TCD",
      "name": "Chad",
      "numeric": "148",
      "official_name": "Republic of Chad"
    },
    {
      "alpha_2": "TG",
      "alpha_3": "TGO",
      "name": "Togo",
      "numeric": "768",
      "official_name": "Togolese Republic"
    },
    {
      "alpha_2": "TH",
      "alpha_3": "THA",
      "name": "Thailand",
      "numeric": "764",
      "official_name": "Kingdom of Thailand"
    },
    {
      "alpha_2": "TJ",
      "alpha_3": "TJK",
      "name": "Tajikistan",
      "numeric": "762",
      "official_name": "Republic of Tajikistan"
    },
    {
      "alpha_2": "TK",
      "alpha_3": "TKL",
      "name": "Tokelau",
      "numeric": "772"
    },
    {
      "alpha_2": "TM",
      "alpha_3": "TKM",
      "name": "Turkmenistan",
      "numeric": "795"
    },
    {
      "alpha_2": "TL",
      "alpha_3": "TLS",
      "name": "Timor-Leste",
      "numeric": "626",
      "official_name": "Democratic Republic of Timor-Leste"
    },
    {
      "alpha_2": "TO",
      "alpha_3": "TON",
      "name": "Tonga",
      "numeric": "776",
      "official_name": "Kingdom of Tonga"
    },
    {
      "alpha_2": "TT",
      "alpha_3": "TTO",
      "name": "Trinidad and Tobago",
      "numeric": "780",
      "official_name": "Republic of Trinidad and Tobago"
    },
    {
      "alpha_2": "TN",
      "alpha_3": "TUN",
      "name": "Tunisia",
      "numeric": "788",
      "official_name": "Republic of Tunisia"
    },
    {
      "alpha_2": "TR",
      "alpha_3": "TUR",
      "name": "Turkey",
      "numeric": "792",
      "official_name": "Republic of Turkey"
    },
    {
      "alpha_2": "TV",
      "alpha_3": "TUV",
      "name": "Tuvalu",
      "numeric": "798"
    },
    {
      "alpha_2": "TW",
      "alpha_3": "TWN",
      "common_name": "Taiwan",
      "name": "Taiwan, Province of China",
      "numeric": "158",
      "official_name": "Taiwan, Province of China"
    },
    {
      "alpha_2": "TZ",
      "alpha_3": "TZA",
      "common_name": "Tanzania",
      "name": "Tanzania, United Republic of",
      "numeric": "834",
      "official_name": "United Republic of Tanzania"
    },
    {
      "alpha_2": "UG",
      "alpha_3": "UGA",
      "name": "Uganda",
      "numeric": "800",
      "official_name": "Republic of Uganda"
    },
    {
      "alpha_2": "UA",
      "alpha_3": "UKR",
      "name": "Ukraine",
      "numeric": "804"
    },
    {
      "alpha_2": "UM",
      "alpha_3": "UMI",
      "name": "United States Minor Outlying Islands",
      "numeric": "581"
    },
    {
      "alpha_2": "UY",
      "alpha_3": "URY",
      "name": "Uruguay",
      "numeric": "858",
      "official_name": "Eastern Republic of Uruguay"
    },
    {
      "alpha_2": "US",
      "alpha_3": "USA",
      "name": "United States",
      "numeric": "840",
      "official_name": "United States of America"
    },
    {
      "alpha_2": "UZ",
      "alpha_3": "UZB",
      "name": "Uzbekistan",
      "numeric": "860",
      "official_name": "Republic of Uzbekistan"
    },
    {
      "alpha_2": "VA",
      "alpha_3": "VAT",
      "name": "Holy See (Vatican City State)",
      "numeric": "336"
    },
    {
      "alpha_2": "VC",
      "alpha_3": "VCT",
      "name": "Saint Vincent and the Grenadines",
      "numeric": "670"
    },
    {
      "alpha_2": "VE",
      "alpha_3": "VEN",
      "common_name": "Venezuela",
      "name": "Venezuela, Bolivarian Republic of",
      "numeric": "862",
      "official_name": "Bolivarian Republic of Venezuela"
    },
    {
      "alpha_2": "VG",
      "alpha_3": "VGB",
      "name": "Virgin Islands, British",
      "numeric": "092",
      "official_name": "British Virgin Islands"
    },
    {
      "alpha_2": "VI",
      "alpha_3": "VIR",
      "name": "Virgin Islands, U.S.",
      "numeric": "850",
      "official_name": "Virgin Islands of the United States"
    },
    {
      "alpha_2": "VN",
      "alpha_3": "VNM",
      "common_name": "Vietnam",
      "name": "Viet Nam",
      "numeric": "704",
      "official_name": "Socialist Republic of Viet Nam"
    },
    {
      "alpha_2": "VU",
      "alpha_3": "VUT",
      "name": "Vanuatu",
      "numeric": "548",
      "official_name": "Republic of Vanuatu"
    },
    {
      "alpha_2": "WF",
      "alpha_3": "WLF",
      "name": "Wallis and Futuna",
      "numeric": "876"
    },
    {
      "alpha_2": "WS",
      "alpha_3": "WSM",
      "name": "Samoa",
      "numeric": "882",
      "official_name": "Independent State of Samoa"
    },
    {
      "alpha_2": "YE",
      "alpha_3": "YEM",
      "name": "Yemen",
      "numeric": "887",
      "official_name": "Republic of Yemen"
    },
    {
      "alpha_2": "ZA",
      "alpha_3": "ZAF",
      "name": "South Africa",
      "numeric": "710",
      "official_name": "Republic of South Africa"
    },
    {
      "alpha_2": "ZM",
      "alpha_3": "ZMB",
      "name": "Zambia",
      "numeric": "894",
      "official_name": "Republic of Zambia"
    },
    {
      "alpha_2": "ZW",
      "alpha_3": "ZWE",
      "name": "Zimbabwe",
      "numeric": "716",
      "official_name": "Republic of Zimbabwe"
    },
    {
      "alpha_2": "XK",
      "alpha_3": "XXK",
      "name": "Kosovo",
      "numeric": "",
      "official_name": "Republic of Kosovo"
    }
  ],
  
  "3166-2": [
    {
      "code": "AD-02",
      "name": "Canillo",
      "type": "Parish"
    },
    {
      "code": "AD-03",
      "name": "Encamp",
      "type": "Parish"
    },
    {
      "code": "AD-04",
      "name": "La Massana",
      "type": "Parish"
    },
    {
      "code": "AD-05",
      "name": "Ordino",
      "type": "Parish"
    },
    {
      "code": "AD-06",
      "name": "Sant Julià de Lòria",
      "type": "Parish"
    },
    {
      "code": "AD-07",
      "name": "Andorra la Vella",
      "type": "Parish"
    },
    {
      "code": "AD-08",
      "name": "Escaldes-Engordany",
      "type": "Parish"
    },
    {
      "code": "AE-AJ",
      "name": "‘Ajmān",
      "type": "Emirate"
    },
    {
      "code": "AE-AZ",
      "name": "Abū Z̧aby",
      "type": "Emirate"
    },
    {
      "code": "AE-DU",
      "name": "Dubayy",
      "type": "Emirate"
    },
    {
      "code": "AE-FU",
      "name": "Al Fujayrah",
      "type": "Emirate"
    },
    {
      "code": "AE-RK",
      "name": "Ra’s al Khaymah",
      "type": "Emirate"
    },
    {
      "code": "AE-SH",
      "name": "Ash Shāriqah",
      "type": "Emirate"
    },
    {
      "code": "AE-UQ",
      "name": "Umm al Qaywayn",
      "type": "Emirate"
    },
    {
      "code": "AF-BAL",
      "name": "Balkh",
      "type": "Province"
    },
    {
      "code": "AF-BAM",
      "name": "Bāmyān",
      "type": "Province"
    },
    {
      "code": "AF-BDG",
      "name": "Bādghīs",
      "type": "Province"
    },
    {
      "code": "AF-BDS",
      "name": "Badakhshān",
      "type": "Province"
    },
    {
      "code": "AF-BGL",
      "name": "Baghlān",
      "type": "Province"
    },
    {
      "code": "AF-DAY",
      "name": "Dāykundī",
      "type": "Province"
    },
    {
      "code": "AF-FRA",
      "name": "Farāh",
      "type": "Province"
    },
    {
      "code": "AF-FYB",
      "name": "Fāryāb",
      "type": "Province"
    },
    {
      "code": "AF-GHA",
      "name": "Ghaznī",
      "type": "Province"
    },
    {
      "code": "AF-GHO",
      "name": "Ghōr",
      "type": "Province"
    },
    {
      "code": "AF-HEL",
      "name": "Helmand",
      "type": "Province"
    },
    {
      "code": "AF-HER",
      "name": "Herāt",
      "type": "Province"
    },
    {
      "code": "AF-JOW",
      "name": "Jowzjān",
      "type": "Province"
    },
    {
      "code": "AF-KAB",
      "name": "Kābul",
      "type": "Province"
    },
    {
      "code": "AF-KAN",
      "name": "Kandahār",
      "type": "Province"
    },
    {
      "code": "AF-KAP",
      "name": "Kāpīsā",
      "type": "Province"
    },
    {
      "code": "AF-KDZ",
      "name": "Kunduz",
      "type": "Province"
    },
    {
      "code": "AF-KHO",
      "name": "Khōst",
      "type": "Province"
    },
    {
      "code": "AF-KNR",
      "name": "Kunaṟ",
      "type": "Province"
    },
    {
      "code": "AF-LAG",
      "name": "Laghmān",
      "type": "Province"
    },
    {
      "code": "AF-LOG",
      "name": "Lōgar",
      "type": "Province"
    },
    {
      "code": "AF-NAN",
      "name": "Nangarhār",
      "type": "Province"
    },
    {
      "code": "AF-NIM",
      "name": "Nīmrōz",
      "type": "Province"
    },
    {
      "code": "AF-NUR",
      "name": "Nūristān",
      "type": "Province"
    },
    {
      "code": "AF-PAN",
      "name": "Panjshayr",
      "type": "Province"
    },
    {
      "code": "AF-PAR",
      "name": "Parwān",
      "type": "Province"
    },
    {
      "code": "AF-PIA",
      "name": "Paktiyā",
      "type": "Province"
    },
    {
      "code": "AF-PKA",
      "name": "Paktīkā",
      "type": "Province"
    },
    {
      "code": "AF-SAM",
      "name": "Samangān",
      "type": "Province"
    },
    {
      "code": "AF-SAR",
      "name": "Sar-e Pul",
      "type": "Province"
    },
    {
      "code": "AF-TAK",
      "name": "Takhār",
      "type": "Province"
    },
    {
      "code": "AF-URU",
      "name": "Uruzgān",
      "type": "Province"
    },
    {
      "code": "AF-WAR",
      "name": "Wardak",
      "type": "Province"
    },
    {
      "code": "AF-ZAB",
      "name": "Zābul",
      "type": "Province"
    },
    {
      "code": "AG-03",
      "name": "Saint George",
      "type": "Parish"
    },
    {
      "code": "AG-04",
      "name": "Saint John",
      "type": "Parish"
    },
    {
      "code": "AG-05",
      "name": "Saint Mary",
      "type": "Parish"
    },
    {
      "code": "AG-06",
      "name": "Saint Paul",
      "type": "Parish"
    },
    {
      "code": "AG-07",
      "name": "Saint Peter",
      "type": "Parish"
    },
    {
      "code": "AG-08",
      "name": "Saint Philip",
      "type": "Parish"
    },
    {
      "code": "AG-10",
      "name": "Barbuda",
      "type": "Dependency"
    },
    {
      "code": "AG-11",
      "name": "Redonda",
      "type": "Dependency"
    },
    {
      "code": "AL-01",
      "name": "Berat",
      "type": "County"
    },
    {
      "code": "AL-02",
      "name": "Durrës",
      "type": "County"
    },
    {
      "code": "AL-03",
      "name": "Elbasan",
      "type": "County"
    },
    {
      "code": "AL-04",
      "name": "Fier",
      "type": "County"
    },
    {
      "code": "AL-05",
      "name": "Gjirokastër",
      "type": "County"
    },
    {
      "code": "AL-06",
      "name": "Korçë",
      "type": "County"
    },
    {
      "code": "AL-07",
      "name": "Kukës",
      "type": "County"
    },
    {
      "code": "AL-08",
      "name": "Lezhë",
      "type": "County"
    },
    {
      "code": "AL-09",
      "name": "Dibër",
      "type": "County"
    },
    {
      "code": "AL-10",
      "name": "Shkodër",
      "type": "County"
    },
    {
      "code": "AL-11",
      "name": "Tiranë",
      "type": "County"
    },
    {
      "code": "AL-12",
      "name": "Vlorë",
      "type": "County"
    },
    {
      "code": "AM-AG",
      "name": "Aragac̣otn",
      "type": "Region"
    },
    {
      "code": "AM-AR",
      "name": "Ararat",
      "type": "Region"
    },
    {
      "code": "AM-AV",
      "name": "Armavir",
      "type": "Region"
    },
    {
      "code": "AM-ER",
      "name": "Erevan",
      "type": "City"
    },
    {
      "code": "AM-GR",
      "name": "Geġark'unik'",
      "type": "Region"
    },
    {
      "code": "AM-KT",
      "name": "Kotayk'",
      "type": "Region"
    },
    {
      "code": "AM-LO",
      "name": "Loṙi",
      "type": "Region"
    },
    {
      "code": "AM-SH",
      "name": "Širak",
      "type": "Region"
    },
    {
      "code": "AM-SU",
      "name": "Syunik'",
      "type": "Region"
    },
    {
      "code": "AM-TV",
      "name": "Tavuš",
      "type": "Region"
    },
    {
      "code": "AM-VD",
      "name": "Vayoć Jor",
      "type": "Region"
    },
    {
      "code": "AO-BGO",
      "name": "Bengo",
      "type": "Province"
    },
    {
      "code": "AO-BGU",
      "name": "Benguela",
      "type": "Province"
    },
    {
      "code": "AO-BIE",
      "name": "Bié",
      "type": "Province"
    },
    {
      "code": "AO-CAB",
      "name": "Cabinda",
      "type": "Province"
    },
    {
      "code": "AO-CCU",
      "name": "Cuando Cubango",
      "type": "Province"
    },
    {
      "code": "AO-CNN",
      "name": "Cunene",
      "type": "Province"
    },
    {
      "code": "AO-CNO",
      "name": "Cuanza-Norte",
      "type": "Province"
    },
    {
      "code": "AO-CUS",
      "name": "Cuanza-Sul",
      "type": "Province"
    },
    {
      "code": "AO-HUA",
      "name": "Huambo",
      "type": "Province"
    },
    {
      "code": "AO-HUI",
      "name": "Huíla",
      "type": "Province"
    },
    {
      "code": "AO-LNO",
      "name": "Lunda-Norte",
      "type": "Province"
    },
    {
      "code": "AO-LSU",
      "name": "Lunda-Sul",
      "type": "Province"
    },
    {
      "code": "AO-LUA",
      "name": "Luanda",
      "type": "Province"
    },
    {
      "code": "AO-MAL",
      "name": "Malange",
      "type": "Province"
    },
    {
      "code": "AO-MOX",
      "name": "Moxico",
      "type": "Province"
    },
    {
      "code": "AO-NAM",
      "name": "Namibe",
      "type": "Province"
    },
    {
      "code": "AO-UIG",
      "name": "Uíge",
      "type": "Province"
    },
    {
      "code": "AO-ZAI",
      "name": "Zaire",
      "type": "Province"
    },
    {
      "code": "AR-A",
      "name": "Salta",
      "type": "Province"
    },
    {
      "code": "AR-B",
      "name": "Buenos Aires",
      "type": "Province"
    },
    {
      "code": "AR-C",
      "name": "Ciudad Autónoma de Buenos Aires",
      "type": "City"
    },
    {
      "code": "AR-D",
      "name": "San Luis",
      "type": "Province"
    },
    {
      "code": "AR-E",
      "name": "Entre Ríos",
      "type": "Province"
    },
    {
      "code": "AR-F",
      "name": "La Rioja",
      "type": "Province"
    },
    {
      "code": "AR-G",
      "name": "Santiago del Estero",
      "type": "Province"
    },
    {
      "code": "AR-H",
      "name": "Chaco",
      "type": "Province"
    },
    {
      "code": "AR-J",
      "name": "San Juan",
      "type": "Province"
    },
    {
      "code": "AR-K",
      "name": "Catamarca",
      "type": "Province"
    },
    {
      "code": "AR-L",
      "name": "La Pampa",
      "type": "Province"
    },
    {
      "code": "AR-M",
      "name": "Mendoza",
      "type": "Province"
    },
    {
      "code": "AR-N",
      "name": "Misiones",
      "type": "Province"
    },
    {
      "code": "AR-P",
      "name": "Formosa",
      "type": "Province"
    },
    {
      "code": "AR-Q",
      "name": "Neuquén",
      "type": "Province"
    },
    {
      "code": "AR-R",
      "name": "Río Negro",
      "type": "Province"
    },
    {
      "code": "AR-S",
      "name": "Santa Fe",
      "type": "Province"
    },
    {
      "code": "AR-T",
      "name": "Tucumán",
      "type": "Province"
    },
    {
      "code": "AR-U",
      "name": "Chubut",
      "type": "Province"
    },
    {
      "code": "AR-V",
      "name": "Tierra del Fuego",
      "type": "Province"
    },
    {
      "code": "AR-W",
      "name": "Corrientes",
      "type": "Province"
    },
    {
      "code": "AR-X",
      "name": "Córdoba",
      "type": "Province"
    },
    {
      "code": "AR-Y",
      "name": "Jujuy",
      "type": "Province"
    },
    {
      "code": "AR-Z",
      "name": "Santa Cruz",
      "type": "Province"
    },
    {
      "code": "AT-1",
      "name": "Burgenland",
      "type": "State"
    },
    {
      "code": "AT-2",
      "name": "Kärnten",
      "type": "State"
    },
    {
      "code": "AT-3",
      "name": "Niederösterreich",
      "type": "State"
    },
    {
      "code": "AT-4",
      "name": "Oberösterreich",
      "type": "State"
    },
    {
      "code": "AT-5",
      "name": "Salzburg",
      "type": "State"
    },
    {
      "code": "AT-6",
      "name": "Steiermark",
      "type": "State"
    },
    {
      "code": "AT-7",
      "name": "Tirol",
      "type": "State"
    },
    {
      "code": "AT-8",
      "name": "Vorarlberg",
      "type": "State"
    },
    {
      "code": "AT-9",
      "name": "Wien",
      "type": "State"
    },
    {
      "code": "AU-ACT",
      "name": "Australian Capital Territory",
      "type": "Territory"
    },
    {
      "code": "AU-NSW",
      "name": "New South Wales",
      "type": "State"
    },
    {
      "code": "AU-NT",
      "name": "Northern Territory",
      "type": "Territory"
    },
    {
      "code": "AU-QLD",
      "name": "Queensland",
      "type": "State"
    },
    {
      "code": "AU-SA",
      "name": "South Australia",
      "type": "State"
    },
    {
      "code": "AU-TAS",
      "name": "Tasmania",
      "type": "State"
    },
    {
      "code": "AU-VIC",
      "name": "Victoria",
      "type": "State"
    },
    {
      "code": "AU-WA",
      "name": "Western Australia",
      "type": "State"
    },
    {
      "code": "AZ-ABS",
      "name": "Abşeron",
      "type": "Rayon"
    },
    {
      "code": "AZ-AGA",
      "name": "Ağstafa",
      "type": "Rayon"
    },
    {
      "code": "AZ-AGC",
      "name": "Ağcabədi",
      "type": "Rayon"
    },
    {
      "code": "AZ-AGM",
      "name": "Ağdam",
      "type": "Rayon"
    },
    {
      "code": "AZ-AGS",
      "name": "Ağdaş",
      "type": "Rayon"
    },
    {
      "code": "AZ-AGU",
      "name": "Ağsu",
      "type": "Rayon"
    },
    {
      "code": "AZ-AST",
      "name": "Astara",
      "type": "Rayon"
    },
    {
      "code": "AZ-BA",
      "name": "Bakı",
      "type": "Municipality"
    },
    {
      "code": "AZ-BAB",
      "name": "Babək",
      "parent": "NX",
      "type": "Rayon"
    },
    {
      "code": "AZ-BAL",
      "name": "Balakən",
      "type": "Rayon"
    },
    {
      "code": "AZ-BAR",
      "name": "Bərdə",
      "type": "Rayon"
    },
    {
      "code": "AZ-BEY",
      "name": "Beyləqan",
      "type": "Rayon"
    },
    {
      "code": "AZ-BIL",
      "name": "Biləsuvar",
      "type": "Rayon"
    },
    {
      "code": "AZ-CAB",
      "name": "Cəbrayıl",
      "type": "Rayon"
    },
    {
      "code": "AZ-CAL",
      "name": "Cəlilabad",
      "type": "Rayon"
    },
    {
      "code": "AZ-CUL",
      "name": "Culfa",
      "parent": "NX",
      "type": "Rayon"
    },
    {
      "code": "AZ-DAS",
      "name": "Daşkəsən",
      "type": "Rayon"
    },
    {
      "code": "AZ-FUZ",
      "name": "Füzuli",
      "type": "Rayon"
    },
    {
      "code": "AZ-GA",
      "name": "Gəncə",
      "type": "Municipality"
    },
    {
      "code": "AZ-GAD",
      "name": "Gədəbəy",
      "type": "Rayon"
    },
    {
      "code": "AZ-GOR",
      "name": "Goranboy",
      "type": "Rayon"
    },
    {
      "code": "AZ-GOY",
      "name": "Göyçay",
      "type": "Rayon"
    },
    {
      "code": "AZ-GYG",
      "name": "Göygöl",
      "type": "Rayon"
    },
    {
      "code": "AZ-HAC",
      "name": "Hacıqabul",
      "type": "Rayon"
    },
    {
      "code": "AZ-IMI",
      "name": "İmişli",
      "type": "Rayon"
    },
    {
      "code": "AZ-ISM",
      "name": "İsmayıllı",
      "type": "Rayon"
    },
    {
      "code": "AZ-KAL",
      "name": "Kəlbəcər",
      "type": "Rayon"
    },
    {
      "code": "AZ-KAN",
      "name": "Kǝngǝrli",
      "parent": "NX",
      "type": "Rayon"
    },
    {
      "code": "AZ-KUR",
      "name": "Kürdəmir",
      "type": "Rayon"
    },
    {
      "code": "AZ-LA",
      "name": "Lənkəran",
      "type": "Municipality"
    },
    {
      "code": "AZ-LAC",
      "name": "Laçın",
      "type": "Rayon"
    },
    {
      "code": "AZ-LAN",
      "name": "Lənkəran",
      "type": "Rayon"
    },
    {
      "code": "AZ-LER",
      "name": "Lerik",
      "type": "Rayon"
    },
    {
      "code": "AZ-MAS",
      "name": "Masallı",
      "type": "Rayon"
    },
    {
      "code": "AZ-MI",
      "name": "Mingəçevir",
      "type": "Municipality"
    },
    {
      "code": "AZ-NA",
      "name": "Naftalan",
      "type": "Municipality"
    },
    {
      "code": "AZ-NEF",
      "name": "Neftçala",
      "type": "Rayon"
    },
    {
      "code": "AZ-NV",
      "name": "Naxçıvan",
      "parent": "NX",
      "type": "Municipality"
    },
    {
      "code": "AZ-NX",
      "name": "Naxçıvan",
      "type": "Autonomous republic"
    },
    {
      "code": "AZ-OGU",
      "name": "Oğuz",
      "type": "Rayon"
    },
    {
      "code": "AZ-ORD",
      "name": "Ordubad",
      "parent": "NX",
      "type": "Rayon"
    },
    {
      "code": "AZ-QAB",
      "name": "Qəbələ",
      "type": "Rayon"
    },
    {
      "code": "AZ-QAX",
      "name": "Qax",
      "type": "Rayon"
    },
    {
      "code": "AZ-QAZ",
      "name": "Qazax",
      "type": "Rayon"
    },
    {
      "code": "AZ-QBA",
      "name": "Quba",
      "type": "Rayon"
    },
    {
      "code": "AZ-QBI",
      "name": "Qubadlı",
      "type": "Rayon"
    },
    {
      "code": "AZ-QOB",
      "name": "Qobustan",
      "type": "Rayon"
    },
    {
      "code": "AZ-QUS",
      "name": "Qusar",
      "type": "Rayon"
    },
    {
      "code": "AZ-SA",
      "name": "Şəki",
      "type": "Municipality"
    },
    {
      "code": "AZ-SAB",
      "name": "Sabirabad",
      "type": "Rayon"
    },
    {
      "code": "AZ-SAD",
      "name": "Sədərək",
      "parent": "NX",
      "type": "Rayon"
    },
    {
      "code": "AZ-SAH",
      "name": "Şahbuz",
      "parent": "NX",
      "type": "Rayon"
    },
    {
      "code": "AZ-SAK",
      "name": "Şəki",
      "type": "Rayon"
    },
    {
      "code": "AZ-SAL",
      "name": "Salyan",
      "type": "Rayon"
    },
    {
      "code": "AZ-SAR",
      "name": "Şərur",
      "parent": "NX",
      "type": "Rayon"
    },
    {
      "code": "AZ-SAT",
      "name": "Saatlı",
      "type": "Rayon"
    },
    {
      "code": "AZ-SBN",
      "name": "Şabran",
      "type": "Rayon"
    },
    {
      "code": "AZ-SIY",
      "name": "Siyəzən",
      "type": "Rayon"
    },
    {
      "code": "AZ-SKR",
      "name": "Şəmkir",
      "type": "Rayon"
    },
    {
      "code": "AZ-SM",
      "name": "Sumqayıt",
      "type": "Municipality"
    },
    {
      "code": "AZ-SMI",
      "name": "Şamaxı",
      "type": "Rayon"
    },
    {
      "code": "AZ-SMX",
      "name": "Samux",
      "type": "Rayon"
    },
    {
      "code": "AZ-SR",
      "name": "Şirvan",
      "type": "Municipality"
    },
    {
      "code": "AZ-SUS",
      "name": "Şuşa",
      "type": "Rayon"
    },
    {
      "code": "AZ-TAR",
      "name": "Tərtər",
      "type": "Rayon"
    },
    {
      "code": "AZ-TOV",
      "name": "Tovuz",
      "type": "Rayon"
    },
    {
      "code": "AZ-UCA",
      "name": "Ucar",
      "type": "Rayon"
    },
    {
      "code": "AZ-XA",
      "name": "Xankəndi",
      "type": "Municipality"
    },
    {
      "code": "AZ-XAC",
      "name": "Xaçmaz",
      "type": "Rayon"
    },
    {
      "code": "AZ-XCI",
      "name": "Xocalı",
      "type": "Rayon"
    },
    {
      "code": "AZ-XIZ",
      "name": "Xızı",
      "type": "Rayon"
    },
    {
      "code": "AZ-XVD",
      "name": "Xocavənd",
      "type": "Rayon"
    },
    {
      "code": "AZ-YAR",
      "name": "Yardımlı",
      "type": "Rayon"
    },
    {
      "code": "AZ-YE",
      "name": "Yevlax",
      "type": "Municipality"
    },
    {
      "code": "AZ-YEV",
      "name": "Yevlax",
      "type": "Rayon"
    },
    {
      "code": "AZ-ZAN",
      "name": "Zəngilan",
      "type": "Rayon"
    },
    {
      "code": "AZ-ZAQ",
      "name": "Zaqatala",
      "type": "Rayon"
    },
    {
      "code": "AZ-ZAR",
      "name": "Zərdab",
      "type": "Rayon"
    },
    {
      "code": "BA-BIH",
      "name": "Federacija Bosne i Hercegovine",
      "type": "Entity"
    },
    {
      "code": "BA-BRC",
      "name": "Brčko distrikt",
      "type": "District with special status"
    },
    {
      "code": "BA-SRP",
      "name": "Republika Srpska",
      "type": "Entity"
    },
    {
      "code": "BB-01",
      "name": "Christ Church",
      "type": "Parish"
    },
    {
      "code": "BB-02",
      "name": "Saint Andrew",
      "type": "Parish"
    },
    {
      "code": "BB-03",
      "name": "Saint George",
      "type": "Parish"
    },
    {
      "code": "BB-04",
      "name": "Saint James",
      "type": "Parish"
    },
    {
      "code": "BB-05",
      "name": "Saint John",
      "type": "Parish"
    },
    {
      "code": "BB-06",
      "name": "Saint Joseph",
      "type": "Parish"
    },
    {
      "code": "BB-07",
      "name": "Saint Lucy",
      "type": "Parish"
    },
    {
      "code": "BB-08",
      "name": "Saint Michael",
      "type": "Parish"
    },
    {
      "code": "BB-09",
      "name": "Saint Peter",
      "type": "Parish"
    },
    {
      "code": "BB-10",
      "name": "Saint Philip",
      "type": "Parish"
    },
    {
      "code": "BB-11",
      "name": "Saint Thomas",
      "type": "Parish"
    },
    {
      "code": "BD-01",
      "name": "Bandarban",
      "parent": "B",
      "type": "District"
    },
    {
      "code": "BD-02",
      "name": "Barguna",
      "parent": "A",
      "type": "District"
    },
    {
      "code": "BD-03",
      "name": "Bogura",
      "parent": "E",
      "type": "District"
    },
    {
      "code": "BD-04",
      "name": "Brahmanbaria",
      "parent": "B",
      "type": "District"
    },
    {
      "code": "BD-05",
      "name": "Bagerhat",
      "parent": "D",
      "type": "District"
    },
    {
      "code": "BD-06",
      "name": "Barishal",
      "parent": "A",
      "type": "District"
    },
    {
      "code": "BD-07",
      "name": "Bhola",
      "parent": "A",
      "type": "District"
    },
    {
      "code": "BD-08",
      "name": "Cumilla",
      "parent": "B",
      "type": "District"
    },
    {
      "code": "BD-09",
      "name": "Chandpur",
      "parent": "B",
      "type": "District"
    },
    {
      "code": "BD-10",
      "name": "Chattogram",
      "parent": "B",
      "type": "District"
    },
    {
      "code": "BD-11",
      "name": "Cox's Bazar",
      "parent": "B",
      "type": "District"
    },
    {
      "code": "BD-12",
      "name": "Chuadanga",
      "parent": "D",
      "type": "District"
    },
    {
      "code": "BD-13",
      "name": "Dhaka",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "BD-14",
      "name": "Dinajpur",
      "parent": "F",
      "type": "District"
    },
    {
      "code": "BD-15",
      "name": "Faridpur",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "BD-16",
      "name": "Feni",
      "parent": "B",
      "type": "District"
    },
    {
      "code": "BD-17",
      "name": "Gopalganj",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "BD-18",
      "name": "Gazipur",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "BD-19",
      "name": "Gaibandha",
      "parent": "F",
      "type": "District"
    },
    {
      "code": "BD-20",
      "name": "Habiganj",
      "parent": "G",
      "type": "District"
    },
    {
      "code": "BD-21",
      "name": "Jamalpur",
      "parent": "H",
      "type": "District"
    },
    {
      "code": "BD-22",
      "name": "Jashore",
      "parent": "D",
      "type": "District"
    },
    {
      "code": "BD-23",
      "name": "Jhenaidah",
      "parent": "D",
      "type": "District"
    },
    {
      "code": "BD-24",
      "name": "Joypurhat",
      "parent": "E",
      "type": "District"
    },
    {
      "code": "BD-25",
      "name": "Jhalakathi",
      "parent": "A",
      "type": "District"
    },
    {
      "code": "BD-26",
      "name": "Kishoreganj",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "BD-27",
      "name": "Khulna",
      "parent": "D",
      "type": "District"
    },
    {
      "code": "BD-28",
      "name": "Kurigram",
      "parent": "F",
      "type": "District"
    },
    {
      "code": "BD-29",
      "name": "Khagrachhari",
      "parent": "B",
      "type": "District"
    },
    {
      "code": "BD-30",
      "name": "Kushtia",
      "parent": "D",
      "type": "District"
    },
    {
      "code": "BD-31",
      "name": "Lakshmipur",
      "parent": "B",
      "type": "District"
    },
    {
      "code": "BD-32",
      "name": "Lalmonirhat",
      "parent": "F",
      "type": "District"
    },
    {
      "code": "BD-33",
      "name": "Manikganj",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "BD-34",
      "name": "Mymensingh",
      "parent": "H",
      "type": "District"
    },
    {
      "code": "BD-35",
      "name": "Munshiganj",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "BD-36",
      "name": "Madaripur",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "BD-37",
      "name": "Magura",
      "parent": "D",
      "type": "District"
    },
    {
      "code": "BD-38",
      "name": "Moulvibazar",
      "parent": "G",
      "type": "District"
    },
    {
      "code": "BD-39",
      "name": "Meherpur",
      "parent": "D",
      "type": "District"
    },
    {
      "code": "BD-40",
      "name": "Narayanganj",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "BD-41",
      "name": "Netrakona",
      "parent": "H",
      "type": "District"
    },
    {
      "code": "BD-42",
      "name": "Narsingdi",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "BD-43",
      "name": "Narail",
      "parent": "D",
      "type": "District"
    },
    {
      "code": "BD-44",
      "name": "Natore",
      "parent": "E",
      "type": "District"
    },
    {
      "code": "BD-45",
      "name": "Chapai Nawabganj",
      "parent": "E",
      "type": "District"
    },
    {
      "code": "BD-46",
      "name": "Nilphamari",
      "parent": "F",
      "type": "District"
    },
    {
      "code": "BD-47",
      "name": "Noakhali",
      "parent": "B",
      "type": "District"
    },
    {
      "code": "BD-48",
      "name": "Naogaon",
      "parent": "E",
      "type": "District"
    },
    {
      "code": "BD-49",
      "name": "Pabna",
      "parent": "E",
      "type": "District"
    },
    {
      "code": "BD-50",
      "name": "Pirojpur",
      "parent": "A",
      "type": "District"
    },
    {
      "code": "BD-51",
      "name": "Patuakhali",
      "parent": "A",
      "type": "District"
    },
    {
      "code": "BD-52",
      "name": "Panchagarh",
      "parent": "F",
      "type": "District"
    },
    {
      "code": "BD-53",
      "name": "Rajbari",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "BD-54",
      "name": "Rajshahi",
      "parent": "E",
      "type": "District"
    },
    {
      "code": "BD-55",
      "name": "Rangpur",
      "parent": "F",
      "type": "District"
    },
    {
      "code": "BD-56",
      "name": "Rangamati",
      "parent": "B",
      "type": "District"
    },
    {
      "code": "BD-57",
      "name": "Sherpur",
      "parent": "H",
      "type": "District"
    },
    {
      "code": "BD-58",
      "name": "Satkhira",
      "parent": "D",
      "type": "District"
    },
    {
      "code": "BD-59",
      "name": "Sirajganj",
      "parent": "E",
      "type": "District"
    },
    {
      "code": "BD-60",
      "name": "Sylhet",
      "parent": "G",
      "type": "District"
    },
    {
      "code": "BD-61",
      "name": "Sunamganj",
      "parent": "G",
      "type": "District"
    },
    {
      "code": "BD-62",
      "name": "Shariatpur",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "BD-63",
      "name": "Tangail",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "BD-64",
      "name": "Thakurgaon",
      "parent": "F",
      "type": "District"
    },
    {
      "code": "BD-A",
      "name": "Barishal",
      "type": "Division"
    },
    {
      "code": "BD-B",
      "name": "Chattogram",
      "type": "Division"
    },
    {
      "code": "BD-C",
      "name": "Dhaka",
      "type": "Division"
    },
    {
      "code": "BD-D",
      "name": "Khulna",
      "type": "Division"
    },
    {
      "code": "BD-E",
      "name": "Rajshahi",
      "type": "Division"
    },
    {
      "code": "BD-F",
      "name": "Rangpur",
      "type": "Division"
    },
    {
      "code": "BD-G",
      "name": "Sylhet",
      "type": "Division"
    },
    {
      "code": "BD-H",
      "name": "Mymensingh",
      "type": "Division"
    },
    {
      "code": "BE-BRU",
      "name": "Brussels Hoofdstedelijk Gewest",
      "type": "Region"
    },
    {
      "code": "BE-VAN",
      "name": "Antwerpen",
      "parent": "VLG",
      "type": "Province"
    },
    {
      "code": "BE-VBR",
      "name": "Vlaams-Brabant",
      "parent": "VLG",
      "type": "Province"
    },
    {
      "code": "BE-VLG",
      "name": "Vlaams Gewest",
      "type": "Region"
    },
    {
      "code": "BE-VLI",
      "name": "Limburg",
      "parent": "VLG",
      "type": "Province"
    },
    {
      "code": "BE-VOV",
      "name": "Oost-Vlaanderen",
      "parent": "VLG",
      "type": "Province"
    },
    {
      "code": "BE-VWV",
      "name": "West-Vlaanderen",
      "parent": "VLG",
      "type": "Province"
    },
    {
      "code": "BE-WAL",
      "name": "wallonne, Région",
      "type": "Region"
    },
    {
      "code": "BE-WBR",
      "name": "Brabant wallon",
      "parent": "WAL",
      "type": "Province"
    },
    {
      "code": "BE-WHT",
      "name": "Hainaut",
      "parent": "WAL",
      "type": "Province"
    },
    {
      "code": "BE-WLG",
      "name": "Liège",
      "parent": "WAL",
      "type": "Province"
    },
    {
      "code": "BE-WLX",
      "name": "Luxembourg",
      "parent": "WAL",
      "type": "Province"
    },
    {
      "code": "BE-WNA",
      "name": "Namur",
      "parent": "WAL",
      "type": "Province"
    },
    {
      "code": "BF-01",
      "name": "Boucle du Mouhoun",
      "type": "Region"
    },
    {
      "code": "BF-02",
      "name": "Cascades",
      "type": "Region"
    },
    {
      "code": "BF-03",
      "name": "Centre",
      "type": "Region"
    },
    {
      "code": "BF-04",
      "name": "Centre-Est",
      "type": "Region"
    },
    {
      "code": "BF-05",
      "name": "Centre-Nord",
      "type": "Region"
    },
    {
      "code": "BF-06",
      "name": "Centre-Ouest",
      "type": "Region"
    },
    {
      "code": "BF-07",
      "name": "Centre-Sud",
      "type": "Region"
    },
    {
      "code": "BF-08",
      "name": "Est",
      "type": "Region"
    },
    {
      "code": "BF-09",
      "name": "Hauts-Bassins",
      "type": "Region"
    },
    {
      "code": "BF-10",
      "name": "Nord",
      "type": "Region"
    },
    {
      "code": "BF-11",
      "name": "Plateau-Central",
      "type": "Region"
    },
    {
      "code": "BF-12",
      "name": "Sahel",
      "type": "Region"
    },
    {
      "code": "BF-13",
      "name": "Sud-Ouest",
      "type": "Region"
    },
    {
      "code": "BF-BAL",
      "name": "Balé",
      "parent": "01",
      "type": "Province"
    },
    {
      "code": "BF-BAM",
      "name": "Bam",
      "parent": "05",
      "type": "Province"
    },
    {
      "code": "BF-BAN",
      "name": "Banwa",
      "parent": "01",
      "type": "Province"
    },
    {
      "code": "BF-BAZ",
      "name": "Bazèga",
      "parent": "07",
      "type": "Province"
    },
    {
      "code": "BF-BGR",
      "name": "Bougouriba",
      "parent": "13",
      "type": "Province"
    },
    {
      "code": "BF-BLG",
      "name": "Boulgou",
      "parent": "04",
      "type": "Province"
    },
    {
      "code": "BF-BLK",
      "name": "Boulkiemdé",
      "parent": "06",
      "type": "Province"
    },
    {
      "code": "BF-COM",
      "name": "Comoé",
      "parent": "02",
      "type": "Province"
    },
    {
      "code": "BF-GAN",
      "name": "Ganzourgou",
      "parent": "11",
      "type": "Province"
    },
    {
      "code": "BF-GNA",
      "name": "Gnagna",
      "parent": "08",
      "type": "Province"
    },
    {
      "code": "BF-GOU",
      "name": "Gourma",
      "parent": "08",
      "type": "Province"
    },
    {
      "code": "BF-HOU",
      "name": "Houet",
      "parent": "09",
      "type": "Province"
    },
    {
      "code": "BF-IOB",
      "name": "Ioba",
      "parent": "13",
      "type": "Province"
    },
    {
      "code": "BF-KAD",
      "name": "Kadiogo",
      "parent": "03",
      "type": "Province"
    },
    {
      "code": "BF-KEN",
      "name": "Kénédougou",
      "parent": "09",
      "type": "Province"
    },
    {
      "code": "BF-KMD",
      "name": "Komondjari",
      "parent": "08",
      "type": "Province"
    },
    {
      "code": "BF-KMP",
      "name": "Kompienga",
      "parent": "08",
      "type": "Province"
    },
    {
      "code": "BF-KOP",
      "name": "Koulpélogo",
      "parent": "04",
      "type": "Province"
    },
    {
      "code": "BF-KOS",
      "name": "Kossi",
      "parent": "01",
      "type": "Province"
    },
    {
      "code": "BF-KOT",
      "name": "Kouritenga",
      "parent": "04",
      "type": "Province"
    },
    {
      "code": "BF-KOW",
      "name": "Kourwéogo",
      "parent": "11",
      "type": "Province"
    },
    {
      "code": "BF-LER",
      "name": "Léraba",
      "parent": "02",
      "type": "Province"
    },
    {
      "code": "BF-LOR",
      "name": "Loroum",
      "parent": "10",
      "type": "Province"
    },
    {
      "code": "BF-MOU",
      "name": "Mouhoun",
      "parent": "01",
      "type": "Province"
    },
    {
      "code": "BF-NAM",
      "name": "Namentenga",
      "parent": "05",
      "type": "Province"
    },
    {
      "code": "BF-NAO",
      "name": "Nahouri",
      "parent": "07",
      "type": "Province"
    },
    {
      "code": "BF-NAY",
      "name": "Nayala",
      "parent": "01",
      "type": "Province"
    },
    {
      "code": "BF-NOU",
      "name": "Noumbiel",
      "parent": "13",
      "type": "Province"
    },
    {
      "code": "BF-OUB",
      "name": "Oubritenga",
      "parent": "11",
      "type": "Province"
    },
    {
      "code": "BF-OUD",
      "name": "Oudalan",
      "parent": "12",
      "type": "Province"
    },
    {
      "code": "BF-PAS",
      "name": "Passoré",
      "parent": "10",
      "type": "Province"
    },
    {
      "code": "BF-PON",
      "name": "Poni",
      "parent": "13",
      "type": "Province"
    },
    {
      "code": "BF-SEN",
      "name": "Séno",
      "parent": "12",
      "type": "Province"
    },
    {
      "code": "BF-SIS",
      "name": "Sissili",
      "parent": "06",
      "type": "Province"
    },
    {
      "code": "BF-SMT",
      "name": "Sanmatenga",
      "parent": "05",
      "type": "Province"
    },
    {
      "code": "BF-SNG",
      "name": "Sanguié",
      "parent": "06",
      "type": "Province"
    },
    {
      "code": "BF-SOM",
      "name": "Soum",
      "parent": "12",
      "type": "Province"
    },
    {
      "code": "BF-SOR",
      "name": "Sourou",
      "parent": "01",
      "type": "Province"
    },
    {
      "code": "BF-TAP",
      "name": "Tapoa",
      "parent": "08",
      "type": "Province"
    },
    {
      "code": "BF-TUI",
      "name": "Tuy",
      "parent": "09",
      "type": "Province"
    },
    {
      "code": "BF-YAG",
      "name": "Yagha",
      "parent": "12",
      "type": "Province"
    },
    {
      "code": "BF-YAT",
      "name": "Yatenga",
      "parent": "10",
      "type": "Province"
    },
    {
      "code": "BF-ZIR",
      "name": "Ziro",
      "parent": "06",
      "type": "Province"
    },
    {
      "code": "BF-ZON",
      "name": "Zondoma",
      "parent": "10",
      "type": "Province"
    },
    {
      "code": "BF-ZOU",
      "name": "Zoundwéogo",
      "parent": "07",
      "type": "Province"
    },
    {
      "code": "BG-01",
      "name": "Blagoevgrad",
      "type": "District"
    },
    {
      "code": "BG-02",
      "name": "Burgas",
      "type": "District"
    },
    {
      "code": "BG-03",
      "name": "Varna",
      "type": "District"
    },
    {
      "code": "BG-04",
      "name": "Veliko Tarnovo",
      "type": "District"
    },
    {
      "code": "BG-05",
      "name": "Vidin",
      "type": "District"
    },
    {
      "code": "BG-06",
      "name": "Vratsa",
      "type": "District"
    },
    {
      "code": "BG-07",
      "name": "Gabrovo",
      "type": "District"
    },
    {
      "code": "BG-08",
      "name": "Dobrich",
      "type": "District"
    },
    {
      "code": "BG-09",
      "name": "Kardzhali",
      "type": "District"
    },
    {
      "code": "BG-10",
      "name": "Kyustendil",
      "type": "District"
    },
    {
      "code": "BG-11",
      "name": "Lovech",
      "type": "District"
    },
    {
      "code": "BG-12",
      "name": "Montana",
      "type": "District"
    },
    {
      "code": "BG-13",
      "name": "Pazardzhik",
      "type": "District"
    },
    {
      "code": "BG-14",
      "name": "Pernik",
      "type": "District"
    },
    {
      "code": "BG-15",
      "name": "Pleven",
      "type": "District"
    },
    {
      "code": "BG-16",
      "name": "Plovdiv",
      "type": "District"
    },
    {
      "code": "BG-17",
      "name": "Razgrad",
      "type": "District"
    },
    {
      "code": "BG-18",
      "name": "Ruse",
      "type": "District"
    },
    {
      "code": "BG-19",
      "name": "Silistra",
      "type": "District"
    },
    {
      "code": "BG-20",
      "name": "Sliven",
      "type": "District"
    },
    {
      "code": "BG-21",
      "name": "Smolyan",
      "type": "District"
    },
    {
      "code": "BG-22",
      "name": "Sofia (stolitsa)",
      "type": "District"
    },
    {
      "code": "BG-23",
      "name": "Sofia",
      "type": "District"
    },
    {
      "code": "BG-24",
      "name": "Stara Zagora",
      "type": "District"
    },
    {
      "code": "BG-25",
      "name": "Targovishte",
      "type": "District"
    },
    {
      "code": "BG-26",
      "name": "Haskovo",
      "type": "District"
    },
    {
      "code": "BG-27",
      "name": "Shumen",
      "type": "District"
    },
    {
      "code": "BG-28",
      "name": "Yambol",
      "type": "District"
    },
    {
      "code": "BH-13",
      "name": "Al ‘Āşimah",
      "type": "Governorate"
    },
    {
      "code": "BH-14",
      "name": "Al Janūbīyah",
      "type": "Governorate"
    },
    {
      "code": "BH-15",
      "name": "Al Muḩarraq",
      "type": "Governorate"
    },
    {
      "code": "BH-17",
      "name": "Ash Shamālīyah",
      "type": "Governorate"
    },
    {
      "code": "BI-BB",
      "name": "Bubanza",
      "type": "Province"
    },
    {
      "code": "BI-BL",
      "name": "Bujumbura Rural",
      "type": "Province"
    },
    {
      "code": "BI-BM",
      "name": "Bujumbura Mairie",
      "type": "Province"
    },
    {
      "code": "BI-BR",
      "name": "Bururi",
      "type": "Province"
    },
    {
      "code": "BI-CA",
      "name": "Cankuzo",
      "type": "Province"
    },
    {
      "code": "BI-CI",
      "name": "Cibitoke",
      "type": "Province"
    },
    {
      "code": "BI-GI",
      "name": "Gitega",
      "type": "Province"
    },
    {
      "code": "BI-KI",
      "name": "Kirundo",
      "type": "Province"
    },
    {
      "code": "BI-KR",
      "name": "Karuzi",
      "type": "Province"
    },
    {
      "code": "BI-KY",
      "name": "Kayanza",
      "type": "Province"
    },
    {
      "code": "BI-MA",
      "name": "Makamba",
      "type": "Province"
    },
    {
      "code": "BI-MU",
      "name": "Muramvya",
      "type": "Province"
    },
    {
      "code": "BI-MW",
      "name": "Mwaro",
      "type": "Province"
    },
    {
      "code": "BI-MY",
      "name": "Muyinga",
      "type": "Province"
    },
    {
      "code": "BI-NG",
      "name": "Ngozi",
      "type": "Province"
    },
    {
      "code": "BI-RM",
      "name": "Rumonge",
      "type": "Province"
    },
    {
      "code": "BI-RT",
      "name": "Rutana",
      "type": "Province"
    },
    {
      "code": "BI-RY",
      "name": "Ruyigi",
      "type": "Province"
    },
    {
      "code": "BJ-AK",
      "name": "Atacora",
      "type": "Department"
    },
    {
      "code": "BJ-AL",
      "name": "Alibori",
      "type": "Department"
    },
    {
      "code": "BJ-AQ",
      "name": "Atlantique",
      "type": "Department"
    },
    {
      "code": "BJ-BO",
      "name": "Borgou",
      "type": "Department"
    },
    {
      "code": "BJ-CO",
      "name": "Collines",
      "type": "Department"
    },
    {
      "code": "BJ-DO",
      "name": "Donga",
      "type": "Department"
    },
    {
      "code": "BJ-KO",
      "name": "Couffo",
      "type": "Department"
    },
    {
      "code": "BJ-LI",
      "name": "Littoral",
      "type": "Department"
    },
    {
      "code": "BJ-MO",
      "name": "Mono",
      "type": "Department"
    },
    {
      "code": "BJ-OU",
      "name": "Ouémé",
      "type": "Department"
    },
    {
      "code": "BJ-PL",
      "name": "Plateau",
      "type": "Department"
    },
    {
      "code": "BJ-ZO",
      "name": "Zou",
      "type": "Department"
    },
    {
      "code": "BN-BE",
      "name": "Belait",
      "type": "District"
    },
    {
      "code": "BN-BM",
      "name": "Brunei-Muara",
      "type": "District"
    },
    {
      "code": "BN-TE",
      "name": "Temburong",
      "type": "District"
    },
    {
      "code": "BN-TU",
      "name": "Tutong",
      "type": "District"
    },
    {
      "code": "BO-B",
      "name": "El Beni",
      "type": "Department"
    },
    {
      "code": "BO-C",
      "name": "Cochabamba",
      "type": "Department"
    },
    {
      "code": "BO-H",
      "name": "Chuquisaca",
      "type": "Department"
    },
    {
      "code": "BO-L",
      "name": "La Paz",
      "type": "Department"
    },
    {
      "code": "BO-N",
      "name": "Pando",
      "type": "Department"
    },
    {
      "code": "BO-O",
      "name": "Oruro",
      "type": "Department"
    },
    {
      "code": "BO-P",
      "name": "Potosí",
      "type": "Department"
    },
    {
      "code": "BO-S",
      "name": "Santa Cruz",
      "type": "Department"
    },
    {
      "code": "BO-T",
      "name": "Tarija",
      "type": "Department"
    },
    {
      "code": "BQ-BO",
      "name": "Bonaire",
      "type": "Special municipality"
    },
    {
      "code": "BQ-SA",
      "name": "Saba",
      "type": "Special municipality"
    },
    {
      "code": "BQ-SE",
      "name": "Sint Eustatius",
      "type": "Special municipality"
    },
    {
      "code": "BR-AC",
      "name": "Acre",
      "type": "State"
    },
    {
      "code": "BR-AL",
      "name": "Alagoas",
      "type": "State"
    },
    {
      "code": "BR-AM",
      "name": "Amazonas",
      "type": "State"
    },
    {
      "code": "BR-AP",
      "name": "Amapá",
      "type": "State"
    },
    {
      "code": "BR-BA",
      "name": "Bahia",
      "type": "State"
    },
    {
      "code": "BR-CE",
      "name": "Ceará",
      "type": "State"
    },
    {
      "code": "BR-DF",
      "name": "Distrito Federal",
      "type": "Federal district"
    },
    {
      "code": "BR-ES",
      "name": "Espírito Santo",
      "type": "State"
    },
    {
      "code": "BR-GO",
      "name": "Goiás",
      "type": "State"
    },
    {
      "code": "BR-MA",
      "name": "Maranhão",
      "type": "State"
    },
    {
      "code": "BR-MG",
      "name": "Minas Gerais",
      "type": "State"
    },
    {
      "code": "BR-MS",
      "name": "Mato Grosso do Sul",
      "type": "State"
    },
    {
      "code": "BR-MT",
      "name": "Mato Grosso",
      "type": "State"
    },
    {
      "code": "BR-PA",
      "name": "Pará",
      "type": "State"
    },
    {
      "code": "BR-PB",
      "name": "Paraíba",
      "type": "State"
    },
    {
      "code": "BR-PE",
      "name": "Pernambuco",
      "type": "State"
    },
    {
      "code": "BR-PI",
      "name": "Piauí",
      "type": "State"
    },
    {
      "code": "BR-PR",
      "name": "Paraná",
      "type": "State"
    },
    {
      "code": "BR-RJ",
      "name": "Rio de Janeiro",
      "type": "State"
    },
    {
      "code": "BR-RN",
      "name": "Rio Grande do Norte",
      "type": "State"
    },
    {
      "code": "BR-RO",
      "name": "Rondônia",
      "type": "State"
    },
    {
      "code": "BR-RR",
      "name": "Roraima",
      "type": "State"
    },
    {
      "code": "BR-RS",
      "name": "Rio Grande do Sul",
      "type": "State"
    },
    {
      "code": "BR-SC",
      "name": "Santa Catarina",
      "type": "State"
    },
    {
      "code": "BR-SE",
      "name": "Sergipe",
      "type": "State"
    },
    {
      "code": "BR-SP",
      "name": "São Paulo",
      "type": "State"
    },
    {
      "code": "BR-TO",
      "name": "Tocantins",
      "type": "State"
    },
    {
      "code": "BS-AK",
      "name": "Acklins",
      "type": "District"
    },
    {
      "code": "BS-BI",
      "name": "Bimini",
      "type": "District"
    },
    {
      "code": "BS-BP",
      "name": "Black Point",
      "type": "District"
    },
    {
      "code": "BS-BY",
      "name": "Berry Islands",
      "type": "District"
    },
    {
      "code": "BS-CE",
      "name": "Central Eleuthera",
      "type": "District"
    },
    {
      "code": "BS-CI",
      "name": "Cat Island",
      "type": "District"
    },
    {
      "code": "BS-CK",
      "name": "Crooked Island and Long Cay",
      "type": "District"
    },
    {
      "code": "BS-CO",
      "name": "Central Abaco",
      "type": "District"
    },
    {
      "code": "BS-CS",
      "name": "Central Andros",
      "type": "District"
    },
    {
      "code": "BS-EG",
      "name": "East Grand Bahama",
      "type": "District"
    },
    {
      "code": "BS-EX",
      "name": "Exuma",
      "type": "District"
    },
    {
      "code": "BS-FP",
      "name": "City of Freeport",
      "type": "District"
    },
    {
      "code": "BS-GC",
      "name": "Grand Cay",
      "type": "District"
    },
    {
      "code": "BS-HI",
      "name": "Harbour Island",
      "type": "District"
    },
    {
      "code": "BS-HT",
      "name": "Hope Town",
      "type": "District"
    },
    {
      "code": "BS-IN",
      "name": "Inagua",
      "type": "District"
    },
    {
      "code": "BS-LI",
      "name": "Long Island",
      "type": "District"
    },
    {
      "code": "BS-MC",
      "name": "Mangrove Cay",
      "type": "District"
    },
    {
      "code": "BS-MG",
      "name": "Mayaguana",
      "type": "District"
    },
    {
      "code": "BS-MI",
      "name": "Moore's Island",
      "type": "District"
    },
    {
      "code": "BS-NE",
      "name": "North Eleuthera",
      "type": "District"
    },
    {
      "code": "BS-NO",
      "name": "North Abaco",
      "type": "District"
    },
    {
      "code": "BS-NP",
      "name": "New Providence",
      "type": "Island"
    },
    {
      "code": "BS-NS",
      "name": "North Andros",
      "type": "District"
    },
    {
      "code": "BS-RC",
      "name": "Rum Cay",
      "type": "District"
    },
    {
      "code": "BS-RI",
      "name": "Ragged Island",
      "type": "District"
    },
    {
      "code": "BS-SA",
      "name": "South Andros",
      "type": "District"
    },
    {
      "code": "BS-SE",
      "name": "South Eleuthera",
      "type": "District"
    },
    {
      "code": "BS-SO",
      "name": "South Abaco",
      "type": "District"
    },
    {
      "code": "BS-SS",
      "name": "San Salvador",
      "type": "District"
    },
    {
      "code": "BS-SW",
      "name": "Spanish Wells",
      "type": "District"
    },
    {
      "code": "BS-WG",
      "name": "West Grand Bahama",
      "type": "District"
    },
    {
      "code": "BT-11",
      "name": "Paro",
      "type": "District"
    },
    {
      "code": "BT-12",
      "name": "Chhukha",
      "type": "District"
    },
    {
      "code": "BT-13",
      "name": "Haa",
      "type": "District"
    },
    {
      "code": "BT-14",
      "name": "Samtse",
      "type": "District"
    },
    {
      "code": "BT-15",
      "name": "Thimphu",
      "type": "District"
    },
    {
      "code": "BT-21",
      "name": "Tsirang",
      "type": "District"
    },
    {
      "code": "BT-22",
      "name": "Dagana",
      "type": "District"
    },
    {
      "code": "BT-23",
      "name": "Punakha",
      "type": "District"
    },
    {
      "code": "BT-24",
      "name": "Wangdue Phodrang",
      "type": "District"
    },
    {
      "code": "BT-31",
      "name": "Sarpang",
      "type": "District"
    },
    {
      "code": "BT-32",
      "name": "Trongsa",
      "type": "District"
    },
    {
      "code": "BT-33",
      "name": "Bumthang",
      "type": "District"
    },
    {
      "code": "BT-34",
      "name": "Zhemgang",
      "type": "District"
    },
    {
      "code": "BT-41",
      "name": "Trashigang",
      "type": "District"
    },
    {
      "code": "BT-42",
      "name": "Monggar",
      "type": "District"
    },
    {
      "code": "BT-43",
      "name": "Pema Gatshel",
      "type": "District"
    },
    {
      "code": "BT-44",
      "name": "Lhuentse",
      "type": "District"
    },
    {
      "code": "BT-45",
      "name": "Samdrup Jongkhar",
      "type": "District"
    },
    {
      "code": "BT-GA",
      "name": "Gasa",
      "type": "District"
    },
    {
      "code": "BT-TY",
      "name": "Trashi Yangtse",
      "type": "District"
    },
    {
      "code": "BW-CE",
      "name": "Central",
      "type": "District"
    },
    {
      "code": "BW-CH",
      "name": "Chobe",
      "type": "District"
    },
    {
      "code": "BW-FR",
      "name": "Francistown",
      "type": "City"
    },
    {
      "code": "BW-GA",
      "name": "Gaborone",
      "type": "City"
    },
    {
      "code": "BW-GH",
      "name": "Ghanzi",
      "type": "District"
    },
    {
      "code": "BW-JW",
      "name": "Jwaneng",
      "type": "Town"
    },
    {
      "code": "BW-KG",
      "name": "Kgalagadi",
      "type": "District"
    },
    {
      "code": "BW-KL",
      "name": "Kgatleng",
      "type": "District"
    },
    {
      "code": "BW-KW",
      "name": "Kweneng",
      "type": "District"
    },
    {
      "code": "BW-LO",
      "name": "Lobatse",
      "type": "Town"
    },
    {
      "code": "BW-NE",
      "name": "North East",
      "type": "District"
    },
    {
      "code": "BW-NW",
      "name": "North West",
      "type": "District"
    },
    {
      "code": "BW-SE",
      "name": "South East",
      "type": "District"
    },
    {
      "code": "BW-SO",
      "name": "Southern",
      "type": "District"
    },
    {
      "code": "BW-SP",
      "name": "Selibe Phikwe",
      "type": "Town"
    },
    {
      "code": "BW-ST",
      "name": "Sowa Town",
      "type": "Town"
    },
    {
      "code": "BY-BR",
      "name": "Bresckaja voblasć",
      "type": "Oblast"
    },
    {
      "code": "BY-HM",
      "name": "Gorod Minsk",
      "type": "City"
    },
    {
      "code": "BY-HO",
      "name": "Gomel'skaja oblast'",
      "type": "Oblast"
    },
    {
      "code": "BY-HR",
      "name": "Grodnenskaja oblast'",
      "type": "Oblast"
    },
    {
      "code": "BY-MA",
      "name": "Mahilioŭskaja voblasć",
      "type": "Oblast"
    },
    {
      "code": "BY-MI",
      "name": "Minskaja oblast'",
      "type": "Oblast"
    },
    {
      "code": "BY-VI",
      "name": "Viciebskaja voblasć",
      "type": "Oblast"
    },
    {
      "code": "BZ-BZ",
      "name": "Belize",
      "type": "District"
    },
    {
      "code": "BZ-CY",
      "name": "Cayo",
      "type": "District"
    },
    {
      "code": "BZ-CZL",
      "name": "Corozal",
      "type": "District"
    },
    {
      "code": "BZ-OW",
      "name": "Orange Walk",
      "type": "District"
    },
    {
      "code": "BZ-SC",
      "name": "Stann Creek",
      "type": "District"
    },
    {
      "code": "BZ-TOL",
      "name": "Toledo",
      "type": "District"
    },
    {
      "code": "CA-AB",
      "name": "Alberta",
      "type": "Province"
    },
    {
      "code": "CA-BC",
      "name": "British Columbia",
      "type": "Province"
    },
    {
      "code": "CA-MB",
      "name": "Manitoba",
      "type": "Province"
    },
    {
      "code": "CA-NB",
      "name": "New Brunswick",
      "type": "Province"
    },
    {
      "code": "CA-NL",
      "name": "Newfoundland and Labrador",
      "type": "Province"
    },
    {
      "code": "CA-NS",
      "name": "Nova Scotia",
      "type": "Province"
    },
    {
      "code": "CA-NT",
      "name": "Northwest Territories",
      "type": "Territory"
    },
    {
      "code": "CA-NU",
      "name": "Nunavut",
      "type": "Territory"
    },
    {
      "code": "CA-ON",
      "name": "Ontario",
      "type": "Province"
    },
    {
      "code": "CA-PE",
      "name": "Prince Edward Island",
      "type": "Province"
    },
    {
      "code": "CA-QC",
      "name": "Quebec",
      "type": "Province"
    },
    {
      "code": "CA-SK",
      "name": "Saskatchewan",
      "type": "Province"
    },
    {
      "code": "CA-YT",
      "name": "Yukon",
      "type": "Territory"
    },
    {
      "code": "CD-BC",
      "name": "Kongo Central",
      "type": "Province"
    },
    {
      "code": "CD-BU",
      "name": "Bas-Uélé",
      "type": "Province"
    },
    {
      "code": "CD-EQ",
      "name": "Équateur",
      "type": "Province"
    },
    {
      "code": "CD-HK",
      "name": "Haut-Katanga",
      "type": "Province"
    },
    {
      "code": "CD-HL",
      "name": "Haut-Lomami",
      "type": "Province"
    },
    {
      "code": "CD-HU",
      "name": "Haut-Uélé",
      "type": "Province"
    },
    {
      "code": "CD-IT",
      "name": "Ituri",
      "type": "Province"
    },
    {
      "code": "CD-KC",
      "name": "Kasaï Central",
      "type": "Province"
    },
    {
      "code": "CD-KE",
      "name": "Kasaï Oriental",
      "type": "Province"
    },
    {
      "code": "CD-KG",
      "name": "Kwango",
      "type": "Province"
    },
    {
      "code": "CD-KL",
      "name": "Kwilu",
      "type": "Province"
    },
    {
      "code": "CD-KN",
      "name": "Kinshasa",
      "type": "City"
    },
    {
      "code": "CD-KS",
      "name": "Kasaï",
      "type": "Province"
    },
    {
      "code": "CD-LO",
      "name": "Lomami",
      "type": "Province"
    },
    {
      "code": "CD-LU",
      "name": "Lualaba",
      "type": "Province"
    },
    {
      "code": "CD-MA",
      "name": "Maniema",
      "type": "Province"
    },
    {
      "code": "CD-MN",
      "name": "Mai-Ndombe",
      "type": "Province"
    },
    {
      "code": "CD-MO",
      "name": "Mongala",
      "type": "Province"
    },
    {
      "code": "CD-NK",
      "name": "Nord-Kivu",
      "type": "Province"
    },
    {
      "code": "CD-NU",
      "name": "Nord-Ubangi",
      "type": "Province"
    },
    {
      "code": "CD-SA",
      "name": "Sankuru",
      "type": "Province"
    },
    {
      "code": "CD-SK",
      "name": "Sud-Kivu",
      "type": "Province"
    },
    {
      "code": "CD-SU",
      "name": "Sud-Ubangi",
      "type": "Province"
    },
    {
      "code": "CD-TA",
      "name": "Tanganyika",
      "type": "Province"
    },
    {
      "code": "CD-TO",
      "name": "Tshopo",
      "type": "Province"
    },
    {
      "code": "CD-TU",
      "name": "Tshuapa",
      "type": "Province"
    },
    {
      "code": "CF-AC",
      "name": "Ouham",
      "type": "Prefecture"
    },
    {
      "code": "CF-BB",
      "name": "Bamingui-Bangoran",
      "type": "Prefecture"
    },
    {
      "code": "CF-BGF",
      "name": "Bangui",
      "type": "Commune"
    },
    {
      "code": "CF-BK",
      "name": "Basse-Kotto",
      "type": "Prefecture"
    },
    {
      "code": "CF-HK",
      "name": "Haute-Kotto",
      "type": "Prefecture"
    },
    {
      "code": "CF-HM",
      "name": "Haut-Mbomou",
      "type": "Prefecture"
    },
    {
      "code": "CF-HS",
      "name": "Haute-Sangha / Mambéré-Kadéï",
      "type": "Prefecture"
    },
    {
      "code": "CF-KB",
      "name": "Gribingui",
      "type": "Economic prefecture"
    },
    {
      "code": "CF-KG",
      "name": "Kemö-Gïrïbïngï",
      "type": "Prefecture"
    },
    {
      "code": "CF-LB",
      "name": "Lobaye",
      "type": "Prefecture"
    },
    {
      "code": "CF-MB",
      "name": "Mbomou",
      "type": "Prefecture"
    },
    {
      "code": "CF-MP",
      "name": "Ombella-Mpoko",
      "type": "Prefecture"
    },
    {
      "code": "CF-NM",
      "name": "Nana-Mambéré",
      "type": "Prefecture"
    },
    {
      "code": "CF-OP",
      "name": "Ouham-Pendé",
      "type": "Prefecture"
    },
    {
      "code": "CF-SE",
      "name": "Sangha",
      "type": "Economic prefecture"
    },
    {
      "code": "CF-UK",
      "name": "Ouaka",
      "type": "Prefecture"
    },
    {
      "code": "CF-VK",
      "name": "Vakaga",
      "type": "Prefecture"
    },
    {
      "code": "CG-11",
      "name": "Bouenza",
      "type": "Department"
    },
    {
      "code": "CG-12",
      "name": "Pool",
      "type": "Department"
    },
    {
      "code": "CG-13",
      "name": "Sangha",
      "type": "Department"
    },
    {
      "code": "CG-14",
      "name": "Plateaux",
      "type": "Department"
    },
    {
      "code": "CG-15",
      "name": "Cuvette-Ouest",
      "type": "Department"
    },
    {
      "code": "CG-16",
      "name": "Pointe-Noire",
      "type": "Department"
    },
    {
      "code": "CG-2",
      "name": "Lékoumou",
      "type": "Department"
    },
    {
      "code": "CG-5",
      "name": "Kouilou",
      "type": "Department"
    },
    {
      "code": "CG-7",
      "name": "Likouala",
      "type": "Department"
    },
    {
      "code": "CG-8",
      "name": "Cuvette",
      "type": "Department"
    },
    {
      "code": "CG-9",
      "name": "Niari",
      "type": "Department"
    },
    {
      "code": "CG-BZV",
      "name": "Brazzaville",
      "type": "Department"
    },
    {
      "code": "CH-AG",
      "name": "Aargau",
      "type": "Canton"
    },
    {
      "code": "CH-AI",
      "name": "Appenzell Innerrhoden",
      "type": "Canton"
    },
    {
      "code": "CH-AR",
      "name": "Appenzell Ausserrhoden",
      "type": "Canton"
    },
    {
      "code": "CH-BE",
      "name": "Bern",
      "type": "Canton"
    },
    {
      "code": "CH-BL",
      "name": "Basel-Landschaft",
      "type": "Canton"
    },
    {
      "code": "CH-BS",
      "name": "Basel-Stadt",
      "type": "Canton"
    },
    {
      "code": "CH-FR",
      "name": "Freiburg",
      "type": "Canton"
    },
    {
      "code": "CH-GE",
      "name": "Genève",
      "type": "Canton"
    },
    {
      "code": "CH-GL",
      "name": "Glarus",
      "type": "Canton"
    },
    {
      "code": "CH-GR",
      "name": "Graubünden",
      "type": "Canton"
    },
    {
      "code": "CH-JU",
      "name": "Jura",
      "type": "Canton"
    },
    {
      "code": "CH-LU",
      "name": "Luzern",
      "type": "Canton"
    },
    {
      "code": "CH-NE",
      "name": "Neuchâtel",
      "type": "Canton"
    },
    {
      "code": "CH-NW",
      "name": "Nidwalden",
      "type": "Canton"
    },
    {
      "code": "CH-OW",
      "name": "Obwalden",
      "type": "Canton"
    },
    {
      "code": "CH-SG",
      "name": "Sankt Gallen",
      "type": "Canton"
    },
    {
      "code": "CH-SH",
      "name": "Schaffhausen",
      "type": "Canton"
    },
    {
      "code": "CH-SO",
      "name": "Solothurn",
      "type": "Canton"
    },
    {
      "code": "CH-SZ",
      "name": "Schwyz",
      "type": "Canton"
    },
    {
      "code": "CH-TG",
      "name": "Thurgau",
      "type": "Canton"
    },
    {
      "code": "CH-TI",
      "name": "Ticino",
      "type": "Canton"
    },
    {
      "code": "CH-UR",
      "name": "Uri",
      "type": "Canton"
    },
    {
      "code": "CH-VD",
      "name": "Vaud",
      "type": "Canton"
    },
    {
      "code": "CH-VS",
      "name": "Valais",
      "type": "Canton"
    },
    {
      "code": "CH-ZG",
      "name": "Zug",
      "type": "Canton"
    },
    {
      "code": "CH-ZH",
      "name": "Zürich",
      "type": "Canton"
    },
    {
      "code": "CI-AB",
      "name": "Abidjan",
      "type": "Autonomous district"
    },
    {
      "code": "CI-BS",
      "name": "Bas-Sassandra",
      "type": "District"
    },
    {
      "code": "CI-CM",
      "name": "Comoé",
      "type": "District"
    },
    {
      "code": "CI-DN",
      "name": "Denguélé",
      "type": "District"
    },
    {
      "code": "CI-GD",
      "name": "Gôh-Djiboua",
      "type": "District"
    },
    {
      "code": "CI-LC",
      "name": "Lacs",
      "type": "District"
    },
    {
      "code": "CI-LG",
      "name": "Lagunes",
      "type": "District"
    },
    {
      "code": "CI-MG",
      "name": "Montagnes",
      "type": "District"
    },
    {
      "code": "CI-SM",
      "name": "Sassandra-Marahoué",
      "type": "District"
    },
    {
      "code": "CI-SV",
      "name": "Savanes",
      "type": "District"
    },
    {
      "code": "CI-VB",
      "name": "Vallée du Bandama",
      "type": "District"
    },
    {
      "code": "CI-WR",
      "name": "Woroba",
      "type": "District"
    },
    {
      "code": "CI-YM",
      "name": "Yamoussoukro",
      "type": "Autonomous district"
    },
    {
      "code": "CI-ZZ",
      "name": "Zanzan",
      "type": "District"
    },
    {
      "code": "CL-AI",
      "name": "Aisén del General Carlos Ibañez del Campo",
      "type": "Region"
    },
    {
      "code": "CL-AN",
      "name": "Antofagasta",
      "type": "Region"
    },
    {
      "code": "CL-AP",
      "name": "Arica y Parinacota",
      "type": "Region"
    },
    {
      "code": "CL-AR",
      "name": "La Araucanía",
      "type": "Region"
    },
    {
      "code": "CL-AT",
      "name": "Atacama",
      "type": "Region"
    },
    {
      "code": "CL-BI",
      "name": "Biobío",
      "type": "Region"
    },
    {
      "code": "CL-CO",
      "name": "Coquimbo",
      "type": "Region"
    },
    {
      "code": "CL-LI",
      "name": "Libertador General Bernardo O'Higgins",
      "type": "Region"
    },
    {
      "code": "CL-LL",
      "name": "Los Lagos",
      "type": "Region"
    },
    {
      "code": "CL-LR",
      "name": "Los Ríos",
      "type": "Region"
    },
    {
      "code": "CL-MA",
      "name": "Magallanes",
      "type": "Region"
    },
    {
      "code": "CL-ML",
      "name": "Maule",
      "type": "Region"
    },
    {
      "code": "CL-NB",
      "name": "Ñuble",
      "type": "Region"
    },
    {
      "code": "CL-RM",
      "name": "Región Metropolitana de Santiago",
      "type": "Region"
    },
    {
      "code": "CL-TA",
      "name": "Tarapacá",
      "type": "Region"
    },
    {
      "code": "CL-VS",
      "name": "Valparaíso",
      "type": "Region"
    },
    {
      "code": "CM-AD",
      "name": "Adamaoua",
      "type": "Region"
    },
    {
      "code": "CM-CE",
      "name": "Centre",
      "type": "Region"
    },
    {
      "code": "CM-EN",
      "name": "Far North",
      "type": "Region"
    },
    {
      "code": "CM-ES",
      "name": "East",
      "type": "Region"
    },
    {
      "code": "CM-LT",
      "name": "Littoral",
      "type": "Region"
    },
    {
      "code": "CM-NO",
      "name": "North",
      "type": "Region"
    },
    {
      "code": "CM-NW",
      "name": "North-West",
      "type": "Region"
    },
    {
      "code": "CM-OU",
      "name": "West",
      "type": "Region"
    },
    {
      "code": "CM-SU",
      "name": "South",
      "type": "Region"
    },
    {
      "code": "CM-SW",
      "name": "South-West",
      "type": "Region"
    },
    {
      "code": "CN-AH",
      "name": "Anhui Sheng",
      "type": "Province"
    },
    {
      "code": "CN-BJ",
      "name": "Beijing Shi",
      "type": "Municipality"
    },
    {
      "code": "CN-CQ",
      "name": "Chongqing Shi",
      "type": "Municipality"
    },
    {
      "code": "CN-FJ",
      "name": "Fujian Sheng",
      "type": "Province"
    },
    {
      "code": "CN-GD",
      "name": "Guangdong Sheng",
      "type": "Province"
    },
    {
      "code": "CN-GS",
      "name": "Gansu Sheng",
      "type": "Province"
    },
    {
      "code": "CN-GX",
      "name": "Guangxi Zhuangzu Zizhiqu",
      "type": "Autonomous region"
    },
    {
      "code": "CN-GZ",
      "name": "Guizhou Sheng",
      "type": "Province"
    },
    {
      "code": "CN-HA",
      "name": "Henan Sheng",
      "type": "Province"
    },
    {
      "code": "CN-HB",
      "name": "Hubei Sheng",
      "type": "Province"
    },
    {
      "code": "CN-HE",
      "name": "Hebei Sheng",
      "type": "Province"
    },
    {
      "code": "CN-HI",
      "name": "Hainan Sheng",
      "type": "Province"
    },
    {
      "code": "CN-HK",
      "name": "Hong Kong SAR",
      "type": "Special administrative region"
    },
    {
      "code": "CN-HL",
      "name": "Heilongjiang Sheng",
      "type": "Province"
    },
    {
      "code": "CN-HN",
      "name": "Hunan Sheng",
      "type": "Province"
    },
    {
      "code": "CN-JL",
      "name": "Jilin Sheng",
      "type": "Province"
    },
    {
      "code": "CN-JS",
      "name": "Jiangsu Sheng",
      "type": "Province"
    },
    {
      "code": "CN-JX",
      "name": "Jiangxi Sheng",
      "type": "Province"
    },
    {
      "code": "CN-LN",
      "name": "Liaoning Sheng",
      "type": "Province"
    },
    {
      "code": "CN-MO",
      "name": "Macao SAR",
      "type": "Special administrative region"
    },
    {
      "code": "CN-NM",
      "name": "Nei Mongol Zizhiqu",
      "type": "Autonomous region"
    },
    {
      "code": "CN-NX",
      "name": "Ningxia Huizi Zizhiqu",
      "type": "Autonomous region"
    },
    {
      "code": "CN-QH",
      "name": "Qinghai Sheng",
      "type": "Province"
    },
    {
      "code": "CN-SC",
      "name": "Sichuan Sheng",
      "type": "Province"
    },
    {
      "code": "CN-SD",
      "name": "Shandong Sheng",
      "type": "Province"
    },
    {
      "code": "CN-SH",
      "name": "Shanghai Shi",
      "type": "Municipality"
    },
    {
      "code": "CN-SN",
      "name": "Shaanxi Sheng",
      "type": "Province"
    },
    {
      "code": "CN-SX",
      "name": "Shanxi Sheng",
      "type": "Province"
    },
    {
      "code": "CN-TJ",
      "name": "Tianjin Shi",
      "type": "Municipality"
    },
    {
      "code": "CN-TW",
      "name": "Taiwan Sheng",
      "type": "Province"
    },
    {
      "code": "CN-XJ",
      "name": "Xinjiang Uygur Zizhiqu",
      "type": "Autonomous region"
    },
    {
      "code": "CN-XZ",
      "name": "Xizang Zizhiqu",
      "type": "Autonomous region"
    },
    {
      "code": "CN-YN",
      "name": "Yunnan Sheng",
      "type": "Province"
    },
    {
      "code": "CN-ZJ",
      "name": "Zhejiang Sheng",
      "type": "Province"
    },
    {
      "code": "CO-AMA",
      "name": "Amazonas",
      "type": "Department"
    },
    {
      "code": "CO-ANT",
      "name": "Antioquia",
      "type": "Department"
    },
    {
      "code": "CO-ARA",
      "name": "Arauca",
      "type": "Department"
    },
    {
      "code": "CO-ATL",
      "name": "Atlántico",
      "type": "Department"
    },
    {
      "code": "CO-BOL",
      "name": "Bolívar",
      "type": "Department"
    },
    {
      "code": "CO-BOY",
      "name": "Boyacá",
      "type": "Department"
    },
    {
      "code": "CO-CAL",
      "name": "Caldas",
      "type": "Department"
    },
    {
      "code": "CO-CAQ",
      "name": "Caquetá",
      "type": "Department"
    },
    {
      "code": "CO-CAS",
      "name": "Casanare",
      "type": "Department"
    },
    {
      "code": "CO-CAU",
      "name": "Cauca",
      "type": "Department"
    },
    {
      "code": "CO-CES",
      "name": "Cesar",
      "type": "Department"
    },
    {
      "code": "CO-CHO",
      "name": "Chocó",
      "type": "Department"
    },
    {
      "code": "CO-COR",
      "name": "Córdoba",
      "type": "Department"
    },
    {
      "code": "CO-CUN",
      "name": "Cundinamarca",
      "type": "Department"
    },
    {
      "code": "CO-DC",
      "name": "Distrito Capital de Bogotá",
      "type": "Capital district"
    },
    {
      "code": "CO-GUA",
      "name": "Guainía",
      "type": "Department"
    },
    {
      "code": "CO-GUV",
      "name": "Guaviare",
      "type": "Department"
    },
    {
      "code": "CO-HUI",
      "name": "Huila",
      "type": "Department"
    },
    {
      "code": "CO-LAG",
      "name": "La Guajira",
      "type": "Department"
    },
    {
      "code": "CO-MAG",
      "name": "Magdalena",
      "type": "Department"
    },
    {
      "code": "CO-MET",
      "name": "Meta",
      "type": "Department"
    },
    {
      "code": "CO-NAR",
      "name": "Nariño",
      "type": "Department"
    },
    {
      "code": "CO-NSA",
      "name": "Norte de Santander",
      "type": "Department"
    },
    {
      "code": "CO-PUT",
      "name": "Putumayo",
      "type": "Department"
    },
    {
      "code": "CO-QUI",
      "name": "Quindío",
      "type": "Department"
    },
    {
      "code": "CO-RIS",
      "name": "Risaralda",
      "type": "Department"
    },
    {
      "code": "CO-SAN",
      "name": "Santander",
      "type": "Department"
    },
    {
      "code": "CO-SAP",
      "name": "San Andrés, Providencia y Santa Catalina",
      "type": "Department"
    },
    {
      "code": "CO-SUC",
      "name": "Sucre",
      "type": "Department"
    },
    {
      "code": "CO-TOL",
      "name": "Tolima",
      "type": "Department"
    },
    {
      "code": "CO-VAC",
      "name": "Valle del Cauca",
      "type": "Department"
    },
    {
      "code": "CO-VAU",
      "name": "Vaupés",
      "type": "Department"
    },
    {
      "code": "CO-VID",
      "name": "Vichada",
      "type": "Department"
    },
    {
      "code": "CR-A",
      "name": "Alajuela",
      "type": "Province"
    },
    {
      "code": "CR-C",
      "name": "Cartago",
      "type": "Province"
    },
    {
      "code": "CR-G",
      "name": "Guanacaste",
      "type": "Province"
    },
    {
      "code": "CR-H",
      "name": "Heredia",
      "type": "Province"
    },
    {
      "code": "CR-L",
      "name": "Limón",
      "type": "Province"
    },
    {
      "code": "CR-P",
      "name": "Puntarenas",
      "type": "Province"
    },
    {
      "code": "CR-SJ",
      "name": "San José",
      "type": "Province"
    },
    {
      "code": "CU-01",
      "name": "Pinar del Río",
      "type": "Province"
    },
    {
      "code": "CU-03",
      "name": "La Habana",
      "type": "Province"
    },
    {
      "code": "CU-04",
      "name": "Matanzas",
      "type": "Province"
    },
    {
      "code": "CU-05",
      "name": "Villa Clara",
      "type": "Province"
    },
    {
      "code": "CU-06",
      "name": "Cienfuegos",
      "type": "Province"
    },
    {
      "code": "CU-07",
      "name": "Sancti Spíritus",
      "type": "Province"
    },
    {
      "code": "CU-08",
      "name": "Ciego de Ávila",
      "type": "Province"
    },
    {
      "code": "CU-09",
      "name": "Camagüey",
      "type": "Province"
    },
    {
      "code": "CU-10",
      "name": "Las Tunas",
      "type": "Province"
    },
    {
      "code": "CU-11",
      "name": "Holguín",
      "type": "Province"
    },
    {
      "code": "CU-12",
      "name": "Granma",
      "type": "Province"
    },
    {
      "code": "CU-13",
      "name": "Santiago de Cuba",
      "type": "Province"
    },
    {
      "code": "CU-14",
      "name": "Guantánamo",
      "type": "Province"
    },
    {
      "code": "CU-15",
      "name": "Artemisa",
      "type": "Province"
    },
    {
      "code": "CU-16",
      "name": "Mayabeque",
      "type": "Province"
    },
    {
      "code": "CU-99",
      "name": "Isla de la Juventud",
      "type": "Special municipality"
    },
    {
      "code": "CV-B",
      "name": "Ilhas de Barlavento",
      "type": "Geographical region"
    },
    {
      "code": "CV-BR",
      "name": "Brava",
      "parent": "S",
      "type": "Municipality"
    },
    {
      "code": "CV-BV",
      "name": "Boa Vista",
      "parent": "B",
      "type": "Municipality"
    },
    {
      "code": "CV-CA",
      "name": "Santa Catarina",
      "parent": "S",
      "type": "Municipality"
    },
    {
      "code": "CV-CF",
      "name": "Santa Catarina do Fogo",
      "parent": "S",
      "type": "Municipality"
    },
    {
      "code": "CV-CR",
      "name": "Santa Cruz",
      "parent": "S",
      "type": "Municipality"
    },
    {
      "code": "CV-MA",
      "name": "Maio",
      "parent": "S",
      "type": "Municipality"
    },
    {
      "code": "CV-MO",
      "name": "Mosteiros",
      "parent": "S",
      "type": "Municipality"
    },
    {
      "code": "CV-PA",
      "name": "Paul",
      "parent": "B",
      "type": "Municipality"
    },
    {
      "code": "CV-PN",
      "name": "Porto Novo",
      "parent": "B",
      "type": "Municipality"
    },
    {
      "code": "CV-PR",
      "name": "Praia",
      "parent": "S",
      "type": "Municipality"
    },
    {
      "code": "CV-RB",
      "name": "Ribeira Brava",
      "parent": "B",
      "type": "Municipality"
    },
    {
      "code": "CV-RG",
      "name": "Ribeira Grande",
      "parent": "B",
      "type": "Municipality"
    },
    {
      "code": "CV-RS",
      "name": "Ribeira Grande de Santiago",
      "parent": "S",
      "type": "Municipality"
    },
    {
      "code": "CV-S",
      "name": "Ilhas de Sotavento",
      "type": "Geographical region"
    },
    {
      "code": "CV-SD",
      "name": "São Domingos",
      "parent": "S",
      "type": "Municipality"
    },
    {
      "code": "CV-SF",
      "name": "São Filipe",
      "parent": "S",
      "type": "Municipality"
    },
    {
      "code": "CV-SL",
      "name": "Sal",
      "parent": "B",
      "type": "Municipality"
    },
    {
      "code": "CV-SM",
      "name": "São Miguel",
      "parent": "S",
      "type": "Municipality"
    },
    {
      "code": "CV-SO",
      "name": "São Lourenço dos Órgãos",
      "parent": "S",
      "type": "Municipality"
    },
    {
      "code": "CV-SS",
      "name": "São Salvador do Mundo",
      "parent": "S",
      "type": "Municipality"
    },
    {
      "code": "CV-SV",
      "name": "São Vicente",
      "parent": "B",
      "type": "Municipality"
    },
    {
      "code": "CV-TA",
      "name": "Tarrafal",
      "parent": "S",
      "type": "Municipality"
    },
    {
      "code": "CV-TS",
      "name": "Tarrafal de São Nicolau",
      "parent": "B",
      "type": "Municipality"
    },
    {
      "code": "CY-01",
      "name": "Lefkosia",
      "type": "District"
    },
    {
      "code": "CY-02",
      "name": "Lemesos",
      "type": "District"
    },
    {
      "code": "CY-03",
      "name": "Larnaka",
      "type": "District"
    },
    {
      "code": "CY-04",
      "name": "Ammochostos",
      "type": "District"
    },
    {
      "code": "CY-05",
      "name": "Baf",
      "type": "District"
    },
    {
      "code": "CY-06",
      "name": "Girne",
      "type": "District"
    },
    {
      "code": "CZ-10",
      "name": "Praha, Hlavní město",
      "type": "Capital city"
    },
    {
      "code": "CZ-20",
      "name": "Středočeský kraj",
      "type": "Region"
    },
    {
      "code": "CZ-201",
      "name": "Benešov",
      "parent": "20",
      "type": "District"
    },
    {
      "code": "CZ-202",
      "name": "Beroun",
      "parent": "20",
      "type": "District"
    },
    {
      "code": "CZ-203",
      "name": "Kladno",
      "parent": "20",
      "type": "District"
    },
    {
      "code": "CZ-204",
      "name": "Kolín",
      "parent": "20",
      "type": "District"
    },
    {
      "code": "CZ-205",
      "name": "Kutná Hora",
      "parent": "20",
      "type": "District"
    },
    {
      "code": "CZ-206",
      "name": "Mělník",
      "parent": "20",
      "type": "District"
    },
    {
      "code": "CZ-207",
      "name": "Mladá Boleslav",
      "parent": "20",
      "type": "District"
    },
    {
      "code": "CZ-208",
      "name": "Nymburk",
      "parent": "20",
      "type": "District"
    },
    {
      "code": "CZ-209",
      "name": "Praha-východ",
      "parent": "20",
      "type": "District"
    },
    {
      "code": "CZ-20A",
      "name": "Praha-západ",
      "parent": "20",
      "type": "District"
    },
    {
      "code": "CZ-20B",
      "name": "Příbram",
      "parent": "20",
      "type": "District"
    },
    {
      "code": "CZ-20C",
      "name": "Rakovník",
      "parent": "20",
      "type": "District"
    },
    {
      "code": "CZ-31",
      "name": "Jihočeský kraj",
      "type": "Region"
    },
    {
      "code": "CZ-311",
      "name": "České Budějovice",
      "parent": "31",
      "type": "District"
    },
    {
      "code": "CZ-312",
      "name": "Český Krumlov",
      "parent": "31",
      "type": "District"
    },
    {
      "code": "CZ-313",
      "name": "Jindřichův Hradec",
      "parent": "31",
      "type": "District"
    },
    {
      "code": "CZ-314",
      "name": "Písek",
      "parent": "31",
      "type": "District"
    },
    {
      "code": "CZ-315",
      "name": "Prachatice",
      "parent": "31",
      "type": "District"
    },
    {
      "code": "CZ-316",
      "name": "Strakonice",
      "parent": "31",
      "type": "District"
    },
    {
      "code": "CZ-317",
      "name": "Tábor",
      "parent": "31",
      "type": "District"
    },
    {
      "code": "CZ-32",
      "name": "Plzeňský kraj",
      "type": "Region"
    },
    {
      "code": "CZ-321",
      "name": "Domažlice",
      "parent": "32",
      "type": "District"
    },
    {
      "code": "CZ-322",
      "name": "Klatovy",
      "parent": "32",
      "type": "District"
    },
    {
      "code": "CZ-323",
      "name": "Plzeň-město",
      "parent": "32",
      "type": "District"
    },
    {
      "code": "CZ-324",
      "name": "Plzeň-jih",
      "parent": "32",
      "type": "District"
    },
    {
      "code": "CZ-325",
      "name": "Plzeň-sever",
      "parent": "32",
      "type": "District"
    },
    {
      "code": "CZ-326",
      "name": "Rokycany",
      "parent": "32",
      "type": "District"
    },
    {
      "code": "CZ-327",
      "name": "Tachov",
      "parent": "32",
      "type": "District"
    },
    {
      "code": "CZ-41",
      "name": "Karlovarský kraj",
      "type": "Region"
    },
    {
      "code": "CZ-411",
      "name": "Cheb",
      "parent": "41",
      "type": "District"
    },
    {
      "code": "CZ-412",
      "name": "Karlovy Vary",
      "parent": "41",
      "type": "District"
    },
    {
      "code": "CZ-413",
      "name": "Sokolov",
      "parent": "41",
      "type": "District"
    },
    {
      "code": "CZ-42",
      "name": "Ústecký kraj",
      "type": "Region"
    },
    {
      "code": "CZ-421",
      "name": "Děčín",
      "parent": "42",
      "type": "District"
    },
    {
      "code": "CZ-422",
      "name": "Chomutov",
      "parent": "42",
      "type": "District"
    },
    {
      "code": "CZ-423",
      "name": "Litoměřice",
      "parent": "42",
      "type": "District"
    },
    {
      "code": "CZ-424",
      "name": "Louny",
      "parent": "42",
      "type": "District"
    },
    {
      "code": "CZ-425",
      "name": "Most",
      "parent": "42",
      "type": "District"
    },
    {
      "code": "CZ-426",
      "name": "Teplice",
      "parent": "42",
      "type": "District"
    },
    {
      "code": "CZ-427",
      "name": "Ústí nad Labem",
      "parent": "42",
      "type": "District"
    },
    {
      "code": "CZ-51",
      "name": "Liberecký kraj",
      "type": "Region"
    },
    {
      "code": "CZ-511",
      "name": "Česká Lípa",
      "parent": "51",
      "type": "District"
    },
    {
      "code": "CZ-512",
      "name": "Jablonec nad Nisou",
      "parent": "51",
      "type": "District"
    },
    {
      "code": "CZ-513",
      "name": "Liberec",
      "parent": "51",
      "type": "District"
    },
    {
      "code": "CZ-514",
      "name": "Semily",
      "parent": "51",
      "type": "District"
    },
    {
      "code": "CZ-52",
      "name": "Královéhradecký kraj",
      "type": "Region"
    },
    {
      "code": "CZ-521",
      "name": "Hradec Králové",
      "parent": "52",
      "type": "District"
    },
    {
      "code": "CZ-522",
      "name": "Jičín",
      "parent": "52",
      "type": "District"
    },
    {
      "code": "CZ-523",
      "name": "Náchod",
      "parent": "52",
      "type": "District"
    },
    {
      "code": "CZ-524",
      "name": "Rychnov nad Kněžnou",
      "parent": "52",
      "type": "District"
    },
    {
      "code": "CZ-525",
      "name": "Trutnov",
      "parent": "52",
      "type": "District"
    },
    {
      "code": "CZ-53",
      "name": "Pardubický kraj",
      "type": "Region"
    },
    {
      "code": "CZ-531",
      "name": "Chrudim",
      "parent": "53",
      "type": "District"
    },
    {
      "code": "CZ-532",
      "name": "Pardubice",
      "parent": "53",
      "type": "District"
    },
    {
      "code": "CZ-533",
      "name": "Svitavy",
      "parent": "53",
      "type": "District"
    },
    {
      "code": "CZ-534",
      "name": "Ústí nad Orlicí",
      "parent": "53",
      "type": "District"
    },
    {
      "code": "CZ-63",
      "name": "Kraj Vysočina",
      "type": "Region"
    },
    {
      "code": "CZ-631",
      "name": "Havlíčkův Brod",
      "parent": "63",
      "type": "District"
    },
    {
      "code": "CZ-632",
      "name": "Jihlava",
      "parent": "63",
      "type": "District"
    },
    {
      "code": "CZ-633",
      "name": "Pelhřimov",
      "parent": "63",
      "type": "District"
    },
    {
      "code": "CZ-634",
      "name": "Třebíč",
      "parent": "63",
      "type": "District"
    },
    {
      "code": "CZ-635",
      "name": "Žďár nad Sázavou",
      "parent": "63",
      "type": "District"
    },
    {
      "code": "CZ-64",
      "name": "Jihomoravský kraj",
      "type": "Region"
    },
    {
      "code": "CZ-641",
      "name": "Blansko",
      "parent": "64",
      "type": "District"
    },
    {
      "code": "CZ-642",
      "name": "Brno-město",
      "parent": "64",
      "type": "District"
    },
    {
      "code": "CZ-643",
      "name": "Brno-venkov",
      "parent": "64",
      "type": "District"
    },
    {
      "code": "CZ-644",
      "name": "Břeclav",
      "parent": "64",
      "type": "District"
    },
    {
      "code": "CZ-645",
      "name": "Hodonín",
      "parent": "64",
      "type": "District"
    },
    {
      "code": "CZ-646",
      "name": "Vyškov",
      "parent": "64",
      "type": "District"
    },
    {
      "code": "CZ-647",
      "name": "Znojmo",
      "parent": "64",
      "type": "District"
    },
    {
      "code": "CZ-71",
      "name": "Olomoucký kraj",
      "type": "Region"
    },
    {
      "code": "CZ-711",
      "name": "Jeseník",
      "parent": "71",
      "type": "District"
    },
    {
      "code": "CZ-712",
      "name": "Olomouc",
      "parent": "71",
      "type": "District"
    },
    {
      "code": "CZ-713",
      "name": "Prostějov",
      "parent": "71",
      "type": "District"
    },
    {
      "code": "CZ-714",
      "name": "Přerov",
      "parent": "71",
      "type": "District"
    },
    {
      "code": "CZ-715",
      "name": "Šumperk",
      "parent": "71",
      "type": "District"
    },
    {
      "code": "CZ-72",
      "name": "Zlínský kraj",
      "type": "Region"
    },
    {
      "code": "CZ-721",
      "name": "Kroměříž",
      "parent": "72",
      "type": "District"
    },
    {
      "code": "CZ-722",
      "name": "Uherské Hradiště",
      "parent": "72",
      "type": "District"
    },
    {
      "code": "CZ-723",
      "name": "Vsetín",
      "parent": "72",
      "type": "District"
    },
    {
      "code": "CZ-724",
      "name": "Zlín",
      "parent": "72",
      "type": "District"
    },
    {
      "code": "CZ-80",
      "name": "Moravskoslezský kraj",
      "type": "Region"
    },
    {
      "code": "CZ-801",
      "name": "Bruntál",
      "parent": "80",
      "type": "District"
    },
    {
      "code": "CZ-802",
      "name": "Frýdek-Místek",
      "parent": "80",
      "type": "District"
    },
    {
      "code": "CZ-803",
      "name": "Karviná",
      "parent": "80",
      "type": "District"
    },
    {
      "code": "CZ-804",
      "name": "Nový Jičín",
      "parent": "80",
      "type": "District"
    },
    {
      "code": "CZ-805",
      "name": "Opava",
      "parent": "80",
      "type": "District"
    },
    {
      "code": "CZ-806",
      "name": "Ostrava-město",
      "parent": "80",
      "type": "District"
    },
    {
      "code": "DE-BB",
      "name": "Brandenburg",
      "type": "Land"
    },
    {
      "code": "DE-BE",
      "name": "Berlin",
      "type": "Land"
    },
    {
      "code": "DE-BW",
      "name": "Baden-Württemberg",
      "type": "Land"
    },
    {
      "code": "DE-BY",
      "name": "Bayern",
      "type": "Land"
    },
    {
      "code": "DE-HB",
      "name": "Bremen",
      "type": "Land"
    },
    {
      "code": "DE-HE",
      "name": "Hessen",
      "type": "Land"
    },
    {
      "code": "DE-HH",
      "name": "Hamburg",
      "type": "Land"
    },
    {
      "code": "DE-MV",
      "name": "Mecklenburg-Vorpommern",
      "type": "Land"
    },
    {
      "code": "DE-NI",
      "name": "Niedersachsen",
      "type": "Land"
    },
    {
      "code": "DE-NW",
      "name": "Nordrhein-Westfalen",
      "type": "Land"
    },
    {
      "code": "DE-RP",
      "name": "Rheinland-Pfalz",
      "type": "Land"
    },
    {
      "code": "DE-SH",
      "name": "Schleswig-Holstein",
      "type": "Land"
    },
    {
      "code": "DE-SL",
      "name": "Saarland",
      "type": "Land"
    },
    {
      "code": "DE-SN",
      "name": "Sachsen",
      "type": "Land"
    },
    {
      "code": "DE-ST",
      "name": "Sachsen-Anhalt",
      "type": "Land"
    },
    {
      "code": "DE-TH",
      "name": "Thüringen",
      "type": "Land"
    },
    {
      "code": "DJ-AR",
      "name": "Arta",
      "type": "Region"
    },
    {
      "code": "DJ-AS",
      "name": "Ali Sabieh",
      "type": "Region"
    },
    {
      "code": "DJ-DI",
      "name": "Dikhil",
      "type": "Region"
    },
    {
      "code": "DJ-DJ",
      "name": "Djibouti",
      "type": "City"
    },
    {
      "code": "DJ-OB",
      "name": "Awbūk",
      "type": "Region"
    },
    {
      "code": "DJ-TA",
      "name": "Tadjourah",
      "type": "Region"
    },
    {
      "code": "DK-81",
      "name": "Nordjylland",
      "type": "Region"
    },
    {
      "code": "DK-82",
      "name": "Midtjylland",
      "type": "Region"
    },
    {
      "code": "DK-83",
      "name": "Syddanmark",
      "type": "Region"
    },
    {
      "code": "DK-84",
      "name": "Hovedstaden",
      "type": "Region"
    },
    {
      "code": "DK-85",
      "name": "Sjælland",
      "type": "Region"
    },
    {
      "code": "DM-02",
      "name": "Saint Andrew",
      "type": "Parish"
    },
    {
      "code": "DM-03",
      "name": "Saint David",
      "type": "Parish"
    },
    {
      "code": "DM-04",
      "name": "Saint George",
      "type": "Parish"
    },
    {
      "code": "DM-05",
      "name": "Saint John",
      "type": "Parish"
    },
    {
      "code": "DM-06",
      "name": "Saint Joseph",
      "type": "Parish"
    },
    {
      "code": "DM-07",
      "name": "Saint Luke",
      "type": "Parish"
    },
    {
      "code": "DM-08",
      "name": "Saint Mark",
      "type": "Parish"
    },
    {
      "code": "DM-09",
      "name": "Saint Patrick",
      "type": "Parish"
    },
    {
      "code": "DM-10",
      "name": "Saint Paul",
      "type": "Parish"
    },
    {
      "code": "DM-11",
      "name": "Saint Peter",
      "type": "Parish"
    },
    {
      "code": "DO-01",
      "name": "Distrito Nacional (Santo Domingo)",
      "parent": "40",
      "type": "District"
    },
    {
      "code": "DO-02",
      "name": "Azua",
      "parent": "41",
      "type": "Province"
    },
    {
      "code": "DO-03",
      "name": "Baoruco",
      "parent": "38",
      "type": "Province"
    },
    {
      "code": "DO-04",
      "name": "Barahona",
      "parent": "38",
      "type": "Province"
    },
    {
      "code": "DO-05",
      "name": "Dajabón",
      "parent": "34",
      "type": "Province"
    },
    {
      "code": "DO-06",
      "name": "Duarte",
      "parent": "33",
      "type": "Province"
    },
    {
      "code": "DO-07",
      "name": "Elías Piña",
      "parent": "37",
      "type": "Province"
    },
    {
      "code": "DO-08",
      "name": "El Seibo",
      "parent": "42",
      "type": "Province"
    },
    {
      "code": "DO-09",
      "name": "Espaillat",
      "parent": "35",
      "type": "Province"
    },
    {
      "code": "DO-10",
      "name": "Independencia",
      "parent": "38",
      "type": "Province"
    },
    {
      "code": "DO-11",
      "name": "La Altagracia",
      "parent": "42",
      "type": "Province"
    },
    {
      "code": "DO-12",
      "name": "La Romana",
      "parent": "42",
      "type": "Province"
    },
    {
      "code": "DO-13",
      "name": "La Vega",
      "parent": "36",
      "type": "Province"
    },
    {
      "code": "DO-14",
      "name": "María Trinidad Sánchez",
      "parent": "33",
      "type": "Province"
    },
    {
      "code": "DO-15",
      "name": "Monte Cristi",
      "parent": "34",
      "type": "Province"
    },
    {
      "code": "DO-16",
      "name": "Pedernales",
      "parent": "38",
      "type": "Province"
    },
    {
      "code": "DO-17",
      "name": "Peravia",
      "parent": "41",
      "type": "Province"
    },
    {
      "code": "DO-18",
      "name": "Puerto Plata",
      "parent": "35",
      "type": "Province"
    },
    {
      "code": "DO-19",
      "name": "Hermanas Mirabal",
      "parent": "33",
      "type": "Province"
    },
    {
      "code": "DO-20",
      "name": "Samaná",
      "parent": "33",
      "type": "Province"
    },
    {
      "code": "DO-21",
      "name": "San Cristóbal",
      "parent": "41",
      "type": "Province"
    },
    {
      "code": "DO-22",
      "name": "San Juan",
      "parent": "37",
      "type": "Province"
    },
    {
      "code": "DO-23",
      "name": "San Pedro de Macorís",
      "parent": "39",
      "type": "Province"
    },
    {
      "code": "DO-24",
      "name": "Sánchez Ramírez",
      "parent": "36",
      "type": "Province"
    },
    {
      "code": "DO-25",
      "name": "Santiago",
      "parent": "35",
      "type": "Province"
    },
    {
      "code": "DO-26",
      "name": "Santiago Rodríguez",
      "parent": "34",
      "type": "Province"
    },
    {
      "code": "DO-27",
      "name": "Valverde",
      "parent": "34",
      "type": "Province"
    },
    {
      "code": "DO-28",
      "name": "Monseñor Nouel",
      "parent": "36",
      "type": "Province"
    },
    {
      "code": "DO-29",
      "name": "Monte Plata",
      "parent": "39",
      "type": "Province"
    },
    {
      "code": "DO-30",
      "name": "Hato Mayor",
      "parent": "39",
      "type": "Province"
    },
    {
      "code": "DO-31",
      "name": "San José de Ocoa",
      "parent": "41",
      "type": "Province"
    },
    {
      "code": "DO-32",
      "name": "Santo Domingo",
      "parent": "40",
      "type": "Province"
    },
    {
      "code": "DO-33",
      "name": "Cibao Nordeste",
      "type": "Region"
    },
    {
      "code": "DO-34",
      "name": "Cibao Noroeste",
      "type": "Region"
    },
    {
      "code": "DO-35",
      "name": "Cibao Norte",
      "type": "Region"
    },
    {
      "code": "DO-36",
      "name": "Cibao Sur",
      "type": "Region"
    },
    {
      "code": "DO-37",
      "name": "El Valle",
      "type": "Region"
    },
    {
      "code": "DO-38",
      "name": "Enriquillo",
      "type": "Region"
    },
    {
      "code": "DO-39",
      "name": "Higuamo",
      "type": "Region"
    },
    {
      "code": "DO-40",
      "name": "Ozama",
      "type": "Region"
    },
    {
      "code": "DO-41",
      "name": "Valdesia",
      "type": "Region"
    },
    {
      "code": "DO-42",
      "name": "Yuma",
      "type": "Region"
    },
    {
      "code": "DZ-01",
      "name": "Adrar",
      "type": "Province"
    },
    {
      "code": "DZ-02",
      "name": "Chlef",
      "type": "Province"
    },
    {
      "code": "DZ-03",
      "name": "Laghouat",
      "type": "Province"
    },
    {
      "code": "DZ-04",
      "name": "Oum el Bouaghi",
      "type": "Province"
    },
    {
      "code": "DZ-05",
      "name": "Batna",
      "type": "Province"
    },
    {
      "code": "DZ-06",
      "name": "Béjaïa",
      "type": "Province"
    },
    {
      "code": "DZ-07",
      "name": "Biskra",
      "type": "Province"
    },
    {
      "code": "DZ-08",
      "name": "Béchar",
      "type": "Province"
    },
    {
      "code": "DZ-09",
      "name": "Blida",
      "type": "Province"
    },
    {
      "code": "DZ-10",
      "name": "Bouira",
      "type": "Province"
    },
    {
      "code": "DZ-11",
      "name": "Tamanrasset",
      "type": "Province"
    },
    {
      "code": "DZ-12",
      "name": "Tébessa",
      "type": "Province"
    },
    {
      "code": "DZ-13",
      "name": "Tlemcen",
      "type": "Province"
    },
    {
      "code": "DZ-14",
      "name": "Tiaret",
      "type": "Province"
    },
    {
      "code": "DZ-15",
      "name": "Tizi Ouzou",
      "type": "Province"
    },
    {
      "code": "DZ-16",
      "name": "Alger",
      "type": "Province"
    },
    {
      "code": "DZ-17",
      "name": "Djelfa",
      "type": "Province"
    },
    {
      "code": "DZ-18",
      "name": "Jijel",
      "type": "Province"
    },
    {
      "code": "DZ-19",
      "name": "Sétif",
      "type": "Province"
    },
    {
      "code": "DZ-20",
      "name": "Saïda",
      "type": "Province"
    },
    {
      "code": "DZ-21",
      "name": "Skikda",
      "type": "Province"
    },
    {
      "code": "DZ-22",
      "name": "Sidi Bel Abbès",
      "type": "Province"
    },
    {
      "code": "DZ-23",
      "name": "Annaba",
      "type": "Province"
    },
    {
      "code": "DZ-24",
      "name": "Guelma",
      "type": "Province"
    },
    {
      "code": "DZ-25",
      "name": "Constantine",
      "type": "Province"
    },
    {
      "code": "DZ-26",
      "name": "Médéa",
      "type": "Province"
    },
    {
      "code": "DZ-27",
      "name": "Mostaganem",
      "type": "Province"
    },
    {
      "code": "DZ-28",
      "name": "M'sila",
      "type": "Province"
    },
    {
      "code": "DZ-29",
      "name": "Mascara",
      "type": "Province"
    },
    {
      "code": "DZ-30",
      "name": "Ouargla",
      "type": "Province"
    },
    {
      "code": "DZ-31",
      "name": "Oran",
      "type": "Province"
    },
    {
      "code": "DZ-32",
      "name": "El Bayadh",
      "type": "Province"
    },
    {
      "code": "DZ-33",
      "name": "Illizi",
      "type": "Province"
    },
    {
      "code": "DZ-34",
      "name": "Bordj Bou Arréridj",
      "type": "Province"
    },
    {
      "code": "DZ-35",
      "name": "Boumerdès",
      "type": "Province"
    },
    {
      "code": "DZ-36",
      "name": "El Tarf",
      "type": "Province"
    },
    {
      "code": "DZ-37",
      "name": "Tindouf",
      "type": "Province"
    },
    {
      "code": "DZ-38",
      "name": "Tissemsilt",
      "type": "Province"
    },
    {
      "code": "DZ-39",
      "name": "El Oued",
      "type": "Province"
    },
    {
      "code": "DZ-40",
      "name": "Khenchela",
      "type": "Province"
    },
    {
      "code": "DZ-41",
      "name": "Souk Ahras",
      "type": "Province"
    },
    {
      "code": "DZ-42",
      "name": "Tipaza",
      "type": "Province"
    },
    {
      "code": "DZ-43",
      "name": "Mila",
      "type": "Province"
    },
    {
      "code": "DZ-44",
      "name": "Aïn Defla",
      "type": "Province"
    },
    {
      "code": "DZ-45",
      "name": "Naama",
      "type": "Province"
    },
    {
      "code": "DZ-46",
      "name": "Aïn Témouchent",
      "type": "Province"
    },
    {
      "code": "DZ-47",
      "name": "Ghardaïa",
      "type": "Province"
    },
    {
      "code": "DZ-48",
      "name": "Relizane",
      "type": "Province"
    },
    {
      "code": "EC-A",
      "name": "Azuay",
      "type": "Province"
    },
    {
      "code": "EC-B",
      "name": "Bolívar",
      "type": "Province"
    },
    {
      "code": "EC-C",
      "name": "Carchi",
      "type": "Province"
    },
    {
      "code": "EC-D",
      "name": "Orellana",
      "type": "Province"
    },
    {
      "code": "EC-E",
      "name": "Esmeraldas",
      "type": "Province"
    },
    {
      "code": "EC-F",
      "name": "Cañar",
      "type": "Province"
    },
    {
      "code": "EC-G",
      "name": "Guayas",
      "type": "Province"
    },
    {
      "code": "EC-H",
      "name": "Chimborazo",
      "type": "Province"
    },
    {
      "code": "EC-I",
      "name": "Imbabura",
      "type": "Province"
    },
    {
      "code": "EC-L",
      "name": "Loja",
      "type": "Province"
    },
    {
      "code": "EC-M",
      "name": "Manabí",
      "type": "Province"
    },
    {
      "code": "EC-N",
      "name": "Napo",
      "type": "Province"
    },
    {
      "code": "EC-O",
      "name": "El Oro",
      "type": "Province"
    },
    {
      "code": "EC-P",
      "name": "Pichincha",
      "type": "Province"
    },
    {
      "code": "EC-R",
      "name": "Los Ríos",
      "type": "Province"
    },
    {
      "code": "EC-S",
      "name": "Morona Santiago",
      "type": "Province"
    },
    {
      "code": "EC-SD",
      "name": "Santo Domingo de los Tsáchilas",
      "type": "Province"
    },
    {
      "code": "EC-SE",
      "name": "Santa Elena",
      "type": "Province"
    },
    {
      "code": "EC-T",
      "name": "Tungurahua",
      "type": "Province"
    },
    {
      "code": "EC-U",
      "name": "Sucumbíos",
      "type": "Province"
    },
    {
      "code": "EC-W",
      "name": "Galápagos",
      "type": "Province"
    },
    {
      "code": "EC-X",
      "name": "Cotopaxi",
      "type": "Province"
    },
    {
      "code": "EC-Y",
      "name": "Pastaza",
      "type": "Province"
    },
    {
      "code": "EC-Z",
      "name": "Zamora Chinchipe",
      "type": "Province"
    },
    {
      "code": "EE-130",
      "name": "Alutaguse",
      "parent": "45",
      "type": "Rural municipality"
    },
    {
      "code": "EE-141",
      "name": "Anija",
      "parent": "37",
      "type": "Rural municipality"
    },
    {
      "code": "EE-142",
      "name": "Antsla",
      "parent": "87",
      "type": "Rural municipality"
    },
    {
      "code": "EE-171",
      "name": "Elva",
      "parent": "79",
      "type": "Rural municipality"
    },
    {
      "code": "EE-184",
      "name": "Haapsalu",
      "parent": "56",
      "type": "Urban municipality"
    },
    {
      "code": "EE-191",
      "name": "Haljala",
      "parent": "60",
      "type": "Rural municipality"
    },
    {
      "code": "EE-198",
      "name": "Harku",
      "parent": "37",
      "type": "Rural municipality"
    },
    {
      "code": "EE-205",
      "name": "Hiiumaa",
      "parent": "39",
      "type": "Rural municipality"
    },
    {
      "code": "EE-214",
      "name": "Häädemeeste",
      "parent": "68",
      "type": "Rural municipality"
    },
    {
      "code": "EE-245",
      "name": "Jõelähtme",
      "parent": "37",
      "type": "Rural municipality"
    },
    {
      "code": "EE-247",
      "name": "Jõgeva",
      "parent": "50",
      "type": "Rural municipality"
    },
    {
      "code": "EE-251",
      "name": "Jõhvi",
      "parent": "45",
      "type": "Rural municipality"
    },
    {
      "code": "EE-255",
      "name": "Järva",
      "parent": "52",
      "type": "Rural municipality"
    },
    {
      "code": "EE-272",
      "name": "Kadrina",
      "parent": "60",
      "type": "Rural municipality"
    },
    {
      "code": "EE-283",
      "name": "Kambja",
      "parent": "79",
      "type": "Rural municipality"
    },
    {
      "code": "EE-284",
      "name": "Kanepi",
      "parent": "64",
      "type": "Rural municipality"
    },
    {
      "code": "EE-291",
      "name": "Kastre",
      "parent": "79",
      "type": "Rural municipality"
    },
    {
      "code": "EE-293",
      "name": "Kehtna",
      "parent": "71",
      "type": "Rural municipality"
    },
    {
      "code": "EE-296",
      "name": "Keila",
      "parent": "37",
      "type": "Urban municipality"
    },
    {
      "code": "EE-303",
      "name": "Kihnu",
      "parent": "68",
      "type": "Rural municipality"
    },
    {
      "code": "EE-305",
      "name": "Kiili",
      "parent": "37",
      "type": "Rural municipality"
    },
    {
      "code": "EE-317",
      "name": "Kohila",
      "parent": "71",
      "type": "Rural municipality"
    },
    {
      "code": "EE-321",
      "name": "Kohtla-Järve",
      "parent": "45",
      "type": "Urban municipality"
    },
    {
      "code": "EE-338",
      "name": "Kose",
      "parent": "37",
      "type": "Rural municipality"
    },
    {
      "code": "EE-353",
      "name": "Kuusalu",
      "parent": "37",
      "type": "Rural municipality"
    },
    {
      "code": "EE-37",
      "name": "Harjumaa",
      "type": "County"
    },
    {
      "code": "EE-39",
      "name": "Hiiumaa",
      "type": "County"
    },
    {
      "code": "EE-424",
      "name": "Loksa",
      "parent": "37",
      "type": "Urban municipality"
    },
    {
      "code": "EE-430",
      "name": "Lääneranna",
      "parent": "68",
      "type": "Rural municipality"
    },
    {
      "code": "EE-431",
      "name": "Lääne-Harju",
      "parent": "37",
      "type": "Rural municipality"
    },
    {
      "code": "EE-432",
      "name": "Luunja",
      "parent": "79",
      "type": "Rural municipality"
    },
    {
      "code": "EE-441",
      "name": "Lääne-Nigula",
      "parent": "56",
      "type": "Rural municipality"
    },
    {
      "code": "EE-442",
      "name": "Lüganuse",
      "parent": "45",
      "type": "Rural municipality"
    },
    {
      "code": "EE-446",
      "name": "Maardu",
      "parent": "37",
      "type": "Urban municipality"
    },
    {
      "code": "EE-45",
      "name": "Ida-Virumaa",
      "type": "County"
    },
    {
      "code": "EE-478",
      "name": "Muhu",
      "parent": "74",
      "type": "Rural municipality"
    },
    {
      "code": "EE-480",
      "name": "Mulgi",
      "parent": "84",
      "type": "Rural municipality"
    },
    {
      "code": "EE-486",
      "name": "Mustvee",
      "parent": "50",
      "type": "Rural municipality"
    },
    {
      "code": "EE-50",
      "name": "Jõgevamaa",
      "type": "County"
    },
    {
      "code": "EE-503",
      "name": "Märjamaa",
      "parent": "71",
      "type": "Rural municipality"
    },
    {
      "code": "EE-511",
      "name": "Narva",
      "parent": "45",
      "type": "Urban municipality"
    },
    {
      "code": "EE-514",
      "name": "Narva-Jõesuu",
      "parent": "45",
      "type": "Urban municipality"
    },
    {
      "code": "EE-52",
      "name": "Järvamaa",
      "type": "County"
    },
    {
      "code": "EE-528",
      "name": "Nõo",
      "parent": "79",
      "type": "Rural municipality"
    },
    {
      "code": "EE-557",
      "name": "Otepää",
      "parent": "81",
      "type": "Rural municipality"
    },
    {
      "code": "EE-56",
      "name": "Läänemaa",
      "type": "County"
    },
    {
      "code": "EE-567",
      "name": "Paide",
      "parent": "52",
      "type": "Urban municipality"
    },
    {
      "code": "EE-586",
      "name": "Peipsiääre",
      "parent": "79",
      "type": "Rural municipality"
    },
    {
      "code": "EE-60",
      "name": "Lääne-Virumaa",
      "type": "County"
    },
    {
      "code": "EE-615",
      "name": "Põhja-Sakala",
      "parent": "84",
      "type": "Rural municipality"
    },
    {
      "code": "EE-618",
      "name": "Põltsamaa",
      "parent": "50",
      "type": "Rural municipality"
    },
    {
      "code": "EE-622",
      "name": "Põlva",
      "parent": "64",
      "type": "Rural municipality"
    },
    {
      "code": "EE-624",
      "name": "Pärnu",
      "parent": "68",
      "type": "Urban municipality"
    },
    {
      "code": "EE-638",
      "name": "Põhja-Pärnumaa",
      "parent": "68",
      "type": "Rural municipality"
    },
    {
      "code": "EE-64",
      "name": "Põlvamaa",
      "type": "County"
    },
    {
      "code": "EE-651",
      "name": "Raasiku",
      "parent": "37",
      "type": "Rural municipality"
    },
    {
      "code": "EE-653",
      "name": "Rae",
      "parent": "37",
      "type": "Rural municipality"
    },
    {
      "code": "EE-661",
      "name": "Rakvere",
      "parent": "60",
      "type": "Rural municipality"
    },
    {
      "code": "EE-663",
      "name": "Rakvere",
      "parent": "60",
      "type": "Urban municipality"
    },
    {
      "code": "EE-668",
      "name": "Rapla",
      "parent": "71",
      "type": "Rural municipality"
    },
    {
      "code": "EE-68",
      "name": "Pärnumaa",
      "type": "County"
    },
    {
      "code": "EE-689",
      "name": "Ruhnu",
      "parent": "74",
      "type": "Rural municipality"
    },
    {
      "code": "EE-698",
      "name": "Rõuge",
      "parent": "87",
      "type": "Rural municipality"
    },
    {
      "code": "EE-708",
      "name": "Räpina",
      "parent": "64",
      "type": "Rural municipality"
    },
    {
      "code": "EE-71",
      "name": "Raplamaa",
      "type": "County"
    },
    {
      "code": "EE-712",
      "name": "Saarde",
      "parent": "68",
      "type": "Rural municipality"
    },
    {
      "code": "EE-714",
      "name": "Saaremaa",
      "parent": "74",
      "type": "Rural municipality"
    },
    {
      "code": "EE-719",
      "name": "Saku",
      "parent": "37",
      "type": "Rural municipality"
    },
    {
      "code": "EE-726",
      "name": "Saue",
      "parent": "37",
      "type": "Rural municipality"
    },
    {
      "code": "EE-732",
      "name": "Setomaa",
      "parent": "87",
      "type": "Rural municipality"
    },
    {
      "code": "EE-735",
      "name": "Sillamäe",
      "parent": "45",
      "type": "Urban municipality"
    },
    {
      "code": "EE-74",
      "name": "Saaremaa",
      "type": "County"
    },
    {
      "code": "EE-784",
      "name": "Tallinn",
      "parent": "37",
      "type": "Urban municipality"
    },
    {
      "code": "EE-79",
      "name": "Tartumaa",
      "type": "County"
    },
    {
      "code": "EE-792",
      "name": "Tapa",
      "parent": "60",
      "type": "Rural municipality"
    },
    {
      "code": "EE-793",
      "name": "Tartu",
      "parent": "79",
      "type": "Urban municipality"
    },
    {
      "code": "EE-796",
      "name": "Tartu",
      "parent": "79",
      "type": "Rural municipality"
    },
    {
      "code": "EE-803",
      "name": "Toila",
      "parent": "45",
      "type": "Rural municipality"
    },
    {
      "code": "EE-809",
      "name": "Tori",
      "parent": "68",
      "type": "Rural municipality"
    },
    {
      "code": "EE-81",
      "name": "Valgamaa",
      "type": "County"
    },
    {
      "code": "EE-824",
      "name": "Tõrva",
      "parent": "81",
      "type": "Rural municipality"
    },
    {
      "code": "EE-834",
      "name": "Türi",
      "parent": "52",
      "type": "Rural municipality"
    },
    {
      "code": "EE-84",
      "name": "Viljandimaa",
      "type": "County"
    },
    {
      "code": "EE-855",
      "name": "Valga",
      "parent": "81",
      "type": "Rural municipality"
    },
    {
      "code": "EE-87",
      "name": "Võrumaa",
      "type": "County"
    },
    {
      "code": "EE-890",
      "name": "Viimsi",
      "parent": "37",
      "type": "Rural municipality"
    },
    {
      "code": "EE-897",
      "name": "Viljandi",
      "parent": "84",
      "type": "Urban municipality"
    },
    {
      "code": "EE-899",
      "name": "Viljandi",
      "parent": "84",
      "type": "Rural municipality"
    },
    {
      "code": "EE-901",
      "name": "Vinni",
      "parent": "60",
      "type": "Rural municipality"
    },
    {
      "code": "EE-903",
      "name": "Viru-Nigula",
      "parent": "60",
      "type": "Rural municipality"
    },
    {
      "code": "EE-907",
      "name": "Vormsi",
      "parent": "56",
      "type": "Rural municipality"
    },
    {
      "code": "EE-917",
      "name": "Võru",
      "parent": "87",
      "type": "Rural municipality"
    },
    {
      "code": "EE-919",
      "name": "Võru",
      "parent": "87",
      "type": "Urban municipality"
    },
    {
      "code": "EE-928",
      "name": "Väike-Maarja",
      "parent": "60",
      "type": "Rural municipality"
    },
    {
      "code": "EG-ALX",
      "name": "Al Iskandarīyah",
      "type": "Governorate"
    },
    {
      "code": "EG-ASN",
      "name": "Aswān",
      "type": "Governorate"
    },
    {
      "code": "EG-AST",
      "name": "Asyūţ",
      "type": "Governorate"
    },
    {
      "code": "EG-BA",
      "name": "Al Baḩr al Aḩmar",
      "type": "Governorate"
    },
    {
      "code": "EG-BH",
      "name": "Al Buḩayrah",
      "type": "Governorate"
    },
    {
      "code": "EG-BNS",
      "name": "Banī Suwayf",
      "type": "Governorate"
    },
    {
      "code": "EG-C",
      "name": "Al Qāhirah",
      "type": "Governorate"
    },
    {
      "code": "EG-DK",
      "name": "Ad Daqahlīyah",
      "type": "Governorate"
    },
    {
      "code": "EG-DT",
      "name": "Dumyāţ",
      "type": "Governorate"
    },
    {
      "code": "EG-FYM",
      "name": "Al Fayyūm",
      "type": "Governorate"
    },
    {
      "code": "EG-GH",
      "name": "Al Gharbīyah",
      "type": "Governorate"
    },
    {
      "code": "EG-GZ",
      "name": "Al Jīzah",
      "type": "Governorate"
    },
    {
      "code": "EG-IS",
      "name": "Al Ismā'īlīyah",
      "type": "Governorate"
    },
    {
      "code": "EG-JS",
      "name": "Janūb Sīnā'",
      "type": "Governorate"
    },
    {
      "code": "EG-KB",
      "name": "Al Qalyūbīyah",
      "type": "Governorate"
    },
    {
      "code": "EG-KFS",
      "name": "Kafr ash Shaykh",
      "type": "Governorate"
    },
    {
      "code": "EG-KN",
      "name": "Qinā",
      "type": "Governorate"
    },
    {
      "code": "EG-LX",
      "name": "Al Uqşur",
      "type": "Governorate"
    },
    {
      "code": "EG-MN",
      "name": "Al Minyā",
      "type": "Governorate"
    },
    {
      "code": "EG-MNF",
      "name": "Al Minūfīyah",
      "type": "Governorate"
    },
    {
      "code": "EG-MT",
      "name": "Maţrūḩ",
      "type": "Governorate"
    },
    {
      "code": "EG-PTS",
      "name": "Būr Sa‘īd",
      "type": "Governorate"
    },
    {
      "code": "EG-SHG",
      "name": "Sūhāj",
      "type": "Governorate"
    },
    {
      "code": "EG-SHR",
      "name": "Ash Sharqīyah",
      "type": "Governorate"
    },
    {
      "code": "EG-SIN",
      "name": "Shamāl Sīnā'",
      "type": "Governorate"
    },
    {
      "code": "EG-SUZ",
      "name": "As Suways",
      "type": "Governorate"
    },
    {
      "code": "EG-WAD",
      "name": "Al Wādī al Jadīd",
      "type": "Governorate"
    },
    {
      "code": "ER-AN",
      "name": "Ansabā",
      "type": "Region"
    },
    {
      "code": "ER-DK",
      "name": "Debubawi K’eyyĭḥ Baḥri",
      "type": "Region"
    },
    {
      "code": "ER-DU",
      "name": "Al Janūbī",
      "type": "Region"
    },
    {
      "code": "ER-GB",
      "name": "Gash-Barka",
      "type": "Region"
    },
    {
      "code": "ER-MA",
      "name": "Al Awsaţ",
      "type": "Region"
    },
    {
      "code": "ER-SK",
      "name": "Semienawi K’eyyĭḥ Baḥri",
      "type": "Region"
    },
    {
      "code": "ES-A",
      "name": "Alacant*",
      "parent": "VC",
      "type": "Province"
    },
    {
      "code": "ES-AB",
      "name": "Albacete",
      "parent": "CM",
      "type": "Province"
    },
    {
      "code": "ES-AL",
      "name": "Almería",
      "parent": "AN",
      "type": "Province"
    },
    {
      "code": "ES-AN",
      "name": "Andalucía",
      "type": "Autonomous community"
    },
    {
      "code": "ES-AR",
      "name": "Aragón",
      "type": "Autonomous community"
    },
    {
      "code": "ES-AS",
      "name": "Asturias, Principado de",
      "type": "Autonomous community"
    },
    {
      "code": "ES-AV",
      "name": "Ávila",
      "parent": "CL",
      "type": "Province"
    },
    {
      "code": "ES-B",
      "name": "Barcelona [Barcelona]",
      "parent": "CT",
      "type": "Province"
    },
    {
      "code": "ES-BA",
      "name": "Badajoz",
      "parent": "EX",
      "type": "Province"
    },
    {
      "code": "ES-BI",
      "name": "Bizkaia",
      "parent": "PV",
      "type": "Province"
    },
    {
      "code": "ES-BU",
      "name": "Burgos",
      "parent": "CL",
      "type": "Province"
    },
    {
      "code": "ES-C",
      "name": "A Coruña [La Coruña]",
      "parent": "GA",
      "type": "Province"
    },
    {
      "code": "ES-CA",
      "name": "Cádiz",
      "parent": "AN",
      "type": "Province"
    },
    {
      "code": "ES-CB",
      "name": "Cantabria",
      "type": "Autonomous community"
    },
    {
      "code": "ES-CC",
      "name": "Cáceres",
      "parent": "EX",
      "type": "Province"
    },
    {
      "code": "ES-CE",
      "name": "Ceuta",
      "type": "Autonomous city in north africa"
    },
    {
      "code": "ES-CL",
      "name": "Castilla y León",
      "type": "Autonomous community"
    },
    {
      "code": "ES-CM",
      "name": "Castilla-La Mancha",
      "type": "Autonomous community"
    },
    {
      "code": "ES-CN",
      "name": "Canarias",
      "type": "Autonomous community"
    },
    {
      "code": "ES-CO",
      "name": "Córdoba",
      "parent": "AN",
      "type": "Province"
    },
    {
      "code": "ES-CR",
      "name": "Ciudad Real",
      "parent": "CM",
      "type": "Province"
    },
    {
      "code": "ES-CS",
      "name": "Castelló*",
      "parent": "VC",
      "type": "Province"
    },
    {
      "code": "ES-CT",
      "name": "Catalunya [Cataluña]",
      "type": "Autonomous community"
    },
    {
      "code": "ES-CU",
      "name": "Cuenca",
      "parent": "CM",
      "type": "Province"
    },
    {
      "code": "ES-EX",
      "name": "Extremadura",
      "type": "Autonomous community"
    },
    {
      "code": "ES-GA",
      "name": "Galicia [Galicia]",
      "type": "Autonomous community"
    },
    {
      "code": "ES-GC",
      "name": "Las Palmas",
      "parent": "CN",
      "type": "Province"
    },
    {
      "code": "ES-GI",
      "name": "Girona [Gerona]",
      "parent": "CT",
      "type": "Province"
    },
    {
      "code": "ES-GR",
      "name": "Granada",
      "parent": "AN",
      "type": "Province"
    },
    {
      "code": "ES-GU",
      "name": "Guadalajara",
      "parent": "CM",
      "type": "Province"
    },
    {
      "code": "ES-H",
      "name": "Huelva",
      "parent": "AN",
      "type": "Province"
    },
    {
      "code": "ES-HU",
      "name": "Huesca",
      "parent": "AR",
      "type": "Province"
    },
    {
      "code": "ES-IB",
      "name": "Illes Balears [Islas Baleares]",
      "type": "Autonomous community"
    },
    {
      "code": "ES-J",
      "name": "Jaén",
      "parent": "AN",
      "type": "Province"
    },
    {
      "code": "ES-L",
      "name": "Lleida [Lérida]",
      "parent": "CT",
      "type": "Province"
    },
    {
      "code": "ES-LE",
      "name": "León",
      "parent": "CL",
      "type": "Province"
    },
    {
      "code": "ES-LO",
      "name": "La Rioja",
      "parent": "RI",
      "type": "Province"
    },
    {
      "code": "ES-LU",
      "name": "Lugo [Lugo]",
      "parent": "GA",
      "type": "Province"
    },
    {
      "code": "ES-M",
      "name": "Madrid",
      "parent": "MD",
      "type": "Province"
    },
    {
      "code": "ES-MA",
      "name": "Málaga",
      "parent": "AN",
      "type": "Province"
    },
    {
      "code": "ES-MC",
      "name": "Murcia, Región de",
      "type": "Autonomous community"
    },
    {
      "code": "ES-MD",
      "name": "Madrid, Comunidad de",
      "type": "Autonomous community"
    },
    {
      "code": "ES-ML",
      "name": "Melilla",
      "type": "Autonomous city in north africa"
    },
    {
      "code": "ES-MU",
      "name": "Murcia",
      "parent": "MC",
      "type": "Province"
    },
    {
      "code": "ES-NA",
      "name": "Nafarroa*",
      "parent": "NC",
      "type": "Province"
    },
    {
      "code": "ES-NC",
      "name": "Nafarroako Foru Komunitatea*",
      "type": "Autonomous community"
    },
    {
      "code": "ES-O",
      "name": "Asturias",
      "parent": "AS",
      "type": "Province"
    },
    {
      "code": "ES-OR",
      "name": "Ourense [Orense]",
      "parent": "GA",
      "type": "Province"
    },
    {
      "code": "ES-P",
      "name": "Palencia",
      "parent": "CL",
      "type": "Province"
    },
    {
      "code": "ES-PM",
      "name": "Illes Balears [Islas Baleares]",
      "parent": "IB",
      "type": "Province"
    },
    {
      "code": "ES-PO",
      "name": "Pontevedra [Pontevedra]",
      "parent": "GA",
      "type": "Province"
    },
    {
      "code": "ES-PV",
      "name": "Euskal Herria",
      "type": "Autonomous community"
    },
    {
      "code": "ES-RI",
      "name": "La Rioja",
      "type": "Autonomous community"
    },
    {
      "code": "ES-S",
      "name": "Cantabria",
      "parent": "CB",
      "type": "Province"
    },
    {
      "code": "ES-SA",
      "name": "Salamanca",
      "parent": "CL",
      "type": "Province"
    },
    {
      "code": "ES-SE",
      "name": "Sevilla",
      "parent": "AN",
      "type": "Province"
    },
    {
      "code": "ES-SG",
      "name": "Segovia",
      "parent": "CL",
      "type": "Province"
    },
    {
      "code": "ES-SO",
      "name": "Soria",
      "parent": "CL",
      "type": "Province"
    },
    {
      "code": "ES-SS",
      "name": "Gipuzkoa",
      "parent": "PV",
      "type": "Province"
    },
    {
      "code": "ES-T",
      "name": "Tarragona [Tarragona]",
      "parent": "CT",
      "type": "Province"
    },
    {
      "code": "ES-TE",
      "name": "Teruel",
      "parent": "AR",
      "type": "Province"
    },
    {
      "code": "ES-TF",
      "name": "Santa Cruz de Tenerife",
      "parent": "CN",
      "type": "Province"
    },
    {
      "code": "ES-TO",
      "name": "Toledo",
      "parent": "CM",
      "type": "Province"
    },
    {
      "code": "ES-V",
      "name": "Valencia",
      "parent": "VC",
      "type": "Province"
    },
    {
      "code": "ES-VA",
      "name": "Valladolid",
      "parent": "CL",
      "type": "Province"
    },
    {
      "code": "ES-VC",
      "name": "Valenciana, Comunidad",
      "type": "Autonomous community"
    },
    {
      "code": "ES-VI",
      "name": "Araba*",
      "parent": "PV",
      "type": "Province"
    },
    {
      "code": "ES-Z",
      "name": "Zaragoza",
      "parent": "AR",
      "type": "Province"
    },
    {
      "code": "ES-ZA",
      "name": "Zamora",
      "parent": "CL",
      "type": "Province"
    },
    {
      "code": "ET-AA",
      "name": "Addis Ababa",
      "type": "Administration"
    },
    {
      "code": "ET-AF",
      "name": "Afar",
      "type": "Regional state"
    },
    {
      "code": "ET-AM",
      "name": "Amara",
      "type": "Regional state"
    },
    {
      "code": "ET-BE",
      "name": "Benshangul-Gumaz",
      "type": "Regional state"
    },
    {
      "code": "ET-DD",
      "name": "Dire Dawa",
      "type": "Administration"
    },
    {
      "code": "ET-GA",
      "name": "Gambela Peoples",
      "type": "Regional state"
    },
    {
      "code": "ET-HA",
      "name": "Harari People",
      "type": "Regional state"
    },
    {
      "code": "ET-OR",
      "name": "Oromia",
      "type": "Regional state"
    },
    {
      "code": "ET-SN",
      "name": "Southern Nations, Nationalities and Peoples",
      "type": "Regional state"
    },
    {
      "code": "ET-SO",
      "name": "Somali",
      "type": "Regional state"
    },
    {
      "code": "ET-TI",
      "name": "Tigrai",
      "type": "Regional state"
    },
    {
      "code": "FI-01",
      "name": "Ahvenanmaan maakunta",
      "type": "Region"
    },
    {
      "code": "FI-02",
      "name": "Etelä-Karjala",
      "type": "Region"
    },
    {
      "code": "FI-03",
      "name": "Etelä-Pohjanmaa",
      "type": "Region"
    },
    {
      "code": "FI-04",
      "name": "Etelä-Savo",
      "type": "Region"
    },
    {
      "code": "FI-05",
      "name": "Kainuu",
      "type": "Region"
    },
    {
      "code": "FI-06",
      "name": "Egentliga Tavastland",
      "type": "Region"
    },
    {
      "code": "FI-07",
      "name": "Keski-Pohjanmaa",
      "type": "Region"
    },
    {
      "code": "FI-08",
      "name": "Keski-Suomi",
      "type": "Region"
    },
    {
      "code": "FI-09",
      "name": "Kymenlaakso",
      "type": "Region"
    },
    {
      "code": "FI-10",
      "name": "Lappi",
      "type": "Region"
    },
    {
      "code": "FI-11",
      "name": "Birkaland",
      "type": "Region"
    },
    {
      "code": "FI-12",
      "name": "Pohjanmaa",
      "type": "Region"
    },
    {
      "code": "FI-13",
      "name": "Norra Karelen",
      "type": "Region"
    },
    {
      "code": "FI-14",
      "name": "Norra Österbotten",
      "type": "Region"
    },
    {
      "code": "FI-15",
      "name": "Norra Savolax",
      "type": "Region"
    },
    {
      "code": "FI-16",
      "name": "Päijänne-Tavastland",
      "type": "Region"
    },
    {
      "code": "FI-17",
      "name": "Satakunda",
      "type": "Region"
    },
    {
      "code": "FI-18",
      "name": "Nyland",
      "type": "Region"
    },
    {
      "code": "FI-19",
      "name": "Egentliga Finland",
      "type": "Region"
    },
    {
      "code": "FJ-01",
      "name": "Ba",
      "parent": "W",
      "type": "Province"
    },
    {
      "code": "FJ-02",
      "name": "Bua",
      "parent": "N",
      "type": "Province"
    },
    {
      "code": "FJ-03",
      "name": "Cakaudrove",
      "parent": "N",
      "type": "Province"
    },
    {
      "code": "FJ-04",
      "name": "Kadavu",
      "parent": "E",
      "type": "Province"
    },
    {
      "code": "FJ-05",
      "name": "Lau",
      "parent": "E",
      "type": "Province"
    },
    {
      "code": "FJ-06",
      "name": "Lomaiviti",
      "parent": "E",
      "type": "Province"
    },
    {
      "code": "FJ-07",
      "name": "Macuata",
      "parent": "N",
      "type": "Province"
    },
    {
      "code": "FJ-08",
      "name": "Nadroga and Navosa",
      "parent": "W",
      "type": "Province"
    },
    {
      "code": "FJ-09",
      "name": "Naitasiri",
      "parent": "C",
      "type": "Province"
    },
    {
      "code": "FJ-10",
      "name": "Namosi",
      "parent": "C",
      "type": "Province"
    },
    {
      "code": "FJ-11",
      "name": "Ra",
      "parent": "W",
      "type": "Province"
    },
    {
      "code": "FJ-12",
      "name": "Rewa",
      "parent": "C",
      "type": "Province"
    },
    {
      "code": "FJ-13",
      "name": "Serua",
      "parent": "C",
      "type": "Province"
    },
    {
      "code": "FJ-14",
      "name": "Tailevu",
      "parent": "C",
      "type": "Province"
    },
    {
      "code": "FJ-C",
      "name": "Central",
      "type": "Division"
    },
    {
      "code": "FJ-E",
      "name": "Eastern",
      "type": "Division"
    },
    {
      "code": "FJ-N",
      "name": "Northern",
      "type": "Division"
    },
    {
      "code": "FJ-R",
      "name": "Rotuma",
      "type": "Dependency"
    },
    {
      "code": "FJ-W",
      "name": "Western",
      "type": "Division"
    },
    {
      "code": "FM-KSA",
      "name": "Kosrae",
      "type": "State"
    },
    {
      "code": "FM-PNI",
      "name": "Pohnpei",
      "type": "State"
    },
    {
      "code": "FM-TRK",
      "name": "Chuuk",
      "type": "State"
    },
    {
      "code": "FM-YAP",
      "name": "Yap",
      "type": "State"
    },
    {
      "code": "FR-01",
      "name": "Ain",
      "parent": "ARA",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-02",
      "name": "Aisne",
      "parent": "HDF",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-03",
      "name": "Allier",
      "parent": "ARA",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-04",
      "name": "Alpes-de-Haute-Provence",
      "parent": "PAC",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-05",
      "name": "Hautes-Alpes",
      "parent": "PAC",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-06",
      "name": "Alpes-Maritimes",
      "parent": "PAC",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-07",
      "name": "Ardèche",
      "parent": "ARA",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-08",
      "name": "Ardennes",
      "parent": "GES",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-09",
      "name": "Ariège",
      "parent": "OCC",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-10",
      "name": "Aube",
      "parent": "GES",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-11",
      "name": "Aude",
      "parent": "OCC",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-12",
      "name": "Aveyron",
      "parent": "OCC",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-13",
      "name": "Bouches-du-Rhône",
      "parent": "PAC",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-14",
      "name": "Calvados",
      "parent": "NOR",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-15",
      "name": "Cantal",
      "parent": "ARA",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-16",
      "name": "Charente",
      "parent": "NAQ",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-17",
      "name": "Charente-Maritime",
      "parent": "NAQ",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-18",
      "name": "Cher",
      "parent": "CVL",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-19",
      "name": "Corrèze",
      "parent": "NAQ",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-20R",
      "name": "Corse",
      "type": "Metropolitan collectivity with special status"
    },
    {
      "code": "FR-21",
      "name": "Côte-d'Or",
      "parent": "BFC",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-22",
      "name": "Côtes-d'Armor",
      "parent": "BRE",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-23",
      "name": "Creuse",
      "parent": "NAQ",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-24",
      "name": "Dordogne",
      "parent": "NAQ",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-25",
      "name": "Doubs",
      "parent": "BFC",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-26",
      "name": "Drôme",
      "parent": "ARA",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-27",
      "name": "Eure",
      "parent": "NOR",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-28",
      "name": "Eure-et-Loir",
      "parent": "CVL",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-29",
      "name": "Finistère",
      "parent": "BRE",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-2A",
      "name": "Corse-du-Sud",
      "parent": "20R",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-2B",
      "name": "Haute-Corse",
      "parent": "20R",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-30",
      "name": "Gard",
      "parent": "OCC",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-31",
      "name": "Haute-Garonne",
      "parent": "OCC",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-32",
      "name": "Gers",
      "parent": "OCC",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-33",
      "name": "Gironde",
      "parent": "NAQ",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-34",
      "name": "Hérault",
      "parent": "OCC",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-35",
      "name": "Ille-et-Vilaine",
      "parent": "BRE",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-36",
      "name": "Indre",
      "parent": "CVL",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-37",
      "name": "Indre-et-Loire",
      "parent": "CVL",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-38",
      "name": "Isère",
      "parent": "ARA",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-39",
      "name": "Jura",
      "parent": "BFC",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-40",
      "name": "Landes",
      "parent": "NAQ",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-41",
      "name": "Loir-et-Cher",
      "parent": "CVL",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-42",
      "name": "Loire",
      "parent": "ARA",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-43",
      "name": "Haute-Loire",
      "parent": "ARA",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-44",
      "name": "Loire-Atlantique",
      "parent": "PDL",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-45",
      "name": "Loiret",
      "parent": "CVL",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-46",
      "name": "Lot",
      "parent": "OCC",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-47",
      "name": "Lot-et-Garonne",
      "parent": "NAQ",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-48",
      "name": "Lozère",
      "parent": "OCC",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-49",
      "name": "Maine-et-Loire",
      "parent": "PDL",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-50",
      "name": "Manche",
      "parent": "NOR",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-51",
      "name": "Marne",
      "parent": "GES",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-52",
      "name": "Haute-Marne",
      "parent": "GES",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-53",
      "name": "Mayenne",
      "parent": "PDL",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-54",
      "name": "Meurthe-et-Moselle",
      "parent": "GES",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-55",
      "name": "Meuse",
      "parent": "GES",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-56",
      "name": "Morbihan",
      "parent": "BRE",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-57",
      "name": "Moselle",
      "parent": "GES",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-58",
      "name": "Nièvre",
      "parent": "BFC",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-59",
      "name": "Nord",
      "parent": "HDF",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-60",
      "name": "Oise",
      "parent": "HDF",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-61",
      "name": "Orne",
      "parent": "NOR",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-62",
      "name": "Pas-de-Calais",
      "parent": "HDF",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-63",
      "name": "Puy-de-Dôme",
      "parent": "ARA",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-64",
      "name": "Pyrénées-Atlantiques",
      "parent": "NAQ",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-65",
      "name": "Hautes-Pyrénées",
      "parent": "OCC",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-66",
      "name": "Pyrénées-Orientales",
      "parent": "OCC",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-67",
      "name": "Bas-Rhin",
      "parent": "GES",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-68",
      "name": "Haut-Rhin",
      "parent": "GES",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-69",
      "name": "Rhône",
      "parent": "ARA",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-70",
      "name": "Haute-Saône",
      "parent": "BFC",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-71",
      "name": "Saône-et-Loire",
      "parent": "BFC",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-72",
      "name": "Sarthe",
      "parent": "PDL",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-73",
      "name": "Savoie",
      "parent": "ARA",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-74",
      "name": "Haute-Savoie",
      "parent": "ARA",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-75",
      "name": "Paris",
      "parent": "IDF",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-76",
      "name": "Seine-Maritime",
      "parent": "NOR",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-77",
      "name": "Seine-et-Marne",
      "parent": "IDF",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-78",
      "name": "Yvelines",
      "parent": "IDF",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-79",
      "name": "Deux-Sèvres",
      "parent": "NAQ",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-80",
      "name": "Somme",
      "parent": "HDF",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-81",
      "name": "Tarn",
      "parent": "OCC",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-82",
      "name": "Tarn-et-Garonne",
      "parent": "OCC",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-83",
      "name": "Var",
      "parent": "PAC",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-84",
      "name": "Vaucluse",
      "parent": "PAC",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-85",
      "name": "Vendée",
      "parent": "PDL",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-86",
      "name": "Vienne",
      "parent": "NAQ",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-87",
      "name": "Haute-Vienne",
      "parent": "NAQ",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-88",
      "name": "Vosges",
      "parent": "GES",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-89",
      "name": "Yonne",
      "parent": "BFC",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-90",
      "name": "Territoire de Belfort",
      "parent": "BFC",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-91",
      "name": "Essonne",
      "parent": "IDF",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-92",
      "name": "Hauts-de-Seine",
      "parent": "IDF",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-93",
      "name": "Seine-Saint-Denis",
      "parent": "IDF",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-94",
      "name": "Val-de-Marne",
      "parent": "IDF",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-95",
      "name": "Val-d'Oise",
      "parent": "IDF",
      "type": "Metropolitan department"
    },
    {
      "code": "FR-971",
      "name": "Guadeloupe",
      "parent": "GP",
      "type": "Overseas department"
    },
    {
      "code": "FR-972",
      "name": "Martinique",
      "parent": "MQ",
      "type": "Overseas department"
    },
    {
      "code": "FR-973",
      "name": "Guyane (française)",
      "parent": "GF",
      "type": "Overseas department"
    },
    {
      "code": "FR-974",
      "name": "La Réunion",
      "parent": "RE",
      "type": "Overseas department"
    },
    {
      "code": "FR-976",
      "name": "Mayotte",
      "parent": "YT",
      "type": "Overseas department"
    },
    {
      "code": "FR-ARA",
      "name": "Auvergne-Rhône-Alpes",
      "type": "Metropolitan region"
    },
    {
      "code": "FR-BFC",
      "name": "Bourgogne-Franche-Comté",
      "type": "Metropolitan region"
    },
    {
      "code": "FR-BL",
      "name": "Saint-Barthélemy",
      "type": "Overseas collectivity"
    },
    {
      "code": "FR-BRE",
      "name": "Bretagne",
      "type": "Metropolitan region"
    },
    {
      "code": "FR-CP",
      "name": "Clipperton",
      "type": "Dependency"
    },
    {
      "code": "FR-CVL",
      "name": "Centre-Val de Loire",
      "type": "Metropolitan region"
    },
    {
      "code": "FR-GES",
      "name": "Grand-Est",
      "type": "Metropolitan region"
    },
    {
      "code": "FR-GF",
      "name": "Guyane (française)",
      "type": "Overseas region"
    },
    {
      "code": "FR-GP",
      "name": "Guadeloupe",
      "type": "Overseas region"
    },
    {
      "code": "FR-HDF",
      "name": "Hauts-de-France",
      "type": "Metropolitan region"
    },
    {
      "code": "FR-IDF",
      "name": "Île-de-France",
      "type": "Metropolitan region"
    },
    {
      "code": "FR-MF",
      "name": "Saint-Martin",
      "type": "Overseas collectivity"
    },
    {
      "code": "FR-MQ",
      "name": "Martinique",
      "type": "Overseas region"
    },
    {
      "code": "FR-NAQ",
      "name": "Nouvelle-Aquitaine",
      "type": "Metropolitan region"
    },
    {
      "code": "FR-NC",
      "name": "Nouvelle-Calédonie",
      "type": "Overseas collectivity with special status"
    },
    {
      "code": "FR-NOR",
      "name": "Normandie",
      "type": "Metropolitan region"
    },
    {
      "code": "FR-OCC",
      "name": "Occitanie",
      "type": "Metropolitan region"
    },
    {
      "code": "FR-PAC",
      "name": "Provence-Alpes-Côte-d’Azur",
      "type": "Metropolitan region"
    },
    {
      "code": "FR-PDL",
      "name": "Pays-de-la-Loire",
      "type": "Metropolitan region"
    },
    {
      "code": "FR-PF",
      "name": "Polynésie française",
      "type": "Overseas collectivity"
    },
    {
      "code": "FR-PM",
      "name": "Saint-Pierre-et-Miquelon",
      "type": "Overseas collectivity"
    },
    {
      "code": "FR-RE",
      "name": "La Réunion",
      "type": "Overseas region"
    },
    {
      "code": "FR-TF",
      "name": "Terres australes françaises",
      "type": "Overseas territory"
    },
    {
      "code": "FR-WF",
      "name": "Wallis-et-Futuna",
      "type": "Overseas collectivity"
    },
    {
      "code": "FR-YT",
      "name": "Mayotte",
      "type": "Overseas region"
    },
    {
      "code": "GA-1",
      "name": "Estuaire",
      "type": "Province"
    },
    {
      "code": "GA-2",
      "name": "Haut-Ogooué",
      "type": "Province"
    },
    {
      "code": "GA-3",
      "name": "Moyen-Ogooué",
      "type": "Province"
    },
    {
      "code": "GA-4",
      "name": "Ngounié",
      "type": "Province"
    },
    {
      "code": "GA-5",
      "name": "Nyanga",
      "type": "Province"
    },
    {
      "code": "GA-6",
      "name": "Ogooué-Ivindo",
      "type": "Province"
    },
    {
      "code": "GA-7",
      "name": "Ogooué-Lolo",
      "type": "Province"
    },
    {
      "code": "GA-8",
      "name": "Ogooué-Maritime",
      "type": "Province"
    },
    {
      "code": "GA-9",
      "name": "Woleu-Ntem",
      "type": "Province"
    },
    {
      "code": "GB-ABC",
      "name": "Armagh City, Banbridge and Craigavon",
      "type": "District"
    },
    {
      "code": "GB-ABD",
      "name": "Aberdeenshire",
      "type": "Council area"
    },
    {
      "code": "GB-ABE",
      "name": "Aberdeen City",
      "type": "Council area"
    },
    {
      "code": "GB-AGB",
      "name": "Argyll and Bute",
      "type": "Council area"
    },
    {
      "code": "GB-AGY",
      "name": "Isle of Anglesey [Sir Ynys Môn GB-YNM]",
      "type": "Unitary authority"
    },
    {
      "code": "GB-AND",
      "name": "Ards and North Down",
      "type": "District"
    },
    {
      "code": "GB-ANN",
      "name": "Antrim and Newtownabbey",
      "type": "District"
    },
    {
      "code": "GB-ANS",
      "name": "Angus",
      "type": "Council area"
    },
    {
      "code": "GB-BAS",
      "name": "Bath and North East Somerset",
      "type": "Unitary authority"
    },
    {
      "code": "GB-BBD",
      "name": "Blackburn with Darwen",
      "type": "Unitary authority"
    },
    {
      "code": "GB-BCP",
      "name": "Bournemouth, Christchurch and Poole",
      "type": "Unitary authority"
    },
    {
      "code": "GB-BDF",
      "name": "Bedford",
      "type": "Unitary authority"
    },
    {
      "code": "GB-BDG",
      "name": "Barking and Dagenham",
      "type": "London borough"
    },
    {
      "code": "GB-BEN",
      "name": "Brent",
      "type": "London borough"
    },
    {
      "code": "GB-BEX",
      "name": "Bexley",
      "type": "London borough"
    },
    {
      "code": "GB-BFS",
      "name": "Belfast City",
      "type": "District"
    },
    {
      "code": "GB-BGE",
      "name": "Bridgend [Pen-y-bont ar Ogwr GB-POG]",
      "type": "Unitary authority"
    },
    {
      "code": "GB-BGW",
      "name": "Blaenau Gwent",
      "type": "Unitary authority"
    },
    {
      "code": "GB-BIR",
      "name": "Birmingham",
      "type": "Metropolitan district"
    },
    {
      "code": "GB-BKM",
      "name": "Buckinghamshire",
      "type": "Two-tier county"
    },
    {
      "code": "GB-BNE",
      "name": "Barnet",
      "type": "London borough"
    },
    {
      "code": "GB-BNH",
      "name": "Brighton and Hove",
      "type": "Unitary authority"
    },
    {
      "code": "GB-BNS",
      "name": "Barnsley",
      "type": "Metropolitan district"
    },
    {
      "code": "GB-BOL",
      "name": "Bolton",
      "type": "Metropolitan district"
    },
    {
      "code": "GB-BPL",
      "name": "Blackpool",
      "type": "Unitary authority"
    },
    {
      "code": "GB-BRC",
      "name": "Bracknell Forest",
      "type": "Unitary authority"
    },
    {
      "code": "GB-BRD",
      "name": "Bradford",
      "type": "Metropolitan district"
    },
    {
      "code": "GB-BRY",
      "name": "Bromley",
      "type": "London borough"
    },
    {
      "code": "GB-BST",
      "name": "Bristol, City of",
      "type": "Unitary authority"
    },
    {
      "code": "GB-BUR",
      "name": "Bury",
      "type": "Metropolitan district"
    },
    {
      "code": "GB-CAM",
      "name": "Cambridgeshire",
      "type": "Two-tier county"
    },
    {
      "code": "GB-CAY",
      "name": "Caerphilly [Caerffili GB-CAF]",
      "type": "Unitary authority"
    },
    {
      "code": "GB-CBF",
      "name": "Central Bedfordshire",
      "type": "Unitary authority"
    },
    {
      "code": "GB-CCG",
      "name": "Causeway Coast and Glens",
      "type": "District"
    },
    {
      "code": "GB-CGN",
      "name": "Ceredigion [Sir Ceredigion]",
      "type": "Unitary authority"
    },
    {
      "code": "GB-CHE",
      "name": "Cheshire East",
      "type": "Unitary authority"
    },
    {
      "code": "GB-CHW",
      "name": "Cheshire West and Chester",
      "type": "Unitary authority"
    },
    {
      "code": "GB-CLD",
      "name": "Calderdale",
      "type": "Metropolitan district"
    },
    {
      "code": "GB-CLK",
      "name": "Clackmannanshire",
      "type": "Council area"
    },
    {
      "code": "GB-CMA",
      "name": "Cumbria",
      "type": "Two-tier county"
    },
    {
      "code": "GB-CMD",
      "name": "Camden",
      "type": "London borough"
    },
    {
      "code": "GB-CMN",
      "name": "Carmarthenshire [Sir Gaerfyrddin GB-GFY]",
      "type": "Unitary authority"
    },
    {
      "code": "GB-CON",
      "name": "Cornwall",
      "type": "Unitary authority"
    },
    {
      "code": "GB-COV",
      "name": "Coventry",
      "type": "Metropolitan district"
    },
    {
      "code": "GB-CRF",
      "name": "Cardiff [Caerdydd GB-CRD]",
      "type": "Unitary authority"
    },
    {
      "code": "GB-CRY",
      "name": "Croydon",
      "type": "London borough"
    },
    {
      "code": "GB-CWY",
      "name": "Conwy",
      "type": "Unitary authority"
    },
    {
      "code": "GB-DAL",
      "name": "Darlington",
      "type": "Unitary authority"
    },
    {
      "code": "GB-DBY",
      "name": "Derbyshire",
      "type": "Two-tier county"
    },
    {
      "code": "GB-DEN",
      "name": "Denbighshire [Sir Ddinbych GB-DDB]",
      "type": "Unitary authority"
    },
    {
      "code": "GB-DER",
      "name": "Derby",
      "type": "Unitary authority"
    },
    {
      "code": "GB-DEV",
      "name": "Devon",
      "type": "Two-tier county"
    },
    {
      "code": "GB-DGY",
      "name": "Dumfries and Galloway",
      "type": "Council area"
    },
    {
      "code": "GB-DNC",
      "name": "Doncaster",
      "type": "Metropolitan district"
    },
    {
      "code": "GB-DND",
      "name": "Dundee City",
      "type": "Council area"
    },
    {
      "code": "GB-DOR",
      "name": "Dorset",
      "type": "Two-tier county"
    },
    {
      "code": "GB-DRS",
      "name": "Derry and Strabane",
      "type": "District"
    },
    {
      "code": "GB-DUD",
      "name": "Dudley",
      "type": "Metropolitan district"
    },
    {
      "code": "GB-DUR",
      "name": "Durham, County",
      "type": "Unitary authority"
    },
    {
      "code": "GB-EAL",
      "name": "Ealing",
      "type": "London borough"
    },
    {
      "code": "GB-EAY",
      "name": "East Ayrshire",
      "type": "Council area"
    },
    {
      "code": "GB-EDH",
      "name": "Edinburgh, City of",
      "type": "Council area"
    },
    {
      "code": "GB-EDU",
      "name": "East Dunbartonshire",
      "type": "Council area"
    },
    {
      "code": "GB-ELN",
      "name": "East Lothian",
      "type": "Council area"
    },
    {
      "code": "GB-ELS",
      "name": "Eilean Siar",
      "type": "Council area"
    },
    {
      "code": "GB-ENF",
      "name": "Enfield",
      "type": "London borough"
    },
    {
      "code": "GB-ERW",
      "name": "East Renfrewshire",
      "type": "Council area"
    },
    {
      "code": "GB-ERY",
      "name": "East Riding of Yorkshire",
      "type": "Unitary authority"
    },
    {
      "code": "GB-ESS",
      "name": "Essex",
      "type": "Two-tier county"
    },
    {
      "code": "GB-ESX",
      "name": "East Sussex",
      "type": "Two-tier county"
    },
    {
      "code": "GB-FAL",
      "name": "Falkirk",
      "type": "Council area"
    },
    {
      "code": "GB-FIF",
      "name": "Fife",
      "type": "Council area"
    },
    {
      "code": "GB-FLN",
      "name": "Flintshire [Sir y Fflint GB-FFL]",
      "type": "Unitary authority"
    },
    {
      "code": "GB-FMO",
      "name": "Fermanagh and Omagh",
      "type": "District"
    },
    {
      "code": "GB-GAT",
      "name": "Gateshead",
      "type": "Metropolitan district"
    },
    {
      "code": "GB-GLG",
      "name": "Glasgow City",
      "type": "Council area"
    },
    {
      "code": "GB-GLS",
      "name": "Gloucestershire",
      "type": "Two-tier county"
    },
    {
      "code": "GB-GRE",
      "name": "Greenwich",
      "type": "London borough"
    },
    {
      "code": "GB-GWN",
      "name": "Gwynedd",
      "type": "Unitary authority"
    },
    {
      "code": "GB-HAL",
      "name": "Halton",
      "type": "Unitary authority"
    },
    {
      "code": "GB-HAM",
      "name": "Hampshire",
      "type": "Two-tier county"
    },
    {
      "code": "GB-HAV",
      "name": "Havering",
      "type": "London borough"
    },
    {
      "code": "GB-HCK",
      "name": "Hackney",
      "type": "London borough"
    },
    {
      "code": "GB-HEF",
      "name": "Herefordshire",
      "type": "Unitary authority"
    },
    {
      "code": "GB-HIL",
      "name": "Hillingdon",
      "type": "London borough"
    },
    {
      "code": "GB-HLD",
      "name": "Highland",
      "type": "Council area"
    },
    {
      "code": "GB-HMF",
      "name": "Hammersmith and Fulham",
      "type": "London borough"
    },
    {
      "code": "GB-HNS",
      "name": "Hounslow",
      "type": "London borough"
    },
    {
      "code": "GB-HPL",
      "name": "Hartlepool",
      "type": "Unitary authority"
    },
    {
      "code": "GB-HRT",
      "name": "Hertfordshire",
      "type": "Two-tier county"
    },
    {
      "code": "GB-HRW",
      "name": "Harrow",
      "type": "London borough"
    },
    {
      "code": "GB-HRY",
      "name": "Haringey",
      "type": "London borough"
    },
    {
      "code": "GB-IOS",
      "name": "Isles of Scilly",
      "type": "Unitary authority"
    },
    {
      "code": "GB-IOW",
      "name": "Isle of Wight",
      "type": "Unitary authority"
    },
    {
      "code": "GB-ISL",
      "name": "Islington",
      "type": "London borough"
    },
    {
      "code": "GB-IVC",
      "name": "Inverclyde",
      "type": "Council area"
    },
    {
      "code": "GB-KEC",
      "name": "Kensington and Chelsea",
      "type": "London borough"
    },
    {
      "code": "GB-KEN",
      "name": "Kent",
      "type": "Two-tier county"
    },
    {
      "code": "GB-KHL",
      "name": "Kingston upon Hull",
      "type": "Unitary authority"
    },
    {
      "code": "GB-KIR",
      "name": "Kirklees",
      "type": "Metropolitan district"
    },
    {
      "code": "GB-KTT",
      "name": "Kingston upon Thames",
      "type": "London borough"
    },
    {
      "code": "GB-KWL",
      "name": "Knowsley",
      "type": "Metropolitan district"
    },
    {
      "code": "GB-LAN",
      "name": "Lancashire",
      "type": "Two-tier county"
    },
    {
      "code": "GB-LBC",
      "name": "Lisburn and Castlereagh",
      "type": "District"
    },
    {
      "code": "GB-LBH",
      "name": "Lambeth",
      "type": "London borough"
    },
    {
      "code": "GB-LCE",
      "name": "Leicester",
      "type": "Unitary authority"
    },
    {
      "code": "GB-LDS",
      "name": "Leeds",
      "type": "Metropolitan district"
    },
    {
      "code": "GB-LEC",
      "name": "Leicestershire",
      "type": "Two-tier county"
    },
    {
      "code": "GB-LEW",
      "name": "Lewisham",
      "type": "London borough"
    },
    {
      "code": "GB-LIN",
      "name": "Lincolnshire",
      "type": "Two-tier county"
    },
    {
      "code": "GB-LIV",
      "name": "Liverpool",
      "type": "Metropolitan district"
    },
    {
      "code": "GB-LND",
      "name": "London, City of",
      "type": "City corporation"
    },
    {
      "code": "GB-LUT",
      "name": "Luton",
      "type": "Unitary authority"
    },
    {
      "code": "GB-MAN",
      "name": "Manchester",
      "type": "Metropolitan district"
    },
    {
      "code": "GB-MDB",
      "name": "Middlesbrough",
      "type": "Unitary authority"
    },
    {
      "code": "GB-MDW",
      "name": "Medway",
      "type": "Unitary authority"
    },
    {
      "code": "GB-MEA",
      "name": "Mid and East Antrim",
      "type": "District"
    },
    {
      "code": "GB-MIK",
      "name": "Milton Keynes",
      "type": "Unitary authority"
    },
    {
      "code": "GB-MLN",
      "name": "Midlothian",
      "type": "Council area"
    },
    {
      "code": "GB-MON",
      "name": "Monmouthshire [Sir Fynwy GB-FYN]",
      "type": "Unitary authority"
    },
    {
      "code": "GB-MRT",
      "name": "Merton",
      "type": "London borough"
    },
    {
      "code": "GB-MRY",
      "name": "Moray",
      "type": "Council area"
    },
    {
      "code": "GB-MTY",
      "name": "Merthyr Tydfil [Merthyr Tudful GB-MTU]",
      "type": "Unitary authority"
    },
    {
      "code": "GB-MUL",
      "name": "Mid-Ulster",
      "type": "District"
    },
    {
      "code": "GB-NAY",
      "name": "North Ayrshire",
      "type": "Council area"
    },
    {
      "code": "GB-NBL",
      "name": "Northumberland",
      "type": "Unitary authority"
    },
    {
      "code": "GB-NEL",
      "name": "North East Lincolnshire",
      "type": "Unitary authority"
    },
    {
      "code": "GB-NET",
      "name": "Newcastle upon Tyne",
      "type": "Metropolitan district"
    },
    {
      "code": "GB-NFK",
      "name": "Norfolk",
      "type": "Two-tier county"
    },
    {
      "code": "GB-NGM",
      "name": "Nottingham",
      "type": "Unitary authority"
    },
    {
      "code": "GB-NLK",
      "name": "North Lanarkshire",
      "type": "Council area"
    },
    {
      "code": "GB-NLN",
      "name": "North Lincolnshire",
      "type": "Unitary authority"
    },
    {
      "code": "GB-NMD",
      "name": "Newry, Mourne and Down",
      "type": "District"
    },
    {
      "code": "GB-NSM",
      "name": "North Somerset",
      "type": "Unitary authority"
    },
    {
      "code": "GB-NTH",
      "name": "Northamptonshire",
      "type": "Two-tier county"
    },
    {
      "code": "GB-NTL",
      "name": "Neath Port Talbot [Castell-nedd Port Talbot GB-CTL]",
      "type": "Unitary authority"
    },
    {
      "code": "GB-NTT",
      "name": "Nottinghamshire",
      "type": "Two-tier county"
    },
    {
      "code": "GB-NTY",
      "name": "North Tyneside",
      "type": "Metropolitan district"
    },
    {
      "code": "GB-NWM",
      "name": "Newham",
      "type": "London borough"
    },
    {
      "code": "GB-NWP",
      "name": "Newport [Casnewydd GB-CNW]",
      "type": "Unitary authority"
    },
    {
      "code": "GB-NYK",
      "name": "North Yorkshire",
      "type": "Two-tier county"
    },
    {
      "code": "GB-OLD",
      "name": "Oldham",
      "type": "Metropolitan district"
    },
    {
      "code": "GB-ORK",
      "name": "Orkney Islands",
      "type": "Council area"
    },
    {
      "code": "GB-OXF",
      "name": "Oxfordshire",
      "type": "Two-tier county"
    },
    {
      "code": "GB-PEM",
      "name": "Pembrokeshire [Sir Benfro GB-BNF]",
      "type": "Unitary authority"
    },
    {
      "code": "GB-PKN",
      "name": "Perth and Kinross",
      "type": "Council area"
    },
    {
      "code": "GB-PLY",
      "name": "Plymouth",
      "type": "Unitary authority"
    },
    {
      "code": "GB-POR",
      "name": "Portsmouth",
      "type": "Unitary authority"
    },
    {
      "code": "GB-POW",
      "name": "Powys",
      "type": "Unitary authority"
    },
    {
      "code": "GB-PTE",
      "name": "Peterborough",
      "type": "Unitary authority"
    },
    {
      "code": "GB-RCC",
      "name": "Redcar and Cleveland",
      "type": "Unitary authority"
    },
    {
      "code": "GB-RCH",
      "name": "Rochdale",
      "type": "Metropolitan district"
    },
    {
      "code": "GB-RCT",
      "name": "Rhondda Cynon Taff [Rhondda CynonTaf]",
      "type": "Unitary authority"
    },
    {
      "code": "GB-RDB",
      "name": "Redbridge",
      "type": "London borough"
    },
    {
      "code": "GB-RDG",
      "name": "Reading",
      "type": "Unitary authority"
    },
    {
      "code": "GB-RFW",
      "name": "Renfrewshire",
      "type": "Council area"
    },
    {
      "code": "GB-RIC",
      "name": "Richmond upon Thames",
      "type": "London borough"
    },
    {
      "code": "GB-ROT",
      "name": "Rotherham",
      "type": "Metropolitan district"
    },
    {
      "code": "GB-RUT",
      "name": "Rutland",
      "type": "Unitary authority"
    },
    {
      "code": "GB-SAW",
      "name": "Sandwell",
      "type": "Metropolitan district"
    },
    {
      "code": "GB-SAY",
      "name": "South Ayrshire",
      "type": "Council area"
    },
    {
      "code": "GB-SCB",
      "name": "Scottish Borders",
      "type": "Council area"
    },
    {
      "code": "GB-SFK",
      "name": "Suffolk",
      "type": "Two-tier county"
    },
    {
      "code": "GB-SFT",
      "name": "Sefton",
      "type": "Metropolitan district"
    },
    {
      "code": "GB-SGC",
      "name": "South Gloucestershire",
      "type": "Unitary authority"
    },
    {
      "code": "GB-SHF",
      "name": "Sheffield",
      "type": "Metropolitan district"
    },
    {
      "code": "GB-SHN",
      "name": "St. Helens",
      "type": "Metropolitan district"
    },
    {
      "code": "GB-SHR",
      "name": "Shropshire",
      "type": "Unitary authority"
    },
    {
      "code": "GB-SKP",
      "name": "Stockport",
      "type": "Metropolitan district"
    },
    {
      "code": "GB-SLF",
      "name": "Salford",
      "type": "Metropolitan district"
    },
    {
      "code": "GB-SLG",
      "name": "Slough",
      "type": "Unitary authority"
    },
    {
      "code": "GB-SLK",
      "name": "South Lanarkshire",
      "type": "Council area"
    },
    {
      "code": "GB-SND",
      "name": "Sunderland",
      "type": "Metropolitan district"
    },
    {
      "code": "GB-SOL",
      "name": "Solihull",
      "type": "Metropolitan district"
    },
    {
      "code": "GB-SOM",
      "name": "Somerset",
      "type": "Two-tier county"
    },
    {
      "code": "GB-SOS",
      "name": "Southend-on-Sea",
      "type": "Unitary authority"
    },
    {
      "code": "GB-SRY",
      "name": "Surrey",
      "type": "Two-tier county"
    },
    {
      "code": "GB-STE",
      "name": "Stoke-on-Trent",
      "type": "Unitary authority"
    },
    {
      "code": "GB-STG",
      "name": "Stirling",
      "type": "Council area"
    },
    {
      "code": "GB-STH",
      "name": "Southampton",
      "type": "Unitary authority"
    },
    {
      "code": "GB-STN",
      "name": "Sutton",
      "type": "London borough"
    },
    {
      "code": "GB-STS",
      "name": "Staffordshire",
      "type": "Two-tier county"
    },
    {
      "code": "GB-STT",
      "name": "Stockton-on-Tees",
      "type": "Unitary authority"
    },
    {
      "code": "GB-STY",
      "name": "South Tyneside",
      "type": "Metropolitan district"
    },
    {
      "code": "GB-SWA",
      "name": "Swansea [Abertawe GB-ATA]",
      "type": "Unitary authority"
    },
    {
      "code": "GB-SWD",
      "name": "Swindon",
      "type": "Unitary authority"
    },
    {
      "code": "GB-SWK",
      "name": "Southwark",
      "type": "London borough"
    },
    {
      "code": "GB-TAM",
      "name": "Tameside",
      "type": "Metropolitan district"
    },
    {
      "code": "GB-TFW",
      "name": "Telford and Wrekin",
      "type": "Unitary authority"
    },
    {
      "code": "GB-THR",
      "name": "Thurrock",
      "type": "Unitary authority"
    },
    {
      "code": "GB-TOB",
      "name": "Torbay",
      "type": "Unitary authority"
    },
    {
      "code": "GB-TOF",
      "name": "Torfaen [Tor-faen]",
      "type": "Unitary authority"
    },
    {
      "code": "GB-TRF",
      "name": "Trafford",
      "type": "Metropolitan district"
    },
    {
      "code": "GB-TWH",
      "name": "Tower Hamlets",
      "type": "London borough"
    },
    {
      "code": "GB-VGL",
      "name": "Vale of Glamorgan, The [Bro Morgannwg GB-BMG]",
      "type": "Unitary authority"
    },
    {
      "code": "GB-WAR",
      "name": "Warwickshire",
      "type": "Two-tier county"
    },
    {
      "code": "GB-WBK",
      "name": "West Berkshire",
      "type": "Unitary authority"
    },
    {
      "code": "GB-WDU",
      "name": "West Dunbartonshire",
      "type": "Council area"
    },
    {
      "code": "GB-WFT",
      "name": "Waltham Forest",
      "type": "London borough"
    },
    {
      "code": "GB-WGN",
      "name": "Wigan",
      "type": "Metropolitan district"
    },
    {
      "code": "GB-WIL",
      "name": "Wiltshire",
      "type": "Unitary authority"
    },
    {
      "code": "GB-WKF",
      "name": "Wakefield",
      "type": "Metropolitan district"
    },
    {
      "code": "GB-WLL",
      "name": "Walsall",
      "type": "Metropolitan district"
    },
    {
      "code": "GB-WLN",
      "name": "West Lothian",
      "type": "Council area"
    },
    {
      "code": "GB-WLV",
      "name": "Wolverhampton",
      "type": "Metropolitan district"
    },
    {
      "code": "GB-WND",
      "name": "Wandsworth",
      "type": "London borough"
    },
    {
      "code": "GB-WNM",
      "name": "Windsor and Maidenhead",
      "type": "Unitary authority"
    },
    {
      "code": "GB-WOK",
      "name": "Wokingham",
      "type": "Unitary authority"
    },
    {
      "code": "GB-WOR",
      "name": "Worcestershire",
      "type": "Two-tier county"
    },
    {
      "code": "GB-WRL",
      "name": "Wirral",
      "type": "Metropolitan district"
    },
    {
      "code": "GB-WRT",
      "name": "Warrington",
      "type": "Unitary authority"
    },
    {
      "code": "GB-WRX",
      "name": "Wrexham [Wrecsam GB-WRC]",
      "type": "Unitary authority"
    },
    {
      "code": "GB-WSM",
      "name": "Westminster",
      "type": "London borough"
    },
    {
      "code": "GB-WSX",
      "name": "West Sussex",
      "type": "Two-tier county"
    },
    {
      "code": "GB-YOR",
      "name": "York",
      "type": "Unitary authority"
    },
    {
      "code": "GB-ZET",
      "name": "Shetland Islands",
      "type": "Council area"
    },
    {
      "code": "GD-01",
      "name": "Saint Andrew",
      "type": "Parish"
    },
    {
      "code": "GD-02",
      "name": "Saint David",
      "type": "Parish"
    },
    {
      "code": "GD-03",
      "name": "Saint George",
      "type": "Parish"
    },
    {
      "code": "GD-04",
      "name": "Saint John",
      "type": "Parish"
    },
    {
      "code": "GD-05",
      "name": "Saint Mark",
      "type": "Parish"
    },
    {
      "code": "GD-06",
      "name": "Saint Patrick",
      "type": "Parish"
    },
    {
      "code": "GD-10",
      "name": "Southern Grenadine Islands",
      "type": "Dependency"
    },
    {
      "code": "GE-AB",
      "name": "Abkhazia",
      "type": "Autonomous republic"
    },
    {
      "code": "GE-AJ",
      "name": "Ajaria",
      "type": "Autonomous republic"
    },
    {
      "code": "GE-GU",
      "name": "Guria",
      "type": "Region"
    },
    {
      "code": "GE-IM",
      "name": "Imereti",
      "type": "Region"
    },
    {
      "code": "GE-KA",
      "name": "K'akheti",
      "type": "Region"
    },
    {
      "code": "GE-KK",
      "name": "Kvemo Kartli",
      "type": "Region"
    },
    {
      "code": "GE-MM",
      "name": "Mtskheta-Mtianeti",
      "type": "Region"
    },
    {
      "code": "GE-RL",
      "name": "Rach'a-Lechkhumi-Kvemo Svaneti",
      "type": "Region"
    },
    {
      "code": "GE-SJ",
      "name": "Samtskhe-Javakheti",
      "type": "Region"
    },
    {
      "code": "GE-SK",
      "name": "Shida Kartli",
      "type": "Region"
    },
    {
      "code": "GE-SZ",
      "name": "Samegrelo-Zemo Svaneti",
      "type": "Region"
    },
    {
      "code": "GE-TB",
      "name": "Tbilisi",
      "type": "City"
    },
    {
      "code": "GH-AA",
      "name": "Greater Accra",
      "type": "Region"
    },
    {
      "code": "GH-AF",
      "name": "Ahafo",
      "type": "Region"
    },
    {
      "code": "GH-AH",
      "name": "Ashanti",
      "type": "Region"
    },
    {
      "code": "GH-BE",
      "name": "Bono East",
      "type": "Region"
    },
    {
      "code": "GH-BO",
      "name": "Bono",
      "type": "Region"
    },
    {
      "code": "GH-CP",
      "name": "Central",
      "type": "Region"
    },
    {
      "code": "GH-EP",
      "name": "Eastern",
      "type": "Region"
    },
    {
      "code": "GH-NE",
      "name": "North East",
      "type": "Region"
    },
    {
      "code": "GH-NP",
      "name": "Northern",
      "type": "Region"
    },
    {
      "code": "GH-OT",
      "name": "Oti",
      "type": "Region"
    },
    {
      "code": "GH-SV",
      "name": "Savannah",
      "type": "Region"
    },
    {
      "code": "GH-TV",
      "name": "Volta",
      "type": "Region"
    },
    {
      "code": "GH-UE",
      "name": "Upper East",
      "type": "Region"
    },
    {
      "code": "GH-UW",
      "name": "Upper West",
      "type": "Region"
    },
    {
      "code": "GH-WN",
      "name": "Western North",
      "type": "Region"
    },
    {
      "code": "GH-WP",
      "name": "Western",
      "type": "Region"
    },
    {
      "code": "GL-AV",
      "name": "Avannaata Kommunia",
      "type": "Municipality"
    },
    {
      "code": "GL-KU",
      "name": "Kommune Kujalleq",
      "type": "Municipality"
    },
    {
      "code": "GL-QE",
      "name": "Qeqqata Kommunia",
      "type": "Municipality"
    },
    {
      "code": "GL-QT",
      "name": "Kommune Qeqertalik",
      "type": "Municipality"
    },
    {
      "code": "GL-SM",
      "name": "Kommuneqarfik Sermersooq",
      "type": "Municipality"
    },
    {
      "code": "GM-B",
      "name": "Banjul",
      "type": "City"
    },
    {
      "code": "GM-L",
      "name": "Lower River",
      "type": "Division"
    },
    {
      "code": "GM-M",
      "name": "Central River",
      "type": "Division"
    },
    {
      "code": "GM-N",
      "name": "North Bank",
      "type": "Division"
    },
    {
      "code": "GM-U",
      "name": "Upper River",
      "type": "Division"
    },
    {
      "code": "GM-W",
      "name": "Western",
      "type": "Division"
    },
    {
      "code": "GN-B",
      "name": "Boké",
      "type": "Administrative region"
    },
    {
      "code": "GN-BE",
      "name": "Beyla",
      "parent": "N",
      "type": "Prefecture"
    },
    {
      "code": "GN-BF",
      "name": "Boffa",
      "parent": "B",
      "type": "Prefecture"
    },
    {
      "code": "GN-BK",
      "name": "Boké",
      "parent": "B",
      "type": "Prefecture"
    },
    {
      "code": "GN-C",
      "name": "Conakry",
      "type": "Governorate"
    },
    {
      "code": "GN-CO",
      "name": "Coyah",
      "parent": "D",
      "type": "Prefecture"
    },
    {
      "code": "GN-D",
      "name": "Kindia",
      "type": "Administrative region"
    },
    {
      "code": "GN-DB",
      "name": "Dabola",
      "parent": "F",
      "type": "Prefecture"
    },
    {
      "code": "GN-DI",
      "name": "Dinguiraye",
      "parent": "F",
      "type": "Prefecture"
    },
    {
      "code": "GN-DL",
      "name": "Dalaba",
      "parent": "M",
      "type": "Prefecture"
    },
    {
      "code": "GN-DU",
      "name": "Dubréka",
      "parent": "D",
      "type": "Prefecture"
    },
    {
      "code": "GN-F",
      "name": "Faranah",
      "type": "Administrative region"
    },
    {
      "code": "GN-FA",
      "name": "Faranah",
      "parent": "F",
      "type": "Prefecture"
    },
    {
      "code": "GN-FO",
      "name": "Forécariah",
      "parent": "D",
      "type": "Prefecture"
    },
    {
      "code": "GN-FR",
      "name": "Fria",
      "parent": "B",
      "type": "Prefecture"
    },
    {
      "code": "GN-GA",
      "name": "Gaoual",
      "parent": "B",
      "type": "Prefecture"
    },
    {
      "code": "GN-GU",
      "name": "Guékédou",
      "parent": "N",
      "type": "Prefecture"
    },
    {
      "code": "GN-K",
      "name": "Kankan",
      "type": "Administrative region"
    },
    {
      "code": "GN-KA",
      "name": "Kankan",
      "parent": "K",
      "type": "Prefecture"
    },
    {
      "code": "GN-KB",
      "name": "Koubia",
      "parent": "L",
      "type": "Prefecture"
    },
    {
      "code": "GN-KD",
      "name": "Kindia",
      "parent": "D",
      "type": "Prefecture"
    },
    {
      "code": "GN-KE",
      "name": "Kérouané",
      "parent": "K",
      "type": "Prefecture"
    },
    {
      "code": "GN-KN",
      "name": "Koundara",
      "parent": "B",
      "type": "Prefecture"
    },
    {
      "code": "GN-KO",
      "name": "Kouroussa",
      "parent": "K",
      "type": "Prefecture"
    },
    {
      "code": "GN-KS",
      "name": "Kissidougou",
      "parent": "F",
      "type": "Prefecture"
    },
    {
      "code": "GN-L",
      "name": "Labé",
      "type": "Administrative region"
    },
    {
      "code": "GN-LA",
      "name": "Labé",
      "parent": "L",
      "type": "Prefecture"
    },
    {
      "code": "GN-LE",
      "name": "Lélouma",
      "parent": "L",
      "type": "Prefecture"
    },
    {
      "code": "GN-LO",
      "name": "Lola",
      "parent": "N",
      "type": "Prefecture"
    },
    {
      "code": "GN-M",
      "name": "Mamou",
      "type": "Administrative region"
    },
    {
      "code": "GN-MC",
      "name": "Macenta",
      "parent": "N",
      "type": "Prefecture"
    },
    {
      "code": "GN-MD",
      "name": "Mandiana",
      "parent": "K",
      "type": "Prefecture"
    },
    {
      "code": "GN-ML",
      "name": "Mali",
      "parent": "L",
      "type": "Prefecture"
    },
    {
      "code": "GN-MM",
      "name": "Mamou",
      "parent": "M",
      "type": "Prefecture"
    },
    {
      "code": "GN-N",
      "name": "Nzérékoré",
      "type": "Administrative region"
    },
    {
      "code": "GN-NZ",
      "name": "Nzérékoré",
      "parent": "N",
      "type": "Prefecture"
    },
    {
      "code": "GN-PI",
      "name": "Pita",
      "parent": "M",
      "type": "Prefecture"
    },
    {
      "code": "GN-SI",
      "name": "Siguiri",
      "parent": "K",
      "type": "Prefecture"
    },
    {
      "code": "GN-TE",
      "name": "Télimélé",
      "parent": "D",
      "type": "Prefecture"
    },
    {
      "code": "GN-TO",
      "name": "Tougué",
      "parent": "L",
      "type": "Prefecture"
    },
    {
      "code": "GN-YO",
      "name": "Yomou",
      "parent": "N",
      "type": "Prefecture"
    },
    {
      "code": "GQ-AN",
      "name": "Annobon",
      "parent": "I",
      "type": "Province"
    },
    {
      "code": "GQ-BN",
      "name": "Bioko Nord",
      "parent": "I",
      "type": "Province"
    },
    {
      "code": "GQ-BS",
      "name": "Bioko Sud",
      "parent": "I",
      "type": "Province"
    },
    {
      "code": "GQ-C",
      "name": "Região Continental",
      "type": "Region"
    },
    {
      "code": "GQ-CS",
      "name": "Centro Sud",
      "parent": "C",
      "type": "Province"
    },
    {
      "code": "GQ-DJ",
      "name": "Djibloho",
      "parent": "C",
      "type": "Province"
    },
    {
      "code": "GQ-I",
      "name": "Região Insular",
      "type": "Region"
    },
    {
      "code": "GQ-KN",
      "name": "Kié-Ntem",
      "parent": "C",
      "type": "Province"
    },
    {
      "code": "GQ-LI",
      "name": "Litoral",
      "parent": "C",
      "type": "Province"
    },
    {
      "code": "GQ-WN",
      "name": "Wele-Nzas",
      "parent": "C",
      "type": "Province"
    },
    {
      "code": "GR-69",
      "name": "Ágion Óros",
      "type": "Self-governed part"
    },
    {
      "code": "GR-A",
      "name": "Anatolikí Makedonía kai Thráki",
      "type": "Administrative region"
    },
    {
      "code": "GR-B",
      "name": "Kentrikí Makedonía",
      "type": "Administrative region"
    },
    {
      "code": "GR-C",
      "name": "Dytikí Makedonía",
      "type": "Administrative region"
    },
    {
      "code": "GR-D",
      "name": "Ípeiros",
      "type": "Administrative region"
    },
    {
      "code": "GR-E",
      "name": "Thessalía",
      "type": "Administrative region"
    },
    {
      "code": "GR-F",
      "name": "Ionía Nísia",
      "type": "Administrative region"
    },
    {
      "code": "GR-G",
      "name": "Dytikí Elláda",
      "type": "Administrative region"
    },
    {
      "code": "GR-H",
      "name": "Stereá Elláda",
      "type": "Administrative region"
    },
    {
      "code": "GR-I",
      "name": "Attikí",
      "type": "Administrative region"
    },
    {
      "code": "GR-J",
      "name": "Pelopónnisos",
      "type": "Administrative region"
    },
    {
      "code": "GR-K",
      "name": "Vóreio Aigaío",
      "type": "Administrative region"
    },
    {
      "code": "GR-L",
      "name": "Nótio Aigaío",
      "type": "Administrative region"
    },
    {
      "code": "GR-M",
      "name": "Kríti",
      "type": "Administrative region"
    },
    {
      "code": "GT-AV",
      "name": "Alta Verapaz",
      "type": "Department"
    },
    {
      "code": "GT-BV",
      "name": "Baja Verapaz",
      "type": "Department"
    },
    {
      "code": "GT-CM",
      "name": "Chimaltenango",
      "type": "Department"
    },
    {
      "code": "GT-CQ",
      "name": "Chiquimula",
      "type": "Department"
    },
    {
      "code": "GT-ES",
      "name": "Escuintla",
      "type": "Department"
    },
    {
      "code": "GT-GU",
      "name": "Guatemala",
      "type": "Department"
    },
    {
      "code": "GT-HU",
      "name": "Huehuetenango",
      "type": "Department"
    },
    {
      "code": "GT-IZ",
      "name": "Izabal",
      "type": "Department"
    },
    {
      "code": "GT-JA",
      "name": "Jalapa",
      "type": "Department"
    },
    {
      "code": "GT-JU",
      "name": "Jutiapa",
      "type": "Department"
    },
    {
      "code": "GT-PE",
      "name": "Petén",
      "type": "Department"
    },
    {
      "code": "GT-PR",
      "name": "El Progreso",
      "type": "Department"
    },
    {
      "code": "GT-QC",
      "name": "Quiché",
      "type": "Department"
    },
    {
      "code": "GT-QZ",
      "name": "Quetzaltenango",
      "type": "Department"
    },
    {
      "code": "GT-RE",
      "name": "Retalhuleu",
      "type": "Department"
    },
    {
      "code": "GT-SA",
      "name": "Sacatepéquez",
      "type": "Department"
    },
    {
      "code": "GT-SM",
      "name": "San Marcos",
      "type": "Department"
    },
    {
      "code": "GT-SO",
      "name": "Sololá",
      "type": "Department"
    },
    {
      "code": "GT-SR",
      "name": "Santa Rosa",
      "type": "Department"
    },
    {
      "code": "GT-SU",
      "name": "Suchitepéquez",
      "type": "Department"
    },
    {
      "code": "GT-TO",
      "name": "Totonicapán",
      "type": "Department"
    },
    {
      "code": "GT-ZA",
      "name": "Zacapa",
      "type": "Department"
    },
    {
      "code": "GW-BA",
      "name": "Bafatá",
      "parent": "L",
      "type": "Region"
    },
    {
      "code": "GW-BL",
      "name": "Bolama / Bijagós",
      "parent": "S",
      "type": "Region"
    },
    {
      "code": "GW-BM",
      "name": "Biombo",
      "parent": "N",
      "type": "Region"
    },
    {
      "code": "GW-BS",
      "name": "Bissau",
      "type": "Autonomous sector"
    },
    {
      "code": "GW-CA",
      "name": "Cacheu",
      "parent": "N",
      "type": "Region"
    },
    {
      "code": "GW-GA",
      "name": "Gabú",
      "parent": "L",
      "type": "Region"
    },
    {
      "code": "GW-L",
      "name": "Leste",
      "type": "Province"
    },
    {
      "code": "GW-N",
      "name": "Norte",
      "type": "Province"
    },
    {
      "code": "GW-OI",
      "name": "Oio",
      "parent": "N",
      "type": "Region"
    },
    {
      "code": "GW-QU",
      "name": "Quinara",
      "parent": "S",
      "type": "Region"
    },
    {
      "code": "GW-S",
      "name": "Sul",
      "type": "Province"
    },
    {
      "code": "GW-TO",
      "name": "Tombali",
      "parent": "S",
      "type": "Region"
    },
    {
      "code": "GY-BA",
      "name": "Barima-Waini",
      "type": "Region"
    },
    {
      "code": "GY-CU",
      "name": "Cuyuni-Mazaruni",
      "type": "Region"
    },
    {
      "code": "GY-DE",
      "name": "Demerara-Mahaica",
      "type": "Region"
    },
    {
      "code": "GY-EB",
      "name": "East Berbice-Corentyne",
      "type": "Region"
    },
    {
      "code": "GY-ES",
      "name": "Essequibo Islands-West Demerara",
      "type": "Region"
    },
    {
      "code": "GY-MA",
      "name": "Mahaica-Berbice",
      "type": "Region"
    },
    {
      "code": "GY-PM",
      "name": "Pomeroon-Supenaam",
      "type": "Region"
    },
    {
      "code": "GY-PT",
      "name": "Potaro-Siparuni",
      "type": "Region"
    },
    {
      "code": "GY-UD",
      "name": "Upper Demerara-Berbice",
      "type": "Region"
    },
    {
      "code": "GY-UT",
      "name": "Upper Takutu-Upper Essequibo",
      "type": "Region"
    },
    {
      "code": "HN-AT",
      "name": "Atlántida",
      "type": "Department"
    },
    {
      "code": "HN-CH",
      "name": "Choluteca",
      "type": "Department"
    },
    {
      "code": "HN-CL",
      "name": "Colón",
      "type": "Department"
    },
    {
      "code": "HN-CM",
      "name": "Comayagua",
      "type": "Department"
    },
    {
      "code": "HN-CP",
      "name": "Copán",
      "type": "Department"
    },
    {
      "code": "HN-CR",
      "name": "Cortés",
      "type": "Department"
    },
    {
      "code": "HN-EP",
      "name": "El Paraíso",
      "type": "Department"
    },
    {
      "code": "HN-FM",
      "name": "Francisco Morazán",
      "type": "Department"
    },
    {
      "code": "HN-GD",
      "name": "Gracias a Dios",
      "type": "Department"
    },
    {
      "code": "HN-IB",
      "name": "Islas de la Bahía",
      "type": "Department"
    },
    {
      "code": "HN-IN",
      "name": "Intibucá",
      "type": "Department"
    },
    {
      "code": "HN-LE",
      "name": "Lempira",
      "type": "Department"
    },
    {
      "code": "HN-LP",
      "name": "La Paz",
      "type": "Department"
    },
    {
      "code": "HN-OC",
      "name": "Ocotepeque",
      "type": "Department"
    },
    {
      "code": "HN-OL",
      "name": "Olancho",
      "type": "Department"
    },
    {
      "code": "HN-SB",
      "name": "Santa Bárbara",
      "type": "Department"
    },
    {
      "code": "HN-VA",
      "name": "Valle",
      "type": "Department"
    },
    {
      "code": "HN-YO",
      "name": "Yoro",
      "type": "Department"
    },
    {
      "code": "HR-01",
      "name": "Zagrebačka županija",
      "type": "County"
    },
    {
      "code": "HR-02",
      "name": "Krapinsko-zagorska županija",
      "type": "County"
    },
    {
      "code": "HR-03",
      "name": "Sisačko-moslavačka županija",
      "type": "County"
    },
    {
      "code": "HR-04",
      "name": "Karlovačka županija",
      "type": "County"
    },
    {
      "code": "HR-05",
      "name": "Varaždinska županija",
      "type": "County"
    },
    {
      "code": "HR-06",
      "name": "Koprivničko-križevačka županija",
      "type": "County"
    },
    {
      "code": "HR-07",
      "name": "Bjelovarsko-bilogorska županija",
      "type": "County"
    },
    {
      "code": "HR-08",
      "name": "Primorsko-goranska županija",
      "type": "County"
    },
    {
      "code": "HR-09",
      "name": "Ličko-senjska županija",
      "type": "County"
    },
    {
      "code": "HR-10",
      "name": "Virovitičko-podravska županija",
      "type": "County"
    },
    {
      "code": "HR-11",
      "name": "Požeško-slavonska županija",
      "type": "County"
    },
    {
      "code": "HR-12",
      "name": "Brodsko-posavska županija",
      "type": "County"
    },
    {
      "code": "HR-13",
      "name": "Zadarska županija",
      "type": "County"
    },
    {
      "code": "HR-14",
      "name": "Osječko-baranjska županija",
      "type": "County"
    },
    {
      "code": "HR-15",
      "name": "Šibensko-kninska županija",
      "type": "County"
    },
    {
      "code": "HR-16",
      "name": "Vukovarsko-srijemska županija",
      "type": "County"
    },
    {
      "code": "HR-17",
      "name": "Splitsko-dalmatinska županija",
      "type": "County"
    },
    {
      "code": "HR-18",
      "name": "Istarska županija",
      "type": "County"
    },
    {
      "code": "HR-19",
      "name": "Dubrovačko-neretvanska županija",
      "type": "County"
    },
    {
      "code": "HR-20",
      "name": "Međimurska županija",
      "type": "County"
    },
    {
      "code": "HR-21",
      "name": "Grad Zagreb",
      "type": "City"
    },
    {
      "code": "HT-AR",
      "name": "Artibonite",
      "type": "Department"
    },
    {
      "code": "HT-CE",
      "name": "Centre",
      "type": "Department"
    },
    {
      "code": "HT-GA",
      "name": "Grandans",
      "type": "Department"
    },
    {
      "code": "HT-ND",
      "name": "Nord",
      "type": "Department"
    },
    {
      "code": "HT-NE",
      "name": "Nord-Est",
      "type": "Department"
    },
    {
      "code": "HT-NI",
      "name": "Nip",
      "type": "Department"
    },
    {
      "code": "HT-NO",
      "name": "Nord-Ouest",
      "type": "Department"
    },
    {
      "code": "HT-OU",
      "name": "Lwès",
      "type": "Department"
    },
    {
      "code": "HT-SD",
      "name": "Sid",
      "type": "Department"
    },
    {
      "code": "HT-SE",
      "name": "Sidès",
      "type": "Department"
    },
    {
      "code": "HU-BA",
      "name": "Baranya",
      "type": "County"
    },
    {
      "code": "HU-BC",
      "name": "Békéscsaba",
      "type": "City with county rights"
    },
    {
      "code": "HU-BE",
      "name": "Békés",
      "type": "County"
    },
    {
      "code": "HU-BK",
      "name": "Bács-Kiskun",
      "type": "County"
    },
    {
      "code": "HU-BU",
      "name": "Budapest",
      "type": "Capital city"
    },
    {
      "code": "HU-BZ",
      "name": "Borsod-Abaúj-Zemplén",
      "type": "County"
    },
    {
      "code": "HU-CS",
      "name": "Csongrád",
      "type": "County"
    },
    {
      "code": "HU-DE",
      "name": "Debrecen",
      "type": "City with county rights"
    },
    {
      "code": "HU-DU",
      "name": "Dunaújváros",
      "type": "City with county rights"
    },
    {
      "code": "HU-EG",
      "name": "Eger",
      "type": "City with county rights"
    },
    {
      "code": "HU-ER",
      "name": "Érd",
      "type": "City with county rights"
    },
    {
      "code": "HU-FE",
      "name": "Fejér",
      "type": "County"
    },
    {
      "code": "HU-GS",
      "name": "Győr-Moson-Sopron",
      "type": "County"
    },
    {
      "code": "HU-GY",
      "name": "Győr",
      "type": "City with county rights"
    },
    {
      "code": "HU-HB",
      "name": "Hajdú-Bihar",
      "type": "County"
    },
    {
      "code": "HU-HE",
      "name": "Heves",
      "type": "County"
    },
    {
      "code": "HU-HV",
      "name": "Hódmezővásárhely",
      "type": "City with county rights"
    },
    {
      "code": "HU-JN",
      "name": "Jász-Nagykun-Szolnok",
      "type": "County"
    },
    {
      "code": "HU-KE",
      "name": "Komárom-Esztergom",
      "type": "County"
    },
    {
      "code": "HU-KM",
      "name": "Kecskemét",
      "type": "City with county rights"
    },
    {
      "code": "HU-KV",
      "name": "Kaposvár",
      "type": "City with county rights"
    },
    {
      "code": "HU-MI",
      "name": "Miskolc",
      "type": "City with county rights"
    },
    {
      "code": "HU-NK",
      "name": "Nagykanizsa",
      "type": "City with county rights"
    },
    {
      "code": "HU-NO",
      "name": "Nógrád",
      "type": "County"
    },
    {
      "code": "HU-NY",
      "name": "Nyíregyháza",
      "type": "City with county rights"
    },
    {
      "code": "HU-PE",
      "name": "Pest",
      "type": "County"
    },
    {
      "code": "HU-PS",
      "name": "Pécs",
      "type": "City with county rights"
    },
    {
      "code": "HU-SD",
      "name": "Szeged",
      "type": "City with county rights"
    },
    {
      "code": "HU-SF",
      "name": "Székesfehérvár",
      "type": "City with county rights"
    },
    {
      "code": "HU-SH",
      "name": "Szombathely",
      "type": "City with county rights"
    },
    {
      "code": "HU-SK",
      "name": "Szolnok",
      "type": "City with county rights"
    },
    {
      "code": "HU-SN",
      "name": "Sopron",
      "type": "City with county rights"
    },
    {
      "code": "HU-SO",
      "name": "Somogy",
      "type": "County"
    },
    {
      "code": "HU-SS",
      "name": "Szekszárd",
      "type": "City with county rights"
    },
    {
      "code": "HU-ST",
      "name": "Salgótarján",
      "type": "City with county rights"
    },
    {
      "code": "HU-SZ",
      "name": "Szabolcs-Szatmár-Bereg",
      "type": "County"
    },
    {
      "code": "HU-TB",
      "name": "Tatabánya",
      "type": "City with county rights"
    },
    {
      "code": "HU-TO",
      "name": "Tolna",
      "type": "County"
    },
    {
      "code": "HU-VA",
      "name": "Vas",
      "type": "County"
    },
    {
      "code": "HU-VE",
      "name": "Veszprém",
      "type": "County"
    },
    {
      "code": "HU-VM",
      "name": "Veszprém",
      "type": "City with county rights"
    },
    {
      "code": "HU-ZA",
      "name": "Zala",
      "type": "County"
    },
    {
      "code": "HU-ZE",
      "name": "Zalaegerszeg",
      "type": "City with county rights"
    },
    {
      "code": "ID-AC",
      "name": "Aceh",
      "parent": "SM",
      "type": "Province"
    },
    {
      "code": "ID-BA",
      "name": "Bali",
      "parent": "NU",
      "type": "Province"
    },
    {
      "code": "ID-BB",
      "name": "Kepulauan Bangka Belitung",
      "parent": "SM",
      "type": "Province"
    },
    {
      "code": "ID-BE",
      "name": "Bengkulu",
      "parent": "SM",
      "type": "Province"
    },
    {
      "code": "ID-BT",
      "name": "Banten",
      "parent": "JW",
      "type": "Province"
    },
    {
      "code": "ID-GO",
      "name": "Gorontalo",
      "parent": "SL",
      "type": "Province"
    },
    {
      "code": "ID-JA",
      "name": "Jambi",
      "parent": "SM",
      "type": "Province"
    },
    {
      "code": "ID-JB",
      "name": "Jawa Barat",
      "parent": "JW",
      "type": "Province"
    },
    {
      "code": "ID-JI",
      "name": "Jawa Timur",
      "parent": "JW",
      "type": "Province"
    },
    {
      "code": "ID-JK",
      "name": "Jakarta Raya",
      "parent": "JW",
      "type": "Capital district"
    },
    {
      "code": "ID-JT",
      "name": "Jawa Tengah",
      "parent": "JW",
      "type": "Province"
    },
    {
      "code": "ID-JW",
      "name": "Jawa",
      "type": "Geographical unit"
    },
    {
      "code": "ID-KA",
      "name": "Kalimantan",
      "type": "Geographical unit"
    },
    {
      "code": "ID-KB",
      "name": "Kalimantan Barat",
      "parent": "KA",
      "type": "Province"
    },
    {
      "code": "ID-KI",
      "name": "Kalimantan Timur",
      "parent": "KA",
      "type": "Province"
    },
    {
      "code": "ID-KR",
      "name": "Kepulauan Riau",
      "parent": "SM",
      "type": "Province"
    },
    {
      "code": "ID-KS",
      "name": "Kalimantan Selatan",
      "parent": "KA",
      "type": "Province"
    },
    {
      "code": "ID-KT",
      "name": "Kalimantan Tengah",
      "parent": "KA",
      "type": "Province"
    },
    {
      "code": "ID-KU",
      "name": "Kalimantan Utara",
      "parent": "KA",
      "type": "Province"
    },
    {
      "code": "ID-LA",
      "name": "Lampung",
      "parent": "SM",
      "type": "Province"
    },
    {
      "code": "ID-MA",
      "name": "Maluku",
      "parent": "ML",
      "type": "Province"
    },
    {
      "code": "ID-ML",
      "name": "Maluku",
      "type": "Geographical unit"
    },
    {
      "code": "ID-MU",
      "name": "Maluku Utara",
      "parent": "ML",
      "type": "Province"
    },
    {
      "code": "ID-NB",
      "name": "Nusa Tenggara Barat",
      "parent": "NU",
      "type": "Province"
    },
    {
      "code": "ID-NT",
      "name": "Nusa Tenggara Timur",
      "parent": "NU",
      "type": "Province"
    },
    {
      "code": "ID-NU",
      "name": "Nusa Tenggara",
      "type": "Geographical unit"
    },
    {
      "code": "ID-PA",
      "name": "Papua",
      "parent": "PP",
      "type": "Province"
    },
    {
      "code": "ID-PB",
      "name": "Papua Barat",
      "parent": "PP",
      "type": "Province"
    },
    {
      "code": "ID-PP",
      "name": "Papua",
      "type": "Geographical unit"
    },
    {
      "code": "ID-RI",
      "name": "Riau",
      "parent": "SM",
      "type": "Province"
    },
    {
      "code": "ID-SA",
      "name": "Sulawesi Utara",
      "parent": "SL",
      "type": "Province"
    },
    {
      "code": "ID-SB",
      "name": "Sumatera Barat",
      "parent": "SM",
      "type": "Province"
    },
    {
      "code": "ID-SG",
      "name": "Sulawesi Tenggara",
      "parent": "SL",
      "type": "Province"
    },
    {
      "code": "ID-SL",
      "name": "Sulawesi",
      "type": "Geographical unit"
    },
    {
      "code": "ID-SM",
      "name": "Sumatera",
      "type": "Geographical unit"
    },
    {
      "code": "ID-SN",
      "name": "Sulawesi Selatan",
      "parent": "SL",
      "type": "Province"
    },
    {
      "code": "ID-SR",
      "name": "Sulawesi Barat",
      "parent": "SL",
      "type": "Province"
    },
    {
      "code": "ID-SS",
      "name": "Sumatera Selatan",
      "parent": "SM",
      "type": "Province"
    },
    {
      "code": "ID-ST",
      "name": "Sulawesi Tengah",
      "parent": "SL",
      "type": "Province"
    },
    {
      "code": "ID-SU",
      "name": "Sumatera Utara",
      "parent": "SM",
      "type": "Province"
    },
    {
      "code": "ID-YO",
      "name": "Yogyakarta",
      "parent": "JW",
      "type": "Special region"
    },
    {
      "code": "IE-C",
      "name": "Connaught",
      "type": "Province"
    },
    {
      "code": "IE-CE",
      "name": "Clare",
      "parent": "M",
      "type": "County"
    },
    {
      "code": "IE-CN",
      "name": "Cavan",
      "parent": "U",
      "type": "County"
    },
    {
      "code": "IE-CO",
      "name": "Cork",
      "parent": "M",
      "type": "County"
    },
    {
      "code": "IE-CW",
      "name": "Carlow",
      "parent": "L",
      "type": "County"
    },
    {
      "code": "IE-D",
      "name": "Dublin",
      "parent": "L",
      "type": "County"
    },
    {
      "code": "IE-DL",
      "name": "Donegal",
      "parent": "U",
      "type": "County"
    },
    {
      "code": "IE-G",
      "name": "Galway",
      "parent": "C",
      "type": "County"
    },
    {
      "code": "IE-KE",
      "name": "Kildare",
      "parent": "L",
      "type": "County"
    },
    {
      "code": "IE-KK",
      "name": "Kilkenny",
      "parent": "L",
      "type": "County"
    },
    {
      "code": "IE-KY",
      "name": "Kerry",
      "parent": "M",
      "type": "County"
    },
    {
      "code": "IE-L",
      "name": "Leinster",
      "type": "Province"
    },
    {
      "code": "IE-LD",
      "name": "Longford",
      "parent": "L",
      "type": "County"
    },
    {
      "code": "IE-LH",
      "name": "Louth",
      "parent": "L",
      "type": "County"
    },
    {
      "code": "IE-LK",
      "name": "Limerick",
      "parent": "M",
      "type": "County"
    },
    {
      "code": "IE-LM",
      "name": "Leitrim",
      "parent": "C",
      "type": "County"
    },
    {
      "code": "IE-LS",
      "name": "Laois",
      "parent": "L",
      "type": "County"
    },
    {
      "code": "IE-M",
      "name": "Munster",
      "type": "Province"
    },
    {
      "code": "IE-MH",
      "name": "Meath",
      "parent": "L",
      "type": "County"
    },
    {
      "code": "IE-MN",
      "name": "Monaghan",
      "parent": "U",
      "type": "County"
    },
    {
      "code": "IE-MO",
      "name": "Mayo",
      "parent": "C",
      "type": "County"
    },
    {
      "code": "IE-OY",
      "name": "Offaly",
      "parent": "L",
      "type": "County"
    },
    {
      "code": "IE-RN",
      "name": "Roscommon",
      "parent": "C",
      "type": "County"
    },
    {
      "code": "IE-SO",
      "name": "Sligo",
      "parent": "C",
      "type": "County"
    },
    {
      "code": "IE-TA",
      "name": "Tipperary",
      "parent": "M",
      "type": "County"
    },
    {
      "code": "IE-U",
      "name": "Ulster",
      "type": "Province"
    },
    {
      "code": "IE-WD",
      "name": "Waterford",
      "parent": "M",
      "type": "County"
    },
    {
      "code": "IE-WH",
      "name": "Westmeath",
      "parent": "L",
      "type": "County"
    },
    {
      "code": "IE-WW",
      "name": "Wicklow",
      "parent": "L",
      "type": "County"
    },
    {
      "code": "IE-WX",
      "name": "Wexford",
      "parent": "L",
      "type": "County"
    },
    {
      "code": "IL-D",
      "name": "Al Janūbī",
      "type": "District"
    },
    {
      "code": "IL-HA",
      "name": "H̱efa",
      "type": "District"
    },
    {
      "code": "IL-JM",
      "name": "Al Quds",
      "type": "District"
    },
    {
      "code": "IL-M",
      "name": "Al Awsaţ",
      "type": "District"
    },
    {
      "code": "IL-TA",
      "name": "Tall Abīb",
      "type": "District"
    },
    {
      "code": "IL-Z",
      "name": "Ash Shamālī",
      "type": "District"
    },
    {
      "code": "IN-AN",
      "name": "Andaman and Nicobar Islands",
      "type": "Union territory"
    },
    {
      "code": "IN-AP",
      "name": "Andhra Pradesh",
      "type": "State"
    },
    {
      "code": "IN-AR",
      "name": "Arunāchal Pradesh",
      "type": "State"
    },
    {
      "code": "IN-AS",
      "name": "Assam",
      "type": "State"
    },
    {
      "code": "IN-BR",
      "name": "Bihār",
      "type": "State"
    },
    {
      "code": "IN-CH",
      "name": "Chandīgarh",
      "type": "Union territory"
    },
    {
      "code": "IN-CT",
      "name": "Chhattīsgarh",
      "type": "State"
    },
    {
      "code": "IN-DH",
      "name": "Dādra and Nagar Haveli and Damān and Diu",
      "type": "Union territory"
    },
    {
      "code": "IN-DL",
      "name": "Delhi",
      "type": "Union territory"
    },
    {
      "code": "IN-GA",
      "name": "Goa",
      "type": "State"
    },
    {
      "code": "IN-GJ",
      "name": "Gujarāt",
      "type": "State"
    },
    {
      "code": "IN-HP",
      "name": "Himāchal Pradesh",
      "type": "State"
    },
    {
      "code": "IN-HR",
      "name": "Haryāna",
      "type": "State"
    },
    {
      "code": "IN-JH",
      "name": "Jhārkhand",
      "type": "State"
    },
    {
      "code": "IN-JK",
      "name": "Jammu and Kashmīr",
      "type": "Union territory"
    },
    {
      "code": "IN-KA",
      "name": "Karnātaka",
      "type": "State"
    },
    {
      "code": "IN-KL",
      "name": "Kerala",
      "type": "State"
    },
    {
      "code": "IN-LA",
      "name": "Ladākh",
      "type": "Union territory"
    },
    {
      "code": "IN-LD",
      "name": "Lakshadweep",
      "type": "Union territory"
    },
    {
      "code": "IN-MH",
      "name": "Mahārāshtra",
      "type": "State"
    },
    {
      "code": "IN-ML",
      "name": "Meghālaya",
      "type": "State"
    },
    {
      "code": "IN-MN",
      "name": "Manipur",
      "type": "State"
    },
    {
      "code": "IN-MP",
      "name": "Madhya Pradesh",
      "type": "State"
    },
    {
      "code": "IN-MZ",
      "name": "Mizoram",
      "type": "State"
    },
    {
      "code": "IN-NL",
      "name": "Nāgāland",
      "type": "State"
    },
    {
      "code": "IN-OR",
      "name": "Odisha",
      "type": "State"
    },
    {
      "code": "IN-PB",
      "name": "Punjab",
      "type": "State"
    },
    {
      "code": "IN-PY",
      "name": "Puducherry",
      "type": "Union territory"
    },
    {
      "code": "IN-RJ",
      "name": "Rājasthān",
      "type": "State"
    },
    {
      "code": "IN-SK",
      "name": "Sikkim",
      "type": "State"
    },
    {
      "code": "IN-TG",
      "name": "Telangāna",
      "type": "State"
    },
    {
      "code": "IN-TN",
      "name": "Tamil Nādu",
      "type": "State"
    },
    {
      "code": "IN-TR",
      "name": "Tripura",
      "type": "State"
    },
    {
      "code": "IN-UP",
      "name": "Uttar Pradesh",
      "type": "State"
    },
    {
      "code": "IN-UT",
      "name": "Uttarākhand",
      "type": "State"
    },
    {
      "code": "IN-WB",
      "name": "West Bengal",
      "type": "State"
    },
    {
      "code": "IQ-AN",
      "name": "Al Anbār",
      "type": "Governorate"
    },
    {
      "code": "IQ-AR",
      "name": "Arbīl",
      "type": "Governorate"
    },
    {
      "code": "IQ-BA",
      "name": "Al Başrah",
      "type": "Governorate"
    },
    {
      "code": "IQ-BB",
      "name": "Bābil",
      "type": "Governorate"
    },
    {
      "code": "IQ-BG",
      "name": "Baghdād",
      "type": "Governorate"
    },
    {
      "code": "IQ-DA",
      "name": "Dahūk",
      "type": "Governorate"
    },
    {
      "code": "IQ-DI",
      "name": "Diyālá",
      "type": "Governorate"
    },
    {
      "code": "IQ-DQ",
      "name": "Dhī Qār",
      "type": "Governorate"
    },
    {
      "code": "IQ-KA",
      "name": "Karbalā’",
      "type": "Governorate"
    },
    {
      "code": "IQ-KI",
      "name": "Kirkūk",
      "type": "Governorate"
    },
    {
      "code": "IQ-MA",
      "name": "Maysān",
      "type": "Governorate"
    },
    {
      "code": "IQ-MU",
      "name": "Al Muthanná",
      "type": "Governorate"
    },
    {
      "code": "IQ-NA",
      "name": "An Najaf",
      "type": "Governorate"
    },
    {
      "code": "IQ-NI",
      "name": "Nīnawá",
      "type": "Governorate"
    },
    {
      "code": "IQ-QA",
      "name": "Al Qādisīyah",
      "type": "Governorate"
    },
    {
      "code": "IQ-SD",
      "name": "Şalāḩ ad Dīn",
      "type": "Governorate"
    },
    {
      "code": "IQ-SU",
      "name": "As Sulaymānīyah",
      "type": "Governorate"
    },
    {
      "code": "IQ-WA",
      "name": "Wāsiţ",
      "type": "Governorate"
    },
    {
      "code": "IR-00",
      "name": "Markazī",
      "type": "Province"
    },
    {
      "code": "IR-01",
      "name": "Gīlān",
      "type": "Province"
    },
    {
      "code": "IR-02",
      "name": "Māzandarān",
      "type": "Province"
    },
    {
      "code": "IR-03",
      "name": "Āz̄ārbāyjān-e Shārqī",
      "type": "Province"
    },
    {
      "code": "IR-04",
      "name": "Āz̄ārbāyjān-e Ghārbī",
      "type": "Province"
    },
    {
      "code": "IR-05",
      "name": "Kermānshāh",
      "type": "Province"
    },
    {
      "code": "IR-06",
      "name": "Khūzestān",
      "type": "Province"
    },
    {
      "code": "IR-07",
      "name": "Fārs",
      "type": "Province"
    },
    {
      "code": "IR-08",
      "name": "Kermān",
      "type": "Province"
    },
    {
      "code": "IR-09",
      "name": "Khorāsān-e Raẕavī",
      "type": "Province"
    },
    {
      "code": "IR-10",
      "name": "Eşfahān",
      "type": "Province"
    },
    {
      "code": "IR-11",
      "name": "Sīstān va Balūchestān",
      "type": "Province"
    },
    {
      "code": "IR-12",
      "name": "Kordestān",
      "type": "Province"
    },
    {
      "code": "IR-13",
      "name": "Hamadān",
      "type": "Province"
    },
    {
      "code": "IR-14",
      "name": "Chahār Maḩāl va Bakhtīārī",
      "type": "Province"
    },
    {
      "code": "IR-15",
      "name": "Lorestān",
      "type": "Province"
    },
    {
      "code": "IR-16",
      "name": "Īlām",
      "type": "Province"
    },
    {
      "code": "IR-17",
      "name": "Kohgīlūyeh va Bowyer Aḩmad",
      "type": "Province"
    },
    {
      "code": "IR-18",
      "name": "Būshehr",
      "type": "Province"
    },
    {
      "code": "IR-19",
      "name": "Zanjān",
      "type": "Province"
    },
    {
      "code": "IR-20",
      "name": "Semnān",
      "type": "Province"
    },
    {
      "code": "IR-21",
      "name": "Yazd",
      "type": "Province"
    },
    {
      "code": "IR-22",
      "name": "Hormozgān",
      "type": "Province"
    },
    {
      "code": "IR-23",
      "name": "Tehrān",
      "type": "Province"
    },
    {
      "code": "IR-24",
      "name": "Ardabīl",
      "type": "Province"
    },
    {
      "code": "IR-25",
      "name": "Qom",
      "type": "Province"
    },
    {
      "code": "IR-26",
      "name": "Qazvīn",
      "type": "Province"
    },
    {
      "code": "IR-27",
      "name": "Golestān",
      "type": "Province"
    },
    {
      "code": "IR-28",
      "name": "Khorāsān-e Shomālī",
      "type": "Province"
    },
    {
      "code": "IR-29",
      "name": "Khorāsān-e Jonūbī",
      "type": "Province"
    },
    {
      "code": "IR-30",
      "name": "Alborz",
      "type": "Province"
    },
    {
      "code": "IS-1",
      "name": "Höfuðborgarsvæði",
      "type": "Region"
    },
    {
      "code": "IS-2",
      "name": "Suðurnes",
      "type": "Region"
    },
    {
      "code": "IS-3",
      "name": "Vesturland",
      "type": "Region"
    },
    {
      "code": "IS-4",
      "name": "Vestfirðir",
      "type": "Region"
    },
    {
      "code": "IS-5",
      "name": "Norðurland vestra",
      "type": "Region"
    },
    {
      "code": "IS-6",
      "name": "Norðurland eystra",
      "type": "Region"
    },
    {
      "code": "IS-7",
      "name": "Austurland",
      "type": "Region"
    },
    {
      "code": "IS-8",
      "name": "Suðurland",
      "type": "Region"
    },
    {
      "code": "IS-AKH",
      "name": "Akrahreppur",
      "parent": "5",
      "type": "Municipality"
    },
    {
      "code": "IS-AKN",
      "name": "Akraneskaupstaður",
      "parent": "3",
      "type": "Municipality"
    },
    {
      "code": "IS-AKU",
      "name": "Akureyrarbær",
      "parent": "6",
      "type": "Municipality"
    },
    {
      "code": "IS-ARN",
      "name": "Árneshreppur",
      "parent": "4",
      "type": "Municipality"
    },
    {
      "code": "IS-ASA",
      "name": "Ásahreppur",
      "parent": "8",
      "type": "Municipality"
    },
    {
      "code": "IS-BFJ",
      "name": "Borgarfjarðarhreppur",
      "parent": "7",
      "type": "Municipality"
    },
    {
      "code": "IS-BLA",
      "name": "Bláskógabyggð",
      "parent": "8",
      "type": "Municipality"
    },
    {
      "code": "IS-BLO",
      "name": "Blönduósbær",
      "parent": "5",
      "type": "Municipality"
    },
    {
      "code": "IS-BOG",
      "name": "Borgarbyggð",
      "parent": "3",
      "type": "Municipality"
    },
    {
      "code": "IS-BOL",
      "name": "Bolungarvíkurkaupstaður",
      "parent": "4",
      "type": "Municipality"
    },
    {
      "code": "IS-DAB",
      "name": "Dalabyggð",
      "parent": "3",
      "type": "Municipality"
    },
    {
      "code": "IS-DAV",
      "name": "Dalvíkurbyggð",
      "parent": "6",
      "type": "Municipality"
    },
    {
      "code": "IS-DJU",
      "name": "Djúpavogshreppur",
      "parent": "7",
      "type": "Municipality"
    },
    {
      "code": "IS-EOM",
      "name": "Eyja- og Miklaholtshreppur",
      "parent": "3",
      "type": "Municipality"
    },
    {
      "code": "IS-EYF",
      "name": "Eyjafjarðarsveit",
      "parent": "6",
      "type": "Municipality"
    },
    {
      "code": "IS-FJD",
      "name": "Fjarðabyggð",
      "parent": "7",
      "type": "Municipality"
    },
    {
      "code": "IS-FJL",
      "name": "Fjallabyggð",
      "parent": "6",
      "type": "Municipality"
    },
    {
      "code": "IS-FLA",
      "name": "Flóahreppur",
      "parent": "8",
      "type": "Municipality"
    },
    {
      "code": "IS-FLD",
      "name": "Fljótsdalshérað",
      "parent": "7",
      "type": "Municipality"
    },
    {
      "code": "IS-FLR",
      "name": "Fljótsdalshreppur",
      "parent": "7",
      "type": "Municipality"
    },
    {
      "code": "IS-GAR",
      "name": "Garðabær",
      "parent": "1",
      "type": "Municipality"
    },
    {
      "code": "IS-GOG",
      "name": "Grímsnes- og Grafningshreppur",
      "parent": "8",
      "type": "Municipality"
    },
    {
      "code": "IS-GRN",
      "name": "Grindavíkurbær",
      "parent": "2",
      "type": "Municipality"
    },
    {
      "code": "IS-GRU",
      "name": "Grundarfjarðarbær",
      "parent": "3",
      "type": "Municipality"
    },
    {
      "code": "IS-GRY",
      "name": "Grýtubakkahreppur",
      "parent": "6",
      "type": "Municipality"
    },
    {
      "code": "IS-HAF",
      "name": "Hafnarfjarðarkaupstaður",
      "parent": "1",
      "type": "Municipality"
    },
    {
      "code": "IS-HEL",
      "name": "Helgafellssveit",
      "parent": "3",
      "type": "Municipality"
    },
    {
      "code": "IS-HRG",
      "name": "Hörgársveit",
      "parent": "6",
      "type": "Municipality"
    },
    {
      "code": "IS-HRU",
      "name": "Hrunamannahreppur",
      "parent": "8",
      "type": "Municipality"
    },
    {
      "code": "IS-HUT",
      "name": "Húnavatnshreppur",
      "parent": "5",
      "type": "Municipality"
    },
    {
      "code": "IS-HUV",
      "name": "Húnaþing vestra",
      "parent": "5",
      "type": "Municipality"
    },
    {
      "code": "IS-HVA",
      "name": "Hvalfjarðarsveit",
      "parent": "3",
      "type": "Municipality"
    },
    {
      "code": "IS-HVE",
      "name": "Hveragerðisbær",
      "parent": "8",
      "type": "Municipality"
    },
    {
      "code": "IS-ISA",
      "name": "Ísafjarðarbær",
      "parent": "4",
      "type": "Municipality"
    },
    {
      "code": "IS-KAL",
      "name": "Kaldrananeshreppur",
      "parent": "4",
      "type": "Municipality"
    },
    {
      "code": "IS-KJO",
      "name": "Kjósarhreppur",
      "parent": "1",
      "type": "Municipality"
    },
    {
      "code": "IS-KOP",
      "name": "Kópavogsbær",
      "parent": "1",
      "type": "Municipality"
    },
    {
      "code": "IS-LAN",
      "name": "Langanesbyggð",
      "parent": "6",
      "type": "Municipality"
    },
    {
      "code": "IS-MOS",
      "name": "Mosfellsbær",
      "parent": "1",
      "type": "Municipality"
    },
    {
      "code": "IS-MYR",
      "name": "Mýrdalshreppur",
      "parent": "8",
      "type": "Municipality"
    },
    {
      "code": "IS-NOR",
      "name": "Norðurþing",
      "parent": "6",
      "type": "Municipality"
    },
    {
      "code": "IS-RGE",
      "name": "Rangárþing eystra",
      "parent": "8",
      "type": "Municipality"
    },
    {
      "code": "IS-RGY",
      "name": "Rangárþing ytra",
      "parent": "8",
      "type": "Municipality"
    },
    {
      "code": "IS-RHH",
      "name": "Reykhólahreppur",
      "parent": "4",
      "type": "Municipality"
    },
    {
      "code": "IS-RKN",
      "name": "Reykjanesbær",
      "parent": "2",
      "type": "Municipality"
    },
    {
      "code": "IS-RKV",
      "name": "Reykjavíkurborg",
      "parent": "1",
      "type": "Municipality"
    },
    {
      "code": "IS-SBH",
      "name": "Svalbarðshreppur",
      "parent": "6",
      "type": "Municipality"
    },
    {
      "code": "IS-SBT",
      "name": "Svalbarðsstrandarhreppur",
      "parent": "6",
      "type": "Municipality"
    },
    {
      "code": "IS-SDN",
      "name": "Suðurnesjabær",
      "parent": "2",
      "type": "Municipality"
    },
    {
      "code": "IS-SDV",
      "name": "Súðavíkurhreppur",
      "parent": "4",
      "type": "Municipality"
    },
    {
      "code": "IS-SEL",
      "name": "Seltjarnarnesbær",
      "parent": "1",
      "type": "Municipality"
    },
    {
      "code": "IS-SEY",
      "name": "Seyðisfjarðarkaupstaður",
      "parent": "7",
      "type": "Municipality"
    },
    {
      "code": "IS-SFA",
      "name": "Sveitarfélagið Árborg",
      "parent": "8",
      "type": "Municipality"
    },
    {
      "code": "IS-SHF",
      "name": "Sveitarfélagið Hornafjörður",
      "parent": "7",
      "type": "Municipality"
    },
    {
      "code": "IS-SKF",
      "name": "Skaftárhreppur",
      "parent": "8",
      "type": "Municipality"
    },
    {
      "code": "IS-SKG",
      "name": "Skagabyggð",
      "parent": "5",
      "type": "Municipality"
    },
    {
      "code": "IS-SKO",
      "name": "Skorradalshreppur",
      "parent": "3",
      "type": "Municipality"
    },
    {
      "code": "IS-SKU",
      "name": "Skútustaðahreppur",
      "parent": "6",
      "type": "Municipality"
    },
    {
      "code": "IS-SNF",
      "name": "Snæfellsbær",
      "parent": "3",
      "type": "Municipality"
    },
    {
      "code": "IS-SOG",
      "name": "Skeiða- og Gnúpverjahreppur",
      "parent": "8",
      "type": "Municipality"
    },
    {
      "code": "IS-SOL",
      "name": "Sveitarfélagið Ölfus",
      "parent": "8",
      "type": "Municipality"
    },
    {
      "code": "IS-SSF",
      "name": "Sveitarfélagið Skagafjörður",
      "parent": "5",
      "type": "Municipality"
    },
    {
      "code": "IS-SSS",
      "name": "Sveitarfélagið Skagaströnd",
      "parent": "5",
      "type": "Municipality"
    },
    {
      "code": "IS-STR",
      "name": "Strandabyggð",
      "parent": "4",
      "type": "Municipality"
    },
    {
      "code": "IS-STY",
      "name": "Stykkishólmsbær",
      "parent": "3",
      "type": "Municipality"
    },
    {
      "code": "IS-SVG",
      "name": "Sveitarfélagið Vogar",
      "parent": "2",
      "type": "Municipality"
    },
    {
      "code": "IS-TAL",
      "name": "Tálknafjarðarhreppur",
      "parent": "4",
      "type": "Municipality"
    },
    {
      "code": "IS-THG",
      "name": "Þingeyjarsveit",
      "parent": "6",
      "type": "Municipality"
    },
    {
      "code": "IS-TJO",
      "name": "Tjörneshreppur",
      "parent": "6",
      "type": "Municipality"
    },
    {
      "code": "IS-VEM",
      "name": "Vestmannaeyjabær",
      "parent": "8",
      "type": "Municipality"
    },
    {
      "code": "IS-VER",
      "name": "Vesturbyggð",
      "parent": "4",
      "type": "Municipality"
    },
    {
      "code": "IS-VOP",
      "name": "Vopnafjarðarhreppur",
      "parent": "7",
      "type": "Municipality"
    },
    {
      "code": "IT-21",
      "name": "Piemonte",
      "type": "Region"
    },
    {
      "code": "IT-23",
      "name": "Val d'Aoste",
      "type": "Autonomous region"
    },
    {
      "code": "IT-25",
      "name": "Lombardia",
      "type": "Region"
    },
    {
      "code": "IT-32",
      "name": "Trentino-Alto Adige",
      "type": "Autonomous region"
    },
    {
      "code": "IT-34",
      "name": "Veneto",
      "type": "Region"
    },
    {
      "code": "IT-36",
      "name": "Friuli Venezia Giulia",
      "type": "Autonomous region"
    },
    {
      "code": "IT-42",
      "name": "Liguria",
      "type": "Region"
    },
    {
      "code": "IT-45",
      "name": "Emilia-Romagna",
      "type": "Region"
    },
    {
      "code": "IT-52",
      "name": "Toscana",
      "type": "Region"
    },
    {
      "code": "IT-55",
      "name": "Umbria",
      "type": "Region"
    },
    {
      "code": "IT-57",
      "name": "Marche",
      "type": "Region"
    },
    {
      "code": "IT-62",
      "name": "Lazio",
      "type": "Region"
    },
    {
      "code": "IT-65",
      "name": "Abruzzo",
      "type": "Region"
    },
    {
      "code": "IT-67",
      "name": "Molise",
      "type": "Region"
    },
    {
      "code": "IT-72",
      "name": "Campania",
      "type": "Region"
    },
    {
      "code": "IT-75",
      "name": "Puglia",
      "type": "Region"
    },
    {
      "code": "IT-77",
      "name": "Basilicata",
      "type": "Region"
    },
    {
      "code": "IT-78",
      "name": "Calabria",
      "type": "Region"
    },
    {
      "code": "IT-82",
      "name": "Sicilia",
      "type": "Autonomous region"
    },
    {
      "code": "IT-88",
      "name": "Sardegna",
      "type": "Autonomous region"
    },
    {
      "code": "IT-AG",
      "name": "Agrigento",
      "parent": "82",
      "type": "Free municipal consortium"
    },
    {
      "code": "IT-AL",
      "name": "Alessandria",
      "parent": "21",
      "type": "Province"
    },
    {
      "code": "IT-AN",
      "name": "Ancona",
      "parent": "57",
      "type": "Province"
    },
    {
      "code": "IT-AP",
      "name": "Ascoli Piceno",
      "parent": "57",
      "type": "Province"
    },
    {
      "code": "IT-AQ",
      "name": "L'Aquila",
      "parent": "65",
      "type": "Province"
    },
    {
      "code": "IT-AR",
      "name": "Arezzo",
      "parent": "52",
      "type": "Province"
    },
    {
      "code": "IT-AT",
      "name": "Asti",
      "parent": "21",
      "type": "Province"
    },
    {
      "code": "IT-AV",
      "name": "Avellino",
      "parent": "72",
      "type": "Province"
    },
    {
      "code": "IT-BA",
      "name": "Bari",
      "parent": "75",
      "type": "Metropolitan city"
    },
    {
      "code": "IT-BG",
      "name": "Bergamo",
      "parent": "25",
      "type": "Province"
    },
    {
      "code": "IT-BI",
      "name": "Biella",
      "parent": "21",
      "type": "Province"
    },
    {
      "code": "IT-BL",
      "name": "Belluno",
      "parent": "34",
      "type": "Province"
    },
    {
      "code": "IT-BN",
      "name": "Benevento",
      "parent": "72",
      "type": "Province"
    },
    {
      "code": "IT-BO",
      "name": "Bologna",
      "parent": "45",
      "type": "Metropolitan city"
    },
    {
      "code": "IT-BR",
      "name": "Brindisi",
      "parent": "75",
      "type": "Province"
    },
    {
      "code": "IT-BS",
      "name": "Brescia",
      "parent": "25",
      "type": "Province"
    },
    {
      "code": "IT-BT",
      "name": "Barletta-Andria-Trani",
      "parent": "75",
      "type": "Province"
    },
    {
      "code": "IT-BZ",
      "name": "Bolzano",
      "parent": "32",
      "type": "Autonomous province"
    },
    {
      "code": "IT-CA",
      "name": "Cagliari",
      "parent": "88",
      "type": "Metropolitan city"
    },
    {
      "code": "IT-CB",
      "name": "Campobasso",
      "parent": "67",
      "type": "Province"
    },
    {
      "code": "IT-CE",
      "name": "Caserta",
      "parent": "72",
      "type": "Province"
    },
    {
      "code": "IT-CH",
      "name": "Chieti",
      "parent": "65",
      "type": "Province"
    },
    {
      "code": "IT-CL",
      "name": "Caltanissetta",
      "parent": "82",
      "type": "Free municipal consortium"
    },
    {
      "code": "IT-CN",
      "name": "Cuneo",
      "parent": "21",
      "type": "Province"
    },
    {
      "code": "IT-CO",
      "name": "Como",
      "parent": "25",
      "type": "Province"
    },
    {
      "code": "IT-CR",
      "name": "Cremona",
      "parent": "25",
      "type": "Province"
    },
    {
      "code": "IT-CS",
      "name": "Cosenza",
      "parent": "78",
      "type": "Province"
    },
    {
      "code": "IT-CT",
      "name": "Catania",
      "parent": "82",
      "type": "Metropolitan city"
    },
    {
      "code": "IT-CZ",
      "name": "Catanzaro",
      "parent": "78",
      "type": "Province"
    },
    {
      "code": "IT-EN",
      "name": "Enna",
      "parent": "82",
      "type": "Free municipal consortium"
    },
    {
      "code": "IT-FC",
      "name": "Forlì-Cesena",
      "parent": "45",
      "type": "Province"
    },
    {
      "code": "IT-FE",
      "name": "Ferrara",
      "parent": "45",
      "type": "Province"
    },
    {
      "code": "IT-FG",
      "name": "Foggia",
      "parent": "75",
      "type": "Province"
    },
    {
      "code": "IT-FI",
      "name": "Firenze",
      "parent": "52",
      "type": "Metropolitan city"
    },
    {
      "code": "IT-FM",
      "name": "Fermo",
      "parent": "57",
      "type": "Province"
    },
    {
      "code": "IT-FR",
      "name": "Frosinone",
      "parent": "62",
      "type": "Province"
    },
    {
      "code": "IT-GE",
      "name": "Genova",
      "parent": "42",
      "type": "Metropolitan city"
    },
    {
      "code": "IT-GO",
      "name": "Gorizia",
      "parent": "36",
      "type": "Decentralized regional entity"
    },
    {
      "code": "IT-GR",
      "name": "Grosseto",
      "parent": "52",
      "type": "Province"
    },
    {
      "code": "IT-IM",
      "name": "Imperia",
      "parent": "42",
      "type": "Province"
    },
    {
      "code": "IT-IS",
      "name": "Isernia",
      "parent": "67",
      "type": "Province"
    },
    {
      "code": "IT-KR",
      "name": "Crotone",
      "parent": "78",
      "type": "Province"
    },
    {
      "code": "IT-LC",
      "name": "Lecco",
      "parent": "25",
      "type": "Province"
    },
    {
      "code": "IT-LE",
      "name": "Lecce",
      "parent": "75",
      "type": "Province"
    },
    {
      "code": "IT-LI",
      "name": "Livorno",
      "parent": "52",
      "type": "Province"
    },
    {
      "code": "IT-LO",
      "name": "Lodi",
      "parent": "25",
      "type": "Province"
    },
    {
      "code": "IT-LT",
      "name": "Latina",
      "parent": "62",
      "type": "Province"
    },
    {
      "code": "IT-LU",
      "name": "Lucca",
      "parent": "52",
      "type": "Province"
    },
    {
      "code": "IT-MB",
      "name": "Monza e Brianza",
      "parent": "25",
      "type": "Province"
    },
    {
      "code": "IT-MC",
      "name": "Macerata",
      "parent": "57",
      "type": "Province"
    },
    {
      "code": "IT-ME",
      "name": "Messina",
      "parent": "82",
      "type": "Metropolitan city"
    },
    {
      "code": "IT-MI",
      "name": "Milano",
      "parent": "25",
      "type": "Metropolitan city"
    },
    {
      "code": "IT-MN",
      "name": "Mantova",
      "parent": "25",
      "type": "Province"
    },
    {
      "code": "IT-MO",
      "name": "Modena",
      "parent": "45",
      "type": "Province"
    },
    {
      "code": "IT-MS",
      "name": "Massa-Carrara",
      "parent": "52",
      "type": "Province"
    },
    {
      "code": "IT-MT",
      "name": "Matera",
      "parent": "77",
      "type": "Province"
    },
    {
      "code": "IT-NA",
      "name": "Napoli",
      "parent": "72",
      "type": "Metropolitan city"
    },
    {
      "code": "IT-NO",
      "name": "Novara",
      "parent": "21",
      "type": "Province"
    },
    {
      "code": "IT-NU",
      "name": "Nuoro",
      "parent": "88",
      "type": "Province"
    },
    {
      "code": "IT-OR",
      "name": "Oristano",
      "parent": "88",
      "type": "Province"
    },
    {
      "code": "IT-PA",
      "name": "Palermo",
      "parent": "82",
      "type": "Metropolitan city"
    },
    {
      "code": "IT-PC",
      "name": "Piacenza",
      "parent": "45",
      "type": "Province"
    },
    {
      "code": "IT-PD",
      "name": "Padova",
      "parent": "34",
      "type": "Province"
    },
    {
      "code": "IT-PE",
      "name": "Pescara",
      "parent": "65",
      "type": "Province"
    },
    {
      "code": "IT-PG",
      "name": "Perugia",
      "parent": "55",
      "type": "Province"
    },
    {
      "code": "IT-PI",
      "name": "Pisa",
      "parent": "52",
      "type": "Province"
    },
    {
      "code": "IT-PN",
      "name": "Pordenone",
      "parent": "36",
      "type": "Decentralized regional entity"
    },
    {
      "code": "IT-PO",
      "name": "Prato",
      "parent": "52",
      "type": "Province"
    },
    {
      "code": "IT-PR",
      "name": "Parma",
      "parent": "45",
      "type": "Province"
    },
    {
      "code": "IT-PT",
      "name": "Pistoia",
      "parent": "52",
      "type": "Province"
    },
    {
      "code": "IT-PU",
      "name": "Pesaro e Urbino",
      "parent": "57",
      "type": "Province"
    },
    {
      "code": "IT-PV",
      "name": "Pavia",
      "parent": "25",
      "type": "Province"
    },
    {
      "code": "IT-PZ",
      "name": "Potenza",
      "parent": "77",
      "type": "Province"
    },
    {
      "code": "IT-RA",
      "name": "Ravenna",
      "parent": "45",
      "type": "Province"
    },
    {
      "code": "IT-RC",
      "name": "Reggio Calabria",
      "parent": "78",
      "type": "Metropolitan city"
    },
    {
      "code": "IT-RE",
      "name": "Reggio Emilia",
      "parent": "45",
      "type": "Province"
    },
    {
      "code": "IT-RG",
      "name": "Ragusa",
      "parent": "82",
      "type": "Free municipal consortium"
    },
    {
      "code": "IT-RI",
      "name": "Rieti",
      "parent": "62",
      "type": "Province"
    },
    {
      "code": "IT-RM",
      "name": "Roma",
      "parent": "62",
      "type": "Metropolitan city"
    },
    {
      "code": "IT-RN",
      "name": "Rimini",
      "parent": "45",
      "type": "Province"
    },
    {
      "code": "IT-RO",
      "name": "Rovigo",
      "parent": "34",
      "type": "Province"
    },
    {
      "code": "IT-SA",
      "name": "Salerno",
      "parent": "72",
      "type": "Province"
    },
    {
      "code": "IT-SI",
      "name": "Siena",
      "parent": "52",
      "type": "Province"
    },
    {
      "code": "IT-SO",
      "name": "Sondrio",
      "parent": "25",
      "type": "Province"
    },
    {
      "code": "IT-SP",
      "name": "La Spezia",
      "parent": "42",
      "type": "Province"
    },
    {
      "code": "IT-SR",
      "name": "Siracusa",
      "parent": "82",
      "type": "Free municipal consortium"
    },
    {
      "code": "IT-SS",
      "name": "Sassari",
      "parent": "88",
      "type": "Province"
    },
    {
      "code": "IT-SU",
      "name": "Sud Sardegna",
      "parent": "88",
      "type": "Province"
    },
    {
      "code": "IT-SV",
      "name": "Savona",
      "parent": "42",
      "type": "Province"
    },
    {
      "code": "IT-TA",
      "name": "Taranto",
      "parent": "75",
      "type": "Province"
    },
    {
      "code": "IT-TE",
      "name": "Teramo",
      "parent": "65",
      "type": "Province"
    },
    {
      "code": "IT-TN",
      "name": "Trento",
      "parent": "32",
      "type": "Autonomous province"
    },
    {
      "code": "IT-TO",
      "name": "Torino",
      "parent": "21",
      "type": "Metropolitan city"
    },
    {
      "code": "IT-TP",
      "name": "Trapani",
      "parent": "82",
      "type": "Free municipal consortium"
    },
    {
      "code": "IT-TR",
      "name": "Terni",
      "parent": "55",
      "type": "Province"
    },
    {
      "code": "IT-TS",
      "name": "Trieste",
      "parent": "36",
      "type": "Decentralized regional entity"
    },
    {
      "code": "IT-TV",
      "name": "Treviso",
      "parent": "34",
      "type": "Province"
    },
    {
      "code": "IT-UD",
      "name": "Udine",
      "parent": "36",
      "type": "Decentralized regional entity"
    },
    {
      "code": "IT-VA",
      "name": "Varese",
      "parent": "25",
      "type": "Province"
    },
    {
      "code": "IT-VB",
      "name": "Verbano-Cusio-Ossola",
      "parent": "21",
      "type": "Province"
    },
    {
      "code": "IT-VC",
      "name": "Vercelli",
      "parent": "21",
      "type": "Province"
    },
    {
      "code": "IT-VE",
      "name": "Venezia",
      "parent": "34",
      "type": "Metropolitan city"
    },
    {
      "code": "IT-VI",
      "name": "Vicenza",
      "parent": "34",
      "type": "Province"
    },
    {
      "code": "IT-VR",
      "name": "Verona",
      "parent": "34",
      "type": "Province"
    },
    {
      "code": "IT-VT",
      "name": "Viterbo",
      "parent": "62",
      "type": "Province"
    },
    {
      "code": "IT-VV",
      "name": "Vibo Valentia",
      "parent": "78",
      "type": "Province"
    },
    {
      "code": "JM-01",
      "name": "Kingston",
      "type": "Parish"
    },
    {
      "code": "JM-02",
      "name": "Saint Andrew",
      "type": "Parish"
    },
    {
      "code": "JM-03",
      "name": "Saint Thomas",
      "type": "Parish"
    },
    {
      "code": "JM-04",
      "name": "Portland",
      "type": "Parish"
    },
    {
      "code": "JM-05",
      "name": "Saint Mary",
      "type": "Parish"
    },
    {
      "code": "JM-06",
      "name": "Saint Ann",
      "type": "Parish"
    },
    {
      "code": "JM-07",
      "name": "Trelawny",
      "type": "Parish"
    },
    {
      "code": "JM-08",
      "name": "Saint James",
      "type": "Parish"
    },
    {
      "code": "JM-09",
      "name": "Hanover",
      "type": "Parish"
    },
    {
      "code": "JM-10",
      "name": "Westmoreland",
      "type": "Parish"
    },
    {
      "code": "JM-11",
      "name": "Saint Elizabeth",
      "type": "Parish"
    },
    {
      "code": "JM-12",
      "name": "Manchester",
      "type": "Parish"
    },
    {
      "code": "JM-13",
      "name": "Clarendon",
      "type": "Parish"
    },
    {
      "code": "JM-14",
      "name": "Saint Catherine",
      "type": "Parish"
    },
    {
      "code": "JO-AJ",
      "name": "‘Ajlūn",
      "type": "Governorate"
    },
    {
      "code": "JO-AM",
      "name": "Al ‘A̅şimah",
      "type": "Governorate"
    },
    {
      "code": "JO-AQ",
      "name": "Al ‘Aqabah",
      "type": "Governorate"
    },
    {
      "code": "JO-AT",
      "name": "Aţ Ţafīlah",
      "type": "Governorate"
    },
    {
      "code": "JO-AZ",
      "name": "Az Zarqā’",
      "type": "Governorate"
    },
    {
      "code": "JO-BA",
      "name": "Al Balqā’",
      "type": "Governorate"
    },
    {
      "code": "JO-IR",
      "name": "Irbid",
      "type": "Governorate"
    },
    {
      "code": "JO-JA",
      "name": "Jarash",
      "type": "Governorate"
    },
    {
      "code": "JO-KA",
      "name": "Al Karak",
      "type": "Governorate"
    },
    {
      "code": "JO-MA",
      "name": "Al Mafraq",
      "type": "Governorate"
    },
    {
      "code": "JO-MD",
      "name": "Mādabā",
      "type": "Governorate"
    },
    {
      "code": "JO-MN",
      "name": "Ma‘ān",
      "type": "Governorate"
    },
    {
      "code": "JP-01",
      "name": "Hokkaido",
      "type": "Prefecture"
    },
    {
      "code": "JP-02",
      "name": "Aomori",
      "type": "Prefecture"
    },
    {
      "code": "JP-03",
      "name": "Iwate",
      "type": "Prefecture"
    },
    {
      "code": "JP-04",
      "name": "Miyagi",
      "type": "Prefecture"
    },
    {
      "code": "JP-05",
      "name": "Akita",
      "type": "Prefecture"
    },
    {
      "code": "JP-06",
      "name": "Yamagata",
      "type": "Prefecture"
    },
    {
      "code": "JP-07",
      "name": "Fukushima",
      "type": "Prefecture"
    },
    {
      "code": "JP-08",
      "name": "Ibaraki",
      "type": "Prefecture"
    },
    {
      "code": "JP-09",
      "name": "Tochigi",
      "type": "Prefecture"
    },
    {
      "code": "JP-10",
      "name": "Gunma",
      "type": "Prefecture"
    },
    {
      "code": "JP-11",
      "name": "Saitama",
      "type": "Prefecture"
    },
    {
      "code": "JP-12",
      "name": "Chiba",
      "type": "Prefecture"
    },
    {
      "code": "JP-13",
      "name": "Tokyo",
      "type": "Prefecture"
    },
    {
      "code": "JP-14",
      "name": "Kanagawa",
      "type": "Prefecture"
    },
    {
      "code": "JP-15",
      "name": "Niigata",
      "type": "Prefecture"
    },
    {
      "code": "JP-16",
      "name": "Toyama",
      "type": "Prefecture"
    },
    {
      "code": "JP-17",
      "name": "Ishikawa",
      "type": "Prefecture"
    },
    {
      "code": "JP-18",
      "name": "Fukui",
      "type": "Prefecture"
    },
    {
      "code": "JP-19",
      "name": "Yamanashi",
      "type": "Prefecture"
    },
    {
      "code": "JP-20",
      "name": "Nagano",
      "type": "Prefecture"
    },
    {
      "code": "JP-21",
      "name": "Gifu",
      "type": "Prefecture"
    },
    {
      "code": "JP-22",
      "name": "Shizuoka",
      "type": "Prefecture"
    },
    {
      "code": "JP-23",
      "name": "Aichi",
      "type": "Prefecture"
    },
    {
      "code": "JP-24",
      "name": "Mie",
      "type": "Prefecture"
    },
    {
      "code": "JP-25",
      "name": "Shiga",
      "type": "Prefecture"
    },
    {
      "code": "JP-26",
      "name": "Kyoto",
      "type": "Prefecture"
    },
    {
      "code": "JP-27",
      "name": "Osaka",
      "type": "Prefecture"
    },
    {
      "code": "JP-28",
      "name": "Hyogo",
      "type": "Prefecture"
    },
    {
      "code": "JP-29",
      "name": "Nara",
      "type": "Prefecture"
    },
    {
      "code": "JP-30",
      "name": "Wakayama",
      "type": "Prefecture"
    },
    {
      "code": "JP-31",
      "name": "Tottori",
      "type": "Prefecture"
    },
    {
      "code": "JP-32",
      "name": "Shimane",
      "type": "Prefecture"
    },
    {
      "code": "JP-33",
      "name": "Okayama",
      "type": "Prefecture"
    },
    {
      "code": "JP-34",
      "name": "Hiroshima",
      "type": "Prefecture"
    },
    {
      "code": "JP-35",
      "name": "Yamaguchi",
      "type": "Prefecture"
    },
    {
      "code": "JP-36",
      "name": "Tokushima",
      "type": "Prefecture"
    },
    {
      "code": "JP-37",
      "name": "Kagawa",
      "type": "Prefecture"
    },
    {
      "code": "JP-38",
      "name": "Ehime",
      "type": "Prefecture"
    },
    {
      "code": "JP-39",
      "name": "Kochi",
      "type": "Prefecture"
    },
    {
      "code": "JP-40",
      "name": "Fukuoka",
      "type": "Prefecture"
    },
    {
      "code": "JP-41",
      "name": "Saga",
      "type": "Prefecture"
    },
    {
      "code": "JP-42",
      "name": "Nagasaki",
      "type": "Prefecture"
    },
    {
      "code": "JP-43",
      "name": "Kumamoto",
      "type": "Prefecture"
    },
    {
      "code": "JP-44",
      "name": "Oita",
      "type": "Prefecture"
    },
    {
      "code": "JP-45",
      "name": "Miyazaki",
      "type": "Prefecture"
    },
    {
      "code": "JP-46",
      "name": "Kagoshima",
      "type": "Prefecture"
    },
    {
      "code": "JP-47",
      "name": "Okinawa",
      "type": "Prefecture"
    },
    {
      "code": "KE-01",
      "name": "Baringo",
      "type": "County"
    },
    {
      "code": "KE-02",
      "name": "Bomet",
      "type": "County"
    },
    {
      "code": "KE-03",
      "name": "Bungoma",
      "type": "County"
    },
    {
      "code": "KE-04",
      "name": "Busia",
      "type": "County"
    },
    {
      "code": "KE-05",
      "name": "Elgeyo/Marakwet",
      "type": "County"
    },
    {
      "code": "KE-06",
      "name": "Embu",
      "type": "County"
    },
    {
      "code": "KE-07",
      "name": "Garissa",
      "type": "County"
    },
    {
      "code": "KE-08",
      "name": "Homa Bay",
      "type": "County"
    },
    {
      "code": "KE-09",
      "name": "Isiolo",
      "type": "County"
    },
    {
      "code": "KE-10",
      "name": "Kajiado",
      "type": "County"
    },
    {
      "code": "KE-11",
      "name": "Kakamega",
      "type": "County"
    },
    {
      "code": "KE-12",
      "name": "Kericho",
      "type": "County"
    },
    {
      "code": "KE-13",
      "name": "Kiambu",
      "type": "County"
    },
    {
      "code": "KE-14",
      "name": "Kilifi",
      "type": "County"
    },
    {
      "code": "KE-15",
      "name": "Kirinyaga",
      "type": "County"
    },
    {
      "code": "KE-16",
      "name": "Kisii",
      "type": "County"
    },
    {
      "code": "KE-17",
      "name": "Kisumu",
      "type": "County"
    },
    {
      "code": "KE-18",
      "name": "Kitui",
      "type": "County"
    },
    {
      "code": "KE-19",
      "name": "Kwale",
      "type": "County"
    },
    {
      "code": "KE-20",
      "name": "Laikipia",
      "type": "County"
    },
    {
      "code": "KE-21",
      "name": "Lamu",
      "type": "County"
    },
    {
      "code": "KE-22",
      "name": "Machakos",
      "type": "County"
    },
    {
      "code": "KE-23",
      "name": "Makueni",
      "type": "County"
    },
    {
      "code": "KE-24",
      "name": "Mandera",
      "type": "County"
    },
    {
      "code": "KE-25",
      "name": "Marsabit",
      "type": "County"
    },
    {
      "code": "KE-26",
      "name": "Meru",
      "type": "County"
    },
    {
      "code": "KE-27",
      "name": "Migori",
      "type": "County"
    },
    {
      "code": "KE-28",
      "name": "Mombasa",
      "type": "County"
    },
    {
      "code": "KE-29",
      "name": "Murang'a",
      "type": "County"
    },
    {
      "code": "KE-30",
      "name": "Nairobi City",
      "type": "County"
    },
    {
      "code": "KE-31",
      "name": "Nakuru",
      "type": "County"
    },
    {
      "code": "KE-32",
      "name": "Nandi",
      "type": "County"
    },
    {
      "code": "KE-33",
      "name": "Narok",
      "type": "County"
    },
    {
      "code": "KE-34",
      "name": "Nyamira",
      "type": "County"
    },
    {
      "code": "KE-35",
      "name": "Nyandarua",
      "type": "County"
    },
    {
      "code": "KE-36",
      "name": "Nyeri",
      "type": "County"
    },
    {
      "code": "KE-37",
      "name": "Samburu",
      "type": "County"
    },
    {
      "code": "KE-38",
      "name": "Siaya",
      "type": "County"
    },
    {
      "code": "KE-39",
      "name": "Taita/Taveta",
      "type": "County"
    },
    {
      "code": "KE-40",
      "name": "Tana River",
      "type": "County"
    },
    {
      "code": "KE-41",
      "name": "Tharaka-Nithi",
      "type": "County"
    },
    {
      "code": "KE-42",
      "name": "Trans Nzoia",
      "type": "County"
    },
    {
      "code": "KE-43",
      "name": "Turkana",
      "type": "County"
    },
    {
      "code": "KE-44",
      "name": "Uasin Gishu",
      "type": "County"
    },
    {
      "code": "KE-45",
      "name": "Vihiga",
      "type": "County"
    },
    {
      "code": "KE-46",
      "name": "Wajir",
      "type": "County"
    },
    {
      "code": "KE-47",
      "name": "West Pokot",
      "type": "County"
    },
    {
      "code": "KG-B",
      "name": "Batken",
      "type": "Region"
    },
    {
      "code": "KG-C",
      "name": "Chuyskaya oblast'",
      "type": "Region"
    },
    {
      "code": "KG-GB",
      "name": "Bishkek Shaary",
      "type": "City"
    },
    {
      "code": "KG-GO",
      "name": "Gorod Osh",
      "type": "City"
    },
    {
      "code": "KG-J",
      "name": "Dzhalal-Abadskaya oblast'",
      "type": "Region"
    },
    {
      "code": "KG-N",
      "name": "Naryn",
      "type": "Region"
    },
    {
      "code": "KG-O",
      "name": "Osh",
      "type": "Region"
    },
    {
      "code": "KG-T",
      "name": "Talas",
      "type": "Region"
    },
    {
      "code": "KG-Y",
      "name": "Issyk-Kul'skaja oblast'",
      "type": "Region"
    },
    {
      "code": "KH-1",
      "name": "Banteay Mean Choăy",
      "type": "Province"
    },
    {
      "code": "KH-10",
      "name": "Kracheh",
      "type": "Province"
    },
    {
      "code": "KH-11",
      "name": "Mondol Kiri",
      "type": "Province"
    },
    {
      "code": "KH-12",
      "name": "Phnom Penh",
      "type": "Autonomous municipality"
    },
    {
      "code": "KH-13",
      "name": "Preah Vihear",
      "type": "Province"
    },
    {
      "code": "KH-14",
      "name": "Prey Veaeng",
      "type": "Province"
    },
    {
      "code": "KH-15",
      "name": "Pousaat",
      "type": "Province"
    },
    {
      "code": "KH-16",
      "name": "Rotanak Kiri",
      "type": "Province"
    },
    {
      "code": "KH-17",
      "name": "Siem Reab",
      "type": "Province"
    },
    {
      "code": "KH-18",
      "name": "Preah Sihanouk",
      "type": "Province"
    },
    {
      "code": "KH-19",
      "name": "Stoĕng Trêng",
      "type": "Province"
    },
    {
      "code": "KH-2",
      "name": "Baat Dambang",
      "type": "Province"
    },
    {
      "code": "KH-20",
      "name": "Svaay Rieng",
      "type": "Province"
    },
    {
      "code": "KH-21",
      "name": "Taakaev",
      "type": "Province"
    },
    {
      "code": "KH-22",
      "name": "Otdar Mean Chey",
      "type": "Province"
    },
    {
      "code": "KH-23",
      "name": "Kaeb",
      "type": "Province"
    },
    {
      "code": "KH-24",
      "name": "Pailin",
      "type": "Province"
    },
    {
      "code": "KH-25",
      "name": "Tbong Khmum",
      "type": "Province"
    },
    {
      "code": "KH-3",
      "name": "Kampong Chaam",
      "type": "Province"
    },
    {
      "code": "KH-4",
      "name": "Kampong Chhnang",
      "type": "Province"
    },
    {
      "code": "KH-5",
      "name": "Kampong Spueu",
      "type": "Province"
    },
    {
      "code": "KH-6",
      "name": "Kampong Thum",
      "type": "Province"
    },
    {
      "code": "KH-7",
      "name": "Kampot",
      "type": "Province"
    },
    {
      "code": "KH-8",
      "name": "Kandaal",
      "type": "Province"
    },
    {
      "code": "KH-9",
      "name": "Kaoh Kong",
      "type": "Province"
    },
    {
      "code": "KI-G",
      "name": "Gilbert Islands",
      "type": "Group of islands (20 inhabited islands)"
    },
    {
      "code": "KI-L",
      "name": "Line Islands",
      "type": "Group of islands (20 inhabited islands)"
    },
    {
      "code": "KI-P",
      "name": "Phoenix Islands",
      "type": "Group of islands (20 inhabited islands)"
    },
    {
      "code": "KM-A",
      "name": "Andjouân",
      "type": "Island"
    },
    {
      "code": "KM-G",
      "name": "Andjazîdja",
      "type": "Island"
    },
    {
      "code": "KM-M",
      "name": "Mohéli",
      "type": "Island"
    },
    {
      "code": "KN-01",
      "name": "Christ Church Nichola Town",
      "parent": "K",
      "type": "Parish"
    },
    {
      "code": "KN-02",
      "name": "Saint Anne Sandy Point",
      "parent": "K",
      "type": "Parish"
    },
    {
      "code": "KN-03",
      "name": "Saint George Basseterre",
      "parent": "K",
      "type": "Parish"
    },
    {
      "code": "KN-04",
      "name": "Saint George Gingerland",
      "parent": "N",
      "type": "Parish"
    },
    {
      "code": "KN-05",
      "name": "Saint James Windward",
      "parent": "N",
      "type": "Parish"
    },
    {
      "code": "KN-06",
      "name": "Saint John Capisterre",
      "parent": "K",
      "type": "Parish"
    },
    {
      "code": "KN-07",
      "name": "Saint John Figtree",
      "parent": "N",
      "type": "Parish"
    },
    {
      "code": "KN-08",
      "name": "Saint Mary Cayon",
      "parent": "K",
      "type": "Parish"
    },
    {
      "code": "KN-09",
      "name": "Saint Paul Capisterre",
      "parent": "K",
      "type": "Parish"
    },
    {
      "code": "KN-10",
      "name": "Saint Paul Charlestown",
      "parent": "N",
      "type": "Parish"
    },
    {
      "code": "KN-11",
      "name": "Saint Peter Basseterre",
      "parent": "K",
      "type": "Parish"
    },
    {
      "code": "KN-12",
      "name": "Saint Thomas Lowland",
      "parent": "N",
      "type": "Parish"
    },
    {
      "code": "KN-13",
      "name": "Saint Thomas Middle Island",
      "parent": "K",
      "type": "Parish"
    },
    {
      "code": "KN-15",
      "name": "Trinity Palmetto Point",
      "parent": "K",
      "type": "Parish"
    },
    {
      "code": "KN-K",
      "name": "Saint Kitts",
      "type": "State"
    },
    {
      "code": "KN-N",
      "name": "Nevis",
      "type": "State"
    },
    {
      "code": "KP-01",
      "name": "P'yǒngyang",
      "type": "Capital city"
    },
    {
      "code": "KP-02",
      "name": "P'yǒngan-namdo",
      "type": "Province"
    },
    {
      "code": "KP-03",
      "name": "P'yǒngan-bukto",
      "type": "Province"
    },
    {
      "code": "KP-04",
      "name": "Chagang-do",
      "type": "Province"
    },
    {
      "code": "KP-05",
      "name": "Hwanghae-namdo",
      "type": "Province"
    },
    {
      "code": "KP-06",
      "name": "Hwanghae-bukto",
      "type": "Province"
    },
    {
      "code": "KP-07",
      "name": "Kangweonto",
      "type": "Province"
    },
    {
      "code": "KP-08",
      "name": "Hamgyǒng-namdo",
      "type": "Province"
    },
    {
      "code": "KP-09",
      "name": "Hamgyǒng-bukto",
      "type": "Province"
    },
    {
      "code": "KP-10",
      "name": "Ryanggang-do",
      "type": "Province"
    },
    {
      "code": "KP-13",
      "name": "Raseon",
      "type": "Special city"
    },
    {
      "code": "KP-14",
      "name": "Nampho",
      "type": "Metropolitan city"
    },
    {
      "code": "KR-11",
      "name": "Seoul-teukbyeolsi",
      "type": "Special city"
    },
    {
      "code": "KR-26",
      "name": "Busan-gwangyeoksi",
      "type": "Metropolitan city"
    },
    {
      "code": "KR-27",
      "name": "Daegu-gwangyeoksi",
      "type": "Metropolitan city"
    },
    {
      "code": "KR-28",
      "name": "Incheon-gwangyeoksi",
      "type": "Metropolitan city"
    },
    {
      "code": "KR-29",
      "name": "Gwangju-gwangyeoksi",
      "type": "Metropolitan city"
    },
    {
      "code": "KR-30",
      "name": "Daejeon-gwangyeoksi",
      "type": "Metropolitan city"
    },
    {
      "code": "KR-31",
      "name": "Ulsan-gwangyeoksi",
      "type": "Metropolitan city"
    },
    {
      "code": "KR-41",
      "name": "Gyeonggi-do",
      "type": "Province"
    },
    {
      "code": "KR-42",
      "name": "Gangwon-do",
      "type": "Province"
    },
    {
      "code": "KR-43",
      "name": "Chungcheongbuk-do",
      "type": "Province"
    },
    {
      "code": "KR-44",
      "name": "Chungcheongnam-do",
      "type": "Province"
    },
    {
      "code": "KR-45",
      "name": "Jeollabuk-do",
      "type": "Province"
    },
    {
      "code": "KR-46",
      "name": "Jeollanam-do",
      "type": "Province"
    },
    {
      "code": "KR-47",
      "name": "Gyeongsangbuk-do",
      "type": "Province"
    },
    {
      "code": "KR-48",
      "name": "Gyeongsangnam-do",
      "type": "Province"
    },
    {
      "code": "KR-49",
      "name": "Jeju-teukbyeoljachido",
      "type": "Special self-governing province"
    },
    {
      "code": "KR-50",
      "name": "Sejong",
      "type": "Special self-governing city"
    },
    {
      "code": "KW-AH",
      "name": "Al Aḩmadī",
      "type": "Governorate"
    },
    {
      "code": "KW-FA",
      "name": "Al Farwānīyah",
      "type": "Governorate"
    },
    {
      "code": "KW-HA",
      "name": "Ḩawallī",
      "type": "Governorate"
    },
    {
      "code": "KW-JA",
      "name": "Al Jahrā’",
      "type": "Governorate"
    },
    {
      "code": "KW-KU",
      "name": "Al ‘Āşimah",
      "type": "Governorate"
    },
    {
      "code": "KW-MU",
      "name": "Mubārak al Kabīr",
      "type": "Governorate"
    },
    {
      "code": "KZ-AKM",
      "name": "Akmolinskaja oblast'",
      "type": "Region"
    },
    {
      "code": "KZ-AKT",
      "name": "Aktjubinskaja oblast'",
      "type": "Region"
    },
    {
      "code": "KZ-ALA",
      "name": "Almaty",
      "type": "City"
    },
    {
      "code": "KZ-ALM",
      "name": "Almatinskaja oblast'",
      "type": "Region"
    },
    {
      "code": "KZ-AST",
      "name": "Nur-Sultan",
      "type": "City"
    },
    {
      "code": "KZ-ATY",
      "name": "Atyrauskaja oblast'",
      "type": "Region"
    },
    {
      "code": "KZ-KAR",
      "name": "Karagandinskaja oblast'",
      "type": "Region"
    },
    {
      "code": "KZ-KUS",
      "name": "Kostanajskaja oblast'",
      "type": "Region"
    },
    {
      "code": "KZ-KZY",
      "name": "Kyzylordinskaja oblast'",
      "type": "Region"
    },
    {
      "code": "KZ-MAN",
      "name": "Mangghystaū oblysy",
      "type": "Region"
    },
    {
      "code": "KZ-PAV",
      "name": "Pavlodar oblysy",
      "type": "Region"
    },
    {
      "code": "KZ-SEV",
      "name": "Severo-Kazahstanskaja oblast'",
      "type": "Region"
    },
    {
      "code": "KZ-SHY",
      "name": "Shymkent",
      "type": "City"
    },
    {
      "code": "KZ-VOS",
      "name": "Shyghys Qazaqstan oblysy",
      "type": "Region"
    },
    {
      "code": "KZ-YUZ",
      "name": "Turkestankaya oblast'",
      "type": "Region"
    },
    {
      "code": "KZ-ZAP",
      "name": "Batys Qazaqstan oblysy",
      "type": "Region"
    },
    {
      "code": "KZ-ZHA",
      "name": "Zhambyl oblysy",
      "type": "Region"
    },
    {
      "code": "LA-AT",
      "name": "Attapu",
      "type": "Province"
    },
    {
      "code": "LA-BK",
      "name": "Bokèo",
      "type": "Province"
    },
    {
      "code": "LA-BL",
      "name": "Bolikhamxai",
      "type": "Province"
    },
    {
      "code": "LA-CH",
      "name": "Champasak",
      "type": "Province"
    },
    {
      "code": "LA-HO",
      "name": "Houaphan",
      "type": "Province"
    },
    {
      "code": "LA-KH",
      "name": "Khammouan",
      "type": "Province"
    },
    {
      "code": "LA-LM",
      "name": "Louang Namtha",
      "type": "Province"
    },
    {
      "code": "LA-LP",
      "name": "Louangphabang",
      "type": "Province"
    },
    {
      "code": "LA-OU",
      "name": "Oudômxai",
      "type": "Province"
    },
    {
      "code": "LA-PH",
      "name": "Phôngsali",
      "type": "Province"
    },
    {
      "code": "LA-SL",
      "name": "Salavan",
      "type": "Province"
    },
    {
      "code": "LA-SV",
      "name": "Savannakhét",
      "type": "Province"
    },
    {
      "code": "LA-VI",
      "name": "Viangchan",
      "type": "Province"
    },
    {
      "code": "LA-VT",
      "name": "Viangchan",
      "type": "Prefecture"
    },
    {
      "code": "LA-XA",
      "name": "Xaignabouli",
      "type": "Province"
    },
    {
      "code": "LA-XE",
      "name": "Xékong",
      "type": "Province"
    },
    {
      "code": "LA-XI",
      "name": "Xiangkhouang",
      "type": "Province"
    },
    {
      "code": "LA-XS",
      "name": "Xaisômboun",
      "type": "Province"
    },
    {
      "code": "LB-AK",
      "name": "Aakkâr",
      "type": "Governorate"
    },
    {
      "code": "LB-AS",
      "name": "Ash Shimāl",
      "type": "Governorate"
    },
    {
      "code": "LB-BA",
      "name": "Bayrūt",
      "type": "Governorate"
    },
    {
      "code": "LB-BH",
      "name": "Baalbek-Hermel",
      "type": "Governorate"
    },
    {
      "code": "LB-BI",
      "name": "Al Biqā‘",
      "type": "Governorate"
    },
    {
      "code": "LB-JA",
      "name": "Al Janūb",
      "type": "Governorate"
    },
    {
      "code": "LB-JL",
      "name": "Jabal Lubnān",
      "type": "Governorate"
    },
    {
      "code": "LB-NA",
      "name": "An Nabaţīyah",
      "type": "Governorate"
    },
    {
      "code": "LC-01",
      "name": "Anse la Raye",
      "type": "District"
    },
    {
      "code": "LC-02",
      "name": "Castries",
      "type": "District"
    },
    {
      "code": "LC-03",
      "name": "Choiseul",
      "type": "District"
    },
    {
      "code": "LC-05",
      "name": "Dennery",
      "type": "District"
    },
    {
      "code": "LC-06",
      "name": "Gros Islet",
      "type": "District"
    },
    {
      "code": "LC-07",
      "name": "Laborie",
      "type": "District"
    },
    {
      "code": "LC-08",
      "name": "Micoud",
      "type": "District"
    },
    {
      "code": "LC-10",
      "name": "Soufrière",
      "type": "District"
    },
    {
      "code": "LC-11",
      "name": "Vieux Fort",
      "type": "District"
    },
    {
      "code": "LC-12",
      "name": "Canaries",
      "type": "District"
    },
    {
      "code": "LI-01",
      "name": "Balzers",
      "type": "Commune"
    },
    {
      "code": "LI-02",
      "name": "Eschen",
      "type": "Commune"
    },
    {
      "code": "LI-03",
      "name": "Gamprin",
      "type": "Commune"
    },
    {
      "code": "LI-04",
      "name": "Mauren",
      "type": "Commune"
    },
    {
      "code": "LI-05",
      "name": "Planken",
      "type": "Commune"
    },
    {
      "code": "LI-06",
      "name": "Ruggell",
      "type": "Commune"
    },
    {
      "code": "LI-07",
      "name": "Schaan",
      "type": "Commune"
    },
    {
      "code": "LI-08",
      "name": "Schellenberg",
      "type": "Commune"
    },
    {
      "code": "LI-09",
      "name": "Triesen",
      "type": "Commune"
    },
    {
      "code": "LI-10",
      "name": "Triesenberg",
      "type": "Commune"
    },
    {
      "code": "LI-11",
      "name": "Vaduz",
      "type": "Commune"
    },
    {
      "code": "LK-1",
      "name": "Western Province",
      "type": "Province"
    },
    {
      "code": "LK-11",
      "name": "Colombo",
      "parent": "1",
      "type": "District"
    },
    {
      "code": "LK-12",
      "name": "Gampaha",
      "parent": "1",
      "type": "District"
    },
    {
      "code": "LK-13",
      "name": "Kalutara",
      "parent": "1",
      "type": "District"
    },
    {
      "code": "LK-2",
      "name": "Central Province",
      "type": "Province"
    },
    {
      "code": "LK-21",
      "name": "Kandy",
      "parent": "2",
      "type": "District"
    },
    {
      "code": "LK-22",
      "name": "Matale",
      "parent": "2",
      "type": "District"
    },
    {
      "code": "LK-23",
      "name": "Nuwara Eliya",
      "parent": "2",
      "type": "District"
    },
    {
      "code": "LK-3",
      "name": "Southern Province",
      "type": "Province"
    },
    {
      "code": "LK-31",
      "name": "Galle",
      "parent": "3",
      "type": "District"
    },
    {
      "code": "LK-32",
      "name": "Matara",
      "parent": "3",
      "type": "District"
    },
    {
      "code": "LK-33",
      "name": "Hambantota",
      "parent": "3",
      "type": "District"
    },
    {
      "code": "LK-4",
      "name": "Northern Province",
      "type": "Province"
    },
    {
      "code": "LK-41",
      "name": "Jaffna",
      "parent": "4",
      "type": "District"
    },
    {
      "code": "LK-42",
      "name": "Kilinochchi",
      "parent": "4",
      "type": "District"
    },
    {
      "code": "LK-43",
      "name": "Mannar",
      "parent": "4",
      "type": "District"
    },
    {
      "code": "LK-44",
      "name": "Vavuniya",
      "parent": "4",
      "type": "District"
    },
    {
      "code": "LK-45",
      "name": "Mullaittivu",
      "parent": "4",
      "type": "District"
    },
    {
      "code": "LK-5",
      "name": "Eastern Province",
      "type": "Province"
    },
    {
      "code": "LK-51",
      "name": "Batticaloa",
      "parent": "5",
      "type": "District"
    },
    {
      "code": "LK-52",
      "name": "Ampara",
      "parent": "5",
      "type": "District"
    },
    {
      "code": "LK-53",
      "name": "Trincomalee",
      "parent": "5",
      "type": "District"
    },
    {
      "code": "LK-6",
      "name": "North Western Province",
      "type": "Province"
    },
    {
      "code": "LK-61",
      "name": "Kurunegala",
      "parent": "6",
      "type": "District"
    },
    {
      "code": "LK-62",
      "name": "Puttalam",
      "parent": "6",
      "type": "District"
    },
    {
      "code": "LK-7",
      "name": "North Central Province",
      "type": "Province"
    },
    {
      "code": "LK-71",
      "name": "Anuradhapura",
      "parent": "7",
      "type": "District"
    },
    {
      "code": "LK-72",
      "name": "Polonnaruwa",
      "parent": "7",
      "type": "District"
    },
    {
      "code": "LK-8",
      "name": "Uva Province",
      "type": "Province"
    },
    {
      "code": "LK-81",
      "name": "Badulla",
      "parent": "8",
      "type": "District"
    },
    {
      "code": "LK-82",
      "name": "Monaragala",
      "parent": "8",
      "type": "District"
    },
    {
      "code": "LK-9",
      "name": "Sabaragamuwa Province",
      "type": "Province"
    },
    {
      "code": "LK-91",
      "name": "Ratnapura",
      "parent": "9",
      "type": "District"
    },
    {
      "code": "LK-92",
      "name": "Kegalla",
      "parent": "9",
      "type": "District"
    },
    {
      "code": "LR-BG",
      "name": "Bong",
      "type": "County"
    },
    {
      "code": "LR-BM",
      "name": "Bomi",
      "type": "County"
    },
    {
      "code": "LR-CM",
      "name": "Grand Cape Mount",
      "type": "County"
    },
    {
      "code": "LR-GB",
      "name": "Grand Bassa",
      "type": "County"
    },
    {
      "code": "LR-GG",
      "name": "Grand Gedeh",
      "type": "County"
    },
    {
      "code": "LR-GK",
      "name": "Grand Kru",
      "type": "County"
    },
    {
      "code": "LR-GP",
      "name": "Gbarpolu",
      "type": "County"
    },
    {
      "code": "LR-LO",
      "name": "Lofa",
      "type": "County"
    },
    {
      "code": "LR-MG",
      "name": "Margibi",
      "type": "County"
    },
    {
      "code": "LR-MO",
      "name": "Montserrado",
      "type": "County"
    },
    {
      "code": "LR-MY",
      "name": "Maryland",
      "type": "County"
    },
    {
      "code": "LR-NI",
      "name": "Nimba",
      "type": "County"
    },
    {
      "code": "LR-RG",
      "name": "River Gee",
      "type": "County"
    },
    {
      "code": "LR-RI",
      "name": "River Cess",
      "type": "County"
    },
    {
      "code": "LR-SI",
      "name": "Sinoe",
      "type": "County"
    },
    {
      "code": "LS-A",
      "name": "Maseru",
      "type": "District"
    },
    {
      "code": "LS-B",
      "name": "Botha-Bothe",
      "type": "District"
    },
    {
      "code": "LS-C",
      "name": "Leribe",
      "type": "District"
    },
    {
      "code": "LS-D",
      "name": "Berea",
      "type": "District"
    },
    {
      "code": "LS-E",
      "name": "Mafeteng",
      "type": "District"
    },
    {
      "code": "LS-F",
      "name": "Mohale's Hoek",
      "type": "District"
    },
    {
      "code": "LS-G",
      "name": "Quthing",
      "type": "District"
    },
    {
      "code": "LS-H",
      "name": "Qacha's Nek",
      "type": "District"
    },
    {
      "code": "LS-J",
      "name": "Mokhotlong",
      "type": "District"
    },
    {
      "code": "LS-K",
      "name": "Thaba-Tseka",
      "type": "District"
    },
    {
      "code": "LT-01",
      "name": "Akmenė",
      "type": "District municipality"
    },
    {
      "code": "LT-02",
      "name": "Alytaus miestas",
      "type": "City municipality"
    },
    {
      "code": "LT-03",
      "name": "Alytus",
      "type": "District municipality"
    },
    {
      "code": "LT-04",
      "name": "Anykščiai",
      "type": "District municipality"
    },
    {
      "code": "LT-05",
      "name": "Birštono",
      "type": "Municipality"
    },
    {
      "code": "LT-06",
      "name": "Biržai",
      "type": "District municipality"
    },
    {
      "code": "LT-07",
      "name": "Druskininkai",
      "type": "Municipality"
    },
    {
      "code": "LT-08",
      "name": "Elektrėnai",
      "type": "Municipality"
    },
    {
      "code": "LT-09",
      "name": "Ignalina",
      "type": "District municipality"
    },
    {
      "code": "LT-10",
      "name": "Jonava",
      "type": "District municipality"
    },
    {
      "code": "LT-11",
      "name": "Joniškis",
      "type": "District municipality"
    },
    {
      "code": "LT-12",
      "name": "Jurbarkas",
      "type": "District municipality"
    },
    {
      "code": "LT-13",
      "name": "Kaišiadorys",
      "type": "District municipality"
    },
    {
      "code": "LT-14",
      "name": "Kalvarijos",
      "type": "Municipality"
    },
    {
      "code": "LT-15",
      "name": "Kauno miestas",
      "type": "City municipality"
    },
    {
      "code": "LT-16",
      "name": "Kaunas",
      "type": "District municipality"
    },
    {
      "code": "LT-17",
      "name": "Kazlų Rūdos",
      "type": "Municipality"
    },
    {
      "code": "LT-18",
      "name": "Kėdainiai",
      "type": "District municipality"
    },
    {
      "code": "LT-19",
      "name": "Kelmė",
      "type": "District municipality"
    },
    {
      "code": "LT-20",
      "name": "Klaipėdos miestas",
      "type": "City municipality"
    },
    {
      "code": "LT-21",
      "name": "Klaipėda",
      "type": "District municipality"
    },
    {
      "code": "LT-22",
      "name": "Kretinga",
      "type": "District municipality"
    },
    {
      "code": "LT-23",
      "name": "Kupiškis",
      "type": "District municipality"
    },
    {
      "code": "LT-24",
      "name": "Lazdijai",
      "type": "District municipality"
    },
    {
      "code": "LT-25",
      "name": "Marijampolė",
      "type": "District municipality"
    },
    {
      "code": "LT-26",
      "name": "Mažeikiai",
      "type": "District municipality"
    },
    {
      "code": "LT-27",
      "name": "Molėtai",
      "type": "District municipality"
    },
    {
      "code": "LT-28",
      "name": "Neringa",
      "type": "Municipality"
    },
    {
      "code": "LT-29",
      "name": "Pagėgiai",
      "type": "Municipality"
    },
    {
      "code": "LT-30",
      "name": "Pakruojis",
      "type": "District municipality"
    },
    {
      "code": "LT-31",
      "name": "Palangos miestas",
      "type": "City municipality"
    },
    {
      "code": "LT-32",
      "name": "Panevėžio miestas",
      "type": "City municipality"
    },
    {
      "code": "LT-33",
      "name": "Panevėžys",
      "type": "District municipality"
    },
    {
      "code": "LT-34",
      "name": "Pasvalys",
      "type": "District municipality"
    },
    {
      "code": "LT-35",
      "name": "Plungė",
      "type": "District municipality"
    },
    {
      "code": "LT-36",
      "name": "Prienai",
      "type": "District municipality"
    },
    {
      "code": "LT-37",
      "name": "Radviliškis",
      "type": "District municipality"
    },
    {
      "code": "LT-38",
      "name": "Raseiniai",
      "type": "District municipality"
    },
    {
      "code": "LT-39",
      "name": "Rietavo",
      "type": "Municipality"
    },
    {
      "code": "LT-40",
      "name": "Rokiškis",
      "type": "District municipality"
    },
    {
      "code": "LT-41",
      "name": "Šakiai",
      "type": "District municipality"
    },
    {
      "code": "LT-42",
      "name": "Šalčininkai",
      "type": "District municipality"
    },
    {
      "code": "LT-43",
      "name": "Šiaulių miestas",
      "type": "City municipality"
    },
    {
      "code": "LT-44",
      "name": "Šiauliai",
      "type": "District municipality"
    },
    {
      "code": "LT-45",
      "name": "Šilalė",
      "type": "District municipality"
    },
    {
      "code": "LT-46",
      "name": "Šilutė",
      "type": "District municipality"
    },
    {
      "code": "LT-47",
      "name": "Širvintos",
      "type": "District municipality"
    },
    {
      "code": "LT-48",
      "name": "Skuodas",
      "type": "District municipality"
    },
    {
      "code": "LT-49",
      "name": "Švenčionys",
      "type": "District municipality"
    },
    {
      "code": "LT-50",
      "name": "Tauragė",
      "type": "District municipality"
    },
    {
      "code": "LT-51",
      "name": "Telšiai",
      "type": "District municipality"
    },
    {
      "code": "LT-52",
      "name": "Trakai",
      "type": "District municipality"
    },
    {
      "code": "LT-53",
      "name": "Ukmergė",
      "type": "District municipality"
    },
    {
      "code": "LT-54",
      "name": "Utena",
      "type": "District municipality"
    },
    {
      "code": "LT-55",
      "name": "Varėna",
      "type": "District municipality"
    },
    {
      "code": "LT-56",
      "name": "Vilkaviškis",
      "type": "District municipality"
    },
    {
      "code": "LT-57",
      "name": "Vilniaus miestas",
      "type": "City municipality"
    },
    {
      "code": "LT-58",
      "name": "Vilnius",
      "type": "District municipality"
    },
    {
      "code": "LT-59",
      "name": "Visaginas",
      "type": "Municipality"
    },
    {
      "code": "LT-60",
      "name": "Zarasai",
      "type": "District municipality"
    },
    {
      "code": "LT-AL",
      "name": "Alytaus apskritis",
      "type": "County"
    },
    {
      "code": "LT-KL",
      "name": "Klaipėdos apskritis",
      "type": "County"
    },
    {
      "code": "LT-KU",
      "name": "Kauno apskritis",
      "type": "County"
    },
    {
      "code": "LT-MR",
      "name": "Marijampolės apskritis",
      "type": "County"
    },
    {
      "code": "LT-PN",
      "name": "Panevėžio apskritis",
      "type": "County"
    },
    {
      "code": "LT-SA",
      "name": "Šiaulių apskritis",
      "type": "County"
    },
    {
      "code": "LT-TA",
      "name": "Tauragės apskritis",
      "type": "County"
    },
    {
      "code": "LT-TE",
      "name": "Telšių apskritis",
      "type": "County"
    },
    {
      "code": "LT-UT",
      "name": "Utenos apskritis",
      "type": "County"
    },
    {
      "code": "LT-VL",
      "name": "Vilniaus apskritis",
      "type": "County"
    },
    {
      "code": "LU-CA",
      "name": "Capellen",
      "type": "Canton"
    },
    {
      "code": "LU-CL",
      "name": "Clerf",
      "type": "Canton"
    },
    {
      "code": "LU-DI",
      "name": "Diekirch",
      "type": "Canton"
    },
    {
      "code": "LU-EC",
      "name": "Echternach",
      "type": "Canton"
    },
    {
      "code": "LU-ES",
      "name": "Esch an der Alzette",
      "type": "Canton"
    },
    {
      "code": "LU-GR",
      "name": "Grevenmacher",
      "type": "Canton"
    },
    {
      "code": "LU-LU",
      "name": "Luxembourg",
      "type": "Canton"
    },
    {
      "code": "LU-ME",
      "name": "Mersch",
      "type": "Canton"
    },
    {
      "code": "LU-RD",
      "name": "Redange",
      "type": "Canton"
    },
    {
      "code": "LU-RM",
      "name": "Remich",
      "type": "Canton"
    },
    {
      "code": "LU-VD",
      "name": "Veianen",
      "type": "Canton"
    },
    {
      "code": "LU-WI",
      "name": "Wiltz",
      "type": "Canton"
    },
    {
      "code": "LV-001",
      "name": "Aglonas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-002",
      "name": "Aizkraukles novads",
      "type": "Municipality"
    },
    {
      "code": "LV-003",
      "name": "Aizputes novads",
      "type": "Municipality"
    },
    {
      "code": "LV-004",
      "name": "Aknīstes novads",
      "type": "Municipality"
    },
    {
      "code": "LV-005",
      "name": "Alojas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-006",
      "name": "Alsungas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-007",
      "name": "Alūksnes novads",
      "type": "Municipality"
    },
    {
      "code": "LV-008",
      "name": "Amatas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-009",
      "name": "Apes novads",
      "type": "Municipality"
    },
    {
      "code": "LV-010",
      "name": "Auces novads",
      "type": "Municipality"
    },
    {
      "code": "LV-011",
      "name": "Ādažu novads",
      "type": "Municipality"
    },
    {
      "code": "LV-012",
      "name": "Babītes novads",
      "type": "Municipality"
    },
    {
      "code": "LV-013",
      "name": "Baldones novads",
      "type": "Municipality"
    },
    {
      "code": "LV-014",
      "name": "Baltinavas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-015",
      "name": "Balvu novads",
      "type": "Municipality"
    },
    {
      "code": "LV-016",
      "name": "Bauskas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-017",
      "name": "Beverīnas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-018",
      "name": "Brocēnu novads",
      "type": "Municipality"
    },
    {
      "code": "LV-019",
      "name": "Burtnieku novads",
      "type": "Municipality"
    },
    {
      "code": "LV-020",
      "name": "Carnikavas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-021",
      "name": "Cesvaines novads",
      "type": "Municipality"
    },
    {
      "code": "LV-022",
      "name": "Cēsu novads",
      "type": "Municipality"
    },
    {
      "code": "LV-023",
      "name": "Ciblas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-024",
      "name": "Dagdas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-025",
      "name": "Daugavpils novads",
      "type": "Municipality"
    },
    {
      "code": "LV-026",
      "name": "Dobeles novads",
      "type": "Municipality"
    },
    {
      "code": "LV-027",
      "name": "Dundagas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-028",
      "name": "Durbes novads",
      "type": "Municipality"
    },
    {
      "code": "LV-029",
      "name": "Engures novads",
      "type": "Municipality"
    },
    {
      "code": "LV-030",
      "name": "Ērgļu novads",
      "type": "Municipality"
    },
    {
      "code": "LV-031",
      "name": "Garkalnes novads",
      "type": "Municipality"
    },
    {
      "code": "LV-032",
      "name": "Grobiņas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-033",
      "name": "Gulbenes novads",
      "type": "Municipality"
    },
    {
      "code": "LV-034",
      "name": "Iecavas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-035",
      "name": "Ikšķiles novads",
      "type": "Municipality"
    },
    {
      "code": "LV-036",
      "name": "Ilūkstes novads",
      "type": "Municipality"
    },
    {
      "code": "LV-037",
      "name": "Inčukalna novads",
      "type": "Municipality"
    },
    {
      "code": "LV-038",
      "name": "Jaunjelgavas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-039",
      "name": "Jaunpiebalgas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-040",
      "name": "Jaunpils novads",
      "type": "Municipality"
    },
    {
      "code": "LV-041",
      "name": "Jelgavas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-042",
      "name": "Jēkabpils novads",
      "type": "Municipality"
    },
    {
      "code": "LV-043",
      "name": "Kandavas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-044",
      "name": "Kārsavas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-045",
      "name": "Kocēnu novads",
      "type": "Municipality"
    },
    {
      "code": "LV-046",
      "name": "Kokneses novads",
      "type": "Municipality"
    },
    {
      "code": "LV-047",
      "name": "Krāslavas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-048",
      "name": "Krimuldas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-049",
      "name": "Krustpils novads",
      "type": "Municipality"
    },
    {
      "code": "LV-050",
      "name": "Kuldīgas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-051",
      "name": "Ķeguma novads",
      "type": "Municipality"
    },
    {
      "code": "LV-052",
      "name": "Ķekavas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-053",
      "name": "Lielvārdes novads",
      "type": "Municipality"
    },
    {
      "code": "LV-054",
      "name": "Limbažu novads",
      "type": "Municipality"
    },
    {
      "code": "LV-055",
      "name": "Līgatnes novads",
      "type": "Municipality"
    },
    {
      "code": "LV-056",
      "name": "Līvānu novads",
      "type": "Municipality"
    },
    {
      "code": "LV-057",
      "name": "Lubānas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-058",
      "name": "Ludzas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-059",
      "name": "Madonas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-060",
      "name": "Mazsalacas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-061",
      "name": "Mālpils novads",
      "type": "Municipality"
    },
    {
      "code": "LV-062",
      "name": "Mārupes novads",
      "type": "Municipality"
    },
    {
      "code": "LV-063",
      "name": "Mērsraga novads",
      "type": "Municipality"
    },
    {
      "code": "LV-064",
      "name": "Naukšēnu novads",
      "type": "Municipality"
    },
    {
      "code": "LV-065",
      "name": "Neretas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-066",
      "name": "Nīcas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-067",
      "name": "Ogres novads",
      "type": "Municipality"
    },
    {
      "code": "LV-068",
      "name": "Olaines novads",
      "type": "Municipality"
    },
    {
      "code": "LV-069",
      "name": "Ozolnieku novads",
      "type": "Municipality"
    },
    {
      "code": "LV-070",
      "name": "Pārgaujas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-071",
      "name": "Pāvilostas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-072",
      "name": "Pļaviņu novads",
      "type": "Municipality"
    },
    {
      "code": "LV-073",
      "name": "Preiļu novads",
      "type": "Municipality"
    },
    {
      "code": "LV-074",
      "name": "Priekules novads",
      "type": "Municipality"
    },
    {
      "code": "LV-075",
      "name": "Priekuļu novads",
      "type": "Municipality"
    },
    {
      "code": "LV-076",
      "name": "Raunas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-077",
      "name": "Rēzeknes novads",
      "type": "Municipality"
    },
    {
      "code": "LV-078",
      "name": "Riebiņu novads",
      "type": "Municipality"
    },
    {
      "code": "LV-079",
      "name": "Rojas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-080",
      "name": "Ropažu novads",
      "type": "Municipality"
    },
    {
      "code": "LV-081",
      "name": "Rucavas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-082",
      "name": "Rugāju novads",
      "type": "Municipality"
    },
    {
      "code": "LV-083",
      "name": "Rundāles novads",
      "type": "Municipality"
    },
    {
      "code": "LV-084",
      "name": "Rūjienas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-085",
      "name": "Salas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-086",
      "name": "Salacgrīvas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-087",
      "name": "Salaspils novads",
      "type": "Municipality"
    },
    {
      "code": "LV-088",
      "name": "Saldus novads",
      "type": "Municipality"
    },
    {
      "code": "LV-089",
      "name": "Saulkrastu novads",
      "type": "Municipality"
    },
    {
      "code": "LV-090",
      "name": "Sējas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-091",
      "name": "Siguldas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-092",
      "name": "Skrīveru novads",
      "type": "Municipality"
    },
    {
      "code": "LV-093",
      "name": "Skrundas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-094",
      "name": "Smiltenes novads",
      "type": "Municipality"
    },
    {
      "code": "LV-095",
      "name": "Stopiņu novads",
      "type": "Municipality"
    },
    {
      "code": "LV-096",
      "name": "Strenču novads",
      "type": "Municipality"
    },
    {
      "code": "LV-097",
      "name": "Talsu novads",
      "type": "Municipality"
    },
    {
      "code": "LV-098",
      "name": "Tērvetes novads",
      "type": "Municipality"
    },
    {
      "code": "LV-099",
      "name": "Tukuma novads",
      "type": "Municipality"
    },
    {
      "code": "LV-100",
      "name": "Vaiņodes novads",
      "type": "Municipality"
    },
    {
      "code": "LV-101",
      "name": "Valkas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-102",
      "name": "Varakļānu novads",
      "type": "Municipality"
    },
    {
      "code": "LV-103",
      "name": "Vārkavas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-104",
      "name": "Vecpiebalgas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-105",
      "name": "Vecumnieku novads",
      "type": "Municipality"
    },
    {
      "code": "LV-106",
      "name": "Ventspils novads",
      "type": "Municipality"
    },
    {
      "code": "LV-107",
      "name": "Viesītes novads",
      "type": "Municipality"
    },
    {
      "code": "LV-108",
      "name": "Viļakas novads",
      "type": "Municipality"
    },
    {
      "code": "LV-109",
      "name": "Viļānu novads",
      "type": "Municipality"
    },
    {
      "code": "LV-110",
      "name": "Zilupes novads",
      "type": "Municipality"
    },
    {
      "code": "LV-DGV",
      "name": "Daugavpils",
      "type": "Republican city"
    },
    {
      "code": "LV-JEL",
      "name": "Jelgava",
      "type": "Republican city"
    },
    {
      "code": "LV-JKB",
      "name": "Jēkabpils",
      "type": "Republican city"
    },
    {
      "code": "LV-JUR",
      "name": "Jūrmala",
      "type": "Republican city"
    },
    {
      "code": "LV-LPX",
      "name": "Liepāja",
      "type": "Republican city"
    },
    {
      "code": "LV-REZ",
      "name": "Rēzekne",
      "type": "Republican city"
    },
    {
      "code": "LV-RIX",
      "name": "Rīga",
      "type": "Republican city"
    },
    {
      "code": "LV-VEN",
      "name": "Ventspils",
      "type": "Republican city"
    },
    {
      "code": "LV-VMR",
      "name": "Valmiera",
      "type": "Republican city"
    },
    {
      "code": "LY-BA",
      "name": "Banghāzī",
      "type": "Popularate"
    },
    {
      "code": "LY-BU",
      "name": "Al Buţnān",
      "type": "Popularate"
    },
    {
      "code": "LY-DR",
      "name": "Darnah",
      "type": "Popularate"
    },
    {
      "code": "LY-GT",
      "name": "Ghāt",
      "type": "Popularate"
    },
    {
      "code": "LY-JA",
      "name": "Al Jabal al Akhḑar",
      "type": "Popularate"
    },
    {
      "code": "LY-JG",
      "name": "Al Jabal al Gharbī",
      "type": "Popularate"
    },
    {
      "code": "LY-JI",
      "name": "Al Jafārah",
      "type": "Popularate"
    },
    {
      "code": "LY-JU",
      "name": "Al Jufrah",
      "type": "Popularate"
    },
    {
      "code": "LY-KF",
      "name": "Al Kufrah",
      "type": "Popularate"
    },
    {
      "code": "LY-MB",
      "name": "Al Marqab",
      "type": "Popularate"
    },
    {
      "code": "LY-MI",
      "name": "Mişrātah",
      "type": "Popularate"
    },
    {
      "code": "LY-MJ",
      "name": "Al Marj",
      "type": "Popularate"
    },
    {
      "code": "LY-MQ",
      "name": "Murzuq",
      "type": "Popularate"
    },
    {
      "code": "LY-NL",
      "name": "Nālūt",
      "type": "Popularate"
    },
    {
      "code": "LY-NQ",
      "name": "An Nuqāţ al Khams",
      "type": "Popularate"
    },
    {
      "code": "LY-SB",
      "name": "Sabhā",
      "type": "Popularate"
    },
    {
      "code": "LY-SR",
      "name": "Surt",
      "type": "Popularate"
    },
    {
      "code": "LY-TB",
      "name": "Ţarābulus",
      "type": "Popularate"
    },
    {
      "code": "LY-WA",
      "name": "Al Wāḩāt",
      "type": "Popularate"
    },
    {
      "code": "LY-WD",
      "name": "Wādī al Ḩayāt",
      "type": "Popularate"
    },
    {
      "code": "LY-WS",
      "name": "Wādī ash Shāţi’",
      "type": "Popularate"
    },
    {
      "code": "LY-ZA",
      "name": "Az Zāwiyah",
      "type": "Popularate"
    },
    {
      "code": "MA-01",
      "name": "Tanger-Tétouan-Al Hoceïma",
      "type": "Region"
    },
    {
      "code": "MA-02",
      "name": "L'Oriental",
      "type": "Region"
    },
    {
      "code": "MA-03",
      "name": "Fès-Meknès",
      "type": "Region"
    },
    {
      "code": "MA-04",
      "name": "Rabat-Salé-Kénitra",
      "type": "Region"
    },
    {
      "code": "MA-05",
      "name": "Béni Mellal-Khénifra",
      "type": "Region"
    },
    {
      "code": "MA-06",
      "name": "Casablanca-Settat",
      "type": "Region"
    },
    {
      "code": "MA-07",
      "name": "Marrakech-Safi",
      "type": "Region"
    },
    {
      "code": "MA-08",
      "name": "Drâa-Tafilalet",
      "type": "Region"
    },
    {
      "code": "MA-09",
      "name": "Souss-Massa",
      "type": "Region"
    },
    {
      "code": "MA-10",
      "name": "Guelmim-Oued Noun (EH-partial)",
      "type": "Region"
    },
    {
      "code": "MA-11",
      "name": "Laâyoune-Sakia El Hamra (EH-partial)",
      "type": "Region"
    },
    {
      "code": "MA-12",
      "name": "Dakhla-Oued Ed-Dahab (EH)",
      "type": "Region"
    },
    {
      "code": "MA-AGD",
      "name": "Agadir-Ida-Ou-Tanane",
      "parent": "09",
      "type": "Prefecture"
    },
    {
      "code": "MA-AOU",
      "name": "Aousserd (EH)",
      "parent": "12",
      "type": "Province"
    },
    {
      "code": "MA-ASZ",
      "name": "Assa-Zag (EH-partial)",
      "parent": "10",
      "type": "Province"
    },
    {
      "code": "MA-AZI",
      "name": "Azilal",
      "parent": "05",
      "type": "Province"
    },
    {
      "code": "MA-BEM",
      "name": "Béni Mellal",
      "parent": "05",
      "type": "Province"
    },
    {
      "code": "MA-BER",
      "name": "Berkane",
      "parent": "02",
      "type": "Province"
    },
    {
      "code": "MA-BES",
      "name": "Benslimane",
      "parent": "06",
      "type": "Province"
    },
    {
      "code": "MA-BOD",
      "name": "Boujdour (EH)",
      "parent": "11",
      "type": "Province"
    },
    {
      "code": "MA-BOM",
      "name": "Boulemane",
      "parent": "03",
      "type": "Province"
    },
    {
      "code": "MA-BRR",
      "name": "Berrechid",
      "parent": "06",
      "type": "Province"
    },
    {
      "code": "MA-CAS",
      "name": "Casablanca",
      "parent": "06",
      "type": "Prefecture"
    },
    {
      "code": "MA-CHE",
      "name": "Chefchaouen",
      "parent": "01",
      "type": "Province"
    },
    {
      "code": "MA-CHI",
      "name": "Chichaoua",
      "parent": "07",
      "type": "Province"
    },
    {
      "code": "MA-CHT",
      "name": "Chtouka-Ait Baha",
      "parent": "06",
      "type": "Province"
    },
    {
      "code": "MA-DRI",
      "name": "Driouch",
      "parent": "02",
      "type": "Province"
    },
    {
      "code": "MA-ERR",
      "name": "Errachidia",
      "parent": "08",
      "type": "Province"
    },
    {
      "code": "MA-ESI",
      "name": "Essaouira",
      "parent": "07",
      "type": "Province"
    },
    {
      "code": "MA-ESM",
      "name": "Es-Semara (EH-partial)",
      "parent": "11",
      "type": "Province"
    },
    {
      "code": "MA-FAH",
      "name": "Fahs-Anjra",
      "parent": "01",
      "type": "Province"
    },
    {
      "code": "MA-FES",
      "name": "Fès",
      "parent": "03",
      "type": "Prefecture"
    },
    {
      "code": "MA-FIG",
      "name": "Figuig",
      "parent": "02",
      "type": "Province"
    },
    {
      "code": "MA-FQH",
      "name": "Fquih Ben Salah",
      "parent": "05",
      "type": "Province"
    },
    {
      "code": "MA-GUE",
      "name": "Guelmim",
      "parent": "10",
      "type": "Province"
    },
    {
      "code": "MA-GUF",
      "name": "Guercif",
      "parent": "02",
      "type": "Province"
    },
    {
      "code": "MA-HAJ",
      "name": "El Hajeb",
      "parent": "03",
      "type": "Province"
    },
    {
      "code": "MA-HAO",
      "name": "Al Haouz",
      "parent": "07",
      "type": "Province"
    },
    {
      "code": "MA-HOC",
      "name": "Al Hoceïma",
      "parent": "01",
      "type": "Province"
    },
    {
      "code": "MA-IFR",
      "name": "Ifrane",
      "parent": "03",
      "type": "Province"
    },
    {
      "code": "MA-INE",
      "name": "Inezgane-Ait Melloul",
      "parent": "09",
      "type": "Prefecture"
    },
    {
      "code": "MA-JDI",
      "name": "El Jadida",
      "parent": "06",
      "type": "Province"
    },
    {
      "code": "MA-JRA",
      "name": "Jerada",
      "parent": "02",
      "type": "Province"
    },
    {
      "code": "MA-KEN",
      "name": "Kénitra",
      "parent": "04",
      "type": "Province"
    },
    {
      "code": "MA-KES",
      "name": "El Kelâa des Sraghna",
      "parent": "07",
      "type": "Province"
    },
    {
      "code": "MA-KHE",
      "name": "Khémisset",
      "parent": "04",
      "type": "Province"
    },
    {
      "code": "MA-KHN",
      "name": "Khénifra",
      "parent": "05",
      "type": "Province"
    },
    {
      "code": "MA-KHO",
      "name": "Khouribga",
      "parent": "05",
      "type": "Province"
    },
    {
      "code": "MA-LAA",
      "name": "Laâyoune (EH)",
      "parent": "11",
      "type": "Province"
    },
    {
      "code": "MA-LAR",
      "name": "Larache",
      "parent": "01",
      "type": "Province"
    },
    {
      "code": "MA-MAR",
      "name": "Marrakech",
      "parent": "07",
      "type": "Prefecture"
    },
    {
      "code": "MA-MDF",
      "name": "M’diq-Fnideq",
      "parent": "01",
      "type": "Prefecture"
    },
    {
      "code": "MA-MED",
      "name": "Médiouna",
      "parent": "06",
      "type": "Province"
    },
    {
      "code": "MA-MEK",
      "name": "Meknès",
      "parent": "03",
      "type": "Prefecture"
    },
    {
      "code": "MA-MID",
      "name": "Midelt",
      "parent": "08",
      "type": "Province"
    },
    {
      "code": "MA-MOH",
      "name": "Mohammadia",
      "parent": "06",
      "type": "Prefecture"
    },
    {
      "code": "MA-MOU",
      "name": "Moulay Yacoub",
      "parent": "03",
      "type": "Province"
    },
    {
      "code": "MA-NAD",
      "name": "Nador",
      "parent": "02",
      "type": "Province"
    },
    {
      "code": "MA-NOU",
      "name": "Nouaceur",
      "parent": "04",
      "type": "Province"
    },
    {
      "code": "MA-OUA",
      "name": "Ouarzazate",
      "parent": "08",
      "type": "Province"
    },
    {
      "code": "MA-OUD",
      "name": "Oued Ed-Dahab (EH)",
      "parent": "12",
      "type": "Province"
    },
    {
      "code": "MA-OUJ",
      "name": "Oujda-Angad",
      "parent": "02",
      "type": "Prefecture"
    },
    {
      "code": "MA-OUZ",
      "name": "Ouezzane",
      "parent": "01",
      "type": "Province"
    },
    {
      "code": "MA-RAB",
      "name": "Rabat",
      "parent": "04",
      "type": "Prefecture"
    },
    {
      "code": "MA-REH",
      "name": "Rehamna",
      "parent": "07",
      "type": "Province"
    },
    {
      "code": "MA-SAF",
      "name": "Safi",
      "parent": "07",
      "type": "Province"
    },
    {
      "code": "MA-SAL",
      "name": "Salé",
      "parent": "04",
      "type": "Prefecture"
    },
    {
      "code": "MA-SEF",
      "name": "Sefrou",
      "parent": "03",
      "type": "Province"
    },
    {
      "code": "MA-SET",
      "name": "Settat",
      "parent": "06",
      "type": "Province"
    },
    {
      "code": "MA-SIB",
      "name": "Sidi Bennour",
      "parent": "06",
      "type": "Province"
    },
    {
      "code": "MA-SIF",
      "name": "Sidi Ifni",
      "parent": "10",
      "type": "Province"
    },
    {
      "code": "MA-SIK",
      "name": "Sidi Kacem",
      "parent": "04",
      "type": "Province"
    },
    {
      "code": "MA-SIL",
      "name": "Sidi Slimane",
      "parent": "04",
      "type": "Province"
    },
    {
      "code": "MA-SKH",
      "name": "Skhirate-Témara",
      "parent": "04",
      "type": "Prefecture"
    },
    {
      "code": "MA-TAF",
      "name": "Tarfaya (EH-partial)",
      "parent": "11",
      "type": "Province"
    },
    {
      "code": "MA-TAI",
      "name": "Taourirt",
      "parent": "02",
      "type": "Province"
    },
    {
      "code": "MA-TAO",
      "name": "Taounate",
      "parent": "03",
      "type": "Province"
    },
    {
      "code": "MA-TAR",
      "name": "Taroudannt",
      "parent": "09",
      "type": "Province"
    },
    {
      "code": "MA-TAT",
      "name": "Tata",
      "parent": "09",
      "type": "Province"
    },
    {
      "code": "MA-TAZ",
      "name": "Taza",
      "parent": "03",
      "type": "Province"
    },
    {
      "code": "MA-TET",
      "name": "Tétouan",
      "parent": "01",
      "type": "Province"
    },
    {
      "code": "MA-TIN",
      "name": "Tinghir",
      "parent": "08",
      "type": "Province"
    },
    {
      "code": "MA-TIZ",
      "name": "Tiznit",
      "parent": "09",
      "type": "Province"
    },
    {
      "code": "MA-TNG",
      "name": "Tanger-Assilah",
      "parent": "01",
      "type": "Prefecture"
    },
    {
      "code": "MA-TNT",
      "name": "Tan-Tan (EH-partial)",
      "parent": "10",
      "type": "Province"
    },
    {
      "code": "MA-YUS",
      "name": "Youssoufia",
      "parent": "07",
      "type": "Province"
    },
    {
      "code": "MA-ZAG",
      "name": "Zagora",
      "parent": "08",
      "type": "Province"
    },
    {
      "code": "MC-CL",
      "name": "La Colle",
      "type": "Quarter"
    },
    {
      "code": "MC-CO",
      "name": "La Condamine",
      "type": "Quarter"
    },
    {
      "code": "MC-FO",
      "name": "Fontvieille",
      "type": "Quarter"
    },
    {
      "code": "MC-GA",
      "name": "La Gare",
      "type": "Quarter"
    },
    {
      "code": "MC-JE",
      "name": "Jardin Exotique",
      "type": "Quarter"
    },
    {
      "code": "MC-LA",
      "name": "Larvotto",
      "type": "Quarter"
    },
    {
      "code": "MC-MA",
      "name": "Malbousquet",
      "type": "Quarter"
    },
    {
      "code": "MC-MC",
      "name": "Monte-Carlo",
      "type": "Quarter"
    },
    {
      "code": "MC-MG",
      "name": "Moneghetti",
      "type": "Quarter"
    },
    {
      "code": "MC-MO",
      "name": "Monaco-Ville",
      "type": "Quarter"
    },
    {
      "code": "MC-MU",
      "name": "Moulins",
      "type": "Quarter"
    },
    {
      "code": "MC-PH",
      "name": "Port-Hercule",
      "type": "Quarter"
    },
    {
      "code": "MC-SD",
      "name": "Sainte-Dévote",
      "type": "Quarter"
    },
    {
      "code": "MC-SO",
      "name": "La Source",
      "type": "Quarter"
    },
    {
      "code": "MC-SP",
      "name": "Spélugues",
      "type": "Quarter"
    },
    {
      "code": "MC-SR",
      "name": "Saint-Roman",
      "type": "Quarter"
    },
    {
      "code": "MC-VR",
      "name": "Vallon de la Rousse",
      "type": "Quarter"
    },
    {
      "code": "MD-AN",
      "name": "Anenii Noi",
      "type": "District"
    },
    {
      "code": "MD-BA",
      "name": "Bălți",
      "type": "City"
    },
    {
      "code": "MD-BD",
      "name": "Bender [Tighina]",
      "type": "City"
    },
    {
      "code": "MD-BR",
      "name": "Briceni",
      "type": "District"
    },
    {
      "code": "MD-BS",
      "name": "Basarabeasca",
      "type": "District"
    },
    {
      "code": "MD-CA",
      "name": "Cahul",
      "type": "District"
    },
    {
      "code": "MD-CL",
      "name": "Călărași",
      "type": "District"
    },
    {
      "code": "MD-CM",
      "name": "Cimișlia",
      "type": "District"
    },
    {
      "code": "MD-CR",
      "name": "Criuleni",
      "type": "District"
    },
    {
      "code": "MD-CS",
      "name": "Căușeni",
      "type": "District"
    },
    {
      "code": "MD-CT",
      "name": "Cantemir",
      "type": "District"
    },
    {
      "code": "MD-CU",
      "name": "Chișinău",
      "type": "City"
    },
    {
      "code": "MD-DO",
      "name": "Dondușeni",
      "type": "District"
    },
    {
      "code": "MD-DR",
      "name": "Drochia",
      "type": "District"
    },
    {
      "code": "MD-DU",
      "name": "Dubăsari",
      "type": "District"
    },
    {
      "code": "MD-ED",
      "name": "Edineț",
      "type": "District"
    },
    {
      "code": "MD-FA",
      "name": "Fălești",
      "type": "District"
    },
    {
      "code": "MD-FL",
      "name": "Florești",
      "type": "District"
    },
    {
      "code": "MD-GA",
      "name": "Găgăuzia, Unitatea teritorială autonomă (UTAG)",
      "type": "Autonomous territorial unit"
    },
    {
      "code": "MD-GL",
      "name": "Glodeni",
      "type": "District"
    },
    {
      "code": "MD-HI",
      "name": "Hîncești",
      "type": "District"
    },
    {
      "code": "MD-IA",
      "name": "Ialoveni",
      "type": "District"
    },
    {
      "code": "MD-LE",
      "name": "Leova",
      "type": "District"
    },
    {
      "code": "MD-NI",
      "name": "Nisporeni",
      "type": "District"
    },
    {
      "code": "MD-OC",
      "name": "Ocnița",
      "type": "District"
    },
    {
      "code": "MD-OR",
      "name": "Orhei",
      "type": "District"
    },
    {
      "code": "MD-RE",
      "name": "Rezina",
      "type": "District"
    },
    {
      "code": "MD-RI",
      "name": "Rîșcani",
      "type": "District"
    },
    {
      "code": "MD-SD",
      "name": "Șoldănești",
      "type": "District"
    },
    {
      "code": "MD-SI",
      "name": "Sîngerei",
      "type": "District"
    },
    {
      "code": "MD-SN",
      "name": "Stînga Nistrului, unitatea teritorială din",
      "type": "Territorial unit"
    },
    {
      "code": "MD-SO",
      "name": "Soroca",
      "type": "District"
    },
    {
      "code": "MD-ST",
      "name": "Strășeni",
      "type": "District"
    },
    {
      "code": "MD-SV",
      "name": "Ștefan Vodă",
      "type": "District"
    },
    {
      "code": "MD-TA",
      "name": "Taraclia",
      "type": "District"
    },
    {
      "code": "MD-TE",
      "name": "Telenești",
      "type": "District"
    },
    {
      "code": "MD-UN",
      "name": "Ungheni",
      "type": "District"
    },
    {
      "code": "ME-01",
      "name": "Andrijevica",
      "type": "Municipality"
    },
    {
      "code": "ME-02",
      "name": "Bar",
      "type": "Municipality"
    },
    {
      "code": "ME-03",
      "name": "Berane",
      "type": "Municipality"
    },
    {
      "code": "ME-04",
      "name": "Bijelo Polje",
      "type": "Municipality"
    },
    {
      "code": "ME-05",
      "name": "Budva",
      "type": "Municipality"
    },
    {
      "code": "ME-06",
      "name": "Cetinje",
      "type": "Municipality"
    },
    {
      "code": "ME-07",
      "name": "Danilovgrad",
      "type": "Municipality"
    },
    {
      "code": "ME-08",
      "name": "Herceg-Novi",
      "type": "Municipality"
    },
    {
      "code": "ME-09",
      "name": "Kolašin",
      "type": "Municipality"
    },
    {
      "code": "ME-10",
      "name": "Kotor",
      "type": "Municipality"
    },
    {
      "code": "ME-11",
      "name": "Mojkovac",
      "type": "Municipality"
    },
    {
      "code": "ME-12",
      "name": "Nikšić",
      "type": "Municipality"
    },
    {
      "code": "ME-13",
      "name": "Plav",
      "type": "Municipality"
    },
    {
      "code": "ME-14",
      "name": "Pljevlja",
      "type": "Municipality"
    },
    {
      "code": "ME-15",
      "name": "Plužine",
      "type": "Municipality"
    },
    {
      "code": "ME-16",
      "name": "Podgorica",
      "type": "Municipality"
    },
    {
      "code": "ME-17",
      "name": "Rožaje",
      "type": "Municipality"
    },
    {
      "code": "ME-18",
      "name": "Šavnik",
      "type": "Municipality"
    },
    {
      "code": "ME-19",
      "name": "Tivat",
      "type": "Municipality"
    },
    {
      "code": "ME-20",
      "name": "Ulcinj",
      "type": "Municipality"
    },
    {
      "code": "ME-21",
      "name": "Žabljak",
      "type": "Municipality"
    },
    {
      "code": "ME-22",
      "name": "Gusinje",
      "type": "Municipality"
    },
    {
      "code": "ME-23",
      "name": "Petnjica",
      "type": "Municipality"
    },
    {
      "code": "ME-24",
      "name": "Tuzi",
      "type": "Municipality"
    },
    {
      "code": "MG-A",
      "name": "Toamasina",
      "type": "Province"
    },
    {
      "code": "MG-D",
      "name": "Antsiranana",
      "type": "Province"
    },
    {
      "code": "MG-F",
      "name": "Fianarantsoa",
      "type": "Province"
    },
    {
      "code": "MG-M",
      "name": "Mahajanga",
      "type": "Province"
    },
    {
      "code": "MG-T",
      "name": "Antananarivo",
      "type": "Province"
    },
    {
      "code": "MG-U",
      "name": "Toliara",
      "type": "Province"
    },
    {
      "code": "MH-ALK",
      "name": "Ailuk",
      "parent": "T",
      "type": "Municipality"
    },
    {
      "code": "MH-ALL",
      "name": "Ailinglaplap",
      "parent": "L",
      "type": "Municipality"
    },
    {
      "code": "MH-ARN",
      "name": "Arno",
      "parent": "T",
      "type": "Municipality"
    },
    {
      "code": "MH-AUR",
      "name": "Aur",
      "parent": "T",
      "type": "Municipality"
    },
    {
      "code": "MH-EBO",
      "name": "Ebon",
      "parent": "L",
      "type": "Municipality"
    },
    {
      "code": "MH-ENI",
      "name": "Enewetak & Ujelang",
      "parent": "L",
      "type": "Municipality"
    },
    {
      "code": "MH-JAB",
      "name": "Jabat",
      "parent": "L",
      "type": "Municipality"
    },
    {
      "code": "MH-JAL",
      "name": "Jaluit",
      "parent": "L",
      "type": "Municipality"
    },
    {
      "code": "MH-KIL",
      "name": "Bikini & Kili",
      "parent": "L",
      "type": "Municipality"
    },
    {
      "code": "MH-KWA",
      "name": "Kwajalein",
      "parent": "L",
      "type": "Municipality"
    },
    {
      "code": "MH-L",
      "name": "Ralik chain",
      "type": "Chain (of islands)"
    },
    {
      "code": "MH-LAE",
      "name": "Lae",
      "parent": "L",
      "type": "Municipality"
    },
    {
      "code": "MH-LIB",
      "name": "Lib",
      "parent": "L",
      "type": "Municipality"
    },
    {
      "code": "MH-LIK",
      "name": "Likiep",
      "parent": "T",
      "type": "Municipality"
    },
    {
      "code": "MH-MAJ",
      "name": "Majuro",
      "parent": "T",
      "type": "Municipality"
    },
    {
      "code": "MH-MAL",
      "name": "Maloelap",
      "parent": "T",
      "type": "Municipality"
    },
    {
      "code": "MH-MEJ",
      "name": "Mejit",
      "parent": "T",
      "type": "Municipality"
    },
    {
      "code": "MH-MIL",
      "name": "Mili",
      "parent": "T",
      "type": "Municipality"
    },
    {
      "code": "MH-NMK",
      "name": "Namdrik",
      "parent": "L",
      "type": "Municipality"
    },
    {
      "code": "MH-NMU",
      "name": "Namu",
      "parent": "L",
      "type": "Municipality"
    },
    {
      "code": "MH-RON",
      "name": "Rongelap",
      "parent": "L",
      "type": "Municipality"
    },
    {
      "code": "MH-T",
      "name": "Ratak chain",
      "type": "Chain (of islands)"
    },
    {
      "code": "MH-UJA",
      "name": "Ujae",
      "parent": "L",
      "type": "Municipality"
    },
    {
      "code": "MH-UTI",
      "name": "Utrik",
      "parent": "T",
      "type": "Municipality"
    },
    {
      "code": "MH-WTH",
      "name": "Wotho",
      "parent": "L",
      "type": "Municipality"
    },
    {
      "code": "MH-WTJ",
      "name": "Wotje",
      "parent": "T",
      "type": "Municipality"
    },
    {
      "code": "MK-101",
      "name": "Veles",
      "type": "Municipality"
    },
    {
      "code": "MK-102",
      "name": "Gradsko",
      "type": "Municipality"
    },
    {
      "code": "MK-103",
      "name": "Demir Kapija",
      "type": "Municipality"
    },
    {
      "code": "MK-104",
      "name": "Kavadarci",
      "type": "Municipality"
    },
    {
      "code": "MK-105",
      "name": "Lozovo",
      "type": "Municipality"
    },
    {
      "code": "MK-106",
      "name": "Negotino",
      "type": "Municipality"
    },
    {
      "code": "MK-107",
      "name": "Rosoman",
      "type": "Municipality"
    },
    {
      "code": "MK-108",
      "name": "Sveti Nikole",
      "type": "Municipality"
    },
    {
      "code": "MK-109",
      "name": "Čaška",
      "type": "Municipality"
    },
    {
      "code": "MK-201",
      "name": "Berovo",
      "type": "Municipality"
    },
    {
      "code": "MK-202",
      "name": "Vinica",
      "type": "Municipality"
    },
    {
      "code": "MK-203",
      "name": "Delčevo",
      "type": "Municipality"
    },
    {
      "code": "MK-204",
      "name": "Zrnovci",
      "type": "Municipality"
    },
    {
      "code": "MK-205",
      "name": "Karbinci",
      "type": "Municipality"
    },
    {
      "code": "MK-206",
      "name": "Kočani",
      "type": "Municipality"
    },
    {
      "code": "MK-207",
      "name": "Makedonska Kamenica",
      "type": "Municipality"
    },
    {
      "code": "MK-208",
      "name": "Pehčevo",
      "type": "Municipality"
    },
    {
      "code": "MK-209",
      "name": "Probištip",
      "type": "Municipality"
    },
    {
      "code": "MK-210",
      "name": "Češinovo-Obleševo",
      "type": "Municipality"
    },
    {
      "code": "MK-211",
      "name": "Štip",
      "type": "Municipality"
    },
    {
      "code": "MK-301",
      "name": "Vevčani",
      "type": "Municipality"
    },
    {
      "code": "MK-303",
      "name": "Debar",
      "type": "Municipality"
    },
    {
      "code": "MK-304",
      "name": "Debrca",
      "type": "Municipality"
    },
    {
      "code": "MK-307",
      "name": "Kičevo",
      "type": "Municipality"
    },
    {
      "code": "MK-308",
      "name": "Makedonski Brod",
      "type": "Municipality"
    },
    {
      "code": "MK-310",
      "name": "Ohrid",
      "type": "Municipality"
    },
    {
      "code": "MK-311",
      "name": "Plasnica",
      "type": "Municipality"
    },
    {
      "code": "MK-312",
      "name": "Struga",
      "type": "Municipality"
    },
    {
      "code": "MK-313",
      "name": "Centar Župa",
      "type": "Municipality"
    },
    {
      "code": "MK-401",
      "name": "Bogdanci",
      "type": "Municipality"
    },
    {
      "code": "MK-402",
      "name": "Bosilovo",
      "type": "Municipality"
    },
    {
      "code": "MK-403",
      "name": "Valandovo",
      "type": "Municipality"
    },
    {
      "code": "MK-404",
      "name": "Vasilevo",
      "type": "Municipality"
    },
    {
      "code": "MK-405",
      "name": "Gevgelija",
      "type": "Municipality"
    },
    {
      "code": "MK-406",
      "name": "Dojran",
      "type": "Municipality"
    },
    {
      "code": "MK-407",
      "name": "Konče",
      "type": "Municipality"
    },
    {
      "code": "MK-408",
      "name": "Novo Selo",
      "type": "Municipality"
    },
    {
      "code": "MK-409",
      "name": "Radoviš",
      "type": "Municipality"
    },
    {
      "code": "MK-410",
      "name": "Strumica",
      "type": "Municipality"
    },
    {
      "code": "MK-501",
      "name": "Bitola",
      "type": "Municipality"
    },
    {
      "code": "MK-502",
      "name": "Demir Hisar",
      "type": "Municipality"
    },
    {
      "code": "MK-503",
      "name": "Dolneni",
      "type": "Municipality"
    },
    {
      "code": "MK-504",
      "name": "Krivogaštani",
      "type": "Municipality"
    },
    {
      "code": "MK-505",
      "name": "Kruševo",
      "type": "Municipality"
    },
    {
      "code": "MK-506",
      "name": "Mogila",
      "type": "Municipality"
    },
    {
      "code": "MK-507",
      "name": "Novaci",
      "type": "Municipality"
    },
    {
      "code": "MK-508",
      "name": "Prilep",
      "type": "Municipality"
    },
    {
      "code": "MK-509",
      "name": "Resen",
      "type": "Municipality"
    },
    {
      "code": "MK-601",
      "name": "Bogovinje",
      "type": "Municipality"
    },
    {
      "code": "MK-602",
      "name": "Brvenica",
      "type": "Municipality"
    },
    {
      "code": "MK-603",
      "name": "Vrapčište",
      "type": "Municipality"
    },
    {
      "code": "MK-604",
      "name": "Gostivar",
      "type": "Municipality"
    },
    {
      "code": "MK-605",
      "name": "Želino",
      "type": "Municipality"
    },
    {
      "code": "MK-606",
      "name": "Jegunovce",
      "type": "Municipality"
    },
    {
      "code": "MK-607",
      "name": "Mavrovo i Rostuše",
      "type": "Municipality"
    },
    {
      "code": "MK-608",
      "name": "Tearce",
      "type": "Municipality"
    },
    {
      "code": "MK-609",
      "name": "Tetovo",
      "type": "Municipality"
    },
    {
      "code": "MK-701",
      "name": "Kratovo",
      "type": "Municipality"
    },
    {
      "code": "MK-702",
      "name": "Kriva Palanka",
      "type": "Municipality"
    },
    {
      "code": "MK-703",
      "name": "Kumanovo",
      "type": "Municipality"
    },
    {
      "code": "MK-704",
      "name": "Lipkovo",
      "type": "Municipality"
    },
    {
      "code": "MK-705",
      "name": "Rankovce",
      "type": "Municipality"
    },
    {
      "code": "MK-706",
      "name": "Staro Nagoričane",
      "type": "Municipality"
    },
    {
      "code": "MK-801",
      "name": "Aerodrom †",
      "type": "Municipality"
    },
    {
      "code": "MK-802",
      "name": "Aračinovo",
      "type": "Municipality"
    },
    {
      "code": "MK-803",
      "name": "Butel †",
      "type": "Municipality"
    },
    {
      "code": "MK-804",
      "name": "Gazi Baba †",
      "type": "Municipality"
    },
    {
      "code": "MK-805",
      "name": "Gjorče Petrov †",
      "type": "Municipality"
    },
    {
      "code": "MK-806",
      "name": "Zelenikovo",
      "type": "Municipality"
    },
    {
      "code": "MK-807",
      "name": "Ilinden",
      "type": "Municipality"
    },
    {
      "code": "MK-808",
      "name": "Karpoš †",
      "type": "Municipality"
    },
    {
      "code": "MK-809",
      "name": "Kisela Voda †",
      "type": "Municipality"
    },
    {
      "code": "MK-810",
      "name": "Petrovec",
      "type": "Municipality"
    },
    {
      "code": "MK-811",
      "name": "Saraj †",
      "type": "Municipality"
    },
    {
      "code": "MK-812",
      "name": "Sopište",
      "type": "Municipality"
    },
    {
      "code": "MK-813",
      "name": "Studeničani",
      "type": "Municipality"
    },
    {
      "code": "MK-814",
      "name": "Centar †",
      "type": "Municipality"
    },
    {
      "code": "MK-815",
      "name": "Čair †",
      "type": "Municipality"
    },
    {
      "code": "MK-816",
      "name": "Čučer-Sandevo",
      "type": "Municipality"
    },
    {
      "code": "MK-817",
      "name": "Šuto Orizari †",
      "type": "Municipality"
    },
    {
      "code": "ML-1",
      "name": "Kayes",
      "type": "Region"
    },
    {
      "code": "ML-10",
      "name": "Taoudénit",
      "type": "Region"
    },
    {
      "code": "ML-2",
      "name": "Koulikoro",
      "type": "Region"
    },
    {
      "code": "ML-3",
      "name": "Sikasso",
      "type": "Region"
    },
    {
      "code": "ML-4",
      "name": "Ségou",
      "type": "Region"
    },
    {
      "code": "ML-5",
      "name": "Mopti",
      "type": "Region"
    },
    {
      "code": "ML-6",
      "name": "Tombouctou",
      "type": "Region"
    },
    {
      "code": "ML-7",
      "name": "Gao",
      "type": "Region"
    },
    {
      "code": "ML-8",
      "name": "Kidal",
      "type": "Region"
    },
    {
      "code": "ML-9",
      "name": "Ménaka",
      "type": "Region"
    },
    {
      "code": "ML-BKO",
      "name": "Bamako",
      "type": "District"
    },
    {
      "code": "MM-01",
      "name": "Sagaing",
      "type": "Region"
    },
    {
      "code": "MM-02",
      "name": "Bago",
      "type": "Region"
    },
    {
      "code": "MM-03",
      "name": "Magway",
      "type": "Region"
    },
    {
      "code": "MM-04",
      "name": "Mandalay",
      "type": "Region"
    },
    {
      "code": "MM-05",
      "name": "Tanintharyi",
      "type": "Region"
    },
    {
      "code": "MM-06",
      "name": "Yangon",
      "type": "Region"
    },
    {
      "code": "MM-07",
      "name": "Ayeyarwady",
      "type": "Region"
    },
    {
      "code": "MM-11",
      "name": "Kachin",
      "type": "State"
    },
    {
      "code": "MM-12",
      "name": "Kayah",
      "type": "State"
    },
    {
      "code": "MM-13",
      "name": "Kayin",
      "type": "State"
    },
    {
      "code": "MM-14",
      "name": "Chin",
      "type": "State"
    },
    {
      "code": "MM-15",
      "name": "Mon",
      "type": "State"
    },
    {
      "code": "MM-16",
      "name": "Rakhine",
      "type": "State"
    },
    {
      "code": "MM-17",
      "name": "Shan",
      "type": "State"
    },
    {
      "code": "MM-18",
      "name": "Nay Pyi Taw",
      "type": "Union territory"
    },
    {
      "code": "MN-035",
      "name": "Orhon",
      "type": "Province"
    },
    {
      "code": "MN-037",
      "name": "Darhan uul",
      "type": "Province"
    },
    {
      "code": "MN-039",
      "name": "Hentiy",
      "type": "Province"
    },
    {
      "code": "MN-041",
      "name": "Hövsgöl",
      "type": "Province"
    },
    {
      "code": "MN-043",
      "name": "Hovd",
      "type": "Province"
    },
    {
      "code": "MN-046",
      "name": "Uvs",
      "type": "Province"
    },
    {
      "code": "MN-047",
      "name": "Töv",
      "type": "Province"
    },
    {
      "code": "MN-049",
      "name": "Selenge",
      "type": "Province"
    },
    {
      "code": "MN-051",
      "name": "Sühbaatar",
      "type": "Province"
    },
    {
      "code": "MN-053",
      "name": "Ömnögovĭ",
      "type": "Province"
    },
    {
      "code": "MN-055",
      "name": "Övörhangay",
      "type": "Province"
    },
    {
      "code": "MN-057",
      "name": "Dzavhan",
      "type": "Province"
    },
    {
      "code": "MN-059",
      "name": "Dundgovĭ",
      "type": "Province"
    },
    {
      "code": "MN-061",
      "name": "Dornod",
      "type": "Province"
    },
    {
      "code": "MN-063",
      "name": "Dornogovĭ",
      "type": "Province"
    },
    {
      "code": "MN-064",
      "name": "Govĭ-Sümber",
      "type": "Province"
    },
    {
      "code": "MN-065",
      "name": "Govĭ-Altay",
      "type": "Province"
    },
    {
      "code": "MN-067",
      "name": "Bulgan",
      "type": "Province"
    },
    {
      "code": "MN-069",
      "name": "Bayanhongor",
      "type": "Province"
    },
    {
      "code": "MN-071",
      "name": "Bayan-Ölgiy",
      "type": "Province"
    },
    {
      "code": "MN-073",
      "name": "Arhangay",
      "type": "Province"
    },
    {
      "code": "MN-1",
      "name": "Ulaanbaatar",
      "type": "Capital city"
    },
    {
      "code": "MR-01",
      "name": "Hodh ech Chargui",
      "type": "Region"
    },
    {
      "code": "MR-02",
      "name": "Hodh el Gharbi",
      "type": "Region"
    },
    {
      "code": "MR-03",
      "name": "Assaba",
      "type": "Region"
    },
    {
      "code": "MR-04",
      "name": "Gorgol",
      "type": "Region"
    },
    {
      "code": "MR-05",
      "name": "Brakna",
      "type": "Region"
    },
    {
      "code": "MR-06",
      "name": "Trarza",
      "type": "Region"
    },
    {
      "code": "MR-07",
      "name": "Adrar",
      "type": "Region"
    },
    {
      "code": "MR-08",
      "name": "Dakhlet Nouâdhibou",
      "type": "Region"
    },
    {
      "code": "MR-09",
      "name": "Tagant",
      "type": "Region"
    },
    {
      "code": "MR-10",
      "name": "Guidimaka",
      "type": "Region"
    },
    {
      "code": "MR-11",
      "name": "Tiris Zemmour",
      "type": "Region"
    },
    {
      "code": "MR-12",
      "name": "Inchiri",
      "type": "Region"
    },
    {
      "code": "MR-13",
      "name": "Nouakchott Ouest",
      "type": "Region"
    },
    {
      "code": "MR-14",
      "name": "Nouakchott Nord",
      "type": "Region"
    },
    {
      "code": "MR-15",
      "name": "Nouakchott Sud",
      "type": "Region"
    },
    {
      "code": "MT-01",
      "name": "Attard",
      "type": "Local council"
    },
    {
      "code": "MT-02",
      "name": "Balzan",
      "type": "Local council"
    },
    {
      "code": "MT-03",
      "name": "Birgu",
      "type": "Local council"
    },
    {
      "code": "MT-04",
      "name": "Birkirkara",
      "type": "Local council"
    },
    {
      "code": "MT-05",
      "name": "Birżebbuġa",
      "type": "Local council"
    },
    {
      "code": "MT-06",
      "name": "Bormla",
      "type": "Local council"
    },
    {
      "code": "MT-07",
      "name": "Dingli",
      "type": "Local council"
    },
    {
      "code": "MT-08",
      "name": "Fgura",
      "type": "Local council"
    },
    {
      "code": "MT-09",
      "name": "Floriana",
      "type": "Local council"
    },
    {
      "code": "MT-10",
      "name": "Fontana",
      "type": "Local council"
    },
    {
      "code": "MT-11",
      "name": "Gudja",
      "type": "Local council"
    },
    {
      "code": "MT-12",
      "name": "Gżira",
      "type": "Local council"
    },
    {
      "code": "MT-13",
      "name": "Għajnsielem",
      "type": "Local council"
    },
    {
      "code": "MT-14",
      "name": "Għarb",
      "type": "Local council"
    },
    {
      "code": "MT-15",
      "name": "Għargħur",
      "type": "Local council"
    },
    {
      "code": "MT-16",
      "name": "Għasri",
      "type": "Local council"
    },
    {
      "code": "MT-17",
      "name": "Għaxaq",
      "type": "Local council"
    },
    {
      "code": "MT-18",
      "name": "Ħamrun",
      "type": "Local council"
    },
    {
      "code": "MT-19",
      "name": "Iklin",
      "type": "Local council"
    },
    {
      "code": "MT-20",
      "name": "Isla",
      "type": "Local council"
    },
    {
      "code": "MT-21",
      "name": "Kalkara",
      "type": "Local council"
    },
    {
      "code": "MT-22",
      "name": "Kerċem",
      "type": "Local council"
    },
    {
      "code": "MT-23",
      "name": "Kirkop",
      "type": "Local council"
    },
    {
      "code": "MT-24",
      "name": "Lija",
      "type": "Local council"
    },
    {
      "code": "MT-25",
      "name": "Luqa",
      "type": "Local council"
    },
    {
      "code": "MT-26",
      "name": "Marsa",
      "type": "Local council"
    },
    {
      "code": "MT-27",
      "name": "Marsaskala",
      "type": "Local council"
    },
    {
      "code": "MT-28",
      "name": "Marsaxlokk",
      "type": "Local council"
    },
    {
      "code": "MT-29",
      "name": "Mdina",
      "type": "Local council"
    },
    {
      "code": "MT-30",
      "name": "Mellieħa",
      "type": "Local council"
    },
    {
      "code": "MT-31",
      "name": "Mġarr",
      "type": "Local council"
    },
    {
      "code": "MT-32",
      "name": "Mosta",
      "type": "Local council"
    },
    {
      "code": "MT-33",
      "name": "Mqabba",
      "type": "Local council"
    },
    {
      "code": "MT-34",
      "name": "Msida",
      "type": "Local council"
    },
    {
      "code": "MT-35",
      "name": "Mtarfa",
      "type": "Local council"
    },
    {
      "code": "MT-36",
      "name": "Munxar",
      "type": "Local council"
    },
    {
      "code": "MT-37",
      "name": "Nadur",
      "type": "Local council"
    },
    {
      "code": "MT-38",
      "name": "Naxxar",
      "type": "Local council"
    },
    {
      "code": "MT-39",
      "name": "Paola",
      "type": "Local council"
    },
    {
      "code": "MT-40",
      "name": "Pembroke",
      "type": "Local council"
    },
    {
      "code": "MT-41",
      "name": "Pietà",
      "type": "Local council"
    },
    {
      "code": "MT-42",
      "name": "Qala",
      "type": "Local council"
    },
    {
      "code": "MT-43",
      "name": "Qormi",
      "type": "Local council"
    },
    {
      "code": "MT-44",
      "name": "Qrendi",
      "type": "Local council"
    },
    {
      "code": "MT-45",
      "name": "Rabat Gozo",
      "type": "Local council"
    },
    {
      "code": "MT-46",
      "name": "Rabat Malta",
      "type": "Local council"
    },
    {
      "code": "MT-47",
      "name": "Safi",
      "type": "Local council"
    },
    {
      "code": "MT-48",
      "name": "Saint Julian's",
      "type": "Local council"
    },
    {
      "code": "MT-49",
      "name": "Saint John",
      "type": "Local council"
    },
    {
      "code": "MT-50",
      "name": "Saint Lawrence",
      "type": "Local council"
    },
    {
      "code": "MT-51",
      "name": "Saint Paul's Bay",
      "type": "Local council"
    },
    {
      "code": "MT-52",
      "name": "Sannat",
      "type": "Local council"
    },
    {
      "code": "MT-53",
      "name": "Saint Lucia's",
      "type": "Local council"
    },
    {
      "code": "MT-54",
      "name": "Santa Venera",
      "type": "Local council"
    },
    {
      "code": "MT-55",
      "name": "Siġġiewi",
      "type": "Local council"
    },
    {
      "code": "MT-56",
      "name": "Sliema",
      "type": "Local council"
    },
    {
      "code": "MT-57",
      "name": "Swieqi",
      "type": "Local council"
    },
    {
      "code": "MT-58",
      "name": "Ta' Xbiex",
      "type": "Local council"
    },
    {
      "code": "MT-59",
      "name": "Tarxien",
      "type": "Local council"
    },
    {
      "code": "MT-60",
      "name": "Valletta",
      "type": "Local council"
    },
    {
      "code": "MT-61",
      "name": "Xagħra",
      "type": "Local council"
    },
    {
      "code": "MT-62",
      "name": "Xewkija",
      "type": "Local council"
    },
    {
      "code": "MT-63",
      "name": "Xgħajra",
      "type": "Local council"
    },
    {
      "code": "MT-64",
      "name": "Żabbar",
      "type": "Local council"
    },
    {
      "code": "MT-65",
      "name": "Żebbuġ Gozo",
      "type": "Local council"
    },
    {
      "code": "MT-66",
      "name": "Żebbuġ Malta",
      "type": "Local council"
    },
    {
      "code": "MT-67",
      "name": "Żejtun",
      "type": "Local council"
    },
    {
      "code": "MT-68",
      "name": "Żurrieq",
      "type": "Local council"
    },
    {
      "code": "MU-AG",
      "name": "Agalega Islands",
      "type": "Dependency"
    },
    {
      "code": "MU-BL",
      "name": "Black River",
      "type": "District"
    },
    {
      "code": "MU-CC",
      "name": "Cargados Carajos Shoals",
      "type": "Dependency"
    },
    {
      "code": "MU-FL",
      "name": "Flacq",
      "type": "District"
    },
    {
      "code": "MU-GP",
      "name": "Grand Port",
      "type": "District"
    },
    {
      "code": "MU-MO",
      "name": "Moka",
      "type": "District"
    },
    {
      "code": "MU-PA",
      "name": "Pamplemousses",
      "type": "District"
    },
    {
      "code": "MU-PL",
      "name": "Port Louis",
      "type": "District"
    },
    {
      "code": "MU-PW",
      "name": "Plaines Wilhems",
      "type": "District"
    },
    {
      "code": "MU-RO",
      "name": "Rodrigues Island",
      "type": "Dependency"
    },
    {
      "code": "MU-RR",
      "name": "Rivière du Rempart",
      "type": "District"
    },
    {
      "code": "MU-SA",
      "name": "Savanne",
      "type": "District"
    },
    {
      "code": "MV-00",
      "name": "South Ari Atoll",
      "type": "Administrative atoll"
    },
    {
      "code": "MV-01",
      "name": "Addu City",
      "type": "City"
    },
    {
      "code": "MV-02",
      "name": "North Ari Atoll",
      "type": "Administrative atoll"
    },
    {
      "code": "MV-03",
      "name": "Faadhippolhu",
      "type": "Administrative atoll"
    },
    {
      "code": "MV-04",
      "name": "Felidhu Atoll",
      "type": "Administrative atoll"
    },
    {
      "code": "MV-05",
      "name": "Hahdhunmathi",
      "type": "Administrative atoll"
    },
    {
      "code": "MV-07",
      "name": "North Thiladhunmathi",
      "type": "Administrative atoll"
    },
    {
      "code": "MV-08",
      "name": "Kolhumadulu",
      "type": "Administrative atoll"
    },
    {
      "code": "MV-12",
      "name": "Mulaku Atoll",
      "type": "Administrative atoll"
    },
    {
      "code": "MV-13",
      "name": "North Maalhosmadulu",
      "type": "Administrative atoll"
    },
    {
      "code": "MV-14",
      "name": "North Nilandhe Atoll",
      "type": "Administrative atoll"
    },
    {
      "code": "MV-17",
      "name": "South Nilandhe Atoll",
      "type": "Administrative atoll"
    },
    {
      "code": "MV-20",
      "name": "South Maalhosmadulu",
      "type": "Administrative atoll"
    },
    {
      "code": "MV-23",
      "name": "South Thiladhunmathi",
      "type": "Administrative atoll"
    },
    {
      "code": "MV-24",
      "name": "North Miladhunmadulu",
      "type": "Administrative atoll"
    },
    {
      "code": "MV-25",
      "name": "South Miladhunmadulu",
      "type": "Administrative atoll"
    },
    {
      "code": "MV-26",
      "name": "Male Atoll",
      "type": "Administrative atoll"
    },
    {
      "code": "MV-27",
      "name": "North Huvadhu Atoll",
      "type": "Administrative atoll"
    },
    {
      "code": "MV-28",
      "name": "South Huvadhu Atoll",
      "type": "Administrative atoll"
    },
    {
      "code": "MV-29",
      "name": "Fuvammulah",
      "type": "Administrative atoll"
    },
    {
      "code": "MV-MLE",
      "name": "Male",
      "type": "City"
    },
    {
      "code": "MW-BA",
      "name": "Balaka",
      "parent": "S",
      "type": "District"
    },
    {
      "code": "MW-BL",
      "name": "Blantyre",
      "parent": "S",
      "type": "District"
    },
    {
      "code": "MW-C",
      "name": "Central Region",
      "type": "Region"
    },
    {
      "code": "MW-CK",
      "name": "Chikwawa",
      "parent": "S",
      "type": "District"
    },
    {
      "code": "MW-CR",
      "name": "Chiradzulu",
      "parent": "S",
      "type": "District"
    },
    {
      "code": "MW-CT",
      "name": "Chitipa",
      "parent": "N",
      "type": "District"
    },
    {
      "code": "MW-DE",
      "name": "Dedza",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "MW-DO",
      "name": "Dowa",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "MW-KR",
      "name": "Karonga",
      "parent": "N",
      "type": "District"
    },
    {
      "code": "MW-KS",
      "name": "Kasungu",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "MW-LI",
      "name": "Lilongwe",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "MW-LK",
      "name": "Likoma",
      "parent": "N",
      "type": "District"
    },
    {
      "code": "MW-MC",
      "name": "Mchinji",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "MW-MG",
      "name": "Mangochi",
      "parent": "S",
      "type": "District"
    },
    {
      "code": "MW-MH",
      "name": "Machinga",
      "parent": "S",
      "type": "District"
    },
    {
      "code": "MW-MU",
      "name": "Mulanje",
      "parent": "S",
      "type": "District"
    },
    {
      "code": "MW-MW",
      "name": "Mwanza",
      "parent": "S",
      "type": "District"
    },
    {
      "code": "MW-MZ",
      "name": "Mzimba",
      "parent": "N",
      "type": "District"
    },
    {
      "code": "MW-N",
      "name": "Northern Region",
      "type": "Region"
    },
    {
      "code": "MW-NB",
      "name": "Nkhata Bay",
      "parent": "N",
      "type": "District"
    },
    {
      "code": "MW-NE",
      "name": "Neno",
      "parent": "S",
      "type": "District"
    },
    {
      "code": "MW-NI",
      "name": "Ntchisi",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "MW-NK",
      "name": "Nkhotakota",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "MW-NS",
      "name": "Nsanje",
      "parent": "S",
      "type": "District"
    },
    {
      "code": "MW-NU",
      "name": "Ntcheu",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "MW-PH",
      "name": "Phalombe",
      "parent": "S",
      "type": "District"
    },
    {
      "code": "MW-RU",
      "name": "Rumphi",
      "parent": "N",
      "type": "District"
    },
    {
      "code": "MW-S",
      "name": "Southern Region",
      "type": "Region"
    },
    {
      "code": "MW-SA",
      "name": "Salima",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "MW-TH",
      "name": "Thyolo",
      "parent": "S",
      "type": "District"
    },
    {
      "code": "MW-ZO",
      "name": "Zomba",
      "parent": "S",
      "type": "District"
    },
    {
      "code": "MX-AGU",
      "name": "Aguascalientes",
      "type": "State"
    },
    {
      "code": "MX-BCN",
      "name": "Baja California",
      "type": "State"
    },
    {
      "code": "MX-BCS",
      "name": "Baja California Sur",
      "type": "State"
    },
    {
      "code": "MX-CAM",
      "name": "Campeche",
      "type": "State"
    },
    {
      "code": "MX-CHH",
      "name": "Chihuahua",
      "type": "State"
    },
    {
      "code": "MX-CHP",
      "name": "Chiapas",
      "type": "State"
    },
    {
      "code": "MX-CMX",
      "name": "Ciudad de México",
      "type": "Federal district"
    },
    {
      "code": "MX-COA",
      "name": "Coahuila de Zaragoza",
      "type": "State"
    },
    {
      "code": "MX-COL",
      "name": "Colima",
      "type": "State"
    },
    {
      "code": "MX-DUR",
      "name": "Durango",
      "type": "State"
    },
    {
      "code": "MX-GRO",
      "name": "Guerrero",
      "type": "State"
    },
    {
      "code": "MX-GUA",
      "name": "Guanajuato",
      "type": "State"
    },
    {
      "code": "MX-HID",
      "name": "Hidalgo",
      "type": "State"
    },
    {
      "code": "MX-JAL",
      "name": "Jalisco",
      "type": "State"
    },
    {
      "code": "MX-MEX",
      "name": "México",
      "type": "State"
    },
    {
      "code": "MX-MIC",
      "name": "Michoacán de Ocampo",
      "type": "State"
    },
    {
      "code": "MX-MOR",
      "name": "Morelos",
      "type": "State"
    },
    {
      "code": "MX-NAY",
      "name": "Nayarit",
      "type": "State"
    },
    {
      "code": "MX-NLE",
      "name": "Nuevo León",
      "type": "State"
    },
    {
      "code": "MX-OAX",
      "name": "Oaxaca",
      "type": "State"
    },
    {
      "code": "MX-PUE",
      "name": "Puebla",
      "type": "State"
    },
    {
      "code": "MX-QUE",
      "name": "Querétaro",
      "type": "State"
    },
    {
      "code": "MX-ROO",
      "name": "Quintana Roo",
      "type": "State"
    },
    {
      "code": "MX-SIN",
      "name": "Sinaloa",
      "type": "State"
    },
    {
      "code": "MX-SLP",
      "name": "San Luis Potosí",
      "type": "State"
    },
    {
      "code": "MX-SON",
      "name": "Sonora",
      "type": "State"
    },
    {
      "code": "MX-TAB",
      "name": "Tabasco",
      "type": "State"
    },
    {
      "code": "MX-TAM",
      "name": "Tamaulipas",
      "type": "State"
    },
    {
      "code": "MX-TLA",
      "name": "Tlaxcala",
      "type": "State"
    },
    {
      "code": "MX-VER",
      "name": "Veracruz de Ignacio de la Llave",
      "type": "State"
    },
    {
      "code": "MX-YUC",
      "name": "Yucatán",
      "type": "State"
    },
    {
      "code": "MX-ZAC",
      "name": "Zacatecas",
      "type": "State"
    },
    {
      "code": "MY-01",
      "name": "Johor",
      "type": "State"
    },
    {
      "code": "MY-02",
      "name": "Kedah",
      "type": "State"
    },
    {
      "code": "MY-03",
      "name": "Kelantan",
      "type": "State"
    },
    {
      "code": "MY-04",
      "name": "Melaka",
      "type": "State"
    },
    {
      "code": "MY-05",
      "name": "Negeri Sembilan",
      "type": "State"
    },
    {
      "code": "MY-06",
      "name": "Pahang",
      "type": "State"
    },
    {
      "code": "MY-07",
      "name": "Pulau Pinang",
      "type": "State"
    },
    {
      "code": "MY-08",
      "name": "Perak",
      "type": "State"
    },
    {
      "code": "MY-09",
      "name": "Perlis",
      "type": "State"
    },
    {
      "code": "MY-10",
      "name": "Selangor",
      "type": "State"
    },
    {
      "code": "MY-11",
      "name": "Terengganu",
      "type": "State"
    },
    {
      "code": "MY-12",
      "name": "Sabah",
      "type": "State"
    },
    {
      "code": "MY-13",
      "name": "Sarawak",
      "type": "State"
    },
    {
      "code": "MY-14",
      "name": "Wilayah Persekutuan Kuala Lumpur",
      "type": "Federal territory"
    },
    {
      "code": "MY-15",
      "name": "Wilayah Persekutuan Labuan",
      "type": "Federal territory"
    },
    {
      "code": "MY-16",
      "name": "Wilayah Persekutuan Putrajaya",
      "type": "Federal territory"
    },
    {
      "code": "MZ-A",
      "name": "Niassa",
      "type": "Province"
    },
    {
      "code": "MZ-B",
      "name": "Manica",
      "type": "Province"
    },
    {
      "code": "MZ-G",
      "name": "Gaza",
      "type": "Province"
    },
    {
      "code": "MZ-I",
      "name": "Inhambane",
      "type": "Province"
    },
    {
      "code": "MZ-L",
      "name": "Maputo",
      "type": "Province"
    },
    {
      "code": "MZ-MPM",
      "name": "Maputo",
      "type": "City"
    },
    {
      "code": "MZ-N",
      "name": "Nampula",
      "type": "Province"
    },
    {
      "code": "MZ-P",
      "name": "Cabo Delgado",
      "type": "Province"
    },
    {
      "code": "MZ-Q",
      "name": "Zambézia",
      "type": "Province"
    },
    {
      "code": "MZ-S",
      "name": "Sofala",
      "type": "Province"
    },
    {
      "code": "MZ-T",
      "name": "Tete",
      "type": "Province"
    },
    {
      "code": "NA-CA",
      "name": "Zambezi",
      "type": "Region"
    },
    {
      "code": "NA-ER",
      "name": "Erongo",
      "type": "Region"
    },
    {
      "code": "NA-HA",
      "name": "Hardap",
      "type": "Region"
    },
    {
      "code": "NA-KA",
      "name": "//Karas",
      "type": "Region"
    },
    {
      "code": "NA-KE",
      "name": "Kavango East",
      "type": "Region"
    },
    {
      "code": "NA-KH",
      "name": "Khomas",
      "type": "Region"
    },
    {
      "code": "NA-KU",
      "name": "Kunene",
      "type": "Region"
    },
    {
      "code": "NA-KW",
      "name": "Kavango West",
      "type": "Region"
    },
    {
      "code": "NA-OD",
      "name": "Otjozondjupa",
      "type": "Region"
    },
    {
      "code": "NA-OH",
      "name": "Omaheke",
      "type": "Region"
    },
    {
      "code": "NA-ON",
      "name": "Oshana",
      "type": "Region"
    },
    {
      "code": "NA-OS",
      "name": "Omusati",
      "type": "Region"
    },
    {
      "code": "NA-OT",
      "name": "Oshikoto",
      "type": "Region"
    },
    {
      "code": "NA-OW",
      "name": "Ohangwena",
      "type": "Region"
    },
    {
      "code": "NE-1",
      "name": "Agadez",
      "type": "Region"
    },
    {
      "code": "NE-2",
      "name": "Diffa",
      "type": "Region"
    },
    {
      "code": "NE-3",
      "name": "Dosso",
      "type": "Region"
    },
    {
      "code": "NE-4",
      "name": "Maradi",
      "type": "Region"
    },
    {
      "code": "NE-5",
      "name": "Tahoua",
      "type": "Region"
    },
    {
      "code": "NE-6",
      "name": "Tillabéri",
      "type": "Region"
    },
    {
      "code": "NE-7",
      "name": "Zinder",
      "type": "Region"
    },
    {
      "code": "NE-8",
      "name": "Niamey",
      "type": "Urban community"
    },
    {
      "code": "NG-AB",
      "name": "Abia",
      "type": "State"
    },
    {
      "code": "NG-AD",
      "name": "Adamawa",
      "type": "State"
    },
    {
      "code": "NG-AK",
      "name": "Akwa Ibom",
      "type": "State"
    },
    {
      "code": "NG-AN",
      "name": "Anambra",
      "type": "State"
    },
    {
      "code": "NG-BA",
      "name": "Bauchi",
      "type": "State"
    },
    {
      "code": "NG-BE",
      "name": "Benue",
      "type": "State"
    },
    {
      "code": "NG-BO",
      "name": "Borno",
      "type": "State"
    },
    {
      "code": "NG-BY",
      "name": "Bayelsa",
      "type": "State"
    },
    {
      "code": "NG-CR",
      "name": "Cross River",
      "type": "State"
    },
    {
      "code": "NG-DE",
      "name": "Delta",
      "type": "State"
    },
    {
      "code": "NG-EB",
      "name": "Ebonyi",
      "type": "State"
    },
    {
      "code": "NG-ED",
      "name": "Edo",
      "type": "State"
    },
    {
      "code": "NG-EK",
      "name": "Ekiti",
      "type": "State"
    },
    {
      "code": "NG-EN",
      "name": "Enugu",
      "type": "State"
    },
    {
      "code": "NG-FC",
      "name": "Abuja Federal Capital Territory",
      "type": "Capital territory"
    },
    {
      "code": "NG-GO",
      "name": "Gombe",
      "type": "State"
    },
    {
      "code": "NG-IM",
      "name": "Imo",
      "type": "State"
    },
    {
      "code": "NG-JI",
      "name": "Jigawa",
      "type": "State"
    },
    {
      "code": "NG-KD",
      "name": "Kaduna",
      "type": "State"
    },
    {
      "code": "NG-KE",
      "name": "Kebbi",
      "type": "State"
    },
    {
      "code": "NG-KN",
      "name": "Kano",
      "type": "State"
    },
    {
      "code": "NG-KO",
      "name": "Kogi",
      "type": "State"
    },
    {
      "code": "NG-KT",
      "name": "Katsina",
      "type": "State"
    },
    {
      "code": "NG-KW",
      "name": "Kwara",
      "type": "State"
    },
    {
      "code": "NG-LA",
      "name": "Lagos",
      "type": "State"
    },
    {
      "code": "NG-NA",
      "name": "Nasarawa",
      "type": "State"
    },
    {
      "code": "NG-NI",
      "name": "Niger",
      "type": "State"
    },
    {
      "code": "NG-OG",
      "name": "Ogun",
      "type": "State"
    },
    {
      "code": "NG-ON",
      "name": "Ondo",
      "type": "State"
    },
    {
      "code": "NG-OS",
      "name": "Osun",
      "type": "State"
    },
    {
      "code": "NG-OY",
      "name": "Oyo",
      "type": "State"
    },
    {
      "code": "NG-PL",
      "name": "Plateau",
      "type": "State"
    },
    {
      "code": "NG-RI",
      "name": "Rivers",
      "type": "State"
    },
    {
      "code": "NG-SO",
      "name": "Sokoto",
      "type": "State"
    },
    {
      "code": "NG-TA",
      "name": "Taraba",
      "type": "State"
    },
    {
      "code": "NG-YO",
      "name": "Yobe",
      "type": "State"
    },
    {
      "code": "NG-ZA",
      "name": "Zamfara",
      "type": "State"
    },
    {
      "code": "NI-AN",
      "name": "Costa Caribe Norte",
      "type": "Autonomous region"
    },
    {
      "code": "NI-AS",
      "name": "Costa Caribe Sur",
      "type": "Autonomous region"
    },
    {
      "code": "NI-BO",
      "name": "Boaco",
      "type": "Department"
    },
    {
      "code": "NI-CA",
      "name": "Carazo",
      "type": "Department"
    },
    {
      "code": "NI-CI",
      "name": "Chinandega",
      "type": "Department"
    },
    {
      "code": "NI-CO",
      "name": "Chontales",
      "type": "Department"
    },
    {
      "code": "NI-ES",
      "name": "Estelí",
      "type": "Department"
    },
    {
      "code": "NI-GR",
      "name": "Granada",
      "type": "Department"
    },
    {
      "code": "NI-JI",
      "name": "Jinotega",
      "type": "Department"
    },
    {
      "code": "NI-LE",
      "name": "León",
      "type": "Department"
    },
    {
      "code": "NI-MD",
      "name": "Madriz",
      "type": "Department"
    },
    {
      "code": "NI-MN",
      "name": "Managua",
      "type": "Department"
    },
    {
      "code": "NI-MS",
      "name": "Masaya",
      "type": "Department"
    },
    {
      "code": "NI-MT",
      "name": "Matagalpa",
      "type": "Department"
    },
    {
      "code": "NI-NS",
      "name": "Nueva Segovia",
      "type": "Department"
    },
    {
      "code": "NI-RI",
      "name": "Rivas",
      "type": "Department"
    },
    {
      "code": "NI-SJ",
      "name": "Río San Juan",
      "type": "Department"
    },
    {
      "code": "NL-AW",
      "name": "Aruba",
      "type": "Country"
    },
    {
      "code": "NL-BQ1",
      "name": "Bonaire",
      "type": "Special municipality"
    },
    {
      "code": "NL-BQ2",
      "name": "Saba",
      "type": "Special municipality"
    },
    {
      "code": "NL-BQ3",
      "name": "Sint Eustatius",
      "type": "Special municipality"
    },
    {
      "code": "NL-CW",
      "name": "Curaçao",
      "type": "Country"
    },
    {
      "code": "NL-DR",
      "name": "Drenthe",
      "type": "Province"
    },
    {
      "code": "NL-FL",
      "name": "Flevoland",
      "type": "Province"
    },
    {
      "code": "NL-FR",
      "name": "Fryslân",
      "type": "Province"
    },
    {
      "code": "NL-GE",
      "name": "Gelderland",
      "type": "Province"
    },
    {
      "code": "NL-GR",
      "name": "Groningen",
      "type": "Province"
    },
    {
      "code": "NL-LI",
      "name": "Limburg",
      "type": "Province"
    },
    {
      "code": "NL-NB",
      "name": "Noord-Brabant",
      "type": "Province"
    },
    {
      "code": "NL-NH",
      "name": "Noord-Holland",
      "type": "Province"
    },
    {
      "code": "NL-OV",
      "name": "Overijssel",
      "type": "Province"
    },
    {
      "code": "NL-SX",
      "name": "Sint Maarten",
      "type": "Country"
    },
    {
      "code": "NL-UT",
      "name": "Utrecht",
      "type": "Province"
    },
    {
      "code": "NL-ZE",
      "name": "Zeeland",
      "type": "Province"
    },
    {
      "code": "NL-ZH",
      "name": "Zuid-Holland",
      "type": "Province"
    },
    {
      "code": "NO-03",
      "name": "Oslo",
      "type": "County"
    },
    {
      "code": "NO-11",
      "name": "Rogaland",
      "type": "County"
    },
    {
      "code": "NO-15",
      "name": "Møre og Romsdal",
      "type": "County"
    },
    {
      "code": "NO-18",
      "name": "Nordland",
      "type": "County"
    },
    {
      "code": "NO-21",
      "name": "Svalbard (Arctic Region)",
      "type": "Arctic region"
    },
    {
      "code": "NO-22",
      "name": "Jan Mayen (Arctic Region)",
      "type": "Arctic region"
    },
    {
      "code": "NO-30",
      "name": "Viken",
      "type": "County"
    },
    {
      "code": "NO-34",
      "name": "Innlandet",
      "type": "County"
    },
    {
      "code": "NO-38",
      "name": "Vestfold og Telemark",
      "type": "County"
    },
    {
      "code": "NO-42",
      "name": "Agder",
      "type": "County"
    },
    {
      "code": "NO-46",
      "name": "Vestland",
      "type": "County"
    },
    {
      "code": "NO-50",
      "name": "Trööndelage",
      "type": "County"
    },
    {
      "code": "NO-54",
      "name": "Romssa ja Finnmárkku",
      "type": "County"
    },
    {
      "code": "NP-1",
      "name": "Central",
      "type": "Development region"
    },
    {
      "code": "NP-2",
      "name": "Mid Western",
      "type": "Development region"
    },
    {
      "code": "NP-3",
      "name": "Western",
      "type": "Development region"
    },
    {
      "code": "NP-4",
      "name": "Eastern",
      "type": "Development region"
    },
    {
      "code": "NP-5",
      "name": "Far Western",
      "type": "Development region"
    },
    {
      "code": "NP-BA",
      "name": "Bagmati",
      "parent": "1",
      "type": "Zone"
    },
    {
      "code": "NP-BH",
      "name": "Bheri",
      "parent": "2",
      "type": "Zone"
    },
    {
      "code": "NP-DH",
      "name": "Dhawalagiri",
      "parent": "3",
      "type": "Zone"
    },
    {
      "code": "NP-GA",
      "name": "Gandaki",
      "parent": "3",
      "type": "Zone"
    },
    {
      "code": "NP-JA",
      "name": "Janakpur",
      "parent": "1",
      "type": "Zone"
    },
    {
      "code": "NP-KA",
      "name": "Karnali",
      "parent": "2",
      "type": "Zone"
    },
    {
      "code": "NP-KO",
      "name": "Kosi",
      "parent": "4",
      "type": "Zone"
    },
    {
      "code": "NP-LU",
      "name": "Lumbini",
      "parent": "3",
      "type": "Zone"
    },
    {
      "code": "NP-MA",
      "name": "Mahakali",
      "parent": "5",
      "type": "Zone"
    },
    {
      "code": "NP-ME",
      "name": "Mechi",
      "parent": "4",
      "type": "Zone"
    },
    {
      "code": "NP-NA",
      "name": "Narayani",
      "parent": "1",
      "type": "Zone"
    },
    {
      "code": "NP-P1",
      "name": "Province 1",
      "type": "Province"
    },
    {
      "code": "NP-P2",
      "name": "Province 2",
      "type": "Province"
    },
    {
      "code": "NP-P3",
      "name": "Bāgmatī",
      "type": "Province"
    },
    {
      "code": "NP-P4",
      "name": "Gandaki",
      "type": "Province"
    },
    {
      "code": "NP-P5",
      "name": "Province 5",
      "type": "Province"
    },
    {
      "code": "NP-P6",
      "name": "Karnali",
      "type": "Province"
    },
    {
      "code": "NP-P7",
      "name": "Sudūr Pashchim",
      "type": "Province"
    },
    {
      "code": "NP-RA",
      "name": "Rapti",
      "parent": "2",
      "type": "Zone"
    },
    {
      "code": "NP-SA",
      "name": "Sagarmatha",
      "parent": "4",
      "type": "Zone"
    },
    {
      "code": "NP-SE",
      "name": "Seti",
      "parent": "5",
      "type": "Zone"
    },
    {
      "code": "NR-01",
      "name": "Aiwo",
      "type": "District"
    },
    {
      "code": "NR-02",
      "name": "Anabar",
      "type": "District"
    },
    {
      "code": "NR-03",
      "name": "Anetan",
      "type": "District"
    },
    {
      "code": "NR-04",
      "name": "Anibare",
      "type": "District"
    },
    {
      "code": "NR-05",
      "name": "Baitsi",
      "type": "District"
    },
    {
      "code": "NR-06",
      "name": "Boe",
      "type": "District"
    },
    {
      "code": "NR-07",
      "name": "Buada",
      "type": "District"
    },
    {
      "code": "NR-08",
      "name": "Denigomodu",
      "type": "District"
    },
    {
      "code": "NR-09",
      "name": "Ewa",
      "type": "District"
    },
    {
      "code": "NR-10",
      "name": "Ijuw",
      "type": "District"
    },
    {
      "code": "NR-11",
      "name": "Meneng",
      "type": "District"
    },
    {
      "code": "NR-12",
      "name": "Nibok",
      "type": "District"
    },
    {
      "code": "NR-13",
      "name": "Uaboe",
      "type": "District"
    },
    {
      "code": "NR-14",
      "name": "Yaren",
      "type": "District"
    },
    {
      "code": "NZ-AUK",
      "name": "Auckland",
      "type": "Region"
    },
    {
      "code": "NZ-BOP",
      "name": "Bay of Plenty",
      "type": "Region"
    },
    {
      "code": "NZ-CAN",
      "name": "Canterbury",
      "type": "Region"
    },
    {
      "code": "NZ-CIT",
      "name": "Chatham Islands Territory",
      "type": "Special island authority"
    },
    {
      "code": "NZ-GIS",
      "name": "Gisborne",
      "type": "Region"
    },
    {
      "code": "NZ-HKB",
      "name": "Hawke's Bay",
      "type": "Region"
    },
    {
      "code": "NZ-MBH",
      "name": "Marlborough",
      "type": "Region"
    },
    {
      "code": "NZ-MWT",
      "name": "Manawatu-Wanganui",
      "type": "Region"
    },
    {
      "code": "NZ-NSN",
      "name": "Nelson",
      "type": "Region"
    },
    {
      "code": "NZ-NTL",
      "name": "Northland",
      "type": "Region"
    },
    {
      "code": "NZ-OTA",
      "name": "Otago",
      "type": "Region"
    },
    {
      "code": "NZ-STL",
      "name": "Southland",
      "type": "Region"
    },
    {
      "code": "NZ-TAS",
      "name": "Tasman",
      "type": "Region"
    },
    {
      "code": "NZ-TKI",
      "name": "Taranaki",
      "type": "Region"
    },
    {
      "code": "NZ-WGN",
      "name": "Wellington",
      "type": "Region"
    },
    {
      "code": "NZ-WKO",
      "name": "Waikato",
      "type": "Region"
    },
    {
      "code": "NZ-WTC",
      "name": "West Coast",
      "type": "Region"
    },
    {
      "code": "OM-BJ",
      "name": "Janūb al Bāţinah",
      "type": "Governorate"
    },
    {
      "code": "OM-BS",
      "name": "Shamāl al Bāţinah",
      "type": "Governorate"
    },
    {
      "code": "OM-BU",
      "name": "Al Buraymī",
      "type": "Governorate"
    },
    {
      "code": "OM-DA",
      "name": "Ad Dākhilīyah",
      "type": "Governorate"
    },
    {
      "code": "OM-MA",
      "name": "Masqaţ",
      "type": "Governorate"
    },
    {
      "code": "OM-MU",
      "name": "Musandam",
      "type": "Governorate"
    },
    {
      "code": "OM-SJ",
      "name": "Janūb ash Sharqīyah",
      "type": "Governorate"
    },
    {
      "code": "OM-SS",
      "name": "Shamāl ash Sharqīyah",
      "type": "Governorate"
    },
    {
      "code": "OM-WU",
      "name": "Al Wusţá",
      "type": "Governorate"
    },
    {
      "code": "OM-ZA",
      "name": "Az̧ Z̧āhirah",
      "type": "Governorate"
    },
    {
      "code": "OM-ZU",
      "name": "Z̧ufār",
      "type": "Governorate"
    },
    {
      "code": "PA-1",
      "name": "Bocas del Toro",
      "type": "Province"
    },
    {
      "code": "PA-10",
      "name": "Panamá Oeste",
      "type": "Province"
    },
    {
      "code": "PA-2",
      "name": "Coclé",
      "type": "Province"
    },
    {
      "code": "PA-3",
      "name": "Colón",
      "type": "Province"
    },
    {
      "code": "PA-4",
      "name": "Chiriquí",
      "type": "Province"
    },
    {
      "code": "PA-5",
      "name": "Darién",
      "type": "Province"
    },
    {
      "code": "PA-6",
      "name": "Herrera",
      "type": "Province"
    },
    {
      "code": "PA-7",
      "name": "Los Santos",
      "type": "Province"
    },
    {
      "code": "PA-8",
      "name": "Panamá",
      "type": "Province"
    },
    {
      "code": "PA-9",
      "name": "Veraguas",
      "type": "Province"
    },
    {
      "code": "PA-EM",
      "name": "Emberá",
      "type": "Indigenous region"
    },
    {
      "code": "PA-KY",
      "name": "Guna Yala",
      "type": "Indigenous region"
    },
    {
      "code": "PA-NB",
      "name": "Ngöbe-Buglé",
      "type": "Indigenous region"
    },
    {
      "code": "PE-AMA",
      "name": "Amarumayu",
      "type": "Region"
    },
    {
      "code": "PE-ANC",
      "name": "Ancash",
      "type": "Region"
    },
    {
      "code": "PE-APU",
      "name": "Apurimaq",
      "type": "Region"
    },
    {
      "code": "PE-ARE",
      "name": "Arequipa",
      "type": "Region"
    },
    {
      "code": "PE-AYA",
      "name": "Ayacucho",
      "type": "Region"
    },
    {
      "code": "PE-CAJ",
      "name": "Cajamarca",
      "type": "Region"
    },
    {
      "code": "PE-CAL",
      "name": "El Callao",
      "type": "Region"
    },
    {
      "code": "PE-CUS",
      "name": "Cusco",
      "type": "Region"
    },
    {
      "code": "PE-HUC",
      "name": "Huánuco",
      "type": "Region"
    },
    {
      "code": "PE-HUV",
      "name": "Huancavelica",
      "type": "Region"
    },
    {
      "code": "PE-ICA",
      "name": "Ica",
      "type": "Region"
    },
    {
      "code": "PE-JUN",
      "name": "Hunin",
      "type": "Region"
    },
    {
      "code": "PE-LAL",
      "name": "La Libertad",
      "type": "Region"
    },
    {
      "code": "PE-LAM",
      "name": "Lambayeque",
      "type": "Region"
    },
    {
      "code": "PE-LIM",
      "name": "Lima",
      "type": "Region"
    },
    {
      "code": "PE-LMA",
      "name": "Lima hatun llaqta",
      "type": "Municipality"
    },
    {
      "code": "PE-LOR",
      "name": "Loreto",
      "type": "Region"
    },
    {
      "code": "PE-MDD",
      "name": "Madre de Dios",
      "type": "Region"
    },
    {
      "code": "PE-MOQ",
      "name": "Moquegua",
      "type": "Region"
    },
    {
      "code": "PE-PAS",
      "name": "Pasco",
      "type": "Region"
    },
    {
      "code": "PE-PIU",
      "name": "Piura",
      "type": "Region"
    },
    {
      "code": "PE-PUN",
      "name": "Puno",
      "type": "Region"
    },
    {
      "code": "PE-SAM",
      "name": "San Martin",
      "type": "Region"
    },
    {
      "code": "PE-TAC",
      "name": "Tacna",
      "type": "Region"
    },
    {
      "code": "PE-TUM",
      "name": "Tumbes",
      "type": "Region"
    },
    {
      "code": "PE-UCA",
      "name": "Ucayali",
      "type": "Region"
    },
    {
      "code": "PG-CPK",
      "name": "Chimbu",
      "type": "Province"
    },
    {
      "code": "PG-CPM",
      "name": "Central",
      "type": "Province"
    },
    {
      "code": "PG-EBR",
      "name": "East New Britain",
      "type": "Province"
    },
    {
      "code": "PG-EHG",
      "name": "Eastern Highlands",
      "type": "Province"
    },
    {
      "code": "PG-EPW",
      "name": "Enga",
      "type": "Province"
    },
    {
      "code": "PG-ESW",
      "name": "East Sepik",
      "type": "Province"
    },
    {
      "code": "PG-GPK",
      "name": "Gulf",
      "type": "Province"
    },
    {
      "code": "PG-HLA",
      "name": "Hela",
      "type": "Province"
    },
    {
      "code": "PG-JWK",
      "name": "Jiwaka",
      "type": "Province"
    },
    {
      "code": "PG-MBA",
      "name": "Milne Bay",
      "type": "Province"
    },
    {
      "code": "PG-MPL",
      "name": "Morobe",
      "type": "Province"
    },
    {
      "code": "PG-MPM",
      "name": "Madang",
      "type": "Province"
    },
    {
      "code": "PG-MRL",
      "name": "Manus",
      "type": "Province"
    },
    {
      "code": "PG-NCD",
      "name": "National Capital District (Port Moresby)",
      "type": "District"
    },
    {
      "code": "PG-NIK",
      "name": "New Ireland",
      "type": "Province"
    },
    {
      "code": "PG-NPP",
      "name": "Northern",
      "type": "Province"
    },
    {
      "code": "PG-NSB",
      "name": "Bougainville",
      "type": "Autonomous region"
    },
    {
      "code": "PG-SAN",
      "name": "West Sepik",
      "type": "Province"
    },
    {
      "code": "PG-SHM",
      "name": "Southern Highlands",
      "type": "Province"
    },
    {
      "code": "PG-WBK",
      "name": "West New Britain",
      "type": "Province"
    },
    {
      "code": "PG-WHM",
      "name": "Western Highlands",
      "type": "Province"
    },
    {
      "code": "PG-WPD",
      "name": "Western",
      "type": "Province"
    },
    {
      "code": "PH-00",
      "name": "National Capital Region",
      "type": "Region"
    },
    {
      "code": "PH-01",
      "name": "Ilocos (Region I)",
      "type": "Region"
    },
    {
      "code": "PH-02",
      "name": "Cagayan Valley (Region II)",
      "type": "Region"
    },
    {
      "code": "PH-03",
      "name": "Central Luzon (Region III)",
      "type": "Region"
    },
    {
      "code": "PH-05",
      "name": "Bicol (Region V)",
      "type": "Region"
    },
    {
      "code": "PH-06",
      "name": "Western Visayas (Region VI)",
      "type": "Region"
    },
    {
      "code": "PH-07",
      "name": "Central Visayas (Region VII)",
      "type": "Region"
    },
    {
      "code": "PH-08",
      "name": "Eastern Visayas (Region VIII)",
      "type": "Region"
    },
    {
      "code": "PH-09",
      "name": "Zamboanga Peninsula (Region IX)",
      "type": "Region"
    },
    {
      "code": "PH-10",
      "name": "Northern Mindanao (Region X)",
      "type": "Region"
    },
    {
      "code": "PH-11",
      "name": "Davao (Region XI)",
      "type": "Region"
    },
    {
      "code": "PH-12",
      "name": "Soccsksargen (Region XII)",
      "type": "Region"
    },
    {
      "code": "PH-13",
      "name": "Caraga (Region XIII)",
      "type": "Region"
    },
    {
      "code": "PH-14",
      "name": "Autonomous Region in Muslim Mindanao (ARMM)",
      "type": "Region"
    },
    {
      "code": "PH-15",
      "name": "Cordillera Administrative Region (CAR)",
      "type": "Region"
    },
    {
      "code": "PH-40",
      "name": "Calabarzon (Region IV-A)",
      "type": "Region"
    },
    {
      "code": "PH-41",
      "name": "Mimaropa (Region IV-B)",
      "type": "Region"
    },
    {
      "code": "PH-ABR",
      "name": "Abra",
      "parent": "15",
      "type": "Province"
    },
    {
      "code": "PH-AGN",
      "name": "Agusan del Norte",
      "parent": "13",
      "type": "Province"
    },
    {
      "code": "PH-AGS",
      "name": "Agusan del Sur",
      "parent": "13",
      "type": "Province"
    },
    {
      "code": "PH-AKL",
      "name": "Aklan",
      "parent": "06",
      "type": "Province"
    },
    {
      "code": "PH-ALB",
      "name": "Albay",
      "parent": "05",
      "type": "Province"
    },
    {
      "code": "PH-ANT",
      "name": "Antique",
      "parent": "06",
      "type": "Province"
    },
    {
      "code": "PH-APA",
      "name": "Apayao",
      "parent": "15",
      "type": "Province"
    },
    {
      "code": "PH-AUR",
      "name": "Aurora",
      "parent": "03",
      "type": "Province"
    },
    {
      "code": "PH-BAN",
      "name": "Bataan",
      "parent": "03",
      "type": "Province"
    },
    {
      "code": "PH-BAS",
      "name": "Basilan",
      "parent": "09",
      "type": "Province"
    },
    {
      "code": "PH-BEN",
      "name": "Benguet",
      "parent": "15",
      "type": "Province"
    },
    {
      "code": "PH-BIL",
      "name": "Biliran",
      "parent": "08",
      "type": "Province"
    },
    {
      "code": "PH-BOH",
      "name": "Bohol",
      "parent": "07",
      "type": "Province"
    },
    {
      "code": "PH-BTG",
      "name": "Batangas",
      "parent": "40",
      "type": "Province"
    },
    {
      "code": "PH-BTN",
      "name": "Batanes",
      "parent": "02",
      "type": "Province"
    },
    {
      "code": "PH-BUK",
      "name": "Bukidnon",
      "parent": "10",
      "type": "Province"
    },
    {
      "code": "PH-BUL",
      "name": "Bulacan",
      "parent": "03",
      "type": "Province"
    },
    {
      "code": "PH-CAG",
      "name": "Cagayan",
      "parent": "02",
      "type": "Province"
    },
    {
      "code": "PH-CAM",
      "name": "Camiguin",
      "parent": "10",
      "type": "Province"
    },
    {
      "code": "PH-CAN",
      "name": "Camarines Norte",
      "parent": "05",
      "type": "Province"
    },
    {
      "code": "PH-CAP",
      "name": "Capiz",
      "parent": "06",
      "type": "Province"
    },
    {
      "code": "PH-CAS",
      "name": "Camarines Sur",
      "parent": "05",
      "type": "Province"
    },
    {
      "code": "PH-CAT",
      "name": "Catanduanes",
      "parent": "05",
      "type": "Province"
    },
    {
      "code": "PH-CAV",
      "name": "Cavite",
      "parent": "40",
      "type": "Province"
    },
    {
      "code": "PH-CEB",
      "name": "Cebu",
      "parent": "07",
      "type": "Province"
    },
    {
      "code": "PH-COM",
      "name": "Davao de Oro",
      "parent": "11",
      "type": "Province"
    },
    {
      "code": "PH-DAO",
      "name": "Davao Oriental",
      "parent": "11",
      "type": "Province"
    },
    {
      "code": "PH-DAS",
      "name": "Davao del Sur",
      "parent": "11",
      "type": "Province"
    },
    {
      "code": "PH-DAV",
      "name": "Davao del Norte",
      "parent": "11",
      "type": "Province"
    },
    {
      "code": "PH-DIN",
      "name": "Dinagat Islands",
      "parent": "13",
      "type": "Province"
    },
    {
      "code": "PH-DVO",
      "name": "Davao Occidental",
      "parent": "11",
      "type": "Province"
    },
    {
      "code": "PH-EAS",
      "name": "Eastern Samar",
      "parent": "08",
      "type": "Province"
    },
    {
      "code": "PH-GUI",
      "name": "Guimaras",
      "parent": "06",
      "type": "Province"
    },
    {
      "code": "PH-IFU",
      "name": "Ifugao",
      "parent": "15",
      "type": "Province"
    },
    {
      "code": "PH-ILI",
      "name": "Iloilo",
      "parent": "06",
      "type": "Province"
    },
    {
      "code": "PH-ILN",
      "name": "Ilocos Norte",
      "parent": "01",
      "type": "Province"
    },
    {
      "code": "PH-ILS",
      "name": "Ilocos Sur",
      "parent": "01",
      "type": "Province"
    },
    {
      "code": "PH-ISA",
      "name": "Isabela",
      "parent": "02",
      "type": "Province"
    },
    {
      "code": "PH-KAL",
      "name": "Kalinga",
      "parent": "15",
      "type": "Province"
    },
    {
      "code": "PH-LAG",
      "name": "Laguna",
      "parent": "40",
      "type": "Province"
    },
    {
      "code": "PH-LAN",
      "name": "Lanao del Norte",
      "parent": "12",
      "type": "Province"
    },
    {
      "code": "PH-LAS",
      "name": "Lanao del Sur",
      "parent": "14",
      "type": "Province"
    },
    {
      "code": "PH-LEY",
      "name": "Leyte",
      "parent": "08",
      "type": "Province"
    },
    {
      "code": "PH-LUN",
      "name": "La Union",
      "parent": "01",
      "type": "Province"
    },
    {
      "code": "PH-MAD",
      "name": "Marinduque",
      "parent": "41",
      "type": "Province"
    },
    {
      "code": "PH-MAG",
      "name": "Maguindanao",
      "parent": "14",
      "type": "Province"
    },
    {
      "code": "PH-MAS",
      "name": "Masbate",
      "parent": "05",
      "type": "Province"
    },
    {
      "code": "PH-MDC",
      "name": "Mindoro Occidental",
      "parent": "41",
      "type": "Province"
    },
    {
      "code": "PH-MDR",
      "name": "Mindoro Oriental",
      "parent": "41",
      "type": "Province"
    },
    {
      "code": "PH-MOU",
      "name": "Mountain Province",
      "parent": "15",
      "type": "Province"
    },
    {
      "code": "PH-MSC",
      "name": "Misamis Occidental",
      "parent": "10",
      "type": "Province"
    },
    {
      "code": "PH-MSR",
      "name": "Misamis Oriental",
      "parent": "10",
      "type": "Province"
    },
    {
      "code": "PH-NCO",
      "name": "Cotabato",
      "parent": "12",
      "type": "Province"
    },
    {
      "code": "PH-NEC",
      "name": "Negros Occidental",
      "parent": "06",
      "type": "Province"
    },
    {
      "code": "PH-NER",
      "name": "Negros Oriental",
      "parent": "07",
      "type": "Province"
    },
    {
      "code": "PH-NSA",
      "name": "Northern Samar",
      "parent": "08",
      "type": "Province"
    },
    {
      "code": "PH-NUE",
      "name": "Nueva Ecija",
      "parent": "03",
      "type": "Province"
    },
    {
      "code": "PH-NUV",
      "name": "Nueva Vizcaya",
      "parent": "02",
      "type": "Province"
    },
    {
      "code": "PH-PAM",
      "name": "Pampanga",
      "parent": "03",
      "type": "Province"
    },
    {
      "code": "PH-PAN",
      "name": "Pangasinan",
      "parent": "01",
      "type": "Province"
    },
    {
      "code": "PH-PLW",
      "name": "Palawan",
      "parent": "41",
      "type": "Province"
    },
    {
      "code": "PH-QUE",
      "name": "Quezon",
      "parent": "40",
      "type": "Province"
    },
    {
      "code": "PH-QUI",
      "name": "Quirino",
      "parent": "02",
      "type": "Province"
    },
    {
      "code": "PH-RIZ",
      "name": "Rizal",
      "parent": "40",
      "type": "Province"
    },
    {
      "code": "PH-ROM",
      "name": "Romblon",
      "parent": "41",
      "type": "Province"
    },
    {
      "code": "PH-SAR",
      "name": "Sarangani",
      "parent": "11",
      "type": "Province"
    },
    {
      "code": "PH-SCO",
      "name": "South Cotabato",
      "parent": "11",
      "type": "Province"
    },
    {
      "code": "PH-SIG",
      "name": "Siquijor",
      "parent": "07",
      "type": "Province"
    },
    {
      "code": "PH-SLE",
      "name": "Southern Leyte",
      "parent": "08",
      "type": "Province"
    },
    {
      "code": "PH-SLU",
      "name": "Sulu",
      "parent": "14",
      "type": "Province"
    },
    {
      "code": "PH-SOR",
      "name": "Sorsogon",
      "parent": "05",
      "type": "Province"
    },
    {
      "code": "PH-SUK",
      "name": "Sultan Kudarat",
      "parent": "12",
      "type": "Province"
    },
    {
      "code": "PH-SUN",
      "name": "Surigao del Norte",
      "parent": "13",
      "type": "Province"
    },
    {
      "code": "PH-SUR",
      "name": "Surigao del Sur",
      "parent": "13",
      "type": "Province"
    },
    {
      "code": "PH-TAR",
      "name": "Tarlac",
      "parent": "03",
      "type": "Province"
    },
    {
      "code": "PH-TAW",
      "name": "Tawi-Tawi",
      "parent": "14",
      "type": "Province"
    },
    {
      "code": "PH-WSA",
      "name": "Samar",
      "parent": "08",
      "type": "Province"
    },
    {
      "code": "PH-ZAN",
      "name": "Zamboanga del Norte",
      "parent": "09",
      "type": "Province"
    },
    {
      "code": "PH-ZAS",
      "name": "Zamboanga del Sur",
      "parent": "09",
      "type": "Province"
    },
    {
      "code": "PH-ZMB",
      "name": "Zambales",
      "parent": "03",
      "type": "Province"
    },
    {
      "code": "PH-ZSI",
      "name": "Zamboanga Sibugay",
      "parent": "09",
      "type": "Province"
    },
    {
      "code": "PK-BA",
      "name": "Balochistan",
      "type": "Province"
    },
    {
      "code": "PK-GB",
      "name": "Gilgit-Baltistan",
      "type": "Pakistan administered area"
    },
    {
      "code": "PK-IS",
      "name": "Islamabad",
      "type": "Federal capital territory"
    },
    {
      "code": "PK-JK",
      "name": "Azad Jammu and Kashmir",
      "type": "Pakistan administered area"
    },
    {
      "code": "PK-KP",
      "name": "Khyber Pakhtunkhwa",
      "type": "Province"
    },
    {
      "code": "PK-PB",
      "name": "Punjab",
      "type": "Province"
    },
    {
      "code": "PK-SD",
      "name": "Sindh",
      "type": "Province"
    },
    {
      "code": "PL-02",
      "name": "Dolnośląskie",
      "type": "Voivodship"
    },
    {
      "code": "PL-04",
      "name": "Kujawsko-pomorskie",
      "type": "Voivodship"
    },
    {
      "code": "PL-06",
      "name": "Lubelskie",
      "type": "Voivodship"
    },
    {
      "code": "PL-08",
      "name": "Lubuskie",
      "type": "Voivodship"
    },
    {
      "code": "PL-10",
      "name": "Łódzkie",
      "type": "Voivodship"
    },
    {
      "code": "PL-12",
      "name": "Małopolskie",
      "type": "Voivodship"
    },
    {
      "code": "PL-14",
      "name": "Mazowieckie",
      "type": "Voivodship"
    },
    {
      "code": "PL-16",
      "name": "Opolskie",
      "type": "Voivodship"
    },
    {
      "code": "PL-18",
      "name": "Podkarpackie",
      "type": "Voivodship"
    },
    {
      "code": "PL-20",
      "name": "Podlaskie",
      "type": "Voivodship"
    },
    {
      "code": "PL-22",
      "name": "Pomorskie",
      "type": "Voivodship"
    },
    {
      "code": "PL-24",
      "name": "Śląskie",
      "type": "Voivodship"
    },
    {
      "code": "PL-26",
      "name": "Świętokrzyskie",
      "type": "Voivodship"
    },
    {
      "code": "PL-28",
      "name": "Warmińsko-mazurskie",
      "type": "Voivodship"
    },
    {
      "code": "PL-30",
      "name": "Wielkopolskie",
      "type": "Voivodship"
    },
    {
      "code": "PL-32",
      "name": "Zachodniopomorskie",
      "type": "Voivodship"
    },
    {
      "code": "PS-BTH",
      "name": "Bethlehem",
      "type": "Governorate"
    },
    {
      "code": "PS-DEB",
      "name": "Deir El Balah",
      "type": "Governorate"
    },
    {
      "code": "PS-GZA",
      "name": "Gaza",
      "type": "Governorate"
    },
    {
      "code": "PS-HBN",
      "name": "Hebron",
      "type": "Governorate"
    },
    {
      "code": "PS-JEM",
      "name": "Jerusalem",
      "type": "Governorate"
    },
    {
      "code": "PS-JEN",
      "name": "Jenin",
      "type": "Governorate"
    },
    {
      "code": "PS-JRH",
      "name": "Jericho and Al Aghwar",
      "type": "Governorate"
    },
    {
      "code": "PS-KYS",
      "name": "Khan Yunis",
      "type": "Governorate"
    },
    {
      "code": "PS-NBS",
      "name": "Nablus",
      "type": "Governorate"
    },
    {
      "code": "PS-NGZ",
      "name": "North Gaza",
      "type": "Governorate"
    },
    {
      "code": "PS-QQA",
      "name": "Qalqilya",
      "type": "Governorate"
    },
    {
      "code": "PS-RBH",
      "name": "Ramallah",
      "type": "Governorate"
    },
    {
      "code": "PS-RFH",
      "name": "Rafah",
      "type": "Governorate"
    },
    {
      "code": "PS-SLT",
      "name": "Salfit",
      "type": "Governorate"
    },
    {
      "code": "PS-TBS",
      "name": "Tubas",
      "type": "Governorate"
    },
    {
      "code": "PS-TKM",
      "name": "Tulkarm",
      "type": "Governorate"
    },
    {
      "code": "PT-01",
      "name": "Aveiro",
      "type": "District"
    },
    {
      "code": "PT-02",
      "name": "Beja",
      "type": "District"
    },
    {
      "code": "PT-03",
      "name": "Braga",
      "type": "District"
    },
    {
      "code": "PT-04",
      "name": "Bragança",
      "type": "District"
    },
    {
      "code": "PT-05",
      "name": "Castelo Branco",
      "type": "District"
    },
    {
      "code": "PT-06",
      "name": "Coimbra",
      "type": "District"
    },
    {
      "code": "PT-07",
      "name": "Évora",
      "type": "District"
    },
    {
      "code": "PT-08",
      "name": "Faro",
      "type": "District"
    },
    {
      "code": "PT-09",
      "name": "Guarda",
      "type": "District"
    },
    {
      "code": "PT-10",
      "name": "Leiria",
      "type": "District"
    },
    {
      "code": "PT-11",
      "name": "Lisboa",
      "type": "District"
    },
    {
      "code": "PT-12",
      "name": "Portalegre",
      "type": "District"
    },
    {
      "code": "PT-13",
      "name": "Porto",
      "type": "District"
    },
    {
      "code": "PT-14",
      "name": "Santarém",
      "type": "District"
    },
    {
      "code": "PT-15",
      "name": "Setúbal",
      "type": "District"
    },
    {
      "code": "PT-16",
      "name": "Viana do Castelo",
      "type": "District"
    },
    {
      "code": "PT-17",
      "name": "Vila Real",
      "type": "District"
    },
    {
      "code": "PT-18",
      "name": "Viseu",
      "type": "District"
    },
    {
      "code": "PT-20",
      "name": "Região Autónoma dos Açores",
      "type": "Autonomous region"
    },
    {
      "code": "PT-30",
      "name": "Região Autónoma da Madeira",
      "type": "Autonomous region"
    },
    {
      "code": "PW-002",
      "name": "Aimeliik",
      "type": "State"
    },
    {
      "code": "PW-004",
      "name": "Airai",
      "type": "State"
    },
    {
      "code": "PW-010",
      "name": "Angaur",
      "type": "State"
    },
    {
      "code": "PW-050",
      "name": "Hatohobei",
      "type": "State"
    },
    {
      "code": "PW-100",
      "name": "Kayangel",
      "type": "State"
    },
    {
      "code": "PW-150",
      "name": "Koror",
      "type": "State"
    },
    {
      "code": "PW-212",
      "name": "Melekeok",
      "type": "State"
    },
    {
      "code": "PW-214",
      "name": "Ngaraard",
      "type": "State"
    },
    {
      "code": "PW-218",
      "name": "Ngarchelong",
      "type": "State"
    },
    {
      "code": "PW-222",
      "name": "Ngardmau",
      "type": "State"
    },
    {
      "code": "PW-224",
      "name": "Ngatpang",
      "type": "State"
    },
    {
      "code": "PW-226",
      "name": "Ngchesar",
      "type": "State"
    },
    {
      "code": "PW-227",
      "name": "Ngeremlengui",
      "type": "State"
    },
    {
      "code": "PW-228",
      "name": "Ngiwal",
      "type": "State"
    },
    {
      "code": "PW-350",
      "name": "Peleliu",
      "type": "State"
    },
    {
      "code": "PW-370",
      "name": "Sonsorol",
      "type": "State"
    },
    {
      "code": "PY-1",
      "name": "Concepción",
      "type": "Department"
    },
    {
      "code": "PY-10",
      "name": "Alto Paraná",
      "type": "Department"
    },
    {
      "code": "PY-11",
      "name": "Central",
      "type": "Department"
    },
    {
      "code": "PY-12",
      "name": "Ñeembucú",
      "type": "Department"
    },
    {
      "code": "PY-13",
      "name": "Amambay",
      "type": "Department"
    },
    {
      "code": "PY-14",
      "name": "Canindeyú",
      "type": "Department"
    },
    {
      "code": "PY-15",
      "name": "Presidente Hayes",
      "type": "Department"
    },
    {
      "code": "PY-16",
      "name": "Alto Paraguay",
      "type": "Department"
    },
    {
      "code": "PY-19",
      "name": "Boquerón",
      "type": "Department"
    },
    {
      "code": "PY-2",
      "name": "San Pedro",
      "type": "Department"
    },
    {
      "code": "PY-3",
      "name": "Cordillera",
      "type": "Department"
    },
    {
      "code": "PY-4",
      "name": "Guairá",
      "type": "Department"
    },
    {
      "code": "PY-5",
      "name": "Caaguazú",
      "type": "Department"
    },
    {
      "code": "PY-6",
      "name": "Caazapá",
      "type": "Department"
    },
    {
      "code": "PY-7",
      "name": "Itapúa",
      "type": "Department"
    },
    {
      "code": "PY-8",
      "name": "Misiones",
      "type": "Department"
    },
    {
      "code": "PY-9",
      "name": "Paraguarí",
      "type": "Department"
    },
    {
      "code": "PY-ASU",
      "name": "Asunción",
      "type": "Capital"
    },
    {
      "code": "QA-DA",
      "name": "Ad Dawḩah",
      "type": "Municipality"
    },
    {
      "code": "QA-KH",
      "name": "Al Khawr wa adh Dhakhīrah",
      "type": "Municipality"
    },
    {
      "code": "QA-MS",
      "name": "Ash Shamāl",
      "type": "Municipality"
    },
    {
      "code": "QA-RA",
      "name": "Ar Rayyān",
      "type": "Municipality"
    },
    {
      "code": "QA-SH",
      "name": "Ash Shīḩānīyah",
      "type": "Municipality"
    },
    {
      "code": "QA-US",
      "name": "Umm Şalāl",
      "type": "Municipality"
    },
    {
      "code": "QA-WA",
      "name": "Al Wakrah",
      "type": "Municipality"
    },
    {
      "code": "QA-ZA",
      "name": "Az̧ Z̧a‘āyin",
      "type": "Municipality"
    },
    {
      "code": "RO-AB",
      "name": "Alba",
      "type": "Department"
    },
    {
      "code": "RO-AG",
      "name": "Argeș",
      "type": "Department"
    },
    {
      "code": "RO-AR",
      "name": "Arad",
      "type": "Department"
    },
    {
      "code": "RO-B",
      "name": "București",
      "type": "Municipality"
    },
    {
      "code": "RO-BC",
      "name": "Bacău",
      "type": "Department"
    },
    {
      "code": "RO-BH",
      "name": "Bihor",
      "type": "Department"
    },
    {
      "code": "RO-BN",
      "name": "Bistrița-Năsăud",
      "type": "Department"
    },
    {
      "code": "RO-BR",
      "name": "Brăila",
      "type": "Department"
    },
    {
      "code": "RO-BT",
      "name": "Botoșani",
      "type": "Department"
    },
    {
      "code": "RO-BV",
      "name": "Brașov",
      "type": "Department"
    },
    {
      "code": "RO-BZ",
      "name": "Buzău",
      "type": "Department"
    },
    {
      "code": "RO-CJ",
      "name": "Cluj",
      "type": "Department"
    },
    {
      "code": "RO-CL",
      "name": "Călărași",
      "type": "Department"
    },
    {
      "code": "RO-CS",
      "name": "Caraș-Severin",
      "type": "Department"
    },
    {
      "code": "RO-CT",
      "name": "Constanța",
      "type": "Department"
    },
    {
      "code": "RO-CV",
      "name": "Covasna",
      "type": "Department"
    },
    {
      "code": "RO-DB",
      "name": "Dâmbovița",
      "type": "Department"
    },
    {
      "code": "RO-DJ",
      "name": "Dolj",
      "type": "Department"
    },
    {
      "code": "RO-GJ",
      "name": "Gorj",
      "type": "Department"
    },
    {
      "code": "RO-GL",
      "name": "Galați",
      "type": "Department"
    },
    {
      "code": "RO-GR",
      "name": "Giurgiu",
      "type": "Department"
    },
    {
      "code": "RO-HD",
      "name": "Hunedoara",
      "type": "Department"
    },
    {
      "code": "RO-HR",
      "name": "Harghita",
      "type": "Department"
    },
    {
      "code": "RO-IF",
      "name": "Ilfov",
      "type": "Department"
    },
    {
      "code": "RO-IL",
      "name": "Ialomița",
      "type": "Department"
    },
    {
      "code": "RO-IS",
      "name": "Iași",
      "type": "Department"
    },
    {
      "code": "RO-MH",
      "name": "Mehedinți",
      "type": "Department"
    },
    {
      "code": "RO-MM",
      "name": "Maramureș",
      "type": "Department"
    },
    {
      "code": "RO-MS",
      "name": "Mureș",
      "type": "Department"
    },
    {
      "code": "RO-NT",
      "name": "Neamț",
      "type": "Department"
    },
    {
      "code": "RO-OT",
      "name": "Olt",
      "type": "Department"
    },
    {
      "code": "RO-PH",
      "name": "Prahova",
      "type": "Department"
    },
    {
      "code": "RO-SB",
      "name": "Sibiu",
      "type": "Department"
    },
    {
      "code": "RO-SJ",
      "name": "Sălaj",
      "type": "Department"
    },
    {
      "code": "RO-SM",
      "name": "Satu Mare",
      "type": "Department"
    },
    {
      "code": "RO-SV",
      "name": "Suceava",
      "type": "Department"
    },
    {
      "code": "RO-TL",
      "name": "Tulcea",
      "type": "Department"
    },
    {
      "code": "RO-TM",
      "name": "Timiș",
      "type": "Department"
    },
    {
      "code": "RO-TR",
      "name": "Teleorman",
      "type": "Department"
    },
    {
      "code": "RO-VL",
      "name": "Vâlcea",
      "type": "Department"
    },
    {
      "code": "RO-VN",
      "name": "Vrancea",
      "type": "Department"
    },
    {
      "code": "RO-VS",
      "name": "Vaslui",
      "type": "Department"
    },
    {
      "code": "RS-00",
      "name": "Beograd",
      "type": "City"
    },
    {
      "code": "RS-01",
      "name": "Severnobački okrug",
      "parent": "VO",
      "type": "District"
    },
    {
      "code": "RS-02",
      "name": "Srednjebanatski okrug",
      "parent": "VO",
      "type": "District"
    },
    {
      "code": "RS-03",
      "name": "Severnobanatski okrug",
      "parent": "VO",
      "type": "District"
    },
    {
      "code": "RS-04",
      "name": "Južnobanatski okrug",
      "parent": "VO",
      "type": "District"
    },
    {
      "code": "RS-05",
      "name": "Zapadnobački okrug",
      "parent": "VO",
      "type": "District"
    },
    {
      "code": "RS-06",
      "name": "Južnobački okrug",
      "parent": "VO",
      "type": "District"
    },
    {
      "code": "RS-07",
      "name": "Sremski okrug",
      "parent": "VO",
      "type": "District"
    },
    {
      "code": "RS-08",
      "name": "Mačvanski okrug",
      "type": "District"
    },
    {
      "code": "RS-09",
      "name": "Kolubarski okrug",
      "type": "District"
    },
    {
      "code": "RS-10",
      "name": "Podunavski okrug",
      "type": "District"
    },
    {
      "code": "RS-11",
      "name": "Braničevski okrug",
      "type": "District"
    },
    {
      "code": "RS-12",
      "name": "Šumadijski okrug",
      "type": "District"
    },
    {
      "code": "RS-13",
      "name": "Pomoravski okrug",
      "type": "District"
    },
    {
      "code": "RS-14",
      "name": "Borski okrug",
      "type": "District"
    },
    {
      "code": "RS-15",
      "name": "Zaječarski okrug",
      "type": "District"
    },
    {
      "code": "RS-16",
      "name": "Zlatiborski okrug",
      "type": "District"
    },
    {
      "code": "RS-17",
      "name": "Moravički okrug",
      "type": "District"
    },
    {
      "code": "RS-18",
      "name": "Raški okrug",
      "type": "District"
    },
    {
      "code": "RS-19",
      "name": "Rasinski okrug",
      "type": "District"
    },
    {
      "code": "RS-20",
      "name": "Nišavski okrug",
      "type": "District"
    },
    {
      "code": "RS-21",
      "name": "Toplički okrug",
      "type": "District"
    },
    {
      "code": "RS-22",
      "name": "Pirotski okrug",
      "type": "District"
    },
    {
      "code": "RS-23",
      "name": "Jablanički okrug",
      "type": "District"
    },
    {
      "code": "RS-24",
      "name": "Pčinjski okrug",
      "type": "District"
    },
    {
      "code": "RS-25",
      "name": "Kosovski okrug",
      "parent": "KM",
      "type": "District"
    },
    {
      "code": "RS-26",
      "name": "Pećki okrug",
      "parent": "KM",
      "type": "District"
    },
    {
      "code": "RS-27",
      "name": "Prizrenski okrug",
      "parent": "KM",
      "type": "District"
    },
    {
      "code": "RS-28",
      "name": "Kosovsko-Mitrovački okrug",
      "parent": "KM",
      "type": "District"
    },
    {
      "code": "RS-29",
      "name": "Kosovsko-Pomoravski okrug",
      "parent": "KM",
      "type": "District"
    },
    {
      "code": "RS-KM",
      "name": "Kosovo-Metohija",
      "type": "Autonomous province"
    },
    {
      "code": "RS-VO",
      "name": "Vojvodina",
      "type": "Autonomous province"
    },
    {
      "code": "RU-AD",
      "name": "Adygeja, Respublika",
      "type": "Republic"
    },
    {
      "code": "RU-AL",
      "name": "Altaj, Respublika",
      "type": "Republic"
    },
    {
      "code": "RU-ALT",
      "name": "Altajskij kraj",
      "type": "Administrative territory"
    },
    {
      "code": "RU-AMU",
      "name": "Amurskaja oblast'",
      "type": "Administrative region"
    },
    {
      "code": "RU-ARK",
      "name": "Arhangel'skaja oblast'",
      "type": "Administrative region"
    },
    {
      "code": "RU-AST",
      "name": "Astrahanskaja oblast'",
      "type": "Administrative region"
    },
    {
      "code": "RU-BA",
      "name": "Bashkortostan, Respublika",
      "type": "Republic"
    },
    {
      "code": "RU-BEL",
      "name": "Belgorodskaja oblast'",
      "type": "Administrative region"
    },
    {
      "code": "RU-BRY",
      "name": "Brjanskaja oblast'",
      "type": "Administrative region"
    },
    {
      "code": "RU-BU",
      "name": "Burjatija, Respublika",
      "type": "Republic"
    },
    {
      "code": "RU-CE",
      "name": "Chechenskaya Respublika",
      "type": "Republic"
    },
    {
      "code": "RU-CHE",
      "name": "Chelyabinskaya oblast'",
      "type": "Administrative region"
    },
    {
      "code": "RU-CHU",
      "name": "Chukotskiy avtonomnyy okrug",
      "type": "Autonomous district"
    },
    {
      "code": "RU-CU",
      "name": "Chuvashskaya Respublika",
      "type": "Republic"
    },
    {
      "code": "RU-DA",
      "name": "Dagestan, Respublika",
      "type": "Republic"
    },
    {
      "code": "RU-IN",
      "name": "Ingushetiya, Respublika",
      "type": "Republic"
    },
    {
      "code": "RU-IRK",
      "name": "Irkutskaja oblast'",
      "type": "Administrative region"
    },
    {
      "code": "RU-IVA",
      "name": "Ivanovskaja oblast'",
      "type": "Administrative region"
    },
    {
      "code": "RU-KAM",
      "name": "Kamchatskiy kray",
      "type": "Administrative territory"
    },
    {
      "code": "RU-KB",
      "name": "Kabardino-Balkarskaja Respublika",
      "type": "Republic"
    },
    {
      "code": "RU-KC",
      "name": "Karachayevo-Cherkesskaya Respublika",
      "type": "Republic"
    },
    {
      "code": "RU-KDA",
      "name": "Krasnodarskij kraj",
      "type": "Administrative territory"
    },
    {
      "code": "RU-KEM",
      "name": "Kemerovskaja oblast'",
      "type": "Administrative region"
    },
    {
      "code": "RU-KGD",
      "name": "Kaliningradskaja oblast'",
      "type": "Administrative region"
    },
    {
      "code": "RU-KGN",
      "name": "Kurganskaja oblast'",
      "type": "Administrative region"
    },
    {
      "code": "RU-KHA",
      "name": "Habarovskij kraj",
      "type": "Administrative territory"
    },
    {
      "code": "RU-KHM",
      "name": "Hanty-Mansijskij avtonomnyj okrug",
      "type": "Autonomous district"
    },
    {
      "code": "RU-KIR",
      "name": "Kirovskaja oblast'",
      "type": "Administrative region"
    },
    {
      "code": "RU-KK",
      "name": "Hakasija, Respublika",
      "type": "Republic"
    },
    {
      "code": "RU-KL",
      "name": "Kalmykija, Respublika",
      "type": "Republic"
    },
    {
      "code": "RU-KLU",
      "name": "Kaluzhskaya oblast'",
      "type": "Administrative region"
    },
    {
      "code": "RU-KO",
      "name": "Komi, Respublika",
      "type": "Republic"
    },
    {
      "code": "RU-KOS",
      "name": "Kostromskaja oblast'",
      "type": "Administrative region"
    },
    {
      "code": "RU-KR",
      "name": "Karelija, Respublika",
      "type": "Republic"
    },
    {
      "code": "RU-KRS",
      "name": "Kurskaja oblast'",
      "type": "Administrative region"
    },
    {
      "code": "RU-KYA",
      "name": "Krasnojarskij kraj",
      "type": "Administrative territory"
    },
    {
      "code": "RU-LEN",
      "name": "Leningradskaja oblast'",
      "type": "Administrative region"
    },
    {
      "code": "RU-LIP",
      "name": "Lipeckaja oblast'",
      "type": "Administrative region"
    },
    {
      "code": "RU-MAG",
      "name": "Magadanskaja oblast'",
      "type": "Administrative region"
    },
    {
      "code": "RU-ME",
      "name": "Marij Èl, Respublika",
      "type": "Republic"
    },
    {
      "code": "RU-MO",
      "name": "Mordovija, Respublika",
      "type": "Republic"
    },
    {
      "code": "RU-MOS",
      "name": "Moskovskaja oblast'",
      "type": "Administrative region"
    },
    {
      "code": "RU-MOW",
      "name": "Moskva",
      "type": "Autonomous city"
    },
    {
      "code": "RU-MUR",
      "name": "Murmanskaja oblast'",
      "type": "Administrative region"
    },
    {
      "code": "RU-NEN",
      "name": "Neneckij avtonomnyj okrug",
      "type": "Autonomous district"
    },
    {
      "code": "RU-NGR",
      "name": "Novgorodskaja oblast'",
      "type": "Administrative region"
    },
    {
      "code": "RU-NIZ",
      "name": "Nizhegorodskaya oblast'",
      "type": "Administrative region"
    },
    {
      "code": "RU-NVS",
      "name": "Novosibirskaja oblast'",
      "type": "Administrative region"
    },
    {
      "code": "RU-OMS",
      "name": "Omskaja oblast'",
      "type": "Administrative region"
    },
    {
      "code": "RU-ORE",
      "name": "Orenburgskaja oblast'",
      "type": "Administrative region"
    },
    {
      "code": "RU-ORL",
      "name": "Orlovskaja oblast'",
      "type": "Administrative region"
    },
    {
      "code": "RU-PER",
      "name": "Permskij kraj",
      "type": "Administrative territory"
    },
    {
      "code": "RU-PNZ",
      "name": "Penzenskaja oblast'",
      "type": "Administrative region"
    },
    {
      "code": "RU-PRI",
      "name": "Primorskij kraj",
      "type": "Administrative territory"
    },
    {
      "code": "RU-PSK",
      "name": "Pskovskaja oblast'",
      "type": "Administrative region"
    },
    {
      "code": "RU-ROS",
      "name": "Rostovskaja oblast'",
      "type": "Administrative region"
    },
    {
      "code": "RU-RYA",
      "name": "Rjazanskaja oblast'",
      "type": "Administrative region"
    },
    {
      "code": "RU-SA",
      "name": "Saha, Respublika",
      "type": "Republic"
    },
    {
      "code": "RU-SAK",
      "name": "Sahalinskaja oblast'",
      "type": "Administrative region"
    },
    {
      "code": "RU-SAM",
      "name": "Samarskaja oblast'",
      "type": "Administrative region"
    },
    {
      "code": "RU-SAR",
      "name": "Saratovskaja oblast'",
      "type": "Administrative region"
    },
    {
      "code": "RU-SE",
      "name": "Severnaja Osetija, Respublika",
      "type": "Republic"
    },
    {
      "code": "RU-SMO",
      "name": "Smolenskaja oblast'",
      "type": "Administrative region"
    },
    {
      "code": "RU-SPE",
      "name": "Sankt-Peterburg",
      "type": "Autonomous city"
    },
    {
      "code": "RU-STA",
      "name": "Stavropol'skij kraj",
      "type": "Administrative territory"
    },
    {
      "code": "RU-SVE",
      "name": "Sverdlovskaja oblast'",
      "type": "Administrative region"
    },
    {
      "code": "RU-TA",
      "name": "Tatarstan, Respublika",
      "type": "Republic"
    },
    {
      "code": "RU-TAM",
      "name": "Tambovskaja oblast'",
      "type": "Administrative region"
    },
    {
      "code": "RU-TOM",
      "name": "Tomskaja oblast'",
      "type": "Administrative region"
    },
    {
      "code": "RU-TUL",
      "name": "Tul'skaja oblast'",
      "type": "Administrative region"
    },
    {
      "code": "RU-TVE",
      "name": "Tverskaja oblast'",
      "type": "Administrative region"
    },
    {
      "code": "RU-TY",
      "name": "Tyva, Respublika",
      "type": "Republic"
    },
    {
      "code": "RU-TYU",
      "name": "Tjumenskaja oblast'",
      "type": "Administrative region"
    },
    {
      "code": "RU-UD",
      "name": "Udmurtskaja Respublika",
      "type": "Republic"
    },
    {
      "code": "RU-ULY",
      "name": "Ul'janovskaja oblast'",
      "type": "Administrative region"
    },
    {
      "code": "RU-VGG",
      "name": "Volgogradskaja oblast'",
      "type": "Administrative region"
    },
    {
      "code": "RU-VLA",
      "name": "Vladimirskaja oblast'",
      "type": "Administrative region"
    },
    {
      "code": "RU-VLG",
      "name": "Vologodskaja oblast'",
      "type": "Administrative region"
    },
    {
      "code": "RU-VOR",
      "name": "Voronezhskaya oblast'",
      "type": "Administrative region"
    },
    {
      "code": "RU-YAN",
      "name": "Jamalo-Neneckij avtonomnyj okrug",
      "type": "Autonomous district"
    },
    {
      "code": "RU-YAR",
      "name": "Jaroslavskaja oblast'",
      "type": "Administrative region"
    },
    {
      "code": "RU-YEV",
      "name": "Evrejskaja avtonomnaja oblast'",
      "type": "Autonomous region"
    },
    {
      "code": "RU-ZAB",
      "name": "Zabajkal'skij kraj",
      "type": "Administrative territory"
    },
    {
      "code": "RW-01",
      "name": "City of Kigali",
      "type": "City"
    },
    {
      "code": "RW-02",
      "name": "Eastern",
      "type": "Province"
    },
    {
      "code": "RW-03",
      "name": "Northern",
      "type": "Province"
    },
    {
      "code": "RW-04",
      "name": "Western",
      "type": "Province"
    },
    {
      "code": "RW-05",
      "name": "Southern",
      "type": "Province"
    },
    {
      "code": "SA-01",
      "name": "Ar Riyāḑ",
      "type": "Region"
    },
    {
      "code": "SA-02",
      "name": "Makkah al Mukarramah",
      "type": "Region"
    },
    {
      "code": "SA-03",
      "name": "Al Madīnah al Munawwarah",
      "type": "Region"
    },
    {
      "code": "SA-04",
      "name": "Ash Sharqīyah",
      "type": "Region"
    },
    {
      "code": "SA-05",
      "name": "Al Qaşīm",
      "type": "Region"
    },
    {
      "code": "SA-06",
      "name": "Ḩā'il",
      "type": "Region"
    },
    {
      "code": "SA-07",
      "name": "Tabūk",
      "type": "Region"
    },
    {
      "code": "SA-08",
      "name": "Al Ḩudūd ash Shamālīyah",
      "type": "Region"
    },
    {
      "code": "SA-09",
      "name": "Jāzān",
      "type": "Region"
    },
    {
      "code": "SA-10",
      "name": "Najrān",
      "type": "Region"
    },
    {
      "code": "SA-11",
      "name": "Al Bāḩah",
      "type": "Region"
    },
    {
      "code": "SA-12",
      "name": "Al Jawf",
      "type": "Region"
    },
    {
      "code": "SA-14",
      "name": "'Asīr",
      "type": "Region"
    },
    {
      "code": "SB-CE",
      "name": "Central",
      "type": "Province"
    },
    {
      "code": "SB-CH",
      "name": "Choiseul",
      "type": "Province"
    },
    {
      "code": "SB-CT",
      "name": "Capital Territory (Honiara)",
      "type": "Capital territory"
    },
    {
      "code": "SB-GU",
      "name": "Guadalcanal",
      "type": "Province"
    },
    {
      "code": "SB-IS",
      "name": "Isabel",
      "type": "Province"
    },
    {
      "code": "SB-MK",
      "name": "Makira-Ulawa",
      "type": "Province"
    },
    {
      "code": "SB-ML",
      "name": "Malaita",
      "type": "Province"
    },
    {
      "code": "SB-RB",
      "name": "Rennell and Bellona",
      "type": "Province"
    },
    {
      "code": "SB-TE",
      "name": "Temotu",
      "type": "Province"
    },
    {
      "code": "SB-WE",
      "name": "Western",
      "type": "Province"
    },
    {
      "code": "SC-01",
      "name": "Anse aux Pins",
      "type": "District"
    },
    {
      "code": "SC-02",
      "name": "Anse Boileau",
      "type": "District"
    },
    {
      "code": "SC-03",
      "name": "Anse Etoile",
      "type": "District"
    },
    {
      "code": "SC-04",
      "name": "Au Cap",
      "type": "District"
    },
    {
      "code": "SC-05",
      "name": "Anse Royale",
      "type": "District"
    },
    {
      "code": "SC-06",
      "name": "Baie Lazare",
      "type": "District"
    },
    {
      "code": "SC-07",
      "name": "Baie Sainte Anne",
      "type": "District"
    },
    {
      "code": "SC-08",
      "name": "Beau Vallon",
      "type": "District"
    },
    {
      "code": "SC-09",
      "name": "Bel Air",
      "type": "District"
    },
    {
      "code": "SC-10",
      "name": "Bel Ombre",
      "type": "District"
    },
    {
      "code": "SC-11",
      "name": "Cascade",
      "type": "District"
    },
    {
      "code": "SC-12",
      "name": "Glacis",
      "type": "District"
    },
    {
      "code": "SC-13",
      "name": "Grand Anse Mahe",
      "type": "District"
    },
    {
      "code": "SC-14",
      "name": "Grand Anse Praslin",
      "type": "District"
    },
    {
      "code": "SC-15",
      "name": "La Digue",
      "type": "District"
    },
    {
      "code": "SC-16",
      "name": "English River",
      "type": "District"
    },
    {
      "code": "SC-17",
      "name": "Mont Buxton",
      "type": "District"
    },
    {
      "code": "SC-18",
      "name": "Mont Fleuri",
      "type": "District"
    },
    {
      "code": "SC-19",
      "name": "Plaisance",
      "type": "District"
    },
    {
      "code": "SC-20",
      "name": "Pointe Larue",
      "type": "District"
    },
    {
      "code": "SC-21",
      "name": "Port Glaud",
      "type": "District"
    },
    {
      "code": "SC-22",
      "name": "Saint Louis",
      "type": "District"
    },
    {
      "code": "SC-23",
      "name": "Takamaka",
      "type": "District"
    },
    {
      "code": "SC-24",
      "name": "Les Mamelles",
      "type": "District"
    },
    {
      "code": "SC-25",
      "name": "Roche Caiman",
      "type": "District"
    },
    {
      "code": "SC-26",
      "name": "Ile Perseverance I",
      "type": "District"
    },
    {
      "code": "SC-27",
      "name": "Ile Perseverance II",
      "type": "District"
    },
    {
      "code": "SD-DC",
      "name": "Central Darfur",
      "type": "State"
    },
    {
      "code": "SD-DE",
      "name": "East Darfur",
      "type": "State"
    },
    {
      "code": "SD-DN",
      "name": "North Darfur",
      "type": "State"
    },
    {
      "code": "SD-DS",
      "name": "South Darfur",
      "type": "State"
    },
    {
      "code": "SD-DW",
      "name": "West Darfur",
      "type": "State"
    },
    {
      "code": "SD-GD",
      "name": "Gedaref",
      "type": "State"
    },
    {
      "code": "SD-GK",
      "name": "West Kordofan",
      "type": "State"
    },
    {
      "code": "SD-GZ",
      "name": "Gezira",
      "type": "State"
    },
    {
      "code": "SD-KA",
      "name": "Kassala",
      "type": "State"
    },
    {
      "code": "SD-KH",
      "name": "Khartoum",
      "type": "State"
    },
    {
      "code": "SD-KN",
      "name": "North Kordofan",
      "type": "State"
    },
    {
      "code": "SD-KS",
      "name": "South Kordofan",
      "type": "State"
    },
    {
      "code": "SD-NB",
      "name": "Blue Nile",
      "type": "State"
    },
    {
      "code": "SD-NO",
      "name": "Northern",
      "type": "State"
    },
    {
      "code": "SD-NR",
      "name": "River Nile",
      "type": "State"
    },
    {
      "code": "SD-NW",
      "name": "White Nile",
      "type": "State"
    },
    {
      "code": "SD-RS",
      "name": "Red Sea",
      "type": "State"
    },
    {
      "code": "SD-SI",
      "name": "Sennar",
      "type": "State"
    },
    {
      "code": "SE-AB",
      "name": "Stockholms län [SE-01]",
      "type": "County"
    },
    {
      "code": "SE-AC",
      "name": "Västerbottens län [SE-24]",
      "type": "County"
    },
    {
      "code": "SE-BD",
      "name": "Norrbottens län [SE-25]",
      "type": "County"
    },
    {
      "code": "SE-C",
      "name": "Uppsala län [SE-03]",
      "type": "County"
    },
    {
      "code": "SE-D",
      "name": "Södermanlands län [SE-04]",
      "type": "County"
    },
    {
      "code": "SE-E",
      "name": "Östergötlands län [SE-05]",
      "type": "County"
    },
    {
      "code": "SE-F",
      "name": "Jönköpings län [SE-06]",
      "type": "County"
    },
    {
      "code": "SE-G",
      "name": "Kronobergs län [SE-07]",
      "type": "County"
    },
    {
      "code": "SE-H",
      "name": "Kalmar län [SE-08]",
      "type": "County"
    },
    {
      "code": "SE-I",
      "name": "Gotlands län [SE-09]",
      "type": "County"
    },
    {
      "code": "SE-K",
      "name": "Blekinge län [SE-10]",
      "type": "County"
    },
    {
      "code": "SE-M",
      "name": "Skåne län [SE-12]",
      "type": "County"
    },
    {
      "code": "SE-N",
      "name": "Hallands län [SE-13]",
      "type": "County"
    },
    {
      "code": "SE-O",
      "name": "Västra Götalands län [SE-14]",
      "type": "County"
    },
    {
      "code": "SE-S",
      "name": "Värmlands län [SE-17]",
      "type": "County"
    },
    {
      "code": "SE-T",
      "name": "Örebro län [SE-18]",
      "type": "County"
    },
    {
      "code": "SE-U",
      "name": "Västmanlands län [SE-19]",
      "type": "County"
    },
    {
      "code": "SE-W",
      "name": "Dalarnas län [SE-20]",
      "type": "County"
    },
    {
      "code": "SE-X",
      "name": "Gävleborgs län [SE-21]",
      "type": "County"
    },
    {
      "code": "SE-Y",
      "name": "Västernorrlands län [SE-22]",
      "type": "County"
    },
    {
      "code": "SE-Z",
      "name": "Jämtlands län [SE-23]",
      "type": "County"
    },
    {
      "code": "SG-01",
      "name": "Central Singapore",
      "type": "District"
    },
    {
      "code": "SG-02",
      "name": "North East",
      "type": "District"
    },
    {
      "code": "SG-03",
      "name": "North West",
      "type": "District"
    },
    {
      "code": "SG-04",
      "name": "South East",
      "type": "District"
    },
    {
      "code": "SG-05",
      "name": "South West",
      "type": "District"
    },
    {
      "code": "SH-AC",
      "name": "Ascension",
      "type": "Geographical entity"
    },
    {
      "code": "SH-HL",
      "name": "Saint Helena",
      "type": "Geographical entity"
    },
    {
      "code": "SH-TA",
      "name": "Tristan da Cunha",
      "type": "Geographical entity"
    },
    {
      "code": "SI-001",
      "name": "Ajdovščina",
      "type": "Municipality"
    },
    {
      "code": "SI-002",
      "name": "Beltinci",
      "type": "Municipality"
    },
    {
      "code": "SI-003",
      "name": "Bled",
      "type": "Municipality"
    },
    {
      "code": "SI-004",
      "name": "Bohinj",
      "type": "Municipality"
    },
    {
      "code": "SI-005",
      "name": "Borovnica",
      "type": "Municipality"
    },
    {
      "code": "SI-006",
      "name": "Bovec",
      "type": "Municipality"
    },
    {
      "code": "SI-007",
      "name": "Brda",
      "type": "Municipality"
    },
    {
      "code": "SI-008",
      "name": "Brezovica",
      "type": "Municipality"
    },
    {
      "code": "SI-009",
      "name": "Brežice",
      "type": "Municipality"
    },
    {
      "code": "SI-010",
      "name": "Tišina",
      "type": "Municipality"
    },
    {
      "code": "SI-011",
      "name": "Celje",
      "type": "Municipality"
    },
    {
      "code": "SI-012",
      "name": "Cerklje na Gorenjskem",
      "type": "Municipality"
    },
    {
      "code": "SI-013",
      "name": "Cerknica",
      "type": "Municipality"
    },
    {
      "code": "SI-014",
      "name": "Cerkno",
      "type": "Municipality"
    },
    {
      "code": "SI-015",
      "name": "Črenšovci",
      "type": "Municipality"
    },
    {
      "code": "SI-016",
      "name": "Črna na Koroškem",
      "type": "Municipality"
    },
    {
      "code": "SI-017",
      "name": "Črnomelj",
      "type": "Municipality"
    },
    {
      "code": "SI-018",
      "name": "Destrnik",
      "type": "Municipality"
    },
    {
      "code": "SI-019",
      "name": "Divača",
      "type": "Municipality"
    },
    {
      "code": "SI-020",
      "name": "Dobrepolje",
      "type": "Municipality"
    },
    {
      "code": "SI-021",
      "name": "Dobrova-Polhov Gradec",
      "type": "Municipality"
    },
    {
      "code": "SI-022",
      "name": "Dol pri Ljubljani",
      "type": "Municipality"
    },
    {
      "code": "SI-023",
      "name": "Domžale",
      "type": "Municipality"
    },
    {
      "code": "SI-024",
      "name": "Dornava",
      "type": "Municipality"
    },
    {
      "code": "SI-025",
      "name": "Dravograd",
      "type": "Municipality"
    },
    {
      "code": "SI-026",
      "name": "Duplek",
      "type": "Municipality"
    },
    {
      "code": "SI-027",
      "name": "Gorenja vas-Poljane",
      "type": "Municipality"
    },
    {
      "code": "SI-028",
      "name": "Gorišnica",
      "type": "Municipality"
    },
    {
      "code": "SI-029",
      "name": "Gornja Radgona",
      "type": "Municipality"
    },
    {
      "code": "SI-030",
      "name": "Gornji Grad",
      "type": "Municipality"
    },
    {
      "code": "SI-031",
      "name": "Gornji Petrovci",
      "type": "Municipality"
    },
    {
      "code": "SI-032",
      "name": "Grosuplje",
      "type": "Municipality"
    },
    {
      "code": "SI-033",
      "name": "Šalovci",
      "type": "Municipality"
    },
    {
      "code": "SI-034",
      "name": "Hrastnik",
      "type": "Municipality"
    },
    {
      "code": "SI-035",
      "name": "Hrpelje-Kozina",
      "type": "Municipality"
    },
    {
      "code": "SI-036",
      "name": "Idrija",
      "type": "Municipality"
    },
    {
      "code": "SI-037",
      "name": "Ig",
      "type": "Municipality"
    },
    {
      "code": "SI-038",
      "name": "Ilirska Bistrica",
      "type": "Municipality"
    },
    {
      "code": "SI-039",
      "name": "Ivančna Gorica",
      "type": "Municipality"
    },
    {
      "code": "SI-040",
      "name": "Izola",
      "type": "Municipality"
    },
    {
      "code": "SI-041",
      "name": "Jesenice",
      "type": "Municipality"
    },
    {
      "code": "SI-042",
      "name": "Juršinci",
      "type": "Municipality"
    },
    {
      "code": "SI-043",
      "name": "Kamnik",
      "type": "Municipality"
    },
    {
      "code": "SI-044",
      "name": "Kanal",
      "type": "Municipality"
    },
    {
      "code": "SI-045",
      "name": "Kidričevo",
      "type": "Municipality"
    },
    {
      "code": "SI-046",
      "name": "Kobarid",
      "type": "Municipality"
    },
    {
      "code": "SI-047",
      "name": "Kobilje",
      "type": "Municipality"
    },
    {
      "code": "SI-048",
      "name": "Kočevje",
      "type": "Municipality"
    },
    {
      "code": "SI-049",
      "name": "Komen",
      "type": "Municipality"
    },
    {
      "code": "SI-050",
      "name": "Koper",
      "type": "Municipality"
    },
    {
      "code": "SI-051",
      "name": "Kozje",
      "type": "Municipality"
    },
    {
      "code": "SI-052",
      "name": "Kranj",
      "type": "Municipality"
    },
    {
      "code": "SI-053",
      "name": "Kranjska Gora",
      "type": "Municipality"
    },
    {
      "code": "SI-054",
      "name": "Krško",
      "type": "Municipality"
    },
    {
      "code": "SI-055",
      "name": "Kungota",
      "type": "Municipality"
    },
    {
      "code": "SI-056",
      "name": "Kuzma",
      "type": "Municipality"
    },
    {
      "code": "SI-057",
      "name": "Laško",
      "type": "Municipality"
    },
    {
      "code": "SI-058",
      "name": "Lenart",
      "type": "Municipality"
    },
    {
      "code": "SI-059",
      "name": "Lendava",
      "type": "Municipality"
    },
    {
      "code": "SI-060",
      "name": "Litija",
      "type": "Municipality"
    },
    {
      "code": "SI-061",
      "name": "Ljubljana",
      "type": "Municipality"
    },
    {
      "code": "SI-062",
      "name": "Ljubno",
      "type": "Municipality"
    },
    {
      "code": "SI-063",
      "name": "Ljutomer",
      "type": "Municipality"
    },
    {
      "code": "SI-064",
      "name": "Logatec",
      "type": "Municipality"
    },
    {
      "code": "SI-065",
      "name": "Loška dolina",
      "type": "Municipality"
    },
    {
      "code": "SI-066",
      "name": "Loški Potok",
      "type": "Municipality"
    },
    {
      "code": "SI-067",
      "name": "Luče",
      "type": "Municipality"
    },
    {
      "code": "SI-068",
      "name": "Lukovica",
      "type": "Municipality"
    },
    {
      "code": "SI-069",
      "name": "Majšperk",
      "type": "Municipality"
    },
    {
      "code": "SI-070",
      "name": "Maribor",
      "type": "Municipality"
    },
    {
      "code": "SI-071",
      "name": "Medvode",
      "type": "Municipality"
    },
    {
      "code": "SI-072",
      "name": "Mengeš",
      "type": "Municipality"
    },
    {
      "code": "SI-073",
      "name": "Metlika",
      "type": "Municipality"
    },
    {
      "code": "SI-074",
      "name": "Mežica",
      "type": "Municipality"
    },
    {
      "code": "SI-075",
      "name": "Miren-Kostanjevica",
      "type": "Municipality"
    },
    {
      "code": "SI-076",
      "name": "Mislinja",
      "type": "Municipality"
    },
    {
      "code": "SI-077",
      "name": "Moravče",
      "type": "Municipality"
    },
    {
      "code": "SI-078",
      "name": "Moravske Toplice",
      "type": "Municipality"
    },
    {
      "code": "SI-079",
      "name": "Mozirje",
      "type": "Municipality"
    },
    {
      "code": "SI-080",
      "name": "Murska Sobota",
      "type": "Municipality"
    },
    {
      "code": "SI-081",
      "name": "Muta",
      "type": "Municipality"
    },
    {
      "code": "SI-082",
      "name": "Naklo",
      "type": "Municipality"
    },
    {
      "code": "SI-083",
      "name": "Nazarje",
      "type": "Municipality"
    },
    {
      "code": "SI-084",
      "name": "Nova Gorica",
      "type": "Municipality"
    },
    {
      "code": "SI-085",
      "name": "Novo Mesto",
      "type": "Municipality"
    },
    {
      "code": "SI-086",
      "name": "Odranci",
      "type": "Municipality"
    },
    {
      "code": "SI-087",
      "name": "Ormož",
      "type": "Municipality"
    },
    {
      "code": "SI-088",
      "name": "Osilnica",
      "type": "Municipality"
    },
    {
      "code": "SI-089",
      "name": "Pesnica",
      "type": "Municipality"
    },
    {
      "code": "SI-090",
      "name": "Piran",
      "type": "Municipality"
    },
    {
      "code": "SI-091",
      "name": "Pivka",
      "type": "Municipality"
    },
    {
      "code": "SI-092",
      "name": "Podčetrtek",
      "type": "Municipality"
    },
    {
      "code": "SI-093",
      "name": "Podvelka",
      "type": "Municipality"
    },
    {
      "code": "SI-094",
      "name": "Postojna",
      "type": "Municipality"
    },
    {
      "code": "SI-095",
      "name": "Preddvor",
      "type": "Municipality"
    },
    {
      "code": "SI-096",
      "name": "Ptuj",
      "type": "Municipality"
    },
    {
      "code": "SI-097",
      "name": "Puconci",
      "type": "Municipality"
    },
    {
      "code": "SI-098",
      "name": "Rače-Fram",
      "type": "Municipality"
    },
    {
      "code": "SI-099",
      "name": "Radeče",
      "type": "Municipality"
    },
    {
      "code": "SI-100",
      "name": "Radenci",
      "type": "Municipality"
    },
    {
      "code": "SI-101",
      "name": "Radlje ob Dravi",
      "type": "Municipality"
    },
    {
      "code": "SI-102",
      "name": "Radovljica",
      "type": "Municipality"
    },
    {
      "code": "SI-103",
      "name": "Ravne na Koroškem",
      "type": "Municipality"
    },
    {
      "code": "SI-104",
      "name": "Ribnica",
      "type": "Municipality"
    },
    {
      "code": "SI-105",
      "name": "Rogašovci",
      "type": "Municipality"
    },
    {
      "code": "SI-106",
      "name": "Rogaška Slatina",
      "type": "Municipality"
    },
    {
      "code": "SI-107",
      "name": "Rogatec",
      "type": "Municipality"
    },
    {
      "code": "SI-108",
      "name": "Ruše",
      "type": "Municipality"
    },
    {
      "code": "SI-109",
      "name": "Semič",
      "type": "Municipality"
    },
    {
      "code": "SI-110",
      "name": "Sevnica",
      "type": "Municipality"
    },
    {
      "code": "SI-111",
      "name": "Sežana",
      "type": "Municipality"
    },
    {
      "code": "SI-112",
      "name": "Slovenj Gradec",
      "type": "Municipality"
    },
    {
      "code": "SI-113",
      "name": "Slovenska Bistrica",
      "type": "Municipality"
    },
    {
      "code": "SI-114",
      "name": "Slovenske Konjice",
      "type": "Municipality"
    },
    {
      "code": "SI-115",
      "name": "Starše",
      "type": "Municipality"
    },
    {
      "code": "SI-116",
      "name": "Sveti Jurij ob Ščavnici",
      "type": "Municipality"
    },
    {
      "code": "SI-117",
      "name": "Šenčur",
      "type": "Municipality"
    },
    {
      "code": "SI-118",
      "name": "Šentilj",
      "type": "Municipality"
    },
    {
      "code": "SI-119",
      "name": "Šentjernej",
      "type": "Municipality"
    },
    {
      "code": "SI-120",
      "name": "Šentjur",
      "type": "Municipality"
    },
    {
      "code": "SI-121",
      "name": "Škocjan",
      "type": "Municipality"
    },
    {
      "code": "SI-122",
      "name": "Škofja Loka",
      "type": "Municipality"
    },
    {
      "code": "SI-123",
      "name": "Škofljica",
      "type": "Municipality"
    },
    {
      "code": "SI-124",
      "name": "Šmarje pri Jelšah",
      "type": "Municipality"
    },
    {
      "code": "SI-125",
      "name": "Šmartno ob Paki",
      "type": "Municipality"
    },
    {
      "code": "SI-126",
      "name": "Šoštanj",
      "type": "Municipality"
    },
    {
      "code": "SI-127",
      "name": "Štore",
      "type": "Municipality"
    },
    {
      "code": "SI-128",
      "name": "Tolmin",
      "type": "Municipality"
    },
    {
      "code": "SI-129",
      "name": "Trbovlje",
      "type": "Municipality"
    },
    {
      "code": "SI-130",
      "name": "Trebnje",
      "type": "Municipality"
    },
    {
      "code": "SI-131",
      "name": "Tržič",
      "type": "Municipality"
    },
    {
      "code": "SI-132",
      "name": "Turnišče",
      "type": "Municipality"
    },
    {
      "code": "SI-133",
      "name": "Velenje",
      "type": "Municipality"
    },
    {
      "code": "SI-134",
      "name": "Velike Lašče",
      "type": "Municipality"
    },
    {
      "code": "SI-135",
      "name": "Videm",
      "type": "Municipality"
    },
    {
      "code": "SI-136",
      "name": "Vipava",
      "type": "Municipality"
    },
    {
      "code": "SI-137",
      "name": "Vitanje",
      "type": "Municipality"
    },
    {
      "code": "SI-138",
      "name": "Vodice",
      "type": "Municipality"
    },
    {
      "code": "SI-139",
      "name": "Vojnik",
      "type": "Municipality"
    },
    {
      "code": "SI-140",
      "name": "Vrhnika",
      "type": "Municipality"
    },
    {
      "code": "SI-141",
      "name": "Vuzenica",
      "type": "Municipality"
    },
    {
      "code": "SI-142",
      "name": "Zagorje ob Savi",
      "type": "Municipality"
    },
    {
      "code": "SI-143",
      "name": "Zavrč",
      "type": "Municipality"
    },
    {
      "code": "SI-144",
      "name": "Zreče",
      "type": "Municipality"
    },
    {
      "code": "SI-146",
      "name": "Železniki",
      "type": "Municipality"
    },
    {
      "code": "SI-147",
      "name": "Žiri",
      "type": "Municipality"
    },
    {
      "code": "SI-148",
      "name": "Benedikt",
      "type": "Municipality"
    },
    {
      "code": "SI-149",
      "name": "Bistrica ob Sotli",
      "type": "Municipality"
    },
    {
      "code": "SI-150",
      "name": "Bloke",
      "type": "Municipality"
    },
    {
      "code": "SI-151",
      "name": "Braslovče",
      "type": "Municipality"
    },
    {
      "code": "SI-152",
      "name": "Cankova",
      "type": "Municipality"
    },
    {
      "code": "SI-153",
      "name": "Cerkvenjak",
      "type": "Municipality"
    },
    {
      "code": "SI-154",
      "name": "Dobje",
      "type": "Municipality"
    },
    {
      "code": "SI-155",
      "name": "Dobrna",
      "type": "Municipality"
    },
    {
      "code": "SI-156",
      "name": "Dobrovnik",
      "type": "Municipality"
    },
    {
      "code": "SI-157",
      "name": "Dolenjske Toplice",
      "type": "Municipality"
    },
    {
      "code": "SI-158",
      "name": "Grad",
      "type": "Municipality"
    },
    {
      "code": "SI-159",
      "name": "Hajdina",
      "type": "Municipality"
    },
    {
      "code": "SI-160",
      "name": "Hoče-Slivnica",
      "type": "Municipality"
    },
    {
      "code": "SI-161",
      "name": "Hodoš",
      "type": "Municipality"
    },
    {
      "code": "SI-162",
      "name": "Horjul",
      "type": "Municipality"
    },
    {
      "code": "SI-163",
      "name": "Jezersko",
      "type": "Municipality"
    },
    {
      "code": "SI-164",
      "name": "Komenda",
      "type": "Municipality"
    },
    {
      "code": "SI-165",
      "name": "Kostel",
      "type": "Municipality"
    },
    {
      "code": "SI-166",
      "name": "Križevci",
      "type": "Municipality"
    },
    {
      "code": "SI-167",
      "name": "Lovrenc na Pohorju",
      "type": "Municipality"
    },
    {
      "code": "SI-168",
      "name": "Markovci",
      "type": "Municipality"
    },
    {
      "code": "SI-169",
      "name": "Miklavž na Dravskem polju",
      "type": "Municipality"
    },
    {
      "code": "SI-170",
      "name": "Mirna Peč",
      "type": "Municipality"
    },
    {
      "code": "SI-171",
      "name": "Oplotnica",
      "type": "Municipality"
    },
    {
      "code": "SI-172",
      "name": "Podlehnik",
      "type": "Municipality"
    },
    {
      "code": "SI-173",
      "name": "Polzela",
      "type": "Municipality"
    },
    {
      "code": "SI-174",
      "name": "Prebold",
      "type": "Municipality"
    },
    {
      "code": "SI-175",
      "name": "Prevalje",
      "type": "Municipality"
    },
    {
      "code": "SI-176",
      "name": "Razkrižje",
      "type": "Municipality"
    },
    {
      "code": "SI-177",
      "name": "Ribnica na Pohorju",
      "type": "Municipality"
    },
    {
      "code": "SI-178",
      "name": "Selnica ob Dravi",
      "type": "Municipality"
    },
    {
      "code": "SI-179",
      "name": "Sodražica",
      "type": "Municipality"
    },
    {
      "code": "SI-180",
      "name": "Solčava",
      "type": "Municipality"
    },
    {
      "code": "SI-181",
      "name": "Sveta Ana",
      "type": "Municipality"
    },
    {
      "code": "SI-182",
      "name": "Sveti Andraž v Slovenskih goricah",
      "type": "Municipality"
    },
    {
      "code": "SI-183",
      "name": "Šempeter-Vrtojba",
      "type": "Municipality"
    },
    {
      "code": "SI-184",
      "name": "Tabor",
      "type": "Municipality"
    },
    {
      "code": "SI-185",
      "name": "Trnovska Vas",
      "type": "Municipality"
    },
    {
      "code": "SI-186",
      "name": "Trzin",
      "type": "Municipality"
    },
    {
      "code": "SI-187",
      "name": "Velika Polana",
      "type": "Municipality"
    },
    {
      "code": "SI-188",
      "name": "Veržej",
      "type": "Municipality"
    },
    {
      "code": "SI-189",
      "name": "Vransko",
      "type": "Municipality"
    },
    {
      "code": "SI-190",
      "name": "Žalec",
      "type": "Municipality"
    },
    {
      "code": "SI-191",
      "name": "Žetale",
      "type": "Municipality"
    },
    {
      "code": "SI-192",
      "name": "Žirovnica",
      "type": "Municipality"
    },
    {
      "code": "SI-193",
      "name": "Žužemberk",
      "type": "Municipality"
    },
    {
      "code": "SI-194",
      "name": "Šmartno pri Litiji",
      "type": "Municipality"
    },
    {
      "code": "SI-195",
      "name": "Apače",
      "type": "Municipality"
    },
    {
      "code": "SI-196",
      "name": "Cirkulane",
      "type": "Municipality"
    },
    {
      "code": "SI-197",
      "name": "Kosanjevica na Krki",
      "type": "Municipality"
    },
    {
      "code": "SI-198",
      "name": "Makole",
      "type": "Municipality"
    },
    {
      "code": "SI-199",
      "name": "Mokronog-Trebelno",
      "type": "Municipality"
    },
    {
      "code": "SI-200",
      "name": "Poljčane",
      "type": "Municipality"
    },
    {
      "code": "SI-201",
      "name": "Renče-Vogrsko",
      "type": "Municipality"
    },
    {
      "code": "SI-202",
      "name": "Središče ob Dravi",
      "type": "Municipality"
    },
    {
      "code": "SI-203",
      "name": "Straža",
      "type": "Municipality"
    },
    {
      "code": "SI-204",
      "name": "Sveta Trojica v Slovenskih goricah",
      "type": "Municipality"
    },
    {
      "code": "SI-205",
      "name": "Sveti Tomaž",
      "type": "Municipality"
    },
    {
      "code": "SI-206",
      "name": "Šmarješke Toplice",
      "type": "Municipality"
    },
    {
      "code": "SI-207",
      "name": "Gorje",
      "type": "Municipality"
    },
    {
      "code": "SI-208",
      "name": "Log-Dragomer",
      "type": "Municipality"
    },
    {
      "code": "SI-209",
      "name": "Rečica ob Savinji",
      "type": "Municipality"
    },
    {
      "code": "SI-210",
      "name": "Sveti Jurij v Slovenskih goricah",
      "type": "Municipality"
    },
    {
      "code": "SI-211",
      "name": "Šentrupert",
      "type": "Municipality"
    },
    {
      "code": "SI-212",
      "name": "Mirna",
      "type": "Municipality"
    },
    {
      "code": "SI-213",
      "name": "Ankaran",
      "type": "Municipality"
    },
    {
      "code": "SK-BC",
      "name": "Banskobystrický kraj",
      "type": "Region"
    },
    {
      "code": "SK-BL",
      "name": "Bratislavský kraj",
      "type": "Region"
    },
    {
      "code": "SK-KI",
      "name": "Košický kraj",
      "type": "Region"
    },
    {
      "code": "SK-NI",
      "name": "Nitriansky kraj",
      "type": "Region"
    },
    {
      "code": "SK-PV",
      "name": "Prešovský kraj",
      "type": "Region"
    },
    {
      "code": "SK-TA",
      "name": "Trnavský kraj",
      "type": "Region"
    },
    {
      "code": "SK-TC",
      "name": "Trenčiansky kraj",
      "type": "Region"
    },
    {
      "code": "SK-ZI",
      "name": "Žilinský kraj",
      "type": "Region"
    },
    {
      "code": "SL-E",
      "name": "Eastern",
      "type": "Province"
    },
    {
      "code": "SL-N",
      "name": "Northern",
      "type": "Province"
    },
    {
      "code": "SL-NW",
      "name": "North Western",
      "type": "Province"
    },
    {
      "code": "SL-S",
      "name": "Southern",
      "type": "Province"
    },
    {
      "code": "SL-W",
      "name": "Western Area (Freetown)",
      "type": "Area"
    },
    {
      "code": "SM-01",
      "name": "Acquaviva",
      "type": "Municipality"
    },
    {
      "code": "SM-02",
      "name": "Chiesanuova",
      "type": "Municipality"
    },
    {
      "code": "SM-03",
      "name": "Domagnano",
      "type": "Municipality"
    },
    {
      "code": "SM-04",
      "name": "Faetano",
      "type": "Municipality"
    },
    {
      "code": "SM-05",
      "name": "Fiorentino",
      "type": "Municipality"
    },
    {
      "code": "SM-06",
      "name": "Borgo Maggiore",
      "type": "Municipality"
    },
    {
      "code": "SM-07",
      "name": "Città di San Marino",
      "type": "Municipality"
    },
    {
      "code": "SM-08",
      "name": "Montegiardino",
      "type": "Municipality"
    },
    {
      "code": "SM-09",
      "name": "Serravalle",
      "type": "Municipality"
    },
    {
      "code": "SN-DB",
      "name": "Diourbel",
      "type": "Region"
    },
    {
      "code": "SN-DK",
      "name": "Dakar",
      "type": "Region"
    },
    {
      "code": "SN-FK",
      "name": "Fatick",
      "type": "Region"
    },
    {
      "code": "SN-KA",
      "name": "Kaffrine",
      "type": "Region"
    },
    {
      "code": "SN-KD",
      "name": "Kolda",
      "type": "Region"
    },
    {
      "code": "SN-KE",
      "name": "Kédougou",
      "type": "Region"
    },
    {
      "code": "SN-KL",
      "name": "Kaolack",
      "type": "Region"
    },
    {
      "code": "SN-LG",
      "name": "Louga",
      "type": "Region"
    },
    {
      "code": "SN-MT",
      "name": "Matam",
      "type": "Region"
    },
    {
      "code": "SN-SE",
      "name": "Sédhiou",
      "type": "Region"
    },
    {
      "code": "SN-SL",
      "name": "Saint-Louis",
      "type": "Region"
    },
    {
      "code": "SN-TC",
      "name": "Tambacounda",
      "type": "Region"
    },
    {
      "code": "SN-TH",
      "name": "Thiès",
      "type": "Region"
    },
    {
      "code": "SN-ZG",
      "name": "Ziguinchor",
      "type": "Region"
    },
    {
      "code": "SO-AW",
      "name": "Awdal",
      "type": "Region"
    },
    {
      "code": "SO-BK",
      "name": "Bakool",
      "type": "Region"
    },
    {
      "code": "SO-BN",
      "name": "Banaadir",
      "type": "Region"
    },
    {
      "code": "SO-BR",
      "name": "Bari",
      "type": "Region"
    },
    {
      "code": "SO-BY",
      "name": "Bay",
      "type": "Region"
    },
    {
      "code": "SO-GA",
      "name": "Galguduud",
      "type": "Region"
    },
    {
      "code": "SO-GE",
      "name": "Gedo",
      "type": "Region"
    },
    {
      "code": "SO-HI",
      "name": "Hiiraan",
      "type": "Region"
    },
    {
      "code": "SO-JD",
      "name": "Jubbada Dhexe",
      "type": "Region"
    },
    {
      "code": "SO-JH",
      "name": "Jubbada Hoose",
      "type": "Region"
    },
    {
      "code": "SO-MU",
      "name": "Mudug",
      "type": "Region"
    },
    {
      "code": "SO-NU",
      "name": "Nugaal",
      "type": "Region"
    },
    {
      "code": "SO-SA",
      "name": "Sanaag",
      "type": "Region"
    },
    {
      "code": "SO-SD",
      "name": "Shabeellaha Dhexe",
      "type": "Region"
    },
    {
      "code": "SO-SH",
      "name": "Shabeellaha Hoose",
      "type": "Region"
    },
    {
      "code": "SO-SO",
      "name": "Sool",
      "type": "Region"
    },
    {
      "code": "SO-TO",
      "name": "Togdheer",
      "type": "Region"
    },
    {
      "code": "SO-WO",
      "name": "Woqooyi Galbeed",
      "type": "Region"
    },
    {
      "code": "SR-BR",
      "name": "Brokopondo",
      "type": "District"
    },
    {
      "code": "SR-CM",
      "name": "Commewijne",
      "type": "District"
    },
    {
      "code": "SR-CR",
      "name": "Coronie",
      "type": "District"
    },
    {
      "code": "SR-MA",
      "name": "Marowijne",
      "type": "District"
    },
    {
      "code": "SR-NI",
      "name": "Nickerie",
      "type": "District"
    },
    {
      "code": "SR-PM",
      "name": "Paramaribo",
      "type": "District"
    },
    {
      "code": "SR-PR",
      "name": "Para",
      "type": "District"
    },
    {
      "code": "SR-SA",
      "name": "Saramacca",
      "type": "District"
    },
    {
      "code": "SR-SI",
      "name": "Sipaliwini",
      "type": "District"
    },
    {
      "code": "SR-WA",
      "name": "Wanica",
      "type": "District"
    },
    {
      "code": "SS-BN",
      "name": "Northern Bahr el Ghazal",
      "type": "State"
    },
    {
      "code": "SS-BW",
      "name": "Western Bahr el Ghazal",
      "type": "State"
    },
    {
      "code": "SS-EC",
      "name": "Central Equatoria",
      "type": "State"
    },
    {
      "code": "SS-EE",
      "name": "Eastern Equatoria",
      "type": "State"
    },
    {
      "code": "SS-EW",
      "name": "Western Equatoria",
      "type": "State"
    },
    {
      "code": "SS-JG",
      "name": "Jonglei",
      "type": "State"
    },
    {
      "code": "SS-LK",
      "name": "Lakes",
      "type": "State"
    },
    {
      "code": "SS-NU",
      "name": "Upper Nile",
      "type": "State"
    },
    {
      "code": "SS-UY",
      "name": "Unity",
      "type": "State"
    },
    {
      "code": "SS-WR",
      "name": "Warrap",
      "type": "State"
    },
    {
      "code": "ST-01",
      "name": "Água Grande",
      "type": "District"
    },
    {
      "code": "ST-02",
      "name": "Cantagalo",
      "type": "District"
    },
    {
      "code": "ST-03",
      "name": "Caué",
      "type": "District"
    },
    {
      "code": "ST-04",
      "name": "Lembá",
      "type": "District"
    },
    {
      "code": "ST-05",
      "name": "Lobata",
      "type": "District"
    },
    {
      "code": "ST-06",
      "name": "Mé-Zóchi",
      "type": "District"
    },
    {
      "code": "ST-P",
      "name": "Príncipe",
      "type": "Autonomous region"
    },
    {
      "code": "SV-AH",
      "name": "Ahuachapán",
      "type": "Department"
    },
    {
      "code": "SV-CA",
      "name": "Cabañas",
      "type": "Department"
    },
    {
      "code": "SV-CH",
      "name": "Chalatenango",
      "type": "Department"
    },
    {
      "code": "SV-CU",
      "name": "Cuscatlán",
      "type": "Department"
    },
    {
      "code": "SV-LI",
      "name": "La Libertad",
      "type": "Department"
    },
    {
      "code": "SV-MO",
      "name": "Morazán",
      "type": "Department"
    },
    {
      "code": "SV-PA",
      "name": "La Paz",
      "type": "Department"
    },
    {
      "code": "SV-SA",
      "name": "Santa Ana",
      "type": "Department"
    },
    {
      "code": "SV-SM",
      "name": "San Miguel",
      "type": "Department"
    },
    {
      "code": "SV-SO",
      "name": "Sonsonate",
      "type": "Department"
    },
    {
      "code": "SV-SS",
      "name": "San Salvador",
      "type": "Department"
    },
    {
      "code": "SV-SV",
      "name": "San Vicente",
      "type": "Department"
    },
    {
      "code": "SV-UN",
      "name": "La Unión",
      "type": "Department"
    },
    {
      "code": "SV-US",
      "name": "Usulután",
      "type": "Department"
    },
    {
      "code": "SY-DI",
      "name": "Dimashq",
      "type": "Province"
    },
    {
      "code": "SY-DR",
      "name": "Dar'ā",
      "type": "Province"
    },
    {
      "code": "SY-DY",
      "name": "Dayr az Zawr",
      "type": "Province"
    },
    {
      "code": "SY-HA",
      "name": "Al Ḩasakah",
      "type": "Province"
    },
    {
      "code": "SY-HI",
      "name": "Ḩimş",
      "type": "Province"
    },
    {
      "code": "SY-HL",
      "name": "Ḩalab",
      "type": "Province"
    },
    {
      "code": "SY-HM",
      "name": "Ḩamāh",
      "type": "Province"
    },
    {
      "code": "SY-ID",
      "name": "Idlib",
      "type": "Province"
    },
    {
      "code": "SY-LA",
      "name": "Al Lādhiqīyah",
      "type": "Province"
    },
    {
      "code": "SY-QU",
      "name": "Al Qunayţirah",
      "type": "Province"
    },
    {
      "code": "SY-RA",
      "name": "Ar Raqqah",
      "type": "Province"
    },
    {
      "code": "SY-RD",
      "name": "Rīf Dimashq",
      "type": "Province"
    },
    {
      "code": "SY-SU",
      "name": "As Suwaydā'",
      "type": "Province"
    },
    {
      "code": "SY-TA",
      "name": "Ţarţūs",
      "type": "Province"
    },
    {
      "code": "SZ-HH",
      "name": "Hhohho",
      "type": "Region"
    },
    {
      "code": "SZ-LU",
      "name": "Lubombo",
      "type": "Region"
    },
    {
      "code": "SZ-MA",
      "name": "Manzini",
      "type": "Region"
    },
    {
      "code": "SZ-SH",
      "name": "Shiselweni",
      "type": "Region"
    },
    {
      "code": "TD-BA",
      "name": "Al Baţḩā’",
      "type": "Province"
    },
    {
      "code": "TD-BG",
      "name": "Bahr el Ghazal",
      "type": "Province"
    },
    {
      "code": "TD-BO",
      "name": "Borkou",
      "type": "Province"
    },
    {
      "code": "TD-CB",
      "name": "Chari-Baguirmi",
      "type": "Province"
    },
    {
      "code": "TD-EE",
      "name": "Ennedi-Est",
      "type": "Province"
    },
    {
      "code": "TD-EO",
      "name": "Ennedi-Ouest",
      "type": "Province"
    },
    {
      "code": "TD-GR",
      "name": "Guéra",
      "type": "Province"
    },
    {
      "code": "TD-HL",
      "name": "Hadjer Lamis",
      "type": "Province"
    },
    {
      "code": "TD-KA",
      "name": "Kanem",
      "type": "Province"
    },
    {
      "code": "TD-LC",
      "name": "Al Buḩayrah",
      "type": "Province"
    },
    {
      "code": "TD-LO",
      "name": "Logone-Occidental",
      "type": "Province"
    },
    {
      "code": "TD-LR",
      "name": "Logone-Oriental",
      "type": "Province"
    },
    {
      "code": "TD-MA",
      "name": "Mandoul",
      "type": "Province"
    },
    {
      "code": "TD-MC",
      "name": "Moyen-Chari",
      "type": "Province"
    },
    {
      "code": "TD-ME",
      "name": "Mayo-Kebbi-Est",
      "type": "Province"
    },
    {
      "code": "TD-MO",
      "name": "Mayo-Kebbi-Ouest",
      "type": "Province"
    },
    {
      "code": "TD-ND",
      "name": "Madīnat Injamīnā",
      "type": "Province"
    },
    {
      "code": "TD-OD",
      "name": "Ouaddaï",
      "type": "Province"
    },
    {
      "code": "TD-SA",
      "name": "Salamat",
      "type": "Province"
    },
    {
      "code": "TD-SI",
      "name": "Sila",
      "type": "Province"
    },
    {
      "code": "TD-TA",
      "name": "Tandjilé",
      "type": "Province"
    },
    {
      "code": "TD-TI",
      "name": "Tibastī",
      "type": "Province"
    },
    {
      "code": "TD-WF",
      "name": "Wadi Fira",
      "type": "Province"
    },
    {
      "code": "TG-C",
      "name": "Centrale",
      "type": "Region"
    },
    {
      "code": "TG-K",
      "name": "Kara",
      "type": "Region"
    },
    {
      "code": "TG-M",
      "name": "Maritime (Région)",
      "type": "Region"
    },
    {
      "code": "TG-P",
      "name": "Plateaux",
      "type": "Region"
    },
    {
      "code": "TG-S",
      "name": "Savanes",
      "type": "Region"
    },
    {
      "code": "TH-10",
      "name": "Krung Thep Maha Nakhon",
      "type": "Metropolitan administration"
    },
    {
      "code": "TH-11",
      "name": "Samut Prakan",
      "type": "Province"
    },
    {
      "code": "TH-12",
      "name": "Nonthaburi",
      "type": "Province"
    },
    {
      "code": "TH-13",
      "name": "Pathum Thani",
      "type": "Province"
    },
    {
      "code": "TH-14",
      "name": "Phra Nakhon Si Ayutthaya",
      "type": "Province"
    },
    {
      "code": "TH-15",
      "name": "Ang Thong",
      "type": "Province"
    },
    {
      "code": "TH-16",
      "name": "Lop Buri",
      "type": "Province"
    },
    {
      "code": "TH-17",
      "name": "Sing Buri",
      "type": "Province"
    },
    {
      "code": "TH-18",
      "name": "Chai Nat",
      "type": "Province"
    },
    {
      "code": "TH-19",
      "name": "Saraburi",
      "type": "Province"
    },
    {
      "code": "TH-20",
      "name": "Chon Buri",
      "type": "Province"
    },
    {
      "code": "TH-21",
      "name": "Rayong",
      "type": "Province"
    },
    {
      "code": "TH-22",
      "name": "Chanthaburi",
      "type": "Province"
    },
    {
      "code": "TH-23",
      "name": "Trat",
      "type": "Province"
    },
    {
      "code": "TH-24",
      "name": "Chachoengsao",
      "type": "Province"
    },
    {
      "code": "TH-25",
      "name": "Prachin Buri",
      "type": "Province"
    },
    {
      "code": "TH-26",
      "name": "Nakhon Nayok",
      "type": "Province"
    },
    {
      "code": "TH-27",
      "name": "Sa Kaeo",
      "type": "Province"
    },
    {
      "code": "TH-30",
      "name": "Nakhon Ratchasima",
      "type": "Province"
    },
    {
      "code": "TH-31",
      "name": "Buri Ram",
      "type": "Province"
    },
    {
      "code": "TH-32",
      "name": "Surin",
      "type": "Province"
    },
    {
      "code": "TH-33",
      "name": "Si Sa Ket",
      "type": "Province"
    },
    {
      "code": "TH-34",
      "name": "Ubon Ratchathani",
      "type": "Province"
    },
    {
      "code": "TH-35",
      "name": "Yasothon",
      "type": "Province"
    },
    {
      "code": "TH-36",
      "name": "Chaiyaphum",
      "type": "Province"
    },
    {
      "code": "TH-37",
      "name": "Amnat Charoen",
      "type": "Province"
    },
    {
      "code": "TH-38",
      "name": "Bueng Kan",
      "type": "Province"
    },
    {
      "code": "TH-39",
      "name": "Nong Bua Lam Phu",
      "type": "Province"
    },
    {
      "code": "TH-40",
      "name": "Khon Kaen",
      "type": "Province"
    },
    {
      "code": "TH-41",
      "name": "Udon Thani",
      "type": "Province"
    },
    {
      "code": "TH-42",
      "name": "Loei",
      "type": "Province"
    },
    {
      "code": "TH-43",
      "name": "Nong Khai",
      "type": "Province"
    },
    {
      "code": "TH-44",
      "name": "Maha Sarakham",
      "type": "Province"
    },
    {
      "code": "TH-45",
      "name": "Roi Et",
      "type": "Province"
    },
    {
      "code": "TH-46",
      "name": "Kalasin",
      "type": "Province"
    },
    {
      "code": "TH-47",
      "name": "Sakon Nakhon",
      "type": "Province"
    },
    {
      "code": "TH-48",
      "name": "Nakhon Phanom",
      "type": "Province"
    },
    {
      "code": "TH-49",
      "name": "Mukdahan",
      "type": "Province"
    },
    {
      "code": "TH-50",
      "name": "Chiang Mai",
      "type": "Province"
    },
    {
      "code": "TH-51",
      "name": "Lamphun",
      "type": "Province"
    },
    {
      "code": "TH-52",
      "name": "Lampang",
      "type": "Province"
    },
    {
      "code": "TH-53",
      "name": "Uttaradit",
      "type": "Province"
    },
    {
      "code": "TH-54",
      "name": "Phrae",
      "type": "Province"
    },
    {
      "code": "TH-55",
      "name": "Nan",
      "type": "Province"
    },
    {
      "code": "TH-56",
      "name": "Phayao",
      "type": "Province"
    },
    {
      "code": "TH-57",
      "name": "Chiang Rai",
      "type": "Province"
    },
    {
      "code": "TH-58",
      "name": "Mae Hong Son",
      "type": "Province"
    },
    {
      "code": "TH-60",
      "name": "Nakhon Sawan",
      "type": "Province"
    },
    {
      "code": "TH-61",
      "name": "Uthai Thani",
      "type": "Province"
    },
    {
      "code": "TH-62",
      "name": "Kamphaeng Phet",
      "type": "Province"
    },
    {
      "code": "TH-63",
      "name": "Tak",
      "type": "Province"
    },
    {
      "code": "TH-64",
      "name": "Sukhothai",
      "type": "Province"
    },
    {
      "code": "TH-65",
      "name": "Phitsanulok",
      "type": "Province"
    },
    {
      "code": "TH-66",
      "name": "Phichit",
      "type": "Province"
    },
    {
      "code": "TH-67",
      "name": "Phetchabun",
      "type": "Province"
    },
    {
      "code": "TH-70",
      "name": "Ratchaburi",
      "type": "Province"
    },
    {
      "code": "TH-71",
      "name": "Kanchanaburi",
      "type": "Province"
    },
    {
      "code": "TH-72",
      "name": "Suphan Buri",
      "type": "Province"
    },
    {
      "code": "TH-73",
      "name": "Nakhon Pathom",
      "type": "Province"
    },
    {
      "code": "TH-74",
      "name": "Samut Sakhon",
      "type": "Province"
    },
    {
      "code": "TH-75",
      "name": "Samut Songkhram",
      "type": "Province"
    },
    {
      "code": "TH-76",
      "name": "Phetchaburi",
      "type": "Province"
    },
    {
      "code": "TH-77",
      "name": "Prachuap Khiri Khan",
      "type": "Province"
    },
    {
      "code": "TH-80",
      "name": "Nakhon Si Thammarat",
      "type": "Province"
    },
    {
      "code": "TH-81",
      "name": "Krabi",
      "type": "Province"
    },
    {
      "code": "TH-82",
      "name": "Phangnga",
      "type": "Province"
    },
    {
      "code": "TH-83",
      "name": "Phuket",
      "type": "Province"
    },
    {
      "code": "TH-84",
      "name": "Surat Thani",
      "type": "Province"
    },
    {
      "code": "TH-85",
      "name": "Ranong",
      "type": "Province"
    },
    {
      "code": "TH-86",
      "name": "Chumphon",
      "type": "Province"
    },
    {
      "code": "TH-90",
      "name": "Songkhla",
      "type": "Province"
    },
    {
      "code": "TH-91",
      "name": "Satun",
      "type": "Province"
    },
    {
      "code": "TH-92",
      "name": "Trang",
      "type": "Province"
    },
    {
      "code": "TH-93",
      "name": "Phatthalung",
      "type": "Province"
    },
    {
      "code": "TH-94",
      "name": "Pattani",
      "type": "Province"
    },
    {
      "code": "TH-95",
      "name": "Yala",
      "type": "Province"
    },
    {
      "code": "TH-96",
      "name": "Narathiwat",
      "type": "Province"
    },
    {
      "code": "TH-S",
      "name": "Phatthaya",
      "type": "Special administrative city"
    },
    {
      "code": "TJ-DU",
      "name": "Dushanbe",
      "type": "Capital territory"
    },
    {
      "code": "TJ-GB",
      "name": "Kŭhistoni Badakhshon",
      "type": "Autonomous region"
    },
    {
      "code": "TJ-KT",
      "name": "Khatlon",
      "type": "Region"
    },
    {
      "code": "TJ-RA",
      "name": "nohiyahoi tobei jumhurí",
      "type": "Districts under republic administration"
    },
    {
      "code": "TJ-SU",
      "name": "Sughd",
      "type": "Region"
    },
    {
      "code": "TL-AL",
      "name": "Aileu",
      "type": "Municipality"
    },
    {
      "code": "TL-AN",
      "name": "Ainaro",
      "type": "Municipality"
    },
    {
      "code": "TL-BA",
      "name": "Baucau",
      "type": "Municipality"
    },
    {
      "code": "TL-BO",
      "name": "Bobonaro",
      "type": "Municipality"
    },
    {
      "code": "TL-CO",
      "name": "Cova Lima",
      "type": "Municipality"
    },
    {
      "code": "TL-DI",
      "name": "Díli",
      "type": "Municipality"
    },
    {
      "code": "TL-ER",
      "name": "Ermera",
      "type": "Municipality"
    },
    {
      "code": "TL-LA",
      "name": "Lautein",
      "type": "Municipality"
    },
    {
      "code": "TL-LI",
      "name": "Likisá",
      "type": "Municipality"
    },
    {
      "code": "TL-MF",
      "name": "Manufahi",
      "type": "Municipality"
    },
    {
      "code": "TL-MT",
      "name": "Manatuto",
      "type": "Municipality"
    },
    {
      "code": "TL-OE",
      "name": "Oekusi-Ambenu",
      "type": "Special administrative region"
    },
    {
      "code": "TL-VI",
      "name": "Vikeke",
      "type": "Municipality"
    },
    {
      "code": "TM-A",
      "name": "Ahal",
      "type": "Region"
    },
    {
      "code": "TM-B",
      "name": "Balkan",
      "type": "Region"
    },
    {
      "code": "TM-D",
      "name": "Daşoguz",
      "type": "Region"
    },
    {
      "code": "TM-L",
      "name": "Lebap",
      "type": "Region"
    },
    {
      "code": "TM-M",
      "name": "Mary",
      "type": "Region"
    },
    {
      "code": "TM-S",
      "name": "Aşgabat",
      "type": "City"
    },
    {
      "code": "TN-11",
      "name": "Tunis",
      "type": "Governorate"
    },
    {
      "code": "TN-12",
      "name": "L'Ariana",
      "type": "Governorate"
    },
    {
      "code": "TN-13",
      "name": "Ben Arous",
      "type": "Governorate"
    },
    {
      "code": "TN-14",
      "name": "La Manouba",
      "type": "Governorate"
    },
    {
      "code": "TN-21",
      "name": "Nabeul",
      "type": "Governorate"
    },
    {
      "code": "TN-22",
      "name": "Zaghouan",
      "type": "Governorate"
    },
    {
      "code": "TN-23",
      "name": "Bizerte",
      "type": "Governorate"
    },
    {
      "code": "TN-31",
      "name": "Béja",
      "type": "Governorate"
    },
    {
      "code": "TN-32",
      "name": "Jendouba",
      "type": "Governorate"
    },
    {
      "code": "TN-33",
      "name": "Le Kef",
      "type": "Governorate"
    },
    {
      "code": "TN-34",
      "name": "Siliana",
      "type": "Governorate"
    },
    {
      "code": "TN-41",
      "name": "Kairouan",
      "type": "Governorate"
    },
    {
      "code": "TN-42",
      "name": "Kasserine",
      "type": "Governorate"
    },
    {
      "code": "TN-43",
      "name": "Sidi Bouzid",
      "type": "Governorate"
    },
    {
      "code": "TN-51",
      "name": "Sousse",
      "type": "Governorate"
    },
    {
      "code": "TN-52",
      "name": "Monastir",
      "type": "Governorate"
    },
    {
      "code": "TN-53",
      "name": "Mahdia",
      "type": "Governorate"
    },
    {
      "code": "TN-61",
      "name": "Sfax",
      "type": "Governorate"
    },
    {
      "code": "TN-71",
      "name": "Gafsa",
      "type": "Governorate"
    },
    {
      "code": "TN-72",
      "name": "Tozeur",
      "type": "Governorate"
    },
    {
      "code": "TN-73",
      "name": "Kébili",
      "type": "Governorate"
    },
    {
      "code": "TN-81",
      "name": "Gabès",
      "type": "Governorate"
    },
    {
      "code": "TN-82",
      "name": "Médenine",
      "type": "Governorate"
    },
    {
      "code": "TN-83",
      "name": "Tataouine",
      "type": "Governorate"
    },
    {
      "code": "TO-01",
      "name": "'Eua",
      "type": "Division"
    },
    {
      "code": "TO-02",
      "name": "Ha'apai",
      "type": "Division"
    },
    {
      "code": "TO-03",
      "name": "Niuas",
      "type": "Division"
    },
    {
      "code": "TO-04",
      "name": "Tongatapu",
      "type": "Division"
    },
    {
      "code": "TO-05",
      "name": "Vava'u",
      "type": "Division"
    },
    {
      "code": "TR-01",
      "name": "Adana",
      "type": "Province"
    },
    {
      "code": "TR-02",
      "name": "Adıyaman",
      "type": "Province"
    },
    {
      "code": "TR-03",
      "name": "Afyonkarahisar",
      "type": "Province"
    },
    {
      "code": "TR-04",
      "name": "Ağrı",
      "type": "Province"
    },
    {
      "code": "TR-05",
      "name": "Amasya",
      "type": "Province"
    },
    {
      "code": "TR-06",
      "name": "Ankara",
      "type": "Province"
    },
    {
      "code": "TR-07",
      "name": "Antalya",
      "type": "Province"
    },
    {
      "code": "TR-08",
      "name": "Artvin",
      "type": "Province"
    },
    {
      "code": "TR-09",
      "name": "Aydın",
      "type": "Province"
    },
    {
      "code": "TR-10",
      "name": "Balıkesir",
      "type": "Province"
    },
    {
      "code": "TR-11",
      "name": "Bilecik",
      "type": "Province"
    },
    {
      "code": "TR-12",
      "name": "Bingöl",
      "type": "Province"
    },
    {
      "code": "TR-13",
      "name": "Bitlis",
      "type": "Province"
    },
    {
      "code": "TR-14",
      "name": "Bolu",
      "type": "Province"
    },
    {
      "code": "TR-15",
      "name": "Burdur",
      "type": "Province"
    },
    {
      "code": "TR-16",
      "name": "Bursa",
      "type": "Province"
    },
    {
      "code": "TR-17",
      "name": "Çanakkale",
      "type": "Province"
    },
    {
      "code": "TR-18",
      "name": "Çankırı",
      "type": "Province"
    },
    {
      "code": "TR-19",
      "name": "Çorum",
      "type": "Province"
    },
    {
      "code": "TR-20",
      "name": "Denizli",
      "type": "Province"
    },
    {
      "code": "TR-21",
      "name": "Diyarbakır",
      "type": "Province"
    },
    {
      "code": "TR-22",
      "name": "Edirne",
      "type": "Province"
    },
    {
      "code": "TR-23",
      "name": "Elazığ",
      "type": "Province"
    },
    {
      "code": "TR-24",
      "name": "Erzincan",
      "type": "Province"
    },
    {
      "code": "TR-25",
      "name": "Erzurum",
      "type": "Province"
    },
    {
      "code": "TR-26",
      "name": "Eskişehir",
      "type": "Province"
    },
    {
      "code": "TR-27",
      "name": "Gaziantep",
      "type": "Province"
    },
    {
      "code": "TR-28",
      "name": "Giresun",
      "type": "Province"
    },
    {
      "code": "TR-29",
      "name": "Gümüşhane",
      "type": "Province"
    },
    {
      "code": "TR-30",
      "name": "Hakkâri",
      "type": "Province"
    },
    {
      "code": "TR-31",
      "name": "Hatay",
      "type": "Province"
    },
    {
      "code": "TR-32",
      "name": "Isparta",
      "type": "Province"
    },
    {
      "code": "TR-33",
      "name": "Mersin",
      "type": "Province"
    },
    {
      "code": "TR-34",
      "name": "İstanbul",
      "type": "Province"
    },
    {
      "code": "TR-35",
      "name": "İzmir",
      "type": "Province"
    },
    {
      "code": "TR-36",
      "name": "Kars",
      "type": "Province"
    },
    {
      "code": "TR-37",
      "name": "Kastamonu",
      "type": "Province"
    },
    {
      "code": "TR-38",
      "name": "Kayseri",
      "type": "Province"
    },
    {
      "code": "TR-39",
      "name": "Kırklareli",
      "type": "Province"
    },
    {
      "code": "TR-40",
      "name": "Kırşehir",
      "type": "Province"
    },
    {
      "code": "TR-41",
      "name": "Kocaeli",
      "type": "Province"
    },
    {
      "code": "TR-42",
      "name": "Konya",
      "type": "Province"
    },
    {
      "code": "TR-43",
      "name": "Kütahya",
      "type": "Province"
    },
    {
      "code": "TR-44",
      "name": "Malatya",
      "type": "Province"
    },
    {
      "code": "TR-45",
      "name": "Manisa",
      "type": "Province"
    },
    {
      "code": "TR-46",
      "name": "Kahramanmaraş",
      "type": "Province"
    },
    {
      "code": "TR-47",
      "name": "Mardin",
      "type": "Province"
    },
    {
      "code": "TR-48",
      "name": "Muğla",
      "type": "Province"
    },
    {
      "code": "TR-49",
      "name": "Muş",
      "type": "Province"
    },
    {
      "code": "TR-50",
      "name": "Nevşehir",
      "type": "Province"
    },
    {
      "code": "TR-51",
      "name": "Niğde",
      "type": "Province"
    },
    {
      "code": "TR-52",
      "name": "Ordu",
      "type": "Province"
    },
    {
      "code": "TR-53",
      "name": "Rize",
      "type": "Province"
    },
    {
      "code": "TR-54",
      "name": "Sakarya",
      "type": "Province"
    },
    {
      "code": "TR-55",
      "name": "Samsun",
      "type": "Province"
    },
    {
      "code": "TR-56",
      "name": "Siirt",
      "type": "Province"
    },
    {
      "code": "TR-57",
      "name": "Sinop",
      "type": "Province"
    },
    {
      "code": "TR-58",
      "name": "Sivas",
      "type": "Province"
    },
    {
      "code": "TR-59",
      "name": "Tekirdağ",
      "type": "Province"
    },
    {
      "code": "TR-60",
      "name": "Tokat",
      "type": "Province"
    },
    {
      "code": "TR-61",
      "name": "Trabzon",
      "type": "Province"
    },
    {
      "code": "TR-62",
      "name": "Tunceli",
      "type": "Province"
    },
    {
      "code": "TR-63",
      "name": "Şanlıurfa",
      "type": "Province"
    },
    {
      "code": "TR-64",
      "name": "Uşak",
      "type": "Province"
    },
    {
      "code": "TR-65",
      "name": "Van",
      "type": "Province"
    },
    {
      "code": "TR-66",
      "name": "Yozgat",
      "type": "Province"
    },
    {
      "code": "TR-67",
      "name": "Zonguldak",
      "type": "Province"
    },
    {
      "code": "TR-68",
      "name": "Aksaray",
      "type": "Province"
    },
    {
      "code": "TR-69",
      "name": "Bayburt",
      "type": "Province"
    },
    {
      "code": "TR-70",
      "name": "Karaman",
      "type": "Province"
    },
    {
      "code": "TR-71",
      "name": "Kırıkkale",
      "type": "Province"
    },
    {
      "code": "TR-72",
      "name": "Batman",
      "type": "Province"
    },
    {
      "code": "TR-73",
      "name": "Şırnak",
      "type": "Province"
    },
    {
      "code": "TR-74",
      "name": "Bartın",
      "type": "Province"
    },
    {
      "code": "TR-75",
      "name": "Ardahan",
      "type": "Province"
    },
    {
      "code": "TR-76",
      "name": "Iğdır",
      "type": "Province"
    },
    {
      "code": "TR-77",
      "name": "Yalova",
      "type": "Province"
    },
    {
      "code": "TR-78",
      "name": "Karabük",
      "type": "Province"
    },
    {
      "code": "TR-79",
      "name": "Kilis",
      "type": "Province"
    },
    {
      "code": "TR-80",
      "name": "Osmaniye",
      "type": "Province"
    },
    {
      "code": "TR-81",
      "name": "Düzce",
      "type": "Province"
    },
    {
      "code": "TT-ARI",
      "name": "Arima",
      "type": "Borough"
    },
    {
      "code": "TT-CHA",
      "name": "Chaguanas",
      "type": "Borough"
    },
    {
      "code": "TT-CTT",
      "name": "Couva-Tabaquite-Talparo",
      "type": "Region"
    },
    {
      "code": "TT-DMN",
      "name": "Diego Martin",
      "type": "Region"
    },
    {
      "code": "TT-MRC",
      "name": "Mayaro-Rio Claro",
      "type": "Region"
    },
    {
      "code": "TT-PED",
      "name": "Penal-Debe",
      "type": "Region"
    },
    {
      "code": "TT-POS",
      "name": "Port of Spain",
      "type": "City"
    },
    {
      "code": "TT-PRT",
      "name": "Princes Town",
      "type": "Region"
    },
    {
      "code": "TT-PTF",
      "name": "Point Fortin",
      "type": "Borough"
    },
    {
      "code": "TT-SFO",
      "name": "San Fernando",
      "type": "City"
    },
    {
      "code": "TT-SGE",
      "name": "Sangre Grande",
      "type": "Region"
    },
    {
      "code": "TT-SIP",
      "name": "Siparia",
      "type": "Region"
    },
    {
      "code": "TT-SJL",
      "name": "San Juan-Laventille",
      "type": "Region"
    },
    {
      "code": "TT-TOB",
      "name": "Tobago",
      "type": "Ward"
    },
    {
      "code": "TT-TUP",
      "name": "Tunapuna-Piarco",
      "type": "Region"
    },
    {
      "code": "TV-FUN",
      "name": "Funafuti",
      "type": "Town council"
    },
    {
      "code": "TV-NIT",
      "name": "Niutao",
      "type": "Island council"
    },
    {
      "code": "TV-NKF",
      "name": "Nukufetau",
      "type": "Island council"
    },
    {
      "code": "TV-NKL",
      "name": "Nukulaelae",
      "type": "Island council"
    },
    {
      "code": "TV-NMA",
      "name": "Nanumea",
      "type": "Island council"
    },
    {
      "code": "TV-NMG",
      "name": "Nanumaga",
      "type": "Island council"
    },
    {
      "code": "TV-NUI",
      "name": "Nui",
      "type": "Island council"
    },
    {
      "code": "TV-VAI",
      "name": "Vaitupu",
      "type": "Island council"
    },
    {
      "code": "TW-CHA",
      "name": "Changhua",
      "type": "County"
    },
    {
      "code": "TW-CYI",
      "name": "Chiayi",
      "type": "City"
    },
    {
      "code": "TW-CYQ",
      "name": "Chiayi",
      "type": "County"
    },
    {
      "code": "TW-HSQ",
      "name": "Hsinchu",
      "type": "County"
    },
    {
      "code": "TW-HSZ",
      "name": "Hsinchu",
      "type": "City"
    },
    {
      "code": "TW-HUA",
      "name": "Hualien",
      "type": "County"
    },
    {
      "code": "TW-ILA",
      "name": "Yilan",
      "type": "County"
    },
    {
      "code": "TW-KEE",
      "name": "Keelung",
      "type": "City"
    },
    {
      "code": "TW-KHH",
      "name": "Kaohsiung",
      "type": "Special municipality"
    },
    {
      "code": "TW-KIN",
      "name": "Kinmen",
      "type": "County"
    },
    {
      "code": "TW-LIE",
      "name": "Lienchiang",
      "type": "County"
    },
    {
      "code": "TW-MIA",
      "name": "Miaoli",
      "type": "County"
    },
    {
      "code": "TW-NAN",
      "name": "Nantou",
      "type": "County"
    },
    {
      "code": "TW-NWT",
      "name": "New Taipei",
      "type": "Special municipality"
    },
    {
      "code": "TW-PEN",
      "name": "Penghu",
      "type": "County"
    },
    {
      "code": "TW-PIF",
      "name": "Pingtung",
      "type": "County"
    },
    {
      "code": "TW-TAO",
      "name": "Taoyuan",
      "type": "Special municipality"
    },
    {
      "code": "TW-TNN",
      "name": "Tainan",
      "type": "Special municipality"
    },
    {
      "code": "TW-TPE",
      "name": "Taipei",
      "type": "Special municipality"
    },
    {
      "code": "TW-TTT",
      "name": "Taitung",
      "type": "County"
    },
    {
      "code": "TW-TXG",
      "name": "Taichung",
      "type": "Special municipality"
    },
    {
      "code": "TW-YUN",
      "name": "Yunlin",
      "type": "County"
    },
    {
      "code": "TZ-01",
      "name": "Arusha",
      "type": "Region"
    },
    {
      "code": "TZ-02",
      "name": "Dar es Salaam",
      "type": "Region"
    },
    {
      "code": "TZ-03",
      "name": "Dodoma",
      "type": "Region"
    },
    {
      "code": "TZ-04",
      "name": "Iringa",
      "type": "Region"
    },
    {
      "code": "TZ-05",
      "name": "Kagera",
      "type": "Region"
    },
    {
      "code": "TZ-06",
      "name": "Pemba North",
      "type": "Region"
    },
    {
      "code": "TZ-07",
      "name": "Zanzibar North",
      "type": "Region"
    },
    {
      "code": "TZ-08",
      "name": "Kigoma",
      "type": "Region"
    },
    {
      "code": "TZ-09",
      "name": "Kilimanjaro",
      "type": "Region"
    },
    {
      "code": "TZ-10",
      "name": "Pemba South",
      "type": "Region"
    },
    {
      "code": "TZ-11",
      "name": "Zanzibar South",
      "type": "Region"
    },
    {
      "code": "TZ-12",
      "name": "Lindi",
      "type": "Region"
    },
    {
      "code": "TZ-13",
      "name": "Mara",
      "type": "Region"
    },
    {
      "code": "TZ-14",
      "name": "Mbeya",
      "type": "Region"
    },
    {
      "code": "TZ-15",
      "name": "Zanzibar West",
      "type": "Region"
    },
    {
      "code": "TZ-16",
      "name": "Morogoro",
      "type": "Region"
    },
    {
      "code": "TZ-17",
      "name": "Mtwara",
      "type": "Region"
    },
    {
      "code": "TZ-18",
      "name": "Mwanza",
      "type": "Region"
    },
    {
      "code": "TZ-19",
      "name": "Coast",
      "type": "Region"
    },
    {
      "code": "TZ-20",
      "name": "Rukwa",
      "type": "Region"
    },
    {
      "code": "TZ-21",
      "name": "Ruvuma",
      "type": "Region"
    },
    {
      "code": "TZ-22",
      "name": "Shinyanga",
      "type": "Region"
    },
    {
      "code": "TZ-23",
      "name": "Singida",
      "type": "Region"
    },
    {
      "code": "TZ-24",
      "name": "Tabora",
      "type": "Region"
    },
    {
      "code": "TZ-25",
      "name": "Tanga",
      "type": "Region"
    },
    {
      "code": "TZ-26",
      "name": "Manyara",
      "type": "Region"
    },
    {
      "code": "TZ-27",
      "name": "Geita",
      "type": "Region"
    },
    {
      "code": "TZ-28",
      "name": "Katavi",
      "type": "Region"
    },
    {
      "code": "TZ-29",
      "name": "Njombe",
      "type": "Region"
    },
    {
      "code": "TZ-30",
      "name": "Simiyu",
      "type": "Region"
    },
    {
      "code": "TZ-31",
      "name": "Songwe",
      "type": "Region"
    },
    {
      "code": "UA-05",
      "name": "Vinnytska oblast",
      "type": "Region"
    },
    {
      "code": "UA-07",
      "name": "Volynska oblast",
      "type": "Region"
    },
    {
      "code": "UA-09",
      "name": "Luhanska oblast",
      "type": "Region"
    },
    {
      "code": "UA-12",
      "name": "Dnipropetrovska oblast",
      "type": "Region"
    },
    {
      "code": "UA-14",
      "name": "Donetska oblast",
      "type": "Region"
    },
    {
      "code": "UA-18",
      "name": "Zhytomyrska oblast",
      "type": "Region"
    },
    {
      "code": "UA-21",
      "name": "Zakarpatska oblast",
      "type": "Region"
    },
    {
      "code": "UA-23",
      "name": "Zaporizka oblast",
      "type": "Region"
    },
    {
      "code": "UA-26",
      "name": "Ivano-Frankivska oblast",
      "type": "Region"
    },
    {
      "code": "UA-30",
      "name": "Kyiv",
      "type": "City"
    },
    {
      "code": "UA-32",
      "name": "Kyivska oblast",
      "type": "Region"
    },
    {
      "code": "UA-35",
      "name": "Kirovohradska oblast",
      "type": "Region"
    },
    {
      "code": "UA-40",
      "name": "Sevastopol",
      "type": "City"
    },
    {
      "code": "UA-43",
      "name": "Avtonomna Respublika Krym",
      "type": "Republic"
    },
    {
      "code": "UA-46",
      "name": "Lvivska oblast",
      "type": "Region"
    },
    {
      "code": "UA-48",
      "name": "Mykolaivska oblast",
      "type": "Region"
    },
    {
      "code": "UA-51",
      "name": "Odeska oblast",
      "type": "Region"
    },
    {
      "code": "UA-53",
      "name": "Poltavska oblast",
      "type": "Region"
    },
    {
      "code": "UA-56",
      "name": "Rivnenska oblast",
      "type": "Region"
    },
    {
      "code": "UA-59",
      "name": "Sumska oblast",
      "type": "Region"
    },
    {
      "code": "UA-61",
      "name": "Ternopilska oblast",
      "type": "Region"
    },
    {
      "code": "UA-63",
      "name": "Kharkivska oblast",
      "type": "Region"
    },
    {
      "code": "UA-65",
      "name": "Khersonska oblast",
      "type": "Region"
    },
    {
      "code": "UA-68",
      "name": "Khmelnytska oblast",
      "type": "Region"
    },
    {
      "code": "UA-71",
      "name": "Cherkaska oblast",
      "type": "Region"
    },
    {
      "code": "UA-74",
      "name": "Chernihivska oblast",
      "type": "Region"
    },
    {
      "code": "UA-77",
      "name": "Chernivetska oblast",
      "type": "Region"
    },
    {
      "code": "UG-101",
      "name": "Kalangala",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "UG-102",
      "name": "Kampala",
      "parent": "C",
      "type": "City"
    },
    {
      "code": "UG-103",
      "name": "Kiboga",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "UG-104",
      "name": "Luwero",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "UG-105",
      "name": "Masaka",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "UG-106",
      "name": "Mpigi",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "UG-107",
      "name": "Mubende",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "UG-108",
      "name": "Mukono",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "UG-109",
      "name": "Nakasongola",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "UG-110",
      "name": "Rakai",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "UG-111",
      "name": "Sembabule",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "UG-112",
      "name": "Kayunga",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "UG-113",
      "name": "Wakiso",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "UG-114",
      "name": "Lyantonde",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "UG-115",
      "name": "Mityana",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "UG-116",
      "name": "Nakaseke",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "UG-117",
      "name": "Buikwe",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "UG-118",
      "name": "Bukomansibi",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "UG-119",
      "name": "Butambala",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "UG-120",
      "name": "Buvuma",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "UG-121",
      "name": "Gomba",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "UG-122",
      "name": "Kalungu",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "UG-123",
      "name": "Kyankwanzi",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "UG-124",
      "name": "Lwengo",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "UG-125",
      "name": "Kyotera",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "UG-126",
      "name": "Kasanda",
      "parent": "C",
      "type": "District"
    },
    {
      "code": "UG-201",
      "name": "Bugiri",
      "parent": "E",
      "type": "District"
    },
    {
      "code": "UG-202",
      "name": "Busia",
      "parent": "E",
      "type": "District"
    },
    {
      "code": "UG-203",
      "name": "Iganga",
      "parent": "E",
      "type": "District"
    },
    {
      "code": "UG-204",
      "name": "Jinja",
      "parent": "E",
      "type": "District"
    },
    {
      "code": "UG-205",
      "name": "Kamuli",
      "parent": "E",
      "type": "District"
    },
    {
      "code": "UG-206",
      "name": "Kapchorwa",
      "parent": "E",
      "type": "District"
    },
    {
      "code": "UG-207",
      "name": "Katakwi",
      "parent": "E",
      "type": "District"
    },
    {
      "code": "UG-208",
      "name": "Kumi",
      "parent": "E",
      "type": "District"
    },
    {
      "code": "UG-209",
      "name": "Mbale",
      "parent": "E",
      "type": "District"
    },
    {
      "code": "UG-210",
      "name": "Pallisa",
      "parent": "E",
      "type": "District"
    },
    {
      "code": "UG-211",
      "name": "Soroti",
      "parent": "E",
      "type": "District"
    },
    {
      "code": "UG-212",
      "name": "Tororo",
      "parent": "E",
      "type": "District"
    },
    {
      "code": "UG-213",
      "name": "Kaberamaido",
      "parent": "E",
      "type": "District"
    },
    {
      "code": "UG-214",
      "name": "Mayuge",
      "parent": "E",
      "type": "District"
    },
    {
      "code": "UG-215",
      "name": "Sironko",
      "parent": "E",
      "type": "District"
    },
    {
      "code": "UG-216",
      "name": "Amuria",
      "parent": "E",
      "type": "District"
    },
    {
      "code": "UG-217",
      "name": "Budaka",
      "parent": "E",
      "type": "District"
    },
    {
      "code": "UG-218",
      "name": "Bududa",
      "parent": "E",
      "type": "District"
    },
    {
      "code": "UG-219",
      "name": "Bukedea",
      "parent": "E",
      "type": "District"
    },
    {
      "code": "UG-220",
      "name": "Bukwo",
      "parent": "E",
      "type": "District"
    },
    {
      "code": "UG-221",
      "name": "Butaleja",
      "parent": "E",
      "type": "District"
    },
    {
      "code": "UG-222",
      "name": "Kaliro",
      "parent": "E",
      "type": "District"
    },
    {
      "code": "UG-223",
      "name": "Manafwa",
      "parent": "E",
      "type": "District"
    },
    {
      "code": "UG-224",
      "name": "Namutumba",
      "parent": "E",
      "type": "District"
    },
    {
      "code": "UG-225",
      "name": "Bulambuli",
      "parent": "E",
      "type": "District"
    },
    {
      "code": "UG-226",
      "name": "Buyende",
      "parent": "E",
      "type": "District"
    },
    {
      "code": "UG-227",
      "name": "Kibuku",
      "parent": "E",
      "type": "District"
    },
    {
      "code": "UG-228",
      "name": "Kween",
      "parent": "E",
      "type": "District"
    },
    {
      "code": "UG-229",
      "name": "Luuka",
      "parent": "E",
      "type": "District"
    },
    {
      "code": "UG-230",
      "name": "Namayingo",
      "parent": "E",
      "type": "District"
    },
    {
      "code": "UG-231",
      "name": "Ngora",
      "parent": "E",
      "type": "District"
    },
    {
      "code": "UG-232",
      "name": "Serere",
      "parent": "E",
      "type": "District"
    },
    {
      "code": "UG-233",
      "name": "Butebo",
      "parent": "E",
      "type": "District"
    },
    {
      "code": "UG-234",
      "name": "Namisindwa",
      "parent": "E",
      "type": "District"
    },
    {
      "code": "UG-235",
      "name": "Bugweri",
      "parent": "E",
      "type": "District"
    },
    {
      "code": "UG-236",
      "name": "Kapelebyong",
      "parent": "E",
      "type": "District"
    },
    {
      "code": "UG-237",
      "name": "Kalaki",
      "parent": "E",
      "type": "District"
    },
    {
      "code": "UG-301",
      "name": "Adjumani",
      "parent": "N",
      "type": "District"
    },
    {
      "code": "UG-302",
      "name": "Apac",
      "parent": "N",
      "type": "District"
    },
    {
      "code": "UG-303",
      "name": "Arua",
      "parent": "N",
      "type": "District"
    },
    {
      "code": "UG-304",
      "name": "Gulu",
      "parent": "N",
      "type": "District"
    },
    {
      "code": "UG-305",
      "name": "Kitgum",
      "parent": "N",
      "type": "District"
    },
    {
      "code": "UG-306",
      "name": "Kotido",
      "parent": "N",
      "type": "District"
    },
    {
      "code": "UG-307",
      "name": "Lira",
      "parent": "N",
      "type": "District"
    },
    {
      "code": "UG-308",
      "name": "Moroto",
      "parent": "N",
      "type": "District"
    },
    {
      "code": "UG-309",
      "name": "Moyo",
      "parent": "N",
      "type": "District"
    },
    {
      "code": "UG-310",
      "name": "Nebbi",
      "parent": "N",
      "type": "District"
    },
    {
      "code": "UG-311",
      "name": "Nakapiripirit",
      "parent": "N",
      "type": "District"
    },
    {
      "code": "UG-312",
      "name": "Pader",
      "parent": "N",
      "type": "District"
    },
    {
      "code": "UG-313",
      "name": "Yumbe",
      "parent": "N",
      "type": "District"
    },
    {
      "code": "UG-314",
      "name": "Abim",
      "parent": "N",
      "type": "District"
    },
    {
      "code": "UG-315",
      "name": "Amolatar",
      "parent": "N",
      "type": "District"
    },
    {
      "code": "UG-316",
      "name": "Amuru",
      "parent": "N",
      "type": "District"
    },
    {
      "code": "UG-317",
      "name": "Dokolo",
      "parent": "N",
      "type": "District"
    },
    {
      "code": "UG-318",
      "name": "Kaabong",
      "parent": "N",
      "type": "District"
    },
    {
      "code": "UG-319",
      "name": "Koboko",
      "parent": "N",
      "type": "District"
    },
    {
      "code": "UG-320",
      "name": "Maracha",
      "parent": "N",
      "type": "District"
    },
    {
      "code": "UG-321",
      "name": "Oyam",
      "parent": "N",
      "type": "District"
    },
    {
      "code": "UG-322",
      "name": "Agago",
      "parent": "N",
      "type": "District"
    },
    {
      "code": "UG-323",
      "name": "Alebtong",
      "parent": "N",
      "type": "District"
    },
    {
      "code": "UG-324",
      "name": "Amudat",
      "parent": "N",
      "type": "District"
    },
    {
      "code": "UG-325",
      "name": "Kole",
      "parent": "N",
      "type": "District"
    },
    {
      "code": "UG-326",
      "name": "Lamwo",
      "parent": "N",
      "type": "District"
    },
    {
      "code": "UG-327",
      "name": "Napak",
      "parent": "N",
      "type": "District"
    },
    {
      "code": "UG-328",
      "name": "Nwoya",
      "parent": "N",
      "type": "District"
    },
    {
      "code": "UG-329",
      "name": "Otuke",
      "parent": "N",
      "type": "District"
    },
    {
      "code": "UG-330",
      "name": "Zombo",
      "parent": "N",
      "type": "District"
    },
    {
      "code": "UG-331",
      "name": "Omoro",
      "parent": "N",
      "type": "District"
    },
    {
      "code": "UG-332",
      "name": "Pakwach",
      "parent": "N",
      "type": "District"
    },
    {
      "code": "UG-333",
      "name": "Kwania",
      "parent": "N",
      "type": "District"
    },
    {
      "code": "UG-334",
      "name": "Nabilatuk",
      "parent": "N",
      "type": "District"
    },
    {
      "code": "UG-335",
      "name": "Karenga",
      "parent": "N",
      "type": "District"
    },
    {
      "code": "UG-336",
      "name": "Madi-Okollo",
      "parent": "N",
      "type": "District"
    },
    {
      "code": "UG-337",
      "name": "Obongi",
      "parent": "N",
      "type": "District"
    },
    {
      "code": "UG-401",
      "name": "Bundibugyo",
      "parent": "W",
      "type": "District"
    },
    {
      "code": "UG-402",
      "name": "Bushenyi",
      "parent": "W",
      "type": "District"
    },
    {
      "code": "UG-403",
      "name": "Hoima",
      "parent": "W",
      "type": "District"
    },
    {
      "code": "UG-404",
      "name": "Kabale",
      "parent": "W",
      "type": "District"
    },
    {
      "code": "UG-405",
      "name": "Kabarole",
      "parent": "W",
      "type": "District"
    },
    {
      "code": "UG-406",
      "name": "Kasese",
      "parent": "W",
      "type": "District"
    },
    {
      "code": "UG-407",
      "name": "Kibaale",
      "parent": "W",
      "type": "District"
    },
    {
      "code": "UG-408",
      "name": "Kisoro",
      "parent": "W",
      "type": "District"
    },
    {
      "code": "UG-409",
      "name": "Masindi",
      "parent": "W",
      "type": "District"
    },
    {
      "code": "UG-410",
      "name": "Mbarara",
      "parent": "W",
      "type": "District"
    },
    {
      "code": "UG-411",
      "name": "Ntungamo",
      "parent": "W",
      "type": "District"
    },
    {
      "code": "UG-412",
      "name": "Rukungiri",
      "parent": "W",
      "type": "District"
    },
    {
      "code": "UG-413",
      "name": "Kamwenge",
      "parent": "W",
      "type": "District"
    },
    {
      "code": "UG-414",
      "name": "Kanungu",
      "parent": "W",
      "type": "District"
    },
    {
      "code": "UG-415",
      "name": "Kyenjojo",
      "parent": "W",
      "type": "District"
    },
    {
      "code": "UG-416",
      "name": "Buliisa",
      "parent": "W",
      "type": "District"
    },
    {
      "code": "UG-417",
      "name": "Ibanda",
      "parent": "W",
      "type": "District"
    },
    {
      "code": "UG-418",
      "name": "Isingiro",
      "parent": "W",
      "type": "District"
    },
    {
      "code": "UG-419",
      "name": "Kiruhura",
      "parent": "W",
      "type": "District"
    },
    {
      "code": "UG-420",
      "name": "Buhweju",
      "parent": "W",
      "type": "District"
    },
    {
      "code": "UG-421",
      "name": "Kiryandongo",
      "parent": "W",
      "type": "District"
    },
    {
      "code": "UG-422",
      "name": "Kyegegwa",
      "parent": "W",
      "type": "District"
    },
    {
      "code": "UG-423",
      "name": "Mitooma",
      "parent": "W",
      "type": "District"
    },
    {
      "code": "UG-424",
      "name": "Ntoroko",
      "parent": "W",
      "type": "District"
    },
    {
      "code": "UG-425",
      "name": "Rubirizi",
      "parent": "W",
      "type": "District"
    },
    {
      "code": "UG-426",
      "name": "Sheema",
      "parent": "W",
      "type": "District"
    },
    {
      "code": "UG-427",
      "name": "Kagadi",
      "parent": "W",
      "type": "District"
    },
    {
      "code": "UG-428",
      "name": "Kakumiro",
      "parent": "W",
      "type": "District"
    },
    {
      "code": "UG-429",
      "name": "Rubanda",
      "parent": "W",
      "type": "District"
    },
    {
      "code": "UG-430",
      "name": "Bunyangabu",
      "parent": "W",
      "type": "District"
    },
    {
      "code": "UG-431",
      "name": "Rukiga",
      "parent": "W",
      "type": "District"
    },
    {
      "code": "UG-432",
      "name": "Kikuube",
      "parent": "W",
      "type": "District"
    },
    {
      "code": "UG-433",
      "name": "Kazo",
      "parent": "W",
      "type": "District"
    },
    {
      "code": "UG-434",
      "name": "Kitagwenda",
      "parent": "W",
      "type": "District"
    },
    {
      "code": "UG-435",
      "name": "Rwampara",
      "parent": "W",
      "type": "District"
    },
    {
      "code": "UG-C",
      "name": "Central",
      "type": "Geographical region"
    },
    {
      "code": "UG-E",
      "name": "Eastern",
      "type": "Geographical region"
    },
    {
      "code": "UG-N",
      "name": "Northern",
      "type": "Geographical region"
    },
    {
      "code": "UG-W",
      "name": "Western",
      "type": "Geographical region"
    },
    {
      "code": "UM-67",
      "name": "Johnston Atoll",
      "type": "Islands, groups of islands"
    },
    {
      "code": "UM-71",
      "name": "Midway Islands",
      "type": "Islands, groups of islands"
    },
    {
      "code": "UM-76",
      "name": "Navassa Island",
      "type": "Islands, groups of islands"
    },
    {
      "code": "UM-79",
      "name": "Wake Island",
      "type": "Islands, groups of islands"
    },
    {
      "code": "UM-81",
      "name": "Baker Island",
      "type": "Islands, groups of islands"
    },
    {
      "code": "UM-84",
      "name": "Howland Island",
      "type": "Islands, groups of islands"
    },
    {
      "code": "UM-86",
      "name": "Jarvis Island",
      "type": "Islands, groups of islands"
    },
    {
      "code": "UM-89",
      "name": "Kingman Reef",
      "type": "Islands, groups of islands"
    },
    {
      "code": "UM-95",
      "name": "Palmyra Atoll",
      "type": "Islands, groups of islands"
    },
    {
      "code": "US-AK",
      "name": "Alaska",
      "type": "State"
    },
    {
      "code": "US-AL",
      "name": "Alabama",
      "type": "State"
    },
    {
      "code": "US-AR",
      "name": "Arkansas",
      "type": "State"
    },
    {
      "code": "US-AS",
      "name": "American Samoa",
      "type": "Outlying area"
    },
    {
      "code": "US-AZ",
      "name": "Arizona",
      "type": "State"
    },
    {
      "code": "US-CA",
      "name": "California",
      "type": "State"
    },
    {
      "code": "US-CO",
      "name": "Colorado",
      "type": "State"
    },
    {
      "code": "US-CT",
      "name": "Connecticut",
      "type": "State"
    },
    {
      "code": "US-DC",
      "name": "District of Columbia",
      "type": "District"
    },
    {
      "code": "US-DE",
      "name": "Delaware",
      "type": "State"
    },
    {
      "code": "US-FL",
      "name": "Florida",
      "type": "State"
    },
    {
      "code": "US-GA",
      "name": "Georgia",
      "type": "State"
    },
    {
      "code": "US-GU",
      "name": "Guam",
      "type": "Outlying area"
    },
    {
      "code": "US-HI",
      "name": "Hawaii",
      "type": "State"
    },
    {
      "code": "US-IA",
      "name": "Iowa",
      "type": "State"
    },
    {
      "code": "US-ID",
      "name": "Idaho",
      "type": "State"
    },
    {
      "code": "US-IL",
      "name": "Illinois",
      "type": "State"
    },
    {
      "code": "US-IN",
      "name": "Indiana",
      "type": "State"
    },
    {
      "code": "US-KS",
      "name": "Kansas",
      "type": "State"
    },
    {
      "code": "US-KY",
      "name": "Kentucky",
      "type": "State"
    },
    {
      "code": "US-LA",
      "name": "Louisiana",
      "type": "State"
    },
    {
      "code": "US-MA",
      "name": "Massachusetts",
      "type": "State"
    },
    {
      "code": "US-MD",
      "name": "Maryland",
      "type": "State"
    },
    {
      "code": "US-ME",
      "name": "Maine",
      "type": "State"
    },
    {
      "code": "US-MI",
      "name": "Michigan",
      "type": "State"
    },
    {
      "code": "US-MN",
      "name": "Minnesota",
      "type": "State"
    },
    {
      "code": "US-MO",
      "name": "Missouri",
      "type": "State"
    },
    {
      "code": "US-MP",
      "name": "Northern Mariana Islands",
      "type": "Outlying area"
    },
    {
      "code": "US-MS",
      "name": "Mississippi",
      "type": "State"
    },
    {
      "code": "US-MT",
      "name": "Montana",
      "type": "State"
    },
    {
      "code": "US-NC",
      "name": "North Carolina",
      "type": "State"
    },
    {
      "code": "US-ND",
      "name": "North Dakota",
      "type": "State"
    },
    {
      "code": "US-NE",
      "name": "Nebraska",
      "type": "State"
    },
    {
      "code": "US-NH",
      "name": "New Hampshire",
      "type": "State"
    },
    {
      "code": "US-NJ",
      "name": "New Jersey",
      "type": "State"
    },
    {
      "code": "US-NM",
      "name": "New Mexico",
      "type": "State"
    },
    {
      "code": "US-NV",
      "name": "Nevada",
      "type": "State"
    },
    {
      "code": "US-NY",
      "name": "New York",
      "type": "State"
    },
    {
      "code": "US-OH",
      "name": "Ohio",
      "type": "State"
    },
    {
      "code": "US-OK",
      "name": "Oklahoma",
      "type": "State"
    },
    {
      "code": "US-OR",
      "name": "Oregon",
      "type": "State"
    },
    {
      "code": "US-PA",
      "name": "Pennsylvania",
      "type": "State"
    },
    {
      "code": "US-PR",
      "name": "Puerto Rico",
      "type": "Outlying area"
    },
    {
      "code": "US-RI",
      "name": "Rhode Island",
      "type": "State"
    },
    {
      "code": "US-SC",
      "name": "South Carolina",
      "type": "State"
    },
    {
      "code": "US-SD",
      "name": "South Dakota",
      "type": "State"
    },
    {
      "code": "US-TN",
      "name": "Tennessee",
      "type": "State"
    },
    {
      "code": "US-TX",
      "name": "Texas",
      "type": "State"
    },
    {
      "code": "US-UM",
      "name": "United States Minor Outlying Islands",
      "type": "Outlying area"
    },
    {
      "code": "US-UT",
      "name": "Utah",
      "type": "State"
    },
    {
      "code": "US-VA",
      "name": "Virginia",
      "type": "State"
    },
    {
      "code": "US-VI",
      "name": "Virgin Islands, U.S.",
      "type": "Outlying area"
    },
    {
      "code": "US-VT",
      "name": "Vermont",
      "type": "State"
    },
    {
      "code": "US-WA",
      "name": "Washington",
      "type": "State"
    },
    {
      "code": "US-WI",
      "name": "Wisconsin",
      "type": "State"
    },
    {
      "code": "US-WV",
      "name": "West Virginia",
      "type": "State"
    },
    {
      "code": "US-WY",
      "name": "Wyoming",
      "type": "State"
    },
    {
      "code": "UY-AR",
      "name": "Artigas",
      "type": "Department"
    },
    {
      "code": "UY-CA",
      "name": "Canelones",
      "type": "Department"
    },
    {
      "code": "UY-CL",
      "name": "Cerro Largo",
      "type": "Department"
    },
    {
      "code": "UY-CO",
      "name": "Colonia",
      "type": "Department"
    },
    {
      "code": "UY-DU",
      "name": "Durazno",
      "type": "Department"
    },
    {
      "code": "UY-FD",
      "name": "Florida",
      "type": "Department"
    },
    {
      "code": "UY-FS",
      "name": "Flores",
      "type": "Department"
    },
    {
      "code": "UY-LA",
      "name": "Lavalleja",
      "type": "Department"
    },
    {
      "code": "UY-MA",
      "name": "Maldonado",
      "type": "Department"
    },
    {
      "code": "UY-MO",
      "name": "Montevideo",
      "type": "Department"
    },
    {
      "code": "UY-PA",
      "name": "Paysandú",
      "type": "Department"
    },
    {
      "code": "UY-RN",
      "name": "Río Negro",
      "type": "Department"
    },
    {
      "code": "UY-RO",
      "name": "Rocha",
      "type": "Department"
    },
    {
      "code": "UY-RV",
      "name": "Rivera",
      "type": "Department"
    },
    {
      "code": "UY-SA",
      "name": "Salto",
      "type": "Department"
    },
    {
      "code": "UY-SJ",
      "name": "San José",
      "type": "Department"
    },
    {
      "code": "UY-SO",
      "name": "Soriano",
      "type": "Department"
    },
    {
      "code": "UY-TA",
      "name": "Tacuarembó",
      "type": "Department"
    },
    {
      "code": "UY-TT",
      "name": "Treinta y Tres",
      "type": "Department"
    },
    {
      "code": "UZ-AN",
      "name": "Andijon",
      "type": "Region"
    },
    {
      "code": "UZ-BU",
      "name": "Buxoro",
      "type": "Region"
    },
    {
      "code": "UZ-FA",
      "name": "Farg‘ona",
      "type": "Region"
    },
    {
      "code": "UZ-JI",
      "name": "Jizzax",
      "type": "Region"
    },
    {
      "code": "UZ-NG",
      "name": "Namangan",
      "type": "Region"
    },
    {
      "code": "UZ-NW",
      "name": "Navoiy",
      "type": "Region"
    },
    {
      "code": "UZ-QA",
      "name": "Qashqadaryo",
      "type": "Region"
    },
    {
      "code": "UZ-QR",
      "name": "Qoraqalpog‘iston Respublikasi",
      "type": "Republic"
    },
    {
      "code": "UZ-SA",
      "name": "Samarqand",
      "type": "Region"
    },
    {
      "code": "UZ-SI",
      "name": "Sirdaryo",
      "type": "Region"
    },
    {
      "code": "UZ-SU",
      "name": "Surxondaryo",
      "type": "Region"
    },
    {
      "code": "UZ-TK",
      "name": "Toshkent",
      "type": "City"
    },
    {
      "code": "UZ-TO",
      "name": "Toshkent",
      "type": "Region"
    },
    {
      "code": "UZ-XO",
      "name": "Xorazm",
      "type": "Region"
    },
    {
      "code": "VC-01",
      "name": "Charlotte",
      "type": "Parish"
    },
    {
      "code": "VC-02",
      "name": "Saint Andrew",
      "type": "Parish"
    },
    {
      "code": "VC-03",
      "name": "Saint David",
      "type": "Parish"
    },
    {
      "code": "VC-04",
      "name": "Saint George",
      "type": "Parish"
    },
    {
      "code": "VC-05",
      "name": "Saint Patrick",
      "type": "Parish"
    },
    {
      "code": "VC-06",
      "name": "Grenadines",
      "type": "Parish"
    },
    {
      "code": "VE-A",
      "name": "Distrito Capital",
      "type": "Capital district"
    },
    {
      "code": "VE-B",
      "name": "Anzoátegui",
      "type": "State"
    },
    {
      "code": "VE-C",
      "name": "Apure",
      "type": "State"
    },
    {
      "code": "VE-D",
      "name": "Aragua",
      "type": "State"
    },
    {
      "code": "VE-E",
      "name": "Barinas",
      "type": "State"
    },
    {
      "code": "VE-F",
      "name": "Bolívar",
      "type": "State"
    },
    {
      "code": "VE-G",
      "name": "Carabobo",
      "type": "State"
    },
    {
      "code": "VE-H",
      "name": "Cojedes",
      "type": "State"
    },
    {
      "code": "VE-I",
      "name": "Falcón",
      "type": "State"
    },
    {
      "code": "VE-J",
      "name": "Guárico",
      "type": "State"
    },
    {
      "code": "VE-K",
      "name": "Lara",
      "type": "State"
    },
    {
      "code": "VE-L",
      "name": "Mérida",
      "type": "State"
    },
    {
      "code": "VE-M",
      "name": "Miranda",
      "type": "State"
    },
    {
      "code": "VE-N",
      "name": "Monagas",
      "type": "State"
    },
    {
      "code": "VE-O",
      "name": "Nueva Esparta",
      "type": "State"
    },
    {
      "code": "VE-P",
      "name": "Portuguesa",
      "type": "State"
    },
    {
      "code": "VE-R",
      "name": "Sucre",
      "type": "State"
    },
    {
      "code": "VE-S",
      "name": "Táchira",
      "type": "State"
    },
    {
      "code": "VE-T",
      "name": "Trujillo",
      "type": "State"
    },
    {
      "code": "VE-U",
      "name": "Yaracuy",
      "type": "State"
    },
    {
      "code": "VE-V",
      "name": "Zulia",
      "type": "State"
    },
    {
      "code": "VE-W",
      "name": "Dependencias Federales",
      "type": "Federal dependency"
    },
    {
      "code": "VE-X",
      "name": "La Guaira",
      "type": "State"
    },
    {
      "code": "VE-Y",
      "name": "Delta Amacuro",
      "type": "State"
    },
    {
      "code": "VE-Z",
      "name": "Amazonas",
      "type": "State"
    },
    {
      "code": "VN-01",
      "name": "Lai Châu",
      "type": "Province"
    },
    {
      "code": "VN-02",
      "name": "Lào Cai",
      "type": "Province"
    },
    {
      "code": "VN-03",
      "name": "Hà Giang",
      "type": "Province"
    },
    {
      "code": "VN-04",
      "name": "Cao Bằng",
      "type": "Province"
    },
    {
      "code": "VN-05",
      "name": "Sơn La",
      "type": "Province"
    },
    {
      "code": "VN-06",
      "name": "Yên Bái",
      "type": "Province"
    },
    {
      "code": "VN-07",
      "name": "Tuyên Quang",
      "type": "Province"
    },
    {
      "code": "VN-09",
      "name": "Lạng Sơn",
      "type": "Province"
    },
    {
      "code": "VN-13",
      "name": "Quảng Ninh",
      "type": "Province"
    },
    {
      "code": "VN-14",
      "name": "Hòa Bình",
      "type": "Province"
    },
    {
      "code": "VN-18",
      "name": "Ninh Bình",
      "type": "Province"
    },
    {
      "code": "VN-20",
      "name": "Thái Bình",
      "type": "Province"
    },
    {
      "code": "VN-21",
      "name": "Thanh Hóa",
      "type": "Province"
    },
    {
      "code": "VN-22",
      "name": "Nghệ An",
      "type": "Province"
    },
    {
      "code": "VN-23",
      "name": "Hà Tĩnh",
      "type": "Province"
    },
    {
      "code": "VN-24",
      "name": "Quảng Bình",
      "type": "Province"
    },
    {
      "code": "VN-25",
      "name": "Quảng Trị",
      "type": "Province"
    },
    {
      "code": "VN-26",
      "name": "Thừa Thiên-Huế",
      "type": "Province"
    },
    {
      "code": "VN-27",
      "name": "Quảng Nam",
      "type": "Province"
    },
    {
      "code": "VN-28",
      "name": "Kon Tum",
      "type": "Province"
    },
    {
      "code": "VN-29",
      "name": "Quảng Ngãi",
      "type": "Province"
    },
    {
      "code": "VN-30",
      "name": "Gia Lai",
      "type": "Province"
    },
    {
      "code": "VN-31",
      "name": "Bình Định",
      "type": "Province"
    },
    {
      "code": "VN-32",
      "name": "Phú Yên",
      "type": "Province"
    },
    {
      "code": "VN-33",
      "name": "Đắk Lắk",
      "type": "Province"
    },
    {
      "code": "VN-34",
      "name": "Khánh Hòa",
      "type": "Province"
    },
    {
      "code": "VN-35",
      "name": "Lâm Đồng",
      "type": "Province"
    },
    {
      "code": "VN-36",
      "name": "Ninh Thuận",
      "type": "Province"
    },
    {
      "code": "VN-37",
      "name": "Tây Ninh",
      "type": "Province"
    },
    {
      "code": "VN-39",
      "name": "Đồng Nai",
      "type": "Province"
    },
    {
      "code": "VN-40",
      "name": "Bình Thuận",
      "type": "Province"
    },
    {
      "code": "VN-41",
      "name": "Long An",
      "type": "Province"
    },
    {
      "code": "VN-43",
      "name": "Bà Rịa - Vũng Tàu",
      "type": "Province"
    },
    {
      "code": "VN-44",
      "name": "An Giang",
      "type": "Province"
    },
    {
      "code": "VN-45",
      "name": "Đồng Tháp",
      "type": "Province"
    },
    {
      "code": "VN-46",
      "name": "Tiền Giang",
      "type": "Province"
    },
    {
      "code": "VN-47",
      "name": "Kiến Giang",
      "type": "Province"
    },
    {
      "code": "VN-49",
      "name": "Vĩnh Long",
      "type": "Province"
    },
    {
      "code": "VN-50",
      "name": "Bến Tre",
      "type": "Province"
    },
    {
      "code": "VN-51",
      "name": "Trà Vinh",
      "type": "Province"
    },
    {
      "code": "VN-52",
      "name": "Sóc Trăng",
      "type": "Province"
    },
    {
      "code": "VN-53",
      "name": "Bắc Kạn",
      "type": "Province"
    },
    {
      "code": "VN-54",
      "name": "Bắc Giang",
      "type": "Province"
    },
    {
      "code": "VN-55",
      "name": "Bạc Liêu",
      "type": "Province"
    },
    {
      "code": "VN-56",
      "name": "Bắc Ninh",
      "type": "Province"
    },
    {
      "code": "VN-57",
      "name": "Bình Dương",
      "type": "Province"
    },
    {
      "code": "VN-58",
      "name": "Bình Phước",
      "type": "Province"
    },
    {
      "code": "VN-59",
      "name": "Cà Mau",
      "type": "Province"
    },
    {
      "code": "VN-61",
      "name": "Hải Dương",
      "type": "Province"
    },
    {
      "code": "VN-63",
      "name": "Hà Nam",
      "type": "Province"
    },
    {
      "code": "VN-66",
      "name": "Hưng Yên",
      "type": "Province"
    },
    {
      "code": "VN-67",
      "name": "Nam Định",
      "type": "Province"
    },
    {
      "code": "VN-68",
      "name": "Phú Thọ",
      "type": "Province"
    },
    {
      "code": "VN-69",
      "name": "Thái Nguyên",
      "type": "Province"
    },
    {
      "code": "VN-70",
      "name": "Vĩnh Phúc",
      "type": "Province"
    },
    {
      "code": "VN-71",
      "name": "Điện Biên",
      "type": "Province"
    },
    {
      "code": "VN-72",
      "name": "Đắk Nông",
      "type": "Province"
    },
    {
      "code": "VN-73",
      "name": "Hậu Giang",
      "type": "Province"
    },
    {
      "code": "VN-CT",
      "name": "Cần Thơ",
      "type": "Municipality"
    },
    {
      "code": "VN-DN",
      "name": "Đà Nẵng",
      "type": "Municipality"
    },
    {
      "code": "VN-HN",
      "name": "Hà Nội",
      "type": "Municipality"
    },
    {
      "code": "VN-HP",
      "name": "Hải Phòng",
      "type": "Municipality"
    },
    {
      "code": "VN-SG",
      "name": "Hồ Chí Minh",
      "type": "Municipality"
    },
    {
      "code": "VU-MAP",
      "name": "Malampa",
      "type": "Province"
    },
    {
      "code": "VU-PAM",
      "name": "Pénama",
      "type": "Province"
    },
    {
      "code": "VU-SAM",
      "name": "Sanma",
      "type": "Province"
    },
    {
      "code": "VU-SEE",
      "name": "Shéfa",
      "type": "Province"
    },
    {
      "code": "VU-TAE",
      "name": "Taféa",
      "type": "Province"
    },
    {
      "code": "VU-TOB",
      "name": "Torba",
      "type": "Province"
    },
    {
      "code": "WF-AL",
      "name": "Alo",
      "type": "Administrative precinct"
    },
    {
      "code": "WF-SG",
      "name": "Sigave",
      "type": "Administrative precinct"
    },
    {
      "code": "WF-UV",
      "name": "Uvea",
      "type": "Administrative precinct"
    },
    {
      "code": "WS-AA",
      "name": "A'ana",
      "type": "District"
    },
    {
      "code": "WS-AL",
      "name": "Aiga-i-le-Tai",
      "type": "District"
    },
    {
      "code": "WS-AT",
      "name": "Atua",
      "type": "District"
    },
    {
      "code": "WS-FA",
      "name": "Fa'asaleleaga",
      "type": "District"
    },
    {
      "code": "WS-GE",
      "name": "Gaga'emauga",
      "type": "District"
    },
    {
      "code": "WS-GI",
      "name": "Gagaifomauga",
      "type": "District"
    },
    {
      "code": "WS-PA",
      "name": "Palauli",
      "type": "District"
    },
    {
      "code": "WS-SA",
      "name": "Satupa'itea",
      "type": "District"
    },
    {
      "code": "WS-TU",
      "name": "Tuamasaga",
      "type": "District"
    },
    {
      "code": "WS-VF",
      "name": "Va'a-o-Fonoti",
      "type": "District"
    },
    {
      "code": "WS-VS",
      "name": "Vaisigano",
      "type": "District"
    },
    {
      "code": "YE-AB",
      "name": "Abyan",
      "type": "Governorate"
    },
    {
      "code": "YE-AD",
      "name": "‘Adan",
      "type": "Governorate"
    },
    {
      "code": "YE-AM",
      "name": "‘Amrān",
      "type": "Governorate"
    },
    {
      "code": "YE-BA",
      "name": "Al Bayḑā’",
      "type": "Governorate"
    },
    {
      "code": "YE-DA",
      "name": "Aḑ Ḑāli‘",
      "type": "Governorate"
    },
    {
      "code": "YE-DH",
      "name": "Dhamār",
      "type": "Governorate"
    },
    {
      "code": "YE-HD",
      "name": "Ḩaḑramawt",
      "type": "Governorate"
    },
    {
      "code": "YE-HJ",
      "name": "Ḩajjah",
      "type": "Governorate"
    },
    {
      "code": "YE-HU",
      "name": "Al Ḩudaydah",
      "type": "Governorate"
    },
    {
      "code": "YE-IB",
      "name": "Ibb",
      "type": "Governorate"
    },
    {
      "code": "YE-JA",
      "name": "Al Jawf",
      "type": "Governorate"
    },
    {
      "code": "YE-LA",
      "name": "Laḩij",
      "type": "Governorate"
    },
    {
      "code": "YE-MA",
      "name": "Ma’rib",
      "type": "Governorate"
    },
    {
      "code": "YE-MR",
      "name": "Al Mahrah",
      "type": "Governorate"
    },
    {
      "code": "YE-MW",
      "name": "Al Maḩwīt",
      "type": "Governorate"
    },
    {
      "code": "YE-RA",
      "name": "Raymah",
      "type": "Governorate"
    },
    {
      "code": "YE-SA",
      "name": "Amānat al ‘Āşimah [city]",
      "type": "Municipality"
    },
    {
      "code": "YE-SD",
      "name": "Şāʻdah",
      "type": "Governorate"
    },
    {
      "code": "YE-SH",
      "name": "Shabwah",
      "type": "Governorate"
    },
    {
      "code": "YE-SN",
      "name": "Şanʻā’",
      "type": "Governorate"
    },
    {
      "code": "YE-SU",
      "name": "Arkhabīl Suquţrá",
      "type": "Governorate"
    },
    {
      "code": "YE-TA",
      "name": "Tāʻizz",
      "type": "Governorate"
    },
    {
      "code": "ZA-EC",
      "name": "Eastern Cape",
      "type": "Province"
    },
    {
      "code": "ZA-FS",
      "name": "Free State",
      "type": "Province"
    },
    {
      "code": "ZA-GP",
      "name": "Gauteng",
      "type": "Province"
    },
    {
      "code": "ZA-KZN",
      "name": "Kwazulu-Natal",
      "type": "Province"
    },
    {
      "code": "ZA-LP",
      "name": "Limpopo",
      "type": "Province"
    },
    {
      "code": "ZA-MP",
      "name": "Mpumalanga",
      "type": "Province"
    },
    {
      "code": "ZA-NC",
      "name": "Northern Cape",
      "type": "Province"
    },
    {
      "code": "ZA-NW",
      "name": "North-West",
      "type": "Province"
    },
    {
      "code": "ZA-WC",
      "name": "Western Cape",
      "type": "Province"
    },
    {
      "code": "ZM-01",
      "name": "Western",
      "type": "Province"
    },
    {
      "code": "ZM-02",
      "name": "Central",
      "type": "Province"
    },
    {
      "code": "ZM-03",
      "name": "Eastern",
      "type": "Province"
    },
    {
      "code": "ZM-04",
      "name": "Luapula",
      "type": "Province"
    },
    {
      "code": "ZM-05",
      "name": "Northern",
      "type": "Province"
    },
    {
      "code": "ZM-06",
      "name": "North-Western",
      "type": "Province"
    },
    {
      "code": "ZM-07",
      "name": "Southern",
      "type": "Province"
    },
    {
      "code": "ZM-08",
      "name": "Copperbelt",
      "type": "Province"
    },
    {
      "code": "ZM-09",
      "name": "Lusaka",
      "type": "Province"
    },
    {
      "code": "ZM-10",
      "name": "Muchinga",
      "type": "Province"
    },
    {
      "code": "ZW-BU",
      "name": "Bulawayo",
      "type": "Province"
    },
    {
      "code": "ZW-HA",
      "name": "Harare",
      "type": "Province"
    },
    {
      "code": "ZW-MA",
      "name": "Manicaland",
      "type": "Province"
    },
    {
      "code": "ZW-MC",
      "name": "Mashonaland Central",
      "type": "Province"
    },
    {
      "code": "ZW-ME",
      "name": "Mashonaland East",
      "type": "Province"
    },
    {
      "code": "ZW-MI",
      "name": "Midlands",
      "type": "Province"
    },
    {
      "code": "ZW-MN",
      "name": "Matabeleland North",
      "type": "Province"
    },
    {
      "code": "ZW-MS",
      "name": "Matabeleland South",
      "type": "Province"
    },
    {
      "code": "ZW-MV",
      "name": "Masvingo",
      "type": "Province"
    },
    {
      "code": "ZW-MW",
      "name": "Mashonaland West",
      "type": "Province"
    }
  ]
}

};
#-------------------------------------------------------------------------------
1;
  
