/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.netbeans.modules.gradle.options;

import org.netbeans.modules.gradle.spi.GradleSettings;
import java.awt.CardLayout;
import java.io.File;
import javax.swing.JFileChooser;
import org.netbeans.spi.options.OptionsPanelController;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import org.netbeans.api.annotations.common.StaticResource;
import org.netbeans.modules.gradle.api.execute.GradleDistributionManager;
import org.netbeans.modules.gradle.api.execute.GradleDistributionManager.GradleDistribution;
import org.openide.LifecycleManager;
import org.openide.awt.NotificationDisplayer;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.NbBundle.Messages;


/**
 *
 * @author Laszlo Kishalmi
 */
@OptionsPanelController.Keywords(keywords = {"gradle"}, location = "Java", tabTitle = "Gradle")
public class SettingsPanel extends javax.swing.JPanel {

    @StaticResource
    private static final String RESTART_ICON = "org/netbeans/modules/gradle/resources/restart.png"; //NOI18

    private static final String[] CARDS = {"Execution", "Appearance", "Dependencies", "Maven", "Experimental"}; //NOI18N

    private GradleDistributionManager gdm = GradleDistributionManager.get();

    /**
     * Creates new form SettingsPanel
     */
    public SettingsPanel() {
        initComponents();
        cbGradleVersion.setRenderer(new VersionCellRenderer(cbGradleVersion.getRenderer()));
        lstCategories.setSelectedIndex(0);

        cbDownloadLibs.setModel(new DefaultComboBoxModel<>(GradleSettings.DownloadLibsRule.values()));
        cbDownloadSources.setModel(new DefaultComboBoxModel<>(GradleSettings.DownloadMiscRule.values()));
        cbDownloadJavadoc.setModel(new DefaultComboBoxModel<>(GradleSettings.DownloadMiscRule.values()));
        cbAllowExecution.setModel(new DefaultComboBoxModel<>(GradleSettings.GradleExecutionRule.values()));
        
        DefaultComboBoxModel mdl = new DefaultComboBoxModel<>(NetworkProxySettings.values());
        if (!NetworkProxySettings.allowProxyOverride()) {
            mdl.removeElement(NetworkProxySettings.OVERRIDE);
        }
        cbNetworkProxy.setModel(mdl);
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings({"unchecked", "rawtypes"})
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        bgUsedDistribution = new javax.swing.ButtonGroup();
        pnlCategories = new javax.swing.JPanel();
        lblCategories = new javax.swing.JLabel();
        lstCategories = new javax.swing.JList<>();
        pnlCards = new javax.swing.JPanel();
        pnlExecution = new javax.swing.JPanel();
        javax.swing.JPanel jPanel1 = new javax.swing.JPanel();
        lblGradleUserHome = new javax.swing.JLabel();
        tfGradleUserHome = new javax.swing.JTextField();
        btGradleUserHome = new javax.swing.JButton();
        lblGradleDistribution = new javax.swing.JLabel();
        cbGradleVersion = new javax.swing.JComboBox<>();
        rbUseStandardGradle = new javax.swing.JRadioButton();
        rbUseCustomGradle = new javax.swing.JRadioButton();
        tfUseCustomGradle = new javax.swing.JTextField();
        btUseCustomGradle = new javax.swing.JButton();
        cbStartDaemonOnStart = new javax.swing.JCheckBox();
        cbPreferWrapper = new javax.swing.JCheckBox();
        lbVersionInfo = new javax.swing.JLabel();
        cbSilentInstall = new javax.swing.JCheckBox();
        btDefaultHome = new javax.swing.JButton();
        javax.swing.JPanel jPanel2 = new javax.swing.JPanel();
        cbOffline = new javax.swing.JCheckBox();
        cbSkipTest = new javax.swing.JCheckBox();
        cbSkipCheck = new javax.swing.JCheckBox();
        cbUseConfigCache = new javax.swing.JCheckBox();
        cbConfigureOnDemand = new javax.swing.JCheckBox();
        cbNoRebuild = new javax.swing.JCheckBox();
        lbAllowExecution = new javax.swing.JLabel();
        cbAllowExecution = new javax.swing.JComboBox<>();
        lbNetworkProxy = new javax.swing.JLabel();
        cbNetworkProxy = new javax.swing.JComboBox<>();
        pnlAppearance = new javax.swing.JPanel();
        javax.swing.JPanel jPanel4 = new javax.swing.JPanel();
        cbDisplayDescription = new javax.swing.JCheckBox();
        cbHideEmptyConfig = new javax.swing.JCheckBox();
        javax.swing.JPanel jPanel5 = new javax.swing.JPanel();
        cbAlwaysShowOutput = new javax.swing.JCheckBox();
        cbReuseOutputTabs = new javax.swing.JCheckBox();
        cbReuseEditorOnStackTrace = new javax.swing.JCheckBox();
        pnlDependencies = new javax.swing.JPanel();
        javax.swing.JPanel jPanel8 = new javax.swing.JPanel();
        cbDownloadJavadoc = new javax.swing.JComboBox<>();
        cbDownloadSources = new javax.swing.JComboBox<>();
        cbDownloadLibs = new javax.swing.JComboBox<>();
        lbDownloadLibs = new javax.swing.JLabel();
        lbDownloadSources = new javax.swing.JLabel();
        lbDownloadJavadoc = new javax.swing.JLabel();
        pnlMaven = new javax.swing.JPanel();
        javax.swing.JPanel jPanel3 = new javax.swing.JPanel();
        cbPreferMaven = new javax.swing.JCheckBox();
        pnlExperimental = new javax.swing.JPanel();
        javax.swing.JPanel jPanel7 = new javax.swing.JPanel();
        cbEnableCache = new javax.swing.JCheckBox();
        cbOpenLazy = new javax.swing.JCheckBox();
        cbBundledLoading = new javax.swing.JCheckBox();

        setPreferredSize(new java.awt.Dimension(723, 417));
        setLayout(new java.awt.BorderLayout());

        org.openide.awt.Mnemonics.setLocalizedText(lblCategories, org.openide.util.NbBundle.getMessage(SettingsPanel.class, "SettingsPanel.lblCategories.text")); // NOI18N

        lstCategories.setModel(new javax.swing.AbstractListModel<String>() {
            String[] strings = { "Execution", "Appearance", "Dependencies", "Maven", "Experimental" };
            public int getSize() { return strings.length; }
            public String getElementAt(int i) { return strings[i]; }
        });
        lstCategories.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        lstCategories.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
                lstCategoriesValueChanged(evt);
            }
        });

        javax.swing.GroupLayout pnlCategoriesLayout = new javax.swing.GroupLayout(pnlCategories);
        pnlCategories.setLayout(pnlCategoriesLayout);
        pnlCategoriesLayout.setHorizontalGroup(
            pnlCategoriesLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnlCategoriesLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(pnlCategoriesLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(lstCategories, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(lblCategories, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        pnlCategoriesLayout.setVerticalGroup(
            pnlCategoriesLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnlCategoriesLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(lblCategories)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(lstCategories, javax.swing.GroupLayout.DEFAULT_SIZE, 382, Short.MAX_VALUE)
                .addContainerGap())
        );

        add(pnlCategories, java.awt.BorderLayout.WEST);

        pnlCards.setPreferredSize(new java.awt.Dimension(800, 415));
        pnlCards.setLayout(new java.awt.CardLayout());

        pnlExecution.setPreferredSize(new java.awt.Dimension(800, 415));

        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder(org.openide.util.NbBundle.getMessage(SettingsPanel.class, "SettingsPanel.jPanel1.border.title"))); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(lblGradleUserHome, org.openide.util.NbBundle.getMessage(SettingsPanel.class, "SettingsPanel.lblGradleUserHome.text")); // NOI18N

        tfGradleUserHome.setEditable(false);

        org.openide.awt.Mnemonics.setLocalizedText(btGradleUserHome, org.openide.util.NbBundle.getMessage(SettingsPanel.class, "SettingsPanel.btGradleUserHome.text")); // NOI18N
        btGradleUserHome.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btGradleUserHomeActionPerformed(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(lblGradleDistribution, org.openide.util.NbBundle.getMessage(SettingsPanel.class, "SettingsPanel.lblGradleDistribution.text")); // NOI18N

        cbGradleVersion.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                cbGradleVersionItemStateChanged(evt);
            }
        });

        bgUsedDistribution.add(rbUseStandardGradle);
        org.openide.awt.Mnemonics.setLocalizedText(rbUseStandardGradle, org.openide.util.NbBundle.getMessage(SettingsPanel.class, "SettingsPanel.rbUseStandardGradle.text")); // NOI18N
        rbUseStandardGradle.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                rbUseStandardGradleStateChanged(evt);
            }
        });

        bgUsedDistribution.add(rbUseCustomGradle);
        org.openide.awt.Mnemonics.setLocalizedText(rbUseCustomGradle, org.openide.util.NbBundle.getMessage(SettingsPanel.class, "SettingsPanel.rbUseCustomGradle.text")); // NOI18N
        rbUseCustomGradle.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                rbUseCustomGradleStateChanged(evt);
            }
        });

        tfUseCustomGradle.setEditable(false);
        tfUseCustomGradle.setText(org.openide.util.NbBundle.getMessage(SettingsPanel.class, "SettingsPanel.tfUseCustomGradle.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(btUseCustomGradle, org.openide.util.NbBundle.getMessage(SettingsPanel.class, "SettingsPanel.btUseCustomGradle.text")); // NOI18N
        btUseCustomGradle.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btUseCustomGradleActionPerformed(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(cbStartDaemonOnStart, org.openide.util.NbBundle.getMessage(SettingsPanel.class, "SettingsPanel.cbStartDaemonOnStart.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(cbPreferWrapper, org.openide.util.NbBundle.getMessage(SettingsPanel.class, "SettingsPanel.cbPreferWrapper.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(lbVersionInfo, org.openide.util.NbBundle.getMessage(SettingsPanel.class, "SettingsPanel.lbVersionInfo.text")); // NOI18N
        lbVersionInfo.setEnabled(false);

        org.openide.awt.Mnemonics.setLocalizedText(cbSilentInstall, org.openide.util.NbBundle.getMessage(SettingsPanel.class, "SettingsPanel.cbSilentInstall.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(btDefaultHome, org.openide.util.NbBundle.getMessage(SettingsPanel.class, "SettingsPanel.btDefaultHome.text")); // NOI18N
        btDefaultHome.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btDefaultHomeActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addComponent(lblGradleDistribution)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(jPanel1Layout.createSequentialGroup()
                                .addComponent(rbUseStandardGradle)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(cbGradleVersion, 0, 107, Short.MAX_VALUE))
                            .addGroup(jPanel1Layout.createSequentialGroup()
                                .addComponent(rbUseCustomGradle)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(tfUseCustomGradle)))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(btUseCustomGradle, javax.swing.GroupLayout.DEFAULT_SIZE, 102, Short.MAX_VALUE))
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(cbSilentInstall)
                            .addComponent(cbStartDaemonOnStart)
                            .addComponent(cbPreferWrapper))
                        .addGap(0, 0, Short.MAX_VALUE))
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addComponent(lblGradleUserHome)
                        .addGap(9, 9, 9)
                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(jPanel1Layout.createSequentialGroup()
                                .addGap(6, 6, 6)
                                .addComponent(lbVersionInfo, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                            .addGroup(jPanel1Layout.createSequentialGroup()
                                .addComponent(tfGradleUserHome)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(btGradleUserHome, javax.swing.GroupLayout.PREFERRED_SIZE, 105, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(btDefaultHome, javax.swing.GroupLayout.PREFERRED_SIZE, 105, javax.swing.GroupLayout.PREFERRED_SIZE)))))
                .addGap(2, 2, 2))
        );

        jPanel1Layout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {btGradleUserHome, btUseCustomGradle});

        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(lblGradleUserHome)
                    .addComponent(tfGradleUserHome, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(btGradleUserHome)
                    .addComponent(btDefaultHome))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(lbVersionInfo, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(lblGradleDistribution)
                    .addComponent(cbGradleVersion, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(rbUseStandardGradle))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(rbUseCustomGradle)
                    .addComponent(tfUseCustomGradle, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(btUseCustomGradle))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(cbPreferWrapper)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(cbStartDaemonOnStart)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(cbSilentInstall))
        );

        jPanel2.setBorder(javax.swing.BorderFactory.createTitledBorder(org.openide.util.NbBundle.getMessage(SettingsPanel.class, "SettingsPanel.jPanel2.border.title"))); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(cbOffline, org.openide.util.NbBundle.getMessage(SettingsPanel.class, "SettingsPanel.cbOffline.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(cbSkipTest, org.openide.util.NbBundle.getMessage(SettingsPanel.class, "SettingsPanel.cbSkipTest.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(cbSkipCheck, org.openide.util.NbBundle.getMessage(SettingsPanel.class, "SettingsPanel.cbSkipCheck.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(cbUseConfigCache, org.openide.util.NbBundle.getMessage(SettingsPanel.class, "SettingsPanel.cbUseConfigCache.text")); // NOI18N
        cbUseConfigCache.setToolTipText(org.openide.util.NbBundle.getMessage(SettingsPanel.class, "SettingsPanel.cbUseConfigCache.toolTipText")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(cbConfigureOnDemand, org.openide.util.NbBundle.getMessage(SettingsPanel.class, "SettingsPanel.cbConfigureOnDemand.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(cbNoRebuild, org.openide.util.NbBundle.getMessage(SettingsPanel.class, "SettingsPanel.cbNoRebuild.text")); // NOI18N
        cbNoRebuild.setToolTipText(org.openide.util.NbBundle.getMessage(SettingsPanel.class, "SettingsPanel.cbNoRebuild.toolTipText")); // NOI18N

        lbAllowExecution.setHorizontalAlignment(javax.swing.SwingConstants.TRAILING);
        org.openide.awt.Mnemonics.setLocalizedText(lbAllowExecution, org.openide.util.NbBundle.getMessage(SettingsPanel.class, "SettingsPanel.lbAllowExecution.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(lbNetworkProxy, org.openide.util.NbBundle.getMessage(SettingsPanel.class, "SettingsPanel.lbNetworkProxy.text")); // NOI18N

        javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(cbOffline)
                            .addComponent(cbConfigureOnDemand)
                            .addComponent(cbNoRebuild, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(cbUseConfigCache)
                            .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                                .addComponent(cbSkipCheck, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                .addComponent(cbSkipTest, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))))
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                            .addComponent(lbAllowExecution, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(lbNetworkProxy, javax.swing.GroupLayout.PREFERRED_SIZE, 142, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                            .addComponent(cbNetworkProxy, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(cbAllowExecution, javax.swing.GroupLayout.PREFERRED_SIZE, 280, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addGap(0, 0, Short.MAX_VALUE)))
                .addContainerGap())
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(cbOffline)
                    .addComponent(cbSkipCheck))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(cbSkipTest)
                    .addComponent(cbNoRebuild, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(cbConfigureOnDemand)
                    .addComponent(cbUseConfigCache))
                .addGap(18, 18, 18)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(cbAllowExecution, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(lbAllowExecution))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(cbNetworkProxy, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(lbNetworkProxy))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        javax.swing.GroupLayout pnlExecutionLayout = new javax.swing.GroupLayout(pnlExecution);
        pnlExecution.setLayout(pnlExecutionLayout);
        pnlExecutionLayout.setHorizontalGroup(
            pnlExecutionLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, pnlExecutionLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(pnlExecutionLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jPanel2, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap())
        );
        pnlExecutionLayout.setVerticalGroup(
            pnlExecutionLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnlExecutionLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanel2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(14, Short.MAX_VALUE))
        );

        pnlCards.add(pnlExecution, "Execution");

        pnlAppearance.setPreferredSize(new java.awt.Dimension(800, 415));

        jPanel4.setBorder(javax.swing.BorderFactory.createTitledBorder(org.openide.util.NbBundle.getMessage(SettingsPanel.class, "SettingsPanel.jPanel4.border.title"))); // NOI18N

        cbDisplayDescription.setSelected(true);
        org.openide.awt.Mnemonics.setLocalizedText(cbDisplayDescription, org.openide.util.NbBundle.getMessage(SettingsPanel.class, "SettingsPanel.cbDisplayDescription.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(cbHideEmptyConfig, org.openide.util.NbBundle.getMessage(SettingsPanel.class, "SettingsPanel.cbHideEmptyConfig.text")); // NOI18N

        javax.swing.GroupLayout jPanel4Layout = new javax.swing.GroupLayout(jPanel4);
        jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(
            jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel4Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(cbDisplayDescription, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(cbHideEmptyConfig, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap())
        );
        jPanel4Layout.setVerticalGroup(
            jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel4Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(cbDisplayDescription)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(cbHideEmptyConfig)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jPanel5.setBorder(javax.swing.BorderFactory.createTitledBorder(org.openide.util.NbBundle.getMessage(SettingsPanel.class, "SettingsPanel.jPanel5.border.title"))); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(cbAlwaysShowOutput, org.openide.util.NbBundle.getMessage(SettingsPanel.class, "SettingsPanel.cbAlwaysShowOutput.text")); // NOI18N

        cbReuseOutputTabs.setSelected(true);
        org.openide.awt.Mnemonics.setLocalizedText(cbReuseOutputTabs, org.openide.util.NbBundle.getMessage(SettingsPanel.class, "SettingsPanel.cbReuseOutputTabs.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(cbReuseEditorOnStackTrace, org.openide.util.NbBundle.getMessage(SettingsPanel.class, "SettingsPanel.cbReuseEditorOnStackTrace.text")); // NOI18N

        javax.swing.GroupLayout jPanel5Layout = new javax.swing.GroupLayout(jPanel5);
        jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(
            jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel5Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(cbReuseEditorOnStackTrace, javax.swing.GroupLayout.DEFAULT_SIZE, 541, Short.MAX_VALUE)
                    .addComponent(cbReuseOutputTabs, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(cbAlwaysShowOutput, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap())
        );
        jPanel5Layout.setVerticalGroup(
            jPanel5Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel5Layout.createSequentialGroup()
                .addComponent(cbAlwaysShowOutput)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(cbReuseOutputTabs)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(cbReuseEditorOnStackTrace)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        javax.swing.GroupLayout pnlAppearanceLayout = new javax.swing.GroupLayout(pnlAppearance);
        pnlAppearance.setLayout(pnlAppearanceLayout);
        pnlAppearanceLayout.setHorizontalGroup(
            pnlAppearanceLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, pnlAppearanceLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(pnlAppearanceLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jPanel5, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jPanel4, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap())
        );
        pnlAppearanceLayout.setVerticalGroup(
            pnlAppearanceLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnlAppearanceLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jPanel4, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanel5, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(216, Short.MAX_VALUE))
        );

        pnlCards.add(pnlAppearance, "Appearance");

        pnlDependencies.setPreferredSize(new java.awt.Dimension(800, 415));

        jPanel8.setBorder(javax.swing.BorderFactory.createTitledBorder(org.openide.util.NbBundle.getMessage(SettingsPanel.class, "SettingsPanel.jPanel8.border.title"))); // NOI18N

        cbDownloadJavadoc.setToolTipText(org.openide.util.NbBundle.getMessage(SettingsPanel.class, "SettingsPanel.cbDownloadJavadoc.toolTipText")); // NOI18N
        cbDownloadJavadoc.setEnabled(false);

        cbDownloadSources.setToolTipText(org.openide.util.NbBundle.getMessage(SettingsPanel.class, "SettingsPanel.cbDownloadSources.toolTipText")); // NOI18N
        cbDownloadSources.setEnabled(false);

        lbDownloadLibs.setLabelFor(cbDownloadLibs);
        org.openide.awt.Mnemonics.setLocalizedText(lbDownloadLibs, org.openide.util.NbBundle.getMessage(SettingsPanel.class, "SettingsPanel.lbDownloadLibs.text")); // NOI18N

        lbDownloadSources.setLabelFor(cbDownloadSources);
        org.openide.awt.Mnemonics.setLocalizedText(lbDownloadSources, org.openide.util.NbBundle.getMessage(SettingsPanel.class, "SettingsPanel.lbDownloadSources.text")); // NOI18N

        lbDownloadJavadoc.setLabelFor(cbDownloadJavadoc);
        org.openide.awt.Mnemonics.setLocalizedText(lbDownloadJavadoc, org.openide.util.NbBundle.getMessage(SettingsPanel.class, "SettingsPanel.lbDownloadJavadoc.text")); // NOI18N

        javax.swing.GroupLayout jPanel8Layout = new javax.swing.GroupLayout(jPanel8);
        jPanel8.setLayout(jPanel8Layout);
        jPanel8Layout.setHorizontalGroup(
            jPanel8Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel8Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel8Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                    .addComponent(lbDownloadSources, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(lbDownloadJavadoc, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(lbDownloadLibs, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(jPanel8Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(cbDownloadSources, 0, 238, Short.MAX_VALUE)
                    .addComponent(cbDownloadLibs, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(cbDownloadJavadoc, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap())
        );
        jPanel8Layout.setVerticalGroup(
            jPanel8Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel8Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel8Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(lbDownloadLibs)
                    .addComponent(cbDownloadLibs, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel8Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(lbDownloadSources)
                    .addComponent(cbDownloadSources, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel8Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(lbDownloadJavadoc)
                    .addComponent(cbDownloadJavadoc, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        javax.swing.GroupLayout pnlDependenciesLayout = new javax.swing.GroupLayout(pnlDependencies);
        pnlDependencies.setLayout(pnlDependenciesLayout);
        pnlDependenciesLayout.setHorizontalGroup(
            pnlDependenciesLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnlDependenciesLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jPanel8, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addContainerGap())
        );
        pnlDependenciesLayout.setVerticalGroup(
            pnlDependenciesLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnlDependenciesLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jPanel8, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(294, Short.MAX_VALUE))
        );

        pnlCards.add(pnlDependencies, "Dependencies");

        jPanel3.setBorder(javax.swing.BorderFactory.createTitledBorder(org.openide.util.NbBundle.getMessage(SettingsPanel.class, "SettingsPanel.jPanel3.border.title"))); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(cbPreferMaven, org.openide.util.NbBundle.getMessage(SettingsPanel.class, "SettingsPanel.cbPreferMaven.text")); // NOI18N

        javax.swing.GroupLayout jPanel3Layout = new javax.swing.GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel3Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(cbPreferMaven)
                .addContainerGap(231, Short.MAX_VALUE))
        );
        jPanel3Layout.setVerticalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel3Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(cbPreferMaven)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        javax.swing.GroupLayout pnlMavenLayout = new javax.swing.GroupLayout(pnlMaven);
        pnlMaven.setLayout(pnlMavenLayout);
        pnlMavenLayout.setHorizontalGroup(
            pnlMavenLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, pnlMavenLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jPanel3, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addContainerGap())
        );
        pnlMavenLayout.setVerticalGroup(
            pnlMavenLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnlMavenLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jPanel3, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(354, Short.MAX_VALUE))
        );

        pnlCards.add(pnlMaven, "Maven");

        jPanel7.setBorder(javax.swing.BorderFactory.createTitledBorder(org.openide.util.NbBundle.getMessage(SettingsPanel.class, "SettingsPanel.jPanel7.border.title"))); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(cbEnableCache, org.openide.util.NbBundle.getMessage(SettingsPanel.class, "SettingsPanel.cbEnableCache.text")); // NOI18N
        cbEnableCache.setToolTipText(org.openide.util.NbBundle.getMessage(SettingsPanel.class, "SettingsPanel.cbEnableCache.toolTipText")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(cbOpenLazy, org.openide.util.NbBundle.getMessage(SettingsPanel.class, "SettingsPanel.cbOpenLazy.text")); // NOI18N
        cbOpenLazy.setToolTipText(org.openide.util.NbBundle.getMessage(SettingsPanel.class, "SettingsPanel.cbOpenLazy.toolTipText")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(cbBundledLoading, org.openide.util.NbBundle.getMessage(SettingsPanel.class, "SettingsPanel.cbBundledLoading.text")); // NOI18N
        cbBundledLoading.setToolTipText(org.openide.util.NbBundle.getMessage(SettingsPanel.class, "SettingsPanel.cbBundledLoading.toolTipText")); // NOI18N

        javax.swing.GroupLayout jPanel7Layout = new javax.swing.GroupLayout(jPanel7);
        jPanel7.setLayout(jPanel7Layout);
        jPanel7Layout.setHorizontalGroup(
            jPanel7Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel7Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel7Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(cbOpenLazy)
                    .addComponent(cbEnableCache)
                    .addComponent(cbBundledLoading))
                .addContainerGap(289, Short.MAX_VALUE))
        );
        jPanel7Layout.setVerticalGroup(
            jPanel7Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel7Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(cbEnableCache)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(cbOpenLazy)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(cbBundledLoading)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        javax.swing.GroupLayout pnlExperimentalLayout = new javax.swing.GroupLayout(pnlExperimental);
        pnlExperimental.setLayout(pnlExperimentalLayout);
        pnlExperimentalLayout.setHorizontalGroup(
            pnlExperimentalLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnlExperimentalLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jPanel7, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addContainerGap())
        );
        pnlExperimentalLayout.setVerticalGroup(
            pnlExperimentalLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnlExperimentalLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jPanel7, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(300, Short.MAX_VALUE))
        );

        pnlCards.add(pnlExperimental, "Experimental");

        add(pnlCards, java.awt.BorderLayout.CENTER);
    }// </editor-fold>//GEN-END:initComponents

    @Messages("TIT_CustomGradle=Select Gradle Distribution")
    private void btUseCustomGradleActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btUseCustomGradleActionPerformed
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle(Bundle.TIT_CustomGradle());
        chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        chooser.setFileHidingEnabled(false);
        String path = tfUseCustomGradle.getText();
        if (path == null || path.trim().length() == 0) {
            path = GradleSettings.getDefault().getGradleUserHome().getAbsolutePath();
        }
        if (path.length() > 0) {
            File f = new File(path);
            if (f.exists()) {
                chooser.setSelectedFile(f);
            }
        }
        if (JFileChooser.APPROVE_OPTION == chooser.showOpenDialog(this)) {
            File distDir = chooser.getSelectedFile();
            tfUseCustomGradle.setText(distDir.getAbsolutePath());
        }
    }//GEN-LAST:event_btUseCustomGradleActionPerformed

    private void lstCategoriesValueChanged(javax.swing.event.ListSelectionEvent evt) {//GEN-FIRST:event_lstCategoriesValueChanged
        int idx = lstCategories.getSelectedIndex();
        CardLayout cardLayout = (CardLayout) pnlCards.getLayout();
        if ((idx >= 0) && (idx < CARDS.length)) {
            cardLayout.show(pnlCards, CARDS[idx]);
        }
    }//GEN-LAST:event_lstCategoriesValueChanged

    @Messages("LBL_IncompatibleGradle=This version does not work with NetBeans!")
    private void cbGradleVersionItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_cbGradleVersionItemStateChanged
        if (evt.getItem() instanceof GradleDistribution) {
            GradleDistribution v = (GradleDistribution) evt.getItem();
            if ((v != null) && (evt.getStateChange() == ItemEvent.SELECTED)) {
                if (v.isBlackListed()) {
                    lbVersionInfo.setText(Bundle.LBL_IncompatibleGradle());
                } else {
                    lbVersionInfo.setText(null);
                }
            }
        }
    }//GEN-LAST:event_cbGradleVersionItemStateChanged

    private void rbUseStandardGradleStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_rbUseStandardGradleStateChanged
        boolean selected = rbUseStandardGradle.isSelected();
        cbGradleVersion.setEnabled(selected);
    }//GEN-LAST:event_rbUseStandardGradleStateChanged

    private void rbUseCustomGradleStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_rbUseCustomGradleStateChanged
        boolean selected = rbUseCustomGradle.isSelected();
        tfUseCustomGradle.setEnabled(selected);
        btUseCustomGradle.setEnabled(selected);
    }//GEN-LAST:event_rbUseCustomGradleStateChanged

    @Messages("TIT_GradleUserHome=Select Gradle User Home")
    private void btGradleUserHomeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btGradleUserHomeActionPerformed
        final GradleSettings settings = GradleSettings.getDefault();
        settings.getGradleUserHome();

        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle(Bundle.TIT_GradleUserHome());
        chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        chooser.setFileHidingEnabled(false);
        String path = tfGradleUserHome.getText();

        if (path.length() > 0) {
            File f = new File(path);
            if (f.exists()) {
                chooser.setSelectedFile(f);
            }
        }
        if (JFileChooser.APPROVE_OPTION == chooser.showOpenDialog(this)) {
            File home = chooser.getSelectedFile();
            tfGradleUserHome.setText(home.getAbsolutePath());
            gdm = GradleDistributionManager.get(home);
            cbGradleVersion.repaint();
        }
    }//GEN-LAST:event_btGradleUserHomeActionPerformed

    private void btDefaultHomeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btDefaultHomeActionPerformed
        tfGradleUserHome.setText(getDefaultGradleUserHome());
    }//GEN-LAST:event_btDefaultHomeActionPerformed

    public void setValues() {
        GradleSettings settings = GradleSettings.getDefault();
        GradleExperimentalSettings experimental = GradleExperimentalSettings.getDefault();

        tfGradleUserHome.setText(settings.getGradleUserHome().getAbsolutePath());

        tfUseCustomGradle.setText(settings.getDistributionHome());
        cbPreferWrapper.setSelected(settings.isWrapperPreferred());

        ButtonModel bm = settings.useCustomGradle()
                ? rbUseCustomGradle.getModel() : rbUseStandardGradle.getModel();
        bgUsedDistribution.setSelected(bm, true);

        cbStartDaemonOnStart.setSelected(settings.isStartDaemonOnStart());
        cbSilentInstall.setSelected(settings.isSilentInstall());

        cbOffline.setSelected(settings.isOffline());
        cbNoRebuild.setSelected(settings.getNoRebuild());
        cbConfigureOnDemand.setSelected(settings.isConfigureOnDemand());
        cbUseConfigCache.setSelected(settings.getUseConfigCache());

        cbSkipCheck.setSelected(settings.skipCheck());
        cbSkipTest.setSelected(settings.skipTest());

        cbHideEmptyConfig.setSelected(settings.isHideEmptyConfigurations());
        cbAlwaysShowOutput.setSelected(settings.isAlwaysShowOutput());
        cbReuseOutputTabs.setSelected(settings.isReuseOutputTabs());
        cbDisplayDescription.setSelected(settings.isDisplayDesctiption());
        cbReuseEditorOnStackTrace.setSelected(settings.isReuseEditorOnStackTace());

        cbEnableCache.setSelected(!experimental.isCacheDisabled());
        cbOpenLazy.setSelected(experimental.isOpenLazy());
        cbBundledLoading.setSelected(experimental.isBundledLoading());

        cbPreferMaven.setSelected(settings.isPreferMaven());

        cbDownloadLibs.setSelectedItem(settings.getDownloadLibs());
        cbDownloadSources.setSelectedItem(settings.getDownloadSources());
        cbDownloadJavadoc.setSelectedItem(settings.getDownloadJavadoc());

        cbAllowExecution.setSelectedItem(settings.getGradleExecutionRule());
        
        cbNetworkProxy.setSelectedItem(experimental.getNetworkProxy());

        new SwingWorker<List<GradleDistribution>, Void>() {

            @Override
            protected List<GradleDistribution> doInBackground() throws Exception {
                try {
                    return gdm.availableDistributions(true);
                } catch (IOException ex) {
                    return gdm.availableLocalDistributions();
                }
            }

            @Override
            protected void done() {
                GradleDistribution[] items = new GradleDistribution[0];
                try {
                    items = get().toArray(new GradleDistribution[0]);
                } catch (InterruptedException | ExecutionException ex) {
                    // Something happened, let's have the combo list box empty;
                }
                ComboBoxModel<GradleDistribution> model = new DefaultComboBoxModel<>(items);
                cbGradleVersion.setModel(model);
                model.setSelectedItem(gdm.distributionFromVersion(settings.getGradleVersion()));
            }

        }.execute();
    }

    @Messages({
        "TIT_RestartIDE=Restart IDE",
        "HINT_RestartIDE=Click here to restart IDE and apply new settings."
    })
    public void applyValues() {
        GradleSettings settings = GradleSettings.getDefault();
        GradleExperimentalSettings experimental = GradleExperimentalSettings.getDefault();

        if (getDefaultGradleUserHome().equals(tfGradleUserHome.getText())) {
            settings.setGradleUserHome(null);
        } else {
            settings.setGradleUserHome(new File(tfGradleUserHome.getText()));
        }
        GradleDistribution distVersion = (GradleDistribution) cbGradleVersion.getSelectedItem();
        if (distVersion != null) {
            settings.setGradleVersion(distVersion.getVersion());
        }
        settings.setDistributionHome(tfUseCustomGradle.getText());
        settings.setWrapperPreferred(cbPreferWrapper.isSelected());
        boolean useCustomGradle = bgUsedDistribution.getSelection() == rbUseCustomGradle.getModel();
        settings.setUseCustomGradle(useCustomGradle);

        settings.setStartDaemonOnStart(cbStartDaemonOnStart.isSelected());
        settings.setSilentInstall(cbSilentInstall.isSelected());

        settings.setOffline(cbOffline.isSelected());
        settings.setNoRebuild(cbNoRebuild.isSelected());
        settings.setConfigureOnDemand(cbConfigureOnDemand.isSelected());
        settings.setUseConfigCache(cbUseConfigCache.isSelected());
        settings.setSkipCheck(cbSkipCheck.isSelected());
        settings.setSkipTest(cbSkipTest.isSelected());
        settings.setHideEmptyConfigurations(cbHideEmptyConfig.isSelected());
        settings.setAlwaysShowOutput(cbAlwaysShowOutput.isSelected());
        settings.setReuseOutputTabs(cbReuseOutputTabs.isSelected());
        settings.setDisplayDescription(cbDisplayDescription.isSelected());
        settings.setReuseEditorOnStackTrace(cbReuseEditorOnStackTrace.isSelected());

        experimental.setCacheDisabled(!cbEnableCache.isSelected());
        experimental.setOpenLazy(cbOpenLazy.isSelected());
        experimental.setBundledLoading(cbBundledLoading.isSelected());

        settings.setDownloadLibs((GradleSettings.DownloadLibsRule) cbDownloadLibs.getSelectedItem());
        settings.setDownloadSources((GradleSettings.DownloadMiscRule) cbDownloadSources.getSelectedItem());
        settings.setDownloadJavadoc((GradleSettings.DownloadMiscRule) cbDownloadJavadoc.getSelectedItem());

        settings.setGradleExecutionRule((GradleSettings.GradleExecutionRule) cbAllowExecution.getSelectedItem());

        if (settings.isPreferMaven() != cbPreferMaven.isSelected()) {
            settings.setPreferMaven(cbPreferMaven.isSelected());
            NotificationDisplayer.getDefault().notify(Bundle.TIT_RestartIDE(),
                    ImageUtilities.loadImageIcon(RESTART_ICON, true),
                    Bundle.HINT_RestartIDE(), (ActionEvent e) -> {
                        LifecycleManager.getDefault().markForRestart();
                        LifecycleManager.getDefault().exit();
            });
        }
        
        experimental.setNetworkProxy((NetworkProxySettings)cbNetworkProxy.getSelectedItem());
    }

    public boolean hasChanges() {
        GradleSettings settings = GradleSettings.getDefault();
        GradleExperimentalSettings experimental = GradleExperimentalSettings.getDefault();
        boolean isChanged = !settings.getDistributionHome().equals(tfUseCustomGradle.getText());
        isChanged |= settings.isWrapperPreferred() != cbPreferWrapper.isSelected();
        isChanged |= !settings.getGradleVersion().equals(String.valueOf(cbGradleVersion.getSelectedItem()));

        boolean useCustomGradle = bgUsedDistribution.getSelection() == rbUseCustomGradle.getModel();
        isChanged |= settings.useCustomGradle() != useCustomGradle;

        isChanged |= settings.isStartDaemonOnStart() != cbStartDaemonOnStart.isSelected();
        isChanged |= settings.isSilentInstall() != cbSilentInstall.isSelected();

        isChanged |= settings.isOffline() != cbOffline.isSelected();
        isChanged |= settings.isConfigureOnDemand() != cbConfigureOnDemand.isSelected();
        isChanged |= settings.getUseConfigCache() != cbUseConfigCache.isSelected();
        isChanged |= settings.skipCheck() != cbSkipCheck.isSelected();
        isChanged |= settings.skipTest() != cbSkipTest.isSelected();

        isChanged |= settings.isDisplayDesctiption() != cbDisplayDescription.isSelected();
        isChanged |= settings.isHideEmptyConfigurations() != cbHideEmptyConfig.isSelected();

        isChanged |= settings.isAlwaysShowOutput() != cbAlwaysShowOutput.isSelected();
        isChanged |= settings.isReuseOutputTabs() != cbReuseOutputTabs.isSelected();
        isChanged |= settings.isReuseEditorOnStackTace() != cbReuseEditorOnStackTrace.isSelected();

        isChanged |= experimental.isCacheDisabled() == cbEnableCache.isSelected();
        isChanged |= experimental.isOpenLazy() != cbOpenLazy.isSelected();
        isChanged |= experimental.isBundledLoading() != cbBundledLoading.isSelected();

        isChanged |= settings.isPreferMaven() != cbPreferMaven.isSelected();

        isChanged |= settings.getDownloadLibs() != cbDownloadLibs.getSelectedItem();
        isChanged |= settings.getDownloadSources() != cbDownloadSources.getSelectedItem();
        isChanged |= settings.getDownloadJavadoc() != cbDownloadJavadoc.getSelectedItem();

        isChanged |= settings.getGradleExecutionRule() != cbAllowExecution.getSelectedItem();
        
        isChanged |= experimental.getNetworkProxy() != cbNetworkProxy.getSelectedItem();

        return isChanged;
    }

    private class VersionCellRenderer extends DefaultListCellRenderer {
        final Color blackListColor = UIManager.getColor("nb.errorForeground");         //NOI18N
        final Color unavailableColor = UIManager.getColor("Label.disabledForeground"); //NOI18N
        @SuppressWarnings("rawtypes")
        final ListCellRenderer delegate;
        @SuppressWarnings("rawtypes")
        public VersionCellRenderer(ListCellRenderer delegate) {
            this.delegate = delegate;
        }

        @Override
        @NbBundle.Messages (value = {
            "NbGradleVersion.autoInstall_TXT=<html>This version is not available on this system<br/>It is going to be installed automatically.",
            "NbGradleVersion.blacklist_TXT=<html>This version is known to have issues with NetBeans, hence usage is not recommended."
        })
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            @SuppressWarnings("unchecked")
            Component cmp = delegate.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (cmp instanceof JLabel) {
                JLabel label = (JLabel) cmp;
                label.setHorizontalAlignment(RIGHT);
                if (value instanceof GradleDistribution) {
                    GradleDistribution dist = (GradleDistribution) value;
                    label.setText(dist.getVersion());
                    if (!dist.isAvailable()) {
                        label.setToolTipText(Bundle.NbGradleVersion_autoInstall_TXT());
                        label.setForeground(unavailableColor);
                    }
                    if (dist.isBlackListed()) {
                        label.setToolTipText(Bundle.NbGradleVersion_blacklist_TXT());
                        label.setForeground(blackListColor);
                    }
                }
            }
            return cmp;
        }

    }

    private static String getDefaultGradleUserHome() {
        String dir = System.getenv("GRADLE_USER_HOME"); //NOI18N
        return dir != null ? dir : new File(System.getProperty("user.home"), ".gradle").getAbsolutePath(); //NOI18N
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup bgUsedDistribution;
    private javax.swing.JButton btDefaultHome;
    private javax.swing.JButton btGradleUserHome;
    private javax.swing.JButton btUseCustomGradle;
    private javax.swing.JComboBox<GradleSettings.GradleExecutionRule> cbAllowExecution;
    private javax.swing.JCheckBox cbAlwaysShowOutput;
    private javax.swing.JCheckBox cbBundledLoading;
    private javax.swing.JCheckBox cbConfigureOnDemand;
    private javax.swing.JCheckBox cbDisplayDescription;
    private javax.swing.JComboBox<GradleSettings.DownloadMiscRule> cbDownloadJavadoc;
    private javax.swing.JComboBox<GradleSettings.DownloadLibsRule> cbDownloadLibs;
    private javax.swing.JComboBox<GradleSettings.DownloadMiscRule> cbDownloadSources;
    private javax.swing.JCheckBox cbEnableCache;
    private javax.swing.JComboBox<GradleDistribution> cbGradleVersion;
    private javax.swing.JCheckBox cbHideEmptyConfig;
    private javax.swing.JComboBox<NetworkProxySettings> cbNetworkProxy;
    private javax.swing.JCheckBox cbNoRebuild;
    private javax.swing.JCheckBox cbOffline;
    private javax.swing.JCheckBox cbOpenLazy;
    private javax.swing.JCheckBox cbPreferMaven;
    private javax.swing.JCheckBox cbPreferWrapper;
    private javax.swing.JCheckBox cbReuseEditorOnStackTrace;
    private javax.swing.JCheckBox cbReuseOutputTabs;
    private javax.swing.JCheckBox cbSilentInstall;
    private javax.swing.JCheckBox cbSkipCheck;
    private javax.swing.JCheckBox cbSkipTest;
    private javax.swing.JCheckBox cbStartDaemonOnStart;
    private javax.swing.JCheckBox cbUseConfigCache;
    private javax.swing.JLabel lbAllowExecution;
    private javax.swing.JLabel lbDownloadJavadoc;
    private javax.swing.JLabel lbDownloadLibs;
    private javax.swing.JLabel lbDownloadSources;
    private javax.swing.JLabel lbNetworkProxy;
    private javax.swing.JLabel lbVersionInfo;
    private javax.swing.JLabel lblCategories;
    private javax.swing.JLabel lblGradleDistribution;
    private javax.swing.JLabel lblGradleUserHome;
    private javax.swing.JList<String> lstCategories;
    private javax.swing.JPanel pnlAppearance;
    private javax.swing.JPanel pnlCards;
    private javax.swing.JPanel pnlCategories;
    private javax.swing.JPanel pnlDependencies;
    private javax.swing.JPanel pnlExecution;
    private javax.swing.JPanel pnlExperimental;
    private javax.swing.JPanel pnlMaven;
    private javax.swing.JRadioButton rbUseCustomGradle;
    private javax.swing.JRadioButton rbUseStandardGradle;
    private javax.swing.JTextField tfGradleUserHome;
    private javax.swing.JTextField tfUseCustomGradle;
    // End of variables declaration//GEN-END:variables
}
