/*
  libnzb

  Copyright (C) 2004 Mattias Nordstrom <matta at ftlight net>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


  Authors:
    Mattias Nordstrom <matta at ftlight net>

  $Id: yenc.h,v 1.3 2004/08/28 13:50:05 mnordstr Exp $
    This file provides the yenc decoding function headers.

*/

#ifndef YENC_H
#define YENC_H

#include <iostream>

#define YRES_OK			0	// Ok
#define YRES_ERRSIZE		1	// Part size mismatch
#define YRES_ERRTOTSIZE		2	// Total filesize mismatch
#define YRES_ERRPCRC32		3	// Part CRC32 error
#define YRES_ERROR		4	// General/Unknown error
#define YRES_ERRPART		5	// Part number mismatch

using namespace std;

struct ydata {
	int status;
	string filename;
	unsigned int part;
	unsigned long size;
	unsigned int total;
	unsigned long total_size;
	string crc32;
	unsigned long block_begin;
	unsigned long block_end;
	string data;
};

extern "C" ydata ydecode(string data);
bool crc32_check(int crc32, string c_crc, string data);

#endif
