# Copyright 2014 Canonical Ltd.  This software is licensed under the
# GNU Affero General Public License version 3 (see the file LICENSE).

"""Factory helpers for testing."""

from __future__ import (
    absolute_import,
    print_function,
    unicode_literals,
    )

str = None

__metaclass__ = type
__all__ = [
    'make_file',
    ]

from fixtures import TempDir
import os.path


def make_file(testcase, name=None, content=None):
    """Write a file.  Attach cleanup to `testcase`."""
    if content is None:
        content = testcase.getUniqueString()
    testcase.assertIsInstance(content, bytes)
    if name is None:
        name = testcase.getUniqueString()
    path = os.path.join(testcase.useFixture(TempDir()).path, name)
    with open(path, 'wb') as f:
        f.write(content)
    return path
