# Copyright (C) 2005-2010 Canonical Ltd
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

"""Minimal Test

This is a basic test to verify that mago-ng is working as expected and can
be run with various testing framework

To run it with:
$ mago-ng <path_to_this_file>

You can code ldtp directly in there or an external module
The only mandatory element is 'launcher' (and window_name for now)

set setupOnce to False to launch/close the app for each test

The purpose of this example is to test the management of the about
dialog
"""

from mago import TestCase
import unittest
import ldtp

class TestAbout(TestCase):
    """Test the about dialog
    """
    launcher = 'gucharmap'
    window_name = 'frmCharacterMap'

    def test_openclose(self):
        """Test opening and closing of the about dialog

        This test:
            - opens the about dialog
            - check the return code
            - check it the dialog is there
            - closes it
            - check the return code
            - check it the dialog vanished
        """
        # Open the about
        rc = self.application.about_open()
        self.assertTrue(rc)
        dlgAboutName = self.application.dlgAboutName
        self.assertIsNotNone(dlgAboutName,
                             "Name of the about dialog was not found")
        self.assertTrue(ldtp.guiexist(dlgAboutName))

        # Then close it
        rc = self.application.about_close()
        self.assertTrue(rc)
        self.assertFalse(ldtp.guiexist(dlgAboutName))


if __name__ == "__main__":
    unittest.main()
