/* Generated by GOB (v2.0.15)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 15

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "mn-mailboxes.h"

#include "mn-mailboxes-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 24 "src/mn-mailboxes.gob"

#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <stdarg.h>
#include <errno.h>
#include <glib/gi18n.h>
#include <libxml/parser.h>
#include <libxml/tree.h>
#include "mn-conf.h"
#include "mn-message.h"
#include "mn-mailbox-private.h"
#include "mn-test-mailbox.h"
#include "mn-shell.h"
#include "mn-util.h"

#line 44 "mn-mailboxes.c"
/* self casting macros */
#define SELF(x) MN_MAILBOXES(x)
#define SELF_CONST(x) MN_MAILBOXES_CONST(x)
#define IS_SELF(x) MN_IS_MAILBOXES(x)
#define TYPE_SELF MN_TYPE_MAILBOXES
#define SELF_CLASS(x) MN_MAILBOXES_CLASS(x)

#define SELF_GET_CLASS(x) MN_MAILBOXES_GET_CLASS(x)

/* self typedefs */
typedef MNMailboxes Self;
typedef MNMailboxesClass SelfClass;

/* here are local prototypes */
static void ___object_get_property (GObject *object, guint property_id, GValue *value, GParamSpec *pspec);
#line 0 "src/mn-mailboxes.gob"
static void mn_mailboxes_class_init (MNMailboxesClass * c);
#line 62 "mn-mailboxes.c"
static void ___real_mn_mailboxes_mailbox_added (MNMailboxes * self, MNMailbox * mailbox);
#line 70 "src/mn-mailboxes.gob"
static void mn_mailboxes_mailbox_added (MNMailboxes * self, MNMailbox * mailbox);
#line 66 "mn-mailboxes.c"
static void ___real_mn_mailboxes_mailbox_removed (MNMailboxes * self, MNMailbox * mailbox);
#line 87 "src/mn-mailboxes.gob"
static void mn_mailboxes_mailbox_removed (MNMailboxes * self, MNMailbox * mailbox);
#line 70 "mn-mailboxes.c"
#line 101 "src/mn-mailboxes.gob"
static void mn_mailboxes_mailbox_notify (MNMailboxes * self, MNMailbox * mailbox, GParamSpec * pspec) G_GNUC_UNUSED;
#line 73 "mn-mailboxes.c"
static void ___real_mn_mailboxes_list_changed (MNMailboxes * self);
#line 114 "src/mn-mailboxes.gob"
static void mn_mailboxes_list_changed (MNMailboxes * self);
#line 77 "mn-mailboxes.c"
static void ___real_mn_mailboxes_messages_changed (MNMailboxes * self, gboolean has_new);
#line 135 "src/mn-mailboxes.gob"
static void mn_mailboxes_messages_changed (MNMailboxes * self, gboolean has_new);
#line 81 "mn-mailboxes.c"
#line 155 "src/mn-mailboxes.gob"
static void mn_mailboxes_messages_changed_cb (const char * id, MNMessage * message, Self * self);
#line 84 "mn-mailboxes.c"
#line 164 "src/mn-mailboxes.gob"
static int mn_mailboxes_messages_sort_cb (MNMessage ** a, MNMessage ** b);
#line 87 "mn-mailboxes.c"
#line 180 "src/mn-mailboxes.gob"
static void mn_mailboxes_error_changed (MNMailboxes * self);
#line 90 "mn-mailboxes.c"
#line 203 "src/mn-mailboxes.gob"
static void mn_mailboxes_init (MNMailboxes * self);
#line 93 "mn-mailboxes.c"
#line 258 "src/mn-mailboxes.gob"
static void mn_mailboxes_finalize (MNMailboxes * self);
#line 96 "mn-mailboxes.c"
#line 276 "src/mn-mailboxes.gob"
static void mn_mailboxes_connect_mailbox_signals (MNMailboxes * self, MNMailbox * mailbox);
#line 99 "mn-mailboxes.c"
#line 287 "src/mn-mailboxes.gob"
static void mn_mailboxes_disconnect_mailbox_signals (MNMailboxes * self, MNMailbox * mailbox);
#line 102 "mn-mailboxes.c"
#line 298 "src/mn-mailboxes.gob"
static void mn_mailboxes_load (MNMailboxes * self);
#line 105 "mn-mailboxes.c"
#line 314 "src/mn-mailboxes.gob"
static void mn_mailboxes_add_error (GString ** errors, int * n_errors, const char * format, ...) G_GNUC_PRINTF(3, 4);
#line 108 "mn-mailboxes.c"
#line 334 "src/mn-mailboxes.gob"
static gboolean mn_mailboxes_load_real (MNMailboxes * self, GError ** err);
#line 111 "mn-mailboxes.c"
#line 419 "src/mn-mailboxes.gob"
static void mn_mailboxes_save (MNMailboxes * self);
#line 114 "mn-mailboxes.c"
#line 431 "src/mn-mailboxes.gob"
static gboolean mn_mailboxes_save_real (MNMailboxes * self, GError ** err);
#line 117 "mn-mailboxes.c"
#line 545 "src/mn-mailboxes.gob"
static void mn_mailboxes_mailbox_messages_changed_h (MNMailbox * mailbox, gboolean has_new, gpointer user_data);
#line 120 "mn-mailboxes.c"
#line 561 "src/mn-mailboxes.gob"
static void mn_mailboxes_mailbox_notify_h (GObject * object, GParamSpec * pspec, gpointer user_data);
#line 123 "mn-mailboxes.c"
#line 572 "src/mn-mailboxes.gob"
static void mn_mailboxes_mailbox_notify_error_h (GObject * object, GParamSpec * pspec, gpointer user_data);
#line 126 "mn-mailboxes.c"
#line 586 "src/mn-mailboxes.gob"
static void mn_mailboxes_mailbox_notify_manually_checkable_h (GObject * object, GParamSpec * pspec, gpointer user_data);
#line 129 "mn-mailboxes.c"
#line 611 "src/mn-mailboxes.gob"
static void mn_mailboxes_add_real (MNMailboxes * self, MNMailbox * mailbox);
#line 132 "mn-mailboxes.c"
#line 639 "src/mn-mailboxes.gob"
static void mn_mailboxes_remove_real (MNMailboxes * self, MNMailbox * mailbox);
#line 135 "mn-mailboxes.c"
#line 666 "src/mn-mailboxes.gob"
static gboolean mn_mailboxes_queue_idle_cb (gpointer data);
#line 138 "mn-mailboxes.c"

/*
 * Signal connection wrapper macro shortcuts
 */
#define self_connect__mailbox_added(object,func,data)	mn_mailboxes_connect__mailbox_added((object),(func),(data))
#define self_connect_after__mailbox_added(object,func,data)	mn_mailboxes_connect_after__mailbox_added((object),(func),(data))
#define self_connect_data__mailbox_added(object,func,data,destroy_data,flags)	mn_mailboxes_connect_data__mailbox_added((object),(func),(data),(destroy_data),(flags))
#define self_connect__mailbox_removed(object,func,data)	mn_mailboxes_connect__mailbox_removed((object),(func),(data))
#define self_connect_after__mailbox_removed(object,func,data)	mn_mailboxes_connect_after__mailbox_removed((object),(func),(data))
#define self_connect_data__mailbox_removed(object,func,data,destroy_data,flags)	mn_mailboxes_connect_data__mailbox_removed((object),(func),(data),(destroy_data),(flags))
#define self_connect__mailbox_notify(object,func,data)	mn_mailboxes_connect__mailbox_notify((object),(func),(data))
#define self_connect_after__mailbox_notify(object,func,data)	mn_mailboxes_connect_after__mailbox_notify((object),(func),(data))
#define self_connect_data__mailbox_notify(object,func,data,destroy_data,flags)	mn_mailboxes_connect_data__mailbox_notify((object),(func),(data),(destroy_data),(flags))
#define self_connect__list_changed(object,func,data)	mn_mailboxes_connect__list_changed((object),(func),(data))
#define self_connect_after__list_changed(object,func,data)	mn_mailboxes_connect_after__list_changed((object),(func),(data))
#define self_connect_data__list_changed(object,func,data,destroy_data,flags)	mn_mailboxes_connect_data__list_changed((object),(func),(data),(destroy_data),(flags))
#define self_connect__messages_changed(object,func,data)	mn_mailboxes_connect__messages_changed((object),(func),(data))
#define self_connect_after__messages_changed(object,func,data)	mn_mailboxes_connect_after__messages_changed((object),(func),(data))
#define self_connect_data__messages_changed(object,func,data,destroy_data,flags)	mn_mailboxes_connect_data__messages_changed((object),(func),(data),(destroy_data),(flags))
#define self_connect__error_changed(object,func,data)	mn_mailboxes_connect__error_changed((object),(func),(data))
#define self_connect_after__error_changed(object,func,data)	mn_mailboxes_connect_after__error_changed((object),(func),(data))
#define self_connect_data__error_changed(object,func,data,destroy_data,flags)	mn_mailboxes_connect_data__error_changed((object),(func),(data),(destroy_data),(flags))

typedef void  (*___Sig1) (MNMailboxes *, GObject *, gpointer);

static void
___marshal_Sig1 (GClosure *closure,
	GValue *return_value G_GNUC_UNUSED,
	guint n_param_values,
	const GValue *param_values,
	gpointer invocation_hint G_GNUC_UNUSED,
	gpointer marshal_data)
{
	register ___Sig1 callback;
	register GCClosure *cc = (GCClosure*) closure;
	register gpointer data1, data2;

	g_return_if_fail (n_param_values == 2);

	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = g_value_peek_pointer (param_values + 0);
	} else {
		data1 = g_value_peek_pointer (param_values + 0);
		data2 = closure->data;
	}

	callback = (___Sig1) (marshal_data != NULL ? marshal_data : cc->callback);

	callback ((MNMailboxes *)data1,
		(GObject *) g_value_get_object (param_values + 1),
		data2);
}


typedef void  (*___Sig2) (MNMailboxes *, GObject *, gpointer , gpointer);

static void
___marshal_Sig2 (GClosure *closure,
	GValue *return_value G_GNUC_UNUSED,
	guint n_param_values,
	const GValue *param_values,
	gpointer invocation_hint G_GNUC_UNUSED,
	gpointer marshal_data)
{
	register ___Sig2 callback;
	register GCClosure *cc = (GCClosure*) closure;
	register gpointer data1, data2;

	g_return_if_fail (n_param_values == 3);

	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = g_value_peek_pointer (param_values + 0);
	} else {
		data1 = g_value_peek_pointer (param_values + 0);
		data2 = closure->data;
	}

	callback = (___Sig2) (marshal_data != NULL ? marshal_data : cc->callback);

	callback ((MNMailboxes *)data1,
		(GObject *) g_value_get_object (param_values + 1),
		(gpointer ) g_value_get_pointer (param_values + 2),
		data2);
}


typedef void  (*___Sig3) (MNMailboxes *, gboolean , gpointer);

static void
___marshal_Sig3 (GClosure *closure,
	GValue *return_value G_GNUC_UNUSED,
	guint n_param_values,
	const GValue *param_values,
	gpointer invocation_hint G_GNUC_UNUSED,
	gpointer marshal_data)
{
	register ___Sig3 callback;
	register GCClosure *cc = (GCClosure*) closure;
	register gpointer data1, data2;

	g_return_if_fail (n_param_values == 2);

	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = g_value_peek_pointer (param_values + 0);
	} else {
		data1 = g_value_peek_pointer (param_values + 0);
		data2 = closure->data;
	}

	callback = (___Sig3) (marshal_data != NULL ? marshal_data : cc->callback);

	callback ((MNMailboxes *)data1,
		(gboolean ) g_value_get_boolean (param_values + 1),
		data2);
}


enum {
	MAILBOX_ADDED_SIGNAL,
	MAILBOX_REMOVED_SIGNAL,
	MAILBOX_NOTIFY_SIGNAL,
	LIST_CHANGED_SIGNAL,
	MESSAGES_CHANGED_SIGNAL,
	ERROR_CHANGED_SIGNAL,
	LAST_SIGNAL
};

enum {
	PROP_0,
	PROP_MANUALLY_CHECKABLE
};

static guint object_signals[LAST_SIGNAL] = {0};

/* pointer to the class of our parent */
static GObjectClass *parent_class = NULL;

/* Short form macros */
#define self_mailbox_added mn_mailboxes_mailbox_added
#define self_mailbox_removed mn_mailboxes_mailbox_removed
#define self_mailbox_notify mn_mailboxes_mailbox_notify
#define self_list_changed mn_mailboxes_list_changed
#define self_messages_changed mn_mailboxes_messages_changed
#define self_messages_changed_cb mn_mailboxes_messages_changed_cb
#define self_messages_sort_cb mn_mailboxes_messages_sort_cb
#define self_error_changed mn_mailboxes_error_changed
#define self_get_manually_checkable mn_mailboxes_get_manually_checkable
#define self_connect_mailbox_signals mn_mailboxes_connect_mailbox_signals
#define self_disconnect_mailbox_signals mn_mailboxes_disconnect_mailbox_signals
#define self_load mn_mailboxes_load
#define self_add_error mn_mailboxes_add_error
#define self_load_real mn_mailboxes_load_real
#define self_save mn_mailboxes_save
#define self_save_real mn_mailboxes_save_real
#define self_mailbox_messages_changed_h mn_mailboxes_mailbox_messages_changed_h
#define self_mailbox_notify_h mn_mailboxes_mailbox_notify_h
#define self_mailbox_notify_error_h mn_mailboxes_mailbox_notify_error_h
#define self_mailbox_notify_manually_checkable_h mn_mailboxes_mailbox_notify_manually_checkable_h
#define self_check mn_mailboxes_check
#define self_add_real mn_mailboxes_add_real
#define self_add mn_mailboxes_add
#define self_queue_add mn_mailboxes_queue_add
#define self_remove_real mn_mailboxes_remove_real
#define self_remove mn_mailboxes_remove
#define self_queue_remove mn_mailboxes_queue_remove
#define self_queue_idle_cb mn_mailboxes_queue_idle_cb
#define self_compare_by_name_func mn_mailboxes_compare_by_name_func
#define self_new mn_mailboxes_new
GType
mn_mailboxes_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (MNMailboxesClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) mn_mailboxes_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (MNMailboxes),
			0 /* n_preallocs */,
			(GInstanceInitFunc) mn_mailboxes_init,
			NULL
		};

		type = g_type_register_static (G_TYPE_OBJECT, "MNMailboxes", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((MNMailboxes *)g_object_new(mn_mailboxes_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static MNMailboxes * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static MNMailboxes *
GET_NEW_VARG (const char *first, ...)
{
	MNMailboxes *ret;
	va_list ap;
	va_start (ap, first);
	ret = (MNMailboxes *)g_object_new_valist (mn_mailboxes_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "MN:Mailboxes::finalize"
	MNMailboxes *self G_GNUC_UNUSED = MN_MAILBOXES (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
#line 258 "src/mn-mailboxes.gob"
	mn_mailboxes_finalize (self);
#line 361 "mn-mailboxes.c"
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
#line 47 "src/mn-mailboxes.gob"
	if(self->messages) { mn_g_object_ptr_array_free ((gpointer) self->messages); self->messages = NULL; }
#line 366 "mn-mailboxes.c"
#line 50 "src/mn-mailboxes.gob"
	if(self->messages_hash_table) { g_hash_table_destroy ((gpointer) self->messages_hash_table); self->messages_hash_table = NULL; }
#line 369 "mn-mailboxes.c"
#line 52 "src/mn-mailboxes.gob"
	if(self->_priv->add_queue) { mn_g_object_slist_free ((gpointer) self->_priv->add_queue); self->_priv->add_queue = NULL; }
#line 372 "mn-mailboxes.c"
#line 53 "src/mn-mailboxes.gob"
	if(self->_priv->remove_queue) { mn_g_object_slist_free ((gpointer) self->_priv->remove_queue); self->_priv->remove_queue = NULL; }
#line 375 "mn-mailboxes.c"
}
#undef __GOB_FUNCTION__

static void 
mn_mailboxes_class_init (MNMailboxesClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "MN:Mailboxes::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) c;

	g_type_class_add_private(c,sizeof(MNMailboxesPrivate));

	parent_class = g_type_class_ref (G_TYPE_OBJECT);

	object_signals[MAILBOX_ADDED_SIGNAL] =
		g_signal_new ("mailbox_added",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_FIRST),
			G_STRUCT_OFFSET (MNMailboxesClass, mailbox_added),
			NULL, NULL,
			___marshal_Sig1,
			G_TYPE_NONE, 1,
			G_TYPE_OBJECT);
	if ___GOB_UNLIKELY(sizeof(MNMailbox * ) != sizeof(GObject *) || parent_class == NULL /* avoid warning */) {
		g_error("src/mn-mailboxes.gob line 70: Type mismatch of \"mailbox_added\" signal signature");
	}
	object_signals[MAILBOX_REMOVED_SIGNAL] =
		g_signal_new ("mailbox_removed",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_FIRST),
			G_STRUCT_OFFSET (MNMailboxesClass, mailbox_removed),
			NULL, NULL,
			___marshal_Sig1,
			G_TYPE_NONE, 1,
			G_TYPE_OBJECT);
	if ___GOB_UNLIKELY(sizeof(MNMailbox * ) != sizeof(GObject *) || parent_class == NULL /* avoid warning */) {
		g_error("src/mn-mailboxes.gob line 87: Type mismatch of \"mailbox_removed\" signal signature");
	}
	object_signals[MAILBOX_NOTIFY_SIGNAL] =
		g_signal_new ("mailbox_notify",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_LAST | G_SIGNAL_DETAILED),
			G_STRUCT_OFFSET (MNMailboxesClass, mailbox_notify),
			NULL, NULL,
			___marshal_Sig2,
			G_TYPE_NONE, 2,
			G_TYPE_OBJECT,
			G_TYPE_POINTER);
	if ___GOB_UNLIKELY(sizeof(MNMailbox * ) != sizeof(GObject *) || sizeof(GParamSpec * ) != sizeof(gpointer ) || parent_class == NULL /* avoid warning */) {
		g_error("src/mn-mailboxes.gob line 101: Type mismatch of \"mailbox_notify\" signal signature");
	}
	object_signals[LIST_CHANGED_SIGNAL] =
		g_signal_new ("list_changed",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_FIRST),
			G_STRUCT_OFFSET (MNMailboxesClass, list_changed),
			NULL, NULL,
			g_cclosure_marshal_VOID__VOID,
			G_TYPE_NONE, 0);
	object_signals[MESSAGES_CHANGED_SIGNAL] =
		g_signal_new ("messages_changed",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_FIRST),
			G_STRUCT_OFFSET (MNMailboxesClass, messages_changed),
			NULL, NULL,
			___marshal_Sig3,
			G_TYPE_NONE, 1,
			G_TYPE_BOOLEAN);
	if ___GOB_UNLIKELY(sizeof(gboolean ) != sizeof(gboolean ) || parent_class == NULL /* avoid warning */) {
		g_error("src/mn-mailboxes.gob line 135: Type mismatch of \"messages_changed\" signal signature");
	}
	object_signals[ERROR_CHANGED_SIGNAL] =
		g_signal_new ("error_changed",
			G_TYPE_FROM_CLASS (g_object_class),
			(GSignalFlags)(G_SIGNAL_RUN_LAST),
			G_STRUCT_OFFSET (MNMailboxesClass, error_changed),
			NULL, NULL,
			g_cclosure_marshal_VOID__VOID,
			G_TYPE_NONE, 0);

#line 70 "src/mn-mailboxes.gob"
	c->mailbox_added = ___real_mn_mailboxes_mailbox_added;
#line 87 "src/mn-mailboxes.gob"
	c->mailbox_removed = ___real_mn_mailboxes_mailbox_removed;
#line 459 "mn-mailboxes.c"
	c->mailbox_notify = NULL;
#line 114 "src/mn-mailboxes.gob"
	c->list_changed = ___real_mn_mailboxes_list_changed;
#line 135 "src/mn-mailboxes.gob"
	c->messages_changed = ___real_mn_mailboxes_messages_changed;
#line 465 "mn-mailboxes.c"
	c->error_changed = NULL;
	g_object_class->finalize = ___finalize;
	g_object_class->get_property = ___object_get_property;
    {
	GParamSpec   *param_spec;

	param_spec = g_param_spec_boolean
		("manually_checkable" /* name */,
		 NULL /* nick */,
		 NULL /* blurb */,
		 FALSE /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE));
	g_object_class_install_property (g_object_class,
		PROP_MANUALLY_CHECKABLE,
		param_spec);
    }
}
#undef __GOB_FUNCTION__
#line 203 "src/mn-mailboxes.gob"
static void 
mn_mailboxes_init (MNMailboxes * self G_GNUC_UNUSED)
{
#line 488 "mn-mailboxes.c"
#define __GOB_FUNCTION__ "MN:Mailboxes::init"
	self->_priv = G_TYPE_INSTANCE_GET_PRIVATE(self,MN_TYPE_MAILBOXES,MNMailboxesPrivate);
#line 47 "src/mn-mailboxes.gob"
	self->messages = g_ptr_array_new();
#line 493 "mn-mailboxes.c"
#line 50 "src/mn-mailboxes.gob"
	self->messages_hash_table = g_hash_table_new(g_str_hash, g_str_equal);
#line 496 "mn-mailboxes.c"
 {
#line 204 "src/mn-mailboxes.gob"

    char *filename;
    gboolean exists;

    mn_shell->mailboxes = self;

    filename = g_build_filename(mn_conf_dot_dir, "mailboxes.xml", NULL);
    exists = g_file_test(filename, G_FILE_TEST_EXISTS);
    g_free(filename);

    if (exists)
      self_load(self);
    else if (mn_conf_is_set(MN_CONF_OBSOLETE_MAILBOXES))
      {
	GSList *gconf_mailboxes;
	GSList *l;
	GSList *invalid_uri_list = NULL;
	gboolean list_changed = FALSE;

	gconf_mailboxes = mn_conf_get_string_list(MN_CONF_OBSOLETE_MAILBOXES);
	MN_LIST_FOREACH(l, gconf_mailboxes)
	  {
	    const char *uri = l->data;
	    MNMailbox *mailbox;

	    mailbox = mn_mailbox_new_from_obsolete_uri(uri);
	    if (mailbox)
	      {
		mn_mailbox_seal(mailbox);
		self_add_real(self, mailbox);
		g_object_unref(mailbox);

		list_changed = TRUE;
	      }
	    else
	      invalid_uri_list = g_slist_append(invalid_uri_list, (gpointer) uri);
	  }

	if (list_changed)
	  {
	    self_list_changed(self);
	    self_save(self);	/* save the imported mailboxes */
	  }

	if (invalid_uri_list)
	  {
	    mn_show_invalid_uri_list_dialog(NULL, _("An error has occurred while importing old mailboxes"), invalid_uri_list);
	    g_slist_free(invalid_uri_list);
	  }

	mn_g_slist_free_deep(gconf_mailboxes);
      }
  
#line 552 "mn-mailboxes.c"
 }
}
#undef __GOB_FUNCTION__

static void
___object_get_property (GObject *object,
	guint property_id,
	GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "MN:Mailboxes::get_property"
{
	MNMailboxes *self G_GNUC_UNUSED;

	self = MN_MAILBOXES (object);

	switch (property_id) {
	case PROP_MANUALLY_CHECKABLE:
		{
#line 185 "src/mn-mailboxes.gob"

      GList *l;
      gboolean value = FALSE;

      MN_LIST_FOREACH(l, self->list)
	{
	  MNMailbox *mailbox = l->data;

	  if (mn_mailbox_get_manually_checkable(mailbox))
	    {
	      value = TRUE;
	      break;
	    }
	}

      g_value_set_boolean(VAL, value);
    
#line 589 "mn-mailboxes.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__


#line 70 "src/mn-mailboxes.gob"
static void 
mn_mailboxes_mailbox_added (MNMailboxes * self, MNMailbox * mailbox)
{
#line 609 "mn-mailboxes.c"
	GValue ___param_values[2];
	GValue ___return_val;

memset (&___return_val, 0, sizeof (___return_val));
memset (&___param_values, 0, sizeof (___param_values));

#line 70 "src/mn-mailboxes.gob"
	g_return_if_fail (self != NULL);
#line 70 "src/mn-mailboxes.gob"
	g_return_if_fail (MN_IS_MAILBOXES (self));
#line 70 "src/mn-mailboxes.gob"
	g_return_if_fail (mailbox != NULL);
#line 70 "src/mn-mailboxes.gob"
	g_return_if_fail (MN_IS_MAILBOX (mailbox));
#line 624 "mn-mailboxes.c"

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	___param_values[1].g_type = 0;
	g_value_init (&___param_values[1], G_TYPE_OBJECT);
	g_value_set_object (&___param_values[1], (GObject *) mailbox);

	g_signal_emitv (___param_values,
		object_signals[MAILBOX_ADDED_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);
	g_value_unset (&___param_values[1]);
}
#line 70 "src/mn-mailboxes.gob"
static void 
___real_mn_mailboxes_mailbox_added (MNMailboxes * self, MNMailbox * mailbox)
{
#line 646 "mn-mailboxes.c"
#define __GOB_FUNCTION__ "MN:Mailboxes::mailbox_added"
{
#line 72 "src/mn-mailboxes.gob"
	
    self_connect_mailbox_signals(self, mailbox);

    /* emit the "added" signal on the mailbox */
    mn_mailbox_added(mailbox);
  }}
#line 656 "mn-mailboxes.c"
#undef __GOB_FUNCTION__

#line 87 "src/mn-mailboxes.gob"
static void 
mn_mailboxes_mailbox_removed (MNMailboxes * self, MNMailbox * mailbox)
{
#line 663 "mn-mailboxes.c"
	GValue ___param_values[2];
	GValue ___return_val;

memset (&___return_val, 0, sizeof (___return_val));
memset (&___param_values, 0, sizeof (___param_values));

#line 87 "src/mn-mailboxes.gob"
	g_return_if_fail (self != NULL);
#line 87 "src/mn-mailboxes.gob"
	g_return_if_fail (MN_IS_MAILBOXES (self));
#line 87 "src/mn-mailboxes.gob"
	g_return_if_fail (mailbox != NULL);
#line 87 "src/mn-mailboxes.gob"
	g_return_if_fail (MN_IS_MAILBOX (mailbox));
#line 678 "mn-mailboxes.c"

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	___param_values[1].g_type = 0;
	g_value_init (&___param_values[1], G_TYPE_OBJECT);
	g_value_set_object (&___param_values[1], (GObject *) mailbox);

	g_signal_emitv (___param_values,
		object_signals[MAILBOX_REMOVED_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);
	g_value_unset (&___param_values[1]);
}
#line 87 "src/mn-mailboxes.gob"
static void 
___real_mn_mailboxes_mailbox_removed (MNMailboxes * self, MNMailbox * mailbox)
{
#line 700 "mn-mailboxes.c"
#define __GOB_FUNCTION__ "MN:Mailboxes::mailbox_removed"
{
#line 89 "src/mn-mailboxes.gob"
	
    self_disconnect_mailbox_signals(self, mailbox);

    /* emit the "removed" signal on the mailbox */
    mn_mailbox_removed(mailbox);

    /* messages and error have possibly changed */
    self_messages_changed(self, FALSE);
    self_error_changed(self);
  }}
#line 714 "mn-mailboxes.c"
#undef __GOB_FUNCTION__

#line 101 "src/mn-mailboxes.gob"
static void 
mn_mailboxes_mailbox_notify (MNMailboxes * self, MNMailbox * mailbox, GParamSpec * pspec)
{
#line 721 "mn-mailboxes.c"
	GValue ___param_values[3];
	GValue ___return_val;

memset (&___return_val, 0, sizeof (___return_val));
memset (&___param_values, 0, sizeof (___param_values));

#line 101 "src/mn-mailboxes.gob"
	g_return_if_fail (self != NULL);
#line 101 "src/mn-mailboxes.gob"
	g_return_if_fail (MN_IS_MAILBOXES (self));
#line 101 "src/mn-mailboxes.gob"
	g_return_if_fail (mailbox != NULL);
#line 101 "src/mn-mailboxes.gob"
	g_return_if_fail (MN_IS_MAILBOX (mailbox));
#line 101 "src/mn-mailboxes.gob"
	g_return_if_fail (pspec != NULL);
#line 738 "mn-mailboxes.c"

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	___param_values[1].g_type = 0;
	g_value_init (&___param_values[1], G_TYPE_OBJECT);
	g_value_set_object (&___param_values[1], (GObject *) mailbox);

	___param_values[2].g_type = 0;
	g_value_init (&___param_values[2], G_TYPE_POINTER);
	g_value_set_pointer (&___param_values[2], (gpointer ) pspec);

	g_signal_emitv (___param_values,
		object_signals[MAILBOX_NOTIFY_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);
	g_value_unset (&___param_values[1]);
	g_value_unset (&___param_values[2]);
}

#line 114 "src/mn-mailboxes.gob"
static void 
mn_mailboxes_list_changed (MNMailboxes * self)
{
#line 766 "mn-mailboxes.c"
	GValue ___param_values[1];
	GValue ___return_val;

memset (&___return_val, 0, sizeof (___return_val));
memset (&___param_values, 0, sizeof (___param_values));

#line 114 "src/mn-mailboxes.gob"
	g_return_if_fail (self != NULL);
#line 114 "src/mn-mailboxes.gob"
	g_return_if_fail (MN_IS_MAILBOXES (self));
#line 777 "mn-mailboxes.c"

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	g_signal_emitv (___param_values,
		object_signals[LIST_CHANGED_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);
}
#line 114 "src/mn-mailboxes.gob"
static void 
___real_mn_mailboxes_list_changed (MNMailboxes * self)
{
#line 794 "mn-mailboxes.c"
#define __GOB_FUNCTION__ "MN:Mailboxes::list_changed"
{
#line 116 "src/mn-mailboxes.gob"
	
    /* manually-checkable has possibly changed */
    g_object_notify(G_OBJECT(self), "manually-checkable");
  }}
#line 802 "mn-mailboxes.c"
#undef __GOB_FUNCTION__

#line 135 "src/mn-mailboxes.gob"
static void 
mn_mailboxes_messages_changed (MNMailboxes * self, gboolean has_new)
{
#line 809 "mn-mailboxes.c"
	GValue ___param_values[2];
	GValue ___return_val;

memset (&___return_val, 0, sizeof (___return_val));
memset (&___param_values, 0, sizeof (___param_values));

#line 135 "src/mn-mailboxes.gob"
	g_return_if_fail (self != NULL);
#line 135 "src/mn-mailboxes.gob"
	g_return_if_fail (MN_IS_MAILBOXES (self));
#line 820 "mn-mailboxes.c"

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	___param_values[1].g_type = 0;
	g_value_init (&___param_values[1], G_TYPE_BOOLEAN);
	g_value_set_boolean (&___param_values[1], (gboolean ) has_new);

	g_signal_emitv (___param_values,
		object_signals[MESSAGES_CHANGED_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);
	g_value_unset (&___param_values[1]);
}
#line 135 "src/mn-mailboxes.gob"
static void 
___real_mn_mailboxes_messages_changed (MNMailboxes * self, gboolean has_new)
{
#line 842 "mn-mailboxes.c"
#define __GOB_FUNCTION__ "MN:Mailboxes::messages_changed"
{
#line 137 "src/mn-mailboxes.gob"
	
    GList *l;

    mn_g_object_ptr_array_free(self->messages);
    self->messages = g_ptr_array_new();

    g_hash_table_remove_all(self->messages_hash_table);

    MN_LIST_FOREACH(l, self->list)
      {
	MNMailbox *mailbox = l->data;

	g_hash_table_foreach(mailbox->messages, (GHFunc) self_messages_changed_cb, self);
      }

    g_ptr_array_sort(self->messages, (GCompareFunc) self_messages_sort_cb);
  }}
#line 863 "mn-mailboxes.c"
#undef __GOB_FUNCTION__

#line 155 "src/mn-mailboxes.gob"
static void 
mn_mailboxes_messages_changed_cb (const char * id, MNMessage * message, Self * self)
{
#line 870 "mn-mailboxes.c"
#define __GOB_FUNCTION__ "MN:Mailboxes::messages_changed_cb"
{
#line 159 "src/mn-mailboxes.gob"
	
    g_ptr_array_add(self->messages, g_object_ref(message));
    g_hash_table_insert(self->messages_hash_table, message->id, message);
  }}
#line 878 "mn-mailboxes.c"
#undef __GOB_FUNCTION__

#line 164 "src/mn-mailboxes.gob"
static int 
mn_mailboxes_messages_sort_cb (MNMessage ** a, MNMessage ** b)
{
#line 885 "mn-mailboxes.c"
#define __GOB_FUNCTION__ "MN:Mailboxes::messages_sort_cb"
{
#line 166 "src/mn-mailboxes.gob"
	
    /* sort by sent time in descending order */
    return (*b)->sent_time - (*a)->sent_time;
  }}
#line 893 "mn-mailboxes.c"
#undef __GOB_FUNCTION__

#line 180 "src/mn-mailboxes.gob"
static void 
mn_mailboxes_error_changed (MNMailboxes * self)
{
#line 900 "mn-mailboxes.c"
	GValue ___param_values[1];
	GValue ___return_val;

memset (&___return_val, 0, sizeof (___return_val));
memset (&___param_values, 0, sizeof (___param_values));

#line 180 "src/mn-mailboxes.gob"
	g_return_if_fail (self != NULL);
#line 180 "src/mn-mailboxes.gob"
	g_return_if_fail (MN_IS_MAILBOXES (self));
#line 911 "mn-mailboxes.c"

	___param_values[0].g_type = 0;
	g_value_init (&___param_values[0], G_TYPE_FROM_INSTANCE (self));
	g_value_set_instance (&___param_values[0], (gpointer) self);

	g_signal_emitv (___param_values,
		object_signals[ERROR_CHANGED_SIGNAL],
		0 /* detail */,
		&___return_val);

	g_value_unset (&___param_values[0]);
}

#line 185 "src/mn-mailboxes.gob"
gboolean 
mn_mailboxes_get_manually_checkable (MNMailboxes * self)
{
#line 929 "mn-mailboxes.c"
#define __GOB_FUNCTION__ "MN:Mailboxes::get_manually_checkable"
{
#line 183 "src/mn-mailboxes.gob"
		gboolean val; g_object_get (G_OBJECT (self), "manually_checkable", &val, NULL); return val;
}}
#line 935 "mn-mailboxes.c"
#undef __GOB_FUNCTION__


#line 258 "src/mn-mailboxes.gob"
static void 
mn_mailboxes_finalize (MNMailboxes * self)
{
#line 943 "mn-mailboxes.c"
#define __GOB_FUNCTION__ "MN:Mailboxes::finalize"
{
#line 259 "src/mn-mailboxes.gob"
	
    GList *l;

    /*
     * We need to disconnect the mailbox signals because on exit, a
     * mailbox can survive the MNMailboxes object (if a check thread
     * is running).
     */
    MN_LIST_FOREACH(l, self->list)
      self_disconnect_mailbox_signals(self, l->data);

    mn_g_object_list_free(self->list);

    if (selfp->queue_idle_id)
      g_source_remove(selfp->queue_idle_id);
  }}
#line 963 "mn-mailboxes.c"
#undef __GOB_FUNCTION__

#line 276 "src/mn-mailboxes.gob"
static void 
mn_mailboxes_connect_mailbox_signals (MNMailboxes * self, MNMailbox * mailbox)
{
#line 970 "mn-mailboxes.c"
#define __GOB_FUNCTION__ "MN:Mailboxes::connect_mailbox_signals"
#line 276 "src/mn-mailboxes.gob"
	g_return_if_fail (self != NULL);
#line 276 "src/mn-mailboxes.gob"
	g_return_if_fail (MN_IS_MAILBOXES (self));
#line 276 "src/mn-mailboxes.gob"
	g_return_if_fail (mailbox != NULL);
#line 276 "src/mn-mailboxes.gob"
	g_return_if_fail (MN_IS_MAILBOX (mailbox));
#line 980 "mn-mailboxes.c"
{
#line 278 "src/mn-mailboxes.gob"
	
    g_object_connect(mailbox,
		     "signal::messages-changed", self_mailbox_messages_changed_h, self,
		     "signal::notify", self_mailbox_notify_h, self,
		     "signal::notify::error", self_mailbox_notify_error_h, self,
		     "signal::notify::manually-checkable", self_mailbox_notify_manually_checkable_h, self,
		     NULL);
  }}
#line 991 "mn-mailboxes.c"
#undef __GOB_FUNCTION__

#line 287 "src/mn-mailboxes.gob"
static void 
mn_mailboxes_disconnect_mailbox_signals (MNMailboxes * self, MNMailbox * mailbox)
{
#line 998 "mn-mailboxes.c"
#define __GOB_FUNCTION__ "MN:Mailboxes::disconnect_mailbox_signals"
#line 287 "src/mn-mailboxes.gob"
	g_return_if_fail (self != NULL);
#line 287 "src/mn-mailboxes.gob"
	g_return_if_fail (MN_IS_MAILBOXES (self));
#line 287 "src/mn-mailboxes.gob"
	g_return_if_fail (mailbox != NULL);
#line 287 "src/mn-mailboxes.gob"
	g_return_if_fail (MN_IS_MAILBOX (mailbox));
#line 1008 "mn-mailboxes.c"
{
#line 289 "src/mn-mailboxes.gob"
	
    g_object_disconnect(mailbox,
			"any-signal", self_mailbox_messages_changed_h, self,
			"any-signal", self_mailbox_notify_h, self,
			"any-signal", self_mailbox_notify_error_h, self,
			"any-signal", self_mailbox_notify_manually_checkable_h, self,
			NULL);
  }}
#line 1019 "mn-mailboxes.c"
#undef __GOB_FUNCTION__

#line 298 "src/mn-mailboxes.gob"
static void 
mn_mailboxes_load (MNMailboxes * self)
{
#line 1026 "mn-mailboxes.c"
#define __GOB_FUNCTION__ "MN:Mailboxes::load"
#line 298 "src/mn-mailboxes.gob"
	g_return_if_fail (self != NULL);
#line 298 "src/mn-mailboxes.gob"
	g_return_if_fail (MN_IS_MAILBOXES (self));
#line 1032 "mn-mailboxes.c"
{
#line 300 "src/mn-mailboxes.gob"
	
    GError *err = NULL;

    if (! self_load_real(self, &err))
      {
	mn_show_error_dialog(NULL, _("Unable to load the mailboxes configuration"), "%s", err->message);
	g_error_free(err);
      }

    if (self->must_save_after_load)
      self_save(self);
  }}
#line 1047 "mn-mailboxes.c"
#undef __GOB_FUNCTION__

#line 314 "src/mn-mailboxes.gob"
static void 
mn_mailboxes_add_error (GString ** errors, int * n_errors, const char * format, ...)
{
#line 1054 "mn-mailboxes.c"
#define __GOB_FUNCTION__ "MN:Mailboxes::add_error"
#line 314 "src/mn-mailboxes.gob"
	g_return_if_fail (errors != NULL);
#line 314 "src/mn-mailboxes.gob"
	g_return_if_fail (n_errors != NULL);
#line 1060 "mn-mailboxes.c"
{
#line 319 "src/mn-mailboxes.gob"
	
    char *message;

    if (*errors)
      g_string_append_c(*errors, '\n');
    else
      *errors = g_string_new(NULL);

    MN_STRDUP_VPRINTF(message, format);
    g_string_append(*errors, message);
    g_free(message);

    (*n_errors)++;
  }}
#line 1077 "mn-mailboxes.c"
#undef __GOB_FUNCTION__

#line 334 "src/mn-mailboxes.gob"
static gboolean 
mn_mailboxes_load_real (MNMailboxes * self, GError ** err)
{
#line 1084 "mn-mailboxes.c"
#define __GOB_FUNCTION__ "MN:Mailboxes::load_real"
#line 334 "src/mn-mailboxes.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 334 "src/mn-mailboxes.gob"
	g_return_val_if_fail (MN_IS_MAILBOXES (self), (gboolean )0);
#line 1090 "mn-mailboxes.c"
{
#line 336 "src/mn-mailboxes.gob"
	
    char *filename;
    xmlDoc *doc;
    xmlNode *root;
    xmlNode *node;
    gboolean list_changed = FALSE;
    gboolean status = TRUE;
    GString *errors = NULL;
    int n_errors = 0;

    filename = g_build_filename(mn_conf_dot_dir, "mailboxes.xml", NULL);
    doc = xmlParseFile(filename);
    g_free(filename);

    if (! doc)
      {
	g_set_error(err, 0, 0, _("Unable to parse the XML document."));
	return FALSE;
      }

    root = xmlDocGetRootElement(doc);
    if (! root)
      {
	g_set_error(err, 0, 0, _("The root element is missing."));
	goto error;
      }

    if (strcmp(root->name, "mailboxes"))
      {
	g_set_error(err, 0, 0, _("The root element \"%s\" is invalid."), root->name);
	goto error;
      }

    for (node = root->children; node; node = node->next)
      if (node->type == XML_ELEMENT_NODE)
	{
	  if (! strcmp(node->name, "mailbox"))
	    {
	      MNMailbox *mailbox;
	      GError *tmp_err = NULL;

	      mailbox = mn_mailbox_new_from_xml_node(node, &tmp_err);
	      if (mailbox)
		{
		  mn_mailbox_seal(mailbox);
		  self_add_real(self, mailbox);
		  g_object_unref(mailbox);
		  list_changed = TRUE;
		}
	      else
		{
		  self_add_error(&errors, &n_errors, _("On line %i: %s."), node->line, tmp_err->message);
		  g_error_free(tmp_err);
		}
	    }
	  else
	    self_add_error(&errors, &n_errors, _("On line %i: unknown element \"%s\"."), node->line, node->name);
	}

    if (list_changed)
      self_list_changed(self);

    if (errors)
      {
	mn_show_error_dialog(NULL,
			     ngettext("An error has occurred while loading the mailboxes configuration",
				      "Errors have occurred while loading the mailboxes configuration",
				      n_errors),
			     "%s", errors->str);
	g_string_free(errors, TRUE);
      }

    goto end;

  error:
    status = FALSE;

  end:
    xmlFreeDoc(doc);

    return status;
  }}
#line 1175 "mn-mailboxes.c"
#undef __GOB_FUNCTION__

#line 419 "src/mn-mailboxes.gob"
static void 
mn_mailboxes_save (MNMailboxes * self)
{
#line 1182 "mn-mailboxes.c"
#define __GOB_FUNCTION__ "MN:Mailboxes::save"
#line 419 "src/mn-mailboxes.gob"
	g_return_if_fail (self != NULL);
#line 419 "src/mn-mailboxes.gob"
	g_return_if_fail (MN_IS_MAILBOXES (self));
#line 1188 "mn-mailboxes.c"
{
#line 421 "src/mn-mailboxes.gob"
	
    GError *err = NULL;

    if (! self_save_real(self, &err))
      {
	mn_show_error_dialog(NULL, _("Unable to save the mailboxes configuration"), "%s", err->message);
	g_error_free(err);
      }
  }}
#line 1200 "mn-mailboxes.c"
#undef __GOB_FUNCTION__

#line 431 "src/mn-mailboxes.gob"
static gboolean 
mn_mailboxes_save_real (MNMailboxes * self, GError ** err)
{
#line 1207 "mn-mailboxes.c"
#define __GOB_FUNCTION__ "MN:Mailboxes::save_real"
#line 431 "src/mn-mailboxes.gob"
	g_return_val_if_fail (self != NULL, (gboolean )0);
#line 431 "src/mn-mailboxes.gob"
	g_return_val_if_fail (MN_IS_MAILBOXES (self), (gboolean )0);
#line 1213 "mn-mailboxes.c"
{
#line 433 "src/mn-mailboxes.gob"
	
    int indent;
    xmlDoc *doc;
    xmlNode *root;
    GList *l;
    char *filename;
    char *tmp_filename;
    char *old_filename;
    int fd = -1;
    FILE *f = NULL;
    gboolean old_exists;
    gboolean status = TRUE;

    indent = xmlIndentTreeOutput;
    xmlIndentTreeOutput = 1;

    doc = xmlNewDoc("1.0");
    root = xmlNewNode(NULL, "mailboxes");
    xmlDocSetRootElement(doc, root);

    MN_LIST_FOREACH(l, self->list)
      {
	MNMailbox *mailbox = l->data;
	xmlNode *node;

	if (! MN_IS_TEST_MAILBOX(mailbox))
	  {
	    node = mn_mailbox_xml_node_new(mailbox);
	    xmlAddChild(root, node); /* owns node */
	  }
      }

    filename = g_build_filename(mn_conf_dot_dir, "mailboxes.xml", NULL);
    tmp_filename = g_strconcat(filename, ".tmp", NULL);
    old_filename = g_strconcat(filename, ".old", NULL);

    if (g_file_test(tmp_filename, G_FILE_TEST_EXISTS) && unlink(tmp_filename) < 0)
      {
	g_set_error(err, 0, 0, _("Unable to remove %s: %s."), tmp_filename, g_strerror(errno));
	goto error;
      }

    /* the file may contain passwords; restrict permissions (600) */
    fd = open(tmp_filename, O_WRONLY | O_CREAT | O_EXCL, S_IRUSR | S_IWUSR);
    if (fd < 0)
      {
	g_set_error(err, 0, 0, _("Unable to create %s: %s."), tmp_filename, g_strerror(errno));
	goto error;
      }

    f = fdopen(fd, "w");
    if (! f)
      {
	g_set_error(err, 0, 0, _("Unable to open %s for writing: %s."), tmp_filename, g_strerror(errno));
	goto error;
      }
    fd = -1;			/* now owned by f */

    if (xmlDocFormatDump(f, doc, 1) < 0)
      {
	g_set_error(err, 0, 0, _("Unable to write the XML document."));
	goto error;
      }

    if (fclose(f) != 0)
      {
	g_set_error(err, 0, 0, _("Unable to close %s: %s."), tmp_filename, g_strerror(errno));
	goto error;
      }
    f = NULL;

    old_exists = g_file_test(filename, G_FILE_TEST_EXISTS);
    if (old_exists)
      {
	if (rename(filename, old_filename) < 0)
	  {
	    g_set_error(err, 0, 0, _("Unable to rename %s to %s: %s."), filename, old_filename, g_strerror(errno));
	    goto error;
	  }
      }

    if (rename(tmp_filename, filename) < 0)
      {
	g_set_error(err, 0, 0, _("Unable to rename %s to %s: %s."), tmp_filename, filename, g_strerror(errno));
	goto error;
      }

    if (old_exists)
      if (unlink(old_filename) < 0) /* non fatal */
	g_warning(_("unable to delete %s: %s"), old_filename, g_strerror(errno));

    goto end;			/* success */

  error:
    status = FALSE;

  end:
    xmlFreeDoc(doc);
    xmlIndentTreeOutput = indent;

    g_free(filename);
    g_free(tmp_filename);
    g_free(old_filename);

    if (fd >= 0)
      close(fd);
    if (f)
      fclose(f);

    return status;
  }}
#line 1327 "mn-mailboxes.c"
#undef __GOB_FUNCTION__

#line 545 "src/mn-mailboxes.gob"
static void 
mn_mailboxes_mailbox_messages_changed_h (MNMailbox * mailbox, gboolean has_new, gpointer user_data)
{
#line 1334 "mn-mailboxes.c"
#define __GOB_FUNCTION__ "MN:Mailboxes::mailbox_messages_changed_h"
{
#line 549 "src/mn-mailboxes.gob"
	
    Self *self = user_data;
    int num_messages;

    num_messages = g_hash_table_size(mailbox->messages);

    mn_info(ngettext("%s has %i new message", "%s has %i new messages", num_messages),
	    mailbox->runtime_name, num_messages);

    self_messages_changed(self, has_new);
  }}
#line 1349 "mn-mailboxes.c"
#undef __GOB_FUNCTION__

#line 561 "src/mn-mailboxes.gob"
static void 
mn_mailboxes_mailbox_notify_h (GObject * object, GParamSpec * pspec, gpointer user_data)
{
#line 1356 "mn-mailboxes.c"
#define __GOB_FUNCTION__ "MN:Mailboxes::mailbox_notify_h"
{
#line 563 "src/mn-mailboxes.gob"
	
    Self *self = user_data;
    char *detailed_signal;

    detailed_signal = g_strconcat("mailbox-notify::", g_param_spec_get_name(pspec), NULL);
    g_signal_emit_by_name(self, detailed_signal, object, pspec);
    g_free(detailed_signal);
  }}
#line 1368 "mn-mailboxes.c"
#undef __GOB_FUNCTION__

#line 572 "src/mn-mailboxes.gob"
static void 
mn_mailboxes_mailbox_notify_error_h (GObject * object, GParamSpec * pspec, gpointer user_data)
{
#line 1375 "mn-mailboxes.c"
#define __GOB_FUNCTION__ "MN:Mailboxes::mailbox_notify_error_h"
{
#line 576 "src/mn-mailboxes.gob"
	
    Self *self = user_data;
    MNMailbox *mailbox = MN_MAILBOX(object);

    if (mailbox->error)
      mn_info(_("%s reported an error: %s"), mailbox->runtime_name, mailbox->error);

    self_error_changed(self);
  }}
#line 1388 "mn-mailboxes.c"
#undef __GOB_FUNCTION__

#line 586 "src/mn-mailboxes.gob"
static void 
mn_mailboxes_mailbox_notify_manually_checkable_h (GObject * object, GParamSpec * pspec, gpointer user_data)
{
#line 1395 "mn-mailboxes.c"
#define __GOB_FUNCTION__ "MN:Mailboxes::mailbox_notify_manually_checkable_h"
{
#line 590 "src/mn-mailboxes.gob"
	
    Self *self = user_data;

    /* manually-checkable has possibly changed */
    g_object_notify(G_OBJECT(self), "manually-checkable");
  }}
#line 1405 "mn-mailboxes.c"
#undef __GOB_FUNCTION__

#line 597 "src/mn-mailboxes.gob"
void 
mn_mailboxes_check (MNMailboxes * self)
{
#line 1412 "mn-mailboxes.c"
#define __GOB_FUNCTION__ "MN:Mailboxes::check"
#line 597 "src/mn-mailboxes.gob"
	g_return_if_fail (self != NULL);
#line 597 "src/mn-mailboxes.gob"
	g_return_if_fail (MN_IS_MAILBOXES (self));
#line 1418 "mn-mailboxes.c"
{
#line 599 "src/mn-mailboxes.gob"
	
    GList *l;

    MN_LIST_FOREACH(l, self->list)
      {
	MNMailbox *mailbox = l->data;

	if (mn_mailbox_get_manually_checkable(mailbox))
	  mn_mailbox_check(mailbox);
      }
  }}
#line 1432 "mn-mailboxes.c"
#undef __GOB_FUNCTION__

#line 611 "src/mn-mailboxes.gob"
static void 
mn_mailboxes_add_real (MNMailboxes * self, MNMailbox * mailbox)
{
#line 1439 "mn-mailboxes.c"
#define __GOB_FUNCTION__ "MN:Mailboxes::add_real"
#line 611 "src/mn-mailboxes.gob"
	g_return_if_fail (self != NULL);
#line 611 "src/mn-mailboxes.gob"
	g_return_if_fail (MN_IS_MAILBOXES (self));
#line 611 "src/mn-mailboxes.gob"
	g_return_if_fail (mailbox != NULL);
#line 611 "src/mn-mailboxes.gob"
	g_return_if_fail (MN_IS_MAILBOX (mailbox));
#line 1449 "mn-mailboxes.c"
{
#line 613 "src/mn-mailboxes.gob"
	
    g_object_ref(mailbox);
    self->list = g_list_insert_sorted(self->list, mailbox, self_compare_by_name_func);
    self_mailbox_added(self, mailbox);
  }}
#line 1457 "mn-mailboxes.c"
#undef __GOB_FUNCTION__

#line 619 "src/mn-mailboxes.gob"
void 
mn_mailboxes_add (MNMailboxes * self, MNMailbox * mailbox)
{
#line 1464 "mn-mailboxes.c"
#define __GOB_FUNCTION__ "MN:Mailboxes::add"
#line 619 "src/mn-mailboxes.gob"
	g_return_if_fail (self != NULL);
#line 619 "src/mn-mailboxes.gob"
	g_return_if_fail (MN_IS_MAILBOXES (self));
#line 619 "src/mn-mailboxes.gob"
	g_return_if_fail (mailbox != NULL);
#line 619 "src/mn-mailboxes.gob"
	g_return_if_fail (MN_IS_MAILBOX (mailbox));
#line 1474 "mn-mailboxes.c"
{
#line 621 "src/mn-mailboxes.gob"
	
    self_add_real(self, mailbox);
    self_list_changed(self);

    if (! MN_IS_TEST_MAILBOX(mailbox))
      self_save(self);
  }}
#line 1484 "mn-mailboxes.c"
#undef __GOB_FUNCTION__

#line 629 "src/mn-mailboxes.gob"
void 
mn_mailboxes_queue_add (MNMailboxes * self, MNMailbox * mailbox)
{
#line 1491 "mn-mailboxes.c"
#define __GOB_FUNCTION__ "MN:Mailboxes::queue_add"
#line 629 "src/mn-mailboxes.gob"
	g_return_if_fail (self != NULL);
#line 629 "src/mn-mailboxes.gob"
	g_return_if_fail (MN_IS_MAILBOXES (self));
#line 629 "src/mn-mailboxes.gob"
	g_return_if_fail (mailbox != NULL);
#line 629 "src/mn-mailboxes.gob"
	g_return_if_fail (MN_IS_MAILBOX (mailbox));
#line 1501 "mn-mailboxes.c"
{
#line 631 "src/mn-mailboxes.gob"
	
    g_object_ref(mailbox);
    selfp->add_queue = g_slist_append(selfp->add_queue, mailbox);

    if (! selfp->queue_idle_id)
      selfp->queue_idle_id = gdk_threads_add_idle(self_queue_idle_cb, self);
  }}
#line 1511 "mn-mailboxes.c"
#undef __GOB_FUNCTION__

#line 639 "src/mn-mailboxes.gob"
static void 
mn_mailboxes_remove_real (MNMailboxes * self, MNMailbox * mailbox)
{
#line 1518 "mn-mailboxes.c"
#define __GOB_FUNCTION__ "MN:Mailboxes::remove_real"
#line 639 "src/mn-mailboxes.gob"
	g_return_if_fail (self != NULL);
#line 639 "src/mn-mailboxes.gob"
	g_return_if_fail (MN_IS_MAILBOXES (self));
#line 639 "src/mn-mailboxes.gob"
	g_return_if_fail (mailbox != NULL);
#line 639 "src/mn-mailboxes.gob"
	g_return_if_fail (MN_IS_MAILBOX (mailbox));
#line 1528 "mn-mailboxes.c"
{
#line 641 "src/mn-mailboxes.gob"
	
    self->list = g_list_remove(self->list, mailbox);
    self_mailbox_removed(self, mailbox);
    g_object_unref(mailbox);
  }}
#line 1536 "mn-mailboxes.c"
#undef __GOB_FUNCTION__

#line 647 "src/mn-mailboxes.gob"
void 
mn_mailboxes_remove (MNMailboxes * self, MNMailbox * mailbox)
{
#line 1543 "mn-mailboxes.c"
#define __GOB_FUNCTION__ "MN:Mailboxes::remove"
#line 647 "src/mn-mailboxes.gob"
	g_return_if_fail (self != NULL);
#line 647 "src/mn-mailboxes.gob"
	g_return_if_fail (MN_IS_MAILBOXES (self));
#line 647 "src/mn-mailboxes.gob"
	g_return_if_fail (mailbox != NULL);
#line 647 "src/mn-mailboxes.gob"
	g_return_if_fail (MN_IS_MAILBOX (mailbox));
#line 1553 "mn-mailboxes.c"
{
#line 649 "src/mn-mailboxes.gob"
	
    self_remove_real(self, mailbox);
    self_list_changed(self);
    if (! MN_IS_TEST_MAILBOX(mailbox))
      self_save(self);
  }}
#line 1562 "mn-mailboxes.c"
#undef __GOB_FUNCTION__

#line 656 "src/mn-mailboxes.gob"
void 
mn_mailboxes_queue_remove (MNMailboxes * self, MNMailbox * mailbox)
{
#line 1569 "mn-mailboxes.c"
#define __GOB_FUNCTION__ "MN:Mailboxes::queue_remove"
#line 656 "src/mn-mailboxes.gob"
	g_return_if_fail (self != NULL);
#line 656 "src/mn-mailboxes.gob"
	g_return_if_fail (MN_IS_MAILBOXES (self));
#line 656 "src/mn-mailboxes.gob"
	g_return_if_fail (mailbox != NULL);
#line 656 "src/mn-mailboxes.gob"
	g_return_if_fail (MN_IS_MAILBOX (mailbox));
#line 1579 "mn-mailboxes.c"
{
#line 658 "src/mn-mailboxes.gob"
	
    g_object_ref(mailbox);
    selfp->remove_queue = g_slist_append(selfp->remove_queue, mailbox);

    if (! selfp->queue_idle_id)
      selfp->queue_idle_id = gdk_threads_add_idle(self_queue_idle_cb, self);
  }}
#line 1589 "mn-mailboxes.c"
#undef __GOB_FUNCTION__

#line 666 "src/mn-mailboxes.gob"
static gboolean 
mn_mailboxes_queue_idle_cb (gpointer data)
{
#line 1596 "mn-mailboxes.c"
#define __GOB_FUNCTION__ "MN:Mailboxes::queue_idle_cb"
{
#line 668 "src/mn-mailboxes.gob"
	
    Self *self = data;
    GSList *l;

    MN_LIST_FOREACH(l, selfp->add_queue)
      self_add_real(self, l->data);

    mn_g_object_slist_clear(&selfp->add_queue);

    MN_LIST_FOREACH(l, selfp->remove_queue)
      self_remove_real(self, l->data);

    mn_g_object_slist_clear(&selfp->remove_queue);

    self_list_changed(self);
    self_save(self);

    selfp->queue_idle_id = 0;
    return FALSE;		/* remove */
  }}
#line 1620 "mn-mailboxes.c"
#undef __GOB_FUNCTION__

#line 689 "src/mn-mailboxes.gob"
int 
mn_mailboxes_compare_by_name_func (gconstpointer a, gconstpointer b)
{
#line 1627 "mn-mailboxes.c"
#define __GOB_FUNCTION__ "MN:Mailboxes::compare_by_name_func"
{
#line 691 "src/mn-mailboxes.gob"
	
    MNMailbox *mailbox_a = (MNMailbox *) a;
    MNMailbox *mailbox_b = (MNMailbox *) b;

    return g_utf8_collate(mailbox_a->runtime_name, mailbox_b->runtime_name);
  }}
#line 1637 "mn-mailboxes.c"
#undef __GOB_FUNCTION__

#line 698 "src/mn-mailboxes.gob"
MNMailboxes * 
mn_mailboxes_new (void)
{
#line 1644 "mn-mailboxes.c"
#define __GOB_FUNCTION__ "MN:Mailboxes::new"
{
#line 700 "src/mn-mailboxes.gob"
	
    return GET_NEW;
  }}
#line 1651 "mn-mailboxes.c"
#undef __GOB_FUNCTION__
