<?xml version='1.0'?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version='1.0'>

  <xsl:include href="/usr/share/xml/docbook/stylesheet/nwalsh/manpages/docbook.xsl"/>

  <!-- https://sourceforge.net/tracker/index.php?func=detail&aid=935833&group_id=21935&atid=373747 -->

  <xsl:template match="author|editor">
    <xsl:call-template name="person.name"/>
    <xsl:text> </xsl:text>
    <xsl:apply-templates select="./email" />
    <xsl:if test="./affiliation/orgname">
      <xsl:text>, </xsl:text>
      <xsl:apply-templates select="./affiliation/orgname" />
    </xsl:if>
  </xsl:template>

  <xsl:template match="filename|varname">
    <xsl:text>\fI</xsl:text><xsl:apply-templates/><xsl:text>\fP</xsl:text>
  </xsl:template>

  <xsl:template match="replaceable">
    <xsl:text>\fB</xsl:text><xsl:apply-templates/><xsl:text>\fP</xsl:text>
  </xsl:template>

  <xsl:template match="option|userinput|envar|errorcode|constant|type">
    <xsl:text>\fB</xsl:text><xsl:apply-templates/><xsl:text>\fP</xsl:text>
  </xsl:template>

<xsl:template match="email">
  <xsl:text>&lt;</xsl:text>
  <xsl:apply-templates/>
  <xsl:text>&gt;</xsl:text>
</xsl:template>

<xsl:template match="para">
  <xsl:text>&#10;.PP&#10;</xsl:text>
  <xsl:for-each select="node()">
    <xsl:choose>
      <xsl:when test="self::literallayout|self::informaltable|self::screen|self::programlisting|self::itemizedlist|self::orderedlist|self::variablelist">
        <xsl:text>&#10;</xsl:text>
        <xsl:apply-templates select="."/>
      </xsl:when>
      <xsl:when test="self::text()">
	<xsl:if test="starts-with(translate(.,'&#10;&#9;','  '), ' ') and
		      preceding-sibling::node()[name(.)!='']">
	  <xsl:text> </xsl:text>
	</xsl:if>
        <xsl:variable name="content">
	  <xsl:apply-templates select="."/>
	</xsl:variable>
	<xsl:value-of select="normalize-space($content)"/>
	<xsl:if
        test="translate(substring(., string-length(.), 1),'&#10;&#9;','  ') = ' ' and
              following-sibling::node()[name(.)!='']">
	  <xsl:text> </xsl:text>
	</xsl:if>
      </xsl:when>
      <xsl:otherwise>
        <xsl:variable name="content">
          <xsl:apply-templates select="."/>
        </xsl:variable>
	<xsl:value-of select="normalize-space($content)"/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:for-each>
  <xsl:text>&#10;</xsl:text>
</xsl:template>

</xsl:stylesheet>
