;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;   MDH 070918 - Simple test for Induction - Variant 1
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(load "~/minlog/init.scm")
(set! COMMENT-FLAG #f)
(libload "nat.scm")
(add-rewrite-rule (pt "nat < 0") (pt "False"))


(set-goal (pf "all n,m. exca k. n < m+k"))
(ind)
(assume "m" "Hyp0")
(inst-with "Hyp0" (pt "1"))
(use 2)
(use "Truth-Axiom")
(assume "n" "Hyp1" "m" "Hyp2")
(use "Hyp1" (pt "m"))
(assume "k" "Hyp3")
(use "Hyp2" (pt "k+1"))
(use "Hyp3")
(define prf (current-proof))
(define nprf (np prf))

(mload "../modules/diatup.scm")
(add-rewrite-rule (pt "Max nat (Succ nat)") (pt "Succ nat"))
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; First we get exact realizers by a Light/Pure Dialectica
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(set! COMMENT-FLAG #t)
(define vatmp (time (DIA-extract 'light prf)))
(define tmtup (tmpair-to-tuple (vatmpair-to-tmpair vatmp)))
(define tmlst (tmtuple-to-tmlist tmtup))
(length tmlst)
(define ti (car tmlst))
(string-length (term-to-string ti))
(set! UNFOLDING-FLAG #t)
(set! COMMENT-FLAG #t)
(define nti (time (nt ti)))
(pp nti)

(define i (mk-term-in-app-form nti (pt "175") (pt "30")))
(define ni (time (nt i)))
(pp ni)
(define i (mk-term-in-app-form nti (pt "100") (pt "15")))
(define ni (time (nt i)))
(pp ni)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Here we get upper bounds by a Monotone Dialectica
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define vatmp (time (DIA-extract 'monot prf)))
(define tmtup (tmpair-to-tuple (vatmpair-to-tmpair vatmp)))
(define tmlst (tmtuple-to-tmlist tmtup))
(length tmlst)
(define ti (car tmlst))
(string-length (term-to-string ti))
(set! UNFOLDING-FLAG #t)
(define nti (time (nt ti)))
(pp nti)

(define i (mk-term-in-app-form nti (pt "175") (pt "30")))
(define ni (time (nt i)))
(pp ni)
(define i (mk-term-in-app-form nti (pt "100") (pt "15")))
(define ni (time (nt i)))
(pp ni)
