#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <fcntl.h>

#include "message.h"

#define BUFSIZE 128
#define PORT 4711

int main(int argc, char **argv) {
	
	errno=0;
	
	if (argc < 2) {
		printf("Usage: %s address\n", argv[0]);
		exit(1);
	}

	int sock = socket(AF_INET, SOCK_STREAM, 0);
	if (sock < 0 || errno) {
		perror("socket()");
		exit(2);
	}

	struct sockaddr_in addr;
	memset(&addr, 0, sizeof(addr));
	addr.sin_family = AF_INET;
	addr.sin_port = htons(PORT);
	if (!inet_aton (argv[1], &addr.sin_addr)) {
		fprintf(stderr, "inet_aton(): address %s invalid\n", argv[1]);
		exit(3);
	}

	if ( connect(sock, (struct sockaddr *)&addr, sizeof(addr)) || errno) {
		perror("connect()");
		exit(4);
	}
	
	if (fcntl(sock, F_SETFL, O_NONBLOCK) == -1) {
		perror("fcntl(NONBLOCK)");
		exit(5);
	}

	struct netmessage_buffer *recvbuf = NULL;
	if (netmessage_buffer_init(&recvbuf) != NETMSG_SUCCESS) {
		fprintf(stderr, "netmessage_buffer_init(): could not init buffer\n");
		exit(6);
	}

	for (unsigned i=0; i<100000; i++) {
//		usleep(49000);
		struct netmessage msg;
		int ret = recvmessage(sock, &msg, sizeof(msg), recvbuf);
		if (ret==NETMSG_PARTIAL || ret==NETMSG_FAIL_DELIVER) {
			printf("partial read!\n");
	//		usleep(1000);
			continue;
		}
		if (ret!=NETMSG_SUCCESS) {
			fprintf(stderr, "recvmessage(): error code %d at message # %d\n", ret, i);
			exit(7);
		}
		printf("received message '%c' with %d bytes: %s\n", msg.hdr.id, msg.hdr.len, msg.payload.data);
	}


/*
	char buf[BUFSIZE];
	buf[BUFSIZE-1]='\0';
	
	for (unsigned i=0; i<100000; i++) {
		int size = read(sock, buf, BUFSIZE);
		if (errno) {
			perror("read()");
			exit(5);
		}

		if (size < BUFSIZE) {
			fprintf(stderr, "read(): received %d instead of %d bytes! (half message '%s')\n", size, BUFSIZE, buf);
			exit(6);
		}
		
		printf("received message: %s\n", buf);

	}
*/
	return 0;
}
