/*
 * Decompiled with CFR 0.152.
 */
package sharpen.core.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import sharpen.core.Annotations;
import sharpen.core.Bindings;
import sharpen.core.Configuration;
import sharpen.core.Mappings;
import sharpen.core.MemberKind;
import sharpen.core.NameScope;
import sharpen.core.PreserveFullyQualifiedNamesState;
import sharpen.core.csharp.ast.CSCompilationUnit;
import sharpen.core.csharp.ast.CSUsing;
import sharpen.core.framework.BindingUtils;
import sharpen.core.framework.Environments;
import sharpen.core.framework.JavadocUtility;

public class MappingsImpl
implements Mappings {
    private final List<String> _namespaces = new ArrayList<String>();
    private final Configuration _configuration = Environments.my(Configuration.class);
    private final CSCompilationUnit _compilationUnit = Environments.my(CSCompilationUnit.class);
    private final NameScope _nameScope = Environments.my(NameScope.class);
    private final Annotations _annotations = Environments.my(Annotations.class);
    private final Bindings _bindings = Environments.my(Bindings.class);
    private final PreserveFullyQualifiedNamesState _preserveFQNState = Environments.my(PreserveFullyQualifiedNamesState.class);

    @Override
    public String mappedFieldName(IVariableBinding binding) {
        if (!binding.isField()) {
            return null;
        }
        Configuration.MemberMapping mapping = this._configuration.mappedMember(BindingUtils.qualifiedName(binding));
        return mapping != null ? mapping.name : null;
    }

    @Override
    public String mappedMethodName(IMethodBinding binding) {
        Configuration.MemberMapping mapping = this.effectiveMappingFor(binding);
        return this.computeMethodName(binding, mapping);
    }

    @Override
    public String mappedTypeName(ITypeBinding type) {
        String annotatedRenaming;
        if (type.isArray() || type.isWildcardType()) {
            return type.getQualifiedName();
        }
        if (!this.hasMapping(type) && (annotatedRenaming = this.annotatedRenaming(type)) != null) {
            return this.registerMappedType(type, this.fullyQualifyIfNeeded(annotatedRenaming, type));
        }
        String mappedTypeName = this.mappedTypeName(BindingUtils.typeMappingKey(type), this.qualifiedName(type));
        if (mappedTypeName.length() == 0) {
            mappedTypeName = "_T" + Math.abs(type.getKey().hashCode());
        }
        if (this.shouldPrefixInterface(type)) {
            return this.registerMappedType(type, this.mappedInterfaceName(mappedTypeName));
        }
        return this.registerMappedType(type, mappedTypeName);
    }

    private String fullyQualifyIfNeeded(String typeName, ITypeBinding type) {
        String mappedNamespace;
        if (this.isFullyQualified(typeName)) {
            return typeName;
        }
        String originalNamespace = this.namespace(this.qualifiedName(type));
        if (originalNamespace.equals(mappedNamespace = this._configuration.mappedNamespace(originalNamespace))) {
            return typeName;
        }
        return String.valueOf(mappedNamespace) + "." + typeName;
    }

    private String namespace(String typeName) {
        return this.substringBeforeLast(typeName, '.');
    }

    private String substringBeforeLast(String s, char marker) {
        return s.substring(0, s.lastIndexOf(marker));
    }

    private boolean isFullyQualified(String typeName) {
        return typeName.contains(".");
    }

    private String annotatedRenaming(ITypeBinding type) {
        if (type.isTypeVariable()) {
            return null;
        }
        Object node = this.findDeclaringNode((IBinding)type);
        AbstractTypeDeclaration typeDeclaration = node instanceof AbstractTypeDeclaration ? (AbstractTypeDeclaration)node : null;
        return typeDeclaration != null && this.isAnnotatedWith((BodyDeclaration)typeDeclaration, "@sharpen.rename") ? this.annotatedRenaming((BodyDeclaration)typeDeclaration) : null;
    }

    private boolean shouldPrefixInterface(ITypeBinding type) {
        return this._configuration.nativeInterfaces() && type.isInterface() && !type.isAnnotation() && !this.hasMapping(type);
    }

    private String registerMappedType(ITypeBinding type, String fullName) {
        if (this._preserveFQNState.value()) {
            return fullName;
        }
        if (!this._configuration.organizeUsings()) {
            return fullName;
        }
        int pos = fullName.lastIndexOf(".");
        if (pos == -1) {
            return fullName;
        }
        if (!this.hasMapping(type)) {
            pos = this.nameSpaceLength(type, fullName, pos);
        }
        String namespace = fullName.substring(0, pos);
        this.registerNamespace(namespace);
        String name = fullName.substring(pos + 1);
        if (this.keepFullyQualified(name)) {
            return fullName;
        }
        this._compilationUnit.addUsing(new CSUsing(namespace));
        return name;
    }

    private int nameSpaceLength(ITypeBinding type, String fullName, int pos) {
        while (type.isNested()) {
            pos = fullName.lastIndexOf(".", pos - 1);
            type = type.getDeclaringClass();
        }
        return pos;
    }

    private boolean keepFullyQualified(String name) {
        return this._configuration.shouldFullyQualifyTypeName(name) || this._namespaces.contains(name) || this._nameScope.contains(name);
    }

    private void registerNamespace(String namespace) {
        if (this._namespaces.contains(namespace)) {
            return;
        }
        int pos = namespace.lastIndexOf(".");
        if (pos == -1) {
            this._namespaces.add(namespace);
            return;
        }
        this._namespaces.add(namespace.substring(pos + 1));
        this.registerNamespace(namespace.substring(0, pos));
    }

    private boolean hasMapping(ITypeBinding type) {
        return this._configuration.typeHasMapping(BindingUtils.typeMappingKey(type));
    }

    private String mappedInterfaceName(String name) {
        int pos = name.lastIndexOf(46);
        return String.valueOf(name.substring(0, pos)) + "." + this.interfaceName(name.substring(pos + 1));
    }

    private String interfaceName(String name) {
        return this._configuration.toInterfaceName(name);
    }

    @Override
    public Configuration.MemberMapping effectiveMappingFor(IMethodBinding binding) {
        Configuration.MemberMapping mapping = this.configuredMappingFor(binding);
        if (mapping != null) {
            return mapping;
        }
        boolean declaringClassIgnoresExtends = this.isDeclaringClassIgnoringExtends(binding);
        MethodDeclaration method = (MethodDeclaration)(declaringClassIgnoresExtends ? this.findDeclaringNode((IBinding)binding) : this.findDeclaringNode((IBinding)this.originalMethodBinding(binding)));
        if (method == null) {
            return null;
        }
        if (this.isAnnotatedWith((BodyDeclaration)method, "@sharpen.indexer")) {
            return new Configuration.MemberMapping(null, MemberKind.Indexer);
        }
        if (this.isAnnotatedWith((BodyDeclaration)method, "@sharpen.event")) {
            return new Configuration.MemberMapping(binding.getName(), MemberKind.Property);
        }
        if (this.isAnnotatedWith((BodyDeclaration)method, "@sharpen.property")) {
            return new Configuration.MemberMapping(this.annotatedPropertyName(method), MemberKind.Property);
        }
        if (this.isAnnotatedWith((BodyDeclaration)method, "@sharpen.rename")) {
            return new Configuration.MemberMapping(this.annotatedRenaming((BodyDeclaration)method), MemberKind.Method);
        }
        return null;
    }

    private boolean isDeclaringClassIgnoringExtends(IMethodBinding binding) {
        ITypeBinding declaringClassBinding = binding.getDeclaringClass();
        if (declaringClassBinding.isAnonymous()) {
            return false;
        }
        Object node = this.findDeclaringNode((IBinding)declaringClassBinding);
        BodyDeclaration declaringClass = node instanceof BodyDeclaration ? (BodyDeclaration)node : null;
        return declaringClass == null ? false : this.isAnnotatedWith(declaringClass, "@sharpen.ignore.extends");
    }

    private String annotatedRenaming(BodyDeclaration method) {
        return this._annotations.annotatedRenaming(method);
    }

    private String annotatedPropertyName(MethodDeclaration node) {
        return this._annotations.annotatedPropertyName(node);
    }

    private <T extends ASTNode> T findDeclaringNode(IBinding binding) {
        return this._bindings.findDeclaringNode(binding);
    }

    private boolean isAnnotatedWith(BodyDeclaration node, String annotation) {
        return JavadocUtility.containsJavadoc(node, annotation);
    }

    private Configuration.MemberMapping configuredMappingFor(IMethodBinding binding) {
        IMethodBinding actual = this.originalMethodBinding(binding);
        Configuration.MemberMapping mapping = this._configuration.mappedMember(BindingUtils.qualifiedSignature(actual));
        if (mapping != null) {
            return mapping;
        }
        return this._configuration.mappedMember(this.qualifiedName(actual));
    }

    private String qualifiedName(IMethodBinding actual) {
        return BindingUtils.qualifiedName(actual);
    }

    private String qualifiedName(ITypeBinding type) {
        return BindingUtils.qualifiedName(type);
    }

    private String computeMethodName(IMethodBinding binding, Configuration.MemberMapping mapping) {
        if (this.isStaticVoidMain(binding)) {
            return "Main";
        }
        String name = this.isNameMapping(mapping) ? mapping.name : binding.getName();
        return this.methodName(name);
    }

    private boolean isStaticVoidMain(IMethodBinding binding) {
        return this.isStatic(binding) && "main".equals(binding.getName());
    }

    private boolean isStatic(IMethodBinding binding) {
        return Modifier.isStatic((int)binding.getModifiers());
    }

    private boolean isNameMapping(Configuration.MemberMapping mapping) {
        return mapping != null && mapping.name != null;
    }

    private String methodName(String name) {
        return this._configuration.getNamingStrategy().methodName(name);
    }

    private IMethodBinding originalMethodBinding(IMethodBinding binding) {
        return this._bindings.originalBindingFor(binding);
    }

    private String mappedTypeName(String typeName, String defaultValue) {
        return this._configuration.mappedTypeName(typeName, defaultValue);
    }
}

