/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xml.tok;

import com.jclark.xml.tok.Encoding;
import com.jclark.xml.tok.InvalidTokenException;
import com.jclark.xml.tok.Position;

final class UTF8Encoding
extends Encoding {
    private static final byte[] utf8HiTypeTable = new byte[]{-6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -6, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -2, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -3, -4, -4, -4, -4, -4, -4, -4, -4, -5, -5, -5, -5, -5, -5, -6, -6};
    private static final byte[] utf8TypeTable = new byte[256];

    int byteType3(byte[] byArray, int n) {
        byte[] byArray2 = Encoding.charTypeTable[(byArray[n] & 0xF) << 4 | byArray[n + 1] >>> 2 & 0xF];
        return byArray2[(byArray[n + 1] & 3) << 6 | byArray[n + 2] & 0x3F];
    }

    int byteToAscii(byte[] byArray, int n) {
        return (char)byArray[n];
    }

    UTF8Encoding() {
        super(1);
    }

    public int convert(byte[] byArray, int n, int n2, char[] cArray, int n3) {
        int n4 = n3;
        while (n != n2) {
            byte by;
            if ((by = byArray[n++]) >= 0) {
                cArray[n3++] = (char)by;
                continue;
            }
            switch (utf8TypeTable[by & 0xFF]) {
                case -2: {
                    cArray[n3++] = (char)((by & 0x1F) << 6 | byArray[n++] & 0x3F);
                    break;
                }
                case -3: {
                    int n5 = (by & 0xF) << 12;
                    n5 |= (byArray[n++] & 0x3F) << 6;
                    cArray[n3++] = (char)(n5 |= byArray[n++] & 0x3F);
                    break;
                }
                case -4: {
                    int n5 = (by & 7) << 18;
                    n5 |= (byArray[n++] & 0x3F) << 12;
                    n5 |= (byArray[n++] & 0x3F) << 6;
                    n5 |= byArray[n++] & 0x3F;
                    cArray[n3++] = (char)((n5 -= 65536) >> 10 | 0xD800);
                    cArray[n3++] = (char)(n5 & 0x3FF | 0xDC00);
                }
            }
        }
        return n3 - n4;
    }

    boolean charMatches(byte[] byArray, int n, char c) {
        return (char)byArray[n] == c;
    }

    int byteType(byte[] byArray, int n) {
        return utf8TypeTable[byArray[n] & 0xFF];
    }

    int extendData(byte[] byArray, int n, int n2) throws InvalidTokenException {
        while (n != n2) {
            byte by = utf8TypeTable[byArray[n] & 0xFF];
            if (by >= 0) {
                ++n;
                continue;
            }
            if (by < -4 || n2 - n + by < 0) break;
            switch (by) {
                case -3: {
                    this.check3(byArray, n);
                    break;
                }
                case -4: {
                    this.check4(byArray, n);
                }
            }
            n -= by;
        }
        return n;
    }

    int byteType2(byte[] byArray, int n) {
        byte[] byArray2 = Encoding.charTypeTable[byArray[n] >>> 2 & 7];
        return byArray2[(byArray[n] & 3) << 6 | byArray[n + 1] & 0x3F];
    }

    static {
        System.arraycopy(Encoding.asciiTypeTable, 0, utf8TypeTable, 0, 128);
        System.arraycopy(utf8HiTypeTable, 0, utf8TypeTable, 128, 128);
    }

    public int getFixedBytesPerChar() {
        return 0;
    }

    void check3(byte[] byArray, int n) throws InvalidTokenException {
        switch (byArray[n]) {
            case -17: {
                if (byArray[n + 1] == -65 && (byArray[n + 2] == -65 || byArray[n + 2] == -66)) break;
                return;
            }
            case -19: {
                if ((byArray[n + 1] & 0x20) != 0) break;
                return;
            }
            default: {
                return;
            }
        }
        throw new InvalidTokenException(n);
    }

    void check4(byte[] byArray, int n) throws InvalidTokenException {
        switch (byArray[n] & 7) {
            default: {
                return;
            }
            case 4: {
                if ((byArray[n + 1] & 0x30) != 0) break;
                return;
            }
            case 5: 
            case 6: 
            case 7: 
        }
        throw new InvalidTokenException(n);
    }

    public void movePosition(byte[] byArray, int n, int n2, Position position) {
        int n3 = n - position.columnNumber;
        int n4 = position.lineNumber;
        block9: while (n != n2) {
            byte by;
            block10: while ((by = byArray[n]) >= 0) {
                ++n;
                switch (by) {
                    case 10: {
                        ++n4;
                        n3 = n;
                        continue block9;
                    }
                    case 13: {
                        ++n4;
                        if (n == n2 || byArray[n] == 10) {
                            // empty if block
                        }
                        n3 = ++n;
                        continue block9;
                    }
                    default: {
                        if (n != n2) continue block10;
                    }
                }
            }
            switch (utf8TypeTable[by & 0xFF]) {
                default: {
                    ++n;
                    break;
                }
                case -2: {
                    n += 2;
                    ++n3;
                    break;
                }
                case -3: {
                    n += 3;
                    n3 += 2;
                    break;
                }
                case -4: {
                    n += 4;
                    n3 += 3;
                }
            }
        }
        position.columnNumber = n - n3;
        position.lineNumber = n4;
    }
}

