/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.sax;

import com.jclark.xsl.om.LoadContext;
import com.jclark.xsl.om.Name;
import com.jclark.xsl.om.NameTable;
import com.jclark.xsl.om.NamespacePrefixMap;
import com.jclark.xsl.om.Node;
import com.jclark.xsl.om.SafeNodeIterator;
import com.jclark.xsl.om.XMLProcessor;
import com.jclark.xsl.om.XSLException;
import com.jclark.xsl.sax.CommentHandler;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLProcessorImpl
implements XMLProcessor {
    private Parser parser;

    public XMLProcessorImpl(Parser parser) {
        this.parser = parser;
    }

    public Node load(URL uRL, LoadContext loadContext, NameTable nameTable) throws IOException, XSLException {
        return this.load(new InputSource(uRL.toString()), loadContext, nameTable);
    }

    public Node load(InputSource inputSource, LoadContext loadContext, NameTable nameTable) throws IOException, XSLException {
        try {
            BuilderImpl builderImpl = new BuilderImpl(loadContext, inputSource.getSystemId(), nameTable.getEmptyNamespacePrefixMap());
            this.parser.setDocumentHandler(builderImpl);
            this.parser.parse(inputSource);
            return builderImpl.getRootNode();
        }
        catch (SAXParseException sAXParseException) {
            throw new XSLException(sAXParseException);
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException.getException();
            if (exception == null) {
                throw new XSLException(sAXException.getMessage());
            }
            if (exception instanceof XSLException) {
                throw (XSLException)sAXException.getException();
            }
            throw new XSLException(exception);
        }
    }

    public Builder createBuilder(String string, LoadContext loadContext, NameTable nameTable) {
        return new BuilderImpl(loadContext, string, nameTable.getEmptyNamespacePrefixMap());
    }

    private static class BuilderImpl
    implements Builder {
        char[] dataBuf = new char[1024];
        int dataBufUsed = 0;
        RootNodeImpl rootNode;
        ContainerNodeImpl currentNode;
        int currentIndex = 1;
        boolean includeProcessingInstructions;
        boolean includeComments;
        LoadContext context;
        Locator locator = new NullLocator();

        public void ignorableWhitespace(char[] cArray, int n, int n2) {
            if (this.dataBufUsed > 0 || this.currentNode.preserveSpace() || !this.context.getStripSource(this.currentNode.getName())) {
                this.characters(cArray, n, n2);
            }
        }

        private static boolean isWhitespace(char[] cArray, int n) {
            int n2 = 0;
            while (n2 < n) {
                switch (cArray[n2]) {
                    default: {
                        return false;
                    }
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': 
                }
                ++n2;
            }
            return true;
        }

        public void startElement(String string, AttributeList attributeList) throws SAXException {
            ElementNodeImpl elementNodeImpl;
            this.flushData();
            String string2 = attributeList.getValue("xml:space");
            boolean bl = string2 == null ? this.currentNode.preserveSpace() : (string2.equals("default") ? false : (string2.equals("preserve") ? true : this.currentNode.preserveSpace()));
            try {
                elementNodeImpl = bl ? new PreserveElementNodeImpl(string, attributeList, this.locator, this.currentIndex++, this.currentNode) : new ElementNodeImpl(string, attributeList, this.locator, this.currentIndex++, this.currentNode);
            }
            catch (XSLException xSLException) {
                throw new SAXException(xSLException);
            }
            this.currentIndex += attributeList.getLength();
            this.currentNode = elementNodeImpl;
        }

        public Node getRootNode() {
            return this.rootNode;
        }

        public void startDocument() {
        }

        public void endElement(String string) {
            this.flushData();
            this.currentNode = this.currentNode.parent;
        }

        BuilderImpl(LoadContext loadContext, String string, NamespacePrefixMap namespacePrefixMap) {
            this.context = loadContext;
            this.includeProcessingInstructions = loadContext.getIncludeProcessingInstructions();
            this.includeComments = loadContext.getIncludeComments();
            this.rootNode = new RootNodeImpl(string, namespacePrefixMap);
            this.currentNode = this.rootNode;
        }

        public void endDocument() {
        }

        public void comment(String string) {
            if (this.includeComments) {
                this.flushData();
                new CommentNodeImpl(string, this.currentIndex++, this.currentNode);
            }
        }

        private final void flushData() {
            if (this.dataBufUsed > 0) {
                if (!BuilderImpl.isWhitespace(this.dataBuf, this.dataBufUsed) || this.currentNode.preserveSpace() || !this.context.getStripSource(this.currentNode.getName())) {
                    new TextNodeImpl(this.dataBuf, 0, this.dataBufUsed, this.currentIndex++, this.currentNode);
                }
                this.dataBufUsed = 0;
            }
        }

        public void characters(char[] cArray, int n, int n2) {
            int n3 = n2 + this.dataBufUsed;
            if (n3 > this.dataBuf.length) {
                int n4 = this.dataBuf.length << 1;
                while (n3 > n4) {
                    n4 <<= 1;
                }
                char[] cArray2 = this.dataBuf;
                this.dataBuf = new char[n4];
                if (this.dataBufUsed > 0) {
                    System.arraycopy(cArray2, 0, this.dataBuf, 0, this.dataBufUsed);
                }
            }
            while (n2 > 0) {
                this.dataBuf[this.dataBufUsed++] = cArray[n++];
                --n2;
            }
        }

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        public void processingInstruction(String string, String string2) {
            if (string == null) {
                this.comment(string2);
                return;
            }
            if (this.includeProcessingInstructions) {
                this.flushData();
                new ProcessingInstructionNodeImpl(string, string2, this.currentIndex++, this.currentNode);
            }
        }
    }

    public static interface Builder
    extends DocumentHandler,
    CommentHandler {
        public Node getRootNode();
    }

    private static abstract class NodeImpl
    implements Node {
        ContainerNodeImpl parent;
        int index;
        NodeImpl nextSibling;

        public String getGeneratedId() {
            return "N" + String.valueOf(this.index);
        }

        public int getLineNumber() {
            return this.parent.getLineNumber();
        }

        public NamespacePrefixMap getNamespacePrefixMap() {
            return this.parent.nsMap;
        }

        public String getAttributeValue(Name name) {
            return null;
        }

        public Node getAttribute(Name name) {
            return null;
        }

        public Node getParent() {
            return this.parent;
        }

        NodeImpl() {
            this.index = 0;
            this.parent = null;
            this.nextSibling = null;
        }

        NodeImpl(int n, ContainerNodeImpl containerNodeImpl) {
            this.index = n;
            this.parent = containerNodeImpl;
            this.nextSibling = null;
            if (containerNodeImpl.lastChild == null) {
                containerNodeImpl.firstChild = containerNodeImpl.lastChild = this;
                return;
            }
            containerNodeImpl.lastChild.nextSibling = this;
            containerNodeImpl.lastChild = this;
        }

        public boolean isId(String string) {
            return false;
        }

        public SafeNodeIterator getAttributes() {
            return new NodeIteratorImpl(null);
        }

        boolean canStrip() {
            return false;
        }

        public int compareTo(Node node) {
            return this.index - ((NodeImpl)node).index;
        }

        public abstract String getData();

        public abstract SafeNodeIterator getChildren();

        public SafeNodeIterator getFollowingSiblings() {
            return new NodeIteratorImpl(this.nextSibling);
        }

        public URL getURL() {
            return this.parent.getURL();
        }

        public abstract byte getType();

        public Name getName() {
            return null;
        }

        public Node getElementWithId(String string) {
            return this.parent.getElementWithId(string);
        }
    }

    private static class NodeIteratorImpl
    implements SafeNodeIterator {
        private NodeImpl nextNode;

        NodeIteratorImpl(NodeImpl nodeImpl) {
            this.nextNode = nodeImpl;
        }

        public Node next() {
            NodeImpl nodeImpl = this.nextNode;
            if (nodeImpl != null) {
                this.nextNode = nodeImpl.nextSibling;
            }
            return nodeImpl;
        }
    }

    private static abstract class ContainerNodeImpl
    extends NodeImpl {
        NodeImpl firstChild;
        NodeImpl lastChild;
        NamespacePrefixMap nsMap;

        public NamespacePrefixMap getNamespacePrefixMap() {
            return this.nsMap;
        }

        ContainerNodeImpl(NamespacePrefixMap namespacePrefixMap) {
            this.nsMap = namespacePrefixMap;
        }

        ContainerNodeImpl(int n, ContainerNodeImpl containerNodeImpl) {
            super(n, containerNodeImpl);
            this.nsMap = containerNodeImpl.nsMap;
        }

        boolean preserveSpace() {
            return false;
        }

        public String getData() {
            return null;
        }

        public SafeNodeIterator getChildren() {
            return new NodeIteratorImpl(this.firstChild);
        }

        void addId(String string, NodeImpl nodeImpl) {
            this.parent.addId(string, nodeImpl);
        }
    }

    private static class RootNodeImpl
    extends ContainerNodeImpl {
        private String systemId;
        private Hashtable idTable = new Hashtable();

        public int getLineNumber() {
            return 1;
        }

        RootNodeImpl(String string, NamespacePrefixMap namespacePrefixMap) {
            super(namespacePrefixMap);
            this.systemId = string;
        }

        void addId(String string, NodeImpl nodeImpl) {
            if (this.idTable.get(string) == null) {
                this.idTable.put(string, nodeImpl);
            }
        }

        public URL getURL() {
            if (this.systemId != null) {
                try {
                    return new URL(this.systemId);
                }
                catch (MalformedURLException malformedURLException) {}
            }
            return null;
        }

        public byte getType() {
            return 3;
        }

        public Node getElementWithId(String string) {
            return (Node)this.idTable.get(string);
        }
    }

    private static class NullLocator
    implements Locator {
        public String getSystemId() {
            return null;
        }

        public int getLineNumber() {
            return -1;
        }

        NullLocator() {
        }

        public String getPublicId() {
            return null;
        }

        public int getColumnNumber() {
            return -1;
        }
    }

    private static class ElementNodeImpl
    extends ContainerNodeImpl {
        private Name name;
        Object[] atts;
        private int lineNumber;
        private String systemId;

        public int getLineNumber() {
            return this.lineNumber;
        }

        public Node getAttribute(Name name) {
            if (this.atts != null) {
                int n = 0;
                while (n < this.atts.length) {
                    if (this.atts[n].equals(name)) {
                        return new AttributeNodeImpl(this.index + (n >> 1) + 1, this, name, (String)this.atts[n + 1]);
                    }
                    n += 2;
                }
            }
            return null;
        }

        public String getAttributeValue(Name name) {
            if (this.atts != null) {
                int n = 0;
                while (n < this.atts.length) {
                    if (this.atts[n].equals(name)) {
                        return (String)this.atts[n + 1];
                    }
                    n += 2;
                }
            }
            return null;
        }

        ElementNodeImpl(String string, AttributeList attributeList, Locator locator, int n, ContainerNodeImpl containerNodeImpl) throws XSLException {
            super(n, containerNodeImpl);
            this.lineNumber = locator.getLineNumber();
            this.systemId = locator.getSystemId();
            int n2 = attributeList.getLength();
            if (n2 > 0) {
                Object[] objectArray;
                int n3 = 0;
                int n4 = 0;
                while (n4 < n2) {
                    objectArray = attributeList.getName(n4);
                    if (objectArray.startsWith("xmlns")) {
                        ++n3;
                        if (objectArray.length() == 5) {
                            String string2 = attributeList.getValue(n4);
                            this.nsMap = string2.length() == 0 ? this.nsMap.unbindDefault() : this.nsMap.bindDefault(string2);
                        } else if (objectArray.charAt(5) == ':') {
                            this.nsMap = this.nsMap.bind(objectArray.substring(6), attributeList.getValue(n4));
                        }
                    }
                    ++n4;
                }
                n4 = n2 - n3;
                if (n4 > 0) {
                    objectArray = new Object[n4 * 2];
                    int n5 = 0;
                    int n6 = 0;
                    while (n6 < n2) {
                        String string3 = attributeList.getName(n6);
                        if (!string3.startsWith("xmlns")) {
                            objectArray[n5++] = this.nsMap.expandAttributeName(string3, this);
                            objectArray[n5++] = attributeList.getValue(n6);
                        }
                        if (attributeList.getType(n6).length() == 2) {
                            containerNodeImpl.addId(attributeList.getValue(n6), this);
                        }
                        ++n6;
                    }
                    this.atts = objectArray;
                }
            }
            this.name = this.nsMap.expandElementTypeName(string, this);
        }

        public boolean isId(String string) {
            return this.equals(this.getElementWithId(string));
        }

        public SafeNodeIterator getAttributes() {
            return new SafeNodeIterator(){
                private int i;
                {
                    ElementNodeImpl.this.getClass();
                    this.i = 0;
                }

                public Node next() {
                    if (ElementNodeImpl.this.atts == null) {
                        return null;
                    }
                    int n = this.i * 2;
                    if (n == ElementNodeImpl.this.atts.length) {
                        return null;
                    }
                    return new AttributeNodeImpl(ElementNodeImpl.this.index + ++this.i, ElementNodeImpl.this, (Name)ElementNodeImpl.this.atts[n], (String)ElementNodeImpl.this.atts[n + 1]);
                }
            };
        }

        public URL getURL() {
            if (this.systemId != null) {
                try {
                    return new URL(this.systemId);
                }
                catch (MalformedURLException malformedURLException) {}
            }
            return null;
        }

        public Name getName() {
            return this.name;
        }

        public byte getType() {
            return 0;
        }
    }

    private static class PreserveElementNodeImpl
    extends ElementNodeImpl {
        PreserveElementNodeImpl(String string, AttributeList attributeList, Locator locator, int n, ContainerNodeImpl containerNodeImpl) throws XSLException {
            super(string, attributeList, locator, n, containerNodeImpl);
        }

        boolean preserveSpace() {
            return true;
        }
    }

    private static class AttributeNodeImpl
    extends NodeImpl {
        private Name name;
        private String value;

        AttributeNodeImpl(int n, ContainerNodeImpl containerNodeImpl, Name name, String string) {
            this.index = n;
            this.parent = containerNodeImpl;
            this.name = name;
            this.value = string;
        }

        public int hashCode() {
            return this.index;
        }

        public String getData() {
            return this.value;
        }

        public SafeNodeIterator getChildren() {
            return new NodeIteratorImpl(null);
        }

        public boolean equals(Object object) {
            return object != null && object instanceof AttributeNodeImpl && ((AttributeNodeImpl)object).index == this.index;
        }

        public byte getType() {
            return 2;
        }

        public Name getName() {
            return this.name;
        }
    }

    private static class TextNodeImpl
    extends NodeImpl {
        private String data;

        public TextNodeImpl(char[] cArray, int n, int n2, int n3, ContainerNodeImpl containerNodeImpl) {
            super(n3, containerNodeImpl);
            this.data = new String(cArray, n, n2);
        }

        public String getData() {
            return this.data;
        }

        public SafeNodeIterator getChildren() {
            return new NodeIteratorImpl(null);
        }

        public byte getType() {
            return 1;
        }
    }

    private static class StripTextNodeImpl
    extends TextNodeImpl {
        public StripTextNodeImpl(char[] cArray, int n, int n2, int n3, ContainerNodeImpl containerNodeImpl) {
            super(cArray, n, n2, n3, containerNodeImpl);
        }

        boolean canStrip() {
            return true;
        }
    }

    private static class CommentNodeImpl
    extends NodeImpl {
        private String data;

        public CommentNodeImpl(String string, int n, ContainerNodeImpl containerNodeImpl) {
            super(n, containerNodeImpl);
            this.data = string;
        }

        public String getData() {
            return this.data;
        }

        public SafeNodeIterator getChildren() {
            return new NodeIteratorImpl(null);
        }

        public byte getType() {
            return 5;
        }
    }

    private static class ProcessingInstructionNodeImpl
    extends NodeImpl {
        private Name name;
        private String data;

        public ProcessingInstructionNodeImpl(String string, String string2, int n, ContainerNodeImpl containerNodeImpl) {
            super(n, containerNodeImpl);
            this.name = containerNodeImpl.getNamespacePrefixMap().getNameTable().createName(string);
            this.data = string2;
        }

        public String getData() {
            return this.data;
        }

        public SafeNodeIterator getChildren() {
            return new NodeIteratorImpl(null);
        }

        public Name getName() {
            return this.name;
        }

        public byte getType() {
            return 4;
        }
    }
}

