#include "usb.h"

#define F60_MAX_FILES 256
#define F60_MAX_FILENAME 128
#define F60_MAX_RESPONSE 512

#include "f60error.h"

#define F60_VENDOR_ID 0x0a62
#define F60_PRODUCT_ID 0x0006

// Looks like the F50 can be supported just by checking for a different PRODUCT ID 

#define F50_VENDOR_ID F60_VENDOR_ID
#define F50_PRODUCT_ID 0x0004

#define F55_VENDOR_ID F60_VENDOR_ID
#define F55_PRODUCT_ID 0x000b

#define F60_EPA_1 0x01
#define F60_EPA_2 0x82

#define FLASH_MEMORY 1
#define SMARTMEDIA_MEMORY 2

#define MPMAN_F50 1
#define MPMAN_F60 2

struct f60_dir {
     unsigned char size;
     int total_memory;
     int free_memory;

     char contents[F60_MAX_FILES * 256];
};

extern char f60_strerror[512];
extern int f60_error;
extern unsigned char response[F60_MAX_RESPONSE];
extern int response_size;

int f60_delete_file(usb_dev_handle *dev,unsigned char index);
int f60_move_file(usb_dev_handle *dev,char* order,unsigned char size);
char* f60_get_file(usb_dev_handle *dev,unsigned char index,char* path);
int f60_send_file(usb_dev_handle *dev,char* filename,char* text);
struct f60_dir* f60_get_dir(usb_dev_handle *dev);
int f60_get_firmware_version(usb_dev_handle* dev);
int f60_format_media(usb_dev_handle *dev, char x);

int get_filename_offset();

struct usb_device* f60_get_device_by_id(short vendor,short product);
void f60_set_debug(int level);
char* f60_strip_path(char* filename);
void f60_big2little_endian(int* from,int* to);
void f60_little2big_endian(int* from,int* to);
struct usb_dev_handle* f60_init();
void f60_close(struct usb_dev_handle* usb_hand);
int f60_encode_file(char* source,char* dest);
int f60_decode_file(char* source,char* dest);
void f60_select_memory(int a);
//int f60_check_for_device();
float f60_get_rw_progress(); 
struct usb_dev_handle* f60_init_with_id(unsigned short vendor,
                                        unsigned short product
					);

