from typing import Any
from werkzeug.datastructures import CallbackDict

def generate_key(salt=None): ...

class ModificationTrackingDict(CallbackDict):
    modified = ...  # type: Any
    def __init__(self, *args, **kwargs): ...
    def copy(self): ...
    def __copy__(self): ...

class Session(ModificationTrackingDict):
    sid = ...  # type: Any
    new = ...  # type: Any
    def __init__(self, data, sid, new=False): ...
    @property
    def should_save(self): ...

class SessionStore:
    session_class = ...  # type: Any
    def __init__(self, session_class=None): ...
    def is_valid_key(self, key): ...
    def generate_key(self, salt=None): ...
    def new(self): ...
    def save(self, session): ...
    def save_if_modified(self, session): ...
    def delete(self, session): ...
    def get(self, sid): ...

class FilesystemSessionStore(SessionStore):
    path = ...  # type: Any
    filename_template = ...  # type: Any
    renew_missing = ...  # type: Any
    mode = ...  # type: Any
    def __init__(self, path=None, filename_template='', session_class=None, renew_missing=False, mode=420): ...
    def get_session_filename(self, sid): ...
    def save(self, session): ...
    def delete(self, session): ...
    def get(self, sid): ...
    def list(self): ...

class SessionMiddleware:
    app = ...  # type: Any
    store = ...  # type: Any
    cookie_name = ...  # type: Any
    cookie_age = ...  # type: Any
    cookie_expires = ...  # type: Any
    cookie_path = ...  # type: Any
    cookie_domain = ...  # type: Any
    cookie_secure = ...  # type: Any
    cookie_httponly = ...  # type: Any
    environ_key = ...  # type: Any
    def __init__(self, app, store, cookie_name='', cookie_age=None, cookie_expires=None, cookie_path='', cookie_domain=None, cookie_secure=None, cookie_httponly=False, environ_key=''): ...
    def __call__(self, environ, start_response): ...
