/* $Id: Word_substitution.cpp 452500 2014-11-20 16:51:44Z ivanov $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  .......
 *
 * File Description:
 *   .......
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using the following specifications:
 *   'macro.asn'.
 */

// standard includes
#include <ncbi_pch.hpp>

// generated includes
#include <objects/macro/Word_substitution.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

// constructor
CWord_substitution::CWord_substitution(string word, string synonym) : CWord_substitution_Base()
{
    SetWord(word);
    SetSynonyms().push_back(synonym);
}


// destructor
CWord_substitution::~CWord_substitution(void)
{
}


bool CWord_substitution::IsWordBoundary(char ch)
{
    if (ch == 0 || !isalpha(ch)) {
        return true;
    } else {
        return false;
    }
}


// this function looks for portions of the text that can be skipped because it
// begins with a word to ignore or one of its synonyms.
// note that more than one item could match, all should be tried
vector<size_t> CWord_substitution :: GetMatchLens(const string& text, const string& pattern, char prev_char) const
{
    vector<size_t> match_lens;
    size_t len;

    if (!IsSetWord()) {
        // doesn't make sense
    } else if (!NStr::StartsWith(pattern, GetWord(), GetCase_sensitive() ? NStr::eCase : NStr::eNocase)) {
        // no match
    } else if (IsSetSynonyms()) {
        ITERATE(CWord_substitution::TSynonyms, syn, GetSynonyms()) {
            len = (*syn).length();
            if (NStr::StartsWith(text, *syn, GetCase_sensitive() ? NStr::eCase : NStr::eNocase)
                && (!IsSetWhole_word()
                        || (IsWordBoundary(prev_char) && IsWordBoundary(text.c_str()[len])))) {
                // text matches synonym
                match_lens.push_back(len);            
            }
        }
    } else {
        // word is optional, but don't skip it if it's already in the text
        if (!NStr::StartsWith(text, GetWord(), GetCase_sensitive() ? NStr::eCase : NStr::eNocase)) {
            match_lens.push_back(0);
        }
    }
    return match_lens;
}


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE

/* Original file checksum: lines: 57, chars: 1744, CRC32: 9a0806fb */
