<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/collectors/xenstat.plugin/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/collectors/xenstat.plugin/metadata.yaml"
sidebar_label: "Xen/XCP-ng"
learn_status: "Published"
learn_rel_path: "Data Collection/Containers and VMs"
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# Xen/XCP-ng


<img src="https://netdata.cloud/img/xen.png" width="150"/>


Plugin: xenstat.plugin
Module: xenstat.plugin

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

This collector monitors XenServer and XCP-ng host and domains statistics.



This collector is supported on all platforms.

This collector supports collecting metrics from multiple instances of this integration, including remote instances.

The plugin needs setuid.

### Default Behavior

#### Auto-Detection

This plugin requires the `xen-dom0-libs-devel` and `yajl-devel` libraries to be installed.

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per Xen/XCP-ng instance

These metrics refer to the entire monitored application.

This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| xenstat.mem | free, used | MiB |
| xenstat.domains | domains | domains |
| xenstat.cpus | cpus | cpus |
| xenstat.cpu_freq | frequency | MHz |

### Per xendomain

Metrics related to Xen domains. Each domain provides its own set of the following metrics.

This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| xendomain.states | running, blocked, paused, shutdown, crashed, dying | boolean |
| xendomain.cpu | used | percentage |
| xendomain.mem | maximum, current | MiB |
| xendomain.vcpu | a dimension per vcpu | percentage |

### Per xendomain vbd

Metrics related to Xen domain Virtual Block Device. Each VBD provides its own set of the following metrics.

This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| xendomain.oo_req_vbd | requests | requests/s |
| xendomain.requests_vbd | read, write | requests/s |
| xendomain.sectors_vbd | read, write | sectors/s |

### Per xendomain network

Metrics related to Xen domain network interfaces. Each network interface provides its own set of the following metrics.

This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| xendomain.bytes_network | received, sent | kilobits/s |
| xendomain.packets_network | received, sent | packets/s |
| xendomain.errors_network | received, sent | errors/s |
| xendomain.drops_network | received, sent | drops/s |



## Alerts

There are no alerts configured by default for this integration.


## Setup

### Prerequisites

#### Libraries

1. Install `xen-dom0-libs-devel` and `yajl-devel` using the package manager of your system.

  Note: On Cent-OS systems you will need `centos-release-xen` repository and the required package for xen is `xen-devel`

2. Re-install Netdata from source. The installer will detect that the required libraries are now available and will also build xenstat.plugin.



### Configuration

#### File

The configuration file name for this integration is `netdata.conf`.
Configuration for this specific integration is located in the `[plugin:xenstat]` section within that file.

The file format is a modified INI syntax. The general structure is:

```ini
[section1]
    option1 = some value
    option2 = some other value

[section2]
    option3 = some third value
```
You can edit the configuration file using the `edit-config` script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/configure/nodes.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config netdata.conf
```
#### Options



<details><summary>Config options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| update every | Data collection frequency. | 1 | False |

</details>

#### Examples
There are no configuration examples.


