/*
	Сейчас на меленьком примере, рассмотрим создание небольшого скрипта.
Здесь будут применены не все команды, но их будет достаточно что бы
написать свой скрипт.

	Подрузамевается что читающий имеет знания ActonScript или более знакомого 
для всех JavaScript. Если вы не знакомы с этим языком, вы можете ознакомится с ним
в интернете. Язык обладает легким С подобным синтаксисом без строгой типизации и
довольно легок в изучении.

	Если здесь вы не найдете нужной вам функции, можете посмотреть в исходниках
программы. Все открытые слоты классов deviceImpl и myCanvas можно использовать в скриптах 
в соответсвующих для этого контекстах. Т.е. слоты myCanvas являются функциями самой сцены
с устройствами и их можно применять напрямую. Слоты deviceImpl применяются к конкретным 
устройствам. Например:

// Функция из класса myCanvas: 
myCanvas::emulateTime(); // Функция выполняется пока сеть нагружена работой и прекращается
// как только сеть начинает бездействовать.
в скрипте её можно писать просто:
emulateTime();

Напротив если мы создаем устройство:
var router = addRouter(5,5);
router.setIp("LAN10", "192.168.1.2"); // Функция вызывается именно у этого устройства

	В дальнейшем если сценарии будут развиваться, они будут делать это в сторону 
объектной парадигмы, а не процедурной.

	Итак рассмотрим создание небольшой сети и проверки её работоспособности.
Для начала проверим, а не открыта ли у нас другая сеть.
Свойство open сцены принимает булево значение и показывает открыта сцена или нет.
Если открыта мы её безмолвно закрываем( Ну что поделаешь это учебный скрипт и 
спрашивать сохранения нам сейчас не так важно.
*/
if ( open ) closeScene();
/*
Теперь откроем новый файл.
*/
newScene();
/*
Остановим симуляцию, теперь наша сцена стоит на паузе.
*/
stop();
/*
    Для начала создадим массив коммутаторов. Конечно здесь можно было создать
два отдельных коммутатора, но что бы показать возможности я создал именно
массив.
*/
var sw = new Array();
/*
    Функции сцены имеющие форму addX добавляют соответсвующий Х на сцену.
в данном случае это switch. Параметрами функция ожидает координаты
размещаемого устройства. Координаты соотевтствуют узлам сетки и начинаются с 0.
Первая идет абсцисса, второй ордината.

    Функция setSocketsCount(int) задает количество портов(интерфейсов) у устройства.
*/
sw[0] = addSwitch(3,3);
sw[0].setSocketsCount(8);
/*
  Далее добавляем еще один коммутатор. Сейчас еще мало понятно что значат эти координаты,
но стоит один раз попробывать, как уже свободно можно будет представлять как они расположены.
*/
sw[1] = addSwitch(7,3);
sw[1].setSocketsCount(8);
/*
  Добавляем мершрутизатор.
  Свойство router у маршрутизатора или компьютера указывает включена ли у них маршрутизация.
*/
var r = addRouter(5,3);
r.router = true;
r.setSocketsCount(8);
/*
  addConnection( устройство начала , устройство конца , порт начала , порт конца ) - создает
кабель соединяющий эти два устройства через указанные порты.
*/
addConnection(sw[0],r,"LAN8","LAN3");
addConnection(sw[1],r,"LAN8","LAN4");
/*
    Cейчас создадим новый массив, он будет содержать наши компьютеры.
x и g мы будем использовать как вспомогательные переменные.
*/
var net = new Array();
var x = 1 , g = 126;
/*
  Используем цикл for, мы будем создавать сеть состоящую из двух подсетей.
На каждой итерации цикла мы добавляем новый вектор(создаем многомерный массив)
Все наши компьютеры будут лежать в двухмерном массиве по 5 компьютеров в двух сетях.
*Возможно начинающему трудно будет понять этот ход, но это сначала.
*/
for ( j = 0 ; j < 2 ; j++ ) {
    net[j] = new Array();
/*
  Во вложенном цикле создадим 5 компьютеров. И соединим их с соответсвующим коммутатором.
При использовании строк мы можем пользоваться преимуществами ActionScript и использовать
конкатенацию строки с числом.
*/
    for ( i = 1 ; i <= 5 ; i++ ) {
        net[j][i-1] = addComputer(x,i);
        addConnection( net[j][i-1] , sw[j] , "eth0" , "LAN"+i );
/*
  Здесь мы приблизились к часто используемым функциям:
setIp( имя интерфейса, ip-адрес ) - задает Ip адрес интерфейса.
setMask( имя интерфейса, маска ) - задает маску интерфейса.
setGateway( шлюз ) - задаает шлюз.
Надо учесть что данные функции можно применять(пока) только в соответствующем контексте.
Если сейчас попробовать присвоить ip-адрес скажем коммутатру, это приведет к безмолвному
краху программы.

    На каждой итерации обоих циклов мы производим настройку наших компьютеров.
Хотя пример является довольно надуманным, все же он показывает как можно сократить
свою работу.
*/
	net[j][i-1].setIp("eth0","192.168.1."+( i + j*128) );
	net[j][i-1].setMask("eth0", "255.255.255.128");
	net[j][i-1].setGateway("192.168.1."+g);
    }
/*
  По пути производим настройку интерфейсов маршрутизатора.
*/
    r.setMask("LAN"+(j+3) , "255.255.255.128");
    r.setIp("LAN"+(j+3) , "192.168.1." + g );
/*
  И увеличиваем вспомогательные переменные.
*/
    x += 8;
    g += 128;
}
/*
    Отправка данных в скриптах выглядит конечно не так как в gui, но смысл
проиходящего понять можно. Функция sendMessage вызывается в контексте устройства,
которое посылает данные(!ВНИМАНИЕ попытка отправить данные с коммутатора или
того хуже концентратора может привести к непредсказуемым последмтвиям, позже будет
более сильный механизм сдерживания) первым параметром указывается адрес интерфейса
получателя(если когда нибудь будет dns) тут можно будет писать адрес узла.
Далее мы указываем наш пока очень условный размер в килобайтах. И протокол отправки,
но пока он только UDP(цифра 0 в параметре).
*/
net[0][0].sendMessage("192.168.1.133",50,0);
/*
    Функция уже упоминалась во вступлении. Как и было рассказанно ранее, она выполняется
пока сеть проявляет хоть какую то активность, даже если у одного из устройств не пуста
очередь на отправку пакетов, она будет выполняться(!ОСТОРОЖНО да при неудачной модификации
программы может уйти в бесконечный цикл, но зато хорошая проверка корректности).
*/
emulateTime();
/*
  Снимем сцену с паузы.
*/
play();
/*
  Проверяем результат сравнивая количество переданных пакетов от первого компьютера,
первой сети(Напоминаю что отсчет массивов в С подобных языках всегда ведется с 0)
и количество полученных пакетов у последнего компьютера второй сети. Результат сохраним
в переменной result. Именно её ниже мы вернем из скрипта.
Примечание: именно этому компьютеру мы посылали данные, точнее на адрес его интерфейса.
*/
result = ( net[0][0].sendPacketCount("eth0") == net[1][4].receivePacketCount("eth0") );
/*
  Добавляем текстовый комментарий на сцену. Параметры которых ждет конструктор комментария,
также его координаты, note свойство текстовой записки это текст который она отображает.
(возможность подвинуть объекты появится чуть-чуть позже)
*/
var text = addNote(4,6);
text.note = "Our first easy script!";
/*
    Сохраним созданную нами сцену в файл. Также доступна функция openScene которая
пытается загрузить сеть из файла, имя которого было переданно ей в качестве аргумента.
*/
saveScene("test/arp.net");
/*
  Последняя строчка скрипта станет его возвращаемым значением. Это значение возвращается
в программу и приводится к типу bool, это значение указывает верно ли выполнился наш скрипт
и в основном используется для проверки возможностей программы.
*/
result;
/*
    В заключении хотелось бы отметить, что в скриптах не хватает еще множества полезных функций.
Они могут быть добавлены если вы сообщите автору о том что их не хватает.
Спасибо за внимание.
*/
